import { defineConfig, loadEnv } from "vite";
import vue from "@vitejs/plugin-vue";
import styleImport from "vite-plugin-style-import";

//配置别名
const path = require("path");
function resolve(dir) {
  return path.join(__dirname, dir);
}

export default ({ mode }) => {
  const env = loadEnv(mode, process.cwd());
  console.log(env);
  return defineConfig({
    plugins: [vue()],
    server: {
      host: "0.0.0.0",
      port: 3000,
    },
    // 注释
    publicDir: "/public",
    base: env.VITE_BASE_URI,
    resolve: {
      alias: [
        {
          find: "@",
          replacement: resolve("./src"),
        },
        {
          find: "#",
          replacement: resolve("./public"),
        },
      ],
    },
    build: {
      chunkSizeWarningLimit: 1500,
    },
  });
};
