// HTTP请求

import axios from "axios";
import { Dialog, Toast } from "vant";

let msg: any = [];

// 统一处理返回的数据
axios.interceptors.response.use(
  (response) => {
    console.log(response);

    const data = response.data;
    if (data.code === 200) {
      return data.data;
    }
    Toast.clear();
    if(data.description=="自定义错误"){
      try{
		  // console.log(data.data[0].errmsg,'123')
          Dialog({ title: "提示", message: data.data[0].errmsg });
      }catch(e){
		  
		  if(data.data.errmsg != "没有找到建档信息" && data.data.errmsg.indexOf('您不是符合该活动经销商的客户') == -1 && data.data.errmsg.indexOf('您不是符合该活动的客户') == -1 && data.data.errmsg.indexOf('没有加入录单人员名单') == -1){
			  if(data.data.errmsg.indexOf('验证码无效') != -1){
				  Dialog({
				  	allowHtml: true,
				  	theme: "round-button",
				  	confirmButtonColor: "var(--van-button-primary-background-color)",
				  	messageAlign: "left",
				  	message: `<div style='font-size:1.2em;font-weight:bold;text-align:center'>验证失败</div><div style='font-size:1.1em;text-align:center;margin-top: 14px;'>验证码无效，请重新获取！</div>`
				  }).then(() => {
				  	// on confirm
				  	console.log('12345')
				  }).catch(() => {
				  	console.log('789')
				  		// on cancel
				  });
			  }else if(data.data.errmsg.indexOf('活动尚未开始') != -1){
				  Dialog({
				  	allowHtml: true,
				  	theme: "round-button",
				  	confirmButtonColor: "var(--van-button-primary-background-color)",
				  	messageAlign: "left",
				  	message: `<div style='font-size:1.2em;font-weight:bold;text-align:center'>温馨提示</div><div style='font-size:1.1em;text-align:center;margin-top: 14px;'>活动尚未开始，不能签到，敬请期待！</div>`
				  }).then(() => {
				  	// on confirm
				  	console.log('12345')
				  }).catch(() => {
				  	console.log('789')
				  		// on cancel
				  });
			  }else{
				  
				  Dialog({ title: "提示", message: data.data.errmsg });
			  }
		  }
		  // console.log(data.data.errmsg,'123')
      }
      
      return Promise.reject(data);
    }else{
      Dialog({ title: "提示", message: data.description });
      
    }
    return Promise.reject(data);
    
  },
  (error) => {
    Toast.clear();
    Dialog({ title: "提示", message: "网络出了点小差，请刷新页面。" });
    return Promise.reject(error);
  }
);

declare module "axios" {
  interface AxiosInstance {
    (config: AxiosRequestConfig): Promise<any>;
  }
}

export default {
  post(url: string, params: any = {}) {
    const hfcapp_jwt: any = localStorage.getItem("dsopm_wechat_jwt");
    const headers: any = {
      Accept: "application/json",
      "Content-Type": "application/json;charset=utf-8",
    };
    // if (hfcapp_jwt && hfcapp_jwt.length) {
    //     headers.Authorization = 'Bearer ' + hfcapp_jwt
    // }
    const config = {
      headers: headers,
      method: "POST",
      url: url,
      data: params,
    };
    return axios(config);
  },

  picPost(url: string, params: any = {}) {
    const headers: any = {
      "Content-Type": "multipart/form-data;application/x-www-form-urlencoded",
    };
    // if (hfcapp_jwt && hfcapp_jwt.length) {
    //     headers.Authorization = 'Bearer ' + hfcapp_jwt
    // }
    const config = {
      headers: headers,
      method: "POST",
      url: url,
      data: params,
    };
    return axios(config);
  },
};
