import {Base64} from "js-base64";

function parsePayload(jwtStr: string): any {
  if (jwtStr == null || jwtStr.length == 0) {
    return null;
  }
  const strArray = jwtStr.split(".");
  if (strArray.length != 3) {
    return null;
  }
  // console.log(jwtStr,'strArray')
  let payloadStr = strArray[1];
  payloadStr = payloadStr.replace("-", "+");
  // console.log(payloadStr,'payloadStr1')
  payloadStr = Base64.decode(payloadStr);
  // console.log(payloadStr,'payloadStr')
  const payloadObject: any = JSON.parse(payloadStr);
  return payloadObject;
}

export default {parsePayload};
