import axios from "axios";
import {AxiosRequestConfig} from "axios";
import wx from "weixin-js-sdk-ts";
import {Dialog} from "vant";

const CHECK_AUTHENTICATION: Boolean = <string>import.meta.env.VITE_CHECK_AUTHENTICATION == "true";
//const TEST_JWTSTR='eyJhbGciOiJIUzI1NiJ9.eyJ1c2VyX2luZm8iOnsicGVyc29uSWQiOm51bGwsIndvcmtOdW1iZXIiOiIxMTEyNjc2NiIsInRlbGVwaG9uZSI6bnVsbCwiZW1haWxBZGRyZXNzIjpudWxsfSwiZXhwIjoxNjU3NDE5MjgxLCJpYXQiOjE2NTczMzI4ODF9.c46yLFqDzc0nhMbeDpelwMZ1gikiG84w_UQ-oYIp2Ts';
//默认配置
const DEFAULT_POST_HEADERS = {
  "Content-Type": "application/json;charset=utf-8",
  Accept: "application/json",
  Authorization: ""
};
const DEFAULT_TIMEOUT: number = 10000;
const DEFAULT_BASE_URL: string = <string>import.meta.env.VITE_Dealer_Activity_Api_Url;
const DEFAULT_BASE_URL_WECHAT: string = <string>import.meta.env.VITE_Dealer_Activity_Api_Url; //<string>import.meta.env.VITE_API_SERVER_URL;
const OFFICIAL_ACCOUNT_ID: string = <string>import.meta.env.VITE_OFFICIAL_ACCOUNT_ID;
//服务接口uri
//export const V1_WECHAT_GET_APPID_BY_OA_ID = "/v1/wechat/get_appid_by_oa_id";
//export const V1_AUTH_LOGIN: string = "/v1/auth/login2";
//export const V1_WECHAT_GET_OA_JSSDK_CONFIG = "/v1/wechat/get_oa_jssdk_config";
export const V1_WECHAT_GET_APPID_BY_OA_ID = "/wechat/get_appid_by_oa_id";
export const V1_AUTH_LOGIN: string = "/auth/login2";
export const V1_WECHAT_GET_OA_JSSDK_CONFIG = "/wechat/get_oa_jssdk_config";

//服务接口uri for Wxwork
export const WXWORK_GET_CONFIG: string = "/wxwork/get_config";
export const WXWORK_GET_JS_SDK_CONFIG: string = "/wxwork/get_js_sdk_config";
export const AUTH_LOGIN: string = "/wxwork/login";

const JWT_LOCAL_STORAGE_KEY: string = "dsopm_wechat_jwt";

//url = window.location.origin + window.location.pathname
//["scanQRCode","image"] 
function wx_config(url:string,functions:any){
    //配置微信js-sdk
    postWechat(V1_WECHAT_GET_OA_JSSDK_CONFIG, {oaId:OFFICIAL_ACCOUNT_ID,url: url})
        .then((res:any) => {
            console.log('GET_JS_SDK_CONFIG,res:',res);
            const jsonResult = res;
            //console.log('GET_JS_SDK_CONFIG,res.appId:',res.appId);
            //console.log('GET_JS_SDK_CONFIG,jsonResult--data:',res.data);
            //console.log('GET_JS_SDK_CONFIG,jsonResult--:',jsonResult.config);
            
            if (res) {
				//console.log("before:wx.config");
                wx.config({
                    debug: false, // 开启调试模式
                    appId: jsonResult.appId, // 必填，企业微信的corpID
                    timestamp: jsonResult.timestamp, // 必填，生成签名的时间戳
                    nonceStr: jsonResult.nonceStr, // 必填，生成签名的随机串
                    signature: jsonResult.signature, // 必填，签名，见 附录-JS-SDK使用权限签名算法
                    jsApiList: ["getLocation"],  // 必填，需要使用的JS接口列表，凡是要调用的接口都需要传进来
                    openTagList: ["wx-open-launch-weapp", "wx-open-launch-app"]
                });
				//console.log("over:wx.config");
                wx.ready(function () {
                    console.log("微信JS-SDK配置成功");
                });
				wx.error(function (res) {
                    //alert("微信JS-SDK配置失败");
					Dialog({message: "微信JS-SDK配置失败"});
					console.log('wx.error.res',res);
				});
				console.log("over:wx.error");
            } else {
                console.log("GET_JS_SDK_CONFIG: res ==null");
                Dialog({message: 'GET_OA_JSSDK_CONFIG：null'});
            }
        })
        .catch((error) => {
            console.log(error);
            Dialog({message: "网络出了点小差，请刷新页面。"});
        });
}

function post(uri: string, data: object = {}) {
  //console.log('HttpUtilFd.post,uri:',uri);
  let jwtStr: string | null = <string | null>localStorage.getItem(JWT_LOCAL_STORAGE_KEY);
  //if (jwtStr==null){
  //    if (import.meta.env.MODE=="development" && (!CHECK_AUTHENTICATION))
  //    jwtStr=TEST_JWTSTR;
  //};
  if (jwtStr != null && jwtStr.length != 0) {
    DEFAULT_POST_HEADERS.Authorization = "Bearer " + jwtStr;
  }
  const config: AxiosRequestConfig = {
    url: DEFAULT_BASE_URL + uri,
    headers: DEFAULT_POST_HEADERS,
    timeout: DEFAULT_TIMEOUT,
    data: data,
    method: "POST"
  };
  console.log('HttpUtilFd.post,config.url:',config.url);
  return axios.request(config);
}

const DEFAULT_POSTFORMDATA_HEADERS = {
  "Content-Type": "multipart/form-data",
  Accept: "application/json",
  Authorization: ""
};
function postFormData(uri: string, data: FormData) {
  const jwtStr: string | null = <string | null>localStorage.getItem(JWT_LOCAL_STORAGE_KEY);
  //if (jwtStr==null){
  //    if (import.meta.env.MODE=="development" && (!CHECK_AUTHENTICATION))
  //    jwtStr=TEST_JWTSTR;
  //};
  if (jwtStr != null && jwtStr.length != 0) {
    DEFAULT_POSTFORMDATA_HEADERS.Authorization = "Bearer " + jwtStr;
  }
  const config: AxiosRequestConfig = {
    url: DEFAULT_BASE_URL + uri,
    headers: DEFAULT_POSTFORMDATA_HEADERS,
    timeout: DEFAULT_TIMEOUT,
    data: data,
    method: "POST"
  };
  //console.log('post->config.url:',config.url);
  return axios.request(config);
}

function postWechat(uri: string, data: object = {}) {
  //console.log('HttpUtilFd.post,uri:',uri);
  let jwtStr: string | null = <string | null>localStorage.getItem(JWT_LOCAL_STORAGE_KEY);
  //if (jwtStr==null){
  //    if (import.meta.env.MODE=="development" && (!CHECK_AUTHENTICATION))
  //    jwtStr=TEST_JWTSTR;
  //};
  if (jwtStr != null && jwtStr.length != 0) {
    DEFAULT_POST_HEADERS.Authorization = "Bearer " + jwtStr;
  }
  const config: AxiosRequestConfig = {
    url: DEFAULT_BASE_URL_WECHAT + uri,
    headers: DEFAULT_POST_HEADERS,
    timeout: DEFAULT_TIMEOUT,
    data: data,
    method: "POST"
  };
  console.log('HttpUtilFd.postWechat,config.url:',config.url);
  return axios.request(config);
}



export default {post,postFormData,postWechat,wx_config};
