const DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";

function getYear(date: Date): string {
  return date.getFullYear().toString();
}

function getMonth(date: Date): string {
  const month = date.getMonth() + 1;
  if (month < 10) {
    return "0" + month.toString();
  } else {
    return month.toString();
  }
}

function getDay(date: Date): string {
  const day = date.getDate();
  if (day < 10) {
    return "0" + day.toString();
  } else {
    return day.toString();
  }
}

function getHour(date: Date): string {
  const hour = date.getHours();
  if (hour < 10) {
    return "0" + hour.toString();
  } else {
    return hour.toString();
  }
}

function getMinute(date: Date): string {
  const minute = date.getMinutes();
  if (minute < 10) {
    return "0" + minute.toString();
  } else {
    return minute.toString();
  }
}

function getSecond(date: Date): string {
  const second = date.getSeconds();
  if (second < 10) {
    return "0" + second.toString();
  } else {
    return second.toString();
  }
}

function getMilliSecond(date: Date): string {
  return date.getMilliseconds().toString();
}

const SIGN_MAP = new Map([
  [/yyyy/g, getYear],
  [/MM/g, getMonth],
  [/dd/g, getDay],
  [/HH/g, getHour],
  [/mm/g, getMinute],
  [/ss/g, getSecond],
  [/SSS/g, getMilliSecond]
]);

function format(date: Date, pattern: string = DEFAULT_PATTERN): string {
  let patterTemp = new String(pattern);
  for (let [key, value] of SIGN_MAP) {
    if (patterTemp.match(key)) {
      patterTemp = patterTemp.replace(key, value(date));
    }
  }
  return patterTemp.valueOf();
}

function parse(dateStr: string, pattern: string = DEFAULT_PATTERN): Date {
  console.log(dateStr);
  console.log(pattern);
  return new Date();
}

export default {format, parse};
