// 路由入口

import { createRouter, createWebHashHistory, useRoute } from 'vue-router'

import common from './common/index'
import dealer from './dealer/index'

import httputil from "@/util/HttpUtilFd";
import * as api from "@/util/HttpUtilFd";
import { Dialog } from "vant";
import jwtUtil from "@/util/JwtUtil";

import CommonPageNotFound from "@/views/common/PageNotFound.vue";
import CommonForbidUserAgent from "@/views/common/ForbidUserAgent.vue";
import { ref } from 'vue';

const CHECK_AUTHENTICATION : Boolean = <string>import.meta.env.VITE_CHECK_AUTHENTICATION == "true";
const OFFICIAL_ACCOUNT_ID : string = <string>import.meta.env.VITE_OFFICIAL_ACCOUNT_ID;
const JWT_LOCAL_STORAGE_KEY : string = "dsopm_wechat_jwt";

// 集合所有需要使用的路由
const routes = [
	...dealer,
	...common,
	{
		path: "/common/page_not_found",
		component: CommonPageNotFound,
		meta: {
			keepAlive: false //设置页面是否需要使用缓存
		}
	},
	{
		path: "/common/forbid_user_agent",
		component: CommonForbidUserAgent,
		meta: {
			keepAlive: false //设置页面是否需要使用缓存
		}
	},

]

// 创建路由
const router = createRouter({
	history: createWebHashHistory(),
	routes
})

let skip_login : boolean = false; //视同登录
console.log(CHECK_AUTHENTICATION, 'CHECK_AUTHENTICATION')
// 监听路由-改变前
router.beforeEach((to, from, next) => {
	if(to.meta.title == '徐记订货会1'){
		document.title = to.query.dealerName as string
	}else{
		document.title = to.meta.title as string
	}
	console.log(to, 'to.meta.title')
	console.log(from, 'from')
	
	//console.log('router.beforeEach,to.matched:'+to.matched);
	if (to.matched.length == 0) {
		next({ path: "/common/page_not_found" });
	} else if (CHECK_AUTHENTICATION) {
		//首先要看是否在微信内打开
		const isCorrectClient : boolean = isWechatClient();
		if (isCorrectClient) {
			//验证登陆
			console.log(to.meta)
			const verifyAuth : boolean = <boolean>to.meta.verifyAuth;
			if (verifyAuth) {
				//需要验证权限
				console.log('router.beforeEach,before checkLogin:');
				const alreadyLogin : boolean = checkLogin();
				if (alreadyLogin) {
					console.log('checkLogin,alreadyLogin;');
					next();
				} else {
					//检查是否从微信公众号授权过来的
					console.log('checkLogin,has /code/?;');
					const url = window.location.href;
					console.log('router.beforeEach,window.location.href:' + url);
					if (url.search(/code=/g) != -1 && url.search(/state=/g) != -1) {
						login(url);
					} else {
						goToOauth2(to);
					}
				}
			} else {
				//不需要验证权限
				next();
			}
		} else {
			alert("请在微信中打开(●'◡'●)！");
		}
	} else {
		next();
	}
});

function isWxWorkClient() : boolean {
	const userAgent = window.navigator.userAgent.toLowerCase();
	if (userAgent.search(/wxwork/g) == -1) {
		return false;
	} else {
		return true;
	}
}

function isWechatClient() : boolean {
	const userAgent = window.navigator.userAgent.toLowerCase();
	if (userAgent.search(/micromessenger/g) != -1 && userAgent.search(/wxwork/g) == -1) {
		return true;
	} else {
		return false;
	}
}

function checkLogin() : boolean {
	const jwt : string | null = localStorage.getItem(JWT_LOCAL_STORAGE_KEY);
	if (jwt == null) {
		//没有登陆
		console.log('checkLogin,return false;');
		return skip_login;
	} else {
		const payload = jwtUtil.parsePayload(jwt);
		console.log('checkLogin,payload:' + JSON.stringify(payload));
		const exp : number = payload.exp;
		if (new Date().getTime() / 1000 >= exp) {
			//登陆已过时
			return false;
		} else {
			return true;
		}
	}
}

function goToOauth2(to : any) : void {
	// alert('goToOauth2,before post(api.WXWORK_GET_CONFIG):');
	httputil
		//.post(api.WXWORK_GET_CONFIG) 原接企业微信,下面改接微信公众号
		.postWechat(api.V1_WECHAT_GET_APPID_BY_OA_ID, { officialAccountInfoId: OFFICIAL_ACCOUNT_ID })
		.then((res) => {
			const resData = res.data;
			//alert('V1_WECHAT_GET_APPID_BY_OA_ID,resData:'+JSON.stringify(resData));
			console.log('goToOauth2,resData:', resData);
			if (resData.code == 200) {
				const appId : string = <string>resData.data;
				const oauth2Url : string = "https://open.weixin.qq.com/connect/oauth2/authorize";
				const oauth2Param : string =
					"?appid=" + appId + "&redirect_uri=" + encodeURIComponent(window.location.href) + "&response_type=code&scope=snsapi_userinfo&state=#wechat_redirect";
				const tarURL = oauth2Url + oauth2Param;
				window.location.href = tarURL;
				console.log('goToOauth2,URL:', tarURL);
			} else {
				console.log(resData.data);
				Dialog({ message: "网络出了点小差" });
			}
		})
		.catch((error) => {
			console.log(error);
			Dialog({ message: "网络出了点小差" });
		});
}

function login(url : string) : void {
	//提取code
	const code = url.split("code=")[1].split("&state=")[0];
	//调用后端服务器登陆接口,改为方式3
	httputil
		//.postWechat(api.V1_AUTH_LOGIN, {loginType: 2, oaOauth2Code: code, oaInfoId: OFFICIAL_ACCOUNT_ID})
		.postWechat(api.V1_AUTH_LOGIN, { loginType: 3, oaOauth2Code: code, oaInfoId: OFFICIAL_ACCOUNT_ID })
		.then((res) => {
			const data = res.data;
			if (data.code == 200) {
				//添加token到localstorage
				/* old(数据放在data.data,后改为放在data.data.{}):
				const jwtStr = data.data;
				localStorage.removeItem(JWT_LOCAL_STORAGE_KEY);
				localStorage.setItem(JWT_LOCAL_STORAGE_KEY, jwtStr);
				window.location.href = window.location.origin + window.location.pathname + window.location.hash;
				console.log('window.location.href:');
				console.log(window.location.href);
				*/
				//new:
				let data2 = data.data;
				if (data2.errcode == 0) {
					console.log('login,nickname:' + data2.nickname);
					const jwtStr = data2.jwtStr;
					localStorage.removeItem(JWT_LOCAL_STORAGE_KEY);
					localStorage.setItem(JWT_LOCAL_STORAGE_KEY, jwtStr);
					window.location.href = window.location.origin + window.location.pathname + window.location.hash;
					console.log('data2.errcode==0,window.location.href:');
					console.log(window.location.href);
				} else {
					Dialog({ message: "登陆失败:" + data2.errmsg });
				};

			} else if (data.code == 801) {
				//未绑定
				/*
				Dialog({message: "未绑定:" + data.data});
				skip_login = true;
				alert(window.location.href);
				let s_href = window.location.origin + window.location.pathname + window.location.hash;
				alert(s_href);
				*/
				//绑定到后台：
				console.log('绑定到后台:' + data.data?.openid);
				reg_band(data.data?.openid);
				/*
				window.location.href =
				  window.location.origin +
				  window.location.pathname +
				  "#/common/mobile_bind?orginUri=" +
				  window.location.hash.replace("#", "") +
				  "&oaOpenId=" +
				  data.data;
				*/
			} else {
				Dialog({ message: "登陆失败:" + data.description });
			}
		})
		.catch((error) => {
			console.log(error);
			Dialog({ message: "网络出了点小差" });
		});
}

function reg_band(openId : string) : void {
	console.log("reg_band-openId:" + openId);
	//alert("reg_band-openId:" + openId);
	//调用后端服务器登陆接口
	let param = {
		oaInfoId: OFFICIAL_ACCOUNT_ID,
		openId: openId
	};
	httputil
		.post("/reg_band", param)
		.then((res) => {
			const data = res.data;
			if (data.code == 200) {
				//添加token到localstorage
				const jwtStr = data.data;
				console.log('jwtStr:' + jwtStr);
				localStorage.removeItem(JWT_LOCAL_STORAGE_KEY);
				localStorage.setItem(JWT_LOCAL_STORAGE_KEY, jwtStr);
				window.location.href = window.location.origin + window.location.pathname + window.location.hash;
				console.log('window.location.href:');
				console.log(window.location.href);
			} else {
				Dialog({ message: "绑定失败:" + data.data });
			}
		})
		.catch((error) => {
			console.log(error);
			Dialog({ message: "网络出了点小差" });
		});
}

export default router