import { createApp } from "vue";
const app = createApp(App)

import App from "./App.vue";

// 开发环境开启调试
import VConsole from "vconsole";
//if (import.meta.env.MODE === "development") new VConsole();
let vConsole = null;
const USE_VCONSOLE: boolean = <string>import.meta.env.VITE_USE_VCONSOLE == "true" ? true : false;
if (USE_VCONSOLE) {
  vConsole = new VConsole();
}
// 引入路由
import router from "./router/index";
app.use(router)

// 引入vant
import vant from "vant";
import "vant/lib/index.css";
app.use(vant);

// 引入样式
import "./assets/style/dealer.scss";

app.mount("#app");
