// 经销商人员api

import http from "../../util/http";

const url = import.meta.env.VITE_Dealer_User_Api_Url;

export default {
  /**
   * 获取经销商人员列表
   * @param   params
   * {
   *  pageNum         页码
   *  pageSize        返回条数
   *  personType      所属角色
   *  personStatus    人员状态
   *  keyword         关键字，搜索时使用
   * }
   */
  getDealerUserLists(params: any) {
    const json: object = {
      pageNum: params.pageNum || 1,
      pageSize: params.pageSize || 1000,
      personType: params.personType || 0,
      personStatus: params.personStatus || 0,
      keyword: params.keyword || "",
    };
    return http.post(url + "/v1/mcp/get_person_list", json);
  },

  /**
   * 获取经销商详情
   * personId     人员id
   */
  getDealerUserDetail(personId: string) {
    const json: object = {
      personId: personId,
      personType: 0,
    };
    return http.post(url + "/v1/mcp/get_person_by_id", json);
  },

  /**
   * 获取经销商列表
   * {
   *  pageNum             页码
   *  pageSize            返回条数
   *  distributorStatus   经销商状态
   * }
   */
  getDealerLists(params: any = {}) {
    const json: object = {
      pageNum: params.pageNum || 1,
      pageSize: params.pageSize || 1000,
      distributorStatus: params.distributorStatus || 0,
    };
    return http.post(url + "/v1/mcp/get_distributor_list", json);
  },

  /**
   * 添加经销商人员
   * @param   params
   * {
   *  personType      所属角色
   *  name            人员姓名
   *  phone           手机号码
   *  distributorId   所属经销商
   * }
   */
  addDealerUser(params: any) {
    const json: object = {
      personType: params.personTypeId || 0,
      name: params.personName || "",
      phone: params.mobile || "",
      distributorId: params.distributorId || 0,
    };
    return http.post(url + "/v1/mcp/add_person", json);
  },

  /**
   * 修改经销商人员列表
   * @param   params
   * {
   *  personId        人员id
   *  personType      所属角色
   *  name            人员姓名
   *  phone           手机号码
   *  distributorId   所属经销商
   * }
   */
  editDealerUser(params: any) {
    const json: object = {
      personId: params.personId || "",
      personType: params.personTypeId || 0,
      name: params.personName || "",
      phone: params.mobile || "",
      distributorId: params.distributorId || 0,
    };
    return http.post(url + "/v1/mcp/update_person_by_id", params);
  },

  /**
   * 修改经销商人员状态
   * @param   params
   * {
   *  personId        人员id
   *  personType      所属角色
   *  personStatus    人员状态
   * }
   */
  editDealerUserStatus(params: any) {
    const json: object = {
      personId: params.personId || "",
      personType: params.personType || 0,
      personStatus: params.personStatus || 0,
    };
    return http.post(url + "/v1/mcp/update_person_status", json);
  },
};
