// 经销商活动api

import http from "../../util/http";

const url = import.meta.env.VITE_Dealer_Activity_Api_Url;
const psncode = localStorage.getItem("psncode");
export default {
  // ------------------------- 3.3.1.显示订货会活动 -------------------------
  /**
   * 3.3.1-1 读取订货会活动列表/读取当天活动清单
   * @param   params
   * {
   *  ACTIVITYID      活动号，单值
   *  ACTIVITYNAME    主题，模糊
   *  DATEAT          活动日期,YYYYMMDD。单值
   *  DATEAT_begin    活动日期起,YYYYMMDD。范围起值,>=
   *  DATEAT_end      活动日期止,YYYYMMDD。范围末值,<=
   *  DSCODE          经销商代码，单值
   *  DSNAME          经销商名称，模糊
   *  ZT              状态，单值
   *  psncode         业管工号。取 JWT 中的 workNumber 作为 psncode 参数
   * }
   */
  getlst_amtb(params: any = {}) {
    const json: object = {
      ACTIVITYID: params.ACTIVITYID || "",
      ACTIVITYNAME: params.ACTIVITYNAME || "",
      DATEAT: params.DATEAT || "",
      DATEAT_begin: params.DATEAT_begin || "",
      DATEAT_end: params.DATEAT_end || "",
      DSCODE: params.DSCODE || "",
      ZT: params.ZT || "",
      psncode,
    };
    return http.post(url + "/getlst_amtb", json);
  },

  /**
   * 3.3.1-2 按订货会活动状态统计报表
   * psncode  业管工号。取 JWT 中的 workNumber 作为 psncode 参数
   */
  getstat_amtb() {
    return http.post(url + "/getstat_amtb");
  },

  /**
   * 【3.3.1-3 / 3.3.2-4】 设置活动状态为完成/作废/结束
   *
   * {
   *  activityId  活动号
   *  ZT          状态，F:完成，X:作废，Y:结束
   * }
   */
  set_zt(parpms: { activityId: string; ZT: string }) {
    return http.post(url + "/set_zt", parpms);
  },

  // ------------------------- 3.3.2.创建修改订货会活动 -------------------------
  /**
   * 3.3.2-1 读取经销商列表
   * @param   params
   * {
   *  DSCODE      经销商编号，单值
   *  DSNAME      经销商名称，模糊
   *  DAQUTXT     大区名称。模糊
   *  BRAN3TXT    业绩公司名称。模糊
   *  psncode     业管工号。单值。若[v]本人负责的打勾则传
   * }
   */
  getlst_dsma(params: any) {
    const json = {
      keyword: params.keyword || "",
      psncode,
    };
    return http.post(url + "/getlst_dsma", json);
  },

  /**
   * 3.3.2-2 创建订货会记录
   * @param   params
   * {
   *  ACTIVITYID      活动号，业务 Key,后端生成。新增时不填，修改时要有
   *  ACTIVITYNAME    活动名称(移动端:主题)
   *  BIGTITLE        大屏标题
   *  DATEAT          活动日期，YYYYMMDD
   *  DEPTCODE        主办部门编号，X5 录入时才用
   *  DEPTNAME        主办部门名称，X5 录入时才用
   *  DSCODE          经销商编号 <- 客户主数据视图
   *  DSNAME          经销商名称 <- 客户主数据视图
   *  DSPHONE         经销商手机，创建时后台绑定
   *  HUICHANG        会场地址
   *  NOTETXT         备注，大会场所等
   *  STARTTIME       开始时间,"yyyy-MM-dd HH:mm:ss.SSS"，前端填字 符串
   *  STOPTIME        结束时间,"yyyy-MM-dd HH:mm:ss.SSS"，前端填字 符串
   *  ZT              状态: A:草稿,B:发布,F:完成,J:结案,X:作废,Y:结束(异常)
   *  fCreateCode     创建者工号，传入 jwt.workNumber,(兼容 PC 测试)
   * }
   */
  add_amtb(params: {}) {
    const reqJson = {
      ...params,
      fCreateCode: psncode,
    };
    return http.post(url + "/add_amtb", reqJson);
  },

  /**
   * 3.3.2-3 修改订货会记录
   * @param   params
   * {
   *  ACTIVITYID      活动号，业务 Key,后端生成。新增时不填，修改时要有
   *  ACTIVITYNAME    活动名称(移动端:主题)
   *  BIGTITLE        大屏标题
   *  DATEAT          活动日期，YYYYMMDD
   *  DEPTCODE        主办部门编号，X5 录入时才用
   *  DEPTNAME        主办部门名称，X5 录入时才用
   *  DSCODE          经销商编号 <- 客户主数据视图
   *  DSNAME          经销商名称 <- 客户主数据视图
   *  DSPHONE         经销商手机，创建时后台绑定
   *  HUICHANG        会场地址
   *  NOTETXT         备注，大会场所等
   *  STARTTIME       开始时间,"yyyy-MM-dd HH:mm:ss.SSS"，前端填字 符串
   *  STOPTIME        结束时间,"yyyy-MM-dd HH:mm:ss.SSS"，前端填字 符串
   *  ZT              状态: A:草稿,B:发布,F:完成,J:结案,X:作废,Y:结束(异常)
   *  fCreateCode     创建者工号，传入 jwt.workNumber,(兼容 PC 测试)
   * }
   */
  edt_amtb(params: {}) {
    return http.post(url + "/edt_amtb", { ...params, fCreateCode: psncode });
  },

  /**
   * 3.3.2-5 获取签到二维码 URL 和标准大屏 URL
   * activityId   活动号
   */
  get_signurl() {
    return http.post(url + "/get_signurl");
  },
  get_signurlsss(params: any) {
    return http.post(url + "/get_signurl", params);
  },

  // ------------------------- 3.3.3 补充订货会资料(结案) -------------------------
  /**
   * 3.3.3-1 上传照片
   * @param   params
   * {
   *  file            内容:图片文件
   *  activityId      活动号
   *  notetxt         图片内容备注
   *  fCreateCode     创建者工号，由 jwt 的 workNumber 传入(兼容 PC 测试)
   * }
   */
  upload_picture(params: {}) {
    return http.picPost(url + "/upload_picture", {
      ...params,
      fCreateCode: psncode,
    });
  },

  /**
   * 3.3.3-2 获取照片列表
   * activityId   活动号
   */
  getlst_pictures() {
    return http.post(url + "/getlst_pictures");
  },

  /**
   * 3.3.3-3 获取照片图像数据流
   * @param   params
   * {
   *  activityId  活动号
   *  pictureId   图片 ID
   * }
   */
  get_picturestream() {
    // get
  },

  /**
   * 3.3.3-4 删除照片
   * @param   params
   * {
   *  activityId  活动号
   *  pictureId   图片 ID
   * }
   */
  delete_picture() {
    http.post(url + "/delete_picture");
  },

  /**
   * 3.3.3-5 上传发票
   * @param   params
   * {
   *  file            内容:发票图片文件
   *  activityId      活动号
   *  money           发票金额
   *  notetxt         发票内容备注
   *  fCreateCode     创建者工号，由 jwt 的 workNumber 传入(兼容 PC 测试)
   * }
   */
  upload_invoice() {
    http.post(url + "/upload_invoice");
  },

  /**
   * 3.3.3-6 获取发票列表
   * activityId   活动号
   */
  getlst_invoices() {
    return http.post(url + "/getlst_invoices");
  },

  /**
   * 3.3.3-7 获取发票图像数据流
   * @param   params
   * {
   *  activityId  活动号
   *  pictureId   图片 ID
   * }
   */
  get_invoicestream() {
    // get
  },

  /**
   * 3.3.3-8 删除发票
   * @param   params
   * {
   *  activityId  活动号
   *  pictureId   图片 ID
   * }
   */
  delete_invoice() {
    return http.post(url + "/delete_invoice");
  },

  /**
   * 3.3.3-9 活动结案提交
   * @param   params
   * {
   *  ACTIVITYID          活动号
   *  SUMBUYERS           到会店数
   *  SUMMANS             到会人数
   *  SUMODSCNT           订货家数
   *  SUMORDMNY           订货金额
   *  sLastWriterCode     操作者工号，由 jwt 的 workNumber 传入(兼容 PC 测试)
   * }
   */
  upd_settle(parpms: {}) {
    return http.post(url + "/upd_settle", {
      ...parpms,
      sLastWriterCode: psncode,
    });
  },

  // ------------------------- 3.4.2.签到功能 -------------------------
  /**
   * 3.4.2-1 活动签到提交
   * @param   params
   * {
   *  ACTIVITYID  活动号
   *  KINDROLE    人员类型:徐记、经销商、终端商户
   *  MOBILENO    手机号
   *  PSNNAME     姓名
   *  XT_CORPNAME 答到人员公司名称
   *  personId    人员识别码，由 jwt 的 personId 传入(兼容 PC 测试)
   * }
   */

  sumit_sign(params: any) {
    return http.post(url + "/sumit_sign", { ...params });
  },
  /**
   * 3.4.2-2 获取终端商户信息
   *  ACTIVITYID	字符串	活动号，单值。必传。
      KINDROLE	字符串	角色(人员类型) 。必传。应为“终端商户”
      MOBILENO	字符串	手机号。能匹配就按手机号匹配。

   */
  getlst_dsmzd(params: any) {
    return http.post(url + "/getlst_dsmzd", params);
  },

  //订货--排名--分组情况下
  getGroupDetails(params: any) {
    return http.post(url + "/getGroupDetails", params);
  },
  //订货--排名--未分组情况下
  getNoGroupDetails(params: any) {
    return http.post(url + "/getNoGroupDetails", params);
  },

  //订货--录入订单--新增
  addOrderListpost(params: any) {
    return http.post(url + "/addOrder", params);
  },
  //订货--录入订单--修改
  updateOrderDetails(params: any) {
    return http.post(url + "/updateOrderDetail", params);
  },
  //订货--录入订单--作废
  deleteOrderDetails(params: any) {
    return http.post(url + "/getMemberAllOrderDetail", params);
  },
  //订货--录入订单--查询订单
  searchOrderDetails(params: any) {
    return http.post(url + "/searchOrderDetail", params);
  },
  //订单号查找订单信息byId
  searchOrderDetailsById(params: any) {
    return http.post(url + "/searchOrderDetailByID", params);
  },
  //订单号查找订单信息获取套餐
  searchPackage(params: any) {
    return http.post(url + "/SearchPackage", params);
  },
  //订货--录入订单--根据personid查找人员信息
  getLDUserByPersonIds(params: any) {
    return http.post(url + "/getLDUserByPersonId", params);
  },
  //订货--录入订单--判断是否在组内和在那个组
  checkGroupExistByMobileNos(params: any) {
    return http.post(url + "/checkGroupExistByMobileNo", params);
  },
  //验证码验证是否为录单人员
  verifycodecheckRecoderss(params: any) {
    return http.post(url + "/verifycode_checkRecoder", params);
  },
  //录单人员--检查是否为录单人员
  checkRecoderstyle(params: any) {
    return http.post(url + "/checkRecoder", params);
  },

  //读取签到列表
  getlstsignss(params: any) {
    return http.post(url + "/getlst_sign", params);
  },

  //读取签到排名
  getsignRankss(params: any) {
    return http.post(url + "/getsignRank", params);
  },
  //读取参会排名
  getinvitedRanks(params: any) {
    return http.post(url + "/getinvitedRank", params);
  },

  //检查活动是否分组
  getGroupss(params: any) {
    return http.post(url + "/getGroup", params);
  },

  //签到
  sumitsignsss(params: any) {
    return http.post(url + "/sumit_sign", params);
  },

  //填写信息
  verifycodeCheckMemberRecord(params: any) {
    return http.post(url + "/verifycode_CheckMemberRecord", params);
  },

  //邀请二维码
  getfillphoneurlss(params: any) {
    return http.post(url + "/get_fillphoneurl", params);
  },

  //注销
  deleteMBRIbyOpenIdss(params: any) {
    return http.post(url + "/deleteMBRIbyOpenId", params);
  },

  //是否确认参会
  sumitIinvite(params: any) {
    return http.post(url + "/sumit_invite", params);
  },

  //获取验证码
  sendverifycodesss(params: any) {
    return http.post(url + "/send_verifycode", params);
  },

  //手机号检验是否建档
  getDsmzdByMOBILENOss(params: any) {
    return http.post(url + "/getDsmzdByMOBILENO", params);
  },

  //读取签到个人信息
  // getsignRankss(params: any) {
  //   return http.post(url + "/getsignRank",params);
  // },

  // ------------------------- 3.6.标准大屏数据接口 -------------------------
  /**
   * 3.6.1-1 获取签到二维码 URL
   * activityId   活动号
   */
  get_signurl4dp() {
    return http.post(url + "/get_signurl4dp");
  },
  //查询奖励
  postSearchAwards(params: any) {
    return http.post(url + "/SearchAwards", params);
  },

  // ------------------------- 3.9排行榜-------------------------
  /**
   * 3.6.1-1 排行榜
   * activityId   活动号
   */
  //查询日排行榜
  postgetGroupDailyDetails(params: any) {
    return http.post(url + "/getGroupDailyDetails2", params);
  },

  //查询总排行榜
  postgetGroupDetails(params: any) {
    return http.post(url + "/getGroupDetails2", params);
  },

  //查询业务员的订单详细
  getAmountDetailByMembers(params: any) {
    return http.post(url + "/getAmountDetailByMember", params);
  },

  //查询业务员的订单详细-包含作废
  getMemberAllOrderDetails(params: any) {
    return http.post(url + "/getMemberAllOrderDetail", params);
  },

  //查询套餐
  SearchPackage(params: any) {
    return http.post(url + "/SearchPackage", params);
  },

  //查询客户
  SearchZDList(params: any) {
    return http.post(url + "/SearchZDList", params);
  },

  //获取首页数据金额
  getNUMandAMOUNT(params: any) {
    return http.post(url + "/getNUMandAMOUNT", params);
  },

  //查询活动类型和编码
  getAmtb(params: any) {
    return http.post(url + "/getAmtb", params);
  },
};
