// 常用api

import http from '../../util/http'

import { useRoute } from 'vue-router'
const route = useRoute()

const url = import.meta.env.VITE_Dealer_User_Api_Url

export default {
    /**
     * 获取吉祥码跳转URL
     * marketingCode    code
     */
    getUrl() {
        const marketingCode = route.query.code
        return http.post(url + '/v1/mcp/get_jxm_url', { marketingCode: marketingCode })
    },

     /**
     * 绑定经销商信息
     * @param   params
     * {
     *  mobile      手机号码
     *  verifyCode  验证码
     *  oaOpenId    用户openid，获取code链接时一起返回
     *  oaId        公众号id
     * }
     */
    bindDealerInfo(params:any) {
        const json:object = {
            mobile: params.mobile,
            verifyCode: params.verifyCode,
            oaOpenId: params.oaOpenId,
            oaId: params.oaId
        }
        return http.post(url + '/v1/mcp/bind_distributor_with_phone', json)
    },

    /**
     * 获取短信验证
     * mobile   手机号码
     */
    getVerifyCode(mobile:any) {
        return http.post(url + '/v1/mcp/send_verify_code', { mobile: mobile })
    },

    /**
     * 校验验证码
     * @param   params
     * {
     *  mobile   手机号码
     *  verifyCode  验证码
     * }
     */
    checkVerifyCode(param:any) {
        const json:object = {
            mobile: param.mobile,
            verifyCode: param.verifyCode
        }
        return http.post(url + '/v1/sms/verify_code', json)
    }
}
