// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: select.proto

package tipb

import (
	"fmt"

	proto "github.com/golang/protobuf/proto"

	math "math"

	github_com_pingcap_tipb_sharedbytes "github.com/pingcap/tipb/sharedbytes"

	io "io"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type EncodeType int32

const (
	EncodeType_TypeDefault EncodeType = 0
	EncodeType_TypeArrow   EncodeType = 1
)

var EncodeType_name = map[int32]string{
	0: "TypeDefault",
	1: "TypeArrow",
}
var EncodeType_value = map[string]int32{
	"TypeDefault": 0,
	"TypeArrow":   1,
}

func (x EncodeType) Enum() *EncodeType {
	p := new(EncodeType)
	*p = x
	return p
}
func (x EncodeType) String() string {
	return proto.EnumName(EncodeType_name, int32(x))
}
func (x *EncodeType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EncodeType_value, data, "EncodeType")
	if err != nil {
		return err
	}
	*x = EncodeType(value)
	return nil
}
func (EncodeType) EnumDescriptor() ([]byte, []int) { return fileDescriptorSelect, []int{0} }

// values are all in text format.
type Row struct {
	Handle           []byte `protobuf:"bytes,1,opt,name=handle" json:"handle,omitempty"`
	Data             []byte `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()               {}
func (*Row) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{0} }

func (m *Row) GetHandle() []byte {
	if m != nil {
		return m.Handle
	}
	return nil
}

func (m *Row) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type Error struct {
	Code             int32  `protobuf:"varint,1,opt,name=code" json:"code"`
	Msg              string `protobuf:"bytes,2,opt,name=msg" json:"msg"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (m *Error) String() string            { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{1} }

func (m *Error) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Error) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

// Response for SelectRequest.
type SelectResponse struct {
	Error *Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// Result rows.
	Rows []*Row `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	// Use multiple chunks to reduce memory allocation and
	// avoid allocating large contiguous memory.
	Chunks           []Chunk                                         `protobuf:"bytes,3,rep,name=chunks" json:"chunks"`
	Warnings         []*Error                                        `protobuf:"bytes,4,rep,name=warnings" json:"warnings,omitempty"`
	OutputCounts     []int64                                         `protobuf:"varint,5,rep,name=output_counts,json=outputCounts" json:"output_counts,omitempty"`
	WarningCount     *int64                                          `protobuf:"varint,6,opt,name=warning_count,json=warningCount" json:"warning_count,omitempty"`
	RowBatchData     github_com_pingcap_tipb_sharedbytes.SharedBytes `protobuf:"bytes,7,opt,name=row_batch_data,json=rowBatchData,customtype=github.com/pingcap/tipb/sharedbytes.SharedBytes" json:"row_batch_data"`
	XXX_unrecognized []byte                                          `json:"-"`
}

func (m *SelectResponse) Reset()                    { *m = SelectResponse{} }
func (m *SelectResponse) String() string            { return proto.CompactTextString(m) }
func (*SelectResponse) ProtoMessage()               {}
func (*SelectResponse) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{2} }

func (m *SelectResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *SelectResponse) GetRows() []*Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *SelectResponse) GetChunks() []Chunk {
	if m != nil {
		return m.Chunks
	}
	return nil
}

func (m *SelectResponse) GetWarnings() []*Error {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *SelectResponse) GetOutputCounts() []int64 {
	if m != nil {
		return m.OutputCounts
	}
	return nil
}

func (m *SelectResponse) GetWarningCount() int64 {
	if m != nil && m.WarningCount != nil {
		return *m.WarningCount
	}
	return 0
}

// Chunk contains multiple rows data and rows meta.
type Chunk struct {
	// Data for all rows in the chunk.
	RowsData github_com_pingcap_tipb_sharedbytes.SharedBytes `protobuf:"bytes,3,opt,name=rows_data,json=rowsData,customtype=github.com/pingcap/tipb/sharedbytes.SharedBytes" json:"rows_data"`
	// Meta data for every row.
	RowsMeta         []RowMeta `protobuf:"bytes,4,rep,name=rows_meta,json=rowsMeta" json:"rows_meta"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *Chunk) Reset()                    { *m = Chunk{} }
func (m *Chunk) String() string            { return proto.CompactTextString(m) }
func (*Chunk) ProtoMessage()               {}
func (*Chunk) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{3} }

func (m *Chunk) GetRowsMeta() []RowMeta {
	if m != nil {
		return m.RowsMeta
	}
	return nil
}

// RowMeta contains row handle and length of a row.
type RowMeta struct {
	Handle           int64  `protobuf:"varint,1,opt,name=handle" json:"handle"`
	Length           int64  `protobuf:"varint,2,opt,name=length" json:"length"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RowMeta) Reset()                    { *m = RowMeta{} }
func (m *RowMeta) String() string            { return proto.CompactTextString(m) }
func (*RowMeta) ProtoMessage()               {}
func (*RowMeta) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{4} }

func (m *RowMeta) GetHandle() int64 {
	if m != nil {
		return m.Handle
	}
	return 0
}

func (m *RowMeta) GetLength() int64 {
	if m != nil {
		return m.Length
	}
	return 0
}

// DAGRequest represents the request that will be handled with DAG mode.
type DAGRequest struct {
	// Transaction start timestamp.
	StartTs uint64 `protobuf:"varint,1,opt,name=start_ts,json=startTs" json:"start_ts"`
	// It represents push down Executors.
	Executors []*Executor `protobuf:"bytes,2,rep,name=executors" json:"executors,omitempty"`
	// time zone offset in seconds
	TimeZoneOffset int64 `protobuf:"varint,3,opt,name=time_zone_offset,json=timeZoneOffset" json:"time_zone_offset"`
	// flags are used to store flags that change the execution mode, it contains:
	// 	ignore_truncate = 1
	// 		truncate error should be ignore if set.
	// 	truncate_as_warning = 1 << 1
	// 		when ignored_truncate is not set, return warning instead of error if this flag is set.
	// 	...
	// 	add more when needed.
	Flags uint64 `protobuf:"varint,4,opt,name=flags" json:"flags"`
	// It represents which columns we should output.
	OutputOffsets []uint32 `protobuf:"varint,5,rep,name=output_offsets,json=outputOffsets" json:"output_offsets,omitempty"`
	// It represents whether we collect the detailed scan counts in each range.
	CollectRangeCounts *bool `protobuf:"varint,6,opt,name=collect_range_counts,json=collectRangeCounts" json:"collect_range_counts,omitempty"`
	// It indicates the maximum number of warning,
	// which is the number of messages that SHOW WARNINGS displays.
	MaxWarningCount *uint64 `protobuf:"varint,7,opt,name=max_warning_count,json=maxWarningCount" json:"max_warning_count,omitempty"`
	// It indicates the encode type of response.
	EncodeType EncodeType `protobuf:"varint,8,opt,name=encode_type,json=encodeType,enum=tipb.EncodeType" json:"encode_type"`
	// It indicates the sql_mode.
	SqlMode *uint64 `protobuf:"varint,9,opt,name=sql_mode,json=sqlMode" json:"sql_mode,omitempty"`
	// It indicates whether the sql mode is strict.
	IsStrictSqlMode *bool `protobuf:"varint,10,opt,name=is_strict_sql_mode,json=isStrictSqlMode" json:"is_strict_sql_mode,omitempty"`
	// supply offset is not enough since we have daylight saving time present in some regions
	TimeZoneName     string `protobuf:"bytes,11,opt,name=time_zone_name,json=timeZoneName" json:"time_zone_name"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *DAGRequest) Reset()                    { *m = DAGRequest{} }
func (m *DAGRequest) String() string            { return proto.CompactTextString(m) }
func (*DAGRequest) ProtoMessage()               {}
func (*DAGRequest) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{5} }

func (m *DAGRequest) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *DAGRequest) GetExecutors() []*Executor {
	if m != nil {
		return m.Executors
	}
	return nil
}

func (m *DAGRequest) GetTimeZoneOffset() int64 {
	if m != nil {
		return m.TimeZoneOffset
	}
	return 0
}

func (m *DAGRequest) GetFlags() uint64 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *DAGRequest) GetOutputOffsets() []uint32 {
	if m != nil {
		return m.OutputOffsets
	}
	return nil
}

func (m *DAGRequest) GetCollectRangeCounts() bool {
	if m != nil && m.CollectRangeCounts != nil {
		return *m.CollectRangeCounts
	}
	return false
}

func (m *DAGRequest) GetMaxWarningCount() uint64 {
	if m != nil && m.MaxWarningCount != nil {
		return *m.MaxWarningCount
	}
	return 0
}

func (m *DAGRequest) GetEncodeType() EncodeType {
	if m != nil {
		return m.EncodeType
	}
	return EncodeType_TypeDefault
}

func (m *DAGRequest) GetSqlMode() uint64 {
	if m != nil && m.SqlMode != nil {
		return *m.SqlMode
	}
	return 0
}

func (m *DAGRequest) GetIsStrictSqlMode() bool {
	if m != nil && m.IsStrictSqlMode != nil {
		return *m.IsStrictSqlMode
	}
	return false
}

func (m *DAGRequest) GetTimeZoneName() string {
	if m != nil {
		return m.TimeZoneName
	}
	return ""
}

type StreamResponse struct {
	Error *Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// Data for all rows
	Data     github_com_pingcap_tipb_sharedbytes.SharedBytes `protobuf:"bytes,3,opt,name=data,customtype=github.com/pingcap/tipb/sharedbytes.SharedBytes" json:"data"`
	Warnings []*Error                                        `protobuf:"bytes,4,rep,name=warnings" json:"warnings,omitempty"`
	// output row count for each executor
	OutputCounts     []int64 `protobuf:"varint,5,rep,name=output_counts,json=outputCounts" json:"output_counts,omitempty"`
	WarningCount     *int64  `protobuf:"varint,6,opt,name=warning_count,json=warningCount" json:"warning_count,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StreamResponse) Reset()                    { *m = StreamResponse{} }
func (m *StreamResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamResponse) ProtoMessage()               {}
func (*StreamResponse) Descriptor() ([]byte, []int) { return fileDescriptorSelect, []int{6} }

func (m *StreamResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamResponse) GetWarnings() []*Error {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *StreamResponse) GetOutputCounts() []int64 {
	if m != nil {
		return m.OutputCounts
	}
	return nil
}

func (m *StreamResponse) GetWarningCount() int64 {
	if m != nil && m.WarningCount != nil {
		return *m.WarningCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Row)(nil), "tipb.Row")
	proto.RegisterType((*Error)(nil), "tipb.Error")
	proto.RegisterType((*SelectResponse)(nil), "tipb.SelectResponse")
	proto.RegisterType((*Chunk)(nil), "tipb.Chunk")
	proto.RegisterType((*RowMeta)(nil), "tipb.RowMeta")
	proto.RegisterType((*DAGRequest)(nil), "tipb.DAGRequest")
	proto.RegisterType((*StreamResponse)(nil), "tipb.StreamResponse")
	proto.RegisterEnum("tipb.EncodeType", EncodeType_name, EncodeType_value)
}
func (m *Row) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Row) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Handle != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSelect(dAtA, i, uint64(len(m.Handle)))
		i += copy(dAtA[i:], m.Handle)
	}
	if m.Data != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintSelect(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Code))
	dAtA[i] = 0x12
	i++
	i = encodeVarintSelect(dAtA, i, uint64(len(m.Msg)))
	i += copy(dAtA[i:], m.Msg)
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SelectResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SelectResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSelect(dAtA, i, uint64(m.Error.Size()))
		n1, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Chunks) > 0 {
		for _, msg := range m.Chunks {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Warnings) > 0 {
		for _, msg := range m.Warnings {
			dAtA[i] = 0x22
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, num := range m.OutputCounts {
			dAtA[i] = 0x28
			i++
			i = encodeVarintSelect(dAtA, i, uint64(num))
		}
	}
	if m.WarningCount != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintSelect(dAtA, i, uint64(*m.WarningCount))
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.RowBatchData.Size()))
	n2, err := m.RowBatchData.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Chunk) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Chunk) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x1a
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.RowsData.Size()))
	n3, err := m.RowsData.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if len(m.RowsMeta) > 0 {
		for _, msg := range m.RowsMeta {
			dAtA[i] = 0x22
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RowMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RowMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Handle))
	dAtA[i] = 0x10
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Length))
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DAGRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DAGRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.StartTs))
	if len(m.Executors) > 0 {
		for _, msg := range m.Executors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.TimeZoneOffset))
	dAtA[i] = 0x20
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Flags))
	if len(m.OutputOffsets) > 0 {
		for _, num := range m.OutputOffsets {
			dAtA[i] = 0x28
			i++
			i = encodeVarintSelect(dAtA, i, uint64(num))
		}
	}
	if m.CollectRangeCounts != nil {
		dAtA[i] = 0x30
		i++
		if *m.CollectRangeCounts {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.MaxWarningCount != nil {
		dAtA[i] = 0x38
		i++
		i = encodeVarintSelect(dAtA, i, uint64(*m.MaxWarningCount))
	}
	dAtA[i] = 0x40
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.EncodeType))
	if m.SqlMode != nil {
		dAtA[i] = 0x48
		i++
		i = encodeVarintSelect(dAtA, i, uint64(*m.SqlMode))
	}
	if m.IsStrictSqlMode != nil {
		dAtA[i] = 0x50
		i++
		if *m.IsStrictSqlMode {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x5a
	i++
	i = encodeVarintSelect(dAtA, i, uint64(len(m.TimeZoneName)))
	i += copy(dAtA[i:], m.TimeZoneName)
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StreamResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StreamResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintSelect(dAtA, i, uint64(m.Error.Size()))
		n4, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintSelect(dAtA, i, uint64(m.Data.Size()))
	n5, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if len(m.Warnings) > 0 {
		for _, msg := range m.Warnings {
			dAtA[i] = 0x22
			i++
			i = encodeVarintSelect(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, num := range m.OutputCounts {
			dAtA[i] = 0x28
			i++
			i = encodeVarintSelect(dAtA, i, uint64(num))
		}
	}
	if m.WarningCount != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintSelect(dAtA, i, uint64(*m.WarningCount))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintSelect(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Row) Size() (n int) {
	var l int
	_ = l
	if m.Handle != nil {
		l = len(m.Handle)
		n += 1 + l + sovSelect(uint64(l))
	}
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovSelect(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Error) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovSelect(uint64(m.Code))
	l = len(m.Msg)
	n += 1 + l + sovSelect(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SelectResponse) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovSelect(uint64(l))
	}
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.Chunks) > 0 {
		for _, e := range m.Chunks {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, e := range m.Warnings {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, e := range m.OutputCounts {
			n += 1 + sovSelect(uint64(e))
		}
	}
	if m.WarningCount != nil {
		n += 1 + sovSelect(uint64(*m.WarningCount))
	}
	l = m.RowBatchData.Size()
	n += 1 + l + sovSelect(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Chunk) Size() (n int) {
	var l int
	_ = l
	l = m.RowsData.Size()
	n += 1 + l + sovSelect(uint64(l))
	if len(m.RowsMeta) > 0 {
		for _, e := range m.RowsMeta {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RowMeta) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovSelect(uint64(m.Handle))
	n += 1 + sovSelect(uint64(m.Length))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DAGRequest) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovSelect(uint64(m.StartTs))
	if len(m.Executors) > 0 {
		for _, e := range m.Executors {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	n += 1 + sovSelect(uint64(m.TimeZoneOffset))
	n += 1 + sovSelect(uint64(m.Flags))
	if len(m.OutputOffsets) > 0 {
		for _, e := range m.OutputOffsets {
			n += 1 + sovSelect(uint64(e))
		}
	}
	if m.CollectRangeCounts != nil {
		n += 2
	}
	if m.MaxWarningCount != nil {
		n += 1 + sovSelect(uint64(*m.MaxWarningCount))
	}
	n += 1 + sovSelect(uint64(m.EncodeType))
	if m.SqlMode != nil {
		n += 1 + sovSelect(uint64(*m.SqlMode))
	}
	if m.IsStrictSqlMode != nil {
		n += 2
	}
	l = len(m.TimeZoneName)
	n += 1 + l + sovSelect(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StreamResponse) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovSelect(uint64(l))
	}
	l = m.Data.Size()
	n += 1 + l + sovSelect(uint64(l))
	if len(m.Warnings) > 0 {
		for _, e := range m.Warnings {
			l = e.Size()
			n += 1 + l + sovSelect(uint64(l))
		}
	}
	if len(m.OutputCounts) > 0 {
		for _, e := range m.OutputCounts {
			n += 1 + sovSelect(uint64(e))
		}
	}
	if m.WarningCount != nil {
		n += 1 + sovSelect(uint64(*m.WarningCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSelect(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozSelect(x uint64) (n int) {
	return sovSelect(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Row) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Row: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Row: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handle", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Handle = append(m.Handle[:0], dAtA[iNdEx:postIndex]...)
			if m.Handle == nil {
				m.Handle = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SelectResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SelectResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SelectResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, &Row{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Chunks = append(m.Chunks, Chunk{})
			if err := m.Chunks[len(m.Chunks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, &Error{})
			if err := m.Warnings[len(m.Warnings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputCounts = append(m.OutputCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSelect
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSelect
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputCounts = append(m.OutputCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputCounts", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WarningCount", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WarningCount = &v
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowBatchData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RowBatchData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Chunk) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Chunk: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Chunk: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowsData", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RowsData.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RowsMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RowsMeta = append(m.RowsMeta, RowMeta{})
			if err := m.RowsMeta[len(m.RowsMeta)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RowMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RowMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RowMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handle", wireType)
			}
			m.Handle = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Handle |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Length", wireType)
			}
			m.Length = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Length |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DAGRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DAGRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DAGRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Executors = append(m.Executors, &Executor{})
			if err := m.Executors[len(m.Executors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeZoneOffset", wireType)
			}
			m.TimeZoneOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeZoneOffset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputOffsets = append(m.OutputOffsets, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSelect
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSelect
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputOffsets = append(m.OutputOffsets, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputOffsets", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CollectRangeCounts", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.CollectRangeCounts = &b
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxWarningCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MaxWarningCount = &v
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncodeType", wireType)
			}
			m.EncodeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EncodeType |= (EncodeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SqlMode", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SqlMode = &v
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsStrictSqlMode", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.IsStrictSqlMode = &b
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeZoneName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeZoneName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StreamResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StreamResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StreamResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSelect
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, &Error{})
			if err := m.Warnings[len(m.Warnings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType == 0 {
				var v int64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputCounts = append(m.OutputCounts, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSelect
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSelect
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputCounts = append(m.OutputCounts, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputCounts", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WarningCount", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WarningCount = &v
		default:
			iNdEx = preIndex
			skippy, err := skipSelect(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSelect
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSelect(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSelect
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSelect
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthSelect
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSelect
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSelect(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSelect = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSelect   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("select.proto", fileDescriptorSelect) }

var fileDescriptorSelect = []byte{
	// 748 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x54, 0xcd, 0x4e, 0xdb, 0x4a,
	0x18, 0xc5, 0xd8, 0xf9, 0xfb, 0x92, 0x98, 0xdc, 0x11, 0x17, 0xf9, 0x22, 0x6e, 0xc8, 0xcd, 0x55,
	0xd5, 0x40, 0x91, 0x43, 0xd9, 0xa0, 0x2e, 0x09, 0xa0, 0x2e, 0x2a, 0xda, 0xca, 0x41, 0xaa, 0x54,
	0xa9, 0xb2, 0x26, 0xce, 0xc4, 0xb1, 0x6a, 0x7b, 0xcc, 0xcc, 0x58, 0x81, 0xbe, 0x44, 0xb7, 0x7d,
	0x24, 0x76, 0xed, 0xb6, 0x5d, 0xa0, 0x8a, 0x3e, 0x42, 0x5f, 0xa0, 0x9a, 0xf1, 0x24, 0x81, 0x65,
	0xc5, 0xa2, 0xab, 0x4c, 0xce, 0x39, 0x73, 0xbe, 0xcf, 0xdf, 0x9c, 0x19, 0x68, 0x70, 0x12, 0x93,
	0x40, 0xb8, 0x19, 0xa3, 0x82, 0x22, 0x4b, 0x44, 0xd9, 0x68, 0xd3, 0x26, 0x97, 0x24, 0xc8, 0x05,
	0x65, 0x05, 0xba, 0xb9, 0x1e, 0xd2, 0x90, 0xaa, 0x65, 0x5f, 0xae, 0x0a, 0xb4, 0xfb, 0x14, 0x4c,
	0x8f, 0xce, 0xd0, 0x06, 0x94, 0xa7, 0x38, 0x1d, 0xc7, 0xc4, 0x31, 0x3a, 0x46, 0xaf, 0xe1, 0xe9,
	0x7f, 0x08, 0x81, 0x35, 0xc6, 0x02, 0x3b, 0xab, 0x0a, 0x55, 0xeb, 0xee, 0x33, 0x28, 0x9d, 0x32,
	0x46, 0x19, 0x72, 0xc0, 0x0a, 0xe8, 0xb8, 0xd8, 0x52, 0x1a, 0x58, 0xd7, 0x37, 0xdb, 0x2b, 0x9e,
	0x42, 0xd0, 0x06, 0x98, 0x09, 0x0f, 0xd5, 0xae, 0x9a, 0x26, 0x24, 0xd0, 0xfd, 0xbc, 0x0a, 0xf6,
	0x50, 0xb5, 0xea, 0x11, 0x9e, 0xd1, 0x94, 0x13, 0xf4, 0x1f, 0x94, 0x88, 0x74, 0x53, 0x2e, 0xf5,
	0x83, 0xba, 0x2b, 0x9b, 0x77, 0x55, 0x01, 0xaf, 0x60, 0xd0, 0xbf, 0x60, 0x31, 0x3a, 0xe3, 0xce,
	0x6a, 0xc7, 0xec, 0xd5, 0x0f, 0x6a, 0x85, 0xc2, 0xa3, 0x33, 0x4f, 0xc1, 0x68, 0x07, 0xca, 0xc1,
	0x34, 0x4f, 0xdf, 0x73, 0xc7, 0x54, 0x02, 0x6d, 0x71, 0x2c, 0x31, 0x5d, 0x5c, 0x0b, 0xd0, 0x63,
	0xa8, 0xce, 0x30, 0x4b, 0xa3, 0x34, 0xe4, 0x8e, 0x75, 0x57, 0x5c, 0xd4, 0x5b, 0x90, 0xe8, 0x7f,
	0x68, 0xd2, 0x5c, 0x64, 0xb9, 0xf0, 0x03, 0x9a, 0xa7, 0x82, 0x3b, 0xa5, 0x8e, 0xd9, 0x33, 0xbd,
	0x46, 0x01, 0x1e, 0x2b, 0x4c, 0x8a, 0xf4, 0x86, 0x42, 0xe5, 0x94, 0x3b, 0x86, 0x14, 0x69, 0x50,
	0xa9, 0xd0, 0x3b, 0xb0, 0x19, 0x9d, 0xf9, 0x23, 0x2c, 0x82, 0xa9, 0xaf, 0x66, 0x59, 0x91, 0xb3,
	0x1c, 0x1c, 0xca, 0xc6, 0xbe, 0xdd, 0x6c, 0xf7, 0xc3, 0x48, 0x4c, 0xf3, 0x91, 0x1b, 0xd0, 0xa4,
	0x9f, 0x45, 0x69, 0x18, 0xe0, 0xac, 0x2f, 0x5b, 0xea, 0xf3, 0x29, 0x66, 0x64, 0x3c, 0xba, 0x12,
	0x84, 0xbb, 0x43, 0xb5, 0x1e, 0xc8, 0xb5, 0xd7, 0x60, 0x74, 0x36, 0x90, 0x6e, 0x27, 0xf2, 0x30,
	0x3e, 0x1a, 0x50, 0x52, 0x5f, 0x8a, 0xce, 0xa1, 0x26, 0xc7, 0x51, 0xd4, 0x30, 0x1f, 0x56, 0xa3,
	0x2a, 0x9d, 0xa4, 0x3f, 0xda, 0xd7, 0xae, 0x09, 0x11, 0x58, 0x8f, 0xac, 0xb9, 0x38, 0x80, 0x33,
	0x22, 0xb0, 0x9e, 0xb0, 0xda, 0x21, 0xff, 0x77, 0x4f, 0xa1, 0xa2, 0x29, 0xb4, 0x75, 0x2f, 0x55,
	0xe6, 0xfc, 0x30, 0x74, 0xb6, 0xb6, 0xa0, 0x1c, 0x93, 0x34, 0x14, 0x53, 0x95, 0x93, 0x05, 0x5b,
	0x60, 0xdd, 0xaf, 0x26, 0xc0, 0xc9, 0xd1, 0x73, 0x8f, 0x5c, 0xe4, 0x84, 0x0b, 0xb4, 0x0d, 0x55,
	0x2e, 0x30, 0x13, 0xbe, 0xe0, 0xca, 0xcc, 0xd2, 0xf2, 0x8a, 0x42, 0xcf, 0x39, 0xda, 0x83, 0xda,
	0x3c, 0xf0, 0xf3, 0xa4, 0xd8, 0xfa, 0x6c, 0x35, 0xec, 0x2d, 0x05, 0xc8, 0x85, 0x96, 0x88, 0x12,
	0xe2, 0x7f, 0xa0, 0x29, 0xf1, 0xe9, 0x64, 0xc2, 0x89, 0x50, 0x33, 0x9b, 0x77, 0x61, 0x4b, 0xf6,
	0x2d, 0x4d, 0xc9, 0x2b, 0xc5, 0xa1, 0x4d, 0x28, 0x4d, 0x62, 0xac, 0x52, 0xb3, 0xac, 0x5d, 0x40,
	0xe8, 0x11, 0xd8, 0x3a, 0x2b, 0x85, 0x51, 0x11, 0x96, 0xa6, 0xa7, 0x13, 0x54, 0x38, 0x70, 0xb4,
	0x0f, 0xeb, 0x01, 0x8d, 0x65, 0xf6, 0x7d, 0x86, 0xd3, 0x90, 0xcc, 0x93, 0x25, 0x43, 0x53, 0xf5,
	0x90, 0xe6, 0x3c, 0x49, 0xe9, 0x7c, 0xed, 0xc2, 0x5f, 0x09, 0xbe, 0xf4, 0xef, 0x67, 0x4c, 0xa6,
	0xc7, 0xf2, 0xd6, 0x12, 0x7c, 0xf9, 0xe6, 0x6e, 0xcc, 0x0e, 0xa1, 0x4e, 0x52, 0x79, 0xf7, 0x7c,
	0x71, 0x95, 0x11, 0xa7, 0xda, 0x31, 0x7a, 0xf6, 0x41, 0x4b, 0x0f, 0x40, 0x11, 0xe7, 0x57, 0x19,
	0xd1, 0x8d, 0x03, 0x59, 0x20, 0xe8, 0x1f, 0xa8, 0xf2, 0x8b, 0xd8, 0x4f, 0xe4, 0x45, 0xae, 0x29,
	0xef, 0x0a, 0xbf, 0x88, 0xcf, 0xe4, 0x2d, 0x7e, 0x02, 0x28, 0xe2, 0x3e, 0x17, 0x2c, 0x0a, 0x84,
	0xbf, 0x10, 0x81, 0xea, 0x77, 0x2d, 0xe2, 0x43, 0x45, 0x0c, 0xb5, 0x78, 0x17, 0xec, 0xe5, 0x44,
	0x53, 0x9c, 0x10, 0xa7, 0x7e, 0xe7, 0xf6, 0x37, 0xe6, 0xf3, 0x7c, 0x89, 0x13, 0xd2, 0xfd, 0x69,
	0x80, 0x3d, 0x14, 0x8c, 0xe0, 0xe4, 0x77, 0x9e, 0x81, 0x17, 0xfa, 0x2d, 0x7a, 0x60, 0xb6, 0x95,
	0xc9, 0x1f, 0x78, 0x09, 0x76, 0xf7, 0x00, 0x96, 0x27, 0x81, 0xd6, 0xa0, 0x2e, 0x7f, 0x4f, 0xc8,
	0x04, 0xe7, 0xb1, 0x68, 0xad, 0xa0, 0x26, 0xd4, 0x24, 0x70, 0xc4, 0x18, 0x9d, 0xb5, 0x8c, 0xc1,
	0xce, 0xf5, 0x6d, 0xdb, 0xf8, 0x72, 0xdb, 0x36, 0xbe, 0xdf, 0xb6, 0x8d, 0x4f, 0x3f, 0xda, 0x2b,
	0xf0, 0x77, 0x40, 0x13, 0x57, 0x7f, 0xa2, 0x2b, 0xa2, 0xf1, 0x48, 0x35, 0xfc, 0xda, 0xf8, 0x15,
	0x00, 0x00, 0xff, 0xff, 0x04, 0xb1, 0xa6, 0x66, 0xfe, 0x05, 0x00, 0x00,
}
