// Code generated by protoc-gen-go. DO NOT EDIT.
// source: topodata.proto

package topodata

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	vttime "vitess.io/vitess/go/vt/proto/vttime"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// KeyspaceType describes the type of the keyspace
type KeyspaceType int32

const (
	// NORMAL is the default value
	KeyspaceType_NORMAL KeyspaceType = 0
	// SNAPSHOT is when we are creating a snapshot keyspace
	KeyspaceType_SNAPSHOT KeyspaceType = 1
)

var KeyspaceType_name = map[int32]string{
	0: "NORMAL",
	1: "SNAPSHOT",
}

var KeyspaceType_value = map[string]int32{
	"NORMAL":   0,
	"SNAPSHOT": 1,
}

func (x KeyspaceType) String() string {
	return proto.EnumName(KeyspaceType_name, int32(x))
}

func (KeyspaceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{0}
}

// KeyspaceIdType describes the type of the sharding key for a
// range-based sharded keyspace.
type KeyspaceIdType int32

const (
	// UNSET is the default value, when range-based sharding is not used.
	KeyspaceIdType_UNSET KeyspaceIdType = 0
	// UINT64 is when uint64 value is used.
	// This is represented as 'unsigned bigint' in mysql
	KeyspaceIdType_UINT64 KeyspaceIdType = 1
	// BYTES is when an array of bytes is used.
	// This is represented as 'varbinary' in mysql
	KeyspaceIdType_BYTES KeyspaceIdType = 2
)

var KeyspaceIdType_name = map[int32]string{
	0: "UNSET",
	1: "UINT64",
	2: "BYTES",
}

var KeyspaceIdType_value = map[string]int32{
	"UNSET":  0,
	"UINT64": 1,
	"BYTES":  2,
}

func (x KeyspaceIdType) String() string {
	return proto.EnumName(KeyspaceIdType_name, int32(x))
}

func (KeyspaceIdType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{1}
}

// TabletType represents the type of a given tablet.
type TabletType int32

const (
	// UNKNOWN is not a valid value.
	TabletType_UNKNOWN TabletType = 0
	// MASTER is the master server for the shard. Only MASTER allows DMLs.
	TabletType_MASTER TabletType = 1
	// REPLICA is a slave type. It is used to serve live traffic.
	// A REPLICA can be promoted to MASTER. A demoted MASTER will go to REPLICA.
	TabletType_REPLICA TabletType = 2
	// RDONLY (old name) / BATCH (new name) is used to serve traffic for
	// long-running jobs. It is a separate type from REPLICA so
	// long-running queries don't affect web-like traffic.
	TabletType_RDONLY TabletType = 3
	TabletType_BATCH  TabletType = 3
	// SPARE is a type of servers that cannot serve queries, but is available
	// in case an extra server is needed.
	TabletType_SPARE TabletType = 4
	// EXPERIMENTAL is like SPARE, except it can serve queries. This
	// type can be used for usages not planned by Vitess, like online
	// export to another storage engine.
	TabletType_EXPERIMENTAL TabletType = 5
	// BACKUP is the type a server goes to when taking a backup. No queries
	// can be served in BACKUP mode.
	TabletType_BACKUP TabletType = 6
	// RESTORE is the type a server uses when restoring a backup, at
	// startup time.  No queries can be served in RESTORE mode.
	TabletType_RESTORE TabletType = 7
	// DRAINED is the type a server goes into when used by Vitess tools
	// to perform an offline action. It is a serving type (as
	// the tools processes may need to run queries), but it's not used
	// to route queries from Vitess users. In this state,
	// this tablet is dedicated to the process that uses it.
	TabletType_DRAINED TabletType = 8
)

var TabletType_name = map[int32]string{
	0: "UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
	3: "RDONLY",
	// Duplicate value: 3: "BATCH",
	4: "SPARE",
	5: "EXPERIMENTAL",
	6: "BACKUP",
	7: "RESTORE",
	8: "DRAINED",
}

var TabletType_value = map[string]int32{
	"UNKNOWN":      0,
	"MASTER":       1,
	"REPLICA":      2,
	"RDONLY":       3,
	"BATCH":        3,
	"SPARE":        4,
	"EXPERIMENTAL": 5,
	"BACKUP":       6,
	"RESTORE":      7,
	"DRAINED":      8,
}

func (x TabletType) String() string {
	return proto.EnumName(TabletType_name, int32(x))
}

func (TabletType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{2}
}

// KeyRange describes a range of sharding keys, when range-based
// sharding is used.
type KeyRange struct {
	Start                []byte   `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End                  []byte   `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyRange) Reset()         { *m = KeyRange{} }
func (m *KeyRange) String() string { return proto.CompactTextString(m) }
func (*KeyRange) ProtoMessage()    {}
func (*KeyRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{0}
}

func (m *KeyRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyRange.Unmarshal(m, b)
}
func (m *KeyRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyRange.Marshal(b, m, deterministic)
}
func (m *KeyRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyRange.Merge(m, src)
}
func (m *KeyRange) XXX_Size() int {
	return xxx_messageInfo_KeyRange.Size(m)
}
func (m *KeyRange) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyRange.DiscardUnknown(m)
}

var xxx_messageInfo_KeyRange proto.InternalMessageInfo

func (m *KeyRange) GetStart() []byte {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *KeyRange) GetEnd() []byte {
	if m != nil {
		return m.End
	}
	return nil
}

// TabletAlias is a globally unique tablet identifier.
type TabletAlias struct {
	// cell is the cell (or datacenter) the tablet is in
	Cell string `protobuf:"bytes,1,opt,name=cell,proto3" json:"cell,omitempty"`
	// uid is a unique id for this tablet within the shard
	// (this is the MySQL server id as well).
	Uid                  uint32   `protobuf:"varint,2,opt,name=uid,proto3" json:"uid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TabletAlias) Reset()         { *m = TabletAlias{} }
func (m *TabletAlias) String() string { return proto.CompactTextString(m) }
func (*TabletAlias) ProtoMessage()    {}
func (*TabletAlias) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{1}
}

func (m *TabletAlias) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TabletAlias.Unmarshal(m, b)
}
func (m *TabletAlias) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TabletAlias.Marshal(b, m, deterministic)
}
func (m *TabletAlias) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TabletAlias.Merge(m, src)
}
func (m *TabletAlias) XXX_Size() int {
	return xxx_messageInfo_TabletAlias.Size(m)
}
func (m *TabletAlias) XXX_DiscardUnknown() {
	xxx_messageInfo_TabletAlias.DiscardUnknown(m)
}

var xxx_messageInfo_TabletAlias proto.InternalMessageInfo

func (m *TabletAlias) GetCell() string {
	if m != nil {
		return m.Cell
	}
	return ""
}

func (m *TabletAlias) GetUid() uint32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

// Tablet represents information about a running instance of vttablet.
type Tablet struct {
	// alias is the unique name of the tablet.
	Alias *TabletAlias `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
	// Fully qualified domain name of the host.
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Map of named ports. Normally this should include vt and grpc.
	// Going forward, the mysql port will be stored in mysql_port
	// instead of here.
	// For accessing mysql port, use topoproto.MysqlPort to fetch, and
	// topoproto.SetMysqlPort to set. These wrappers will ensure
	// legacy behavior is supported.
	PortMap map[string]int32 `protobuf:"bytes,4,rep,name=port_map,json=portMap,proto3" json:"port_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Keyspace name.
	Keyspace string `protobuf:"bytes,5,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// Shard name. If range based sharding is used, it should match
	// key_range.
	Shard string `protobuf:"bytes,6,opt,name=shard,proto3" json:"shard,omitempty"`
	// If range based sharding is used, range for the tablet's shard.
	KeyRange *KeyRange `protobuf:"bytes,7,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// type is the current type of the tablet.
	Type TabletType `protobuf:"varint,8,opt,name=type,proto3,enum=topodata.TabletType" json:"type,omitempty"`
	// It this is set, it is used as the database name instead of the
	// normal "vt_" + keyspace.
	DbNameOverride string `protobuf:"bytes,9,opt,name=db_name_override,json=dbNameOverride,proto3" json:"db_name_override,omitempty"`
	// tablet tags
	Tags map[string]string `protobuf:"bytes,10,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// MySQL hostname.
	MysqlHostname string `protobuf:"bytes,12,opt,name=mysql_hostname,json=mysqlHostname,proto3" json:"mysql_hostname,omitempty"`
	// MySQL port. Use topoproto.MysqlPort and topoproto.SetMysqlPort
	// to access this variable. The functions provide support
	// for legacy behavior.
	MysqlPort int32 `protobuf:"varint,13,opt,name=mysql_port,json=mysqlPort,proto3" json:"mysql_port,omitempty"`
	// master_term_start_time is the time (in UTC) at which the current term of
	// the current tablet began as master. If this tablet is not currently the
	// master, this value is ignored.
	//
	// A new master term begins any time an authoritative decision is communicated
	// about which tablet should be the master, such as via Vitess
	// replication-management commands like PlannedReparentShard,
	// EmergencyReparentShard, and TabletExternallyReparented.
	//
	MasterTermStartTime  *vttime.Time `protobuf:"bytes,14,opt,name=master_term_start_time,json=masterTermStartTime,proto3" json:"master_term_start_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Tablet) Reset()         { *m = Tablet{} }
func (m *Tablet) String() string { return proto.CompactTextString(m) }
func (*Tablet) ProtoMessage()    {}
func (*Tablet) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{2}
}

func (m *Tablet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tablet.Unmarshal(m, b)
}
func (m *Tablet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tablet.Marshal(b, m, deterministic)
}
func (m *Tablet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tablet.Merge(m, src)
}
func (m *Tablet) XXX_Size() int {
	return xxx_messageInfo_Tablet.Size(m)
}
func (m *Tablet) XXX_DiscardUnknown() {
	xxx_messageInfo_Tablet.DiscardUnknown(m)
}

var xxx_messageInfo_Tablet proto.InternalMessageInfo

func (m *Tablet) GetAlias() *TabletAlias {
	if m != nil {
		return m.Alias
	}
	return nil
}

func (m *Tablet) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *Tablet) GetPortMap() map[string]int32 {
	if m != nil {
		return m.PortMap
	}
	return nil
}

func (m *Tablet) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *Tablet) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *Tablet) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Tablet) GetType() TabletType {
	if m != nil {
		return m.Type
	}
	return TabletType_UNKNOWN
}

func (m *Tablet) GetDbNameOverride() string {
	if m != nil {
		return m.DbNameOverride
	}
	return ""
}

func (m *Tablet) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Tablet) GetMysqlHostname() string {
	if m != nil {
		return m.MysqlHostname
	}
	return ""
}

func (m *Tablet) GetMysqlPort() int32 {
	if m != nil {
		return m.MysqlPort
	}
	return 0
}

func (m *Tablet) GetMasterTermStartTime() *vttime.Time {
	if m != nil {
		return m.MasterTermStartTime
	}
	return nil
}

// A Shard contains data about a subset of the data whithin a keyspace.
type Shard struct {
	// master_alias is the tablet alias of the master for the shard.
	// If it is unset, then there is no master in this shard yet.
	// No lock is necessary to update this field, when for instance
	// TabletExternallyReparented updates this. However, we lock the
	// shard for reparenting operations (InitShardMaster,
	// PlannedReparentShard,EmergencyReparentShard), to guarantee
	// exclusive operation.
	MasterAlias *TabletAlias `protobuf:"bytes,1,opt,name=master_alias,json=masterAlias,proto3" json:"master_alias,omitempty"`
	// master_term_start_time is the time (in UTC) at which the current term of
	// the master specified in master_alias began.
	//
	// A new master term begins any time an authoritative decision is communicated
	// about which tablet should be the master, such as via Vitess
	// replication-management commands like PlannedReparentShard,
	// EmergencyReparentShard, and TabletExternallyReparented.
	//
	// The master_alias should only ever be changed if the new master's term began
	// at a later time than this. Note that a new term can start for the tablet
	// that is already the master. In that case, the master_term_start_time would
	// be increased without changing the master_alias.
	MasterTermStartTime *vttime.Time `protobuf:"bytes,8,opt,name=master_term_start_time,json=masterTermStartTime,proto3" json:"master_term_start_time,omitempty"`
	// key_range is the KeyRange for this shard. It can be unset if:
	// - we are not using range-based sharding in this shard.
	// - the shard covers the entire keyrange.
	// This must match the shard name based on our other conventions, but
	// helpful to have it decomposed here.
	// Once set at creation time, it is never changed.
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// served_types has at most one entry per TabletType
	// This field is in the process of being deprecated in favor of
	// is_master_serving. Keeping for backwards compatibility purposes.
	ServedTypes []*Shard_ServedType `protobuf:"bytes,3,rep,name=served_types,json=servedTypes,proto3" json:"served_types,omitempty"`
	// SourceShards is the list of shards we're replicating from,
	// using filtered replication.
	// The keyspace lock is always taken when changing this.
	SourceShards []*Shard_SourceShard `protobuf:"bytes,4,rep,name=source_shards,json=sourceShards,proto3" json:"source_shards,omitempty"`
	// tablet_controls has at most one entry per TabletType.
	// The keyspace lock is always taken when changing this.
	TabletControls []*Shard_TabletControl `protobuf:"bytes,6,rep,name=tablet_controls,json=tabletControls,proto3" json:"tablet_controls,omitempty"`
	// is_master_serving sets whether this shard master is serving traffic or not.
	// The keyspace lock is always taken when changing this.
	IsMasterServing      bool     `protobuf:"varint,7,opt,name=is_master_serving,json=isMasterServing,proto3" json:"is_master_serving,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3}
}

func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (m *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(m, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetMasterAlias() *TabletAlias {
	if m != nil {
		return m.MasterAlias
	}
	return nil
}

func (m *Shard) GetMasterTermStartTime() *vttime.Time {
	if m != nil {
		return m.MasterTermStartTime
	}
	return nil
}

func (m *Shard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Shard) GetServedTypes() []*Shard_ServedType {
	if m != nil {
		return m.ServedTypes
	}
	return nil
}

func (m *Shard) GetSourceShards() []*Shard_SourceShard {
	if m != nil {
		return m.SourceShards
	}
	return nil
}

func (m *Shard) GetTabletControls() []*Shard_TabletControl {
	if m != nil {
		return m.TabletControls
	}
	return nil
}

func (m *Shard) GetIsMasterServing() bool {
	if m != nil {
		return m.IsMasterServing
	}
	return false
}

// ServedType is an entry in the served_types
type Shard_ServedType struct {
	TabletType           TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells                []string   `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Shard_ServedType) Reset()         { *m = Shard_ServedType{} }
func (m *Shard_ServedType) String() string { return proto.CompactTextString(m) }
func (*Shard_ServedType) ProtoMessage()    {}
func (*Shard_ServedType) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3, 0}
}

func (m *Shard_ServedType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard_ServedType.Unmarshal(m, b)
}
func (m *Shard_ServedType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard_ServedType.Marshal(b, m, deterministic)
}
func (m *Shard_ServedType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard_ServedType.Merge(m, src)
}
func (m *Shard_ServedType) XXX_Size() int {
	return xxx_messageInfo_Shard_ServedType.Size(m)
}
func (m *Shard_ServedType) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard_ServedType.DiscardUnknown(m)
}

var xxx_messageInfo_Shard_ServedType proto.InternalMessageInfo

func (m *Shard_ServedType) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *Shard_ServedType) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

// SourceShard represents a data source for filtered replication
// across shards. When this is used in a destination shard, the master
// of that shard will run filtered replication.
type Shard_SourceShard struct {
	// Uid is the unique ID for this SourceShard object.
	Uid uint32 `protobuf:"varint,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// the source keyspace
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,3,opt,name=shard,proto3" json:"shard,omitempty"`
	// the source shard keyrange
	KeyRange *KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// the source table list to replicate
	Tables               []string `protobuf:"bytes,5,rep,name=tables,proto3" json:"tables,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard_SourceShard) Reset()         { *m = Shard_SourceShard{} }
func (m *Shard_SourceShard) String() string { return proto.CompactTextString(m) }
func (*Shard_SourceShard) ProtoMessage()    {}
func (*Shard_SourceShard) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3, 1}
}

func (m *Shard_SourceShard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard_SourceShard.Unmarshal(m, b)
}
func (m *Shard_SourceShard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard_SourceShard.Marshal(b, m, deterministic)
}
func (m *Shard_SourceShard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard_SourceShard.Merge(m, src)
}
func (m *Shard_SourceShard) XXX_Size() int {
	return xxx_messageInfo_Shard_SourceShard.Size(m)
}
func (m *Shard_SourceShard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard_SourceShard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard_SourceShard proto.InternalMessageInfo

func (m *Shard_SourceShard) GetUid() uint32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *Shard_SourceShard) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *Shard_SourceShard) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *Shard_SourceShard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Shard_SourceShard) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

// TabletControl controls tablet's behavior
type Shard_TabletControl struct {
	// which tablet type is affected
	TabletType        TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells             []string   `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	BlacklistedTables []string   `protobuf:"bytes,4,rep,name=blacklisted_tables,json=blacklistedTables,proto3" json:"blacklisted_tables,omitempty"`
	// frozen is set if we've started failing over traffic for
	// the master. If set, this record should not be removed.
	Frozen               bool     `protobuf:"varint,5,opt,name=frozen,proto3" json:"frozen,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard_TabletControl) Reset()         { *m = Shard_TabletControl{} }
func (m *Shard_TabletControl) String() string { return proto.CompactTextString(m) }
func (*Shard_TabletControl) ProtoMessage()    {}
func (*Shard_TabletControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3, 2}
}

func (m *Shard_TabletControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard_TabletControl.Unmarshal(m, b)
}
func (m *Shard_TabletControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard_TabletControl.Marshal(b, m, deterministic)
}
func (m *Shard_TabletControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard_TabletControl.Merge(m, src)
}
func (m *Shard_TabletControl) XXX_Size() int {
	return xxx_messageInfo_Shard_TabletControl.Size(m)
}
func (m *Shard_TabletControl) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard_TabletControl.DiscardUnknown(m)
}

var xxx_messageInfo_Shard_TabletControl proto.InternalMessageInfo

func (m *Shard_TabletControl) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *Shard_TabletControl) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

func (m *Shard_TabletControl) GetBlacklistedTables() []string {
	if m != nil {
		return m.BlacklistedTables
	}
	return nil
}

func (m *Shard_TabletControl) GetFrozen() bool {
	if m != nil {
		return m.Frozen
	}
	return false
}

// A Keyspace contains data about a keyspace.
type Keyspace struct {
	// name of the column used for sharding
	// empty if the keyspace is not sharded
	ShardingColumnName string `protobuf:"bytes,1,opt,name=sharding_column_name,json=shardingColumnName,proto3" json:"sharding_column_name,omitempty"`
	// type of the column used for sharding
	// UNSET if the keyspace is not sharded
	ShardingColumnType KeyspaceIdType `protobuf:"varint,2,opt,name=sharding_column_type,json=shardingColumnType,proto3,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	// ServedFrom will redirect the appropriate traffic to
	// another keyspace.
	ServedFroms []*Keyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_froms,json=servedFroms,proto3" json:"served_froms,omitempty"`
	// keyspace_type will determine how this keyspace is treated by
	// vtgate / vschema. Normal keyspaces are routable by
	// any query. Snapshot keyspaces are only accessible
	// by explicit addresssing or by calling "use keyspace" first
	KeyspaceType KeyspaceType `protobuf:"varint,5,opt,name=keyspace_type,json=keyspaceType,proto3,enum=topodata.KeyspaceType" json:"keyspace_type,omitempty"`
	// base_keyspace is the base keyspace from which a snapshot
	// keyspace is created. empty for normal keyspaces
	BaseKeyspace string `protobuf:"bytes,6,opt,name=base_keyspace,json=baseKeyspace,proto3" json:"base_keyspace,omitempty"`
	// snapshot_time (in UTC) is a property of snapshot
	// keyspaces which tells us what point in time
	// the snapshot is of
	SnapshotTime         *vttime.Time `protobuf:"bytes,7,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Keyspace) Reset()         { *m = Keyspace{} }
func (m *Keyspace) String() string { return proto.CompactTextString(m) }
func (*Keyspace) ProtoMessage()    {}
func (*Keyspace) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{4}
}

func (m *Keyspace) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Keyspace.Unmarshal(m, b)
}
func (m *Keyspace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Keyspace.Marshal(b, m, deterministic)
}
func (m *Keyspace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Keyspace.Merge(m, src)
}
func (m *Keyspace) XXX_Size() int {
	return xxx_messageInfo_Keyspace.Size(m)
}
func (m *Keyspace) XXX_DiscardUnknown() {
	xxx_messageInfo_Keyspace.DiscardUnknown(m)
}

var xxx_messageInfo_Keyspace proto.InternalMessageInfo

func (m *Keyspace) GetShardingColumnName() string {
	if m != nil {
		return m.ShardingColumnName
	}
	return ""
}

func (m *Keyspace) GetShardingColumnType() KeyspaceIdType {
	if m != nil {
		return m.ShardingColumnType
	}
	return KeyspaceIdType_UNSET
}

func (m *Keyspace) GetServedFroms() []*Keyspace_ServedFrom {
	if m != nil {
		return m.ServedFroms
	}
	return nil
}

func (m *Keyspace) GetKeyspaceType() KeyspaceType {
	if m != nil {
		return m.KeyspaceType
	}
	return KeyspaceType_NORMAL
}

func (m *Keyspace) GetBaseKeyspace() string {
	if m != nil {
		return m.BaseKeyspace
	}
	return ""
}

func (m *Keyspace) GetSnapshotTime() *vttime.Time {
	if m != nil {
		return m.SnapshotTime
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type Keyspace_ServedFrom struct {
	// the tablet type (key for the map)
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the cells to limit this to
	Cells []string `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	// the keyspace name that's serving it
	Keyspace             string   `protobuf:"bytes,3,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Keyspace_ServedFrom) Reset()         { *m = Keyspace_ServedFrom{} }
func (m *Keyspace_ServedFrom) String() string { return proto.CompactTextString(m) }
func (*Keyspace_ServedFrom) ProtoMessage()    {}
func (*Keyspace_ServedFrom) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{4, 0}
}

func (m *Keyspace_ServedFrom) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Keyspace_ServedFrom.Unmarshal(m, b)
}
func (m *Keyspace_ServedFrom) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Keyspace_ServedFrom.Marshal(b, m, deterministic)
}
func (m *Keyspace_ServedFrom) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Keyspace_ServedFrom.Merge(m, src)
}
func (m *Keyspace_ServedFrom) XXX_Size() int {
	return xxx_messageInfo_Keyspace_ServedFrom.Size(m)
}
func (m *Keyspace_ServedFrom) XXX_DiscardUnknown() {
	xxx_messageInfo_Keyspace_ServedFrom.DiscardUnknown(m)
}

var xxx_messageInfo_Keyspace_ServedFrom proto.InternalMessageInfo

func (m *Keyspace_ServedFrom) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *Keyspace_ServedFrom) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

func (m *Keyspace_ServedFrom) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

// ShardReplication describes the MySQL replication relationships
// whithin a cell.
type ShardReplication struct {
	// Note there can be only one Node in this array
	// for a given tablet.
	Nodes                []*ShardReplication_Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ShardReplication) Reset()         { *m = ShardReplication{} }
func (m *ShardReplication) String() string { return proto.CompactTextString(m) }
func (*ShardReplication) ProtoMessage()    {}
func (*ShardReplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{5}
}

func (m *ShardReplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardReplication.Unmarshal(m, b)
}
func (m *ShardReplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardReplication.Marshal(b, m, deterministic)
}
func (m *ShardReplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardReplication.Merge(m, src)
}
func (m *ShardReplication) XXX_Size() int {
	return xxx_messageInfo_ShardReplication.Size(m)
}
func (m *ShardReplication) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardReplication.DiscardUnknown(m)
}

var xxx_messageInfo_ShardReplication proto.InternalMessageInfo

func (m *ShardReplication) GetNodes() []*ShardReplication_Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// Node describes a tablet instance within the cell
type ShardReplication_Node struct {
	TabletAlias          *TabletAlias `protobuf:"bytes,1,opt,name=tablet_alias,json=tabletAlias,proto3" json:"tablet_alias,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ShardReplication_Node) Reset()         { *m = ShardReplication_Node{} }
func (m *ShardReplication_Node) String() string { return proto.CompactTextString(m) }
func (*ShardReplication_Node) ProtoMessage()    {}
func (*ShardReplication_Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{5, 0}
}

func (m *ShardReplication_Node) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardReplication_Node.Unmarshal(m, b)
}
func (m *ShardReplication_Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardReplication_Node.Marshal(b, m, deterministic)
}
func (m *ShardReplication_Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardReplication_Node.Merge(m, src)
}
func (m *ShardReplication_Node) XXX_Size() int {
	return xxx_messageInfo_ShardReplication_Node.Size(m)
}
func (m *ShardReplication_Node) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardReplication_Node.DiscardUnknown(m)
}

var xxx_messageInfo_ShardReplication_Node proto.InternalMessageInfo

func (m *ShardReplication_Node) GetTabletAlias() *TabletAlias {
	if m != nil {
		return m.TabletAlias
	}
	return nil
}

// ShardReference is used as a pointer from a SrvKeyspace to a Shard
type ShardReference struct {
	// Copied from Shard.
	Name                 string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	KeyRange             *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ShardReference) Reset()         { *m = ShardReference{} }
func (m *ShardReference) String() string { return proto.CompactTextString(m) }
func (*ShardReference) ProtoMessage()    {}
func (*ShardReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{6}
}

func (m *ShardReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardReference.Unmarshal(m, b)
}
func (m *ShardReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardReference.Marshal(b, m, deterministic)
}
func (m *ShardReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardReference.Merge(m, src)
}
func (m *ShardReference) XXX_Size() int {
	return xxx_messageInfo_ShardReference.Size(m)
}
func (m *ShardReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardReference.DiscardUnknown(m)
}

var xxx_messageInfo_ShardReference proto.InternalMessageInfo

func (m *ShardReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ShardReference) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// ShardTabletControl is used as a pointer from a SrvKeyspace to a Shard
type ShardTabletControl struct {
	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// Disable query serving in this shard
	QueryServiceDisabled bool     `protobuf:"varint,3,opt,name=query_service_disabled,json=queryServiceDisabled,proto3" json:"query_service_disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShardTabletControl) Reset()         { *m = ShardTabletControl{} }
func (m *ShardTabletControl) String() string { return proto.CompactTextString(m) }
func (*ShardTabletControl) ProtoMessage()    {}
func (*ShardTabletControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{7}
}

func (m *ShardTabletControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardTabletControl.Unmarshal(m, b)
}
func (m *ShardTabletControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardTabletControl.Marshal(b, m, deterministic)
}
func (m *ShardTabletControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardTabletControl.Merge(m, src)
}
func (m *ShardTabletControl) XXX_Size() int {
	return xxx_messageInfo_ShardTabletControl.Size(m)
}
func (m *ShardTabletControl) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardTabletControl.DiscardUnknown(m)
}

var xxx_messageInfo_ShardTabletControl proto.InternalMessageInfo

func (m *ShardTabletControl) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ShardTabletControl) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *ShardTabletControl) GetQueryServiceDisabled() bool {
	if m != nil {
		return m.QueryServiceDisabled
	}
	return false
}

// SrvKeyspace is a rollup node for the keyspace itself.
type SrvKeyspace struct {
	// The partitions this keyspace is serving, per tablet type.
	Partitions []*SrvKeyspace_KeyspacePartition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// copied from Keyspace
	ShardingColumnName   string                    `protobuf:"bytes,2,opt,name=sharding_column_name,json=shardingColumnName,proto3" json:"sharding_column_name,omitempty"`
	ShardingColumnType   KeyspaceIdType            `protobuf:"varint,3,opt,name=sharding_column_type,json=shardingColumnType,proto3,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	ServedFrom           []*SrvKeyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_from,json=servedFrom,proto3" json:"served_from,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SrvKeyspace) Reset()         { *m = SrvKeyspace{} }
func (m *SrvKeyspace) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace) ProtoMessage()    {}
func (*SrvKeyspace) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{8}
}

func (m *SrvKeyspace) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SrvKeyspace.Unmarshal(m, b)
}
func (m *SrvKeyspace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SrvKeyspace.Marshal(b, m, deterministic)
}
func (m *SrvKeyspace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SrvKeyspace.Merge(m, src)
}
func (m *SrvKeyspace) XXX_Size() int {
	return xxx_messageInfo_SrvKeyspace.Size(m)
}
func (m *SrvKeyspace) XXX_DiscardUnknown() {
	xxx_messageInfo_SrvKeyspace.DiscardUnknown(m)
}

var xxx_messageInfo_SrvKeyspace proto.InternalMessageInfo

func (m *SrvKeyspace) GetPartitions() []*SrvKeyspace_KeyspacePartition {
	if m != nil {
		return m.Partitions
	}
	return nil
}

func (m *SrvKeyspace) GetShardingColumnName() string {
	if m != nil {
		return m.ShardingColumnName
	}
	return ""
}

func (m *SrvKeyspace) GetShardingColumnType() KeyspaceIdType {
	if m != nil {
		return m.ShardingColumnType
	}
	return KeyspaceIdType_UNSET
}

func (m *SrvKeyspace) GetServedFrom() []*SrvKeyspace_ServedFrom {
	if m != nil {
		return m.ServedFrom
	}
	return nil
}

type SrvKeyspace_KeyspacePartition struct {
	// The type this partition applies to.
	ServedType TabletType `protobuf:"varint,1,opt,name=served_type,json=servedType,proto3,enum=topodata.TabletType" json:"served_type,omitempty"`
	// List of non-overlapping continuous shards sorted by range.
	ShardReferences []*ShardReference `protobuf:"bytes,2,rep,name=shard_references,json=shardReferences,proto3" json:"shard_references,omitempty"`
	// List of shard tablet controls
	ShardTabletControls  []*ShardTabletControl `protobuf:"bytes,3,rep,name=shard_tablet_controls,json=shardTabletControls,proto3" json:"shard_tablet_controls,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SrvKeyspace_KeyspacePartition) Reset()         { *m = SrvKeyspace_KeyspacePartition{} }
func (m *SrvKeyspace_KeyspacePartition) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace_KeyspacePartition) ProtoMessage()    {}
func (*SrvKeyspace_KeyspacePartition) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{8, 0}
}

func (m *SrvKeyspace_KeyspacePartition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SrvKeyspace_KeyspacePartition.Unmarshal(m, b)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SrvKeyspace_KeyspacePartition.Marshal(b, m, deterministic)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SrvKeyspace_KeyspacePartition.Merge(m, src)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_Size() int {
	return xxx_messageInfo_SrvKeyspace_KeyspacePartition.Size(m)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_DiscardUnknown() {
	xxx_messageInfo_SrvKeyspace_KeyspacePartition.DiscardUnknown(m)
}

var xxx_messageInfo_SrvKeyspace_KeyspacePartition proto.InternalMessageInfo

func (m *SrvKeyspace_KeyspacePartition) GetServedType() TabletType {
	if m != nil {
		return m.ServedType
	}
	return TabletType_UNKNOWN
}

func (m *SrvKeyspace_KeyspacePartition) GetShardReferences() []*ShardReference {
	if m != nil {
		return m.ShardReferences
	}
	return nil
}

func (m *SrvKeyspace_KeyspacePartition) GetShardTabletControls() []*ShardTabletControl {
	if m != nil {
		return m.ShardTabletControls
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type SrvKeyspace_ServedFrom struct {
	// the tablet type
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the keyspace name that's serving it
	Keyspace             string   `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SrvKeyspace_ServedFrom) Reset()         { *m = SrvKeyspace_ServedFrom{} }
func (m *SrvKeyspace_ServedFrom) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace_ServedFrom) ProtoMessage()    {}
func (*SrvKeyspace_ServedFrom) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{8, 1}
}

func (m *SrvKeyspace_ServedFrom) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SrvKeyspace_ServedFrom.Unmarshal(m, b)
}
func (m *SrvKeyspace_ServedFrom) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SrvKeyspace_ServedFrom.Marshal(b, m, deterministic)
}
func (m *SrvKeyspace_ServedFrom) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SrvKeyspace_ServedFrom.Merge(m, src)
}
func (m *SrvKeyspace_ServedFrom) XXX_Size() int {
	return xxx_messageInfo_SrvKeyspace_ServedFrom.Size(m)
}
func (m *SrvKeyspace_ServedFrom) XXX_DiscardUnknown() {
	xxx_messageInfo_SrvKeyspace_ServedFrom.DiscardUnknown(m)
}

var xxx_messageInfo_SrvKeyspace_ServedFrom proto.InternalMessageInfo

func (m *SrvKeyspace_ServedFrom) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *SrvKeyspace_ServedFrom) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

// CellInfo contains information about a cell. CellInfo objects are
// stored in the global topology server, and describe how to reach
// local topology servers.
type CellInfo struct {
	// ServerAddress contains the address of the server for the cell.
	// The syntax of this field is topology implementation specific.
	// For instance, for Zookeeper, it is a comma-separated list of
	// server addresses.
	ServerAddress string `protobuf:"bytes,1,opt,name=server_address,json=serverAddress,proto3" json:"server_address,omitempty"`
	// Root is the path to store data in. It is only used when talking
	// to server_address.
	Root                 string   `protobuf:"bytes,2,opt,name=root,proto3" json:"root,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CellInfo) Reset()         { *m = CellInfo{} }
func (m *CellInfo) String() string { return proto.CompactTextString(m) }
func (*CellInfo) ProtoMessage()    {}
func (*CellInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{9}
}

func (m *CellInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CellInfo.Unmarshal(m, b)
}
func (m *CellInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CellInfo.Marshal(b, m, deterministic)
}
func (m *CellInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CellInfo.Merge(m, src)
}
func (m *CellInfo) XXX_Size() int {
	return xxx_messageInfo_CellInfo.Size(m)
}
func (m *CellInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CellInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CellInfo proto.InternalMessageInfo

func (m *CellInfo) GetServerAddress() string {
	if m != nil {
		return m.ServerAddress
	}
	return ""
}

func (m *CellInfo) GetRoot() string {
	if m != nil {
		return m.Root
	}
	return ""
}

// CellsAlias
type CellsAlias struct {
	// Cells that map to this alias
	Cells                []string `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CellsAlias) Reset()         { *m = CellsAlias{} }
func (m *CellsAlias) String() string { return proto.CompactTextString(m) }
func (*CellsAlias) ProtoMessage()    {}
func (*CellsAlias) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{10}
}

func (m *CellsAlias) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CellsAlias.Unmarshal(m, b)
}
func (m *CellsAlias) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CellsAlias.Marshal(b, m, deterministic)
}
func (m *CellsAlias) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CellsAlias.Merge(m, src)
}
func (m *CellsAlias) XXX_Size() int {
	return xxx_messageInfo_CellsAlias.Size(m)
}
func (m *CellsAlias) XXX_DiscardUnknown() {
	xxx_messageInfo_CellsAlias.DiscardUnknown(m)
}

var xxx_messageInfo_CellsAlias proto.InternalMessageInfo

func (m *CellsAlias) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

func init() {
	proto.RegisterEnum("topodata.KeyspaceType", KeyspaceType_name, KeyspaceType_value)
	proto.RegisterEnum("topodata.KeyspaceIdType", KeyspaceIdType_name, KeyspaceIdType_value)
	proto.RegisterEnum("topodata.TabletType", TabletType_name, TabletType_value)
	proto.RegisterType((*KeyRange)(nil), "topodata.KeyRange")
	proto.RegisterType((*TabletAlias)(nil), "topodata.TabletAlias")
	proto.RegisterType((*Tablet)(nil), "topodata.Tablet")
	proto.RegisterMapType((map[string]int32)(nil), "topodata.Tablet.PortMapEntry")
	proto.RegisterMapType((map[string]string)(nil), "topodata.Tablet.TagsEntry")
	proto.RegisterType((*Shard)(nil), "topodata.Shard")
	proto.RegisterType((*Shard_ServedType)(nil), "topodata.Shard.ServedType")
	proto.RegisterType((*Shard_SourceShard)(nil), "topodata.Shard.SourceShard")
	proto.RegisterType((*Shard_TabletControl)(nil), "topodata.Shard.TabletControl")
	proto.RegisterType((*Keyspace)(nil), "topodata.Keyspace")
	proto.RegisterType((*Keyspace_ServedFrom)(nil), "topodata.Keyspace.ServedFrom")
	proto.RegisterType((*ShardReplication)(nil), "topodata.ShardReplication")
	proto.RegisterType((*ShardReplication_Node)(nil), "topodata.ShardReplication.Node")
	proto.RegisterType((*ShardReference)(nil), "topodata.ShardReference")
	proto.RegisterType((*ShardTabletControl)(nil), "topodata.ShardTabletControl")
	proto.RegisterType((*SrvKeyspace)(nil), "topodata.SrvKeyspace")
	proto.RegisterType((*SrvKeyspace_KeyspacePartition)(nil), "topodata.SrvKeyspace.KeyspacePartition")
	proto.RegisterType((*SrvKeyspace_ServedFrom)(nil), "topodata.SrvKeyspace.ServedFrom")
	proto.RegisterType((*CellInfo)(nil), "topodata.CellInfo")
	proto.RegisterType((*CellsAlias)(nil), "topodata.CellsAlias")
}

func init() { proto.RegisterFile("topodata.proto", fileDescriptor_52c350cb619f972e) }

var fileDescriptor_52c350cb619f972e = []byte{
	// 1349 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xcf, 0x6e, 0xdb, 0x46,
	0x13, 0x0f, 0xf5, 0xcf, 0xd4, 0x88, 0x92, 0x99, 0x8d, 0x63, 0x10, 0xfa, 0xbe, 0xa0, 0x86, 0x8a,
	0xa0, 0x82, 0x8b, 0xca, 0xad, 0x93, 0xb4, 0x46, 0x8a, 0x02, 0x51, 0x64, 0xa5, 0x71, 0x6c, 0xcb,
	0xc2, 0x4a, 0x46, 0x9b, 0x5e, 0x08, 0x5a, 0x5a, 0x3b, 0x84, 0x25, 0x52, 0xd9, 0x5d, 0x0b, 0x50,
	0x5f, 0xa1, 0x87, 0xf6, 0xdc, 0x37, 0xe8, 0xfb, 0xf4, 0xd8, 0x4b, 0xfb, 0x1c, 0x3d, 0x14, 0x3b,
	0x4b, 0x52, 0x94, 0x14, 0xa7, 0x4e, 0xe1, 0xdb, 0xcc, 0xec, 0xcc, 0x70, 0xe6, 0xb7, 0xbf, 0x99,
	0x95, 0xa0, 0x22, 0xc3, 0x49, 0x38, 0xf4, 0xa4, 0xd7, 0x98, 0xf0, 0x50, 0x86, 0xc4, 0x8c, 0xf5,
	0xaa, 0x35, 0x95, 0xd2, 0x1f, 0x33, 0x6d, 0xaf, 0xed, 0x82, 0x79, 0xc8, 0x66, 0xd4, 0x0b, 0x2e,
	0x18, 0xd9, 0x80, 0xbc, 0x90, 0x1e, 0x97, 0x8e, 0xb1, 0x65, 0xd4, 0x2d, 0xaa, 0x15, 0x62, 0x43,
	0x96, 0x05, 0x43, 0x27, 0x83, 0x36, 0x25, 0xd6, 0x1e, 0x41, 0xa9, 0xef, 0x9d, 0x8d, 0x98, 0x6c,
	0x8e, 0x7c, 0x4f, 0x10, 0x02, 0xb9, 0x01, 0x1b, 0x8d, 0x30, 0xaa, 0x48, 0x51, 0x56, 0x41, 0x57,
	0xbe, 0x0e, 0x2a, 0x53, 0x25, 0xd6, 0xfe, 0xce, 0x41, 0x41, 0x47, 0x91, 0x4f, 0x21, 0xef, 0xa9,
	0x48, 0x8c, 0x28, 0xed, 0xde, 0x6f, 0x24, 0xb5, 0xa6, 0xd2, 0x52, 0xed, 0x43, 0xaa, 0x60, 0xbe,
	0x09, 0x85, 0x0c, 0xbc, 0x31, 0xc3, 0x74, 0x45, 0x9a, 0xe8, 0x64, 0x0f, 0xcc, 0x49, 0xc8, 0xa5,
	0x3b, 0xf6, 0x26, 0x4e, 0x6e, 0x2b, 0x5b, 0x2f, 0xed, 0x3e, 0x58, 0xce, 0xd5, 0xe8, 0x86, 0x5c,
	0x1e, 0x7b, 0x93, 0x76, 0x20, 0xf9, 0x8c, 0xae, 0x4d, 0xb4, 0xa6, 0xb2, 0x5e, 0xb2, 0x99, 0x98,
	0x78, 0x03, 0xe6, 0xe4, 0x75, 0xd6, 0x58, 0x47, 0x18, 0xde, 0x78, 0x7c, 0xe8, 0x14, 0xf0, 0x40,
	0x2b, 0x64, 0x07, 0x8a, 0x97, 0x6c, 0xe6, 0x72, 0x85, 0x94, 0xb3, 0x86, 0x85, 0x93, 0xf9, 0xc7,
	0x62, 0x0c, 0x31, 0x8d, 0x46, 0xb3, 0x0e, 0x39, 0x39, 0x9b, 0x30, 0xc7, 0xdc, 0x32, 0xea, 0x95,
	0xdd, 0x8d, 0xe5, 0xc2, 0xfa, 0xb3, 0x09, 0xa3, 0xe8, 0x41, 0xea, 0x60, 0x0f, 0xcf, 0x5c, 0xd5,
	0x91, 0x1b, 0x4e, 0x19, 0xe7, 0xfe, 0x90, 0x39, 0x45, 0xfc, 0x76, 0x65, 0x78, 0xd6, 0xf1, 0xc6,
	0xec, 0x24, 0xb2, 0x92, 0x06, 0xe4, 0xa4, 0x77, 0x21, 0x1c, 0xc0, 0x66, 0xab, 0x2b, 0xcd, 0xf6,
	0xbd, 0x0b, 0xa1, 0x3b, 0x45, 0x3f, 0xf2, 0x10, 0x2a, 0xe3, 0x99, 0x78, 0x3b, 0x72, 0x13, 0x08,
	0x2d, 0xcc, 0x5b, 0x46, 0xeb, 0xcb, 0x18, 0xc7, 0x07, 0x00, 0xda, 0x4d, 0xc1, 0xe3, 0x94, 0xb7,
	0x8c, 0x7a, 0x9e, 0x16, 0xd1, 0xa2, 0xd0, 0x23, 0x4d, 0xd8, 0x1c, 0x7b, 0x42, 0x32, 0xee, 0x4a,
	0xc6, 0xc7, 0x2e, 0xd2, 0xc2, 0x55, 0x1c, 0x72, 0x2a, 0x88, 0x83, 0xd5, 0x88, 0x28, 0xd5, 0xf7,
	0xc7, 0x8c, 0xde, 0xd3, 0xbe, 0x7d, 0xc6, 0xc7, 0x3d, 0xe5, 0xa9, 0x8c, 0xd5, 0xa7, 0x60, 0xa5,
	0x2f, 0x42, 0xf1, 0xe3, 0x92, 0xcd, 0x22, 0xca, 0x28, 0x51, 0xa1, 0x3e, 0xf5, 0x46, 0x57, 0xfa,
	0x92, 0xf3, 0x54, 0x2b, 0x4f, 0x33, 0x7b, 0x46, 0xf5, 0x2b, 0x28, 0x26, 0x7d, 0xfd, 0x5b, 0x60,
	0x31, 0x15, 0xf8, 0x2a, 0x67, 0x66, 0xed, 0xdc, 0xab, 0x9c, 0x59, 0xb2, 0xad, 0xda, 0xef, 0x05,
	0xc8, 0xf7, 0xf0, 0x22, 0xf7, 0xc0, 0x8a, 0xba, 0xb9, 0x01, 0x09, 0x4b, 0xda, 0x55, 0x13, 0xfd,
	0x7a, 0x1c, 0xcc, 0x1b, 0xe2, 0xb0, 0xc8, 0xa2, 0xcc, 0x0d, 0x58, 0xf4, 0x0d, 0x58, 0x82, 0xf1,
	0x29, 0x1b, 0xba, 0x8a, 0x2a, 0xc2, 0xc9, 0x2e, 0xdf, 0x3c, 0x36, 0xd5, 0xe8, 0xa1, 0x0f, 0x72,
	0xaa, 0x24, 0x12, 0x59, 0x90, 0x67, 0x50, 0x16, 0xe1, 0x15, 0x1f, 0x30, 0x17, 0x59, 0x2c, 0xa2,
	0x31, 0xf9, 0xdf, 0x4a, 0x3c, 0x3a, 0xa1, 0x4c, 0x2d, 0x31, 0x57, 0x04, 0x79, 0x01, 0xeb, 0x12,
	0x01, 0x71, 0x07, 0x61, 0x20, 0x79, 0x38, 0x12, 0x4e, 0x61, 0x79, 0xd4, 0x74, 0x0e, 0x8d, 0x5b,
	0x4b, 0x7b, 0xd1, 0x8a, 0x4c, 0xab, 0x82, 0x6c, 0xc3, 0x5d, 0x5f, 0xb8, 0x11, 0x7e, 0xaa, 0x44,
	0x3f, 0xb8, 0xc0, 0x39, 0x32, 0xe9, 0xba, 0x2f, 0x8e, 0xd1, 0xde, 0xd3, 0xe6, 0xea, 0x6b, 0x80,
	0x79, 0x43, 0xe4, 0x09, 0x94, 0xa2, 0x0a, 0x70, 0x9e, 0x8c, 0xf7, 0xcc, 0x13, 0xc8, 0x44, 0x56,
	0xbc, 0x50, 0xab, 0x48, 0x38, 0x99, 0xad, 0xac, 0xe2, 0x05, 0x2a, 0xd5, 0x5f, 0x0d, 0x28, 0xa5,
	0x9a, 0x8d, 0x17, 0x95, 0x91, 0x2c, 0xaa, 0x85, 0xd5, 0x90, 0xb9, 0x6e, 0x35, 0x64, 0xaf, 0x5d,
	0x0d, 0xb9, 0x1b, 0x5c, 0xea, 0x26, 0x14, 0xb0, 0x50, 0xe1, 0xe4, 0xb1, 0xb6, 0x48, 0xab, 0xfe,
	0x66, 0x40, 0x79, 0x01, 0xc5, 0x5b, 0xed, 0x9d, 0x7c, 0x06, 0xe4, 0x6c, 0xe4, 0x0d, 0x2e, 0x47,
	0xbe, 0x90, 0x8a, 0x50, 0xba, 0x84, 0x1c, 0xba, 0xdc, 0x4d, 0x9d, 0x60, 0x52, 0xa1, 0xaa, 0x3c,
	0xe7, 0xe1, 0x8f, 0x2c, 0xc0, 0x0d, 0x69, 0xd2, 0x48, 0x4b, 0xc6, 0x2a, 0x6f, 0x17, 0x6a, 0x7f,
	0x64, 0xf1, 0xfd, 0xd0, 0xe8, 0x7c, 0x0e, 0x1b, 0x08, 0x88, 0x1f, 0x5c, 0xb8, 0x83, 0x70, 0x74,
	0x35, 0x0e, 0x70, 0xa9, 0x45, 0xc3, 0x4a, 0xe2, 0xb3, 0x16, 0x1e, 0xa9, 0xbd, 0x46, 0x5e, 0xad,
	0x46, 0x60, 0x9f, 0x19, 0xec, 0xd3, 0x59, 0x00, 0x11, 0xbf, 0x71, 0xa0, 0x39, 0xbe, 0x94, 0x0b,
	0x7b, 0x7e, 0x96, 0x4c, 0xca, 0x39, 0x0f, 0xc7, 0x62, 0xf5, 0x41, 0x88, 0x73, 0x44, 0xc3, 0xf2,
	0x82, 0x87, 0xe3, 0x78, 0x58, 0x94, 0x2c, 0xc8, 0xd7, 0x50, 0x8e, 0x6f, 0x5a, 0x97, 0x91, 0xc7,
	0x32, 0x36, 0x57, 0x53, 0x60, 0x11, 0xd6, 0x65, 0x4a, 0x23, 0x1f, 0x43, 0xf9, 0xcc, 0x13, 0xcc,
	0x4d, 0xb8, 0xa3, 0x5f, 0x0f, 0x4b, 0x19, 0x13, 0x84, 0xbe, 0x80, 0xb2, 0x08, 0xbc, 0x89, 0x78,
	0x13, 0x46, 0x8b, 0x63, 0xed, 0x1d, 0x8b, 0xc3, 0x8a, 0x5d, 0x70, 0x73, 0x5e, 0xc5, 0xb3, 0xa0,
	0x6a, 0xbc, 0x5d, 0x3e, 0xa4, 0x99, 0x9e, 0x5d, 0x64, 0xba, 0xbe, 0xe4, 0xda, 0x4f, 0x06, 0xd8,
	0x7a, 0x29, 0xb0, 0xc9, 0xc8, 0x1f, 0x78, 0xd2, 0x0f, 0x03, 0xf2, 0x04, 0xf2, 0x41, 0x38, 0x64,
	0x6a, 0x73, 0x2a, 0x84, 0x3f, 0x5a, 0xda, 0x03, 0x29, 0xd7, 0x46, 0x27, 0x1c, 0x32, 0xaa, 0xbd,
	0xab, 0xcf, 0x20, 0xa7, 0x54, 0xb5, 0x7f, 0xa3, 0x16, 0x6e, 0xb2, 0x7f, 0xe5, 0x5c, 0xa9, 0x9d,
	0x42, 0x25, 0xfa, 0xc2, 0x39, 0xe3, 0x2c, 0x18, 0x30, 0xf5, 0xd3, 0x23, 0xc5, 0x30, 0x94, 0x3f,
	0x78, 0xc5, 0xd6, 0x7e, 0x36, 0x80, 0x60, 0xde, 0xc5, 0xd1, 0xbb, 0x8d, 0xdc, 0xe4, 0x31, 0x6c,
	0xbe, 0xbd, 0x62, 0x7c, 0xa6, 0x37, 0xde, 0x80, 0xb9, 0x43, 0x5f, 0xa8, 0xaf, 0xe8, 0x0d, 0x62,
	0xd2, 0x0d, 0x3c, 0xed, 0xe9, 0xc3, 0xfd, 0xe8, 0xac, 0xf6, 0x57, 0x0e, 0x4a, 0x3d, 0x3e, 0x4d,
	0x68, 0xf3, 0x2d, 0xc0, 0xc4, 0xe3, 0xd2, 0x57, 0x98, 0xc6, 0xb0, 0x7f, 0x92, 0x82, 0x7d, 0xee,
	0x9a, 0x30, 0xb4, 0x1b, 0xfb, 0xd3, 0x54, 0xe8, 0xb5, 0x13, 0x9a, 0xf9, 0xe0, 0x09, 0xcd, 0xfe,
	0x87, 0x09, 0x6d, 0x42, 0x29, 0x35, 0xa1, 0xd1, 0x80, 0x6e, 0xbd, 0xbb, 0x8f, 0xd4, 0x8c, 0xc2,
	0x7c, 0x46, 0xab, 0x7f, 0x1a, 0x70, 0x77, 0xa5, 0x45, 0x35, 0x15, 0xa9, 0x47, 0xf2, 0xfd, 0x53,
	0x31, 0x7f, 0x1d, 0x49, 0x0b, 0x6c, 0xac, 0xd2, 0xe5, 0x31, 0xa1, 0xf4, 0x80, 0x94, 0xd2, 0x7d,
	0x2d, 0x32, 0x8e, 0xae, 0x8b, 0x05, 0x5d, 0x90, 0x2e, 0xdc, 0xd7, 0x49, 0x96, 0x5f, 0x49, 0xfd,
	0x52, 0xff, 0x7f, 0x29, 0xd3, 0xe2, 0x23, 0x79, 0x4f, 0xac, 0xd8, 0x44, 0xd5, 0xbd, 0x8d, 0x89,
	0x7f, 0xcf, 0x2b, 0x16, 0xad, 0xee, 0x43, 0x30, 0x5b, 0x6c, 0x34, 0x3a, 0x08, 0xce, 0x43, 0xf5,
	0x3b, 0x11, 0x71, 0xe1, 0xae, 0x37, 0x1c, 0x72, 0x26, 0x44, 0xc4, 0xfa, 0xb2, 0xb6, 0x36, 0xb5,
	0x51, 0x8d, 0x04, 0x0f, 0x43, 0x19, 0x25, 0x44, 0x39, 0x5a, 0x14, 0x35, 0x00, 0x95, 0x4c, 0xe8,
	0x1f, 0x4a, 0xef, 0x5c, 0x37, 0xdb, 0x75, 0xb0, 0xd2, 0xfb, 0x93, 0x00, 0x14, 0x3a, 0x27, 0xf4,
	0xb8, 0x79, 0x64, 0xdf, 0x21, 0x16, 0x98, 0xbd, 0x4e, 0xb3, 0xdb, 0x7b, 0x79, 0xd2, 0xb7, 0x8d,
	0xed, 0x5d, 0xa8, 0x2c, 0xd2, 0x89, 0x14, 0x21, 0x7f, 0xda, 0xe9, 0xb5, 0xfb, 0xf6, 0x1d, 0x15,
	0x76, 0x7a, 0xd0, 0xe9, 0x7f, 0xf9, 0xd8, 0x36, 0x94, 0xf9, 0xf9, 0xeb, 0x7e, 0xbb, 0x67, 0x67,
	0xb6, 0x7f, 0x31, 0x00, 0xe6, 0x58, 0x90, 0x12, 0xac, 0x9d, 0x76, 0x0e, 0x3b, 0x27, 0xdf, 0x75,
	0x74, 0xc8, 0x71, 0xb3, 0xd7, 0x6f, 0x53, 0xdb, 0x50, 0x07, 0xb4, 0xdd, 0x3d, 0x3a, 0x68, 0x35,
	0xed, 0x8c, 0x3a, 0xa0, 0xfb, 0x27, 0x9d, 0xa3, 0xd7, 0x76, 0x16, 0x73, 0x35, 0xfb, 0xad, 0x97,
	0x5a, 0xec, 0x75, 0x9b, 0xb4, 0x6d, 0xe7, 0x88, 0x0d, 0x56, 0xfb, 0xfb, 0x6e, 0x9b, 0x1e, 0x1c,
	0xb7, 0x3b, 0xfd, 0xe6, 0x91, 0x9d, 0x57, 0x31, 0xcf, 0x9b, 0xad, 0xc3, 0xd3, 0xae, 0x5d, 0xd0,
	0xc9, 0x7a, 0xfd, 0x13, 0xda, 0xb6, 0xd7, 0x94, 0xb2, 0x4f, 0x9b, 0x07, 0x9d, 0xf6, 0xbe, 0x6d,
	0x56, 0x33, 0xb6, 0xf1, 0x7c, 0x0f, 0xd6, 0xfd, 0xb0, 0x31, 0xf5, 0x25, 0x13, 0x42, 0xff, 0xdd,
	0xfa, 0xe1, 0x61, 0xa4, 0xf9, 0xe1, 0x8e, 0x96, 0x76, 0x2e, 0xc2, 0x9d, 0xa9, 0xdc, 0xc1, 0xd3,
	0x9d, 0xf8, 0x52, 0xcf, 0x0a, 0xa8, 0x3f, 0xfa, 0x27, 0x00, 0x00, 0xff, 0xff, 0x51, 0xac, 0x2b,
	0xc1, 0xc6, 0x0d, 0x00, 0x00,
}
