// Code generated by protoc-gen-go. DO NOT EDIT.
// source: binlogdata.proto

package binlogdata

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
	query "vitess.io/vitess/go/vt/proto/query"
	topodata "vitess.io/vitess/go/vt/proto/topodata"
	vtrpc "vitess.io/vitess/go/vt/proto/vtrpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// OnDDLAction lists the possible actions for DDLs.
type OnDDLAction int32

const (
	OnDDLAction_IGNORE      OnDDLAction = 0
	OnDDLAction_STOP        OnDDLAction = 1
	OnDDLAction_EXEC        OnDDLAction = 2
	OnDDLAction_EXEC_IGNORE OnDDLAction = 3
)

var OnDDLAction_name = map[int32]string{
	0: "IGNORE",
	1: "STOP",
	2: "EXEC",
	3: "EXEC_IGNORE",
}

var OnDDLAction_value = map[string]int32{
	"IGNORE":      0,
	"STOP":        1,
	"EXEC":        2,
	"EXEC_IGNORE": 3,
}

func (x OnDDLAction) String() string {
	return proto.EnumName(OnDDLAction_name, int32(x))
}

func (OnDDLAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{0}
}

// VEventType enumerates the event types.
// This list is comprehensive. Many of these types
// will not be encountered in RBR mode.
type VEventType int32

const (
	VEventType_UNKNOWN   VEventType = 0
	VEventType_GTID      VEventType = 1
	VEventType_BEGIN     VEventType = 2
	VEventType_COMMIT    VEventType = 3
	VEventType_ROLLBACK  VEventType = 4
	VEventType_DDL       VEventType = 5
	VEventType_INSERT    VEventType = 6
	VEventType_REPLACE   VEventType = 7
	VEventType_UPDATE    VEventType = 8
	VEventType_DELETE    VEventType = 9
	VEventType_SET       VEventType = 10
	VEventType_OTHER     VEventType = 11
	VEventType_ROW       VEventType = 12
	VEventType_FIELD     VEventType = 13
	VEventType_HEARTBEAT VEventType = 14
	VEventType_VGTID     VEventType = 15
	VEventType_JOURNAL   VEventType = 16
)

var VEventType_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "GTID",
	2:  "BEGIN",
	3:  "COMMIT",
	4:  "ROLLBACK",
	5:  "DDL",
	6:  "INSERT",
	7:  "REPLACE",
	8:  "UPDATE",
	9:  "DELETE",
	10: "SET",
	11: "OTHER",
	12: "ROW",
	13: "FIELD",
	14: "HEARTBEAT",
	15: "VGTID",
	16: "JOURNAL",
}

var VEventType_value = map[string]int32{
	"UNKNOWN":   0,
	"GTID":      1,
	"BEGIN":     2,
	"COMMIT":    3,
	"ROLLBACK":  4,
	"DDL":       5,
	"INSERT":    6,
	"REPLACE":   7,
	"UPDATE":    8,
	"DELETE":    9,
	"SET":       10,
	"OTHER":     11,
	"ROW":       12,
	"FIELD":     13,
	"HEARTBEAT": 14,
	"VGTID":     15,
	"JOURNAL":   16,
}

func (x VEventType) String() string {
	return proto.EnumName(VEventType_name, int32(x))
}

func (VEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1}
}

// MigrationType specifies the type of migration for the Journal.
type MigrationType int32

const (
	MigrationType_TABLES MigrationType = 0
	MigrationType_SHARDS MigrationType = 1
)

var MigrationType_name = map[int32]string{
	0: "TABLES",
	1: "SHARDS",
}

var MigrationType_value = map[string]int32{
	"TABLES": 0,
	"SHARDS": 1,
}

func (x MigrationType) String() string {
	return proto.EnumName(MigrationType_name, int32(x))
}

func (MigrationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{2}
}

type BinlogTransaction_Statement_Category int32

const (
	BinlogTransaction_Statement_BL_UNRECOGNIZED BinlogTransaction_Statement_Category = 0
	BinlogTransaction_Statement_BL_BEGIN        BinlogTransaction_Statement_Category = 1
	BinlogTransaction_Statement_BL_COMMIT       BinlogTransaction_Statement_Category = 2
	BinlogTransaction_Statement_BL_ROLLBACK     BinlogTransaction_Statement_Category = 3
	// BL_DML is deprecated.
	BinlogTransaction_Statement_BL_DML_DEPRECATED BinlogTransaction_Statement_Category = 4
	BinlogTransaction_Statement_BL_DDL            BinlogTransaction_Statement_Category = 5
	BinlogTransaction_Statement_BL_SET            BinlogTransaction_Statement_Category = 6
	BinlogTransaction_Statement_BL_INSERT         BinlogTransaction_Statement_Category = 7
	BinlogTransaction_Statement_BL_UPDATE         BinlogTransaction_Statement_Category = 8
	BinlogTransaction_Statement_BL_DELETE         BinlogTransaction_Statement_Category = 9
)

var BinlogTransaction_Statement_Category_name = map[int32]string{
	0: "BL_UNRECOGNIZED",
	1: "BL_BEGIN",
	2: "BL_COMMIT",
	3: "BL_ROLLBACK",
	4: "BL_DML_DEPRECATED",
	5: "BL_DDL",
	6: "BL_SET",
	7: "BL_INSERT",
	8: "BL_UPDATE",
	9: "BL_DELETE",
}

var BinlogTransaction_Statement_Category_value = map[string]int32{
	"BL_UNRECOGNIZED":   0,
	"BL_BEGIN":          1,
	"BL_COMMIT":         2,
	"BL_ROLLBACK":       3,
	"BL_DML_DEPRECATED": 4,
	"BL_DDL":            5,
	"BL_SET":            6,
	"BL_INSERT":         7,
	"BL_UPDATE":         8,
	"BL_DELETE":         9,
}

func (x BinlogTransaction_Statement_Category) String() string {
	return proto.EnumName(BinlogTransaction_Statement_Category_name, int32(x))
}

func (BinlogTransaction_Statement_Category) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1, 0, 0}
}

type Filter_FieldEventMode int32

const (
	Filter_ERR_ON_MISMATCH Filter_FieldEventMode = 0
	Filter_BEST_EFFORT     Filter_FieldEventMode = 1
)

var Filter_FieldEventMode_name = map[int32]string{
	0: "ERR_ON_MISMATCH",
	1: "BEST_EFFORT",
}

var Filter_FieldEventMode_value = map[string]int32{
	"ERR_ON_MISMATCH": 0,
	"BEST_EFFORT":     1,
}

func (x Filter_FieldEventMode) String() string {
	return proto.EnumName(Filter_FieldEventMode_name, int32(x))
}

func (Filter_FieldEventMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{7, 0}
}

// Charset is the per-statement charset info from a QUERY_EVENT binlog entry.
type Charset struct {
	// @@session.character_set_client
	Client int32 `protobuf:"varint,1,opt,name=client,proto3" json:"client,omitempty"`
	// @@session.collation_connection
	Conn int32 `protobuf:"varint,2,opt,name=conn,proto3" json:"conn,omitempty"`
	// @@session.collation_server
	Server               int32    `protobuf:"varint,3,opt,name=server,proto3" json:"server,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Charset) Reset()         { *m = Charset{} }
func (m *Charset) String() string { return proto.CompactTextString(m) }
func (*Charset) ProtoMessage()    {}
func (*Charset) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{0}
}

func (m *Charset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Charset.Unmarshal(m, b)
}
func (m *Charset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Charset.Marshal(b, m, deterministic)
}
func (m *Charset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Charset.Merge(m, src)
}
func (m *Charset) XXX_Size() int {
	return xxx_messageInfo_Charset.Size(m)
}
func (m *Charset) XXX_DiscardUnknown() {
	xxx_messageInfo_Charset.DiscardUnknown(m)
}

var xxx_messageInfo_Charset proto.InternalMessageInfo

func (m *Charset) GetClient() int32 {
	if m != nil {
		return m.Client
	}
	return 0
}

func (m *Charset) GetConn() int32 {
	if m != nil {
		return m.Conn
	}
	return 0
}

func (m *Charset) GetServer() int32 {
	if m != nil {
		return m.Server
	}
	return 0
}

// BinlogTransaction describes a transaction inside the binlogs.
// It is streamed by vttablet for filtered replication, used during resharding.
type BinlogTransaction struct {
	// the statements in this transaction
	Statements []*BinlogTransaction_Statement `protobuf:"bytes,1,rep,name=statements,proto3" json:"statements,omitempty"`
	// The Event Token for this event.
	EventToken           *query.EventToken `protobuf:"bytes,4,opt,name=event_token,json=eventToken,proto3" json:"event_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BinlogTransaction) Reset()         { *m = BinlogTransaction{} }
func (m *BinlogTransaction) String() string { return proto.CompactTextString(m) }
func (*BinlogTransaction) ProtoMessage()    {}
func (*BinlogTransaction) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1}
}

func (m *BinlogTransaction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinlogTransaction.Unmarshal(m, b)
}
func (m *BinlogTransaction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinlogTransaction.Marshal(b, m, deterministic)
}
func (m *BinlogTransaction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinlogTransaction.Merge(m, src)
}
func (m *BinlogTransaction) XXX_Size() int {
	return xxx_messageInfo_BinlogTransaction.Size(m)
}
func (m *BinlogTransaction) XXX_DiscardUnknown() {
	xxx_messageInfo_BinlogTransaction.DiscardUnknown(m)
}

var xxx_messageInfo_BinlogTransaction proto.InternalMessageInfo

func (m *BinlogTransaction) GetStatements() []*BinlogTransaction_Statement {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *BinlogTransaction) GetEventToken() *query.EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

type BinlogTransaction_Statement struct {
	// what type of statement is this?
	Category BinlogTransaction_Statement_Category `protobuf:"varint,1,opt,name=category,proto3,enum=binlogdata.BinlogTransaction_Statement_Category" json:"category,omitempty"`
	// charset of this statement, if different from pre-negotiated default.
	Charset *Charset `protobuf:"bytes,2,opt,name=charset,proto3" json:"charset,omitempty"`
	// the sql
	Sql                  []byte   `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BinlogTransaction_Statement) Reset()         { *m = BinlogTransaction_Statement{} }
func (m *BinlogTransaction_Statement) String() string { return proto.CompactTextString(m) }
func (*BinlogTransaction_Statement) ProtoMessage()    {}
func (*BinlogTransaction_Statement) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1, 0}
}

func (m *BinlogTransaction_Statement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinlogTransaction_Statement.Unmarshal(m, b)
}
func (m *BinlogTransaction_Statement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinlogTransaction_Statement.Marshal(b, m, deterministic)
}
func (m *BinlogTransaction_Statement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinlogTransaction_Statement.Merge(m, src)
}
func (m *BinlogTransaction_Statement) XXX_Size() int {
	return xxx_messageInfo_BinlogTransaction_Statement.Size(m)
}
func (m *BinlogTransaction_Statement) XXX_DiscardUnknown() {
	xxx_messageInfo_BinlogTransaction_Statement.DiscardUnknown(m)
}

var xxx_messageInfo_BinlogTransaction_Statement proto.InternalMessageInfo

func (m *BinlogTransaction_Statement) GetCategory() BinlogTransaction_Statement_Category {
	if m != nil {
		return m.Category
	}
	return BinlogTransaction_Statement_BL_UNRECOGNIZED
}

func (m *BinlogTransaction_Statement) GetCharset() *Charset {
	if m != nil {
		return m.Charset
	}
	return nil
}

func (m *BinlogTransaction_Statement) GetSql() []byte {
	if m != nil {
		return m.Sql
	}
	return nil
}

// StreamKeyRangeRequest is the payload to StreamKeyRange
type StreamKeyRangeRequest struct {
	// where to start
	Position string `protobuf:"bytes,1,opt,name=position,proto3" json:"position,omitempty"`
	// what to get
	KeyRange *topodata.KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// default charset on the player side
	Charset              *Charset `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamKeyRangeRequest) Reset()         { *m = StreamKeyRangeRequest{} }
func (m *StreamKeyRangeRequest) String() string { return proto.CompactTextString(m) }
func (*StreamKeyRangeRequest) ProtoMessage()    {}
func (*StreamKeyRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{2}
}

func (m *StreamKeyRangeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamKeyRangeRequest.Unmarshal(m, b)
}
func (m *StreamKeyRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamKeyRangeRequest.Marshal(b, m, deterministic)
}
func (m *StreamKeyRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamKeyRangeRequest.Merge(m, src)
}
func (m *StreamKeyRangeRequest) XXX_Size() int {
	return xxx_messageInfo_StreamKeyRangeRequest.Size(m)
}
func (m *StreamKeyRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamKeyRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamKeyRangeRequest proto.InternalMessageInfo

func (m *StreamKeyRangeRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *StreamKeyRangeRequest) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *StreamKeyRangeRequest) GetCharset() *Charset {
	if m != nil {
		return m.Charset
	}
	return nil
}

// StreamKeyRangeResponse is the response from StreamKeyRange
type StreamKeyRangeResponse struct {
	BinlogTransaction    *BinlogTransaction `protobuf:"bytes,1,opt,name=binlog_transaction,json=binlogTransaction,proto3" json:"binlog_transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamKeyRangeResponse) Reset()         { *m = StreamKeyRangeResponse{} }
func (m *StreamKeyRangeResponse) String() string { return proto.CompactTextString(m) }
func (*StreamKeyRangeResponse) ProtoMessage()    {}
func (*StreamKeyRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{3}
}

func (m *StreamKeyRangeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamKeyRangeResponse.Unmarshal(m, b)
}
func (m *StreamKeyRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamKeyRangeResponse.Marshal(b, m, deterministic)
}
func (m *StreamKeyRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamKeyRangeResponse.Merge(m, src)
}
func (m *StreamKeyRangeResponse) XXX_Size() int {
	return xxx_messageInfo_StreamKeyRangeResponse.Size(m)
}
func (m *StreamKeyRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamKeyRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamKeyRangeResponse proto.InternalMessageInfo

func (m *StreamKeyRangeResponse) GetBinlogTransaction() *BinlogTransaction {
	if m != nil {
		return m.BinlogTransaction
	}
	return nil
}

// StreamTablesRequest is the payload to StreamTables
type StreamTablesRequest struct {
	// where to start
	Position string `protobuf:"bytes,1,opt,name=position,proto3" json:"position,omitempty"`
	// what to get
	Tables []string `protobuf:"bytes,2,rep,name=tables,proto3" json:"tables,omitempty"`
	// default charset on the player side
	Charset              *Charset `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamTablesRequest) Reset()         { *m = StreamTablesRequest{} }
func (m *StreamTablesRequest) String() string { return proto.CompactTextString(m) }
func (*StreamTablesRequest) ProtoMessage()    {}
func (*StreamTablesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{4}
}

func (m *StreamTablesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamTablesRequest.Unmarshal(m, b)
}
func (m *StreamTablesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamTablesRequest.Marshal(b, m, deterministic)
}
func (m *StreamTablesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamTablesRequest.Merge(m, src)
}
func (m *StreamTablesRequest) XXX_Size() int {
	return xxx_messageInfo_StreamTablesRequest.Size(m)
}
func (m *StreamTablesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamTablesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamTablesRequest proto.InternalMessageInfo

func (m *StreamTablesRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *StreamTablesRequest) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *StreamTablesRequest) GetCharset() *Charset {
	if m != nil {
		return m.Charset
	}
	return nil
}

// StreamTablesResponse is the response from StreamTables
type StreamTablesResponse struct {
	BinlogTransaction    *BinlogTransaction `protobuf:"bytes,1,opt,name=binlog_transaction,json=binlogTransaction,proto3" json:"binlog_transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamTablesResponse) Reset()         { *m = StreamTablesResponse{} }
func (m *StreamTablesResponse) String() string { return proto.CompactTextString(m) }
func (*StreamTablesResponse) ProtoMessage()    {}
func (*StreamTablesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{5}
}

func (m *StreamTablesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamTablesResponse.Unmarshal(m, b)
}
func (m *StreamTablesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamTablesResponse.Marshal(b, m, deterministic)
}
func (m *StreamTablesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamTablesResponse.Merge(m, src)
}
func (m *StreamTablesResponse) XXX_Size() int {
	return xxx_messageInfo_StreamTablesResponse.Size(m)
}
func (m *StreamTablesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamTablesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamTablesResponse proto.InternalMessageInfo

func (m *StreamTablesResponse) GetBinlogTransaction() *BinlogTransaction {
	if m != nil {
		return m.BinlogTransaction
	}
	return nil
}

// Rule represents one rule.
type Rule struct {
	// match can be a table name or a regular expression
	// delineated by '/' and '/'.
	Match string `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// filter can be an empty string or keyrange if the match
	// is a regular expression. Otherwise, it must be a select
	// query.
	Filter               string   `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Rule) Reset()         { *m = Rule{} }
func (m *Rule) String() string { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()    {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{6}
}

func (m *Rule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Rule.Unmarshal(m, b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
}
func (m *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(m, src)
}
func (m *Rule) XXX_Size() int {
	return xxx_messageInfo_Rule.Size(m)
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

func (m *Rule) GetMatch() string {
	if m != nil {
		return m.Match
	}
	return ""
}

func (m *Rule) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Filter represents a list of ordered rules. First match
// wins.
type Filter struct {
	Rules                []*Rule               `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	FieldEventMode       Filter_FieldEventMode `protobuf:"varint,2,opt,name=fieldEventMode,proto3,enum=binlogdata.Filter_FieldEventMode" json:"fieldEventMode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{7}
}

func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetRules() []*Rule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *Filter) GetFieldEventMode() Filter_FieldEventMode {
	if m != nil {
		return m.FieldEventMode
	}
	return Filter_ERR_ON_MISMATCH
}

// BinlogSource specifies the source  and filter parameters for
// Filtered Replication. It currently supports a keyrange
// or a list of tables.
type BinlogSource struct {
	// the source keyspace
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	// the source tablet type
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// key_range is set if the request is for a keyrange
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// tables is set if the request is for a list of tables
	Tables []string `protobuf:"bytes,5,rep,name=tables,proto3" json:"tables,omitempty"`
	// filter is set if we're using the generalized representation
	// for the filter.
	Filter *Filter `protobuf:"bytes,6,opt,name=filter,proto3" json:"filter,omitempty"`
	// on_ddl specifies the action to be taken when a DDL is encountered.
	OnDdl                OnDDLAction `protobuf:"varint,7,opt,name=on_ddl,json=onDdl,proto3,enum=binlogdata.OnDDLAction" json:"on_ddl,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BinlogSource) Reset()         { *m = BinlogSource{} }
func (m *BinlogSource) String() string { return proto.CompactTextString(m) }
func (*BinlogSource) ProtoMessage()    {}
func (*BinlogSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{8}
}

func (m *BinlogSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinlogSource.Unmarshal(m, b)
}
func (m *BinlogSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinlogSource.Marshal(b, m, deterministic)
}
func (m *BinlogSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinlogSource.Merge(m, src)
}
func (m *BinlogSource) XXX_Size() int {
	return xxx_messageInfo_BinlogSource.Size(m)
}
func (m *BinlogSource) XXX_DiscardUnknown() {
	xxx_messageInfo_BinlogSource.DiscardUnknown(m)
}

var xxx_messageInfo_BinlogSource proto.InternalMessageInfo

func (m *BinlogSource) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *BinlogSource) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *BinlogSource) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *BinlogSource) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *BinlogSource) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *BinlogSource) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *BinlogSource) GetOnDdl() OnDDLAction {
	if m != nil {
		return m.OnDdl
	}
	return OnDDLAction_IGNORE
}

// RowChange represents one row change
type RowChange struct {
	Before               *query.Row `protobuf:"bytes,1,opt,name=before,proto3" json:"before,omitempty"`
	After                *query.Row `protobuf:"bytes,2,opt,name=after,proto3" json:"after,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *RowChange) Reset()         { *m = RowChange{} }
func (m *RowChange) String() string { return proto.CompactTextString(m) }
func (*RowChange) ProtoMessage()    {}
func (*RowChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{9}
}

func (m *RowChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowChange.Unmarshal(m, b)
}
func (m *RowChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowChange.Marshal(b, m, deterministic)
}
func (m *RowChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowChange.Merge(m, src)
}
func (m *RowChange) XXX_Size() int {
	return xxx_messageInfo_RowChange.Size(m)
}
func (m *RowChange) XXX_DiscardUnknown() {
	xxx_messageInfo_RowChange.DiscardUnknown(m)
}

var xxx_messageInfo_RowChange proto.InternalMessageInfo

func (m *RowChange) GetBefore() *query.Row {
	if m != nil {
		return m.Before
	}
	return nil
}

func (m *RowChange) GetAfter() *query.Row {
	if m != nil {
		return m.After
	}
	return nil
}

// RowEvent represent row events for one table
type RowEvent struct {
	TableName            string       `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	RowChanges           []*RowChange `protobuf:"bytes,2,rep,name=row_changes,json=rowChanges,proto3" json:"row_changes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *RowEvent) Reset()         { *m = RowEvent{} }
func (m *RowEvent) String() string { return proto.CompactTextString(m) }
func (*RowEvent) ProtoMessage()    {}
func (*RowEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{10}
}

func (m *RowEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowEvent.Unmarshal(m, b)
}
func (m *RowEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowEvent.Marshal(b, m, deterministic)
}
func (m *RowEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowEvent.Merge(m, src)
}
func (m *RowEvent) XXX_Size() int {
	return xxx_messageInfo_RowEvent.Size(m)
}
func (m *RowEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_RowEvent.DiscardUnknown(m)
}

var xxx_messageInfo_RowEvent proto.InternalMessageInfo

func (m *RowEvent) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *RowEvent) GetRowChanges() []*RowChange {
	if m != nil {
		return m.RowChanges
	}
	return nil
}

type FieldEvent struct {
	TableName            string         `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	Fields               []*query.Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FieldEvent) Reset()         { *m = FieldEvent{} }
func (m *FieldEvent) String() string { return proto.CompactTextString(m) }
func (*FieldEvent) ProtoMessage()    {}
func (*FieldEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{11}
}

func (m *FieldEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FieldEvent.Unmarshal(m, b)
}
func (m *FieldEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FieldEvent.Marshal(b, m, deterministic)
}
func (m *FieldEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FieldEvent.Merge(m, src)
}
func (m *FieldEvent) XXX_Size() int {
	return xxx_messageInfo_FieldEvent.Size(m)
}
func (m *FieldEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_FieldEvent.DiscardUnknown(m)
}

var xxx_messageInfo_FieldEvent proto.InternalMessageInfo

func (m *FieldEvent) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *FieldEvent) GetFields() []*query.Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

type ShardGtid struct {
	Keyspace             string   `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard                string   `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	Gtid                 string   `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShardGtid) Reset()         { *m = ShardGtid{} }
func (m *ShardGtid) String() string { return proto.CompactTextString(m) }
func (*ShardGtid) ProtoMessage()    {}
func (*ShardGtid) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{12}
}

func (m *ShardGtid) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardGtid.Unmarshal(m, b)
}
func (m *ShardGtid) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardGtid.Marshal(b, m, deterministic)
}
func (m *ShardGtid) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardGtid.Merge(m, src)
}
func (m *ShardGtid) XXX_Size() int {
	return xxx_messageInfo_ShardGtid.Size(m)
}
func (m *ShardGtid) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardGtid.DiscardUnknown(m)
}

var xxx_messageInfo_ShardGtid proto.InternalMessageInfo

func (m *ShardGtid) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ShardGtid) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *ShardGtid) GetGtid() string {
	if m != nil {
		return m.Gtid
	}
	return ""
}

type VGtid struct {
	ShardGtids           []*ShardGtid `protobuf:"bytes,1,rep,name=shard_gtids,json=shardGtids,proto3" json:"shard_gtids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *VGtid) Reset()         { *m = VGtid{} }
func (m *VGtid) String() string { return proto.CompactTextString(m) }
func (*VGtid) ProtoMessage()    {}
func (*VGtid) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{13}
}

func (m *VGtid) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VGtid.Unmarshal(m, b)
}
func (m *VGtid) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VGtid.Marshal(b, m, deterministic)
}
func (m *VGtid) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VGtid.Merge(m, src)
}
func (m *VGtid) XXX_Size() int {
	return xxx_messageInfo_VGtid.Size(m)
}
func (m *VGtid) XXX_DiscardUnknown() {
	xxx_messageInfo_VGtid.DiscardUnknown(m)
}

var xxx_messageInfo_VGtid proto.InternalMessageInfo

func (m *VGtid) GetShardGtids() []*ShardGtid {
	if m != nil {
		return m.ShardGtids
	}
	return nil
}

type KeyspaceShard struct {
	Keyspace             string   `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard                string   `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyspaceShard) Reset()         { *m = KeyspaceShard{} }
func (m *KeyspaceShard) String() string { return proto.CompactTextString(m) }
func (*KeyspaceShard) ProtoMessage()    {}
func (*KeyspaceShard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{14}
}

func (m *KeyspaceShard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyspaceShard.Unmarshal(m, b)
}
func (m *KeyspaceShard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyspaceShard.Marshal(b, m, deterministic)
}
func (m *KeyspaceShard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyspaceShard.Merge(m, src)
}
func (m *KeyspaceShard) XXX_Size() int {
	return xxx_messageInfo_KeyspaceShard.Size(m)
}
func (m *KeyspaceShard) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyspaceShard.DiscardUnknown(m)
}

var xxx_messageInfo_KeyspaceShard proto.InternalMessageInfo

func (m *KeyspaceShard) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *KeyspaceShard) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

type Journal struct {
	Id                   int64            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	MigrationType        MigrationType    `protobuf:"varint,2,opt,name=migration_type,json=migrationType,proto3,enum=binlogdata.MigrationType" json:"migration_type,omitempty"`
	Tables               []string         `protobuf:"bytes,3,rep,name=tables,proto3" json:"tables,omitempty"`
	LocalPosition        string           `protobuf:"bytes,4,opt,name=local_position,json=localPosition,proto3" json:"local_position,omitempty"`
	ShardGtids           []*ShardGtid     `protobuf:"bytes,5,rep,name=shard_gtids,json=shardGtids,proto3" json:"shard_gtids,omitempty"`
	Participants         []*KeyspaceShard `protobuf:"bytes,6,rep,name=participants,proto3" json:"participants,omitempty"`
	ReversedIds          []int64          `protobuf:"varint,7,rep,packed,name=reversed_ids,json=reversedIds,proto3" json:"reversed_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Journal) Reset()         { *m = Journal{} }
func (m *Journal) String() string { return proto.CompactTextString(m) }
func (*Journal) ProtoMessage()    {}
func (*Journal) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{15}
}

func (m *Journal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Journal.Unmarshal(m, b)
}
func (m *Journal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Journal.Marshal(b, m, deterministic)
}
func (m *Journal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Journal.Merge(m, src)
}
func (m *Journal) XXX_Size() int {
	return xxx_messageInfo_Journal.Size(m)
}
func (m *Journal) XXX_DiscardUnknown() {
	xxx_messageInfo_Journal.DiscardUnknown(m)
}

var xxx_messageInfo_Journal proto.InternalMessageInfo

func (m *Journal) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Journal) GetMigrationType() MigrationType {
	if m != nil {
		return m.MigrationType
	}
	return MigrationType_TABLES
}

func (m *Journal) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *Journal) GetLocalPosition() string {
	if m != nil {
		return m.LocalPosition
	}
	return ""
}

func (m *Journal) GetShardGtids() []*ShardGtid {
	if m != nil {
		return m.ShardGtids
	}
	return nil
}

func (m *Journal) GetParticipants() []*KeyspaceShard {
	if m != nil {
		return m.Participants
	}
	return nil
}

func (m *Journal) GetReversedIds() []int64 {
	if m != nil {
		return m.ReversedIds
	}
	return nil
}

// VEvent represents a vstream event
type VEvent struct {
	Type       VEventType  `protobuf:"varint,1,opt,name=type,proto3,enum=binlogdata.VEventType" json:"type,omitempty"`
	Timestamp  int64       `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Gtid       string      `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Ddl        string      `protobuf:"bytes,4,opt,name=ddl,proto3" json:"ddl,omitempty"`
	RowEvent   *RowEvent   `protobuf:"bytes,5,opt,name=row_event,json=rowEvent,proto3" json:"row_event,omitempty"`
	FieldEvent *FieldEvent `protobuf:"bytes,6,opt,name=field_event,json=fieldEvent,proto3" json:"field_event,omitempty"`
	Vgtid      *VGtid      `protobuf:"bytes,7,opt,name=vgtid,proto3" json:"vgtid,omitempty"`
	Journal    *Journal    `protobuf:"bytes,8,opt,name=journal,proto3" json:"journal,omitempty"`
	// current_time specifies the current time to handle clock skew.
	CurrentTime          int64    `protobuf:"varint,20,opt,name=current_time,json=currentTime,proto3" json:"current_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VEvent) Reset()         { *m = VEvent{} }
func (m *VEvent) String() string { return proto.CompactTextString(m) }
func (*VEvent) ProtoMessage()    {}
func (*VEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{16}
}

func (m *VEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VEvent.Unmarshal(m, b)
}
func (m *VEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VEvent.Marshal(b, m, deterministic)
}
func (m *VEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VEvent.Merge(m, src)
}
func (m *VEvent) XXX_Size() int {
	return xxx_messageInfo_VEvent.Size(m)
}
func (m *VEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_VEvent.DiscardUnknown(m)
}

var xxx_messageInfo_VEvent proto.InternalMessageInfo

func (m *VEvent) GetType() VEventType {
	if m != nil {
		return m.Type
	}
	return VEventType_UNKNOWN
}

func (m *VEvent) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *VEvent) GetGtid() string {
	if m != nil {
		return m.Gtid
	}
	return ""
}

func (m *VEvent) GetDdl() string {
	if m != nil {
		return m.Ddl
	}
	return ""
}

func (m *VEvent) GetRowEvent() *RowEvent {
	if m != nil {
		return m.RowEvent
	}
	return nil
}

func (m *VEvent) GetFieldEvent() *FieldEvent {
	if m != nil {
		return m.FieldEvent
	}
	return nil
}

func (m *VEvent) GetVgtid() *VGtid {
	if m != nil {
		return m.Vgtid
	}
	return nil
}

func (m *VEvent) GetJournal() *Journal {
	if m != nil {
		return m.Journal
	}
	return nil
}

func (m *VEvent) GetCurrentTime() int64 {
	if m != nil {
		return m.CurrentTime
	}
	return 0
}

// VStreamRequest is the payload for VStream
type VStreamRequest struct {
	EffectiveCallerId    *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Position             string                `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
	Filter               *Filter               `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VStreamRequest) Reset()         { *m = VStreamRequest{} }
func (m *VStreamRequest) String() string { return proto.CompactTextString(m) }
func (*VStreamRequest) ProtoMessage()    {}
func (*VStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{17}
}

func (m *VStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamRequest.Unmarshal(m, b)
}
func (m *VStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamRequest.Marshal(b, m, deterministic)
}
func (m *VStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamRequest.Merge(m, src)
}
func (m *VStreamRequest) XXX_Size() int {
	return xxx_messageInfo_VStreamRequest.Size(m)
}
func (m *VStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamRequest proto.InternalMessageInfo

func (m *VStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *VStreamRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *VStreamRequest) GetTarget() *query.Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *VStreamRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *VStreamRequest) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// VStreamResponse is the response from VStream
type VStreamResponse struct {
	Events               []*VEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *VStreamResponse) Reset()         { *m = VStreamResponse{} }
func (m *VStreamResponse) String() string { return proto.CompactTextString(m) }
func (*VStreamResponse) ProtoMessage()    {}
func (*VStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{18}
}

func (m *VStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamResponse.Unmarshal(m, b)
}
func (m *VStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamResponse.Marshal(b, m, deterministic)
}
func (m *VStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamResponse.Merge(m, src)
}
func (m *VStreamResponse) XXX_Size() int {
	return xxx_messageInfo_VStreamResponse.Size(m)
}
func (m *VStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamResponse proto.InternalMessageInfo

func (m *VStreamResponse) GetEvents() []*VEvent {
	if m != nil {
		return m.Events
	}
	return nil
}

// VStreamRowsRequest is the payload for VStreamRows
type VStreamRowsRequest struct {
	EffectiveCallerId    *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query                string                `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	Lastpk               *query.QueryResult    `protobuf:"bytes,5,opt,name=lastpk,proto3" json:"lastpk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VStreamRowsRequest) Reset()         { *m = VStreamRowsRequest{} }
func (m *VStreamRowsRequest) String() string { return proto.CompactTextString(m) }
func (*VStreamRowsRequest) ProtoMessage()    {}
func (*VStreamRowsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{19}
}

func (m *VStreamRowsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamRowsRequest.Unmarshal(m, b)
}
func (m *VStreamRowsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamRowsRequest.Marshal(b, m, deterministic)
}
func (m *VStreamRowsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamRowsRequest.Merge(m, src)
}
func (m *VStreamRowsRequest) XXX_Size() int {
	return xxx_messageInfo_VStreamRowsRequest.Size(m)
}
func (m *VStreamRowsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamRowsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamRowsRequest proto.InternalMessageInfo

func (m *VStreamRowsRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *VStreamRowsRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *VStreamRowsRequest) GetTarget() *query.Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *VStreamRowsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *VStreamRowsRequest) GetLastpk() *query.QueryResult {
	if m != nil {
		return m.Lastpk
	}
	return nil
}

// VStreamRowsResponse is the response from VStreamRows
type VStreamRowsResponse struct {
	Fields               []*query.Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	Pkfields             []*query.Field `protobuf:"bytes,2,rep,name=pkfields,proto3" json:"pkfields,omitempty"`
	Gtid                 string         `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Rows                 []*query.Row   `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
	Lastpk               *query.Row     `protobuf:"bytes,5,opt,name=lastpk,proto3" json:"lastpk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VStreamRowsResponse) Reset()         { *m = VStreamRowsResponse{} }
func (m *VStreamRowsResponse) String() string { return proto.CompactTextString(m) }
func (*VStreamRowsResponse) ProtoMessage()    {}
func (*VStreamRowsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{20}
}

func (m *VStreamRowsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamRowsResponse.Unmarshal(m, b)
}
func (m *VStreamRowsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamRowsResponse.Marshal(b, m, deterministic)
}
func (m *VStreamRowsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamRowsResponse.Merge(m, src)
}
func (m *VStreamRowsResponse) XXX_Size() int {
	return xxx_messageInfo_VStreamRowsResponse.Size(m)
}
func (m *VStreamRowsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamRowsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamRowsResponse proto.InternalMessageInfo

func (m *VStreamRowsResponse) GetFields() []*query.Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *VStreamRowsResponse) GetPkfields() []*query.Field {
	if m != nil {
		return m.Pkfields
	}
	return nil
}

func (m *VStreamRowsResponse) GetGtid() string {
	if m != nil {
		return m.Gtid
	}
	return ""
}

func (m *VStreamRowsResponse) GetRows() []*query.Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *VStreamRowsResponse) GetLastpk() *query.Row {
	if m != nil {
		return m.Lastpk
	}
	return nil
}

func init() {
	proto.RegisterEnum("binlogdata.OnDDLAction", OnDDLAction_name, OnDDLAction_value)
	proto.RegisterEnum("binlogdata.VEventType", VEventType_name, VEventType_value)
	proto.RegisterEnum("binlogdata.MigrationType", MigrationType_name, MigrationType_value)
	proto.RegisterEnum("binlogdata.BinlogTransaction_Statement_Category", BinlogTransaction_Statement_Category_name, BinlogTransaction_Statement_Category_value)
	proto.RegisterEnum("binlogdata.Filter_FieldEventMode", Filter_FieldEventMode_name, Filter_FieldEventMode_value)
	proto.RegisterType((*Charset)(nil), "binlogdata.Charset")
	proto.RegisterType((*BinlogTransaction)(nil), "binlogdata.BinlogTransaction")
	proto.RegisterType((*BinlogTransaction_Statement)(nil), "binlogdata.BinlogTransaction.Statement")
	proto.RegisterType((*StreamKeyRangeRequest)(nil), "binlogdata.StreamKeyRangeRequest")
	proto.RegisterType((*StreamKeyRangeResponse)(nil), "binlogdata.StreamKeyRangeResponse")
	proto.RegisterType((*StreamTablesRequest)(nil), "binlogdata.StreamTablesRequest")
	proto.RegisterType((*StreamTablesResponse)(nil), "binlogdata.StreamTablesResponse")
	proto.RegisterType((*Rule)(nil), "binlogdata.Rule")
	proto.RegisterType((*Filter)(nil), "binlogdata.Filter")
	proto.RegisterType((*BinlogSource)(nil), "binlogdata.BinlogSource")
	proto.RegisterType((*RowChange)(nil), "binlogdata.RowChange")
	proto.RegisterType((*RowEvent)(nil), "binlogdata.RowEvent")
	proto.RegisterType((*FieldEvent)(nil), "binlogdata.FieldEvent")
	proto.RegisterType((*ShardGtid)(nil), "binlogdata.ShardGtid")
	proto.RegisterType((*VGtid)(nil), "binlogdata.VGtid")
	proto.RegisterType((*KeyspaceShard)(nil), "binlogdata.KeyspaceShard")
	proto.RegisterType((*Journal)(nil), "binlogdata.Journal")
	proto.RegisterType((*VEvent)(nil), "binlogdata.VEvent")
	proto.RegisterType((*VStreamRequest)(nil), "binlogdata.VStreamRequest")
	proto.RegisterType((*VStreamResponse)(nil), "binlogdata.VStreamResponse")
	proto.RegisterType((*VStreamRowsRequest)(nil), "binlogdata.VStreamRowsRequest")
	proto.RegisterType((*VStreamRowsResponse)(nil), "binlogdata.VStreamRowsResponse")
}

func init() { proto.RegisterFile("binlogdata.proto", fileDescriptor_5fd02bcb2e350dad) }

var fileDescriptor_5fd02bcb2e350dad = []byte{
	// 1620 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x57, 0x4d, 0x73, 0xf3, 0x48,
	0x11, 0x8e, 0x2d, 0xf9, 0xab, 0x95, 0x38, 0xca, 0xe4, 0x03, 0x93, 0x62, 0xa9, 0xac, 0x8a, 0x25,
	0x21, 0x55, 0x38, 0x60, 0xe0, 0xe5, 0xb4, 0x2c, 0xfe, 0x50, 0x12, 0x27, 0xb2, 0x9d, 0x77, 0xac,
	0x64, 0xa9, 0xbd, 0xa8, 0x14, 0x6b, 0x92, 0x88, 0xc8, 0x92, 0x5f, 0x69, 0xec, 0x90, 0x1f, 0x40,
	0xf1, 0x03, 0xb8, 0xf2, 0x07, 0x38, 0xc3, 0x95, 0x2b, 0x77, 0x7e, 0x01, 0x27, 0xfe, 0x07, 0x35,
	0x1f, 0x92, 0xad, 0x64, 0xd9, 0x37, 0x4b, 0x15, 0x07, 0x2e, 0xaa, 0x9e, 0x9e, 0xee, 0x9e, 0x9e,
	0x67, 0x9e, 0xee, 0xd1, 0x80, 0x7e, 0xeb, 0x87, 0x41, 0x74, 0xef, 0xb9, 0xd4, 0x6d, 0xce, 0xe2,
	0x88, 0x46, 0x08, 0x96, 0x9a, 0x7d, 0x6d, 0x41, 0xe3, 0xd9, 0x44, 0x4c, 0xec, 0x6b, 0x1f, 0xe6,
	0x24, 0x7e, 0x96, 0x83, 0x3a, 0x8d, 0x66, 0xd1, 0xd2, 0xcb, 0x18, 0x40, 0xa5, 0xfb, 0xe0, 0xc6,
	0x09, 0xa1, 0x68, 0x0f, 0xca, 0x93, 0xc0, 0x27, 0x21, 0x6d, 0x14, 0x0e, 0x0a, 0x47, 0x25, 0x2c,
	0x47, 0x08, 0x81, 0x3a, 0x89, 0xc2, 0xb0, 0x51, 0xe4, 0x5a, 0x2e, 0x33, 0xdb, 0x84, 0xc4, 0x0b,
	0x12, 0x37, 0x14, 0x61, 0x2b, 0x46, 0xc6, 0xbf, 0x14, 0xd8, 0xea, 0xf0, 0x3c, 0xec, 0xd8, 0x0d,
	0x13, 0x77, 0x42, 0xfd, 0x28, 0x44, 0x67, 0x00, 0x09, 0x75, 0x29, 0x99, 0x92, 0x90, 0x26, 0x8d,
	0xc2, 0x81, 0x72, 0xa4, 0xb5, 0x0e, 0x9b, 0x2b, 0x3b, 0x78, 0xe5, 0xd2, 0x1c, 0xa7, 0xf6, 0x78,
	0xc5, 0x15, 0xb5, 0x40, 0x23, 0x0b, 0x12, 0x52, 0x87, 0x46, 0x8f, 0x24, 0x6c, 0xa8, 0x07, 0x85,
	0x23, 0xad, 0xb5, 0xd5, 0x14, 0x1b, 0x34, 0xd9, 0x8c, 0xcd, 0x26, 0x30, 0x90, 0x4c, 0xde, 0xff,
	0x7b, 0x11, 0x6a, 0x59, 0x34, 0x64, 0x41, 0x75, 0xe2, 0x52, 0x72, 0x1f, 0xc5, 0xcf, 0x7c, 0x9b,
	0xf5, 0xd6, 0x4f, 0xde, 0x98, 0x48, 0xb3, 0x2b, 0xfd, 0x70, 0x16, 0x01, 0xfd, 0x18, 0x2a, 0x13,
	0x81, 0x1e, 0x47, 0x47, 0x6b, 0x6d, 0xaf, 0x06, 0x93, 0xc0, 0xe2, 0xd4, 0x06, 0xe9, 0xa0, 0x24,
	0x1f, 0x02, 0x0e, 0xd9, 0x3a, 0x66, 0xa2, 0xf1, 0xe7, 0x02, 0x54, 0xd3, 0xb8, 0x68, 0x1b, 0x36,
	0x3b, 0x96, 0x73, 0x3d, 0xc4, 0x66, 0x77, 0x74, 0x36, 0xec, 0x7f, 0x65, 0xf6, 0xf4, 0x35, 0xb4,
	0x0e, 0xd5, 0x8e, 0xe5, 0x74, 0xcc, 0xb3, 0xfe, 0x50, 0x2f, 0xa0, 0x0d, 0xa8, 0x75, 0x2c, 0xa7,
	0x3b, 0x1a, 0x0c, 0xfa, 0xb6, 0x5e, 0x44, 0x9b, 0xa0, 0x75, 0x2c, 0x07, 0x8f, 0x2c, 0xab, 0xd3,
	0xee, 0x5e, 0xea, 0x0a, 0xda, 0x85, 0xad, 0x8e, 0xe5, 0xf4, 0x06, 0x96, 0xd3, 0x33, 0xaf, 0xb0,
	0xd9, 0x6d, 0xdb, 0x66, 0x4f, 0x57, 0x11, 0x40, 0x99, 0xa9, 0x7b, 0x96, 0x5e, 0x92, 0xf2, 0xd8,
	0xb4, 0xf5, 0xb2, 0x0c, 0xd7, 0x1f, 0x8e, 0x4d, 0x6c, 0xeb, 0x15, 0x39, 0xbc, 0xbe, 0xea, 0xb5,
	0x6d, 0x53, 0xaf, 0xca, 0x61, 0xcf, 0xb4, 0x4c, 0xdb, 0xd4, 0x6b, 0x17, 0x6a, 0xb5, 0xa8, 0x2b,
	0x17, 0x6a, 0x55, 0xd1, 0x55, 0xe3, 0x8f, 0x05, 0xd8, 0x1d, 0xd3, 0x98, 0xb8, 0xd3, 0x4b, 0xf2,
	0x8c, 0xdd, 0xf0, 0x9e, 0x60, 0xf2, 0x61, 0x4e, 0x12, 0x8a, 0xf6, 0xa1, 0x3a, 0x8b, 0x12, 0x9f,
	0x61, 0xc7, 0x01, 0xae, 0xe1, 0x6c, 0x8c, 0x4e, 0xa0, 0xf6, 0x48, 0x9e, 0x9d, 0x98, 0xd9, 0x4b,
	0xc0, 0x50, 0x33, 0x23, 0x64, 0x16, 0xa9, 0xfa, 0x28, 0xa5, 0x55, 0x7c, 0x95, 0x8f, 0xe3, 0x6b,
	0xdc, 0xc1, 0xde, 0xcb, 0xa4, 0x92, 0x59, 0x14, 0x26, 0x04, 0x59, 0x80, 0x84, 0xa3, 0x43, 0x97,
	0x67, 0xcb, 0xf3, 0xd3, 0x5a, 0x9f, 0x7c, 0x23, 0x01, 0xf0, 0xd6, 0xed, 0x4b, 0x95, 0xf1, 0x3b,
	0xd8, 0x16, 0xeb, 0xd8, 0xee, 0x6d, 0x40, 0x92, 0xb7, 0x6c, 0x7d, 0x0f, 0xca, 0x94, 0x1b, 0x37,
	0x8a, 0x07, 0xca, 0x51, 0x0d, 0xcb, 0xd1, 0xb7, 0xdd, 0xa1, 0x07, 0x3b, 0xf9, 0x95, 0xff, 0x27,
	0xfb, 0xfb, 0x39, 0xa8, 0x78, 0x1e, 0x10, 0xb4, 0x03, 0xa5, 0xa9, 0x4b, 0x27, 0x0f, 0x72, 0x37,
	0x62, 0xc0, 0xb6, 0x72, 0xe7, 0x07, 0x94, 0xc4, 0xfc, 0x08, 0x6b, 0x58, 0x8e, 0x8c, 0xbf, 0x14,
	0xa0, 0x7c, 0xca, 0x45, 0xf4, 0x43, 0x28, 0xc5, 0x73, 0xb6, 0x59, 0x51, 0xeb, 0xfa, 0x6a, 0x06,
	0x2c, 0x32, 0x16, 0xd3, 0xa8, 0x0f, 0xf5, 0x3b, 0x9f, 0x04, 0x1e, 0x2f, 0xdd, 0x41, 0xe4, 0x09,
	0x56, 0xd4, 0x5b, 0x9f, 0xae, 0x3a, 0x88, 0x98, 0xcd, 0xd3, 0x9c, 0x21, 0x7e, 0xe1, 0x68, 0xbc,
	0x83, 0x7a, 0xde, 0x82, 0x95, 0x93, 0x89, 0xb1, 0x33, 0x1a, 0x3a, 0x83, 0xfe, 0x78, 0xd0, 0xb6,
	0xbb, 0xe7, 0xfa, 0x1a, 0xaf, 0x18, 0x73, 0x6c, 0x3b, 0xe6, 0xe9, 0xe9, 0x08, 0xdb, 0x7a, 0xc1,
	0xf8, 0x53, 0x11, 0xd6, 0x05, 0x28, 0xe3, 0x68, 0x1e, 0x4f, 0x08, 0x3b, 0xc5, 0x47, 0xf2, 0x9c,
	0xcc, 0xdc, 0x09, 0x49, 0x4f, 0x31, 0x1d, 0x33, 0x40, 0x92, 0x07, 0x37, 0xf6, 0xe4, 0xce, 0xc5,
	0x00, 0xfd, 0x02, 0x34, 0x7e, 0x9a, 0xd4, 0xa1, 0xcf, 0x33, 0xc2, 0xcf, 0xb1, 0xde, 0xda, 0x59,
	0x12, 0x9b, 0x9f, 0x15, 0xb5, 0x9f, 0x67, 0x04, 0x03, 0xcd, 0xe4, 0x7c, 0x35, 0xa8, 0x6f, 0xa8,
	0x86, 0x25, 0x87, 0x4a, 0x39, 0x0e, 0x1d, 0x67, 0x07, 0x52, 0x96, 0x51, 0x5e, 0xa1, 0x97, 0x1e,
	0x12, 0x6a, 0x42, 0x39, 0x0a, 0x1d, 0xcf, 0x0b, 0x1a, 0x15, 0x9e, 0xe6, 0x77, 0x56, 0x6d, 0x47,
	0x61, 0xaf, 0x67, 0xb5, 0x05, 0x2d, 0x4a, 0x51, 0xd8, 0xf3, 0x02, 0xe3, 0x3d, 0xd4, 0x70, 0xf4,
	0xd4, 0x7d, 0xe0, 0x09, 0x18, 0x50, 0xbe, 0x25, 0x77, 0x51, 0x4c, 0x24, 0xb3, 0x40, 0x76, 0x5e,
	0x1c, 0x3d, 0x61, 0x39, 0x83, 0x0e, 0xa0, 0xe4, 0xde, 0xa5, 0xe4, 0xc8, 0x9b, 0x88, 0x09, 0xc3,
	0x85, 0x2a, 0x8e, 0x9e, 0xf8, 0x39, 0xa1, 0x4f, 0x40, 0x20, 0xe2, 0x84, 0xee, 0x34, 0x85, 0xbb,
	0xc6, 0x35, 0x43, 0x77, 0x4a, 0xd0, 0x3b, 0xd0, 0xe2, 0xe8, 0xc9, 0x99, 0xf0, 0xe5, 0x45, 0xe9,
	0x68, 0xad, 0xdd, 0x1c, 0x9b, 0xd2, 0xe4, 0x30, 0xc4, 0xa9, 0x98, 0x18, 0xef, 0x01, 0x96, 0x64,
	0xf8, 0xd8, 0x22, 0x3f, 0x60, 0xf0, 0x91, 0xc0, 0x4b, 0xe3, 0xaf, 0xcb, 0x94, 0x79, 0x04, 0x2c,
	0xe7, 0x18, 0x10, 0x63, 0x76, 0xda, 0x67, 0xd4, 0xf7, 0xfe, 0x0b, 0x8e, 0x20, 0x50, 0xef, 0xa9,
	0xef, 0x71, 0x72, 0xd4, 0x30, 0x97, 0x8d, 0x2f, 0xa0, 0x74, 0xc3, 0xc3, 0xbd, 0x03, 0x8d, 0x5b,
	0x39, 0x4c, 0x9d, 0x16, 0x4d, 0x6e, 0x9b, 0xd9, 0xd2, 0x18, 0x92, 0x54, 0x4c, 0x8c, 0x36, 0x6c,
	0x5c, 0xca, 0x65, 0xb9, 0xc1, 0xb7, 0xcf, 0xcb, 0xf8, 0x6b, 0x11, 0x2a, 0x17, 0xd1, 0x3c, 0x0e,
	0xdd, 0x00, 0xd5, 0xa1, 0xe8, 0x7b, 0xdc, 0x4f, 0xc1, 0x45, 0xdf, 0x43, 0xbf, 0x86, 0xfa, 0xd4,
	0xbf, 0x8f, 0x5d, 0xc6, 0x07, 0x41, 0x6d, 0x51, 0x9d, 0xdf, 0x5d, 0xcd, 0x6c, 0x90, 0x5a, 0x70,
	0x7e, 0x6f, 0x4c, 0x57, 0x87, 0x2b, 0x8c, 0x55, 0x72, 0x8c, 0xfd, 0x0c, 0xea, 0x41, 0x34, 0x71,
	0x03, 0x27, 0xeb, 0x97, 0x2a, 0x4f, 0x6a, 0x83, 0x6b, 0xaf, 0xd2, 0xa6, 0xf9, 0x02, 0x97, 0xd2,
	0x1b, 0x71, 0x41, 0x9f, 0xc3, 0xfa, 0xcc, 0x8d, 0xa9, 0x3f, 0xf1, 0x67, 0x2e, 0xfb, 0xe3, 0x28,
	0x73, 0xc7, 0x5c, 0xda, 0x39, 0xdc, 0x70, 0xce, 0x1c, 0x7d, 0x0a, 0xeb, 0x31, 0x59, 0x90, 0x38,
	0x21, 0x9e, 0xc3, 0xd6, 0xad, 0x1c, 0x28, 0x47, 0x0a, 0xd6, 0x52, 0x5d, 0xdf, 0x4b, 0x8c, 0x7f,
	0x16, 0xa1, 0x7c, 0x23, 0xd8, 0x75, 0x0c, 0x2a, 0xc7, 0x46, 0xfc, 0x4d, 0xec, 0xad, 0x2e, 0x22,
	0x2c, 0x38, 0x30, 0xdc, 0x06, 0x7d, 0x0f, 0x6a, 0xd4, 0x9f, 0x92, 0x84, 0xba, 0xd3, 0x19, 0x07,
	0x53, 0xc1, 0x4b, 0xc5, 0xd7, 0x71, 0x84, 0xfd, 0x32, 0xb0, 0x62, 0x15, 0xf0, 0x30, 0x11, 0xfd,
	0x14, 0x6a, 0xac, 0x26, 0xf8, 0x1f, 0x4e, 0xa3, 0xc4, 0x8b, 0x6c, 0xe7, 0x45, 0x45, 0xf0, 0x65,
	0x71, 0x35, 0x4e, 0xab, 0xec, 0x97, 0xa0, 0x71, 0x16, 0x4b, 0x27, 0xd1, 0x25, 0xf6, 0xf2, 0x5d,
	0x22, 0xad, 0x16, 0x0c, 0xcb, 0xc6, 0x8a, 0x0e, 0xa1, 0xb4, 0xe0, 0x29, 0x55, 0xe4, 0x9f, 0xd6,
	0xea, 0xe6, 0x38, 0xec, 0x62, 0x9e, 0x5d, 0x63, 0xbf, 0x15, 0x2c, 0x6a, 0x54, 0x5f, 0x5f, 0x63,
	0x92, 0x60, 0x38, 0xb5, 0x61, 0x08, 0x4f, 0xe6, 0x71, 0xcc, 0xff, 0xe4, 0xfc, 0x29, 0x69, 0xec,
	0x70, 0x28, 0x34, 0xa9, 0xb3, 0xfd, 0x29, 0x31, 0xfe, 0x50, 0x84, 0xfa, 0x8d, 0xb8, 0xeb, 0xd2,
	0xfb, 0xf5, 0x0b, 0xd8, 0x26, 0x77, 0x77, 0x64, 0x42, 0xfd, 0x05, 0x71, 0x26, 0x6e, 0x10, 0x90,
	0xd8, 0x91, 0x84, 0xd5, 0x5a, 0x9b, 0x4d, 0xf1, 0xcf, 0xdb, 0xe5, 0xfa, 0x7e, 0x0f, 0x6f, 0x65,
	0xb6, 0x52, 0xe5, 0x21, 0x13, 0xb6, 0xfd, 0xe9, 0x94, 0x78, 0xbe, 0x4b, 0x57, 0x03, 0x88, 0x4e,
	0xb5, 0x2b, 0xcb, 0xfe, 0xc6, 0x3e, 0x73, 0x29, 0x59, 0x86, 0xc9, 0x3c, 0xb2, 0x30, 0x9f, 0x31,
	0x56, 0xc7, 0xf7, 0xd9, 0x95, 0xbd, 0x21, 0x3d, 0x6d, 0xae, 0xc4, 0x72, 0x32, 0xf7, 0x3b, 0xa0,
	0xbe, 0xf8, 0x1d, 0x58, 0xb6, 0xec, 0xd2, 0xc7, 0x5a, 0xb6, 0xf1, 0x39, 0x6c, 0x66, 0x40, 0xc8,
	0xeb, 0xfe, 0x18, 0xca, 0xfc, 0x28, 0xd3, 0x5e, 0x81, 0x5e, 0xb3, 0x0e, 0x4b, 0x0b, 0xe3, 0xf7,
	0x45, 0x40, 0xa9, 0x7f, 0xf4, 0x94, 0xfc, 0x9f, 0x82, 0xb9, 0x03, 0x25, 0xae, 0x97, 0x48, 0x8a,
	0x01, 0xc3, 0x21, 0x70, 0x13, 0x3a, 0x7b, 0xcc, 0x60, 0x14, 0xce, 0xef, 0xd9, 0x17, 0x93, 0x64,
	0x1e, 0x50, 0x2c, 0x2d, 0x8c, 0xbf, 0x15, 0x60, 0x3b, 0x87, 0x83, 0xc4, 0x72, 0xd9, 0xfe, 0x0b,
	0xff, 0xb9, 0xfd, 0xa3, 0x23, 0xa8, 0xce, 0x1e, 0xbf, 0xe1, 0x9a, 0xc8, 0x66, 0xbf, 0xb6, 0x8a,
	0xbf, 0x0f, 0x6a, 0x1c, 0x3d, 0x25, 0x0d, 0x95, 0x7b, 0xae, 0xde, 0x89, 0x5c, 0xcf, 0x2e, 0xd6,
	0xdc, 0x3e, 0x72, 0x17, 0xab, 0x98, 0x39, 0xfe, 0x15, 0x68, 0x2b, 0xf7, 0x33, 0xfb, 0x8d, 0xef,
	0x9f, 0x0d, 0x47, 0xd8, 0xd4, 0xd7, 0x50, 0x15, 0xd4, 0xb1, 0x3d, 0xba, 0xd2, 0x0b, 0x4c, 0x32,
	0x7f, 0x63, 0x76, 0xc5, 0xd3, 0x80, 0x49, 0x8e, 0x34, 0x52, 0x8e, 0xff, 0x51, 0x00, 0x58, 0x36,
	0x24, 0xa4, 0x41, 0xe5, 0x7a, 0x78, 0x39, 0x1c, 0x7d, 0x39, 0x14, 0x01, 0xce, 0xec, 0x7e, 0x4f,
	0x2f, 0xa0, 0x1a, 0x94, 0xc4, 0x5b, 0xa3, 0xc8, 0x56, 0x90, 0x0f, 0x0d, 0x85, 0xbd, 0x42, 0xb2,
	0x57, 0x86, 0x8a, 0x2a, 0xa0, 0x64, 0x6f, 0x09, 0xf9, 0x78, 0x28, 0xb3, 0x80, 0xd8, 0xbc, 0xb2,
	0xda, 0x5d, 0x53, 0xaf, 0xb0, 0x89, 0xec, 0x19, 0x01, 0x50, 0x4e, 0xdf, 0x10, 0xcc, 0x93, 0xbd,
	0x3c, 0x80, 0xad, 0x33, 0xb2, 0xcf, 0x4d, 0xac, 0x6b, 0x4c, 0x87, 0x47, 0x5f, 0xea, 0xeb, 0x4c,
	0x77, 0xda, 0x37, 0xad, 0x9e, 0xbe, 0xc1, 0x9e, 0x1e, 0xe7, 0x66, 0x1b, 0xdb, 0x1d, 0xb3, 0x6d,
	0xeb, 0x75, 0x36, 0x73, 0xc3, 0x13, 0xdc, 0x64, 0xcb, 0x5c, 0x8c, 0xae, 0xf1, 0xb0, 0x6d, 0xe9,
	0xfa, 0xf1, 0x21, 0x6c, 0xe4, 0xee, 0x1f, 0xb6, 0x96, 0xdd, 0xee, 0x58, 0xe6, 0x58, 0x5f, 0x63,
	0xf2, 0xf8, 0xbc, 0x8d, 0x7b, 0x63, 0xbd, 0xd0, 0xf9, 0xd1, 0x57, 0x87, 0x0b, 0x9f, 0x92, 0x24,
	0x69, 0xfa, 0xd1, 0x89, 0x90, 0x4e, 0xee, 0xa3, 0x93, 0x05, 0x3d, 0xe1, 0xcf, 0xe0, 0x93, 0x65,
	0xf9, 0xdc, 0x96, 0xb9, 0xe6, 0x67, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0x13, 0xef, 0x5d, 0xd6,
	0x62, 0x0f, 0x00, 0x00,
}
