// Code generated by protoc-gen-go. DO NOT EDIT.
// source: query.proto

package query

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	topodata "vitess.io/vitess/go/vt/proto/topodata"
	vtrpc "vitess.io/vitess/go/vt/proto/vtrpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Flags sent from the MySQL C API
type MySqlFlag int32

const (
	MySqlFlag_EMPTY                 MySqlFlag = 0
	MySqlFlag_NOT_NULL_FLAG         MySqlFlag = 1
	MySqlFlag_PRI_KEY_FLAG          MySqlFlag = 2
	MySqlFlag_UNIQUE_KEY_FLAG       MySqlFlag = 4
	MySqlFlag_MULTIPLE_KEY_FLAG     MySqlFlag = 8
	MySqlFlag_BLOB_FLAG             MySqlFlag = 16
	MySqlFlag_UNSIGNED_FLAG         MySqlFlag = 32
	MySqlFlag_ZEROFILL_FLAG         MySqlFlag = 64
	MySqlFlag_BINARY_FLAG           MySqlFlag = 128
	MySqlFlag_ENUM_FLAG             MySqlFlag = 256
	MySqlFlag_AUTO_INCREMENT_FLAG   MySqlFlag = 512
	MySqlFlag_TIMESTAMP_FLAG        MySqlFlag = 1024
	MySqlFlag_SET_FLAG              MySqlFlag = 2048
	MySqlFlag_NO_DEFAULT_VALUE_FLAG MySqlFlag = 4096
	MySqlFlag_ON_UPDATE_NOW_FLAG    MySqlFlag = 8192
	MySqlFlag_NUM_FLAG              MySqlFlag = 32768
	MySqlFlag_PART_KEY_FLAG         MySqlFlag = 16384
	MySqlFlag_GROUP_FLAG            MySqlFlag = 32768
	MySqlFlag_UNIQUE_FLAG           MySqlFlag = 65536
	MySqlFlag_BINCMP_FLAG           MySqlFlag = 131072
)

var MySqlFlag_name = map[int32]string{
	0:     "EMPTY",
	1:     "NOT_NULL_FLAG",
	2:     "PRI_KEY_FLAG",
	4:     "UNIQUE_KEY_FLAG",
	8:     "MULTIPLE_KEY_FLAG",
	16:    "BLOB_FLAG",
	32:    "UNSIGNED_FLAG",
	64:    "ZEROFILL_FLAG",
	128:   "BINARY_FLAG",
	256:   "ENUM_FLAG",
	512:   "AUTO_INCREMENT_FLAG",
	1024:  "TIMESTAMP_FLAG",
	2048:  "SET_FLAG",
	4096:  "NO_DEFAULT_VALUE_FLAG",
	8192:  "ON_UPDATE_NOW_FLAG",
	32768: "NUM_FLAG",
	16384: "PART_KEY_FLAG",
	// Duplicate value: 32768: "GROUP_FLAG",
	65536:  "UNIQUE_FLAG",
	131072: "BINCMP_FLAG",
}

var MySqlFlag_value = map[string]int32{
	"EMPTY":                 0,
	"NOT_NULL_FLAG":         1,
	"PRI_KEY_FLAG":          2,
	"UNIQUE_KEY_FLAG":       4,
	"MULTIPLE_KEY_FLAG":     8,
	"BLOB_FLAG":             16,
	"UNSIGNED_FLAG":         32,
	"ZEROFILL_FLAG":         64,
	"BINARY_FLAG":           128,
	"ENUM_FLAG":             256,
	"AUTO_INCREMENT_FLAG":   512,
	"TIMESTAMP_FLAG":        1024,
	"SET_FLAG":              2048,
	"NO_DEFAULT_VALUE_FLAG": 4096,
	"ON_UPDATE_NOW_FLAG":    8192,
	"NUM_FLAG":              32768,
	"PART_KEY_FLAG":         16384,
	"GROUP_FLAG":            32768,
	"UNIQUE_FLAG":           65536,
	"BINCMP_FLAG":           131072,
}

func (x MySqlFlag) String() string {
	return proto.EnumName(MySqlFlag_name, int32(x))
}

func (MySqlFlag) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{0}
}

// Flag allows us to qualify types by their common properties.
type Flag int32

const (
	Flag_NONE       Flag = 0
	Flag_ISINTEGRAL Flag = 256
	Flag_ISUNSIGNED Flag = 512
	Flag_ISFLOAT    Flag = 1024
	Flag_ISQUOTED   Flag = 2048
	Flag_ISTEXT     Flag = 4096
	Flag_ISBINARY   Flag = 8192
)

var Flag_name = map[int32]string{
	0:    "NONE",
	256:  "ISINTEGRAL",
	512:  "ISUNSIGNED",
	1024: "ISFLOAT",
	2048: "ISQUOTED",
	4096: "ISTEXT",
	8192: "ISBINARY",
}

var Flag_value = map[string]int32{
	"NONE":       0,
	"ISINTEGRAL": 256,
	"ISUNSIGNED": 512,
	"ISFLOAT":    1024,
	"ISQUOTED":   2048,
	"ISTEXT":     4096,
	"ISBINARY":   8192,
}

func (x Flag) String() string {
	return proto.EnumName(Flag_name, int32(x))
}

func (Flag) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{1}
}

// Type defines the various supported data types in bind vars
// and query results.
type Type int32

const (
	// NULL_TYPE specifies a NULL type.
	Type_NULL_TYPE Type = 0
	// INT8 specifies a TINYINT type.
	// Properties: 1, IsNumber.
	Type_INT8 Type = 257
	// UINT8 specifies a TINYINT UNSIGNED type.
	// Properties: 2, IsNumber, IsUnsigned.
	Type_UINT8 Type = 770
	// INT16 specifies a SMALLINT type.
	// Properties: 3, IsNumber.
	Type_INT16 Type = 259
	// UINT16 specifies a SMALLINT UNSIGNED type.
	// Properties: 4, IsNumber, IsUnsigned.
	Type_UINT16 Type = 772
	// INT24 specifies a MEDIUMINT type.
	// Properties: 5, IsNumber.
	Type_INT24 Type = 261
	// UINT24 specifies a MEDIUMINT UNSIGNED type.
	// Properties: 6, IsNumber, IsUnsigned.
	Type_UINT24 Type = 774
	// INT32 specifies a INTEGER type.
	// Properties: 7, IsNumber.
	Type_INT32 Type = 263
	// UINT32 specifies a INTEGER UNSIGNED type.
	// Properties: 8, IsNumber, IsUnsigned.
	Type_UINT32 Type = 776
	// INT64 specifies a BIGINT type.
	// Properties: 9, IsNumber.
	Type_INT64 Type = 265
	// UINT64 specifies a BIGINT UNSIGNED type.
	// Properties: 10, IsNumber, IsUnsigned.
	Type_UINT64 Type = 778
	// FLOAT32 specifies a FLOAT type.
	// Properties: 11, IsFloat.
	Type_FLOAT32 Type = 1035
	// FLOAT64 specifies a DOUBLE or REAL type.
	// Properties: 12, IsFloat.
	Type_FLOAT64 Type = 1036
	// TIMESTAMP specifies a TIMESTAMP type.
	// Properties: 13, IsQuoted.
	Type_TIMESTAMP Type = 2061
	// DATE specifies a DATE type.
	// Properties: 14, IsQuoted.
	Type_DATE Type = 2062
	// TIME specifies a TIME type.
	// Properties: 15, IsQuoted.
	Type_TIME Type = 2063
	// DATETIME specifies a DATETIME type.
	// Properties: 16, IsQuoted.
	Type_DATETIME Type = 2064
	// YEAR specifies a YEAR type.
	// Properties: 17, IsNumber, IsUnsigned.
	Type_YEAR Type = 785
	// DECIMAL specifies a DECIMAL or NUMERIC type.
	// Properties: 18, None.
	Type_DECIMAL Type = 18
	// TEXT specifies a TEXT type.
	// Properties: 19, IsQuoted, IsText.
	Type_TEXT Type = 6163
	// BLOB specifies a BLOB type.
	// Properties: 20, IsQuoted, IsBinary.
	Type_BLOB Type = 10260
	// VARCHAR specifies a VARCHAR type.
	// Properties: 21, IsQuoted, IsText.
	Type_VARCHAR Type = 6165
	// VARBINARY specifies a VARBINARY type.
	// Properties: 22, IsQuoted, IsBinary.
	Type_VARBINARY Type = 10262
	// CHAR specifies a CHAR type.
	// Properties: 23, IsQuoted, IsText.
	Type_CHAR Type = 6167
	// BINARY specifies a BINARY type.
	// Properties: 24, IsQuoted, IsBinary.
	Type_BINARY Type = 10264
	// BIT specifies a BIT type.
	// Properties: 25, IsQuoted.
	Type_BIT Type = 2073
	// ENUM specifies an ENUM type.
	// Properties: 26, IsQuoted.
	Type_ENUM Type = 2074
	// SET specifies a SET type.
	// Properties: 27, IsQuoted.
	Type_SET Type = 2075
	// TUPLE specifies a tuple. This cannot
	// be returned in a QueryResult, but it can
	// be sent as a bind var.
	// Properties: 28, None.
	Type_TUPLE Type = 28
	// GEOMETRY specifies a GEOMETRY type.
	// Properties: 29, IsQuoted.
	Type_GEOMETRY Type = 2077
	// JSON specifies a JSON type.
	// Properties: 30, IsQuoted.
	Type_JSON Type = 2078
	// EXPRESSION specifies a SQL expression.
	// This type is for internal use only.
	// Properties: 31, None.
	Type_EXPRESSION Type = 31
)

var Type_name = map[int32]string{
	0:     "NULL_TYPE",
	257:   "INT8",
	770:   "UINT8",
	259:   "INT16",
	772:   "UINT16",
	261:   "INT24",
	774:   "UINT24",
	263:   "INT32",
	776:   "UINT32",
	265:   "INT64",
	778:   "UINT64",
	1035:  "FLOAT32",
	1036:  "FLOAT64",
	2061:  "TIMESTAMP",
	2062:  "DATE",
	2063:  "TIME",
	2064:  "DATETIME",
	785:   "YEAR",
	18:    "DECIMAL",
	6163:  "TEXT",
	10260: "BLOB",
	6165:  "VARCHAR",
	10262: "VARBINARY",
	6167:  "CHAR",
	10264: "BINARY",
	2073:  "BIT",
	2074:  "ENUM",
	2075:  "SET",
	28:    "TUPLE",
	2077:  "GEOMETRY",
	2078:  "JSON",
	31:    "EXPRESSION",
}

var Type_value = map[string]int32{
	"NULL_TYPE":  0,
	"INT8":       257,
	"UINT8":      770,
	"INT16":      259,
	"UINT16":     772,
	"INT24":      261,
	"UINT24":     774,
	"INT32":      263,
	"UINT32":     776,
	"INT64":      265,
	"UINT64":     778,
	"FLOAT32":    1035,
	"FLOAT64":    1036,
	"TIMESTAMP":  2061,
	"DATE":       2062,
	"TIME":       2063,
	"DATETIME":   2064,
	"YEAR":       785,
	"DECIMAL":    18,
	"TEXT":       6163,
	"BLOB":       10260,
	"VARCHAR":    6165,
	"VARBINARY":  10262,
	"CHAR":       6167,
	"BINARY":     10264,
	"BIT":        2073,
	"ENUM":       2074,
	"SET":        2075,
	"TUPLE":      28,
	"GEOMETRY":   2077,
	"JSON":       2078,
	"EXPRESSION": 31,
}

func (x Type) String() string {
	return proto.EnumName(Type_name, int32(x))
}

func (Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{2}
}

// TransactionState represents the state of a distributed transaction.
type TransactionState int32

const (
	TransactionState_UNKNOWN  TransactionState = 0
	TransactionState_PREPARE  TransactionState = 1
	TransactionState_COMMIT   TransactionState = 2
	TransactionState_ROLLBACK TransactionState = 3
)

var TransactionState_name = map[int32]string{
	0: "UNKNOWN",
	1: "PREPARE",
	2: "COMMIT",
	3: "ROLLBACK",
}

var TransactionState_value = map[string]int32{
	"UNKNOWN":  0,
	"PREPARE":  1,
	"COMMIT":   2,
	"ROLLBACK": 3,
}

func (x TransactionState) String() string {
	return proto.EnumName(TransactionState_name, int32(x))
}

func (TransactionState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{3}
}

type ExecuteOptions_IncludedFields int32

const (
	ExecuteOptions_TYPE_AND_NAME ExecuteOptions_IncludedFields = 0
	ExecuteOptions_TYPE_ONLY     ExecuteOptions_IncludedFields = 1
	ExecuteOptions_ALL           ExecuteOptions_IncludedFields = 2
)

var ExecuteOptions_IncludedFields_name = map[int32]string{
	0: "TYPE_AND_NAME",
	1: "TYPE_ONLY",
	2: "ALL",
}

var ExecuteOptions_IncludedFields_value = map[string]int32{
	"TYPE_AND_NAME": 0,
	"TYPE_ONLY":     1,
	"ALL":           2,
}

func (x ExecuteOptions_IncludedFields) String() string {
	return proto.EnumName(ExecuteOptions_IncludedFields_name, int32(x))
}

func (ExecuteOptions_IncludedFields) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{6, 0}
}

type ExecuteOptions_Workload int32

const (
	ExecuteOptions_UNSPECIFIED ExecuteOptions_Workload = 0
	ExecuteOptions_OLTP        ExecuteOptions_Workload = 1
	ExecuteOptions_OLAP        ExecuteOptions_Workload = 2
	ExecuteOptions_DBA         ExecuteOptions_Workload = 3
)

var ExecuteOptions_Workload_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "OLTP",
	2: "OLAP",
	3: "DBA",
}

var ExecuteOptions_Workload_value = map[string]int32{
	"UNSPECIFIED": 0,
	"OLTP":        1,
	"OLAP":        2,
	"DBA":         3,
}

func (x ExecuteOptions_Workload) String() string {
	return proto.EnumName(ExecuteOptions_Workload_name, int32(x))
}

func (ExecuteOptions_Workload) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{6, 1}
}

type ExecuteOptions_TransactionIsolation int32

const (
	ExecuteOptions_DEFAULT          ExecuteOptions_TransactionIsolation = 0
	ExecuteOptions_REPEATABLE_READ  ExecuteOptions_TransactionIsolation = 1
	ExecuteOptions_READ_COMMITTED   ExecuteOptions_TransactionIsolation = 2
	ExecuteOptions_READ_UNCOMMITTED ExecuteOptions_TransactionIsolation = 3
	ExecuteOptions_SERIALIZABLE     ExecuteOptions_TransactionIsolation = 4
	// This is not an "official" transaction level but it will do a
	// START TRANSACTION WITH CONSISTENT SNAPSHOT, READ ONLY
	ExecuteOptions_CONSISTENT_SNAPSHOT_READ_ONLY ExecuteOptions_TransactionIsolation = 5
	// This not an "official" transaction level, it will send queries to mysql
	// without wrapping them in a transaction
	ExecuteOptions_AUTOCOMMIT ExecuteOptions_TransactionIsolation = 6
)

var ExecuteOptions_TransactionIsolation_name = map[int32]string{
	0: "DEFAULT",
	1: "REPEATABLE_READ",
	2: "READ_COMMITTED",
	3: "READ_UNCOMMITTED",
	4: "SERIALIZABLE",
	5: "CONSISTENT_SNAPSHOT_READ_ONLY",
	6: "AUTOCOMMIT",
}

var ExecuteOptions_TransactionIsolation_value = map[string]int32{
	"DEFAULT":                       0,
	"REPEATABLE_READ":               1,
	"READ_COMMITTED":                2,
	"READ_UNCOMMITTED":              3,
	"SERIALIZABLE":                  4,
	"CONSISTENT_SNAPSHOT_READ_ONLY": 5,
	"AUTOCOMMIT":                    6,
}

func (x ExecuteOptions_TransactionIsolation) String() string {
	return proto.EnumName(ExecuteOptions_TransactionIsolation_name, int32(x))
}

func (ExecuteOptions_TransactionIsolation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{6, 2}
}

// The category of one statement.
type StreamEvent_Statement_Category int32

const (
	StreamEvent_Statement_Error StreamEvent_Statement_Category = 0
	StreamEvent_Statement_DML   StreamEvent_Statement_Category = 1
	StreamEvent_Statement_DDL   StreamEvent_Statement_Category = 2
)

var StreamEvent_Statement_Category_name = map[int32]string{
	0: "Error",
	1: "DML",
	2: "DDL",
}

var StreamEvent_Statement_Category_value = map[string]int32{
	"Error": 0,
	"DML":   1,
	"DDL":   2,
}

func (x StreamEvent_Statement_Category) String() string {
	return proto.EnumName(StreamEvent_Statement_Category_name, int32(x))
}

func (StreamEvent_Statement_Category) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{12, 0, 0}
}

type SplitQueryRequest_Algorithm int32

const (
	SplitQueryRequest_EQUAL_SPLITS SplitQueryRequest_Algorithm = 0
	SplitQueryRequest_FULL_SCAN    SplitQueryRequest_Algorithm = 1
)

var SplitQueryRequest_Algorithm_name = map[int32]string{
	0: "EQUAL_SPLITS",
	1: "FULL_SCAN",
}

var SplitQueryRequest_Algorithm_value = map[string]int32{
	"EQUAL_SPLITS": 0,
	"FULL_SCAN":    1,
}

func (x SplitQueryRequest_Algorithm) String() string {
	return proto.EnumName(SplitQueryRequest_Algorithm_name, int32(x))
}

func (SplitQueryRequest_Algorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{50, 0}
}

// Target describes what the client expects the tablet is.
// If the tablet does not match, an error is returned.
type Target struct {
	Keyspace   string              `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard      string              `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// cell is used for routing queries between vtgate and vttablets. It
	// is not used when Target is part of the Session sent by the client.
	Cell                 string   `protobuf:"bytes,4,opt,name=cell,proto3" json:"cell,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Target) Reset()         { *m = Target{} }
func (m *Target) String() string { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()    {}
func (*Target) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{0}
}

func (m *Target) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target.Unmarshal(m, b)
}
func (m *Target) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target.Marshal(b, m, deterministic)
}
func (m *Target) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target.Merge(m, src)
}
func (m *Target) XXX_Size() int {
	return xxx_messageInfo_Target.Size(m)
}
func (m *Target) XXX_DiscardUnknown() {
	xxx_messageInfo_Target.DiscardUnknown(m)
}

var xxx_messageInfo_Target proto.InternalMessageInfo

func (m *Target) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *Target) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *Target) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *Target) GetCell() string {
	if m != nil {
		return m.Cell
	}
	return ""
}

// VTGateCallerID is sent by VTGate to VTTablet to describe the
// caller. If possible, this information is secure. For instance,
// if using unique certificates that guarantee that VTGate->VTTablet
// traffic cannot be spoofed, then VTTablet can trust this information,
// and VTTablet will use it for tablet ACLs, for instance.
// Because of this security guarantee, this is different than the CallerID
// structure, which is not secure at all, because it is provided
// by the Vitess client.
type VTGateCallerID struct {
	Username             string   `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	Groups               []string `protobuf:"bytes,2,rep,name=groups,proto3" json:"groups,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VTGateCallerID) Reset()         { *m = VTGateCallerID{} }
func (m *VTGateCallerID) String() string { return proto.CompactTextString(m) }
func (*VTGateCallerID) ProtoMessage()    {}
func (*VTGateCallerID) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{1}
}

func (m *VTGateCallerID) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VTGateCallerID.Unmarshal(m, b)
}
func (m *VTGateCallerID) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VTGateCallerID.Marshal(b, m, deterministic)
}
func (m *VTGateCallerID) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VTGateCallerID.Merge(m, src)
}
func (m *VTGateCallerID) XXX_Size() int {
	return xxx_messageInfo_VTGateCallerID.Size(m)
}
func (m *VTGateCallerID) XXX_DiscardUnknown() {
	xxx_messageInfo_VTGateCallerID.DiscardUnknown(m)
}

var xxx_messageInfo_VTGateCallerID proto.InternalMessageInfo

func (m *VTGateCallerID) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *VTGateCallerID) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

// EventToken is a structure that describes a point in time in a
// replication stream on one shard. The most recent known replication
// position can be retrieved from vttablet when executing a query. It
// is also sent with the replication streams from the binlog service.
type EventToken struct {
	// timestamp is the MySQL timestamp of the statements. Seconds since Epoch.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The shard name that applied the statements. Note this is not set when
	// streaming from a vttablet. It is only used on the client -> vtgate link.
	Shard string `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	// The position on the replication stream after this statement was applied.
	// It is not the transaction ID / GTID, but the position / GTIDSet.
	Position             string   `protobuf:"bytes,3,opt,name=position,proto3" json:"position,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventToken) Reset()         { *m = EventToken{} }
func (m *EventToken) String() string { return proto.CompactTextString(m) }
func (*EventToken) ProtoMessage()    {}
func (*EventToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{2}
}

func (m *EventToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventToken.Unmarshal(m, b)
}
func (m *EventToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventToken.Marshal(b, m, deterministic)
}
func (m *EventToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventToken.Merge(m, src)
}
func (m *EventToken) XXX_Size() int {
	return xxx_messageInfo_EventToken.Size(m)
}
func (m *EventToken) XXX_DiscardUnknown() {
	xxx_messageInfo_EventToken.DiscardUnknown(m)
}

var xxx_messageInfo_EventToken proto.InternalMessageInfo

func (m *EventToken) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *EventToken) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *EventToken) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

// Value represents a typed value.
type Value struct {
	Type                 Type     `protobuf:"varint,1,opt,name=type,proto3,enum=query.Type" json:"type,omitempty"`
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Value) Reset()         { *m = Value{} }
func (m *Value) String() string { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()    {}
func (*Value) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{3}
}

func (m *Value) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Value.Unmarshal(m, b)
}
func (m *Value) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Value.Marshal(b, m, deterministic)
}
func (m *Value) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Value.Merge(m, src)
}
func (m *Value) XXX_Size() int {
	return xxx_messageInfo_Value.Size(m)
}
func (m *Value) XXX_DiscardUnknown() {
	xxx_messageInfo_Value.DiscardUnknown(m)
}

var xxx_messageInfo_Value proto.InternalMessageInfo

func (m *Value) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *Value) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// BindVariable represents a single bind variable in a Query.
type BindVariable struct {
	Type  Type   `protobuf:"varint,1,opt,name=type,proto3,enum=query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// values are set if type is TUPLE.
	Values               []*Value `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BindVariable) Reset()         { *m = BindVariable{} }
func (m *BindVariable) String() string { return proto.CompactTextString(m) }
func (*BindVariable) ProtoMessage()    {}
func (*BindVariable) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{4}
}

func (m *BindVariable) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BindVariable.Unmarshal(m, b)
}
func (m *BindVariable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BindVariable.Marshal(b, m, deterministic)
}
func (m *BindVariable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BindVariable.Merge(m, src)
}
func (m *BindVariable) XXX_Size() int {
	return xxx_messageInfo_BindVariable.Size(m)
}
func (m *BindVariable) XXX_DiscardUnknown() {
	xxx_messageInfo_BindVariable.DiscardUnknown(m)
}

var xxx_messageInfo_BindVariable proto.InternalMessageInfo

func (m *BindVariable) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *BindVariable) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *BindVariable) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// BoundQuery is a query with its bind variables
type BoundQuery struct {
	// sql is the SQL query to execute
	Sql string `protobuf:"bytes,1,opt,name=sql,proto3" json:"sql,omitempty"`
	// bind_variables is a map of all bind variables to expand in the query.
	// nil values are not allowed. Use NULL_TYPE to express a NULL value.
	BindVariables        map[string]*BindVariable `protobuf:"bytes,2,rep,name=bind_variables,json=bindVariables,proto3" json:"bind_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *BoundQuery) Reset()         { *m = BoundQuery{} }
func (m *BoundQuery) String() string { return proto.CompactTextString(m) }
func (*BoundQuery) ProtoMessage()    {}
func (*BoundQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{5}
}

func (m *BoundQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BoundQuery.Unmarshal(m, b)
}
func (m *BoundQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BoundQuery.Marshal(b, m, deterministic)
}
func (m *BoundQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BoundQuery.Merge(m, src)
}
func (m *BoundQuery) XXX_Size() int {
	return xxx_messageInfo_BoundQuery.Size(m)
}
func (m *BoundQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_BoundQuery.DiscardUnknown(m)
}

var xxx_messageInfo_BoundQuery proto.InternalMessageInfo

func (m *BoundQuery) GetSql() string {
	if m != nil {
		return m.Sql
	}
	return ""
}

func (m *BoundQuery) GetBindVariables() map[string]*BindVariable {
	if m != nil {
		return m.BindVariables
	}
	return nil
}

// ExecuteOptions is passed around for all Execute calls.
type ExecuteOptions struct {
	// If set, we will try to include an EventToken with the responses.
	IncludeEventToken bool `protobuf:"varint,2,opt,name=include_event_token,json=includeEventToken,proto3" json:"include_event_token,omitempty"`
	// If set, the fresher field may be set as a result comparison to this token.
	// This is a shortcut so the application doesn't need to care about
	// comparing EventTokens.
	CompareEventToken *EventToken `protobuf:"bytes,3,opt,name=compare_event_token,json=compareEventToken,proto3" json:"compare_event_token,omitempty"`
	// Controls what fields are returned in Field message responses from mysql, i.e.
	// field name, table name, etc. This is an optimization for high-QPS queries where
	// the client knows what it's getting
	IncludedFields ExecuteOptions_IncludedFields `protobuf:"varint,4,opt,name=included_fields,json=includedFields,proto3,enum=query.ExecuteOptions_IncludedFields" json:"included_fields,omitempty"`
	// client_rows_found specifies if rows_affected should return
	// rows found instead of rows affected. Behavior is defined
	// by MySQL's CLIENT_FOUND_ROWS flag.
	ClientFoundRows bool `protobuf:"varint,5,opt,name=client_found_rows,json=clientFoundRows,proto3" json:"client_found_rows,omitempty"`
	// workload specifies the type of workload:
	// OLTP: DMLs allowed, results have row count limit, and
	// query timeouts are shorter.
	// OLAP: DMLS not allowed, no limit on row count, timeouts
	// can be as high as desired.
	// DBA: no limit on rowcount or timeout, all queries allowed
	// but intended for long DMLs and DDLs.
	Workload ExecuteOptions_Workload `protobuf:"varint,6,opt,name=workload,proto3,enum=query.ExecuteOptions_Workload" json:"workload,omitempty"`
	// sql_select_limit sets an implicit limit on all select statements. Since
	// vitess also sets a rowcount limit on queries, the smallest value wins.
	SqlSelectLimit       int64                               `protobuf:"varint,8,opt,name=sql_select_limit,json=sqlSelectLimit,proto3" json:"sql_select_limit,omitempty"`
	TransactionIsolation ExecuteOptions_TransactionIsolation `protobuf:"varint,9,opt,name=transaction_isolation,json=transactionIsolation,proto3,enum=query.ExecuteOptions_TransactionIsolation" json:"transaction_isolation,omitempty"`
	// skip_query_plan_cache specifies if the query plan should be cached by vitess.
	// By default all query plans are cached.
	SkipQueryPlanCache   bool     `protobuf:"varint,10,opt,name=skip_query_plan_cache,json=skipQueryPlanCache,proto3" json:"skip_query_plan_cache,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecuteOptions) Reset()         { *m = ExecuteOptions{} }
func (m *ExecuteOptions) String() string { return proto.CompactTextString(m) }
func (*ExecuteOptions) ProtoMessage()    {}
func (*ExecuteOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{6}
}

func (m *ExecuteOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteOptions.Unmarshal(m, b)
}
func (m *ExecuteOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteOptions.Marshal(b, m, deterministic)
}
func (m *ExecuteOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteOptions.Merge(m, src)
}
func (m *ExecuteOptions) XXX_Size() int {
	return xxx_messageInfo_ExecuteOptions.Size(m)
}
func (m *ExecuteOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteOptions.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteOptions proto.InternalMessageInfo

func (m *ExecuteOptions) GetIncludeEventToken() bool {
	if m != nil {
		return m.IncludeEventToken
	}
	return false
}

func (m *ExecuteOptions) GetCompareEventToken() *EventToken {
	if m != nil {
		return m.CompareEventToken
	}
	return nil
}

func (m *ExecuteOptions) GetIncludedFields() ExecuteOptions_IncludedFields {
	if m != nil {
		return m.IncludedFields
	}
	return ExecuteOptions_TYPE_AND_NAME
}

func (m *ExecuteOptions) GetClientFoundRows() bool {
	if m != nil {
		return m.ClientFoundRows
	}
	return false
}

func (m *ExecuteOptions) GetWorkload() ExecuteOptions_Workload {
	if m != nil {
		return m.Workload
	}
	return ExecuteOptions_UNSPECIFIED
}

func (m *ExecuteOptions) GetSqlSelectLimit() int64 {
	if m != nil {
		return m.SqlSelectLimit
	}
	return 0
}

func (m *ExecuteOptions) GetTransactionIsolation() ExecuteOptions_TransactionIsolation {
	if m != nil {
		return m.TransactionIsolation
	}
	return ExecuteOptions_DEFAULT
}

func (m *ExecuteOptions) GetSkipQueryPlanCache() bool {
	if m != nil {
		return m.SkipQueryPlanCache
	}
	return false
}

// Field describes a single column returned by a query
type Field struct {
	// name of the field as returned by mysql C API
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// vitess-defined type. Conversion function is in sqltypes package.
	Type Type `protobuf:"varint,2,opt,name=type,proto3,enum=query.Type" json:"type,omitempty"`
	// Remaining fields from mysql C API.
	// These fields are only populated when ExecuteOptions.included_fields
	// is set to IncludedFields.ALL.
	Table    string `protobuf:"bytes,3,opt,name=table,proto3" json:"table,omitempty"`
	OrgTable string `protobuf:"bytes,4,opt,name=org_table,json=orgTable,proto3" json:"org_table,omitempty"`
	Database string `protobuf:"bytes,5,opt,name=database,proto3" json:"database,omitempty"`
	OrgName  string `protobuf:"bytes,6,opt,name=org_name,json=orgName,proto3" json:"org_name,omitempty"`
	// column_length is really a uint32. All 32 bits can be used.
	ColumnLength uint32 `protobuf:"varint,7,opt,name=column_length,json=columnLength,proto3" json:"column_length,omitempty"`
	// charset is actually a uint16. Only the lower 16 bits are used.
	Charset uint32 `protobuf:"varint,8,opt,name=charset,proto3" json:"charset,omitempty"`
	// decimals is actually a uint8. Only the lower 8 bits are used.
	Decimals uint32 `protobuf:"varint,9,opt,name=decimals,proto3" json:"decimals,omitempty"`
	// flags is actually a uint16. Only the lower 16 bits are used.
	Flags                uint32   `protobuf:"varint,10,opt,name=flags,proto3" json:"flags,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Field) Reset()         { *m = Field{} }
func (m *Field) String() string { return proto.CompactTextString(m) }
func (*Field) ProtoMessage()    {}
func (*Field) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{7}
}

func (m *Field) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Field.Unmarshal(m, b)
}
func (m *Field) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Field.Marshal(b, m, deterministic)
}
func (m *Field) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Field.Merge(m, src)
}
func (m *Field) XXX_Size() int {
	return xxx_messageInfo_Field.Size(m)
}
func (m *Field) XXX_DiscardUnknown() {
	xxx_messageInfo_Field.DiscardUnknown(m)
}

var xxx_messageInfo_Field proto.InternalMessageInfo

func (m *Field) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Field) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *Field) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *Field) GetOrgTable() string {
	if m != nil {
		return m.OrgTable
	}
	return ""
}

func (m *Field) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *Field) GetOrgName() string {
	if m != nil {
		return m.OrgName
	}
	return ""
}

func (m *Field) GetColumnLength() uint32 {
	if m != nil {
		return m.ColumnLength
	}
	return 0
}

func (m *Field) GetCharset() uint32 {
	if m != nil {
		return m.Charset
	}
	return 0
}

func (m *Field) GetDecimals() uint32 {
	if m != nil {
		return m.Decimals
	}
	return 0
}

func (m *Field) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// Row is a database row.
type Row struct {
	// lengths contains the length of each value in values.
	// A length of -1 means that the field is NULL. While
	// reading values, you have to accummulate the length
	// to know the offset where the next value begins in values.
	Lengths []int64 `protobuf:"zigzag64,1,rep,packed,name=lengths,proto3" json:"lengths,omitempty"`
	// values contains a concatenation of all values in the row.
	Values               []byte   `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Row) Reset()         { *m = Row{} }
func (m *Row) String() string { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()    {}
func (*Row) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{8}
}

func (m *Row) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Row.Unmarshal(m, b)
}
func (m *Row) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Row.Marshal(b, m, deterministic)
}
func (m *Row) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Row.Merge(m, src)
}
func (m *Row) XXX_Size() int {
	return xxx_messageInfo_Row.Size(m)
}
func (m *Row) XXX_DiscardUnknown() {
	xxx_messageInfo_Row.DiscardUnknown(m)
}

var xxx_messageInfo_Row proto.InternalMessageInfo

func (m *Row) GetLengths() []int64 {
	if m != nil {
		return m.Lengths
	}
	return nil
}

func (m *Row) GetValues() []byte {
	if m != nil {
		return m.Values
	}
	return nil
}

// ResultExtras contains optional out-of-band information. Usually the
// extras are requested by adding ExecuteOptions flags.
type ResultExtras struct {
	// event_token is populated if the include_event_token flag is set
	// in ExecuteOptions.
	EventToken *EventToken `protobuf:"bytes,1,opt,name=event_token,json=eventToken,proto3" json:"event_token,omitempty"`
	// If set, it means the data returned with this result is fresher
	// than the compare_token passed in the ExecuteOptions.
	Fresher              bool     `protobuf:"varint,2,opt,name=fresher,proto3" json:"fresher,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResultExtras) Reset()         { *m = ResultExtras{} }
func (m *ResultExtras) String() string { return proto.CompactTextString(m) }
func (*ResultExtras) ProtoMessage()    {}
func (*ResultExtras) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{9}
}

func (m *ResultExtras) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResultExtras.Unmarshal(m, b)
}
func (m *ResultExtras) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResultExtras.Marshal(b, m, deterministic)
}
func (m *ResultExtras) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResultExtras.Merge(m, src)
}
func (m *ResultExtras) XXX_Size() int {
	return xxx_messageInfo_ResultExtras.Size(m)
}
func (m *ResultExtras) XXX_DiscardUnknown() {
	xxx_messageInfo_ResultExtras.DiscardUnknown(m)
}

var xxx_messageInfo_ResultExtras proto.InternalMessageInfo

func (m *ResultExtras) GetEventToken() *EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

func (m *ResultExtras) GetFresher() bool {
	if m != nil {
		return m.Fresher
	}
	return false
}

// QueryResult is returned by Execute and ExecuteStream.
//
// As returned by Execute, len(fields) is always equal to len(row)
// (for each row in rows).
//
// As returned by StreamExecute, the first QueryResult has the fields
// set, and subsequent QueryResult have rows set. And as Execute,
// len(QueryResult[0].fields) is always equal to len(row) (for each
// row in rows for each QueryResult in QueryResult[1:]).
type QueryResult struct {
	Fields               []*Field      `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	RowsAffected         uint64        `protobuf:"varint,2,opt,name=rows_affected,json=rowsAffected,proto3" json:"rows_affected,omitempty"`
	InsertId             uint64        `protobuf:"varint,3,opt,name=insert_id,json=insertId,proto3" json:"insert_id,omitempty"`
	Rows                 []*Row        `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
	Extras               *ResultExtras `protobuf:"bytes,5,opt,name=extras,proto3" json:"extras,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *QueryResult) Reset()         { *m = QueryResult{} }
func (m *QueryResult) String() string { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()    {}
func (*QueryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{10}
}

func (m *QueryResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResult.Unmarshal(m, b)
}
func (m *QueryResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResult.Marshal(b, m, deterministic)
}
func (m *QueryResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResult.Merge(m, src)
}
func (m *QueryResult) XXX_Size() int {
	return xxx_messageInfo_QueryResult.Size(m)
}
func (m *QueryResult) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResult.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResult proto.InternalMessageInfo

func (m *QueryResult) GetFields() []*Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *QueryResult) GetRowsAffected() uint64 {
	if m != nil {
		return m.RowsAffected
	}
	return 0
}

func (m *QueryResult) GetInsertId() uint64 {
	if m != nil {
		return m.InsertId
	}
	return 0
}

func (m *QueryResult) GetRows() []*Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *QueryResult) GetExtras() *ResultExtras {
	if m != nil {
		return m.Extras
	}
	return nil
}

// QueryWarning is used to convey out of band query execution warnings
// by storing in the vtgate.Session
type QueryWarning struct {
	Code                 uint32   `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryWarning) Reset()         { *m = QueryWarning{} }
func (m *QueryWarning) String() string { return proto.CompactTextString(m) }
func (*QueryWarning) ProtoMessage()    {}
func (*QueryWarning) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{11}
}

func (m *QueryWarning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryWarning.Unmarshal(m, b)
}
func (m *QueryWarning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryWarning.Marshal(b, m, deterministic)
}
func (m *QueryWarning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryWarning.Merge(m, src)
}
func (m *QueryWarning) XXX_Size() int {
	return xxx_messageInfo_QueryWarning.Size(m)
}
func (m *QueryWarning) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryWarning.DiscardUnknown(m)
}

var xxx_messageInfo_QueryWarning proto.InternalMessageInfo

func (m *QueryWarning) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *QueryWarning) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// StreamEvent describes a set of transformations that happened as a
// single transactional unit on a server. It is streamed back by the
// Update Stream calls.
type StreamEvent struct {
	// The statements in this transaction.
	Statements []*StreamEvent_Statement `protobuf:"bytes,1,rep,name=statements,proto3" json:"statements,omitempty"`
	// The Event Token for this event.
	EventToken           *EventToken `protobuf:"bytes,2,opt,name=event_token,json=eventToken,proto3" json:"event_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StreamEvent) Reset()         { *m = StreamEvent{} }
func (m *StreamEvent) String() string { return proto.CompactTextString(m) }
func (*StreamEvent) ProtoMessage()    {}
func (*StreamEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{12}
}

func (m *StreamEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamEvent.Unmarshal(m, b)
}
func (m *StreamEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamEvent.Marshal(b, m, deterministic)
}
func (m *StreamEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamEvent.Merge(m, src)
}
func (m *StreamEvent) XXX_Size() int {
	return xxx_messageInfo_StreamEvent.Size(m)
}
func (m *StreamEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamEvent.DiscardUnknown(m)
}

var xxx_messageInfo_StreamEvent proto.InternalMessageInfo

func (m *StreamEvent) GetStatements() []*StreamEvent_Statement {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *StreamEvent) GetEventToken() *EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

// One individual Statement in a transaction.
type StreamEvent_Statement struct {
	Category StreamEvent_Statement_Category `protobuf:"varint,1,opt,name=category,proto3,enum=query.StreamEvent_Statement_Category" json:"category,omitempty"`
	// table_name, primary_key_fields and primary_key_values are set for DML.
	TableName        string   `protobuf:"bytes,2,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	PrimaryKeyFields []*Field `protobuf:"bytes,3,rep,name=primary_key_fields,json=primaryKeyFields,proto3" json:"primary_key_fields,omitempty"`
	PrimaryKeyValues []*Row   `protobuf:"bytes,4,rep,name=primary_key_values,json=primaryKeyValues,proto3" json:"primary_key_values,omitempty"`
	// sql is set for all queries.
	// FIXME(alainjobart) we may not need it for DMLs.
	Sql                  []byte   `protobuf:"bytes,5,opt,name=sql,proto3" json:"sql,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamEvent_Statement) Reset()         { *m = StreamEvent_Statement{} }
func (m *StreamEvent_Statement) String() string { return proto.CompactTextString(m) }
func (*StreamEvent_Statement) ProtoMessage()    {}
func (*StreamEvent_Statement) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{12, 0}
}

func (m *StreamEvent_Statement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamEvent_Statement.Unmarshal(m, b)
}
func (m *StreamEvent_Statement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamEvent_Statement.Marshal(b, m, deterministic)
}
func (m *StreamEvent_Statement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamEvent_Statement.Merge(m, src)
}
func (m *StreamEvent_Statement) XXX_Size() int {
	return xxx_messageInfo_StreamEvent_Statement.Size(m)
}
func (m *StreamEvent_Statement) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamEvent_Statement.DiscardUnknown(m)
}

var xxx_messageInfo_StreamEvent_Statement proto.InternalMessageInfo

func (m *StreamEvent_Statement) GetCategory() StreamEvent_Statement_Category {
	if m != nil {
		return m.Category
	}
	return StreamEvent_Statement_Error
}

func (m *StreamEvent_Statement) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *StreamEvent_Statement) GetPrimaryKeyFields() []*Field {
	if m != nil {
		return m.PrimaryKeyFields
	}
	return nil
}

func (m *StreamEvent_Statement) GetPrimaryKeyValues() []*Row {
	if m != nil {
		return m.PrimaryKeyValues
	}
	return nil
}

func (m *StreamEvent_Statement) GetSql() []byte {
	if m != nil {
		return m.Sql
	}
	return nil
}

// ExecuteRequest is the payload to Execute
type ExecuteRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query                *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	TransactionId        int64           `protobuf:"varint,5,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Options              *ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ExecuteRequest) Reset()         { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()    {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{13}
}

func (m *ExecuteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteRequest.Unmarshal(m, b)
}
func (m *ExecuteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteRequest.Marshal(b, m, deterministic)
}
func (m *ExecuteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteRequest.Merge(m, src)
}
func (m *ExecuteRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteRequest.Size(m)
}
func (m *ExecuteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteRequest proto.InternalMessageInfo

func (m *ExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *ExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteResponse is the returned value from Execute
type ExecuteResponse struct {
	Result               *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ExecuteResponse) Reset()         { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()    {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{14}
}

func (m *ExecuteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteResponse.Unmarshal(m, b)
}
func (m *ExecuteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteResponse.Marshal(b, m, deterministic)
}
func (m *ExecuteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteResponse.Merge(m, src)
}
func (m *ExecuteResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteResponse.Size(m)
}
func (m *ExecuteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteResponse proto.InternalMessageInfo

func (m *ExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ResultWithError represents a query response
// in the form of result or error but not both.
// TODO: To be used in ExecuteBatchResponse and BeginExecuteBatchResponse.
type ResultWithError struct {
	// error contains an query level error, only set if result is unset.
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// result contains the query result, only set if error is unset.
	Result               *QueryResult `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ResultWithError) Reset()         { *m = ResultWithError{} }
func (m *ResultWithError) String() string { return proto.CompactTextString(m) }
func (*ResultWithError) ProtoMessage()    {}
func (*ResultWithError) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{15}
}

func (m *ResultWithError) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResultWithError.Unmarshal(m, b)
}
func (m *ResultWithError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResultWithError.Marshal(b, m, deterministic)
}
func (m *ResultWithError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResultWithError.Merge(m, src)
}
func (m *ResultWithError) XXX_Size() int {
	return xxx_messageInfo_ResultWithError.Size(m)
}
func (m *ResultWithError) XXX_DiscardUnknown() {
	xxx_messageInfo_ResultWithError.DiscardUnknown(m)
}

var xxx_messageInfo_ResultWithError proto.InternalMessageInfo

func (m *ResultWithError) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ResultWithError) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch
type ExecuteBatchRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Queries              []*BoundQuery   `protobuf:"bytes,4,rep,name=queries,proto3" json:"queries,omitempty"`
	AsTransaction        bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction,proto3" json:"as_transaction,omitempty"`
	TransactionId        int64           `protobuf:"varint,6,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Options              *ExecuteOptions `protobuf:"bytes,7,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ExecuteBatchRequest) Reset()         { *m = ExecuteBatchRequest{} }
func (m *ExecuteBatchRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchRequest) ProtoMessage()    {}
func (*ExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{16}
}

func (m *ExecuteBatchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchRequest.Unmarshal(m, b)
}
func (m *ExecuteBatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchRequest.Marshal(b, m, deterministic)
}
func (m *ExecuteBatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchRequest.Merge(m, src)
}
func (m *ExecuteBatchRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchRequest.Size(m)
}
func (m *ExecuteBatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchRequest proto.InternalMessageInfo

func (m *ExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteBatchRequest) GetQueries() []*BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *ExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch
type ExecuteBatchResponse struct {
	Results              []*QueryResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ExecuteBatchResponse) Reset()         { *m = ExecuteBatchResponse{} }
func (m *ExecuteBatchResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteBatchResponse) ProtoMessage()    {}
func (*ExecuteBatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{17}
}

func (m *ExecuteBatchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteBatchResponse.Unmarshal(m, b)
}
func (m *ExecuteBatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteBatchResponse.Marshal(b, m, deterministic)
}
func (m *ExecuteBatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteBatchResponse.Merge(m, src)
}
func (m *ExecuteBatchResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteBatchResponse.Size(m)
}
func (m *ExecuteBatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteBatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteBatchResponse proto.InternalMessageInfo

func (m *ExecuteBatchResponse) GetResults() []*QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute
type StreamExecuteRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query                *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	Options              *ExecuteOptions `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`
	TransactionId        int64           `protobuf:"varint,6,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StreamExecuteRequest) Reset()         { *m = StreamExecuteRequest{} }
func (m *StreamExecuteRequest) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteRequest) ProtoMessage()    {}
func (*StreamExecuteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{18}
}

func (m *StreamExecuteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteRequest.Unmarshal(m, b)
}
func (m *StreamExecuteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteRequest.Marshal(b, m, deterministic)
}
func (m *StreamExecuteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteRequest.Merge(m, src)
}
func (m *StreamExecuteRequest) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteRequest.Size(m)
}
func (m *StreamExecuteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteRequest proto.InternalMessageInfo

func (m *StreamExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *StreamExecuteRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// StreamExecuteResponse is the returned value from StreamExecute
type StreamExecuteResponse struct {
	Result               *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *StreamExecuteResponse) Reset()         { *m = StreamExecuteResponse{} }
func (m *StreamExecuteResponse) String() string { return proto.CompactTextString(m) }
func (*StreamExecuteResponse) ProtoMessage()    {}
func (*StreamExecuteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{19}
}

func (m *StreamExecuteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamExecuteResponse.Unmarshal(m, b)
}
func (m *StreamExecuteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamExecuteResponse.Marshal(b, m, deterministic)
}
func (m *StreamExecuteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamExecuteResponse.Merge(m, src)
}
func (m *StreamExecuteResponse) XXX_Size() int {
	return xxx_messageInfo_StreamExecuteResponse.Size(m)
}
func (m *StreamExecuteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamExecuteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamExecuteResponse proto.InternalMessageInfo

func (m *StreamExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// BeginRequest is the payload to Begin
type BeginRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Options              *ExecuteOptions `protobuf:"bytes,4,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *BeginRequest) Reset()         { *m = BeginRequest{} }
func (m *BeginRequest) String() string { return proto.CompactTextString(m) }
func (*BeginRequest) ProtoMessage()    {}
func (*BeginRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{20}
}

func (m *BeginRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginRequest.Unmarshal(m, b)
}
func (m *BeginRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginRequest.Marshal(b, m, deterministic)
}
func (m *BeginRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginRequest.Merge(m, src)
}
func (m *BeginRequest) XXX_Size() int {
	return xxx_messageInfo_BeginRequest.Size(m)
}
func (m *BeginRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginRequest proto.InternalMessageInfo

func (m *BeginRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginResponse is the returned value from Begin
type BeginResponse struct {
	TransactionId        int64    `protobuf:"varint,1,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginResponse) Reset()         { *m = BeginResponse{} }
func (m *BeginResponse) String() string { return proto.CompactTextString(m) }
func (*BeginResponse) ProtoMessage()    {}
func (*BeginResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{21}
}

func (m *BeginResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginResponse.Unmarshal(m, b)
}
func (m *BeginResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginResponse.Marshal(b, m, deterministic)
}
func (m *BeginResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginResponse.Merge(m, src)
}
func (m *BeginResponse) XXX_Size() int {
	return xxx_messageInfo_BeginResponse.Size(m)
}
func (m *BeginResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginResponse proto.InternalMessageInfo

func (m *BeginResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// CommitRequest is the payload to Commit
type CommitRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId        int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CommitRequest) Reset()         { *m = CommitRequest{} }
func (m *CommitRequest) String() string { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()    {}
func (*CommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{22}
}

func (m *CommitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitRequest.Unmarshal(m, b)
}
func (m *CommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitRequest.Marshal(b, m, deterministic)
}
func (m *CommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitRequest.Merge(m, src)
}
func (m *CommitRequest) XXX_Size() int {
	return xxx_messageInfo_CommitRequest.Size(m)
}
func (m *CommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitRequest proto.InternalMessageInfo

func (m *CommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CommitRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CommitRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// CommitResponse is the returned value from Commit
type CommitResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitResponse) Reset()         { *m = CommitResponse{} }
func (m *CommitResponse) String() string { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()    {}
func (*CommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{23}
}

func (m *CommitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitResponse.Unmarshal(m, b)
}
func (m *CommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitResponse.Marshal(b, m, deterministic)
}
func (m *CommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitResponse.Merge(m, src)
}
func (m *CommitResponse) XXX_Size() int {
	return xxx_messageInfo_CommitResponse.Size(m)
}
func (m *CommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitResponse proto.InternalMessageInfo

// RollbackRequest is the payload to Rollback
type RollbackRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId        int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *RollbackRequest) Reset()         { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()    {}
func (*RollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{24}
}

func (m *RollbackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackRequest.Unmarshal(m, b)
}
func (m *RollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackRequest.Marshal(b, m, deterministic)
}
func (m *RollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackRequest.Merge(m, src)
}
func (m *RollbackRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackRequest.Size(m)
}
func (m *RollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackRequest proto.InternalMessageInfo

func (m *RollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *RollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *RollbackRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RollbackRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// RollbackResponse is the returned value from Rollback
type RollbackResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackResponse) Reset()         { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()    {}
func (*RollbackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{25}
}

func (m *RollbackResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackResponse.Unmarshal(m, b)
}
func (m *RollbackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackResponse.Marshal(b, m, deterministic)
}
func (m *RollbackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackResponse.Merge(m, src)
}
func (m *RollbackResponse) XXX_Size() int {
	return xxx_messageInfo_RollbackResponse.Size(m)
}
func (m *RollbackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackResponse proto.InternalMessageInfo

// PrepareRequest is the payload to Prepare
type PrepareRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId        int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid                 string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PrepareRequest) Reset()         { *m = PrepareRequest{} }
func (m *PrepareRequest) String() string { return proto.CompactTextString(m) }
func (*PrepareRequest) ProtoMessage()    {}
func (*PrepareRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{26}
}

func (m *PrepareRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareRequest.Unmarshal(m, b)
}
func (m *PrepareRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareRequest.Marshal(b, m, deterministic)
}
func (m *PrepareRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareRequest.Merge(m, src)
}
func (m *PrepareRequest) XXX_Size() int {
	return xxx_messageInfo_PrepareRequest.Size(m)
}
func (m *PrepareRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareRequest proto.InternalMessageInfo

func (m *PrepareRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *PrepareRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *PrepareRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *PrepareRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *PrepareRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// PrepareResponse is the returned value from Prepare
type PrepareResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrepareResponse) Reset()         { *m = PrepareResponse{} }
func (m *PrepareResponse) String() string { return proto.CompactTextString(m) }
func (*PrepareResponse) ProtoMessage()    {}
func (*PrepareResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{27}
}

func (m *PrepareResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareResponse.Unmarshal(m, b)
}
func (m *PrepareResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareResponse.Marshal(b, m, deterministic)
}
func (m *PrepareResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareResponse.Merge(m, src)
}
func (m *PrepareResponse) XXX_Size() int {
	return xxx_messageInfo_PrepareResponse.Size(m)
}
func (m *PrepareResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareResponse proto.InternalMessageInfo

// CommitPreparedRequest is the payload to CommitPrepared
type CommitPreparedRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid                 string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CommitPreparedRequest) Reset()         { *m = CommitPreparedRequest{} }
func (m *CommitPreparedRequest) String() string { return proto.CompactTextString(m) }
func (*CommitPreparedRequest) ProtoMessage()    {}
func (*CommitPreparedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{28}
}

func (m *CommitPreparedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitPreparedRequest.Unmarshal(m, b)
}
func (m *CommitPreparedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitPreparedRequest.Marshal(b, m, deterministic)
}
func (m *CommitPreparedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitPreparedRequest.Merge(m, src)
}
func (m *CommitPreparedRequest) XXX_Size() int {
	return xxx_messageInfo_CommitPreparedRequest.Size(m)
}
func (m *CommitPreparedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitPreparedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitPreparedRequest proto.InternalMessageInfo

func (m *CommitPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CommitPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CommitPreparedRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CommitPreparedRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// CommitPreparedResponse is the returned value from CommitPrepared
type CommitPreparedResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitPreparedResponse) Reset()         { *m = CommitPreparedResponse{} }
func (m *CommitPreparedResponse) String() string { return proto.CompactTextString(m) }
func (*CommitPreparedResponse) ProtoMessage()    {}
func (*CommitPreparedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{29}
}

func (m *CommitPreparedResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitPreparedResponse.Unmarshal(m, b)
}
func (m *CommitPreparedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitPreparedResponse.Marshal(b, m, deterministic)
}
func (m *CommitPreparedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitPreparedResponse.Merge(m, src)
}
func (m *CommitPreparedResponse) XXX_Size() int {
	return xxx_messageInfo_CommitPreparedResponse.Size(m)
}
func (m *CommitPreparedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitPreparedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitPreparedResponse proto.InternalMessageInfo

// RollbackPreparedRequest is the payload to RollbackPrepared
type RollbackPreparedRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId        int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid                 string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *RollbackPreparedRequest) Reset()         { *m = RollbackPreparedRequest{} }
func (m *RollbackPreparedRequest) String() string { return proto.CompactTextString(m) }
func (*RollbackPreparedRequest) ProtoMessage()    {}
func (*RollbackPreparedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{30}
}

func (m *RollbackPreparedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackPreparedRequest.Unmarshal(m, b)
}
func (m *RollbackPreparedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackPreparedRequest.Marshal(b, m, deterministic)
}
func (m *RollbackPreparedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackPreparedRequest.Merge(m, src)
}
func (m *RollbackPreparedRequest) XXX_Size() int {
	return xxx_messageInfo_RollbackPreparedRequest.Size(m)
}
func (m *RollbackPreparedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackPreparedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackPreparedRequest proto.InternalMessageInfo

func (m *RollbackPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *RollbackPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *RollbackPreparedRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RollbackPreparedRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *RollbackPreparedRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// RollbackPreparedResponse is the returned value from RollbackPrepared
type RollbackPreparedResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RollbackPreparedResponse) Reset()         { *m = RollbackPreparedResponse{} }
func (m *RollbackPreparedResponse) String() string { return proto.CompactTextString(m) }
func (*RollbackPreparedResponse) ProtoMessage()    {}
func (*RollbackPreparedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{31}
}

func (m *RollbackPreparedResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollbackPreparedResponse.Unmarshal(m, b)
}
func (m *RollbackPreparedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollbackPreparedResponse.Marshal(b, m, deterministic)
}
func (m *RollbackPreparedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollbackPreparedResponse.Merge(m, src)
}
func (m *RollbackPreparedResponse) XXX_Size() int {
	return xxx_messageInfo_RollbackPreparedResponse.Size(m)
}
func (m *RollbackPreparedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RollbackPreparedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RollbackPreparedResponse proto.InternalMessageInfo

// CreateTransactionRequest is the payload to CreateTransaction
type CreateTransactionRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid                 string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
	Participants         []*Target       `protobuf:"bytes,5,rep,name=participants,proto3" json:"participants,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateTransactionRequest) Reset()         { *m = CreateTransactionRequest{} }
func (m *CreateTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTransactionRequest) ProtoMessage()    {}
func (*CreateTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{32}
}

func (m *CreateTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTransactionRequest.Unmarshal(m, b)
}
func (m *CreateTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTransactionRequest.Marshal(b, m, deterministic)
}
func (m *CreateTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTransactionRequest.Merge(m, src)
}
func (m *CreateTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTransactionRequest.Size(m)
}
func (m *CreateTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTransactionRequest proto.InternalMessageInfo

func (m *CreateTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CreateTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CreateTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CreateTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

func (m *CreateTransactionRequest) GetParticipants() []*Target {
	if m != nil {
		return m.Participants
	}
	return nil
}

// CreateTransactionResponse is the returned value from CreateTransaction
type CreateTransactionResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTransactionResponse) Reset()         { *m = CreateTransactionResponse{} }
func (m *CreateTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*CreateTransactionResponse) ProtoMessage()    {}
func (*CreateTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{33}
}

func (m *CreateTransactionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTransactionResponse.Unmarshal(m, b)
}
func (m *CreateTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTransactionResponse.Marshal(b, m, deterministic)
}
func (m *CreateTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTransactionResponse.Merge(m, src)
}
func (m *CreateTransactionResponse) XXX_Size() int {
	return xxx_messageInfo_CreateTransactionResponse.Size(m)
}
func (m *CreateTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTransactionResponse proto.InternalMessageInfo

// StartCommitRequest is the payload to StartCommit
type StartCommitRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId        int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid                 string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StartCommitRequest) Reset()         { *m = StartCommitRequest{} }
func (m *StartCommitRequest) String() string { return proto.CompactTextString(m) }
func (*StartCommitRequest) ProtoMessage()    {}
func (*StartCommitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{34}
}

func (m *StartCommitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartCommitRequest.Unmarshal(m, b)
}
func (m *StartCommitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartCommitRequest.Marshal(b, m, deterministic)
}
func (m *StartCommitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartCommitRequest.Merge(m, src)
}
func (m *StartCommitRequest) XXX_Size() int {
	return xxx_messageInfo_StartCommitRequest.Size(m)
}
func (m *StartCommitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartCommitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartCommitRequest proto.InternalMessageInfo

func (m *StartCommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *StartCommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *StartCommitRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StartCommitRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *StartCommitRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// StartCommitResponse is the returned value from StartCommit
type StartCommitResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartCommitResponse) Reset()         { *m = StartCommitResponse{} }
func (m *StartCommitResponse) String() string { return proto.CompactTextString(m) }
func (*StartCommitResponse) ProtoMessage()    {}
func (*StartCommitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{35}
}

func (m *StartCommitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartCommitResponse.Unmarshal(m, b)
}
func (m *StartCommitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartCommitResponse.Marshal(b, m, deterministic)
}
func (m *StartCommitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartCommitResponse.Merge(m, src)
}
func (m *StartCommitResponse) XXX_Size() int {
	return xxx_messageInfo_StartCommitResponse.Size(m)
}
func (m *StartCommitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartCommitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartCommitResponse proto.InternalMessageInfo

// SetRollbackRequest is the payload to SetRollback
type SetRollbackRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	TransactionId        int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	Dtid                 string          `protobuf:"bytes,5,opt,name=dtid,proto3" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SetRollbackRequest) Reset()         { *m = SetRollbackRequest{} }
func (m *SetRollbackRequest) String() string { return proto.CompactTextString(m) }
func (*SetRollbackRequest) ProtoMessage()    {}
func (*SetRollbackRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{36}
}

func (m *SetRollbackRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetRollbackRequest.Unmarshal(m, b)
}
func (m *SetRollbackRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetRollbackRequest.Marshal(b, m, deterministic)
}
func (m *SetRollbackRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetRollbackRequest.Merge(m, src)
}
func (m *SetRollbackRequest) XXX_Size() int {
	return xxx_messageInfo_SetRollbackRequest.Size(m)
}
func (m *SetRollbackRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetRollbackRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetRollbackRequest proto.InternalMessageInfo

func (m *SetRollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *SetRollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *SetRollbackRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SetRollbackRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *SetRollbackRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// SetRollbackResponse is the returned value from SetRollback
type SetRollbackResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetRollbackResponse) Reset()         { *m = SetRollbackResponse{} }
func (m *SetRollbackResponse) String() string { return proto.CompactTextString(m) }
func (*SetRollbackResponse) ProtoMessage()    {}
func (*SetRollbackResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{37}
}

func (m *SetRollbackResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetRollbackResponse.Unmarshal(m, b)
}
func (m *SetRollbackResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetRollbackResponse.Marshal(b, m, deterministic)
}
func (m *SetRollbackResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetRollbackResponse.Merge(m, src)
}
func (m *SetRollbackResponse) XXX_Size() int {
	return xxx_messageInfo_SetRollbackResponse.Size(m)
}
func (m *SetRollbackResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SetRollbackResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SetRollbackResponse proto.InternalMessageInfo

// ConcludeTransactionRequest is the payload to ConcludeTransaction
type ConcludeTransactionRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid                 string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ConcludeTransactionRequest) Reset()         { *m = ConcludeTransactionRequest{} }
func (m *ConcludeTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*ConcludeTransactionRequest) ProtoMessage()    {}
func (*ConcludeTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{38}
}

func (m *ConcludeTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConcludeTransactionRequest.Unmarshal(m, b)
}
func (m *ConcludeTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConcludeTransactionRequest.Marshal(b, m, deterministic)
}
func (m *ConcludeTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConcludeTransactionRequest.Merge(m, src)
}
func (m *ConcludeTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_ConcludeTransactionRequest.Size(m)
}
func (m *ConcludeTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConcludeTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConcludeTransactionRequest proto.InternalMessageInfo

func (m *ConcludeTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// ConcludeTransactionResponse is the returned value from ConcludeTransaction
type ConcludeTransactionResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConcludeTransactionResponse) Reset()         { *m = ConcludeTransactionResponse{} }
func (m *ConcludeTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*ConcludeTransactionResponse) ProtoMessage()    {}
func (*ConcludeTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{39}
}

func (m *ConcludeTransactionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConcludeTransactionResponse.Unmarshal(m, b)
}
func (m *ConcludeTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConcludeTransactionResponse.Marshal(b, m, deterministic)
}
func (m *ConcludeTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConcludeTransactionResponse.Merge(m, src)
}
func (m *ConcludeTransactionResponse) XXX_Size() int {
	return xxx_messageInfo_ConcludeTransactionResponse.Size(m)
}
func (m *ConcludeTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConcludeTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConcludeTransactionResponse proto.InternalMessageInfo

// ReadTransactionRequest is the payload to ReadTransaction
type ReadTransactionRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Dtid                 string          `protobuf:"bytes,4,opt,name=dtid,proto3" json:"dtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ReadTransactionRequest) Reset()         { *m = ReadTransactionRequest{} }
func (m *ReadTransactionRequest) String() string { return proto.CompactTextString(m) }
func (*ReadTransactionRequest) ProtoMessage()    {}
func (*ReadTransactionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{40}
}

func (m *ReadTransactionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadTransactionRequest.Unmarshal(m, b)
}
func (m *ReadTransactionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadTransactionRequest.Marshal(b, m, deterministic)
}
func (m *ReadTransactionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadTransactionRequest.Merge(m, src)
}
func (m *ReadTransactionRequest) XXX_Size() int {
	return xxx_messageInfo_ReadTransactionRequest.Size(m)
}
func (m *ReadTransactionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadTransactionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadTransactionRequest proto.InternalMessageInfo

func (m *ReadTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ReadTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ReadTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ReadTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// ReadTransactionResponse is the returned value from ReadTransaction
type ReadTransactionResponse struct {
	Metadata             *TransactionMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ReadTransactionResponse) Reset()         { *m = ReadTransactionResponse{} }
func (m *ReadTransactionResponse) String() string { return proto.CompactTextString(m) }
func (*ReadTransactionResponse) ProtoMessage()    {}
func (*ReadTransactionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{41}
}

func (m *ReadTransactionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadTransactionResponse.Unmarshal(m, b)
}
func (m *ReadTransactionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadTransactionResponse.Marshal(b, m, deterministic)
}
func (m *ReadTransactionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadTransactionResponse.Merge(m, src)
}
func (m *ReadTransactionResponse) XXX_Size() int {
	return xxx_messageInfo_ReadTransactionResponse.Size(m)
}
func (m *ReadTransactionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadTransactionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReadTransactionResponse proto.InternalMessageInfo

func (m *ReadTransactionResponse) GetMetadata() *TransactionMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// BeginExecuteRequest is the payload to BeginExecute
type BeginExecuteRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query                *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	Options              *ExecuteOptions `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *BeginExecuteRequest) Reset()         { *m = BeginExecuteRequest{} }
func (m *BeginExecuteRequest) String() string { return proto.CompactTextString(m) }
func (*BeginExecuteRequest) ProtoMessage()    {}
func (*BeginExecuteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{42}
}

func (m *BeginExecuteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginExecuteRequest.Unmarshal(m, b)
}
func (m *BeginExecuteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginExecuteRequest.Marshal(b, m, deterministic)
}
func (m *BeginExecuteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginExecuteRequest.Merge(m, src)
}
func (m *BeginExecuteRequest) XXX_Size() int {
	return xxx_messageInfo_BeginExecuteRequest.Size(m)
}
func (m *BeginExecuteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginExecuteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginExecuteRequest proto.InternalMessageInfo

func (m *BeginExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BeginExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginExecuteResponse is the returned value from BeginExecute
type BeginExecuteResponse struct {
	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error  *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Result *QueryResult    `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId        int64    `protobuf:"varint,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginExecuteResponse) Reset()         { *m = BeginExecuteResponse{} }
func (m *BeginExecuteResponse) String() string { return proto.CompactTextString(m) }
func (*BeginExecuteResponse) ProtoMessage()    {}
func (*BeginExecuteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{43}
}

func (m *BeginExecuteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginExecuteResponse.Unmarshal(m, b)
}
func (m *BeginExecuteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginExecuteResponse.Marshal(b, m, deterministic)
}
func (m *BeginExecuteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginExecuteResponse.Merge(m, src)
}
func (m *BeginExecuteResponse) XXX_Size() int {
	return xxx_messageInfo_BeginExecuteResponse.Size(m)
}
func (m *BeginExecuteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginExecuteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginExecuteResponse proto.InternalMessageInfo

func (m *BeginExecuteResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BeginExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *BeginExecuteResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// BeginExecuteBatchRequest is the payload to BeginExecuteBatch
type BeginExecuteBatchRequest struct {
	EffectiveCallerId    *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Queries              []*BoundQuery   `protobuf:"bytes,4,rep,name=queries,proto3" json:"queries,omitempty"`
	AsTransaction        bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction,proto3" json:"as_transaction,omitempty"`
	Options              *ExecuteOptions `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *BeginExecuteBatchRequest) Reset()         { *m = BeginExecuteBatchRequest{} }
func (m *BeginExecuteBatchRequest) String() string { return proto.CompactTextString(m) }
func (*BeginExecuteBatchRequest) ProtoMessage()    {}
func (*BeginExecuteBatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{44}
}

func (m *BeginExecuteBatchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginExecuteBatchRequest.Unmarshal(m, b)
}
func (m *BeginExecuteBatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginExecuteBatchRequest.Marshal(b, m, deterministic)
}
func (m *BeginExecuteBatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginExecuteBatchRequest.Merge(m, src)
}
func (m *BeginExecuteBatchRequest) XXX_Size() int {
	return xxx_messageInfo_BeginExecuteBatchRequest.Size(m)
}
func (m *BeginExecuteBatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginExecuteBatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BeginExecuteBatchRequest proto.InternalMessageInfo

func (m *BeginExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetQueries() []*BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *BeginExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginExecuteBatchResponse is the returned value from BeginExecuteBatch
type BeginExecuteBatchResponse struct {
	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error   *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Results []*QueryResult  `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId        int64    `protobuf:"varint,3,opt,name=transaction_id,json=transactionId,proto3" json:"transaction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeginExecuteBatchResponse) Reset()         { *m = BeginExecuteBatchResponse{} }
func (m *BeginExecuteBatchResponse) String() string { return proto.CompactTextString(m) }
func (*BeginExecuteBatchResponse) ProtoMessage()    {}
func (*BeginExecuteBatchResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{45}
}

func (m *BeginExecuteBatchResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeginExecuteBatchResponse.Unmarshal(m, b)
}
func (m *BeginExecuteBatchResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeginExecuteBatchResponse.Marshal(b, m, deterministic)
}
func (m *BeginExecuteBatchResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeginExecuteBatchResponse.Merge(m, src)
}
func (m *BeginExecuteBatchResponse) XXX_Size() int {
	return xxx_messageInfo_BeginExecuteBatchResponse.Size(m)
}
func (m *BeginExecuteBatchResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BeginExecuteBatchResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BeginExecuteBatchResponse proto.InternalMessageInfo

func (m *BeginExecuteBatchResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BeginExecuteBatchResponse) GetResults() []*QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *BeginExecuteBatchResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// MessageStreamRequest is the request payload for MessageStream.
type MessageStreamRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// name is the message table name.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MessageStreamRequest) Reset()         { *m = MessageStreamRequest{} }
func (m *MessageStreamRequest) String() string { return proto.CompactTextString(m) }
func (*MessageStreamRequest) ProtoMessage()    {}
func (*MessageStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{46}
}

func (m *MessageStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageStreamRequest.Unmarshal(m, b)
}
func (m *MessageStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageStreamRequest.Marshal(b, m, deterministic)
}
func (m *MessageStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageStreamRequest.Merge(m, src)
}
func (m *MessageStreamRequest) XXX_Size() int {
	return xxx_messageInfo_MessageStreamRequest.Size(m)
}
func (m *MessageStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MessageStreamRequest proto.InternalMessageInfo

func (m *MessageStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MessageStreamRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// MessageStreamResponse is a response for MessageStream.
type MessageStreamResponse struct {
	Result               *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *MessageStreamResponse) Reset()         { *m = MessageStreamResponse{} }
func (m *MessageStreamResponse) String() string { return proto.CompactTextString(m) }
func (*MessageStreamResponse) ProtoMessage()    {}
func (*MessageStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{47}
}

func (m *MessageStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageStreamResponse.Unmarshal(m, b)
}
func (m *MessageStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageStreamResponse.Marshal(b, m, deterministic)
}
func (m *MessageStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageStreamResponse.Merge(m, src)
}
func (m *MessageStreamResponse) XXX_Size() int {
	return xxx_messageInfo_MessageStreamResponse.Size(m)
}
func (m *MessageStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MessageStreamResponse proto.InternalMessageInfo

func (m *MessageStreamResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// MessageAckRequest is the request payload for MessageAck.
type MessageAckRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// name is the message table name.
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	Ids                  []*Value `protobuf:"bytes,5,rep,name=ids,proto3" json:"ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MessageAckRequest) Reset()         { *m = MessageAckRequest{} }
func (m *MessageAckRequest) String() string { return proto.CompactTextString(m) }
func (*MessageAckRequest) ProtoMessage()    {}
func (*MessageAckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{48}
}

func (m *MessageAckRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageAckRequest.Unmarshal(m, b)
}
func (m *MessageAckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageAckRequest.Marshal(b, m, deterministic)
}
func (m *MessageAckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageAckRequest.Merge(m, src)
}
func (m *MessageAckRequest) XXX_Size() int {
	return xxx_messageInfo_MessageAckRequest.Size(m)
}
func (m *MessageAckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageAckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MessageAckRequest proto.InternalMessageInfo

func (m *MessageAckRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *MessageAckRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *MessageAckRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MessageAckRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MessageAckRequest) GetIds() []*Value {
	if m != nil {
		return m.Ids
	}
	return nil
}

// MessageAckResponse is the response for MessageAck.
type MessageAckResponse struct {
	// result contains the result of the ack operation.
	// Since this acts like a DML, only
	// RowsAffected is returned in the result.
	Result               *QueryResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *MessageAckResponse) Reset()         { *m = MessageAckResponse{} }
func (m *MessageAckResponse) String() string { return proto.CompactTextString(m) }
func (*MessageAckResponse) ProtoMessage()    {}
func (*MessageAckResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{49}
}

func (m *MessageAckResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageAckResponse.Unmarshal(m, b)
}
func (m *MessageAckResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageAckResponse.Marshal(b, m, deterministic)
}
func (m *MessageAckResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageAckResponse.Merge(m, src)
}
func (m *MessageAckResponse) XXX_Size() int {
	return xxx_messageInfo_MessageAckResponse.Size(m)
}
func (m *MessageAckResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageAckResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MessageAckResponse proto.InternalMessageInfo

func (m *MessageAckResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// SplitQueryRequest is the payload for SplitQuery sent by VTGate to a VTTablet.
// See vtgate.SplitQueryRequest for more details.
type SplitQueryRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	SplitColumn       []string        `protobuf:"bytes,5,rep,name=split_column,json=splitColumn,proto3" json:"split_column,omitempty"`
	// Exactly one of the following must be nonzero.
	SplitCount           int64                       `protobuf:"varint,6,opt,name=split_count,json=splitCount,proto3" json:"split_count,omitempty"`
	NumRowsPerQueryPart  int64                       `protobuf:"varint,8,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart,proto3" json:"num_rows_per_query_part,omitempty"`
	Algorithm            SplitQueryRequest_Algorithm `protobuf:"varint,9,opt,name=algorithm,proto3,enum=query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *SplitQueryRequest) Reset()         { *m = SplitQueryRequest{} }
func (m *SplitQueryRequest) String() string { return proto.CompactTextString(m) }
func (*SplitQueryRequest) ProtoMessage()    {}
func (*SplitQueryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{50}
}

func (m *SplitQueryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitQueryRequest.Unmarshal(m, b)
}
func (m *SplitQueryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitQueryRequest.Marshal(b, m, deterministic)
}
func (m *SplitQueryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitQueryRequest.Merge(m, src)
}
func (m *SplitQueryRequest) XXX_Size() int {
	return xxx_messageInfo_SplitQueryRequest.Size(m)
}
func (m *SplitQueryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitQueryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SplitQueryRequest proto.InternalMessageInfo

func (m *SplitQueryRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SplitQueryRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitColumn() []string {
	if m != nil {
		return m.SplitColumn
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitCount() int64 {
	if m != nil {
		return m.SplitCount
	}
	return 0
}

func (m *SplitQueryRequest) GetNumRowsPerQueryPart() int64 {
	if m != nil {
		return m.NumRowsPerQueryPart
	}
	return 0
}

func (m *SplitQueryRequest) GetAlgorithm() SplitQueryRequest_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return SplitQueryRequest_EQUAL_SPLITS
}

// QuerySplit represents one query to execute on the tablet
type QuerySplit struct {
	// query is the query to execute
	Query *BoundQuery `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// row_count is the approximate row count the query will return
	RowCount             int64    `protobuf:"varint,2,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QuerySplit) Reset()         { *m = QuerySplit{} }
func (m *QuerySplit) String() string { return proto.CompactTextString(m) }
func (*QuerySplit) ProtoMessage()    {}
func (*QuerySplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{51}
}

func (m *QuerySplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QuerySplit.Unmarshal(m, b)
}
func (m *QuerySplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QuerySplit.Marshal(b, m, deterministic)
}
func (m *QuerySplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuerySplit.Merge(m, src)
}
func (m *QuerySplit) XXX_Size() int {
	return xxx_messageInfo_QuerySplit.Size(m)
}
func (m *QuerySplit) XXX_DiscardUnknown() {
	xxx_messageInfo_QuerySplit.DiscardUnknown(m)
}

var xxx_messageInfo_QuerySplit proto.InternalMessageInfo

func (m *QuerySplit) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *QuerySplit) GetRowCount() int64 {
	if m != nil {
		return m.RowCount
	}
	return 0
}

// SplitQueryResponse is returned by SplitQuery and represents all the queries
// to execute in order to get the entire data set.
type SplitQueryResponse struct {
	Queries              []*QuerySplit `protobuf:"bytes,1,rep,name=queries,proto3" json:"queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SplitQueryResponse) Reset()         { *m = SplitQueryResponse{} }
func (m *SplitQueryResponse) String() string { return proto.CompactTextString(m) }
func (*SplitQueryResponse) ProtoMessage()    {}
func (*SplitQueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{52}
}

func (m *SplitQueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SplitQueryResponse.Unmarshal(m, b)
}
func (m *SplitQueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SplitQueryResponse.Marshal(b, m, deterministic)
}
func (m *SplitQueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SplitQueryResponse.Merge(m, src)
}
func (m *SplitQueryResponse) XXX_Size() int {
	return xxx_messageInfo_SplitQueryResponse.Size(m)
}
func (m *SplitQueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SplitQueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SplitQueryResponse proto.InternalMessageInfo

func (m *SplitQueryResponse) GetQueries() []*QuerySplit {
	if m != nil {
		return m.Queries
	}
	return nil
}

// StreamHealthRequest is the payload for StreamHealth
type StreamHealthRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamHealthRequest) Reset()         { *m = StreamHealthRequest{} }
func (m *StreamHealthRequest) String() string { return proto.CompactTextString(m) }
func (*StreamHealthRequest) ProtoMessage()    {}
func (*StreamHealthRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{53}
}

func (m *StreamHealthRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamHealthRequest.Unmarshal(m, b)
}
func (m *StreamHealthRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamHealthRequest.Marshal(b, m, deterministic)
}
func (m *StreamHealthRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamHealthRequest.Merge(m, src)
}
func (m *StreamHealthRequest) XXX_Size() int {
	return xxx_messageInfo_StreamHealthRequest.Size(m)
}
func (m *StreamHealthRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamHealthRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamHealthRequest proto.InternalMessageInfo

// RealtimeStats contains information about the tablet status.
// It is only valid for a single tablet.
type RealtimeStats struct {
	// health_error is the last error we got from health check,
	// or empty is the server is healthy. This is used for subset selection,
	// we do not send queries to servers that are not healthy.
	HealthError string `protobuf:"bytes,1,opt,name=health_error,json=healthError,proto3" json:"health_error,omitempty"`
	// seconds_behind_master is populated for slaves only. It indicates
	// how far behind on (MySQL) replication a slave currently is.  It is used
	// by clients for subset selection (so we don't try to send traffic
	// to tablets that are too far behind).
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// TODO(mberlin): Let's switch it to int64 instead?
	SecondsBehindMaster uint32 `protobuf:"varint,2,opt,name=seconds_behind_master,json=secondsBehindMaster,proto3" json:"seconds_behind_master,omitempty"`
	// bin_log_players_count is the number of currently running binlog players.
	// if the value is 0, it means that filtered replication is currently not
	// running on the tablet. If >0, filtered replication is running.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	BinlogPlayersCount int32 `protobuf:"varint,3,opt,name=binlog_players_count,json=binlogPlayersCount,proto3" json:"binlog_players_count,omitempty"`
	// seconds_behind_master_filtered_replication is populated for the receiving
	// master of an ongoing filtered replication only.
	// It specifies how far the receiving master lags behind the sending master.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// NOTE: This field must not be evaluated if "bin_log_players_count" is 0.
	SecondsBehindMasterFilteredReplication int64 `protobuf:"varint,4,opt,name=seconds_behind_master_filtered_replication,json=secondsBehindMasterFilteredReplication,proto3" json:"seconds_behind_master_filtered_replication,omitempty"`
	// cpu_usage is used for load-based balancing
	CpuUsage float64 `protobuf:"fixed64,5,opt,name=cpu_usage,json=cpuUsage,proto3" json:"cpu_usage,omitempty"`
	// qps is the average QPS (queries per second) rate in the last XX seconds
	// where XX is usually 60 (See query_service_stats.go).
	Qps                  float64  `protobuf:"fixed64,6,opt,name=qps,proto3" json:"qps,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RealtimeStats) Reset()         { *m = RealtimeStats{} }
func (m *RealtimeStats) String() string { return proto.CompactTextString(m) }
func (*RealtimeStats) ProtoMessage()    {}
func (*RealtimeStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{54}
}

func (m *RealtimeStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RealtimeStats.Unmarshal(m, b)
}
func (m *RealtimeStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RealtimeStats.Marshal(b, m, deterministic)
}
func (m *RealtimeStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RealtimeStats.Merge(m, src)
}
func (m *RealtimeStats) XXX_Size() int {
	return xxx_messageInfo_RealtimeStats.Size(m)
}
func (m *RealtimeStats) XXX_DiscardUnknown() {
	xxx_messageInfo_RealtimeStats.DiscardUnknown(m)
}

var xxx_messageInfo_RealtimeStats proto.InternalMessageInfo

func (m *RealtimeStats) GetHealthError() string {
	if m != nil {
		return m.HealthError
	}
	return ""
}

func (m *RealtimeStats) GetSecondsBehindMaster() uint32 {
	if m != nil {
		return m.SecondsBehindMaster
	}
	return 0
}

func (m *RealtimeStats) GetBinlogPlayersCount() int32 {
	if m != nil {
		return m.BinlogPlayersCount
	}
	return 0
}

func (m *RealtimeStats) GetSecondsBehindMasterFilteredReplication() int64 {
	if m != nil {
		return m.SecondsBehindMasterFilteredReplication
	}
	return 0
}

func (m *RealtimeStats) GetCpuUsage() float64 {
	if m != nil {
		return m.CpuUsage
	}
	return 0
}

func (m *RealtimeStats) GetQps() float64 {
	if m != nil {
		return m.Qps
	}
	return 0
}

// AggregateStats contains information about the health of a group of
// tablets for a Target.  It is used to propagate stats from a vtgate
// to another, or from the Gateway layer of a vtgate to the routing
// layer.
type AggregateStats struct {
	// healthy_tablet_count is the number of healthy tablets in the group.
	HealthyTabletCount int32 `protobuf:"varint,1,opt,name=healthy_tablet_count,json=healthyTabletCount,proto3" json:"healthy_tablet_count,omitempty"`
	// unhealthy_tablet_count is the number of unhealthy tablets in the group.
	UnhealthyTabletCount int32 `protobuf:"varint,2,opt,name=unhealthy_tablet_count,json=unhealthyTabletCount,proto3" json:"unhealthy_tablet_count,omitempty"`
	// seconds_behind_master_min is the minimum of the
	// seconds_behind_master values of the healthy tablets. It is unset
	// if the tablet type is master.
	SecondsBehindMasterMin uint32 `protobuf:"varint,3,opt,name=seconds_behind_master_min,json=secondsBehindMasterMin,proto3" json:"seconds_behind_master_min,omitempty"`
	// seconds_behind_master_max is the maximum of the
	// seconds_behind_master values of the healthy tablets. It is unset
	// if the tablet type is master.
	SecondsBehindMasterMax uint32   `protobuf:"varint,4,opt,name=seconds_behind_master_max,json=secondsBehindMasterMax,proto3" json:"seconds_behind_master_max,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *AggregateStats) Reset()         { *m = AggregateStats{} }
func (m *AggregateStats) String() string { return proto.CompactTextString(m) }
func (*AggregateStats) ProtoMessage()    {}
func (*AggregateStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{55}
}

func (m *AggregateStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AggregateStats.Unmarshal(m, b)
}
func (m *AggregateStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AggregateStats.Marshal(b, m, deterministic)
}
func (m *AggregateStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AggregateStats.Merge(m, src)
}
func (m *AggregateStats) XXX_Size() int {
	return xxx_messageInfo_AggregateStats.Size(m)
}
func (m *AggregateStats) XXX_DiscardUnknown() {
	xxx_messageInfo_AggregateStats.DiscardUnknown(m)
}

var xxx_messageInfo_AggregateStats proto.InternalMessageInfo

func (m *AggregateStats) GetHealthyTabletCount() int32 {
	if m != nil {
		return m.HealthyTabletCount
	}
	return 0
}

func (m *AggregateStats) GetUnhealthyTabletCount() int32 {
	if m != nil {
		return m.UnhealthyTabletCount
	}
	return 0
}

func (m *AggregateStats) GetSecondsBehindMasterMin() uint32 {
	if m != nil {
		return m.SecondsBehindMasterMin
	}
	return 0
}

func (m *AggregateStats) GetSecondsBehindMasterMax() uint32 {
	if m != nil {
		return m.SecondsBehindMasterMax
	}
	return 0
}

// StreamHealthResponse is streamed by StreamHealth on a regular basis.
// It is expected to be used between a vtgate and vttablet:
// - target describes the tablet.
// - realtime_stats is set.
// - aggregate_stats is not set (deprecated)
type StreamHealthResponse struct {
	// target is the current server type. Only queries with that exact Target
	// record will be accepted (the cell may not match, however).
	Target *Target `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// serving is true iff the tablet is serving. A tablet may not be serving
	// if filtered replication is enabled on a master for instance,
	// or if a replica should not be used because the keyspace is being resharded.
	Serving bool `protobuf:"varint,2,opt,name=serving,proto3" json:"serving,omitempty"`
	// tablet_externally_reparented_timestamp can be interpreted as the
	// last time we knew that this tablet was the MASTER of this shard
	// (if StreamHealthResponse describes a group of tablets, between
	// two vtgates, only one master will be present in the group, and
	// this is this master's value).
	//
	// It is used by vtgate when determining the current MASTER of a shard.
	// If vtgate sees more than one MASTER tablet, this timestamp is used
	// as tiebreaker where the MASTER with the highest timestamp wins.
	// Another usage of this timestamp is in go/vt/vtgate/buffer to detect the end
	// of a reparent (failover) and stop buffering.
	//
	// In practice, this field is set to:
	// a) the last time the RPC tabletmanager.TabletExternallyReparented was
	//    called on this tablet (usually done by an external failover tool e.g.
	//    Orchestrator). The failover tool can call this as long as we are the
	//    master i.e. even ages after the last reparent occurred.
	// OR
	// b) the last time an active reparent was executed through a vtctl command
	//    (InitShardMaster, PlannedReparentShard, EmergencyReparentShard)
	// OR
	// c) the last time vttablet was started and it initialized its tablet type
	//    as MASTER because it was recorded as the shard's current master in the
	//    topology (see go/vt/vttablet/tabletmanager/init_tablet.go)
	// OR
	// d) 0 if the vttablet was never a MASTER.
	TabletExternallyReparentedTimestamp int64 `protobuf:"varint,3,opt,name=tablet_externally_reparented_timestamp,json=tabletExternallyReparentedTimestamp,proto3" json:"tablet_externally_reparented_timestamp,omitempty"`
	// realtime_stats contains information about the tablet status.
	// It is only filled in if the information is about a tablet.
	RealtimeStats *RealtimeStats `protobuf:"bytes,4,opt,name=realtime_stats,json=realtimeStats,proto3" json:"realtime_stats,omitempty"`
	// tablet_alias is the alias of the sending tablet. The discovery/healthcheck.go
	// code uses it to verify that it's talking to the correct tablet and that it
	// hasn't changed in the meantime e.g. due to tablet restarts where ports or
	// ips have been reused but assigned differently.
	TabletAlias          *topodata.TabletAlias `protobuf:"bytes,5,opt,name=tablet_alias,json=tabletAlias,proto3" json:"tablet_alias,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StreamHealthResponse) Reset()         { *m = StreamHealthResponse{} }
func (m *StreamHealthResponse) String() string { return proto.CompactTextString(m) }
func (*StreamHealthResponse) ProtoMessage()    {}
func (*StreamHealthResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{56}
}

func (m *StreamHealthResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamHealthResponse.Unmarshal(m, b)
}
func (m *StreamHealthResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamHealthResponse.Marshal(b, m, deterministic)
}
func (m *StreamHealthResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamHealthResponse.Merge(m, src)
}
func (m *StreamHealthResponse) XXX_Size() int {
	return xxx_messageInfo_StreamHealthResponse.Size(m)
}
func (m *StreamHealthResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamHealthResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamHealthResponse proto.InternalMessageInfo

func (m *StreamHealthResponse) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamHealthResponse) GetServing() bool {
	if m != nil {
		return m.Serving
	}
	return false
}

func (m *StreamHealthResponse) GetTabletExternallyReparentedTimestamp() int64 {
	if m != nil {
		return m.TabletExternallyReparentedTimestamp
	}
	return 0
}

func (m *StreamHealthResponse) GetRealtimeStats() *RealtimeStats {
	if m != nil {
		return m.RealtimeStats
	}
	return nil
}

func (m *StreamHealthResponse) GetTabletAlias() *topodata.TabletAlias {
	if m != nil {
		return m.TabletAlias
	}
	return nil
}

// UpdateStreamRequest is the payload for UpdateStream. At most one of
// position and timestamp can be set. If neither is set, we will start
// streaming from the current binlog position.
type UpdateStreamRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// If position is set, we will start the streaming from that replication
	// position. Incompatible with timestamp.
	Position string `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
	// If timestamp is set, we will start the streaming from the first
	// event in the binlogs that have that timestamp. Incompatible with position.
	Timestamp            int64    `protobuf:"varint,5,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateStreamRequest) Reset()         { *m = UpdateStreamRequest{} }
func (m *UpdateStreamRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateStreamRequest) ProtoMessage()    {}
func (*UpdateStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{57}
}

func (m *UpdateStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateStreamRequest.Unmarshal(m, b)
}
func (m *UpdateStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateStreamRequest.Marshal(b, m, deterministic)
}
func (m *UpdateStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateStreamRequest.Merge(m, src)
}
func (m *UpdateStreamRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateStreamRequest.Size(m)
}
func (m *UpdateStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateStreamRequest proto.InternalMessageInfo

func (m *UpdateStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *UpdateStreamRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *UpdateStreamRequest) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

// UpdateStreamResponse is returned by UpdateStream
type UpdateStreamResponse struct {
	Event                *StreamEvent `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *UpdateStreamResponse) Reset()         { *m = UpdateStreamResponse{} }
func (m *UpdateStreamResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateStreamResponse) ProtoMessage()    {}
func (*UpdateStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{58}
}

func (m *UpdateStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateStreamResponse.Unmarshal(m, b)
}
func (m *UpdateStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateStreamResponse.Marshal(b, m, deterministic)
}
func (m *UpdateStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateStreamResponse.Merge(m, src)
}
func (m *UpdateStreamResponse) XXX_Size() int {
	return xxx_messageInfo_UpdateStreamResponse.Size(m)
}
func (m *UpdateStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateStreamResponse proto.InternalMessageInfo

func (m *UpdateStreamResponse) GetEvent() *StreamEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

// TransactionMetadata contains the metadata for a distributed transaction.
type TransactionMetadata struct {
	Dtid                 string           `protobuf:"bytes,1,opt,name=dtid,proto3" json:"dtid,omitempty"`
	State                TransactionState `protobuf:"varint,2,opt,name=state,proto3,enum=query.TransactionState" json:"state,omitempty"`
	TimeCreated          int64            `protobuf:"varint,3,opt,name=time_created,json=timeCreated,proto3" json:"time_created,omitempty"`
	Participants         []*Target        `protobuf:"bytes,4,rep,name=participants,proto3" json:"participants,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *TransactionMetadata) Reset()         { *m = TransactionMetadata{} }
func (m *TransactionMetadata) String() string { return proto.CompactTextString(m) }
func (*TransactionMetadata) ProtoMessage()    {}
func (*TransactionMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_5c6ac9b241082464, []int{59}
}

func (m *TransactionMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransactionMetadata.Unmarshal(m, b)
}
func (m *TransactionMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransactionMetadata.Marshal(b, m, deterministic)
}
func (m *TransactionMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransactionMetadata.Merge(m, src)
}
func (m *TransactionMetadata) XXX_Size() int {
	return xxx_messageInfo_TransactionMetadata.Size(m)
}
func (m *TransactionMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_TransactionMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_TransactionMetadata proto.InternalMessageInfo

func (m *TransactionMetadata) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

func (m *TransactionMetadata) GetState() TransactionState {
	if m != nil {
		return m.State
	}
	return TransactionState_UNKNOWN
}

func (m *TransactionMetadata) GetTimeCreated() int64 {
	if m != nil {
		return m.TimeCreated
	}
	return 0
}

func (m *TransactionMetadata) GetParticipants() []*Target {
	if m != nil {
		return m.Participants
	}
	return nil
}

func init() {
	proto.RegisterEnum("query.MySqlFlag", MySqlFlag_name, MySqlFlag_value)
	proto.RegisterEnum("query.Flag", Flag_name, Flag_value)
	proto.RegisterEnum("query.Type", Type_name, Type_value)
	proto.RegisterEnum("query.TransactionState", TransactionState_name, TransactionState_value)
	proto.RegisterEnum("query.ExecuteOptions_IncludedFields", ExecuteOptions_IncludedFields_name, ExecuteOptions_IncludedFields_value)
	proto.RegisterEnum("query.ExecuteOptions_Workload", ExecuteOptions_Workload_name, ExecuteOptions_Workload_value)
	proto.RegisterEnum("query.ExecuteOptions_TransactionIsolation", ExecuteOptions_TransactionIsolation_name, ExecuteOptions_TransactionIsolation_value)
	proto.RegisterEnum("query.StreamEvent_Statement_Category", StreamEvent_Statement_Category_name, StreamEvent_Statement_Category_value)
	proto.RegisterEnum("query.SplitQueryRequest_Algorithm", SplitQueryRequest_Algorithm_name, SplitQueryRequest_Algorithm_value)
	proto.RegisterType((*Target)(nil), "query.Target")
	proto.RegisterType((*VTGateCallerID)(nil), "query.VTGateCallerID")
	proto.RegisterType((*EventToken)(nil), "query.EventToken")
	proto.RegisterType((*Value)(nil), "query.Value")
	proto.RegisterType((*BindVariable)(nil), "query.BindVariable")
	proto.RegisterType((*BoundQuery)(nil), "query.BoundQuery")
	proto.RegisterMapType((map[string]*BindVariable)(nil), "query.BoundQuery.BindVariablesEntry")
	proto.RegisterType((*ExecuteOptions)(nil), "query.ExecuteOptions")
	proto.RegisterType((*Field)(nil), "query.Field")
	proto.RegisterType((*Row)(nil), "query.Row")
	proto.RegisterType((*ResultExtras)(nil), "query.ResultExtras")
	proto.RegisterType((*QueryResult)(nil), "query.QueryResult")
	proto.RegisterType((*QueryWarning)(nil), "query.QueryWarning")
	proto.RegisterType((*StreamEvent)(nil), "query.StreamEvent")
	proto.RegisterType((*StreamEvent_Statement)(nil), "query.StreamEvent.Statement")
	proto.RegisterType((*ExecuteRequest)(nil), "query.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "query.ExecuteResponse")
	proto.RegisterType((*ResultWithError)(nil), "query.ResultWithError")
	proto.RegisterType((*ExecuteBatchRequest)(nil), "query.ExecuteBatchRequest")
	proto.RegisterType((*ExecuteBatchResponse)(nil), "query.ExecuteBatchResponse")
	proto.RegisterType((*StreamExecuteRequest)(nil), "query.StreamExecuteRequest")
	proto.RegisterType((*StreamExecuteResponse)(nil), "query.StreamExecuteResponse")
	proto.RegisterType((*BeginRequest)(nil), "query.BeginRequest")
	proto.RegisterType((*BeginResponse)(nil), "query.BeginResponse")
	proto.RegisterType((*CommitRequest)(nil), "query.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "query.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "query.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "query.RollbackResponse")
	proto.RegisterType((*PrepareRequest)(nil), "query.PrepareRequest")
	proto.RegisterType((*PrepareResponse)(nil), "query.PrepareResponse")
	proto.RegisterType((*CommitPreparedRequest)(nil), "query.CommitPreparedRequest")
	proto.RegisterType((*CommitPreparedResponse)(nil), "query.CommitPreparedResponse")
	proto.RegisterType((*RollbackPreparedRequest)(nil), "query.RollbackPreparedRequest")
	proto.RegisterType((*RollbackPreparedResponse)(nil), "query.RollbackPreparedResponse")
	proto.RegisterType((*CreateTransactionRequest)(nil), "query.CreateTransactionRequest")
	proto.RegisterType((*CreateTransactionResponse)(nil), "query.CreateTransactionResponse")
	proto.RegisterType((*StartCommitRequest)(nil), "query.StartCommitRequest")
	proto.RegisterType((*StartCommitResponse)(nil), "query.StartCommitResponse")
	proto.RegisterType((*SetRollbackRequest)(nil), "query.SetRollbackRequest")
	proto.RegisterType((*SetRollbackResponse)(nil), "query.SetRollbackResponse")
	proto.RegisterType((*ConcludeTransactionRequest)(nil), "query.ConcludeTransactionRequest")
	proto.RegisterType((*ConcludeTransactionResponse)(nil), "query.ConcludeTransactionResponse")
	proto.RegisterType((*ReadTransactionRequest)(nil), "query.ReadTransactionRequest")
	proto.RegisterType((*ReadTransactionResponse)(nil), "query.ReadTransactionResponse")
	proto.RegisterType((*BeginExecuteRequest)(nil), "query.BeginExecuteRequest")
	proto.RegisterType((*BeginExecuteResponse)(nil), "query.BeginExecuteResponse")
	proto.RegisterType((*BeginExecuteBatchRequest)(nil), "query.BeginExecuteBatchRequest")
	proto.RegisterType((*BeginExecuteBatchResponse)(nil), "query.BeginExecuteBatchResponse")
	proto.RegisterType((*MessageStreamRequest)(nil), "query.MessageStreamRequest")
	proto.RegisterType((*MessageStreamResponse)(nil), "query.MessageStreamResponse")
	proto.RegisterType((*MessageAckRequest)(nil), "query.MessageAckRequest")
	proto.RegisterType((*MessageAckResponse)(nil), "query.MessageAckResponse")
	proto.RegisterType((*SplitQueryRequest)(nil), "query.SplitQueryRequest")
	proto.RegisterType((*QuerySplit)(nil), "query.QuerySplit")
	proto.RegisterType((*SplitQueryResponse)(nil), "query.SplitQueryResponse")
	proto.RegisterType((*StreamHealthRequest)(nil), "query.StreamHealthRequest")
	proto.RegisterType((*RealtimeStats)(nil), "query.RealtimeStats")
	proto.RegisterType((*AggregateStats)(nil), "query.AggregateStats")
	proto.RegisterType((*StreamHealthResponse)(nil), "query.StreamHealthResponse")
	proto.RegisterType((*UpdateStreamRequest)(nil), "query.UpdateStreamRequest")
	proto.RegisterType((*UpdateStreamResponse)(nil), "query.UpdateStreamResponse")
	proto.RegisterType((*TransactionMetadata)(nil), "query.TransactionMetadata")
}

func init() { proto.RegisterFile("query.proto", fileDescriptor_5c6ac9b241082464) }

var fileDescriptor_5c6ac9b241082464 = []byte{
	// 3258 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5a, 0xcb, 0x73, 0xdb, 0x48,
	0x7a, 0x37, 0xf8, 0x12, 0xf9, 0x51, 0xa4, 0x5a, 0x4d, 0xc9, 0xe6, 0x68, 0x5e, 0x5a, 0xec, 0xce,
	0xae, 0xa2, 0xdd, 0xc8, 0x1e, 0x8d, 0xd7, 0x71, 0x66, 0x37, 0x89, 0x21, 0x0a, 0xf2, 0x70, 0x4c,
	0x82, 0x74, 0x13, 0xb4, 0xd7, 0x53, 0x5b, 0x85, 0x82, 0xc8, 0x36, 0x85, 0x12, 0x08, 0xd0, 0x00,
	0x28, 0x59, 0x37, 0x27, 0x9b, 0xcd, 0xfb, 0x31, 0x79, 0x4e, 0x36, 0xa9, 0x4c, 0x52, 0x95, 0x43,
	0x2a, 0x97, 0xfc, 0x0d, 0xa9, 0x1c, 0x72, 0xcc, 0x2d, 0x87, 0x24, 0x87, 0x9c, 0x52, 0xb9, 0x6d,
	0xe5, 0x94, 0x43, 0x0e, 0xa9, 0x54, 0x3f, 0x00, 0x82, 0x12, 0x67, 0xec, 0x75, 0x72, 0x91, 0x67,
	0x6e, 0xdd, 0xdf, 0xf7, 0xf5, 0xe3, 0xf7, 0xfb, 0x3e, 0x7c, 0xdd, 0xe8, 0x6e, 0x28, 0x3f, 0x99,
	0xd2, 0xe0, 0x6c, 0x67, 0x12, 0xf8, 0x91, 0x8f, 0xf3, 0xbc, 0xb2, 0x51, 0x8d, 0xfc, 0x89, 0x3f,
	0xb4, 0x23, 0x5b, 0x88, 0x37, 0xca, 0x27, 0x51, 0x30, 0x19, 0x88, 0x8a, 0xfa, 0x43, 0x05, 0x0a,
	0xa6, 0x1d, 0x8c, 0x68, 0x84, 0x37, 0xa0, 0x78, 0x4c, 0xcf, 0xc2, 0x89, 0x3d, 0xa0, 0x75, 0x65,
	0x53, 0xd9, 0x2a, 0x91, 0xa4, 0x8e, 0xd7, 0x20, 0x1f, 0x1e, 0xd9, 0xc1, 0xb0, 0x9e, 0xe1, 0x0a,
	0x51, 0xc1, 0xdf, 0x86, 0x72, 0x64, 0x1f, 0xba, 0x34, 0xb2, 0xa2, 0xb3, 0x09, 0xad, 0x67, 0x37,
	0x95, 0xad, 0xea, 0xee, 0xda, 0x4e, 0x32, 0x9e, 0xc9, 0x95, 0xe6, 0xd9, 0x84, 0x12, 0x88, 0x92,
	0x32, 0xc6, 0x90, 0x1b, 0x50, 0xd7, 0xad, 0xe7, 0x78, 0x5f, 0xbc, 0xac, 0xee, 0x43, 0xf5, 0x81,
	0x79, 0xd7, 0x8e, 0x68, 0xc3, 0x76, 0x5d, 0x1a, 0x34, 0xf7, 0xd9, 0x74, 0xa6, 0x21, 0x0d, 0x3c,
	0x7b, 0x9c, 0x4c, 0x27, 0xae, 0xe3, 0xab, 0x50, 0x18, 0x05, 0xfe, 0x74, 0x12, 0xd6, 0x33, 0x9b,
	0xd9, 0xad, 0x12, 0x91, 0x35, 0xf5, 0xfb, 0x00, 0xfa, 0x09, 0xf5, 0x22, 0xd3, 0x3f, 0xa6, 0x1e,
	0x7e, 0x03, 0x4a, 0x91, 0x33, 0xa6, 0x61, 0x64, 0x8f, 0x27, 0xbc, 0x8b, 0x2c, 0x99, 0x09, 0x3e,
	0x03, 0xd2, 0x06, 0x14, 0x27, 0x7e, 0xe8, 0x44, 0x8e, 0xef, 0x71, 0x3c, 0x25, 0x92, 0xd4, 0xd5,
	0x9f, 0x87, 0xfc, 0x03, 0xdb, 0x9d, 0x52, 0xfc, 0x36, 0xe4, 0x38, 0x60, 0x85, 0x03, 0x2e, 0xef,
	0x08, 0xd2, 0x39, 0x4e, 0xae, 0x60, 0x7d, 0x9f, 0x30, 0x4b, 0xde, 0xf7, 0x32, 0x11, 0x15, 0xf5,
	0x18, 0x96, 0xf7, 0x1c, 0x6f, 0xf8, 0xc0, 0x0e, 0x1c, 0x46, 0xc6, 0x4b, 0x76, 0x83, 0xbf, 0x06,
	0x05, 0x5e, 0x08, 0xeb, 0xd9, 0xcd, 0xec, 0x56, 0x79, 0x77, 0x59, 0x36, 0xe4, 0x73, 0x23, 0x52,
	0xa7, 0xfe, 0xbd, 0x02, 0xb0, 0xe7, 0x4f, 0xbd, 0xe1, 0x7d, 0xa6, 0xc4, 0x08, 0xb2, 0xe1, 0x13,
	0x57, 0x12, 0xc9, 0x8a, 0xf8, 0x1e, 0x54, 0x0f, 0x1d, 0x6f, 0x68, 0x9d, 0xc8, 0xe9, 0x08, 0x2e,
	0xcb, 0xbb, 0x5f, 0x93, 0xdd, 0xcd, 0x1a, 0xef, 0xa4, 0x67, 0x1d, 0xea, 0x5e, 0x14, 0x9c, 0x91,
	0xca, 0x61, 0x5a, 0xb6, 0xd1, 0x07, 0x7c, 0xd1, 0x88, 0x0d, 0x7a, 0x4c, 0xcf, 0xe2, 0x41, 0x8f,
	0xe9, 0x19, 0xfe, 0xa9, 0x34, 0xa2, 0xf2, 0x6e, 0x2d, 0x1e, 0x2b, 0xd5, 0x56, 0xc2, 0x7c, 0x3f,
	0x73, 0x5b, 0x51, 0xff, 0xa2, 0x00, 0x55, 0xfd, 0x29, 0x1d, 0x4c, 0x23, 0xda, 0x99, 0x30, 0x1f,
	0x84, 0x78, 0x07, 0x6a, 0x8e, 0x37, 0x70, 0xa7, 0x43, 0x6a, 0x51, 0xe6, 0x6a, 0x2b, 0x62, 0xbe,
	0xe6, 0xfd, 0x15, 0xc9, 0xaa, 0x54, 0xa5, 0x82, 0x40, 0x83, 0xda, 0xc0, 0x1f, 0x4f, 0xec, 0x60,
	0xde, 0x3e, 0xcb, 0xc7, 0x5f, 0x95, 0xe3, 0xcf, 0xec, 0xc9, 0xaa, 0xb4, 0x4e, 0x75, 0xd1, 0x86,
	0x15, 0xd9, 0xef, 0xd0, 0x7a, 0xec, 0x50, 0x77, 0x18, 0xf2, 0xd0, 0xad, 0x26, 0x54, 0xcd, 0x4f,
	0x71, 0xa7, 0x29, 0x8d, 0x0f, 0xb8, 0x2d, 0xa9, 0x3a, 0x73, 0x75, 0xbc, 0x0d, 0xab, 0x03, 0xd7,
	0x61, 0x53, 0x79, 0xcc, 0x28, 0xb6, 0x02, 0xff, 0x34, 0xac, 0xe7, 0xf9, 0xfc, 0x57, 0x84, 0xe2,
	0x80, 0xc9, 0x89, 0x7f, 0x1a, 0xe2, 0xf7, 0xa1, 0x78, 0xea, 0x07, 0xc7, 0xae, 0x6f, 0x0f, 0xeb,
	0x05, 0x3e, 0xe6, 0x5b, 0x8b, 0xc7, 0x7c, 0x28, 0xad, 0x48, 0x62, 0x8f, 0xb7, 0x00, 0x85, 0x4f,
	0x5c, 0x2b, 0xa4, 0x2e, 0x1d, 0x44, 0x96, 0xeb, 0x8c, 0x9d, 0xa8, 0x5e, 0xe4, 0x5f, 0x41, 0x35,
	0x7c, 0xe2, 0xf6, 0xb8, 0xb8, 0xc5, 0xa4, 0xd8, 0x82, 0xf5, 0x28, 0xb0, 0xbd, 0xd0, 0x1e, 0xb0,
	0xce, 0x2c, 0x27, 0xf4, 0x5d, 0x9b, 0x7f, 0x01, 0x25, 0x3e, 0xe4, 0xf6, 0xe2, 0x21, 0xcd, 0x59,
	0x93, 0x66, 0xdc, 0x82, 0xac, 0x45, 0x0b, 0xa4, 0xf8, 0x5d, 0x58, 0x0f, 0x8f, 0x9d, 0x89, 0xc5,
	0xfb, 0xb1, 0x26, 0xae, 0xed, 0x59, 0x03, 0x7b, 0x70, 0x44, 0xeb, 0xc0, 0x61, 0x63, 0xa6, 0xe4,
	0xa1, 0xd6, 0x75, 0x6d, 0xaf, 0xc1, 0x34, 0xea, 0x77, 0xa0, 0x3a, 0xcf, 0x23, 0x5e, 0x85, 0x8a,
	0xf9, 0xa8, 0xab, 0x5b, 0x9a, 0xb1, 0x6f, 0x19, 0x5a, 0x5b, 0x47, 0x57, 0x70, 0x05, 0x4a, 0x5c,
	0xd4, 0x31, 0x5a, 0x8f, 0x90, 0x82, 0x97, 0x20, 0xab, 0xb5, 0x5a, 0x28, 0xa3, 0xde, 0x86, 0x62,
	0x4c, 0x08, 0x5e, 0x81, 0x72, 0xdf, 0xe8, 0x75, 0xf5, 0x46, 0xf3, 0xa0, 0xa9, 0xef, 0xa3, 0x2b,
	0xb8, 0x08, 0xb9, 0x4e, 0xcb, 0xec, 0x22, 0x45, 0x94, 0xb4, 0x2e, 0xca, 0xb0, 0x96, 0xfb, 0x7b,
	0x1a, 0xca, 0xaa, 0x7f, 0xad, 0xc0, 0xda, 0x22, 0x60, 0xb8, 0x0c, 0x4b, 0xfb, 0xfa, 0x81, 0xd6,
	0x6f, 0x99, 0xe8, 0x0a, 0xae, 0xc1, 0x0a, 0xd1, 0xbb, 0xba, 0x66, 0x6a, 0x7b, 0x2d, 0xdd, 0x22,
	0xba, 0xb6, 0x8f, 0x14, 0x8c, 0xa1, 0xca, 0x4a, 0x56, 0xa3, 0xd3, 0x6e, 0x37, 0x4d, 0x53, 0xdf,
	0x47, 0x19, 0xbc, 0x06, 0x88, 0xcb, 0xfa, 0xc6, 0x4c, 0x9a, 0xc5, 0x08, 0x96, 0x7b, 0x3a, 0x69,
	0x6a, 0xad, 0xe6, 0x47, 0xac, 0x03, 0x94, 0xc3, 0x5f, 0x81, 0x37, 0x1b, 0x1d, 0xa3, 0xd7, 0xec,
	0x99, 0xba, 0x61, 0x5a, 0x3d, 0x43, 0xeb, 0xf6, 0x3e, 0xe8, 0x98, 0xbc, 0x67, 0x01, 0x2e, 0x8f,
	0xab, 0x00, 0x5a, 0xdf, 0xec, 0x88, 0x7e, 0x50, 0xe1, 0xc3, 0x5c, 0x51, 0x41, 0x19, 0xf5, 0x93,
	0x0c, 0xe4, 0x39, 0x3f, 0x2c, 0xab, 0xa6, 0x72, 0x25, 0x2f, 0x27, 0x19, 0x26, 0xf3, 0x39, 0x19,
	0x86, 0x27, 0x66, 0x99, 0xeb, 0x44, 0x05, 0xbf, 0x0e, 0x25, 0x3f, 0x18, 0x59, 0x42, 0x23, 0xb2,
	0x74, 0xd1, 0x0f, 0x46, 0x3c, 0x9d, 0xb3, 0x0c, 0xc9, 0x92, 0xfb, 0xa1, 0x1d, 0x52, 0x1e, 0xb5,
	0x25, 0x92, 0xd4, 0xf1, 0x6b, 0xc0, 0xec, 0x2c, 0x3e, 0x8f, 0x02, 0xd7, 0x2d, 0xf9, 0xc1, 0xc8,
	0x60, 0x53, 0xf9, 0x2a, 0x54, 0x06, 0xbe, 0x3b, 0x1d, 0x7b, 0x96, 0x4b, 0xbd, 0x51, 0x74, 0x54,
	0x5f, 0xda, 0x54, 0xb6, 0x2a, 0x64, 0x59, 0x08, 0x5b, 0x5c, 0x86, 0xeb, 0xb0, 0x34, 0x38, 0xb2,
	0x83, 0x90, 0x8a, 0x48, 0xad, 0x90, 0xb8, 0xca, 0x47, 0xa5, 0x03, 0x67, 0x6c, 0xbb, 0x21, 0x8f,
	0xca, 0x0a, 0x49, 0xea, 0x0c, 0xc4, 0x63, 0xd7, 0x1e, 0x85, 0x3c, 0x9a, 0x2a, 0x44, 0x54, 0xd4,
	0x9f, 0x81, 0x2c, 0xf1, 0x4f, 0x59, 0x97, 0x62, 0xc0, 0xb0, 0xae, 0x6c, 0x66, 0xb7, 0x30, 0x89,
	0xab, 0x6c, 0x11, 0x91, 0x79, 0x54, 0xa4, 0xd7, 0x38, 0x73, 0x7e, 0x1f, 0x96, 0x09, 0x0d, 0xa7,
	0x6e, 0xa4, 0x3f, 0x8d, 0x02, 0x3b, 0xc4, 0xbb, 0x50, 0x4e, 0x67, 0x0e, 0xe5, 0xb3, 0x32, 0x07,
	0xd0, 0x59, 0xca, 0xa8, 0xc3, 0xd2, 0xe3, 0x80, 0x86, 0x47, 0x34, 0x90, 0x99, 0x29, 0xae, 0xb2,
	0xbc, 0x5c, 0xe6, 0xa1, 0x2e, 0xc6, 0x60, 0xd9, 0x5c, 0xe6, 0x14, 0x65, 0x2e, 0x9b, 0x73, 0xa7,
	0x12, 0xa9, 0x63, 0xec, 0xb1, 0x34, 0x61, 0xd9, 0x8f, 0x1f, 0xd3, 0x41, 0x44, 0xc5, 0xa2, 0x95,
	0x23, 0xcb, 0x4c, 0xa8, 0x49, 0x19, 0x73, 0x9b, 0xe3, 0x85, 0x34, 0x88, 0x2c, 0x67, 0xc8, 0x1d,
	0x9a, 0x23, 0x45, 0x21, 0x68, 0x0e, 0xf1, 0x5b, 0x90, 0xe3, 0x89, 0x26, 0xc7, 0x47, 0x01, 0x39,
	0x0a, 0xf1, 0x4f, 0x09, 0x97, 0xe3, 0x6f, 0x42, 0x81, 0x72, 0xbc, 0xdc, 0xa9, 0xb3, 0xd4, 0x9c,
	0xa6, 0x82, 0x48, 0x13, 0xf5, 0xbb, 0xb0, 0xcc, 0x31, 0x3c, 0xb4, 0x03, 0xcf, 0xf1, 0x46, 0x7c,
	0x45, 0xf7, 0x87, 0x22, 0xf6, 0x2a, 0x84, 0x97, 0x19, 0x05, 0x63, 0x1a, 0x86, 0xf6, 0x88, 0xca,
	0x15, 0x36, 0xae, 0xaa, 0x7f, 0x99, 0x85, 0x72, 0x2f, 0x0a, 0xa8, 0x3d, 0xe6, 0xec, 0xe1, 0xef,
	0x02, 0x84, 0x91, 0x1d, 0xd1, 0x31, 0xf5, 0xa2, 0x98, 0x86, 0x37, 0xe4, 0xf0, 0x29, 0xbb, 0x9d,
	0x5e, 0x6c, 0x44, 0x52, 0xf6, 0xe7, 0xdd, 0x93, 0x79, 0x01, 0xf7, 0x6c, 0x7c, 0x9a, 0x81, 0x52,
	0xd2, 0x1b, 0xd6, 0xa0, 0x38, 0xb0, 0x23, 0x3a, 0xf2, 0x83, 0x33, 0xb9, 0x16, 0xbf, 0xf3, 0x79,
	0xa3, 0xef, 0x34, 0xa4, 0x31, 0x49, 0x9a, 0xe1, 0x37, 0x41, 0x6c, 0x70, 0x44, 0xe8, 0x0b, 0xbc,
	0x25, 0x2e, 0xe1, 0xc1, 0xff, 0x3e, 0xe0, 0x49, 0xe0, 0x8c, 0xed, 0xe0, 0xcc, 0x3a, 0xa6, 0x67,
	0xf1, 0x22, 0x92, 0x5d, 0xe0, 0x70, 0x24, 0xed, 0xee, 0xd1, 0x33, 0x99, 0xf6, 0x6e, 0xcf, 0xb7,
	0x95, 0x21, 0x7b, 0xd1, 0x8d, 0xa9, 0x96, 0x7c, 0x27, 0x10, 0xc6, 0x6b, 0x7e, 0x9e, 0x47, 0x37,
	0x2b, 0xaa, 0xdf, 0x80, 0x62, 0x3c, 0x79, 0x5c, 0x82, 0xbc, 0x1e, 0x04, 0x7e, 0x80, 0xae, 0xf0,
	0xec, 0xd7, 0x6e, 0x89, 0x04, 0xba, 0xbf, 0xcf, 0x12, 0xe8, 0xdf, 0x65, 0x92, 0x85, 0x97, 0xd0,
	0x27, 0x53, 0x1a, 0x46, 0xf8, 0x17, 0xa0, 0x46, 0x79, 0xa4, 0x39, 0x27, 0xd4, 0x1a, 0xf0, 0x5d,
	0x1a, 0x8b, 0x33, 0xf1, 0x39, 0xac, 0xec, 0x88, 0x4d, 0x65, 0xbc, 0x7b, 0x23, 0xab, 0x89, 0xad,
	0x14, 0x0d, 0xb1, 0x0e, 0x35, 0x67, 0x3c, 0xa6, 0x43, 0xc7, 0x8e, 0xd2, 0x1d, 0x08, 0x87, 0xad,
	0xc7, 0x9b, 0x98, 0xb9, 0x4d, 0x20, 0x59, 0x4d, 0x5a, 0x24, 0xdd, 0xbc, 0x03, 0x85, 0x88, 0x6f,
	0x58, 0xe5, 0x1a, 0x5e, 0x89, 0xb3, 0x1a, 0x17, 0x12, 0xa9, 0xc4, 0xdf, 0x00, 0xb1, 0xfd, 0xe5,
	0xf9, 0x6b, 0x16, 0x10, 0xb3, 0x5d, 0x0d, 0x11, 0x7a, 0xfc, 0x0e, 0x54, 0xe7, 0x16, 0xbf, 0x21,
	0x27, 0x2c, 0x4b, 0x2a, 0xe9, 0x95, 0x6c, 0x88, 0xaf, 0xc3, 0x92, 0x2f, 0x16, 0x3e, 0x9e, 0xd9,
	0x66, 0x33, 0x9e, 0x5f, 0x15, 0x49, 0x6c, 0xa5, 0xfe, 0x1c, 0xac, 0x24, 0x0c, 0x86, 0x13, 0xdf,
	0x0b, 0x29, 0xde, 0x86, 0x42, 0xc0, 0x3f, 0x27, 0xc9, 0x1a, 0x96, 0x5d, 0xa4, 0xf2, 0x01, 0x91,
	0x16, 0xea, 0x10, 0x56, 0x84, 0xe4, 0xa1, 0x13, 0x1d, 0x71, 0x47, 0xe1, 0x77, 0x20, 0x4f, 0x59,
	0xe1, 0x1c, 0xe7, 0xa4, 0xdb, 0xe0, 0x7a, 0x22, 0xb4, 0xa9, 0x51, 0x32, 0xcf, 0x1d, 0xe5, 0x3f,
	0x33, 0x50, 0x93, 0xb3, 0xdc, 0xb3, 0xa3, 0xc1, 0xd1, 0x25, 0x75, 0xf6, 0x37, 0x61, 0x89, 0xc9,
	0x9d, 0xe4, 0xc3, 0x58, 0xe0, 0xee, 0xd8, 0x82, 0x39, 0xdc, 0x0e, 0xad, 0x94, 0x77, 0xe5, 0xe6,
	0xab, 0x62, 0x87, 0xa9, 0x95, 0x7f, 0x41, 0x5c, 0x14, 0x9e, 0x13, 0x17, 0x4b, 0x2f, 0x14, 0x17,
	0xfb, 0xb0, 0x36, 0xcf, 0xb8, 0x0c, 0x8e, 0x6f, 0xc1, 0x92, 0x70, 0x4a, 0x9c, 0x02, 0x17, 0xf9,
	0x2d, 0x36, 0x51, 0xff, 0x21, 0x03, 0x6b, 0x32, 0x3b, 0x7d, 0x31, 0x3e, 0xd3, 0x14, 0xcf, 0xf9,
	0x17, 0xe1, 0xf9, 0x05, 0xfd, 0xa7, 0x36, 0x60, 0xfd, 0x1c, 0x8f, 0x2f, 0xf1, 0xb1, 0xfe, 0x58,
	0x81, 0xe5, 0x3d, 0x3a, 0x72, 0xbc, 0x4b, 0xea, 0x85, 0x14, 0xb9, 0xb9, 0x17, 0x0a, 0xe2, 0x5b,
	0x50, 0x91, 0x78, 0x25, 0x5b, 0x17, 0xd9, 0x56, 0x16, 0xb1, 0xfd, 0xef, 0x0a, 0x54, 0x1a, 0xfe,
	0x78, 0xec, 0x44, 0x97, 0x94, 0xa9, 0x8b, 0x38, 0x73, 0x8b, 0x70, 0x22, 0xa8, 0xc6, 0x30, 0x05,
	0x41, 0xea, 0x7f, 0x28, 0xb0, 0x42, 0x7c, 0xd7, 0x3d, 0xb4, 0x07, 0xc7, 0xaf, 0x36, 0x76, 0x0c,
	0x68, 0x06, 0x54, 0xa2, 0xff, 0x6f, 0x05, 0xaa, 0xdd, 0x80, 0xb2, 0x1f, 0xeb, 0x57, 0x1a, 0x3c,
	0xdb, 0x09, 0x0f, 0x23, 0xb9, 0x87, 0x28, 0x11, 0x5e, 0x56, 0x57, 0x61, 0x25, 0xc1, 0x2e, 0xf9,
	0xf8, 0x17, 0x05, 0xd6, 0x45, 0x80, 0x48, 0xcd, 0xf0, 0x92, 0xd2, 0x12, 0xe3, 0xcd, 0xa5, 0xf0,
	0xd6, 0xe1, 0xea, 0x79, 0x6c, 0x12, 0xf6, 0x0f, 0x32, 0x70, 0x2d, 0x8e, 0x8d, 0x4b, 0x0e, 0xfc,
	0xff, 0x10, 0x0f, 0x1b, 0x50, 0xbf, 0x48, 0x82, 0x64, 0xe8, 0xe3, 0x0c, 0xd4, 0x1b, 0x01, 0xb5,
	0x23, 0x9a, 0xda, 0x8b, 0xbc, 0x3a, 0xb1, 0x81, 0xdf, 0x85, 0xe5, 0x89, 0x1d, 0x44, 0xce, 0xc0,
	0x99, 0xd8, 0xec, 0x6f, 0x2f, 0xcf, 0xb7, 0x3a, 0xe7, 0x3a, 0x98, 0x33, 0x51, 0x5f, 0x87, 0xd7,
	0x16, 0x30, 0x22, 0xf9, 0xfa, 0x1f, 0x05, 0x70, 0x2f, 0xb2, 0x83, 0xe8, 0x0b, 0xb0, 0xaa, 0x2c,
	0x0c, 0xa6, 0x75, 0xa8, 0xcd, 0xe1, 0x4f, 0xf3, 0x42, 0xa3, 0x2f, 0xc4, 0x8a, 0xf3, 0x99, 0xbc,
	0xa4, 0xf1, 0x4b, 0x5e, 0xfe, 0x4d, 0x81, 0x8d, 0x86, 0x2f, 0x0e, 0x16, 0x5f, 0xc9, 0x2f, 0x4c,
	0x7d, 0x13, 0x5e, 0x5f, 0x08, 0x50, 0x12, 0xf0, 0xaf, 0x0a, 0x5c, 0x25, 0xd4, 0x1e, 0xbe, 0x9a,
	0xe0, 0xef, 0xc3, 0xb5, 0x0b, 0xe0, 0xe4, 0x0e, 0xf5, 0x16, 0x14, 0xc7, 0x34, 0xb2, 0x87, 0x76,
	0x64, 0x4b, 0x48, 0x1b, 0x71, 0xbf, 0x33, 0xeb, 0xb6, 0xb4, 0x20, 0x89, 0xad, 0xfa, 0x69, 0x06,
	0x6a, 0x7c, 0xaf, 0xfb, 0xe5, 0x8f, 0xd6, 0xe2, 0x7f, 0x81, 0x8f, 0x15, 0x58, 0x9b, 0x27, 0x28,
	0xf9, 0x27, 0xf8, 0xff, 0x3e, 0xaf, 0x58, 0x90, 0x10, 0xb2, 0x8b, 0xb6, 0xa0, 0xff, 0x98, 0x81,
	0x7a, 0x7a, 0x4a, 0x5f, 0x9e, 0x6d, 0xcc, 0x9f, 0x6d, 0xfc, 0xc4, 0x87, 0x59, 0x9f, 0x28, 0xf0,
	0xda, 0x02, 0x42, 0x7f, 0x32, 0x47, 0xa7, 0x4e, 0x38, 0x32, 0xcf, 0x3d, 0xe1, 0x78, 0x51, 0x57,
	0xff, 0xb3, 0x02, 0x6b, 0x6d, 0x71, 0xb0, 0x2c, 0xfe, 0xe3, 0x2f, 0x6f, 0x36, 0xe3, 0x67, 0xc7,
	0xb9, 0xd9, 0xf5, 0x8d, 0xda, 0x80, 0xf5, 0x73, 0xd0, 0x5e, 0xe2, 0x6c, 0xe2, 0xbf, 0x14, 0x58,
	0x95, 0xbd, 0x68, 0x97, 0x76, 0x23, 0xb0, 0x80, 0x1d, 0xfc, 0x16, 0x64, 0x9d, 0x61, 0xbc, 0x83,
	0x9c, 0xbf, 0x04, 0x67, 0x0a, 0xf5, 0x0e, 0xe0, 0x34, 0xee, 0x97, 0xa0, 0xee, 0x9f, 0xb2, 0xb0,
	0xda, 0x9b, 0xb8, 0x4e, 0x24, 0x95, 0xaf, 0x76, 0xe2, 0xff, 0x0a, 0x2c, 0x87, 0x0c, 0xac, 0x25,
	0xae, 0xe4, 0x38, 0xb1, 0x25, 0x52, 0xe6, 0xb2, 0x06, 0x17, 0xe1, 0xb7, 0xa1, 0x1c, 0x9b, 0x4c,
	0xbd, 0x48, 0x1e, 0xa8, 0x81, 0xb4, 0x98, 0x7a, 0x11, 0xbe, 0x09, 0xd7, 0xbc, 0xe9, 0x98, 0x5f,
	0x69, 0x5b, 0x13, 0x1a, 0xc4, 0x17, 0xbe, 0x76, 0x10, 0x5f, 0x3d, 0xd7, 0xbc, 0xe9, 0x98, 0xf8,
	0xa7, 0x61, 0x97, 0x06, 0xe2, 0xc2, 0xd7, 0x0e, 0x22, 0x7c, 0x07, 0x4a, 0xb6, 0x3b, 0xf2, 0x03,
	0x27, 0x3a, 0x1a, 0xcb, 0x3b, 0x67, 0x35, 0xbe, 0x81, 0x39, 0x4f, 0xff, 0x8e, 0x16, 0x5b, 0x92,
	0x59, 0x23, 0xf5, 0x5b, 0x50, 0x4a, 0xe4, 0x18, 0xc1, 0xb2, 0x7e, 0xbf, 0xaf, 0xb5, 0xac, 0x5e,
	0xb7, 0xd5, 0x34, 0x7b, 0xe2, 0x9e, 0xf8, 0xa0, 0xdf, 0x6a, 0x59, 0xbd, 0x86, 0x66, 0x20, 0x45,
	0x25, 0x00, 0xbc, 0x4b, 0xde, 0xf9, 0x8c, 0x20, 0xe5, 0x39, 0x04, 0xbd, 0x0e, 0xa5, 0xc0, 0x3f,
	0x95, 0xd8, 0x33, 0x1c, 0x4e, 0x31, 0xf0, 0x4f, 0x39, 0x72, 0x55, 0x03, 0x9c, 0x9e, 0xab, 0x8c,
	0xb6, 0x54, 0xf2, 0x56, 0xe6, 0x92, 0xf7, 0x6c, 0xfc, 0x24, 0x79, 0x8b, 0xad, 0x3c, 0xfb, 0xce,
	0x3f, 0xa0, 0xb6, 0x1b, 0xc5, 0xeb, 0x95, 0xfa, 0x57, 0x19, 0xa8, 0x10, 0x26, 0x71, 0xc6, 0xb4,
	0x17, 0xd9, 0x51, 0xc8, 0x3c, 0x75, 0xc4, 0x4d, 0xac, 0x59, 0xda, 0x2d, 0x91, 0xb2, 0x90, 0x89,
	0xbb, 0x82, 0x5d, 0x58, 0x0f, 0xe9, 0xc0, 0xf7, 0x86, 0xa1, 0x75, 0x48, 0x8f, 0x1c, 0x6f, 0x68,
	0x8d, 0xed, 0x30, 0x92, 0xd7, 0x91, 0x15, 0x52, 0x93, 0xca, 0x3d, 0xae, 0x6b, 0x73, 0x15, 0xbe,
	0x01, 0x6b, 0x87, 0x8e, 0xe7, 0xfa, 0x23, 0x6b, 0xe2, 0xda, 0x67, 0x34, 0x08, 0x25, 0x54, 0x16,
	0x5e, 0x79, 0x82, 0x85, 0xae, 0x2b, 0x54, 0xc2, 0xdd, 0x1f, 0xc1, 0xf6, 0xc2, 0x51, 0xac, 0xc7,
	0x8e, 0x1b, 0xd1, 0x80, 0x0e, 0xad, 0x80, 0x4e, 0x5c, 0x67, 0x20, 0x5e, 0x13, 0x88, 0xbd, 0xfb,
	0xd7, 0x17, 0x0c, 0x7d, 0x20, 0xcd, 0xc9, 0xcc, 0x9a, 0xb1, 0x3d, 0x98, 0x4c, 0xad, 0x29, 0xbf,
	0x41, 0x64, 0xab, 0x98, 0x42, 0x8a, 0x83, 0xc9, 0xb4, 0xcf, 0xea, 0x18, 0x41, 0xf6, 0xc9, 0x44,
	0x2c, 0x5e, 0x0a, 0x61, 0x45, 0xf5, 0xc7, 0x0a, 0x54, 0xb5, 0xd1, 0x28, 0xa0, 0x23, 0x3b, 0x92,
	0x34, 0xdd, 0x80, 0x35, 0x41, 0xc9, 0x99, 0x25, 0x9f, 0x29, 0x09, 0x3c, 0x8a, 0xc0, 0x23, 0x75,
	0xe2, 0x91, 0x52, 0x1c, 0xbe, 0x57, 0xa7, 0xde, 0xc2, 0x36, 0x19, 0xde, 0x66, 0x2d, 0xd1, 0xa6,
	0x5b, 0xfd, 0x2c, 0xbc, 0xb6, 0x98, 0x85, 0xb1, 0x23, 0x1e, 0x9a, 0x54, 0xc8, 0xd5, 0x05, 0xa0,
	0xdb, 0x8e, 0xf7, 0x39, 0x4d, 0xed, 0xa7, 0x9c, 0xaf, 0xcf, 0x68, 0x6a, 0x3f, 0x55, 0xff, 0x26,
	0xb9, 0x01, 0x88, 0xc3, 0x25, 0x59, 0x8d, 0xe3, 0xbc, 0xa0, 0x7c, 0x5e, 0x5e, 0xa8, 0xc3, 0x52,
	0x48, 0x83, 0x13, 0xc7, 0x1b, 0xc5, 0x57, 0xd4, 0xb2, 0x8a, 0x7b, 0xf0, 0x75, 0x89, 0x9d, 0x3e,
	0x8d, 0x68, 0xe0, 0xd9, 0xae, 0x7b, 0x66, 0x89, 0x83, 0x0a, 0x2f, 0xa2, 0x43, 0x6b, 0xf6, 0xa8,
	0x4a, 0xac, 0xc8, 0x5f, 0x15, 0xd6, 0x7a, 0x62, 0x4c, 0x12, 0x5b, 0x33, 0x79, 0x6e, 0xf5, 0x1d,
	0xa8, 0x06, 0x32, 0x88, 0xad, 0x90, 0xb9, 0x47, 0xe6, 0xa3, 0xb5, 0xe4, 0x9e, 0x39, 0x15, 0xe1,
	0xa4, 0x12, 0xcc, 0x05, 0xfc, 0x6d, 0x58, 0x96, 0x33, 0xb2, 0x5d, 0xc7, 0x9e, 0x6d, 0x4c, 0xcf,
	0xbd, 0x34, 0xd3, 0x98, 0x92, 0xc8, 0x37, 0x69, 0xbc, 0xf2, 0x61, 0xae, 0x58, 0x40, 0x4b, 0xec,
	0x6f, 0xb8, 0xd6, 0x9f, 0x0c, 0x79, 0x64, 0x5c, 0xe2, 0x3d, 0x42, 0xfa, 0x71, 0x5a, 0x6e, 0xfe,
	0x71, 0xda, 0xfc, 0x63, 0xb7, 0xfc, 0xb9, 0xc7, 0x6e, 0xea, 0x1d, 0x58, 0x9b, 0xc7, 0x2f, 0x63,
	0x65, 0x0b, 0xf2, 0xfc, 0x5a, 0xfc, 0xdc, 0x62, 0x98, 0xba, 0xf7, 0x26, 0xc2, 0x40, 0xfd, 0x5b,
	0x05, 0x6a, 0x0b, 0x7e, 0x94, 0x92, 0xbf, 0x30, 0x25, 0x75, 0xc8, 0xf3, 0xd3, 0x90, 0xe7, 0x17,
	0xf4, 0xf2, 0xdd, 0xc9, 0xb5, 0x8b, 0xff, 0x59, 0xfc, 0x32, 0x9d, 0x08, 0x2b, 0x96, 0xce, 0x78,
	0x58, 0x0c, 0xf8, 0x29, 0x4f, 0xbc, 0xcf, 0x2b, 0x33, 0x99, 0x38, 0xf8, 0xb9, 0x78, 0x6c, 0x94,
	0x7b, 0xee, 0xb1, 0xd1, 0xf6, 0xef, 0x67, 0xa1, 0xd4, 0x3e, 0xeb, 0x3d, 0x71, 0x0f, 0x5c, 0x7b,
	0xc4, 0x6f, 0xbb, 0xdb, 0x5d, 0xf3, 0x11, 0xba, 0x82, 0x57, 0xa1, 0x62, 0x74, 0x4c, 0xcb, 0x60,
	0x0b, 0xc2, 0x41, 0x4b, 0xbb, 0x8b, 0x14, 0xb6, 0x62, 0x74, 0x49, 0xd3, 0xba, 0xa7, 0x3f, 0x12,
	0x92, 0x0c, 0xae, 0xc1, 0x4a, 0xdf, 0x68, 0xde, 0xef, 0xeb, 0x33, 0x61, 0x0e, 0xaf, 0xc3, 0x6a,
	0xbb, 0xdf, 0x32, 0x9b, 0xdd, 0x56, 0x4a, 0x5c, 0x64, 0xab, 0xcb, 0x5e, 0xab, 0xb3, 0x27, 0xaa,
	0x88, 0xf5, 0xdf, 0x37, 0x7a, 0xcd, 0xbb, 0x86, 0xbe, 0x2f, 0x44, 0x9b, 0x4c, 0xf4, 0x91, 0x4e,
	0x3a, 0x07, 0xcd, 0x78, 0xc8, 0x3b, 0x18, 0x41, 0x79, 0xaf, 0x69, 0x68, 0x44, 0xf6, 0xf2, 0x4c,
	0xc1, 0x55, 0x28, 0xe9, 0x46, 0xbf, 0x2d, 0xeb, 0x19, 0x5c, 0x87, 0x9a, 0xd6, 0x37, 0x3b, 0x56,
	0xd3, 0x68, 0x10, 0xbd, 0xad, 0x1b, 0xa6, 0xd4, 0xe4, 0x70, 0x0d, 0xaa, 0x66, 0xb3, 0xad, 0xf7,
	0x4c, 0xad, 0xdd, 0x95, 0x42, 0x36, 0x8b, 0x62, 0x4f, 0x8f, 0x6d, 0x10, 0xde, 0x80, 0x75, 0xa3,
	0x63, 0xc9, 0x27, 0x4b, 0xd6, 0x03, 0xad, 0xd5, 0xd7, 0xa5, 0x6e, 0x13, 0x5f, 0x03, 0xdc, 0x31,
	0xac, 0x7e, 0x77, 0x5f, 0x33, 0x75, 0xcb, 0xe8, 0x3c, 0x94, 0x8a, 0x3b, 0xb8, 0x0a, 0xc5, 0xd9,
	0x0c, 0x9e, 0x31, 0x16, 0x2a, 0x5d, 0x8d, 0x98, 0x33, 0xb0, 0xcf, 0x9e, 0x31, 0xb2, 0xe0, 0x2e,
	0xe9, 0xf4, 0xbb, 0x33, 0xb3, 0x55, 0x28, 0x4b, 0xb2, 0xa4, 0x28, 0xc7, 0x44, 0x7b, 0x4d, 0xa3,
	0x91, 0xcc, 0xef, 0x59, 0x71, 0x23, 0x83, 0x94, 0xed, 0x63, 0xc8, 0x71, 0x77, 0x14, 0x21, 0x67,
	0x74, 0x0c, 0x1d, 0x5d, 0xc1, 0x2b, 0x00, 0xcd, 0x5e, 0xd3, 0x30, 0xf5, 0xbb, 0x44, 0x6b, 0x31,
	0xd8, 0x5c, 0x10, 0x13, 0xc8, 0xd0, 0x2e, 0xc3, 0x52, 0xb3, 0x77, 0xd0, 0xea, 0x68, 0xa6, 0x84,
	0xd9, 0xec, 0xdd, 0xef, 0x77, 0x4c, 0xa6, 0x44, 0xb8, 0x0c, 0x85, 0x66, 0xcf, 0xd4, 0xbf, 0x67,
	0x32, 0x5c, 0x5c, 0x27, 0x58, 0x45, 0xcf, 0xee, 0x6c, 0xff, 0x28, 0x0b, 0x39, 0xfe, 0xe0, 0xb4,
	0x02, 0x25, 0xee, 0x6d, 0xf3, 0x51, 0x97, 0x0d, 0x59, 0x82, 0x5c, 0xd3, 0x30, 0x6f, 0xa3, 0x5f,
	0xcc, 0x60, 0x80, 0x7c, 0x9f, 0x97, 0x7f, 0xa9, 0xc0, 0xca, 0x4d, 0xc3, 0x7c, 0xf7, 0x16, 0xfa,
	0x41, 0x86, 0x75, 0xdb, 0x17, 0x95, 0x5f, 0x8e, 0x15, 0xbb, 0x37, 0xd1, 0x0f, 0x13, 0xc5, 0xee,
	0x4d, 0xf4, 0x2b, 0xb1, 0xe2, 0xbd, 0x5d, 0xf4, 0xab, 0x89, 0xe2, 0xbd, 0x5d, 0xf4, 0x6b, 0xb1,
	0xe2, 0xd6, 0x4d, 0xf4, 0xeb, 0x89, 0xe2, 0xd6, 0x4d, 0xf4, 0x1b, 0x05, 0x86, 0x85, 0x23, 0x79,
	0x6f, 0x17, 0xfd, 0x66, 0x31, 0xa9, 0xdd, 0xba, 0x89, 0x7e, 0xab, 0xc8, 0xfc, 0x9f, 0x78, 0x15,
	0xfd, 0x36, 0x62, 0xd3, 0x64, 0x0e, 0x42, 0xbf, 0xc3, 0x8b, 0x4c, 0x85, 0x7e, 0x17, 0x31, 0x8c,
	0x4c, 0xca, 0xab, 0x1f, 0x73, 0xcd, 0x23, 0x5d, 0x23, 0xe8, 0xf7, 0x0a, 0xe2, 0x85, 0x5a, 0xa3,
	0xd9, 0xd6, 0x5a, 0x08, 0xf3, 0x16, 0x8c, 0x95, 0x3f, 0xb8, 0xc1, 0x8a, 0x2c, 0x3c, 0xd1, 0x1f,
	0x76, 0xd9, 0x80, 0x0f, 0x34, 0xd2, 0xf8, 0x40, 0x23, 0xe8, 0x8f, 0x6e, 0xb0, 0x01, 0x1f, 0x68,
	0x44, 0xf2, 0xf5, 0xc7, 0x5d, 0x66, 0xc8, 0x55, 0x9f, 0xdc, 0x60, 0x93, 0x96, 0xf2, 0x3f, 0xe9,
	0xe2, 0x22, 0x64, 0xf7, 0x9a, 0x26, 0xfa, 0x11, 0x1f, 0x8d, 0x85, 0x28, 0xfa, 0x53, 0xc4, 0x84,
	0x3d, 0xdd, 0x44, 0x7f, 0xc6, 0x84, 0x79, 0xb3, 0xdf, 0x6d, 0xe9, 0xe8, 0x0d, 0x36, 0xb9, 0xbb,
	0x7a, 0xa7, 0xad, 0x9b, 0xe4, 0x11, 0xfa, 0x73, 0x6e, 0xfe, 0x61, 0xaf, 0x63, 0xa0, 0x4f, 0x11,
	0xae, 0x02, 0xe8, 0xdf, 0xeb, 0x12, 0xbd, 0xd7, 0x6b, 0x76, 0x0c, 0xf4, 0xf6, 0xf6, 0x01, 0xa0,
	0xf3, 0xe9, 0x80, 0x01, 0xe8, 0x1b, 0xf7, 0x8c, 0xce, 0x43, 0x03, 0x5d, 0x61, 0x95, 0x2e, 0xd1,
	0xbb, 0x1a, 0xd1, 0x91, 0x82, 0x01, 0x0a, 0xf2, 0xdd, 0x5b, 0x06, 0x2f, 0x43, 0x91, 0x74, 0x5a,
	0xad, 0x3d, 0xad, 0x71, 0x0f, 0x65, 0xf7, 0xbe, 0x0d, 0x2b, 0x8e, 0xbf, 0x73, 0xe2, 0x44, 0x34,
	0x0c, 0xc5, 0x93, 0xe6, 0x8f, 0x54, 0x59, 0x73, 0xfc, 0xeb, 0xa2, 0x74, 0x7d, 0xe4, 0x5f, 0x3f,
	0x89, 0xae, 0x73, 0xed, 0x75, 0x9e, 0x31, 0x0e, 0x0b, 0xbc, 0xf2, 0xde, 0xff, 0x06, 0x00, 0x00,
	0xff, 0xff, 0x40, 0x99, 0x5d, 0x63, 0x30, 0x2d, 0x00, 0x00,
}
