// Code generated by protoc-gen-go. DO NOT EDIT.
// source: binlogdata.proto

package binlogdata

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	query "vitess.io/vitess/go/vt/proto/query"
	topodata "vitess.io/vitess/go/vt/proto/topodata"
	vtrpc "vitess.io/vitess/go/vt/proto/vtrpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// OnDDLAction lists the possible actions for DDLs.
type OnDDLAction int32

const (
	OnDDLAction_IGNORE      OnDDLAction = 0
	OnDDLAction_STOP        OnDDLAction = 1
	OnDDLAction_EXEC        OnDDLAction = 2
	OnDDLAction_EXEC_IGNORE OnDDLAction = 3
)

var OnDDLAction_name = map[int32]string{
	0: "IGNORE",
	1: "STOP",
	2: "EXEC",
	3: "EXEC_IGNORE",
}

var OnDDLAction_value = map[string]int32{
	"IGNORE":      0,
	"STOP":        1,
	"EXEC":        2,
	"EXEC_IGNORE": 3,
}

func (x OnDDLAction) String() string {
	return proto.EnumName(OnDDLAction_name, int32(x))
}

func (OnDDLAction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{0}
}

// VEventType enumerates the event types.
// This list is comprehensive. Many of these types
// will not be encountered in RBR mode.
type VEventType int32

const (
	VEventType_UNKNOWN   VEventType = 0
	VEventType_GTID      VEventType = 1
	VEventType_BEGIN     VEventType = 2
	VEventType_COMMIT    VEventType = 3
	VEventType_ROLLBACK  VEventType = 4
	VEventType_DDL       VEventType = 5
	VEventType_INSERT    VEventType = 6
	VEventType_REPLACE   VEventType = 7
	VEventType_UPDATE    VEventType = 8
	VEventType_DELETE    VEventType = 9
	VEventType_SET       VEventType = 10
	VEventType_OTHER     VEventType = 11
	VEventType_ROW       VEventType = 12
	VEventType_FIELD     VEventType = 13
	VEventType_HEARTBEAT VEventType = 14
	VEventType_VGTID     VEventType = 15
	VEventType_JOURNAL   VEventType = 16
)

var VEventType_name = map[int32]string{
	0:  "UNKNOWN",
	1:  "GTID",
	2:  "BEGIN",
	3:  "COMMIT",
	4:  "ROLLBACK",
	5:  "DDL",
	6:  "INSERT",
	7:  "REPLACE",
	8:  "UPDATE",
	9:  "DELETE",
	10: "SET",
	11: "OTHER",
	12: "ROW",
	13: "FIELD",
	14: "HEARTBEAT",
	15: "VGTID",
	16: "JOURNAL",
}

var VEventType_value = map[string]int32{
	"UNKNOWN":   0,
	"GTID":      1,
	"BEGIN":     2,
	"COMMIT":    3,
	"ROLLBACK":  4,
	"DDL":       5,
	"INSERT":    6,
	"REPLACE":   7,
	"UPDATE":    8,
	"DELETE":    9,
	"SET":       10,
	"OTHER":     11,
	"ROW":       12,
	"FIELD":     13,
	"HEARTBEAT": 14,
	"VGTID":     15,
	"JOURNAL":   16,
}

func (x VEventType) String() string {
	return proto.EnumName(VEventType_name, int32(x))
}

func (VEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1}
}

// MigrationType specifies the type of migration for the Journal.
type MigrationType int32

const (
	MigrationType_TABLES MigrationType = 0
	MigrationType_SHARDS MigrationType = 1
)

var MigrationType_name = map[int32]string{
	0: "TABLES",
	1: "SHARDS",
}

var MigrationType_value = map[string]int32{
	"TABLES": 0,
	"SHARDS": 1,
}

func (x MigrationType) String() string {
	return proto.EnumName(MigrationType_name, int32(x))
}

func (MigrationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{2}
}

type BinlogTransaction_Statement_Category int32

const (
	BinlogTransaction_Statement_BL_UNRECOGNIZED BinlogTransaction_Statement_Category = 0
	BinlogTransaction_Statement_BL_BEGIN        BinlogTransaction_Statement_Category = 1
	BinlogTransaction_Statement_BL_COMMIT       BinlogTransaction_Statement_Category = 2
	BinlogTransaction_Statement_BL_ROLLBACK     BinlogTransaction_Statement_Category = 3
	// BL_DML is deprecated.
	BinlogTransaction_Statement_BL_DML_DEPRECATED BinlogTransaction_Statement_Category = 4
	BinlogTransaction_Statement_BL_DDL            BinlogTransaction_Statement_Category = 5
	BinlogTransaction_Statement_BL_SET            BinlogTransaction_Statement_Category = 6
	BinlogTransaction_Statement_BL_INSERT         BinlogTransaction_Statement_Category = 7
	BinlogTransaction_Statement_BL_UPDATE         BinlogTransaction_Statement_Category = 8
	BinlogTransaction_Statement_BL_DELETE         BinlogTransaction_Statement_Category = 9
)

var BinlogTransaction_Statement_Category_name = map[int32]string{
	0: "BL_UNRECOGNIZED",
	1: "BL_BEGIN",
	2: "BL_COMMIT",
	3: "BL_ROLLBACK",
	4: "BL_DML_DEPRECATED",
	5: "BL_DDL",
	6: "BL_SET",
	7: "BL_INSERT",
	8: "BL_UPDATE",
	9: "BL_DELETE",
}

var BinlogTransaction_Statement_Category_value = map[string]int32{
	"BL_UNRECOGNIZED":   0,
	"BL_BEGIN":          1,
	"BL_COMMIT":         2,
	"BL_ROLLBACK":       3,
	"BL_DML_DEPRECATED": 4,
	"BL_DDL":            5,
	"BL_SET":            6,
	"BL_INSERT":         7,
	"BL_UPDATE":         8,
	"BL_DELETE":         9,
}

func (x BinlogTransaction_Statement_Category) String() string {
	return proto.EnumName(BinlogTransaction_Statement_Category_name, int32(x))
}

func (BinlogTransaction_Statement_Category) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1, 0, 0}
}

type Filter_FieldEventMode int32

const (
	Filter_ERR_ON_MISMATCH Filter_FieldEventMode = 0
	Filter_BEST_EFFORT     Filter_FieldEventMode = 1
)

var Filter_FieldEventMode_name = map[int32]string{
	0: "ERR_ON_MISMATCH",
	1: "BEST_EFFORT",
}

var Filter_FieldEventMode_value = map[string]int32{
	"ERR_ON_MISMATCH": 0,
	"BEST_EFFORT":     1,
}

func (x Filter_FieldEventMode) String() string {
	return proto.EnumName(Filter_FieldEventMode_name, int32(x))
}

func (Filter_FieldEventMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{7, 0}
}

// Charset is the per-statement charset info from a QUERY_EVENT binlog entry.
type Charset struct {
	// @@session.character_set_client
	Client int32 `protobuf:"varint,1,opt,name=client,proto3" json:"client,omitempty"`
	// @@session.collation_connection
	Conn int32 `protobuf:"varint,2,opt,name=conn,proto3" json:"conn,omitempty"`
	// @@session.collation_server
	Server               int32    `protobuf:"varint,3,opt,name=server,proto3" json:"server,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Charset) Reset()         { *m = Charset{} }
func (m *Charset) String() string { return proto.CompactTextString(m) }
func (*Charset) ProtoMessage()    {}
func (*Charset) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{0}
}

func (m *Charset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Charset.Unmarshal(m, b)
}
func (m *Charset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Charset.Marshal(b, m, deterministic)
}
func (m *Charset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Charset.Merge(m, src)
}
func (m *Charset) XXX_Size() int {
	return xxx_messageInfo_Charset.Size(m)
}
func (m *Charset) XXX_DiscardUnknown() {
	xxx_messageInfo_Charset.DiscardUnknown(m)
}

var xxx_messageInfo_Charset proto.InternalMessageInfo

func (m *Charset) GetClient() int32 {
	if m != nil {
		return m.Client
	}
	return 0
}

func (m *Charset) GetConn() int32 {
	if m != nil {
		return m.Conn
	}
	return 0
}

func (m *Charset) GetServer() int32 {
	if m != nil {
		return m.Server
	}
	return 0
}

// BinlogTransaction describes a transaction inside the binlogs.
// It is streamed by vttablet for filtered replication, used during resharding.
type BinlogTransaction struct {
	// the statements in this transaction
	Statements []*BinlogTransaction_Statement `protobuf:"bytes,1,rep,name=statements,proto3" json:"statements,omitempty"`
	// The Event Token for this event.
	EventToken           *query.EventToken `protobuf:"bytes,4,opt,name=event_token,json=eventToken,proto3" json:"event_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BinlogTransaction) Reset()         { *m = BinlogTransaction{} }
func (m *BinlogTransaction) String() string { return proto.CompactTextString(m) }
func (*BinlogTransaction) ProtoMessage()    {}
func (*BinlogTransaction) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1}
}

func (m *BinlogTransaction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinlogTransaction.Unmarshal(m, b)
}
func (m *BinlogTransaction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinlogTransaction.Marshal(b, m, deterministic)
}
func (m *BinlogTransaction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinlogTransaction.Merge(m, src)
}
func (m *BinlogTransaction) XXX_Size() int {
	return xxx_messageInfo_BinlogTransaction.Size(m)
}
func (m *BinlogTransaction) XXX_DiscardUnknown() {
	xxx_messageInfo_BinlogTransaction.DiscardUnknown(m)
}

var xxx_messageInfo_BinlogTransaction proto.InternalMessageInfo

func (m *BinlogTransaction) GetStatements() []*BinlogTransaction_Statement {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *BinlogTransaction) GetEventToken() *query.EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

type BinlogTransaction_Statement struct {
	// what type of statement is this?
	Category BinlogTransaction_Statement_Category `protobuf:"varint,1,opt,name=category,proto3,enum=binlogdata.BinlogTransaction_Statement_Category" json:"category,omitempty"`
	// charset of this statement, if different from pre-negotiated default.
	Charset *Charset `protobuf:"bytes,2,opt,name=charset,proto3" json:"charset,omitempty"`
	// the sql
	Sql                  []byte   `protobuf:"bytes,3,opt,name=sql,proto3" json:"sql,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BinlogTransaction_Statement) Reset()         { *m = BinlogTransaction_Statement{} }
func (m *BinlogTransaction_Statement) String() string { return proto.CompactTextString(m) }
func (*BinlogTransaction_Statement) ProtoMessage()    {}
func (*BinlogTransaction_Statement) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{1, 0}
}

func (m *BinlogTransaction_Statement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinlogTransaction_Statement.Unmarshal(m, b)
}
func (m *BinlogTransaction_Statement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinlogTransaction_Statement.Marshal(b, m, deterministic)
}
func (m *BinlogTransaction_Statement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinlogTransaction_Statement.Merge(m, src)
}
func (m *BinlogTransaction_Statement) XXX_Size() int {
	return xxx_messageInfo_BinlogTransaction_Statement.Size(m)
}
func (m *BinlogTransaction_Statement) XXX_DiscardUnknown() {
	xxx_messageInfo_BinlogTransaction_Statement.DiscardUnknown(m)
}

var xxx_messageInfo_BinlogTransaction_Statement proto.InternalMessageInfo

func (m *BinlogTransaction_Statement) GetCategory() BinlogTransaction_Statement_Category {
	if m != nil {
		return m.Category
	}
	return BinlogTransaction_Statement_BL_UNRECOGNIZED
}

func (m *BinlogTransaction_Statement) GetCharset() *Charset {
	if m != nil {
		return m.Charset
	}
	return nil
}

func (m *BinlogTransaction_Statement) GetSql() []byte {
	if m != nil {
		return m.Sql
	}
	return nil
}

// StreamKeyRangeRequest is the payload to StreamKeyRange
type StreamKeyRangeRequest struct {
	// where to start
	Position string `protobuf:"bytes,1,opt,name=position,proto3" json:"position,omitempty"`
	// what to get
	KeyRange *topodata.KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// default charset on the player side
	Charset              *Charset `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamKeyRangeRequest) Reset()         { *m = StreamKeyRangeRequest{} }
func (m *StreamKeyRangeRequest) String() string { return proto.CompactTextString(m) }
func (*StreamKeyRangeRequest) ProtoMessage()    {}
func (*StreamKeyRangeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{2}
}

func (m *StreamKeyRangeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamKeyRangeRequest.Unmarshal(m, b)
}
func (m *StreamKeyRangeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamKeyRangeRequest.Marshal(b, m, deterministic)
}
func (m *StreamKeyRangeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamKeyRangeRequest.Merge(m, src)
}
func (m *StreamKeyRangeRequest) XXX_Size() int {
	return xxx_messageInfo_StreamKeyRangeRequest.Size(m)
}
func (m *StreamKeyRangeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamKeyRangeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamKeyRangeRequest proto.InternalMessageInfo

func (m *StreamKeyRangeRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *StreamKeyRangeRequest) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *StreamKeyRangeRequest) GetCharset() *Charset {
	if m != nil {
		return m.Charset
	}
	return nil
}

// StreamKeyRangeResponse is the response from StreamKeyRange
type StreamKeyRangeResponse struct {
	BinlogTransaction    *BinlogTransaction `protobuf:"bytes,1,opt,name=binlog_transaction,json=binlogTransaction,proto3" json:"binlog_transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamKeyRangeResponse) Reset()         { *m = StreamKeyRangeResponse{} }
func (m *StreamKeyRangeResponse) String() string { return proto.CompactTextString(m) }
func (*StreamKeyRangeResponse) ProtoMessage()    {}
func (*StreamKeyRangeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{3}
}

func (m *StreamKeyRangeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamKeyRangeResponse.Unmarshal(m, b)
}
func (m *StreamKeyRangeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamKeyRangeResponse.Marshal(b, m, deterministic)
}
func (m *StreamKeyRangeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamKeyRangeResponse.Merge(m, src)
}
func (m *StreamKeyRangeResponse) XXX_Size() int {
	return xxx_messageInfo_StreamKeyRangeResponse.Size(m)
}
func (m *StreamKeyRangeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamKeyRangeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamKeyRangeResponse proto.InternalMessageInfo

func (m *StreamKeyRangeResponse) GetBinlogTransaction() *BinlogTransaction {
	if m != nil {
		return m.BinlogTransaction
	}
	return nil
}

// StreamTablesRequest is the payload to StreamTables
type StreamTablesRequest struct {
	// where to start
	Position string `protobuf:"bytes,1,opt,name=position,proto3" json:"position,omitempty"`
	// what to get
	Tables []string `protobuf:"bytes,2,rep,name=tables,proto3" json:"tables,omitempty"`
	// default charset on the player side
	Charset              *Charset `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamTablesRequest) Reset()         { *m = StreamTablesRequest{} }
func (m *StreamTablesRequest) String() string { return proto.CompactTextString(m) }
func (*StreamTablesRequest) ProtoMessage()    {}
func (*StreamTablesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{4}
}

func (m *StreamTablesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamTablesRequest.Unmarshal(m, b)
}
func (m *StreamTablesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamTablesRequest.Marshal(b, m, deterministic)
}
func (m *StreamTablesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamTablesRequest.Merge(m, src)
}
func (m *StreamTablesRequest) XXX_Size() int {
	return xxx_messageInfo_StreamTablesRequest.Size(m)
}
func (m *StreamTablesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamTablesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamTablesRequest proto.InternalMessageInfo

func (m *StreamTablesRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *StreamTablesRequest) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *StreamTablesRequest) GetCharset() *Charset {
	if m != nil {
		return m.Charset
	}
	return nil
}

// StreamTablesResponse is the response from StreamTables
type StreamTablesResponse struct {
	BinlogTransaction    *BinlogTransaction `protobuf:"bytes,1,opt,name=binlog_transaction,json=binlogTransaction,proto3" json:"binlog_transaction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamTablesResponse) Reset()         { *m = StreamTablesResponse{} }
func (m *StreamTablesResponse) String() string { return proto.CompactTextString(m) }
func (*StreamTablesResponse) ProtoMessage()    {}
func (*StreamTablesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{5}
}

func (m *StreamTablesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamTablesResponse.Unmarshal(m, b)
}
func (m *StreamTablesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamTablesResponse.Marshal(b, m, deterministic)
}
func (m *StreamTablesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamTablesResponse.Merge(m, src)
}
func (m *StreamTablesResponse) XXX_Size() int {
	return xxx_messageInfo_StreamTablesResponse.Size(m)
}
func (m *StreamTablesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamTablesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamTablesResponse proto.InternalMessageInfo

func (m *StreamTablesResponse) GetBinlogTransaction() *BinlogTransaction {
	if m != nil {
		return m.BinlogTransaction
	}
	return nil
}

// Rule represents one rule.
type Rule struct {
	// match can be a table name or a regular expression
	// delineated by '/' and '/'.
	Match string `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// filter can be an empty string or keyrange if the match
	// is a regular expression. Otherwise, it must be a select
	// query.
	Filter               string   `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Rule) Reset()         { *m = Rule{} }
func (m *Rule) String() string { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()    {}
func (*Rule) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{6}
}

func (m *Rule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Rule.Unmarshal(m, b)
}
func (m *Rule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Rule.Marshal(b, m, deterministic)
}
func (m *Rule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Rule.Merge(m, src)
}
func (m *Rule) XXX_Size() int {
	return xxx_messageInfo_Rule.Size(m)
}
func (m *Rule) XXX_DiscardUnknown() {
	xxx_messageInfo_Rule.DiscardUnknown(m)
}

var xxx_messageInfo_Rule proto.InternalMessageInfo

func (m *Rule) GetMatch() string {
	if m != nil {
		return m.Match
	}
	return ""
}

func (m *Rule) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Filter represents a list of ordered rules. First match
// wins.
type Filter struct {
	Rules                []*Rule               `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	FieldEventMode       Filter_FieldEventMode `protobuf:"varint,2,opt,name=fieldEventMode,proto3,enum=binlogdata.Filter_FieldEventMode" json:"fieldEventMode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{7}
}

func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetRules() []*Rule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *Filter) GetFieldEventMode() Filter_FieldEventMode {
	if m != nil {
		return m.FieldEventMode
	}
	return Filter_ERR_ON_MISMATCH
}

// BinlogSource specifies the source  and filter parameters for
// Filtered Replication. It currently supports a keyrange
// or a list of tables.
type BinlogSource struct {
	// the source keyspace
	Keyspace string `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	// the source tablet type
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// key_range is set if the request is for a keyrange
	KeyRange *topodata.KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// tables is set if the request is for a list of tables
	Tables []string `protobuf:"bytes,5,rep,name=tables,proto3" json:"tables,omitempty"`
	// filter is set if we're using the generalized representation
	// for the filter.
	Filter *Filter `protobuf:"bytes,6,opt,name=filter,proto3" json:"filter,omitempty"`
	// on_ddl specifies the action to be taken when a DDL is encountered.
	OnDdl OnDDLAction `protobuf:"varint,7,opt,name=on_ddl,json=onDdl,proto3,enum=binlogdata.OnDDLAction" json:"on_ddl,omitempty"`
	// Source is an external mysql. This attribute should be set to the username
	// to use in the connection
	ExternalMysql string `protobuf:"bytes,8,opt,name=external_mysql,json=externalMysql,proto3" json:"external_mysql,omitempty"`
	// stop_after_copy specifies if vreplication should be stopped
	// after copying is done.
	StopAfterCopy        bool     `protobuf:"varint,9,opt,name=stop_after_copy,json=stopAfterCopy,proto3" json:"stop_after_copy,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BinlogSource) Reset()         { *m = BinlogSource{} }
func (m *BinlogSource) String() string { return proto.CompactTextString(m) }
func (*BinlogSource) ProtoMessage()    {}
func (*BinlogSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{8}
}

func (m *BinlogSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BinlogSource.Unmarshal(m, b)
}
func (m *BinlogSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BinlogSource.Marshal(b, m, deterministic)
}
func (m *BinlogSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BinlogSource.Merge(m, src)
}
func (m *BinlogSource) XXX_Size() int {
	return xxx_messageInfo_BinlogSource.Size(m)
}
func (m *BinlogSource) XXX_DiscardUnknown() {
	xxx_messageInfo_BinlogSource.DiscardUnknown(m)
}

var xxx_messageInfo_BinlogSource proto.InternalMessageInfo

func (m *BinlogSource) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *BinlogSource) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *BinlogSource) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}

func (m *BinlogSource) GetKeyRange() *topodata.KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *BinlogSource) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *BinlogSource) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *BinlogSource) GetOnDdl() OnDDLAction {
	if m != nil {
		return m.OnDdl
	}
	return OnDDLAction_IGNORE
}

func (m *BinlogSource) GetExternalMysql() string {
	if m != nil {
		return m.ExternalMysql
	}
	return ""
}

func (m *BinlogSource) GetStopAfterCopy() bool {
	if m != nil {
		return m.StopAfterCopy
	}
	return false
}

// RowChange represents one row change
type RowChange struct {
	Before               *query.Row `protobuf:"bytes,1,opt,name=before,proto3" json:"before,omitempty"`
	After                *query.Row `protobuf:"bytes,2,opt,name=after,proto3" json:"after,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *RowChange) Reset()         { *m = RowChange{} }
func (m *RowChange) String() string { return proto.CompactTextString(m) }
func (*RowChange) ProtoMessage()    {}
func (*RowChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{9}
}

func (m *RowChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowChange.Unmarshal(m, b)
}
func (m *RowChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowChange.Marshal(b, m, deterministic)
}
func (m *RowChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowChange.Merge(m, src)
}
func (m *RowChange) XXX_Size() int {
	return xxx_messageInfo_RowChange.Size(m)
}
func (m *RowChange) XXX_DiscardUnknown() {
	xxx_messageInfo_RowChange.DiscardUnknown(m)
}

var xxx_messageInfo_RowChange proto.InternalMessageInfo

func (m *RowChange) GetBefore() *query.Row {
	if m != nil {
		return m.Before
	}
	return nil
}

func (m *RowChange) GetAfter() *query.Row {
	if m != nil {
		return m.After
	}
	return nil
}

// RowEvent represent row events for one table
type RowEvent struct {
	TableName            string       `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	RowChanges           []*RowChange `protobuf:"bytes,2,rep,name=row_changes,json=rowChanges,proto3" json:"row_changes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *RowEvent) Reset()         { *m = RowEvent{} }
func (m *RowEvent) String() string { return proto.CompactTextString(m) }
func (*RowEvent) ProtoMessage()    {}
func (*RowEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{10}
}

func (m *RowEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RowEvent.Unmarshal(m, b)
}
func (m *RowEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RowEvent.Marshal(b, m, deterministic)
}
func (m *RowEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RowEvent.Merge(m, src)
}
func (m *RowEvent) XXX_Size() int {
	return xxx_messageInfo_RowEvent.Size(m)
}
func (m *RowEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_RowEvent.DiscardUnknown(m)
}

var xxx_messageInfo_RowEvent proto.InternalMessageInfo

func (m *RowEvent) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *RowEvent) GetRowChanges() []*RowChange {
	if m != nil {
		return m.RowChanges
	}
	return nil
}

type FieldEvent struct {
	TableName            string         `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	Fields               []*query.Field `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FieldEvent) Reset()         { *m = FieldEvent{} }
func (m *FieldEvent) String() string { return proto.CompactTextString(m) }
func (*FieldEvent) ProtoMessage()    {}
func (*FieldEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{11}
}

func (m *FieldEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FieldEvent.Unmarshal(m, b)
}
func (m *FieldEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FieldEvent.Marshal(b, m, deterministic)
}
func (m *FieldEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FieldEvent.Merge(m, src)
}
func (m *FieldEvent) XXX_Size() int {
	return xxx_messageInfo_FieldEvent.Size(m)
}
func (m *FieldEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_FieldEvent.DiscardUnknown(m)
}

var xxx_messageInfo_FieldEvent proto.InternalMessageInfo

func (m *FieldEvent) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *FieldEvent) GetFields() []*query.Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

type ShardGtid struct {
	Keyspace             string   `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard                string   `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	Gtid                 string   `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShardGtid) Reset()         { *m = ShardGtid{} }
func (m *ShardGtid) String() string { return proto.CompactTextString(m) }
func (*ShardGtid) ProtoMessage()    {}
func (*ShardGtid) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{12}
}

func (m *ShardGtid) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardGtid.Unmarshal(m, b)
}
func (m *ShardGtid) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardGtid.Marshal(b, m, deterministic)
}
func (m *ShardGtid) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardGtid.Merge(m, src)
}
func (m *ShardGtid) XXX_Size() int {
	return xxx_messageInfo_ShardGtid.Size(m)
}
func (m *ShardGtid) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardGtid.DiscardUnknown(m)
}

var xxx_messageInfo_ShardGtid proto.InternalMessageInfo

func (m *ShardGtid) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *ShardGtid) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *ShardGtid) GetGtid() string {
	if m != nil {
		return m.Gtid
	}
	return ""
}

type VGtid struct {
	ShardGtids           []*ShardGtid `protobuf:"bytes,1,rep,name=shard_gtids,json=shardGtids,proto3" json:"shard_gtids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *VGtid) Reset()         { *m = VGtid{} }
func (m *VGtid) String() string { return proto.CompactTextString(m) }
func (*VGtid) ProtoMessage()    {}
func (*VGtid) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{13}
}

func (m *VGtid) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VGtid.Unmarshal(m, b)
}
func (m *VGtid) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VGtid.Marshal(b, m, deterministic)
}
func (m *VGtid) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VGtid.Merge(m, src)
}
func (m *VGtid) XXX_Size() int {
	return xxx_messageInfo_VGtid.Size(m)
}
func (m *VGtid) XXX_DiscardUnknown() {
	xxx_messageInfo_VGtid.DiscardUnknown(m)
}

var xxx_messageInfo_VGtid proto.InternalMessageInfo

func (m *VGtid) GetShardGtids() []*ShardGtid {
	if m != nil {
		return m.ShardGtids
	}
	return nil
}

type KeyspaceShard struct {
	Keyspace             string   `protobuf:"bytes,1,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	Shard                string   `protobuf:"bytes,2,opt,name=shard,proto3" json:"shard,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyspaceShard) Reset()         { *m = KeyspaceShard{} }
func (m *KeyspaceShard) String() string { return proto.CompactTextString(m) }
func (*KeyspaceShard) ProtoMessage()    {}
func (*KeyspaceShard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{14}
}

func (m *KeyspaceShard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyspaceShard.Unmarshal(m, b)
}
func (m *KeyspaceShard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyspaceShard.Marshal(b, m, deterministic)
}
func (m *KeyspaceShard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyspaceShard.Merge(m, src)
}
func (m *KeyspaceShard) XXX_Size() int {
	return xxx_messageInfo_KeyspaceShard.Size(m)
}
func (m *KeyspaceShard) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyspaceShard.DiscardUnknown(m)
}

var xxx_messageInfo_KeyspaceShard proto.InternalMessageInfo

func (m *KeyspaceShard) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *KeyspaceShard) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

type Journal struct {
	Id                   int64            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	MigrationType        MigrationType    `protobuf:"varint,2,opt,name=migration_type,json=migrationType,proto3,enum=binlogdata.MigrationType" json:"migration_type,omitempty"`
	Tables               []string         `protobuf:"bytes,3,rep,name=tables,proto3" json:"tables,omitempty"`
	LocalPosition        string           `protobuf:"bytes,4,opt,name=local_position,json=localPosition,proto3" json:"local_position,omitempty"`
	ShardGtids           []*ShardGtid     `protobuf:"bytes,5,rep,name=shard_gtids,json=shardGtids,proto3" json:"shard_gtids,omitempty"`
	Participants         []*KeyspaceShard `protobuf:"bytes,6,rep,name=participants,proto3" json:"participants,omitempty"`
	SourceWorkflows      []string         `protobuf:"bytes,7,rep,name=source_workflows,json=sourceWorkflows,proto3" json:"source_workflows,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Journal) Reset()         { *m = Journal{} }
func (m *Journal) String() string { return proto.CompactTextString(m) }
func (*Journal) ProtoMessage()    {}
func (*Journal) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{15}
}

func (m *Journal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Journal.Unmarshal(m, b)
}
func (m *Journal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Journal.Marshal(b, m, deterministic)
}
func (m *Journal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Journal.Merge(m, src)
}
func (m *Journal) XXX_Size() int {
	return xxx_messageInfo_Journal.Size(m)
}
func (m *Journal) XXX_DiscardUnknown() {
	xxx_messageInfo_Journal.DiscardUnknown(m)
}

var xxx_messageInfo_Journal proto.InternalMessageInfo

func (m *Journal) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Journal) GetMigrationType() MigrationType {
	if m != nil {
		return m.MigrationType
	}
	return MigrationType_TABLES
}

func (m *Journal) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *Journal) GetLocalPosition() string {
	if m != nil {
		return m.LocalPosition
	}
	return ""
}

func (m *Journal) GetShardGtids() []*ShardGtid {
	if m != nil {
		return m.ShardGtids
	}
	return nil
}

func (m *Journal) GetParticipants() []*KeyspaceShard {
	if m != nil {
		return m.Participants
	}
	return nil
}

func (m *Journal) GetSourceWorkflows() []string {
	if m != nil {
		return m.SourceWorkflows
	}
	return nil
}

// VEvent represents a vstream event
type VEvent struct {
	Type       VEventType  `protobuf:"varint,1,opt,name=type,proto3,enum=binlogdata.VEventType" json:"type,omitempty"`
	Timestamp  int64       `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Gtid       string      `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Ddl        string      `protobuf:"bytes,4,opt,name=ddl,proto3" json:"ddl,omitempty"`
	RowEvent   *RowEvent   `protobuf:"bytes,5,opt,name=row_event,json=rowEvent,proto3" json:"row_event,omitempty"`
	FieldEvent *FieldEvent `protobuf:"bytes,6,opt,name=field_event,json=fieldEvent,proto3" json:"field_event,omitempty"`
	Vgtid      *VGtid      `protobuf:"bytes,7,opt,name=vgtid,proto3" json:"vgtid,omitempty"`
	Journal    *Journal    `protobuf:"bytes,8,opt,name=journal,proto3" json:"journal,omitempty"`
	Dml        string      `protobuf:"bytes,9,opt,name=dml,proto3" json:"dml,omitempty"`
	// current_time specifies the current time to handle clock skew.
	CurrentTime          int64    `protobuf:"varint,20,opt,name=current_time,json=currentTime,proto3" json:"current_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VEvent) Reset()         { *m = VEvent{} }
func (m *VEvent) String() string { return proto.CompactTextString(m) }
func (*VEvent) ProtoMessage()    {}
func (*VEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{16}
}

func (m *VEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VEvent.Unmarshal(m, b)
}
func (m *VEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VEvent.Marshal(b, m, deterministic)
}
func (m *VEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VEvent.Merge(m, src)
}
func (m *VEvent) XXX_Size() int {
	return xxx_messageInfo_VEvent.Size(m)
}
func (m *VEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_VEvent.DiscardUnknown(m)
}

var xxx_messageInfo_VEvent proto.InternalMessageInfo

func (m *VEvent) GetType() VEventType {
	if m != nil {
		return m.Type
	}
	return VEventType_UNKNOWN
}

func (m *VEvent) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *VEvent) GetGtid() string {
	if m != nil {
		return m.Gtid
	}
	return ""
}

func (m *VEvent) GetDdl() string {
	if m != nil {
		return m.Ddl
	}
	return ""
}

func (m *VEvent) GetRowEvent() *RowEvent {
	if m != nil {
		return m.RowEvent
	}
	return nil
}

func (m *VEvent) GetFieldEvent() *FieldEvent {
	if m != nil {
		return m.FieldEvent
	}
	return nil
}

func (m *VEvent) GetVgtid() *VGtid {
	if m != nil {
		return m.Vgtid
	}
	return nil
}

func (m *VEvent) GetJournal() *Journal {
	if m != nil {
		return m.Journal
	}
	return nil
}

func (m *VEvent) GetDml() string {
	if m != nil {
		return m.Dml
	}
	return ""
}

func (m *VEvent) GetCurrentTime() int64 {
	if m != nil {
		return m.CurrentTime
	}
	return 0
}

// VStreamRequest is the payload for VStream
type VStreamRequest struct {
	EffectiveCallerId    *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Position             string                `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
	Filter               *Filter               `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VStreamRequest) Reset()         { *m = VStreamRequest{} }
func (m *VStreamRequest) String() string { return proto.CompactTextString(m) }
func (*VStreamRequest) ProtoMessage()    {}
func (*VStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{17}
}

func (m *VStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamRequest.Unmarshal(m, b)
}
func (m *VStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamRequest.Marshal(b, m, deterministic)
}
func (m *VStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamRequest.Merge(m, src)
}
func (m *VStreamRequest) XXX_Size() int {
	return xxx_messageInfo_VStreamRequest.Size(m)
}
func (m *VStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamRequest proto.InternalMessageInfo

func (m *VStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *VStreamRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *VStreamRequest) GetTarget() *query.Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *VStreamRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *VStreamRequest) GetFilter() *Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

// VStreamResponse is the response from VStream
type VStreamResponse struct {
	Events               []*VEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *VStreamResponse) Reset()         { *m = VStreamResponse{} }
func (m *VStreamResponse) String() string { return proto.CompactTextString(m) }
func (*VStreamResponse) ProtoMessage()    {}
func (*VStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{18}
}

func (m *VStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamResponse.Unmarshal(m, b)
}
func (m *VStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamResponse.Marshal(b, m, deterministic)
}
func (m *VStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamResponse.Merge(m, src)
}
func (m *VStreamResponse) XXX_Size() int {
	return xxx_messageInfo_VStreamResponse.Size(m)
}
func (m *VStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamResponse proto.InternalMessageInfo

func (m *VStreamResponse) GetEvents() []*VEvent {
	if m != nil {
		return m.Events
	}
	return nil
}

// VStreamRowsRequest is the payload for VStreamRows
type VStreamRowsRequest struct {
	EffectiveCallerId    *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query                string                `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	Lastpk               *query.QueryResult    `protobuf:"bytes,5,opt,name=lastpk,proto3" json:"lastpk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VStreamRowsRequest) Reset()         { *m = VStreamRowsRequest{} }
func (m *VStreamRowsRequest) String() string { return proto.CompactTextString(m) }
func (*VStreamRowsRequest) ProtoMessage()    {}
func (*VStreamRowsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{19}
}

func (m *VStreamRowsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamRowsRequest.Unmarshal(m, b)
}
func (m *VStreamRowsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamRowsRequest.Marshal(b, m, deterministic)
}
func (m *VStreamRowsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamRowsRequest.Merge(m, src)
}
func (m *VStreamRowsRequest) XXX_Size() int {
	return xxx_messageInfo_VStreamRowsRequest.Size(m)
}
func (m *VStreamRowsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamRowsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamRowsRequest proto.InternalMessageInfo

func (m *VStreamRowsRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *VStreamRowsRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *VStreamRowsRequest) GetTarget() *query.Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *VStreamRowsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *VStreamRowsRequest) GetLastpk() *query.QueryResult {
	if m != nil {
		return m.Lastpk
	}
	return nil
}

// VStreamRowsResponse is the response from VStreamRows
type VStreamRowsResponse struct {
	Fields               []*query.Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	Pkfields             []*query.Field `protobuf:"bytes,2,rep,name=pkfields,proto3" json:"pkfields,omitempty"`
	Gtid                 string         `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Rows                 []*query.Row   `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
	Lastpk               *query.Row     `protobuf:"bytes,5,opt,name=lastpk,proto3" json:"lastpk,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VStreamRowsResponse) Reset()         { *m = VStreamRowsResponse{} }
func (m *VStreamRowsResponse) String() string { return proto.CompactTextString(m) }
func (*VStreamRowsResponse) ProtoMessage()    {}
func (*VStreamRowsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{20}
}

func (m *VStreamRowsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamRowsResponse.Unmarshal(m, b)
}
func (m *VStreamRowsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamRowsResponse.Marshal(b, m, deterministic)
}
func (m *VStreamRowsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamRowsResponse.Merge(m, src)
}
func (m *VStreamRowsResponse) XXX_Size() int {
	return xxx_messageInfo_VStreamRowsResponse.Size(m)
}
func (m *VStreamRowsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamRowsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamRowsResponse proto.InternalMessageInfo

func (m *VStreamRowsResponse) GetFields() []*query.Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *VStreamRowsResponse) GetPkfields() []*query.Field {
	if m != nil {
		return m.Pkfields
	}
	return nil
}

func (m *VStreamRowsResponse) GetGtid() string {
	if m != nil {
		return m.Gtid
	}
	return ""
}

func (m *VStreamRowsResponse) GetRows() []*query.Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *VStreamRowsResponse) GetLastpk() *query.Row {
	if m != nil {
		return m.Lastpk
	}
	return nil
}

// VStreamResultsRequest is the payload for VStreamResults
// The ids match VStreamRows, in case we decide to merge the two.
type VStreamResultsRequest struct {
	EffectiveCallerId    *vtrpc.CallerID       `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId,proto3" json:"effective_caller_id,omitempty"`
	ImmediateCallerId    *query.VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId,proto3" json:"immediate_caller_id,omitempty"`
	Target               *query.Target         `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	Query                string                `protobuf:"bytes,4,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VStreamResultsRequest) Reset()         { *m = VStreamResultsRequest{} }
func (m *VStreamResultsRequest) String() string { return proto.CompactTextString(m) }
func (*VStreamResultsRequest) ProtoMessage()    {}
func (*VStreamResultsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{21}
}

func (m *VStreamResultsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamResultsRequest.Unmarshal(m, b)
}
func (m *VStreamResultsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamResultsRequest.Marshal(b, m, deterministic)
}
func (m *VStreamResultsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamResultsRequest.Merge(m, src)
}
func (m *VStreamResultsRequest) XXX_Size() int {
	return xxx_messageInfo_VStreamResultsRequest.Size(m)
}
func (m *VStreamResultsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamResultsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamResultsRequest proto.InternalMessageInfo

func (m *VStreamResultsRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *VStreamResultsRequest) GetImmediateCallerId() *query.VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *VStreamResultsRequest) GetTarget() *query.Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *VStreamResultsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

// VStreamResultsResponse is the response from VStreamResults
// The ids match VStreamRows, in case we decide to merge the two.
type VStreamResultsResponse struct {
	Fields               []*query.Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	Gtid                 string         `protobuf:"bytes,3,opt,name=gtid,proto3" json:"gtid,omitempty"`
	Rows                 []*query.Row   `protobuf:"bytes,4,rep,name=rows,proto3" json:"rows,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VStreamResultsResponse) Reset()         { *m = VStreamResultsResponse{} }
func (m *VStreamResultsResponse) String() string { return proto.CompactTextString(m) }
func (*VStreamResultsResponse) ProtoMessage()    {}
func (*VStreamResultsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fd02bcb2e350dad, []int{22}
}

func (m *VStreamResultsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VStreamResultsResponse.Unmarshal(m, b)
}
func (m *VStreamResultsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VStreamResultsResponse.Marshal(b, m, deterministic)
}
func (m *VStreamResultsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VStreamResultsResponse.Merge(m, src)
}
func (m *VStreamResultsResponse) XXX_Size() int {
	return xxx_messageInfo_VStreamResultsResponse.Size(m)
}
func (m *VStreamResultsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_VStreamResultsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_VStreamResultsResponse proto.InternalMessageInfo

func (m *VStreamResultsResponse) GetFields() []*query.Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *VStreamResultsResponse) GetGtid() string {
	if m != nil {
		return m.Gtid
	}
	return ""
}

func (m *VStreamResultsResponse) GetRows() []*query.Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func init() {
	proto.RegisterEnum("binlogdata.OnDDLAction", OnDDLAction_name, OnDDLAction_value)
	proto.RegisterEnum("binlogdata.VEventType", VEventType_name, VEventType_value)
	proto.RegisterEnum("binlogdata.MigrationType", MigrationType_name, MigrationType_value)
	proto.RegisterEnum("binlogdata.BinlogTransaction_Statement_Category", BinlogTransaction_Statement_Category_name, BinlogTransaction_Statement_Category_value)
	proto.RegisterEnum("binlogdata.Filter_FieldEventMode", Filter_FieldEventMode_name, Filter_FieldEventMode_value)
	proto.RegisterType((*Charset)(nil), "binlogdata.Charset")
	proto.RegisterType((*BinlogTransaction)(nil), "binlogdata.BinlogTransaction")
	proto.RegisterType((*BinlogTransaction_Statement)(nil), "binlogdata.BinlogTransaction.Statement")
	proto.RegisterType((*StreamKeyRangeRequest)(nil), "binlogdata.StreamKeyRangeRequest")
	proto.RegisterType((*StreamKeyRangeResponse)(nil), "binlogdata.StreamKeyRangeResponse")
	proto.RegisterType((*StreamTablesRequest)(nil), "binlogdata.StreamTablesRequest")
	proto.RegisterType((*StreamTablesResponse)(nil), "binlogdata.StreamTablesResponse")
	proto.RegisterType((*Rule)(nil), "binlogdata.Rule")
	proto.RegisterType((*Filter)(nil), "binlogdata.Filter")
	proto.RegisterType((*BinlogSource)(nil), "binlogdata.BinlogSource")
	proto.RegisterType((*RowChange)(nil), "binlogdata.RowChange")
	proto.RegisterType((*RowEvent)(nil), "binlogdata.RowEvent")
	proto.RegisterType((*FieldEvent)(nil), "binlogdata.FieldEvent")
	proto.RegisterType((*ShardGtid)(nil), "binlogdata.ShardGtid")
	proto.RegisterType((*VGtid)(nil), "binlogdata.VGtid")
	proto.RegisterType((*KeyspaceShard)(nil), "binlogdata.KeyspaceShard")
	proto.RegisterType((*Journal)(nil), "binlogdata.Journal")
	proto.RegisterType((*VEvent)(nil), "binlogdata.VEvent")
	proto.RegisterType((*VStreamRequest)(nil), "binlogdata.VStreamRequest")
	proto.RegisterType((*VStreamResponse)(nil), "binlogdata.VStreamResponse")
	proto.RegisterType((*VStreamRowsRequest)(nil), "binlogdata.VStreamRowsRequest")
	proto.RegisterType((*VStreamRowsResponse)(nil), "binlogdata.VStreamRowsResponse")
	proto.RegisterType((*VStreamResultsRequest)(nil), "binlogdata.VStreamResultsRequest")
	proto.RegisterType((*VStreamResultsResponse)(nil), "binlogdata.VStreamResultsResponse")
}

func init() { proto.RegisterFile("binlogdata.proto", fileDescriptor_5fd02bcb2e350dad) }

var fileDescriptor_5fd02bcb2e350dad = []byte{
	// 1709 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0x4b, 0x73, 0x23, 0x49,
	0x11, 0x9e, 0xd6, 0x5b, 0xd9, 0xb6, 0xdc, 0x2e, 0x3f, 0x10, 0x13, 0x2c, 0xe1, 0xed, 0x60, 0x76,
	0xbc, 0x8e, 0x40, 0x06, 0x01, 0xc3, 0x69, 0x59, 0xf4, 0x68, 0x7b, 0x34, 0xd3, 0x92, 0x3c, 0xa5,
	0x1e, 0x0f, 0xb1, 0x97, 0x8e, 0xb6, 0x54, 0xf6, 0x34, 0xee, 0xd7, 0x74, 0x97, 0xec, 0xd5, 0x0f,
	0x20, 0xf8, 0x01, 0xfc, 0x0a, 0xce, 0x5c, 0xe1, 0xca, 0x9d, 0x3b, 0x57, 0x4e, 0x9c, 0xf8, 0x07,
	0x44, 0x3d, 0xba, 0xd5, 0xad, 0x59, 0x76, 0x3c, 0x1b, 0xc1, 0x01, 0x2e, 0x8a, 0xac, 0xec, 0xcc,
	0xac, 0xcc, 0x2f, 0x1f, 0x55, 0x25, 0xd0, 0xae, 0xdc, 0xc0, 0x0b, 0x6f, 0x16, 0x0e, 0x75, 0x3a,
	0x51, 0x1c, 0xd2, 0x10, 0xc1, 0x9a, 0xf3, 0x58, 0xbd, 0xa3, 0x71, 0x34, 0x17, 0x1f, 0x1e, 0xab,
	0xef, 0x96, 0x24, 0x5e, 0xc9, 0x45, 0x8b, 0x86, 0x51, 0xb8, 0xd6, 0xd2, 0xc7, 0x50, 0x1f, 0xbc,
	0x75, 0xe2, 0x84, 0x50, 0x74, 0x08, 0xb5, 0xb9, 0xe7, 0x92, 0x80, 0xb6, 0x95, 0x23, 0xe5, 0xb8,
	0x8a, 0xe5, 0x0a, 0x21, 0xa8, 0xcc, 0xc3, 0x20, 0x68, 0x97, 0x38, 0x97, 0xd3, 0x4c, 0x36, 0x21,
	0xf1, 0x1d, 0x89, 0xdb, 0x65, 0x21, 0x2b, 0x56, 0xfa, 0x3f, 0xca, 0xb0, 0xdb, 0xe7, 0x7e, 0x58,
	0xb1, 0x13, 0x24, 0xce, 0x9c, 0xba, 0x61, 0x80, 0xce, 0x01, 0x12, 0xea, 0x50, 0xe2, 0x93, 0x80,
	0x26, 0x6d, 0xe5, 0xa8, 0x7c, 0xac, 0x76, 0x9f, 0x76, 0x72, 0x11, 0xbc, 0xa7, 0xd2, 0x99, 0xa5,
	0xf2, 0x38, 0xa7, 0x8a, 0xba, 0xa0, 0x92, 0x3b, 0x12, 0x50, 0x9b, 0x86, 0xb7, 0x24, 0x68, 0x57,
	0x8e, 0x94, 0x63, 0xb5, 0xbb, 0xdb, 0x11, 0x01, 0x1a, 0xec, 0x8b, 0xc5, 0x3e, 0x60, 0x20, 0x19,
	0xfd, 0xf8, 0xaf, 0x25, 0x68, 0x66, 0xd6, 0x90, 0x09, 0x8d, 0xb9, 0x43, 0xc9, 0x4d, 0x18, 0xaf,
	0x78, 0x98, 0xad, 0xee, 0x4f, 0x1e, 0xe8, 0x48, 0x67, 0x20, 0xf5, 0x70, 0x66, 0x01, 0xfd, 0x18,
	0xea, 0x73, 0x81, 0x1e, 0x47, 0x47, 0xed, 0xee, 0xe5, 0x8d, 0x49, 0x60, 0x71, 0x2a, 0x83, 0x34,
	0x28, 0x27, 0xef, 0x3c, 0x0e, 0xd9, 0x16, 0x66, 0xa4, 0xfe, 0x47, 0x05, 0x1a, 0xa9, 0x5d, 0xb4,
	0x07, 0x3b, 0x7d, 0xd3, 0x7e, 0x3d, 0xc1, 0xc6, 0x60, 0x7a, 0x3e, 0x19, 0x7d, 0x65, 0x0c, 0xb5,
	0x47, 0x68, 0x0b, 0x1a, 0x7d, 0xd3, 0xee, 0x1b, 0xe7, 0xa3, 0x89, 0xa6, 0xa0, 0x6d, 0x68, 0xf6,
	0x4d, 0x7b, 0x30, 0x1d, 0x8f, 0x47, 0x96, 0x56, 0x42, 0x3b, 0xa0, 0xf6, 0x4d, 0x1b, 0x4f, 0x4d,
	0xb3, 0xdf, 0x1b, 0xbc, 0xd4, 0xca, 0xe8, 0x00, 0x76, 0xfb, 0xa6, 0x3d, 0x1c, 0x9b, 0xf6, 0xd0,
	0xb8, 0xc0, 0xc6, 0xa0, 0x67, 0x19, 0x43, 0xad, 0x82, 0x00, 0x6a, 0x8c, 0x3d, 0x34, 0xb5, 0xaa,
	0xa4, 0x67, 0x86, 0xa5, 0xd5, 0xa4, 0xb9, 0xd1, 0x64, 0x66, 0x60, 0x4b, 0xab, 0xcb, 0xe5, 0xeb,
	0x8b, 0x61, 0xcf, 0x32, 0xb4, 0x86, 0x5c, 0x0e, 0x0d, 0xd3, 0xb0, 0x0c, 0xad, 0xf9, 0xa2, 0xd2,
	0x28, 0x69, 0xe5, 0x17, 0x95, 0x46, 0x59, 0xab, 0xe8, 0x7f, 0x50, 0xe0, 0x60, 0x46, 0x63, 0xe2,
	0xf8, 0x2f, 0xc9, 0x0a, 0x3b, 0xc1, 0x0d, 0xc1, 0xe4, 0xdd, 0x92, 0x24, 0x14, 0x3d, 0x86, 0x46,
	0x14, 0x26, 0x2e, 0xc3, 0x8e, 0x03, 0xdc, 0xc4, 0xd9, 0x1a, 0x9d, 0x42, 0xf3, 0x96, 0xac, 0xec,
	0x98, 0xc9, 0x4b, 0xc0, 0x50, 0x27, 0x2b, 0xc8, 0xcc, 0x52, 0xe3, 0x56, 0x52, 0x79, 0x7c, 0xcb,
	0x1f, 0xc6, 0x57, 0xbf, 0x86, 0xc3, 0x4d, 0xa7, 0x92, 0x28, 0x0c, 0x12, 0x82, 0x4c, 0x40, 0x42,
	0xd1, 0xa6, 0xeb, 0xdc, 0x72, 0xff, 0xd4, 0xee, 0x27, 0xdf, 0x5a, 0x00, 0x78, 0xf7, 0x6a, 0x93,
	0xa5, 0x7f, 0x0d, 0x7b, 0x62, 0x1f, 0xcb, 0xb9, 0xf2, 0x48, 0xf2, 0x90, 0xd0, 0x0f, 0xa1, 0x46,
	0xb9, 0x70, 0xbb, 0x74, 0x54, 0x3e, 0x6e, 0x62, 0xb9, 0xfa, 0xd8, 0x08, 0x17, 0xb0, 0x5f, 0xdc,
	0xf9, 0xbf, 0x12, 0xdf, 0xcf, 0xa1, 0x82, 0x97, 0x1e, 0x41, 0xfb, 0x50, 0xf5, 0x1d, 0x3a, 0x7f,
	0x2b, 0xa3, 0x11, 0x0b, 0x16, 0xca, 0xb5, 0xeb, 0x51, 0x12, 0xf3, 0x14, 0x36, 0xb1, 0x5c, 0xe9,
	0x7f, 0x52, 0xa0, 0x76, 0xc6, 0x49, 0xf4, 0x19, 0x54, 0xe3, 0x25, 0x0b, 0x56, 0xf4, 0xba, 0x96,
	0xf7, 0x80, 0x59, 0xc6, 0xe2, 0x33, 0x1a, 0x41, 0xeb, 0xda, 0x25, 0xde, 0x82, 0xb7, 0xee, 0x38,
	0x5c, 0x88, 0xaa, 0x68, 0x75, 0x3f, 0xcd, 0x2b, 0x08, 0x9b, 0x9d, 0xb3, 0x82, 0x20, 0xde, 0x50,
	0xd4, 0x9f, 0x41, 0xab, 0x28, 0xc1, 0xda, 0xc9, 0xc0, 0xd8, 0x9e, 0x4e, 0xec, 0xf1, 0x68, 0x36,
	0xee, 0x59, 0x83, 0xe7, 0xda, 0x23, 0xde, 0x31, 0xc6, 0xcc, 0xb2, 0x8d, 0xb3, 0xb3, 0x29, 0xb6,
	0x34, 0x45, 0xff, 0x67, 0x09, 0xb6, 0x04, 0x28, 0xb3, 0x70, 0x19, 0xcf, 0x09, 0xcb, 0xe2, 0x2d,
	0x59, 0x25, 0x91, 0x33, 0x27, 0x69, 0x16, 0xd3, 0x35, 0x03, 0x24, 0x79, 0xeb, 0xc4, 0x0b, 0x19,
	0xb9, 0x58, 0xa0, 0x5f, 0x80, 0xca, 0xb3, 0x49, 0x6d, 0xba, 0x8a, 0x08, 0xcf, 0x63, 0xab, 0xbb,
	0xbf, 0x2e, 0x6c, 0x9e, 0x2b, 0x6a, 0xad, 0x22, 0x82, 0x81, 0x66, 0x74, 0xb1, 0x1b, 0x2a, 0x0f,
	0xe8, 0x86, 0x75, 0x0d, 0x55, 0x0b, 0x35, 0x74, 0x92, 0x25, 0xa4, 0x26, 0xad, 0xbc, 0x87, 0x5e,
	0x9a, 0x24, 0xd4, 0x81, 0x5a, 0x18, 0xd8, 0x8b, 0x85, 0xd7, 0xae, 0x73, 0x37, 0xbf, 0x97, 0x97,
	0x9d, 0x06, 0xc3, 0xa1, 0xd9, 0x13, 0x65, 0x51, 0x0d, 0x83, 0xe1, 0xc2, 0x43, 0x4f, 0xa0, 0x45,
	0xbe, 0xa6, 0x24, 0x0e, 0x1c, 0xcf, 0xf6, 0x57, 0x6c, 0x7a, 0x35, 0x78, 0xe8, 0xdb, 0x29, 0x77,
	0xcc, 0x98, 0xe8, 0x33, 0xd8, 0x49, 0x68, 0x18, 0xd9, 0xce, 0x35, 0x25, 0xb1, 0x3d, 0x0f, 0xa3,
	0x55, 0xbb, 0x79, 0xa4, 0x1c, 0x37, 0xf0, 0x36, 0x63, 0xf7, 0x18, 0x77, 0x10, 0x46, 0x2b, 0xfd,
	0x15, 0x34, 0x71, 0x78, 0x3f, 0x78, 0xcb, 0xe3, 0xd1, 0xa1, 0x76, 0x45, 0xae, 0xc3, 0x98, 0xc8,
	0x42, 0x05, 0x39, 0xc8, 0x71, 0x78, 0x8f, 0xe5, 0x17, 0x74, 0x04, 0x55, 0x6e, 0x53, 0x8e, 0x8b,
	0xbc, 0x88, 0xf8, 0xa0, 0x3b, 0xd0, 0xc0, 0xe1, 0x3d, 0x4f, 0x3b, 0xfa, 0x04, 0x04, 0xc0, 0x76,
	0xe0, 0xf8, 0x69, 0xf6, 0x9a, 0x9c, 0x33, 0x71, 0x7c, 0x82, 0x9e, 0x81, 0x1a, 0x87, 0xf7, 0xf6,
	0x9c, 0x6f, 0x2f, 0x3a, 0x51, 0xed, 0x1e, 0x14, 0x8a, 0x33, 0x75, 0x0e, 0x43, 0x9c, 0x92, 0x89,
	0xfe, 0x0a, 0x60, 0x5d, 0x5b, 0x1f, 0xda, 0xe4, 0x47, 0x2c, 0x1b, 0xc4, 0x5b, 0xa4, 0xf6, 0xb7,
	0xa4, 0xcb, 0xdc, 0x02, 0x96, 0xdf, 0x18, 0x10, 0x33, 0x56, 0x3c, 0xe7, 0xd4, 0x5d, 0x7c, 0x87,
	0x92, 0x43, 0x50, 0xb9, 0xa1, 0xee, 0x82, 0xd7, 0x5a, 0x13, 0x73, 0x5a, 0xff, 0x12, 0xaa, 0x97,
	0xdc, 0xdc, 0x33, 0x50, 0xb9, 0x94, 0xcd, 0xd8, 0x69, 0x0f, 0x16, 0xc2, 0xcc, 0xb6, 0xc6, 0x90,
	0xa4, 0x64, 0xa2, 0xf7, 0x60, 0xfb, 0xa5, 0xdc, 0x96, 0x0b, 0x7c, 0xbc, 0x5f, 0xfa, 0x9f, 0x4b,
	0x50, 0x7f, 0x11, 0x2e, 0x59, 0x61, 0xa0, 0x16, 0x94, 0xdc, 0x05, 0xd7, 0x2b, 0xe3, 0x92, 0xbb,
	0x40, 0xbf, 0x86, 0x96, 0xef, 0xde, 0xc4, 0x0e, 0x2b, 0x2f, 0xd1, 0x29, 0xa2, 0xd9, 0xbf, 0x9f,
	0xf7, 0x6c, 0x9c, 0x4a, 0xf0, 0x76, 0xd9, 0xf6, 0xf3, 0xcb, 0x5c, 0x03, 0x94, 0x0b, 0x0d, 0xf0,
	0x04, 0x5a, 0x5e, 0x38, 0x77, 0x3c, 0x3b, 0x1b, 0xbf, 0x15, 0x51, 0xa4, 0x9c, 0x7b, 0x91, 0xce,
	0xe0, 0x0d, 0x5c, 0xaa, 0x0f, 0xc4, 0x05, 0x7d, 0x01, 0x5b, 0x91, 0x13, 0x53, 0x77, 0xee, 0x46,
	0x0e, 0xbb, 0xc0, 0xd4, 0xb8, 0x62, 0xc1, 0xed, 0x02, 0x6e, 0xb8, 0x20, 0x8e, 0x3e, 0x07, 0x2d,
	0xe1, 0xa3, 0xc5, 0xbe, 0x0f, 0xe3, 0xdb, 0x6b, 0x2f, 0xbc, 0x4f, 0xda, 0x75, 0xee, 0xff, 0x8e,
	0xe0, 0xbf, 0x49, 0xd9, 0xfa, 0xbf, 0x4a, 0x50, 0xbb, 0x14, 0x55, 0x76, 0x02, 0x15, 0x8e, 0x91,
	0xb8, 0xa4, 0x1c, 0xe6, 0x37, 0x13, 0x12, 0x1c, 0x20, 0x2e, 0x83, 0x7e, 0x00, 0x4d, 0xea, 0xfa,
	0x24, 0xa1, 0x8e, 0x1f, 0x71, 0x50, 0xcb, 0x78, 0xcd, 0xf8, 0xa6, 0x5a, 0x61, 0x37, 0x11, 0x36,
	0x03, 0x04, 0x4c, 0x8c, 0x44, 0x3f, 0x85, 0x26, 0xeb, 0x0d, 0x7e, 0x71, 0x6a, 0x57, 0x79, 0xb3,
	0xed, 0x6f, 0x74, 0x06, 0xdf, 0x16, 0x37, 0xe2, 0xb4, 0xdb, 0x7e, 0x09, 0x2a, 0xaf, 0x66, 0xa9,
	0x24, 0x86, 0xcf, 0x61, 0x71, 0xf8, 0xa4, 0x5d, 0x83, 0x61, 0x3d, 0xaf, 0xd1, 0x53, 0xa8, 0xde,
	0x71, 0x97, 0xea, 0xf2, 0x02, 0x97, 0x0f, 0x8e, 0xc3, 0x2f, 0xbe, 0xb3, 0xd3, 0xf1, 0xb7, 0xa2,
	0x9a, 0xf8, 0xd8, 0xd9, 0x38, 0x1d, 0x65, 0xa1, 0xe1, 0x54, 0x86, 0x47, 0xe5, 0x7b, 0x7c, 0xf2,
	0xb0, 0xa8, 0x7c, 0x0f, 0x7d, 0x0a, 0x5b, 0xf3, 0x65, 0x1c, 0xf3, 0x2b, 0xa3, 0xeb, 0x93, 0xf6,
	0x3e, 0x07, 0x47, 0x95, 0x3c, 0xcb, 0xf5, 0x89, 0xfe, 0xfb, 0x12, 0xb4, 0x2e, 0xc5, 0xa1, 0x9a,
	0x1e, 0xe4, 0x5f, 0xc2, 0x1e, 0xb9, 0xbe, 0x26, 0x73, 0xea, 0xde, 0x11, 0x7b, 0xee, 0x78, 0x1e,
	0x89, 0x6d, 0x59, 0xca, 0x6a, 0x77, 0xa7, 0x23, 0x2e, 0xd7, 0x03, 0xce, 0x1f, 0x0d, 0xf1, 0x6e,
	0x26, 0x2b, 0x59, 0x0b, 0x64, 0xc0, 0x9e, 0xeb, 0xfb, 0x64, 0xe1, 0x3a, 0x34, 0x6f, 0x40, 0xcc,
	0xb0, 0x03, 0x39, 0x10, 0x2e, 0xad, 0x73, 0x87, 0x92, 0xb5, 0x99, 0x4c, 0x23, 0x33, 0xf3, 0x84,
	0xd5, 0x7b, 0x7c, 0x93, 0xdd, 0x0d, 0xb6, 0xa5, 0xa6, 0xc5, 0x99, 0x58, 0x7e, 0x2c, 0xdc, 0x3b,
	0x2a, 0x1b, 0xf7, 0x8e, 0xf5, 0xd9, 0x50, 0xfd, 0xd0, 0xd9, 0xa0, 0x7f, 0x01, 0x3b, 0x19, 0x10,
	0xf2, 0x5e, 0x71, 0x02, 0x35, 0x9e, 0xdc, 0x74, 0x8a, 0xa0, 0xf7, 0xeb, 0x10, 0x4b, 0x09, 0xfd,
	0x77, 0x25, 0x40, 0xa9, 0x7e, 0x78, 0x9f, 0xfc, 0x8f, 0x82, 0xb9, 0x0f, 0x55, 0xce, 0x97, 0x48,
	0x8a, 0x05, 0xc3, 0xc1, 0x73, 0x12, 0x1a, 0xdd, 0x66, 0x30, 0x0a, 0xe5, 0x57, 0xec, 0x17, 0x93,
	0x64, 0xe9, 0x51, 0x2c, 0x25, 0xf4, 0xbf, 0x28, 0xb0, 0x57, 0xc0, 0x41, 0x62, 0xb9, 0x3e, 0x18,
	0x94, 0xff, 0x7c, 0x30, 0xa0, 0x63, 0x68, 0x44, 0xb7, 0xdf, 0x72, 0x80, 0x64, 0x5f, 0xbf, 0xb1,
	0xaf, 0x7f, 0x08, 0x95, 0x98, 0xcd, 0x97, 0x0a, 0xd7, 0xcc, 0x9f, 0x96, 0x9c, 0xcf, 0x8e, 0xdc,
	0x42, 0x1c, 0x85, 0x23, 0x57, 0xfa, 0xff, 0x77, 0x05, 0x0e, 0xd6, 0x75, 0xb0, 0xf4, 0xe8, 0xff,
	0x55, 0x2a, 0xf5, 0x18, 0x0e, 0x37, 0xa3, 0xfb, 0xa8, 0x04, 0x7d, 0x07, 0xd8, 0x4f, 0x7e, 0x05,
	0x6a, 0xee, 0x6e, 0xc5, 0x9e, 0x60, 0xa3, 0xf3, 0xc9, 0x14, 0x1b, 0xda, 0x23, 0xd4, 0x80, 0xca,
	0xcc, 0x9a, 0x5e, 0x68, 0x0a, 0xa3, 0x8c, 0xdf, 0x18, 0x03, 0xf1, 0xac, 0x63, 0x94, 0x2d, 0x85,
	0xca, 0x27, 0x7f, 0x53, 0x00, 0xd6, 0x53, 0x1f, 0xa9, 0x50, 0x7f, 0x3d, 0x79, 0x39, 0x99, 0xbe,
	0x99, 0x08, 0x03, 0xe7, 0xd6, 0x68, 0xa8, 0x29, 0xa8, 0x09, 0x55, 0xf1, 0x4e, 0x2c, 0xb1, 0x1d,
	0xe4, 0x23, 0xb1, 0xcc, 0x5e, 0x90, 0xd9, 0x0b, 0xb1, 0x82, 0xea, 0x50, 0xce, 0xde, 0x81, 0xf2,
	0xe1, 0x57, 0x63, 0x06, 0xb1, 0x71, 0x61, 0xf6, 0x06, 0x86, 0x56, 0x67, 0x1f, 0xb2, 0x27, 0x20,
	0x40, 0x2d, 0x7d, 0xff, 0x31, 0x4d, 0xf6, 0x6a, 0x04, 0xb6, 0xcf, 0xd4, 0x7a, 0x6e, 0x60, 0x4d,
	0x65, 0x3c, 0x3c, 0x7d, 0xa3, 0x6d, 0x31, 0xde, 0xd9, 0xc8, 0x30, 0x87, 0xda, 0x36, 0x7b, 0x36,
	0x3e, 0x37, 0x7a, 0xd8, 0xea, 0x1b, 0x3d, 0x4b, 0x6b, 0xb1, 0x2f, 0x97, 0xdc, 0xc1, 0x1d, 0xb6,
	0xcd, 0x8b, 0xe9, 0x6b, 0x3c, 0xe9, 0x99, 0x9a, 0x76, 0xf2, 0x14, 0xb6, 0x0b, 0x87, 0x3d, 0xdb,
	0xcb, 0xea, 0xf5, 0x4d, 0x63, 0xa6, 0x3d, 0x62, 0xf4, 0xec, 0x79, 0x0f, 0x0f, 0x67, 0x9a, 0xd2,
	0xff, 0xfc, 0xab, 0xa7, 0x77, 0x2e, 0x25, 0x49, 0xd2, 0x71, 0xc3, 0x53, 0x41, 0x9d, 0xde, 0x84,
	0xa7, 0x77, 0xf4, 0x94, 0xff, 0x85, 0x71, 0xba, 0x9e, 0x48, 0x57, 0x35, 0xce, 0xf9, 0xd9, 0xbf,
	0x03, 0x00, 0x00, 0xff, 0xff, 0x78, 0x33, 0x5b, 0xba, 0x1e, 0x11, 0x00, 0x00,
}
