// Code generated by protoc-gen-go. DO NOT EDIT.
// source: topodata.proto

package topodata

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	vttime "vitess.io/vitess/go/vt/proto/vttime"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// KeyspaceType describes the type of the keyspace
type KeyspaceType int32

const (
	// NORMAL is the default value
	KeyspaceType_NORMAL KeyspaceType = 0
	// SNAPSHOT is when we are creating a snapshot keyspace
	KeyspaceType_SNAPSHOT KeyspaceType = 1
)

var KeyspaceType_name = map[int32]string{
	0: "NORMAL",
	1: "SNAPSHOT",
}

var KeyspaceType_value = map[string]int32{
	"NORMAL":   0,
	"SNAPSHOT": 1,
}

func (x KeyspaceType) String() string {
	return proto.EnumName(KeyspaceType_name, int32(x))
}

func (KeyspaceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{0}
}

// KeyspaceIdType describes the type of the sharding key for a
// range-based sharded keyspace.
type KeyspaceIdType int32

const (
	// UNSET is the default value, when range-based sharding is not used.
	KeyspaceIdType_UNSET KeyspaceIdType = 0
	// UINT64 is when uint64 value is used.
	// This is represented as 'unsigned bigint' in mysql
	KeyspaceIdType_UINT64 KeyspaceIdType = 1
	// BYTES is when an array of bytes is used.
	// This is represented as 'varbinary' in mysql
	KeyspaceIdType_BYTES KeyspaceIdType = 2
)

var KeyspaceIdType_name = map[int32]string{
	0: "UNSET",
	1: "UINT64",
	2: "BYTES",
}

var KeyspaceIdType_value = map[string]int32{
	"UNSET":  0,
	"UINT64": 1,
	"BYTES":  2,
}

func (x KeyspaceIdType) String() string {
	return proto.EnumName(KeyspaceIdType_name, int32(x))
}

func (KeyspaceIdType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{1}
}

// TabletType represents the type of a given tablet.
type TabletType int32

const (
	// UNKNOWN is not a valid value.
	TabletType_UNKNOWN TabletType = 0
	// MASTER is the master server for the shard. Only MASTER allows DMLs.
	TabletType_MASTER TabletType = 1
	// REPLICA is a slave type. It is used to serve live traffic.
	// A REPLICA can be promoted to MASTER. A demoted MASTER will go to REPLICA.
	TabletType_REPLICA TabletType = 2
	// RDONLY (old name) / BATCH (new name) is used to serve traffic for
	// long-running jobs. It is a separate type from REPLICA so
	// long-running queries don't affect web-like traffic.
	TabletType_RDONLY TabletType = 3
	TabletType_BATCH  TabletType = 3
	// SPARE is a type of servers that cannot serve queries, but is available
	// in case an extra server is needed.
	TabletType_SPARE TabletType = 4
	// EXPERIMENTAL is like SPARE, except it can serve queries. This
	// type can be used for usages not planned by Vitess, like online
	// export to another storage engine.
	TabletType_EXPERIMENTAL TabletType = 5
	// BACKUP is the type a server goes to when taking a backup. No queries
	// can be served in BACKUP mode.
	TabletType_BACKUP TabletType = 6
	// RESTORE is the type a server uses when restoring a backup, at
	// startup time.  No queries can be served in RESTORE mode.
	TabletType_RESTORE TabletType = 7
	// DRAINED is the type a server goes into when used by Vitess tools
	// to perform an offline action. It is a serving type (as
	// the tools processes may need to run queries), but it's not used
	// to route queries from Vitess users. In this state,
	// this tablet is dedicated to the process that uses it.
	TabletType_DRAINED TabletType = 8
)

var TabletType_name = map[int32]string{
	0: "UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
	3: "RDONLY",
	// Duplicate value: 3: "BATCH",
	4: "SPARE",
	5: "EXPERIMENTAL",
	6: "BACKUP",
	7: "RESTORE",
	8: "DRAINED",
}

var TabletType_value = map[string]int32{
	"UNKNOWN":      0,
	"MASTER":       1,
	"REPLICA":      2,
	"RDONLY":       3,
	"BATCH":        3,
	"SPARE":        4,
	"EXPERIMENTAL": 5,
	"BACKUP":       6,
	"RESTORE":      7,
	"DRAINED":      8,
}

func (x TabletType) String() string {
	return proto.EnumName(TabletType_name, int32(x))
}

func (TabletType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{2}
}

// KeyRange describes a range of sharding keys, when range-based
// sharding is used.
type KeyRange struct {
	Start                []byte   `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End                  []byte   `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyRange) Reset()         { *m = KeyRange{} }
func (m *KeyRange) String() string { return proto.CompactTextString(m) }
func (*KeyRange) ProtoMessage()    {}
func (*KeyRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{0}
}

func (m *KeyRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyRange.Unmarshal(m, b)
}
func (m *KeyRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyRange.Marshal(b, m, deterministic)
}
func (m *KeyRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyRange.Merge(m, src)
}
func (m *KeyRange) XXX_Size() int {
	return xxx_messageInfo_KeyRange.Size(m)
}
func (m *KeyRange) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyRange.DiscardUnknown(m)
}

var xxx_messageInfo_KeyRange proto.InternalMessageInfo

func (m *KeyRange) GetStart() []byte {
	if m != nil {
		return m.Start
	}
	return nil
}

func (m *KeyRange) GetEnd() []byte {
	if m != nil {
		return m.End
	}
	return nil
}

// TabletAlias is a globally unique tablet identifier.
type TabletAlias struct {
	// cell is the cell (or datacenter) the tablet is in
	Cell string `protobuf:"bytes,1,opt,name=cell,proto3" json:"cell,omitempty"`
	// uid is a unique id for this tablet within the shard
	// (this is the MySQL server id as well).
	Uid                  uint32   `protobuf:"varint,2,opt,name=uid,proto3" json:"uid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TabletAlias) Reset()         { *m = TabletAlias{} }
func (m *TabletAlias) String() string { return proto.CompactTextString(m) }
func (*TabletAlias) ProtoMessage()    {}
func (*TabletAlias) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{1}
}

func (m *TabletAlias) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TabletAlias.Unmarshal(m, b)
}
func (m *TabletAlias) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TabletAlias.Marshal(b, m, deterministic)
}
func (m *TabletAlias) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TabletAlias.Merge(m, src)
}
func (m *TabletAlias) XXX_Size() int {
	return xxx_messageInfo_TabletAlias.Size(m)
}
func (m *TabletAlias) XXX_DiscardUnknown() {
	xxx_messageInfo_TabletAlias.DiscardUnknown(m)
}

var xxx_messageInfo_TabletAlias proto.InternalMessageInfo

func (m *TabletAlias) GetCell() string {
	if m != nil {
		return m.Cell
	}
	return ""
}

func (m *TabletAlias) GetUid() uint32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

// Tablet represents information about a running instance of vttablet.
type Tablet struct {
	// alias is the unique name of the tablet.
	Alias *TabletAlias `protobuf:"bytes,1,opt,name=alias,proto3" json:"alias,omitempty"`
	// Fully qualified domain name of the host.
	Hostname string `protobuf:"bytes,2,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Map of named ports. Normally this should include vt and grpc.
	// Going forward, the mysql port will be stored in mysql_port
	// instead of here.
	// For accessing mysql port, use topoproto.MysqlPort to fetch, and
	// topoproto.SetMysqlPort to set. These wrappers will ensure
	// legacy behavior is supported.
	PortMap map[string]int32 `protobuf:"bytes,4,rep,name=port_map,json=portMap,proto3" json:"port_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Keyspace name.
	Keyspace string `protobuf:"bytes,5,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// Shard name. If range based sharding is used, it should match
	// key_range.
	Shard string `protobuf:"bytes,6,opt,name=shard,proto3" json:"shard,omitempty"`
	// If range based sharding is used, range for the tablet's shard.
	KeyRange *KeyRange `protobuf:"bytes,7,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// type is the current type of the tablet.
	Type TabletType `protobuf:"varint,8,opt,name=type,proto3,enum=topodata.TabletType" json:"type,omitempty"`
	// It this is set, it is used as the database name instead of the
	// normal "vt_" + keyspace.
	DbNameOverride string `protobuf:"bytes,9,opt,name=db_name_override,json=dbNameOverride,proto3" json:"db_name_override,omitempty"`
	// tablet tags
	Tags map[string]string `protobuf:"bytes,10,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// MySQL hostname.
	MysqlHostname string `protobuf:"bytes,12,opt,name=mysql_hostname,json=mysqlHostname,proto3" json:"mysql_hostname,omitempty"`
	// MySQL port. Use topoproto.MysqlPort and topoproto.SetMysqlPort
	// to access this variable. The functions provide support
	// for legacy behavior.
	MysqlPort            int32    `protobuf:"varint,13,opt,name=mysql_port,json=mysqlPort,proto3" json:"mysql_port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tablet) Reset()         { *m = Tablet{} }
func (m *Tablet) String() string { return proto.CompactTextString(m) }
func (*Tablet) ProtoMessage()    {}
func (*Tablet) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{2}
}

func (m *Tablet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tablet.Unmarshal(m, b)
}
func (m *Tablet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tablet.Marshal(b, m, deterministic)
}
func (m *Tablet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tablet.Merge(m, src)
}
func (m *Tablet) XXX_Size() int {
	return xxx_messageInfo_Tablet.Size(m)
}
func (m *Tablet) XXX_DiscardUnknown() {
	xxx_messageInfo_Tablet.DiscardUnknown(m)
}

var xxx_messageInfo_Tablet proto.InternalMessageInfo

func (m *Tablet) GetAlias() *TabletAlias {
	if m != nil {
		return m.Alias
	}
	return nil
}

func (m *Tablet) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *Tablet) GetPortMap() map[string]int32 {
	if m != nil {
		return m.PortMap
	}
	return nil
}

func (m *Tablet) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *Tablet) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *Tablet) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Tablet) GetType() TabletType {
	if m != nil {
		return m.Type
	}
	return TabletType_UNKNOWN
}

func (m *Tablet) GetDbNameOverride() string {
	if m != nil {
		return m.DbNameOverride
	}
	return ""
}

func (m *Tablet) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Tablet) GetMysqlHostname() string {
	if m != nil {
		return m.MysqlHostname
	}
	return ""
}

func (m *Tablet) GetMysqlPort() int32 {
	if m != nil {
		return m.MysqlPort
	}
	return 0
}

// A Shard contains data about a subset of the data whithin a keyspace.
type Shard struct {
	// No lock is necessary to update this field, when for instance
	// TabletExternallyReparented updates this. However, we lock the
	// shard for reparenting operations (InitShardMaster,
	// PlannedReparentShard,EmergencyReparentShard), to guarantee
	// exclusive operation.
	MasterAlias *TabletAlias `protobuf:"bytes,1,opt,name=master_alias,json=masterAlias,proto3" json:"master_alias,omitempty"`
	// key_range is the KeyRange for this shard. It can be unset if:
	// - we are not using range-based sharding in this shard.
	// - the shard covers the entire keyrange.
	// This must match the shard name based on our other conventions, but
	// helpful to have it decomposed here.
	// Once set at creation time, it is never changed.
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// served_types has at most one entry per TabletType
	// This field is in the process of being deprecated in favor of
	// is_master_serving. Keeping for backwards compatibility purposes.
	ServedTypes []*Shard_ServedType `protobuf:"bytes,3,rep,name=served_types,json=servedTypes,proto3" json:"served_types,omitempty"`
	// SourceShards is the list of shards we're replicating from,
	// using filtered replication.
	// The keyspace lock is always taken when changing this.
	SourceShards []*Shard_SourceShard `protobuf:"bytes,4,rep,name=source_shards,json=sourceShards,proto3" json:"source_shards,omitempty"`
	// tablet_controls has at most one entry per TabletType.
	// The keyspace lock is always taken when changing this.
	TabletControls []*Shard_TabletControl `protobuf:"bytes,6,rep,name=tablet_controls,json=tabletControls,proto3" json:"tablet_controls,omitempty"`
	// is_master_serving sets whether this shard master is serving traffic or not.
	// The keyspace lock is always taken when changing this.
	IsMasterServing      bool     `protobuf:"varint,7,opt,name=is_master_serving,json=isMasterServing,proto3" json:"is_master_serving,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard) Reset()         { *m = Shard{} }
func (m *Shard) String() string { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()    {}
func (*Shard) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3}
}

func (m *Shard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard.Unmarshal(m, b)
}
func (m *Shard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard.Marshal(b, m, deterministic)
}
func (m *Shard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard.Merge(m, src)
}
func (m *Shard) XXX_Size() int {
	return xxx_messageInfo_Shard.Size(m)
}
func (m *Shard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard proto.InternalMessageInfo

func (m *Shard) GetMasterAlias() *TabletAlias {
	if m != nil {
		return m.MasterAlias
	}
	return nil
}

func (m *Shard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Shard) GetServedTypes() []*Shard_ServedType {
	if m != nil {
		return m.ServedTypes
	}
	return nil
}

func (m *Shard) GetSourceShards() []*Shard_SourceShard {
	if m != nil {
		return m.SourceShards
	}
	return nil
}

func (m *Shard) GetTabletControls() []*Shard_TabletControl {
	if m != nil {
		return m.TabletControls
	}
	return nil
}

func (m *Shard) GetIsMasterServing() bool {
	if m != nil {
		return m.IsMasterServing
	}
	return false
}

// ServedType is an entry in the served_types
type Shard_ServedType struct {
	TabletType           TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells                []string   `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Shard_ServedType) Reset()         { *m = Shard_ServedType{} }
func (m *Shard_ServedType) String() string { return proto.CompactTextString(m) }
func (*Shard_ServedType) ProtoMessage()    {}
func (*Shard_ServedType) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3, 0}
}

func (m *Shard_ServedType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard_ServedType.Unmarshal(m, b)
}
func (m *Shard_ServedType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard_ServedType.Marshal(b, m, deterministic)
}
func (m *Shard_ServedType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard_ServedType.Merge(m, src)
}
func (m *Shard_ServedType) XXX_Size() int {
	return xxx_messageInfo_Shard_ServedType.Size(m)
}
func (m *Shard_ServedType) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard_ServedType.DiscardUnknown(m)
}

var xxx_messageInfo_Shard_ServedType proto.InternalMessageInfo

func (m *Shard_ServedType) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *Shard_ServedType) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

// SourceShard represents a data source for filtered replication
// across shards. When this is used in a destination shard, the master
// of that shard will run filtered replication.
type Shard_SourceShard struct {
	// Uid is the unique ID for this SourceShard object.
	Uid uint32 `protobuf:"varint,1,opt,name=uid,proto3" json:"uid,omitempty"`
	// the source keyspace
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,3,opt,name=shard,proto3" json:"shard,omitempty"`
	// the source shard keyrange
	KeyRange *KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// the source table list to replicate
	Tables               []string `protobuf:"bytes,5,rep,name=tables,proto3" json:"tables,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard_SourceShard) Reset()         { *m = Shard_SourceShard{} }
func (m *Shard_SourceShard) String() string { return proto.CompactTextString(m) }
func (*Shard_SourceShard) ProtoMessage()    {}
func (*Shard_SourceShard) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3, 1}
}

func (m *Shard_SourceShard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard_SourceShard.Unmarshal(m, b)
}
func (m *Shard_SourceShard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard_SourceShard.Marshal(b, m, deterministic)
}
func (m *Shard_SourceShard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard_SourceShard.Merge(m, src)
}
func (m *Shard_SourceShard) XXX_Size() int {
	return xxx_messageInfo_Shard_SourceShard.Size(m)
}
func (m *Shard_SourceShard) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard_SourceShard.DiscardUnknown(m)
}

var xxx_messageInfo_Shard_SourceShard proto.InternalMessageInfo

func (m *Shard_SourceShard) GetUid() uint32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *Shard_SourceShard) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *Shard_SourceShard) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *Shard_SourceShard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Shard_SourceShard) GetTables() []string {
	if m != nil {
		return m.Tables
	}
	return nil
}

// TabletControl controls tablet's behavior
type Shard_TabletControl struct {
	// which tablet type is affected
	TabletType        TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells             []string   `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	BlacklistedTables []string   `protobuf:"bytes,4,rep,name=blacklisted_tables,json=blacklistedTables,proto3" json:"blacklisted_tables,omitempty"`
	// frozen is set if we've started failing over traffic for
	// the master. If set, this record should not be removed.
	Frozen               bool     `protobuf:"varint,5,opt,name=frozen,proto3" json:"frozen,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shard_TabletControl) Reset()         { *m = Shard_TabletControl{} }
func (m *Shard_TabletControl) String() string { return proto.CompactTextString(m) }
func (*Shard_TabletControl) ProtoMessage()    {}
func (*Shard_TabletControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{3, 2}
}

func (m *Shard_TabletControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shard_TabletControl.Unmarshal(m, b)
}
func (m *Shard_TabletControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shard_TabletControl.Marshal(b, m, deterministic)
}
func (m *Shard_TabletControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shard_TabletControl.Merge(m, src)
}
func (m *Shard_TabletControl) XXX_Size() int {
	return xxx_messageInfo_Shard_TabletControl.Size(m)
}
func (m *Shard_TabletControl) XXX_DiscardUnknown() {
	xxx_messageInfo_Shard_TabletControl.DiscardUnknown(m)
}

var xxx_messageInfo_Shard_TabletControl proto.InternalMessageInfo

func (m *Shard_TabletControl) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *Shard_TabletControl) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

func (m *Shard_TabletControl) GetBlacklistedTables() []string {
	if m != nil {
		return m.BlacklistedTables
	}
	return nil
}

func (m *Shard_TabletControl) GetFrozen() bool {
	if m != nil {
		return m.Frozen
	}
	return false
}

// A Keyspace contains data about a keyspace.
type Keyspace struct {
	// name of the column used for sharding
	// empty if the keyspace is not sharded
	ShardingColumnName string `protobuf:"bytes,1,opt,name=sharding_column_name,json=shardingColumnName,proto3" json:"sharding_column_name,omitempty"`
	// type of the column used for sharding
	// UNSET if the keyspace is not sharded
	ShardingColumnType KeyspaceIdType `protobuf:"varint,2,opt,name=sharding_column_type,json=shardingColumnType,proto3,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	// ServedFrom will redirect the appropriate traffic to
	// another keyspace.
	ServedFroms []*Keyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_froms,json=servedFroms,proto3" json:"served_froms,omitempty"`
	// keyspace_type will determine how this keyspace is treated by
	// vtgate / vschema. Normal keyspaces are routable by
	// any query. Snapshot keyspaces are only accessible
	// by explicit addresssing or by calling "use keyspace" first
	KeyspaceType KeyspaceType `protobuf:"varint,5,opt,name=keyspace_type,json=keyspaceType,proto3,enum=topodata.KeyspaceType" json:"keyspace_type,omitempty"`
	// base_keyspace is the base keyspace from which a snapshot
	// keyspace is created. empty for normal keyspaces
	BaseKeyspace string `protobuf:"bytes,6,opt,name=base_keyspace,json=baseKeyspace,proto3" json:"base_keyspace,omitempty"`
	// snapshot_time (in UTC) is a property of snapshot
	// keyspaces which tells us what point in time
	// the snapshot is of
	SnapshotTime         *vttime.Time `protobuf:"bytes,7,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Keyspace) Reset()         { *m = Keyspace{} }
func (m *Keyspace) String() string { return proto.CompactTextString(m) }
func (*Keyspace) ProtoMessage()    {}
func (*Keyspace) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{4}
}

func (m *Keyspace) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Keyspace.Unmarshal(m, b)
}
func (m *Keyspace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Keyspace.Marshal(b, m, deterministic)
}
func (m *Keyspace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Keyspace.Merge(m, src)
}
func (m *Keyspace) XXX_Size() int {
	return xxx_messageInfo_Keyspace.Size(m)
}
func (m *Keyspace) XXX_DiscardUnknown() {
	xxx_messageInfo_Keyspace.DiscardUnknown(m)
}

var xxx_messageInfo_Keyspace proto.InternalMessageInfo

func (m *Keyspace) GetShardingColumnName() string {
	if m != nil {
		return m.ShardingColumnName
	}
	return ""
}

func (m *Keyspace) GetShardingColumnType() KeyspaceIdType {
	if m != nil {
		return m.ShardingColumnType
	}
	return KeyspaceIdType_UNSET
}

func (m *Keyspace) GetServedFroms() []*Keyspace_ServedFrom {
	if m != nil {
		return m.ServedFroms
	}
	return nil
}

func (m *Keyspace) GetKeyspaceType() KeyspaceType {
	if m != nil {
		return m.KeyspaceType
	}
	return KeyspaceType_NORMAL
}

func (m *Keyspace) GetBaseKeyspace() string {
	if m != nil {
		return m.BaseKeyspace
	}
	return ""
}

func (m *Keyspace) GetSnapshotTime() *vttime.Time {
	if m != nil {
		return m.SnapshotTime
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type Keyspace_ServedFrom struct {
	// the tablet type (key for the map)
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the cells to limit this to
	Cells []string `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	// the keyspace name that's serving it
	Keyspace             string   `protobuf:"bytes,3,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Keyspace_ServedFrom) Reset()         { *m = Keyspace_ServedFrom{} }
func (m *Keyspace_ServedFrom) String() string { return proto.CompactTextString(m) }
func (*Keyspace_ServedFrom) ProtoMessage()    {}
func (*Keyspace_ServedFrom) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{4, 0}
}

func (m *Keyspace_ServedFrom) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Keyspace_ServedFrom.Unmarshal(m, b)
}
func (m *Keyspace_ServedFrom) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Keyspace_ServedFrom.Marshal(b, m, deterministic)
}
func (m *Keyspace_ServedFrom) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Keyspace_ServedFrom.Merge(m, src)
}
func (m *Keyspace_ServedFrom) XXX_Size() int {
	return xxx_messageInfo_Keyspace_ServedFrom.Size(m)
}
func (m *Keyspace_ServedFrom) XXX_DiscardUnknown() {
	xxx_messageInfo_Keyspace_ServedFrom.DiscardUnknown(m)
}

var xxx_messageInfo_Keyspace_ServedFrom proto.InternalMessageInfo

func (m *Keyspace_ServedFrom) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *Keyspace_ServedFrom) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

func (m *Keyspace_ServedFrom) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

// ShardReplication describes the MySQL replication relationships
// whithin a cell.
type ShardReplication struct {
	// Note there can be only one Node in this array
	// for a given tablet.
	Nodes                []*ShardReplication_Node `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ShardReplication) Reset()         { *m = ShardReplication{} }
func (m *ShardReplication) String() string { return proto.CompactTextString(m) }
func (*ShardReplication) ProtoMessage()    {}
func (*ShardReplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{5}
}

func (m *ShardReplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardReplication.Unmarshal(m, b)
}
func (m *ShardReplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardReplication.Marshal(b, m, deterministic)
}
func (m *ShardReplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardReplication.Merge(m, src)
}
func (m *ShardReplication) XXX_Size() int {
	return xxx_messageInfo_ShardReplication.Size(m)
}
func (m *ShardReplication) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardReplication.DiscardUnknown(m)
}

var xxx_messageInfo_ShardReplication proto.InternalMessageInfo

func (m *ShardReplication) GetNodes() []*ShardReplication_Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// Node describes a tablet instance within the cell
type ShardReplication_Node struct {
	TabletAlias          *TabletAlias `protobuf:"bytes,1,opt,name=tablet_alias,json=tabletAlias,proto3" json:"tablet_alias,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ShardReplication_Node) Reset()         { *m = ShardReplication_Node{} }
func (m *ShardReplication_Node) String() string { return proto.CompactTextString(m) }
func (*ShardReplication_Node) ProtoMessage()    {}
func (*ShardReplication_Node) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{5, 0}
}

func (m *ShardReplication_Node) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardReplication_Node.Unmarshal(m, b)
}
func (m *ShardReplication_Node) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardReplication_Node.Marshal(b, m, deterministic)
}
func (m *ShardReplication_Node) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardReplication_Node.Merge(m, src)
}
func (m *ShardReplication_Node) XXX_Size() int {
	return xxx_messageInfo_ShardReplication_Node.Size(m)
}
func (m *ShardReplication_Node) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardReplication_Node.DiscardUnknown(m)
}

var xxx_messageInfo_ShardReplication_Node proto.InternalMessageInfo

func (m *ShardReplication_Node) GetTabletAlias() *TabletAlias {
	if m != nil {
		return m.TabletAlias
	}
	return nil
}

// ShardReference is used as a pointer from a SrvKeyspace to a Shard
type ShardReference struct {
	// Copied from Shard.
	Name                 string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	KeyRange             *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ShardReference) Reset()         { *m = ShardReference{} }
func (m *ShardReference) String() string { return proto.CompactTextString(m) }
func (*ShardReference) ProtoMessage()    {}
func (*ShardReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{6}
}

func (m *ShardReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardReference.Unmarshal(m, b)
}
func (m *ShardReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardReference.Marshal(b, m, deterministic)
}
func (m *ShardReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardReference.Merge(m, src)
}
func (m *ShardReference) XXX_Size() int {
	return xxx_messageInfo_ShardReference.Size(m)
}
func (m *ShardReference) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardReference.DiscardUnknown(m)
}

var xxx_messageInfo_ShardReference proto.InternalMessageInfo

func (m *ShardReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ShardReference) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// ShardTabletControl is used as a pointer from a SrvKeyspace to a Shard
type ShardTabletControl struct {
	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange,proto3" json:"key_range,omitempty"`
	// Disable query serving in this shard
	QueryServiceDisabled bool     `protobuf:"varint,3,opt,name=query_service_disabled,json=queryServiceDisabled,proto3" json:"query_service_disabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShardTabletControl) Reset()         { *m = ShardTabletControl{} }
func (m *ShardTabletControl) String() string { return proto.CompactTextString(m) }
func (*ShardTabletControl) ProtoMessage()    {}
func (*ShardTabletControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{7}
}

func (m *ShardTabletControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShardTabletControl.Unmarshal(m, b)
}
func (m *ShardTabletControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShardTabletControl.Marshal(b, m, deterministic)
}
func (m *ShardTabletControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardTabletControl.Merge(m, src)
}
func (m *ShardTabletControl) XXX_Size() int {
	return xxx_messageInfo_ShardTabletControl.Size(m)
}
func (m *ShardTabletControl) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardTabletControl.DiscardUnknown(m)
}

var xxx_messageInfo_ShardTabletControl proto.InternalMessageInfo

func (m *ShardTabletControl) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ShardTabletControl) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *ShardTabletControl) GetQueryServiceDisabled() bool {
	if m != nil {
		return m.QueryServiceDisabled
	}
	return false
}

// SrvKeyspace is a rollup node for the keyspace itself.
type SrvKeyspace struct {
	// The partitions this keyspace is serving, per tablet type.
	Partitions []*SrvKeyspace_KeyspacePartition `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions,omitempty"`
	// copied from Keyspace
	ShardingColumnName   string                    `protobuf:"bytes,2,opt,name=sharding_column_name,json=shardingColumnName,proto3" json:"sharding_column_name,omitempty"`
	ShardingColumnType   KeyspaceIdType            `protobuf:"varint,3,opt,name=sharding_column_type,json=shardingColumnType,proto3,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	ServedFrom           []*SrvKeyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_from,json=servedFrom,proto3" json:"served_from,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SrvKeyspace) Reset()         { *m = SrvKeyspace{} }
func (m *SrvKeyspace) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace) ProtoMessage()    {}
func (*SrvKeyspace) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{8}
}

func (m *SrvKeyspace) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SrvKeyspace.Unmarshal(m, b)
}
func (m *SrvKeyspace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SrvKeyspace.Marshal(b, m, deterministic)
}
func (m *SrvKeyspace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SrvKeyspace.Merge(m, src)
}
func (m *SrvKeyspace) XXX_Size() int {
	return xxx_messageInfo_SrvKeyspace.Size(m)
}
func (m *SrvKeyspace) XXX_DiscardUnknown() {
	xxx_messageInfo_SrvKeyspace.DiscardUnknown(m)
}

var xxx_messageInfo_SrvKeyspace proto.InternalMessageInfo

func (m *SrvKeyspace) GetPartitions() []*SrvKeyspace_KeyspacePartition {
	if m != nil {
		return m.Partitions
	}
	return nil
}

func (m *SrvKeyspace) GetShardingColumnName() string {
	if m != nil {
		return m.ShardingColumnName
	}
	return ""
}

func (m *SrvKeyspace) GetShardingColumnType() KeyspaceIdType {
	if m != nil {
		return m.ShardingColumnType
	}
	return KeyspaceIdType_UNSET
}

func (m *SrvKeyspace) GetServedFrom() []*SrvKeyspace_ServedFrom {
	if m != nil {
		return m.ServedFrom
	}
	return nil
}

type SrvKeyspace_KeyspacePartition struct {
	// The type this partition applies to.
	ServedType TabletType `protobuf:"varint,1,opt,name=served_type,json=servedType,proto3,enum=topodata.TabletType" json:"served_type,omitempty"`
	// List of non-overlapping continuous shards sorted by range.
	ShardReferences []*ShardReference `protobuf:"bytes,2,rep,name=shard_references,json=shardReferences,proto3" json:"shard_references,omitempty"`
	// List of shard tablet controls
	ShardTabletControls  []*ShardTabletControl `protobuf:"bytes,3,rep,name=shard_tablet_controls,json=shardTabletControls,proto3" json:"shard_tablet_controls,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SrvKeyspace_KeyspacePartition) Reset()         { *m = SrvKeyspace_KeyspacePartition{} }
func (m *SrvKeyspace_KeyspacePartition) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace_KeyspacePartition) ProtoMessage()    {}
func (*SrvKeyspace_KeyspacePartition) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{8, 0}
}

func (m *SrvKeyspace_KeyspacePartition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SrvKeyspace_KeyspacePartition.Unmarshal(m, b)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SrvKeyspace_KeyspacePartition.Marshal(b, m, deterministic)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SrvKeyspace_KeyspacePartition.Merge(m, src)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_Size() int {
	return xxx_messageInfo_SrvKeyspace_KeyspacePartition.Size(m)
}
func (m *SrvKeyspace_KeyspacePartition) XXX_DiscardUnknown() {
	xxx_messageInfo_SrvKeyspace_KeyspacePartition.DiscardUnknown(m)
}

var xxx_messageInfo_SrvKeyspace_KeyspacePartition proto.InternalMessageInfo

func (m *SrvKeyspace_KeyspacePartition) GetServedType() TabletType {
	if m != nil {
		return m.ServedType
	}
	return TabletType_UNKNOWN
}

func (m *SrvKeyspace_KeyspacePartition) GetShardReferences() []*ShardReference {
	if m != nil {
		return m.ShardReferences
	}
	return nil
}

func (m *SrvKeyspace_KeyspacePartition) GetShardTabletControls() []*ShardTabletControl {
	if m != nil {
		return m.ShardTabletControls
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type SrvKeyspace_ServedFrom struct {
	// the tablet type
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,proto3,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the keyspace name that's serving it
	Keyspace             string   `protobuf:"bytes,2,opt,name=keyspace,proto3" json:"keyspace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SrvKeyspace_ServedFrom) Reset()         { *m = SrvKeyspace_ServedFrom{} }
func (m *SrvKeyspace_ServedFrom) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace_ServedFrom) ProtoMessage()    {}
func (*SrvKeyspace_ServedFrom) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{8, 1}
}

func (m *SrvKeyspace_ServedFrom) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SrvKeyspace_ServedFrom.Unmarshal(m, b)
}
func (m *SrvKeyspace_ServedFrom) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SrvKeyspace_ServedFrom.Marshal(b, m, deterministic)
}
func (m *SrvKeyspace_ServedFrom) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SrvKeyspace_ServedFrom.Merge(m, src)
}
func (m *SrvKeyspace_ServedFrom) XXX_Size() int {
	return xxx_messageInfo_SrvKeyspace_ServedFrom.Size(m)
}
func (m *SrvKeyspace_ServedFrom) XXX_DiscardUnknown() {
	xxx_messageInfo_SrvKeyspace_ServedFrom.DiscardUnknown(m)
}

var xxx_messageInfo_SrvKeyspace_ServedFrom proto.InternalMessageInfo

func (m *SrvKeyspace_ServedFrom) GetTabletType() TabletType {
	if m != nil {
		return m.TabletType
	}
	return TabletType_UNKNOWN
}

func (m *SrvKeyspace_ServedFrom) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

// CellInfo contains information about a cell. CellInfo objects are
// stored in the global topology server, and describe how to reach
// local topology servers.
type CellInfo struct {
	// ServerAddress contains the address of the server for the cell.
	// The syntax of this field is topology implementation specific.
	// For instance, for Zookeeper, it is a comma-separated list of
	// server addresses.
	ServerAddress string `protobuf:"bytes,1,opt,name=server_address,json=serverAddress,proto3" json:"server_address,omitempty"`
	// Root is the path to store data in. It is only used when talking
	// to server_address.
	Root                 string   `protobuf:"bytes,2,opt,name=root,proto3" json:"root,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CellInfo) Reset()         { *m = CellInfo{} }
func (m *CellInfo) String() string { return proto.CompactTextString(m) }
func (*CellInfo) ProtoMessage()    {}
func (*CellInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{9}
}

func (m *CellInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CellInfo.Unmarshal(m, b)
}
func (m *CellInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CellInfo.Marshal(b, m, deterministic)
}
func (m *CellInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CellInfo.Merge(m, src)
}
func (m *CellInfo) XXX_Size() int {
	return xxx_messageInfo_CellInfo.Size(m)
}
func (m *CellInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CellInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CellInfo proto.InternalMessageInfo

func (m *CellInfo) GetServerAddress() string {
	if m != nil {
		return m.ServerAddress
	}
	return ""
}

func (m *CellInfo) GetRoot() string {
	if m != nil {
		return m.Root
	}
	return ""
}

// CellsAlias
type CellsAlias struct {
	// Cells that map to this alias
	Cells                []string `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CellsAlias) Reset()         { *m = CellsAlias{} }
func (m *CellsAlias) String() string { return proto.CompactTextString(m) }
func (*CellsAlias) ProtoMessage()    {}
func (*CellsAlias) Descriptor() ([]byte, []int) {
	return fileDescriptor_52c350cb619f972e, []int{10}
}

func (m *CellsAlias) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CellsAlias.Unmarshal(m, b)
}
func (m *CellsAlias) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CellsAlias.Marshal(b, m, deterministic)
}
func (m *CellsAlias) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CellsAlias.Merge(m, src)
}
func (m *CellsAlias) XXX_Size() int {
	return xxx_messageInfo_CellsAlias.Size(m)
}
func (m *CellsAlias) XXX_DiscardUnknown() {
	xxx_messageInfo_CellsAlias.DiscardUnknown(m)
}

var xxx_messageInfo_CellsAlias proto.InternalMessageInfo

func (m *CellsAlias) GetCells() []string {
	if m != nil {
		return m.Cells
	}
	return nil
}

func init() {
	proto.RegisterEnum("topodata.KeyspaceType", KeyspaceType_name, KeyspaceType_value)
	proto.RegisterEnum("topodata.KeyspaceIdType", KeyspaceIdType_name, KeyspaceIdType_value)
	proto.RegisterEnum("topodata.TabletType", TabletType_name, TabletType_value)
	proto.RegisterType((*KeyRange)(nil), "topodata.KeyRange")
	proto.RegisterType((*TabletAlias)(nil), "topodata.TabletAlias")
	proto.RegisterType((*Tablet)(nil), "topodata.Tablet")
	proto.RegisterMapType((map[string]int32)(nil), "topodata.Tablet.PortMapEntry")
	proto.RegisterMapType((map[string]string)(nil), "topodata.Tablet.TagsEntry")
	proto.RegisterType((*Shard)(nil), "topodata.Shard")
	proto.RegisterType((*Shard_ServedType)(nil), "topodata.Shard.ServedType")
	proto.RegisterType((*Shard_SourceShard)(nil), "topodata.Shard.SourceShard")
	proto.RegisterType((*Shard_TabletControl)(nil), "topodata.Shard.TabletControl")
	proto.RegisterType((*Keyspace)(nil), "topodata.Keyspace")
	proto.RegisterType((*Keyspace_ServedFrom)(nil), "topodata.Keyspace.ServedFrom")
	proto.RegisterType((*ShardReplication)(nil), "topodata.ShardReplication")
	proto.RegisterType((*ShardReplication_Node)(nil), "topodata.ShardReplication.Node")
	proto.RegisterType((*ShardReference)(nil), "topodata.ShardReference")
	proto.RegisterType((*ShardTabletControl)(nil), "topodata.ShardTabletControl")
	proto.RegisterType((*SrvKeyspace)(nil), "topodata.SrvKeyspace")
	proto.RegisterType((*SrvKeyspace_KeyspacePartition)(nil), "topodata.SrvKeyspace.KeyspacePartition")
	proto.RegisterType((*SrvKeyspace_ServedFrom)(nil), "topodata.SrvKeyspace.ServedFrom")
	proto.RegisterType((*CellInfo)(nil), "topodata.CellInfo")
	proto.RegisterType((*CellsAlias)(nil), "topodata.CellsAlias")
}

func init() { proto.RegisterFile("topodata.proto", fileDescriptor_52c350cb619f972e) }

var fileDescriptor_52c350cb619f972e = []byte{
	// 1314 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xe1, 0x6e, 0x1b, 0x45,
	0x10, 0xee, 0xd9, 0x67, 0xe7, 0x3c, 0x3e, 0x27, 0xd7, 0x25, 0xad, 0x4e, 0x07, 0x15, 0x91, 0x51,
	0x85, 0x15, 0x84, 0x03, 0x69, 0x0b, 0x51, 0x11, 0x52, 0x5d, 0xc7, 0xa5, 0x69, 0x12, 0xc7, 0x5a,
	0x3b, 0x82, 0xf2, 0xe7, 0x74, 0xb1, 0x37, 0xe9, 0x29, 0xe7, 0x3b, 0xf7, 0x76, 0x63, 0xc9, 0xbc,
	0x02, 0x3f, 0x80, 0xbf, 0xbc, 0x01, 0x8f, 0xc0, 0xbb, 0xf0, 0x07, 0x9e, 0x04, 0xed, 0xec, 0xdd,
	0xf9, 0x6c, 0xb7, 0x25, 0x45, 0xf9, 0xb7, 0x33, 0x3b, 0x33, 0x37, 0xf3, 0xcd, 0xcc, 0xb7, 0x36,
	0xac, 0x8b, 0x68, 0x12, 0x8d, 0x3c, 0xe1, 0x35, 0x27, 0x71, 0x24, 0x22, 0x62, 0xa4, 0xb2, 0x03,
	0xc2, 0x1f, 0x33, 0xa5, 0xad, 0xef, 0x82, 0x71, 0xc8, 0x66, 0xd4, 0x0b, 0x2f, 0x18, 0xd9, 0x84,
	0x12, 0x17, 0x5e, 0x2c, 0x6c, 0x6d, 0x4b, 0x6b, 0x98, 0x54, 0x09, 0xc4, 0x82, 0x22, 0x0b, 0x47,
	0x76, 0x01, 0x75, 0xf2, 0x58, 0x7f, 0x00, 0xd5, 0x81, 0x77, 0x16, 0x30, 0xd1, 0x0a, 0x7c, 0x8f,
	0x13, 0x02, 0xfa, 0x90, 0x05, 0x01, 0x7a, 0x55, 0x28, 0x9e, 0xa5, 0xd3, 0x95, 0xaf, 0x9c, 0x6a,
	0x54, 0x1e, 0xeb, 0x7f, 0xea, 0x50, 0x56, 0x5e, 0xe4, 0x33, 0x28, 0x79, 0xd2, 0x13, 0x3d, 0xaa,
	0xbb, 0x77, 0x9a, 0x59, 0xa6, 0xb9, 0xb0, 0x54, 0xd9, 0x10, 0x07, 0x8c, 0x57, 0x11, 0x17, 0xa1,
	0x37, 0x66, 0x18, 0xae, 0x42, 0x33, 0x99, 0xec, 0x81, 0x31, 0x89, 0x62, 0xe1, 0x8e, 0xbd, 0x89,
	0xad, 0x6f, 0x15, 0x1b, 0xd5, 0xdd, 0x7b, 0xcb, 0xb1, 0x9a, 0xbd, 0x28, 0x16, 0xc7, 0xde, 0xa4,
	0x13, 0x8a, 0x78, 0x46, 0xd7, 0x26, 0x4a, 0x92, 0x51, 0x2f, 0xd9, 0x8c, 0x4f, 0xbc, 0x21, 0xb3,
	0x4b, 0x2a, 0x6a, 0x2a, 0x23, 0x0c, 0xaf, 0xbc, 0x78, 0x64, 0x97, 0xf1, 0x42, 0x09, 0x64, 0x07,
	0x2a, 0x97, 0x6c, 0xe6, 0xc6, 0x12, 0x29, 0x7b, 0x0d, 0x13, 0x27, 0xf3, 0x8f, 0xa5, 0x18, 0x62,
	0x18, 0x85, 0x66, 0x03, 0x74, 0x31, 0x9b, 0x30, 0xdb, 0xd8, 0xd2, 0x1a, 0xeb, 0xbb, 0x9b, 0xcb,
	0x89, 0x0d, 0x66, 0x13, 0x46, 0xd1, 0x82, 0x34, 0xc0, 0x1a, 0x9d, 0xb9, 0xb2, 0x22, 0x37, 0x9a,
	0xb2, 0x38, 0xf6, 0x47, 0xcc, 0xae, 0xe0, 0xb7, 0xd7, 0x47, 0x67, 0x5d, 0x6f, 0xcc, 0x4e, 0x12,
	0x2d, 0x69, 0x82, 0x2e, 0xbc, 0x0b, 0x6e, 0x03, 0x16, 0xeb, 0xac, 0x14, 0x3b, 0xf0, 0x2e, 0xb8,
	0xaa, 0x14, 0xed, 0xc8, 0x7d, 0x58, 0x1f, 0xcf, 0xf8, 0xeb, 0xc0, 0xcd, 0x20, 0x34, 0x31, 0x6e,
	0x0d, 0xb5, 0xcf, 0x53, 0x1c, 0xef, 0x01, 0x28, 0x33, 0x09, 0x8f, 0x5d, 0xdb, 0xd2, 0x1a, 0x25,
	0x5a, 0x41, 0x8d, 0x44, 0xcf, 0x79, 0x0c, 0x66, 0x1e, 0x45, 0xd9, 0xdc, 0x4b, 0x36, 0x4b, 0xfa,
	0x2d, 0x8f, 0x12, 0xb2, 0xa9, 0x17, 0x5c, 0xa9, 0x0e, 0x95, 0xa8, 0x12, 0x1e, 0x17, 0xf6, 0x34,
	0xe7, 0x6b, 0xa8, 0x64, 0x49, 0xfd, 0x97, 0x63, 0x25, 0xe7, 0xf8, 0x42, 0x37, 0x8a, 0x96, 0xfe,
	0x42, 0x37, 0xaa, 0x96, 0x59, 0xff, 0xad, 0x0c, 0xa5, 0x3e, 0x76, 0x61, 0x0f, 0xcc, 0xb1, 0xc7,
	0x05, 0x8b, 0xdd, 0x6b, 0x4c, 0x50, 0x55, 0x99, 0xaa, 0x29, 0x5d, 0xe8, 0x5f, 0xe1, 0x1a, 0xfd,
	0xfb, 0x16, 0x4c, 0xce, 0xe2, 0x29, 0x1b, 0xb9, 0xb2, 0x49, 0xdc, 0x2e, 0x2e, 0x63, 0x8e, 0x19,
	0x35, 0xfb, 0x68, 0x83, 0xdd, 0xac, 0xf2, 0xec, 0xcc, 0xc9, 0x13, 0xa8, 0xf1, 0xe8, 0x2a, 0x1e,
	0x32, 0x17, 0xe7, 0x87, 0x27, 0x03, 0xfa, 0xe1, 0x8a, 0x3f, 0x1a, 0xe1, 0x99, 0x9a, 0x7c, 0x2e,
	0x70, 0xf2, 0x0c, 0x36, 0x04, 0x56, 0xe3, 0x0e, 0xa3, 0x50, 0xc4, 0x51, 0xc0, 0xed, 0xf2, 0xf2,
	0x90, 0xab, 0x18, 0xaa, 0xe8, 0xb6, 0xb2, 0xa2, 0xeb, 0x22, 0x2f, 0x72, 0xb2, 0x0d, 0xb7, 0x7d,
	0xee, 0x26, 0xb0, 0xc9, 0x14, 0xfd, 0xf0, 0x02, 0x27, 0xd8, 0xa0, 0x1b, 0x3e, 0x3f, 0x46, 0x7d,
	0x5f, 0xa9, 0x9d, 0x97, 0x00, 0xf3, 0x82, 0xc8, 0x23, 0xa8, 0x26, 0x19, 0xe0, 0x24, 0x6b, 0xef,
	0x98, 0x64, 0x10, 0xd9, 0x59, 0x36, 0x55, 0x92, 0x00, 0xb7, 0x0b, 0x5b, 0x45, 0xd9, 0x54, 0x14,
	0x9c, 0xdf, 0x35, 0xa8, 0xe6, 0x8a, 0x4d, 0x29, 0x42, 0xcb, 0x28, 0x62, 0x61, 0x29, 0x0b, 0x6f,
	0x5b, 0xca, 0xe2, 0x5b, 0x97, 0x52, 0xbf, 0x46, 0x53, 0xef, 0x42, 0x19, 0x13, 0xe5, 0x76, 0x09,
	0x73, 0x4b, 0x24, 0xe7, 0x0f, 0x0d, 0x6a, 0x0b, 0x28, 0xde, 0x68, 0xed, 0xe4, 0x73, 0x20, 0x67,
	0x81, 0x37, 0xbc, 0x0c, 0x7c, 0x2e, 0xe4, 0x40, 0xa9, 0x14, 0x74, 0x34, 0xb9, 0x9d, 0xbb, 0xc1,
	0xa0, 0x5c, 0x66, 0x79, 0x1e, 0x47, 0x3f, 0xb1, 0x10, 0xb9, 0xc9, 0xa0, 0x89, 0x94, 0xed, 0x44,
	0xc9, 0x2a, 0xd7, 0xff, 0x2a, 0x22, 0x73, 0x2b, 0x74, 0xbe, 0x80, 0x4d, 0x04, 0xc4, 0x0f, 0x2f,
	0xdc, 0x61, 0x14, 0x5c, 0x8d, 0x43, 0xa4, 0x93, 0x64, 0xd3, 0x48, 0x7a, 0xd7, 0xc6, 0x2b, 0xc9,
	0x28, 0xe4, 0xc5, 0xaa, 0x07, 0xd6, 0x59, 0xc0, 0x3a, 0xed, 0x05, 0x10, 0xf1, 0x1b, 0x07, 0x6a,
	0xc6, 0x97, 0x62, 0x61, 0xcd, 0x4f, 0xb2, 0x4d, 0x39, 0x8f, 0xa3, 0x31, 0x5f, 0xa5, 0xe2, 0x34,
	0x46, 0xb2, 0x2c, 0xcf, 0xe2, 0x68, 0x9c, 0x2e, 0x8b, 0x3c, 0x73, 0xf2, 0x0d, 0xd4, 0xd2, 0x4e,
	0xab, 0x34, 0x4a, 0x98, 0xc6, 0xdd, 0xd5, 0x10, 0x98, 0x84, 0x79, 0x99, 0x93, 0xc8, 0x27, 0x50,
	0x3b, 0xf3, 0x38, 0x73, 0xb3, 0xd9, 0x51, 0xbc, 0x6d, 0x4a, 0x65, 0x86, 0xd0, 0x97, 0x50, 0xe3,
	0xa1, 0x37, 0xe1, 0xaf, 0x22, 0xe1, 0xca, 0xe7, 0x2f, 0xa1, 0x70, 0xb3, 0x39, 0x15, 0xf8, 0x1a,
	0x0e, 0xfc, 0x31, 0xa3, 0x66, 0x6a, 0x22, 0x25, 0xe7, 0x2a, 0xdd, 0x05, 0x99, 0xe3, 0xcd, 0xce,
	0x43, 0x7e, 0xd2, 0x8b, 0x8b, 0x93, 0xae, 0x9a, 0x5c, 0xff, 0x59, 0x03, 0x4b, 0x91, 0x02, 0x9b,
	0x04, 0xfe, 0xd0, 0x13, 0x7e, 0x14, 0x92, 0x47, 0x50, 0x0a, 0xa3, 0x11, 0x93, 0xb4, 0x27, 0x11,
	0xfe, 0x78, 0x89, 0x07, 0x72, 0xa6, 0xcd, 0x6e, 0x34, 0x62, 0x54, 0x59, 0x3b, 0x4f, 0x40, 0x97,
	0xa2, 0x24, 0xcf, 0xa4, 0x84, 0xeb, 0x90, 0xa7, 0x98, 0x0b, 0xf5, 0x53, 0x58, 0x4f, 0xbe, 0x70,
	0xce, 0x62, 0x16, 0x0e, 0x99, 0x7c, 0xf4, 0x73, 0x13, 0x86, 0xe7, 0xf7, 0xa6, 0xd8, 0xfa, 0x2f,
	0x1a, 0x10, 0x8c, 0xbb, 0xb8, 0x7a, 0x37, 0x11, 0x9b, 0x3c, 0x84, 0xbb, 0xaf, 0xaf, 0x58, 0x3c,
	0x53, 0x8c, 0x37, 0x64, 0xee, 0xc8, 0xe7, 0xf2, 0x2b, 0x8a, 0x41, 0x0c, 0xba, 0x89, 0xb7, 0x7d,
	0x75, 0xb9, 0x9f, 0xdc, 0xd5, 0xff, 0xd1, 0xa1, 0xda, 0x8f, 0xa7, 0xd9, 0xd8, 0x7c, 0x07, 0x30,
	0xf1, 0x62, 0xe1, 0x4b, 0x4c, 0x53, 0xd8, 0x3f, 0xcd, 0xc1, 0x3e, 0x37, 0xcd, 0x26, 0xb4, 0x97,
	0xda, 0xd3, 0x9c, 0xeb, 0x5b, 0x37, 0xb4, 0xf0, 0xde, 0x1b, 0x5a, 0xfc, 0x1f, 0x1b, 0xda, 0x82,
	0x6a, 0x6e, 0x43, 0x93, 0x05, 0xdd, 0x7a, 0x73, 0x1d, 0xb9, 0x1d, 0x85, 0xf9, 0x8e, 0x3a, 0x7f,
	0x6b, 0x70, 0x7b, 0xa5, 0x44, 0xb9, 0x15, 0xb9, 0x47, 0xf2, 0xdd, 0x5b, 0x31, 0x7f, 0x1d, 0x49,
	0x1b, 0x2c, 0xcc, 0xd2, 0x8d, 0xd3, 0x81, 0x52, 0x0b, 0x52, 0xcd, 0xd7, 0xb5, 0x38, 0x71, 0x74,
	0x83, 0x2f, 0xc8, 0x9c, 0xf4, 0xe0, 0x8e, 0x0a, 0xb2, 0xfc, 0x4a, 0xaa, 0x97, 0xfa, 0xa3, 0xa5,
	0x48, 0x8b, 0x8f, 0xe4, 0x07, 0x7c, 0x45, 0xc7, 0x1d, 0xf7, 0x26, 0x36, 0xfe, 0x1d, 0xaf, 0x58,
	0x42, 0xdd, 0x87, 0x60, 0xb4, 0x59, 0x10, 0x1c, 0x84, 0xe7, 0x91, 0xfc, 0x85, 0x86, 0xb8, 0xc4,
	0xae, 0x37, 0x1a, 0xc5, 0x8c, 0xf3, 0x64, 0xea, 0x6b, 0x4a, 0xdb, 0x52, 0x4a, 0xb9, 0x12, 0x71,
	0x14, 0x89, 0x24, 0x20, 0x9e, 0x13, 0xa2, 0xa8, 0x03, 0xc8, 0x60, 0x5c, 0xfd, 0xca, 0x79, 0x23,
	0xdd, 0x6c, 0x37, 0xc0, 0xcc, 0xf3, 0x27, 0x01, 0x28, 0x77, 0x4f, 0xe8, 0x71, 0xeb, 0xc8, 0xba,
	0x45, 0x4c, 0x30, 0xfa, 0xdd, 0x56, 0xaf, 0xff, 0xfc, 0x64, 0x60, 0x69, 0xdb, 0xbb, 0xb0, 0xbe,
	0x38, 0x4e, 0xa4, 0x02, 0xa5, 0xd3, 0x6e, 0xbf, 0x33, 0xb0, 0x6e, 0x49, 0xb7, 0xd3, 0x83, 0xee,
	0xe0, 0xab, 0x87, 0x96, 0x26, 0xd5, 0x4f, 0x5f, 0x0e, 0x3a, 0x7d, 0xab, 0xb0, 0xfd, 0xab, 0x06,
	0x30, 0xc7, 0x82, 0x54, 0x61, 0xed, 0xb4, 0x7b, 0xd8, 0x3d, 0xf9, 0xbe, 0xab, 0x5c, 0x8e, 0x5b,
	0xfd, 0x41, 0x87, 0x5a, 0x9a, 0xbc, 0xa0, 0x9d, 0xde, 0xd1, 0x41, 0xbb, 0x65, 0x15, 0xe4, 0x05,
	0xdd, 0x3f, 0xe9, 0x1e, 0xbd, 0xb4, 0x8a, 0x18, 0xab, 0x35, 0x68, 0x3f, 0x57, 0xc7, 0x7e, 0xaf,
	0x45, 0x3b, 0x96, 0x4e, 0x2c, 0x30, 0x3b, 0x3f, 0xf4, 0x3a, 0xf4, 0xe0, 0xb8, 0xd3, 0x1d, 0xb4,
	0x8e, 0xac, 0x92, 0xf4, 0x79, 0xda, 0x6a, 0x1f, 0x9e, 0xf6, 0xac, 0xb2, 0x0a, 0xd6, 0x1f, 0x9c,
	0xd0, 0x8e, 0xb5, 0x26, 0x85, 0x7d, 0xda, 0x3a, 0xe8, 0x76, 0xf6, 0x2d, 0xc3, 0x29, 0x58, 0xda,
	0xd3, 0x3d, 0xd8, 0xf0, 0xa3, 0xe6, 0xd4, 0x17, 0x8c, 0x73, 0xf5, 0x47, 0xe7, 0xc7, 0xfb, 0x89,
	0xe4, 0x47, 0x3b, 0xea, 0xb4, 0x73, 0x11, 0xed, 0x4c, 0xc5, 0x0e, 0xde, 0xee, 0xa4, 0x4d, 0x3d,
	0x2b, 0xa3, 0xfc, 0xe0, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x5c, 0xc8, 0x21, 0x3e, 0x0d,
	0x00, 0x00,
}
