// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: analyze.proto

/*
	Package tipb is a generated protocol buffer package.

	It is generated from these files:
		analyze.proto
		checksum.proto
		executor.proto
		expression.proto
		schema.proto
		select.proto

	It has these top-level messages:
		AnalyzeReq
		AnalyzeIndexReq
		AnalyzeColumnsReq
		AnalyzeColumnsResp
		AnalyzeIndexResp
		Bucket
		Histogram
		FMSketch
		SampleCollector
		CMSketchRow
		CMSketch
		ChecksumRequest
		ChecksumResponse
		Executor
		TableScan
		IndexScan
		Selection
		Projection
		Aggregation
		TopN
		Limit
		ExecutorExecutionSummary
		FieldType
		Expr
		ByItem
		TableInfo
		ColumnInfo
		IndexInfo
		KeyRange
		Row
		Error
		SelectResponse
		Chunk
		RowMeta
		DAGRequest
		StreamResponse
*/
package tipb

import (
	"fmt"
	io "io"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type AnalyzeType int32

const (
	AnalyzeType_TypeIndex  AnalyzeType = 0
	AnalyzeType_TypeColumn AnalyzeType = 1
)

var AnalyzeType_name = map[int32]string{
	0: "TypeIndex",
	1: "TypeColumn",
}
var AnalyzeType_value = map[string]int32{
	"TypeIndex":  0,
	"TypeColumn": 1,
}

func (x AnalyzeType) Enum() *AnalyzeType {
	p := new(AnalyzeType)
	*p = x
	return p
}
func (x AnalyzeType) String() string {
	return proto.EnumName(AnalyzeType_name, int32(x))
}
func (x *AnalyzeType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AnalyzeType_value, data, "AnalyzeType")
	if err != nil {
		return err
	}
	*x = AnalyzeType(value)
	return nil
}
func (AnalyzeType) EnumDescriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{0} }

type AnalyzeReq struct {
	Tp               AnalyzeType        `protobuf:"varint,1,opt,name=tp,enum=tipb.AnalyzeType" json:"tp"`
	StartTs          uint64             `protobuf:"varint,2,opt,name=start_ts,json=startTs" json:"start_ts"`
	Flags            uint64             `protobuf:"varint,3,opt,name=flags" json:"flags"`
	TimeZoneOffset   int64              `protobuf:"varint,4,opt,name=time_zone_offset,json=timeZoneOffset" json:"time_zone_offset"`
	IdxReq           *AnalyzeIndexReq   `protobuf:"bytes,5,opt,name=idx_req,json=idxReq" json:"idx_req,omitempty"`
	ColReq           *AnalyzeColumnsReq `protobuf:"bytes,6,opt,name=col_req,json=colReq" json:"col_req,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *AnalyzeReq) Reset()                    { *m = AnalyzeReq{} }
func (m *AnalyzeReq) String() string            { return proto.CompactTextString(m) }
func (*AnalyzeReq) ProtoMessage()               {}
func (*AnalyzeReq) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{0} }

func (m *AnalyzeReq) GetTp() AnalyzeType {
	if m != nil {
		return m.Tp
	}
	return AnalyzeType_TypeIndex
}

func (m *AnalyzeReq) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *AnalyzeReq) GetFlags() uint64 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *AnalyzeReq) GetTimeZoneOffset() int64 {
	if m != nil {
		return m.TimeZoneOffset
	}
	return 0
}

func (m *AnalyzeReq) GetIdxReq() *AnalyzeIndexReq {
	if m != nil {
		return m.IdxReq
	}
	return nil
}

func (m *AnalyzeReq) GetColReq() *AnalyzeColumnsReq {
	if m != nil {
		return m.ColReq
	}
	return nil
}

type AnalyzeIndexReq struct {
	// bucket_size is the max histograms bucket size.
	BucketSize int64 `protobuf:"varint,1,opt,name=bucket_size,json=bucketSize" json:"bucket_size"`
	// num_columns is the number of columns in the index.
	NumColumns       int32  `protobuf:"varint,2,opt,name=num_columns,json=numColumns" json:"num_columns"`
	CmsketchDepth    *int32 `protobuf:"varint,3,opt,name=cmsketch_depth,json=cmsketchDepth" json:"cmsketch_depth,omitempty"`
	CmsketchWidth    *int32 `protobuf:"varint,4,opt,name=cmsketch_width,json=cmsketchWidth" json:"cmsketch_width,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *AnalyzeIndexReq) Reset()                    { *m = AnalyzeIndexReq{} }
func (m *AnalyzeIndexReq) String() string            { return proto.CompactTextString(m) }
func (*AnalyzeIndexReq) ProtoMessage()               {}
func (*AnalyzeIndexReq) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{1} }

func (m *AnalyzeIndexReq) GetBucketSize() int64 {
	if m != nil {
		return m.BucketSize
	}
	return 0
}

func (m *AnalyzeIndexReq) GetNumColumns() int32 {
	if m != nil {
		return m.NumColumns
	}
	return 0
}

func (m *AnalyzeIndexReq) GetCmsketchDepth() int32 {
	if m != nil && m.CmsketchDepth != nil {
		return *m.CmsketchDepth
	}
	return 0
}

func (m *AnalyzeIndexReq) GetCmsketchWidth() int32 {
	if m != nil && m.CmsketchWidth != nil {
		return *m.CmsketchWidth
	}
	return 0
}

type AnalyzeColumnsReq struct {
	// bucket_size is the max histograms bucket size, we need this because when primary key is handle,
	// the histogram will be directly built.
	BucketSize int64 `protobuf:"varint,1,opt,name=bucket_size,json=bucketSize" json:"bucket_size"`
	// sample_size is the max number of samples that will be collected.
	SampleSize int64 `protobuf:"varint,2,opt,name=sample_size,json=sampleSize" json:"sample_size"`
	// sketch_size is the max sketch size.
	SketchSize int64 `protobuf:"varint,3,opt,name=sketch_size,json=sketchSize" json:"sketch_size"`
	// columns_info is the info of all the columns that needs to be analyzed.
	ColumnsInfo      []*ColumnInfo `protobuf:"bytes,4,rep,name=columns_info,json=columnsInfo" json:"columns_info,omitempty"`
	CmsketchDepth    *int32        `protobuf:"varint,5,opt,name=cmsketch_depth,json=cmsketchDepth" json:"cmsketch_depth,omitempty"`
	CmsketchWidth    *int32        `protobuf:"varint,6,opt,name=cmsketch_width,json=cmsketchWidth" json:"cmsketch_width,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *AnalyzeColumnsReq) Reset()                    { *m = AnalyzeColumnsReq{} }
func (m *AnalyzeColumnsReq) String() string            { return proto.CompactTextString(m) }
func (*AnalyzeColumnsReq) ProtoMessage()               {}
func (*AnalyzeColumnsReq) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{2} }

func (m *AnalyzeColumnsReq) GetBucketSize() int64 {
	if m != nil {
		return m.BucketSize
	}
	return 0
}

func (m *AnalyzeColumnsReq) GetSampleSize() int64 {
	if m != nil {
		return m.SampleSize
	}
	return 0
}

func (m *AnalyzeColumnsReq) GetSketchSize() int64 {
	if m != nil {
		return m.SketchSize
	}
	return 0
}

func (m *AnalyzeColumnsReq) GetColumnsInfo() []*ColumnInfo {
	if m != nil {
		return m.ColumnsInfo
	}
	return nil
}

func (m *AnalyzeColumnsReq) GetCmsketchDepth() int32 {
	if m != nil && m.CmsketchDepth != nil {
		return *m.CmsketchDepth
	}
	return 0
}

func (m *AnalyzeColumnsReq) GetCmsketchWidth() int32 {
	if m != nil && m.CmsketchWidth != nil {
		return *m.CmsketchWidth
	}
	return 0
}

type AnalyzeColumnsResp struct {
	// collectors is the sample collectors for columns.
	Collectors []*SampleCollector `protobuf:"bytes,1,rep,name=collectors" json:"collectors,omitempty"`
	// pk_hist is the histogram for primary key when it is the handle.
	PkHist           *Histogram `protobuf:"bytes,2,opt,name=pk_hist,json=pkHist" json:"pk_hist,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *AnalyzeColumnsResp) Reset()                    { *m = AnalyzeColumnsResp{} }
func (m *AnalyzeColumnsResp) String() string            { return proto.CompactTextString(m) }
func (*AnalyzeColumnsResp) ProtoMessage()               {}
func (*AnalyzeColumnsResp) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{3} }

func (m *AnalyzeColumnsResp) GetCollectors() []*SampleCollector {
	if m != nil {
		return m.Collectors
	}
	return nil
}

func (m *AnalyzeColumnsResp) GetPkHist() *Histogram {
	if m != nil {
		return m.PkHist
	}
	return nil
}

type AnalyzeIndexResp struct {
	Hist             *Histogram `protobuf:"bytes,1,opt,name=hist" json:"hist,omitempty"`
	Cms              *CMSketch  `protobuf:"bytes,2,opt,name=cms" json:"cms,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *AnalyzeIndexResp) Reset()                    { *m = AnalyzeIndexResp{} }
func (m *AnalyzeIndexResp) String() string            { return proto.CompactTextString(m) }
func (*AnalyzeIndexResp) ProtoMessage()               {}
func (*AnalyzeIndexResp) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{4} }

func (m *AnalyzeIndexResp) GetHist() *Histogram {
	if m != nil {
		return m.Hist
	}
	return nil
}

func (m *AnalyzeIndexResp) GetCms() *CMSketch {
	if m != nil {
		return m.Cms
	}
	return nil
}

// Bucket is an element of histogram.
type Bucket struct {
	Count            int64  `protobuf:"varint,1,opt,name=count" json:"count"`
	LowerBound       []byte `protobuf:"bytes,2,opt,name=lower_bound,json=lowerBound" json:"lower_bound,omitempty"`
	UpperBound       []byte `protobuf:"bytes,3,opt,name=upper_bound,json=upperBound" json:"upper_bound,omitempty"`
	Repeats          int64  `protobuf:"varint,4,opt,name=repeats" json:"repeats"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Bucket) Reset()                    { *m = Bucket{} }
func (m *Bucket) String() string            { return proto.CompactTextString(m) }
func (*Bucket) ProtoMessage()               {}
func (*Bucket) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{5} }

func (m *Bucket) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Bucket) GetLowerBound() []byte {
	if m != nil {
		return m.LowerBound
	}
	return nil
}

func (m *Bucket) GetUpperBound() []byte {
	if m != nil {
		return m.UpperBound
	}
	return nil
}

func (m *Bucket) GetRepeats() int64 {
	if m != nil {
		return m.Repeats
	}
	return 0
}

type Histogram struct {
	// ndv is the number of distinct values.
	Ndv int64 `protobuf:"varint,1,opt,name=ndv" json:"ndv"`
	// buckets represents all the buckets.
	Buckets          []*Bucket `protobuf:"bytes,2,rep,name=buckets" json:"buckets,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *Histogram) Reset()                    { *m = Histogram{} }
func (m *Histogram) String() string            { return proto.CompactTextString(m) }
func (*Histogram) ProtoMessage()               {}
func (*Histogram) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{6} }

func (m *Histogram) GetNdv() int64 {
	if m != nil {
		return m.Ndv
	}
	return 0
}

func (m *Histogram) GetBuckets() []*Bucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

// FMSketch is used to count distinct values for columns.
type FMSketch struct {
	Mask             uint64   `protobuf:"varint,1,opt,name=mask" json:"mask"`
	Hashset          []uint64 `protobuf:"varint,2,rep,name=hashset" json:"hashset,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *FMSketch) Reset()                    { *m = FMSketch{} }
func (m *FMSketch) String() string            { return proto.CompactTextString(m) }
func (*FMSketch) ProtoMessage()               {}
func (*FMSketch) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{7} }

func (m *FMSketch) GetMask() uint64 {
	if m != nil {
		return m.Mask
	}
	return 0
}

func (m *FMSketch) GetHashset() []uint64 {
	if m != nil {
		return m.Hashset
	}
	return nil
}

// SampleCollector is used for collect samples and calculate the count and ndv of an column.
type SampleCollector struct {
	Samples          [][]byte  `protobuf:"bytes,1,rep,name=samples" json:"samples,omitempty"`
	NullCount        int64     `protobuf:"varint,2,opt,name=null_count,json=nullCount" json:"null_count"`
	Count            int64     `protobuf:"varint,3,opt,name=count" json:"count"`
	FmSketch         *FMSketch `protobuf:"bytes,4,opt,name=fm_sketch,json=fmSketch" json:"fm_sketch,omitempty"`
	CmSketch         *CMSketch `protobuf:"bytes,5,opt,name=cm_sketch,json=cmSketch" json:"cm_sketch,omitempty"`
	TotalSize        *int64    `protobuf:"varint,6,opt,name=total_size,json=totalSize" json:"total_size,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *SampleCollector) Reset()                    { *m = SampleCollector{} }
func (m *SampleCollector) String() string            { return proto.CompactTextString(m) }
func (*SampleCollector) ProtoMessage()               {}
func (*SampleCollector) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{8} }

func (m *SampleCollector) GetSamples() [][]byte {
	if m != nil {
		return m.Samples
	}
	return nil
}

func (m *SampleCollector) GetNullCount() int64 {
	if m != nil {
		return m.NullCount
	}
	return 0
}

func (m *SampleCollector) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *SampleCollector) GetFmSketch() *FMSketch {
	if m != nil {
		return m.FmSketch
	}
	return nil
}

func (m *SampleCollector) GetCmSketch() *CMSketch {
	if m != nil {
		return m.CmSketch
	}
	return nil
}

func (m *SampleCollector) GetTotalSize() int64 {
	if m != nil && m.TotalSize != nil {
		return *m.TotalSize
	}
	return 0
}

type CMSketchRow struct {
	Counters         []uint32 `protobuf:"varint,1,rep,name=counters" json:"counters,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *CMSketchRow) Reset()                    { *m = CMSketchRow{} }
func (m *CMSketchRow) String() string            { return proto.CompactTextString(m) }
func (*CMSketchRow) ProtoMessage()               {}
func (*CMSketchRow) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{9} }

func (m *CMSketchRow) GetCounters() []uint32 {
	if m != nil {
		return m.Counters
	}
	return nil
}

type CMSketch struct {
	Rows             []*CMSketchRow `protobuf:"bytes,1,rep,name=rows" json:"rows,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *CMSketch) Reset()                    { *m = CMSketch{} }
func (m *CMSketch) String() string            { return proto.CompactTextString(m) }
func (*CMSketch) ProtoMessage()               {}
func (*CMSketch) Descriptor() ([]byte, []int) { return fileDescriptorAnalyze, []int{10} }

func (m *CMSketch) GetRows() []*CMSketchRow {
	if m != nil {
		return m.Rows
	}
	return nil
}

func init() {
	proto.RegisterType((*AnalyzeReq)(nil), "tipb.AnalyzeReq")
	proto.RegisterType((*AnalyzeIndexReq)(nil), "tipb.AnalyzeIndexReq")
	proto.RegisterType((*AnalyzeColumnsReq)(nil), "tipb.AnalyzeColumnsReq")
	proto.RegisterType((*AnalyzeColumnsResp)(nil), "tipb.AnalyzeColumnsResp")
	proto.RegisterType((*AnalyzeIndexResp)(nil), "tipb.AnalyzeIndexResp")
	proto.RegisterType((*Bucket)(nil), "tipb.Bucket")
	proto.RegisterType((*Histogram)(nil), "tipb.Histogram")
	proto.RegisterType((*FMSketch)(nil), "tipb.FMSketch")
	proto.RegisterType((*SampleCollector)(nil), "tipb.SampleCollector")
	proto.RegisterType((*CMSketchRow)(nil), "tipb.CMSketchRow")
	proto.RegisterType((*CMSketch)(nil), "tipb.CMSketch")
	proto.RegisterEnum("tipb.AnalyzeType", AnalyzeType_name, AnalyzeType_value)
}
func (m *AnalyzeReq) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AnalyzeReq) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.Tp))
	dAtA[i] = 0x10
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.StartTs))
	dAtA[i] = 0x18
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.Flags))
	dAtA[i] = 0x20
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.TimeZoneOffset))
	if m.IdxReq != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(m.IdxReq.Size()))
		n1, err := m.IdxReq.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.ColReq != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(m.ColReq.Size()))
		n2, err := m.ColReq.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AnalyzeIndexReq) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AnalyzeIndexReq) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.BucketSize))
	dAtA[i] = 0x10
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.NumColumns))
	if m.CmsketchDepth != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(*m.CmsketchDepth))
	}
	if m.CmsketchWidth != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(*m.CmsketchWidth))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AnalyzeColumnsReq) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AnalyzeColumnsReq) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.BucketSize))
	dAtA[i] = 0x10
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.SampleSize))
	dAtA[i] = 0x18
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.SketchSize))
	if len(m.ColumnsInfo) > 0 {
		for _, msg := range m.ColumnsInfo {
			dAtA[i] = 0x22
			i++
			i = encodeVarintAnalyze(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.CmsketchDepth != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(*m.CmsketchDepth))
	}
	if m.CmsketchWidth != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(*m.CmsketchWidth))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AnalyzeColumnsResp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AnalyzeColumnsResp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Collectors) > 0 {
		for _, msg := range m.Collectors {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAnalyze(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.PkHist != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(m.PkHist.Size()))
		n3, err := m.PkHist.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *AnalyzeIndexResp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AnalyzeIndexResp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Hist != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(m.Hist.Size()))
		n4, err := m.Hist.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Cms != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(m.Cms.Size()))
		n5, err := m.Cms.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bucket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bucket) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.Count))
	if m.LowerBound != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(len(m.LowerBound)))
		i += copy(dAtA[i:], m.LowerBound)
	}
	if m.UpperBound != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(len(m.UpperBound)))
		i += copy(dAtA[i:], m.UpperBound)
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.Repeats))
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Histogram) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Histogram) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.Ndv))
	if len(m.Buckets) > 0 {
		for _, msg := range m.Buckets {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAnalyze(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FMSketch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FMSketch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.Mask))
	if len(m.Hashset) > 0 {
		for _, num := range m.Hashset {
			dAtA[i] = 0x10
			i++
			i = encodeVarintAnalyze(dAtA, i, uint64(num))
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *SampleCollector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SampleCollector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Samples) > 0 {
		for _, b := range m.Samples {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAnalyze(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.NullCount))
	dAtA[i] = 0x18
	i++
	i = encodeVarintAnalyze(dAtA, i, uint64(m.Count))
	if m.FmSketch != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(m.FmSketch.Size()))
		n6, err := m.FmSketch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.CmSketch != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(m.CmSketch.Size()))
		n7, err := m.CmSketch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.TotalSize != nil {
		dAtA[i] = 0x30
		i++
		i = encodeVarintAnalyze(dAtA, i, uint64(*m.TotalSize))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CMSketchRow) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CMSketchRow) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Counters) > 0 {
		for _, num := range m.Counters {
			dAtA[i] = 0x8
			i++
			i = encodeVarintAnalyze(dAtA, i, uint64(num))
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CMSketch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CMSketch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0xa
			i++
			i = encodeVarintAnalyze(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintAnalyze(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *AnalyzeReq) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAnalyze(uint64(m.Tp))
	n += 1 + sovAnalyze(uint64(m.StartTs))
	n += 1 + sovAnalyze(uint64(m.Flags))
	n += 1 + sovAnalyze(uint64(m.TimeZoneOffset))
	if m.IdxReq != nil {
		l = m.IdxReq.Size()
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.ColReq != nil {
		l = m.ColReq.Size()
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AnalyzeIndexReq) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAnalyze(uint64(m.BucketSize))
	n += 1 + sovAnalyze(uint64(m.NumColumns))
	if m.CmsketchDepth != nil {
		n += 1 + sovAnalyze(uint64(*m.CmsketchDepth))
	}
	if m.CmsketchWidth != nil {
		n += 1 + sovAnalyze(uint64(*m.CmsketchWidth))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AnalyzeColumnsReq) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAnalyze(uint64(m.BucketSize))
	n += 1 + sovAnalyze(uint64(m.SampleSize))
	n += 1 + sovAnalyze(uint64(m.SketchSize))
	if len(m.ColumnsInfo) > 0 {
		for _, e := range m.ColumnsInfo {
			l = e.Size()
			n += 1 + l + sovAnalyze(uint64(l))
		}
	}
	if m.CmsketchDepth != nil {
		n += 1 + sovAnalyze(uint64(*m.CmsketchDepth))
	}
	if m.CmsketchWidth != nil {
		n += 1 + sovAnalyze(uint64(*m.CmsketchWidth))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AnalyzeColumnsResp) Size() (n int) {
	var l int
	_ = l
	if len(m.Collectors) > 0 {
		for _, e := range m.Collectors {
			l = e.Size()
			n += 1 + l + sovAnalyze(uint64(l))
		}
	}
	if m.PkHist != nil {
		l = m.PkHist.Size()
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AnalyzeIndexResp) Size() (n int) {
	var l int
	_ = l
	if m.Hist != nil {
		l = m.Hist.Size()
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.Cms != nil {
		l = m.Cms.Size()
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bucket) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAnalyze(uint64(m.Count))
	if m.LowerBound != nil {
		l = len(m.LowerBound)
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.UpperBound != nil {
		l = len(m.UpperBound)
		n += 1 + l + sovAnalyze(uint64(l))
	}
	n += 1 + sovAnalyze(uint64(m.Repeats))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Histogram) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAnalyze(uint64(m.Ndv))
	if len(m.Buckets) > 0 {
		for _, e := range m.Buckets {
			l = e.Size()
			n += 1 + l + sovAnalyze(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FMSketch) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAnalyze(uint64(m.Mask))
	if len(m.Hashset) > 0 {
		for _, e := range m.Hashset {
			n += 1 + sovAnalyze(uint64(e))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SampleCollector) Size() (n int) {
	var l int
	_ = l
	if len(m.Samples) > 0 {
		for _, b := range m.Samples {
			l = len(b)
			n += 1 + l + sovAnalyze(uint64(l))
		}
	}
	n += 1 + sovAnalyze(uint64(m.NullCount))
	n += 1 + sovAnalyze(uint64(m.Count))
	if m.FmSketch != nil {
		l = m.FmSketch.Size()
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.CmSketch != nil {
		l = m.CmSketch.Size()
		n += 1 + l + sovAnalyze(uint64(l))
	}
	if m.TotalSize != nil {
		n += 1 + sovAnalyze(uint64(*m.TotalSize))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CMSketchRow) Size() (n int) {
	var l int
	_ = l
	if len(m.Counters) > 0 {
		for _, e := range m.Counters {
			n += 1 + sovAnalyze(uint64(e))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CMSketch) Size() (n int) {
	var l int
	_ = l
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovAnalyze(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAnalyze(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAnalyze(x uint64) (n int) {
	return sovAnalyze(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AnalyzeReq) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AnalyzeReq: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AnalyzeReq: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tp", wireType)
			}
			m.Tp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Tp |= (AnalyzeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			m.Flags = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Flags |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeZoneOffset", wireType)
			}
			m.TimeZoneOffset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeZoneOffset |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IdxReq", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IdxReq == nil {
				m.IdxReq = &AnalyzeIndexReq{}
			}
			if err := m.IdxReq.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColReq", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ColReq == nil {
				m.ColReq = &AnalyzeColumnsReq{}
			}
			if err := m.ColReq.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AnalyzeIndexReq) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AnalyzeIndexReq: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AnalyzeIndexReq: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketSize", wireType)
			}
			m.BucketSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BucketSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumColumns", wireType)
			}
			m.NumColumns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumColumns |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmsketchDepth", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CmsketchDepth = &v
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmsketchWidth", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CmsketchWidth = &v
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AnalyzeColumnsReq) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AnalyzeColumnsReq: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AnalyzeColumnsReq: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketSize", wireType)
			}
			m.BucketSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BucketSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SampleSize", wireType)
			}
			m.SampleSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SampleSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SketchSize", wireType)
			}
			m.SketchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SketchSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnsInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnsInfo = append(m.ColumnsInfo, &ColumnInfo{})
			if err := m.ColumnsInfo[len(m.ColumnsInfo)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmsketchDepth", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CmsketchDepth = &v
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmsketchWidth", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CmsketchWidth = &v
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AnalyzeColumnsResp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AnalyzeColumnsResp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AnalyzeColumnsResp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Collectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Collectors = append(m.Collectors, &SampleCollector{})
			if err := m.Collectors[len(m.Collectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PkHist", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PkHist == nil {
				m.PkHist = &Histogram{}
			}
			if err := m.PkHist.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AnalyzeIndexResp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AnalyzeIndexResp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AnalyzeIndexResp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hist", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hist == nil {
				m.Hist = &Histogram{}
			}
			if err := m.Hist.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cms", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cms == nil {
				m.Cms = &CMSketch{}
			}
			if err := m.Cms.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bucket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bucket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bucket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LowerBound", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LowerBound = append(m.LowerBound[:0], dAtA[iNdEx:postIndex]...)
			if m.LowerBound == nil {
				m.LowerBound = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpperBound", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpperBound = append(m.UpperBound[:0], dAtA[iNdEx:postIndex]...)
			if m.UpperBound == nil {
				m.UpperBound = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Repeats", wireType)
			}
			m.Repeats = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Repeats |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Histogram) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Histogram: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Histogram: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ndv", wireType)
			}
			m.Ndv = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ndv |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Buckets = append(m.Buckets, &Bucket{})
			if err := m.Buckets[len(m.Buckets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FMSketch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FMSketch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FMSketch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mask", wireType)
			}
			m.Mask = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mask |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAnalyze
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Hashset = append(m.Hashset, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAnalyze
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAnalyze
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAnalyze
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Hashset = append(m.Hashset, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Hashset", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SampleCollector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SampleCollector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SampleCollector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Samples", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Samples = append(m.Samples, make([]byte, postIndex-iNdEx))
			copy(m.Samples[len(m.Samples)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NullCount", wireType)
			}
			m.NullCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NullCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FmSketch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FmSketch == nil {
				m.FmSketch = &FMSketch{}
			}
			if err := m.FmSketch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CmSketch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CmSketch == nil {
				m.CmSketch = &CMSketch{}
			}
			if err := m.CmSketch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalSize", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TotalSize = &v
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CMSketchRow) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CMSketchRow: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CMSketchRow: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAnalyze
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Counters = append(m.Counters, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAnalyze
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthAnalyze
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAnalyze
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Counters = append(m.Counters, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Counters", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CMSketch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CMSketch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CMSketch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAnalyze
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, &CMSketchRow{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAnalyze(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAnalyze
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAnalyze(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAnalyze
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAnalyze
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAnalyze
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAnalyze
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAnalyze(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAnalyze = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAnalyze   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("analyze.proto", fileDescriptorAnalyze) }

var fileDescriptorAnalyze = []byte{
	// 810 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xae, 0x63, 0xe7, 0xef, 0x38, 0x4d, 0xd3, 0x11, 0x0b, 0x56, 0x25, 0xd2, 0xc8, 0xab, 0x42,
	0x96, 0x45, 0x01, 0x8a, 0xb8, 0x45, 0xa2, 0x45, 0x88, 0x15, 0x42, 0xa0, 0xe9, 0x4a, 0x08, 0x6e,
	0x2c, 0xd7, 0x9e, 0x24, 0x56, 0x6c, 0xcf, 0xd4, 0x33, 0x26, 0xbb, 0xbd, 0x46, 0xdc, 0xf0, 0x02,
	0xbc, 0x04, 0xef, 0xb1, 0x97, 0x3c, 0x01, 0x42, 0x45, 0xbc, 0x07, 0x9a, 0x33, 0xb6, 0x15, 0x67,
	0x73, 0xc1, 0x5e, 0xd9, 0xf3, 0x7d, 0xdf, 0x39, 0x3e, 0xe7, 0x3b, 0x67, 0x0c, 0xc7, 0x61, 0x1e,
	0xa6, 0x2f, 0xef, 0xd9, 0x42, 0x14, 0x5c, 0x71, 0xe2, 0xa8, 0x44, 0xdc, 0x9e, 0x8d, 0x64, 0xb4,
	0x66, 0x59, 0x68, 0xb0, 0xb3, 0xb7, 0x56, 0x7c, 0xc5, 0xf1, 0xf5, 0x23, 0xfd, 0x66, 0x50, 0xff,
	0x97, 0x0e, 0xc0, 0x17, 0x26, 0x96, 0xb2, 0x3b, 0xf2, 0x3e, 0x74, 0x94, 0xf0, 0xac, 0x99, 0x35,
	0x1f, 0x5f, 0x9e, 0x2e, 0x74, 0x96, 0x45, 0xc5, 0x3e, 0x7f, 0x29, 0xd8, 0x95, 0xf3, 0xea, 0xaf,
	0xf3, 0x23, 0xda, 0x51, 0x82, 0x9c, 0xc3, 0x40, 0xaa, 0xb0, 0x50, 0x81, 0x92, 0x5e, 0x67, 0x66,
	0xcd, 0x9d, 0x8a, 0xeb, 0x23, 0xfa, 0x5c, 0x92, 0x33, 0xe8, 0x2e, 0xd3, 0x70, 0x25, 0x3d, 0x7b,
	0x87, 0x35, 0x10, 0x59, 0xc0, 0x44, 0x25, 0x19, 0x0b, 0xee, 0x79, 0xce, 0x02, 0xbe, 0x5c, 0x4a,
	0xa6, 0x3c, 0x67, 0x66, 0xcd, 0xed, 0x4a, 0x36, 0xd6, 0xec, 0x4f, 0x3c, 0x67, 0xdf, 0x21, 0x47,
	0x16, 0xd0, 0x4f, 0xe2, 0x17, 0x41, 0xc1, 0xee, 0xbc, 0xee, 0xcc, 0x9a, 0xbb, 0x97, 0x8f, 0x5a,
	0xa5, 0x3d, 0xcb, 0x63, 0xf6, 0x82, 0xb2, 0x3b, 0xda, 0x4b, 0x62, 0xfd, 0x24, 0x1f, 0x43, 0x3f,
	0xe2, 0x29, 0xea, 0x7b, 0xa8, 0x7f, 0xa7, 0xa5, 0xbf, 0xe6, 0x69, 0x99, 0xe5, 0x12, 0x23, 0x22,
	0x9e, 0x52, 0x76, 0xe7, 0xff, 0x61, 0xc1, 0xc9, 0x5e, 0x36, 0x72, 0x01, 0xee, 0x6d, 0x19, 0x6d,
	0x98, 0x0a, 0x64, 0x72, 0xcf, 0xd0, 0x94, 0xba, 0x40, 0x30, 0xc4, 0x4d, 0x72, 0xcf, 0xb4, 0x2c,
	0x2f, 0xb3, 0x20, 0x32, 0x49, 0xd1, 0x8c, 0x6e, 0x2d, 0xcb, 0xcb, 0xac, 0xfa, 0x18, 0xb9, 0x80,
	0x71, 0x94, 0xc9, 0x0d, 0x53, 0xd1, 0x3a, 0x88, 0x99, 0x50, 0x6b, 0x34, 0xa6, 0x4b, 0x8f, 0x6b,
	0xf4, 0x4b, 0x0d, 0xb6, 0x64, 0xdb, 0x24, 0x56, 0x6b, 0x34, 0x66, 0x47, 0xf6, 0x83, 0x06, 0xfd,
	0xdf, 0x3a, 0x70, 0xfa, 0x5a, 0x37, 0x6f, 0x50, 0xb1, 0x0c, 0x33, 0x91, 0x32, 0x23, 0xeb, 0xec,
	0xca, 0x0c, 0xd1, 0xc8, 0x4c, 0x21, 0x28, 0xb3, 0x5b, 0x32, 0x24, 0x50, 0xf6, 0x29, 0x8c, 0xaa,
	0xde, 0x83, 0x24, 0x5f, 0x72, 0xcf, 0x99, 0xd9, 0x73, 0xf7, 0x72, 0x62, 0x1c, 0x37, 0xc5, 0x3d,
	0xcb, 0x97, 0x9c, 0xba, 0x95, 0x4a, 0x1f, 0x0e, 0xb8, 0xd1, 0xfd, 0x7f, 0x6e, 0xf4, 0x0e, 0xb9,
	0x51, 0x02, 0xd9, 0x37, 0x43, 0x0a, 0xf2, 0x19, 0x40, 0xc4, 0xd3, 0x94, 0x45, 0x8a, 0x17, 0xd2,
	0xb3, 0xb0, 0xac, 0x6a, 0x71, 0x6e, 0xb0, 0xcb, 0xeb, 0x9a, 0xa5, 0x3b, 0x42, 0x32, 0x87, 0xbe,
	0xd8, 0x04, 0xeb, 0x44, 0x2a, 0x74, 0xc6, 0xbd, 0x3c, 0x31, 0x31, 0x5f, 0x27, 0x52, 0xf1, 0x55,
	0x11, 0x66, 0xb4, 0x27, 0x36, 0xfa, 0xe0, 0xff, 0x08, 0x93, 0xf6, 0xce, 0x48, 0x41, 0x1e, 0x83,
	0x83, 0xa1, 0xd6, 0xe1, 0x50, 0x24, 0xc9, 0x0c, 0xec, 0x28, 0x93, 0x55, 0xfa, 0x71, 0xe5, 0xd4,
	0xb7, 0x37, 0xd8, 0x11, 0xd5, 0x94, 0xff, 0xab, 0x05, 0xbd, 0x2b, 0x9c, 0x98, 0xbe, 0x48, 0x11,
	0x2f, 0x73, 0xd5, 0x1a, 0xa7, 0x81, 0xc8, 0x39, 0xb8, 0x29, 0xdf, 0xb2, 0x22, 0xb8, 0xe5, 0x65,
	0x1e, 0x63, 0xc2, 0x11, 0x05, 0x84, 0xae, 0x34, 0xa2, 0x05, 0xa5, 0x10, 0x8d, 0xc0, 0x36, 0x02,
	0x84, 0x8c, 0x60, 0x0a, 0xfd, 0x82, 0x09, 0x16, 0x2a, 0xd9, 0xba, 0x81, 0x35, 0xe8, 0x7f, 0x03,
	0xc3, 0xa6, 0x7a, 0xf2, 0x36, 0xd8, 0x79, 0xfc, 0x73, 0xab, 0x10, 0x0d, 0x90, 0xf7, 0xa0, 0x6f,
	0xd6, 0x4b, 0xf7, 0xa4, 0x6d, 0x1e, 0x99, 0x9e, 0x4c, 0x07, 0xb4, 0x26, 0xfd, 0xcf, 0x61, 0xf0,
	0x55, 0xd5, 0x26, 0xf1, 0xc0, 0xc9, 0x42, 0xb9, 0xc1, 0x64, 0xf5, 0xef, 0x01, 0x11, 0xe2, 0x41,
	0x7f, 0x1d, 0xca, 0xb5, 0xfe, 0x29, 0xe8, 0x6c, 0x0e, 0xad, 0x8f, 0xfe, 0xbf, 0x16, 0x9c, 0xec,
	0x8d, 0x4e, 0xab, 0xcd, 0xce, 0x9a, 0x11, 0x8f, 0x68, 0x7d, 0x24, 0x8f, 0x01, 0xf2, 0x32, 0x4d,
	0x03, 0xe3, 0xde, 0xee, 0x96, 0x0f, 0x35, 0x7e, 0x8d, 0x0e, 0x36, 0xee, 0xda, 0xaf, 0xbb, 0xfb,
	0x14, 0x86, 0xcb, 0x2c, 0x30, 0x8b, 0x86, 0xee, 0x34, 0xc3, 0xaa, 0xbb, 0xa0, 0x83, 0x65, 0x56,
	0xf5, 0xf3, 0x14, 0x86, 0x51, 0x23, 0xee, 0x1e, 0x9c, 0xec, 0x20, 0xaa, 0xc5, 0xef, 0x02, 0x28,
	0xae, 0xc2, 0xd4, 0xdc, 0x2c, 0xbd, 0xd3, 0x36, 0x1d, 0x22, 0xa2, 0xaf, 0x94, 0xff, 0x04, 0xdc,
	0x26, 0x88, 0x6f, 0xc9, 0x19, 0x0c, 0xb0, 0x20, 0x56, 0xad, 0xf1, 0x31, 0x6d, 0xce, 0xfe, 0x27,
	0x30, 0xa8, 0xa5, 0xe4, 0x02, 0x9c, 0x82, 0x6f, 0xeb, 0x55, 0x3f, 0xdd, 0xfb, 0x3a, 0xdf, 0x52,
	0xa4, 0x3f, 0xf8, 0x10, 0xdc, 0x9d, 0x7f, 0x3a, 0x39, 0x86, 0xa1, 0x7e, 0xe2, 0x0a, 0x4f, 0x8e,
	0xc8, 0x18, 0x40, 0x1f, 0xcd, 0x45, 0x9a, 0x58, 0x57, 0x4f, 0x5e, 0x3d, 0x4c, 0xad, 0x3f, 0x1f,
	0xa6, 0xd6, 0xdf, 0x0f, 0x53, 0xeb, 0xf7, 0x7f, 0xa6, 0x47, 0xf0, 0x28, 0xe2, 0xd9, 0x42, 0x24,
	0xf9, 0x2a, 0x0a, 0xc5, 0x42, 0x25, 0xf1, 0x2d, 0x7e, 0xe8, 0x7b, 0xeb, 0xbf, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xa2, 0x15, 0x4d, 0x0e, 0x85, 0x06, 0x00, 0x00,
}
