// Copyright 2020 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// See the License for the specific language governing permissions and
// limitations under the License.

package errno

// MySQL error code.
// This value is numeric. It is not portable to other database systems.
const (
	ErrErrorFirst                                            uint16 = 1000
	ErrHashchk                                                      = 1000
	ErrNisamchk                                                     = 1001
	ErrNo                                                           = 1002
	ErrYes                                                          = 1003
	ErrCantCreateFile                                               = 1004
	ErrCantCreateTable                                              = 1005
	ErrCantCreateDB                                                 = 1006
	ErrDBCreateExists                                               = 1007
	ErrDBDropExists                                                 = 1008
	ErrDBDropDelete                                                 = 1009
	ErrDBDropRmdir                                                  = 1010
	ErrCantDeleteFile                                               = 1011
	ErrCantFindSystemRec                                            = 1012
	ErrCantGetStat                                                  = 1013
	ErrCantGetWd                                                    = 1014
	ErrCantLock                                                     = 1015
	ErrCantOpenFile                                                 = 1016
	ErrFileNotFound                                                 = 1017
	ErrCantReadDir                                                  = 1018
	ErrCantSetWd                                                    = 1019
	ErrCheckread                                                    = 1020
	ErrDiskFull                                                     = 1021
	ErrDupKey                                                       = 1022
	ErrErrorOnClose                                                 = 1023
	ErrErrorOnRead                                                  = 1024
	ErrErrorOnRename                                                = 1025
	ErrErrorOnWrite                                                 = 1026
	ErrFileUsed                                                     = 1027
	ErrFilsortAbort                                                 = 1028
	ErrFormNotFound                                                 = 1029
	ErrGetErrno                                                     = 1030
	ErrIllegalHa                                                    = 1031
	ErrKeyNotFound                                                  = 1032
	ErrNotFormFile                                                  = 1033
	ErrNotKeyFile                                                   = 1034
	ErrOldKeyFile                                                   = 1035
	ErrOpenAsReadonly                                               = 1036
	ErrOutofMemory                                                  = 1037
	ErrOutOfSortMemory                                              = 1038
	ErrUnexpectedEOF                                                = 1039
	ErrConCount                                                     = 1040
	ErrOutOfResources                                               = 1041
	ErrBadHost                                                      = 1042
	ErrHandshake                                                    = 1043
	ErrDBaccessDenied                                               = 1044
	ErrAccessDenied                                                 = 1045
	ErrNoDB                                                         = 1046
	ErrUnknownCom                                                   = 1047
	ErrBadNull                                                      = 1048
	ErrBadDB                                                        = 1049
	ErrTableExists                                                  = 1050
	ErrBadTable                                                     = 1051
	ErrNonUniq                                                      = 1052
	ErrServerShutdown                                               = 1053
	ErrBadField                                                     = 1054
	ErrFieldNotInGroupBy                                            = 1055
	ErrWrongGroupField                                              = 1056
	ErrWrongSumSelect                                               = 1057
	ErrWrongValueCount                                              = 1058
	ErrTooLongIdent                                                 = 1059
	ErrDupFieldName                                                 = 1060
	ErrDupKeyName                                                   = 1061
	ErrDupEntry                                                     = 1062
	ErrWrongFieldSpec                                               = 1063
	ErrParse                                                        = 1064
	ErrEmptyQuery                                                   = 1065
	ErrNonuniqTable                                                 = 1066
	ErrInvalidDefault                                               = 1067
	ErrMultiplePriKey                                               = 1068
	ErrTooManyKeys                                                  = 1069
	ErrTooManyKeyParts                                              = 1070
	ErrTooLongKey                                                   = 1071
	ErrKeyColumnDoesNotExits                                        = 1072
	ErrBlobUsedAsKey                                                = 1073
	ErrTooBigFieldlength                                            = 1074
	ErrWrongAutoKey                                                 = 1075
	ErrReady                                                        = 1076
	ErrNormalShutdown                                               = 1077
	ErrGotSignal                                                    = 1078
	ErrShutdownComplete                                             = 1079
	ErrForcingClose                                                 = 1080
	ErrIpsock                                                       = 1081
	ErrNoSuchIndex                                                  = 1082
	ErrWrongFieldTerminators                                        = 1083
	ErrBlobsAndNoTerminated                                         = 1084
	ErrTextFileNotReadable                                          = 1085
	ErrFileExists                                                   = 1086
	ErrLoadInfo                                                     = 1087
	ErrAlterInfo                                                    = 1088
	ErrWrongSubKey                                                  = 1089
	ErrCantRemoveAllFields                                          = 1090
	ErrCantDropFieldOrKey                                           = 1091
	ErrInsertInfo                                                   = 1092
	ErrUpdateTableUsed                                              = 1093
	ErrNoSuchThread                                                 = 1094
	ErrKillDenied                                                   = 1095
	ErrNoTablesUsed                                                 = 1096
	ErrTooBigSet                                                    = 1097
	ErrNoUniqueLogFile                                              = 1098
	ErrTableNotLockedForWrite                                       = 1099
	ErrTableNotLocked                                               = 1100
	ErrBlobCantHaveDefault                                          = 1101
	ErrWrongDBName                                                  = 1102
	ErrWrongTableName                                               = 1103
	ErrTooBigSelect                                                 = 1104
	ErrUnknown                                                      = 1105
	ErrUnknownProcedure                                             = 1106
	ErrWrongParamcountToProcedure                                   = 1107
	ErrWrongParametersToProcedure                                   = 1108
	ErrUnknownTable                                                 = 1109
	ErrFieldSpecifiedTwice                                          = 1110
	ErrInvalidGroupFuncUse                                          = 1111
	ErrUnsupportedExtension                                         = 1112
	ErrTableMustHaveColumns                                         = 1113
	ErrRecordFileFull                                               = 1114
	ErrUnknownCharacterSet                                          = 1115
	ErrTooManyTables                                                = 1116
	ErrTooManyFields                                                = 1117
	ErrTooBigRowsize                                                = 1118
	ErrStackOverrun                                                 = 1119
	ErrWrongOuterJoin                                               = 1120
	ErrNullColumnInIndex                                            = 1121
	ErrCantFindUdf                                                  = 1122
	ErrCantInitializeUdf                                            = 1123
	ErrUdfNoPaths                                                   = 1124
	ErrUdfExists                                                    = 1125
	ErrCantOpenLibrary                                              = 1126
	ErrCantFindDlEntry                                              = 1127
	ErrFunctionNotDefined                                           = 1128
	ErrHostIsBlocked                                                = 1129
	ErrHostNotPrivileged                                            = 1130
	ErrPasswordAnonymousUser                                        = 1131
	ErrPasswordNotAllowed                                           = 1132
	ErrPasswordNoMatch                                              = 1133
	ErrUpdateInfo                                                   = 1134
	ErrCantCreateThread                                             = 1135
	ErrWrongValueCountOnRow                                         = 1136
	ErrCantReopenTable                                              = 1137
	ErrInvalidUseOfNull                                             = 1138
	ErrRegexp                                                       = 1139
	ErrMixOfGroupFuncAndFields                                      = 1140
	ErrNonexistingGrant                                             = 1141
	ErrTableaccessDenied                                            = 1142
	ErrColumnaccessDenied                                           = 1143
	ErrIllegalGrantForTable                                         = 1144
	ErrGrantWrongHostOrUser                                         = 1145
	ErrNoSuchTable                                                  = 1146
	ErrNonexistingTableGrant                                        = 1147
	ErrNotAllowedCommand                                            = 1148
	ErrSyntax                                                       = 1149
	ErrDelayedCantChangeLock                                        = 1150
	ErrTooManyDelayedThreads                                        = 1151
	ErrAbortingConnection                                           = 1152
	ErrNetPacketTooLarge                                            = 1153
	ErrNetReadErrorFromPipe                                         = 1154
	ErrNetFcntl                                                     = 1155
	ErrNetPacketsOutOfOrder                                         = 1156
	ErrNetUncompress                                                = 1157
	ErrNetRead                                                      = 1158
	ErrNetReadInterrupted                                           = 1159
	ErrNetErrorOnWrite                                              = 1160
	ErrNetWriteInterrupted                                          = 1161
	ErrTooLongString                                                = 1162
	ErrTableCantHandleBlob                                          = 1163
	ErrTableCantHandleAutoIncrement                                 = 1164
	ErrDelayedInsertTableLocked                                     = 1165
	ErrWrongColumnName                                              = 1166
	ErrWrongKeyColumn                                               = 1167
	ErrWrongMrgTable                                                = 1168
	ErrDupUnique                                                    = 1169
	ErrBlobKeyWithoutLength                                         = 1170
	ErrPrimaryCantHaveNull                                          = 1171
	ErrTooManyRows                                                  = 1172
	ErrRequiresPrimaryKey                                           = 1173
	ErrNoRaidCompiled                                               = 1174
	ErrUpdateWithoutKeyInSafeMode                                   = 1175
	ErrKeyDoesNotExist                                              = 1176
	ErrCheckNoSuchTable                                             = 1177
	ErrCheckNotImplemented                                          = 1178
	ErrCantDoThisDuringAnTransaction                                = 1179
	ErrErrorDuringCommit                                            = 1180
	ErrErrorDuringRollback                                          = 1181
	ErrErrorDuringFlushLogs                                         = 1182
	ErrErrorDuringCheckpoint                                        = 1183
	ErrNewAbortingConnection                                        = 1184
	ErrDumpNotImplemented                                           = 1185
	ErrFlushMasterBinlogClosed                                      = 1186
	ErrIndexRebuild                                                 = 1187
	ErrMaster                                                       = 1188
	ErrMasterNetRead                                                = 1189
	ErrMasterNetWrite                                               = 1190
	ErrFtMatchingKeyNotFound                                        = 1191
	ErrLockOrActiveTransaction                                      = 1192
	ErrUnknownSystemVariable                                        = 1193
	ErrCrashedOnUsage                                               = 1194
	ErrCrashedOnRepair                                              = 1195
	ErrWarningNotCompleteRollback                                   = 1196
	ErrTransCacheFull                                               = 1197
	ErrSlaveMustStop                                                = 1198
	ErrSlaveNotRunning                                              = 1199
	ErrBadSlave                                                     = 1200
	ErrMasterInfo                                                   = 1201
	ErrSlaveThread                                                  = 1202
	ErrTooManyUserConnections                                       = 1203
	ErrSetConstantsOnly                                             = 1204
	ErrLockWaitTimeout                                              = 1205
	ErrLockTableFull                                                = 1206
	ErrReadOnlyTransaction                                          = 1207
	ErrDropDBWithReadLock                                           = 1208
	ErrCreateDBWithReadLock                                         = 1209
	ErrWrongArguments                                               = 1210
	ErrNoPermissionToCreateUser                                     = 1211
	ErrUnionTablesInDifferentDir                                    = 1212
	ErrLockDeadlock                                                 = 1213
	ErrTableCantHandleFt                                            = 1214
	ErrCannotAddForeign                                             = 1215
	ErrNoReferencedRow                                              = 1216
	ErrRowIsReferenced                                              = 1217
	ErrConnectToMaster                                              = 1218
	ErrQueryOnMaster                                                = 1219
	ErrErrorWhenExecutingCommand                                    = 1220
	ErrWrongUsage                                                   = 1221
	ErrWrongNumberOfColumnsInSelect                                 = 1222
	ErrCantUpdateWithReadlock                                       = 1223
	ErrMixingNotAllowed                                             = 1224
	ErrDupArgument                                                  = 1225
	ErrUserLimitReached                                             = 1226
	ErrSpecificAccessDenied                                         = 1227
	ErrLocalVariable                                                = 1228
	ErrGlobalVariable                                               = 1229
	ErrNoDefault                                                    = 1230
	ErrWrongValueForVar                                             = 1231
	ErrWrongTypeForVar                                              = 1232
	ErrVarCantBeRead                                                = 1233
	ErrCantUseOptionHere                                            = 1234
	ErrNotSupportedYet                                              = 1235
	ErrMasterFatalErrorReadingBinlog                                = 1236
	ErrSlaveIgnoredTable                                            = 1237
	ErrIncorrectGlobalLocalVar                                      = 1238
	ErrWrongFkDef                                                   = 1239
	ErrKeyRefDoNotMatchTableRef                                     = 1240
	ErrOperandColumns                                               = 1241
	ErrSubqueryNo1Row                                               = 1242
	ErrUnknownStmtHandler                                           = 1243
	ErrCorruptHelpDB                                                = 1244
	ErrCyclicReference                                              = 1245
	ErrAutoConvert                                                  = 1246
	ErrIllegalReference                                             = 1247
	ErrDerivedMustHaveAlias                                         = 1248
	ErrSelectReduced                                                = 1249
	ErrTablenameNotAllowedHere                                      = 1250
	ErrNotSupportedAuthMode                                         = 1251
	ErrSpatialCantHaveNull                                          = 1252
	ErrCollationCharsetMismatch                                     = 1253
	ErrSlaveWasRunning                                              = 1254
	ErrSlaveWasNotRunning                                           = 1255
	ErrTooBigForUncompress                                          = 1256
	ErrZlibZMem                                                     = 1257
	ErrZlibZBuf                                                     = 1258
	ErrZlibZData                                                    = 1259
	ErrCutValueGroupConcat                                          = 1260
	ErrWarnTooFewRecords                                            = 1261
	ErrWarnTooManyRecords                                           = 1262
	ErrWarnNullToNotnull                                            = 1263
	ErrWarnDataOutOfRange                                           = 1264
	WarnDataTruncated                                               = 1265
	ErrWarnUsingOtherHandler                                        = 1266
	ErrCantAggregate2collations                                     = 1267
	ErrDropUser                                                     = 1268
	ErrRevokeGrants                                                 = 1269
	ErrCantAggregate3collations                                     = 1270
	ErrCantAggregateNcollations                                     = 1271
	ErrVariableIsNotStruct                                          = 1272
	ErrUnknownCollation                                             = 1273
	ErrSlaveIgnoredSslParams                                        = 1274
	ErrServerIsInSecureAuthMode                                     = 1275
	ErrWarnFieldResolved                                            = 1276
	ErrBadSlaveUntilCond                                            = 1277
	ErrMissingSkipSlave                                             = 1278
	ErrUntilCondIgnored                                             = 1279
	ErrWrongNameForIndex                                            = 1280
	ErrWrongNameForCatalog                                          = 1281
	ErrWarnQcResize                                                 = 1282
	ErrBadFtColumn                                                  = 1283
	ErrUnknownKeyCache                                              = 1284
	ErrWarnHostnameWontWork                                         = 1285
	ErrUnknownStorageEngine                                         = 1286
	ErrWarnDeprecatedSyntax                                         = 1287
	ErrNonUpdatableTable                                            = 1288
	ErrFeatureDisabled                                              = 1289
	ErrOptionPreventsStatement                                      = 1290
	ErrDuplicatedValueInType                                        = 1291
	ErrTruncatedWrongValue                                          = 1292
	ErrTooMuchAutoTimestampCols                                     = 1293
	ErrInvalidOnUpdate                                              = 1294
	ErrUnsupportedPs                                                = 1295
	ErrGetErrmsg                                                    = 1296
	ErrGetTemporaryErrmsg                                           = 1297
	ErrUnknownTimeZone                                              = 1298
	ErrWarnInvalidTimestamp                                         = 1299
	ErrInvalidCharacterString                                       = 1300
	ErrWarnAllowedPacketOverflowed                                  = 1301
	ErrConflictingDeclarations                                      = 1302
	ErrSpNoRecursiveCreate                                          = 1303
	ErrSpAlreadyExists                                              = 1304
	ErrSpDoesNotExist                                               = 1305
	ErrSpDropFailed                                                 = 1306
	ErrSpStoreFailed                                                = 1307
	ErrSpLilabelMismatch                                            = 1308
	ErrSpLabelRedefine                                              = 1309
	ErrSpLabelMismatch                                              = 1310
	ErrSpUninitVar                                                  = 1311
	ErrSpBadselect                                                  = 1312
	ErrSpBadreturn                                                  = 1313
	ErrSpBadstatement                                               = 1314
	ErrUpdateLogDeprecatedIgnored                                   = 1315
	ErrUpdateLogDeprecatedTranslated                                = 1316
	ErrQueryInterrupted                                             = 1317
	ErrSpWrongNoOfArgs                                              = 1318
	ErrSpCondMismatch                                               = 1319
	ErrSpNoreturn                                                   = 1320
	ErrSpNoreturnend                                                = 1321
	ErrSpBadCursorQuery                                             = 1322
	ErrSpBadCursorSelect                                            = 1323
	ErrSpCursorMismatch                                             = 1324
	ErrSpCursorAlreadyOpen                                          = 1325
	ErrSpCursorNotOpen                                              = 1326
	ErrSpUndeclaredVar                                              = 1327
	ErrSpWrongNoOfFetchArgs                                         = 1328
	ErrSpFetchNoData                                                = 1329
	ErrSpDupParam                                                   = 1330
	ErrSpDupVar                                                     = 1331
	ErrSpDupCond                                                    = 1332
	ErrSpDupCurs                                                    = 1333
	ErrSpCantAlter                                                  = 1334
	ErrSpSubselectNyi                                               = 1335
	ErrStmtNotAllowedInSfOrTrg                                      = 1336
	ErrSpVarcondAfterCurshndlr                                      = 1337
	ErrSpCursorAfterHandler                                         = 1338
	ErrSpCaseNotFound                                               = 1339
	ErrFparserTooBigFile                                            = 1340
	ErrFparserBadHeader                                             = 1341
	ErrFparserEOFInComment                                          = 1342
	ErrFparserErrorInParameter                                      = 1343
	ErrFparserEOFInUnknownParameter                                 = 1344
	ErrViewNoExplain                                                = 1345
	ErrFrmUnknownType                                               = 1346
	ErrWrongObject                                                  = 1347
	ErrNonupdateableColumn                                          = 1348
	ErrViewSelectDerived                                            = 1349
	ErrViewSelectClause                                             = 1350
	ErrViewSelectVariable                                           = 1351
	ErrViewSelectTmptable                                           = 1352
	ErrViewWrongList                                                = 1353
	ErrWarnViewMerge                                                = 1354
	ErrWarnViewWithoutKey                                           = 1355
	ErrViewInvalid                                                  = 1356
	ErrSpNoDropSp                                                   = 1357
	ErrSpGotoInHndlr                                                = 1358
	ErrTrgAlreadyExists                                             = 1359
	ErrTrgDoesNotExist                                              = 1360
	ErrTrgOnViewOrTempTable                                         = 1361
	ErrTrgCantChangeRow                                             = 1362
	ErrTrgNoSuchRowInTrg                                            = 1363
	ErrNoDefaultForField                                            = 1364
	ErrDivisionByZero                                               = 1365
	ErrTruncatedWrongValueForField                                  = 1366
	ErrIllegalValueForType                                          = 1367
	ErrViewNonupdCheck                                              = 1368
	ErrViewCheckFailed                                              = 1369
	ErrProcaccessDenied                                             = 1370
	ErrRelayLogFail                                                 = 1371
	ErrPasswdLength                                                 = 1372
	ErrUnknownTargetBinlog                                          = 1373
	ErrIoErrLogIndexRead                                            = 1374
	ErrBinlogPurgeProhibited                                        = 1375
	ErrFseekFail                                                    = 1376
	ErrBinlogPurgeFatalErr                                          = 1377
	ErrLogInUse                                                     = 1378
	ErrLogPurgeUnknownErr                                           = 1379
	ErrRelayLogInit                                                 = 1380
	ErrNoBinaryLogging                                              = 1381
	ErrReservedSyntax                                               = 1382
	ErrWsasFailed                                                   = 1383
	ErrDiffGroupsProc                                               = 1384
	ErrNoGroupForProc                                               = 1385
	ErrOrderWithProc                                                = 1386
	ErrLoggingProhibitChangingOf                                    = 1387
	ErrNoFileMapping                                                = 1388
	ErrWrongMagic                                                   = 1389
	ErrPsManyParam                                                  = 1390
	ErrKeyPart0                                                     = 1391
	ErrViewChecksum                                                 = 1392
	ErrViewMultiupdate                                              = 1393
	ErrViewNoInsertFieldList                                        = 1394
	ErrViewDeleteMergeView                                          = 1395
	ErrCannotUser                                                   = 1396
	ErrXaerNota                                                     = 1397
	ErrXaerInval                                                    = 1398
	ErrXaerRmfail                                                   = 1399
	ErrXaerOutside                                                  = 1400
	ErrXaerRmerr                                                    = 1401
	ErrXaRbrollback                                                 = 1402
	ErrNonexistingProcGrant                                         = 1403
	ErrProcAutoGrantFail                                            = 1404
	ErrProcAutoRevokeFail                                           = 1405
	ErrDataTooLong                                                  = 1406
	ErrSpBadSQLstate                                                = 1407
	ErrStartup                                                      = 1408
	ErrLoadFromFixedSizeRowsToVar                                   = 1409
	ErrCantCreateUserWithGrant                                      = 1410
	ErrWrongValueForType                                            = 1411
	ErrTableDefChanged                                              = 1412
	ErrSpDupHandler                                                 = 1413
	ErrSpNotVarArg                                                  = 1414
	ErrSpNoRetset                                                   = 1415
	ErrCantCreateGeometryObject                                     = 1416
	ErrFailedRoutineBreakBinlog                                     = 1417
	ErrBinlogUnsafeRoutine                                          = 1418
	ErrBinlogCreateRoutineNeedSuper                                 = 1419
	ErrExecStmtWithOpenCursor                                       = 1420
	ErrStmtHasNoOpenCursor                                          = 1421
	ErrCommitNotAllowedInSfOrTrg                                    = 1422
	ErrNoDefaultForViewField                                        = 1423
	ErrSpNoRecursion                                                = 1424
	ErrTooBigScale                                                  = 1425
	ErrTooBigPrecision                                              = 1426
	ErrMBiggerThanD                                                 = 1427
	ErrWrongLockOfSystemTable                                       = 1428
	ErrConnectToForeignDataSource                                   = 1429
	ErrQueryOnForeignDataSource                                     = 1430
	ErrForeignDataSourceDoesntExist                                 = 1431
	ErrForeignDataStringInvalidCantCreate                           = 1432
	ErrForeignDataStringInvalid                                     = 1433
	ErrCantCreateFederatedTable                                     = 1434
	ErrTrgInWrongSchema                                             = 1435
	ErrStackOverrunNeedMore                                         = 1436
	ErrTooLongBody                                                  = 1437
	ErrWarnCantDropDefaultKeycache                                  = 1438
	ErrTooBigDisplaywidth                                           = 1439
	ErrXaerDupid                                                    = 1440
	ErrDatetimeFunctionOverflow                                     = 1441
	ErrCantUpdateUsedTableInSfOrTrg                                 = 1442
	ErrViewPreventUpdate                                            = 1443
	ErrPsNoRecursion                                                = 1444
	ErrSpCantSetAutocommit                                          = 1445
	ErrMalformedDefiner                                             = 1446
	ErrViewFrmNoUser                                                = 1447
	ErrViewOtherUser                                                = 1448
	ErrNoSuchUser                                                   = 1449
	ErrForbidSchemaChange                                           = 1450
	ErrRowIsReferenced2                                             = 1451
	ErrNoReferencedRow2                                             = 1452
	ErrSpBadVarShadow                                               = 1453
	ErrTrgNoDefiner                                                 = 1454
	ErrOldFileFormat                                                = 1455
	ErrSpRecursionLimit                                             = 1456
	ErrSpProcTableCorrupt                                           = 1457
	ErrSpWrongName                                                  = 1458
	ErrTableNeedsUpgrade                                            = 1459
	ErrSpNoAggregate                                                = 1460
	ErrMaxPreparedStmtCountReached                                  = 1461
	ErrViewRecursive                                                = 1462
	ErrNonGroupingFieldUsed                                         = 1463
	ErrTableCantHandleSpkeys                                        = 1464
	ErrNoTriggersOnSystemSchema                                     = 1465
	ErrRemovedSpaces                                                = 1466
	ErrAutoincReadFailed                                            = 1467
	ErrUsername                                                     = 1468
	ErrHostname                                                     = 1469
	ErrWrongStringLength                                            = 1470
	ErrNonInsertableTable                                           = 1471
	ErrAdminWrongMrgTable                                           = 1472
	ErrTooHighLevelOfNestingForSelect                               = 1473
	ErrNameBecomesEmpty                                             = 1474
	ErrAmbiguousFieldTerm                                           = 1475
	ErrForeignServerExists                                          = 1476
	ErrForeignServerDoesntExist                                     = 1477
	ErrIllegalHaCreateOption                                        = 1478
	ErrPartitionRequiresValues                                      = 1479
	ErrPartitionWrongValues                                         = 1480
	ErrPartitionMaxvalue                                            = 1481
	ErrPartitionSubpartition                                        = 1482
	ErrPartitionSubpartMix                                          = 1483
	ErrPartitionWrongNoPart                                         = 1484
	ErrPartitionWrongNoSubpart                                      = 1485
	ErrWrongExprInPartitionFunc                                     = 1486
	ErrNoConstExprInRangeOrList                                     = 1487
	ErrFieldNotFoundPart                                            = 1488
	ErrListOfFieldsOnlyInHash                                       = 1489
	ErrInconsistentPartitionInfo                                    = 1490
	ErrPartitionFuncNotAllowed                                      = 1491
	ErrPartitionsMustBeDefined                                      = 1492
	ErrRangeNotIncreasing                                           = 1493
	ErrInconsistentTypeOfFunctions                                  = 1494
	ErrMultipleDefConstInListPart                                   = 1495
	ErrPartitionEntry                                               = 1496
	ErrMixHandler                                                   = 1497
	ErrPartitionNotDefined                                          = 1498
	ErrTooManyPartitions                                            = 1499
	ErrSubpartition                                                 = 1500
	ErrCantCreateHandlerFile                                        = 1501
	ErrBlobFieldInPartFunc                                          = 1502
	ErrUniqueKeyNeedAllFieldsInPf                                   = 1503
	ErrNoParts                                                      = 1504
	ErrPartitionMgmtOnNonpartitioned                                = 1505
	ErrForeignKeyOnPartitioned                                      = 1506
	ErrDropPartitionNonExistent                                     = 1507
	ErrDropLastPartition                                            = 1508
	ErrCoalesceOnlyOnHashPartition                                  = 1509
	ErrReorgHashOnlyOnSameNo                                        = 1510
	ErrReorgNoParam                                                 = 1511
	ErrOnlyOnRangeListPartition                                     = 1512
	ErrAddPartitionSubpart                                          = 1513
	ErrAddPartitionNoNewPartition                                   = 1514
	ErrCoalescePartitionNoPartition                                 = 1515
	ErrReorgPartitionNotExist                                       = 1516
	ErrSameNamePartition                                            = 1517
	ErrNoBinlog                                                     = 1518
	ErrConsecutiveReorgPartitions                                   = 1519
	ErrReorgOutsideRange                                            = 1520
	ErrPartitionFunctionFailure                                     = 1521
	ErrPartState                                                    = 1522
	ErrLimitedPartRange                                             = 1523
	ErrPluginIsNotLoaded                                            = 1524
	ErrWrongValue                                                   = 1525
	ErrNoPartitionForGivenValue                                     = 1526
	ErrFilegroupOptionOnlyOnce                                      = 1527
	ErrCreateFilegroupFailed                                        = 1528
	ErrDropFilegroupFailed                                          = 1529
	ErrTablespaceAutoExtend                                         = 1530
	ErrWrongSizeNumber                                              = 1531
	ErrSizeOverflow                                                 = 1532
	ErrAlterFilegroupFailed                                         = 1533
	ErrBinlogRowLoggingFailed                                       = 1534
	ErrBinlogRowWrongTableDef                                       = 1535
	ErrBinlogRowRbrToSbr                                            = 1536
	ErrEventAlreadyExists                                           = 1537
	ErrEventStoreFailed                                             = 1538
	ErrEventDoesNotExist                                            = 1539
	ErrEventCantAlter                                               = 1540
	ErrEventDropFailed                                              = 1541
	ErrEventIntervalNotPositiveOrTooBig                             = 1542
	ErrEventEndsBeforeStarts                                        = 1543
	ErrEventExecTimeInThePast                                       = 1544
	ErrEventOpenTableFailed                                         = 1545
	ErrEventNeitherMExprNorMAt                                      = 1546
	ErrObsoleteColCountDoesntMatchCorrupted                         = 1547
	ErrObsoleteCannotLoadFromTable                                  = 1548
	ErrEventCannotDelete                                            = 1549
	ErrEventCompile                                                 = 1550
	ErrEventSameName                                                = 1551
	ErrEventDataTooLong                                             = 1552
	ErrDropIndexFk                                                  = 1553
	ErrWarnDeprecatedSyntaxWithVer                                  = 1554
	ErrCantWriteLockLogTable                                        = 1555
	ErrCantLockLogTable                                             = 1556
	ErrForeignDuplicateKeyOldUnused                                 = 1557
	ErrColCountDoesntMatchPleaseUpdate                              = 1558
	ErrTempTablePreventsSwitchOutOfRbr                              = 1559
	ErrStoredFunctionPreventsSwitchBinlogFormat                     = 1560
	ErrNdbCantSwitchBinlogFormat                                    = 1561
	ErrPartitionNoTemporary                                         = 1562
	ErrPartitionConstDomain                                         = 1563
	ErrPartitionFunctionIsNotAllowed                                = 1564
	ErrDdlLog                                                       = 1565
	ErrNullInValuesLessThan                                         = 1566
	ErrWrongPartitionName                                           = 1567
	ErrCantChangeTxCharacteristics                                  = 1568
	ErrDupEntryAutoincrementCase                                    = 1569
	ErrEventModifyQueue                                             = 1570
	ErrEventSetVar                                                  = 1571
	ErrPartitionMerge                                               = 1572
	ErrCantActivateLog                                              = 1573
	ErrRbrNotAvailable                                              = 1574
	ErrBase64Decode                                                 = 1575
	ErrEventRecursionForbidden                                      = 1576
	ErrEventsDB                                                     = 1577
	ErrOnlyIntegersAllowed                                          = 1578
	ErrUnsuportedLogEngine                                          = 1579
	ErrBadLogStatement                                              = 1580
	ErrCantRenameLogTable                                           = 1581
	ErrWrongParamcountToNativeFct                                   = 1582
	ErrWrongParametersToNativeFct                                   = 1583
	ErrWrongParametersToStoredFct                                   = 1584
	ErrNativeFctNameCollision                                       = 1585
	ErrDupEntryWithKeyName                                          = 1586
	ErrBinlogPurgeEmFile                                            = 1587
	ErrEventCannotCreateInThePast                                   = 1588
	ErrEventCannotAlterInThePast                                    = 1589
	ErrSlaveIncident                                                = 1590
	ErrNoPartitionForGivenValueSilent                               = 1591
	ErrBinlogUnsafeStatement                                        = 1592
	ErrSlaveFatal                                                   = 1593
	ErrSlaveRelayLogReadFailure                                     = 1594
	ErrSlaveRelayLogWriteFailure                                    = 1595
	ErrSlaveCreateEventFailure                                      = 1596
	ErrSlaveMasterComFailure                                        = 1597
	ErrBinlogLoggingImpossible                                      = 1598
	ErrViewNoCreationCtx                                            = 1599
	ErrViewInvalidCreationCtx                                       = 1600
	ErrSrInvalidCreationCtx                                         = 1601
	ErrTrgCorruptedFile                                             = 1602
	ErrTrgNoCreationCtx                                             = 1603
	ErrTrgInvalidCreationCtx                                        = 1604
	ErrEventInvalidCreationCtx                                      = 1605
	ErrTrgCantOpenTable                                             = 1606
	ErrCantCreateSroutine                                           = 1607
	ErrNeverUsed                                                    = 1608
	ErrNoFormatDescriptionEventBeforeBinlogStatement                = 1609
	ErrSlaveCorruptEvent                                            = 1610
	ErrLoadDataInvalidColumn                                        = 1611
	ErrLogPurgeNoFile                                               = 1612
	ErrXaRbtimeout                                                  = 1613
	ErrXaRbdeadlock                                                 = 1614
	ErrNeedReprepare                                                = 1615
	ErrDelayedNotSupported                                          = 1616
	WarnNoMasterInfo                                                = 1617
	WarnOptionIgnored                                               = 1618
	WarnPluginDeleteBuiltin                                         = 1619
	WarnPluginBusy                                                  = 1620
	ErrVariableIsReadonly                                           = 1621
	ErrWarnEngineTransactionRollback                                = 1622
	ErrSlaveHeartbeatFailure                                        = 1623
	ErrSlaveHeartbeatValueOutOfRange                                = 1624
	ErrNdbReplicationSchema                                         = 1625
	ErrConflictFnParse                                              = 1626
	ErrExceptionsWrite                                              = 1627
	ErrTooLongTableComment                                          = 1628
	ErrTooLongFieldComment                                          = 1629
	ErrFuncInexistentNameCollision                                  = 1630
	ErrDatabaseName                                                 = 1631
	ErrTableName                                                    = 1632
	ErrPartitionName                                                = 1633
	ErrSubpartitionName                                             = 1634
	ErrTemporaryName                                                = 1635
	ErrRenamedName                                                  = 1636
	ErrTooManyConcurrentTrxs                                        = 1637
	WarnNonASCIISeparatorNotImplemented                             = 1638
	ErrDebugSyncTimeout                                             = 1639
	ErrDebugSyncHitLimit                                            = 1640
	ErrDupSignalSet                                                 = 1641
	ErrSignalWarn                                                   = 1642
	ErrSignalNotFound                                               = 1643
	ErrSignalException                                              = 1644
	ErrResignalWithoutActiveHandler                                 = 1645
	ErrSignalBadConditionType                                       = 1646
	WarnCondItemTruncated                                           = 1647
	ErrCondItemTooLong                                              = 1648
	ErrUnknownLocale                                                = 1649
	ErrSlaveIgnoreServerIds                                         = 1650
	ErrQueryCacheDisabled                                           = 1651
	ErrSameNamePartitionField                                       = 1652
	ErrPartitionColumnList                                          = 1653
	ErrWrongTypeColumnValue                                         = 1654
	ErrTooManyPartitionFuncFields                                   = 1655
	ErrMaxvalueInValuesIn                                           = 1656
	ErrTooManyValues                                                = 1657
	ErrRowSinglePartitionField                                      = 1658
	ErrFieldTypeNotAllowedAsPartitionField                          = 1659
	ErrPartitionFieldsTooLong                                       = 1660
	ErrBinlogRowEngineAndStmtEngine                                 = 1661
	ErrBinlogRowModeAndStmtEngine                                   = 1662
	ErrBinlogUnsafeAndStmtEngine                                    = 1663
	ErrBinlogRowInjectionAndStmtEngine                              = 1664
	ErrBinlogStmtModeAndRowEngine                                   = 1665
	ErrBinlogRowInjectionAndStmtMode                                = 1666
	ErrBinlogMultipleEnginesAndSelfLoggingEngine                    = 1667
	ErrBinlogUnsafeLimit                                            = 1668
	ErrBinlogUnsafeInsertDelayed                                    = 1669
	ErrBinlogUnsafeSystemTable                                      = 1670
	ErrBinlogUnsafeAutoincColumns                                   = 1671
	ErrBinlogUnsafeUdf                                              = 1672
	ErrBinlogUnsafeSystemVariable                                   = 1673
	ErrBinlogUnsafeSystemFunction                                   = 1674
	ErrBinlogUnsafeNontransAfterTrans                               = 1675
	ErrMessageAndStatement                                          = 1676
	ErrSlaveConversionFailed                                        = 1677
	ErrSlaveCantCreateConversion                                    = 1678
	ErrInsideTransactionPreventsSwitchBinlogFormat                  = 1679
	ErrPathLength                                                   = 1680
	ErrWarnDeprecatedSyntaxNoReplacement                            = 1681
	ErrWrongNativeTableStructure                                    = 1682
	ErrWrongPerfSchemaUsage                                         = 1683
	ErrWarnISSkippedTable                                           = 1684
	ErrInsideTransactionPreventsSwitchBinlogDirect                  = 1685
	ErrStoredFunctionPreventsSwitchBinlogDirect                     = 1686
	ErrSpatialMustHaveGeomCol                                       = 1687
	ErrTooLongIndexComment                                          = 1688
	ErrLockAborted                                                  = 1689
	ErrDataOutOfRange                                               = 1690
	ErrWrongSpvarTypeInLimit                                        = 1691
	ErrBinlogUnsafeMultipleEnginesAndSelfLoggingEngine              = 1692
	ErrBinlogUnsafeMixedStatement                                   = 1693
	ErrInsideTransactionPreventsSwitchSQLLogBin                     = 1694
	ErrStoredFunctionPreventsSwitchSQLLogBin                        = 1695
	ErrFailedReadFromParFile                                        = 1696
	ErrValuesIsNotIntType                                           = 1697
	ErrAccessDeniedNoPassword                                       = 1698
	ErrSetPasswordAuthPlugin                                        = 1699
	ErrGrantPluginUserExists                                        = 1700
	ErrTruncateIllegalFk                                            = 1701
	ErrPluginIsPermanent                                            = 1702
	ErrSlaveHeartbeatValueOutOfRangeMin                             = 1703
	ErrSlaveHeartbeatValueOutOfRangeMax                             = 1704
	ErrStmtCacheFull                                                = 1705
	ErrMultiUpdateKeyConflict                                       = 1706
	ErrTableNeedsRebuild                                            = 1707
	WarnOptionBelowLimit                                            = 1708
	ErrIndexColumnTooLong                                           = 1709
	ErrErrorInTriggerBody                                           = 1710
	ErrErrorInUnknownTriggerBody                                    = 1711
	ErrIndexCorrupt                                                 = 1712
	ErrUndoRecordTooBig                                             = 1713
	ErrBinlogUnsafeInsertIgnoreSelect                               = 1714
	ErrBinlogUnsafeInsertSelectUpdate                               = 1715
	ErrBinlogUnsafeReplaceSelect                                    = 1716
	ErrBinlogUnsafeCreateIgnoreSelect                               = 1717
	ErrBinlogUnsafeCreateReplaceSelect                              = 1718
	ErrBinlogUnsafeUpdateIgnore                                     = 1719
	ErrPluginNoUninstall                                            = 1720
	ErrPluginNoInstall                                              = 1721
	ErrBinlogUnsafeWriteAutoincSelect                               = 1722
	ErrBinlogUnsafeCreateSelectAutoinc                              = 1723
	ErrBinlogUnsafeInsertTwoKeys                                    = 1724
	ErrTableInFkCheck                                               = 1725
	ErrUnsupportedEngine                                            = 1726
	ErrBinlogUnsafeAutoincNotFirst                                  = 1727
	ErrCannotLoadFromTableV2                                        = 1728
	ErrMasterDelayValueOutOfRange                                   = 1729
	ErrOnlyFdAndRbrEventsAllowedInBinlogStatement                   = 1730
	ErrPartitionExchangeDifferentOption                             = 1731
	ErrPartitionExchangePartTable                                   = 1732
	ErrPartitionExchangeTempTable                                   = 1733
	ErrPartitionInsteadOfSubpartition                               = 1734
	ErrUnknownPartition                                             = 1735
	ErrTablesDifferentMetadata                                      = 1736
	ErrRowDoesNotMatchPartition                                     = 1737
	ErrBinlogCacheSizeGreaterThanMax                                = 1738
	ErrWarnIndexNotApplicable                                       = 1739
	ErrPartitionExchangeForeignKey                                  = 1740
	ErrNoSuchKeyValue                                               = 1741
	ErrRplInfoDataTooLong                                           = 1742
	ErrNetworkReadEventChecksumFailure                              = 1743
	ErrBinlogReadEventChecksumFailure                               = 1744
	ErrBinlogStmtCacheSizeGreaterThanMax                            = 1745
	ErrCantUpdateTableInCreateTableSelect                           = 1746
	ErrPartitionClauseOnNonpartitioned                              = 1747
	ErrRowDoesNotMatchGivenPartitionSet                             = 1748
	ErrNoSuchPartitionunused                                        = 1749
	ErrChangeRplInfoRepositoryFailure                               = 1750
	ErrWarningNotCompleteRollbackWithCreatedTempTable               = 1751
	ErrWarningNotCompleteRollbackWithDroppedTempTable               = 1752
	ErrMtsFeatureIsNotSupported                                     = 1753
	ErrMtsUpdatedDBsGreaterMax                                      = 1754
	ErrMtsCantParallel                                              = 1755
	ErrMtsInconsistentData                                          = 1756
	ErrFulltextNotSupportedWithPartitioning                         = 1757
	ErrDaInvalidConditionNumber                                     = 1758
	ErrInsecurePlainText                                            = 1759
	ErrInsecureChangeMaster                                         = 1760
	ErrForeignDuplicateKeyWithChildInfo                             = 1761
	ErrForeignDuplicateKeyWithoutChildInfo                          = 1762
	ErrSQLthreadWithSecureSlave                                     = 1763
	ErrTableHasNoFt                                                 = 1764
	ErrVariableNotSettableInSfOrTrigger                             = 1765
	ErrVariableNotSettableInTransaction                             = 1766
	ErrGtidNextIsNotInGtidNextList                                  = 1767
	ErrCantChangeGtidNextInTransactionWhenGtidNextListIsNull        = 1768
	ErrSetStatementCannotInvokeFunction                             = 1769
	ErrGtidNextCantBeAutomaticIfGtidNextListIsNonNull               = 1770
	ErrSkippingLoggedTransaction                                    = 1771
	ErrMalformedGtidSetSpecification                                = 1772
	ErrMalformedGtidSetEncoding                                     = 1773
	ErrMalformedGtidSpecification                                   = 1774
	ErrGnoExhausted                                                 = 1775
	ErrBadSlaveAutoPosition                                         = 1776
	ErrAutoPositionRequiresGtidModeOn                               = 1777
	ErrCantDoImplicitCommitInTrxWhenGtidNextIsSet                   = 1778
	ErrGtidMode2Or3RequiresEnforceGtidConsistencyOn                 = 1779
	ErrGtidModeRequiresBinlog                                       = 1780
	ErrCantSetGtidNextToGtidWhenGtidModeIsOff                       = 1781
	ErrCantSetGtidNextToAnonymousWhenGtidModeIsOn                   = 1782
	ErrCantSetGtidNextListToNonNullWhenGtidModeIsOff                = 1783
	ErrFoundGtidEventWhenGtidModeIsOff                              = 1784
	ErrGtidUnsafeNonTransactionalTable                              = 1785
	ErrGtidUnsafeCreateSelect                                       = 1786
	ErrGtidUnsafeCreateDropTemporaryTableInTransaction              = 1787
	ErrGtidModeCanOnlyChangeOneStepAtATime                          = 1788
	ErrMasterHasPurgedRequiredGtids                                 = 1789
	ErrCantSetGtidNextWhenOwningGtid                                = 1790
	ErrUnknownExplainFormat                                         = 1791
	ErrCantExecuteInReadOnlyTransaction                             = 1792
	ErrTooLongTablePartitionComment                                 = 1793
	ErrSlaveConfiguration                                           = 1794
	ErrInnodbFtLimit                                                = 1795
	ErrInnodbNoFtTempTable                                          = 1796
	ErrInnodbFtWrongDocidColumn                                     = 1797
	ErrInnodbFtWrongDocidIndex                                      = 1798
	ErrInnodbOnlineLogTooBig                                        = 1799
	ErrUnknownAlterAlgorithm                                        = 1800
	ErrUnknownAlterLock                                             = 1801
	ErrMtsChangeMasterCantRunWithGaps                               = 1802
	ErrMtsRecoveryFailure                                           = 1803
	ErrMtsResetWorkers                                              = 1804
	ErrColCountDoesntMatchCorruptedV2                               = 1805
	ErrSlaveSilentRetryTransaction                                  = 1806
	ErrDiscardFkChecksRunning                                       = 1807
	ErrTableSchemaMismatch                                          = 1808
	ErrTableInSystemTablespace                                      = 1809
	ErrIoRead                                                       = 1810
	ErrIoWrite                                                      = 1811
	ErrTablespaceMissing                                            = 1812
	ErrTablespaceExists                                             = 1813
	ErrTablespaceDiscarded                                          = 1814
	ErrInternal                                                     = 1815
	ErrInnodbImport                                                 = 1816
	ErrInnodbIndexCorrupt                                           = 1817
	ErrInvalidYearColumnLength                                      = 1818
	ErrNotValidPassword                                             = 1819
	ErrMustChangePassword                                           = 1820
	ErrFkNoIndexChild                                               = 1821
	ErrFkNoIndexParent                                              = 1822
	ErrFkFailAddSystem                                              = 1823
	ErrFkCannotOpenParent                                           = 1824
	ErrFkIncorrectOption                                            = 1825
	ErrFkDupName                                                    = 1826
	ErrPasswordFormat                                               = 1827
	ErrFkColumnCannotDrop                                           = 1828
	ErrFkColumnCannotDropChild                                      = 1829
	ErrFkColumnNotNull                                              = 1830
	ErrDupIndex                                                     = 1831
	ErrFkColumnCannotChange                                         = 1832
	ErrFkColumnCannotChangeChild                                    = 1833
	ErrFkCannotDeleteParent                                         = 1834
	ErrMalformedPacket                                              = 1835
	ErrReadOnlyMode                                                 = 1836
	ErrGtidNextTypeUndefinedGroup                                   = 1837
	ErrVariableNotSettableInSp                                      = 1838
	ErrCantSetGtidPurgedWhenGtidModeIsOff                           = 1839
	ErrCantSetGtidPurgedWhenGtidExecutedIsNotEmpty                  = 1840
	ErrCantSetGtidPurgedWhenOwnedGtidsIsNotEmpty                    = 1841
	ErrGtidPurgedWasChanged                                         = 1842
	ErrGtidExecutedWasChanged                                       = 1843
	ErrBinlogStmtModeAndNoReplTables                                = 1844
	ErrAlterOperationNotSupported                                   = 1845
	ErrAlterOperationNotSupportedReason                             = 1846
	ErrAlterOperationNotSupportedReasonCopy                         = 1847
	ErrAlterOperationNotSupportedReasonPartition                    = 1848
	ErrAlterOperationNotSupportedReasonFkRename                     = 1849
	ErrAlterOperationNotSupportedReasonColumnType                   = 1850
	ErrAlterOperationNotSupportedReasonFkCheck                      = 1851
	ErrAlterOperationNotSupportedReasonIgnore                       = 1852
	ErrAlterOperationNotSupportedReasonNopk                         = 1853
	ErrAlterOperationNotSupportedReasonAutoinc                      = 1854
	ErrAlterOperationNotSupportedReasonHiddenFts                    = 1855
	ErrAlterOperationNotSupportedReasonChangeFts                    = 1856
	ErrAlterOperationNotSupportedReasonFts                          = 1857
	ErrSQLSlaveSkipCounterNotSettableInGtidMode                     = 1858
	ErrDupUnknownInIndex                                            = 1859
	ErrIdentCausesTooLongPath                                       = 1860
	ErrAlterOperationNotSupportedReasonNotNull                      = 1861
	ErrMustChangePasswordLogin                                      = 1862
	ErrRowInWrongPartition                                          = 1863
	ErrErrorLast                                                    = 1863
	ErrMaxExecTimeExceeded                                          = 1907
	ErrInvalidFieldSize                                             = 3013
	ErrIncorrectType                                                = 3064
	ErrInvalidJSONData                                              = 3069
	ErrGeneratedColumnFunctionIsNotAllowed                          = 3102
	ErrUnsupportedAlterInplaceOnVirtualColumn                       = 3103
	ErrWrongFKOptionForGeneratedColumn                              = 3104
	ErrBadGeneratedColumn                                           = 3105
	ErrUnsupportedOnGeneratedColumn                                 = 3106
	ErrGeneratedColumnNonPrior                                      = 3107
	ErrDependentByGeneratedColumn                                   = 3108
	ErrGeneratedColumnRefAutoInc                                    = 3109
	ErrInvalidJSONText                                              = 3140
	ErrInvalidJSONPath                                              = 3143
	ErrInvalidTypeForJSON                                           = 3146
	ErrInvalidJSONPathWildcard                                      = 3149
	ErrInvalidJSONContainsPathType                                  = 3150
	ErrJSONUsedAsKey                                                = 3152
	ErrJSONDocumentNULLKey                                          = 3158
	ErrSecureTransportRequired                                      = 3159
	ErrBadUser                                                      = 3162
	ErrUserAlreadyExists                                            = 3163
	ErrInvalidJSONPathArrayCell                                     = 3165
	ErrInvalidEncryptionOption                                      = 3184
	ErrRoleNotGranted                                               = 3530
	ErrLockAcquireFailAndNoWaitSet                                  = 3572
	ErrWindowNoSuchWindow                                           = 3579
	ErrWindowCircularityInWindowGraph                               = 3580
	ErrWindowNoChildPartitioning                                    = 3581
	ErrWindowNoInherentFrame                                        = 3582
	ErrWindowNoRedefineOrderBy                                      = 3583
	ErrWindowFrameStartIllegal                                      = 3584
	ErrWindowFrameEndIllegal                                        = 3585
	ErrWindowFrameIllegal                                           = 3586
	ErrWindowRangeFrameOrderType                                    = 3587
	ErrWindowRangeFrameTemporalType                                 = 3588
	ErrWindowRangeFrameNumericType                                  = 3589
	ErrWindowRangeBoundNotConstant                                  = 3590
	ErrWindowDuplicateName                                          = 3591
	ErrWindowIllegalOrderBy                                         = 3592
	ErrWindowInvalidWindowFuncUse                                   = 3593
	ErrWindowInvalidWindowFuncAliasUse                              = 3594
	ErrWindowNestedWindowFuncUseInWindowSpec                        = 3595
	ErrWindowRowsIntervalUse                                        = 3596
	ErrWindowNoGroupOrderUnused                                     = 3597
	ErrWindowExplainJSON                                            = 3598
	ErrWindowFunctionIgnoresFrame                                   = 3599
	ErrDataTruncatedFunctionalIndex                                 = 3751
	ErrDataOutOfRangeFunctionalIndex                                = 3752
	ErrFunctionalIndexOnJSONOrGeometryFunction                      = 3753
	ErrFunctionalIndexRefAutoIncrement                              = 3754
	ErrCannotDropColumnFunctionalIndex                              = 3755
	ErrFunctionalIndexPrimaryKey                                    = 3756
	ErrFunctionalIndexOnLob                                         = 3757
	ErrFunctionalIndexFunctionIsNotAllowed                          = 3758
	ErrFulltextFunctionalIndex                                      = 3759
	ErrSpatialFunctionalIndex                                       = 3760
	ErrWrongKeyColumnFunctionalIndex                                = 3761
	ErrFunctionalIndexOnField                                       = 3762
	ErrFKIncompatibleColumns                                        = 3780
	ErrFunctionalIndexRowValueIsNotAllowed                          = 3800
	ErrDependentByFunctionalIndex                                   = 3837
	ErrInvalidJSONValueForFuncIndex                                 = 3903
	ErrJSONValueOutOfRangeForFuncIndex                              = 3904
	ErrFunctionalIndexDataIsTooLong                                 = 3907
	ErrFunctionalIndexNotApplicable                                 = 3909

	// MariaDB errors.
	ErrOnlyOneDefaultPartionAllowed         = 4030
	ErrWrongPartitionTypeExpectedSystemTime = 4113
	ErrSystemVersioningWrongPartitions      = 4128
	ErrSequenceRunOut                       = 4135
	ErrSequenceInvalidData                  = 4136
	ErrSequenceAccessFail                   = 4137
	ErrNotSequence                          = 4138
	ErrUnknownSequence                      = 4139
	ErrWrongInsertIntoSequence              = 4140
	ErrSequenceInvalidTableStructure        = 4141

	// TiDB self-defined errors.
	ErrMemExceedThreshold                  = 8001
	ErrForUpdateCantRetry                  = 8002
	ErrAdminCheckTable                     = 8003
	ErrTxnTooLarge                         = 8004
	ErrWriteConflictInTiDB                 = 8005
	ErrUnsupportedReloadPlugin             = 8018
	ErrUnsupportedReloadPluginVar          = 8019
	ErrTableLocked                         = 8020
	ErrNotExist                            = 8021
	ErrTxnRetryable                        = 8022
	ErrCannotSetNilValue                   = 8023
	ErrInvalidTxn                          = 8024
	ErrEntryTooLarge                       = 8025
	ErrNotImplemented                      = 8026
	ErrInfoSchemaExpired                   = 8027
	ErrInfoSchemaChanged                   = 8028
	ErrBadNumber                           = 8029
	ErrCastAsSignedOverflow                = 8030
	ErrCastNegIntAsUnsigned                = 8031
	ErrInvalidYearFormat                   = 8032
	ErrInvalidYear                         = 8033
	ErrIncorrectDatetimeValue              = 8034
	ErrInvalidTimeFormat                   = 8036
	ErrInvalidWeekModeFormat               = 8037
	ErrFieldGetDefaultFailed               = 8038
	ErrIndexOutBound                       = 8039
	ErrUnsupportedOp                       = 8040
	ErrRowNotFound                         = 8041
	ErrTableStateCantNone                  = 8042
	ErrColumnStateNonPublic                = 8043
	ErrIndexStateCantNone                  = 8044
	ErrInvalidRecordKey                    = 8045
	ErrColumnStateCantNone                 = 8046
	ErrUnsupportedValueForVar              = 8047
	ErrUnsupportedIsolationLevel           = 8048
	ErrLoadPrivilege                       = 8049
	ErrInvalidPrivilegeType                = 8050
	ErrUnknownFieldType                    = 8051
	ErrInvalidSequence                     = 8052
	ErrCantGetValidID                      = 8053
	ErrCantSetToNull                       = 8054
	ErrSnapshotTooOld                      = 8055
	ErrInvalidTableID                      = 8056
	ErrInvalidType                         = 8057
	ErrUnknownAllocatorType                = 8058
	ErrAutoRandReadFailed                  = 8059
	ErrInvalidIncrementAndOffset           = 8060
	ErrWarnOptimizerHintUnsupportedHint    = 8061
	ErrWarnOptimizerHintInvalidToken       = 8062
	ErrWarnMemoryQuotaOverflow             = 8063
	ErrWarnOptimizerHintParseError         = 8064
	ErrWarnOptimizerHintInvalidInteger     = 8065
	ErrUnsupportedSecondArgumentType       = 8066
	ErrInvalidPluginID                     = 8101
	ErrInvalidPluginManifest               = 8102
	ErrInvalidPluginName                   = 8103
	ErrInvalidPluginVersion                = 8104
	ErrDuplicatePlugin                     = 8105
	ErrInvalidPluginSysVarName             = 8106
	ErrRequireVersionCheckFail             = 8107
	ErrUnsupportedType                     = 8108
	ErrAnalyzeMissIndex                    = 8109
	ErrCartesianProductUnsupported         = 8110
	ErrPreparedStmtNotFound                = 8111
	ErrWrongParamCount                     = 8112
	ErrSchemaChanged                       = 8113
	ErrUnknownPlan                         = 8114
	ErrPrepareMulti                        = 8115
	ErrPrepareDDL                          = 8116
	ErrResultIsEmpty                       = 8117
	ErrBuildExecutor                       = 8118
	ErrBatchInsertFail                     = 8119
	ErrGetStartTS                          = 8120
	ErrPrivilegeCheckFail                  = 8121
	ErrInvalidWildCard                     = 8122
	ErrMixOfGroupFuncAndFieldsIncompatible = 8123

	// Error codes used by TiDB ddl package
	ErrUnsupportedDDLOperation        = 8200
	ErrNotOwner                       = 8201
	ErrCantDecodeIndex                = 8202
	ErrInvalidDDLWorker               = 8203
	ErrInvalidDDLJob                  = 8204
	ErrInvalidDDLJobFlag              = 8205
	ErrWaitReorgTimeout               = 8206
	ErrInvalidStoreVersion            = 8207
	ErrUnknownTypeLength              = 8208
	ErrUnknownFractionLength          = 8209
	ErrInvalidDDLState                = 8210
	ErrReorgPanic                     = 8211
	ErrInvalidSplitRegionRanges       = 8212
	ErrInvalidDDLJobVersion           = 8213
	ErrCancelledDDLJob                = 8214
	ErrRepairTable                    = 8215
	ErrInvalidAutoRandom              = 8216
	ErrInvalidHashKeyFlag             = 8217
	ErrInvalidListIndex               = 8218
	ErrInvalidListMetaData            = 8219
	ErrWriteOnSnapshot                = 8220
	ErrInvalidKey                     = 8221
	ErrInvalidIndexKey                = 8222
	ErrDataInConsistent               = 8223
	ErrDDLJobNotFound                 = 8224
	ErrCancelFinishedDDLJob           = 8225
	ErrCannotCancelDDLJob             = 8226
	ErrSequenceUnsupportedTableOption = 8227
	ErrColumnTypeUnsupportedNextValue = 8228

	// TiKV/PD errors.
	ErrPDServerTimeout        = 9001
	ErrTiKVServerTimeout      = 9002
	ErrTiKVServerBusy         = 9003
	ErrResolveLockTimeout     = 9004
	ErrRegionUnavailable      = 9005
	ErrGCTooEarly             = 9006
	ErrWriteConflict          = 9007
	ErrTiKVStoreLimit         = 9008
	ErrPrometheusAddrIsNotSet = 9009
)
