// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: checksum.proto

package tipb

import (
	"fmt"
	io "io"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type ChecksumScanOn int32

const (
	ChecksumScanOn_Table ChecksumScanOn = 0
	ChecksumScanOn_Index ChecksumScanOn = 1
)

var ChecksumScanOn_name = map[int32]string{
	0: "Table",
	1: "Index",
}
var ChecksumScanOn_value = map[string]int32{
	"Table": 0,
	"Index": 1,
}

func (x ChecksumScanOn) Enum() *ChecksumScanOn {
	p := new(ChecksumScanOn)
	*p = x
	return p
}
func (x ChecksumScanOn) String() string {
	return proto.EnumName(ChecksumScanOn_name, int32(x))
}
func (x *ChecksumScanOn) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ChecksumScanOn_value, data, "ChecksumScanOn")
	if err != nil {
		return err
	}
	*x = ChecksumScanOn(value)
	return nil
}
func (ChecksumScanOn) EnumDescriptor() ([]byte, []int) { return fileDescriptorChecksum, []int{0} }

type ChecksumAlgorithm int32

const (
	ChecksumAlgorithm_Crc64_Xor ChecksumAlgorithm = 0
)

var ChecksumAlgorithm_name = map[int32]string{
	0: "Crc64_Xor",
}
var ChecksumAlgorithm_value = map[string]int32{
	"Crc64_Xor": 0,
}

func (x ChecksumAlgorithm) Enum() *ChecksumAlgorithm {
	p := new(ChecksumAlgorithm)
	*p = x
	return p
}
func (x ChecksumAlgorithm) String() string {
	return proto.EnumName(ChecksumAlgorithm_name, int32(x))
}
func (x *ChecksumAlgorithm) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ChecksumAlgorithm_value, data, "ChecksumAlgorithm")
	if err != nil {
		return err
	}
	*x = ChecksumAlgorithm(value)
	return nil
}
func (ChecksumAlgorithm) EnumDescriptor() ([]byte, []int) { return fileDescriptorChecksum, []int{1} }

type ChecksumRequest struct {
	StartTs          uint64            `protobuf:"varint,1,opt,name=start_ts,json=startTs" json:"start_ts"`
	ScanOn           ChecksumScanOn    `protobuf:"varint,2,opt,name=scan_on,json=scanOn,enum=tipb.ChecksumScanOn" json:"scan_on"`
	Algorithm        ChecksumAlgorithm `protobuf:"varint,3,opt,name=algorithm,enum=tipb.ChecksumAlgorithm" json:"algorithm"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ChecksumRequest) Reset()                    { *m = ChecksumRequest{} }
func (m *ChecksumRequest) String() string            { return proto.CompactTextString(m) }
func (*ChecksumRequest) ProtoMessage()               {}
func (*ChecksumRequest) Descriptor() ([]byte, []int) { return fileDescriptorChecksum, []int{0} }

func (m *ChecksumRequest) GetStartTs() uint64 {
	if m != nil {
		return m.StartTs
	}
	return 0
}

func (m *ChecksumRequest) GetScanOn() ChecksumScanOn {
	if m != nil {
		return m.ScanOn
	}
	return ChecksumScanOn_Table
}

func (m *ChecksumRequest) GetAlgorithm() ChecksumAlgorithm {
	if m != nil {
		return m.Algorithm
	}
	return ChecksumAlgorithm_Crc64_Xor
}

type ChecksumResponse struct {
	Checksum         uint64 `protobuf:"varint,1,opt,name=checksum" json:"checksum"`
	TotalKvs         uint64 `protobuf:"varint,2,opt,name=total_kvs,json=totalKvs" json:"total_kvs"`
	TotalBytes       uint64 `protobuf:"varint,3,opt,name=total_bytes,json=totalBytes" json:"total_bytes"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ChecksumResponse) Reset()                    { *m = ChecksumResponse{} }
func (m *ChecksumResponse) String() string            { return proto.CompactTextString(m) }
func (*ChecksumResponse) ProtoMessage()               {}
func (*ChecksumResponse) Descriptor() ([]byte, []int) { return fileDescriptorChecksum, []int{1} }

func (m *ChecksumResponse) GetChecksum() uint64 {
	if m != nil {
		return m.Checksum
	}
	return 0
}

func (m *ChecksumResponse) GetTotalKvs() uint64 {
	if m != nil {
		return m.TotalKvs
	}
	return 0
}

func (m *ChecksumResponse) GetTotalBytes() uint64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func init() {
	proto.RegisterType((*ChecksumRequest)(nil), "tipb.ChecksumRequest")
	proto.RegisterType((*ChecksumResponse)(nil), "tipb.ChecksumResponse")
	proto.RegisterEnum("tipb.ChecksumScanOn", ChecksumScanOn_name, ChecksumScanOn_value)
	proto.RegisterEnum("tipb.ChecksumAlgorithm", ChecksumAlgorithm_name, ChecksumAlgorithm_value)
}
func (m *ChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintChecksum(dAtA, i, uint64(m.StartTs))
	dAtA[i] = 0x10
	i++
	i = encodeVarintChecksum(dAtA, i, uint64(m.ScanOn))
	dAtA[i] = 0x18
	i++
	i = encodeVarintChecksum(dAtA, i, uint64(m.Algorithm))
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintChecksum(dAtA, i, uint64(m.Checksum))
	dAtA[i] = 0x10
	i++
	i = encodeVarintChecksum(dAtA, i, uint64(m.TotalKvs))
	dAtA[i] = 0x18
	i++
	i = encodeVarintChecksum(dAtA, i, uint64(m.TotalBytes))
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintChecksum(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ChecksumRequest) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovChecksum(uint64(m.StartTs))
	n += 1 + sovChecksum(uint64(m.ScanOn))
	n += 1 + sovChecksum(uint64(m.Algorithm))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ChecksumResponse) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovChecksum(uint64(m.Checksum))
	n += 1 + sovChecksum(uint64(m.TotalKvs))
	n += 1 + sovChecksum(uint64(m.TotalBytes))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovChecksum(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozChecksum(x uint64) (n int) {
	return sovChecksum(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ChecksumRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecksum
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChecksumRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChecksumRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTs", wireType)
			}
			m.StartTs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartTs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ScanOn", wireType)
			}
			m.ScanOn = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ScanOn |= (ChecksumScanOn(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Algorithm", wireType)
			}
			m.Algorithm = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Algorithm |= (ChecksumAlgorithm(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecksum(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecksum
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChecksumResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowChecksum
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChecksumResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChecksumResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			m.Checksum = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Checksum |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalKvs", wireType)
			}
			m.TotalKvs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalKvs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipChecksum(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthChecksum
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipChecksum(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowChecksum
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowChecksum
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthChecksum
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowChecksum
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipChecksum(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthChecksum = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowChecksum   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("checksum.proto", fileDescriptorChecksum) }

var fileDescriptorChecksum = []byte{
	// 321 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x90, 0x41, 0x4e, 0xc2, 0x40,
	0x14, 0x86, 0x3b, 0x8a, 0x42, 0x9f, 0x11, 0xeb, 0x04, 0x23, 0x71, 0x51, 0x90, 0x44, 0x83, 0x2c,
	0x6a, 0xa2, 0xc6, 0x8d, 0x2b, 0x61, 0x65, 0x5c, 0x68, 0x90, 0x85, 0xbb, 0x66, 0x3a, 0x4c, 0x4a,
	0x03, 0xcc, 0xd4, 0xbe, 0x81, 0xe8, 0xc6, 0x73, 0x78, 0x00, 0x0f, 0xc3, 0xd2, 0x13, 0x18, 0x83,
	0x17, 0x31, 0x1d, 0x28, 0xa4, 0x71, 0xf7, 0xe6, 0x7f, 0xdf, 0x3f, 0xf3, 0xff, 0x03, 0x65, 0x3e,
	0x10, 0x7c, 0x88, 0x93, 0xb1, 0x17, 0x27, 0x4a, 0x2b, 0x5a, 0xd0, 0x51, 0x1c, 0x1c, 0x55, 0x42,
	0x15, 0x2a, 0x23, 0x9c, 0xa7, 0xd3, 0x62, 0xd7, 0xf8, 0x24, 0xb0, 0xd7, 0x59, 0xe2, 0x5d, 0xf1,
	0x32, 0x11, 0xa8, 0x69, 0x0d, 0x4a, 0xa8, 0x59, 0xa2, 0x7d, 0x8d, 0x55, 0x52, 0x27, 0xcd, 0x42,
	0xbb, 0x30, 0xfb, 0xae, 0x59, 0xdd, 0xa2, 0x51, 0x7b, 0x48, 0x2f, 0xa1, 0x88, 0x9c, 0x49, 0x5f,
	0xc9, 0xea, 0x46, 0x9d, 0x34, 0xcb, 0x17, 0x15, 0x2f, 0x7d, 0xc2, 0xcb, 0x2e, 0x7a, 0xe2, 0x4c,
	0x3e, 0xc8, 0xa5, 0x6b, 0x1b, 0xcd, 0x89, 0xde, 0x80, 0xcd, 0x46, 0xa1, 0x4a, 0x22, 0x3d, 0x18,
	0x57, 0x37, 0x8d, 0xed, 0x30, 0x6f, 0xbb, 0xcd, 0xd6, 0x4b, 0xe7, 0x9a, 0x6f, 0xbc, 0x83, 0xb3,
	0x4e, 0x89, 0xb1, 0x92, 0x28, 0x68, 0x1d, 0x4a, 0x59, 0xd1, 0x5c, 0xcc, 0x95, 0x4a, 0x8f, 0xc1,
	0xd6, 0x4a, 0xb3, 0x91, 0x3f, 0x9c, 0xa2, 0x49, 0xba, 0x42, 0x8c, 0x7c, 0x3f, 0x45, 0x7a, 0x02,
	0x3b, 0x0b, 0x24, 0x78, 0xd3, 0x02, 0x4d, 0xae, 0x0c, 0x02, 0xb3, 0x68, 0xa7, 0x7a, 0xeb, 0x14,
	0xca, 0xf9, 0x72, 0xd4, 0x86, 0xad, 0x1e, 0x0b, 0x46, 0xc2, 0xb1, 0xd2, 0xf1, 0x4e, 0xf6, 0xc5,
	0xab, 0x43, 0x5a, 0x0d, 0xd8, 0xff, 0xd7, 0x86, 0xee, 0x82, 0xdd, 0x49, 0xf8, 0xf5, 0x95, 0xff,
	0xac, 0x12, 0xc7, 0x6a, 0x9f, 0xcd, 0xe6, 0x2e, 0xf9, 0x9a, 0xbb, 0xe4, 0x67, 0xee, 0x92, 0x8f,
	0x5f, 0xd7, 0x82, 0x03, 0xae, 0xc6, 0x5e, 0x1c, 0xc9, 0x90, 0xb3, 0xd8, 0xd3, 0x51, 0x3f, 0x30,
	0xff, 0xf2, 0x48, 0xfe, 0x02, 0x00, 0x00, 0xff, 0xff, 0x40, 0x2d, 0x34, 0x0d, 0xca, 0x01, 0x00,
	0x00,
}
