// Copyright 2020 PingCAP, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// See the License for the specific language governing permissions and
// limitations under the License.

package errno

// MySQLErrName maps error code to MySQL error messages.
var MySQLErrName = map[uint16]string{
	ErrHashchk:                                  "hashchk",
	ErrNisamchk:                                 "isamchk",
	ErrNo:                                       "NO",
	ErrYes:                                      "YES",
	ErrCantCreateFile:                           "Can't create file '%-.200s' (errno: %d - %s)",
	ErrCantCreateTable:                          "Can't create table '%-.200s' (errno: %d)",
	ErrCantCreateDB:                             "Can't create database '%-.192s' (errno: %d)",
	ErrDBCreateExists:                           "Can't create database '%-.192s'; database exists",
	ErrDBDropExists:                             "Can't drop database '%-.192s'; database doesn't exist",
	ErrDBDropDelete:                             "Error dropping database (can't delete '%-.192s', errno: %d)",
	ErrDBDropRmdir:                              "Error dropping database (can't rmdir '%-.192s', errno: %d)",
	ErrCantDeleteFile:                           "Error on delete of '%-.192s' (errno: %d - %s)",
	ErrCantFindSystemRec:                        "Can't read record in system table",
	ErrCantGetStat:                              "Can't get status of '%-.200s' (errno: %d - %s)",
	ErrCantGetWd:                                "Can't get working directory (errno: %d - %s)",
	ErrCantLock:                                 "Can't lock file (errno: %d - %s)",
	ErrCantOpenFile:                             "Can't open file: '%-.200s' (errno: %d - %s)",
	ErrFileNotFound:                             "Can't find file: '%-.200s' (errno: %d - %s)",
	ErrCantReadDir:                              "Can't read dir of '%-.192s' (errno: %d - %s)",
	ErrCantSetWd:                                "Can't change dir to '%-.192s' (errno: %d - %s)",
	ErrCheckread:                                "Record has changed since last read in table '%-.192s'",
	ErrDiskFull:                                 "Disk full (%s); waiting for someone to free some space... (errno: %d - %s)",
	ErrDupKey:                                   "Can't write; duplicate key in table '%-.192s'",
	ErrErrorOnClose:                             "Error on close of '%-.192s' (errno: %d - %s)",
	ErrErrorOnRead:                              "Error reading file '%-.200s' (errno: %d - %s)",
	ErrErrorOnRename:                            "Error on rename of '%-.210s' to '%-.210s' (errno: %d - %s)",
	ErrErrorOnWrite:                             "Error writing file '%-.200s' (errno: %d - %s)",
	ErrFileUsed:                                 "'%-.192s' is locked against change",
	ErrFilsortAbort:                             "Sort aborted",
	ErrFormNotFound:                             "View '%-.192s' doesn't exist for '%-.192s'",
	ErrGetErrno:                                 "Got error %d from storage engine",
	ErrIllegalHa:                                "Table storage engine for '%-.192s' doesn't have this option",
	ErrKeyNotFound:                              "Can't find record in '%-.192s'",
	ErrNotFormFile:                              "Incorrect information in file: '%-.200s'",
	ErrNotKeyFile:                               "Incorrect key file for table '%-.200s'; try to repair it",
	ErrOldKeyFile:                               "Old key file for table '%-.192s'; repair it!",
	ErrOpenAsReadonly:                           "Table '%-.192s' is read only",
	ErrOutofMemory:                              "Out of memory; restart server and try again (needed %d bytes)",
	ErrOutOfSortMemory:                          "Out of sort memory, consider increasing server sort buffer size",
	ErrUnexpectedEOF:                            "Unexpected EOF found when reading file '%-.192s' (errno: %d - %s)",
	ErrConCount:                                 "Too many connections",
	ErrOutOfResources:                           "Out of memory; check if mysqld or some other process uses all available memory; if not, you may have to use 'ulimit' to allow mysqld to use more memory or you can add more swap space",
	ErrBadHost:                                  "Can't get hostname for your address",
	ErrHandshake:                                "Bad handshake",
	ErrDBaccessDenied:                           "Access denied for user '%-.48s'@'%-.64s' to database '%-.192s'",
	ErrAccessDenied:                             "Access denied for user '%-.48s'@'%-.64s' (using password: %s)",
	ErrNoDB:                                     "No database selected",
	ErrUnknownCom:                               "Unknown command",
	ErrBadNull:                                  "Column '%-.192s' cannot be null",
	ErrBadDB:                                    "Unknown database '%-.192s'",
	ErrTableExists:                              "Table '%-.192s' already exists",
	ErrBadTable:                                 "Unknown table '%-.100s'",
	ErrNonUniq:                                  "Column '%-.192s' in %-.192s is ambiguous",
	ErrServerShutdown:                           "Server shutdown in progress",
	ErrBadField:                                 "Unknown column '%-.192s' in '%-.192s'",
	ErrFieldNotInGroupBy:                        "Expression #%d of %s is not in GROUP BY clause and contains nonaggregated column '%s' which is not functionally dependent on columns in GROUP BY clause; this is incompatible with sql_mode=only_full_group_by",
	ErrWrongGroupField:                          "Can't group on '%-.192s'",
	ErrWrongSumSelect:                           "Statement has sum functions and columns in same statement",
	ErrWrongValueCount:                          "Column count doesn't match value count",
	ErrTooLongIdent:                             "Identifier name '%-.100s' is too long",
	ErrDupFieldName:                             "Duplicate column name '%-.192s'",
	ErrDupKeyName:                               "Duplicate key name '%-.192s'",
	ErrDupEntry:                                 "Duplicate entry '%-.64s' for key '%-.192s'",
	ErrWrongFieldSpec:                           "Incorrect column specifier for column '%-.192s'",
	ErrParse:                                    "%s %s",
	ErrEmptyQuery:                               "Query was empty",
	ErrNonuniqTable:                             "Not unique table/alias: '%-.192s'",
	ErrInvalidDefault:                           "Invalid default value for '%-.192s'",
	ErrMultiplePriKey:                           "Multiple primary key defined",
	ErrTooManyKeys:                              "Too many keys specified; max %d keys allowed",
	ErrTooManyKeyParts:                          "Too many key parts specified; max %d parts allowed",
	ErrTooLongKey:                               "Specified key was too long; max key length is %d bytes",
	ErrKeyColumnDoesNotExits:                    "Key column '%-.192s' doesn't exist in table",
	ErrBlobUsedAsKey:                            "BLOB column '%-.192s' can't be used in key specification with the used table type",
	ErrTooBigFieldlength:                        "Column length too big for column '%-.192s' (max = %d); use BLOB or TEXT instead",
	ErrWrongAutoKey:                             "Incorrect table definition; there can be only one auto column and it must be defined as a key",
	ErrReady:                                    "%s: ready for connections.\nVersion: '%s'  socket: '%s'  port: %d",
	ErrNormalShutdown:                           "%s: Normal shutdown\n",
	ErrGotSignal:                                "%s: Got signal %d. Aborting!\n",
	ErrShutdownComplete:                         "%s: Shutdown complete\n",
	ErrForcingClose:                             "%s: Forcing close of thread %d  user: '%-.48s'\n",
	ErrIpsock:                                   "Can't create IP socket",
	ErrNoSuchIndex:                              "Table '%-.192s' has no index like the one used in CREATE INDEX; recreate the table",
	ErrWrongFieldTerminators:                    "Field separator argument is not what is expected; check the manual",
	ErrBlobsAndNoTerminated:                     "You can't use fixed rowlength with BLOBs; please use 'fields terminated by'",
	ErrTextFileNotReadable:                      "The file '%-.128s' must be in the database directory or be readable by all",
	ErrFileExists:                               "File '%-.200s' already exists",
	ErrLoadInfo:                                 "Records: %d  Deleted: %d  Skipped: %d  Warnings: %d",
	ErrAlterInfo:                                "Records: %d  Duplicates: %d",
	ErrWrongSubKey:                              "Incorrect prefix key; the used key part isn't a string, the used length is longer than the key part, or the storage engine doesn't support unique prefix keys",
	ErrCantRemoveAllFields:                      "You can't delete all columns with ALTER TABLE; use DROP TABLE instead",
	ErrCantDropFieldOrKey:                       "Can't DROP '%-.192s'; check that column/key exists",
	ErrInsertInfo:                               "Records: %d  Duplicates: %d  Warnings: %d",
	ErrUpdateTableUsed:                          "You can't specify target table '%-.192s' for update in FROM clause",
	ErrNoSuchThread:                             "Unknown thread id: %d",
	ErrKillDenied:                               "You are not owner of thread %d",
	ErrNoTablesUsed:                             "No tables used",
	ErrTooBigSet:                                "Too many strings for column %-.192s and SET",
	ErrNoUniqueLogFile:                          "Can't generate a unique log-filename %-.200s.(1-999)\n",
	ErrTableNotLockedForWrite:                   "Table '%-.192s' was locked with a READ lock and can't be updated",
	ErrTableNotLocked:                           "Table '%-.192s' was not locked with LOCK TABLES",
	ErrBlobCantHaveDefault:                      "BLOB/TEXT/JSON column '%-.192s' can't have a default value",
	ErrWrongDBName:                              "Incorrect database name '%-.100s'",
	ErrWrongTableName:                           "Incorrect table name '%-.100s'",
	ErrTooBigSelect:                             "The SELECT would examine more than MAXJOINSIZE rows; check your WHERE and use SET SQLBIGSELECTS=1 or SET MAXJOINSIZE=# if the SELECT is okay",
	ErrUnknown:                                  "Unknown error",
	ErrUnknownProcedure:                         "Unknown procedure '%-.192s'",
	ErrWrongParamcountToProcedure:               "Incorrect parameter count to procedure '%-.192s'",
	ErrWrongParametersToProcedure:               "Incorrect parameters to procedure '%-.192s'",
	ErrUnknownTable:                             "Unknown table '%-.192s' in %-.32s",
	ErrFieldSpecifiedTwice:                      "Column '%-.192s' specified twice",
	ErrInvalidGroupFuncUse:                      "Invalid use of group function",
	ErrUnsupportedExtension:                     "Table '%-.192s' uses an extension that doesn't exist in this MySQL version",
	ErrTableMustHaveColumns:                     "A table must have at least 1 column",
	ErrRecordFileFull:                           "The table '%-.192s' is full",
	ErrUnknownCharacterSet:                      "Unknown character set: '%-.64s'",
	ErrTooManyTables:                            "Too many tables; MySQL can only use %d tables in a join",
	ErrTooManyFields:                            "Too many columns",
	ErrTooBigRowsize:                            "Row size too large. The maximum row size for the used table type, not counting BLOBs, is %d. This includes storage overhead, check the manual. You have to change some columns to TEXT or BLOBs",
	ErrStackOverrun:                             "Thread stack overrun:  Used: %d of a %d stack.  Use 'mysqld --threadStack=#' to specify a bigger stack if needed",
	ErrWrongOuterJoin:                           "Cross dependency found in OUTER JOIN; examine your ON conditions",
	ErrNullColumnInIndex:                        "Table handler doesn't support NULL in given index. Please change column '%-.192s' to be NOT NULL or use another handler",
	ErrCantFindUdf:                              "Can't load function '%-.192s'",
	ErrCantInitializeUdf:                        "Can't initialize function '%-.192s'; %-.80s",
	ErrUdfNoPaths:                               "No paths allowed for shared library",
	ErrUdfExists:                                "Function '%-.192s' already exists",
	ErrCantOpenLibrary:                          "Can't open shared library '%-.192s' (errno: %d %-.128s)",
	ErrCantFindDlEntry:                          "Can't find symbol '%-.128s' in library",
	ErrFunctionNotDefined:                       "Function '%-.192s' is not defined",
	ErrHostIsBlocked:                            "Host '%-.64s' is blocked because of many connection errors; unblock with 'mysqladmin flush-hosts'",
	ErrHostNotPrivileged:                        "Host '%-.64s' is not allowed to connect to this MySQL server",
	ErrPasswordAnonymousUser:                    "You are using MySQL as an anonymous user and anonymous users are not allowed to change passwords",
	ErrPasswordNotAllowed:                       "You must have privileges to update tables in the mysql database to be able to change passwords for others",
	ErrPasswordNoMatch:                          "Can't find any matching row in the user table",
	ErrUpdateInfo:                               "Rows matched: %d  Changed: %d  Warnings: %d",
	ErrCantCreateThread:                         "Can't create a new thread (errno %d); if you are not out of available memory, you can consult the manual for a possible OS-dependent bug",
	ErrWrongValueCountOnRow:                     "Column count doesn't match value count at row %d",
	ErrCantReopenTable:                          "Can't reopen table: '%-.192s'",
	ErrInvalidUseOfNull:                         "Invalid use of NULL value",
	ErrRegexp:                                   "Got error '%-.64s' from regexp",
	ErrMixOfGroupFuncAndFields:                  "Mixing of GROUP columns (MIN(),MAX(),COUNT(),...) with no GROUP columns is illegal if there is no GROUP BY clause",
	ErrNonexistingGrant:                         "There is no such grant defined for user '%-.48s' on host '%-.64s'",
	ErrTableaccessDenied:                        "%-.128s command denied to user '%-.48s'@'%-.64s' for table '%-.64s'",
	ErrColumnaccessDenied:                       "%-.16s command denied to user '%-.48s'@'%-.64s' for column '%-.192s' in table '%-.192s'",
	ErrIllegalGrantForTable:                     "Illegal GRANT/REVOKE command; please consult the manual to see which privileges can be used",
	ErrGrantWrongHostOrUser:                     "The host or user argument to GRANT is too long",
	ErrNoSuchTable:                              "Table '%-.192s.%-.192s' doesn't exist",
	ErrNonexistingTableGrant:                    "There is no such grant defined for user '%-.48s' on host '%-.64s' on table '%-.192s'",
	ErrNotAllowedCommand:                        "The used command is not allowed with this MySQL version",
	ErrSyntax:                                   "You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use",
	ErrDelayedCantChangeLock:                    "Delayed insert thread couldn't get requested lock for table %-.192s",
	ErrTooManyDelayedThreads:                    "Too many delayed threads in use",
	ErrAbortingConnection:                       "Aborted connection %d to db: '%-.192s' user: '%-.48s' (%-.64s)",
	ErrNetPacketTooLarge:                        "Got a packet bigger than 'maxAllowedPacket' bytes",
	ErrNetReadErrorFromPipe:                     "Got a read error from the connection pipe",
	ErrNetFcntl:                                 "Got an error from fcntl()",
	ErrNetPacketsOutOfOrder:                     "Got packets out of order",
	ErrNetUncompress:                            "Couldn't uncompress communication packet",
	ErrNetRead:                                  "Got an error reading communication packets",
	ErrNetReadInterrupted:                       "Got timeout reading communication packets",
	ErrNetErrorOnWrite:                          "Got an error writing communication packets",
	ErrNetWriteInterrupted:                      "Got timeout writing communication packets",
	ErrTooLongString:                            "Result string is longer than 'maxAllowedPacket' bytes",
	ErrTableCantHandleBlob:                      "The used table type doesn't support BLOB/TEXT columns",
	ErrTableCantHandleAutoIncrement:             "The used table type doesn't support AUTOINCREMENT columns",
	ErrDelayedInsertTableLocked:                 "INSERT DELAYED can't be used with table '%-.192s' because it is locked with LOCK TABLES",
	ErrWrongColumnName:                          "Incorrect column name '%-.100s'",
	ErrWrongKeyColumn:                           "The used storage engine can't index column '%-.192s'",
	ErrWrongMrgTable:                            "Unable to open underlying table which is differently defined or of non-MyISAM type or doesn't exist",
	ErrDupUnique:                                "Can't write, because of unique constraint, to table '%-.192s'",
	ErrBlobKeyWithoutLength:                     "BLOB/TEXT column '%-.192s' used in key specification without a key length",
	ErrPrimaryCantHaveNull:                      "All parts of a PRIMARY KEY must be NOT NULL; if you need NULL in a key, use UNIQUE instead",
	ErrTooManyRows:                              "Result consisted of more than one row",
	ErrRequiresPrimaryKey:                       "This table type requires a primary key",
	ErrNoRaidCompiled:                           "This version of MySQL is not compiled with RAID support",
	ErrUpdateWithoutKeyInSafeMode:               "You are using safe update mode and you tried to update a table without a WHERE that uses a KEY column",
	ErrKeyDoesNotExist:                          "Key '%-.192s' doesn't exist in table '%-.192s'",
	ErrCheckNoSuchTable:                         "Can't open table",
	ErrCheckNotImplemented:                      "The storage engine for the table doesn't support %s",
	ErrCantDoThisDuringAnTransaction:            "You are not allowed to execute this command in a transaction",
	ErrErrorDuringCommit:                        "Got error %d during COMMIT",
	ErrErrorDuringRollback:                      "Got error %d during ROLLBACK",
	ErrErrorDuringFlushLogs:                     "Got error %d during FLUSHLOGS",
	ErrErrorDuringCheckpoint:                    "Got error %d during CHECKPOINT",
	ErrNewAbortingConnection:                    "Aborted connection %d to db: '%-.192s' user: '%-.48s' host: '%-.64s' (%-.64s)",
	ErrDumpNotImplemented:                       "The storage engine for the table does not support binary table dump",
	ErrFlushMasterBinlogClosed:                  "Binlog closed, cannot RESET MASTER",
	ErrIndexRebuild:                             "Failed rebuilding the index of  dumped table '%-.192s'",
	ErrMaster:                                   "Error from master: '%-.64s'",
	ErrMasterNetRead:                            "Net error reading from master",
	ErrMasterNetWrite:                           "Net error writing to master",
	ErrFtMatchingKeyNotFound:                    "Can't find FULLTEXT index matching the column list",
	ErrLockOrActiveTransaction:                  "Can't execute the given command because you have active locked tables or an active transaction",
	ErrUnknownSystemVariable:                    "Unknown system variable '%-.64s'",
	ErrCrashedOnUsage:                           "Table '%-.192s' is marked as crashed and should be repaired",
	ErrCrashedOnRepair:                          "Table '%-.192s' is marked as crashed and last (automatic?) repair failed",
	ErrWarningNotCompleteRollback:               "Some non-transactional changed tables couldn't be rolled back",
	ErrTransCacheFull:                           "Multi-statement transaction required more than 'maxBinlogCacheSize' bytes of storage; increase this mysqld variable and try again",
	ErrSlaveMustStop:                            "This operation cannot be performed with a running slave; run STOP SLAVE first",
	ErrSlaveNotRunning:                          "This operation requires a running slave; configure slave and do START SLAVE",
	ErrBadSlave:                                 "The server is not configured as slave; fix in config file or with CHANGE MASTER TO",
	ErrMasterInfo:                               "Could not initialize master info structure; more error messages can be found in the MySQL error log",
	ErrSlaveThread:                              "Could not create slave thread; check system resources",
	ErrTooManyUserConnections:                   "User %-.64s already has more than 'maxUserConnections' active connections",
	ErrSetConstantsOnly:                         "You may only use constant expressions with SET",
	ErrLockWaitTimeout:                          "Lock wait timeout exceeded; try restarting transaction",
	ErrLockTableFull:                            "The total number of locks exceeds the lock table size",
	ErrReadOnlyTransaction:                      "Update locks cannot be acquired during a READ UNCOMMITTED transaction",
	ErrDropDBWithReadLock:                       "DROP DATABASE not allowed while thread is holding global read lock",
	ErrCreateDBWithReadLock:                     "CREATE DATABASE not allowed while thread is holding global read lock",
	ErrWrongArguments:                           "Incorrect arguments to %s",
	ErrNoPermissionToCreateUser:                 "'%-.48s'@'%-.64s' is not allowed to create new users",
	ErrUnionTablesInDifferentDir:                "Incorrect table definition; all MERGE tables must be in the same database",
	ErrLockDeadlock:                             "Deadlock found when trying to get lock; try restarting transaction",
	ErrTableCantHandleFt:                        "The used table type doesn't support FULLTEXT indexes",
	ErrCannotAddForeign:                         "Cannot add foreign key constraint",
	ErrNoReferencedRow:                          "Cannot add or update a child row: a foreign key constraint fails",
	ErrRowIsReferenced:                          "Cannot delete or update a parent row: a foreign key constraint fails",
	ErrConnectToMaster:                          "Error connecting to master: %-.128s",
	ErrQueryOnMaster:                            "Error running query on master: %-.128s",
	ErrErrorWhenExecutingCommand:                "Error when executing command %s: %-.128s",
	ErrWrongUsage:                               "Incorrect usage of %s and %s",
	ErrWrongNumberOfColumnsInSelect:             "The used SELECT statements have a different number of columns",
	ErrCantUpdateWithReadlock:                   "Can't execute the query because you have a conflicting read lock",
	ErrMixingNotAllowed:                         "Mixing of transactional and non-transactional tables is disabled",
	ErrDupArgument:                              "Option '%s' used twice in statement",
	ErrUserLimitReached:                         "User '%-.64s' has exceeded the '%s' resource (current value: %d)",
	ErrSpecificAccessDenied:                     "Access denied; you need (at least one of) the %-.128s privilege(s) for this operation",
	ErrLocalVariable:                            "Variable '%-.64s' is a SESSION variable and can't be used with SET GLOBAL",
	ErrGlobalVariable:                           "Variable '%-.64s' is a GLOBAL variable and should be set with SET GLOBAL",
	ErrNoDefault:                                "Variable '%-.64s' doesn't have a default value",
	ErrWrongValueForVar:                         "Variable '%-.64s' can't be set to the value of '%-.200s'",
	ErrWrongTypeForVar:                          "Incorrect argument type to variable '%-.64s'",
	ErrVarCantBeRead:                            "Variable '%-.64s' can only be set, not read",
	ErrCantUseOptionHere:                        "Incorrect usage/placement of '%s'",
	ErrNotSupportedYet:                          "This version of TiDB doesn't yet support '%s'",
	ErrMasterFatalErrorReadingBinlog:            "Got fatal error %d from master when reading data from binary log: '%-.320s'",
	ErrSlaveIgnoredTable:                        "Slave SQL thread ignored the query because of replicate-*-table rules",
	ErrIncorrectGlobalLocalVar:                  "Variable '%-.192s' is a %s variable",
	ErrWrongFkDef:                               "Incorrect foreign key definition for '%-.192s': %s",
	ErrKeyRefDoNotMatchTableRef:                 "Key reference and table reference don't match",
	ErrOperandColumns:                           "Operand should contain %d column(s)",
	ErrSubqueryNo1Row:                           "Subquery returns more than 1 row",
	ErrUnknownStmtHandler:                       "Unknown prepared statement handler (%.*s) given to %s",
	ErrCorruptHelpDB:                            "Help database is corrupt or does not exist",
	ErrCyclicReference:                          "Cyclic reference on subqueries",
	ErrAutoConvert:                              "Converting column '%s' from %s to %s",
	ErrIllegalReference:                         "Reference '%-.64s' not supported (%s)",
	ErrDerivedMustHaveAlias:                     "Every derived table must have its own alias",
	ErrSelectReduced:                            "Select %d was reduced during optimization",
	ErrTablenameNotAllowedHere:                  "Table '%s' from one of the %ss cannot be used in %s",
	ErrNotSupportedAuthMode:                     "Client does not support authentication protocol requested by server; consider upgrading MySQL client",
	ErrSpatialCantHaveNull:                      "All parts of a SPATIAL index must be NOT NULL",
	ErrCollationCharsetMismatch:                 "COLLATION '%s' is not valid for CHARACTER SET '%s'",
	ErrSlaveWasRunning:                          "Slave is already running",
	ErrSlaveWasNotRunning:                       "Slave already has been stopped",
	ErrTooBigForUncompress:                      "Uncompressed data size too large; the maximum size is %d (probably, length of uncompressed data was corrupted)",
	ErrZlibZMem:                                 "ZLIB: Not enough memory",
	ErrZlibZBuf:                                 "ZLIB: Not enough room in the output buffer (probably, length of uncompressed data was corrupted)",
	ErrZlibZData:                                "ZLIB: Input data corrupted",
	ErrCutValueGroupConcat:                      "Some rows were cut by GROUPCONCAT(%s)",
	ErrWarnTooFewRecords:                        "Row %d doesn't contain data for all columns",
	ErrWarnTooManyRecords:                       "Row %d was truncated; it contained more data than there were input columns",
	ErrWarnNullToNotnull:                        "Column set to default value; NULL supplied to NOT NULL column '%s' at row %d",
	ErrWarnDataOutOfRange:                       "Out of range value for column '%s' at row %d",
	WarnDataTruncated:                           "Data truncated for column '%s' at row %d",
	ErrWarnUsingOtherHandler:                    "Using storage engine %s for table '%s'",
	ErrCantAggregate2collations:                 "Illegal mix of collations (%s,%s) and (%s,%s) for operation '%s'",
	ErrDropUser:                                 "Cannot drop one or more of the requested users",
	ErrRevokeGrants:                             "Can't revoke all privileges for one or more of the requested users",
	ErrCantAggregate3collations:                 "Illegal mix of collations (%s,%s), (%s,%s), (%s,%s) for operation '%s'",
	ErrCantAggregateNcollations:                 "Illegal mix of collations for operation '%s'",
	ErrVariableIsNotStruct:                      "Variable '%-.64s' is not a variable component (can't be used as XXXX.variableName)",
	ErrUnknownCollation:                         "Unknown collation: '%-.64s'",
	ErrSlaveIgnoredSslParams:                    "SSL parameters in CHANGE MASTER are ignored because this MySQL slave was compiled without SSL support; they can be used later if MySQL slave with SSL is started",
	ErrServerIsInSecureAuthMode:                 "Server is running in --secure-auth mode, but '%s'@'%s' has a password in the old format; please change the password to the new format",
	ErrWarnFieldResolved:                        "Field or reference '%-.192s%s%-.192s%s%-.192s' of SELECT #%d was resolved in SELECT #%d",
	ErrBadSlaveUntilCond:                        "Incorrect parameter or combination of parameters for START SLAVE UNTIL",
	ErrMissingSkipSlave:                         "It is recommended to use --skip-slave-start when doing step-by-step replication with START SLAVE UNTIL; otherwise, you will get problems if you get an unexpected slave's mysqld restart",
	ErrUntilCondIgnored:                         "SQL thread is not to be started so UNTIL options are ignored",
	ErrWrongNameForIndex:                        "Incorrect index name '%-.100s'",
	ErrWrongNameForCatalog:                      "Incorrect catalog name '%-.100s'",
	ErrWarnQcResize:                             "Query cache failed to set size %d; new query cache size is %d",
	ErrBadFtColumn:                              "Column '%-.192s' cannot be part of FULLTEXT index",
	ErrUnknownKeyCache:                          "Unknown key cache '%-.100s'",
	ErrWarnHostnameWontWork:                     "MySQL is started in --skip-name-resolve mode; you must restart it without this switch for this grant to work",
	ErrUnknownStorageEngine:                     "Unknown storage engine '%s'",
	ErrWarnDeprecatedSyntax:                     "'%s' is deprecated and will be removed in a future release. Please use %s instead",
	ErrNonUpdatableTable:                        "The target table %-.100s of the %s is not updatable",
	ErrFeatureDisabled:                          "The '%s' feature is disabled; you need MySQL built with '%s' to have it working",
	ErrOptionPreventsStatement:                  "The MySQL server is running with the %s option so it cannot execute this statement",
	ErrDuplicatedValueInType:                    "Column '%-.100s' has duplicated value '%-.64s' in %s",
	ErrTruncatedWrongValue:                      "Truncated incorrect %-.64s value: '%-.128s'",
	ErrTooMuchAutoTimestampCols:                 "Incorrect table definition; there can be only one TIMESTAMP column with CURRENTTIMESTAMP in DEFAULT or ON UPDATE clause",
	ErrInvalidOnUpdate:                          "Invalid ON UPDATE clause for '%-.192s' column",
	ErrUnsupportedPs:                            "This command is not supported in the prepared statement protocol yet",
	ErrGetErrmsg:                                "Got error %d '%-.100s' from %s",
	ErrGetTemporaryErrmsg:                       "Got temporary error %d '%-.100s' from %s",
	ErrUnknownTimeZone:                          "Unknown or incorrect time zone: '%-.64s'",
	ErrWarnInvalidTimestamp:                     "Invalid TIMESTAMP value in column '%s' at row %d",
	ErrInvalidCharacterString:                   "Invalid %s character string: '%.64s'",
	ErrWarnAllowedPacketOverflowed:              "Result of %s() was larger than max_allowed_packet (%d) - truncated",
	ErrConflictingDeclarations:                  "Conflicting declarations: '%s%s' and '%s%s'",
	ErrSpNoRecursiveCreate:                      "Can't create a %s from within another stored routine",
	ErrSpAlreadyExists:                          "%s %s already exists",
	ErrSpDoesNotExist:                           "%s %s does not exist",
	ErrSpDropFailed:                             "Failed to DROP %s %s",
	ErrSpStoreFailed:                            "Failed to CREATE %s %s",
	ErrSpLilabelMismatch:                        "%s with no matching label: %s",
	ErrSpLabelRedefine:                          "Redefining label %s",
	ErrSpLabelMismatch:                          "End-label %s without match",
	ErrSpUninitVar:                              "Referring to uninitialized variable %s",
	ErrSpBadselect:                              "PROCEDURE %s can't return a result set in the given context",
	ErrSpBadreturn:                              "RETURN is only allowed in a FUNCTION",
	ErrSpBadstatement:                           "%s is not allowed in stored procedures",
	ErrUpdateLogDeprecatedIgnored:               "The update log is deprecated and replaced by the binary log; SET SQLLOGUPDATE has been ignored.",
	ErrUpdateLogDeprecatedTranslated:            "The update log is deprecated and replaced by the binary log; SET SQLLOGUPDATE has been translated to SET SQLLOGBIN.",
	ErrQueryInterrupted:                         "Query execution was interrupted",
	ErrSpWrongNoOfArgs:                          "Incorrect number of arguments for %s %s; expected %d, got %d",
	ErrSpCondMismatch:                           "Undefined CONDITION: %s",
	ErrSpNoreturn:                               "No RETURN found in FUNCTION %s",
	ErrSpNoreturnend:                            "FUNCTION %s ended without RETURN",
	ErrSpBadCursorQuery:                         "Cursor statement must be a SELECT",
	ErrSpBadCursorSelect:                        "Cursor SELECT must not have INTO",
	ErrSpCursorMismatch:                         "Undefined CURSOR: %s",
	ErrSpCursorAlreadyOpen:                      "Cursor is already open",
	ErrSpCursorNotOpen:                          "Cursor is not open",
	ErrSpUndeclaredVar:                          "Undeclared variable: %s",
	ErrSpWrongNoOfFetchArgs:                     "Incorrect number of FETCH variables",
	ErrSpFetchNoData:                            "No data - zero rows fetched, selected, or processed",
	ErrSpDupParam:                               "Duplicate parameter: %s",
	ErrSpDupVar:                                 "Duplicate variable: %s",
	ErrSpDupCond:                                "Duplicate condition: %s",
	ErrSpDupCurs:                                "Duplicate cursor: %s",
	ErrSpCantAlter:                              "Failed to ALTER %s %s",
	ErrSpSubselectNyi:                           "Subquery value not supported",
	ErrStmtNotAllowedInSfOrTrg:                  "%s is not allowed in stored function or trigger",
	ErrSpVarcondAfterCurshndlr:                  "Variable or condition declaration after cursor or handler declaration",
	ErrSpCursorAfterHandler:                     "Cursor declaration after handler declaration",
	ErrSpCaseNotFound:                           "Case not found for CASE statement",
	ErrFparserTooBigFile:                        "Configuration file '%-.192s' is too big",
	ErrFparserBadHeader:                         "Malformed file type header in file '%-.192s'",
	ErrFparserEOFInComment:                      "Unexpected end of file while parsing comment '%-.200s'",
	ErrFparserErrorInParameter:                  "Error while parsing parameter '%-.192s' (line: '%-.192s')",
	ErrFparserEOFInUnknownParameter:             "Unexpected end of file while skipping unknown parameter '%-.192s'",
	ErrViewNoExplain:                            "EXPLAIN/SHOW can not be issued; lacking privileges for underlying table",
	ErrFrmUnknownType:                           "File '%-.192s' has unknown type '%-.64s' in its header",
	ErrWrongObject:                              "'%-.192s.%-.192s' is not %s",
	ErrNonupdateableColumn:                      "Column '%-.192s' is not updatable",
	ErrViewSelectDerived:                        "View's SELECT contains a subquery in the FROM clause",
	ErrViewSelectClause:                         "View's SELECT contains a '%s' clause",
	ErrViewSelectVariable:                       "View's SELECT contains a variable or parameter",
	ErrViewSelectTmptable:                       "View's SELECT refers to a temporary table '%-.192s'",
	ErrViewWrongList:                            "View's SELECT and view's field list have different column counts",
	ErrWarnViewMerge:                            "View merge algorithm can't be used here for now (assumed undefined algorithm)",
	ErrWarnViewWithoutKey:                       "View being updated does not have complete key of underlying table in it",
	ErrViewInvalid:                              "View '%-.192s.%-.192s' references invalid table(s) or column(s) or function(s) or definer/invoker of view lack rights to use them",
	ErrSpNoDropSp:                               "Can't drop or alter a %s from within another stored routine",
	ErrSpGotoInHndlr:                            "GOTO is not allowed in a stored procedure handler",
	ErrTrgAlreadyExists:                         "Trigger already exists",
	ErrTrgDoesNotExist:                          "Trigger does not exist",
	ErrTrgOnViewOrTempTable:                     "Trigger's '%-.192s' is view or temporary table",
	ErrTrgCantChangeRow:                         "Updating of %s row is not allowed in %strigger",
	ErrTrgNoSuchRowInTrg:                        "There is no %s row in %s trigger",
	ErrNoDefaultForField:                        "Field '%-.192s' doesn't have a default value",
	ErrDivisionByZero:                           "Division by 0",
	ErrTruncatedWrongValueForField:              "Incorrect %-.32s value: '%-.128s' for column '%.192s' at row %d",
	ErrIllegalValueForType:                      "Illegal %s '%-.192s' value found during parsing",
	ErrViewNonupdCheck:                          "CHECK OPTION on non-updatable view '%-.192s.%-.192s'",
	ErrViewCheckFailed:                          "CHECK OPTION failed '%-.192s.%-.192s'",
	ErrProcaccessDenied:                         "%-.16s command denied to user '%-.48s'@'%-.64s' for routine '%-.192s'",
	ErrRelayLogFail:                             "Failed purging old relay logs: %s",
	ErrPasswdLength:                             "Password hash should be a %d-digit hexadecimal number",
	ErrUnknownTargetBinlog:                      "Target log not found in binlog index",
	ErrIoErrLogIndexRead:                        "I/O error reading log index file",
	ErrBinlogPurgeProhibited:                    "Server configuration does not permit binlog purge",
	ErrFseekFail:                                "Failed on fseek()",
	ErrBinlogPurgeFatalErr:                      "Fatal error during log purge",
	ErrLogInUse:                                 "A purgeable log is in use, will not purge",
	ErrLogPurgeUnknownErr:                       "Unknown error during log purge",
	ErrRelayLogInit:                             "Failed initializing relay log position: %s",
	ErrNoBinaryLogging:                          "You are not using binary logging",
	ErrReservedSyntax:                           "The '%-.64s' syntax is reserved for purposes internal to the MySQL server",
	ErrWsasFailed:                               "WSAStartup Failed",
	ErrDiffGroupsProc:                           "Can't handle procedures with different groups yet",
	ErrNoGroupForProc:                           "Select must have a group with this procedure",
	ErrOrderWithProc:                            "Can't use ORDER clause with this procedure",
	ErrLoggingProhibitChangingOf:                "Binary logging and replication forbid changing the global server %s",
	ErrNoFileMapping:                            "Can't map file: %-.200s, errno: %d",
	ErrWrongMagic:                               "Wrong magic in %-.64s",
	ErrPsManyParam:                              "Prepared statement contains too many placeholders",
	ErrKeyPart0:                                 "Key part '%-.192s' length cannot be 0",
	ErrViewChecksum:                             "View text checksum failed",
	ErrViewMultiupdate:                          "Can not modify more than one base table through a join view '%-.192s.%-.192s'",
	ErrViewNoInsertFieldList:                    "Can not insert into join view '%-.192s.%-.192s' without fields list",
	ErrViewDeleteMergeView:                      "Can not delete from join view '%-.192s.%-.192s'",
	ErrCannotUser:                               "Operation %s failed for %.256s",
	ErrXaerNota:                                 "XAERNOTA: Unknown XID",
	ErrXaerInval:                                "XAERINVAL: Invalid arguments (or unsupported command)",
	ErrXaerRmfail:                               "XAERRMFAIL: The command cannot be executed when global transaction is in the  %.64s state",
	ErrXaerOutside:                              "XAEROUTSIDE: Some work is done outside global transaction",
	ErrXaerRmerr:                                "XAERRMERR: Fatal error occurred in the transaction branch - check your data for consistency",
	ErrXaRbrollback:                             "XARBROLLBACK: Transaction branch was rolled back",
	ErrNonexistingProcGrant:                     "There is no such grant defined for user '%-.48s' on host '%-.64s' on routine '%-.192s'",
	ErrProcAutoGrantFail:                        "Failed to grant EXECUTE and ALTER ROUTINE privileges",
	ErrProcAutoRevokeFail:                       "Failed to revoke all privileges to dropped routine",
	ErrDataTooLong:                              "Data too long for column '%s' at row %d",
	ErrSpBadSQLstate:                            "Bad SQLSTATE: '%s'",
	ErrStartup:                                  "%s: ready for connections.\nVersion: '%s'  socket: '%s'  port: %d  %s",
	ErrLoadFromFixedSizeRowsToVar:               "Can't load value from file with fixed size rows to variable",
	ErrCantCreateUserWithGrant:                  "You are not allowed to create a user with GRANT",
	ErrWrongValueForType:                        "Incorrect %-.32s value: '%-.128s' for function %-.32s",
	ErrTableDefChanged:                          "Table definition has changed, please retry transaction",
	ErrSpDupHandler:                             "Duplicate handler declared in the same block",
	ErrSpNotVarArg:                              "OUT or INOUT argument %d for routine %s is not a variable or NEW pseudo-variable in BEFORE trigger",
	ErrSpNoRetset:                               "Not allowed to return a result set from a %s",
	ErrCantCreateGeometryObject:                 "Cannot get geometry object from data you send to the GEOMETRY field",
	ErrFailedRoutineBreakBinlog:                 "A routine failed and has neither NO SQL nor READS SQL DATA in its declaration and binary logging is enabled; if non-transactional tables were updated, the binary log will miss their changes",
	ErrBinlogUnsafeRoutine:                      "This function has none of DETERMINISTIC, NO SQL, or READS SQL DATA in its declaration and binary logging is enabled (you *might* want to use the less safe logBinTrustFunctionCreators variable)",
	ErrBinlogCreateRoutineNeedSuper:             "You do not have the SUPER privilege and binary logging is enabled (you *might* want to use the less safe logBinTrustFunctionCreators variable)",
	ErrExecStmtWithOpenCursor:                   "You can't execute a prepared statement which has an open cursor associated with it. Reset the statement to re-execute it.",
	ErrStmtHasNoOpenCursor:                      "The statement (%d) has no open cursor.",
	ErrCommitNotAllowedInSfOrTrg:                "Explicit or implicit commit is not allowed in stored function or trigger.",
	ErrNoDefaultForViewField:                    "Field of view '%-.192s.%-.192s' underlying table doesn't have a default value",
	ErrSpNoRecursion:                            "Recursive stored functions and triggers are not allowed.",
	ErrTooBigScale:                              "Too big scale %d specified for column '%-.192s'. Maximum is %d.",
	ErrTooBigPrecision:                          "Too big precision %d specified for column '%-.192s'. Maximum is %d.",
	ErrMBiggerThanD:                             "For float(M,D), double(M,D) or decimal(M,D), M must be >= D (column '%-.192s').",
	ErrWrongLockOfSystemTable:                   "You can't combine write-locking of system tables with other tables or lock types",
	ErrConnectToForeignDataSource:               "Unable to connect to foreign data source: %.64s",
	ErrQueryOnForeignDataSource:                 "There was a problem processing the query on the foreign data source. Data source : %-.64s",
	ErrForeignDataSourceDoesntExist:             "The foreign data source you are trying to reference does not exist. Data source :  %-.64s",
	ErrForeignDataStringInvalidCantCreate:       "Can't create federated table. The data source connection string '%-.64s' is not in the correct format",
	ErrForeignDataStringInvalid:                 "The data source connection string '%-.64s' is not in the correct format",
	ErrCantCreateFederatedTable:                 "Can't create federated table. Foreign data src :  %-.64s",
	ErrTrgInWrongSchema:                         "Trigger in wrong schema",
	ErrStackOverrunNeedMore:                     "Thread stack overrun:  %d bytes used of a %d byte stack, and %d bytes needed.  Use 'mysqld --threadStack=#' to specify a bigger stack.",
	ErrTooLongBody:                              "Routine body for '%-.100s' is too long",
	ErrWarnCantDropDefaultKeycache:              "Cannot drop default keycache",
	ErrTooBigDisplaywidth:                       "Display width out of range for column '%-.192s' (max = %d)",
	ErrXaerDupid:                                "XAERDUPID: The XID already exists",
	ErrDatetimeFunctionOverflow:                 "Datetime function: %-.32s field overflow",
	ErrCantUpdateUsedTableInSfOrTrg:             "Can't update table '%-.192s' in stored function/trigger because it is already used by statement which invoked this stored function/trigger.",
	ErrViewPreventUpdate:                        "The definition of table '%-.192s' prevents operation %.192s on table '%-.192s'.",
	ErrPsNoRecursion:                            "The prepared statement contains a stored routine call that refers to that same statement. It's not allowed to execute a prepared statement in such a recursive manner",
	ErrSpCantSetAutocommit:                      "Not allowed to set autocommit from a stored function or trigger",
	ErrMalformedDefiner:                         "Definer is not fully qualified",
	ErrViewFrmNoUser:                            "View '%-.192s'.'%-.192s' has no definer information (old table format). Current user is used as definer. Please recreate the view!",
	ErrViewOtherUser:                            "You need the SUPER privilege for creation view with '%-.192s'@'%-.192s' definer",
	ErrNoSuchUser:                               "The user specified as a definer ('%-.64s'@'%-.64s') does not exist",
	ErrForbidSchemaChange:                       "Changing schema from '%-.192s' to '%-.192s' is not allowed.",
	ErrRowIsReferenced2:                         "Cannot delete or update a parent row: a foreign key constraint fails (%.192s)",
	ErrNoReferencedRow2:                         "Cannot add or update a child row: a foreign key constraint fails (%.192s)",
	ErrSpBadVarShadow:                           "Variable '%-.64s' must be quoted with `...`, or renamed",
	ErrTrgNoDefiner:                             "No definer attribute for trigger '%-.192s'.'%-.192s'. The trigger will be activated under the authorization of the invoker, which may have insufficient privileges. Please recreate the trigger.",
	ErrOldFileFormat:                            "'%-.192s' has an old format, you should re-create the '%s' object(s)",
	ErrSpRecursionLimit:                         "Recursive limit %d (as set by the maxSpRecursionDepth variable) was exceeded for routine %.192s",
	ErrSpProcTableCorrupt:                       "Failed to load routine %-.192s. The table mysql.proc is missing, corrupt, or contains bad data (internal code %d)",
	ErrSpWrongName:                              "Incorrect routine name '%-.192s'",
	ErrTableNeedsUpgrade:                        "Table upgrade required. Please do \"REPAIR TABLE `%-.32s`\"",
	ErrSpNoAggregate:                            "AGGREGATE is not supported for stored functions",
	ErrMaxPreparedStmtCountReached:              "Can't create more than maxPreparedStmtCount statements (current value: %d)",
	ErrViewRecursive:                            "`%-.192s`.`%-.192s` contains view recursion",
	ErrNonGroupingFieldUsed:                     "Non-grouping field '%-.192s' is used in %-.64s clause",
	ErrTableCantHandleSpkeys:                    "The used table type doesn't support SPATIAL indexes",
	ErrNoTriggersOnSystemSchema:                 "Triggers can not be created on system tables",
	ErrRemovedSpaces:                            "Leading spaces are removed from name '%s'",
	ErrAutoincReadFailed:                        "Failed to read auto-increment value from storage engine",
	ErrUsername:                                 "user name",
	ErrHostname:                                 "host name",
	ErrWrongStringLength:                        "String '%-.70s' is too long for %s (should be no longer than %d)",
	ErrNonInsertableTable:                       "The target table %-.100s of the %s is not insertable-into",
	ErrAdminWrongMrgTable:                       "Table '%-.64s' is differently defined or of non-MyISAM type or doesn't exist",
	ErrTooHighLevelOfNestingForSelect:           "Too high level of nesting for select",
	ErrNameBecomesEmpty:                         "Name '%-.64s' has become ''",
	ErrAmbiguousFieldTerm:                       "First character of the FIELDS TERMINATED string is ambiguous; please use non-optional and non-empty FIELDS ENCLOSED BY",
	ErrForeignServerExists:                      "The foreign server, %s, you are trying to create already exists.",
	ErrForeignServerDoesntExist:                 "The foreign server name you are trying to reference does not exist. Data source :  %-.64s",
	ErrIllegalHaCreateOption:                    "Table storage engine '%-.64s' does not support the create option '%.64s'",
	ErrPartitionRequiresValues:                  "Syntax : %-.64s PARTITIONING requires definition of VALUES %-.64s for each partition",
	ErrPartitionWrongValues:                     "Only %-.64s PARTITIONING can use VALUES %-.64s in partition definition",
	ErrPartitionMaxvalue:                        "MAXVALUE can only be used in last partition definition",
	ErrPartitionSubpartition:                    "Subpartitions can only be hash partitions and by key",
	ErrPartitionSubpartMix:                      "Must define subpartitions on all partitions if on one partition",
	ErrPartitionWrongNoPart:                     "Wrong number of partitions defined, mismatch with previous setting",
	ErrPartitionWrongNoSubpart:                  "Wrong number of subpartitions defined, mismatch with previous setting",
	ErrWrongExprInPartitionFunc:                 "Constant, random or timezone-dependent expressions in (sub)partitioning function are not allowed",
	ErrNoConstExprInRangeOrList:                 "Expression in RANGE/LIST VALUES must be constant",
	ErrFieldNotFoundPart:                        "Field in list of fields for partition function not found in table",
	ErrListOfFieldsOnlyInHash:                   "List of fields is only allowed in KEY partitions",
	ErrInconsistentPartitionInfo:                "The partition info in the frm file is not consistent with what can be written into the frm file",
	ErrPartitionFuncNotAllowed:                  "The %-.192s function returns the wrong type",
	ErrPartitionsMustBeDefined:                  "For %-.64s partitions each partition must be defined",
	ErrRangeNotIncreasing:                       "VALUES LESS THAN value must be strictly increasing for each partition",
	ErrInconsistentTypeOfFunctions:              "VALUES value must be of same type as partition function",
	ErrMultipleDefConstInListPart:               "Multiple definition of same constant in list partitioning",
	ErrPartitionEntry:                           "Partitioning can not be used stand-alone in query",
	ErrMixHandler:                               "The mix of handlers in the partitions is not allowed in this version of MySQL",
	ErrPartitionNotDefined:                      "For the partitioned engine it is necessary to define all %-.64s",
	ErrTooManyPartitions:                        "Too many partitions (including subpartitions) were defined",
	ErrSubpartition:                             "It is only possible to mix RANGE/LIST partitioning with HASH/KEY partitioning for subpartitioning",
	ErrCantCreateHandlerFile:                    "Failed to create specific handler file",
	ErrBlobFieldInPartFunc:                      "A BLOB field is not allowed in partition function",
	ErrUniqueKeyNeedAllFieldsInPf:               "A %-.192s must include all columns in the table's partitioning function",
	ErrNoParts:                                  "Number of %-.64s = 0 is not an allowed value",
	ErrPartitionMgmtOnNonpartitioned:            "Partition management on a not partitioned table is not possible",
	ErrForeignKeyOnPartitioned:                  "Foreign key clause is not yet supported in conjunction with partitioning",
	ErrDropPartitionNonExistent:                 "Error in list of partitions to %-.64s",
	ErrDropLastPartition:                        "Cannot remove all partitions, use DROP TABLE instead",
	ErrCoalesceOnlyOnHashPartition:              "COALESCE PARTITION can only be used on HASH/KEY partitions",
	ErrReorgHashOnlyOnSameNo:                    "REORGANIZE PARTITION can only be used to reorganize partitions not to change their numbers",
	ErrReorgNoParam:                             "REORGANIZE PARTITION without parameters can only be used on auto-partitioned tables using HASH PARTITIONs",
	ErrOnlyOnRangeListPartition:                 "%-.64s PARTITION can only be used on RANGE/LIST partitions",
	ErrAddPartitionSubpart:                      "Trying to Add partition(s) with wrong number of subpartitions",
	ErrAddPartitionNoNewPartition:               "At least one partition must be added",
	ErrCoalescePartitionNoPartition:             "At least one partition must be coalesced",
	ErrReorgPartitionNotExist:                   "More partitions to reorganize than there are partitions",
	ErrSameNamePartition:                        "Duplicate partition name %-.192s",
	ErrNoBinlog:                                 "It is not allowed to shut off binlog on this command",
	ErrConsecutiveReorgPartitions:               "When reorganizing a set of partitions they must be in consecutive order",
	ErrReorgOutsideRange:                        "Reorganize of range partitions cannot change total ranges except for last partition where it can extend the range",
	ErrPartitionFunctionFailure:                 "Partition function not supported in this version for this handler",
	ErrPartState:                                "Partition state cannot be defined from CREATE/ALTER TABLE",
	ErrLimitedPartRange:                         "The %-.64s handler only supports 32 bit integers in VALUES",
	ErrPluginIsNotLoaded:                        "Plugin '%-.192s' is not loaded",
	ErrWrongValue:                               "Incorrect %-.32s value: '%-.128s'",
	ErrNoPartitionForGivenValue:                 "Table has no partition for value %-.64s",
	ErrFilegroupOptionOnlyOnce:                  "It is not allowed to specify %s more than once",
	ErrCreateFilegroupFailed:                    "Failed to create %s",
	ErrDropFilegroupFailed:                      "Failed to drop %s",
	ErrTablespaceAutoExtend:                     "The handler doesn't support autoextend of tablespaces",
	ErrWrongSizeNumber:                          "A size parameter was incorrectly specified, either number or on the form 10M",
	ErrSizeOverflow:                             "The size number was correct but we don't allow the digit part to be more than 2 billion",
	ErrAlterFilegroupFailed:                     "Failed to alter: %s",
	ErrBinlogRowLoggingFailed:                   "Writing one row to the row-based binary log failed",
	ErrBinlogRowWrongTableDef:                   "Table definition on master and slave does not match: %s",
	ErrBinlogRowRbrToSbr:                        "Slave running with --log-slave-updates must use row-based binary logging to be able to replicate row-based binary log events",
	ErrEventAlreadyExists:                       "Event '%-.192s' already exists",
	ErrEventStoreFailed:                         "Failed to store event %s. Error code %d from storage engine.",
	ErrEventDoesNotExist:                        "Unknown event '%-.192s'",
	ErrEventCantAlter:                           "Failed to alter event '%-.192s'",
	ErrEventDropFailed:                          "Failed to drop %s",
	ErrEventIntervalNotPositiveOrTooBig:         "INTERVAL is either not positive or too big",
	ErrEventEndsBeforeStarts:                    "ENDS is either invalid or before STARTS",
	ErrEventExecTimeInThePast:                   "Event execution time is in the past. Event has been disabled",
	ErrEventOpenTableFailed:                     "Failed to open mysql.event",
	ErrEventNeitherMExprNorMAt:                  "No datetime expression provided",
	ErrObsoleteColCountDoesntMatchCorrupted:     "Column count of mysql.%s is wrong. Expected %d, found %d. The table is probably corrupted",
	ErrObsoleteCannotLoadFromTable:              "Cannot load from mysql.%s. The table is probably corrupted",
	ErrEventCannotDelete:                        "Failed to delete the event from mysql.event",
	ErrEventCompile:                             "Error during compilation of event's body",
	ErrEventSameName:                            "Same old and new event name",
	ErrEventDataTooLong:                         "Data for column '%s' too long",
	ErrDropIndexFk:                              "Cannot drop index '%-.192s': needed in a foreign key constraint",
	ErrWarnDeprecatedSyntaxWithVer:              "The syntax '%s' is deprecated and will be removed in MySQL %s. Please use %s instead",
	ErrCantWriteLockLogTable:                    "You can't write-lock a log table. Only read access is possible",
	ErrCantLockLogTable:                         "You can't use locks with log tables.",
	ErrForeignDuplicateKeyOldUnused:             "Upholding foreign key constraints for table '%.192s', entry '%-.192s', key %d would lead to a duplicate entry",
	ErrColCountDoesntMatchPleaseUpdate:          "Column count of mysql.%s is wrong. Expected %d, found %d. Created with MySQL %d, now running %d. Please use mysqlUpgrade to fix this error.",
	ErrTempTablePreventsSwitchOutOfRbr:          "Cannot switch out of the row-based binary log format when the session has open temporary tables",
	ErrStoredFunctionPreventsSwitchBinlogFormat: "Cannot change the binary logging format inside a stored function or trigger",
	ErrNdbCantSwitchBinlogFormat:                "The NDB cluster engine does not support changing the binlog format on the fly yet",
	ErrPartitionNoTemporary:                     "Cannot create temporary table with partitions",
	ErrPartitionConstDomain:                     "Partition constant is out of partition function domain",
	ErrPartitionFunctionIsNotAllowed:            "This partition function is not allowed",
	ErrDdlLog:                                   "Error in DDL log",
	ErrNullInValuesLessThan:                     "Not allowed to use NULL value in VALUES LESS THAN",
	ErrWrongPartitionName:                       "Incorrect partition name",
	ErrCantChangeTxCharacteristics:              "Transaction characteristics can't be changed while a transaction is in progress",
	ErrDupEntryAutoincrementCase:                "ALTER TABLE causes autoIncrement resequencing, resulting in duplicate entry '%-.192s' for key '%-.192s'",
	ErrEventModifyQueue:                         "Internal scheduler error %d",
	ErrEventSetVar:                              "Error during starting/stopping of the scheduler. Error code %d",
	ErrPartitionMerge:                           "Engine cannot be used in partitioned tables",
	ErrCantActivateLog:                          "Cannot activate '%-.64s' log",
	ErrRbrNotAvailable:                          "The server was not built with row-based replication",
	ErrBase64Decode:                             "Decoding of base64 string failed",
	ErrEventRecursionForbidden:                  "Recursion of EVENT DDL statements is forbidden when body is present",
	ErrEventsDB:                                 "Cannot proceed because system tables used by Event Scheduler were found damaged at server start",
	ErrOnlyIntegersAllowed:                      "Only integers allowed as number here",
	ErrUnsuportedLogEngine:                      "This storage engine cannot be used for log tables\"",
	ErrBadLogStatement:                          "You cannot '%s' a log table if logging is enabled",
	ErrCantRenameLogTable:                       "Cannot rename '%s'. When logging enabled, rename to/from log table must rename two tables: the log table to an archive table and another table back to '%s'",
	ErrWrongParamcountToNativeFct:               "Incorrect parameter count in the call to native function '%-.192s'",
	ErrWrongParametersToNativeFct:               "Incorrect parameters in the call to native function '%-.192s'",
	ErrWrongParametersToStoredFct:               "Incorrect parameters in the call to stored function '%-.192s'",
	ErrNativeFctNameCollision:                   "This function '%-.192s' has the same name as a native function",
	ErrDupEntryWithKeyName:                      "Duplicate entry '%-.64s' for key '%-.192s'",
	ErrBinlogPurgeEmFile:                        "Too many files opened, please execute the command again",
	ErrEventCannotCreateInThePast:               "Event execution time is in the past and ON COMPLETION NOT PRESERVE is set. The event was dropped immediately after creation.",
	ErrEventCannotAlterInThePast:                "Event execution time is in the past and ON COMPLETION NOT PRESERVE is set. The event was not changed. Specify a time in the future.",
	ErrSlaveIncident:                            "The incident %s occurred on the master. Message: %-.64s",
	ErrNoPartitionForGivenValueSilent:           "Table has no partition for some existing values",
	ErrBinlogUnsafeStatement:                    "Unsafe statement written to the binary log using statement format since BINLOGFORMAT = STATEMENT. %s",
	ErrSlaveFatal:                               "Fatal : %s",
	ErrSlaveRelayLogReadFailure:                 "Relay log read failure: %s",
	ErrSlaveRelayLogWriteFailure:                "Relay log write failure: %s",
	ErrSlaveCreateEventFailure:                  "Failed to create %s",
	ErrSlaveMasterComFailure:                    "Master command %s failed: %s",
	ErrBinlogLoggingImpossible:                  "Binary logging not possible. Message: %s",
	ErrViewNoCreationCtx:                        "View `%-.64s`.`%-.64s` has no creation context",
	ErrViewInvalidCreationCtx:                   "Creation context of view `%-.64s`.`%-.64s' is invalid",
	ErrSrInvalidCreationCtx:                     "Creation context of stored routine `%-.64s`.`%-.64s` is invalid",
	ErrTrgCorruptedFile:                         "Corrupted TRG file for table `%-.64s`.`%-.64s`",
	ErrTrgNoCreationCtx:                         "Triggers for table `%-.64s`.`%-.64s` have no creation context",
	ErrTrgInvalidCreationCtx:                    "Trigger creation context of table `%-.64s`.`%-.64s` is invalid",
	ErrEventInvalidCreationCtx:                  "Creation context of event `%-.64s`.`%-.64s` is invalid",
	ErrTrgCantOpenTable:                         "Cannot open table for trigger `%-.64s`.`%-.64s`",
	ErrCantCreateSroutine:                       "Cannot create stored routine `%-.64s`. Check warnings",
	ErrNeverUsed:                                "Ambiguous slave modes combination. %s",
	ErrNoFormatDescriptionEventBeforeBinlogStatement:         "The BINLOG statement of type `%s` was not preceded by a format description BINLOG statement.",
	ErrSlaveCorruptEvent:                                     "Corrupted replication event was detected",
	ErrLoadDataInvalidColumn:                                 "Invalid column reference (%-.64s) in LOAD DATA",
	ErrLogPurgeNoFile:                                        "Being purged log %s was not found",
	ErrXaRbtimeout:                                           "XARBTIMEOUT: Transaction branch was rolled back: took too long",
	ErrXaRbdeadlock:                                          "XARBDEADLOCK: Transaction branch was rolled back: deadlock was detected",
	ErrNeedReprepare:                                         "Prepared statement needs to be re-prepared",
	ErrDelayedNotSupported:                                   "DELAYED option not supported for table '%-.192s'",
	WarnNoMasterInfo:                                         "The master info structure does not exist",
	WarnOptionIgnored:                                        "<%-.64s> option ignored",
	WarnPluginDeleteBuiltin:                                  "Built-in plugins cannot be deleted",
	WarnPluginBusy:                                           "Plugin is busy and will be uninstalled on shutdown",
	ErrVariableIsReadonly:                                    "%s variable '%s' is read-only. Use SET %s to assign the value",
	ErrWarnEngineTransactionRollback:                         "Storage engine %s does not support rollback for this statement. Transaction rolled back and must be restarted",
	ErrSlaveHeartbeatFailure:                                 "Unexpected master's heartbeat data: %s",
	ErrSlaveHeartbeatValueOutOfRange:                         "The requested value for the heartbeat period is either negative or exceeds the maximum allowed (%s seconds).",
	ErrNdbReplicationSchema:                                  "Bad schema for mysql.ndbReplication table. Message: %-.64s",
	ErrConflictFnParse:                                       "Error in parsing conflict function. Message: %-.64s",
	ErrExceptionsWrite:                                       "Write to exceptions table failed. Message: %-.128s\"",
	ErrTooLongTableComment:                                   "Comment for table '%-.64s' is too long (max = %d)",
	ErrTooLongFieldComment:                                   "Comment for field '%-.64s' is too long (max = %d)",
	ErrFuncInexistentNameCollision:                           "FUNCTION %s does not exist. Check the 'Function Name Parsing and Resolution' section in the Reference Manual",
	ErrDatabaseName:                                          "Database",
	ErrTableName:                                             "Table",
	ErrPartitionName:                                         "Partition",
	ErrSubpartitionName:                                      "Subpartition",
	ErrTemporaryName:                                         "Temporary",
	ErrRenamedName:                                           "Renamed",
	ErrTooManyConcurrentTrxs:                                 "Too many active concurrent transactions",
	WarnNonASCIISeparatorNotImplemented:                      "Non-ASCII separator arguments are not fully supported",
	ErrDebugSyncTimeout:                                      "debug sync point wait timed out",
	ErrDebugSyncHitLimit:                                     "debug sync point hit limit reached",
	ErrDupSignalSet:                                          "Duplicate condition information item '%s'",
	ErrSignalWarn:                                            "Unhandled user-defined warning condition",
	ErrSignalNotFound:                                        "Unhandled user-defined not found condition",
	ErrSignalException:                                       "Unhandled user-defined exception condition",
	ErrResignalWithoutActiveHandler:                          "RESIGNAL when handler not active",
	ErrSignalBadConditionType:                                "SIGNAL/RESIGNAL can only use a CONDITION defined with SQLSTATE",
	WarnCondItemTruncated:                                    "Data truncated for condition item '%s'",
	ErrCondItemTooLong:                                       "Data too long for condition item '%s'",
	ErrUnknownLocale:                                         "Unknown locale: '%-.64s'",
	ErrSlaveIgnoreServerIds:                                  "The requested server id %d clashes with the slave startup option --replicate-same-server-id",
	ErrQueryCacheDisabled:                                    "Query cache is disabled; restart the server with queryCacheType=1 to enable it",
	ErrSameNamePartitionField:                                "Duplicate partition field name '%-.192s'",
	ErrPartitionColumnList:                                   "Inconsistency in usage of column lists for partitioning",
	ErrWrongTypeColumnValue:                                  "Partition column values of incorrect type",
	ErrTooManyPartitionFuncFields:                            "Too many fields in '%-.192s'",
	ErrMaxvalueInValuesIn:                                    "Cannot use MAXVALUE as value in VALUES IN",
	ErrTooManyValues:                                         "Cannot have more than one value for this type of %-.64s partitioning",
	ErrRowSinglePartitionField:                               "Row expressions in VALUES IN only allowed for multi-field column partitioning",
	ErrFieldTypeNotAllowedAsPartitionField:                   "Field '%-.192s' is of a not allowed type for this type of partitioning",
	ErrPartitionFieldsTooLong:                                "The total length of the partitioning fields is too large",
	ErrBinlogRowEngineAndStmtEngine:                          "Cannot execute statement: impossible to write to binary log since both row-incapable engines and statement-incapable engines are involved.",
	ErrBinlogRowModeAndStmtEngine:                            "Cannot execute statement: impossible to write to binary log since BINLOGFORMAT = ROW and at least one table uses a storage engine limited to statement-based logging.",
	ErrBinlogUnsafeAndStmtEngine:                             "Cannot execute statement: impossible to write to binary log since statement is unsafe, storage engine is limited to statement-based logging, and BINLOGFORMAT = MIXED. %s",
	ErrBinlogRowInjectionAndStmtEngine:                       "Cannot execute statement: impossible to write to binary log since statement is in row format and at least one table uses a storage engine limited to statement-based logging.",
	ErrBinlogStmtModeAndRowEngine:                            "Cannot execute statement: impossible to write to binary log since BINLOGFORMAT = STATEMENT and at least one table uses a storage engine limited to row-based logging.%s",
	ErrBinlogRowInjectionAndStmtMode:                         "Cannot execute statement: impossible to write to binary log since statement is in row format and BINLOGFORMAT = STATEMENT.",
	ErrBinlogMultipleEnginesAndSelfLoggingEngine:             "Cannot execute statement: impossible to write to binary log since more than one engine is involved and at least one engine is self-logging.",
	ErrBinlogUnsafeLimit:                                     "The statement is unsafe because it uses a LIMIT clause. This is unsafe because the set of rows included cannot be predicted.",
	ErrBinlogUnsafeInsertDelayed:                             "The statement is unsafe because it uses INSERT DELAYED. This is unsafe because the times when rows are inserted cannot be predicted.",
	ErrBinlogUnsafeSystemTable:                               "The statement is unsafe because it uses the general log, slow query log, or performanceSchema table(s). This is unsafe because system tables may differ on slaves.",
	ErrBinlogUnsafeAutoincColumns:                            "Statement is unsafe because it invokes a trigger or a stored function that inserts into an AUTOINCREMENT column. Inserted values cannot be logged correctly.",
	ErrBinlogUnsafeUdf:                                       "Statement is unsafe because it uses a UDF which may not return the same value on the slave.",
	ErrBinlogUnsafeSystemVariable:                            "Statement is unsafe because it uses a system variable that may have a different value on the slave.",
	ErrBinlogUnsafeSystemFunction:                            "Statement is unsafe because it uses a system function that may return a different value on the slave.",
	ErrBinlogUnsafeNontransAfterTrans:                        "Statement is unsafe because it accesses a non-transactional table after accessing a transactional table within the same transaction.",
	ErrMessageAndStatement:                                   "%s Statement: %s",
	ErrSlaveConversionFailed:                                 "Column %d of table '%-.192s.%-.192s' cannot be converted from type '%-.32s' to type '%-.32s'",
	ErrSlaveCantCreateConversion:                             "Can't create conversion table for table '%-.192s.%-.192s'",
	ErrInsideTransactionPreventsSwitchBinlogFormat:           "Cannot modify @@session.binlogFormat inside a transaction",
	ErrPathLength:                                            "The path specified for %.64s is too long.",
	ErrWarnDeprecatedSyntaxNoReplacement:                     "'%s' is deprecated and will be removed in a future release.",
	ErrWrongNativeTableStructure:                             "Native table '%-.64s'.'%-.64s' has the wrong structure",
	ErrWrongPerfSchemaUsage:                                  "Invalid performanceSchema usage.",
	ErrWarnISSkippedTable:                                    "Table '%s'.'%s' was skipped since its definition is being modified by concurrent DDL statement",
	ErrInsideTransactionPreventsSwitchBinlogDirect:           "Cannot modify @@session.binlogDirectNonTransactionalUpdates inside a transaction",
	ErrStoredFunctionPreventsSwitchBinlogDirect:              "Cannot change the binlog direct flag inside a stored function or trigger",
	ErrSpatialMustHaveGeomCol:                                "A SPATIAL index may only contain a geometrical type column",
	ErrTooLongIndexComment:                                   "Comment for index '%-.64s' is too long (max = %d)",
	ErrLockAborted:                                           "Wait on a lock was aborted due to a pending exclusive lock",
	ErrDataOutOfRange:                                        "%s value is out of range in '%s'",
	ErrWrongSpvarTypeInLimit:                                 "A variable of a non-integer based type in LIMIT clause",
	ErrBinlogUnsafeMultipleEnginesAndSelfLoggingEngine:       "Mixing self-logging and non-self-logging engines in a statement is unsafe.",
	ErrBinlogUnsafeMixedStatement:                            "Statement accesses nontransactional table as well as transactional or temporary table, and writes to any of them.",
	ErrInsideTransactionPreventsSwitchSQLLogBin:              "Cannot modify @@session.sqlLogBin inside a transaction",
	ErrStoredFunctionPreventsSwitchSQLLogBin:                 "Cannot change the sqlLogBin inside a stored function or trigger",
	ErrFailedReadFromParFile:                                 "Failed to read from the .par file",
	ErrValuesIsNotIntType:                                    "VALUES value for partition '%-.64s' must have type INT",
	ErrAccessDeniedNoPassword:                                "Access denied for user '%-.48s'@'%-.64s'",
	ErrSetPasswordAuthPlugin:                                 "SET PASSWORD has no significance for users authenticating via plugins",
	ErrGrantPluginUserExists:                                 "GRANT with IDENTIFIED WITH is illegal because the user %-.*s already exists",
	ErrTruncateIllegalFk:                                     "Cannot truncate a table referenced in a foreign key constraint (%.192s)",
	ErrPluginIsPermanent:                                     "Plugin '%s' is forcePlusPermanent and can not be unloaded",
	ErrSlaveHeartbeatValueOutOfRangeMin:                      "The requested value for the heartbeat period is less than 1 millisecond. The value is reset to 0, meaning that heartbeating will effectively be disabled.",
	ErrSlaveHeartbeatValueOutOfRangeMax:                      "The requested value for the heartbeat period exceeds the value of `slaveNetTimeout' seconds. A sensible value for the period should be less than the timeout.",
	ErrStmtCacheFull:                                         "Multi-row statements required more than 'maxBinlogStmtCacheSize' bytes of storage; increase this mysqld variable and try again",
	ErrMultiUpdateKeyConflict:                                "Primary key/partition key update is not allowed since the table is updated both as '%-.192s' and '%-.192s'.",
	ErrTableNeedsRebuild:                                     "Table rebuild required. Please do \"ALTER TABLE `%-.32s` FORCE\" or dump/reload to fix it!",
	WarnOptionBelowLimit:                                     "The value of '%s' should be no less than the value of '%s'",
	ErrIndexColumnTooLong:                                    "Index column size too large. The maximum column size is %d bytes.",
	ErrErrorInTriggerBody:                                    "Trigger '%-.64s' has an error in its body: '%-.256s'",
	ErrErrorInUnknownTriggerBody:                             "Unknown trigger has an error in its body: '%-.256s'",
	ErrIndexCorrupt:                                          "Index %s is corrupted",
	ErrUndoRecordTooBig:                                      "Undo log record is too big.",
	ErrBinlogUnsafeInsertIgnoreSelect:                        "INSERT IGNORE... SELECT is unsafe because the order in which rows are retrieved by the SELECT determines which (if any) rows are ignored. This order cannot be predicted and may differ on master and the slave.",
	ErrBinlogUnsafeInsertSelectUpdate:                        "INSERT... SELECT... ON DUPLICATE KEY UPDATE is unsafe because the order in which rows are retrieved by the SELECT determines which (if any) rows are updated. This order cannot be predicted and may differ on master and the slave.",
	ErrBinlogUnsafeReplaceSelect:                             "REPLACE... SELECT is unsafe because the order in which rows are retrieved by the SELECT determines which (if any) rows are replaced. This order cannot be predicted and may differ on master and the slave.",
	ErrBinlogUnsafeCreateIgnoreSelect:                        "CREATE... IGNORE SELECT is unsafe because the order in which rows are retrieved by the SELECT determines which (if any) rows are ignored. This order cannot be predicted and may differ on master and the slave.",
	ErrBinlogUnsafeCreateReplaceSelect:                       "CREATE... REPLACE SELECT is unsafe because the order in which rows are retrieved by the SELECT determines which (if any) rows are replaced. This order cannot be predicted and may differ on master and the slave.",
	ErrBinlogUnsafeUpdateIgnore:                              "UPDATE IGNORE is unsafe because the order in which rows are updated determines which (if any) rows are ignored. This order cannot be predicted and may differ on master and the slave.",
	ErrPluginNoUninstall:                                     "Plugin '%s' is marked as not dynamically uninstallable. You have to stop the server to uninstall it.",
	ErrPluginNoInstall:                                       "Plugin '%s' is marked as not dynamically installable. You have to stop the server to install it.",
	ErrBinlogUnsafeWriteAutoincSelect:                        "Statements writing to a table with an auto-increment column after selecting from another table are unsafe because the order in which rows are retrieved determines what (if any) rows will be written. This order cannot be predicted and may differ on master and the slave.",
	ErrBinlogUnsafeCreateSelectAutoinc:                       "CREATE TABLE... SELECT...  on a table with an auto-increment column is unsafe because the order in which rows are retrieved by the SELECT determines which (if any) rows are inserted. This order cannot be predicted and may differ on master and the slave.",
	ErrBinlogUnsafeInsertTwoKeys:                             "INSERT... ON DUPLICATE KEY UPDATE  on a table with more than one UNIQUE KEY is unsafe",
	ErrTableInFkCheck:                                        "Table is being used in foreign key check.",
	ErrUnsupportedEngine:                                     "Storage engine '%s' does not support system tables. [%s.%s]",
	ErrBinlogUnsafeAutoincNotFirst:                           "INSERT into autoincrement field which is not the first part in the composed primary key is unsafe.",
	ErrCannotLoadFromTableV2:                                 "Cannot load from %s.%s. The table is probably corrupted",
	ErrMasterDelayValueOutOfRange:                            "The requested value %d for the master delay exceeds the maximum %d",
	ErrOnlyFdAndRbrEventsAllowedInBinlogStatement:            "Only FormatDescriptionLogEvent and row events are allowed in BINLOG statements (but %s was provided)",
	ErrPartitionExchangeDifferentOption:                      "Non matching attribute '%-.64s' between partition and table",
	ErrPartitionExchangePartTable:                            "Table to exchange with partition is partitioned: '%-.64s'",
	ErrPartitionExchangeTempTable:                            "Table to exchange with partition is temporary: '%-.64s'",
	ErrPartitionInsteadOfSubpartition:                        "Subpartitioned table, use subpartition instead of partition",
	ErrUnknownPartition:                                      "Unknown partition '%-.64s' in table '%-.64s'",
	ErrTablesDifferentMetadata:                               "Tables have different definitions",
	ErrRowDoesNotMatchPartition:                              "Found a row that does not match the partition",
	ErrBinlogCacheSizeGreaterThanMax:                         "Option binlogCacheSize (%d) is greater than maxBinlogCacheSize (%d); setting binlogCacheSize equal to maxBinlogCacheSize.",
	ErrWarnIndexNotApplicable:                                "Cannot use %-.64s access on index '%-.64s' due to type or collation conversion on field '%-.64s'",
	ErrPartitionExchangeForeignKey:                           "Table to exchange with partition has foreign key references: '%-.64s'",
	ErrNoSuchKeyValue:                                        "Key value '%-.192s' was not found in table '%-.192s.%-.192s'",
	ErrRplInfoDataTooLong:                                    "Data for column '%s' too long",
	ErrNetworkReadEventChecksumFailure:                       "Replication event checksum verification failed while reading from network.",
	ErrBinlogReadEventChecksumFailure:                        "Replication event checksum verification failed while reading from a log file.",
	ErrBinlogStmtCacheSizeGreaterThanMax:                     "Option binlogStmtCacheSize (%d) is greater than maxBinlogStmtCacheSize (%d); setting binlogStmtCacheSize equal to maxBinlogStmtCacheSize.",
	ErrCantUpdateTableInCreateTableSelect:                    "Can't update table '%-.192s' while '%-.192s' is being created.",
	ErrPartitionClauseOnNonpartitioned:                       "PARTITION () clause on non partitioned table",
	ErrRowDoesNotMatchGivenPartitionSet:                      "Found a row not matching the given partition set",
	ErrNoSuchPartitionunused:                                 "partition '%-.64s' doesn't exist",
	ErrChangeRplInfoRepositoryFailure:                        "Failure while changing the type of replication repository: %s.",
	ErrWarningNotCompleteRollbackWithCreatedTempTable:        "The creation of some temporary tables could not be rolled back.",
	ErrWarningNotCompleteRollbackWithDroppedTempTable:        "Some temporary tables were dropped, but these operations could not be rolled back.",
	ErrMtsFeatureIsNotSupported:                              "%s is not supported in multi-threaded slave mode. %s",
	ErrMtsUpdatedDBsGreaterMax:                               "The number of modified databases exceeds the maximum %d; the database names will not be included in the replication event metadata.",
	ErrMtsCantParallel:                                       "Cannot execute the current event group in the parallel mode. Encountered event %s, relay-log name %s, position %s which prevents execution of this event group in parallel mode. Reason: %s.",
	ErrMtsInconsistentData:                                   "%s",
	ErrFulltextNotSupportedWithPartitioning:                  "FULLTEXT index is not supported for partitioned tables.",
	ErrDaInvalidConditionNumber:                              "Invalid condition number",
	ErrInsecurePlainText:                                     "Sending passwords in plain text without SSL/TLS is extremely insecure.",
	ErrInsecureChangeMaster:                                  "Storing MySQL user name or password information in the master.info repository is not secure and is therefore not recommended. Please see the MySQL Manual for more about this issue and possible alternatives.",
	ErrForeignDuplicateKeyWithChildInfo:                      "Foreign key constraint for table '%.192s', record '%-.192s' would lead to a duplicate entry in table '%.192s', key '%.192s'",
	ErrForeignDuplicateKeyWithoutChildInfo:                   "Foreign key constraint for table '%.192s', record '%-.192s' would lead to a duplicate entry in a child table",
	ErrSQLthreadWithSecureSlave:                              "Setting authentication options is not possible when only the Slave SQL Thread is being started.",
	ErrTableHasNoFt:                                          "The table does not have FULLTEXT index to support this query",
	ErrVariableNotSettableInSfOrTrigger:                      "The system variable %.200s cannot be set in stored functions or triggers.",
	ErrVariableNotSettableInTransaction:                      "The system variable %.200s cannot be set when there is an ongoing transaction.",
	ErrGtidNextIsNotInGtidNextList:                           "The system variable @@SESSION.GTIDNEXT has the value %.200s, which is not listed in @@SESSION.GTIDNEXTLIST.",
	ErrCantChangeGtidNextInTransactionWhenGtidNextListIsNull: "When @@SESSION.GTIDNEXTLIST == NULL, the system variable @@SESSION.GTIDNEXT cannot change inside a transaction.",
	ErrSetStatementCannotInvokeFunction:                      "The statement 'SET %.200s' cannot invoke a stored function.",
	ErrGtidNextCantBeAutomaticIfGtidNextListIsNonNull:        "The system variable @@SESSION.GTIDNEXT cannot be 'AUTOMATIC' when @@SESSION.GTIDNEXTLIST is non-NULL.",
	ErrSkippingLoggedTransaction:                             "Skipping transaction %.200s because it has already been executed and logged.",
	ErrMalformedGtidSetSpecification:                         "Malformed GTID set specification '%.200s'.",
	ErrMalformedGtidSetEncoding:                              "Malformed GTID set encoding.",
	ErrMalformedGtidSpecification:                            "Malformed GTID specification '%.200s'.",
	ErrGnoExhausted:                                          "Impossible to generate Global Transaction Identifier: the integer component reached the maximal value. Restart the server with a new serverUuid.",
	ErrBadSlaveAutoPosition:                                  "Parameters MASTERLOGFILE, MASTERLOGPOS, RELAYLOGFILE and RELAYLOGPOS cannot be set when MASTERAUTOPOSITION is active.",
	ErrAutoPositionRequiresGtidModeOn:                        "CHANGE MASTER TO MASTERAUTOPOSITION = 1 can only be executed when @@GLOBAL.GTIDMODE = ON.",
	ErrCantDoImplicitCommitInTrxWhenGtidNextIsSet:            "Cannot execute statements with implicit commit inside a transaction when @@SESSION.GTIDNEXT != AUTOMATIC or @@SESSION.GTIDNEXTLIST != NULL.",
	ErrGtidMode2Or3RequiresEnforceGtidConsistencyOn:          "@@GLOBAL.GTIDMODE = ON or UPGRADESTEP2 requires @@GLOBAL.ENFORCEGTIDCONSISTENCY = 1.",
	ErrGtidModeRequiresBinlog:                                "@@GLOBAL.GTIDMODE = ON or UPGRADESTEP1 or UPGRADESTEP2 requires --log-bin and --log-slave-updates.",
	ErrCantSetGtidNextToGtidWhenGtidModeIsOff:                "@@SESSION.GTIDNEXT cannot be set to UUID:NUMBER when @@GLOBAL.GTIDMODE = OFF.",
	ErrCantSetGtidNextToAnonymousWhenGtidModeIsOn:            "@@SESSION.GTIDNEXT cannot be set to ANONYMOUS when @@GLOBAL.GTIDMODE = ON.",
	ErrCantSetGtidNextListToNonNullWhenGtidModeIsOff:         "@@SESSION.GTIDNEXTLIST cannot be set to a non-NULL value when @@GLOBAL.GTIDMODE = OFF.",
	ErrFoundGtidEventWhenGtidModeIsOff:                       "Found a GtidLogEvent or PreviousGtidsLogEvent when @@GLOBAL.GTIDMODE = OFF.",
	ErrGtidUnsafeNonTransactionalTable:                       "When @@GLOBAL.ENFORCEGTIDCONSISTENCY = 1, updates to non-transactional tables can only be done in either autocommitted statements or single-statement transactions, and never in the same statement as updates to transactional tables.",
	ErrGtidUnsafeCreateSelect:                                "CREATE TABLE ... SELECT is forbidden when @@GLOBAL.ENFORCEGTIDCONSISTENCY = 1.",
	ErrGtidUnsafeCreateDropTemporaryTableInTransaction:       "When @@GLOBAL.ENFORCEGTIDCONSISTENCY = 1, the statements CREATE TEMPORARY TABLE and DROP TEMPORARY TABLE can be executed in a non-transactional context only, and require that AUTOCOMMIT = 1.",
	ErrGtidModeCanOnlyChangeOneStepAtATime:                   "The value of @@GLOBAL.GTIDMODE can only change one step at a time: OFF <-> UPGRADESTEP1 <-> UPGRADESTEP2 <-> ON. Also note that this value must be stepped up or down simultaneously on all servers; see the Manual for instructions.",
	ErrMasterHasPurgedRequiredGtids:                          "The slave is connecting using CHANGE MASTER TO MASTERAUTOPOSITION = 1, but the master has purged binary logs containing GTIDs that the slave requires.",
	ErrCantSetGtidNextWhenOwningGtid:                         "@@SESSION.GTIDNEXT cannot be changed by a client that owns a GTID. The client owns %s. Ownership is released on COMMIT or ROLLBACK.",
	ErrUnknownExplainFormat:                                  "Unknown EXPLAIN format name: '%s'",
	ErrCantExecuteInReadOnlyTransaction:                      "Cannot execute statement in a READ ONLY transaction.",
	ErrTooLongTablePartitionComment:                          "Comment for table partition '%-.64s' is too long (max = %d)",
	ErrSlaveConfiguration:                                    "Slave is not configured or failed to initialize properly. You must at least set --server-id to enable either a master or a slave. Additional error messages can be found in the MySQL error log.",
	ErrInnodbFtLimit:                                         "InnoDB presently supports one FULLTEXT index creation at a time",
	ErrInnodbNoFtTempTable:                                   "Cannot create FULLTEXT index on temporary InnoDB table",
	ErrInnodbFtWrongDocidColumn:                              "Column '%-.192s' is of wrong type for an InnoDB FULLTEXT index",
	ErrInnodbFtWrongDocidIndex:                               "Index '%-.192s' is of wrong type for an InnoDB FULLTEXT index",
	ErrInnodbOnlineLogTooBig:                                 "Creating index '%-.192s' required more than 'innodbOnlineAlterLogMaxSize' bytes of modification log. Please try again.",
	ErrUnknownAlterAlgorithm:                                 "Unknown ALGORITHM '%s'",
	ErrUnknownAlterLock:                                      "Unknown LOCK type '%s'",
	ErrMtsChangeMasterCantRunWithGaps:                        "CHANGE MASTER cannot be executed when the slave was stopped with an error or killed in MTS mode. Consider using RESET SLAVE or START SLAVE UNTIL.",
	ErrMtsRecoveryFailure:                                    "Cannot recover after SLAVE errored out in parallel execution mode. Additional error messages can be found in the MySQL error log.",
	ErrMtsResetWorkers:                                       "Cannot clean up worker info tables. Additional error messages can be found in the MySQL error log.",
	ErrColCountDoesntMatchCorruptedV2:                        "Column count of %s.%s is wrong. Expected %d, found %d. The table is probably corrupted",
	ErrSlaveSilentRetryTransaction:                           "Slave must silently retry current transaction",
	ErrDiscardFkChecksRunning:                                "There is a foreign key check running on table '%-.192s'. Cannot discard the table.",
	ErrTableSchemaMismatch:                                   "Schema mismatch (%s)",
	ErrTableInSystemTablespace:                               "Table '%-.192s' in system tablespace",
	ErrIoRead:                                                "IO Read : (%d, %s) %s",
	ErrIoWrite:                                               "IO Write : (%d, %s) %s",
	ErrTablespaceMissing:                                     "Tablespace is missing for table '%-.192s'",
	ErrTablespaceExists:                                      "Tablespace for table '%-.192s' exists. Please DISCARD the tablespace before IMPORT.",
	ErrTablespaceDiscarded:                                   "Tablespace has been discarded for table '%-.192s'",
	ErrInternal:                                              "Internal : %s",
	ErrInnodbImport:                                          "ALTER TABLE '%-.192s' IMPORT TABLESPACE failed with error %d : '%s'",
	ErrInnodbIndexCorrupt:                                    "Index corrupt: %s",
	ErrInvalidYearColumnLength:                               "Supports only YEAR or YEAR(4) column",
	ErrNotValidPassword:                                      "Your password does not satisfy the current policy requirements",
	ErrMustChangePassword:                                    "You must SET PASSWORD before executing this statement",
	ErrFkNoIndexChild:                                        "Failed to add the foreign key constaint. Missing index for constraint '%s' in the foreign table '%s'",
	ErrFkNoIndexParent:                                       "Failed to add the foreign key constaint. Missing index for constraint '%s' in the referenced table '%s'",
	ErrFkFailAddSystem:                                       "Failed to add the foreign key constraint '%s' to system tables",
	ErrFkCannotOpenParent:                                    "Failed to open the referenced table '%s'",
	ErrFkIncorrectOption:                                     "Failed to add the foreign key constraint on table '%s'. Incorrect options in FOREIGN KEY constraint '%s'",
	ErrFkDupName:                                             "Duplicate foreign key constraint name '%s'",
	ErrPasswordFormat:                                        "The password hash doesn't have the expected format. Check if the correct password algorithm is being used with the PASSWORD() function.",
	ErrFkColumnCannotDrop:                                    "Cannot drop column '%-.192s': needed in a foreign key constraint '%-.192s'",
	ErrFkColumnCannotDropChild:                               "Cannot drop column '%-.192s': needed in a foreign key constraint '%-.192s' of table '%-.192s'",
	ErrFkColumnNotNull:                                       "Column '%-.192s' cannot be NOT NULL: needed in a foreign key constraint '%-.192s' SET NULL",
	ErrDupIndex:                                              "Duplicate index '%-.64s' defined on the table '%-.64s.%-.64s'. This is deprecated and will be disallowed in a future release.",
	ErrFkColumnCannotChange:                                  "Cannot change column '%-.192s': used in a foreign key constraint '%-.192s'",
	ErrFkColumnCannotChangeChild:                             "Cannot change column '%-.192s': used in a foreign key constraint '%-.192s' of table '%-.192s'",
	ErrFkCannotDeleteParent:                                  "Cannot delete rows from table which is parent in a foreign key constraint '%-.192s' of table '%-.192s'",
	ErrMalformedPacket:                                       "Malformed communication packet.",
	ErrReadOnlyMode:                                          "Running in read-only mode",
	ErrGtidNextTypeUndefinedGroup:                            "When @@SESSION.GTIDNEXT is set to a GTID, you must explicitly set it again after a COMMIT or ROLLBACK. If you see this error message in the slave SQL thread, it means that a table in the current transaction is transactional on the master and non-transactional on the slave. In a client connection, it means that you executed SET @@SESSION.GTIDNEXT before a transaction and forgot to set @@SESSION.GTIDNEXT to a different identifier or to 'AUTOMATIC' after COMMIT or ROLLBACK. Current @@SESSION.GTIDNEXT is '%s'.",
	ErrVariableNotSettableInSp:                               "The system variable %.200s cannot be set in stored procedures.",
	ErrCantSetGtidPurgedWhenGtidModeIsOff:                    "@@GLOBAL.GTIDPURGED can only be set when @@GLOBAL.GTIDMODE = ON.",
	ErrCantSetGtidPurgedWhenGtidExecutedIsNotEmpty:           "@@GLOBAL.GTIDPURGED can only be set when @@GLOBAL.GTIDEXECUTED is empty.",
	ErrCantSetGtidPurgedWhenOwnedGtidsIsNotEmpty:             "@@GLOBAL.GTIDPURGED can only be set when there are no ongoing transactions (not even in other clients).",
	ErrGtidPurgedWasChanged:                                  "@@GLOBAL.GTIDPURGED was changed from '%s' to '%s'.",
	ErrGtidExecutedWasChanged:                                "@@GLOBAL.GTIDEXECUTED was changed from '%s' to '%s'.",
	ErrBinlogStmtModeAndNoReplTables:                         "Cannot execute statement: impossible to write to binary log since BINLOGFORMAT = STATEMENT, and both replicated and non replicated tables are written to.",
	ErrAlterOperationNotSupported:                            "%s is not supported for this operation. Try %s.",
	ErrAlterOperationNotSupportedReason:                      "%s is not supported. Reason: %s. Try %s.",
	ErrAlterOperationNotSupportedReasonCopy:                  "COPY algorithm requires a lock",
	ErrAlterOperationNotSupportedReasonPartition:             "Partition specific operations do not yet support LOCK/ALGORITHM",
	ErrAlterOperationNotSupportedReasonFkRename:              "Columns participating in a foreign key are renamed",
	ErrAlterOperationNotSupportedReasonColumnType:            "Cannot change column type INPLACE",
	ErrAlterOperationNotSupportedReasonFkCheck:               "Adding foreign keys needs foreignKeyChecks=OFF",
	ErrAlterOperationNotSupportedReasonIgnore:                "Creating unique indexes with IGNORE requires COPY algorithm to remove duplicate rows",
	ErrAlterOperationNotSupportedReasonNopk:                  "Dropping a primary key is not allowed without also adding a new primary key",
	ErrAlterOperationNotSupportedReasonAutoinc:               "Adding an auto-increment column requires a lock",
	ErrAlterOperationNotSupportedReasonHiddenFts:             "Cannot replace hidden FTSDOCID with a user-visible one",
	ErrAlterOperationNotSupportedReasonChangeFts:             "Cannot drop or rename FTSDOCID",
	ErrAlterOperationNotSupportedReasonFts:                   "Fulltext index creation requires a lock",
	ErrSQLSlaveSkipCounterNotSettableInGtidMode:              "sqlSlaveSkipCounter can not be set when the server is running with @@GLOBAL.GTIDMODE = ON. Instead, for each transaction that you want to skip, generate an empty transaction with the same GTID as the transaction",
	ErrDupUnknownInIndex:                                     "Duplicate entry for key '%-.192s'",
	ErrIdentCausesTooLongPath:                                "Long database name and identifier for object resulted in path length exceeding %d characters. Path: '%s'.",
	ErrAlterOperationNotSupportedReasonNotNull:               "cannot silently convert NULL values, as required in this SQLMODE",
	ErrMustChangePasswordLogin:                               "Your password has expired. To log in you must change it using a client that supports expired passwords.",
	ErrRowInWrongPartition:                                   "Found a row in wrong partition %s",
	ErrGeneratedColumnFunctionIsNotAllowed:                   "Expression of generated column '%s' contains a disallowed function.",
	ErrUnsupportedAlterInplaceOnVirtualColumn:                "INPLACE ADD or DROP of virtual columns cannot be combined with other ALTER TABLE actions.",
	ErrWrongFKOptionForGeneratedColumn:                       "Cannot define foreign key with %s clause on a generated column.",
	ErrBadGeneratedColumn:                                    "The value specified for generated column '%s' in table '%s' is not allowed.",
	ErrUnsupportedOnGeneratedColumn:                          "'%s' is not supported for generated columns.",
	ErrGeneratedColumnNonPrior:                               "Generated column can refer only to generated columns defined prior to it.",
	ErrDependentByGeneratedColumn:                            "Column '%s' has a generated column dependency.",
	ErrGeneratedColumnRefAutoInc:                             "Generated column '%s' cannot refer to auto-increment column.",
	ErrInvalidFieldSize:                                      "Invalid size for column '%s'.",
	ErrIncorrectType:                                         "Incorrect type for argument %s in function %s.",
	ErrInvalidJSONData:                                       "Invalid JSON data provided to function %s: %s",
	ErrInvalidJSONText:                                       "Invalid JSON text: %-.192s",
	ErrInvalidJSONPath:                                       "Invalid JSON path expression %s.",
	ErrInvalidTypeForJSON:                                    "Invalid data type for JSON data in argument %d to function %s; a JSON string or JSON type is required.",
	ErrInvalidJSONPathWildcard:                               "In this situation, path expressions may not contain the * and ** tokens.",
	ErrInvalidJSONContainsPathType:                           "The second argument can only be either 'one' or 'all'.",
	ErrJSONUsedAsKey:                                         "JSON column '%-.192s' cannot be used in key specification.",
	ErrJSONDocumentNULLKey:                                   "JSON documents may not contain NULL member names.",
	ErrSecureTransportRequired:                               "Connections using insecure transport are prohibited while --require_secure_transport=ON.",
	ErrBadUser:                                               "User %s does not exist.",
	ErrUserAlreadyExists:                                     "User %s already exists.",
	ErrInvalidJSONPathArrayCell:                              "A path expression is not a path to a cell in an array.",
	ErrInvalidEncryptionOption:                               "Invalid encryption option.",
	ErrWindowNoSuchWindow:                                    "Window name '%s' is not defined.",
	ErrWindowCircularityInWindowGraph:                        "There is a circularity in the window dependency graph.",
	ErrWindowNoChildPartitioning:                             "A window which depends on another cannot define partitioning.",
	ErrWindowNoInherentFrame:                                 "Window '%s' has a frame definition, so cannot be referenced by another window.",
	ErrWindowNoRedefineOrderBy:                               "Window '%s' cannot inherit '%s' since both contain an ORDER BY clause.",
	ErrWindowFrameStartIllegal:                               "Window '%s': frame start cannot be UNBOUNDED FOLLOWING.",
	ErrWindowFrameEndIllegal:                                 "Window '%s': frame end cannot be UNBOUNDED PRECEDING.",
	ErrWindowFrameIllegal:                                    "Window '%s': frame start or end is negative, NULL or of non-integral type",
	ErrWindowRangeFrameOrderType:                             "Window '%s' with RANGE N PRECEDING/FOLLOWING frame requires exactly one ORDER BY expression, of numeric or temporal type",
	ErrWindowRangeFrameTemporalType:                          "Window '%s' with RANGE frame has ORDER BY expression of datetime type. Only INTERVAL bound value allowed.",
	ErrWindowRangeFrameNumericType:                           "Window '%s' with RANGE frame has ORDER BY expression of numeric type, INTERVAL bound value not allowed.",
	ErrWindowRangeBoundNotConstant:                           "Window '%s' has a non-constant frame bound.",
	ErrWindowDuplicateName:                                   "Window '%s' is defined twice.",
	ErrWindowIllegalOrderBy:                                  "Window '%s': ORDER BY or PARTITION BY uses legacy position indication which is not supported, use expression.",
	ErrWindowInvalidWindowFuncUse:                            "You cannot use the window function '%s' in this context.'",
	ErrWindowInvalidWindowFuncAliasUse:                       "You cannot use the alias '%s' of an expression containing a window function in this context.'",
	ErrWindowNestedWindowFuncUseInWindowSpec:                 "You cannot nest a window function in the specification of window '%s'.",
	ErrWindowRowsIntervalUse:                                 "Window '%s': INTERVAL can only be used with RANGE frames.",
	ErrWindowNoGroupOrderUnused:                              "ASC or DESC with GROUP BY isn't allowed with window functions; put ASC or DESC in ORDER BY",
	ErrWindowExplainJSON:                                     "To get information about window functions use EXPLAIN FORMAT=JSON",
	ErrWindowFunctionIgnoresFrame:                            "Window function '%s' ignores the frame clause of window '%s' and aggregates over the whole partition",
	ErrRoleNotGranted:                                        "%s is is not granted to %s",
	ErrMaxExecTimeExceeded:                                   "Query execution was interrupted, max_execution_time exceeded.",
	ErrLockAcquireFailAndNoWaitSet:                           "Statement aborted because lock(s) could not be acquired immediately and NOWAIT is set.",
	ErrDataTruncatedFunctionalIndex:                          "Data truncated for functional index '%s' at row %d",
	ErrDataOutOfRangeFunctionalIndex:                         "Value is out of range for functional index '%s' at row %d",
	ErrFunctionalIndexOnJSONOrGeometryFunction:               "Cannot create a functional index on a function that returns a JSON or GEOMETRY value",
	ErrFunctionalIndexRefAutoIncrement:                       "Functional index '%s' cannot refer to an auto-increment column",
	ErrCannotDropColumnFunctionalIndex:                       "Cannot drop column '%s' because it is used by a functional index. In order to drop the column, you must remove the functional index",
	ErrFunctionalIndexPrimaryKey:                             "The primary key cannot be a functional index",
	ErrFunctionalIndexOnLob:                                  "Cannot create a functional index on an expression that returns a BLOB or TEXT. Please consider using CAST",
	ErrFunctionalIndexFunctionIsNotAllowed:                   "Expression of functional index '%s' contains a disallowed function",
	ErrFulltextFunctionalIndex:                               "Fulltext functional index is not supported",
	ErrSpatialFunctionalIndex:                                "Spatial functional index is not supported",
	ErrWrongKeyColumnFunctionalIndex:                         "The used storage engine cannot index the expression '%s'",
	ErrFunctionalIndexOnField:                                "Functional index on a column is not supported. Consider using a regular index instead",
	ErrFKIncompatibleColumns:                                 "Referencing column '%s' in foreign key constraint '%s' are incompatible",
	ErrFunctionalIndexRowValueIsNotAllowed:                   "Expression of functional index '%s' cannot refer to a row value",
	ErrDependentByFunctionalIndex:                            "Column '%s' has a functional index dependency and cannot be dropped or renamed",
	ErrInvalidJSONValueForFuncIndex:                          "Invalid JSON value for CAST for functional index '%s'",
	ErrJSONValueOutOfRangeForFuncIndex:                       "Out of range JSON value for CAST for functional index '%s'",
	ErrFunctionalIndexDataIsTooLong:                          "Data too long for functional index '%s'",
	ErrFunctionalIndexNotApplicable:                          "Cannot use functional index '%s' due to type or collation conversion",

	// MariaDB errors.
	ErrOnlyOneDefaultPartionAllowed:         "Only one DEFAULT partition allowed",
	ErrWrongPartitionTypeExpectedSystemTime: "Wrong partitioning type, expected type: `SYSTEM_TIME`",
	ErrSystemVersioningWrongPartitions:      "Wrong Partitions: must have at least one HISTORY and exactly one last CURRENT",
	ErrSequenceRunOut:                       "Sequence '%-.64s.%-.64s' has run out",
	ErrSequenceInvalidData:                  "Sequence '%-.64s.%-.64s' values are conflicting",
	ErrSequenceAccessFail:                   "Sequence '%-.64s.%-.64s' access error",
	ErrNotSequence:                          "'%-.64s.%-.64s' is not a SEQUENCE",
	ErrUnknownSequence:                      "Unknown SEQUENCE: '%-.300s'",
	ErrWrongInsertIntoSequence:              "Wrong INSERT into a SEQUENCE. One can only do single table INSERT into a sequence object (like with mysqldump).  If you want to change the SEQUENCE, use ALTER SEQUENCE instead.",
	ErrSequenceInvalidTableStructure:        "Sequence '%-.64s.%-.64s' table structure is invalid (%s)",

	// TiDB errors.
	ErrMemExceedThreshold:         "%s holds %dB memory, exceeds threshold %dB.%s",
	ErrForUpdateCantRetry:         "[%d] can not retry select for update statement",
	ErrAdminCheckTable:            "TiDB admin check table failed.",
	ErrTxnTooLarge:                "Transaction is too large, size: %d",
	ErrWriteConflictInTiDB:        "Write conflict, txnStartTS %d is stale",
	ErrInvalidPluginID:            "Wrong plugin id: %s, valid plugin id is [name]-[version], both name and version should not contain '-'",
	ErrInvalidPluginManifest:      "Cannot read plugin %s's manifest",
	ErrInvalidPluginName:          "Plugin load with %s but got wrong name %s",
	ErrInvalidPluginVersion:       "Plugin load with %s but got %s",
	ErrDuplicatePlugin:            "Plugin [%s] is redeclared",
	ErrInvalidPluginSysVarName:    "Plugin %s's sysVar %s must start with its plugin name %s",
	ErrRequireVersionCheckFail:    "Plugin %s require %s be %v but got %v",
	ErrUnsupportedReloadPlugin:    "Plugin %s isn't loaded so cannot be reloaded",
	ErrUnsupportedReloadPluginVar: "Reload plugin with different sysVar is unsupported %v",
	ErrTableLocked:                "Table '%s' was locked in %s by %v",
	ErrNotExist:                   "Error: key not exist",
	ErrTxnRetryable:               "Error: KV error safe to retry %s ",
	ErrCannotSetNilValue:          "can not set nil value",
	ErrInvalidTxn:                 "invalid transaction",
	ErrEntryTooLarge:              "entry too large, the max entry size is %d, the size of data is %d",
	ErrNotImplemented:             "not implemented",
	ErrInfoSchemaExpired:          "Information schema is out of date: schema failed to update in 1 lease, please make sure TiDB can connect to TiKV",
	ErrInfoSchemaChanged:          "Information schema is changed during the execution of the statement(for example, table definition may be updated by other DDL ran in parallel). If you see this error often, try increasing `tidb_max_delta_schema_count`",
	ErrBadNumber:                  "Bad Number",
	ErrCastAsSignedOverflow:       "Cast to signed converted positive out-of-range integer to it's negative complement",
	ErrCastNegIntAsUnsigned:       "Cast to unsigned converted negative integer to it's positive complement",
	ErrInvalidYearFormat:          "invalid year format",
	ErrInvalidYear:                "invalid year",
	ErrIncorrectDatetimeValue:     "Incorrect datetime value: '%s'",
	ErrInvalidTimeFormat:          "invalid time format: '%v'",
	ErrInvalidWeekModeFormat:      "invalid week mode format: '%v'",
	ErrFieldGetDefaultFailed:      "Field '%s' get default value fail",
	ErrIndexOutBound:              "Index column %s offset out of bound, offset: %d, row: %v",
	ErrUnsupportedOp:              "operation not supported",
	ErrRowNotFound:                "can not find the row: %s",
	ErrTableStateCantNone:         "table %s can't be in none state",
	ErrColumnStateCantNone:        "column %s can't be in none state",
	ErrColumnStateNonPublic:       "can not use non-public column",
	ErrIndexStateCantNone:         "index %s can't be in none state",
	ErrInvalidRecordKey:           "invalid record key",
	ErrUnsupportedValueForVar:     "variable '%s' does not yet support value: %s",
	ErrUnsupportedIsolationLevel:  "The isolation level '%s' is not supported. Set tidb_skip_isolation_level_check=1 to skip this error",
	ErrInvalidDDLWorker:           "Invalid DDL worker",
	ErrUnsupportedDDLOperation:    "Unsupported %s",
	ErrNotOwner:                   "TiDB server is not a DDL owner",
	ErrCantDecodeIndex:            "Cannot decode index value, because %s",
	ErrInvalidDDLJob:              "Invalid DDL job",
	ErrInvalidDDLJobFlag:          "Invalid DDL job flag",
	ErrWaitReorgTimeout:           "Timeout waiting for data reorganization",
	ErrInvalidStoreVersion:        "Invalid storage current version: %d",
	ErrUnknownTypeLength:          "Unknown length for type %d",
	ErrUnknownFractionLength:      "Unknown length for type %d and fraction %d",
	ErrInvalidDDLJobVersion:       "Version %d of DDL job is greater than current one: %d",
	ErrInvalidSplitRegionRanges:   "Failed to split region ranges",
	ErrReorgPanic:                 "Reorg worker panic",
	ErrInvalidDDLState:            "Invalid %s state: %v",
	ErrCancelledDDLJob:            "Cancelled DDL job",
	ErrRepairTable:                "Failed to repair table: %s",
	ErrLoadPrivilege:              "Load privilege table fail: %s",
	ErrInvalidPrivilegeType:       "unknown privilege type %s",
	ErrUnknownFieldType:           "unknown field type",
	ErrInvalidSequence:            "invalid sequence",
	ErrInvalidType:                "invalid type",
	ErrCantGetValidID:             "Cannot get a valid auto-ID when retrying the statement",
	ErrCantSetToNull:              "cannot set variable to null",
	ErrSnapshotTooOld:             "snapshot is older than GC safe point %s",
	ErrInvalidTableID:             "invalid TableID",
	ErrInvalidAutoRandom:          "Invalid auto random: %s",
	ErrInvalidHashKeyFlag:         "invalid encoded hash key flag",
	ErrInvalidListIndex:           "invalid list index",
	ErrInvalidListMetaData:        "invalid list meta data",
	ErrWriteOnSnapshot:            "write on snapshot",
	ErrInvalidKey:                 "invalid key",
	ErrInvalidIndexKey:            "invalid index key",
	ErrDataInConsistent:           "data isn't equal",
	ErrDDLJobNotFound:             "DDL Job:%v not found",
	ErrCancelFinishedDDLJob:       "This job:%v is finished, so can't be cancelled",
	ErrCannotCancelDDLJob:         "This job:%v is almost finished, can't be cancelled now",
	ErrUnknownAllocatorType:       "Invalid allocator type",
	ErrAutoRandReadFailed:         "Failed to read auto-random value from storage engine",
	ErrInvalidIncrementAndOffset:  "Invalid auto_increment settings: auto_increment_increment: %d, auto_increment_offset: %d, both of them must be in range [1..65535]",

	ErrWarnOptimizerHintInvalidInteger:  "integer value is out of range in '%s'",
	ErrWarnOptimizerHintUnsupportedHint: "Optimizer hint %s is not supported by TiDB and is ignored",
	ErrWarnOptimizerHintInvalidToken:    "Cannot use %s '%s' (tok = %d) in an optimizer hint",
	ErrWarnMemoryQuotaOverflow:          "Max value of MEMORY_QUOTA is %d bytes, ignore this invalid limit",
	ErrWarnOptimizerHintParseError:      "Optimizer hint syntax error at %v",

	ErrSequenceUnsupportedTableOption:      "Unsupported sequence table-option %s",
	ErrColumnTypeUnsupportedNextValue:      "Unsupported sequence default value for column type '%s'",
	ErrUnsupportedType:                     "Unsupported type %T",
	ErrAnalyzeMissIndex:                    "Index '%s' in field list does not exist in table '%s'",
	ErrCartesianProductUnsupported:         "Cartesian product is unsupported",
	ErrPreparedStmtNotFound:                "Prepared statement not found",
	ErrWrongParamCount:                     "Wrong parameter count",
	ErrSchemaChanged:                       "Schema has changed",
	ErrUnknownPlan:                         "Unknown plan",
	ErrPrepareMulti:                        "Can not prepare multiple statements",
	ErrPrepareDDL:                          "Can not prepare DDL statements with parameters",
	ErrResultIsEmpty:                       "Result is empty",
	ErrBuildExecutor:                       "Failed to build executor",
	ErrBatchInsertFail:                     "Batch insert failed, please clean the table and try again.",
	ErrGetStartTS:                          "Can not get start ts",
	ErrPrivilegeCheckFail:                  "privilege check fail", // this error message should begin lowercased to be compatible with the test
	ErrInvalidWildCard:                     "Wildcard fields without any table name appears in wrong place",
	ErrMixOfGroupFuncAndFieldsIncompatible: "In aggregated query without GROUP BY, expression #%d of SELECT list contains nonaggregated column '%s'; this is incompatible with sql_mode=only_full_group_by",
	ErrUnsupportedSecondArgumentType:       "JSON_OBJECTAGG: unsupported second argument type %v",

	// TiKV/PD errors.
	ErrPDServerTimeout:        "PD server timeout",
	ErrTiKVServerTimeout:      "TiKV server timeout",
	ErrTiKVServerBusy:         "TiKV server is busy",
	ErrResolveLockTimeout:     "Resolve lock timeout",
	ErrRegionUnavailable:      "Region is unavailable",
	ErrGCTooEarly:             "GC life time is shorter than transaction duration, transaction starts at %v, GC safe point is %v",
	ErrWriteConflict:          "Write conflict, txnStartTS=%d, conflictStartTS=%d, conflictCommitTS=%d, key=%s",
	ErrTiKVStoreLimit:         "Store token is up to the limit, store id = %d",
	ErrPrometheusAddrIsNotSet: "Prometheus address is not set in PD and etcd",
}
