//
// Copyright (c) 2017 XiaoMi All rights reserved.
//

#include "mace/ops/concat.h"

namespace mace {
namespace ops {

void Register_Concat(OperatorRegistry *op_registry) {
  REGISTER_OPERATOR(op_registry, OpKeyBuilder("Concat")
                                     .Device(DeviceType::CPU)
                                     .TypeConstraint<float>("T")
                                     .Build(),
                    ConcatOp<DeviceType::CPU, float>);
  REGISTER_OPERATOR(op_registry, OpKeyBuilder("Concat")
                                     .Device(DeviceType::OPENCL)
                                     .TypeConstraint<float>("T")
                                     .Build(),
                    ConcatOp<DeviceType::OPENCL, float>);
  REGISTER_OPERATOR(op_registry, OpKeyBuilder("Concat")
                                     .Device(DeviceType::OPENCL)
                                     .TypeConstraint<half>("T")
                                     .Build(),
                    ConcatOp<DeviceType::OPENCL, half>);
  REGISTER_OPERATOR(op_registry, OpKeyBuilder("Concat")
                                     .Device(DeviceType::NEON)
                                     .TypeConstraint<float>("T")
                                     .Build(),
                    ConcatOp<DeviceType::NEON, float>);
}

}  // namespace ops
}  // namespace mace
