// Copyright 2020 The MACE Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef MICRO_EXAMPLES_DATA_KWS_H_
#define MICRO_EXAMPLES_DATA_KWS_H_

// speech_commands_dataset/google_speech_commands/splitted_data/test/yes/1b4c9b89_nohash_1.wav
// clang-format off
static float data_kws_yes[98 * 40] = {
-44.89, -1.35,  0.99,  0.13, -0.37, -0.9 , -1.43, -0.4 , -0.35, -0.64,  0.33,  0.17, -0.19,  0.23, -0.3 , -0.33, -0.17,  0.34,  0.6 , -0.03, -0.74,  0.39, -0.07, -0.05,  0.03,  0.3 , -0.39, -0.43, -0.33, -0.49, -0.1 , -0.31, -0.73, -0.28, -0.34, -0.4 , -0.54, -0.06,  0.19,  0.24,
-45.04, -1.31,  0.75,  0.35,  0.07, -0.86, -1.23,  0.39, -0.71, -0.42,  0.64,  0.4 ,  0.45,  0.44,  0.5 ,  0.36, -0.47, -0.63, -0.02,  0.18, -0.44,  0.78,  0.28, -0.13,  0.14,  0.11, -0.14, -0.09, -0.25, -0.08,  0.02,  0.15, -0.22,  0.29, -0.19, -0.39, -0.26, -0.06,  0.09, -0.14,
-44.73, -0.97,  1.66, -0.16, -0.5 , -1.7 , -1.91,  0.2 , -0.92, -0.64,  0.09,  0.66, -0.36, -0.12,  0.65,  0.01, -0.55, -0.78, -0.7 , -0.45, -0.41, -0.04,  0.83,  0.05,  0.32,  0.16, -0.61, -0.28, -0.87, -0.55, -0.23,  0.26, -0.14,  0.11, -0.49, -0.7 , -0.75, -0.47,  0.22,  0.13,
-44.85, -0.92,  0.63, -0.89, -1.39, -1.89, -1.43,  0.38,  0.06, -0.01,  0.06,  0.67, -0.31, -0.12,  0.86,  0.32,  0.12, -0.48, -1.72, -1.9 , -1.21, -0.01,  0.57,  0.31,  0.41,  0.34, -0.38, -0.26, -1.1 , -0.02,  0.15,  0.29,  0.43,  0.3 ,  0.05, -0.07, -0.63, -0.01, -0.32, -0.12,
-44.73, -0.27,  1.15, -1.17, -1.25, -2.07, -1.58,  0.33,  0.73,  0.34, -0.21, -0.14,  0.28,  0.2 , -0.33,  0.72,  0.22, -0.97, -1.08, -1.59, -1.26,  0.45,  0.35,  0.74,  1.27,  1.11, -0.04, -1.31, -1.  ,  0.23,  0.25,  0.73,  0.15,  0.15,  0.13, -0.51, -0.78, -0.11, -0.18,  0.17,
-44.49, -0.47,  1.83,  0.01, -1.43, -2.24, -2.64, -0.45,  0.95,  0.53, -0.76, -0.85,  0.08,  0.19, -0.75, -0.6 , -0.31, -1.21, -1.72, -1.67, -1.37,  0.55,  0.38,  1.28,  1.35,  0.17, -0.56, -0.84, -1.34, -0.13,  0.42,  1.16, -0.31, -0.02,  0.82, -0.12,  0.31,  0.43, -0.39, -0.05,
-44.51,  0.27,  1.46, -1.51, -1.65, -1.17, -1.26, -0.55,  0.53,  0.75,  1.09,  0.27,  0.24,  0.72, -0.84, -1.15, -0.93, -1.85, -1.79, -1.52, -1.79, -1.2 , -0.15,  1.32,  0.82,  0.49, -0.39, -0.19, -0.83, -0.39,  0.04,  0.53, -0.17, -0.06,  0.85, -0.21, -0.57, -0.39, -0.35,  0.09,
-44.21, -0.23,  0.99, -1.6 , -2.04, -1.24, -0.91, -0.59, -0.62,  0.01,  0.88,  0.58,  0.77,  0.55,  0.09, -0.27, -0.54, -0.74, -1.  , -0.99, -0.94, -0.7 ,  0.41,  1.46,  0.97, -0.46, -1.12, -0.44, -0.1 ,  0.15,  0.56,  0.9 , -0.27, -0.46,  0.24, -0.15, -0.37,  0.05,  0.1 ,  0.3 ,
-43.8 ,  0.31,  1.09, -1.  , -1.23, -0.9 , -0.67, -1.09, -0.6 ,  0.04,  1.09,  0.57,  0.97,  0.78,  0.46, -0.21, -1.13, -0.11, -0.62, -0.52, -1.  , -1.51,  0.4 ,  0.91,  0.47, -0.2 , -0.2 , -0.29, -0.55,  0.48, -0.09,  0.5 , -0.21, -0.16,  0.36, -0.15, -0.07, -0.31, -0.46,  0.26,
-42.98,  0.38,  1.25, -0.87, -0.74, -0.48, -1.4 , -0.95, -2.06,  0.06,  1.74,  0.45,  1.07,  0.93,  0.6 ,  0.44, -0.81, -0.76, -0.14, -0.37, -0.33, -0.79, -0.08,  0.42,  0.64, -0.42, -0.49, -0.83, -0.97,  0.34,  0.18,  0.18, -0.25,  0.15,  0.36, -0.21, -0.31, -0.02, -0.66,  0.14,
-43.47, -0.22,  0.98, -0.73, -1.34, -0.63, -1.71, -2.36, -2.27, -0.22,  0.69, -0.45, -0.44, -0.93,  0.31,  0.84, -0.36, -1.56, -1.77, -1.12, -0.7 , -1.69, -0.96,  0.19,  0.22, -0.62, -0.77, -0.48, -0.49,  0.74,  0.34,  0.33, -0.13,  0.19,  0.54, -0.38, -0.09, -0.08, -0.7 , -0.26,
-40.58,  2.42,  3.86,  1.07, -0.08,  1.06, -0.27, -1.88, -1.96, -0.06,  0.87, -0.88, -1.11, -0.86, -0.72,  0.44, -0.7 , -1.09, -0.63,  0.26,  0.56, -0.48, -0.08,  0.18,  0.81,  0.84, -0.72,  0.08,  0.15,  0.3 , -0.41, -0.13, -0.47, -0.22, -0.66, -0.95,  0.36,  0.47,  0.35, -0.16,
-30.63,  5.5 ,  7.67,  1.49,  1.11,  0.08, -2.62, -2.58, -1.61,  0.04, -0.34, -2.59, -1.08, -0.79, -1.11,  0.12, -2.28, -0.39, -0.02,  0.43,  0.3 , -0.08, -0.97,  0.45, -0.27,  0.46, -1.06, -0.06, -0.01, -0.16, -0.32,  0.18, -0.06, -0.49,  0.23, -0.46, -0.17,  0.27, -0.26, -0.21,
-23.7 ,  5.92,  8.26,  1.79, -1.58,  0.32, -3.54, -2.29, -1.89, -1.11, -0.6 , -3.36, -0.73, -0.66, -1.49, -1.37, -2.87, -0.23, -1.15,  0.18,  0.13, -0.27, -0.42,  1.24,  0.26, -0.04, -0.9 , -0.26, -0.4 , -0.34,  0.17, -0.08,  0.14, -0.3 ,  0.14, -0.1 ,  0.5 ,  0.09, -0.15,  0.21,
-20.41,  5.76,  8.87,  2.16, -3.84,  0.8 , -3.07, -0.3 , -1.21, -1.29,  0.39, -1.81,  0.52, -0.46, -1.18, -1.07, -2.39, -1.82, -1.47, -0.07, -1.03, -0.29,  0.27,  1.35,  0.68,  1.06, -0.28,  0.38, -0.71, -0.51,  0.33,  0.18,  0.62,  0.31, -0.09, -0.13,  0.3 , -0.  ,  0.35,  0.29,
-16.62,  5.57,  7.72,  3.08, -5.01,  1.33, -3.02,  0.9 , -1.33, -1.08,  1.04, -1.93,  1.08, -0.5 , -1.92, -1.18, -1.59, -1.83, -1.65, -0.77, -2.08, -0.32, -0.21,  1.61,  1.74,  1.41,  0.39,  0.69, -0.43, -0.58, -0.13, -0.56,  0.52, -0.24, -0.31,  0.19,  0.06,  0.01,  0.45,  0.13,
-14.  ,  4.68,  6.43,  4.07, -6.68,  1.08, -2.65,  0.83, -1.69, -0.75,  1.04, -2.29,  1.32, -0.69, -1.83, -2.7 , -1.66, -1.77, -1.68, -1.04, -2.47, -0.43,  0.68,  2.06,  1.64,  1.44,  0.36,  0.29, -0.74, -0.89, -0.57, -0.68,  0.97, -0.11, -0.31,  0.13, -0.17, -0.03,  0.39,  0.19,
-12.78,  4.39,  5.95,  4.88, -7.19,  0.37, -2.62,  0.29, -2.01, -0.74, -0.1 , -2.34,  1.3 , -0.49, -1.01, -3.36, -1.41, -1.35, -1.55, -1.82, -2.38, -0.87, -0.02,  1.38,  1.  ,  1.32,  0.36,  0.9 , -0.71, -1.36, -0.61, -0.69,  1.31,  0.41, -0.29,  0.23,  0.34, -0.08,  0.16, -0.08,
-10.62,  4.2 ,  5.31,  5.65, -7.15,  0.33, -2.05, -0.71, -1.05,  0.26, -0.8 , -1.84,  1.35, -0.42, -0.63, -3.38, -1.35, -1.8 , -1.98, -1.5 , -1.59, -0.8 , -0.3 ,  1.52,  0.94,  1.88,  1.04,  0.93, -0.86, -1.03, -0.47, -0.17,  0.56,  0.36, -0.26,  0.05, -0.04,  0.07,  0.35,  0.46,
 -8.94,  4.54,  5.63,  7.13, -7.9 , -0.35, -2.27, -1.07, -0.78,  0.02, -0.47, -1.27,  1.6 , -0.48, -1.44, -2.38, -0.83, -1.54, -2.21, -1.45, -0.91, -0.68, -0.79,  1.89,  0.51,  1.84,  0.99,  0.96, -0.37, -1.47, -0.82, -0.12,  1.05,  0.83,  0.09, -0.24, -0.58, -0.02,  0.3 ,  0.48,
 -6.8 ,  4.53,  3.75,  6.32, -7.55, -0.35, -1.42, -0.74, -1.47, -0.16,  0.54, -0.79,  1.39, -0.75, -1.5 , -2.04, -1.34, -2.2 , -2.79, -2.04, -0.45, -0.65, -0.67,  1.85,  0.89,  2.39,  0.59,  1.09, -0.39, -0.83, -0.86, -0.81,  0.7 ,  0.73,  0.16, -0.25, -0.35, -0.19,  0.44,  0.88,
 -4.24,  4.77,  2.41,  6.13, -6.42, -1.08, -1.41, -1.1 , -2.56, -0.02,  0.69, -0.61,  1.32, -1.21, -1.47, -1.54, -1.07, -2.19, -2.35, -2.05, -0.76, -0.77, -1.07,  1.56,  1.4 ,  2.26,  0.6 ,  0.68, -0.48, -0.82, -1.11, -0.66,  1.04,  1.01,  0.05, -0.23, -0.35, -0.5 ,  0.76,  0.31,
 -1.88,  5.5 ,  1.56,  6.08, -6.31, -2.14, -1.35, -0.75, -2.83, -0.15,  1.07, -0.55,  0.9 , -1.4 , -1.82, -1.17, -0.95, -1.98, -1.78, -1.33, -0.67, -0.65, -0.92,  1.67,  0.78,  1.97,  0.54,  0.72, -0.34, -1.04, -1.15, -0.23,  1.02,  1.03,  0.03, -0.23, -0.74, -0.21,  1.14,  0.62,
 -0.88,  5.98, -0.15,  5.6 , -6.56, -1.91, -0.83,  0.26, -2.67, -0.06,  0.96, -1.09,  0.58, -1.83, -1.23, -0.92, -1.18, -1.99, -2.38, -1.48, -0.99, -0.5 , -0.89,  2.1 ,  0.87,  1.91,  0.32,  0.9 , -0.55, -1.26, -1.4 , -0.49,  1.11,  0.86, -0.06, -0.2 , -0.23,  0.26,  1.12,  0.59,
 -0.15,  6.05, -0.3 ,  5.39, -6.8 , -2.08, -1.67,  0.4 , -2.63, -0.37,  0.6 , -1.5 ,  0.29, -1.28, -1.11, -1.3 , -1.38, -1.44, -1.92, -1.53, -1.41, -0.55, -1.36,  1.53,  0.76,  1.71,  0.36,  0.84, -0.51, -1.54, -0.65, -0.34,  0.98,  0.93, -0.18, -0.13, -0.61,  0.17,  0.87,  0.58,
  0.64,  5.24, -0.64,  5.1 , -6.04, -1.78, -1.56,  1.3 , -2.35, -0.45,  0.19, -0.76, -0.23, -1.09, -0.86, -1.3 , -1.3 , -1.55, -1.7 , -2.49, -1.38, -0.5 , -1.44,  1.99,  0.97,  2.6 ,  0.68,  0.77, -0.15, -1.59, -0.94, -0.74,  1.06,  1.44, -0.19, -0.18, -0.69, -0.32,  0.98,  0.59,
  1.19,  5.41, -0.69,  4.08, -5.65, -1.63, -1.23,  1.41, -2.04, -0.45, -0.05, -1.  , -0.11, -0.79, -1.08, -1.3 , -0.56, -2.12, -1.2 , -2.42, -1.41, -0.43, -1.54,  1.42,  1.14,  2.36,  0.68,  1.09, -0.27, -1.45, -1.05, -0.95,  0.92,  0.96,  0.57,  0.02, -0.77, -0.26,  1.12,  0.38,
  2.17,  4.88, -1.04,  3.79, -6.26, -2.31, -1.15,  1.32, -1.94, -0.29,  0.76, -0.93, -0.51, -1.1 , -1.28, -1.85, -1.32, -2.07, -1.36, -2.01, -1.47, -0.48, -1.57,  1.11,  0.87,  2.5 ,  0.71,  0.83,  0.28, -1.13, -0.99, -0.49,  0.74,  0.84,  0.02, -0.2 , -1.13,  0.03,  1.01,  0.64,
  1.98,  4.9 , -1.71,  3.65, -5.56, -2.68, -1.5 ,  1.12, -1.38, -1.03,  0.6 , -1.15, -0.61, -1.13, -1.25, -1.63, -1.6 , -1.8 , -1.47, -2.31, -2.04, -0.5 , -1.35,  0.81,  0.88,  2.1 ,  1.12,  0.92,  0.15, -1.2 , -1.12, -0.66,  0.65,  1.01,  0.06, -0.2 , -1.25, -0.27,  0.92,  0.4 ,
  2.19,  4.83, -1.07,  2.77, -4.97, -1.63, -1.74,  1.72, -1.67, -0.47,  0.63, -1.42, -0.1 , -1.33, -0.97, -0.66, -1.4 , -1.96, -1.17, -1.85, -1.9 , -1.15, -1.37,  0.94,  1.01,  2.09,  0.95,  1.45,  0.1 , -1.2 , -1.64, -0.77,  1.13,  0.99,  0.45,  0.09, -1.16, -0.32,  0.67,  0.66,
  2.58,  5.07, -1.55,  2.55, -4.88, -1.43, -2.32,  1.79, -1.93, -0.57,  0.32, -1.2 , -0.34, -1.87, -0.56, -1.15, -1.31, -1.64, -0.93, -2.37, -1.65, -0.76, -1.89,  0.91,  0.57,  2.22,  0.91,  1.65, -0.31, -1.22, -1.38, -0.58,  0.6 ,  1.1 ,  0.72, -0.04, -0.89, -0.26,  0.25,  0.79,
  3.32,  4.62, -1.6 ,  3.  , -4.52, -1.64, -2.64,  3.01, -2.01, -0.43,  0.46, -1.22,  0.09, -1.76, -0.69, -1.15, -1.29, -1.39, -1.04, -2.32, -1.54, -0.72, -1.85,  1.  ,  0.57,  2.53,  1.08,  1.6 , -0.25, -0.95, -1.45, -0.42,  0.76,  1.14,  0.49,  0.14, -1.17, -0.46,  0.35,  0.85,
  2.17,  4.74, -2.02,  3.29, -4.59, -1.09, -2.04,  2.6 , -1.93, -1.05, -0.05, -1.57,  0.34, -1.73, -0.59, -0.88, -0.79, -1.49, -1.23, -2.2 , -1.9 , -1.02, -1.75,  1.32,  0.78,  2.53,  1.26,  1.44, -0.35, -1.26, -1.81, -0.49,  0.63,  1.27,  0.95,  0.63, -1.03, -0.83,  0.15,  0.55,
  2.5 ,  5.01, -2.89,  2.97, -4.66, -1.86, -2.03,  2.68, -2.41, -0.83, -0.19, -1.84,  0.09, -1.78, -0.75, -0.84, -1.12, -1.59, -1.25, -2.08, -2.03, -1.25, -1.51,  0.94,  0.39,  2.29,  0.69,  1.33, -0.28, -1.23, -1.4 , -0.64,  0.65,  1.08,  0.5 ,  0.54, -0.74, -0.55,  0.43,  0.41,
  1.96,  5.42, -2.5 ,  3.  , -4.28, -1.9 , -2.37,  3.  , -2.23, -0.47, -0.05, -1.68,  0.48, -1.57, -0.35, -0.86, -1.21, -1.26, -1.36, -1.98, -1.9 , -1.3 , -1.44,  0.83,  0.27,  2.21,  0.83,  1.54,  0.18, -1.56, -1.28, -0.52,  0.31,  1.44,  0.63,  0.36, -1.07, -0.45,  0.22,  0.68,
  0.91,  5.38, -2.65,  3.5 , -4.2 , -1.86, -2.06,  2.66, -2.  , -0.69, -0.14, -2.  ,  0.42, -1.94, -0.44, -0.56, -1.19, -1.42, -1.29, -2.33, -1.49, -1.46, -1.28,  0.72,  0.52,  2.33,  1.39,  1.19, -0.15, -1.89, -1.54, -0.86,  0.83,  1.25,  0.96,  0.16, -0.75, -0.92,  0.6 ,  0.67,
  1.25,  5.63, -3.01,  3.37, -4.19, -1.91, -2.51,  3.2 , -2.1 , -0.5 ,  0.24, -1.75,  0.7 , -2.27, -0.58, -0.76, -1.67, -1.58, -1.44, -2.11, -1.6 , -1.49, -0.86,  0.75,  0.82,  2.09,  1.5 ,  1.16,  0.43, -1.53, -1.36, -0.76,  0.9 ,  0.73,  0.54, -0.06, -0.67, -0.96,  0.39,  0.7 ,
  1.07,  5.51, -2.91,  3.37, -4.23, -1.75, -2.61,  3.29, -1.91, -0.4 , -0.05, -1.49,  0.19, -1.5 , -0.79, -0.89, -1.47, -1.43, -1.15, -2.14, -1.65, -0.98, -0.99,  0.56,  1.1 ,  2.07,  1.2 ,  1.17,  0.21, -1.24, -1.72, -0.46,  1.15,  0.89,  0.77, -0.42, -0.71, -0.37,  0.38,  0.87,
  0.04,  5.62, -2.34,  3.14, -3.98, -1.39, -2.56,  2.89, -1.67, -0.12, -0.36, -1.  , -0.02, -1.47, -0.59, -1.2 , -1.39, -1.31, -0.91, -2.12, -1.51, -0.73, -0.35,  0.15,  1.21,  2.52,  0.94,  1.14, -0.3 , -1.2 , -1.4 , -0.63,  1.07,  1.19,  0.77, -0.44, -0.57, -0.25,  0.32,  1.09,
 -0.39,  5.5 , -2.03,  3.28, -4.07, -1.63, -2.96,  2.6 , -2.11, -0.14, -0.33, -0.94,  0.45, -1.84, -0.8 , -1.26, -1.25, -1.62, -0.85, -2.  , -1.81, -0.82, -0.46,  0.43,  1.48,  2.59,  0.65,  0.89, -0.7 , -0.97, -1.33, -0.19,  1.27,  0.85,  0.6 , -1.06, -0.68,  0.04,  0.94,  0.7 ,
 -1.24,  5.17, -2.24,  2.95, -4.22, -2.11, -3.4 ,  3.09, -2.63, -0.24, -0.24, -1.12, -0.14, -2.24, -1.01, -0.96, -1.37, -2.17, -1.25, -1.8 , -2.02, -0.91, -0.49,  0.25,  1.23,  2.12,  0.44,  1.25, -0.76, -1.08, -1.61, -0.18,  1.03,  0.57,  0.15, -0.96, -0.2 , -0.02,  0.77,  0.52,
 -3.35,  5.05, -2.34,  2.27, -3.37, -2.33, -3.07,  3.44, -2.09, -0.32, -0.52, -1.26,  0.46, -2.71, -1.45, -1.35, -1.97, -2.73, -1.42, -2.33, -1.94, -0.6 , -0.28,  0.55,  1.75,  2.77,  0.53,  1.33, -1.12, -1.23, -1.59, -0.23,  0.68,  0.44, -0.12, -0.9 , -0.27, -0.27,  1.24,  0.53,
 -3.5 ,  6.71, -1.67,  2.93, -2.73, -2.89, -2.96,  3.07, -1.77, -0.12, -0.86, -0.33,  0.95, -2.41, -1.35, -1.14, -1.6 , -1.74, -0.98, -1.92, -1.45, -0.34,  0.25,  0.47,  1.15,  2.29,  0.37,  1.1 , -0.95, -0.76, -0.94,  0.13,  0.45,  1.02, -0.11, -0.99, -0.49, -0.45,  1.16,  0.74,
 -5.66,  7.54, -1.41,  3.07, -1.83, -2.61, -2.84,  2.33, -1.98,  0.15, -1.03, -0.41,  0.95, -2.4 , -0.69, -0.76, -1.62, -1.87, -0.9 , -1.47, -1.33, -0.57,  0.7 ,  0.67,  1.35,  2.02,  0.86,  0.38, -1.3 , -0.87, -0.88,  0.37,  0.59,  1.28, -0.11, -0.95, -0.18,  0.3 ,  0.85,  0.53,
 -7.53,  7.39, -0.67,  3.04, -1.46, -2.83, -3.09,  1.52, -1.42,  0.02, -1.26, -0.99,  0.93, -2.49, -0.16, -0.29, -1.47, -2.18, -1.73, -1.07, -1.36, -0.22,  0.77,  0.43,  1.44,  1.94,  1.16,  0.14, -1.47, -0.99, -0.59,  0.54,  1.07,  1.21, -0.4 , -0.64, -0.01,  0.32,  0.73,  0.15,
-10.08,  7.08, -0.71,  2.43, -1.03, -2.69, -2.64,  0.03, -1.3 , -0.27, -1.21, -1.01,  1.28, -2.91, -0.93, -0.78, -2.06, -2.51, -2.01, -1.02, -2.41, -0.37,  1.32,  1.43,  2.13,  1.45,  1.08, -0.36, -1.63, -0.95, -0.92,  0.81,  1.11,  1.02, -0.85, -1.14, -0.32,  0.55,  0.41,  0.1 ,
-11.46,  7.97, -0.12,  2.17, -0.8 , -2.74, -2.68, -0.41, -1.98, -0.41, -1.52, -0.68,  0.81, -2.63, -0.82, -0.73, -2.02, -2.58, -2.03, -0.69, -2.06, -0.19,  0.66,  1.55,  2.28,  0.61,  0.56,  0.07, -1.65, -1.21, -0.27,  0.84,  1.13,  0.58, -1.  , -0.52,  0.06,  0.01,  0.64,  0.18,
-14.22,  8.09,  1.04,  2.73, -1.06, -2.99, -2.39, -1.12, -1.26, -0.38, -1.56, -0.65,  0.9 , -1.64, -1.29, -0.95, -1.68, -2.26, -2.29, -0.47, -1.26,  0.06,  0.66,  1.02,  2.14,  0.07,  0.71,  0.29, -1.62, -0.62,  0.12,  1.17,  0.21,  0.02,  0.29, -0.32, -0.22, -0.01,  0.55, -0.24,
-18.32,  8.04,  1.98,  2.64, -0.5 , -3.72, -3.02, -0.6 ,  0.05, -0.55, -1.85, -0.28,  0.59, -1.54, -1.64, -0.8 , -1.73, -2.41, -2.67, -0.17, -1.2 ,  0.58,  0.99,  0.2 ,  2.5 ,  0.4 ,  0.23,  0.47, -1.37, -0.28, -0.37,  1.  ,  0.3 , -0.58,  0.2 , -0.45,  0.39,  0.18, -0.09, -0.23,
-18.67,  6.73,  2.71,  2.7 ,  0.38, -3.07, -2.17, -1.72, -0.77, -1.27, -2.74, -0.34,  0.44, -1.43, -1.75, -0.69, -1.45, -1.71, -2.99,  0.29, -0.85,  1.5 ,  1.15, -0.35,  1.58,  0.56, -0.05, -0.29, -0.2 , -0.35, -0.13,  0.1 , -0.1 , -0.71,  0.59, -0.21,  0.04,  0.42, -0.65,  0.38,
-18.72,  4.44,  3.88,  1.9 ,  1.14, -3.24, -0.78, -1.4 ,  0.31, -0.61, -2.81, -0.9 ,  0.09, -1.28, -1.59, -0.75, -1.69, -2.11, -2.89,  0.23,  0.66,  1.43,  1.24, -0.74,  0.47, -0.31, -0.35,  0.14,  0.46, -0.71,  0.56,  0.6 , -0.38, -0.13,  0.03, -0.57,  0.33,  0.66, -0.37, -0.27,
-17.44,  0.95,  4.47,  1.02,  0.62, -3.11, -0.17, -0.38,  0.77, -0.7 , -1.87, -1.16,  0.32, -0.48, -0.65, -0.74, -1.64, -2.  , -2.01, -0.53,  0.82,  1.41,  1.24, -0.05,  0.4 , -0.73, -0.52,  0.6 ,  1.09, -1.05,  0.55,  0.72, -1.46, -0.09,  0.01, -0.98,  0.15,  0.72, -0.  , -0.19,
-17.43, -2.28,  4.38, -0.31, -0.37, -3.6 , -0.38, -0.42,  0.61, -0.68, -0.74, -1.15, -0.21, -0.74, -0.42, -0.9 , -1.24, -1.88, -1.27,  0.37,  0.67,  1.26,  0.97,  1.21,  0.25, -1.04, -0.91,  0.12,  1.19, -1.18,  0.68,  0.57, -1.06, -0.21,  0.44, -0.21,  0.34,  0.17, -0.25, -0.26,
-19.1 , -3.72,  4.63, -0.79, -1.24, -4.14, -0.5 , -0.2 ,  0.72, -0.82, -0.43, -1.13, -0.84, -1.15,  0.55, -0.77, -1.47, -0.72, -0.74,  0.79,  0.35,  0.78,  0.76,  0.26, -0.44, -0.96, -0.28,  0.14,  0.47, -0.84, -0.28, -0.38, -0.19,  0.08,  0.21,  0.21,  0.37, -0.29, -0.01,  0.07,
-20.31, -5.44,  4.49, -0.96, -1.03, -4.17, -1.61, -0.61, -0.1 , -1.47, -0.29,  0.02, -0.13, -0.46,  0.04, -1.26, -1.09, -0.6 , -0.61,  0.6 , -0.54, -0.26, -0.19,  0.28,  0.29, -0.85, -0.5 , -0.17,  1.03, -0.33, -0.33,  0.12,  0.42,  0.1 , -0.48, -0.17, -0.35,  0.57,  0.22, -0.03,
-19.91, -6.34,  4.5 , -2.06, -0.3 , -3.67, -1.05, -1.14,  0.06, -0.68, -0.36,  0.71,  0.12, -0.61, -0.71, -1.84, -0.42, -0.63, -0.68,  0.49,  0.84,  0.54,  0.04,  0.13, -0.04, -0.76,  0.2 , -0.89,  0.42, -0.31, -0.89, -0.03, -0.39, -0.09, -0.92, -0.41, -0.26,  0.71,  0.79,  0.02,
-17.95, -6.59,  4.74, -2.04,  0.27, -2.92, -0.8 , -1.45, -0.08, -0.98, -0.09,  0.88, -0.75, -0.64, -0.66, -1.12, -0.82, -1.15, -1.1 , -0.64,  0.82,  0.84, -0.17, -0.24, -0.38,  0.17,  0.64, -0.39,  0.43, -0.01, -0.79, -0.04,  0.11, -0.01, -0.87, -0.45, -0.53,  0.5 ,  0.25, -0.74,
-18.89, -7.41,  4.77, -3.02,  0.42, -2.94, -0.14, -0.72, -0.7 , -2.04, -0.74,  0.59, -0.09,  0.08, -0.89, -1.64, -0.94, -1.08, -0.16, -0.44,  1.24,  0.59,  0.63,  0.21, -0.44, -0.16,  0.53,  0.61,  0.79,  0.32, -0.54,  0.36, -0.22, -0.22, -0.78, -0.16,  0.21,  0.42,  0.21, -0.34,
-20.96, -7.89,  4.76, -3.29, -0.23, -2.75,  0.29, -0.91, -0.25, -1.55, -0.07,  0.08, -0.36, -0.  , -1.35, -1.89, -1.29, -1.01, -0.62, -0.76,  0.4 , -0.12,  0.4 ,  0.34, -0.87, -1.51, -0.22,  0.5 , -0.14,  0.01,  0.06,  0.22, -0.68, -0.26, -0.79, -0.43, -0.14, -0.03,  0.49, -0.24,
-20.41, -6.75,  4.22, -4.34, -0.04, -2.71, -0.17, -0.43,  0.56, -1.04,  0.15,  0.27,  0.18, -1.06, -1.2 , -2.3 , -1.18, -1.16, -0.8 , -0.31,  0.34,  0.17,  0.69, -0.22, -1.05, -1.04, -0.81,  0.57,  0.26,  0.06, -0.46,  0.23, -0.41, -0.32, -0.53,  0.17,  0.09, -0.53,  0.71, -0.07,
-20.87, -6.75,  3.79, -4.44,  2.23, -1.63, -0.05, -0.24,  0.08, -2.45, -0.43, -0.62, -0.2 , -0.83, -1.16, -2.31, -0.49, -0.46, -1.13,  0.19,  0.45,  0.13, -0.03, -0.11, -0.54, -0.79, -0.64,  0.65,  0.3 , -0.22, -0.54,  0.05, -0.58,  0.18, -0.2 ,  0.03, -0.24, -0.37,  0.19,  0.28,
-19.59, -6.88,  3.56, -4.03,  3.2 , -1.26, -0.  , -0.54,  0.06, -1.68, -0.99, -0.25, -0.69, -0.92, -1.18, -2.7 , -0.74,  0.39,  0.23,  0.28, -0.11, -0.01,  0.08,  0.18,  0.16, -0.84,  0.14,  0.92,  0.77,  0.58, -0.55, -0.43,  0.07,  0.51, -0.66, -0.54, -0.64, -0.03,  0.27,  0.28,
-18.27, -6.64,  3.51, -3.95,  2.51, -1.73, -1.23, -2.08,  0.02, -1.59, -0.8 ,  0.3 , -0.59, -1.79, -1.63, -2.8 , -2.1 ,  0.39,  0.53, -0.37,  0.09,  0.34, -0.23, -0.  , -0.15, -0.95,  0.55,  0.95,  0.95,  0.27, -0.87, -0.48,  0.21, -0.11, -0.78, -0.01,  0.37, -0.34,  0.15, -0.11,
-16.11, -6.92,  3.46, -2.78,  3.18, -1.97, -0.46, -2.28, -0.05,  0.09,  0.64,  0.92, -0.46, -1.25, -1.24, -2.5 , -2.06, -1.07,  0.92, -0.8 ,  0.15,  0.03,  0.02, -0.12,  0.01, -0.73,  0.41,  0.51,  0.45,  0.23, -0.63, -0.35,  0.76,  0.13, -0.74, -0.41, -0.19,  0.02,  0.82,  0.28,
-15.23, -7.11,  3.65, -3.43,  2.29, -2.05, -0.62, -2.5 , -0.59,  0.36,  0.36,  0.46, -0.67, -2.22, -1.72, -2.1 , -2.71, -1.96,  0.79, -0.53, -0.07, -0.68,  0.27, -0.35, -0.1 , -0.26,  0.12,  0.61, -0.1 ,  0.06, -0.19, -0.18,  0.46,  0.15, -0.84, -0.52, -0.06,  0.56,  0.51, -0.38,
-14.86, -5.97,  4.23, -4.  ,  1.81, -1.25, -0.08, -3.03,  0.09,  0.9 ,  0.76,  0.09, -0.57, -1.51, -1.79, -2.4 , -2.68, -2.2 ,  0.48, -0.14,  0.45,  0.19,  1.13,  0.09, -0.44, -0.92,  0.03,  0.6 , -0.28, -0.02, -0.25, -0.36,  0.73,  0.79, -0.1 , -0.64, -0.32,  0.11, -0.36, -0.39,
-14.71, -5.84,  4.19, -4.63,  1.29, -0.86,  0.55, -2.79, -0.13,  1.1 ,  0.44, -0.56, -0.01, -1.06, -1.68, -2.74, -2.09, -2.33,  0.23, -0.19,  0.75,  1.04,  1.38,  0.42,  0.06, -0.78, -0.32,  0.52, -0.23,  0.16, -0.57, -0.09,  0.86,  0.54, -0.03, -0.51, -0.5 ,  0.28, -0.06,  0.12,
-14.96, -5.79,  4.54, -3.81,  1.32, -0.61,  0.67, -2.61, -0.79,  0.71,  0.31, -0.75, -0.44, -0.73, -1.63, -2.48, -1.74, -1.48,  0.95, -0.69,  0.83,  0.47,  0.13,  0.58,  0.04, -0.08, -0.56,  0.39,  0.15, -0.27, -1.08, -0.16,  0.75, -0.1 , -0.85, -0.55, -0.62, -0.2 ,  0.11,  0.82,
-15.02, -5.15,  4.73, -3.72,  1.77, -1.1 ,  0.01, -1.68, -0.76,  0.58,  0.56, -0.33, -1.07, -1.15, -0.86, -1.73, -2.08, -1.56,  1.02, -0.4 ,  0.24,  0.26, -0.08,  0.04, -1.12, -0.39, -0.94,  0.5 ,  0.26,  0.06, -0.36, -0.23,  0.73,  0.45, -0.89, -0.47, -0.39,  0.02, -0.24,  0.54,
-15.79, -6.  ,  3.39, -4.75,  1.64, -1.14,  0.21, -1.07, -0.32, -0.67,  0.19, -0.12, -1.75, -1.41, -0.91, -0.93, -1.23, -1.53,  0.97, -0.69,  0.18,  0.78,  0.61,  0.64, -0.97, -0.15,  0.02,  0.13,  0.14, -0.29, -0.47, -0.61, -0.36,  0.7 , -0.99, -0.53, -0.01,  0.29,  0.25,  0.63,
-16.02, -5.3 ,  4.41, -4.48,  1.44, -1.95, -0.11, -0.64, -0.01, -0.24, -0.04, -0.41, -1.5 , -1.55, -0.88, -0.85, -1.31, -1.79,  0.28, -1.1 , -0.41,  0.95,  0.54,  0.23, -0.44, -0.2 ,  0.22,  1.45,  0.48, -0.5 ,  0.03,  0.24,  0.14,  0.82, -0.77, -0.65,  0.11, -0.16, -0.43, -0.14,
-13.64, -4.42,  5.16, -3.28,  0.83, -2.48,  0.53, -1.11, -0.25, -0.16, -0.24,  0.04, -1.2 , -1.94, -1.9 , -1.09, -0.92, -2.27,  0.13, -0.68, -0.3 ,  1.03,  0.03, -0.12, -1.46, -1.02, -0.  ,  1.1 ,  0.15, -0.57, -0.14, -0.04,  0.16,  0.47, -0.05, -0.35, -0.37, -0.38,  0.03, -0.69,
-13.44, -3.74,  4.8 , -2.37,  0.64, -2.17,  0.79, -1.4 , -1.52, -1.36, -0.08, -0.13, -0.84, -1.36, -0.79, -0.74,  0.23, -0.53,  0.21, -0.52, -0.53,  0.62, -0.22,  0.38, -1.06, -1.08,  0.46,  0.35, -0.24, -0.68, -0.2 ,  0.04, -0.13, -0.3 , -0.15, -0.45, -0.57, -0.8 ,  0.17, -0.56,
-13.07, -3.63,  4.09, -1.67,  0.98, -2.32,  0.12, -0.82, -2.04, -2.17, -0.11,  0.35, -0.14, -1.52, -0.59, -0.78,  0.22,  0.36,  0.3 , -0.87, -0.18, -0.33, -0.28, -0.71, -1.04, -0.59,  0.77,  0.24,  0.3 , -0.78, -0.46,  0.61, -0.22,  0.14,  0.62, -0.4 , -0.86, -0.72,  0.31,  0.43,
-10.39, -2.84,  3.3 , -2.89, -0.34, -4.  , -0.16, -1.32, -1.4 , -1.64, -0.29, -0.45,  0.24, -1.18, -0.26,  0.21, -0.04,  0.27,  0.38, -1.44,  0.09, -0.16, -1.15, -1.17, -1.51, -1.67,  0.92,  0.07,  0.4 , -0.21, -0.07,  0.43, -0.57,  0.15,  0.62, -0.72, -0.69, -0.64,  0.1 ,  0.8 ,
-10.11, -2.13,  2.83, -2.91, -0.56, -4.35, -0.99, -2.07, -1.65, -0.77,  0.66, -0.  ,  0.15, -0.24, -0.7 ,  0.15, -0.41, -0.18, -0.63, -1.76, -0.2 , -0.17, -0.81, -1.14, -1.3 , -1.64,  0.22,  0.34, -0.08,  0.12, -0.  ,  0.22, -0.38, -0.51, -0.39, -0.63, -0.13, -0.3 , -0.28, -0.36,
-12.57, -2.4 ,  2.26, -3.4 , -0.74, -3.7 , -1.19, -2.37, -0.45, -0.4 ,  0.76,  1.08, -0.12, -0.76, -0.98, -0.5 , -0.66, -0.37, -0.9 , -2.11, -0.91, -1.54, -1.43, -0.88, -1.01, -1.25,  0.15, -0.02, -0.06,  0.22, -0.16,  0.23, -0.5 , -0.5 , -0.53, -0.53, -0.1 , -0.07, -0.21, -0.8 ,
-13.4 , -1.89,  2.33, -1.94,  0.55, -2.88,  0.77, -1.89, -1.43, -1.5 ,  0.94,  1.13, -0.23,  0.38, -0.41,  0.36, -0.35, -0.14, -0.23, -0.83, -0.87, -1.2 , -1.18, -1.06, -1.02, -0.37,  0.13,  0.55,  0.11,  0.71, -0.17, -0.76, -0.52, -0.35, -0.33,  0.06,  0.69,  0.33, -0.22, -0.14,
-16.04, -1.86,  1.81, -1.42,  0.03, -3.21,  0.67, -2.4 , -1.24, -1.65,  0.73,  1.22, -0.36,  0.58, -0.7 ,  0.71, -0.47, -0.02,  0.68,  0.1 , -0.4 , -0.86, -0.96, -0.9 , -0.28, -0.08, -0.38,  0.34,  0.17,  0.51,  0.59, -0.66, -0.91, -0.76, -0.35, -0.22,  0.1 ,  0.03, -0.44,  0.38,
-18.52, -1.94,  0.27, -2.45, -0.53, -3.62, -0.66, -3.1 , -1.92, -0.73,  0.61,  1.64, -0.02,  0.93, -0.89,  0.78, -1.01, -0.23,  1.55,  0.06, -0.29, -0.41, -0.39, -0.01, -0.46, -0.17, -0.14,  0.3 ,  0.73,  0.57,  0.15, -0.6 , -0.54, -0.15, -0.7 ,  0.04,  0.07,  0.17, -0.2 , -0.24,
-20.67, -1.22, -0.67, -2.04, -0.19, -2.09, -0.5 , -3.26, -1.77,  0.46, -0.07,  0.11, -0.63,  0.36, -1.66,  0.91,  0.16,  0.31,  1.89, -1.35, -1.09, -0.3 , -0.9 , -0.35, -0.81, -0.28,  0.1 ,  0.22,  0.92,  0.07,  0.3 , -0.34, -0.59, -0.39, -0.35,  0.41, -0.09,  0.47, -0.25, -0.74,
-22.56,  0.22, -0.31, -0.99, -0.92, -1.9 ,  0.24, -3.33, -1.97,  0.93,  0.63,  0.2 ,  0.27,  1.4 , -1.4 ,  1.02, -0.38, -0.69,  0.91, -1.02, -1.11, -0.13, -0.49, -0.58, -1.14, -0.3 , -0.01, -0.12,  0.64, -0.09,  0.23, -0.55, -0.44,  0.05, -0.49,  0.21, -0.3 ,  0.25, -0.5 , -0.57,
-25.12,  0.38, -0.51, -0.74, -1.52, -1.66, -0.35, -3.21, -3.29, -0.43, -0.48, -0.52,  0.77,  0.66, -0.93,  1.47, -1.15, -0.98,  0.71, -0.68, -0.72, -0.78, -0.01, -0.27, -1.  , -0.62, -0.34, -0.16,  0.72,  0.68,  0.88, -0.  ,  0.33, -0.45, -1.02,  0.38, -0.3 ,  0.74,  0.18,  0.05,
-26.65, -0.22,  0.48,  0.36, -2.25, -0.59,  0.8 , -2.28, -3.23, -0.71, -0.15, -0.88,  0.76, -0.42, -1.41,  0.79, -1.39, -0.76,  0.22, -0.17,  0.16,  0.01, -0.97,  0.06, -0.39, -0.98, -1.15, -0.28,  0.68,  0.1 ,  0.55,  0.16, -0.41,  0.02, -0.21,  0.41,  0.22,  0.72,  0.02, -0.08,
-28.18,  0.83,  0.31,  0.86, -1.84, -0.5 ,  0.37, -1.71, -2.05, -0.67,  0.17, -0.55,  0.65, -0.93, -1.48,  0.49, -0.5 , -0.5 , -0.98, -0.63, -0.24,  0.37, -0.86,  0.2 ,  0.13, -0.44, -0.05,  0.26,  0.12,  0.67,  0.43,  0.1 , -0.88, -0.12, -0.65,  0.28, -0.15, -0.24,  0.47, -0.12,
-30.09,  0.59,  0.48,  0.75, -1.7 ,  0.55,  1.27, -1.7 , -1.54,  0.41, -0.28, -0.81,  0.4 , -1.04, -1.  ,  0.39, -0.36, -0.65, -0.53, -0.78,  0.09,  0.91, -0.98, -0.55,  0.7 ,  0.43,  0.4 ,  0.37, -0.61, -0.25,  0.18,  0.37, -0.2 , -0.04, -0.33,  0.  , -0.46,  0.06,  0.23, -0.8 ,
-30.94,  1.65,  0.49,  1.19, -1.27,  0.52,  1.53, -0.65, -0.76, -0.09, -0.99, -0.97,  0.01, -1.34, -1.32, -0.17, -0.38, -0.66, -0.29, -0.18, -0.42,  0.3 , -1.34, -0.86,  0.57, -0.09,  0.02,  1.11, -0.31, -0.07,  0.37,  0.39, -0.08, -0.52, -0.75,  0.01, -0.18,  0.45, -0.01, -0.79,
-33.47,  0.84,  0.87,  1.3 , -1.76,  0.52,  1.42, -1.01, -1.5 , -0.05, -0.88, -0.41,  0.08, -0.97, -1.3 , -0.45, -0.37, -0.67, -0.22, -0.09,  0.59,  1.16, -0.96, -0.51,  0.92, -0.13, -0.58,  0.17, -1.19,  0.01,  0.14, -0.22, -0.14, -0.53,  0.18, -0.22, -0.67,  0.05, -0.47, -0.48,
-35.46,  0.35,  0.35,  0.83, -1.86, -0.47,  1.34, -0.84, -2.33, -0.59, -0.88, -0.7 , -0.35, -1.32, -1.41, -0.83, -0.66, -0.33, -0.35,  0.05, -0.81, -0.2 , -1.28, -0.9 ,  0.61, -0.39, -0.6 , -0.23, -1.59, -0.03,  0.09,  0.15,  0.06, -0.77, -0.75,  0.18, -0.53,  0.12, -0.06, -0.09,
-36.29,  1.18,  1.48,  1.56, -1.13, -0.4 ,  1.08, -0.94, -1.65, -0.76, -0.27, -0.33,  0.16, -0.69, -1.14, -0.71, -0.6 , -0.01,  0.25, -0.39, -0.15,  1.1 , -0.77, -0.01,  0.39, -0.25, -0.28, -0.41, -1.22, -0.31, -0.42,  0.33,  0.57, -0.59, -1.09,  0.35, -0.57,  0.6 ,  0.42, -0.22,
-36.83,  1.23,  1.13,  1.07, -1.34, -0.44,  0.27, -1.2 , -1.88, -1.4 , -0.37, -0.96, -0.22, -0.38, -0.61, -0.77,  0.06,  0.13, -0.47, -0.67, -0.36,  0.71, -0.18,  1.3 ,  1.34,  0.43, -0.3 , -0.4 , -0.62, -0.4 , -0.16,  0.55,  0.5 , -0.01, -0.77,  0.08, -0.96,  0.6 ,  0.53, -0.42,
-34.23,  1.7 ,  1.22, -0.28, -1.18,  0.2 , -0.24, -1.68, -1.38, -1.42, -0.26,  0.1 , -1.29,  0.21, -1.14, -1.08,  0.33,  0.47, -0.98, -0.66, -1.31,  0.36, -0.03,  0.49,  0.99,  0.5 , -0.25,  0.28, -0.79, -0.05,  0.31,  0.24,  0.83,  0.28, -0.8 ,  0.13, -0.33,  0.58, -0.09, -0.58,
-33.07,  2.  ,  2.13, -0.58, -2.29, -0.25,  0.09, -2.28, -1.65, -1.1 ,  0.45,  0.89, -1.05, -0.06, -1.62, -0.6 ,  0.56,  0.61, -0.87, -0.88, -1.48,  1.28,  0.9 ,  0.52,  0.93, -0.19, -0.55,  0.97, -1.18, -0.65, -0.15,  0.07,  0.75,  0.04, -0.64,  0.61, -0.44,  0.19, -0.01, -0.25,
-33.92,  2.05,  1.2 , -0.36, -1.79, -1.27, -1.4 , -2.7 , -1.18, -0.96,  0.12,  0.06, -1.16, -0.74, -1.71,  0.51,  0.91,  0.74, -0.29, -0.97, -1.16,  1.1 ,  1.73,  0.45,  0.49, -0.88, -0.93,  0.82,  0.07, -0.61, -0.66, -0.33,  0.98,  0.47, -0.26, -0.08, -0.85,  0.32,  0.67,  0.17,
-33.89,  1.78,  0.67, -1.01, -1.  , -1.34, -1.22, -1.68, -0.82, -1.17,  0.86,  0.44, -2.04, -1.37, -1.3 ,  0.62,  0.97,  0.15, -0.32,  0.03, -1.13,  0.1 ,  0.7 ,  0.99,  0.49, -0.34, -0.83,  0.05,  0.26, -0.5 , -0.14, -0.09,  0.97,  0.84, -0.25, -0.23, -0.71, -0.49,  0.02, -0.49,
-32.95,  1.04, -0.01, -1.73, -1.93, -1.48, -0.84, -1.4 , -1.31, -0.85,  1.2 , -0.73, -1.98, -2.16, -1.91,  0.03,  0.68, -1.36, -1.24,  0.11, -1.92, -0.7 , -0.38,  0.84,  0.77, -0.1 , -0.87, -0.1 ,  0.24, -0.08, -0.12, -0.51,  0.07, -0.03,  0.65, -0.35, -1.  , -0.12,  0.81, -0.35,
-31.72,  1.3 , -0.02, -0.05, -0.17,  0.  ,  0.83, -1.11, -0.98, -1.09,  0.99, -1.65, -1.6 , -1.46, -2.18,  0.15,  1.19, -0.99, -0.73,  0.66, -1.97, -0.61, -0.63,  0.71,  1.08,  0.75, -0.78,  1.35,  0.51,  0.45, -0.73, -1.02,  0.24,  0.06,  1.04, -0.55, -1.43, -0.34,  1.23,  0.42,
-31.71,  2.01, -0.12,  0.46, -0.43, -0.89,  0.54, -1.01, -0.23, -0.14, -0.48, -1.97, -1.79, -2.49, -2.97, -0.1 ,  1.14, -1.34, -0.64,  0.4 , -2.33, -0.91, -0.35,  0.89,  1.58,  0.26, -1.  ,  0.34,  0.51, -0.04, -1.09,  0.04,  0.24,  0.54,  0.8 , -0.51, -1.01, -0.13,  0.17,  0.3
};
// clang-format on

#endif  // MICRO_EXAMPLES_DATA_KWS_H_
