// Copyright 2018 The MACE Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Simple benchmarking facility.
#ifndef MACE_BENCHMARK_UTILS_TEST_BENCHMARK_H_
#define MACE_BENCHMARK_UTILS_TEST_BENCHMARK_H_

#include <string>
#include <utility>
#include <vector>

#define MACE_BENCHMARK(n) \
  static ::mace::testing::Benchmark *__benchmark_##n = \
      (new ::mace::testing::Benchmark(#n, (n)))

namespace mace {
namespace testing {

class Benchmark {
 public:
  Benchmark(const char *name, void (*benchmark_func)(int));

  static void Run(const char *pattern);

 private:
  std::string name_;
  void (*benchmark_func_)(int iters) = nullptr;

  void Register();
  void Run(int *run_count, double *run_seconds);
};

void BytesProcessed(int64_t);
void MacsProcessed(int64_t);
void RestartTiming();
void StartTiming();
void StopTiming();

}  // namespace testing
}  // namespace mace

#endif  // MACE_BENCHMARK_UTILS_TEST_BENCHMARK_H_
