//
// Copyright (c) 2017 XiaoMi All rights reserved.
//

#include "mace/ops/fully_connected.h"

namespace mace {
namespace ops {

void Register_FullyConnected(OperatorRegistry *op_registry) {
  REGISTER_OPERATOR(op_registry, OpKeyBuilder("FC")
                                     .Device(DeviceType::CPU)
                                     .TypeConstraint<float>("T")
                                     .Build(),
                    FullyConnectedOp<DeviceType::CPU, float>);

  REGISTER_OPERATOR(op_registry, OpKeyBuilder("FC")
                                     .Device(DeviceType::OPENCL)
                                     .TypeConstraint<float>("T")
                                     .Build(),
                    FullyConnectedOp<DeviceType::OPENCL, float>);

  REGISTER_OPERATOR(op_registry, OpKeyBuilder("FC")
                                     .Device(DeviceType::OPENCL)
                                     .TypeConstraint<half>("T")
                                     .Build(),
                    FullyConnectedOp<DeviceType::OPENCL, half>);
}

}  // namespace ops
}  // namespace mace
