var customFunc = function(echarts, myChart, option) {
    /* 当前echarts版本V5.1.1 */
    option = {
        "backgroundColor": "",
        "animationEasing": "cubicOut",
        "xAxis": {
            "axisLabel": {
                "rotate": 0,
                "color": "rgba(255, 255, 255, 1)",
                "legendLen": 0,
                "show": true,
                "fontSize": 14,
                "interval": 0,
                formatter: function(value) {
                  if (value.length > 5) {
                      return value.substring(0, 4) + '\n' + value.substring(4);
                  } else {
                      return value;
                  }
                },
                "fontWeight": "normal"
            },
            "data": [
                            "省信息中心",
							"省政服务办",
							"省人力资源和社会保障厅",
							"省政府公厅",
							"省市场监督局"
            ],
            "axisLine": {
                "lineStyle": {
                    "color": "#235EB3",
                    "width": 1
                },
                "show": true
            },
            "name": "",
            "splitLine": {
                "show": false
            },
            "axisTick": {
                "show": false,
            },
            "type": "category",
            "nameTextStyle": {
                "color": "rgba(255, 255, 255, 1)",
                "fontSize": 14,
                "fontWeight": "normal"
            }
        },
        "color": [
            "#45a1f8",
            "#a6ecf7",
            "#4ea863",
            "#aeea78",
            "#eec14f",
        ],
        "tooltip": {
            "alwaysShowContent": false,
            "backgroundColor": "rgba(50,50,50,0.7)",
            "borderColor": "#333",
            "triggerOn": "mousemove",
            "formatterStr": "{}",
            "show": true,
            "className": "",
            "trigger": "axis",
            "enterable": false,
            "borderWidth": 0,
            "axisPointer": {
                "type": "line",
                "label": {
                    "backgroundColor": "#6a7985",
                    "color": "#fff"
                }
            },
            "textStyle": {
                "color": "#fff",
                "fontSize": 14,
                "fontWeight": "normal"
            }
        },
        "animationDuration": 1000,
        "yAxis": {
            "name": "单位：万",
            "nameTextStyle": {
                "color": "#ebf8ac",
            },
            "axisLabel": {
                "rotate": 0,
                "color": "rgba(255, 255, 255, 1)",
                "show": true,
                "fontSize": 14,
                "fontWeight": "normal"
            },
            "axisLine": {
                "lineStyle": {
                    "color": "#235EB3",
                    "width": 1
                },
                "show": true
            },
            "splitLine": {
                "show": false
            },
            "axisTick": {
                "show": false,
            },
            "splitNumber": 5,
            "type": "value",
            "nameTextStyle": {
                "color": "rgba(255, 255, 255, 1)",
                "fontSize": 14,
                "fontWeight": "normal"
            }
        },
        "grid": {
            "top": 50,
            "left": 50,
            "bottom": 30,
            "right": 50
        },
        "series": [{
            "name": "进货",
            "type": "bar",
            "data": [{
                    "value": 880,
                    "unit": ""
                },
                {
                    "value": 556,
                    "unit": ""
                },
                {
                    "value": 1122,
                    "unit": ""
                },
                {
                    "value": 226,
                    "unit": ""
                },
                {
                    "value": 222,
                    "unit": ""
                },
            ],
            "barGap": "30%",
            "barWidth": 12,
            "label": {
                "show": false,
                "position": "inside",
                "color": "#fff",
                "fontWeight": "normal",
                "fontSize": 12
            },
            "markLineFlag": false,
            "markLineAvgFlag": false,
            "markLine": {
                "data": [],
                "symbol": "none",
                "silent": true
            },
            "markPoint": {
                "data": [],
                "symbol": "none"
            },
            "itemStyle": {
                "normal": {
                    "barBorderRadius": 30,
                    "color": new echarts.graphic.LinearGradient(0, 0, 0, 1, [{
                            "offset": 0,
                            "color": "#FFD40A",
                        },
                        {
                            "offset": 1,
                            "color": "#FFD40A00",
                        },
                    ]),
                },
            },
        }],
        "toolbox": {
            "orient": "horizontal",
            "feature": {
                "saveAsImage": {
                    "show": false
                },
                "dataZoom": {
                    "show": false
                },
                "magicType": {
                    "show": false,
                    "type": [
                        "line",
                        "bar"
                    ]
                },
                "dataView": {
                    "show": false
                }
            },
            "show": true
        },
        "useAdvanceFlag": false,
        "useAdvanceType": "config"
    }
    myChart.setOption(option, true)
}