// 定义变量，记录双方出拳
let playerChoice = "";
let computerChoice = "";

// 定义函数，用于电脑出拳
function computerPlay() {
  // 随机生成整数 0、1、2 分别代表剪刀、石头、布
  const choices = ["scissors", "rock", "paper"];
  const randomIndex = Math.floor(Math.random() * 3);
  return choices[randomIndex];
}

// 定义函数，用于开始游戏
function playTurn(choice) {
  playerChoice = choice;
  computerChoice = computerPlay();
  const iconsHTML = `
    <div>${emojiOf(playerChoice)}</div>
    <div>${emojiOf(computerChoice)}</div>
  `;
  const outcomeMessage = determineOutcome(playerChoice, computerChoice);
  document.getElementById("choices").innerHTML = iconsHTML;
  document.getElementById("outcome").innerHTML = outcomeMessage;
  const playerIcon = document.getElementById("player-icon");
  playerIcon.innerHTML = '😊'
  const computerIcon = document.getElementById("computer-icon");
  computerIcon.innerHTML = '🤖️'
}


// 定义函数，用于将出拳转为 Emoji 显示
function emojiOf(choice) {
  switch (choice) {
    case "scissors":
      return "✌️";
    case "rock":
      return "✊";
    case "paper":
      return "🖐️";
    default:
      return "";
  }
}

function determineOutcome(playerChoice, computerChoice) {
  if (playerChoice === computerChoice) {
    return " draw ";
  } else if (
    (playerChoice === "scissors" && computerChoice === "paper") ||
    (playerChoice === "rock" && computerChoice === "scissors") ||
    (playerChoice === "paper" && computerChoice === "rock")
  ) {
    return "😊 wins !";
  } else {
    return "🤖️ wins !";
  }
}

