const treeData = [
    {
        id: '1',
        title: "课程1",
        children: [
            { id: '4', title: "课程1-1" },
            {
                id: '5',
                title: "课程1-2",
                children: [
                    { id: '6', title: "课程1-2-1" },
                    { id: '7', title: "课程1-2-2" },
                ],
            },
        ],
    },
    { id: '2', title: "课程2" },
    { id: '3', title: "课程3" },
];
const flatData = [
    { id: '1', parentID: '0', title: "课程1" },
    { id: '4', parentID: '1', title: "课程1-1" },
    { id: '5', parentID: '1', title: "课程1-2" },
    { id: '6', parentID: '5', title: "课程1-2-1" },
    { id: '7', parentID: '5', title: "课程1-2-2" },
    { id: '2', parentID: '0', title: "课程2" },
    { id: '3', parentID: '0', title: "课程3" },
]

export function TreeToFlat(data) {
    let formatData = []
    for (var i = 0; i < data.length; i++) {
        formatData.push({
            id: data[i].id,
            title: data[i].title,
        })
        if (data[i].children) {
            formatData = formatData.concat(TreeToFlat(data[i].children));
        }
    }
    return formatData;
}
// console.log(TreeToFlat(treeData), '输出为扁平化结构')

export function FlatToTree(arr) {
    const map = arr.reduce((acc, val) => {
        acc[Number(val.id)] = val
        return acc
    }, {})
    const tree = []
    arr.forEach(region => {
        if (Number(region.parentID)) {
            const parentID = map[Number(region.parentID)];
            if (!parentID?.children) {
                parentID.children = [region]
            }
            else {
                parentID.children.push(region)
            }
        }
        else {
            tree.push(region)
        }
    })
    return { tree }
}
// console.log(FlatToTree(flatData),'输出为树形结构')
