/**
 * @description 表格头
 * @example
 * ```ts
 * [
 *   {
 *     name: "id号",
 *     type: "id",
 *     width: "150px",
 *     isSort: false,
 *     align: "center"
 *   },
 *   {
 *     name: "排序",
 *     type: "sort",
 *     width: "100px",
 *     isSort: true,
 *     align: "center"
 *   },
 *   {
 *     name: '分类名称',
 *     type: "typeName",
 *     width: "auto",
 *     isSort: false,
 *     align: "left"
 *   },
 *   {
 *     name: '父级id',
 *     type: "parent",
 *     width: "80px",
 *     isSort: false,
 *     align: "center"
 *   },
 *   {
 *     name: '状态',
 *     type: "state",
 *     width: "100px",
 *     isSort: false,
 *     align: "center"
 *   }
 * ]
 * ```
 */
class TableType {
    /**显示列名 */
    name: string;
    /**数据绑定列明 */
    type: string;
    /**列宽度 */
    width: string;
    /**可以排序 */
    isSort: boolean;
    /**内容对齐方式 center left right */
    align: string
}
/**
 * @description 表格数据
 * @example
 * ```ts
 * [
 *   {
 *       id: 1,
 *       sort: 1,
 *       typeName: "普通公告",
 *       parent: 0,
 *       state: "正常",
 *   },
 *   {
 *       id: 2,
 *       sort: 2,
 *       typeName: "紧急公告",
 *       parent: 0,
 *       state: "正常",
 *       children: [
 *           {
 *               id: 6,
 *               sort: 0,
 *               typeName: "紧急公告",
 *               state: "正常",
 *               parent: 2,
 *           }
 *       ]
 *   },
 *   {
 *       id: 3,
 *       sort: 3,
 *       typeName: "防疫公告",
 *       state: "正常",
 *       parent: 0,
 *   },
 * ]
 * ```
 */
const _tableData: [] = [];
/**
 * @description 表格数据
 * @example
 * ```ts
 * {
 *     type:["detailes","edit","delete"],
 *     width:"180px"
 * }
 * ```
 */
const _operation: Object = {};
/**
 * @description 表格数据样式,除去表格头
 * @return 样式
 * @example
 * ```ts
 * ({ row, column, rowIndex, columnIndex }) => {
 *  if (column.property === "state") {
 *    if (row.state == "正常")
 *      return {
 *        color: "#16b777"
 *      };
 *  }
 *  return;
 * }
 * ```
 */
const _cellStyle = ({ row, column, rowIndex, columnIndex }) => {
    if (column.property === "state") {
        if (row.state == "正常")
            return {
                color: "#16b777"
            };
    }
    return;
}
export {
    TableType,
    _tableData,
    _operation,
    _cellStyle
}