import axios from "axios";

export interface IParams {
    page?:number;
    limit?:number;
    [prop:string]: string | number | undefined;
}
const request = {
    get(url:string,data:IParams){
        return axios.get(url,{
            params:data,
        })
    },
    post<T>(url:string,body:T){
        return axios.post(url,body);
    },
    put<T>(url:string,body:T){
        return axios.put(url,body);
    },
    delete(url:string){
        return axios.delete(url);
    }
}
export default request;