import request from "./index";
import type { IParams } from './index';
import { CONTRACT_CATEGORY, CONTRACT_LIST, CONTRACT_LIST_Type, DEPT_MENU, HUMAN_RESOURCES_DEPARTMENT, JOB_TITLE, LOGIN, TABLE_ANNOUNCEMENT, EMP_LISIT } from "./path";
import type { AxiosResponse } from "axios";
import { usePromiseStore } from '../storage/promiseStorage'

interface ILoginForm {
    username: string;
    password: string;
}
interface IRes<T> {
    data: {
        msg: string;
        code: number;
        data: T
    }
}
export function login(body: ILoginForm): Promise<AxiosResponse<IRes<Array<null>>>> {
    return request.post(LOGIN, body);
}

export function deptMenu(body: IParams): Promise<AxiosResponse<IRes<Array<any>>>> {
    return request.get(DEPT_MENU, body);
}

export function tableAnnouncement(body: any): Promise<AxiosResponse<IRes<Array<any>>>> {
    return request.get(TABLE_ANNOUNCEMENT, body);
}
interface IContractCategory {
    msg: string;
    code: number;
    data: {
        id: number;
        typeName: string;
        state: string;
    }
}
export function getContractCategory(body: IParams): Promise<AxiosResponse<IContractCategory>> {
    return request.get(CONTRACT_CATEGORY, body);
}

export function getContractList(body: IParams): Promise<AxiosResponse<IContractCategory>> {
    return request.get(CONTRACT_LIST, body);
}

export function getContractListType(): Promise<AxiosResponse<any>> {
    return request.get(CONTRACT_LIST_Type, {});
}

export function getHumanResourcesDepartment(): Promise<AxiosResponse<any>> {
    const send = usePromiseStore();
    const requestPromise = request.get(HUMAN_RESOURCES_DEPARTMENT, {});
    send.setDepartment(requestPromise);
    return requestPromise;
}

export function getJobTiTle(): Promise<AxiosResponse<any>> {
    return request.get(JOB_TITLE, {});
}

export function getEmpList(body: IParams): Promise<AxiosResponse<any>> {
    const send = usePromiseStore();
    const requestPromise = request.get(EMP_LISIT, body);
    send.setEmp(requestPromise);
    return requestPromise;
}
