
import requests

def get_kline_data(symbol, scale, ma, datalen):
    # 基础URL
    base_url = "http://money.finance.sina.com.cn/quotes_service/api/json_v2.php/CN_MarketData.getKLine/XMLSchema"
    
    # 构建请求参数
    params = {
        'symbol': symbol,
        'scale': scale,
        'ma': ma,
        'datalen': datalen
    }
    
    try:
        # 发送GET请求
        response = requests.get(base_url, params=params)
        
        # 检查请求是否成功
        if response.status_code == 200:
            # 返回响应内容（JSON数据）
            return response.json()
        else:
            # 如果不是200 OK状态码，则打印错误信息并返回None
            print(f"Failed to retrieve data: Status Code {response.status_code}")
            return None
    except requests.exceptions.RequestException as e:
        # 处理请求中的任何异常
        print(f"An error occurred: {e}")
        return None

# 示例调用方法
if __name__ == "__main__":
    symbol = "sh600519"  # 示例股票代码
    scale = 240          # 示例时间间隔
    ma = 5               # 示例均线周期
    datalen = 10         # 示例数据长度
    
    result = get_kline_data(symbol, scale, ma, datalen)
    print(result)
    