
import recordWorker from './transcode.worker'

const URL = window.URL || window.webkitURL // 获取浏览器API

// 加载并启动 record worker
let workerString = recordWorker.toString()
// 移除函数包裹
workerString = workerString.substr(workerString.indexOf("{") + 1)
workerString = workerString.substr(0, workerString.lastIndexOf("}"))
const workerBlob = new Blob([workerString])
const workerURL = URL.createObjectURL(workerBlob)
const worker = new Worker(workerURL)

/**
 * class IatRecorder 语音听写类
 * @param {Object} config 参数
 */
class IatRecorder {
  constructor(config) {
    this.status = "null" // 当前录音的状态 null为开始 ing为录音中 end为结束

    // 记录音频数据
    this.audioData = []
    this.buffer = []
    // 记录听写结果
    worker.onmessage = (event) => {
      this.audioData.push(...event.data)
      console.log('处理后的数据长度', this.audioData.length)
    }
  }
  // 修改录音听写状态
  setStatus (status) {
    this.onWillStatusChange &&
      this.status !== status &&
      this.onWillStatusChange(this.status, status)
    this.status = status
  }
  // 初始化浏览器录音
  recorderInit () {
    navigator.getUserMedia =
      navigator.getUserMedia ||
      navigator.webkitGetUserMedia ||
      navigator.mozGetUserMedia ||
      navigator.msGetUserMedia

    // 创建音频环境
    try {
      this.audioContext = new (window.AudioContext ||
          window.webkitAudioContext)()
      console.log('audioContext sampleRate:', this.audioContext.sampleRate)
      console.log('UA', navigator.userAgent)
      if (!this.audioContext) {
        alert("浏览器不支持webAudioApi相关接口,请前往Chrome,FireFox浏览器体验")
        return
      }
    } catch (e) {
      if (!this.audioContext) {
        alert("浏览器不支持webAudioApi相关接口,请前往Chrome,FireFox浏览器体验")
        return
      }
    }

    // 获取浏览器录音权限
    if (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) {
      navigator.mediaDevices
        .getUserMedia({
          audio: true,
          video: false,
        })
        .then((stream) => {
          getMediaSuccess(stream)
        })
        .catch((e) => {
          getMediaFail(e)
        })
    } else if (navigator.getUserMedia) {
      navigator.getUserMedia(
        {
          audio: true,
          video: false,
        },
        (stream) => {
          getMediaSuccess(stream)
        },
        function (e) {
          getMediaFail(e)
        }
      )
    } else {
      if (
        navigator.userAgent.toLowerCase().match(/chrome/) &&
        location.origin.indexOf("https://") < 0
      ) {
        alert(
          "chrome下获取浏览器录音功能，因为安全性问题，需要在localhost或127.0.0.1或https下才能获取权限"
        )
      } else {
        alert("无法获取浏览器录音功能，请升级浏览器或使用chrome")
      }
      this.audioContext && this.audioContext.close()
      return
    }
    // 获取浏览器录音权限成功的回调
    let getMediaSuccess = (stream) => {
      // 创建一个用于通过JavaScript直接处理音频
      this.scriptProcessor = this.audioContext.createScriptProcessor(
        4096,
        1,
        1
      )
      this.scriptProcessor.onaudioprocess = (e) => {
        // 去处理音频数据
        this.buffer.push(...e.inputBuffer.getChannelData(0))
        console.log('录音原始数据长度，类型为 Float32Array', e.inputBuffer.getChannelData(0).length)
        worker.postMessage({
            command: "transform",
            buffer: e.inputBuffer.getChannelData(0),
            is16K: this.audioContext.sampleRate,
        })
      }
      // 创建一个新的MediaStreamAudioSourceNode 对象，使来自MediaStream的音频可以被播放和操作
      this.mediaSource = this.audioContext.createMediaStreamSource(stream)
      // 连接
      this.mediaSource.connect(this.scriptProcessor)
      this.scriptProcessor.connect(this.audioContext.destination)
    };

    let getMediaFail = () => {
      alert("请求麦克风失败")
      this.audioContext && this.audioContext.close()
      this.audioContext = undefined
    }
  }

  /**
   * 开始录音
   */
  recorderStart () {
    this.setStatus("ing")
    this.recorderStop()
    this.recorderInit()
  }
  /**
   * 暂停录音
   * @param e
   */
  recorderStop (e) {
    // this.download();
    this.setStatus("end")
    // 关闭录音
    this.audioContext && this.audioContext.close()
    this.audioContext = undefined
  }
  
  getBuffer () {
    let output = this.to16BitPCM(this.buffer)
    return output
  }
  to16BitPCM (input) {
    var dataLength = input.length * (16 / 8)
    var dataBuffer = new ArrayBuffer(dataLength)
    var dataView = new DataView(dataBuffer)
    var offset = 0
    for (var i = 0; i < input.length; i++, offset += 2) {
      var s = Math.max(-1, Math.min(1, input[i]))
      dataView.setInt16(offset, s < 0 ? s * 0x8000 : s * 0x7fff, true)
    }
    return dataView
  }
  download () {
    const blob = new Blob([this.getBuffer()]) //处理文档流
    if ("msSaveOrOpenBlob" in navigator) {
      window.navigator.msSaveOrOpenBlob(blob, "test.pcm")
      return
    }
    const elink = document.createElement("a")
    elink.download = "test.pcm"
    elink.style.display = "none"
    elink.href = URL.createObjectURL(blob)
    document.body.appendChild(elink)
    elink.click()
    URL.revokeObjectURL(elink.href) // 释放URL 对象
    document.body.removeChild(elink)
  }
}

export default IatRecorder
