function getSysMessage() {
    let userAgent: string = navigator.userAgent
    let webLog: any = {
      ua: userAgent
    }
    // 获取微信版本
    let m1 = userAgent.match(/MicroMessenger.*?(?= )/)
    if (m1 && m1.length > 0) {
      webLog.wxChat = m1[0]
    }

    // 获取钉钉版本
    m1 = userAgent.match(/DingTalk.*?(?= )/)
    if (m1 && m1.length > 0) {
      webLog.dingTalk = m1[0]
    }

    // 苹果手机
    if (userAgent.includes('iPhone') || userAgent.includes('iPad')) {
      // 获取设备名
      if (userAgent.includes('iPad')) {
        webLog.device = 'iPad'
      } else {
        webLog.device = 'iPhone'
      }
      // 获取操作系统版本
      m1 = userAgent.match(/iPhone OS .*?(?= )/)
      if (m1 && m1.length > 0) {
        webLog.system = m1[0]
      }
    }
    // 安卓手机
    if (userAgent.includes('Android')) {
      // 获取设备名
      m1 = userAgent.match(/Android.*; ?(.*(?= Build))/)
      if (m1 && m1.length > 1) {
        webLog.device = m1[1]
      }
      // 获取操作系统版本
      m1 = userAgent.match(/Android.*?(?=;)/)
      if (m1 && m1.length > 0) {
        webLog.system = m1[0]
      }
    }

    return webLog
  }

const webInfos = getSysMessage()

 console.info({webInfos})