
import java.util.LinkedList;
import java.util.Queue;
import java.util.Scanner;

public class Main {

    public static void main(String[] args) {

        // 控制台输入
        Scanner scanner = new Scanner(System.in);
        String matrixStr = scanner.nextLine();

        int[][] matrix = new int[][]{};
        // 解析字符串，构造二维数组
        matrixStr = matrixStr.replaceAll(" ", "");

        if (!"[]".equals(matrixStr)) {
            String[] strArr = matrixStr.replaceAll("\\[\\[", "").replaceAll("\\]\\]", "").split("\\],\\[");
            matrix = new int[strArr.length][];

            for (int i = 0; i < strArr.length; i++) {
                String[] innerArr = strArr[i].split(",");
                matrix[i] = new int[innerArr.length];
                for (int j = 0; j < innerArr.length; j++) {
                    matrix[i][j] = Integer.parseInt(innerArr[j].trim());
                }
            }
        }

        scanner.close();
        // 调用方法
        int res = minimumEffortPath(matrix);
        // 输出结果
        System.out.println(res);
    }

    public static int minimumEffortPath(int[][] heights) {

        int[][] dirs = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

        int m = heights.length;
        int n = heights[0].length;
        int left = 0, right = 999999, ans = 0;
        while (left <= right) {
            int mid = (left + right) / 2;
            Queue<int[]> queue = new LinkedList<int[]>();
            queue.offer(new int[]{0, 0});
            boolean[] seen = new boolean[m * n];
            seen[0] = true;
            while (!queue.isEmpty()) {
                int[] cell = queue.poll();
                int x = cell[0], y = cell[1];
                for (int i = 0; i < 4; ++i) {
                    int nx = x + dirs[i][0];
                    int ny = y + dirs[i][1];
                    if (nx >= 0 && nx < m && ny >= 0 && ny < n && !seen[nx * n + ny] && Math.abs(heights[x][y] - heights[nx][ny]) <= mid) {
                        queue.offer(new int[]{nx, ny});
                        seen[nx * n + ny] = true;
                    }
                }
            }
            if (seen[m * n - 1]) {
                ans = mid;
                right = mid - 1;
            } else {
                left = mid + 1;
            }
        }
        return ans;
    }
}
