
import java.util.Scanner;

import java.util.*;
import java.util.Arrays;

class Main {

    static HashMap<Integer, List<Integer>> child = new HashMap<>();

    public static void main(String[] args) {
        // 控制台输入
        Scanner scanner = new Scanner(System.in);
        String numsStr = scanner.nextLine();

        int[] nums = new int[]{};
        // 解析字符串，构造数组
        numsStr = numsStr.replaceAll(" ", "");

        if (!"[]".equals(numsStr)) {
            String[] numsStrArr = numsStr.replaceAll("\\[", "").replaceAll("\\]", "").split("\\,");
            nums = new int[numsStrArr.length];
            for (int i = 0; i < numsStrArr.length; i++) {
                nums[i] = Integer.parseInt(numsStrArr[i].trim());
            }
        }

        scanner.close();
        // 调用方法
        String res = evolutionaryRecord(nums);
        // 输出结果
        System.out.println(res);
    }

    /**
     * [-1,0,0,2]
     * 00110
     *
     * [-1,0,0,1,2,2]
     * 00101100
     *
     * @param parents
     * @return
     */

    public static String evolutionaryRecord(int[] parents) {
        int n = parents.length;
        if (n == 1) return "";
        for (int i = 0; i < n; i++) {
            child.put(i, new ArrayList<>());
            if (parents[i] == -1) continue;
            //子节点
            child.get(parents[i]).add(i);
        }
        StringBuilder sb = new StringBuilder(dfs(0));
        int end = 0;
        for (int i = sb.length() - 1; i > 0; i--) {
            if (sb.charAt(i) != '1') {
                end = i;
                break;
            }
        }
        return sb.substring(0, end + 1);
    }

    private static String dfs(int i) {
        StringBuilder t = new StringBuilder();
        List<String> path = new ArrayList<>();
        for (int x : child.get(i)) {
            //加入路径
            path.add("0" + dfs(x) + "1");
        }
        //排序
        Collections.sort(path);
        for (String s : path) {
            t.append(s);
        }
        return t.toString();
    }

}
