

 
import java.util.Scanner;

import java.util.*;
 
 
class Main {
    
    public static void main(String[] args) {
    
        // 控制台输入
        Scanner scanner = new Scanner(System.in);
        String command = scanner.nextLine();
        
        String barriersStr = scanner.nextLine();
        
        int[][] barriers = new int[][]{};
        // 解析字符串，构造二维数组
        barriersStr = barriersStr.replaceAll(" ","");
        
        if(!"[]".equals(barriersStr)){
            String[] strArr = barriersStr.replaceAll("\\[\\[", "").replaceAll("\\]\\]", "").split("\\],\\[");
            barriers = new int[strArr.length][];
        
            for (int i = 0; i < strArr.length; i++) {
                String[] innerArr = strArr[i].split(",");
                barriers[i] = new int[innerArr.length];
                for (int j = 0; j < innerArr.length; j++) {
                    barriers[i][j] = Integer.parseInt(innerArr[j].trim());
                }
            }
        }
        
       
        
        int x = scanner.nextInt();
        int y = scanner.nextInt();
        scanner.close();
        // 调用方法
        boolean result = robot(command, barriers, x, y);
       // 输出结果
       System.out.println(result);
    }
        
    
    public static boolean robot(String command, int[][] barriers, int x, int y) {

        int dx = 0, dy = 0;
        char[] cmd = command.toCharArray(); // 把String转为数组，方便遍历。
        for (char c : cmd) { // 算出up和right各有多少个。
            if (c == 'U') { // Upper
                dy++;
            } else if (c == 'R') { // Right
                dx++;
            } else if (c == 'D') { // Down
                dy--;
            } else if (c == 'L') { // Left
                dx--;
            }
        }
        int ans = isPassed(cmd, x, y, dx, dy); // 拿到走到终点的次数。
        /*
            为什么isPassed要拿到走的总次数而不直接返回true或false呢
            比如你发现有一个barrier是经过的，那么最终答案并不一定是false，
            因为如果终点在这个点的前面，那么机器人根本不会走到那个点。答案是true。
        */
        if (ans == -1) return false; // 终点都没经过，肯定false
        for (int[] barrier : barriers) {
            int cnt = isPassed(cmd, barrier[0], barrier[1], dx, dy);
            if (cnt != -1 && cnt < ans) return false;
            //不等于-1，说明经过了，然后再看这个点和终点哪个次数多。ans多，说明这个点在ans前面，返回false。
        }
        return true;
    }

    // 判断是否经过该点，经过返回走的次数，没经过返回-1。
    public static int isPassed(char[] cmd, int x, int y, int dx, int dy) {
        int round = Math.min(x / dx, y / dy); // 计算走到第x-1或y-1层需要多少轮
        int cnt = cmd.length * round;  // 前几轮的总次数
        dx *= round;
        dy *= round; // 在第x-1或y-1层时的位置。
        if (dx == x && dy == y) return cnt; // 正好就是要找的点，直接返回。
        for (char c : cmd) { // 遍历第x层或y层，如果经过，那么答案一定会遍历到。
            if (c == 'U') { // Upper
                dy++;
            } else if (c == 'R') { // Right
                dx++;
            } else if (c == 'D') { // Down
                dy--;
            } else if (c == 'L') { // Left
                dx--;
            }
            cnt++; // 不要忘了每遍历一次，次数都要加1

            if (dx == x && dy == y) return cnt; // 一旦找到，直接返回所需要的次数。
        }
        return -1;
    }

        
    
}        