
export const apiKey = process.env.INSCODE_API_KEY;
export const apiUrl = 'https://inscode-api.csdn.net/api/v1/gpt/';
import { is_empty, checkWin, is_black, is_white } from "./index"
/**
 * 机器人回合下棋
 * @param {(null|isWhite|isBlack)[][]} board 棋盘
 * @param {isWhite|isBlack} player 当前下棋类型
 * @param {number} win_size 多少颗棋子能赢
 * 
 * @return {[number, number]} 返回机器人回合要落子的坐标
 */
export async function robotPlay(board, player, win_size) {
    const content = `这是一个五子棋游戏，${JSON.stringify(board)}，只能在"${is_empty}"中选择下一步的位置，"${player}"要下到哪？请不要返回多余的文字，只返回数组，比如[x, y]。`
    const body = {
        messages: [
            {
                role: 'user',
                content
            }
        ],
        apikey: apiKey
    };

    return await fetch(apiUrl, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify(body),
    }).then(res => {
        return res.text()
    }).then(async (res) => {
        const arr = res.split('\n').filter(item => !!item && !item.includes("DONE")).map(item => JSON.parse(item.replace('data:', ''))).flatMap(item => {
            const content = item.choices[0].delta?.content
            return content ? [content] : []
        }).join('')
        console.log(arr)
        let _res = []
        try {
            _res = JSON.parse(arr)
        } catch (err) {
            _res = []
        }
        return _res
    })
}
