/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 357
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy53;
  ENullOrder yy109;
  SToken yy113;
  EJoinType yy120;
  int64_t yy123;
  bool yy131;
  EOrder yy428;
  SDataType yy490;
  EFillMode yy522;
  int32_t yy550;
  EOperatorType yy632;
  SNodeList* yy670;
  SNode* yy686;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             612
#define YYNRULE              451
#define YYNTOKEN             237
#define YY_MAX_SHIFT         611
#define YY_MIN_SHIFTREDUCE   898
#define YY_MAX_SHIFTREDUCE   1348
#define YY_ERROR_ACTION      1349
#define YY_ACCEPT_ACTION     1350
#define YY_NO_ACTION         1351
#define YY_MIN_REDUCE        1352
#define YY_MAX_REDUCE        1802
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2125)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   132, 1780,  345, 1636, 1440, 1636,  294,  385,  311,  386,
 /*    10 */  1384,   78,   35,   33, 1779, 1472,   24, 1649, 1777,  131,
 /*    20 */   303, 1364, 1162, 1633,  114, 1633,   36,   34,   32,   31,
 /*    30 */    30, 1780, 1475,   36,   34,   32,   31,   30, 1629, 1635,
 /*    40 */  1629, 1635, 1780,  525,  147, 1665,  928, 1160, 1777,  529,
 /*    50 */   525,  529, 1350,  489,  393,  146,  386, 1384,   14, 1777,
 /*    60 */    35,   33, 1289,  509, 1168,   56,  384, 1619,  303,  388,
 /*    70 */  1162,   36,   34,   32,   31,   30,   36,   34,   32,   31,
 /*    80 */    30,    1,   77, 1678,  932,  933,   82, 1650,  512, 1652,
 /*    90 */  1653,  508,   73,  529, 1375, 1160, 1718, 1414, 1780, 1296,
 /*   100 */   296, 1714,  142,  608,   39, 1186,   14, 1353,   35,   33,
 /*   110 */   319, 1778, 1168, 1161,  220, 1777,  303,  277, 1162,  462,
 /*   120 */   468, 1745,   36,   34,   32,   31,   30,   71,   95,    2,
 /*   130 */  1374,   94,   93,   92,   91,   90,   89,   88,   87,   86,
 /*   140 */   525, 1200,   55, 1160, 1619,  315, 1303,  307, 1476, 1251,
 /*   150 */  1780,  608, 1563, 1565,   14,  129, 1163,  438,  437, 1780,
 /*   160 */  1168, 1161,  436,  146, 1485,  110,  433, 1777,  277,  432,
 /*   170 */   431,  430,  146,  945,  497,  944, 1777,    2, 1166, 1167,
 /*   180 */  1619, 1213, 1214, 1216, 1217, 1218, 1219, 1220,  505,  527,
 /*   190 */  1228, 1229, 1230, 1231, 1232, 1233,  286, 1239, 1252,  608,
 /*   200 */  1251,   38,  946, 1186, 1163,   55,   62,   95,  149, 1161,
 /*   210 */    94,   93,   92,   91,   90,   89,   88,   87,   86, 1257,
 /*   220 */  1732,   36,   34,   32,   31,   30, 1166, 1167, 1479, 1213,
 /*   230 */  1214, 1216, 1217, 1218, 1219, 1220,  505,  527, 1228, 1229,
 /*   240 */  1230, 1231, 1232, 1233, 1729,  287, 1373,  285,  284, 1252,
 /*   250 */   426,  403, 1163, 1372,  428,   27,  301, 1246, 1247, 1248,
 /*   260 */  1249, 1250, 1254, 1255, 1256,  513, 1188, 1215,  306,  149,
 /*   270 */  1257, 1572,   28,  228, 1166, 1167,  427, 1213, 1214, 1216,
 /*   280 */  1217, 1218, 1219, 1220,  505,  527, 1228, 1229, 1230, 1231,
 /*   290 */  1232, 1233,   35,   33, 1352, 1313, 1619,   64,  292, 1461,
 /*   300 */   303,  192, 1162, 1619,  526,  351,   27,  301, 1246, 1247,
 /*   310 */  1248, 1249, 1250, 1254, 1255, 1256,  349, 1189,  104,  103,
 /*   320 */   102,  101,  100,   99,   98,   97,   96, 1160,  149,  452,
 /*   330 */   560, 1649,  149, 1483,  472, 1311, 1312, 1314, 1315,  275,
 /*   340 */    35,   33, 1234, 1162, 1168,  486,  313, 1665,  303,  559,
 /*   350 */  1162,  558,  557,  556,  129,  479,  403, 1345,  526, 1665,
 /*   360 */   498,    8, 1371, 1485, 1560, 1215,  526,  489, 1160, 1780,
 /*   370 */   350,  157, 1527,  392,  113, 1160,  388,  509,  360,  293,
 /*   380 */  1186, 1619,  146,  608, 1525, 1168, 1777, 1483,   35,   33,
 /*   390 */   478,  219, 1168, 1161, 1370, 1483,  303, 1678, 1162, 1459,
 /*   400 */    82, 1650,  512, 1652, 1653,  508,   55,  529,   26,    9,
 /*   410 */  1718,  111, 1619, 1288,  296, 1714,  142,  141,   36,   34,
 /*   420 */    32,   31,   30, 1160,  608,  488,  143, 1725, 1726, 1521,
 /*   430 */  1730,  608,   62, 1369, 1161, 1746, 1163, 1344,  438,  437,
 /*   440 */  1168, 1161,  204,  436, 1619,  109,  110,  433,   11,   10,
 /*   450 */   432,  431,  430,  480, 1478, 1368,  562,    9, 1166, 1167,
 /*   460 */   475, 1213, 1214, 1216, 1217, 1218, 1219, 1220,  505,  527,
 /*   470 */  1228, 1229, 1230, 1231, 1232, 1233, 1187, 1163,  316,  608,
 /*   480 */   344,  336,  343, 1619, 1163, 1460,  129,  997,  149, 1161,
 /*   490 */    36,   34,   32,   31,   30, 1485, 1527,  604,  603, 1166,
 /*   500 */  1167,  338,  334,  308,  999, 1619, 1166, 1167, 1525, 1213,
 /*   510 */  1214, 1216, 1217, 1218, 1219, 1220,  505,  527, 1228, 1229,
 /*   520 */  1230, 1231, 1232, 1233,   36,   34,   32,   31,   30, 1265,
 /*   530 */   481,  476, 1163,  149,    7, 1035,  552,  551,  550, 1039,
 /*   540 */   549, 1041, 1042,  548, 1044,  545, 1367, 1050,  542, 1052,
 /*   550 */  1053,  539,  536, 1366, 1166, 1167, 1649, 1213, 1214, 1216,
 /*   560 */  1217, 1218, 1219, 1220,  505,  527, 1228, 1229, 1230, 1231,
 /*   570 */  1232, 1233,   35,   33,  274,  375, 1184, 1411,  560,  526,
 /*   580 */   303,  526, 1162,  368, 1665, 1732,  380,  250,  155,  390,
 /*   590 */  1513,  105,  507,  361, 1200, 1184, 1619,  559,  424,  558,
 /*   600 */   557,  556,  509, 1619,  381, 1527, 1619, 1160, 1483, 1728,
 /*   610 */  1483, 1363,  314,   60, 1253,  513,   59, 1525, 1287,  159,
 /*   620 */   158, 1573, 1678,  128, 1168,  270, 1650,  512, 1652, 1653,
 /*   630 */   508,  506,  529,  503, 1690, 1258,  486,  584,  583,  582,
 /*   640 */   318,    2,  581,  580,  579,  115,  574,  573,  572,  571,
 /*   650 */   570,  569,  568,  567,  122,  563, 1362,   32,   31,   30,
 /*   660 */  1186, 1619, 1361,  608, 1360,  113,  435,  434,  562,  578,
 /*   670 */   576,   25, 1359, 1161,  379, 1458, 1358,  374,  373,  372,
 /*   680 */   371,  370,  367,  366,  365,  364,  363,  359,  358,  357,
 /*   690 */   356,  355,  354,  353,  352,  486, 1564, 1565,  526,  932,
 /*   700 */   933, 1732,  111, 1527, 1284,  198, 1619,   54, 1357, 1356,
 /*   710 */   402,  526, 1619, 1355, 1619, 1526, 1163,  144, 1725, 1726,
 /*   720 */  1185, 1730, 1619,  105,  113, 1727, 1619, 1483,  129, 1649,
 /*   730 */   429,   55,  566,   65, 1455, 1365, 1474, 1486, 1166, 1167,
 /*   740 */  1483, 1213, 1214, 1216, 1217, 1218, 1219, 1220,  505,  527,
 /*   750 */  1228, 1229, 1230, 1231, 1232, 1233, 1633, 1665, 1619, 1619,
 /*   760 */  1649,  111, 1608, 1619,  428,  510,  969,  944,  560, 1737,
 /*   770 */  1284, 1629, 1635, 1147, 1148,  509,  145, 1725, 1726, 1619,
 /*   780 */  1730,  555,  529,  970,  490,  526,  427,  559, 1665,  558,
 /*   790 */   557,  556,  422,  502,  577, 1678,  510, 1480,   81, 1650,
 /*   800 */   512, 1652, 1653,  508,  494,  529,  509,  326, 1718, 1468,
 /*   810 */  1619,  526,  276, 1714, 1483,  490,  183,  185, 1637,  181,
 /*   820 */   184, 1649, 1215, 1599, 1780,  187, 1678, 1470,  186,   81,
 /*   830 */  1650,  512, 1652, 1653,  508,  339,  529,  148, 1633, 1718,
 /*   840 */  1483, 1777, 1639,  276, 1714,  130,  310,  309,  526, 1665,
 /*   850 */   256,  565,  450, 1629, 1635, 1780, 1176,  510,  149, 1466,
 /*   860 */   460,  195,  254,   53,  529,  448,   52,  509,  146,  504,
 /*   870 */   526, 1619, 1777,  443,  526,  189,  119, 1483,  188, 1641,
 /*   880 */    46, 1169,  523,  160, 1649,  207,  524, 1678,  451,  526,
 /*   890 */    82, 1650,  512, 1652, 1653,  508, 1171,  529, 1168, 1483,
 /*   900 */  1718,  241,  191, 1483,  296, 1714, 1793, 1401,   55, 1396,
 /*   910 */  1394,  526, 1665, 1243,  446, 1752,  554,  464, 1483,  440,
 /*   920 */   510, 1310, 1441,  317,  190,   37,  209,  492, 1170,  439,
 /*   930 */   509,  441,  444,   37, 1619, 1347, 1348,  530,   46,  223,
 /*   940 */  1483,   37,   11,   10,   80,  230,  117, 1172,  459,   51,
 /*   950 */  1678,  473,   50,   82, 1650,  512, 1652, 1653,  508,  453,
 /*   960 */   529,  214, 1174, 1718, 1666,  421, 1259,  296, 1714, 1793,
 /*   970 */  1649, 1385,  118,  119, 1221,   58,   57,  348, 1775,  249,
 /*   980 */   154, 1522, 1120,  222, 1748,  342,  232,  518,  495,  534,
 /*   990 */  1177,  118,  119,  487, 1173,  225, 1184,  273, 1665,    3,
 /*  1000 */   332, 1649,  328,  324,  151,  321,  510,  227,  325,  120,
 /*  1010 */   282,  997, 1180,  238, 1028, 1131,  509,  246,  118,  283,
 /*  1020 */  1619,  362, 1562,  527, 1228, 1229,  156,  369,  377, 1665,
 /*  1030 */  1056,  376, 1060, 1066,  378,  149, 1678,  510,  382,   82,
 /*  1040 */  1650,  512, 1652, 1653,  508, 1190,  529,  509,  383, 1718,
 /*  1050 */  1064, 1619,  391,  296, 1714, 1793,  490, 1193,  486,  121,
 /*  1060 */   394,  163, 1649,  395, 1736,  165, 1192, 1678, 1194,  397,
 /*  1070 */   261, 1650,  512, 1652, 1653,  508,  396,  529,  168,  399,
 /*  1080 */   170,  400, 1191,  401,  173,   61,  425,  113,  404,  176,
 /*  1090 */  1665, 1473,  423,  180, 1168,  291, 1780, 1469,  510,   85,
 /*  1100 */   247,  454, 1603,  455,  182,  193,  490,  458,  509,  148,
 /*  1110 */   123,  124, 1619, 1777, 1471, 1467,  125,  490,  196,  126,
 /*  1120 */   461,  199,  202, 1189,  111, 1649, 1759,  466, 1678,  474,
 /*  1130 */   516,  261, 1650,  512, 1652, 1653,  508, 1758,  529,  217,
 /*  1140 */  1725,  485,  465,  484,    6,  483, 1780,  471,  463,  205,
 /*  1150 */   208,  470,  295, 1665,  477,  213, 1649, 1780, 1739,  148,
 /*  1160 */  1284,  510,    5, 1777, 1749, 1188,  112, 1733,   40,  136,
 /*  1170 */   146,  509,  499,  496, 1777, 1619,  215,   18, 1571, 1570,
 /*  1180 */  1796,  514,  519,  297, 1665,  515,  305,  520,  234,  216,
 /*  1190 */   521, 1678,  510,  236,   83, 1650,  512, 1652, 1653,  508,
 /*  1200 */  1699,  529,  509,  248, 1718,   70, 1619,   72, 1717, 1714,
 /*  1210 */  1649, 1484,  251,  607,  532, 1456, 1776,  221,   47, 1649,
 /*  1220 */   135,  493, 1678,  243,  224,   83, 1650,  512, 1652, 1653,
 /*  1230 */   508,  500,  529,  226,  262, 1718,  272,  263, 1665,  501,
 /*  1240 */  1714,  253,  255, 1613, 1612,  320,  510, 1665, 1609,  322,
 /*  1250 */   323, 1156, 1157,  152,  327,  510,  509, 1607,  329,  330,
 /*  1260 */  1619,  331, 1606,  333, 1605,  509,  335, 1604,  337, 1619,
 /*  1270 */  1589,  153,  340,  341, 1134, 1133, 1678,  346,  347,  133,
 /*  1280 */  1650,  512, 1652, 1653,  508, 1678,  529, 1583,   83, 1650,
 /*  1290 */   512, 1652, 1653,  508, 1582,  529,  611, 1649, 1718, 1103,
 /*  1300 */  1555, 1554, 1553, 1715, 1581, 1580, 1552, 1551, 1649, 1550,
 /*  1310 */   245, 1549, 1548, 1547, 1546, 1545, 1544, 1543, 1542, 1541,
 /*  1320 */  1540, 1539,  106,  491, 1794, 1665, 1538, 1537,  600,  596,
 /*  1330 */   592,  588,  244,  510, 1536,  116, 1665, 1535, 1534, 1533,
 /*  1340 */  1532, 1531, 1530,  509,  510, 1105, 1529, 1619,  161,  935,
 /*  1350 */   469, 1528, 1413, 1381,  509, 1380, 1597,   79, 1619,  107,
 /*  1360 */   239,  934,  108, 1678, 1591,  139,  271, 1650,  512, 1652,
 /*  1370 */  1653,  508,  387,  529, 1678,  389, 1649,  266, 1650,  512,
 /*  1380 */  1652, 1653,  508,  162,  529, 1579,  167,  169, 1578, 1568,
 /*  1390 */  1462,  172,  963,  522, 1412, 1410,  407,  405, 1408,  411,
 /*  1400 */  1406, 1404,  406,  415, 1665,  409,  410,  413,  414,  419,
 /*  1410 */   418, 1393,  510, 1392,  417,  482, 1070,  179,  467, 1379,
 /*  1420 */  1464,  200,  509, 1463, 1069, 1649, 1619,  996,  995,  994,
 /*  1430 */   993,  990,  575,   45,  577, 1402, 1649,  288, 1397, 1139,
 /*  1440 */   289,  194, 1678,  989,  988,  133, 1650,  512, 1652, 1653,
 /*  1450 */   508,  442,  529, 1665, 1395,  290,  445, 1378,  447, 1377,
 /*  1460 */  1596,  510,  449,   84, 1665,  201,  456, 1577, 1141, 1590,
 /*  1470 */  1576,  509,  507, 1575, 1567, 1619,  212,   49,  300,   41,
 /*  1480 */    66,  457,  509,    4,   15,  134, 1619, 1649,   37,   48,
 /*  1490 */  1795, 1678,  206,   43,  271, 1650,  512, 1652, 1653,  508,
 /*  1500 */  1639,  529, 1678,  211, 1309,  270, 1650,  512, 1652, 1653,
 /*  1510 */   508,  210,  529,  197, 1691, 1665,  203,   10,   22,   23,
 /*  1520 */    42, 1302,   67,  510,  178,  218, 1649, 1281, 1280,  127,
 /*  1530 */   137, 1338, 1327,  509,   17, 1333,  140, 1619,   19, 1649,
 /*  1540 */   302, 1332,  420,  416,  412,  408,  177,  298, 1337, 1336,
 /*  1550 */   299, 1244,   29, 1678, 1665,  138,  271, 1650,  512, 1652,
 /*  1560 */  1653,  508,  510,  529, 1223, 1222,   12, 1665,   20, 1208,
 /*  1570 */   150,   63,  509,   21,  175,  510, 1619,  229, 1307,  304,
 /*  1580 */   231, 1566,   16,  235, 1178,  509,   13,  511, 1649, 1619,
 /*  1590 */   233,  517, 1678,   68,   69,  271, 1650,  512, 1652, 1653,
 /*  1600 */   508,  237,  529, 1638,  240, 1678, 1225,   73,  257, 1650,
 /*  1610 */   512, 1652, 1653,  508, 1681,  529, 1665, 1649,  528,   44,
 /*  1620 */   531, 1057,  533,  312,  510,  535,  537, 1054, 1049,  538,
 /*  1630 */   540,  174, 1051,  166,  509,  171,  541,  398, 1619,  543,
 /*  1640 */  1045,  546,  544, 1034,  547, 1665, 1043, 1048, 1047,  553,
 /*  1650 */    74,   75, 1065,  510, 1678,  164, 1649,  265, 1650,  512,
 /*  1660 */  1652, 1653,  508,  509,  529,   76, 1063, 1619, 1062,  961,
 /*  1670 */  1046,  561,  985, 1003,  564,  242,  983,  982,  981,  980,
 /*  1680 */   979,  978,  977, 1678, 1665,  976,  267, 1650,  512, 1652,
 /*  1690 */  1653,  508,  510,  529,  998,  973,  972,  971,  968,  967,
 /*  1700 */   966, 1000,  509, 1409,  585, 1649, 1619,  586,  587, 1407,
 /*  1710 */   589,  590,  591, 1405,  593,  594, 1649,  595, 1403,  597,
 /*  1720 */   599,  598, 1678, 1391,  601,  258, 1650,  512, 1652, 1653,
 /*  1730 */   508, 1390,  529, 1665,  602, 1376,  605,  606, 1351, 1351,
 /*  1740 */   609,  510, 1164,  252, 1665,  610, 1351, 1351, 1351, 1351,
 /*  1750 */  1351,  509,  510, 1351, 1351, 1619, 1351, 1351, 1351, 1351,
 /*  1760 */  1351, 1351,  509, 1351, 1351, 1649, 1619, 1351, 1351, 1351,
 /*  1770 */  1351, 1678, 1351, 1351,  268, 1650,  512, 1652, 1653,  508,
 /*  1780 */  1649,  529, 1678, 1351, 1351,  259, 1650,  512, 1652, 1653,
 /*  1790 */   508, 1351,  529, 1665, 1351, 1351, 1351, 1649, 1351, 1351,
 /*  1800 */  1351,  510, 1351, 1351, 1351, 1351, 1351, 1351, 1665, 1351,
 /*  1810 */  1351,  509, 1649, 1351, 1351, 1619,  510, 1351, 1351, 1351,
 /*  1820 */  1351, 1351, 1351, 1351, 1351, 1665,  509, 1351, 1351, 1649,
 /*  1830 */  1619, 1678, 1351,  510,  269, 1650,  512, 1652, 1653,  508,
 /*  1840 */  1665,  529, 1351,  509, 1351, 1351, 1678, 1619,  510,  260,
 /*  1850 */  1650,  512, 1652, 1653,  508, 1351,  529, 1665,  509, 1351,
 /*  1860 */  1351, 1351, 1619, 1678, 1351,  510, 1661, 1650,  512, 1652,
 /*  1870 */  1653,  508, 1351,  529, 1351,  509, 1649, 1351, 1678, 1619,
 /*  1880 */  1351, 1660, 1650,  512, 1652, 1653,  508, 1351,  529, 1351,
 /*  1890 */  1351, 1351, 1351, 1351, 1351, 1678, 1351, 1351, 1659, 1650,
 /*  1900 */   512, 1652, 1653,  508, 1665,  529, 1351, 1351, 1649, 1351,
 /*  1910 */  1351, 1351,  510, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
 /*  1920 */  1351, 1351,  509, 1351, 1351, 1649, 1619, 1351, 1351, 1351,
 /*  1930 */  1351, 1351, 1351, 1351, 1351, 1351, 1665, 1351, 1351, 1351,
 /*  1940 */  1351, 1351, 1678, 1351,  510,  280, 1650,  512, 1652, 1653,
 /*  1950 */   508, 1351,  529, 1665,  509, 1351, 1351, 1649, 1619, 1351,
 /*  1960 */  1351,  510, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
 /*  1970 */  1351,  509, 1351, 1351, 1678, 1619, 1351,  279, 1650,  512,
 /*  1980 */  1652, 1653,  508, 1351,  529, 1665, 1351, 1351, 1351, 1351,
 /*  1990 */  1351, 1678, 1351,  510,  281, 1650,  512, 1652, 1653,  508,
 /*  2000 */  1351,  529, 1351,  509, 1351, 1351, 1649, 1619, 1351, 1351,
 /*  2010 */  1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,  486,
 /*  2020 */  1351, 1351, 1351, 1678, 1351, 1351,  278, 1650,  512, 1652,
 /*  2030 */  1653,  508, 1351,  529, 1665, 1351, 1351, 1351, 1351, 1351,
 /*  2040 */  1351, 1351,  510, 1351, 1351, 1351, 1351, 1351,  113, 1351,
 /*  2050 */  1351, 1351,  509, 1351, 1351, 1351, 1619, 1351, 1351, 1351,
 /*  2060 */  1351, 1351, 1351, 1351, 1351, 1351, 1351,  490, 1351, 1351,
 /*  2070 */  1351, 1351, 1678, 1351, 1351,  264, 1650,  512, 1652, 1653,
 /*  2080 */   508, 1351,  529, 1351, 1351,  111, 1351, 1351, 1351, 1351,
 /*  2090 */  1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
 /*  2100 */   217, 1725,  485, 1351,  484, 1351, 1351, 1780, 1351, 1351,
 /*  2110 */  1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1351,
 /*  2120 */   146, 1351, 1351, 1351, 1777,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   253,  335,  295,  270,  257,  270,  273,  243,  273,  245,
 /*    10 */   246,  250,   12,   13,  348,  269,    2,  240,  352,  239,
 /*    20 */    20,  241,   22,  290,  263,  290,   12,   13,   14,   15,
 /*    30 */    16,  335,  271,   12,   13,   14,   15,   16,  305,  306,
 /*    40 */   305,  306,  335,   20,  348,  268,    4,   47,  352,  316,
 /*    50 */    20,  316,  237,  276,  243,  348,  245,  246,   58,  352,
 /*    60 */    12,   13,   14,  286,   64,    4,  244,  290,   20,  247,
 /*    70 */    22,   12,   13,   14,   15,   16,   12,   13,   14,   15,
 /*    80 */    16,   81,   81,  306,   42,   43,  309,  310,  311,  312,
 /*    90 */   313,  314,   91,  316,  240,   47,  319,    0,  335,   14,
 /*   100 */   323,  324,  325,  103,   81,   20,   58,    0,   12,   13,
 /*   110 */   295,  348,   64,  113,  337,  352,   20,   58,   22,  295,
 /*   120 */   343,  344,   12,   13,   14,   15,   16,  250,   21,   81,
 /*   130 */   240,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   140 */    20,   82,   81,   47,  290,  278,   82,  260,  271,   90,
 /*   150 */   335,  103,  285,  286,   58,  268,  156,   60,   61,  335,
 /*   160 */    64,  113,   65,  348,  277,   68,   69,  352,   58,   72,
 /*   170 */    73,   74,  348,   20,   41,   22,  352,   81,  178,  179,
 /*   180 */   290,  181,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,   35,   14,  139,  103,
 /*   200 */    90,   81,   49,   20,  156,   81,  252,   21,  208,  113,
 /*   210 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  160,
 /*   220 */   307,   12,   13,   14,   15,   16,  178,  179,  274,  181,
 /*   230 */   182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  331,   84,  240,   86,   87,  139,
 /*   250 */    89,   57,  156,  240,   93,  196,  197,  198,  199,  200,
 /*   260 */   201,  202,  203,  204,  205,  286,   20,  182,  289,  208,
 /*   270 */   160,  292,  320,  321,  178,  179,  115,  181,  182,  183,
 /*   280 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   290 */   194,  195,   12,   13,    0,  178,  290,  165,  166,    0,
 /*   300 */    20,  169,   22,  290,  247,  247,  196,  197,  198,  199,
 /*   310 */   200,  201,  202,  203,  204,  205,  259,   20,   24,   25,
 /*   320 */    26,   27,   28,   29,   30,   31,   32,   47,  208,  295,
 /*   330 */    93,  240,  208,  276,  217,  218,  219,  220,  221,  281,
 /*   340 */    12,   13,   14,   22,   64,  247,  260,  268,   20,  112,
 /*   350 */    22,  114,  115,  116,  268,  276,   57,  148,  247,  268,
 /*   360 */   227,   81,  240,  277,  276,  182,  247,  276,   47,  335,
 /*   370 */   259,  283,  268,  244,  276,   47,  247,  286,  259,  275,
 /*   380 */    20,  290,  348,  103,  280,   64,  352,  276,   12,   13,
 /*   390 */   311,  145,   64,  113,  240,  276,   20,  306,   22,    0,
 /*   400 */   309,  310,  311,  312,  313,  314,   81,  316,    2,   81,
 /*   410 */   319,  313,  290,    4,  323,  324,  325,  267,   12,   13,
 /*   420 */    14,   15,   16,   47,  103,  327,  328,  329,  330,  279,
 /*   430 */   332,  103,  252,  240,  113,  344,  156,  228,   60,   61,
 /*   440 */    64,  113,  145,   65,  290,  265,   68,   69,    1,    2,
 /*   450 */    72,   73,   74,   20,  274,  240,   57,   81,  178,  179,
 /*   460 */   143,  181,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   470 */   190,  191,  192,  193,  194,  195,   20,  156,  260,  103,
 /*   480 */   155,  151,  157,  290,  156,    0,  268,   47,  208,  113,
 /*   490 */    12,   13,   14,   15,   16,  277,  268,  248,  249,  178,
 /*   500 */   179,  171,  172,  275,   64,  290,  178,  179,  280,  181,
 /*   510 */   182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   520 */   192,  193,  194,  195,   12,   13,   14,   15,   16,   82,
 /*   530 */   213,  214,  156,  208,   37,   94,   95,   96,   97,   98,
 /*   540 */    99,  100,  101,  102,  103,  104,  240,  106,  107,  108,
 /*   550 */   109,  110,  111,  240,  178,  179,  240,  181,  182,  183,
 /*   560 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   570 */   194,  195,   12,   13,   18,   75,   20,    0,   93,  247,
 /*   580 */    20,  247,   22,   27,  268,  307,   30,  261,   55,   14,
 /*   590 */   264,  259,  276,  259,   82,   20,  290,  112,  266,  114,
 /*   600 */   115,  116,  286,  290,   48,  268,  290,   47,  276,  331,
 /*   610 */   276,  240,  275,   80,  139,  286,   83,  280,  209,  119,
 /*   620 */   120,  292,  306,  145,   64,  309,  310,  311,  312,  313,
 /*   630 */   314,  315,  316,  317,  318,  160,  247,   60,   61,   62,
 /*   640 */    63,   81,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   650 */    73,   74,   75,   76,   77,   78,  240,   14,   15,   16,
 /*   660 */    20,  290,  240,  103,  240,  276,  254,  255,   57,  254,
 /*   670 */   255,  196,  240,  113,  118,    0,  240,  121,  122,  123,
 /*   680 */   124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
 /*   690 */   134,  135,  136,  137,  138,  247,  285,  286,  247,   42,
 /*   700 */    43,  307,  313,  268,  207,   55,  290,    3,  240,  240,
 /*   710 */   259,  247,  290,  240,  290,  280,  156,  328,  329,  330,
 /*   720 */    20,  332,  290,  259,  276,  331,  290,  276,  268,  240,
 /*   730 */   266,   81,  256,   83,  258,  241,  270,  277,  178,  179,
 /*   740 */   276,  181,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   750 */   190,  191,  192,  193,  194,  195,  290,  268,  290,  290,
 /*   760 */   240,  313,    0,  290,   93,  276,   47,   22,   93,  206,
 /*   770 */   207,  305,  306,  167,  168,  286,  328,  329,  330,  290,
 /*   780 */   332,   92,  316,   64,  295,  247,  115,  112,  268,  114,
 /*   790 */   115,  116,   47,   58,   41,  306,  276,  259,  309,  310,
 /*   800 */   311,  312,  313,  314,   41,  316,  286,   45,  319,  269,
 /*   810 */   290,  247,  323,  324,  276,  295,   85,   85,  270,   88,
 /*   820 */    88,  240,  182,  259,  335,   85,  306,  269,   88,  309,
 /*   830 */   310,  311,  312,  313,  314,   82,  316,  348,  290,  319,
 /*   840 */   276,  352,   44,  323,  324,   18,   12,   13,  247,  268,
 /*   850 */    23,   64,   21,  305,  306,  335,   22,  276,  208,  269,
 /*   860 */   259,  269,   35,   36,  316,   34,   39,  286,  348,  269,
 /*   870 */   247,  290,  352,    4,  247,   85,   41,  276,   88,   81,
 /*   880 */    41,   47,  259,   56,  240,   41,  259,  306,   19,  247,
 /*   890 */   309,  310,  311,  312,  313,  314,   47,  316,   64,  276,
 /*   900 */   319,  259,   33,  276,  323,  324,  325,    0,   81,    0,
 /*   910 */     0,  247,  268,  178,   45,  334,  269,   82,  276,   50,
 /*   920 */   276,   82,  257,  259,   55,   41,   82,  223,   47,   22,
 /*   930 */   286,   22,   22,   41,  290,  193,  194,  103,   41,  355,
 /*   940 */   276,   41,    1,    2,  117,   41,   41,  113,  299,   80,
 /*   950 */   306,  346,   83,  309,  310,  311,  312,  313,  314,  303,
 /*   960 */   316,  340,  113,  319,  268,  248,   82,  323,  324,  325,
 /*   970 */   240,  246,   41,   41,   82,  148,  149,  150,  334,   82,
 /*   980 */   153,  279,   82,  349,  308,  158,   82,   82,  225,   41,
 /*   990 */   156,   41,   41,  333,  113,  349,   20,  170,  268,  336,
 /*  1000 */   173,  240,  175,  176,  177,  247,  276,  349,   45,   41,
 /*  1010 */   304,   47,  178,   82,   82,  154,  286,  297,   41,  254,
 /*  1020 */   290,  247,  247,  189,  190,  191,   40,  284,  139,  268,
 /*  1030 */    82,  282,   82,   82,  282,  208,  306,  276,  247,  309,
 /*  1040 */   310,  311,  312,  313,  314,   20,  316,  286,  242,  319,
 /*  1050 */    82,  290,  242,  323,  324,  325,  295,   20,  247,   82,
 /*  1060 */   301,  252,  240,  286,  334,  252,   20,  306,   20,  296,
 /*  1070 */   309,  310,  311,  312,  313,  314,  294,  316,  252,  294,
 /*  1080 */   252,  276,   20,  287,  252,  252,  268,  276,  247,  252,
 /*  1090 */   268,  268,  242,  268,   64,  242,  335,  268,  276,  247,
 /*  1100 */   301,  163,  290,  300,  268,  250,  295,  286,  286,  348,
 /*  1110 */   268,  268,  290,  352,  268,  268,  268,  295,  250,  268,
 /*  1120 */   247,  250,  250,   20,  313,  240,  345,  287,  306,  216,
 /*  1130 */   215,  309,  310,  311,  312,  313,  314,  345,  316,  328,
 /*  1140 */   329,  330,  276,  332,  222,  147,  335,  290,  294,  291,
 /*  1150 */   291,  211,  290,  268,  290,  341,  240,  335,  342,  348,
 /*  1160 */   207,  276,  210,  352,  308,   20,  276,  307,   40,  339,
 /*  1170 */   348,  286,  226,  224,  352,  290,  338,   81,  291,  291,
 /*  1180 */   356,  290,  142,  229,  268,  290,  290,  288,  276,  326,
 /*  1190 */   287,  306,  276,  250,  309,  310,  311,  312,  313,  314,
 /*  1200 */   322,  316,  286,  264,  319,  250,  290,   81,  323,  324,
 /*  1210 */   240,  276,  247,  242,  272,  258,  351,  350,  298,  240,
 /*  1220 */   302,  351,  306,  250,  350,  309,  310,  311,  312,  313,
 /*  1230 */   314,  351,  316,  350,  262,  319,  262,  262,  268,  323,
 /*  1240 */   324,  251,  238,    0,    0,   72,  276,  268,    0,   47,
 /*  1250 */   174,   47,   47,   47,  174,  276,  286,    0,   47,   47,
 /*  1260 */   290,  174,    0,   47,    0,  286,   47,    0,   47,  290,
 /*  1270 */     0,   81,  160,  159,  113,  156,  306,  152,  151,  309,
 /*  1280 */   310,  311,  312,  313,  314,  306,  316,    0,  309,  310,
 /*  1290 */   311,  312,  313,  314,    0,  316,   19,  240,  319,   44,
 /*  1300 */     0,    0,    0,  324,    0,    0,    0,    0,  240,    0,
 /*  1310 */    33,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1320 */     0,    0,   45,  353,  354,  268,    0,    0,   51,   52,
 /*  1330 */    53,   54,   55,  276,    0,   40,  268,    0,    0,    0,
 /*  1340 */     0,    0,    0,  286,  276,   22,    0,  290,   40,   14,
 /*  1350 */   293,    0,    0,    0,  286,    0,    0,   80,  290,   37,
 /*  1360 */    83,   14,   37,  306,    0,   41,  309,  310,  311,  312,
 /*  1370 */   313,  314,   44,  316,  306,   44,  240,  309,  310,  311,
 /*  1380 */   312,  313,  314,   38,  316,    0,   37,  147,    0,    0,
 /*  1390 */     0,   37,   59,  116,    0,    0,   37,   47,    0,   37,
 /*  1400 */     0,    0,   45,   37,  268,   47,   45,   47,   45,   37,
 /*  1410 */    45,    0,  276,    0,   47,  347,   47,   88,  141,    0,
 /*  1420 */     0,  144,  286,    0,   22,  240,  290,   47,   47,   47,
 /*  1430 */    47,   47,   41,   90,   41,    0,  240,   22,    0,  162,
 /*  1440 */    22,  164,  306,   47,   47,  309,  310,  311,  312,  313,
 /*  1450 */   314,   48,  316,  268,    0,   22,   47,    0,   22,    0,
 /*  1460 */     0,  276,   22,   20,  268,   37,   22,    0,   47,    0,
 /*  1470 */     0,  286,  276,    0,    0,  290,   44,  145,  293,  206,
 /*  1480 */    81,  145,  286,   41,  212,   81,  290,  240,   41,  145,
 /*  1490 */   354,  306,   82,   41,  309,  310,  311,  312,  313,  314,
 /*  1500 */    44,  316,  306,   41,   82,  309,  310,  311,  312,  313,
 /*  1510 */   314,   81,  316,  142,  318,  268,  140,    2,   81,   41,
 /*  1520 */    41,   82,   81,  276,   33,   44,  240,   82,   82,  161,
 /*  1530 */    44,   82,   82,  286,   41,   47,   45,  290,   41,  240,
 /*  1540 */   293,   47,   51,   52,   53,   54,   55,   47,   47,   47,
 /*  1550 */    47,  178,   81,  306,  268,   44,  309,  310,  311,  312,
 /*  1560 */   313,  314,  276,  316,   82,   82,   81,  268,   81,   22,
 /*  1570 */    44,   80,  286,   81,   83,  276,  290,   82,   82,  293,
 /*  1580 */    81,    0,  212,   37,   22,  286,  212,  180,  240,  290,
 /*  1590 */    81,  143,  306,   81,   81,  309,  310,  311,  312,  313,
 /*  1600 */   314,  140,  316,   44,   44,  306,   82,   91,  309,  310,
 /*  1610 */   311,  312,  313,  314,   81,  316,  268,  240,   81,   81,
 /*  1620 */    92,   82,   47,   47,  276,   81,   47,   82,  105,   81,
 /*  1630 */    47,  140,   82,  142,  286,  144,   81,  146,  290,   47,
 /*  1640 */    82,   47,   81,   22,   81,  268,   82,  105,  105,   93,
 /*  1650 */    81,   81,   47,  276,  306,  164,  240,  309,  310,  311,
 /*  1660 */   312,  313,  314,  286,  316,   81,  113,  290,   22,   59,
 /*  1670 */   105,   58,   47,   64,   79,   41,   47,   47,   47,   47,
 /*  1680 */    47,   22,   47,  306,  268,   47,  309,  310,  311,  312,
 /*  1690 */   313,  314,  276,  316,   47,   47,   47,   47,   47,   47,
 /*  1700 */    47,   64,  286,    0,   47,  240,  290,   45,   37,    0,
 /*  1710 */    47,   45,   37,    0,   47,   45,  240,   37,    0,   47,
 /*  1720 */    37,   45,  306,    0,   47,  309,  310,  311,  312,  313,
 /*  1730 */   314,    0,  316,  268,   46,    0,   22,   21,  357,  357,
 /*  1740 */    21,  276,   22,   22,  268,   20,  357,  357,  357,  357,
 /*  1750 */   357,  286,  276,  357,  357,  290,  357,  357,  357,  357,
 /*  1760 */   357,  357,  286,  357,  357,  240,  290,  357,  357,  357,
 /*  1770 */   357,  306,  357,  357,  309,  310,  311,  312,  313,  314,
 /*  1780 */   240,  316,  306,  357,  357,  309,  310,  311,  312,  313,
 /*  1790 */   314,  357,  316,  268,  357,  357,  357,  240,  357,  357,
 /*  1800 */   357,  276,  357,  357,  357,  357,  357,  357,  268,  357,
 /*  1810 */   357,  286,  240,  357,  357,  290,  276,  357,  357,  357,
 /*  1820 */   357,  357,  357,  357,  357,  268,  286,  357,  357,  240,
 /*  1830 */   290,  306,  357,  276,  309,  310,  311,  312,  313,  314,
 /*  1840 */   268,  316,  357,  286,  357,  357,  306,  290,  276,  309,
 /*  1850 */   310,  311,  312,  313,  314,  357,  316,  268,  286,  357,
 /*  1860 */   357,  357,  290,  306,  357,  276,  309,  310,  311,  312,
 /*  1870 */   313,  314,  357,  316,  357,  286,  240,  357,  306,  290,
 /*  1880 */   357,  309,  310,  311,  312,  313,  314,  357,  316,  357,
 /*  1890 */   357,  357,  357,  357,  357,  306,  357,  357,  309,  310,
 /*  1900 */   311,  312,  313,  314,  268,  316,  357,  357,  240,  357,
 /*  1910 */   357,  357,  276,  357,  357,  357,  357,  357,  357,  357,
 /*  1920 */   357,  357,  286,  357,  357,  240,  290,  357,  357,  357,
 /*  1930 */   357,  357,  357,  357,  357,  357,  268,  357,  357,  357,
 /*  1940 */   357,  357,  306,  357,  276,  309,  310,  311,  312,  313,
 /*  1950 */   314,  357,  316,  268,  286,  357,  357,  240,  290,  357,
 /*  1960 */   357,  276,  357,  357,  357,  357,  357,  357,  357,  357,
 /*  1970 */   357,  286,  357,  357,  306,  290,  357,  309,  310,  311,
 /*  1980 */   312,  313,  314,  357,  316,  268,  357,  357,  357,  357,
 /*  1990 */   357,  306,  357,  276,  309,  310,  311,  312,  313,  314,
 /*  2000 */   357,  316,  357,  286,  357,  357,  240,  290,  357,  357,
 /*  2010 */   357,  357,  357,  357,  357,  357,  357,  357,  357,  247,
 /*  2020 */   357,  357,  357,  306,  357,  357,  309,  310,  311,  312,
 /*  2030 */   313,  314,  357,  316,  268,  357,  357,  357,  357,  357,
 /*  2040 */   357,  357,  276,  357,  357,  357,  357,  357,  276,  357,
 /*  2050 */   357,  357,  286,  357,  357,  357,  290,  357,  357,  357,
 /*  2060 */   357,  357,  357,  357,  357,  357,  357,  295,  357,  357,
 /*  2070 */   357,  357,  306,  357,  357,  309,  310,  311,  312,  313,
 /*  2080 */   314,  357,  316,  357,  357,  313,  357,  357,  357,  357,
 /*  2090 */   357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
 /*  2100 */   328,  329,  330,  357,  332,  357,  357,  335,  357,  357,
 /*  2110 */   357,  357,  357,  357,  357,  357,  357,  357,  357,  357,
 /*  2120 */   348,  357,  357,  357,  352,
};
#define YY_SHIFT_COUNT    (611)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1735)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   827,    0,    0,   48,   96,   96,   96,   96,  280,  280,
 /*    10 */    96,   96,  328,  376,  560,  376,  376,  376,  376,  376,
 /*    20 */   376,  376,  376,  376,  376,  376,  376,  376,  376,  376,
 /*    30 */   376,  376,  376,  376,  376,  376,  376,  376,  120,  120,
 /*    40 */    23,   23,   23,  834,  834,  834,  834,  325,  650,  124,
 /*    50 */    30,   30,   42,   42,   61,  124,  124,   30,   30,   30,
 /*    60 */    30,   30,   30,  194,   30,   30,  360,  433,  456,  360,
 /*    70 */    30,   30,  360,   30,  360,  360,  456,  360,   30,  611,
 /*    80 */   556,   59,  110,  110,  186,  378,  321,  321,  321,  321,
 /*    90 */   321,  321,  321,  321,  321,  321,  321,  321,  321,  321,
 /*   100 */   321,  321,  321,  321,  321,  161,  153,  575,  575,  299,
 /*   110 */   440,  246,  246,  246,  399,  440,  700,  456,  360,  360,
 /*   120 */   456,  689,  787,  441,  441,  441,  441,  441,  441,  441,
 /*   130 */  1277,  107,   97,  209,  117,  132,  317,   85,  183,  657,
 /*   140 */   745,  671,  297,  563,  497,  563,  704,  704,  704,  409,
 /*   150 */   640,  976,  963,  964,  861,  976,  976,  986,  889,  889,
 /*   160 */   976, 1025, 1025, 1037,  194,  456,  194, 1046, 1048,  194,
 /*   170 */  1046,  194,  700, 1062,  194,  194,  976,  194, 1025,  360,
 /*   180 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*   190 */   976, 1025, 1030, 1037,  611,  938,  456,  611,  976, 1046,
 /*   200 */   611,  700, 1062,  611, 1103,  913,  915, 1030,  913,  915,
 /*   210 */  1030, 1030,  360,  922,  998,  940,  952,  953,  700, 1145,
 /*   220 */  1128,  946,  949,  954,  946,  949,  946,  949, 1096,  915,
 /*   230 */  1030, 1030,  915, 1030, 1040,  700, 1062,  611,  689,  611,
 /*   240 */   700, 1126,  787,  976,  611, 1025, 2125, 2125, 2125, 2125,
 /*   250 */  2125, 2125, 2125,  577, 1491,  294,  869,   64,   14,  406,
 /*   260 */   478,  512,  485,  675,   21,   21,   21,   21,   21,   21,
 /*   270 */    21,   21,  237,  330,  533,  500,  447,  475,  643,  643,
 /*   280 */   643,  643,  762,  753,  731,  732,  740,  790,  907,  909,
 /*   290 */   910,  831,  606,  835,  839,  844,  941,  742,  763,  133,
 /*   300 */   884,  735,  892,  798,  900,  904,  905,  931,  932,  849,
 /*   310 */   881,  897,  948,  950,  951,  968,  977,    1,  719, 1243,
 /*   320 */  1244, 1173, 1248, 1202, 1076, 1204, 1205, 1206, 1080, 1257,
 /*   330 */  1211, 1212, 1087, 1262, 1216, 1264, 1219, 1267, 1221, 1270,
 /*   340 */  1190, 1112, 1114, 1161, 1119, 1287, 1294, 1125, 1127, 1304,
 /*   350 */  1305, 1255, 1300, 1301, 1302, 1306, 1307, 1309, 1311, 1312,
 /*   360 */  1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1326,
 /*   370 */  1295, 1327, 1334, 1337, 1338, 1339, 1340, 1323, 1341, 1342,
 /*   380 */  1346, 1351, 1352, 1353, 1308, 1322, 1324, 1335, 1328, 1347,
 /*   390 */  1331, 1355, 1345, 1325, 1356, 1364, 1385, 1349, 1240, 1388,
 /*   400 */  1389, 1354, 1390, 1333, 1394, 1395, 1350, 1357, 1359, 1398,
 /*   410 */  1358, 1361, 1362, 1400, 1360, 1363, 1366, 1401, 1367, 1365,
 /*   420 */  1372, 1411, 1413, 1419, 1420, 1343, 1329, 1369, 1402, 1423,
 /*   430 */  1380, 1381, 1382, 1383, 1391, 1393, 1384, 1396, 1397, 1435,
 /*   440 */  1415, 1438, 1418, 1403, 1454, 1433, 1409, 1457, 1436, 1459,
 /*   450 */  1440, 1443, 1460, 1332, 1421, 1469, 1368, 1444, 1336, 1371,
 /*   460 */  1467, 1470, 1473, 1344, 1474, 1399, 1428, 1376, 1442, 1447,
 /*   470 */  1272, 1410, 1452, 1422, 1404, 1430, 1437, 1439, 1462, 1432,
 /*   480 */  1456, 1441, 1478, 1370, 1445, 1446, 1481, 1273, 1479, 1486,
 /*   490 */  1449, 1493, 1374, 1450, 1488, 1494, 1500, 1501, 1502, 1503,
 /*   500 */  1450, 1515, 1373, 1497, 1482, 1471, 1483, 1511, 1485, 1487,
 /*   510 */  1526, 1547, 1407, 1492, 1495, 1496, 1499, 1509, 1448, 1512,
 /*   520 */  1581, 1546, 1461, 1513, 1516, 1559, 1560, 1533, 1524, 1537,
 /*   530 */  1562, 1538, 1528, 1539, 1575, 1576, 1544, 1545, 1579, 1548,
 /*   540 */  1550, 1583, 1555, 1558, 1592, 1561, 1564, 1594, 1563, 1523,
 /*   550 */  1542, 1543, 1565, 1621, 1556, 1569, 1570, 1605, 1584, 1553,
 /*   560 */  1646, 1610, 1613, 1625, 1609, 1595, 1634, 1629, 1630, 1631,
 /*   570 */  1632, 1633, 1659, 1635, 1638, 1637, 1391, 1647, 1393, 1648,
 /*   580 */  1649, 1650, 1651, 1652, 1653, 1703, 1657, 1662, 1671, 1709,
 /*   590 */  1663, 1666, 1675, 1713, 1667, 1670, 1680, 1718, 1672, 1676,
 /*   600 */  1683, 1723, 1677, 1688, 1731, 1735, 1714, 1716, 1720, 1721,
 /*   610 */  1719, 1725,
};
#define YY_REDUCE_COUNT (252)
#define YY_REDUCE_MIN   (-334)
#define YY_REDUCE_MAX   (1772)
static const short yy_reduce_ofst[] = {
 /*     0 */  -185,  489,  520, -223,   91,  581,  644,  730,  761,  822,
 /*    10 */   885,  916,  316,  970,  979, 1057, 1068, 1136, 1185, 1196,
 /*    20 */  1247, 1286, 1299, 1348, 1377, 1416, 1465, 1476, 1525, 1540,
 /*    30 */  1557, 1572, 1589, 1636, 1668, 1685, 1717, 1766,  811, 1772,
 /*    40 */    98,  389,  448, -267, -265,  466,  548, -293, -176,   34,
 /*    50 */   332,  464, -236, -189, -334, -304, -237,   57,  111,  119,
 /*    60 */   334,  451,  538,  180,  564,  601,  104,   79,  -21, -113,
 /*    70 */   623,  627,  228,  642,   86,  337, -133,  218,  664, -239,
 /*    80 */    58,  -48,  -48,  -48, -220, -253, -146, -110,    6,   13,
 /*    90 */   122,  154,  193,  215,  306,  313,  371,  416,  422,  424,
 /*   100 */   432,  436,  468,  469,  473,  150,  249, -178,  129,  -46,
 /*   110 */   412,  -87,  278,  394, -123,  415,   88,  329,  460,  435,
 /*   120 */   411,  326,  476, -254,  540,  558,  590,  592,  600,  647,
 /*   130 */   649,  494,  665,  584,  605,  656,  621,  696,  696,  725,
 /*   140 */   717,  702,  676,  660,  660,  660,  634,  646,  658,  663,
 /*   150 */   696,  758,  706,  765,  720,  774,  775,  743,  749,  752,
 /*   160 */   791,  806,  810,  759,  809,  777,  813,  782,  773,  826,
 /*   170 */   785,  828,  805,  796,  832,  833,  841,  837,  850,  818,
 /*   180 */   823,  825,  829,  836,  842,  843,  846,  847,  848,  851,
 /*   190 */   852,  853,  812,  799,  855,  803,  821,  868,  873,  854,
 /*   200 */   871,  866,  840,  872,  856,  781,  858,  857,  792,  859,
 /*   210 */   862,  864,  696,  816,  814,  830,  838,  660,  890,  860,
 /*   220 */   863,  865,  867,  824,  870,  874,  880,  883,  878,  887,
 /*   230 */   891,  895,  888,  896,  899,  912,  903,  943,  939,  955,
 /*   240 */   935,  942,  957,  965,  973,  971,  920,  918,  972,  974,
 /*   250 */   975,  990, 1004,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    10 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    20 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    30 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    40 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    50 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    60 */  1349, 1349, 1349, 1418, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    70 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1416,
 /*    80 */  1556, 1349, 1720, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*    90 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   100 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1418,
 /*   110 */  1349, 1731, 1731, 1731, 1416, 1349, 1349, 1349, 1349, 1349,
 /*   120 */  1349, 1512, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   130 */  1592, 1349, 1349, 1797, 1349, 1598, 1755, 1349, 1349, 1349,
 /*   140 */  1349, 1465, 1747, 1723, 1737, 1724, 1782, 1782, 1782, 1740,
 /*   150 */  1349, 1349, 1349, 1349, 1584, 1349, 1349, 1561, 1558, 1558,
 /*   160 */  1349, 1349, 1349, 1349, 1418, 1349, 1418, 1349, 1349, 1418,
 /*   170 */  1349, 1418, 1349, 1349, 1418, 1418, 1349, 1418, 1349, 1349,
 /*   180 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   190 */  1349, 1349, 1349, 1349, 1416, 1594, 1349, 1416, 1349, 1349,
 /*   200 */  1416, 1349, 1349, 1416, 1349, 1762, 1760, 1349, 1762, 1760,
 /*   210 */  1349, 1349, 1349, 1774, 1770, 1753, 1751, 1737, 1349, 1349,
 /*   220 */  1349, 1788, 1784, 1800, 1788, 1784, 1788, 1784, 1349, 1760,
 /*   230 */  1349, 1349, 1760, 1349, 1569, 1349, 1349, 1416, 1349, 1416,
 /*   240 */  1349, 1481, 1349, 1349, 1416, 1349, 1586, 1600, 1515, 1515,
 /*   250 */  1515, 1419, 1354, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   260 */  1349, 1349, 1349, 1349, 1664, 1773, 1772, 1696, 1695, 1694,
 /*   270 */  1692, 1663, 1477, 1349, 1349, 1349, 1349, 1349, 1657, 1658,
 /*   280 */  1656, 1655, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   290 */  1349, 1349, 1349, 1349, 1349, 1349, 1721, 1349, 1785, 1789,
 /*   300 */  1349, 1349, 1349, 1640, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   310 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   320 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   330 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   340 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   350 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   360 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   370 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   380 */  1349, 1349, 1349, 1349, 1349, 1349, 1383, 1349, 1349, 1349,
 /*   390 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   400 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   410 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   420 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   430 */  1349, 1349, 1349, 1349, 1446, 1445, 1349, 1349, 1349, 1349,
 /*   440 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   450 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   460 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1744, 1754,
 /*   470 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   480 */  1640, 1349, 1771, 1349, 1730, 1726, 1349, 1349, 1722, 1349,
 /*   490 */  1349, 1783, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   500 */  1349, 1716, 1349, 1689, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   510 */  1349, 1349, 1651, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   520 */  1349, 1349, 1349, 1349, 1349, 1639, 1349, 1680, 1349, 1349,
 /*   530 */  1349, 1349, 1349, 1349, 1349, 1349, 1509, 1349, 1349, 1349,
 /*   540 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1494,
 /*   550 */  1492, 1491, 1490, 1349, 1487, 1349, 1349, 1349, 1349, 1349,
 /*   560 */  1349, 1349, 1349, 1349, 1349, 1349, 1438, 1349, 1349, 1349,
 /*   570 */  1349, 1349, 1349, 1349, 1349, 1349, 1429, 1349, 1428, 1349,
 /*   580 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   590 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   600 */  1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349, 1349,
 /*   610 */  1349, 1349,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  230,  /*  NK_BITNOT => ID */
  230,  /*     INSERT => ID */
  230,  /*     VALUES => ID */
  230,  /*     IMPORT => ID */
  230,  /*    NK_SEMI => ID */
  230,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "FILE_FACTOR",
  /*  113 */ "NK_FLOAT",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "SHOW",
  /*  118 */ "DATABASES",
  /*  119 */ "TABLES",
  /*  120 */ "STABLES",
  /*  121 */ "MNODES",
  /*  122 */ "MODULES",
  /*  123 */ "QNODES",
  /*  124 */ "FUNCTIONS",
  /*  125 */ "INDEXES",
  /*  126 */ "ACCOUNTS",
  /*  127 */ "APPS",
  /*  128 */ "CONNECTIONS",
  /*  129 */ "LICENCE",
  /*  130 */ "GRANTS",
  /*  131 */ "QUERIES",
  /*  132 */ "SCORES",
  /*  133 */ "TOPICS",
  /*  134 */ "VARIABLES",
  /*  135 */ "BNODES",
  /*  136 */ "SNODES",
  /*  137 */ "CLUSTER",
  /*  138 */ "TRANSACTIONS",
  /*  139 */ "LIKE",
  /*  140 */ "INDEX",
  /*  141 */ "FULLTEXT",
  /*  142 */ "FUNCTION",
  /*  143 */ "INTERVAL",
  /*  144 */ "TOPIC",
  /*  145 */ "AS",
  /*  146 */ "CONSUMER",
  /*  147 */ "GROUP",
  /*  148 */ "DESC",
  /*  149 */ "DESCRIBE",
  /*  150 */ "RESET",
  /*  151 */ "QUERY",
  /*  152 */ "CACHE",
  /*  153 */ "EXPLAIN",
  /*  154 */ "ANALYZE",
  /*  155 */ "VERBOSE",
  /*  156 */ "NK_BOOL",
  /*  157 */ "RATIO",
  /*  158 */ "COMPACT",
  /*  159 */ "VNODES",
  /*  160 */ "IN",
  /*  161 */ "OUTPUTTYPE",
  /*  162 */ "AGGREGATE",
  /*  163 */ "BUFSIZE",
  /*  164 */ "STREAM",
  /*  165 */ "INTO",
  /*  166 */ "TRIGGER",
  /*  167 */ "AT_ONCE",
  /*  168 */ "WINDOW_CLOSE",
  /*  169 */ "WATERMARK",
  /*  170 */ "KILL",
  /*  171 */ "CONNECTION",
  /*  172 */ "TRANSACTION",
  /*  173 */ "MERGE",
  /*  174 */ "VGROUP",
  /*  175 */ "REDISTRIBUTE",
  /*  176 */ "SPLIT",
  /*  177 */ "SYNCDB",
  /*  178 */ "NULL",
  /*  179 */ "NK_QUESTION",
  /*  180 */ "NK_ARROW",
  /*  181 */ "ROWTS",
  /*  182 */ "TBNAME",
  /*  183 */ "QSTARTTS",
  /*  184 */ "QENDTS",
  /*  185 */ "WSTARTTS",
  /*  186 */ "WENDTS",
  /*  187 */ "WDURATION",
  /*  188 */ "CAST",
  /*  189 */ "NOW",
  /*  190 */ "TODAY",
  /*  191 */ "TIMEZONE",
  /*  192 */ "COUNT",
  /*  193 */ "FIRST",
  /*  194 */ "LAST",
  /*  195 */ "LAST_ROW",
  /*  196 */ "BETWEEN",
  /*  197 */ "IS",
  /*  198 */ "NK_LT",
  /*  199 */ "NK_GT",
  /*  200 */ "NK_LE",
  /*  201 */ "NK_GE",
  /*  202 */ "NK_NE",
  /*  203 */ "MATCH",
  /*  204 */ "NMATCH",
  /*  205 */ "CONTAINS",
  /*  206 */ "JOIN",
  /*  207 */ "INNER",
  /*  208 */ "SELECT",
  /*  209 */ "DISTINCT",
  /*  210 */ "WHERE",
  /*  211 */ "PARTITION",
  /*  212 */ "BY",
  /*  213 */ "SESSION",
  /*  214 */ "STATE_WINDOW",
  /*  215 */ "SLIDING",
  /*  216 */ "FILL",
  /*  217 */ "VALUE",
  /*  218 */ "NONE",
  /*  219 */ "PREV",
  /*  220 */ "LINEAR",
  /*  221 */ "NEXT",
  /*  222 */ "HAVING",
  /*  223 */ "ORDER",
  /*  224 */ "SLIMIT",
  /*  225 */ "SOFFSET",
  /*  226 */ "LIMIT",
  /*  227 */ "OFFSET",
  /*  228 */ "ASC",
  /*  229 */ "NULLS",
  /*  230 */ "ID",
  /*  231 */ "NK_BITNOT",
  /*  232 */ "INSERT",
  /*  233 */ "VALUES",
  /*  234 */ "IMPORT",
  /*  235 */ "NK_SEMI",
  /*  236 */ "FILE",
  /*  237 */ "cmd",
  /*  238 */ "account_options",
  /*  239 */ "alter_account_options",
  /*  240 */ "literal",
  /*  241 */ "alter_account_option",
  /*  242 */ "user_name",
  /*  243 */ "privileges",
  /*  244 */ "priv_level",
  /*  245 */ "priv_type_list",
  /*  246 */ "priv_type",
  /*  247 */ "db_name",
  /*  248 */ "dnode_endpoint",
  /*  249 */ "dnode_host_name",
  /*  250 */ "not_exists_opt",
  /*  251 */ "db_options",
  /*  252 */ "exists_opt",
  /*  253 */ "alter_db_options",
  /*  254 */ "integer_list",
  /*  255 */ "variable_list",
  /*  256 */ "retention_list",
  /*  257 */ "alter_db_option",
  /*  258 */ "retention",
  /*  259 */ "full_table_name",
  /*  260 */ "column_def_list",
  /*  261 */ "tags_def_opt",
  /*  262 */ "table_options",
  /*  263 */ "multi_create_clause",
  /*  264 */ "tags_def",
  /*  265 */ "multi_drop_clause",
  /*  266 */ "alter_table_clause",
  /*  267 */ "alter_table_options",
  /*  268 */ "column_name",
  /*  269 */ "type_name",
  /*  270 */ "signed_literal",
  /*  271 */ "create_subtable_clause",
  /*  272 */ "specific_tags_opt",
  /*  273 */ "literal_list",
  /*  274 */ "drop_table_clause",
  /*  275 */ "col_name_list",
  /*  276 */ "table_name",
  /*  277 */ "column_def",
  /*  278 */ "func_name_list",
  /*  279 */ "alter_table_option",
  /*  280 */ "col_name",
  /*  281 */ "db_name_cond_opt",
  /*  282 */ "like_pattern_opt",
  /*  283 */ "table_name_cond",
  /*  284 */ "from_db_opt",
  /*  285 */ "func_name",
  /*  286 */ "function_name",
  /*  287 */ "index_name",
  /*  288 */ "index_options",
  /*  289 */ "func_list",
  /*  290 */ "duration_literal",
  /*  291 */ "sliding_opt",
  /*  292 */ "func",
  /*  293 */ "expression_list",
  /*  294 */ "topic_name",
  /*  295 */ "query_expression",
  /*  296 */ "cgroup_name",
  /*  297 */ "analyze_opt",
  /*  298 */ "explain_options",
  /*  299 */ "agg_func_opt",
  /*  300 */ "bufsize_opt",
  /*  301 */ "stream_name",
  /*  302 */ "stream_options",
  /*  303 */ "into_opt",
  /*  304 */ "dnode_list",
  /*  305 */ "signed",
  /*  306 */ "literal_func",
  /*  307 */ "table_alias",
  /*  308 */ "column_alias",
  /*  309 */ "expression",
  /*  310 */ "pseudo_column",
  /*  311 */ "column_reference",
  /*  312 */ "function_expression",
  /*  313 */ "subquery",
  /*  314 */ "star_func",
  /*  315 */ "star_func_para_list",
  /*  316 */ "noarg_func",
  /*  317 */ "other_para_list",
  /*  318 */ "star_func_para",
  /*  319 */ "predicate",
  /*  320 */ "compare_op",
  /*  321 */ "in_op",
  /*  322 */ "in_predicate_value",
  /*  323 */ "boolean_value_expression",
  /*  324 */ "boolean_primary",
  /*  325 */ "common_expression",
  /*  326 */ "from_clause",
  /*  327 */ "table_reference_list",
  /*  328 */ "table_reference",
  /*  329 */ "table_primary",
  /*  330 */ "joined_table",
  /*  331 */ "alias_opt",
  /*  332 */ "parenthesized_joined_table",
  /*  333 */ "join_type",
  /*  334 */ "search_condition",
  /*  335 */ "query_specification",
  /*  336 */ "set_quantifier_opt",
  /*  337 */ "select_list",
  /*  338 */ "where_clause_opt",
  /*  339 */ "partition_by_clause_opt",
  /*  340 */ "twindow_clause_opt",
  /*  341 */ "group_by_clause_opt",
  /*  342 */ "having_clause_opt",
  /*  343 */ "select_sublist",
  /*  344 */ "select_item",
  /*  345 */ "fill_opt",
  /*  346 */ "fill_mode",
  /*  347 */ "group_by_list",
  /*  348 */ "query_expression_body",
  /*  349 */ "order_by_clause_opt",
  /*  350 */ "slimit_clause_opt",
  /*  351 */ "limit_clause_opt",
  /*  352 */ "query_primary",
  /*  353 */ "sort_specification_list",
  /*  354 */ "sort_specification",
  /*  355 */ "ordering_specification_opt",
  /*  356 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 166 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 167 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 168 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 169 */ "alter_table_options ::= alter_table_option",
 /* 170 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 171 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 172 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 173 */ "col_name_list ::= col_name",
 /* 174 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 175 */ "col_name ::= column_name",
 /* 176 */ "cmd ::= SHOW DNODES",
 /* 177 */ "cmd ::= SHOW USERS",
 /* 178 */ "cmd ::= SHOW DATABASES",
 /* 179 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 182 */ "cmd ::= SHOW MNODES",
 /* 183 */ "cmd ::= SHOW MODULES",
 /* 184 */ "cmd ::= SHOW QNODES",
 /* 185 */ "cmd ::= SHOW FUNCTIONS",
 /* 186 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 187 */ "cmd ::= SHOW STREAMS",
 /* 188 */ "cmd ::= SHOW ACCOUNTS",
 /* 189 */ "cmd ::= SHOW APPS",
 /* 190 */ "cmd ::= SHOW CONNECTIONS",
 /* 191 */ "cmd ::= SHOW LICENCE",
 /* 192 */ "cmd ::= SHOW GRANTS",
 /* 193 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 194 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 195 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 196 */ "cmd ::= SHOW QUERIES",
 /* 197 */ "cmd ::= SHOW SCORES",
 /* 198 */ "cmd ::= SHOW TOPICS",
 /* 199 */ "cmd ::= SHOW VARIABLES",
 /* 200 */ "cmd ::= SHOW BNODES",
 /* 201 */ "cmd ::= SHOW SNODES",
 /* 202 */ "cmd ::= SHOW CLUSTER",
 /* 203 */ "cmd ::= SHOW TRANSACTIONS",
 /* 204 */ "db_name_cond_opt ::=",
 /* 205 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 206 */ "like_pattern_opt ::=",
 /* 207 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 208 */ "table_name_cond ::= table_name",
 /* 209 */ "from_db_opt ::=",
 /* 210 */ "from_db_opt ::= FROM db_name",
 /* 211 */ "func_name_list ::= func_name",
 /* 212 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 213 */ "func_name ::= function_name",
 /* 214 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 215 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 216 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 217 */ "index_options ::=",
 /* 218 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 220 */ "func_list ::= func",
 /* 221 */ "func_list ::= func_list NK_COMMA func",
 /* 222 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 223 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 225 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 226 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 227 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 228 */ "cmd ::= DESC full_table_name",
 /* 229 */ "cmd ::= DESCRIBE full_table_name",
 /* 230 */ "cmd ::= RESET QUERY CACHE",
 /* 231 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 232 */ "analyze_opt ::=",
 /* 233 */ "analyze_opt ::= ANALYZE",
 /* 234 */ "explain_options ::=",
 /* 235 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 236 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 237 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 238 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 239 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 240 */ "agg_func_opt ::=",
 /* 241 */ "agg_func_opt ::= AGGREGATE",
 /* 242 */ "bufsize_opt ::=",
 /* 243 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 244 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 245 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 246 */ "into_opt ::=",
 /* 247 */ "into_opt ::= INTO full_table_name",
 /* 248 */ "stream_options ::=",
 /* 249 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 250 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 251 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 252 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 253 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 254 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 255 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 256 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 257 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 258 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 259 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 260 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 261 */ "cmd ::= query_expression",
 /* 262 */ "literal ::= NK_INTEGER",
 /* 263 */ "literal ::= NK_FLOAT",
 /* 264 */ "literal ::= NK_STRING",
 /* 265 */ "literal ::= NK_BOOL",
 /* 266 */ "literal ::= TIMESTAMP NK_STRING",
 /* 267 */ "literal ::= duration_literal",
 /* 268 */ "literal ::= NULL",
 /* 269 */ "literal ::= NK_QUESTION",
 /* 270 */ "duration_literal ::= NK_VARIABLE",
 /* 271 */ "signed ::= NK_INTEGER",
 /* 272 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 273 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 274 */ "signed ::= NK_FLOAT",
 /* 275 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 276 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 277 */ "signed_literal ::= signed",
 /* 278 */ "signed_literal ::= NK_STRING",
 /* 279 */ "signed_literal ::= NK_BOOL",
 /* 280 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 281 */ "signed_literal ::= duration_literal",
 /* 282 */ "signed_literal ::= NULL",
 /* 283 */ "signed_literal ::= literal_func",
 /* 284 */ "literal_list ::= signed_literal",
 /* 285 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 286 */ "db_name ::= NK_ID",
 /* 287 */ "table_name ::= NK_ID",
 /* 288 */ "column_name ::= NK_ID",
 /* 289 */ "function_name ::= NK_ID",
 /* 290 */ "table_alias ::= NK_ID",
 /* 291 */ "column_alias ::= NK_ID",
 /* 292 */ "user_name ::= NK_ID",
 /* 293 */ "index_name ::= NK_ID",
 /* 294 */ "topic_name ::= NK_ID",
 /* 295 */ "stream_name ::= NK_ID",
 /* 296 */ "cgroup_name ::= NK_ID",
 /* 297 */ "expression ::= literal",
 /* 298 */ "expression ::= pseudo_column",
 /* 299 */ "expression ::= column_reference",
 /* 300 */ "expression ::= function_expression",
 /* 301 */ "expression ::= subquery",
 /* 302 */ "expression ::= NK_LP expression NK_RP",
 /* 303 */ "expression ::= NK_PLUS expression",
 /* 304 */ "expression ::= NK_MINUS expression",
 /* 305 */ "expression ::= expression NK_PLUS expression",
 /* 306 */ "expression ::= expression NK_MINUS expression",
 /* 307 */ "expression ::= expression NK_STAR expression",
 /* 308 */ "expression ::= expression NK_SLASH expression",
 /* 309 */ "expression ::= expression NK_REM expression",
 /* 310 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 311 */ "expression_list ::= expression",
 /* 312 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 313 */ "column_reference ::= column_name",
 /* 314 */ "column_reference ::= table_name NK_DOT column_name",
 /* 315 */ "pseudo_column ::= ROWTS",
 /* 316 */ "pseudo_column ::= TBNAME",
 /* 317 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 318 */ "pseudo_column ::= QSTARTTS",
 /* 319 */ "pseudo_column ::= QENDTS",
 /* 320 */ "pseudo_column ::= WSTARTTS",
 /* 321 */ "pseudo_column ::= WENDTS",
 /* 322 */ "pseudo_column ::= WDURATION",
 /* 323 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 324 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 325 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 326 */ "function_expression ::= literal_func",
 /* 327 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 328 */ "literal_func ::= NOW",
 /* 329 */ "noarg_func ::= NOW",
 /* 330 */ "noarg_func ::= TODAY",
 /* 331 */ "noarg_func ::= TIMEZONE",
 /* 332 */ "star_func ::= COUNT",
 /* 333 */ "star_func ::= FIRST",
 /* 334 */ "star_func ::= LAST",
 /* 335 */ "star_func ::= LAST_ROW",
 /* 336 */ "star_func_para_list ::= NK_STAR",
 /* 337 */ "star_func_para_list ::= other_para_list",
 /* 338 */ "other_para_list ::= star_func_para",
 /* 339 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 340 */ "star_func_para ::= expression",
 /* 341 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 342 */ "predicate ::= expression compare_op expression",
 /* 343 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 344 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 345 */ "predicate ::= expression IS NULL",
 /* 346 */ "predicate ::= expression IS NOT NULL",
 /* 347 */ "predicate ::= expression in_op in_predicate_value",
 /* 348 */ "compare_op ::= NK_LT",
 /* 349 */ "compare_op ::= NK_GT",
 /* 350 */ "compare_op ::= NK_LE",
 /* 351 */ "compare_op ::= NK_GE",
 /* 352 */ "compare_op ::= NK_NE",
 /* 353 */ "compare_op ::= NK_EQ",
 /* 354 */ "compare_op ::= LIKE",
 /* 355 */ "compare_op ::= NOT LIKE",
 /* 356 */ "compare_op ::= MATCH",
 /* 357 */ "compare_op ::= NMATCH",
 /* 358 */ "compare_op ::= CONTAINS",
 /* 359 */ "in_op ::= IN",
 /* 360 */ "in_op ::= NOT IN",
 /* 361 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 362 */ "boolean_value_expression ::= boolean_primary",
 /* 363 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 364 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 365 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 366 */ "boolean_primary ::= predicate",
 /* 367 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 368 */ "common_expression ::= expression",
 /* 369 */ "common_expression ::= boolean_value_expression",
 /* 370 */ "from_clause ::= FROM table_reference_list",
 /* 371 */ "table_reference_list ::= table_reference",
 /* 372 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 373 */ "table_reference ::= table_primary",
 /* 374 */ "table_reference ::= joined_table",
 /* 375 */ "table_primary ::= table_name alias_opt",
 /* 376 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 377 */ "table_primary ::= subquery alias_opt",
 /* 378 */ "table_primary ::= parenthesized_joined_table",
 /* 379 */ "alias_opt ::=",
 /* 380 */ "alias_opt ::= table_alias",
 /* 381 */ "alias_opt ::= AS table_alias",
 /* 382 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 383 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 384 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 385 */ "join_type ::=",
 /* 386 */ "join_type ::= INNER",
 /* 387 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 388 */ "set_quantifier_opt ::=",
 /* 389 */ "set_quantifier_opt ::= DISTINCT",
 /* 390 */ "set_quantifier_opt ::= ALL",
 /* 391 */ "select_list ::= NK_STAR",
 /* 392 */ "select_list ::= select_sublist",
 /* 393 */ "select_sublist ::= select_item",
 /* 394 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 395 */ "select_item ::= common_expression",
 /* 396 */ "select_item ::= common_expression column_alias",
 /* 397 */ "select_item ::= common_expression AS column_alias",
 /* 398 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 399 */ "where_clause_opt ::=",
 /* 400 */ "where_clause_opt ::= WHERE search_condition",
 /* 401 */ "partition_by_clause_opt ::=",
 /* 402 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 403 */ "twindow_clause_opt ::=",
 /* 404 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 405 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 406 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 407 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 408 */ "sliding_opt ::=",
 /* 409 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 410 */ "fill_opt ::=",
 /* 411 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 412 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 413 */ "fill_mode ::= NONE",
 /* 414 */ "fill_mode ::= PREV",
 /* 415 */ "fill_mode ::= NULL",
 /* 416 */ "fill_mode ::= LINEAR",
 /* 417 */ "fill_mode ::= NEXT",
 /* 418 */ "group_by_clause_opt ::=",
 /* 419 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 420 */ "group_by_list ::= expression",
 /* 421 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 422 */ "having_clause_opt ::=",
 /* 423 */ "having_clause_opt ::= HAVING search_condition",
 /* 424 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 425 */ "query_expression_body ::= query_primary",
 /* 426 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 427 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 428 */ "query_primary ::= query_specification",
 /* 429 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 430 */ "order_by_clause_opt ::=",
 /* 431 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 432 */ "slimit_clause_opt ::=",
 /* 433 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 434 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 435 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 436 */ "limit_clause_opt ::=",
 /* 437 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 438 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 439 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 440 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 441 */ "search_condition ::= common_expression",
 /* 442 */ "sort_specification_list ::= sort_specification",
 /* 443 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 444 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 445 */ "ordering_specification_opt ::=",
 /* 446 */ "ordering_specification_opt ::= ASC",
 /* 447 */ "ordering_specification_opt ::= DESC",
 /* 448 */ "null_ordering_opt ::=",
 /* 449 */ "null_ordering_opt ::= NULLS FIRST",
 /* 450 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 237: /* cmd */
    case 240: /* literal */
    case 251: /* db_options */
    case 253: /* alter_db_options */
    case 258: /* retention */
    case 259: /* full_table_name */
    case 262: /* table_options */
    case 266: /* alter_table_clause */
    case 267: /* alter_table_options */
    case 270: /* signed_literal */
    case 271: /* create_subtable_clause */
    case 274: /* drop_table_clause */
    case 277: /* column_def */
    case 280: /* col_name */
    case 281: /* db_name_cond_opt */
    case 282: /* like_pattern_opt */
    case 283: /* table_name_cond */
    case 284: /* from_db_opt */
    case 285: /* func_name */
    case 288: /* index_options */
    case 290: /* duration_literal */
    case 291: /* sliding_opt */
    case 292: /* func */
    case 295: /* query_expression */
    case 298: /* explain_options */
    case 302: /* stream_options */
    case 303: /* into_opt */
    case 305: /* signed */
    case 306: /* literal_func */
    case 309: /* expression */
    case 310: /* pseudo_column */
    case 311: /* column_reference */
    case 312: /* function_expression */
    case 313: /* subquery */
    case 318: /* star_func_para */
    case 319: /* predicate */
    case 322: /* in_predicate_value */
    case 323: /* boolean_value_expression */
    case 324: /* boolean_primary */
    case 325: /* common_expression */
    case 326: /* from_clause */
    case 327: /* table_reference_list */
    case 328: /* table_reference */
    case 329: /* table_primary */
    case 330: /* joined_table */
    case 332: /* parenthesized_joined_table */
    case 334: /* search_condition */
    case 335: /* query_specification */
    case 338: /* where_clause_opt */
    case 340: /* twindow_clause_opt */
    case 342: /* having_clause_opt */
    case 344: /* select_item */
    case 345: /* fill_opt */
    case 348: /* query_expression_body */
    case 350: /* slimit_clause_opt */
    case 351: /* limit_clause_opt */
    case 352: /* query_primary */
    case 354: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy686)); 
}
      break;
    case 238: /* account_options */
    case 239: /* alter_account_options */
    case 241: /* alter_account_option */
    case 300: /* bufsize_opt */
{
 
}
      break;
    case 242: /* user_name */
    case 244: /* priv_level */
    case 247: /* db_name */
    case 248: /* dnode_endpoint */
    case 249: /* dnode_host_name */
    case 268: /* column_name */
    case 276: /* table_name */
    case 286: /* function_name */
    case 287: /* index_name */
    case 294: /* topic_name */
    case 296: /* cgroup_name */
    case 301: /* stream_name */
    case 307: /* table_alias */
    case 308: /* column_alias */
    case 314: /* star_func */
    case 316: /* noarg_func */
    case 331: /* alias_opt */
{
 
}
      break;
    case 243: /* privileges */
    case 245: /* priv_type_list */
    case 246: /* priv_type */
{
 
}
      break;
    case 250: /* not_exists_opt */
    case 252: /* exists_opt */
    case 297: /* analyze_opt */
    case 299: /* agg_func_opt */
    case 336: /* set_quantifier_opt */
{
 
}
      break;
    case 254: /* integer_list */
    case 255: /* variable_list */
    case 256: /* retention_list */
    case 260: /* column_def_list */
    case 261: /* tags_def_opt */
    case 263: /* multi_create_clause */
    case 264: /* tags_def */
    case 265: /* multi_drop_clause */
    case 272: /* specific_tags_opt */
    case 273: /* literal_list */
    case 275: /* col_name_list */
    case 278: /* func_name_list */
    case 289: /* func_list */
    case 293: /* expression_list */
    case 304: /* dnode_list */
    case 315: /* star_func_para_list */
    case 317: /* other_para_list */
    case 337: /* select_list */
    case 339: /* partition_by_clause_opt */
    case 341: /* group_by_clause_opt */
    case 343: /* select_sublist */
    case 347: /* group_by_list */
    case 349: /* order_by_clause_opt */
    case 353: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy670)); 
}
      break;
    case 257: /* alter_db_option */
    case 279: /* alter_table_option */
{
 
}
      break;
    case 269: /* type_name */
{
 
}
      break;
    case 320: /* compare_op */
    case 321: /* in_op */
{
 
}
      break;
    case 333: /* join_type */
{
 
}
      break;
    case 346: /* fill_mode */
{
 
}
      break;
    case 355: /* ordering_specification_opt */
{
 
}
      break;
    case 356: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  237,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  237,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  238,    0 }, /* (2) account_options ::= */
  {  238,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  238,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  238,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  238,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  238,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  238,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  238,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  238,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  238,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  239,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  239,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  241,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  241,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  241,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  241,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  241,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  241,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  241,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  241,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  241,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  241,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  237,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  237,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  237,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  237,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  237,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  237,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  243,   -1 }, /* (30) privileges ::= ALL */
  {  243,   -1 }, /* (31) privileges ::= priv_type_list */
  {  245,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  245,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  246,   -1 }, /* (34) priv_type ::= READ */
  {  246,   -1 }, /* (35) priv_type ::= WRITE */
  {  244,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  244,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  237,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  237,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  237,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  237,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  237,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  237,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  237,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  237,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  248,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  249,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  249,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  237,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  237,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  237,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  237,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  237,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  237,   -2 }, /* (61) cmd ::= USE db_name */
  {  237,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  250,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  250,    0 }, /* (64) not_exists_opt ::= */
  {  252,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  252,    0 }, /* (66) exists_opt ::= */
  {  251,    0 }, /* (67) db_options ::= */
  {  251,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  251,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  251,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  251,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  251,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  251,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  251,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  251,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  251,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  251,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  251,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  251,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  251,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  251,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  251,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  251,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  251,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  251,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  251,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  251,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  253,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  253,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  257,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  257,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  257,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  257,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  257,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  257,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  257,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  257,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  257,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  254,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  254,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  255,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  255,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  256,   -1 }, /* (103) retention_list ::= retention */
  {  256,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  258,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  237,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  237,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  237,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  237,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  237,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  237,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  237,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  266,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  266,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  266,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  266,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  266,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  266,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  266,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  266,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  266,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  266,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  263,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  263,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  271,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  265,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  265,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  274,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  272,    0 }, /* (129) specific_tags_opt ::= */
  {  272,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  259,   -1 }, /* (131) full_table_name ::= table_name */
  {  259,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  260,   -1 }, /* (133) column_def_list ::= column_def */
  {  260,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  277,   -2 }, /* (135) column_def ::= column_name type_name */
  {  277,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  269,   -1 }, /* (137) type_name ::= BOOL */
  {  269,   -1 }, /* (138) type_name ::= TINYINT */
  {  269,   -1 }, /* (139) type_name ::= SMALLINT */
  {  269,   -1 }, /* (140) type_name ::= INT */
  {  269,   -1 }, /* (141) type_name ::= INTEGER */
  {  269,   -1 }, /* (142) type_name ::= BIGINT */
  {  269,   -1 }, /* (143) type_name ::= FLOAT */
  {  269,   -1 }, /* (144) type_name ::= DOUBLE */
  {  269,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  269,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  269,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  269,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  269,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  269,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  269,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  269,   -1 }, /* (152) type_name ::= JSON */
  {  269,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  269,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  269,   -1 }, /* (155) type_name ::= BLOB */
  {  269,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  269,   -1 }, /* (157) type_name ::= DECIMAL */
  {  269,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  269,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  261,    0 }, /* (160) tags_def_opt ::= */
  {  261,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  264,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  262,    0 }, /* (163) table_options ::= */
  {  262,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  262,   -3 }, /* (165) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  262,   -5 }, /* (166) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  262,   -3 }, /* (167) table_options ::= table_options TTL NK_INTEGER */
  {  262,   -5 }, /* (168) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  267,   -1 }, /* (169) alter_table_options ::= alter_table_option */
  {  267,   -2 }, /* (170) alter_table_options ::= alter_table_options alter_table_option */
  {  279,   -2 }, /* (171) alter_table_option ::= COMMENT NK_STRING */
  {  279,   -2 }, /* (172) alter_table_option ::= TTL NK_INTEGER */
  {  275,   -1 }, /* (173) col_name_list ::= col_name */
  {  275,   -3 }, /* (174) col_name_list ::= col_name_list NK_COMMA col_name */
  {  280,   -1 }, /* (175) col_name ::= column_name */
  {  237,   -2 }, /* (176) cmd ::= SHOW DNODES */
  {  237,   -2 }, /* (177) cmd ::= SHOW USERS */
  {  237,   -2 }, /* (178) cmd ::= SHOW DATABASES */
  {  237,   -4 }, /* (179) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  237,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  237,   -3 }, /* (181) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  237,   -2 }, /* (182) cmd ::= SHOW MNODES */
  {  237,   -2 }, /* (183) cmd ::= SHOW MODULES */
  {  237,   -2 }, /* (184) cmd ::= SHOW QNODES */
  {  237,   -2 }, /* (185) cmd ::= SHOW FUNCTIONS */
  {  237,   -5 }, /* (186) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  237,   -2 }, /* (187) cmd ::= SHOW STREAMS */
  {  237,   -2 }, /* (188) cmd ::= SHOW ACCOUNTS */
  {  237,   -2 }, /* (189) cmd ::= SHOW APPS */
  {  237,   -2 }, /* (190) cmd ::= SHOW CONNECTIONS */
  {  237,   -2 }, /* (191) cmd ::= SHOW LICENCE */
  {  237,   -2 }, /* (192) cmd ::= SHOW GRANTS */
  {  237,   -4 }, /* (193) cmd ::= SHOW CREATE DATABASE db_name */
  {  237,   -4 }, /* (194) cmd ::= SHOW CREATE TABLE full_table_name */
  {  237,   -4 }, /* (195) cmd ::= SHOW CREATE STABLE full_table_name */
  {  237,   -2 }, /* (196) cmd ::= SHOW QUERIES */
  {  237,   -2 }, /* (197) cmd ::= SHOW SCORES */
  {  237,   -2 }, /* (198) cmd ::= SHOW TOPICS */
  {  237,   -2 }, /* (199) cmd ::= SHOW VARIABLES */
  {  237,   -2 }, /* (200) cmd ::= SHOW BNODES */
  {  237,   -2 }, /* (201) cmd ::= SHOW SNODES */
  {  237,   -2 }, /* (202) cmd ::= SHOW CLUSTER */
  {  237,   -2 }, /* (203) cmd ::= SHOW TRANSACTIONS */
  {  281,    0 }, /* (204) db_name_cond_opt ::= */
  {  281,   -2 }, /* (205) db_name_cond_opt ::= db_name NK_DOT */
  {  282,    0 }, /* (206) like_pattern_opt ::= */
  {  282,   -2 }, /* (207) like_pattern_opt ::= LIKE NK_STRING */
  {  283,   -1 }, /* (208) table_name_cond ::= table_name */
  {  284,    0 }, /* (209) from_db_opt ::= */
  {  284,   -2 }, /* (210) from_db_opt ::= FROM db_name */
  {  278,   -1 }, /* (211) func_name_list ::= func_name */
  {  278,   -3 }, /* (212) func_name_list ::= func_name_list NK_COMMA func_name */
  {  285,   -1 }, /* (213) func_name ::= function_name */
  {  237,   -8 }, /* (214) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  237,  -10 }, /* (215) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  237,   -6 }, /* (216) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  288,    0 }, /* (217) index_options ::= */
  {  288,   -9 }, /* (218) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  288,  -11 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  289,   -1 }, /* (220) func_list ::= func */
  {  289,   -3 }, /* (221) func_list ::= func_list NK_COMMA func */
  {  292,   -4 }, /* (222) func ::= function_name NK_LP expression_list NK_RP */
  {  237,   -6 }, /* (223) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  237,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  237,   -7 }, /* (225) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  237,   -4 }, /* (226) cmd ::= DROP TOPIC exists_opt topic_name */
  {  237,   -7 }, /* (227) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  237,   -2 }, /* (228) cmd ::= DESC full_table_name */
  {  237,   -2 }, /* (229) cmd ::= DESCRIBE full_table_name */
  {  237,   -3 }, /* (230) cmd ::= RESET QUERY CACHE */
  {  237,   -4 }, /* (231) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  297,    0 }, /* (232) analyze_opt ::= */
  {  297,   -1 }, /* (233) analyze_opt ::= ANALYZE */
  {  298,    0 }, /* (234) explain_options ::= */
  {  298,   -3 }, /* (235) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  298,   -3 }, /* (236) explain_options ::= explain_options RATIO NK_FLOAT */
  {  237,   -6 }, /* (237) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  237,  -10 }, /* (238) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  237,   -4 }, /* (239) cmd ::= DROP FUNCTION exists_opt function_name */
  {  299,    0 }, /* (240) agg_func_opt ::= */
  {  299,   -1 }, /* (241) agg_func_opt ::= AGGREGATE */
  {  300,    0 }, /* (242) bufsize_opt ::= */
  {  300,   -2 }, /* (243) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  237,   -8 }, /* (244) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  237,   -4 }, /* (245) cmd ::= DROP STREAM exists_opt stream_name */
  {  303,    0 }, /* (246) into_opt ::= */
  {  303,   -2 }, /* (247) into_opt ::= INTO full_table_name */
  {  302,    0 }, /* (248) stream_options ::= */
  {  302,   -3 }, /* (249) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  302,   -3 }, /* (250) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  302,   -3 }, /* (251) stream_options ::= stream_options WATERMARK duration_literal */
  {  237,   -3 }, /* (252) cmd ::= KILL CONNECTION NK_INTEGER */
  {  237,   -3 }, /* (253) cmd ::= KILL QUERY NK_INTEGER */
  {  237,   -3 }, /* (254) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  237,   -4 }, /* (255) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  237,   -4 }, /* (256) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  237,   -3 }, /* (257) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  304,   -2 }, /* (258) dnode_list ::= DNODE NK_INTEGER */
  {  304,   -3 }, /* (259) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  237,   -3 }, /* (260) cmd ::= SYNCDB db_name REPLICA */
  {  237,   -1 }, /* (261) cmd ::= query_expression */
  {  240,   -1 }, /* (262) literal ::= NK_INTEGER */
  {  240,   -1 }, /* (263) literal ::= NK_FLOAT */
  {  240,   -1 }, /* (264) literal ::= NK_STRING */
  {  240,   -1 }, /* (265) literal ::= NK_BOOL */
  {  240,   -2 }, /* (266) literal ::= TIMESTAMP NK_STRING */
  {  240,   -1 }, /* (267) literal ::= duration_literal */
  {  240,   -1 }, /* (268) literal ::= NULL */
  {  240,   -1 }, /* (269) literal ::= NK_QUESTION */
  {  290,   -1 }, /* (270) duration_literal ::= NK_VARIABLE */
  {  305,   -1 }, /* (271) signed ::= NK_INTEGER */
  {  305,   -2 }, /* (272) signed ::= NK_PLUS NK_INTEGER */
  {  305,   -2 }, /* (273) signed ::= NK_MINUS NK_INTEGER */
  {  305,   -1 }, /* (274) signed ::= NK_FLOAT */
  {  305,   -2 }, /* (275) signed ::= NK_PLUS NK_FLOAT */
  {  305,   -2 }, /* (276) signed ::= NK_MINUS NK_FLOAT */
  {  270,   -1 }, /* (277) signed_literal ::= signed */
  {  270,   -1 }, /* (278) signed_literal ::= NK_STRING */
  {  270,   -1 }, /* (279) signed_literal ::= NK_BOOL */
  {  270,   -2 }, /* (280) signed_literal ::= TIMESTAMP NK_STRING */
  {  270,   -1 }, /* (281) signed_literal ::= duration_literal */
  {  270,   -1 }, /* (282) signed_literal ::= NULL */
  {  270,   -1 }, /* (283) signed_literal ::= literal_func */
  {  273,   -1 }, /* (284) literal_list ::= signed_literal */
  {  273,   -3 }, /* (285) literal_list ::= literal_list NK_COMMA signed_literal */
  {  247,   -1 }, /* (286) db_name ::= NK_ID */
  {  276,   -1 }, /* (287) table_name ::= NK_ID */
  {  268,   -1 }, /* (288) column_name ::= NK_ID */
  {  286,   -1 }, /* (289) function_name ::= NK_ID */
  {  307,   -1 }, /* (290) table_alias ::= NK_ID */
  {  308,   -1 }, /* (291) column_alias ::= NK_ID */
  {  242,   -1 }, /* (292) user_name ::= NK_ID */
  {  287,   -1 }, /* (293) index_name ::= NK_ID */
  {  294,   -1 }, /* (294) topic_name ::= NK_ID */
  {  301,   -1 }, /* (295) stream_name ::= NK_ID */
  {  296,   -1 }, /* (296) cgroup_name ::= NK_ID */
  {  309,   -1 }, /* (297) expression ::= literal */
  {  309,   -1 }, /* (298) expression ::= pseudo_column */
  {  309,   -1 }, /* (299) expression ::= column_reference */
  {  309,   -1 }, /* (300) expression ::= function_expression */
  {  309,   -1 }, /* (301) expression ::= subquery */
  {  309,   -3 }, /* (302) expression ::= NK_LP expression NK_RP */
  {  309,   -2 }, /* (303) expression ::= NK_PLUS expression */
  {  309,   -2 }, /* (304) expression ::= NK_MINUS expression */
  {  309,   -3 }, /* (305) expression ::= expression NK_PLUS expression */
  {  309,   -3 }, /* (306) expression ::= expression NK_MINUS expression */
  {  309,   -3 }, /* (307) expression ::= expression NK_STAR expression */
  {  309,   -3 }, /* (308) expression ::= expression NK_SLASH expression */
  {  309,   -3 }, /* (309) expression ::= expression NK_REM expression */
  {  309,   -3 }, /* (310) expression ::= column_reference NK_ARROW NK_STRING */
  {  293,   -1 }, /* (311) expression_list ::= expression */
  {  293,   -3 }, /* (312) expression_list ::= expression_list NK_COMMA expression */
  {  311,   -1 }, /* (313) column_reference ::= column_name */
  {  311,   -3 }, /* (314) column_reference ::= table_name NK_DOT column_name */
  {  310,   -1 }, /* (315) pseudo_column ::= ROWTS */
  {  310,   -1 }, /* (316) pseudo_column ::= TBNAME */
  {  310,   -3 }, /* (317) pseudo_column ::= table_name NK_DOT TBNAME */
  {  310,   -1 }, /* (318) pseudo_column ::= QSTARTTS */
  {  310,   -1 }, /* (319) pseudo_column ::= QENDTS */
  {  310,   -1 }, /* (320) pseudo_column ::= WSTARTTS */
  {  310,   -1 }, /* (321) pseudo_column ::= WENDTS */
  {  310,   -1 }, /* (322) pseudo_column ::= WDURATION */
  {  312,   -4 }, /* (323) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  312,   -4 }, /* (324) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  312,   -6 }, /* (325) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  312,   -1 }, /* (326) function_expression ::= literal_func */
  {  306,   -3 }, /* (327) literal_func ::= noarg_func NK_LP NK_RP */
  {  306,   -1 }, /* (328) literal_func ::= NOW */
  {  316,   -1 }, /* (329) noarg_func ::= NOW */
  {  316,   -1 }, /* (330) noarg_func ::= TODAY */
  {  316,   -1 }, /* (331) noarg_func ::= TIMEZONE */
  {  314,   -1 }, /* (332) star_func ::= COUNT */
  {  314,   -1 }, /* (333) star_func ::= FIRST */
  {  314,   -1 }, /* (334) star_func ::= LAST */
  {  314,   -1 }, /* (335) star_func ::= LAST_ROW */
  {  315,   -1 }, /* (336) star_func_para_list ::= NK_STAR */
  {  315,   -1 }, /* (337) star_func_para_list ::= other_para_list */
  {  317,   -1 }, /* (338) other_para_list ::= star_func_para */
  {  317,   -3 }, /* (339) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  318,   -1 }, /* (340) star_func_para ::= expression */
  {  318,   -3 }, /* (341) star_func_para ::= table_name NK_DOT NK_STAR */
  {  319,   -3 }, /* (342) predicate ::= expression compare_op expression */
  {  319,   -5 }, /* (343) predicate ::= expression BETWEEN expression AND expression */
  {  319,   -6 }, /* (344) predicate ::= expression NOT BETWEEN expression AND expression */
  {  319,   -3 }, /* (345) predicate ::= expression IS NULL */
  {  319,   -4 }, /* (346) predicate ::= expression IS NOT NULL */
  {  319,   -3 }, /* (347) predicate ::= expression in_op in_predicate_value */
  {  320,   -1 }, /* (348) compare_op ::= NK_LT */
  {  320,   -1 }, /* (349) compare_op ::= NK_GT */
  {  320,   -1 }, /* (350) compare_op ::= NK_LE */
  {  320,   -1 }, /* (351) compare_op ::= NK_GE */
  {  320,   -1 }, /* (352) compare_op ::= NK_NE */
  {  320,   -1 }, /* (353) compare_op ::= NK_EQ */
  {  320,   -1 }, /* (354) compare_op ::= LIKE */
  {  320,   -2 }, /* (355) compare_op ::= NOT LIKE */
  {  320,   -1 }, /* (356) compare_op ::= MATCH */
  {  320,   -1 }, /* (357) compare_op ::= NMATCH */
  {  320,   -1 }, /* (358) compare_op ::= CONTAINS */
  {  321,   -1 }, /* (359) in_op ::= IN */
  {  321,   -2 }, /* (360) in_op ::= NOT IN */
  {  322,   -3 }, /* (361) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  323,   -1 }, /* (362) boolean_value_expression ::= boolean_primary */
  {  323,   -2 }, /* (363) boolean_value_expression ::= NOT boolean_primary */
  {  323,   -3 }, /* (364) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  323,   -3 }, /* (365) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  324,   -1 }, /* (366) boolean_primary ::= predicate */
  {  324,   -3 }, /* (367) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  325,   -1 }, /* (368) common_expression ::= expression */
  {  325,   -1 }, /* (369) common_expression ::= boolean_value_expression */
  {  326,   -2 }, /* (370) from_clause ::= FROM table_reference_list */
  {  327,   -1 }, /* (371) table_reference_list ::= table_reference */
  {  327,   -3 }, /* (372) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  328,   -1 }, /* (373) table_reference ::= table_primary */
  {  328,   -1 }, /* (374) table_reference ::= joined_table */
  {  329,   -2 }, /* (375) table_primary ::= table_name alias_opt */
  {  329,   -4 }, /* (376) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  329,   -2 }, /* (377) table_primary ::= subquery alias_opt */
  {  329,   -1 }, /* (378) table_primary ::= parenthesized_joined_table */
  {  331,    0 }, /* (379) alias_opt ::= */
  {  331,   -1 }, /* (380) alias_opt ::= table_alias */
  {  331,   -2 }, /* (381) alias_opt ::= AS table_alias */
  {  332,   -3 }, /* (382) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  332,   -3 }, /* (383) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  330,   -6 }, /* (384) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  333,    0 }, /* (385) join_type ::= */
  {  333,   -1 }, /* (386) join_type ::= INNER */
  {  335,   -9 }, /* (387) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  336,    0 }, /* (388) set_quantifier_opt ::= */
  {  336,   -1 }, /* (389) set_quantifier_opt ::= DISTINCT */
  {  336,   -1 }, /* (390) set_quantifier_opt ::= ALL */
  {  337,   -1 }, /* (391) select_list ::= NK_STAR */
  {  337,   -1 }, /* (392) select_list ::= select_sublist */
  {  343,   -1 }, /* (393) select_sublist ::= select_item */
  {  343,   -3 }, /* (394) select_sublist ::= select_sublist NK_COMMA select_item */
  {  344,   -1 }, /* (395) select_item ::= common_expression */
  {  344,   -2 }, /* (396) select_item ::= common_expression column_alias */
  {  344,   -3 }, /* (397) select_item ::= common_expression AS column_alias */
  {  344,   -3 }, /* (398) select_item ::= table_name NK_DOT NK_STAR */
  {  338,    0 }, /* (399) where_clause_opt ::= */
  {  338,   -2 }, /* (400) where_clause_opt ::= WHERE search_condition */
  {  339,    0 }, /* (401) partition_by_clause_opt ::= */
  {  339,   -3 }, /* (402) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  340,    0 }, /* (403) twindow_clause_opt ::= */
  {  340,   -6 }, /* (404) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  340,   -4 }, /* (405) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  340,   -6 }, /* (406) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  340,   -8 }, /* (407) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  291,    0 }, /* (408) sliding_opt ::= */
  {  291,   -4 }, /* (409) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  345,    0 }, /* (410) fill_opt ::= */
  {  345,   -4 }, /* (411) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  345,   -6 }, /* (412) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  346,   -1 }, /* (413) fill_mode ::= NONE */
  {  346,   -1 }, /* (414) fill_mode ::= PREV */
  {  346,   -1 }, /* (415) fill_mode ::= NULL */
  {  346,   -1 }, /* (416) fill_mode ::= LINEAR */
  {  346,   -1 }, /* (417) fill_mode ::= NEXT */
  {  341,    0 }, /* (418) group_by_clause_opt ::= */
  {  341,   -3 }, /* (419) group_by_clause_opt ::= GROUP BY group_by_list */
  {  347,   -1 }, /* (420) group_by_list ::= expression */
  {  347,   -3 }, /* (421) group_by_list ::= group_by_list NK_COMMA expression */
  {  342,    0 }, /* (422) having_clause_opt ::= */
  {  342,   -2 }, /* (423) having_clause_opt ::= HAVING search_condition */
  {  295,   -4 }, /* (424) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  348,   -1 }, /* (425) query_expression_body ::= query_primary */
  {  348,   -4 }, /* (426) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  348,   -3 }, /* (427) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  352,   -1 }, /* (428) query_primary ::= query_specification */
  {  352,   -6 }, /* (429) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  349,    0 }, /* (430) order_by_clause_opt ::= */
  {  349,   -3 }, /* (431) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  350,    0 }, /* (432) slimit_clause_opt ::= */
  {  350,   -2 }, /* (433) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  350,   -4 }, /* (434) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  350,   -4 }, /* (435) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  351,    0 }, /* (436) limit_clause_opt ::= */
  {  351,   -2 }, /* (437) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  351,   -4 }, /* (438) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  351,   -4 }, /* (439) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  313,   -3 }, /* (440) subquery ::= NK_LP query_expression NK_RP */
  {  334,   -1 }, /* (441) search_condition ::= common_expression */
  {  353,   -1 }, /* (442) sort_specification_list ::= sort_specification */
  {  353,   -3 }, /* (443) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  354,   -3 }, /* (444) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  355,    0 }, /* (445) ordering_specification_opt ::= */
  {  355,   -1 }, /* (446) ordering_specification_opt ::= ASC */
  {  355,   -1 }, /* (447) ordering_specification_opt ::= DESC */
  {  356,    0 }, /* (448) null_ordering_opt ::= */
  {  356,   -2 }, /* (449) null_ordering_opt ::= NULLS FIRST */
  {  356,   -2 }, /* (450) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,238,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,239,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,238,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,240,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,241,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,239,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,241,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy123, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy123, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy123 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy123 = yymsp[0].minor.yy123; }
  yymsp[0].minor.yy123 = yylhsminor.yy123;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy123 = yymsp[-2].minor.yy123 | yymsp[0].minor.yy123; }
  yymsp[-2].minor.yy123 = yylhsminor.yy123;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy123 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy123 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy113 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy113 = yylhsminor.yy113;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy113 = yymsp[-2].minor.yy113; }
  yymsp[-2].minor.yy113 = yylhsminor.yy113;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy113, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 286: /* db_name ::= NK_ID */ yytestcase(yyruleno==286);
      case 287: /* table_name ::= NK_ID */ yytestcase(yyruleno==287);
      case 288: /* column_name ::= NK_ID */ yytestcase(yyruleno==288);
      case 289: /* function_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* table_alias ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* column_alias ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* user_name ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* index_name ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* topic_name ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* stream_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 329: /* noarg_func ::= NOW */ yytestcase(yyruleno==329);
      case 330: /* noarg_func ::= TODAY */ yytestcase(yyruleno==330);
      case 331: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==331);
      case 332: /* star_func ::= COUNT */ yytestcase(yyruleno==332);
      case 333: /* star_func ::= FIRST */ yytestcase(yyruleno==333);
      case 334: /* star_func ::= LAST */ yytestcase(yyruleno==334);
      case 335: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==335);
{ yylhsminor.yy113 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy113 = yylhsminor.yy113;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy131, &yymsp[-1].minor.yy113, yymsp[0].minor.yy686); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy131, &yymsp[0].minor.yy113); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy686); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy131 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 232: /* analyze_opt ::= */ yytestcase(yyruleno==232);
      case 240: /* agg_func_opt ::= */ yytestcase(yyruleno==240);
      case 388: /* set_quantifier_opt ::= */ yytestcase(yyruleno==388);
{ yymsp[1].minor.yy131 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy131 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy686 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_KEEP, yymsp[0].minor.yy670); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_RETENTIONS, yymsp[0].minor.yy670); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy686 = setDatabaseOption(pCxt, yymsp[-2].minor.yy686, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy686 = createAlterDatabaseOptions(pCxt); yylhsminor.yy686 = setAlterDatabaseOption(pCxt, yylhsminor.yy686, &yymsp[0].minor.yy53); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy686 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy686, &yymsp[0].minor.yy53); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy53.type = DB_OPTION_KEEP; yymsp[-1].minor.yy53.pList = yymsp[0].minor.yy670; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_PAGES; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_STRICT; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_WAL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy670 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy670 = yylhsminor.yy670;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 259: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==259);
{ yylhsminor.yy670 = addNodeToList(pCxt, yymsp[-2].minor.yy670, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy670 = yylhsminor.yy670;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy670 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy670 = yylhsminor.yy670;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy670 = addNodeToList(pCxt, yymsp[-2].minor.yy670, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy670 = yylhsminor.yy670;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 173: /* col_name_list ::= col_name */ yytestcase(yyruleno==173);
      case 211: /* func_name_list ::= func_name */ yytestcase(yyruleno==211);
      case 220: /* func_list ::= func */ yytestcase(yyruleno==220);
      case 284: /* literal_list ::= signed_literal */ yytestcase(yyruleno==284);
      case 338: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==338);
      case 393: /* select_sublist ::= select_item */ yytestcase(yyruleno==393);
      case 442: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==442);
{ yylhsminor.yy670 = createNodeList(pCxt, yymsp[0].minor.yy686); }
  yymsp[0].minor.yy670 = yylhsminor.yy670;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 174: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==221);
      case 285: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==285);
      case 339: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==339);
      case 394: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==394);
      case 443: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==443);
{ yylhsminor.yy670 = addNodeToList(pCxt, yymsp[-2].minor.yy670, yymsp[0].minor.yy686); }
  yymsp[-2].minor.yy670 = yylhsminor.yy670;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy686 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy131, yymsp[-5].minor.yy686, yymsp[-3].minor.yy670, yymsp[-1].minor.yy670, yymsp[0].minor.yy686); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy670); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy670); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy131, yymsp[0].minor.yy686); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 261: /* cmd ::= query_expression */ yytestcase(yyruleno==261);
{ pCxt->pRootNode = yymsp[0].minor.yy686; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy686 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy686, yymsp[0].minor.yy686); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy686 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy686, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy113, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy686 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy686, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy686 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy686, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy113, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy686 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy686, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy686 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy686, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy113, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy686 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy686, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy686 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy686, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy113, yymsp[0].minor.yy490); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy686 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy686, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy686 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy686, &yymsp[-2].minor.yy113, yymsp[0].minor.yy686); }
  yymsp[-5].minor.yy686 = yylhsminor.yy686;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy670 = addNodeToList(pCxt, yymsp[-1].minor.yy670, yymsp[0].minor.yy686); }
  yymsp[-1].minor.yy670 = yylhsminor.yy670;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy686 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy131, yymsp[-8].minor.yy686, yymsp[-6].minor.yy686, yymsp[-5].minor.yy670, yymsp[-2].minor.yy670, yymsp[0].minor.yy686); }
  yymsp[-9].minor.yy686 = yylhsminor.yy686;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy686 = createDropTableClause(pCxt, yymsp[-1].minor.yy131, yymsp[0].minor.yy686); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 401: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==401);
      case 418: /* group_by_clause_opt ::= */ yytestcase(yyruleno==418);
      case 430: /* order_by_clause_opt ::= */ yytestcase(yyruleno==430);
{ yymsp[1].minor.yy670 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy670 = yymsp[-1].minor.yy670; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy686 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy113, NULL); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy686 = createRealTableNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113, NULL); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy686 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy490, NULL); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy686 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy113, yymsp[-2].minor.yy490, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy490 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy490 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy490 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy490 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 337: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==337);
      case 392: /* select_list ::= select_sublist */ yytestcase(yyruleno==392);
{ yylhsminor.yy670 = yymsp[0].minor.yy670; }
  yymsp[0].minor.yy670 = yylhsminor.yy670;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy670 = yymsp[-1].minor.yy670; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy686 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy686 = setTableOption(pCxt, yymsp[-2].minor.yy686, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 165: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy686 = setTableOption(pCxt, yymsp[-2].minor.yy686, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 166: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy686 = setTableOption(pCxt, yymsp[-4].minor.yy686, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy670); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 167: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy686 = setTableOption(pCxt, yymsp[-2].minor.yy686, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 168: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy686 = setTableOption(pCxt, yymsp[-4].minor.yy686, TABLE_OPTION_SMA, yymsp[-1].minor.yy670); }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 169: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy686 = createAlterTableOptions(pCxt); yylhsminor.yy686 = setTableOption(pCxt, yylhsminor.yy686, yymsp[0].minor.yy53.type, &yymsp[0].minor.yy53.val); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 170: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy686 = setTableOption(pCxt, yymsp[-1].minor.yy686, yymsp[0].minor.yy53.type, &yymsp[0].minor.yy53.val); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 171: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy53.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 172: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy53.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 175: /* col_name ::= column_name */
{ yylhsminor.yy686 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 176: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy686, yymsp[0].minor.yy686); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy686, yymsp[0].minor.yy686); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy686, NULL); }
        break;
      case 182: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy686, yymsp[0].minor.yy686); }
        break;
      case 187: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 189: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW LICENCE */
      case 192: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==192);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 194: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy686); }
        break;
      case 195: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy686); }
        break;
      case 196: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 204: /* db_name_cond_opt ::= */
      case 209: /* from_db_opt ::= */ yytestcase(yyruleno==209);
{ yymsp[1].minor.yy686 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 205: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy113); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 206: /* like_pattern_opt ::= */
      case 217: /* index_options ::= */ yytestcase(yyruleno==217);
      case 246: /* into_opt ::= */ yytestcase(yyruleno==246);
      case 399: /* where_clause_opt ::= */ yytestcase(yyruleno==399);
      case 403: /* twindow_clause_opt ::= */ yytestcase(yyruleno==403);
      case 408: /* sliding_opt ::= */ yytestcase(yyruleno==408);
      case 410: /* fill_opt ::= */ yytestcase(yyruleno==410);
      case 422: /* having_clause_opt ::= */ yytestcase(yyruleno==422);
      case 432: /* slimit_clause_opt ::= */ yytestcase(yyruleno==432);
      case 436: /* limit_clause_opt ::= */ yytestcase(yyruleno==436);
{ yymsp[1].minor.yy686 = NULL; }
        break;
      case 207: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 208: /* table_name_cond ::= table_name */
{ yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 210: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy113); }
        break;
      case 213: /* func_name ::= function_name */
{ yylhsminor.yy686 = createFunctionNode(pCxt, &yymsp[0].minor.yy113, NULL); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 214: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy131, &yymsp[-3].minor.yy113, &yymsp[-1].minor.yy113, NULL, yymsp[0].minor.yy686); }
        break;
      case 215: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy131, &yymsp[-5].minor.yy113, &yymsp[-3].minor.yy113, yymsp[-1].minor.yy670, NULL); }
        break;
      case 216: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy131, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
        break;
      case 218: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy686 = createIndexOption(pCxt, yymsp[-6].minor.yy670, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), NULL, yymsp[0].minor.yy686); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy686 = createIndexOption(pCxt, yymsp[-8].minor.yy670, releaseRawExprNode(pCxt, yymsp[-4].minor.yy686), releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), yymsp[0].minor.yy686); }
        break;
      case 222: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy686 = createFunctionNode(pCxt, &yymsp[-3].minor.yy113, yymsp[-1].minor.yy670); }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 223: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy131, &yymsp[-2].minor.yy113, yymsp[0].minor.yy686, NULL, NULL); }
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy131, &yymsp[-3].minor.yy113, NULL, &yymsp[0].minor.yy113, NULL); }
        break;
      case 225: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy131, &yymsp[-3].minor.yy113, NULL, NULL, yymsp[0].minor.yy686); }
        break;
      case 226: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy131, &yymsp[0].minor.yy113); }
        break;
      case 227: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy131, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
        break;
      case 228: /* cmd ::= DESC full_table_name */
      case 229: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy686); }
        break;
      case 230: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 231: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy131, yymsp[-1].minor.yy686, yymsp[0].minor.yy686); }
        break;
      case 233: /* analyze_opt ::= ANALYZE */
      case 241: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==241);
      case 389: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==389);
{ yymsp[0].minor.yy131 = true; }
        break;
      case 234: /* explain_options ::= */
{ yymsp[1].minor.yy686 = createDefaultExplainOptions(pCxt); }
        break;
      case 235: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy686 = setExplainVerbose(pCxt, yymsp[-2].minor.yy686, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 236: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy686 = setExplainRatio(pCxt, yymsp[-2].minor.yy686, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 237: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy670); }
        break;
      case 238: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy131, yymsp[-8].minor.yy131, &yymsp[-5].minor.yy113, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy490, yymsp[0].minor.yy550); }
        break;
      case 239: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy131, &yymsp[0].minor.yy113); }
        break;
      case 242: /* bufsize_opt ::= */
{ yymsp[1].minor.yy550 = 0; }
        break;
      case 243: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy550 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 244: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy131, &yymsp[-4].minor.yy113, yymsp[-2].minor.yy686, yymsp[-3].minor.yy686, yymsp[0].minor.yy686); }
        break;
      case 245: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy131, &yymsp[0].minor.yy113); }
        break;
      case 247: /* into_opt ::= INTO full_table_name */
      case 370: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==370);
      case 400: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==400);
      case 423: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==423);
{ yymsp[-1].minor.yy686 = yymsp[0].minor.yy686; }
        break;
      case 248: /* stream_options ::= */
{ yymsp[1].minor.yy686 = createStreamOptions(pCxt); }
        break;
      case 249: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy686)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy686 = yymsp[-2].minor.yy686; }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 250: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy686)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy686 = yymsp[-2].minor.yy686; }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 251: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy686)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy686); yylhsminor.yy686 = yymsp[-2].minor.yy686; }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 252: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 253: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 254: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 255: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 256: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy670); }
        break;
      case 257: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 258: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy670 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 260: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy113); }
        break;
      case 262: /* literal ::= NK_INTEGER */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 263: /* literal ::= NK_FLOAT */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 264: /* literal ::= NK_STRING */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 265: /* literal ::= NK_BOOL */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 266: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 267: /* literal ::= duration_literal */
      case 277: /* signed_literal ::= signed */ yytestcase(yyruleno==277);
      case 297: /* expression ::= literal */ yytestcase(yyruleno==297);
      case 298: /* expression ::= pseudo_column */ yytestcase(yyruleno==298);
      case 299: /* expression ::= column_reference */ yytestcase(yyruleno==299);
      case 300: /* expression ::= function_expression */ yytestcase(yyruleno==300);
      case 301: /* expression ::= subquery */ yytestcase(yyruleno==301);
      case 326: /* function_expression ::= literal_func */ yytestcase(yyruleno==326);
      case 362: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==362);
      case 366: /* boolean_primary ::= predicate */ yytestcase(yyruleno==366);
      case 368: /* common_expression ::= expression */ yytestcase(yyruleno==368);
      case 369: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==369);
      case 371: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==371);
      case 373: /* table_reference ::= table_primary */ yytestcase(yyruleno==373);
      case 374: /* table_reference ::= joined_table */ yytestcase(yyruleno==374);
      case 378: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==378);
      case 425: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==425);
      case 428: /* query_primary ::= query_specification */ yytestcase(yyruleno==428);
{ yylhsminor.yy686 = yymsp[0].minor.yy686; }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 268: /* literal ::= NULL */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 269: /* literal ::= NK_QUESTION */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 270: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 271: /* signed ::= NK_INTEGER */
{ yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 272: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 273: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 274: /* signed ::= NK_FLOAT */
{ yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 275: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 276: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 278: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 279: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 280: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 281: /* signed_literal ::= duration_literal */
      case 283: /* signed_literal ::= literal_func */ yytestcase(yyruleno==283);
      case 340: /* star_func_para ::= expression */ yytestcase(yyruleno==340);
      case 395: /* select_item ::= common_expression */ yytestcase(yyruleno==395);
      case 441: /* search_condition ::= common_expression */ yytestcase(yyruleno==441);
{ yylhsminor.yy686 = releaseRawExprNode(pCxt, yymsp[0].minor.yy686); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 282: /* signed_literal ::= NULL */
{ yylhsminor.yy686 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 302: /* expression ::= NK_LP expression NK_RP */
      case 367: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==367);
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy686)); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 303: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy686));
                                                                                  }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 304: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy686), NULL));
                                                                                  }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 305: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686))); 
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 306: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686))); 
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 307: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686))); 
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 308: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686))); 
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 309: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686))); 
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 310: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 311: /* expression_list ::= expression */
{ yylhsminor.yy670 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy686)); }
  yymsp[0].minor.yy670 = yylhsminor.yy670;
        break;
      case 312: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy670 = addNodeToList(pCxt, yymsp[-2].minor.yy670, releaseRawExprNode(pCxt, yymsp[0].minor.yy686)); }
  yymsp[-2].minor.yy670 = yylhsminor.yy670;
        break;
      case 313: /* column_reference ::= column_name */
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy113, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy113)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 314: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113, createColumnNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113)); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 315: /* pseudo_column ::= ROWTS */
      case 316: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==316);
      case 318: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==318);
      case 319: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==319);
      case 320: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==320);
      case 321: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==321);
      case 322: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==322);
      case 328: /* literal_func ::= NOW */ yytestcase(yyruleno==328);
{ yylhsminor.yy686 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy686 = yylhsminor.yy686;
        break;
      case 317: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy113)))); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 323: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 324: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==324);
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy113, yymsp[-1].minor.yy670)); }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 325: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy686), yymsp[-1].minor.yy490)); }
  yymsp[-5].minor.yy686 = yylhsminor.yy686;
        break;
      case 327: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy113, NULL)); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 336: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy670 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy670 = yylhsminor.yy670;
        break;
      case 341: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 398: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==398);
{ yylhsminor.yy686 = createColumnNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 342: /* predicate ::= expression compare_op expression */
      case 347: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==347);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy632, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686)));
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 343: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy686), releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686)));
                                                                                  }
  yymsp[-4].minor.yy686 = yylhsminor.yy686;
        break;
      case 344: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy686), releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686)));
                                                                                  }
  yymsp[-5].minor.yy686 = yylhsminor.yy686;
        break;
      case 345: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), NULL));
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 346: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy686), NULL));
                                                                                  }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 348: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy632 = OP_TYPE_LOWER_THAN; }
        break;
      case 349: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy632 = OP_TYPE_GREATER_THAN; }
        break;
      case 350: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy632 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 351: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy632 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 352: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy632 = OP_TYPE_NOT_EQUAL; }
        break;
      case 353: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy632 = OP_TYPE_EQUAL; }
        break;
      case 354: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy632 = OP_TYPE_LIKE; }
        break;
      case 355: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy632 = OP_TYPE_NOT_LIKE; }
        break;
      case 356: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy632 = OP_TYPE_MATCH; }
        break;
      case 357: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy632 = OP_TYPE_NMATCH; }
        break;
      case 358: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy632 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 359: /* in_op ::= IN */
{ yymsp[0].minor.yy632 = OP_TYPE_IN; }
        break;
      case 360: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy632 = OP_TYPE_NOT_IN; }
        break;
      case 361: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy670)); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 363: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy686), NULL));
                                                                                  }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 364: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686)));
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 365: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy686);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy686);
                                                                                    yylhsminor.yy686 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), releaseRawExprNode(pCxt, yymsp[0].minor.yy686)));
                                                                                  }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 372: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy686 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy686, yymsp[0].minor.yy686, NULL); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 375: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy686 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 376: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy686 = createRealTableNode(pCxt, &yymsp[-3].minor.yy113, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 377: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy686 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy686), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 379: /* alias_opt ::= */
{ yymsp[1].minor.yy113 = nil_token;  }
        break;
      case 380: /* alias_opt ::= table_alias */
{ yylhsminor.yy113 = yymsp[0].minor.yy113; }
  yymsp[0].minor.yy113 = yylhsminor.yy113;
        break;
      case 381: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy113 = yymsp[0].minor.yy113; }
        break;
      case 382: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 383: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==383);
{ yymsp[-2].minor.yy686 = yymsp[-1].minor.yy686; }
        break;
      case 384: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy686 = createJoinTableNode(pCxt, yymsp[-4].minor.yy120, yymsp[-5].minor.yy686, yymsp[-2].minor.yy686, yymsp[0].minor.yy686); }
  yymsp[-5].minor.yy686 = yylhsminor.yy686;
        break;
      case 385: /* join_type ::= */
{ yymsp[1].minor.yy120 = JOIN_TYPE_INNER; }
        break;
      case 386: /* join_type ::= INNER */
{ yymsp[0].minor.yy120 = JOIN_TYPE_INNER; }
        break;
      case 387: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy686 = createSelectStmt(pCxt, yymsp[-7].minor.yy131, yymsp[-6].minor.yy670, yymsp[-5].minor.yy686);
                                                                                    yymsp[-8].minor.yy686 = addWhereClause(pCxt, yymsp[-8].minor.yy686, yymsp[-4].minor.yy686);
                                                                                    yymsp[-8].minor.yy686 = addPartitionByClause(pCxt, yymsp[-8].minor.yy686, yymsp[-3].minor.yy670);
                                                                                    yymsp[-8].minor.yy686 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy686, yymsp[-2].minor.yy686);
                                                                                    yymsp[-8].minor.yy686 = addGroupByClause(pCxt, yymsp[-8].minor.yy686, yymsp[-1].minor.yy670);
                                                                                    yymsp[-8].minor.yy686 = addHavingClause(pCxt, yymsp[-8].minor.yy686, yymsp[0].minor.yy686);
                                                                                  }
        break;
      case 390: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy131 = false; }
        break;
      case 391: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy670 = NULL; }
        break;
      case 396: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy686 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy686), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy686 = yylhsminor.yy686;
        break;
      case 397: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy686 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), &yymsp[0].minor.yy113); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 402: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 419: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==419);
      case 431: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==431);
{ yymsp[-2].minor.yy670 = yymsp[0].minor.yy670; }
        break;
      case 404: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy686 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy686), releaseRawExprNode(pCxt, yymsp[-1].minor.yy686)); }
        break;
      case 405: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy686 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy686)); }
        break;
      case 406: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy686 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy686), NULL, yymsp[-1].minor.yy686, yymsp[0].minor.yy686); }
        break;
      case 407: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy686 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy686), releaseRawExprNode(pCxt, yymsp[-3].minor.yy686), yymsp[-1].minor.yy686, yymsp[0].minor.yy686); }
        break;
      case 409: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy686 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy686); }
        break;
      case 411: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy686 = createFillNode(pCxt, yymsp[-1].minor.yy522, NULL); }
        break;
      case 412: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy686 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy670)); }
        break;
      case 413: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy522 = FILL_MODE_NONE; }
        break;
      case 414: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy522 = FILL_MODE_PREV; }
        break;
      case 415: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy522 = FILL_MODE_NULL; }
        break;
      case 416: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy522 = FILL_MODE_LINEAR; }
        break;
      case 417: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy522 = FILL_MODE_NEXT; }
        break;
      case 420: /* group_by_list ::= expression */
{ yylhsminor.yy670 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy686))); }
  yymsp[0].minor.yy670 = yylhsminor.yy670;
        break;
      case 421: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy670 = addNodeToList(pCxt, yymsp[-2].minor.yy670, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy686))); }
  yymsp[-2].minor.yy670 = yylhsminor.yy670;
        break;
      case 424: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy686 = addOrderByClause(pCxt, yymsp[-3].minor.yy686, yymsp[-2].minor.yy670);
                                                                                    yylhsminor.yy686 = addSlimitClause(pCxt, yylhsminor.yy686, yymsp[-1].minor.yy686);
                                                                                    yylhsminor.yy686 = addLimitClause(pCxt, yylhsminor.yy686, yymsp[0].minor.yy686);
                                                                                  }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 426: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy686 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy686, yymsp[0].minor.yy686); }
  yymsp[-3].minor.yy686 = yylhsminor.yy686;
        break;
      case 427: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy686 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy686, yymsp[0].minor.yy686); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 429: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy686 = yymsp[-4].minor.yy686; }
  yy_destructor(yypParser,349,&yymsp[-3].minor);
  yy_destructor(yypParser,350,&yymsp[-2].minor);
  yy_destructor(yypParser,351,&yymsp[-1].minor);
        break;
      case 433: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 437: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==437);
{ yymsp[-1].minor.yy686 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 434: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 438: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==438);
{ yymsp[-3].minor.yy686 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 435: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 439: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==439);
{ yymsp[-3].minor.yy686 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 440: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy686 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy686); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 444: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy686 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy686), yymsp[-1].minor.yy428, yymsp[0].minor.yy109); }
  yymsp[-2].minor.yy686 = yylhsminor.yy686;
        break;
      case 445: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy428 = ORDER_ASC; }
        break;
      case 446: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy428 = ORDER_ASC; }
        break;
      case 447: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy428 = ORDER_DESC; }
        break;
      case 448: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy109 = NULL_ORDER_DEFAULT; }
        break;
      case 449: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_FIRST; }
        break;
      case 450: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy109 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
