/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 449
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  bool yy39;
  SToken yy181;
  EJoinType yy202;
  int32_t yy276;
  SNodeList* yy282;
  int8_t yy293;
  ENullOrder yy305;
  SDataType yy380;
  EFillMode yy381;
  SAlterOption yy645;
  EOperatorType yy682;
  SNode* yy778;
  int64_t yy831;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             698
#define YYNRULE              525
#define YYNTOKEN             317
#define YY_MAX_SHIFT         697
#define YY_MIN_SHIFTREDUCE   1031
#define YY_MAX_SHIFTREDUCE   1555
#define YY_ERROR_ACTION      1556
#define YY_ACCEPT_ACTION     1557
#define YY_NO_ACTION         1558
#define YY_MIN_REDUCE        1559
#define YY_MAX_REDUCE        2083
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2819)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1885,   34,  268, 1885,  157, 1064, 1571, 1899,   62,  536,
 /*    10 */  1701, 1881,   44,   42, 1881,  448,  336,  449, 1594, 1811,
 /*    20 */   351, 1881, 1336,   43,   41,   40,   39,   38,  590,  156,
 /*    30 */   167, 1557, 1361, 1416, 1663, 1334, 1917, 1877, 1883,  339,
 /*    40 */  1877, 1883,  345, 1749,  591, 1068, 1069, 1877, 1883, 1867,
 /*    50 */   597,  603,   30,  597,  447, 1582, 1411,  451,   37,   36,
 /*    60 */   597,   17,   43,   41,   40,   39,   38, 1899, 1342,   44,
 /*    70 */    42, 1486, 1897, 1581,  507,  590, 1933,  351,  575, 1336,
 /*    80 */    97, 1898, 1900,  607, 1902, 1903,  602,   77,  597,  517,
 /*    90 */  1416,  366, 1334,  168,    1, 1986, 1917, 1867,   58,  344,
 /*   100 */  1982,  125,   46,  219,  604,  587,   58, 2054,  532, 1867,
 /*   110 */  1705,  603,  173, 1411,  536, 1867,  694,  510,   17, 1580,
 /*   120 */  2012,  504,  574,  171, 1812, 1342,  218, 2055,  576, 1362,
 /*   130 */  1418, 1419,  605, 2059,  132,  587, 1933, 2054,  396, 1579,
 /*   140 */    98,  350, 1900,  607, 1902, 1903,  602,  456,  597,  449,
 /*   150 */  1594,    1, 2060,  171, 1081, 1986, 1080, 2055,  576,  315,
 /*   160 */  1982, 1867, 2054,   64,  132,    7,   63,   58, 1490,  484,
 /*   170 */  2054,  130,  337,  694, 1361, 1337,  311, 1335, 2058,  220,
 /*   180 */   154, 1867, 2055, 2057, 1082,  574,  171, 1418, 1419, 1712,
 /*   190 */  2055,  576,  589,  169, 1994, 1995, 1362, 1999,  465, 1340,
 /*   200 */  1341,  121, 1391, 1392, 1394, 1395, 1396, 1397, 1398, 1399,
 /*   210 */  1400, 1401,  599,  595, 1409, 1410, 1412, 1413, 1414, 1415,
 /*   220 */  1417, 1420,    3,  265, 1994,  586, 1687,  585, 1756, 1757,
 /*   230 */  2054, 1426, 1337,  385, 1335,   79,  313, 1361,  390,  539,
 /*   240 */   174, 1512,  498,  497,  174,  574,  171,  389,  174,  388,
 /*   250 */  2055,  576,  174,  387,  383,  532, 1340, 1341,   58, 1391,
 /*   260 */  1392, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401,  599,
 /*   270 */   595, 1409, 1410, 1412, 1413, 1414, 1415, 1417, 1420,    3,
 /*   280 */    44,   42,  697,  182, 2054,  234,  235, 1361,  351,   77,
 /*   290 */  1336,  562, 1510, 1511, 1513, 1514,  275,  549, 1899, 2060,
 /*   300 */   171, 1416,  549, 1334, 2055,  576, 1230, 1231, 2059,   52,
 /*   310 */   165, 1886, 1706,  174,  120,  687,  683,  679,  675,  273,
 /*   320 */    74,  486, 1881,   73, 1411,  221, 1710, 1917, 1740,   17,
 /*   330 */   356, 1710,  638, 1755, 1757,  604, 1342,   44,   42, 1081,
 /*   340 */  1867, 1080,  603,  313,  590,  351,  539, 1336, 1877, 1883,
 /*   350 */   565,  145,  144,  635,  634,  633,   95, 1393, 1416,  241,
 /*   360 */  1334,  597,    1,  605,  453, 1479,  549, 1933,  638, 1082,
 /*   370 */  1359,  295,  350, 1900,  607, 1902, 1903,  602,  120,  597,
 /*   380 */    47, 1411, 1560,  397,  694,  491,   17,  145,  144,  635,
 /*   390 */   634,  633,  546, 1342,  455, 1710,  398,  451, 1418, 1419,
 /*   400 */  1545, 2054, 1336,  110,  174,  433,  109,  108,  107,  106,
 /*   410 */   105,  104,  103,  102,  101, 1334,  574,  171,   46,    1,
 /*   420 */  1393, 2055,  576,  110,  230,  549,  109,  108,  107,  106,
 /*   430 */   105,  104,  103,  102,  101,  571,  566,  176,  502,  501,
 /*   440 */   500,  694, 1308, 1337,  223, 1335,  126,  496, 1342, 1578,
 /*   450 */   154,  495,  494, 1762, 1710, 1418, 1419,  493,  499, 1713,
 /*   460 */   338,  186,  185,  492, 1148, 1068, 1069, 1340, 1341, 1760,
 /*   470 */  1391, 1392, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401,
 /*   480 */   599,  595, 1409, 1410, 1412, 1413, 1414, 1415, 1417, 1420,
 /*   490 */     3, 1867,   11,   40,   39,   38,  694, 1150, 2006, 1479,
 /*   500 */  1337, 1624, 1335,  233,  570, 1447, 1188,  629,  628,  627,
 /*   510 */  1192,  626, 1194, 1195,  625, 1197,  622,  640, 1203,  619,
 /*   520 */  1205, 1206,  616,  613, 1340, 1341,  174, 1391, 1392, 1394,
 /*   530 */  1395, 1396, 1397, 1398, 1399, 1400, 1401,  599,  595, 1409,
 /*   540 */  1410, 1412, 1413, 1414, 1415, 1417, 1420,    3,   44,   42,
 /*   550 */  1804,  354, 1917, 2059, 2001, 1337,  351, 1335, 1336,  154,
 /*   560 */   569,  179, 1314, 1315,  502,  501,  500,  632, 1712, 1416,
 /*   570 */  1363, 1334,  126,  496,  549,   31,  228,  495,  494, 1340,
 /*   580 */  1341, 1899, 1998,  493,  499, 1452,  394, 1688, 1814,  492,
 /*   590 */    37,   36, 1411, 1360,   43,   41,   40,   39,   38,  568,
 /*   600 */  1899, 1762, 1342, 1710, 1342,   44,   42, 1421,  355,  549,
 /*   610 */  1917,   48,    4,  351,   58, 1336,   81, 1760,  604,  549,
 /*   620 */    11,  395,    9, 1867,  357,  603, 1416, 1762, 1334, 1917,
 /*   630 */     8,  405,  154,  128,  320, 2059, 1957,  604, 1710,  549,
 /*   640 */  1577, 1712, 1867, 1760,  603, 1545, 1897,  465, 1710, 1411,
 /*   650 */  1933,  419,  694,  535,  158, 1898, 1900,  607, 1902, 1903,
 /*   660 */   602, 1342,  597, 1483, 2054, 1897, 1418, 1419, 1710, 1933,
 /*   670 */   532,  549,  575,   97, 1898, 1900,  607, 1902, 1903,  602,
 /*   680 */  2058,  597, 1867,  420, 2055, 2056, 2074,    8, 1986,  551,
 /*   690 */   516, 1958,  344, 1982, 1762,  554, 2023,  665,  663, 2054,
 /*   700 */  1710, 2054, 2020,  514, 1686,  512,  553,   11, 1958,  694,
 /*   710 */  1761, 1337,  267, 1335, 2060,  171,  574,  171, 1361, 2055,
 /*   720 */   576, 2055,  576, 1418, 1419,   37,   36,   13,   12,   43,
 /*   730 */    41,   40,   39,   38, 1854, 1340, 1341, 1364, 1391, 1392,
 /*   740 */  1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401,  599,  595,
 /*   750 */  1409, 1410, 1412, 1413, 1414, 1415, 1417, 1420,    3, 1559,
 /*   760 */   174,  652, 1363, 1804,  640, 1810, 1804,  308, 1337,  653,
 /*   770 */  1335, 1680,   87,  327,  180, 1699,  174,  184, 1576,  527,
 /*   780 */  1809,  373,  308,  119,  118,  117,  116,  115,  114,  113,
 /*   790 */   112,  111, 1340, 1341, 1703, 1391, 1392, 1394, 1395, 1396,
 /*   800 */  1397, 1398, 1399, 1400, 1401,  599,  595, 1409, 1410, 1412,
 /*   810 */  1413, 1414, 1415, 1417, 1420,    3,   44,   42, 1791,  549,
 /*   820 */  1867, 1459,  636,  364,  351, 1753, 1336, 2001, 2001,  637,
 /*   830 */   579,  463, 1753,  328, 1575,  326,  325, 1416,  488, 1334,
 /*   840 */   532,  363,  490,   94,  490, 1364,   37,   36, 1710, 1899,
 /*   850 */    43,   41,   40,   39,   38, 1997, 1996,  127,  532,  549,
 /*   860 */  1411, 1695, 2058,  549,  489, 1702,  489, 1574, 1899, 2054,
 /*   870 */   549,  464, 1342,   44,   42, 1707, 1867, 1697, 1917,  244,
 /*   880 */   143,  351,  137, 1336, 2060,  171,  604, 2054, 1710, 2055,
 /*   890 */   576, 1867, 1710,  603, 1416, 1693, 1334, 1917,    8, 1710,
 /*   900 */  1482, 1393, 2060,  171,  267,  604,  224, 2055,  576, 1867,
 /*   910 */  1867,  598,  603,  280, 1897, 1573, 1740, 1411, 1933,  549,
 /*   920 */   694, 1899,  159, 1898, 1900,  607, 1902, 1903,  602, 1342,
 /*   930 */   597,  528,   51, 1897, 1418, 1419, 1570, 1933, 1569,  549,
 /*   940 */  1611,   97, 1898, 1900,  607, 1902, 1903,  602, 1710,  597,
 /*   950 */  1917,  533,   50,  531, 2074,    1, 1986, 1867,  604,  549,
 /*   960 */   344, 1982,  503, 1867,  549,  603,  414,  631, 1710,  582,
 /*   970 */  2048,  238,  549,   93,  577, 2075,  545,  694, 1867, 1337,
 /*   980 */  1867, 1335, 1685,   90,  547, 1664, 1897,  243, 1710,  404,
 /*   990 */  1933, 1418, 1419, 1710,  159, 1898, 1900,  607, 1902, 1903,
 /*  1000 */   602, 1710,  597, 1340, 1341, 1552, 1391, 1392, 1394, 1395,
 /*  1010 */  1396, 1397, 1398, 1399, 1400, 1401,  599,  595, 1409, 1410,
 /*  1020 */  1412, 1413, 1414, 1415, 1417, 1420,    3,   37,   36,  206,
 /*  1030 */   549,   43,   41,   40,   39,   38, 1337,   72, 1335, 1554,
 /*  1040 */  1555,  211,  548,  161,  209, 1568,  580, 2076,  482,  478,
 /*  1050 */   474,  470,  205, 1567,  213,   13,   12,  212, 1572, 1710,
 /*  1060 */  1340, 1341, 1621, 1391, 1392, 1394, 1395, 1396, 1397, 1398,
 /*  1070 */  1399, 1400, 1401,  599,  595, 1409, 1410, 1412, 1413, 1414,
 /*  1080 */  1415, 1417, 1420,    3,  310,  262, 1359, 1867,  638,   78,
 /*  1090 */   227,  215,  203,  427,  214, 1867,  438, 1606,   37,   36,
 /*  1100 */  1551, 2026,   43,   41,   40,   39,   38,  145,  144,  635,
 /*  1110 */   634,  633,  563,  411, 1522,  439,  578,  413, 1566,  505,
 /*  1120 */  1345,  217, 1565, 1564,  216,  671,  670,  669,  668,  361,
 /*  1130 */    80,  667,  666,  133,  661,  660,  659,  658,  657,  656,
 /*  1140 */   655,  654,  147,  650,  649,  648,  360,  359,  645,  644,
 /*  1150 */   643,  642,  641,  155,  202,  196, 1563,  201,  286,  323,
 /*  1160 */  1867,  461,   37,   36, 1867, 1867,   43,   41,   40,   39,
 /*  1170 */    38,  400,  284,   66, 1604,   45,   65,  194,  594,  232,
 /*  1180 */   483,  138,  142,  256, 1562, 1502,  143,  583,   60, 1918,
 /*  1190 */  1595,  248,  190,  444,  442, 1899,  508,   26, 1867,  437,
 /*  1200 */   362,   60,  432,  431,  430,  429,  426,  425,  424,  423,
 /*  1210 */   422,  418,  417,  416,  415,  324,  408,  407,  406, 1750,
 /*  1220 */   402,  401,  322,  549, 1917, 2016, 1867, 1285,   45,   58,
 /*  1230 */  1108,  236,  604,  542,  240,  269, 1600, 1867, 1181,  603,
 /*  1240 */  1509,   37,   36,  251,   32,   43,   41,   40,   39,   38,
 /*  1250 */    37,   36, 1710, 1453,   43,   41,   40,   39,   38,  264,
 /*  1260 */  1897,  261, 1348, 1109, 1933, 1888,  549,   96,   97, 1898,
 /*  1270 */  1900,  607, 1902, 1903,  602, 1344,  597, 1899,  358,  129,
 /*  1280 */  1402,  141, 1957, 1986,  689,   37,   36,  344, 1982,   43,
 /*  1290 */    41,   40,   39,   38,  316, 1710,   45,  611,  588,    5,
 /*  1300 */     2,  520,   71,   70,  393,  367, 1917,  178,  372,  142,
 /*  1310 */  1301,  334,  143, 1890,  604,  646, 1437,  122,  532, 1867,
 /*  1320 */   321,  603,  142,  647,  309,  276,  183,  381, 1899,  379,
 /*  1330 */   375,  371,  368,  365,  399,  403, 1445, 1128,  435,  409,
 /*  1340 */  1359,  421, 1897, 1806,  587, 1126, 1933, 2054,  279, 1209,
 /*  1350 */   302, 1898, 1900,  607, 1902, 1903,  602, 1917,  597,  428,
 /*  1360 */   587, 1213, 2060,  171, 1220,  591,  434, 2055,  576, 1218,
 /*  1370 */  1867,  436,  603,  132,  146,  174,  441,  440,  187,  443,
 /*  1380 */   445, 1365,  446,  454, 1367,  457,  458,  193,  195,  132,
 /*  1390 */  1446, 1366, 1368, 1897,  459,  460,  198, 1933,  466,  200,
 /*  1400 */   462,   97, 1898, 1900,  607, 1902, 1903,  602,   75,  597,
 /*  1410 */   130,   76,  204,  485,  168,   99, 1986, 1347,  487,  519,
 /*  1420 */   344, 1982, 1700,  208, 1696,  312,  130,  210,  521,  277,
 /*  1430 */   148,  149,  170, 1994, 1995, 1698, 1999, 1694,  150,  153,
 /*  1440 */   222, 2013,  151,  522,  225, 1845, 1899,  523,  172, 1994,
 /*  1450 */  1995,  529, 1999,  534,  229,  561,  526,  543,  537,   84,
 /*  1460 */    33,  348, 1440, 1441, 1442, 1443, 1444, 1448, 1449, 1450,
 /*  1470 */  1451,  333,  139, 1844, 1816, 1917,  140,  540,  335,  544,
 /*  1480 */    86, 1364,  557,  604, 1711,  278, 2017,  564, 1867,    6,
 /*  1490 */   603, 2027, 2032,  246,  250,  559,  560, 2031,  573,  558,
 /*  1500 */   556,  162,  255,  340,  567,  555,  260,  341,  584, 2008,
 /*  1510 */   581, 1897,  257, 1899, 1479, 1933,  131, 1363,   57,   97,
 /*  1520 */  1898, 1900,  607, 1902, 1903,  602,   88,  597,  258, 1967,
 /*  1530 */   609,  259, 2074, 1754, 1986, 1899, 1681, 2002,  344, 1982,
 /*  1540 */   281,  272, 1917,  690, 2053,  691, 2077,  263, 2005,  693,
 /*  1550 */   604,  307,   49,  293,  283, 1867,  304,  603, 1861,  303,
 /*  1560 */  1860,   68, 1859, 1858, 1917,  285,   69, 1855,  369,  370,
 /*  1570 */  1328, 1329,  604,  177,  374, 1853,  376, 1867, 1897,  603,
 /*  1580 */   377,  378, 1933, 1852,  380, 1851,   97, 1898, 1900,  607,
 /*  1590 */  1902, 1903,  602, 1899,  597, 1850,  382, 1849,  384, 1961,
 /*  1600 */  1897, 1986, 1304,  386, 1933,  344, 1982,  391,   97, 1898,
 /*  1610 */  1900,  607, 1902, 1903,  602, 1899,  597, 1303, 1827,  347,
 /*  1620 */   346, 1959, 1917, 1986, 1826,  392, 1825,  344, 1982, 1350,
 /*  1630 */   604, 1824, 1273, 1799, 1798, 1867,  134,  603, 1796, 1795,
 /*  1640 */  1416, 1794, 1343, 1797, 1917,  135, 1793, 1792, 1790, 1789,
 /*  1650 */  1788,  181,  604, 1787,  410, 1786,  412, 1867, 1897,  603,
 /*  1660 */  1785, 1784, 1933, 1411, 1783, 1782,   97, 1898, 1900,  607,
 /*  1670 */  1902, 1903,  602, 1781,  597, 1342, 1780, 1779, 1778,  552,
 /*  1680 */  1897, 1986, 1777, 1776, 1933,  344, 1982,  136,   98, 1898,
 /*  1690 */  1900,  607, 1902, 1903,  602, 1775,  597, 1774, 1773, 1772,
 /*  1700 */  1771, 1770, 1769, 1986, 1768, 1767, 1275, 1985, 1982, 1766,
 /*  1710 */  1765, 1764, 1763, 1626, 1156,  188, 1625, 1623,  189, 1591,
 /*  1720 */   123, 1071, 1899,  593, 1590, 1840,  450,  191, 1070,  166,
 /*  1730 */   192,  124, 1834, 1823,  452,  197,  199, 1822, 1808, 1689,
 /*  1740 */  1622, 1620, 1618,  467, 1616,  469, 1614, 1603, 1602, 1587,
 /*  1750 */   468, 1917, 1691, 1101,   59,  471,  475,  473,  479,  604,
 /*  1760 */  1690, 1320,  472, 1612, 1867,  477,  603,  481,  207,  476,
 /*  1770 */  1224, 1147, 1223, 1145,  480, 1607, 1605,  662, 1146,  506,
 /*  1780 */  1144, 1586, 1351, 1138, 1346,  100,  329, 1897, 1143, 1140,
 /*  1790 */  1899, 1933, 1139, 1137,  330,   98, 1898, 1900,  607, 1902,
 /*  1800 */  1903,  602,  664,  597,  509,  331, 1354, 1356,  511, 1899,
 /*  1810 */  1986, 1585,  513, 1584,  592, 1982,  515, 1839,   53, 1917,
 /*  1820 */   595, 1409, 1410, 1412, 1413, 1414, 1415,  601, 1310, 1833,
 /*  1830 */   152,  524, 1867,  525,  603, 1821, 1819,  332, 1917, 1820,
 /*  1840 */  2059, 1818, 1817, 1318,  538, 1815,  604,  242,  226,   25,
 /*  1850 */    18, 1867, 1807,  603,  541, 1897,  237,  530,   83, 1933,
 /*  1860 */  1428,  231,   82,  301, 1898, 1900,  607, 1902, 1903,  602,
 /*  1870 */   600,  597,  550, 1951, 1897,   90, 1899,   19, 1933,   10,
 /*  1880 */    85, 1427,   98, 1898, 1900,  607, 1902, 1903,  602,  239,
 /*  1890 */   597,   20,   27, 1899, 1524,  247,  245, 1986, 1506,  249,
 /*  1900 */    56, 1508, 1983,  253,  160, 1917,  252,   15,   28,  254,
 /*  1910 */  1501, 1888,   89,  601,   21,   29, 1544, 1545, 1867,   61,
 /*  1920 */   603,   22, 1917, 1539, 1538,  342, 1543, 1542,  343,  266,
 /*  1930 */   604, 1887,  163, 1476,   12, 1867, 1899,  603, 1475,   55,
 /*  1940 */  1352, 1897, 1384, 1936,  596, 1933, 1406,  164, 1404,  301,
 /*  1950 */  1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1897, 1952,
 /*  1960 */    35,   14, 1933, 1403,   23, 1917,  158, 1898, 1900,  607,
 /*  1970 */  1902, 1903,  602,  604,  597,  175, 1376, 1210, 1867, 1438,
 /*  1980 */   603,   24,  608,  606,  610, 1917,  353,  614,  612,  615,
 /*  1990 */   349,  617, 1207,  604, 1204, 1198,  618,  620, 1867,  621,
 /*  2000 */   603, 1897, 1196,  623,  624, 1933, 1187, 1899, 2024,  297,
 /*  2010 */  1898, 1900,  607, 1902, 1903,  602,   54,  597,   16,  630,
 /*  2020 */    91, 1897, 1202, 1219, 1201, 1933, 1200, 1199,   92,  302,
 /*  2030 */  1898, 1900,  607, 1902, 1903,  602, 1917,  597,   67,  270,
 /*  2040 */  1215,  352, 1099,  639,  604, 1134, 1133, 1132, 1131, 1867,
 /*  2050 */  1130,  603, 1129,  572, 1127, 1125, 1124, 1123, 1154,  271,
 /*  2060 */   651, 1121, 1120, 1119, 1118, 1117, 1116, 1115, 1114, 1151,
 /*  2070 */  1149, 1111, 1897, 1110, 1107, 1106, 1933, 1105, 1619, 1104,
 /*  2080 */   302, 1898, 1900,  607, 1902, 1903,  602, 1899,  597,  673,
 /*  2090 */   674,  672, 1617,  676,  677, 1615,  678,  680,  682,  681,
 /*  2100 */  1613,  684,  686, 1601,  688, 1899, 1061,  685, 1583,  274,
 /*  2110 */   692, 1558, 1338,  282,  695, 1558, 1917,  696, 1558, 1558,
 /*  2120 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2130 */  1558,  603, 1558, 1558, 1917, 1558, 1558, 1558, 1558, 1558,
 /*  2140 */  1558, 1558,  604, 1558, 1558, 1558, 1558, 1867, 1899,  603,
 /*  2150 */  1558, 1558,  518, 1558, 1558, 1558, 1933, 1558, 1558, 1558,
 /*  2160 */   295, 1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1558,
 /*  2170 */  1897, 1558, 1558, 1558, 1933, 1558, 1558, 1917,  287, 1898,
 /*  2180 */  1900,  607, 1902, 1903,  602,  604,  597, 1558, 1558, 1558,
 /*  2190 */  1867, 1899,  603, 1558, 1558, 1558, 1917, 1558, 1558, 1558,
 /*  2200 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2210 */  1558,  603, 1558, 1897, 1558, 1558, 1558, 1933, 1558, 1558,
 /*  2220 */  1917,  288, 1898, 1900,  607, 1902, 1903,  602,  604,  597,
 /*  2230 */  1558, 1558, 1897, 1867, 1899,  603, 1933, 1558, 1558, 1558,
 /*  2240 */   289, 1898, 1900,  607, 1902, 1903,  602, 1558,  597, 1558,
 /*  2250 */  1558, 1899, 1558, 1558, 1558, 1558, 1897, 1558, 1558, 1558,
 /*  2260 */  1933, 1558, 1558, 1917,  296, 1898, 1900,  607, 1902, 1903,
 /*  2270 */   602,  604,  597, 1558, 1558, 1558, 1867, 1899,  603, 1558,
 /*  2280 */  1917, 1558, 1558, 1558, 1558, 1558, 1558, 1558,  604, 1558,
 /*  2290 */  1558, 1558, 1558, 1867, 1899,  603, 1558, 1558, 1558, 1897,
 /*  2300 */  1558, 1558, 1558, 1933, 1558, 1558, 1917,  298, 1898, 1900,
 /*  2310 */   607, 1902, 1903,  602,  604,  597, 1897, 1558, 1558, 1867,
 /*  2320 */  1933,  603, 1558, 1917,  290, 1898, 1900,  607, 1902, 1903,
 /*  2330 */   602,  604,  597, 1558, 1558, 1558, 1867, 1558,  603, 1558,
 /*  2340 */  1558, 1558, 1897, 1558, 1558, 1558, 1933, 1558, 1558, 1558,
 /*  2350 */   299, 1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1897,
 /*  2360 */  1558, 1558, 1558, 1933, 1558, 1558, 1558,  291, 1898, 1900,
 /*  2370 */   607, 1902, 1903,  602, 1899,  597, 1558, 1558, 1558, 1558,
 /*  2380 */  1558, 1558, 1558, 1558, 1558, 1558, 1917, 1558, 1558, 1558,
 /*  2390 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2400 */  1558,  603, 1558, 1917, 1558, 1558, 1558, 1558, 1558, 1558,
 /*  2410 */  1558,  604, 1558, 1558, 1558, 1558, 1867, 1558,  603, 1558,
 /*  2420 */  1558, 1558, 1897, 1558, 1558, 1558, 1933, 1558, 1558, 1558,
 /*  2430 */   300, 1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1897,
 /*  2440 */  1558, 1558, 1558, 1933, 1558, 1558, 1558,  292, 1898, 1900,
 /*  2450 */   607, 1902, 1903,  602, 1558,  597, 1558, 1558, 1558, 1558,
 /*  2460 */  1558, 1558, 1558, 1899, 1558, 1558, 1917, 1558, 1558, 1558,
 /*  2470 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2480 */  1558,  603, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558,
 /*  2490 */  1558, 1558, 1917, 1558, 1558, 1558, 1558, 1558, 1558, 1558,
 /*  2500 */   604, 1558, 1897, 1558, 1558, 1867, 1933,  603, 1558, 1558,
 /*  2510 */   305, 1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1558,
 /*  2520 */  1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1897, 1558,
 /*  2530 */  1558, 1558, 1933, 1558, 1899, 1558,  306, 1898, 1900,  607,
 /*  2540 */  1902, 1903,  602, 1558,  597, 1558, 1917, 1558, 1558, 1558,
 /*  2550 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2560 */  1558,  603, 1558, 1917, 1558, 1558, 1558, 1558, 1558, 1558,
 /*  2570 */  1558,  604, 1558, 1558, 1558, 1558, 1867, 1899,  603, 1558,
 /*  2580 */  1558, 1558, 1897, 1558, 1558, 1558, 1933, 1558, 1558, 1558,
 /*  2590 */  1911, 1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1897,
 /*  2600 */  1558, 1558, 1558, 1933, 1558, 1558, 1917, 1910, 1898, 1900,
 /*  2610 */   607, 1902, 1903,  602,  604,  597, 1558, 1558, 1558, 1867,
 /*  2620 */  1558,  603, 1558, 1558, 1558, 1558, 1917, 1558, 1558, 1558,
 /*  2630 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2640 */  1899,  603, 1897, 1558, 1558, 1558, 1933, 1558, 1558, 1558,
 /*  2650 */  1909, 1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1558,
 /*  2660 */  1558, 1558, 1897, 1558, 1558, 1558, 1933, 1558, 1558, 1917,
 /*  2670 */   317, 1898, 1900,  607, 1902, 1903,  602,  604,  597, 1558,
 /*  2680 */  1558, 1558, 1867, 1558,  603, 1558, 1917, 1558, 1558, 1558,
 /*  2690 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2700 */  1558,  603, 1558, 1558, 1558, 1897, 1558, 1558, 1558, 1933,
 /*  2710 */  1558, 1558, 1558,  318, 1898, 1900,  607, 1902, 1903,  602,
 /*  2720 */  1899,  597, 1897, 1558, 1558, 1558, 1933, 1558, 1558, 1558,
 /*  2730 */   314, 1898, 1900,  607, 1902, 1903,  602, 1899,  597, 1558,
 /*  2740 */  1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1558, 1917,
 /*  2750 */  1558, 1558, 1558, 1558, 1558, 1558, 1558,  604, 1558, 1558,
 /*  2760 */  1558, 1558, 1867, 1558,  603, 1558, 1917, 1558, 1558, 1558,
 /*  2770 */  1558, 1558, 1558, 1558,  604, 1558, 1558, 1558, 1558, 1867,
 /*  2780 */  1558,  603, 1558, 1558, 1558, 1897, 1558, 1558, 1558, 1933,
 /*  2790 */  1558, 1558, 1558,  319, 1898, 1900,  607, 1902, 1903,  602,
 /*  2800 */  1558,  597, 1897, 1558, 1558, 1558, 1933, 1558, 1558, 1558,
 /*  2810 */   294, 1898, 1900,  607, 1902, 1903,  602, 1558,  597,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   351,  409,  410,  351,  319,    4,  321,  320,    4,  364,
 /*    10 */   351,  362,   12,   13,  362,  324,  371,  326,  327,  374,
 /*    20 */    20,  362,   22,   12,   13,   14,   15,   16,   20,  333,
 /*    30 */   348,  317,   20,   33,  338,   35,  349,  388,  389,  390,
 /*    40 */   388,  389,  390,  361,  357,   44,   45,  388,  389,  362,
 /*    50 */   401,  364,    2,  401,  325,  320,   56,  328,    8,    9,
 /*    60 */   401,   61,   12,   13,   14,   15,   16,  320,   68,   12,
 /*    70 */    13,   14,  385,  320,    4,   20,  389,   20,  394,   22,
 /*    80 */   393,  394,  395,  396,  397,  398,  399,  332,  401,   19,
 /*    90 */    33,  377,   35,  406,   94,  408,  349,  362,   94,  412,
 /*   100 */   413,  346,   94,   33,  357,  328,   94,  423,  394,  362,
 /*   110 */   355,  364,  425,   56,  364,  362,  116,   47,   61,  320,
 /*   120 */   433,   51,  438,  439,  374,   68,   56,  443,  444,   20,
 /*   130 */   130,  131,  385,  394,  357,  328,  389,  423,  328,  320,
 /*   140 */   393,  394,  395,  396,  397,  398,  399,  324,  401,  326,
 /*   150 */   327,   94,  438,  439,   20,  408,   22,  443,  444,  412,
 /*   160 */   413,  362,  423,   93,  357,   39,   96,   94,   14,   35,
 /*   170 */   423,  394,  341,  116,   20,  175,  366,  177,  439,  126,
 /*   180 */   349,  362,  443,  444,   50,  438,  439,  130,  131,  358,
 /*   190 */   443,  444,  415,  416,  417,  418,   20,  420,   60,  199,
 /*   200 */   200,  394,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  416,  417,  418,    0,  420,  363,  364,
 /*   230 */   423,   14,  175,  170,  177,  182,  183,   20,  377,  186,
 /*   240 */   240,  199,  335,  336,  240,  438,  439,  174,  240,  176,
 /*   250 */   443,  444,  240,  190,  191,  394,  199,  200,   94,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   280 */    12,   13,   19,   56,  423,  125,  126,   20,   20,  332,
 /*   290 */    22,  249,  250,  251,  252,  253,   33,  328,  320,  438,
 /*   300 */   439,   33,  328,   35,  443,  444,  130,  131,    3,  340,
 /*   310 */    47,  351,  355,  240,  340,   52,   53,   54,   55,   56,
 /*   320 */    93,  347,  362,   96,   56,  342,  357,  349,  345,   61,
 /*   330 */   360,  357,  106,  363,  364,  357,   68,   12,   13,   20,
 /*   340 */   362,   22,  364,  183,   20,   20,  186,   22,  388,  389,
 /*   350 */   160,  125,  126,  127,  128,  129,   93,  203,   33,   96,
 /*   360 */    35,  401,   94,  385,   14,  239,  328,  389,  106,   50,
 /*   370 */    20,  393,  394,  395,  396,  397,  398,  399,  340,  401,
 /*   380 */    94,   56,    0,   22,  116,  347,   61,  125,  126,  127,
 /*   390 */   128,  129,  129,   68,  325,  357,   35,  328,  130,  131,
 /*   400 */    95,  423,   22,   21,  240,   78,   24,   25,   26,   27,
 /*   410 */    28,   29,   30,   31,   32,   35,  438,  439,   94,   94,
 /*   420 */   203,  443,  444,   21,  161,  328,   24,   25,   26,   27,
 /*   430 */    28,   29,   30,   31,   32,  245,  246,  340,   63,   64,
 /*   440 */    65,  116,  179,  175,  181,  177,   71,   72,   68,  320,
 /*   450 */   349,   76,   77,  349,  357,  130,  131,   82,   83,  358,
 /*   460 */   356,  134,  135,   88,   35,   44,   45,  199,  200,  365,
 /*   470 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   490 */   222,  362,  224,   14,   15,   16,  116,   68,  238,  239,
 /*   500 */   175,    0,  177,  125,   20,  157,  107,  108,  109,  110,
 /*   510 */   111,  112,  113,  114,  115,  116,  117,   60,  119,  120,
 /*   520 */   121,  122,  123,  124,  199,  200,  240,  202,  203,  204,
 /*   530 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   540 */   215,  216,  217,  218,  219,  220,  221,  222,   12,   13,
 /*   550 */   357,  341,  349,    3,  391,  175,   20,  177,   22,  349,
 /*   560 */   357,  368,  184,  185,   63,   64,   65,  105,  358,   33,
 /*   570 */    20,   35,   71,   72,  328,  227,   56,   76,   77,  199,
 /*   580 */   200,  320,  419,   82,   83,  237,  340,    0,    0,   88,
 /*   590 */     8,    9,   56,   20,   12,   13,   14,   15,   16,  396,
 /*   600 */   320,  349,   68,  357,   68,   12,   13,   14,  356,  328,
 /*   610 */   349,   42,   43,   20,   94,   22,   96,  365,  357,  328,
 /*   620 */   224,  340,  226,  362,  341,  364,   33,  349,   35,  349,
 /*   630 */    94,  340,  349,  404,  356,  394,  407,  357,  357,  328,
 /*   640 */   320,  358,  362,  365,  364,   95,  385,   60,  357,   56,
 /*   650 */   389,  340,  116,  377,  393,  394,  395,  396,  397,  398,
 /*   660 */   399,   68,  401,    4,  423,  385,  130,  131,  357,  389,
 /*   670 */   394,  328,  394,  393,  394,  395,  396,  397,  398,  399,
 /*   680 */   439,  401,  362,  340,  443,  444,  406,   94,  408,  405,
 /*   690 */    21,  407,  412,  413,  349,  434,  435,  335,  336,  423,
 /*   700 */   357,  423,  422,   34,    0,   36,  405,  224,  407,  116,
 /*   710 */   365,  175,  162,  177,  438,  439,  438,  439,   20,  443,
 /*   720 */   444,  443,  444,  130,  131,    8,    9,    1,    2,   12,
 /*   730 */    13,   14,   15,   16,    0,  199,  200,   20,  202,  203,
 /*   740 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,  218,  219,  220,  221,  222,    0,
 /*   760 */   240,   68,   20,  357,   60,  373,  357,  375,  175,  337,
 /*   770 */   177,  339,  330,   37,  368,  350,  240,  368,  320,  381,
 /*   780 */   373,   47,  375,   24,   25,   26,   27,   28,   29,   30,
 /*   790 */    31,   32,  199,  200,  352,  202,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,  214,  215,  216,
 /*   810 */   217,  218,  219,  220,  221,  222,   12,   13,    0,  328,
 /*   820 */   362,   95,  359,  377,   20,  362,   22,  391,  391,  359,
 /*   830 */    43,  340,  362,   97,  320,   99,  100,   33,  102,   35,
 /*   840 */   394,  377,  106,  330,  106,   20,    8,    9,  357,  320,
 /*   850 */    12,   13,   14,   15,   16,  419,  419,  344,  394,  328,
 /*   860 */    56,  350,    3,  328,  128,  352,  128,  320,  320,  423,
 /*   870 */   328,  340,   68,   12,   13,  340,  362,  350,  349,  162,
 /*   880 */    43,   20,  340,   22,  438,  439,  357,  423,  357,  443,
 /*   890 */   444,  362,  357,  364,   33,  350,   35,  349,   94,  357,
 /*   900 */   241,  203,  438,  439,  162,  357,  350,  443,  444,  362,
 /*   910 */   362,  350,  364,  342,  385,  320,  345,   56,  389,  328,
 /*   920 */   116,  320,  393,  394,  395,  396,  397,  398,  399,   68,
 /*   930 */   401,  340,   95,  385,  130,  131,  320,  389,  320,  328,
 /*   940 */     0,  393,  394,  395,  396,  397,  398,  399,  357,  401,
 /*   950 */   349,  340,  162,  163,  406,   94,  408,  362,  357,  328,
 /*   960 */   412,  413,   22,  362,  328,  364,  148,  350,  357,   43,
 /*   970 */   422,  340,  328,   94,  445,  446,  340,  116,  362,  175,
 /*   980 */   362,  177,    0,  104,  340,  338,  385,  162,  357,  105,
 /*   990 */   389,  130,  131,  357,  393,  394,  395,  396,  397,  398,
 /*  1000 */   399,  357,  401,  199,  200,  167,  202,  203,  204,  205,
 /*  1010 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1020 */   216,  217,  218,  219,  220,  221,  222,    8,    9,   33,
 /*  1030 */   328,   12,   13,   14,   15,   16,  175,  153,  177,  130,
 /*  1040 */   131,   98,  340,   47,  101,  320,  259,  446,   52,   53,
 /*  1050 */    54,   55,   56,  320,   98,    1,    2,  101,  321,  357,
 /*  1060 */   199,  200,    0,  202,  203,  204,  205,  206,  207,  208,
 /*  1070 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*  1080 */   219,  220,  221,  222,   18,  447,   20,  362,  106,   93,
 /*  1090 */    56,   98,   96,   27,  101,  362,   30,    0,    8,    9,
 /*  1100 */   262,  392,   12,   13,   14,   15,   16,  125,  126,  127,
 /*  1110 */   128,  129,  436,   47,   95,   49,  257,   51,  320,   22,
 /*  1120 */    35,   98,  320,  320,  101,   63,   64,   65,   66,   67,
 /*  1130 */    96,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*  1140 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1150 */    88,   89,   90,   18,  158,  159,  320,  161,   23,   93,
 /*  1160 */   362,  165,    8,    9,  362,  362,   12,   13,   14,   15,
 /*  1170 */    16,  105,   37,   38,    0,   43,   41,  181,   61,   43,
 /*  1180 */   329,   43,   43,  430,  320,   95,   43,  261,   43,  349,
 /*  1190 */   327,   43,   57,   58,   59,  320,   22,   43,  362,  133,
 /*  1200 */   329,   43,  136,  137,  138,  139,  140,  141,  142,  143,
 /*  1210 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  361,
 /*  1220 */   154,  155,  156,  328,  349,  392,  362,   95,   43,   94,
 /*  1230 */    35,   95,  357,   95,   95,  340,    0,  362,   95,  364,
 /*  1240 */    95,    8,    9,   95,    2,   12,   13,   14,   15,   16,
 /*  1250 */     8,    9,  357,   95,   12,   13,   14,   15,   16,  440,
 /*  1260 */   385,  414,  177,   68,  389,   46,  328,  132,  393,  394,
 /*  1270 */   395,  396,  397,  398,  399,   35,  401,  320,  340,  404,
 /*  1280 */    95,  406,  407,  408,   48,    8,    9,  412,  413,   12,
 /*  1290 */    13,   14,   15,   16,   61,  357,   43,   43,  421,  242,
 /*  1300 */   424,  377,  167,  168,  169,  387,  349,  172,   47,   43,
 /*  1310 */   173,  354,   43,   94,  357,   13,  199,   43,  394,  362,
 /*  1320 */   386,  364,   43,   13,  189,  379,   42,  192,  320,  194,
 /*  1330 */   195,  196,  197,  198,  369,  369,  103,   35,  157,  367,
 /*  1340 */    20,  328,  385,  328,  328,   35,  389,  423,   95,   95,
 /*  1350 */   393,  394,  395,  396,  397,  398,  399,  349,  401,  369,
 /*  1360 */   328,   95,  438,  439,   95,  357,  367,  443,  444,   95,
 /*  1370 */   362,  367,  364,  357,   95,  240,  334,   92,  328,  328,
 /*  1380 */   328,   20,  322,  322,   20,  383,  364,  332,  332,  357,
 /*  1390 */   157,   20,   20,  385,  376,  378,  332,  389,  328,  332,
 /*  1400 */   376,  393,  394,  395,  396,  397,  398,  399,  332,  401,
 /*  1410 */   394,  332,  332,  322,  406,  328,  408,  177,  349,  188,
 /*  1420 */   412,  413,  349,  349,  349,  322,  394,  349,  384,  383,
 /*  1430 */   349,  349,  416,  417,  418,  349,  420,  349,  349,  162,
 /*  1440 */   330,  433,  349,  180,  330,  362,  320,  382,  416,  417,
 /*  1450 */   418,  328,  420,  328,  330,  247,  364,  159,  362,  330,
 /*  1460 */   227,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*  1470 */   237,  376,  372,  362,  362,  349,  372,  362,  362,  370,
 /*  1480 */   330,   20,  362,  357,  357,  345,  392,  248,  362,  254,
 /*  1490 */   364,  392,  429,  372,  372,  362,  362,  429,  166,  256,
 /*  1500 */   255,  429,  431,  362,  362,  243,  387,  263,  260,  432,
 /*  1510 */   258,  385,  428,  320,  239,  389,  357,   20,   94,  393,
 /*  1520 */   394,  395,  396,  397,  398,  399,   94,  401,  427,  411,
 /*  1530 */   353,  426,  406,  362,  408,  320,  339,  391,  412,  413,
 /*  1540 */   328,  330,  349,   36,  442,  323,  448,  441,  422,  322,
 /*  1550 */   357,  375,  380,  343,  331,  362,  343,  364,    0,  343,
 /*  1560 */     0,  182,    0,    0,  349,  318,   42,    0,   35,  193,
 /*  1570 */    35,   35,  357,   35,  193,    0,   35,  362,  385,  364,
 /*  1580 */    35,  193,  389,    0,  193,    0,  393,  394,  395,  396,
 /*  1590 */   397,  398,  399,  320,  401,    0,   35,    0,   22,  406,
 /*  1600 */   385,  408,  177,   35,  389,  412,  413,  171,  393,  394,
 /*  1610 */   395,  396,  397,  398,  399,  320,  401,  175,    0,   12,
 /*  1620 */    13,  406,  349,  408,    0,  170,    0,  412,  413,   22,
 /*  1630 */   357,    0,   46,    0,    0,  362,   42,  364,    0,    0,
 /*  1640 */    33,    0,   35,    0,  349,   42,    0,    0,    0,    0,
 /*  1650 */     0,  148,  357,    0,   35,    0,  148,  362,  385,  364,
 /*  1660 */     0,    0,  389,   56,    0,    0,  393,  394,  395,  396,
 /*  1670 */   397,  398,  399,    0,  401,   68,    0,    0,    0,  406,
 /*  1680 */   385,  408,    0,    0,  389,  412,  413,   42,  393,  394,
 /*  1690 */   395,  396,  397,  398,  399,    0,  401,    0,    0,    0,
 /*  1700 */     0,    0,    0,  408,    0,    0,   22,  412,  413,    0,
 /*  1710 */     0,    0,    0,    0,   35,   56,    0,    0,   56,    0,
 /*  1720 */    39,   14,  320,  116,    0,    0,   46,   42,   14,   43,
 /*  1730 */    40,   39,    0,    0,   46,   39,  166,    0,    0,    0,
 /*  1740 */     0,    0,    0,   35,    0,   39,    0,    0,    0,    0,
 /*  1750 */    47,  349,    0,   62,  103,   35,   35,   39,   35,  357,
 /*  1760 */     0,   95,   47,    0,  362,   39,  364,   39,  101,   47,
 /*  1770 */    35,   35,   22,   22,   47,    0,    0,   43,   35,   49,
 /*  1780 */    35,    0,  175,   22,  177,   20,   22,  385,   35,   35,
 /*  1790 */   320,  389,   35,   35,   22,  393,  394,  395,  396,  397,
 /*  1800 */   398,  399,   43,  401,   35,   22,  199,  200,   35,  320,
 /*  1810 */   408,    0,   35,    0,  412,  413,   22,    0,  162,  349,
 /*  1820 */   213,  214,  215,  216,  217,  218,  219,  357,   35,    0,
 /*  1830 */   178,   22,  362,  162,  364,    0,    0,  162,  349,    0,
 /*  1840 */     3,    0,    0,   35,  187,    0,  357,   46,  159,   94,
 /*  1850 */    94,  362,    0,  364,  160,  385,   94,  164,   39,  389,
 /*  1860 */   223,   95,   94,  393,  394,  395,  396,  397,  398,  399,
 /*  1870 */   400,  401,  402,  403,  385,  104,  320,   43,  389,  225,
 /*  1880 */    94,  223,  393,  394,  395,  396,  397,  398,  399,  158,
 /*  1890 */   401,   43,   94,  320,   95,   95,   94,  408,   95,   94,
 /*  1900 */    43,   95,  413,   43,   94,  349,   94,  244,   94,   46,
 /*  1910 */    95,   46,   94,  357,  244,   43,   95,   95,  362,    3,
 /*  1920 */   364,   43,  349,   35,   35,   35,   35,   35,   35,   46,
 /*  1930 */   357,   46,   46,   95,    2,  362,  320,  364,   95,   43,
 /*  1940 */    22,  385,   22,   94,   94,  389,   95,   46,   95,  393,
 /*  1950 */   394,  395,  396,  397,  398,  399,  320,  401,  385,  403,
 /*  1960 */    94,   94,  389,   95,   94,  349,  393,  394,  395,  396,
 /*  1970 */   397,  398,  399,  357,  401,   46,   95,   95,  362,  199,
 /*  1980 */   364,   94,  105,  201,   35,  349,   35,   35,   94,   94,
 /*  1990 */   354,   35,   95,  357,   95,   95,   94,   35,  362,   94,
 /*  2000 */   364,  385,   95,   35,   94,  389,   22,  320,  435,  393,
 /*  2010 */   394,  395,  396,  397,  398,  399,  238,  401,  244,  106,
 /*  2020 */    94,  385,  118,   35,  118,  389,  118,  118,   94,  393,
 /*  2030 */   394,  395,  396,  397,  398,  399,  349,  401,   94,   43,
 /*  2040 */    22,  354,   62,   61,  357,   35,   35,   35,   35,  362,
 /*  2050 */    35,  364,   35,  437,   35,   35,   35,   35,   68,   43,
 /*  2060 */    91,   35,   35,   22,   35,   22,   35,   35,   35,   68,
 /*  2070 */    35,   35,  385,   35,   35,   35,  389,   22,    0,   35,
 /*  2080 */   393,  394,  395,  396,  397,  398,  399,  320,  401,   47,
 /*  2090 */    39,   35,    0,   35,   47,    0,   39,   35,   39,   47,
 /*  2100 */     0,   35,   39,    0,   35,  320,   35,   47,    0,   22,
 /*  2110 */    21,  449,   22,   22,   21,  449,  349,   20,  449,  449,
 /*  2120 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2130 */   449,  364,  449,  449,  349,  449,  449,  449,  449,  449,
 /*  2140 */   449,  449,  357,  449,  449,  449,  449,  362,  320,  364,
 /*  2150 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2160 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2170 */   385,  449,  449,  449,  389,  449,  449,  349,  393,  394,
 /*  2180 */   395,  396,  397,  398,  399,  357,  401,  449,  449,  449,
 /*  2190 */   362,  320,  364,  449,  449,  449,  349,  449,  449,  449,
 /*  2200 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2210 */   449,  364,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2220 */   349,  393,  394,  395,  396,  397,  398,  399,  357,  401,
 /*  2230 */   449,  449,  385,  362,  320,  364,  389,  449,  449,  449,
 /*  2240 */   393,  394,  395,  396,  397,  398,  399,  449,  401,  449,
 /*  2250 */   449,  320,  449,  449,  449,  449,  385,  449,  449,  449,
 /*  2260 */   389,  449,  449,  349,  393,  394,  395,  396,  397,  398,
 /*  2270 */   399,  357,  401,  449,  449,  449,  362,  320,  364,  449,
 /*  2280 */   349,  449,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2290 */   449,  449,  449,  362,  320,  364,  449,  449,  449,  385,
 /*  2300 */   449,  449,  449,  389,  449,  449,  349,  393,  394,  395,
 /*  2310 */   396,  397,  398,  399,  357,  401,  385,  449,  449,  362,
 /*  2320 */   389,  364,  449,  349,  393,  394,  395,  396,  397,  398,
 /*  2330 */   399,  357,  401,  449,  449,  449,  362,  449,  364,  449,
 /*  2340 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2350 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2360 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2370 */   396,  397,  398,  399,  320,  401,  449,  449,  449,  449,
 /*  2380 */   449,  449,  449,  449,  449,  449,  349,  449,  449,  449,
 /*  2390 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2400 */   449,  364,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2410 */   449,  357,  449,  449,  449,  449,  362,  449,  364,  449,
 /*  2420 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2430 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2440 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2450 */   396,  397,  398,  399,  449,  401,  449,  449,  449,  449,
 /*  2460 */   449,  449,  449,  320,  449,  449,  349,  449,  449,  449,
 /*  2470 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2480 */   449,  364,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2490 */   449,  449,  349,  449,  449,  449,  449,  449,  449,  449,
 /*  2500 */   357,  449,  385,  449,  449,  362,  389,  364,  449,  449,
 /*  2510 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2520 */   449,  449,  449,  449,  449,  449,  449,  449,  385,  449,
 /*  2530 */   449,  449,  389,  449,  320,  449,  393,  394,  395,  396,
 /*  2540 */   397,  398,  399,  449,  401,  449,  349,  449,  449,  449,
 /*  2550 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2560 */   449,  364,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2570 */   449,  357,  449,  449,  449,  449,  362,  320,  364,  449,
 /*  2580 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2590 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  385,
 /*  2600 */   449,  449,  449,  389,  449,  449,  349,  393,  394,  395,
 /*  2610 */   396,  397,  398,  399,  357,  401,  449,  449,  449,  362,
 /*  2620 */   449,  364,  449,  449,  449,  449,  349,  449,  449,  449,
 /*  2630 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2640 */   320,  364,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2650 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2660 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  349,
 /*  2670 */   393,  394,  395,  396,  397,  398,  399,  357,  401,  449,
 /*  2680 */   449,  449,  362,  449,  364,  449,  349,  449,  449,  449,
 /*  2690 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2700 */   449,  364,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2710 */   449,  449,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2720 */   320,  401,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2730 */   393,  394,  395,  396,  397,  398,  399,  320,  401,  449,
 /*  2740 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  349,
 /*  2750 */   449,  449,  449,  449,  449,  449,  449,  357,  449,  449,
 /*  2760 */   449,  449,  362,  449,  364,  449,  349,  449,  449,  449,
 /*  2770 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2780 */   449,  364,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2790 */   449,  449,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2800 */   449,  401,  385,  449,  449,  449,  389,  449,  449,  449,
 /*  2810 */   393,  394,  395,  396,  397,  398,  399,  449,  401,
};
#define YY_SHIFT_COUNT    (697)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2108)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1135,    0,   57,  268,   57,  325,  325,  325,  536,  325,
 /*    10 */   325,  325,  325,  325,  593,  804,  804,  861,  804,  804,
 /*    20 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    30 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    40 */   804,  804,  804,  804,  804,  804,    8,   12,  324,   73,
 /*    50 */   520,  164,  286,  164,  324,  324, 1607, 1607,  164, 1607,
 /*    60 */  1607,    4,  164,   55,   55,    1,    1,  176,   55,   55,
 /*    70 */    55,   55,   55,   55,   55,   55,   55,   55,  138,   55,
 /*    80 */    55,   55,  109,   55,   55,  267,   55,   55,  267,  484,
 /*    90 */    55,  267,  267,  267,   55,  457, 1066, 1233, 1233,  375,
 /*   100 */   402,  380,  380,  380,  380,  380,  380,  380,  380,  380,
 /*   110 */   380,  380,  380,  380,  380,  380,  380,  380,  380,  380,
 /*   120 */   736,  550,  176,  350,  350,  587,  429,  704,  396,  396,
 /*   130 */   742,  742,  742,  429,  573,  573,  573,  462,  109,  588,
 /*   140 */   588,  483,  267,  267,  534,  534,  462,  693,  399,  399,
 /*   150 */   399,  399,  399,  399,  399,  263,  501,  382,  717,  838,
 /*   160 */    42,  134,  190,  154,  217,  319,  421,  738,  825,  260,
 /*   170 */   126,  859,  260,  569,  659,  698, 1057, 1261, 1137, 1284,
 /*   180 */  1284, 1181, 1320, 1320, 1284, 1181, 1181, 1285, 1320, 1320,
 /*   190 */  1320, 1361, 1361, 1364,  138,  109,  138, 1371, 1372,  138,
 /*   200 */  1371,  138,  138,  138, 1320,  138, 1361,  267,  267,  267,
 /*   210 */   267,  267,  267,  267,  267,  267,  267,  267, 1320, 1361,
 /*   220 */   534, 1231, 1364,  457, 1263,  109,  457, 1320, 1320, 1371,
 /*   230 */   457, 1208,  534,  534,  534,  534, 1208,  534, 1298,  457,
 /*   240 */   462,  457,  573, 1461, 1461,  534, 1239, 1208,  534,  534,
 /*   250 */  1239, 1208,  534,  534,  267, 1235, 1332, 1239, 1243, 1245,
 /*   260 */  1262, 1057, 1244, 1248, 1252, 1275,  573, 1497, 1424, 1432,
 /*   270 */   534,  693, 1320,  457, 1507, 1361, 2819, 2819, 2819, 2819,
 /*   280 */  2819, 2819, 2819, 1062,  996,  759,   70, 1019, 1154, 1090,
 /*   290 */    50, 1242, 1277,  226,  582,  582,  582,  582,  582,  582,
 /*   300 */   582,  582,  582,  982,  262,   11,   11,   53,  160,   63,
 /*   310 */   227,  327,  669,  378,  479,  726,  348,  479,  479,  479,
 /*   320 */   837,  734,  361,  884,  818,  943,  956,  993, 1023,  940,
 /*   330 */  1097, 1174, 1034,  790, 1132, 1136, 1138, 1139, 1143, 1145,
 /*   340 */  1148,  909,  787,  926, 1054, 1158, 1085, 1240, 1117, 1185,
 /*   350 */   305, 1219, 1253, 1254, 1266, 1269, 1274, 1279,  879, 1302,
 /*   360 */  1310, 1195, 1236, 1558, 1560, 1379, 1562, 1563, 1524, 1567,
 /*   370 */  1533, 1376, 1535, 1536, 1538, 1381, 1575, 1541, 1545, 1388,
 /*   380 */  1583, 1391, 1585, 1561, 1595, 1576, 1597, 1568, 1425, 1442,
 /*   390 */  1618, 1624, 1436, 1455, 1626, 1631, 1586, 1633, 1634, 1638,
 /*   400 */  1594, 1639, 1641, 1643, 1603, 1646, 1647, 1648, 1649, 1650,
 /*   410 */  1503, 1619, 1653, 1508, 1655, 1660, 1661, 1664, 1665, 1673,
 /*   420 */  1676, 1677, 1678, 1682, 1683, 1695, 1697, 1698, 1699, 1645,
 /*   430 */  1700, 1701, 1702, 1704, 1705, 1684, 1709, 1710, 1711, 1712,
 /*   440 */  1679, 1713, 1659, 1716, 1662, 1717, 1719, 1685, 1681, 1686,
 /*   450 */  1707, 1680, 1714, 1688, 1724, 1690, 1692, 1725, 1732, 1733,
 /*   460 */  1696, 1570, 1737, 1738, 1739, 1691, 1740, 1741, 1708, 1703,
 /*   470 */  1706, 1742, 1720, 1715, 1718, 1744, 1721, 1722, 1726, 1746,
 /*   480 */  1723, 1727, 1728, 1747, 1748, 1749, 1752, 1651, 1667, 1735,
 /*   490 */  1750, 1760, 1736, 1743, 1751, 1745, 1753, 1734, 1759, 1754,
 /*   500 */  1757, 1761, 1758, 1763, 1764, 1775, 1772, 1730, 1776, 1783,
 /*   510 */  1769, 1781, 1773, 1811, 1777, 1813, 1794, 1765, 1666, 1755,
 /*   520 */  1817, 1656, 1793, 1829, 1652, 1809, 1671, 1689, 1835, 1836,
 /*   530 */  1675, 1693, 1837, 1839, 1841, 1842, 1756, 1766, 1808, 1657,
 /*   540 */  1845, 1762, 1694, 1768, 1852, 1819, 1731, 1786, 1771, 1801,
 /*   550 */  1834, 1637, 1654, 1658, 1848, 1663, 1798, 1799, 1802, 1800,
 /*   560 */  1803, 1805, 1857, 1806, 1810, 1812, 1814, 1815, 1860, 1863,
 /*   570 */  1865, 1818, 1872, 1670, 1821, 1822, 1916, 1878, 1774, 1888,
 /*   580 */  1889, 1890, 1891, 1892, 1893, 1838, 1843, 1883, 1778, 1896,
 /*   590 */  1885, 1886, 1932, 1918, 1780, 1849, 1851, 1850, 1853, 1866,
 /*   600 */  1868, 1901, 1867, 1870, 1929, 1881, 1920, 1782, 1887, 1877,
 /*   610 */  1882, 1949, 1951, 1894, 1897, 1952, 1895, 1899, 1956, 1902,
 /*   620 */  1900, 1962, 1905, 1907, 1968, 1910, 1904, 1906, 1908, 1909,
 /*   630 */  1984, 1913, 1926, 1934, 1988, 1944, 1996, 1996, 2018, 1980,
 /*   640 */  1982, 2010, 2011, 2012, 2013, 2015, 2017, 2019, 2020, 2021,
 /*   650 */  2022, 1990, 1969, 2016, 2026, 2027, 2041, 2029, 2043, 2031,
 /*   660 */  2032, 2033, 2001, 1734, 2035, 1759, 2036, 2038, 2039, 2040,
 /*   670 */  2055, 2044, 2078, 2056, 2042, 2051, 2092, 2058, 2047, 2057,
 /*   680 */  2095, 2062, 2052, 2059, 2100, 2066, 2060, 2063, 2103, 2069,
 /*   690 */  2071, 2108, 2087, 2089, 2090, 2091, 2093, 2097,
};
#define YY_REDUCE_COUNT (282)
#define YY_REDUCE_MIN   (-408)
#define YY_REDUCE_MAX   (2417)
static const short yy_reduce_ofst[] = {
 /*     0 */  -286, -253, -313,  875, 1008,  280,  548, 1126,  -22, 1193,
 /*    10 */  1215, 1273, 1295, 1402, 1470,  261,  529, 1489,  957, 1556,
 /*    20 */  1573, 1616,  601, 1636, 1687, 1767, 1785, 1828, 1847, 1871,
 /*    30 */  1914, 1931, 1957, 1974, 2037, 2054, 2117, 2143, 2197, 2214,
 /*    40 */  2257, 2277, 2320, 2337, 2400, 2417, -193,  278, -223, -139,
 /*    50 */   276,  446,  464,  924, 1016, 1032, -351, -348, -316, -341,
 /*    60 */   -40, -261,  241,  -26,   38, -309, -177,  -30,  -31,   97,
 /*    70 */   246,  281,  291,  311,  343,  491,  531,  535, -245,  542,
 /*    80 */   591,  611, -355,  631,  636, -169,  644,  702,  104,  203,
 /*    90 */   895,  210,  252,  283,  938,  513, -190, -408, -408, -304,
 /*   100 */  -315, -265, -247, -201, -181,  129,  320,  458,  514,  547,
 /*   110 */   595,  616,  618,  725,  733,  798,  802,  803,  836,  864,
 /*   120 */  -318,  163, -135, -271,   69,  -43,  -93,  442,  284,  301,
 /*   130 */   163,  436,  437,  362,  193,  406,  409,  -17, -250,  392,
 /*   140 */   407,  229,  101,  345,  463,  470,  571,  432,  425,  511,
 /*   150 */   527,  545,  556,  561,  617,  398,  647,  737,  709,  638,
 /*   160 */   676,  851,  753,  840,  840,  871,  863,  858,  833,  877,
 /*   170 */   877,  819,  877,  847,  876,  840,  918,  934,  946,  965,
 /*   180 */   966,  972, 1013, 1015,  990,  999, 1004, 1042, 1050, 1051,
 /*   190 */  1052, 1060, 1061, 1002, 1055, 1022, 1056, 1018, 1017, 1064,
 /*   200 */  1024, 1067, 1076, 1079, 1070, 1080, 1091, 1069, 1073, 1074,
 /*   210 */  1075, 1078, 1081, 1082, 1086, 1088, 1089, 1093, 1087, 1103,
 /*   220 */  1083, 1044, 1046, 1110, 1065, 1092, 1114, 1123, 1125, 1095,
 /*   230 */  1124, 1100, 1096, 1111, 1112, 1115, 1104, 1116, 1109, 1129,
 /*   240 */  1140, 1150, 1127, 1094, 1099, 1120, 1063, 1121, 1133, 1134,
 /*   250 */  1068, 1122, 1141, 1142,  840, 1077, 1071, 1072, 1084, 1101,
 /*   260 */  1105, 1119, 1098, 1102, 1106,  877, 1159, 1146, 1118, 1177,
 /*   270 */  1171, 1197, 1212, 1211, 1222, 1227, 1172, 1176, 1210, 1213,
 /*   280 */  1216, 1223, 1247,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    10 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    20 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    30 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    40 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    50 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    60 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    70 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1630, 1556,
 /*    80 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*    90 */  1556, 1556, 1556, 1556, 1556, 1628, 1800, 1988, 1556, 1556,
 /*   100 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   110 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   120 */  1556, 2000, 1556, 1556, 1556, 1630, 1556, 1628, 1960, 1960,
 /*   130 */  2000, 2000, 2000, 1556, 1556, 1556, 1556, 1739, 1556, 1841,
 /*   140 */  1841, 1556, 1556, 1556, 1556, 1556, 1739, 1556, 1556, 1556,
 /*   150 */  1556, 1556, 1556, 1556, 1556, 1835, 1556, 1556, 2025, 2078,
 /*   160 */  1556, 1556, 2028, 1556, 1556, 1556, 1556, 1692, 2015, 1992,
 /*   170 */  2006, 2062, 1993, 1990, 2009, 1556, 2019, 1556, 1828, 1805,
 /*   180 */  1805, 1802, 1556, 1556, 1805, 1802, 1802, 1683, 1556, 1556,
 /*   190 */  1556, 1556, 1556, 1556, 1630, 1556, 1630, 1556, 1556, 1630,
 /*   200 */  1556, 1630, 1630, 1630, 1556, 1630, 1556, 1556, 1556, 1556,
 /*   210 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   220 */  1556, 1847, 1556, 1628, 1837, 1556, 1628, 1556, 1556, 1556,
 /*   230 */  1628, 2033, 1556, 1556, 1556, 1556, 2033, 1556, 1556, 1628,
 /*   240 */  1556, 1628, 1556, 1556, 1556, 1556, 2035, 2033, 1556, 1556,
 /*   250 */  2035, 2033, 1556, 1556, 1556, 2047, 2043, 2035, 2051, 2049,
 /*   260 */  2021, 2019, 2081, 2068, 2064, 2006, 1556, 1556, 1556, 1708,
 /*   270 */  1556, 1556, 1556, 1628, 1588, 1556, 1830, 1841, 1742, 1742,
 /*   280 */  1742, 1631, 1561, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   290 */  1556, 1556, 1556, 1556, 1916, 1556, 2046, 2045, 1964, 1963,
 /*   300 */  1962, 1953, 1915, 1556, 1704, 1914, 1913, 1556, 1556, 1556,
 /*   310 */  1556, 1556, 1556, 1556, 1907, 1556, 1556, 1908, 1906, 1905,
 /*   320 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   330 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   340 */  1556, 1556, 2065, 2069, 1989, 1556, 1556, 1556, 1556, 1556,
 /*   350 */  1898, 1889, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   360 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   370 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   380 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   390 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   400 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   410 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   420 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   430 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   440 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1593,
 /*   450 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   460 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   470 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   480 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   490 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1670, 1669, 1556,
 /*   500 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   510 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1897, 1556,
 /*   520 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   530 */  1556, 1556, 2061, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   540 */  1845, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   550 */  1950, 1556, 1556, 1556, 2022, 1556, 1556, 1556, 1556, 1556,
 /*   560 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   570 */  1889, 1556, 2044, 1556, 1556, 2059, 1556, 2063, 1556, 1556,
 /*   580 */  1556, 1556, 1556, 1556, 1556, 1999, 1995, 1556, 1556, 1991,
 /*   590 */  1888, 1556, 1984, 1556, 1556, 1935, 1556, 1556, 1556, 1556,
 /*   600 */  1556, 1556, 1556, 1556, 1556, 1897, 1556, 1901, 1556, 1556,
 /*   610 */  1556, 1556, 1556, 1736, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   620 */  1556, 1556, 1556, 1556, 1556, 1556, 1721, 1719, 1718, 1717,
 /*   630 */  1556, 1714, 1556, 1556, 1556, 1556, 1745, 1744, 1556, 1556,
 /*   640 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   650 */  1556, 1556, 1556, 1650, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   660 */  1556, 1556, 1556, 1641, 1556, 1640, 1556, 1556, 1556, 1556,
 /*   670 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   680 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
 /*   690 */  1556, 1556, 1556, 1556, 1556, 1556, 1556, 1556,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  264,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  264,  /*      AFTER => ABORT */
  264,  /*     ATTACH => ABORT */
  264,  /*     BEFORE => ABORT */
  264,  /*      BEGIN => ABORT */
  264,  /*     BITAND => ABORT */
  264,  /*     BITNOT => ABORT */
  264,  /*      BITOR => ABORT */
  264,  /*     BLOCKS => ABORT */
  264,  /*     CHANGE => ABORT */
  264,  /*      COMMA => ABORT */
  264,  /*    COMPACT => ABORT */
  264,  /*     CONCAT => ABORT */
  264,  /*   CONFLICT => ABORT */
  264,  /*       COPY => ABORT */
  264,  /*   DEFERRED => ABORT */
  264,  /* DELIMITERS => ABORT */
  264,  /*     DETACH => ABORT */
  264,  /*     DIVIDE => ABORT */
  264,  /*        DOT => ABORT */
  264,  /*       EACH => ABORT */
  264,  /*       FAIL => ABORT */
  264,  /*       FILE => ABORT */
  264,  /*        FOR => ABORT */
  264,  /*       GLOB => ABORT */
  264,  /*         ID => ABORT */
  264,  /*  IMMEDIATE => ABORT */
  264,  /*     IMPORT => ABORT */
  264,  /*  INITIALLY => ABORT */
  264,  /*    INSTEAD => ABORT */
  264,  /*     ISNULL => ABORT */
  264,  /*        KEY => ABORT */
  264,  /*    MODULES => ABORT */
  264,  /*  NK_BITNOT => ABORT */
  264,  /*    NK_SEMI => ABORT */
  264,  /*    NOTNULL => ABORT */
  264,  /*         OF => ABORT */
  264,  /*       PLUS => ABORT */
  264,  /*  PRIVILEGE => ABORT */
  264,  /*      RAISE => ABORT */
  264,  /*    REPLACE => ABORT */
  264,  /*   RESTRICT => ABORT */
  264,  /*        ROW => ABORT */
  264,  /*       SEMI => ABORT */
  264,  /*       STAR => ABORT */
  264,  /*  STATEMENT => ABORT */
  264,  /*     STRING => ABORT */
  264,  /*      TIMES => ABORT */
  264,  /*     UPDATE => ABORT */
  264,  /*     VALUES => ABORT */
  264,  /*   VARIABLE => ABORT */
  264,  /*       VIEW => ABORT */
  264,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "QNODES",
  /*  138 */ "FUNCTIONS",
  /*  139 */ "INDEXES",
  /*  140 */ "ACCOUNTS",
  /*  141 */ "APPS",
  /*  142 */ "CONNECTIONS",
  /*  143 */ "LICENCES",
  /*  144 */ "GRANTS",
  /*  145 */ "QUERIES",
  /*  146 */ "SCORES",
  /*  147 */ "TOPICS",
  /*  148 */ "VARIABLES",
  /*  149 */ "CLUSTER",
  /*  150 */ "BNODES",
  /*  151 */ "SNODES",
  /*  152 */ "TRANSACTIONS",
  /*  153 */ "DISTRIBUTED",
  /*  154 */ "CONSUMERS",
  /*  155 */ "SUBSCRIPTIONS",
  /*  156 */ "VNODES",
  /*  157 */ "LIKE",
  /*  158 */ "INDEX",
  /*  159 */ "FUNCTION",
  /*  160 */ "INTERVAL",
  /*  161 */ "TOPIC",
  /*  162 */ "AS",
  /*  163 */ "WITH",
  /*  164 */ "META",
  /*  165 */ "CONSUMER",
  /*  166 */ "GROUP",
  /*  167 */ "DESC",
  /*  168 */ "DESCRIBE",
  /*  169 */ "RESET",
  /*  170 */ "QUERY",
  /*  171 */ "CACHE",
  /*  172 */ "EXPLAIN",
  /*  173 */ "ANALYZE",
  /*  174 */ "VERBOSE",
  /*  175 */ "NK_BOOL",
  /*  176 */ "RATIO",
  /*  177 */ "NK_FLOAT",
  /*  178 */ "OUTPUTTYPE",
  /*  179 */ "AGGREGATE",
  /*  180 */ "BUFSIZE",
  /*  181 */ "STREAM",
  /*  182 */ "INTO",
  /*  183 */ "TRIGGER",
  /*  184 */ "AT_ONCE",
  /*  185 */ "WINDOW_CLOSE",
  /*  186 */ "IGNORE",
  /*  187 */ "EXPIRED",
  /*  188 */ "SUBTABLE",
  /*  189 */ "KILL",
  /*  190 */ "CONNECTION",
  /*  191 */ "TRANSACTION",
  /*  192 */ "BALANCE",
  /*  193 */ "VGROUP",
  /*  194 */ "MERGE",
  /*  195 */ "REDISTRIBUTE",
  /*  196 */ "SPLIT",
  /*  197 */ "DELETE",
  /*  198 */ "INSERT",
  /*  199 */ "NULL",
  /*  200 */ "NK_QUESTION",
  /*  201 */ "NK_ARROW",
  /*  202 */ "ROWTS",
  /*  203 */ "TBNAME",
  /*  204 */ "QSTART",
  /*  205 */ "QEND",
  /*  206 */ "QDURATION",
  /*  207 */ "WSTART",
  /*  208 */ "WEND",
  /*  209 */ "WDURATION",
  /*  210 */ "IROWTS",
  /*  211 */ "QTAGS",
  /*  212 */ "CAST",
  /*  213 */ "NOW",
  /*  214 */ "TODAY",
  /*  215 */ "TIMEZONE",
  /*  216 */ "CLIENT_VERSION",
  /*  217 */ "SERVER_VERSION",
  /*  218 */ "SERVER_STATUS",
  /*  219 */ "CURRENT_USER",
  /*  220 */ "COUNT",
  /*  221 */ "LAST_ROW",
  /*  222 */ "CASE",
  /*  223 */ "END",
  /*  224 */ "WHEN",
  /*  225 */ "THEN",
  /*  226 */ "ELSE",
  /*  227 */ "BETWEEN",
  /*  228 */ "IS",
  /*  229 */ "NK_LT",
  /*  230 */ "NK_GT",
  /*  231 */ "NK_LE",
  /*  232 */ "NK_GE",
  /*  233 */ "NK_NE",
  /*  234 */ "MATCH",
  /*  235 */ "NMATCH",
  /*  236 */ "CONTAINS",
  /*  237 */ "IN",
  /*  238 */ "JOIN",
  /*  239 */ "INNER",
  /*  240 */ "SELECT",
  /*  241 */ "DISTINCT",
  /*  242 */ "WHERE",
  /*  243 */ "PARTITION",
  /*  244 */ "BY",
  /*  245 */ "SESSION",
  /*  246 */ "STATE_WINDOW",
  /*  247 */ "SLIDING",
  /*  248 */ "FILL",
  /*  249 */ "VALUE",
  /*  250 */ "NONE",
  /*  251 */ "PREV",
  /*  252 */ "LINEAR",
  /*  253 */ "NEXT",
  /*  254 */ "HAVING",
  /*  255 */ "RANGE",
  /*  256 */ "EVERY",
  /*  257 */ "ORDER",
  /*  258 */ "SLIMIT",
  /*  259 */ "SOFFSET",
  /*  260 */ "LIMIT",
  /*  261 */ "OFFSET",
  /*  262 */ "ASC",
  /*  263 */ "NULLS",
  /*  264 */ "ABORT",
  /*  265 */ "AFTER",
  /*  266 */ "ATTACH",
  /*  267 */ "BEFORE",
  /*  268 */ "BEGIN",
  /*  269 */ "BITAND",
  /*  270 */ "BITNOT",
  /*  271 */ "BITOR",
  /*  272 */ "BLOCKS",
  /*  273 */ "CHANGE",
  /*  274 */ "COMMA",
  /*  275 */ "COMPACT",
  /*  276 */ "CONCAT",
  /*  277 */ "CONFLICT",
  /*  278 */ "COPY",
  /*  279 */ "DEFERRED",
  /*  280 */ "DELIMITERS",
  /*  281 */ "DETACH",
  /*  282 */ "DIVIDE",
  /*  283 */ "DOT",
  /*  284 */ "EACH",
  /*  285 */ "FAIL",
  /*  286 */ "FILE",
  /*  287 */ "FOR",
  /*  288 */ "GLOB",
  /*  289 */ "ID",
  /*  290 */ "IMMEDIATE",
  /*  291 */ "IMPORT",
  /*  292 */ "INITIALLY",
  /*  293 */ "INSTEAD",
  /*  294 */ "ISNULL",
  /*  295 */ "KEY",
  /*  296 */ "MODULES",
  /*  297 */ "NK_BITNOT",
  /*  298 */ "NK_SEMI",
  /*  299 */ "NOTNULL",
  /*  300 */ "OF",
  /*  301 */ "PLUS",
  /*  302 */ "PRIVILEGE",
  /*  303 */ "RAISE",
  /*  304 */ "REPLACE",
  /*  305 */ "RESTRICT",
  /*  306 */ "ROW",
  /*  307 */ "SEMI",
  /*  308 */ "STAR",
  /*  309 */ "STATEMENT",
  /*  310 */ "STRING",
  /*  311 */ "TIMES",
  /*  312 */ "UPDATE",
  /*  313 */ "VALUES",
  /*  314 */ "VARIABLE",
  /*  315 */ "VIEW",
  /*  316 */ "WAL",
  /*  317 */ "cmd",
  /*  318 */ "account_options",
  /*  319 */ "alter_account_options",
  /*  320 */ "literal",
  /*  321 */ "alter_account_option",
  /*  322 */ "user_name",
  /*  323 */ "sysinfo_opt",
  /*  324 */ "privileges",
  /*  325 */ "priv_level",
  /*  326 */ "priv_type_list",
  /*  327 */ "priv_type",
  /*  328 */ "db_name",
  /*  329 */ "dnode_endpoint",
  /*  330 */ "not_exists_opt",
  /*  331 */ "db_options",
  /*  332 */ "exists_opt",
  /*  333 */ "alter_db_options",
  /*  334 */ "speed_opt",
  /*  335 */ "integer_list",
  /*  336 */ "variable_list",
  /*  337 */ "retention_list",
  /*  338 */ "alter_db_option",
  /*  339 */ "retention",
  /*  340 */ "full_table_name",
  /*  341 */ "column_def_list",
  /*  342 */ "tags_def_opt",
  /*  343 */ "table_options",
  /*  344 */ "multi_create_clause",
  /*  345 */ "tags_def",
  /*  346 */ "multi_drop_clause",
  /*  347 */ "alter_table_clause",
  /*  348 */ "alter_table_options",
  /*  349 */ "column_name",
  /*  350 */ "type_name",
  /*  351 */ "signed_literal",
  /*  352 */ "create_subtable_clause",
  /*  353 */ "specific_cols_opt",
  /*  354 */ "expression_list",
  /*  355 */ "drop_table_clause",
  /*  356 */ "col_name_list",
  /*  357 */ "table_name",
  /*  358 */ "column_def",
  /*  359 */ "duration_list",
  /*  360 */ "rollup_func_list",
  /*  361 */ "alter_table_option",
  /*  362 */ "duration_literal",
  /*  363 */ "rollup_func_name",
  /*  364 */ "function_name",
  /*  365 */ "col_name",
  /*  366 */ "db_name_cond_opt",
  /*  367 */ "like_pattern_opt",
  /*  368 */ "table_name_cond",
  /*  369 */ "from_db_opt",
  /*  370 */ "index_options",
  /*  371 */ "func_list",
  /*  372 */ "sliding_opt",
  /*  373 */ "sma_stream_opt",
  /*  374 */ "func",
  /*  375 */ "stream_options",
  /*  376 */ "topic_name",
  /*  377 */ "query_or_subquery",
  /*  378 */ "cgroup_name",
  /*  379 */ "analyze_opt",
  /*  380 */ "explain_options",
  /*  381 */ "agg_func_opt",
  /*  382 */ "bufsize_opt",
  /*  383 */ "stream_name",
  /*  384 */ "subtable_opt",
  /*  385 */ "expression",
  /*  386 */ "dnode_list",
  /*  387 */ "where_clause_opt",
  /*  388 */ "signed",
  /*  389 */ "literal_func",
  /*  390 */ "literal_list",
  /*  391 */ "table_alias",
  /*  392 */ "column_alias",
  /*  393 */ "expr_or_subquery",
  /*  394 */ "subquery",
  /*  395 */ "pseudo_column",
  /*  396 */ "column_reference",
  /*  397 */ "function_expression",
  /*  398 */ "case_when_expression",
  /*  399 */ "star_func",
  /*  400 */ "star_func_para_list",
  /*  401 */ "noarg_func",
  /*  402 */ "other_para_list",
  /*  403 */ "star_func_para",
  /*  404 */ "when_then_list",
  /*  405 */ "case_when_else_opt",
  /*  406 */ "common_expression",
  /*  407 */ "when_then_expr",
  /*  408 */ "predicate",
  /*  409 */ "compare_op",
  /*  410 */ "in_op",
  /*  411 */ "in_predicate_value",
  /*  412 */ "boolean_value_expression",
  /*  413 */ "boolean_primary",
  /*  414 */ "from_clause_opt",
  /*  415 */ "table_reference_list",
  /*  416 */ "table_reference",
  /*  417 */ "table_primary",
  /*  418 */ "joined_table",
  /*  419 */ "alias_opt",
  /*  420 */ "parenthesized_joined_table",
  /*  421 */ "join_type",
  /*  422 */ "search_condition",
  /*  423 */ "query_specification",
  /*  424 */ "set_quantifier_opt",
  /*  425 */ "select_list",
  /*  426 */ "partition_by_clause_opt",
  /*  427 */ "range_opt",
  /*  428 */ "every_opt",
  /*  429 */ "fill_opt",
  /*  430 */ "twindow_clause_opt",
  /*  431 */ "group_by_clause_opt",
  /*  432 */ "having_clause_opt",
  /*  433 */ "select_item",
  /*  434 */ "partition_list",
  /*  435 */ "partition_item",
  /*  436 */ "fill_mode",
  /*  437 */ "group_by_list",
  /*  438 */ "query_expression",
  /*  439 */ "query_simple",
  /*  440 */ "order_by_clause_opt",
  /*  441 */ "slimit_clause_opt",
  /*  442 */ "limit_clause_opt",
  /*  443 */ "union_query_expression",
  /*  444 */ "query_simple_or_subquery",
  /*  445 */ "sort_specification_list",
  /*  446 */ "sort_specification",
  /*  447 */ "ordering_specification_opt",
  /*  448 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 107 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 108 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 109 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 110 */ "alter_db_option ::= KEEP integer_list",
 /* 111 */ "alter_db_option ::= KEEP variable_list",
 /* 112 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 113 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 114 */ "alter_db_option ::= STRICT NK_STRING",
 /* 115 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 116 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 117 */ "integer_list ::= NK_INTEGER",
 /* 118 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 119 */ "variable_list ::= NK_VARIABLE",
 /* 120 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 121 */ "retention_list ::= retention",
 /* 122 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 123 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 124 */ "speed_opt ::=",
 /* 125 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 126 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 127 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 128 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 129 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 130 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 131 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 132 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 133 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 134 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 136 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 138 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 140 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 142 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 143 */ "multi_create_clause ::= create_subtable_clause",
 /* 144 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 145 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 146 */ "multi_drop_clause ::= drop_table_clause",
 /* 147 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 148 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 149 */ "specific_cols_opt ::=",
 /* 150 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 151 */ "full_table_name ::= table_name",
 /* 152 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 153 */ "column_def_list ::= column_def",
 /* 154 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 155 */ "column_def ::= column_name type_name",
 /* 156 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 157 */ "type_name ::= BOOL",
 /* 158 */ "type_name ::= TINYINT",
 /* 159 */ "type_name ::= SMALLINT",
 /* 160 */ "type_name ::= INT",
 /* 161 */ "type_name ::= INTEGER",
 /* 162 */ "type_name ::= BIGINT",
 /* 163 */ "type_name ::= FLOAT",
 /* 164 */ "type_name ::= DOUBLE",
 /* 165 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= TIMESTAMP",
 /* 167 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TINYINT UNSIGNED",
 /* 169 */ "type_name ::= SMALLINT UNSIGNED",
 /* 170 */ "type_name ::= INT UNSIGNED",
 /* 171 */ "type_name ::= BIGINT UNSIGNED",
 /* 172 */ "type_name ::= JSON",
 /* 173 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 174 */ "type_name ::= MEDIUMBLOB",
 /* 175 */ "type_name ::= BLOB",
 /* 176 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= DECIMAL",
 /* 178 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 180 */ "tags_def_opt ::=",
 /* 181 */ "tags_def_opt ::= tags_def",
 /* 182 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 183 */ "table_options ::=",
 /* 184 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 185 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 186 */ "table_options ::= table_options WATERMARK duration_list",
 /* 187 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 188 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 189 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 190 */ "alter_table_options ::= alter_table_option",
 /* 191 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 192 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 193 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 194 */ "duration_list ::= duration_literal",
 /* 195 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 196 */ "rollup_func_list ::= rollup_func_name",
 /* 197 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 198 */ "rollup_func_name ::= function_name",
 /* 199 */ "rollup_func_name ::= FIRST",
 /* 200 */ "rollup_func_name ::= LAST",
 /* 201 */ "col_name_list ::= col_name",
 /* 202 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 203 */ "col_name ::= column_name",
 /* 204 */ "cmd ::= SHOW DNODES",
 /* 205 */ "cmd ::= SHOW USERS",
 /* 206 */ "cmd ::= SHOW DATABASES",
 /* 207 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 208 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 209 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 210 */ "cmd ::= SHOW MNODES",
 /* 211 */ "cmd ::= SHOW QNODES",
 /* 212 */ "cmd ::= SHOW FUNCTIONS",
 /* 213 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 214 */ "cmd ::= SHOW STREAMS",
 /* 215 */ "cmd ::= SHOW ACCOUNTS",
 /* 216 */ "cmd ::= SHOW APPS",
 /* 217 */ "cmd ::= SHOW CONNECTIONS",
 /* 218 */ "cmd ::= SHOW LICENCES",
 /* 219 */ "cmd ::= SHOW GRANTS",
 /* 220 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 221 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 222 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 223 */ "cmd ::= SHOW QUERIES",
 /* 224 */ "cmd ::= SHOW SCORES",
 /* 225 */ "cmd ::= SHOW TOPICS",
 /* 226 */ "cmd ::= SHOW VARIABLES",
 /* 227 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 228 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 229 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 230 */ "cmd ::= SHOW BNODES",
 /* 231 */ "cmd ::= SHOW SNODES",
 /* 232 */ "cmd ::= SHOW CLUSTER",
 /* 233 */ "cmd ::= SHOW TRANSACTIONS",
 /* 234 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 235 */ "cmd ::= SHOW CONSUMERS",
 /* 236 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 237 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 238 */ "cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt",
 /* 239 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 240 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 241 */ "db_name_cond_opt ::=",
 /* 242 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 243 */ "like_pattern_opt ::=",
 /* 244 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 245 */ "table_name_cond ::= table_name",
 /* 246 */ "from_db_opt ::=",
 /* 247 */ "from_db_opt ::= FROM db_name",
 /* 248 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 249 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 250 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 251 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 252 */ "func_list ::= func",
 /* 253 */ "func_list ::= func_list NK_COMMA func",
 /* 254 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 255 */ "sma_stream_opt ::=",
 /* 256 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 257 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 258 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 259 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 260 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 261 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 262 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 263 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 264 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 265 */ "cmd ::= DESC full_table_name",
 /* 266 */ "cmd ::= DESCRIBE full_table_name",
 /* 267 */ "cmd ::= RESET QUERY CACHE",
 /* 268 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 269 */ "analyze_opt ::=",
 /* 270 */ "analyze_opt ::= ANALYZE",
 /* 271 */ "explain_options ::=",
 /* 272 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 273 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 274 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 275 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 276 */ "agg_func_opt ::=",
 /* 277 */ "agg_func_opt ::= AGGREGATE",
 /* 278 */ "bufsize_opt ::=",
 /* 279 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 280 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 281 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 282 */ "stream_options ::=",
 /* 283 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 284 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 285 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 286 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 287 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 288 */ "subtable_opt ::=",
 /* 289 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 290 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 291 */ "cmd ::= KILL QUERY NK_STRING",
 /* 292 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 293 */ "cmd ::= BALANCE VGROUP",
 /* 294 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 295 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 296 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 297 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 298 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 299 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 300 */ "cmd ::= query_or_subquery",
 /* 301 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 302 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 303 */ "literal ::= NK_INTEGER",
 /* 304 */ "literal ::= NK_FLOAT",
 /* 305 */ "literal ::= NK_STRING",
 /* 306 */ "literal ::= NK_BOOL",
 /* 307 */ "literal ::= TIMESTAMP NK_STRING",
 /* 308 */ "literal ::= duration_literal",
 /* 309 */ "literal ::= NULL",
 /* 310 */ "literal ::= NK_QUESTION",
 /* 311 */ "duration_literal ::= NK_VARIABLE",
 /* 312 */ "signed ::= NK_INTEGER",
 /* 313 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 314 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 315 */ "signed ::= NK_FLOAT",
 /* 316 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 317 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 318 */ "signed_literal ::= signed",
 /* 319 */ "signed_literal ::= NK_STRING",
 /* 320 */ "signed_literal ::= NK_BOOL",
 /* 321 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 322 */ "signed_literal ::= duration_literal",
 /* 323 */ "signed_literal ::= NULL",
 /* 324 */ "signed_literal ::= literal_func",
 /* 325 */ "signed_literal ::= NK_QUESTION",
 /* 326 */ "literal_list ::= signed_literal",
 /* 327 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 328 */ "db_name ::= NK_ID",
 /* 329 */ "table_name ::= NK_ID",
 /* 330 */ "column_name ::= NK_ID",
 /* 331 */ "function_name ::= NK_ID",
 /* 332 */ "table_alias ::= NK_ID",
 /* 333 */ "column_alias ::= NK_ID",
 /* 334 */ "user_name ::= NK_ID",
 /* 335 */ "topic_name ::= NK_ID",
 /* 336 */ "stream_name ::= NK_ID",
 /* 337 */ "cgroup_name ::= NK_ID",
 /* 338 */ "expr_or_subquery ::= expression",
 /* 339 */ "expr_or_subquery ::= subquery",
 /* 340 */ "expression ::= literal",
 /* 341 */ "expression ::= pseudo_column",
 /* 342 */ "expression ::= column_reference",
 /* 343 */ "expression ::= function_expression",
 /* 344 */ "expression ::= case_when_expression",
 /* 345 */ "expression ::= NK_LP expression NK_RP",
 /* 346 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 347 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 348 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 349 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 350 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 351 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 352 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 353 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 354 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 355 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 356 */ "expression_list ::= expr_or_subquery",
 /* 357 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 358 */ "column_reference ::= column_name",
 /* 359 */ "column_reference ::= table_name NK_DOT column_name",
 /* 360 */ "pseudo_column ::= ROWTS",
 /* 361 */ "pseudo_column ::= TBNAME",
 /* 362 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 363 */ "pseudo_column ::= QSTART",
 /* 364 */ "pseudo_column ::= QEND",
 /* 365 */ "pseudo_column ::= QDURATION",
 /* 366 */ "pseudo_column ::= WSTART",
 /* 367 */ "pseudo_column ::= WEND",
 /* 368 */ "pseudo_column ::= WDURATION",
 /* 369 */ "pseudo_column ::= IROWTS",
 /* 370 */ "pseudo_column ::= QTAGS",
 /* 371 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 372 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 373 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 374 */ "function_expression ::= literal_func",
 /* 375 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 376 */ "literal_func ::= NOW",
 /* 377 */ "noarg_func ::= NOW",
 /* 378 */ "noarg_func ::= TODAY",
 /* 379 */ "noarg_func ::= TIMEZONE",
 /* 380 */ "noarg_func ::= DATABASE",
 /* 381 */ "noarg_func ::= CLIENT_VERSION",
 /* 382 */ "noarg_func ::= SERVER_VERSION",
 /* 383 */ "noarg_func ::= SERVER_STATUS",
 /* 384 */ "noarg_func ::= CURRENT_USER",
 /* 385 */ "noarg_func ::= USER",
 /* 386 */ "star_func ::= COUNT",
 /* 387 */ "star_func ::= FIRST",
 /* 388 */ "star_func ::= LAST",
 /* 389 */ "star_func ::= LAST_ROW",
 /* 390 */ "star_func_para_list ::= NK_STAR",
 /* 391 */ "star_func_para_list ::= other_para_list",
 /* 392 */ "other_para_list ::= star_func_para",
 /* 393 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 394 */ "star_func_para ::= expr_or_subquery",
 /* 395 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 396 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 397 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 398 */ "when_then_list ::= when_then_expr",
 /* 399 */ "when_then_list ::= when_then_list when_then_expr",
 /* 400 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 401 */ "case_when_else_opt ::=",
 /* 402 */ "case_when_else_opt ::= ELSE common_expression",
 /* 403 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 404 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 405 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 406 */ "predicate ::= expr_or_subquery IS NULL",
 /* 407 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 408 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 409 */ "compare_op ::= NK_LT",
 /* 410 */ "compare_op ::= NK_GT",
 /* 411 */ "compare_op ::= NK_LE",
 /* 412 */ "compare_op ::= NK_GE",
 /* 413 */ "compare_op ::= NK_NE",
 /* 414 */ "compare_op ::= NK_EQ",
 /* 415 */ "compare_op ::= LIKE",
 /* 416 */ "compare_op ::= NOT LIKE",
 /* 417 */ "compare_op ::= MATCH",
 /* 418 */ "compare_op ::= NMATCH",
 /* 419 */ "compare_op ::= CONTAINS",
 /* 420 */ "in_op ::= IN",
 /* 421 */ "in_op ::= NOT IN",
 /* 422 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 423 */ "boolean_value_expression ::= boolean_primary",
 /* 424 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 425 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 426 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 427 */ "boolean_primary ::= predicate",
 /* 428 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 429 */ "common_expression ::= expr_or_subquery",
 /* 430 */ "common_expression ::= boolean_value_expression",
 /* 431 */ "from_clause_opt ::=",
 /* 432 */ "from_clause_opt ::= FROM table_reference_list",
 /* 433 */ "table_reference_list ::= table_reference",
 /* 434 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 435 */ "table_reference ::= table_primary",
 /* 436 */ "table_reference ::= joined_table",
 /* 437 */ "table_primary ::= table_name alias_opt",
 /* 438 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 439 */ "table_primary ::= subquery alias_opt",
 /* 440 */ "table_primary ::= parenthesized_joined_table",
 /* 441 */ "alias_opt ::=",
 /* 442 */ "alias_opt ::= table_alias",
 /* 443 */ "alias_opt ::= AS table_alias",
 /* 444 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 445 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 446 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 447 */ "join_type ::=",
 /* 448 */ "join_type ::= INNER",
 /* 449 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 450 */ "set_quantifier_opt ::=",
 /* 451 */ "set_quantifier_opt ::= DISTINCT",
 /* 452 */ "set_quantifier_opt ::= ALL",
 /* 453 */ "select_list ::= select_item",
 /* 454 */ "select_list ::= select_list NK_COMMA select_item",
 /* 455 */ "select_item ::= NK_STAR",
 /* 456 */ "select_item ::= common_expression",
 /* 457 */ "select_item ::= common_expression column_alias",
 /* 458 */ "select_item ::= common_expression AS column_alias",
 /* 459 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 460 */ "where_clause_opt ::=",
 /* 461 */ "where_clause_opt ::= WHERE search_condition",
 /* 462 */ "partition_by_clause_opt ::=",
 /* 463 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 464 */ "partition_list ::= partition_item",
 /* 465 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 466 */ "partition_item ::= expr_or_subquery",
 /* 467 */ "partition_item ::= expr_or_subquery column_alias",
 /* 468 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 469 */ "twindow_clause_opt ::=",
 /* 470 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 471 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 472 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 473 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 474 */ "sliding_opt ::=",
 /* 475 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 476 */ "fill_opt ::=",
 /* 477 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 478 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 479 */ "fill_mode ::= NONE",
 /* 480 */ "fill_mode ::= PREV",
 /* 481 */ "fill_mode ::= NULL",
 /* 482 */ "fill_mode ::= LINEAR",
 /* 483 */ "fill_mode ::= NEXT",
 /* 484 */ "group_by_clause_opt ::=",
 /* 485 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 486 */ "group_by_list ::= expr_or_subquery",
 /* 487 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 488 */ "having_clause_opt ::=",
 /* 489 */ "having_clause_opt ::= HAVING search_condition",
 /* 490 */ "range_opt ::=",
 /* 491 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 492 */ "every_opt ::=",
 /* 493 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 494 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 495 */ "query_simple ::= query_specification",
 /* 496 */ "query_simple ::= union_query_expression",
 /* 497 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 498 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 499 */ "query_simple_or_subquery ::= query_simple",
 /* 500 */ "query_simple_or_subquery ::= subquery",
 /* 501 */ "query_or_subquery ::= query_expression",
 /* 502 */ "query_or_subquery ::= subquery",
 /* 503 */ "order_by_clause_opt ::=",
 /* 504 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 505 */ "slimit_clause_opt ::=",
 /* 506 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 507 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 508 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 509 */ "limit_clause_opt ::=",
 /* 510 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 511 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 512 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 513 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 514 */ "subquery ::= NK_LP subquery NK_RP",
 /* 515 */ "search_condition ::= common_expression",
 /* 516 */ "sort_specification_list ::= sort_specification",
 /* 517 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 518 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 519 */ "ordering_specification_opt ::=",
 /* 520 */ "ordering_specification_opt ::= ASC",
 /* 521 */ "ordering_specification_opt ::= DESC",
 /* 522 */ "null_ordering_opt ::=",
 /* 523 */ "null_ordering_opt ::= NULLS FIRST",
 /* 524 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 317: /* cmd */
    case 320: /* literal */
    case 331: /* db_options */
    case 333: /* alter_db_options */
    case 339: /* retention */
    case 340: /* full_table_name */
    case 343: /* table_options */
    case 347: /* alter_table_clause */
    case 348: /* alter_table_options */
    case 351: /* signed_literal */
    case 352: /* create_subtable_clause */
    case 355: /* drop_table_clause */
    case 358: /* column_def */
    case 362: /* duration_literal */
    case 363: /* rollup_func_name */
    case 365: /* col_name */
    case 366: /* db_name_cond_opt */
    case 367: /* like_pattern_opt */
    case 368: /* table_name_cond */
    case 369: /* from_db_opt */
    case 370: /* index_options */
    case 372: /* sliding_opt */
    case 373: /* sma_stream_opt */
    case 374: /* func */
    case 375: /* stream_options */
    case 377: /* query_or_subquery */
    case 380: /* explain_options */
    case 384: /* subtable_opt */
    case 385: /* expression */
    case 387: /* where_clause_opt */
    case 388: /* signed */
    case 389: /* literal_func */
    case 393: /* expr_or_subquery */
    case 394: /* subquery */
    case 395: /* pseudo_column */
    case 396: /* column_reference */
    case 397: /* function_expression */
    case 398: /* case_when_expression */
    case 403: /* star_func_para */
    case 405: /* case_when_else_opt */
    case 406: /* common_expression */
    case 407: /* when_then_expr */
    case 408: /* predicate */
    case 411: /* in_predicate_value */
    case 412: /* boolean_value_expression */
    case 413: /* boolean_primary */
    case 414: /* from_clause_opt */
    case 415: /* table_reference_list */
    case 416: /* table_reference */
    case 417: /* table_primary */
    case 418: /* joined_table */
    case 420: /* parenthesized_joined_table */
    case 422: /* search_condition */
    case 423: /* query_specification */
    case 427: /* range_opt */
    case 428: /* every_opt */
    case 429: /* fill_opt */
    case 430: /* twindow_clause_opt */
    case 432: /* having_clause_opt */
    case 433: /* select_item */
    case 435: /* partition_item */
    case 438: /* query_expression */
    case 439: /* query_simple */
    case 441: /* slimit_clause_opt */
    case 442: /* limit_clause_opt */
    case 443: /* union_query_expression */
    case 444: /* query_simple_or_subquery */
    case 446: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy778)); 
}
      break;
    case 318: /* account_options */
    case 319: /* alter_account_options */
    case 321: /* alter_account_option */
    case 334: /* speed_opt */
    case 382: /* bufsize_opt */
{
 
}
      break;
    case 322: /* user_name */
    case 325: /* priv_level */
    case 328: /* db_name */
    case 329: /* dnode_endpoint */
    case 349: /* column_name */
    case 357: /* table_name */
    case 364: /* function_name */
    case 376: /* topic_name */
    case 378: /* cgroup_name */
    case 383: /* stream_name */
    case 391: /* table_alias */
    case 392: /* column_alias */
    case 399: /* star_func */
    case 401: /* noarg_func */
    case 419: /* alias_opt */
{
 
}
      break;
    case 323: /* sysinfo_opt */
{
 
}
      break;
    case 324: /* privileges */
    case 326: /* priv_type_list */
    case 327: /* priv_type */
{
 
}
      break;
    case 330: /* not_exists_opt */
    case 332: /* exists_opt */
    case 379: /* analyze_opt */
    case 381: /* agg_func_opt */
    case 424: /* set_quantifier_opt */
{
 
}
      break;
    case 335: /* integer_list */
    case 336: /* variable_list */
    case 337: /* retention_list */
    case 341: /* column_def_list */
    case 342: /* tags_def_opt */
    case 344: /* multi_create_clause */
    case 345: /* tags_def */
    case 346: /* multi_drop_clause */
    case 353: /* specific_cols_opt */
    case 354: /* expression_list */
    case 356: /* col_name_list */
    case 359: /* duration_list */
    case 360: /* rollup_func_list */
    case 371: /* func_list */
    case 386: /* dnode_list */
    case 390: /* literal_list */
    case 400: /* star_func_para_list */
    case 402: /* other_para_list */
    case 404: /* when_then_list */
    case 425: /* select_list */
    case 426: /* partition_by_clause_opt */
    case 431: /* group_by_clause_opt */
    case 434: /* partition_list */
    case 437: /* group_by_list */
    case 440: /* order_by_clause_opt */
    case 445: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy282)); 
}
      break;
    case 338: /* alter_db_option */
    case 361: /* alter_table_option */
{
 
}
      break;
    case 350: /* type_name */
{
 
}
      break;
    case 409: /* compare_op */
    case 410: /* in_op */
{
 
}
      break;
    case 421: /* join_type */
{
 
}
      break;
    case 436: /* fill_mode */
{
 
}
      break;
    case 447: /* ordering_specification_opt */
{
 
}
      break;
    case 448: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  317,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  317,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  318,    0 }, /* (2) account_options ::= */
  {  318,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  318,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  318,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  318,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  318,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  318,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  318,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  318,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  318,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  319,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  319,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  321,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  321,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  321,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  321,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  321,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  321,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  321,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  321,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  321,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  321,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  317,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  317,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  317,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  317,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  317,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  323,    0 }, /* (29) sysinfo_opt ::= */
  {  323,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  317,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  317,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  324,   -1 }, /* (33) privileges ::= ALL */
  {  324,   -1 }, /* (34) privileges ::= priv_type_list */
  {  326,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  326,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  327,   -1 }, /* (37) priv_type ::= READ */
  {  327,   -1 }, /* (38) priv_type ::= WRITE */
  {  325,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  325,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  317,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  317,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  317,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  317,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  317,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  317,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  317,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  317,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  329,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  329,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  329,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  317,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  317,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  317,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  317,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  317,   -2 }, /* (64) cmd ::= USE db_name */
  {  317,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  317,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  317,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  330,    0 }, /* (69) not_exists_opt ::= */
  {  332,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  332,    0 }, /* (71) exists_opt ::= */
  {  331,    0 }, /* (72) db_options ::= */
  {  331,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  331,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  331,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  331,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  331,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  331,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  331,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  331,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  331,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  331,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  331,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  331,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  331,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  331,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  331,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  331,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  331,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  331,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  331,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  331,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  331,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  331,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  331,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  331,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  331,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  333,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  333,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  338,   -2 }, /* (106) alter_db_option ::= BUFFER NK_INTEGER */
  {  338,   -2 }, /* (107) alter_db_option ::= CACHEMODEL NK_STRING */
  {  338,   -2 }, /* (108) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  338,   -2 }, /* (109) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -2 }, /* (110) alter_db_option ::= KEEP integer_list */
  {  338,   -2 }, /* (111) alter_db_option ::= KEEP variable_list */
  {  338,   -2 }, /* (112) alter_db_option ::= PAGES NK_INTEGER */
  {  338,   -2 }, /* (113) alter_db_option ::= REPLICA NK_INTEGER */
  {  338,   -2 }, /* (114) alter_db_option ::= STRICT NK_STRING */
  {  338,   -2 }, /* (115) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  338,   -2 }, /* (116) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  335,   -1 }, /* (117) integer_list ::= NK_INTEGER */
  {  335,   -3 }, /* (118) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  336,   -1 }, /* (119) variable_list ::= NK_VARIABLE */
  {  336,   -3 }, /* (120) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  337,   -1 }, /* (121) retention_list ::= retention */
  {  337,   -3 }, /* (122) retention_list ::= retention_list NK_COMMA retention */
  {  339,   -3 }, /* (123) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  334,    0 }, /* (124) speed_opt ::= */
  {  334,   -2 }, /* (125) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  317,   -9 }, /* (126) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  317,   -3 }, /* (127) cmd ::= CREATE TABLE multi_create_clause */
  {  317,   -9 }, /* (128) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  317,   -3 }, /* (129) cmd ::= DROP TABLE multi_drop_clause */
  {  317,   -4 }, /* (130) cmd ::= DROP STABLE exists_opt full_table_name */
  {  317,   -3 }, /* (131) cmd ::= ALTER TABLE alter_table_clause */
  {  317,   -3 }, /* (132) cmd ::= ALTER STABLE alter_table_clause */
  {  347,   -2 }, /* (133) alter_table_clause ::= full_table_name alter_table_options */
  {  347,   -5 }, /* (134) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  347,   -4 }, /* (135) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  347,   -5 }, /* (136) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  347,   -5 }, /* (137) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  347,   -5 }, /* (138) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  347,   -4 }, /* (139) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  347,   -5 }, /* (140) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  347,   -5 }, /* (141) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  347,   -6 }, /* (142) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  344,   -1 }, /* (143) multi_create_clause ::= create_subtable_clause */
  {  344,   -2 }, /* (144) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  352,  -10 }, /* (145) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  346,   -1 }, /* (146) multi_drop_clause ::= drop_table_clause */
  {  346,   -2 }, /* (147) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  355,   -2 }, /* (148) drop_table_clause ::= exists_opt full_table_name */
  {  353,    0 }, /* (149) specific_cols_opt ::= */
  {  353,   -3 }, /* (150) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  340,   -1 }, /* (151) full_table_name ::= table_name */
  {  340,   -3 }, /* (152) full_table_name ::= db_name NK_DOT table_name */
  {  341,   -1 }, /* (153) column_def_list ::= column_def */
  {  341,   -3 }, /* (154) column_def_list ::= column_def_list NK_COMMA column_def */
  {  358,   -2 }, /* (155) column_def ::= column_name type_name */
  {  358,   -4 }, /* (156) column_def ::= column_name type_name COMMENT NK_STRING */
  {  350,   -1 }, /* (157) type_name ::= BOOL */
  {  350,   -1 }, /* (158) type_name ::= TINYINT */
  {  350,   -1 }, /* (159) type_name ::= SMALLINT */
  {  350,   -1 }, /* (160) type_name ::= INT */
  {  350,   -1 }, /* (161) type_name ::= INTEGER */
  {  350,   -1 }, /* (162) type_name ::= BIGINT */
  {  350,   -1 }, /* (163) type_name ::= FLOAT */
  {  350,   -1 }, /* (164) type_name ::= DOUBLE */
  {  350,   -4 }, /* (165) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (166) type_name ::= TIMESTAMP */
  {  350,   -4 }, /* (167) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -2 }, /* (168) type_name ::= TINYINT UNSIGNED */
  {  350,   -2 }, /* (169) type_name ::= SMALLINT UNSIGNED */
  {  350,   -2 }, /* (170) type_name ::= INT UNSIGNED */
  {  350,   -2 }, /* (171) type_name ::= BIGINT UNSIGNED */
  {  350,   -1 }, /* (172) type_name ::= JSON */
  {  350,   -4 }, /* (173) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (174) type_name ::= MEDIUMBLOB */
  {  350,   -1 }, /* (175) type_name ::= BLOB */
  {  350,   -4 }, /* (176) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (177) type_name ::= DECIMAL */
  {  350,   -4 }, /* (178) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  350,   -6 }, /* (179) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  342,    0 }, /* (180) tags_def_opt ::= */
  {  342,   -1 }, /* (181) tags_def_opt ::= tags_def */
  {  345,   -4 }, /* (182) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  343,    0 }, /* (183) table_options ::= */
  {  343,   -3 }, /* (184) table_options ::= table_options COMMENT NK_STRING */
  {  343,   -3 }, /* (185) table_options ::= table_options MAX_DELAY duration_list */
  {  343,   -3 }, /* (186) table_options ::= table_options WATERMARK duration_list */
  {  343,   -5 }, /* (187) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  343,   -3 }, /* (188) table_options ::= table_options TTL NK_INTEGER */
  {  343,   -5 }, /* (189) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  348,   -1 }, /* (190) alter_table_options ::= alter_table_option */
  {  348,   -2 }, /* (191) alter_table_options ::= alter_table_options alter_table_option */
  {  361,   -2 }, /* (192) alter_table_option ::= COMMENT NK_STRING */
  {  361,   -2 }, /* (193) alter_table_option ::= TTL NK_INTEGER */
  {  359,   -1 }, /* (194) duration_list ::= duration_literal */
  {  359,   -3 }, /* (195) duration_list ::= duration_list NK_COMMA duration_literal */
  {  360,   -1 }, /* (196) rollup_func_list ::= rollup_func_name */
  {  360,   -3 }, /* (197) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  363,   -1 }, /* (198) rollup_func_name ::= function_name */
  {  363,   -1 }, /* (199) rollup_func_name ::= FIRST */
  {  363,   -1 }, /* (200) rollup_func_name ::= LAST */
  {  356,   -1 }, /* (201) col_name_list ::= col_name */
  {  356,   -3 }, /* (202) col_name_list ::= col_name_list NK_COMMA col_name */
  {  365,   -1 }, /* (203) col_name ::= column_name */
  {  317,   -2 }, /* (204) cmd ::= SHOW DNODES */
  {  317,   -2 }, /* (205) cmd ::= SHOW USERS */
  {  317,   -2 }, /* (206) cmd ::= SHOW DATABASES */
  {  317,   -4 }, /* (207) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  317,   -4 }, /* (208) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  317,   -3 }, /* (209) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  317,   -2 }, /* (210) cmd ::= SHOW MNODES */
  {  317,   -2 }, /* (211) cmd ::= SHOW QNODES */
  {  317,   -2 }, /* (212) cmd ::= SHOW FUNCTIONS */
  {  317,   -5 }, /* (213) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  317,   -2 }, /* (214) cmd ::= SHOW STREAMS */
  {  317,   -2 }, /* (215) cmd ::= SHOW ACCOUNTS */
  {  317,   -2 }, /* (216) cmd ::= SHOW APPS */
  {  317,   -2 }, /* (217) cmd ::= SHOW CONNECTIONS */
  {  317,   -2 }, /* (218) cmd ::= SHOW LICENCES */
  {  317,   -2 }, /* (219) cmd ::= SHOW GRANTS */
  {  317,   -4 }, /* (220) cmd ::= SHOW CREATE DATABASE db_name */
  {  317,   -4 }, /* (221) cmd ::= SHOW CREATE TABLE full_table_name */
  {  317,   -4 }, /* (222) cmd ::= SHOW CREATE STABLE full_table_name */
  {  317,   -2 }, /* (223) cmd ::= SHOW QUERIES */
  {  317,   -2 }, /* (224) cmd ::= SHOW SCORES */
  {  317,   -2 }, /* (225) cmd ::= SHOW TOPICS */
  {  317,   -2 }, /* (226) cmd ::= SHOW VARIABLES */
  {  317,   -3 }, /* (227) cmd ::= SHOW CLUSTER VARIABLES */
  {  317,   -3 }, /* (228) cmd ::= SHOW LOCAL VARIABLES */
  {  317,   -5 }, /* (229) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  317,   -2 }, /* (230) cmd ::= SHOW BNODES */
  {  317,   -2 }, /* (231) cmd ::= SHOW SNODES */
  {  317,   -2 }, /* (232) cmd ::= SHOW CLUSTER */
  {  317,   -2 }, /* (233) cmd ::= SHOW TRANSACTIONS */
  {  317,   -4 }, /* (234) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  317,   -2 }, /* (235) cmd ::= SHOW CONSUMERS */
  {  317,   -2 }, /* (236) cmd ::= SHOW SUBSCRIPTIONS */
  {  317,   -5 }, /* (237) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  317,   -6 }, /* (238) cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
  {  317,   -3 }, /* (239) cmd ::= SHOW VNODES NK_INTEGER */
  {  317,   -3 }, /* (240) cmd ::= SHOW VNODES NK_STRING */
  {  366,    0 }, /* (241) db_name_cond_opt ::= */
  {  366,   -2 }, /* (242) db_name_cond_opt ::= db_name NK_DOT */
  {  367,    0 }, /* (243) like_pattern_opt ::= */
  {  367,   -2 }, /* (244) like_pattern_opt ::= LIKE NK_STRING */
  {  368,   -1 }, /* (245) table_name_cond ::= table_name */
  {  369,    0 }, /* (246) from_db_opt ::= */
  {  369,   -2 }, /* (247) from_db_opt ::= FROM db_name */
  {  317,   -8 }, /* (248) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  317,   -4 }, /* (249) cmd ::= DROP INDEX exists_opt full_table_name */
  {  370,  -10 }, /* (250) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  370,  -12 }, /* (251) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  371,   -1 }, /* (252) func_list ::= func */
  {  371,   -3 }, /* (253) func_list ::= func_list NK_COMMA func */
  {  374,   -4 }, /* (254) func ::= function_name NK_LP expression_list NK_RP */
  {  373,    0 }, /* (255) sma_stream_opt ::= */
  {  373,   -3 }, /* (256) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  373,   -3 }, /* (257) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  317,   -6 }, /* (258) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  317,   -7 }, /* (259) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  317,   -9 }, /* (260) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  317,   -7 }, /* (261) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  317,   -9 }, /* (262) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  317,   -4 }, /* (263) cmd ::= DROP TOPIC exists_opt topic_name */
  {  317,   -7 }, /* (264) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  317,   -2 }, /* (265) cmd ::= DESC full_table_name */
  {  317,   -2 }, /* (266) cmd ::= DESCRIBE full_table_name */
  {  317,   -3 }, /* (267) cmd ::= RESET QUERY CACHE */
  {  317,   -4 }, /* (268) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  379,    0 }, /* (269) analyze_opt ::= */
  {  379,   -1 }, /* (270) analyze_opt ::= ANALYZE */
  {  380,    0 }, /* (271) explain_options ::= */
  {  380,   -3 }, /* (272) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  380,   -3 }, /* (273) explain_options ::= explain_options RATIO NK_FLOAT */
  {  317,  -10 }, /* (274) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  317,   -4 }, /* (275) cmd ::= DROP FUNCTION exists_opt function_name */
  {  381,    0 }, /* (276) agg_func_opt ::= */
  {  381,   -1 }, /* (277) agg_func_opt ::= AGGREGATE */
  {  382,    0 }, /* (278) bufsize_opt ::= */
  {  382,   -2 }, /* (279) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  317,  -11 }, /* (280) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  317,   -4 }, /* (281) cmd ::= DROP STREAM exists_opt stream_name */
  {  375,    0 }, /* (282) stream_options ::= */
  {  375,   -3 }, /* (283) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  375,   -3 }, /* (284) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  375,   -4 }, /* (285) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  375,   -3 }, /* (286) stream_options ::= stream_options WATERMARK duration_literal */
  {  375,   -4 }, /* (287) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  384,    0 }, /* (288) subtable_opt ::= */
  {  384,   -4 }, /* (289) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  317,   -3 }, /* (290) cmd ::= KILL CONNECTION NK_INTEGER */
  {  317,   -3 }, /* (291) cmd ::= KILL QUERY NK_STRING */
  {  317,   -3 }, /* (292) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  317,   -2 }, /* (293) cmd ::= BALANCE VGROUP */
  {  317,   -4 }, /* (294) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  317,   -4 }, /* (295) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  317,   -3 }, /* (296) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  386,   -2 }, /* (297) dnode_list ::= DNODE NK_INTEGER */
  {  386,   -3 }, /* (298) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  317,   -4 }, /* (299) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  317,   -1 }, /* (300) cmd ::= query_or_subquery */
  {  317,   -7 }, /* (301) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  317,   -4 }, /* (302) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  320,   -1 }, /* (303) literal ::= NK_INTEGER */
  {  320,   -1 }, /* (304) literal ::= NK_FLOAT */
  {  320,   -1 }, /* (305) literal ::= NK_STRING */
  {  320,   -1 }, /* (306) literal ::= NK_BOOL */
  {  320,   -2 }, /* (307) literal ::= TIMESTAMP NK_STRING */
  {  320,   -1 }, /* (308) literal ::= duration_literal */
  {  320,   -1 }, /* (309) literal ::= NULL */
  {  320,   -1 }, /* (310) literal ::= NK_QUESTION */
  {  362,   -1 }, /* (311) duration_literal ::= NK_VARIABLE */
  {  388,   -1 }, /* (312) signed ::= NK_INTEGER */
  {  388,   -2 }, /* (313) signed ::= NK_PLUS NK_INTEGER */
  {  388,   -2 }, /* (314) signed ::= NK_MINUS NK_INTEGER */
  {  388,   -1 }, /* (315) signed ::= NK_FLOAT */
  {  388,   -2 }, /* (316) signed ::= NK_PLUS NK_FLOAT */
  {  388,   -2 }, /* (317) signed ::= NK_MINUS NK_FLOAT */
  {  351,   -1 }, /* (318) signed_literal ::= signed */
  {  351,   -1 }, /* (319) signed_literal ::= NK_STRING */
  {  351,   -1 }, /* (320) signed_literal ::= NK_BOOL */
  {  351,   -2 }, /* (321) signed_literal ::= TIMESTAMP NK_STRING */
  {  351,   -1 }, /* (322) signed_literal ::= duration_literal */
  {  351,   -1 }, /* (323) signed_literal ::= NULL */
  {  351,   -1 }, /* (324) signed_literal ::= literal_func */
  {  351,   -1 }, /* (325) signed_literal ::= NK_QUESTION */
  {  390,   -1 }, /* (326) literal_list ::= signed_literal */
  {  390,   -3 }, /* (327) literal_list ::= literal_list NK_COMMA signed_literal */
  {  328,   -1 }, /* (328) db_name ::= NK_ID */
  {  357,   -1 }, /* (329) table_name ::= NK_ID */
  {  349,   -1 }, /* (330) column_name ::= NK_ID */
  {  364,   -1 }, /* (331) function_name ::= NK_ID */
  {  391,   -1 }, /* (332) table_alias ::= NK_ID */
  {  392,   -1 }, /* (333) column_alias ::= NK_ID */
  {  322,   -1 }, /* (334) user_name ::= NK_ID */
  {  376,   -1 }, /* (335) topic_name ::= NK_ID */
  {  383,   -1 }, /* (336) stream_name ::= NK_ID */
  {  378,   -1 }, /* (337) cgroup_name ::= NK_ID */
  {  393,   -1 }, /* (338) expr_or_subquery ::= expression */
  {  393,   -1 }, /* (339) expr_or_subquery ::= subquery */
  {  385,   -1 }, /* (340) expression ::= literal */
  {  385,   -1 }, /* (341) expression ::= pseudo_column */
  {  385,   -1 }, /* (342) expression ::= column_reference */
  {  385,   -1 }, /* (343) expression ::= function_expression */
  {  385,   -1 }, /* (344) expression ::= case_when_expression */
  {  385,   -3 }, /* (345) expression ::= NK_LP expression NK_RP */
  {  385,   -2 }, /* (346) expression ::= NK_PLUS expr_or_subquery */
  {  385,   -2 }, /* (347) expression ::= NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (348) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  385,   -3 }, /* (349) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (350) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  385,   -3 }, /* (351) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  385,   -3 }, /* (352) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  385,   -3 }, /* (353) expression ::= column_reference NK_ARROW NK_STRING */
  {  385,   -3 }, /* (354) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  385,   -3 }, /* (355) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  354,   -1 }, /* (356) expression_list ::= expr_or_subquery */
  {  354,   -3 }, /* (357) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  396,   -1 }, /* (358) column_reference ::= column_name */
  {  396,   -3 }, /* (359) column_reference ::= table_name NK_DOT column_name */
  {  395,   -1 }, /* (360) pseudo_column ::= ROWTS */
  {  395,   -1 }, /* (361) pseudo_column ::= TBNAME */
  {  395,   -3 }, /* (362) pseudo_column ::= table_name NK_DOT TBNAME */
  {  395,   -1 }, /* (363) pseudo_column ::= QSTART */
  {  395,   -1 }, /* (364) pseudo_column ::= QEND */
  {  395,   -1 }, /* (365) pseudo_column ::= QDURATION */
  {  395,   -1 }, /* (366) pseudo_column ::= WSTART */
  {  395,   -1 }, /* (367) pseudo_column ::= WEND */
  {  395,   -1 }, /* (368) pseudo_column ::= WDURATION */
  {  395,   -1 }, /* (369) pseudo_column ::= IROWTS */
  {  395,   -1 }, /* (370) pseudo_column ::= QTAGS */
  {  397,   -4 }, /* (371) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  397,   -4 }, /* (372) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  397,   -6 }, /* (373) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  397,   -1 }, /* (374) function_expression ::= literal_func */
  {  389,   -3 }, /* (375) literal_func ::= noarg_func NK_LP NK_RP */
  {  389,   -1 }, /* (376) literal_func ::= NOW */
  {  401,   -1 }, /* (377) noarg_func ::= NOW */
  {  401,   -1 }, /* (378) noarg_func ::= TODAY */
  {  401,   -1 }, /* (379) noarg_func ::= TIMEZONE */
  {  401,   -1 }, /* (380) noarg_func ::= DATABASE */
  {  401,   -1 }, /* (381) noarg_func ::= CLIENT_VERSION */
  {  401,   -1 }, /* (382) noarg_func ::= SERVER_VERSION */
  {  401,   -1 }, /* (383) noarg_func ::= SERVER_STATUS */
  {  401,   -1 }, /* (384) noarg_func ::= CURRENT_USER */
  {  401,   -1 }, /* (385) noarg_func ::= USER */
  {  399,   -1 }, /* (386) star_func ::= COUNT */
  {  399,   -1 }, /* (387) star_func ::= FIRST */
  {  399,   -1 }, /* (388) star_func ::= LAST */
  {  399,   -1 }, /* (389) star_func ::= LAST_ROW */
  {  400,   -1 }, /* (390) star_func_para_list ::= NK_STAR */
  {  400,   -1 }, /* (391) star_func_para_list ::= other_para_list */
  {  402,   -1 }, /* (392) other_para_list ::= star_func_para */
  {  402,   -3 }, /* (393) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  403,   -1 }, /* (394) star_func_para ::= expr_or_subquery */
  {  403,   -3 }, /* (395) star_func_para ::= table_name NK_DOT NK_STAR */
  {  398,   -4 }, /* (396) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  398,   -5 }, /* (397) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  404,   -1 }, /* (398) when_then_list ::= when_then_expr */
  {  404,   -2 }, /* (399) when_then_list ::= when_then_list when_then_expr */
  {  407,   -4 }, /* (400) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  405,    0 }, /* (401) case_when_else_opt ::= */
  {  405,   -2 }, /* (402) case_when_else_opt ::= ELSE common_expression */
  {  408,   -3 }, /* (403) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  408,   -5 }, /* (404) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -6 }, /* (405) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -3 }, /* (406) predicate ::= expr_or_subquery IS NULL */
  {  408,   -4 }, /* (407) predicate ::= expr_or_subquery IS NOT NULL */
  {  408,   -3 }, /* (408) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  409,   -1 }, /* (409) compare_op ::= NK_LT */
  {  409,   -1 }, /* (410) compare_op ::= NK_GT */
  {  409,   -1 }, /* (411) compare_op ::= NK_LE */
  {  409,   -1 }, /* (412) compare_op ::= NK_GE */
  {  409,   -1 }, /* (413) compare_op ::= NK_NE */
  {  409,   -1 }, /* (414) compare_op ::= NK_EQ */
  {  409,   -1 }, /* (415) compare_op ::= LIKE */
  {  409,   -2 }, /* (416) compare_op ::= NOT LIKE */
  {  409,   -1 }, /* (417) compare_op ::= MATCH */
  {  409,   -1 }, /* (418) compare_op ::= NMATCH */
  {  409,   -1 }, /* (419) compare_op ::= CONTAINS */
  {  410,   -1 }, /* (420) in_op ::= IN */
  {  410,   -2 }, /* (421) in_op ::= NOT IN */
  {  411,   -3 }, /* (422) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  412,   -1 }, /* (423) boolean_value_expression ::= boolean_primary */
  {  412,   -2 }, /* (424) boolean_value_expression ::= NOT boolean_primary */
  {  412,   -3 }, /* (425) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  412,   -3 }, /* (426) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  413,   -1 }, /* (427) boolean_primary ::= predicate */
  {  413,   -3 }, /* (428) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  406,   -1 }, /* (429) common_expression ::= expr_or_subquery */
  {  406,   -1 }, /* (430) common_expression ::= boolean_value_expression */
  {  414,    0 }, /* (431) from_clause_opt ::= */
  {  414,   -2 }, /* (432) from_clause_opt ::= FROM table_reference_list */
  {  415,   -1 }, /* (433) table_reference_list ::= table_reference */
  {  415,   -3 }, /* (434) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  416,   -1 }, /* (435) table_reference ::= table_primary */
  {  416,   -1 }, /* (436) table_reference ::= joined_table */
  {  417,   -2 }, /* (437) table_primary ::= table_name alias_opt */
  {  417,   -4 }, /* (438) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  417,   -2 }, /* (439) table_primary ::= subquery alias_opt */
  {  417,   -1 }, /* (440) table_primary ::= parenthesized_joined_table */
  {  419,    0 }, /* (441) alias_opt ::= */
  {  419,   -1 }, /* (442) alias_opt ::= table_alias */
  {  419,   -2 }, /* (443) alias_opt ::= AS table_alias */
  {  420,   -3 }, /* (444) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  420,   -3 }, /* (445) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  418,   -6 }, /* (446) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  421,    0 }, /* (447) join_type ::= */
  {  421,   -1 }, /* (448) join_type ::= INNER */
  {  423,  -12 }, /* (449) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  424,    0 }, /* (450) set_quantifier_opt ::= */
  {  424,   -1 }, /* (451) set_quantifier_opt ::= DISTINCT */
  {  424,   -1 }, /* (452) set_quantifier_opt ::= ALL */
  {  425,   -1 }, /* (453) select_list ::= select_item */
  {  425,   -3 }, /* (454) select_list ::= select_list NK_COMMA select_item */
  {  433,   -1 }, /* (455) select_item ::= NK_STAR */
  {  433,   -1 }, /* (456) select_item ::= common_expression */
  {  433,   -2 }, /* (457) select_item ::= common_expression column_alias */
  {  433,   -3 }, /* (458) select_item ::= common_expression AS column_alias */
  {  433,   -3 }, /* (459) select_item ::= table_name NK_DOT NK_STAR */
  {  387,    0 }, /* (460) where_clause_opt ::= */
  {  387,   -2 }, /* (461) where_clause_opt ::= WHERE search_condition */
  {  426,    0 }, /* (462) partition_by_clause_opt ::= */
  {  426,   -3 }, /* (463) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  434,   -1 }, /* (464) partition_list ::= partition_item */
  {  434,   -3 }, /* (465) partition_list ::= partition_list NK_COMMA partition_item */
  {  435,   -1 }, /* (466) partition_item ::= expr_or_subquery */
  {  435,   -2 }, /* (467) partition_item ::= expr_or_subquery column_alias */
  {  435,   -3 }, /* (468) partition_item ::= expr_or_subquery AS column_alias */
  {  430,    0 }, /* (469) twindow_clause_opt ::= */
  {  430,   -6 }, /* (470) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  430,   -4 }, /* (471) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  430,   -6 }, /* (472) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  430,   -8 }, /* (473) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  372,    0 }, /* (474) sliding_opt ::= */
  {  372,   -4 }, /* (475) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  429,    0 }, /* (476) fill_opt ::= */
  {  429,   -4 }, /* (477) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  429,   -6 }, /* (478) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  436,   -1 }, /* (479) fill_mode ::= NONE */
  {  436,   -1 }, /* (480) fill_mode ::= PREV */
  {  436,   -1 }, /* (481) fill_mode ::= NULL */
  {  436,   -1 }, /* (482) fill_mode ::= LINEAR */
  {  436,   -1 }, /* (483) fill_mode ::= NEXT */
  {  431,    0 }, /* (484) group_by_clause_opt ::= */
  {  431,   -3 }, /* (485) group_by_clause_opt ::= GROUP BY group_by_list */
  {  437,   -1 }, /* (486) group_by_list ::= expr_or_subquery */
  {  437,   -3 }, /* (487) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  432,    0 }, /* (488) having_clause_opt ::= */
  {  432,   -2 }, /* (489) having_clause_opt ::= HAVING search_condition */
  {  427,    0 }, /* (490) range_opt ::= */
  {  427,   -6 }, /* (491) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  428,    0 }, /* (492) every_opt ::= */
  {  428,   -4 }, /* (493) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  438,   -4 }, /* (494) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  439,   -1 }, /* (495) query_simple ::= query_specification */
  {  439,   -1 }, /* (496) query_simple ::= union_query_expression */
  {  443,   -4 }, /* (497) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  443,   -3 }, /* (498) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  444,   -1 }, /* (499) query_simple_or_subquery ::= query_simple */
  {  444,   -1 }, /* (500) query_simple_or_subquery ::= subquery */
  {  377,   -1 }, /* (501) query_or_subquery ::= query_expression */
  {  377,   -1 }, /* (502) query_or_subquery ::= subquery */
  {  440,    0 }, /* (503) order_by_clause_opt ::= */
  {  440,   -3 }, /* (504) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  441,    0 }, /* (505) slimit_clause_opt ::= */
  {  441,   -2 }, /* (506) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  441,   -4 }, /* (507) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  441,   -4 }, /* (508) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  442,    0 }, /* (509) limit_clause_opt ::= */
  {  442,   -2 }, /* (510) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  442,   -4 }, /* (511) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  442,   -4 }, /* (512) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  394,   -3 }, /* (513) subquery ::= NK_LP query_expression NK_RP */
  {  394,   -3 }, /* (514) subquery ::= NK_LP subquery NK_RP */
  {  422,   -1 }, /* (515) search_condition ::= common_expression */
  {  445,   -1 }, /* (516) sort_specification_list ::= sort_specification */
  {  445,   -3 }, /* (517) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  446,   -3 }, /* (518) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  447,    0 }, /* (519) ordering_specification_opt ::= */
  {  447,   -1 }, /* (520) ordering_specification_opt ::= ASC */
  {  447,   -1 }, /* (521) ordering_specification_opt ::= DESC */
  {  448,    0 }, /* (522) null_ordering_opt ::= */
  {  448,   -2 }, /* (523) null_ordering_opt ::= NULLS FIRST */
  {  448,   -2 }, /* (524) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,318,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,319,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,318,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,319,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,321,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy0, yymsp[0].minor.yy293); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy293 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy293 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy831 = yymsp[0].minor.yy831; }
  yymsp[0].minor.yy831 = yylhsminor.yy831;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy831 = yymsp[-2].minor.yy831 | yymsp[0].minor.yy831; }
  yymsp[-2].minor.yy831 = yylhsminor.yy831;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy181; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy181, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 328: /* db_name ::= NK_ID */ yytestcase(yyruleno==328);
      case 329: /* table_name ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* column_name ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* function_name ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* table_alias ::= NK_ID */ yytestcase(yyruleno==332);
      case 333: /* column_alias ::= NK_ID */ yytestcase(yyruleno==333);
      case 334: /* user_name ::= NK_ID */ yytestcase(yyruleno==334);
      case 335: /* topic_name ::= NK_ID */ yytestcase(yyruleno==335);
      case 336: /* stream_name ::= NK_ID */ yytestcase(yyruleno==336);
      case 337: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==337);
      case 377: /* noarg_func ::= NOW */ yytestcase(yyruleno==377);
      case 378: /* noarg_func ::= TODAY */ yytestcase(yyruleno==378);
      case 379: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==379);
      case 380: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==380);
      case 381: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==381);
      case 382: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==382);
      case 383: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==383);
      case 384: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==384);
      case 385: /* noarg_func ::= USER */ yytestcase(yyruleno==385);
      case 386: /* star_func ::= COUNT */ yytestcase(yyruleno==386);
      case 387: /* star_func ::= FIRST */ yytestcase(yyruleno==387);
      case 388: /* star_func ::= LAST */ yytestcase(yyruleno==388);
      case 389: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==389);
{ yylhsminor.yy181 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy39, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy276); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy39 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 269: /* analyze_opt ::= */ yytestcase(yyruleno==269);
      case 276: /* agg_func_opt ::= */ yytestcase(yyruleno==276);
      case 450: /* set_quantifier_opt ::= */ yytestcase(yyruleno==450);
{ yymsp[1].minor.yy39 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy39 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy778 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_KEEP, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_RETENTIONS, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy778 = createAlterDatabaseOptions(pCxt); yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yylhsminor.yy778, &yymsp[0].minor.yy645); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy778, &yymsp[0].minor.yy645); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 106: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= KEEP integer_list */
      case 111: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==111);
{ yymsp[-1].minor.yy645.type = DB_OPTION_KEEP; yymsp[-1].minor.yy645.pList = yymsp[0].minor.yy282; }
        break;
      case 112: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_PAGES; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy645.type = DB_OPTION_STRICT; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_WAL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 118: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 298: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==298);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 119: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy282 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 120: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 121: /* retention_list ::= retention */
      case 143: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==143);
      case 146: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==146);
      case 153: /* column_def_list ::= column_def */ yytestcase(yyruleno==153);
      case 196: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==196);
      case 201: /* col_name_list ::= col_name */ yytestcase(yyruleno==201);
      case 252: /* func_list ::= func */ yytestcase(yyruleno==252);
      case 326: /* literal_list ::= signed_literal */ yytestcase(yyruleno==326);
      case 392: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==392);
      case 398: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==398);
      case 453: /* select_list ::= select_item */ yytestcase(yyruleno==453);
      case 464: /* partition_list ::= partition_item */ yytestcase(yyruleno==464);
      case 516: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==516);
{ yylhsminor.yy282 = createNodeList(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 122: /* retention_list ::= retention_list NK_COMMA retention */
      case 154: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==154);
      case 197: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==197);
      case 202: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==202);
      case 253: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==253);
      case 327: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==327);
      case 393: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==393);
      case 454: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==454);
      case 465: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==465);
      case 517: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==517);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 123: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy778 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 124: /* speed_opt ::= */
      case 278: /* bufsize_opt ::= */ yytestcase(yyruleno==278);
{ yymsp[1].minor.yy276 = 0; }
        break;
      case 125: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 279: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==279);
{ yymsp[-1].minor.yy276 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 126: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 128: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==128);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-5].minor.yy778, yymsp[-3].minor.yy282, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 127: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 129: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 130: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 131: /* cmd ::= ALTER TABLE alter_table_clause */
      case 300: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==300);
{ pCxt->pRootNode = yymsp[0].minor.yy778; }
        break;
      case 132: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy778); }
        break;
      case 133: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy778 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 134: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 135: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 136: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 137: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 138: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 139: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 140: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 141: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 142: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy778 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy778, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 144: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 147: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==147);
      case 399: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==399);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy282 = yylhsminor.yy282;
        break;
      case 145: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy778 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy39, yymsp[-8].minor.yy778, yymsp[-6].minor.yy778, yymsp[-5].minor.yy282, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-9].minor.yy778 = yylhsminor.yy778;
        break;
      case 148: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy778 = createDropTableClause(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 149: /* specific_cols_opt ::= */
      case 180: /* tags_def_opt ::= */ yytestcase(yyruleno==180);
      case 462: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==462);
      case 484: /* group_by_clause_opt ::= */ yytestcase(yyruleno==484);
      case 503: /* order_by_clause_opt ::= */ yytestcase(yyruleno==503);
{ yymsp[1].minor.yy282 = NULL; }
        break;
      case 150: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 151: /* full_table_name ::= table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 152: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 155: /* column_def ::= column_name type_name */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380, NULL); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 156: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-2].minor.yy380, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 157: /* type_name ::= BOOL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 158: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 159: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 160: /* type_name ::= INT */
      case 161: /* type_name ::= INTEGER */ yytestcase(yyruleno==161);
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 162: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 163: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 164: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 165: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 167: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 169: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 170: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 171: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 172: /* type_name ::= JSON */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 173: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 174: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 175: /* type_name ::= BLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 176: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 178: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 179: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* tags_def_opt ::= tags_def */
      case 391: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==391);
{ yylhsminor.yy282 = yymsp[0].minor.yy282; }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 182: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 183: /* table_options ::= */
{ yymsp[1].minor.yy778 = createDefaultTableOptions(pCxt); }
        break;
      case 184: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 185: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 186: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 187: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 188: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 189: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_SMA, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 190: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy778 = createAlterTableOptions(pCxt); yylhsminor.yy778 = setTableOption(pCxt, yylhsminor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 191: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 192: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 193: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 194: /* duration_list ::= duration_literal */
      case 356: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==356);
{ yylhsminor.yy282 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 195: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 357: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==357);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 198: /* rollup_func_name ::= function_name */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 199: /* rollup_func_name ::= FIRST */
      case 200: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==200);
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 203: /* col_name ::= column_name */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 204: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 205: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 206: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 207: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 208: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 209: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy778, NULL, OP_TYPE_LIKE); }
        break;
      case 210: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 211: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 212: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 213: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 214: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 215: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 216: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 217: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW LICENCES */
      case 219: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==219);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 220: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 221: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 222: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 223: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 224: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 225: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 226: /* cmd ::= SHOW VARIABLES */
      case 227: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==227);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 228: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 229: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy778); }
        break;
      case 230: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 231: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 233: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 234: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 235: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 236: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 237: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 238: /* cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLE_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 239: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 240: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 241: /* db_name_cond_opt ::= */
      case 246: /* from_db_opt ::= */ yytestcase(yyruleno==246);
{ yymsp[1].minor.yy778 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 242: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy778 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 243: /* like_pattern_opt ::= */
      case 288: /* subtable_opt ::= */ yytestcase(yyruleno==288);
      case 401: /* case_when_else_opt ::= */ yytestcase(yyruleno==401);
      case 431: /* from_clause_opt ::= */ yytestcase(yyruleno==431);
      case 460: /* where_clause_opt ::= */ yytestcase(yyruleno==460);
      case 469: /* twindow_clause_opt ::= */ yytestcase(yyruleno==469);
      case 474: /* sliding_opt ::= */ yytestcase(yyruleno==474);
      case 476: /* fill_opt ::= */ yytestcase(yyruleno==476);
      case 488: /* having_clause_opt ::= */ yytestcase(yyruleno==488);
      case 490: /* range_opt ::= */ yytestcase(yyruleno==490);
      case 492: /* every_opt ::= */ yytestcase(yyruleno==492);
      case 505: /* slimit_clause_opt ::= */ yytestcase(yyruleno==505);
      case 509: /* limit_clause_opt ::= */ yytestcase(yyruleno==509);
{ yymsp[1].minor.yy778 = NULL; }
        break;
      case 244: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 245: /* table_name_cond ::= table_name */
{ yylhsminor.yy778 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 247: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy778 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 248: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy39, yymsp[-3].minor.yy778, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 249: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 250: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy778 = createIndexOption(pCxt, yymsp[-7].minor.yy282, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 251: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy778 = createIndexOption(pCxt, yymsp[-9].minor.yy282, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 254: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 255: /* sma_stream_opt ::= */
      case 282: /* stream_options ::= */ yytestcase(yyruleno==282);
{ yymsp[1].minor.yy778 = createStreamOptions(pCxt); }
        break;
      case 256: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 286: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==286);
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 257: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 258: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 259: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy181, false); }
        break;
      case 260: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[0].minor.yy181, true); }
        break;
      case 261: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, yymsp[0].minor.yy778, false); }
        break;
      case 262: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, yymsp[0].minor.yy778, true); }
        break;
      case 263: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 264: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 265: /* cmd ::= DESC full_table_name */
      case 266: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==266);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 267: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 268: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy39, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 270: /* analyze_opt ::= ANALYZE */
      case 277: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==277);
      case 451: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==451);
{ yymsp[0].minor.yy39 = true; }
        break;
      case 271: /* explain_options ::= */
{ yymsp[1].minor.yy778 = createDefaultExplainOptions(pCxt); }
        break;
      case 272: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy778 = setExplainVerbose(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 273: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy778 = setExplainRatio(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 274: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-8].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy380, yymsp[0].minor.yy276); }
        break;
      case 275: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 280: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy39, &yymsp[-7].minor.yy181, yymsp[-4].minor.yy778, yymsp[-6].minor.yy778, yymsp[-3].minor.yy282, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 281: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 283: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 284: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 285: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 287: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 289: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 475: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==475);
      case 493: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==493);
{ yymsp[-3].minor.yy778 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy778); }
        break;
      case 290: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 291: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 292: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 293: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 294: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 295: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy282); }
        break;
      case 296: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 297: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 299: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 301: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy778, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 302: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 303: /* literal ::= NK_INTEGER */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 304: /* literal ::= NK_FLOAT */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 305: /* literal ::= NK_STRING */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 306: /* literal ::= NK_BOOL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 307: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 308: /* literal ::= duration_literal */
      case 318: /* signed_literal ::= signed */ yytestcase(yyruleno==318);
      case 338: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==338);
      case 339: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==339);
      case 340: /* expression ::= literal */ yytestcase(yyruleno==340);
      case 341: /* expression ::= pseudo_column */ yytestcase(yyruleno==341);
      case 342: /* expression ::= column_reference */ yytestcase(yyruleno==342);
      case 343: /* expression ::= function_expression */ yytestcase(yyruleno==343);
      case 344: /* expression ::= case_when_expression */ yytestcase(yyruleno==344);
      case 374: /* function_expression ::= literal_func */ yytestcase(yyruleno==374);
      case 423: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==423);
      case 427: /* boolean_primary ::= predicate */ yytestcase(yyruleno==427);
      case 429: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==429);
      case 430: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==430);
      case 433: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==433);
      case 435: /* table_reference ::= table_primary */ yytestcase(yyruleno==435);
      case 436: /* table_reference ::= joined_table */ yytestcase(yyruleno==436);
      case 440: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==440);
      case 495: /* query_simple ::= query_specification */ yytestcase(yyruleno==495);
      case 496: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==496);
      case 499: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==499);
      case 501: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==501);
{ yylhsminor.yy778 = yymsp[0].minor.yy778; }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 309: /* literal ::= NULL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 310: /* literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 311: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 312: /* signed ::= NK_INTEGER */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 313: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 314: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 315: /* signed ::= NK_FLOAT */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 316: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 317: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 319: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 320: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 321: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 322: /* signed_literal ::= duration_literal */
      case 324: /* signed_literal ::= literal_func */ yytestcase(yyruleno==324);
      case 394: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==394);
      case 456: /* select_item ::= common_expression */ yytestcase(yyruleno==456);
      case 466: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==466);
      case 500: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==500);
      case 502: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==502);
      case 515: /* search_condition ::= common_expression */ yytestcase(yyruleno==515);
{ yylhsminor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 323: /* signed_literal ::= NULL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 325: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 345: /* expression ::= NK_LP expression NK_RP */
      case 428: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==428);
      case 514: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==514);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 346: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy778));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 347: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 348: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 349: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 350: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 351: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 352: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 353: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 354: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 355: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 358: /* column_reference ::= column_name */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy181, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 359: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 360: /* pseudo_column ::= ROWTS */
      case 361: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==361);
      case 363: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==363);
      case 364: /* pseudo_column ::= QEND */ yytestcase(yyruleno==364);
      case 365: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==365);
      case 366: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==366);
      case 367: /* pseudo_column ::= WEND */ yytestcase(yyruleno==367);
      case 368: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==368);
      case 369: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==369);
      case 370: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==370);
      case 376: /* literal_func ::= NOW */ yytestcase(yyruleno==376);
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 362: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy181)))); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 371: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 372: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==372);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 373: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy380)); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 375: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy181, NULL)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 390: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy282 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 395: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 459: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==459);
{ yylhsminor.yy778 = createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 396: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 397: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 400: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy778 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
        break;
      case 402: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
        break;
      case 403: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 408: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==408);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy682, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 404: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 405: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 406: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), NULL));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 407: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL));
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 409: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_THAN; }
        break;
      case 410: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_THAN; }
        break;
      case 411: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 412: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 413: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy682 = OP_TYPE_NOT_EQUAL; }
        break;
      case 414: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy682 = OP_TYPE_EQUAL; }
        break;
      case 415: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy682 = OP_TYPE_LIKE; }
        break;
      case 416: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_LIKE; }
        break;
      case 417: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_MATCH; }
        break;
      case 418: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_NMATCH; }
        break;
      case 419: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy682 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 420: /* in_op ::= IN */
{ yymsp[0].minor.yy682 = OP_TYPE_IN; }
        break;
      case 421: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_IN; }
        break;
      case 422: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 424: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 425: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 426: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 432: /* from_clause_opt ::= FROM table_reference_list */
      case 461: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==461);
      case 489: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==489);
{ yymsp[-1].minor.yy778 = yymsp[0].minor.yy778; }
        break;
      case 434: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 437: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 438: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 439: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy778 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 441: /* alias_opt ::= */
{ yymsp[1].minor.yy181 = nil_token;  }
        break;
      case 442: /* alias_opt ::= table_alias */
{ yylhsminor.yy181 = yymsp[0].minor.yy181; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 443: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy181 = yymsp[0].minor.yy181; }
        break;
      case 444: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 445: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==445);
{ yymsp[-2].minor.yy778 = yymsp[-1].minor.yy778; }
        break;
      case 446: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, yymsp[-4].minor.yy202, yymsp[-5].minor.yy778, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 447: /* join_type ::= */
{ yymsp[1].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 448: /* join_type ::= INNER */
{ yymsp[0].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 449: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy778 = createSelectStmt(pCxt, yymsp[-10].minor.yy39, yymsp[-9].minor.yy282, yymsp[-8].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addWhereClause(pCxt, yymsp[-11].minor.yy778, yymsp[-7].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addPartitionByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-6].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy778, yymsp[-2].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addGroupByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-1].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addHavingClause(pCxt, yymsp[-11].minor.yy778, yymsp[0].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addRangeClause(pCxt, yymsp[-11].minor.yy778, yymsp[-5].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addEveryClause(pCxt, yymsp[-11].minor.yy778, yymsp[-4].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addFillClause(pCxt, yymsp[-11].minor.yy778, yymsp[-3].minor.yy778);
                                                                                  }
        break;
      case 452: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy39 = false; }
        break;
      case 455: /* select_item ::= NK_STAR */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 457: /* select_item ::= common_expression column_alias */
      case 467: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==467);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 458: /* select_item ::= common_expression AS column_alias */
      case 468: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==468);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 463: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 485: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==485);
      case 504: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==504);
{ yymsp[-2].minor.yy282 = yymsp[0].minor.yy282; }
        break;
      case 470: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy778 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 471: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy778 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 472: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 473: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 477: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy778 = createFillNode(pCxt, yymsp[-1].minor.yy381, NULL); }
        break;
      case 478: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy778 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
        break;
      case 479: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy381 = FILL_MODE_NONE; }
        break;
      case 480: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy381 = FILL_MODE_PREV; }
        break;
      case 481: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy381 = FILL_MODE_NULL; }
        break;
      case 482: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy381 = FILL_MODE_LINEAR; }
        break;
      case 483: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy381 = FILL_MODE_NEXT; }
        break;
      case 486: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy282 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 487: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 491: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy778 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 494: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy778 = addOrderByClause(pCxt, yymsp[-3].minor.yy778, yymsp[-2].minor.yy282);
                                                                                    yylhsminor.yy778 = addSlimitClause(pCxt, yylhsminor.yy778, yymsp[-1].minor.yy778);
                                                                                    yylhsminor.yy778 = addLimitClause(pCxt, yylhsminor.yy778, yymsp[0].minor.yy778);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 497: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 498: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 506: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 510: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==510);
{ yymsp[-1].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 507: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 511: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==511);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 508: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 512: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==512);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 513: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 518: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy778 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), yymsp[-1].minor.yy14, yymsp[0].minor.yy305); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 519: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 520: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 521: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 522: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy305 = NULL_ORDER_DEFAULT; }
        break;
      case 523: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_FIRST; }
        break;
      case 524: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
