/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 471
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNode* yy140;
  EFillMode yy174;
  int32_t yy214;
  SNodeList* yy220;
  int64_t yy303;
  bool yy587;
  SDataType yy682;
  ENullOrder yy697;
  EOperatorType yy794;
  SAlterOption yy809;
  EJoinType yy852;
  int8_t yy857;
  EOrder yy866;
  SToken yy881;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             752
#define YYNRULE              572
#define YYNTOKEN             328
#define YY_MAX_SHIFT         751
#define YY_MIN_SHIFTREDUCE   1118
#define YY_MAX_SHIFTREDUCE   1689
#define YY_ERROR_ACTION      1690
#define YY_ACCEPT_ACTION     1691
#define YY_NO_ACTION         1692
#define YY_MIN_REDUCE        1693
#define YY_MAX_REDUCE        2264
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2669)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1975, 1845,  387, 2076,  429,  604,  627, 2062,  141, 2235,
 /*    10 */   161, 2135,   45,   43, 1617, 1973,  628,  363, 2058, 1858,
 /*    20 */   384, 2062, 1466,  616,  603,  182, 1907, 2062,  496, 2236,
 /*    30 */   605, 2030, 2058, 1547,  492, 1464, 2094,  640, 2058,   44,
 /*    40 */    42,   41,   40,   39,  619, 1170,  332, 1169,  640, 2044,
 /*    50 */  1491,  657, 2054, 2060,  365,  506,  139, 1968, 1542, 1909,
 /*    60 */   222, 2240, 1909,  651,   18, 2235, 2054, 2060,  366,  349,
 /*    70 */  1691, 1472, 2054, 2060,  379, 1908, 1171,  651, 1907,  404,
 /*    80 */  2075, 2239,  176,  651, 2111, 2236, 2238,  109, 2077,  661,
 /*    90 */  2079, 2080,  656, 1151,  651,  166,  167,  748, 1705,  179,
 /*   100 */    14, 2164, 1801,  351, 1958,  378, 2160, 1491,   38,   37,
 /*   110 */    45,   43,   44,   42,   41,   40,   39,   48,  384,  184,
 /*   120 */  1466,  269, 2172,  615,  176,  133,  614, 2190,   48, 2235,
 /*   130 */    61, 1547, 1153, 1464, 1156, 1157, 1549, 1550,  397,  604,
 /*   140 */   622,   31,  396, 2235,  603,  182, 1959,   38,   37, 2236,
 /*   150 */   605,   44,   42,   41,   40,   39, 1542,  389,  603,  182,
 /*   160 */  1902, 1904,   18, 2236,  605, 1492, 1522, 1532, 1716, 1472,
 /*   170 */  1759,  122, 1548, 1551,  121,  120,  119,  118,  117,  116,
 /*   180 */   115,  114,  113,  579, 1975,  579, 1467, 2235, 1465, 2235,
 /*   190 */   490, 1493,  491, 1729,   65,  748,  375, 1239,   14, 1972,
 /*   200 */   628,  105, 2241,  182, 2241,  182,  640, 2236,  605, 2236,
 /*   210 */   605,  102, 1470, 1471, 2044, 1521, 1524, 1525, 1526, 1527,
 /*   220 */  1528, 1529, 1530, 1531,  653,  649, 1540, 1541, 1543, 1544,
 /*   230 */  1545, 1546,    2, 1241, 1549, 1550,  725,  724,  723,  722,
 /*   240 */   394,  626,  721,  720,  143,  715,  714,  713,  712,  711,
 /*   250 */   710,  709,  156,  705,  704,  703,  393,  392,  700,  699,
 /*   260 */   698,  697,  696, 2240, 1522, 1532, 1715, 2235,   38,   37,
 /*   270 */  1548, 1551,   44,   42,   41,   40,   39,  185, 1686,  185,
 /*   280 */  1494, 1330, 1331, 2239, 1467,  693, 1465, 2236, 2237,  508,
 /*   290 */    61, 1847,  489,   38,   37,  494, 1735,   44,   42,   41,
 /*   300 */    40,   39, 2058,  154,  153,  690,  689,  688,  151,  599,
 /*   310 */  1470, 1471, 2044, 1521, 1524, 1525, 1526, 1527, 1528, 1529,
 /*   320 */  1530, 1531,  653,  649, 1540, 1541, 1543, 1544, 1545, 1546,
 /*   330 */     2,   11,   45,   43, 1762, 1491, 2054, 2060, 1909,  271,
 /*   340 */   384, 1296, 1466, 1492,  695,  362, 1170,  651, 1169,  344,
 /*   350 */   594,  106,  194, 1547, 1907, 1464,  100, 1287,  683,  682,
 /*   360 */   681, 1291,  680, 1293, 1294,  679,  676,  140, 1302,  673,
 /*   370 */  1304, 1305,  670,  667, 1685, 1848,   33, 1171, 1542, 1833,
 /*   380 */  1849, 2076,   38,   37,   18,  568,   44,   42,   41,   40,
 /*   390 */    39, 1472, 1490,   83, 1576, 1645,   82,  545,  544,  543,
 /*   400 */   545,  544,  543, 1714,  535,  136,  539,  535,  136,  539,
 /*   410 */   538,   35,  290,  538, 2094,  537,  542,  748,  537,  542,
 /*   420 */    14,  536,  658,  499,  536,  491, 1729, 2044,  249,  657,
 /*   430 */    45,   43, 1552,  600,  595,  588,   86, 2179,  384,  185,
 /*   440 */  1466, 1250,  591,  590, 1643, 1644, 1646, 1647, 1648, 2044,
 /*   450 */  1577, 1547,  353, 1464, 1249,  641, 1549, 1550, 2075, 1402,
 /*   460 */  1403, 1851, 2111, 2176,  533,  109, 2077,  661, 2079, 2080,
 /*   470 */   656,  187,  651, 1694,  641,  142, 1542,  149, 2135, 2164,
 /*   480 */    61, 1385, 1386,  378, 2160,  532, 1522, 1532, 1856, 1472,
 /*   490 */    54,  693, 1548, 1551,  122, 1401, 1404,  121,  120,  119,
 /*   500 */   118,  117,  116,  115,  114,  113, 1467, 1856, 1465,  154,
 /*   510 */   153,  690,  689,  688,  151,  748,  476,  239,   46,  467,
 /*   520 */    49,   34,  382, 1571, 1572, 1573, 1574, 1575, 1579, 1580,
 /*   530 */  1581, 1582, 1470, 1471, 1693, 1521, 1524, 1525, 1526, 1527,
 /*   540 */  1528, 1529, 1530, 1531,  653,  649, 1540, 1541, 1543, 1544,
 /*   550 */  1545, 1546,    2,  423, 1549, 1550, 1472,  422,  131,  130,
 /*   560 */   129,  128,  127,  126,  125,  124,  123,  272,  498,   38,
 /*   570 */    37,  494, 1735,   44,   42,   41,   40,   39,  164, 2076,
 /*   580 */   198,  197, 1440, 1441, 1522, 1532,  616, 1859,   38,   37,
 /*   590 */  1548, 1551,   44,   42,   41,   40,   39, 2240,  579,  686,
 /*   600 */  1909,   86, 2235,  466, 1467, 2094, 1465,  372,  643,   61,
 /*   610 */  2136,   92, 2094,  598, 1493,  178, 1907, 2241,  182,  139,
 /*   620 */   619, 1831, 2236,  605,   27, 2044, 1852,  657, 1896,  185,
 /*   630 */  1470, 1471,  416, 1521, 1524, 1525, 1526, 1527, 1528, 1529,
 /*   640 */  1530, 1531,  653,  649, 1540, 1541, 1543, 1544, 1545, 1546,
 /*   650 */     2,   45,   43, 2037,  418,  414, 2075,  641,  597,  384,
 /*   660 */  2111, 1466, 1656,  109, 2077,  661, 2079, 2080,  656,  185,
 /*   670 */   651,  641, 1547,  132, 1464,  179,  641, 2164, 1903, 1904,
 /*   680 */   529,  378, 2160,  618,  180, 2172, 2173,  132,  137, 2177,
 /*   690 */  1856,  550,  427, 2179,  534, 1679, 2076, 1542,  579,   73,
 /*   700 */  1713,  616, 2235, 2191, 1856,  641,  560,   38,   37, 1856,
 /*   710 */  1472,   44,   42,   41,   40,   39,  627, 2241,  182, 2175,
 /*   720 */   236,  428, 2236,  605,   41,   40,   39,  641,  238, 2094,
 /*   730 */   616,  641,  237,  693,  139,  553,  748,  658, 1856,   46,
 /*   740 */   547,   11, 2044,  437,  657,  235, 2044,  452,   81,   45,
 /*   750 */    43,  154,  153,  690,  689,  688,  151,  384,  185, 1466,
 /*   760 */  1856,  376,  271,  139, 1856,  625,  627, 1968, 2063,  164,
 /*   770 */  1547, 2038, 1464, 2075,  707, 1549, 1550, 2111, 1858, 2058,
 /*   780 */   168, 2077,  661, 2079, 2080,  656,   69,  651, 1841,   68,
 /*   790 */    89,  339, 1712,  641,  361, 1542,  561, 1711, 2076,  181,
 /*   800 */  2172, 2173,  387,  137, 2177, 1522, 1532, 1954, 1472,  453,
 /*   810 */   164, 1548, 1551, 2054, 2060,  636,  579, 1968,  190, 1858,
 /*   820 */  2235,  580, 2201, 1939,  651, 1467, 1856, 1465,  183, 2172,
 /*   830 */  2173, 2094,  137, 2177,  748, 2241,  182,   14, 2044,  658,
 /*   840 */  2236,  605, 1621, 2044, 2044, 1710,  657, 1557, 1491, 1709,
 /*   850 */  2179, 1470, 1471, 1491, 1521, 1524, 1525, 1526, 1527, 1528,
 /*   860 */  1529, 1530, 1531,  653,  649, 1540, 1541, 1543, 1544, 1545,
 /*   870 */  1546,    2, 1843, 1549, 1550, 2075, 2174,  559, 1708, 2111,
 /*   880 */  1839,  641,  109, 2077,  661, 2079, 2080,  656,  165,  651,
 /*   890 */   557, 2044,  555,  310, 2139, 2044, 2164,  507,  685, 1909,
 /*   900 */   378, 2160, 1707, 1522, 1532, 1704,  377,  308,   72, 1548,
 /*   910 */  1551,   71,   38,   37, 1856, 1907,   44,   42,   41,   40,
 /*   920 */    39,  281,  282, 1467, 2044, 1465,  280,  356,  390,  205,
 /*   930 */   486,  484,  481,    8,   38,   37,  164, 2239,   44,   42,
 /*   940 */    41,   40,   39, 1703, 2076, 1858,  541,  540, 2044, 1470,
 /*   950 */  1471, 2044, 1521, 1524, 1525, 1526, 1527, 1528, 1529, 1530,
 /*   960 */  1531,  653,  649, 1540, 1541, 1543, 1544, 1545, 1546,    2,
 /*   970 */    61,  335, 1909, 1489, 2076,  719,  717, 2094,  447,  388,
 /*   980 */   460,  641, 1614,  474,  641,  658,  473,  446, 1907, 2044,
 /*   990 */  2044, 1254,  657,  357, 1523,  355,  354, 1853,  531, 1523,
 /*  1000 */   241,  443,  533,  475, 1253, 1633,  445, 2094,  108,  244,
 /*  1010 */   641,  641,  373, 1832, 1856,  658,   11, 1856,    9, 1491,
 /*  1020 */  2044, 2075,  657,  532,  652, 2111,  575,  620,  109, 2077,
 /*  1030 */   661, 2079, 2080,  656,  708,  651, 1818, 1702, 1701,   61,
 /*  1040 */  2255, 1494, 2164, 1856, 1856, 1700,  378, 2160,   80,   79,
 /*  1050 */   426, 2075,  352,  189,  641, 2111, 1494, 2198,  327, 2077,
 /*  1060 */   661, 2079, 2080,  656,  433,  651,  478,   13,   12, 1466,
 /*  1070 */   624, 1699,  333, 1749, 1578,  412,  695,  410,  406,  402,
 /*  1080 */   399,  419, 1464, 2044, 2044, 1698, 1697, 1856, 1696, 2076,
 /*  1090 */   645, 2044, 2136,  471,  163,  546,  465,  464,  463,  462,
 /*  1100 */   459,  458,  457,  456,  455,  451,  450,  449,  448,  334,
 /*  1110 */   440,  439,  438,  641,  435,  434,  350, 2044, 1472,  185,
 /*  1120 */   641,  608, 2094,  641,  421,  641,  420,  641,  574,  285,
 /*  1130 */   658, 2044, 2044,  152, 2044, 2044,  638,  657, 2076,  639,
 /*  1140 */  1954,  291, 1610,  391,  748,   32, 1856, 2012, 1954,  304,
 /*  1150 */   419,  192, 1886, 1856,  687, 1583, 1856, 1900, 1856,  196,
 /*  1160 */  1856, 1156, 1157, 2184, 1610, 1523, 2075, 1590, 1834,  691,
 /*  1170 */  2111, 2094, 1900,  109, 2077,  661, 2079, 2080,  656,  658,
 /*  1180 */   651,   51,  611,    3, 2044, 2255,  657, 2164,  185,  191,
 /*  1190 */    53,  378, 2160,  240,  430,  692, 1742, 2076, 1900,  145,
 /*  1200 */   152,  134, 2211,  607,  248,  228,  230,  431,  226,  229,
 /*  1210 */   232,  234,  147,  231,  233, 2075, 1688, 1689,  548, 2111,
 /*  1220 */  2076,  247,  109, 2077,  661, 2079, 2080,  656, 1613,  651,
 /*  1230 */  2094, 1802,  152, 1467, 2255, 1465, 2164,  563,  658,  562,
 /*  1240 */   378, 2160, 1740, 2044, 1475,  657,   63,  578,   13,   12,
 /*  1250 */  1706,  586, 2204, 2094,  648,   63,  253, 1435,  701, 1470,
 /*  1260 */  1471,  658,  266,  152,  551,   90, 2044,  592,  657,   47,
 /*  1270 */   278,   70,  150,  152, 2075,   63, 1474,   47, 2111,   47,
 /*  1280 */  1219,  109, 2077,  661, 2079, 2080,  656, 2065,  651, 1438,
 /*  1290 */   665,  221,  150, 2255,  152, 2164,  135, 2075, 2076,  378,
 /*  1300 */  2160, 2111,  150, 1642,  109, 2077,  661, 2079, 2080,  656,
 /*  1310 */  2229,  651, 1641,  255,  381,  380, 2255,  395, 2164,   52,
 /*  1320 */   623, 1736,  378, 2160, 1480, 1200, 1399,  283,  633,  287,
 /*  1330 */  1280, 2094, 1584, 2183, 1533, 1547,  303, 1473,  260,  658,
 /*  1340 */  2067,  702, 1963,  223, 2044, 2095,  657, 1308,  609, 1312,
 /*  1350 */  1730, 1319, 2194, 1317,  617, 1897,  265, 2076,  171,  155,
 /*  1360 */  1542, 1201,  268, 1217,  525,  521,  517,  513,  220,    1,
 /*  1370 */   743,    4,  398, 1472,  403, 2075, 1422,  348,  298, 2111,
 /*  1380 */  2076,  195,  109, 2077,  661, 2079, 2080,  656,  432,  651,
 /*  1390 */  2094, 1494, 1964,  436, 2137,  469, 2164, 1478,  658,  647,
 /*  1400 */   378, 2160, 1568, 2044,  441,  657, 1489,  454, 1956,   87,
 /*  1410 */   468,  612,  218, 2094,  461,  470,  479,  477,  200,  480,
 /*  1420 */   199,  658,  483,  482,  202,  485, 2044,  566,  657, 1477,
 /*  1430 */   487, 1495,  488,  497, 2075, 1497, 1492,  500, 2111,  208,
 /*  1440 */   501,  109, 2077,  661, 2079, 2080,  656, 1496,  651,  210,
 /*  1450 */   502, 1498,  503,  644,  213, 2164,  215, 2075,  505,  378,
 /*  1460 */  2160, 2111, 2076,  509,  110, 2077,  661, 2079, 2080,  656,
 /*  1470 */    84,  651,  579,   85,  219, 1173, 2235,  526, 2164,  217,
 /*  1480 */   211,  528, 2163, 2160,  216,  527,  504,  530, 1481,  111,
 /*  1490 */  1476, 2241,  182,  338, 1846, 2094, 2236,  605,  225, 2021,
 /*  1500 */  1842,  227,  209,  658,  157,  158, 1844,  565, 2044, 1840,
 /*  1510 */   657, 2076,  567,  159, 1484, 1486,  160,   88,  148,  242,
 /*  1520 */   299, 2018,  569, 2017,  245,  576,  573,  649, 1540, 1541,
 /*  1530 */  1543, 1544, 1545, 1546, 2076,  570,  583,  593, 2210, 2075,
 /*  1540 */  2195, 2205,  631, 2111, 2094,  602,  110, 2077,  661, 2079,
 /*  1550 */  2080,  656,  658,  651,  251,  589,  254, 2044,    7,  657,
 /*  1560 */  2164,  367,  596, 2209,  646, 2160,  172, 2094, 2186,  584,
 /*  1570 */   582,  261,  259, 2258,  263,  655,  262,  581, 1610,  264,
 /*  1580 */  2044,  613,  657,  368,  610,  138, 1493, 2180,  659,  371,
 /*  1590 */   621, 1499, 2111,  300, 1969,  110, 2077,  661, 2079, 2080,
 /*  1600 */   656,  629,  651,  273,   95,  634, 2076,  301,   97, 2164,
 /*  1610 */   635, 2075,   99,  343, 2160, 2111,  630,   60,  326, 2077,
 /*  1620 */   661, 2079, 2080,  656,  654,  651,  642, 2129,  267, 2076,
 /*  1630 */  2234, 1983, 1982, 1981,  374, 1857,  302, 2145,  101, 2094,
 /*  1640 */   663, 1901, 1819,  751,  305,  744,  745,  658,  747,  314,
 /*  1650 */   294,  328, 2044,  318,  657,  307,  309,  297,   50,  340,
 /*  1660 */   341, 2036, 2094, 2076, 2035, 2034,  329,   77, 2031,  400,
 /*  1670 */   658,  401,  175, 1457, 1458, 2044,  188,  657,  741,  737,
 /*  1680 */   733,  729,  295, 2075,  405, 2029,  407, 2111,  408, 2076,
 /*  1690 */   169, 2077,  661, 2079, 2080,  656, 2094,  651,  409, 2028,
 /*  1700 */   411, 2027,  413, 2026,  658,  415, 2075, 2025,  417, 2044,
 /*  1710 */  2111,  657,   78,  110, 2077,  661, 2079, 2080,  656, 1425,
 /*  1720 */   651, 1424, 2094,  107, 1995, 1994,  288, 2164, 1993,  424,
 /*  1730 */   658,  425, 2161, 1992, 1991, 2044, 1376,  657, 1947, 1946,
 /*  1740 */  2075, 1944,  606, 2256, 2111, 1943,  144,  168, 2077,  661,
 /*  1750 */  2079, 2080,  656, 2076,  651, 1942, 1945, 1941,  637,  193,
 /*  1760 */  1935,  442,  444, 1949, 1934, 1933, 2075, 1940, 1938, 1937,
 /*  1770 */  2111, 1936, 1932,  320, 2077,  661, 2079, 2080,  656, 1931,
 /*  1780 */   651, 1930, 1929, 1928, 1927, 2076, 2094, 1926, 1925, 2202,
 /*  1790 */  1924, 1923, 1922,  275,  658, 1921, 1920, 1919,  274, 2044,
 /*  1800 */   146,  657, 1918, 1917, 1948, 1916, 1915, 1378, 1914, 1913,
 /*  1810 */  2076, 1912, 1911,  472, 1429, 1910,  243,  601, 2094,  336,
 /*  1820 */  1251, 1255, 1765,  337,  201, 1764,  655, 1763, 1247, 1761,
 /*  1830 */  2075, 2044,  203,  657, 2111,  204, 1725,  169, 2077,  661,
 /*  1840 */  2079, 2080,  656, 2094,  651,  177, 1724, 2064,  383,  206,
 /*  1850 */  2008,  658,   75, 1159, 1158,   76, 2044,  493,  657, 2076,
 /*  1860 */   207,  495, 2075, 2002, 1990,  212, 2111,  214, 1989,  326,
 /*  1870 */  2077,  661, 2079, 2080,  656, 2076,  651, 1967, 2130, 1835,
 /*  1880 */  1760, 1758, 1193,  510,  512,  511, 1756, 2075,  514,  515,
 /*  1890 */  2257, 2111, 2094,  516,  327, 2077,  661, 2079, 2080,  656,
 /*  1900 */   658,  651, 1754,  519,  518, 2044,  520,  657, 2094, 1752,
 /*  1910 */   522,  524, 1739,  385,  523, 1738,  658, 1721, 1837, 1324,
 /*  1920 */  1836, 2044, 1323,  657, 2076, 1238,  224,   62, 1237, 1236,
 /*  1930 */  1235, 1234,  716,  718, 1231, 1229,  564, 1750, 1230, 1228,
 /*  1940 */  2111, 2076, 1743,  322, 2077,  661, 2079, 2080,  656,  358,
 /*  1950 */   651,  359, 2075, 1741,  360,  549, 2111, 2094, 2076,  327,
 /*  1960 */  2077,  661, 2079, 2080,  656,  658,  651, 1720,  552,  554,
 /*  1970 */  2044, 1719,  657,  556, 2094, 1718,  558,  112, 1445, 1447,
 /*  1980 */  1444, 2007,  658, 1449, 1431,   26, 2001, 2044,  571,  657,
 /*  1990 */  1988, 2094,   55,  246, 1986, 2240,  577,   66,  572,  658,
 /*  2000 */    19, 2075,  364,   16, 2044, 2111,  657, 2076,  311, 2077,
 /*  2010 */   661, 2079, 2080,  656,   58,  651,   28,  162, 2075,    5,
 /*  2020 */  1658,  250, 2111, 2076,  585,  312, 2077,  661, 2079, 2080,
 /*  2030 */   656,    6,  651,   59,  587, 2075,   64,  252,  258, 2111,
 /*  2040 */  2094, 2076,  313, 2077,  661, 2079, 2080,  656,  658,  651,
 /*  2050 */   257, 1640,  170, 2044, 2065,  657, 2094,   30,  256,   29,
 /*  2060 */    21, 1632,   91, 1673,  658, 1678, 1679, 1672,  270, 2044,
 /*  2070 */   369,  657, 1677, 1676, 2094,  370,  173, 1607, 1606, 1987,
 /*  2080 */    57, 1985,  658,   93, 2075,   56,   20, 2044, 2111,  657,
 /*  2090 */  2076,  319, 2077,  661, 2079, 2080,  656,   17,  651, 1984,
 /*  2100 */  2075, 1966,   94,  276, 2111,   22, 2076,  323, 2077,  661,
 /*  2110 */  2079, 2080,  656, 1965,  651,  277, 1638,  279, 2075,  284,
 /*  2120 */    67,   96, 2111, 2094,  286,  315, 2077,  661, 2079, 2080,
 /*  2130 */   656,  658,  651,  102,   98,  289, 2044,   23,  657, 2094,
 /*  2140 */   632, 1559,   10, 1558,   12, 1482, 2114,  658, 1537,  650,
 /*  2150 */   174, 1535, 2044, 1569,  657,   36,  186, 1514, 1534,   15,
 /*  2160 */    24,  660, 1506, 2076,   25,  662, 1309, 2075,  664,  386,
 /*  2170 */   666, 2111, 1306,  668,  324, 2077,  661, 2079, 2080,  656,
 /*  2180 */  2076,  651,  671, 2075,  669,  674, 1303, 2111, 1297,  672,
 /*  2190 */   316, 2077,  661, 2079, 2080,  656, 2094,  651,  675,  677,
 /*  2200 */  1301, 1295,  678, 1300,  658, 1286,  684,  103,  104, 2044,
 /*  2210 */   292,  657, 1318, 2094, 1299, 1298,   74, 1314, 1191,  694,
 /*  2220 */  1225,  658, 1224, 1223, 1222, 1221, 2044, 1220,  657, 2076,
 /*  2230 */  1245, 1218,  706, 1216, 1215, 1214, 1212,  293, 1211, 1210,
 /*  2240 */  2075, 1209, 1208, 1207, 2111, 2076, 1206,  325, 2077,  661,
 /*  2250 */  2079, 2080,  656, 1242,  651, 1240, 1203, 2075, 1202, 1199,
 /*  2260 */  1198, 2111, 2094, 1197,  317, 2077,  661, 2079, 2080,  656,
 /*  2270 */   658,  651, 1196, 1757,  726, 2044,  727,  657, 2094,  728,
 /*  2280 */  1755,  731,  730,  732, 1753,  734,  658,  736, 1751,  738,
 /*  2290 */   735, 2044,  740,  657, 2076, 1737,  742,  739, 1148, 1717,
 /*  2300 */   296, 1468,  746,  750,  306, 1692, 2075,  749, 1692, 1692,
 /*  2310 */  2111, 1692, 1692,  330, 2077,  661, 2079, 2080,  656, 2076,
 /*  2320 */   651, 1692, 2075, 1692, 1692, 1692, 2111, 2094, 1692,  331,
 /*  2330 */  2077,  661, 2079, 2080,  656,  658,  651, 1692, 1692, 1692,
 /*  2340 */  2044, 1692,  657, 2076, 1692, 1692, 1692, 1692, 1692, 1692,
 /*  2350 */  1692, 1692, 2094, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*  2360 */   658, 1692, 1692, 1692, 1692, 2044, 1692,  657, 1692, 1692,
 /*  2370 */  1692, 2075, 1692, 1692, 1692, 2111, 2094, 1692, 2088, 2077,
 /*  2380 */   661, 2079, 2080,  656,  658,  651, 1692, 1692, 1692, 2044,
 /*  2390 */  1692,  657, 1692, 1692, 1692, 1692, 2075, 1692, 1692, 1692,
 /*  2400 */  2111, 1692, 1692, 2087, 2077,  661, 2079, 2080,  656, 1692,
 /*  2410 */   651, 1692, 1692, 1692, 2076, 1692, 1692, 1692, 1692, 1692,
 /*  2420 */  2075, 1692, 1692, 1692, 2111, 1692, 1692, 2086, 2077,  661,
 /*  2430 */  2079, 2080,  656, 1692,  651, 1692, 2076, 1692, 1692, 1692,
 /*  2440 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 2094, 1692, 1692,
 /*  2450 */  1692, 1692, 1692, 1692, 1692,  658, 1692, 1692, 1692, 1692,
 /*  2460 */  2044, 1692,  657, 2076, 1692, 1692, 1692, 1692, 1692, 2094,
 /*  2470 */  1692, 1692, 1692, 1692, 1692, 1692, 1692,  658, 1692, 1692,
 /*  2480 */  1692, 1692, 2044, 1692,  657, 1692, 1692, 1692, 1692, 1692,
 /*  2490 */  1692, 2075, 1692, 1692, 1692, 2111, 2094, 1692,  345, 2077,
 /*  2500 */   661, 2079, 2080,  656,  658,  651, 1692, 1692, 1692, 2044,
 /*  2510 */  1692,  657, 2076, 2075, 1692, 1692, 1692, 2111, 1692, 1692,
 /*  2520 */   346, 2077,  661, 2079, 2080,  656, 1692,  651, 2076, 1692,
 /*  2530 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*  2540 */  2075, 1692, 1692, 1692, 2111, 2094, 1692,  342, 2077,  661,
 /*  2550 */  2079, 2080,  656,  658,  651, 1692, 1692, 1692, 2044, 1692,
 /*  2560 */   657, 2094, 1692, 1692, 1692, 1692, 1692, 1692, 1692,  658,
 /*  2570 */  1692, 1692, 1692, 1692, 2044, 1692,  657, 2076, 1692, 1692,
 /*  2580 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 2075,
 /*  2590 */  1692, 1692, 1692, 2111, 1692, 1692,  347, 2077,  661, 2079,
 /*  2600 */  2080,  656, 1692,  651, 1692,  659, 1692, 1692, 1692, 2111,
 /*  2610 */  2094, 1692,  322, 2077,  661, 2079, 2080,  656,  658,  651,
 /*  2620 */  1692, 1692, 1692, 2044, 1692,  657, 1692, 1692, 1692, 1692,
 /*  2630 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*  2640 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*  2650 */  1692, 1692, 1692, 1692, 2075, 1692, 1692, 1692, 2111, 1692,
 /*  2660 */  1692,  321, 2077,  661, 2079, 2080,  656, 1692,  651,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   379,  365,  356,  331,  339,  441,  339,  366,  425,  445,
 /*    10 */   364,  428,   12,   13,   14,  394,  395,  371,  377,  373,
 /*    20 */    20,  366,   22,  339,  460,  461,  380,  366,   14,  465,
 /*    30 */   466,    0,  377,   33,   20,   35,  364,   20,  377,   12,
 /*    40 */    13,   14,   15,   16,  372,   20,  381,   22,   20,  377,
 /*    50 */    20,  379,  411,  412,  413,  388,  372,  390,   58,  364,
 /*    60 */    35,  441,  364,  422,   64,  445,  411,  412,  413,  371,
 /*    70 */   328,   71,  411,  412,  413,  380,   51,  422,  380,   48,
 /*    80 */   408,  461,  364,  422,  412,  465,  466,  415,  416,  417,
 /*    90 */   418,  419,  420,    4,  422,  346,  330,   97,  332,  427,
 /*   100 */   100,  429,  353,  385,  386,  433,  434,   20,    8,    9,
 /*   110 */    12,   13,   12,   13,   14,   15,   16,  100,   20,  447,
 /*   120 */    22,  437,  438,  439,  364,  441,  442,  455,  100,  445,
 /*   130 */   100,   33,   43,   35,   45,   46,  136,  137,  396,  441,
 /*   140 */   396,    2,  400,  445,  460,  461,  386,    8,    9,  465,
 /*   150 */   466,   12,   13,   14,   15,   16,   58,  375,  460,  461,
 /*   160 */   378,  379,   64,  465,  466,   20,  166,  167,  331,   71,
 /*   170 */     0,   21,  172,  173,   24,   25,   26,   27,   28,   29,
 /*   180 */    30,   31,   32,  441,  379,  441,  186,  445,  188,  445,
 /*   190 */   335,   20,  337,  338,    4,   97,  391,   35,  100,  394,
 /*   200 */   395,  100,  460,  461,  460,  461,   20,  465,  466,  465,
 /*   210 */   466,  110,  212,  213,  377,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,   71,  136,  137,   66,   67,   68,   69,
 /*   240 */    70,   20,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   250 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   260 */    90,   91,   92,  441,  166,  167,  331,  445,    8,    9,
 /*   270 */   172,  173,   12,   13,   14,   15,   16,  249,  178,  249,
 /*   280 */    20,  136,  137,  461,  186,  112,  188,  465,  466,   63,
 /*   290 */   100,  366,  336,    8,    9,  339,  340,   12,   13,   14,
 /*   300 */    15,   16,  377,  130,  131,  132,  133,  134,  135,   20,
 /*   310 */   212,  213,  377,  215,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,   12,   13,    0,   20,  411,  412,  364,  168,
 /*   340 */    20,   97,   22,   20,   63,  371,   20,  422,   22,   64,
 /*   350 */   171,  343,   58,   33,  380,   35,  343,  113,  114,  115,
 /*   360 */   116,  117,  118,  119,  120,  121,  122,  359,  124,  125,
 /*   370 */   126,  127,  128,  129,  274,  367,    2,   51,   58,    0,
 /*   380 */   367,  331,    8,    9,   64,  111,   12,   13,   14,   15,
 /*   390 */    16,   71,   20,   99,  109,  212,  102,   66,   67,   68,
 /*   400 */    66,   67,   68,  331,   73,   74,   75,   73,   74,   75,
 /*   410 */    79,  430,  431,   79,  364,   84,   85,   97,   84,   85,
 /*   420 */   100,   90,  372,  335,   90,  337,  338,  377,  168,  379,
 /*   430 */    12,   13,   14,  254,  255,  256,  345,  414,   20,  249,
 /*   440 */    22,   22,  259,  260,  261,  262,  263,  264,  265,  377,
 /*   450 */   165,   33,  361,   35,   35,  339,  136,  137,  408,  136,
 /*   460 */   137,  370,  412,  440,  112,  415,  416,  417,  418,  419,
 /*   470 */   420,  355,  422,    0,  339,  425,   58,  427,  428,  429,
 /*   480 */   100,  166,  167,  433,  434,  133,  166,  167,  372,   71,
 /*   490 */   355,  112,  172,  173,   21,  172,  173,   24,   25,   26,
 /*   500 */    27,   28,   29,   30,   31,   32,  186,  372,  188,  130,
 /*   510 */   131,  132,  133,  134,  135,   97,   97,  130,  100,   80,
 /*   520 */   100,  236,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   530 */   245,  246,  212,  213,    0,  215,  216,  217,  218,  219,
 /*   540 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   550 */   230,  231,  232,  396,  136,  137,   71,  400,   24,   25,
 /*   560 */    26,   27,   28,   29,   30,   31,   32,   58,  336,    8,
 /*   570 */     9,  339,  340,   12,   13,   14,   15,   16,  364,  331,
 /*   580 */   141,  142,  195,  196,  166,  167,  339,  373,    8,    9,
 /*   590 */   172,  173,   12,   13,   14,   15,   16,    3,  441,  111,
 /*   600 */   364,  345,  445,  164,  186,  364,  188,  371,  426,  100,
 /*   610 */   428,  102,  364,  372,   20,  363,  380,  460,  461,  372,
 /*   620 */   372,    0,  465,  466,   44,  377,  370,  379,  376,  249,
 /*   630 */   212,  213,  181,  215,  216,  217,  218,  219,  220,  221,
 /*   640 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   650 */   232,   12,   13,  396,  203,  204,  408,  339,  417,   20,
 /*   660 */   412,   22,  101,  415,  416,  417,  418,  419,  420,  249,
 /*   670 */   422,  339,   33,  355,   35,  427,  339,  429,  378,  379,
 /*   680 */   362,  433,  434,  436,  437,  438,  439,  355,  441,  442,
 /*   690 */   372,    4,  355,  414,  362,  101,  331,   58,  441,  111,
 /*   700 */   331,  339,  445,  455,  372,  339,   19,    8,    9,  372,
 /*   710 */    71,   12,   13,   14,   15,   16,  339,  460,  461,  440,
 /*   720 */    33,  355,  465,  466,   14,   15,   16,  339,  131,  364,
 /*   730 */   339,  339,  135,  112,  372,   48,   97,  372,  372,  100,
 /*   740 */    53,  233,  377,  355,  379,   58,  377,  355,  160,   12,
 /*   750 */    13,  130,  131,  132,  133,  134,  135,   20,  249,   22,
 /*   760 */   372,  356,  168,  372,  372,  388,  339,  390,  366,  364,
 /*   770 */    33,  396,   35,  408,   71,  136,  137,  412,  373,  377,
 /*   780 */   415,  416,  417,  418,  419,  420,   99,  422,  365,  102,
 /*   790 */   193,  194,  331,  339,  197,   58,  199,  331,  331,  437,
 /*   800 */   438,  439,  356,  441,  442,  166,  167,  372,   71,  355,
 /*   810 */   364,  172,  173,  411,  412,  388,  441,  390,  383,  373,
 /*   820 */   445,  456,  457,    0,  422,  186,  372,  188,  437,  438,
 /*   830 */   439,  364,  441,  442,   97,  460,  461,  100,  377,  372,
 /*   840 */   465,  466,   14,  377,  377,  331,  379,   14,   20,  331,
 /*   850 */   414,  212,  213,   20,  215,  216,  217,  218,  219,  220,
 /*   860 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   870 */   231,  232,  365,  136,  137,  408,  440,   21,  331,  412,
 /*   880 */   365,  339,  415,  416,  417,  418,  419,  420,   18,  422,
 /*   890 */    34,  377,   36,   23,  427,  377,  429,  355,  365,  364,
 /*   900 */   433,  434,  331,  166,  167,  331,  371,   37,   38,  172,
 /*   910 */   173,   41,    8,    9,  372,  380,   12,   13,   14,   15,
 /*   920 */    16,  130,  131,  186,  377,  188,  135,   37,  356,   59,
 /*   930 */    60,   61,   62,   39,    8,    9,  364,    3,   12,   13,
 /*   940 */    14,   15,   16,  331,  331,  373,  350,  351,  377,  212,
 /*   950 */   213,  377,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   960 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*   970 */   100,   18,  364,   20,  331,  350,  351,  364,  155,  371,
 /*   980 */    27,  339,    4,   30,  339,  372,   33,  164,  380,  377,
 /*   990 */   377,   22,  379,  103,  166,  105,  106,  355,  108,  166,
 /*  1000 */   355,   48,  112,   50,   35,  101,   53,  364,  138,  365,
 /*  1010 */   339,  339,  369,    0,  372,  372,  233,  372,  235,   20,
 /*  1020 */   377,  408,  379,  133,  365,  412,  355,  355,  415,  416,
 /*  1030 */   417,  418,  419,  420,  352,  422,  354,  331,  331,  100,
 /*  1040 */   427,   20,  429,  372,  372,  331,  433,  434,  178,  179,
 /*  1050 */   180,  408,   99,  183,  339,  412,   20,  444,  415,  416,
 /*  1060 */   417,  418,  419,  420,  111,  422,   97,    1,    2,   22,
 /*  1070 */   355,  331,  202,    0,  165,  205,   63,  207,  208,  209,
 /*  1080 */   210,  211,   35,  377,  377,  331,  331,  372,  331,  331,
 /*  1090 */   426,  377,  428,  140,  168,   22,  143,  144,  145,  146,
 /*  1100 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  156,
 /*  1110 */   157,  158,  159,  339,  161,  162,  163,  377,   71,  249,
 /*  1120 */   339,   44,  364,  339,  185,  339,  187,  339,  401,  355,
 /*  1130 */   372,  377,  377,   44,  377,  377,  355,  379,  331,  355,
 /*  1140 */   372,  355,  248,  355,   97,  236,  372,  360,  372,  357,
 /*  1150 */   211,  383,  360,  372,  374,  246,  372,  377,  372,  383,
 /*  1160 */   372,   45,   46,  247,  248,  166,  408,  101,    0,  374,
 /*  1170 */   412,  364,  377,  415,  416,  417,  418,  419,  420,  372,
 /*  1180 */   422,   42,   44,   44,  377,  427,  379,  429,  249,  168,
 /*  1190 */   101,  433,  434,  406,   22,  374,    0,  331,  377,   42,
 /*  1200 */    44,   44,  444,  269,  168,  104,  104,   35,  107,  107,
 /*  1210 */   104,  104,   44,  107,  107,  408,  136,  137,   22,  412,
 /*  1220 */   331,   58,  415,  416,  417,  418,  419,  420,  250,  422,
 /*  1230 */   364,  353,   44,  186,  427,  188,  429,  198,  372,  200,
 /*  1240 */   433,  434,    0,  377,   35,  379,   44,   96,    1,    2,
 /*  1250 */   332,  444,  387,  364,   64,   44,   44,  101,   13,  212,
 /*  1260 */   213,  372,  469,   44,   22,  102,  377,  458,  379,   44,
 /*  1270 */    44,   44,   44,   44,  408,   44,   35,   44,  412,   44,
 /*  1280 */    35,  415,  416,  417,  418,  419,  420,   47,  422,  101,
 /*  1290 */    44,  341,   44,  427,   44,  429,   44,  408,  331,  433,
 /*  1300 */   434,  412,   44,  101,  415,  416,  417,  418,  419,  420,
 /*  1310 */   444,  422,  101,  101,   12,   13,  427,  341,  429,  168,
 /*  1320 */   101,    0,  433,  434,   22,   35,  101,  101,  101,  101,
 /*  1330 */   101,  364,  101,  444,  101,   33,  101,   35,  452,  372,
 /*  1340 */   100,   13,  387,   33,  377,  364,  379,  101,  271,  101,
 /*  1350 */   338,  101,  387,  101,  443,  376,  435,  331,   48,  101,
 /*  1360 */    58,   71,  462,   35,   54,   55,   56,   57,   58,  446,
 /*  1370 */    49,  251,  410,   71,   48,  408,  184,  409,  398,  412,
 /*  1380 */   331,   42,  415,  416,  417,  418,  419,  420,  384,  422,
 /*  1390 */   364,   20,  387,  384,  427,  165,  429,  188,  372,   97,
 /*  1400 */   433,  434,  212,  377,  382,  379,   20,  339,  339,   99,
 /*  1410 */   382,  273,  102,  364,  384,  382,   98,   95,  339,  349,
 /*  1420 */   348,  372,  347,   94,  339,  339,  377,  396,  379,  188,
 /*  1430 */   339,   20,  333,  333,  408,   20,   20,  403,  412,  345,
 /*  1440 */   379,  415,  416,  417,  418,  419,  420,   20,  422,  345,
 /*  1450 */   340,   20,  397,  427,  345,  429,  345,  408,  340,  433,
 /*  1460 */   434,  412,  331,  339,  415,  416,  417,  418,  419,  420,
 /*  1470 */   345,  422,  441,  345,  345,   52,  445,  342,  429,  169,
 /*  1480 */   170,  333,  433,  434,  174,  342,  176,  364,  186,  339,
 /*  1490 */   188,  460,  461,  333,  364,  364,  465,  466,  364,  377,
 /*  1500 */   364,  364,  192,  372,  364,  364,  364,  201,  377,  364,
 /*  1510 */   379,  331,  407,  364,  212,  213,  364,  100,  405,  343,
 /*  1520 */   403,  377,  191,  377,  343,  339,  379,  225,  226,  227,
 /*  1530 */   228,  229,  230,  231,  331,  402,  377,  258,  451,  408,
 /*  1540 */   387,  387,  257,  412,  364,  177,  415,  416,  417,  418,
 /*  1550 */   419,  420,  372,  422,  392,  377,  392,  377,  266,  379,
 /*  1560 */   429,  377,  377,  451,  433,  434,  451,  364,  454,  268,
 /*  1570 */   267,  450,  453,  470,  448,  372,  449,  252,  248,  410,
 /*  1580 */   377,  272,  379,  275,  270,  372,   20,  414,  408,  340,
 /*  1590 */   339,   20,  412,  392,  390,  415,  416,  417,  418,  419,
 /*  1600 */   420,  377,  422,  343,  343,  170,  331,  392,  343,  429,
 /*  1610 */   389,  408,  343,  433,  434,  412,  377,  100,  415,  416,
 /*  1620 */   417,  418,  419,  420,  421,  422,  423,  424,  463,  331,
 /*  1630 */   464,  377,  377,  377,  377,  372,  360,  432,  100,  364,
 /*  1640 */   368,  377,  354,   19,  339,   36,  334,  372,  333,  358,
 /*  1650 */   343,  358,  377,  358,  379,  344,  329,   33,  399,  393,
 /*  1660 */   393,    0,  364,  331,    0,    0,  404,   42,    0,   35,
 /*  1670 */   372,  206,   48,   35,   35,  377,   35,  379,   54,   55,
 /*  1680 */    56,   57,   58,  408,  206,    0,   35,  412,   35,  331,
 /*  1690 */   415,  416,  417,  418,  419,  420,  364,  422,  206,    0,
 /*  1700 */   206,    0,   35,    0,  372,   22,  408,    0,   35,  377,
 /*  1710 */   412,  379,  193,  415,  416,  417,  418,  419,  420,  188,
 /*  1720 */   422,  186,  364,   99,    0,    0,  102,  429,    0,  182,
 /*  1730 */   372,  181,  434,    0,    0,  377,   47,  379,    0,    0,
 /*  1740 */   408,    0,  467,  468,  412,    0,   42,  415,  416,  417,
 /*  1750 */   418,  419,  420,  331,  422,    0,    0,    0,  134,  155,
 /*  1760 */     0,   35,  155,    0,    0,    0,  408,    0,    0,    0,
 /*  1770 */   412,    0,    0,  415,  416,  417,  418,  419,  420,    0,
 /*  1780 */   422,    0,    0,    0,    0,  331,  364,    0,    0,  457,
 /*  1790 */     0,    0,    0,  169,  372,    0,    0,    0,  174,  377,
 /*  1800 */    42,  379,    0,    0,    0,    0,    0,   22,    0,    0,
 /*  1810 */   331,    0,    0,  139,  190,    0,  192,  459,  364,   96,
 /*  1820 */    22,   22,    0,   96,   58,    0,  372,    0,   35,    0,
 /*  1830 */   408,  377,   58,  379,  412,   58,    0,  415,  416,  417,
 /*  1840 */   418,  419,  420,  364,  422,   44,    0,   47,  369,   42,
 /*  1850 */     0,  372,   39,   14,   14,   39,  377,   47,  379,  331,
 /*  1860 */    40,   47,  408,    0,    0,   39,  412,  177,    0,  415,
 /*  1870 */   416,  417,  418,  419,  420,  331,  422,    0,  424,    0,
 /*  1880 */     0,    0,   65,   35,   39,   48,    0,  408,   35,   48,
 /*  1890 */   468,  412,  364,   39,  415,  416,  417,  418,  419,  420,
 /*  1900 */   372,  422,    0,   48,   35,  377,   39,  379,  364,    0,
 /*  1910 */    35,   39,    0,  369,   48,    0,  372,    0,    0,   35,
 /*  1920 */     0,  377,   22,  379,  331,   35,  107,  109,   35,   35,
 /*  1930 */    35,   35,   44,   44,   35,   22,  408,    0,   35,   35,
 /*  1940 */   412,  331,    0,  415,  416,  417,  418,  419,  420,   22,
 /*  1950 */   422,   22,  408,    0,   22,   50,  412,  364,  331,  415,
 /*  1960 */   416,  417,  418,  419,  420,  372,  422,    0,   35,   35,
 /*  1970 */   377,    0,  379,   35,  364,    0,   22,   20,   35,   35,
 /*  1980 */    35,    0,  372,  101,   35,  100,    0,  377,   22,  379,
 /*  1990 */     0,  364,  168,  170,    0,    3,  175,  100,  168,  372,
 /*  2000 */    44,  408,  168,  253,  377,  412,  379,  331,  415,  416,
 /*  2010 */   417,  418,  419,  420,   44,  422,  100,  189,  408,   96,
 /*  2020 */   101,  100,  412,  331,   98,  415,  416,  417,  418,  419,
 /*  2030 */   420,   96,  422,   44,   95,  408,    3,  101,   47,  412,
 /*  2040 */   364,  331,  415,  416,  417,  418,  419,  420,  372,  422,
 /*  2050 */    44,  101,  100,  377,   47,  379,  364,   44,  100,  100,
 /*  2060 */    44,  101,  100,   35,  372,  101,  101,   35,   47,  377,
 /*  2070 */    35,  379,   35,   35,  364,   35,   47,  101,  101,    0,
 /*  2080 */    44,    0,  372,  100,  408,  247,  253,  377,  412,  379,
 /*  2090 */   331,  415,  416,  417,  418,  419,  420,  253,  422,    0,
 /*  2100 */   408,    0,   39,   47,  412,  100,  331,  415,  416,  417,
 /*  2110 */   418,  419,  420,    0,  422,  101,  101,  100,  408,  100,
 /*  2120 */   100,   39,  412,  364,  169,  415,  416,  417,  418,  419,
 /*  2130 */   420,  372,  422,  110,  100,   47,  377,   44,  379,  364,
 /*  2140 */   171,   98,  234,   98,    2,   22,  100,  372,  101,  100,
 /*  2150 */    47,  101,  377,  212,  379,  100,   47,   22,  101,  100,
 /*  2160 */   100,  214,  101,  331,  100,  111,  101,  408,   35,   35,
 /*  2170 */   100,  412,  101,   35,  415,  416,  417,  418,  419,  420,
 /*  2180 */   331,  422,   35,  408,  100,   35,  101,  412,  101,  100,
 /*  2190 */   415,  416,  417,  418,  419,  420,  364,  422,  100,   35,
 /*  2200 */   123,  101,  100,  123,  372,   22,  112,  100,  100,  377,
 /*  2210 */    44,  379,   35,  364,  123,  123,  100,   22,   65,   64,
 /*  2220 */    35,  372,   35,   35,   35,   35,  377,   35,  379,  331,
 /*  2230 */    71,   35,   93,   35,   35,   35,   35,   44,   35,   35,
 /*  2240 */   408,   22,   35,   35,  412,  331,   35,  415,  416,  417,
 /*  2250 */   418,  419,  420,   71,  422,   35,   35,  408,   35,   35,
 /*  2260 */    35,  412,  364,   22,  415,  416,  417,  418,  419,  420,
 /*  2270 */   372,  422,   35,    0,   35,  377,   48,  379,  364,   39,
 /*  2280 */     0,   48,   35,   39,    0,   35,  372,   39,    0,   35,
 /*  2290 */    48,  377,   39,  379,  331,    0,   35,   48,   35,    0,
 /*  2300 */    22,   22,   21,   20,   22,  471,  408,   21,  471,  471,
 /*  2310 */   412,  471,  471,  415,  416,  417,  418,  419,  420,  331,
 /*  2320 */   422,  471,  408,  471,  471,  471,  412,  364,  471,  415,
 /*  2330 */   416,  417,  418,  419,  420,  372,  422,  471,  471,  471,
 /*  2340 */   377,  471,  379,  331,  471,  471,  471,  471,  471,  471,
 /*  2350 */   471,  471,  364,  471,  471,  471,  471,  471,  471,  471,
 /*  2360 */   372,  471,  471,  471,  471,  377,  471,  379,  471,  471,
 /*  2370 */   471,  408,  471,  471,  471,  412,  364,  471,  415,  416,
 /*  2380 */   417,  418,  419,  420,  372,  422,  471,  471,  471,  377,
 /*  2390 */   471,  379,  471,  471,  471,  471,  408,  471,  471,  471,
 /*  2400 */   412,  471,  471,  415,  416,  417,  418,  419,  420,  471,
 /*  2410 */   422,  471,  471,  471,  331,  471,  471,  471,  471,  471,
 /*  2420 */   408,  471,  471,  471,  412,  471,  471,  415,  416,  417,
 /*  2430 */   418,  419,  420,  471,  422,  471,  331,  471,  471,  471,
 /*  2440 */   471,  471,  471,  471,  471,  471,  471,  364,  471,  471,
 /*  2450 */   471,  471,  471,  471,  471,  372,  471,  471,  471,  471,
 /*  2460 */   377,  471,  379,  331,  471,  471,  471,  471,  471,  364,
 /*  2470 */   471,  471,  471,  471,  471,  471,  471,  372,  471,  471,
 /*  2480 */   471,  471,  377,  471,  379,  471,  471,  471,  471,  471,
 /*  2490 */   471,  408,  471,  471,  471,  412,  364,  471,  415,  416,
 /*  2500 */   417,  418,  419,  420,  372,  422,  471,  471,  471,  377,
 /*  2510 */   471,  379,  331,  408,  471,  471,  471,  412,  471,  471,
 /*  2520 */   415,  416,  417,  418,  419,  420,  471,  422,  331,  471,
 /*  2530 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2540 */   408,  471,  471,  471,  412,  364,  471,  415,  416,  417,
 /*  2550 */   418,  419,  420,  372,  422,  471,  471,  471,  377,  471,
 /*  2560 */   379,  364,  471,  471,  471,  471,  471,  471,  471,  372,
 /*  2570 */   471,  471,  471,  471,  377,  471,  379,  331,  471,  471,
 /*  2580 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  408,
 /*  2590 */   471,  471,  471,  412,  471,  471,  415,  416,  417,  418,
 /*  2600 */   419,  420,  471,  422,  471,  408,  471,  471,  471,  412,
 /*  2610 */   364,  471,  415,  416,  417,  418,  419,  420,  372,  422,
 /*  2620 */   471,  471,  471,  377,  471,  379,  471,  471,  471,  471,
 /*  2630 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2640 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*  2650 */   471,  471,  471,  471,  408,  471,  471,  471,  412,  471,
 /*  2660 */   471,  415,  416,  417,  418,  419,  420,  471,  422,
};
#define YY_SHIFT_COUNT    (751)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2299)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   870,    0,   98,    0,  320,  320,  320,  320,  320,  320,
 /*    10 */   320,  320,  320,  320,  320,  418,  639,  639,  737,  639,
 /*    20 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    30 */   639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
 /*    40 */   639,  639,  639,  639,  639,  639,  639,  639,   28,   30,
 /*    50 */   939,   17,  509,  380,  420,  380,   17,   17, 1302, 1302,
 /*    60 */  1302,  380, 1302, 1302,  190,  380,   87,  323,  186,  186,
 /*    70 */   323,   89,   89,  315,  145,   14,   14,  186,  186,  186,
 /*    80 */   186,  186,  186,  186,  221,  186,  186,  226,   87,  186,
 /*    90 */   186,  289,  186,   87,  186,  221,  186,  221,   87,  186,
 /*   100 */   186,   87,  186,   87,   87,   87,  186,  281,  953,  285,
 /*   110 */   285,  331,  150, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
 /*   120 */  1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
 /*   130 */  1047, 1047,  890,  594,  315,  145,  162,  171,  171,  171,
 /*   140 */  1013,  783,  783,  162,  372,  372,  372,  226,  274,  508,
 /*   150 */    87,  485,   87,  485,  485,  488,  703,  244,  244,  244,
 /*   160 */   244,  244,  244,  244,  244, 1624,  334,  473,  260,  100,
 /*   170 */   183,   25,  179,  828,  833,  326, 1021, 1116,  352, 1036,
 /*   180 */   916,  894,  934,  916, 1139,  978,  999, 1120, 1326, 1192,
 /*   190 */  1339, 1371, 1339, 1230, 1386, 1386, 1339, 1230, 1230, 1318,
 /*   200 */  1322, 1386, 1329, 1386, 1386, 1386, 1411, 1411, 1415,  226,
 /*   210 */  1416,  226, 1427, 1431,  226, 1427,  226,  226,  226, 1386,
 /*   220 */   226, 1423, 1423, 1411,   87,   87,   87,   87,   87,   87,
 /*   230 */    87,   87,   87,   87,   87, 1386, 1411,  485,  485,  485,
 /*   240 */  1306, 1417, 1415,  281, 1331, 1416,  281, 1386, 1371, 1371,
 /*   250 */   485, 1279, 1285,  485, 1279, 1285,  485,  485,   87, 1292,
 /*   260 */  1368, 1279, 1301, 1303, 1325, 1120, 1308, 1309, 1314, 1330,
 /*   270 */   372, 1566, 1386, 1427,  281,  281, 1571, 1285,  485,  485,
 /*   280 */   485,  485,  485, 1285,  485, 1435,  281,  488,  281,  372,
 /*   290 */  1517, 1538,  485,  703, 1386,  281, 1609, 1411, 2669, 2669,
 /*   300 */  2669, 2669, 2669, 2669, 2669, 2669, 2669,  170, 1310,  534,
 /*   310 */   687,  561,  580,  904,  379,  139,  374,  926,  621,  699,
 /*   320 */   699,  699,  699,  699,  699,  699,  699,  699,  173,  597,
 /*   330 */    27,   27,  439,  451,  823,  294,  419,  969,  856,  387,
 /*   340 */   791,  791,  710, 1066,  909,  710,  710,  710,   31, 1089,
 /*   350 */  1172, 1157,  588, 1168, 1101, 1102, 1106, 1107, 1073, 1196,
 /*   360 */  1242, 1039, 1156, 1188, 1163, 1202, 1211, 1212, 1080, 1077,
 /*   370 */  1138, 1151, 1219, 1225, 1226, 1227, 1228, 1229, 1247, 1231,
 /*   380 */  1209, 1241, 1190, 1233, 1240, 1235, 1246, 1248, 1250, 1252,
 /*   390 */  1258,  101, 1245, 1328, 1290, 1321, 1661, 1664, 1665, 1625,
 /*   400 */  1668, 1634, 1465, 1638, 1639, 1641, 1478, 1685, 1651, 1653,
 /*   410 */  1492, 1699, 1494, 1701, 1667, 1703, 1683, 1707, 1673, 1519,
 /*   420 */  1531, 1535, 1724, 1725, 1728, 1547, 1550, 1733, 1734, 1689,
 /*   430 */  1738, 1739, 1741, 1704, 1745, 1755, 1756, 1757, 1767, 1768,
 /*   440 */  1769, 1771, 1604, 1726, 1760, 1607, 1763, 1764, 1765, 1772,
 /*   450 */  1779, 1781, 1782, 1783, 1784, 1787, 1788, 1790, 1791, 1792,
 /*   460 */  1795, 1796, 1758, 1797, 1802, 1803, 1804, 1805, 1806, 1785,
 /*   470 */  1808, 1809, 1811, 1674, 1812, 1815, 1798, 1723, 1799, 1727,
 /*   480 */  1822, 1766, 1793, 1825, 1774, 1827, 1777, 1829, 1836, 1807,
 /*   490 */  1813, 1801, 1800, 1839, 1810, 1840, 1814, 1846, 1820, 1816,
 /*   500 */  1850, 1863, 1864, 1826, 1690, 1868, 1877, 1879, 1817, 1880,
 /*   510 */  1881, 1848, 1837, 1845, 1886, 1853, 1841, 1854, 1902, 1869,
 /*   520 */  1855, 1867, 1909, 1875, 1866, 1872, 1912, 1915, 1917, 1918,
 /*   530 */  1818, 1819, 1884, 1900, 1920, 1890, 1893, 1894, 1895, 1896,
 /*   540 */  1888, 1889, 1899, 1903, 1913, 1904, 1937, 1927, 1942, 1929,
 /*   550 */  1905, 1953, 1932, 1933, 1967, 1934, 1971, 1938, 1975, 1954,
 /*   560 */  1957, 1943, 1944, 1945, 1882, 1885, 1981, 1824, 1897, 1949,
 /*   570 */  1986, 1828, 1966, 1830, 1823, 1990, 1994, 1834, 1821, 1992,
 /*   580 */  1956, 1750, 1916, 1919, 1921, 1923, 1926, 1935, 1939, 1936,
 /*   590 */  1970, 1989, 1950, 1952, 1958, 1959, 1960, 2006, 1991, 2007,
 /*   600 */  1962, 2013, 1833, 1964, 1965, 2033, 2016, 1844, 2028, 2032,
 /*   610 */  2035, 2037, 2038, 2040, 1976, 1977, 2021, 1838, 2036, 2029,
 /*   620 */  2079, 2081, 2099, 2101, 1983, 2063, 1800, 2056, 2005, 2014,
 /*   630 */  2015, 2017, 2019, 1969, 2020, 2113, 2082, 1955, 2034, 2023,
 /*   640 */  1800, 2088, 2093, 2043, 1908, 2045, 2142, 2123, 1941, 2046,
 /*   650 */  2047, 2049, 2050, 2055, 2057, 2103, 2059, 2060, 2109, 2061,
 /*   660 */  2135, 1947, 2064, 2054, 2065, 2133, 2134, 2070, 2071, 2138,
 /*   670 */  2084, 2085, 2147, 2089, 2087, 2150, 2098, 2100, 2164, 2102,
 /*   680 */  2077, 2080, 2091, 2092, 2183, 2094, 2107, 2166, 2108, 2177,
 /*   690 */  2116, 2166, 2166, 2195, 2153, 2155, 2185, 2187, 2188, 2189,
 /*   700 */  2190, 2192, 2196, 2198, 2199, 2200, 2159, 2139, 2193, 2201,
 /*   710 */  2203, 2204, 2219, 2207, 2208, 2211, 2182, 1888, 2220, 1889,
 /*   720 */  2221, 2223, 2224, 2225, 2241, 2237, 2273, 2239, 2228, 2240,
 /*   730 */  2280, 2247, 2233, 2244, 2284, 2250, 2242, 2248, 2288, 2254,
 /*   740 */  2249, 2253, 2295, 2261, 2263, 2299, 2278, 2281, 2279, 2282,
 /*   750 */  2286, 2283,
};
#define YY_REDUCE_COUNT (306)
#define YY_REDUCE_MIN   (-436)
#define YY_REDUCE_MAX   (2246)
static const short yy_reduce_ofst[] = {
 /*     0 */  -258, -328,   50,  248,  613,  758,  807,  866,  889,  467,
 /*    10 */   967, 1026, 1049, 1131, 1180, 1203,  365, 1275, 1298, 1332,
 /*    20 */  1358, 1422,  643, 1454, 1479, 1544, 1528, 1593, 1610, 1627,
 /*    30 */  1676, 1692, 1710, 1759, 1775, 1832, 1849, 1898, 1914, 1963,
 /*    40 */  1988, 2012, 2083, 2105, 2132, 2181, 2197, 2246, -316, -302,
 /*    50 */   157,  247, -256,  257,  375, 1031,  362,  391, -359, -345,
 /*    60 */  -339, -436,  -75,  402, -380, -178, -354, -195,  318,  332,
 /*    70 */  -379, -145,   88, -282, -218,  -44,  232,  116,  135,  337,
 /*    80 */   366,  388,  392,  454, -333,  542,  642,   91,  -26,  645,
 /*    90 */   671,  241,  672,  236,  715,  377,  774,  427,  405,  781,
 /*   100 */   784,  535,  786,  446,  608,  572,  788,    8, -335,  -19,
 /*   110 */   -19, -251, -234, -163,  -65,   72,  369,  461,  466,  514,
 /*   120 */   518,  547,  571,  574,  612,  706,  707,  714,  740,  754,
 /*   130 */   755,  757,  252,   23, -240,  300,  596,   23,  279,  436,
 /*   140 */    13,  182,  664,  625,  435,  768,  776,  256,  787, -417,
 /*   150 */   214,  780, -305,  795,  821,  792,  682, -364,  423,  507,
 /*   160 */   515,  533,  644,  659,  533,  727,  878,  918,  865,  793,
 /*   170 */   809,  950,  886,  981,  981,  976,  955, 1012,  979,  965,
 /*   180 */   911,  911,  900,  911,  921,  923,  981,  962,  968,  980,
 /*   190 */  1004, 1005, 1009, 1022, 1068, 1069, 1030, 1028, 1033, 1070,
 /*   200 */  1072, 1079, 1075, 1085, 1086, 1091, 1099, 1100, 1034, 1094,
 /*   210 */  1061, 1104, 1110, 1055, 1109, 1118, 1111, 1125, 1128, 1124,
 /*   220 */  1129, 1135, 1143, 1148, 1123, 1130, 1134, 1136, 1137, 1140,
 /*   230 */  1141, 1142, 1145, 1149, 1152, 1150, 1160, 1122, 1144, 1146,
 /*   240 */  1105, 1113, 1117, 1176, 1133, 1147, 1181, 1186, 1153, 1154,
 /*   250 */  1159, 1087, 1162, 1178, 1112, 1164, 1184, 1185,  981, 1114,
 /*   260 */  1119, 1115, 1121, 1127, 1126, 1169, 1103, 1166, 1165,  911,
 /*   270 */  1213, 1173, 1251, 1249, 1260, 1261, 1204, 1201, 1224, 1239,
 /*   280 */  1254, 1255, 1256, 1215, 1257, 1221, 1265, 1276, 1269, 1263,
 /*   290 */  1205, 1272, 1264, 1288, 1305, 1307, 1312, 1315, 1259, 1262,
 /*   300 */  1266, 1267, 1291, 1293, 1295, 1311, 1327,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    10 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    20 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    30 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    40 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    50 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    60 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    70 */  1690, 1690, 1690, 1957, 1690, 1690, 1690, 1690, 1690, 1690,
 /*    80 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1769, 1690, 1690,
 /*    90 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   100 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1767, 1950, 2166,
 /*   110 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   120 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   130 */  1690, 1690, 1690, 2178, 1690, 1690, 1690, 2178, 2178, 2178,
 /*   140 */  1767, 2138, 2138, 1690, 1690, 1690, 1690, 1769, 2011, 1690,
 /*   150 */  1690, 1690, 1690, 1690, 1690, 1885, 1690, 1690, 1690, 1690,
 /*   160 */  1690, 1909, 1690, 1690, 1690, 2003, 1690, 1690, 2203, 2259,
 /*   170 */  1690, 1690, 2206, 1690, 1690, 1690, 1962, 1690, 1838, 2193,
 /*   180 */  2170, 2184, 2243, 2171, 2168, 2187, 1690, 2197, 1690, 1996,
 /*   190 */  1955, 1690, 1955, 1952, 1690, 1690, 1955, 1952, 1952, 1827,
 /*   200 */  1823, 1690, 1821, 1690, 1690, 1690, 1690, 1690, 1690, 1769,
 /*   210 */  1690, 1769, 1690, 1690, 1769, 1690, 1769, 1769, 1769, 1690,
 /*   220 */  1769, 1747, 1747, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   230 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   240 */  2023, 2009, 1690, 1767, 2005, 1690, 1767, 1690, 1690, 1690,
 /*   250 */  1690, 2214, 2212, 1690, 2214, 2212, 1690, 1690, 1690, 2228,
 /*   260 */  2224, 2214, 2232, 2230, 2199, 2197, 2262, 2249, 2245, 2184,
 /*   270 */  1690, 1690, 1690, 1690, 1767, 1767, 1690, 2212, 1690, 1690,
 /*   280 */  1690, 1690, 1690, 2212, 1690, 1690, 1767, 1690, 1767, 1690,
 /*   290 */  1690, 1854, 1690, 1690, 1690, 1767, 1722, 1690, 1998, 2014,
 /*   300 */  1980, 1980, 1888, 1888, 1888, 1770, 1695, 1690, 1690, 1690,
 /*   310 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 2227,
 /*   320 */  2226, 2093, 1690, 2142, 2141, 2140, 2131, 2092, 1850, 1690,
 /*   330 */  2091, 2090, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   340 */  1971, 1970, 2084, 1690, 1690, 2085, 2083, 2082, 1690, 1690,
 /*   350 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   360 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 2246,
 /*   370 */  2250, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 2167, 1690,
 /*   380 */  1690, 1690, 1690, 1690, 2066, 1690, 1690, 1690, 1690, 1690,
 /*   390 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   400 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   410 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   420 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   430 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   440 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   450 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   460 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   470 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   480 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   490 */  1690, 1727, 2071, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   500 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   510 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   520 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   530 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   540 */  1808, 1807, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   550 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   560 */  1690, 1690, 1690, 1690, 2075, 1690, 1690, 1690, 1690, 1690,
 /*   570 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 2242,
 /*   580 */  2200, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   590 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 2066,
 /*   600 */  1690, 2225, 1690, 1690, 2240, 1690, 2244, 1690, 1690, 1690,
 /*   610 */  1690, 1690, 1690, 1690, 2177, 2173, 1690, 1690, 2169, 1690,
 /*   620 */  1690, 1690, 1690, 1690, 1690, 1690, 2074, 1690, 1690, 1690,
 /*   630 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   640 */  2065, 1690, 2128, 1690, 1690, 1690, 2162, 1690, 1690, 2113,
 /*   650 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 2075,
 /*   660 */  1690, 2078, 1690, 1690, 1690, 1690, 1690, 1882, 1690, 1690,
 /*   670 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   680 */  1867, 1865, 1864, 1863, 1690, 1860, 1690, 1895, 1690, 1690,
 /*   690 */  1690, 1891, 1890, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   700 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1788, 1690,
 /*   710 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1780, 1690, 1779,
 /*   720 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   730 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   740 */  1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690, 1690,
 /*   750 */  1690, 1690,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  276,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  276,  /*      AFTER => ABORT */
  276,  /*     ATTACH => ABORT */
  276,  /*     BEFORE => ABORT */
  276,  /*      BEGIN => ABORT */
  276,  /*     BITAND => ABORT */
  276,  /*     BITNOT => ABORT */
  276,  /*      BITOR => ABORT */
  276,  /*     BLOCKS => ABORT */
  276,  /*     CHANGE => ABORT */
  276,  /*      COMMA => ABORT */
  276,  /*     CONCAT => ABORT */
  276,  /*   CONFLICT => ABORT */
  276,  /*       COPY => ABORT */
  276,  /*   DEFERRED => ABORT */
  276,  /* DELIMITERS => ABORT */
  276,  /*     DETACH => ABORT */
  276,  /*     DIVIDE => ABORT */
  276,  /*        DOT => ABORT */
  276,  /*       EACH => ABORT */
  276,  /*       FAIL => ABORT */
  276,  /*       FILE => ABORT */
  276,  /*        FOR => ABORT */
  276,  /*       GLOB => ABORT */
  276,  /*         ID => ABORT */
  276,  /*  IMMEDIATE => ABORT */
  276,  /*     IMPORT => ABORT */
  276,  /*  INITIALLY => ABORT */
  276,  /*    INSTEAD => ABORT */
  276,  /*     ISNULL => ABORT */
  276,  /*        KEY => ABORT */
  276,  /*    MODULES => ABORT */
  276,  /*  NK_BITNOT => ABORT */
  276,  /*    NK_SEMI => ABORT */
  276,  /*    NOTNULL => ABORT */
  276,  /*         OF => ABORT */
  276,  /*       PLUS => ABORT */
  276,  /*  PRIVILEGE => ABORT */
  276,  /*      RAISE => ABORT */
  276,  /*    REPLACE => ABORT */
  276,  /*   RESTRICT => ABORT */
  276,  /*        ROW => ABORT */
  276,  /*       SEMI => ABORT */
  276,  /*       STAR => ABORT */
  276,  /*  STATEMENT => ABORT */
  276,  /*     STRICT => ABORT */
  276,  /*     STRING => ABORT */
  276,  /*      TIMES => ABORT */
  276,  /*     VALUES => ABORT */
  276,  /*   VARIABLE => ABORT */
  276,  /*       VIEW => ABORT */
  276,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "STREAM",
  /*  193 */ "INTO",
  /*  194 */ "TRIGGER",
  /*  195 */ "AT_ONCE",
  /*  196 */ "WINDOW_CLOSE",
  /*  197 */ "IGNORE",
  /*  198 */ "EXPIRED",
  /*  199 */ "FILL_HISTORY",
  /*  200 */ "UPDATE",
  /*  201 */ "SUBTABLE",
  /*  202 */ "KILL",
  /*  203 */ "CONNECTION",
  /*  204 */ "TRANSACTION",
  /*  205 */ "BALANCE",
  /*  206 */ "VGROUP",
  /*  207 */ "MERGE",
  /*  208 */ "REDISTRIBUTE",
  /*  209 */ "SPLIT",
  /*  210 */ "DELETE",
  /*  211 */ "INSERT",
  /*  212 */ "NULL",
  /*  213 */ "NK_QUESTION",
  /*  214 */ "NK_ARROW",
  /*  215 */ "ROWTS",
  /*  216 */ "QSTART",
  /*  217 */ "QEND",
  /*  218 */ "QDURATION",
  /*  219 */ "WSTART",
  /*  220 */ "WEND",
  /*  221 */ "WDURATION",
  /*  222 */ "IROWTS",
  /*  223 */ "ISFILLED",
  /*  224 */ "CAST",
  /*  225 */ "NOW",
  /*  226 */ "TODAY",
  /*  227 */ "TIMEZONE",
  /*  228 */ "CLIENT_VERSION",
  /*  229 */ "SERVER_VERSION",
  /*  230 */ "SERVER_STATUS",
  /*  231 */ "CURRENT_USER",
  /*  232 */ "CASE",
  /*  233 */ "WHEN",
  /*  234 */ "THEN",
  /*  235 */ "ELSE",
  /*  236 */ "BETWEEN",
  /*  237 */ "IS",
  /*  238 */ "NK_LT",
  /*  239 */ "NK_GT",
  /*  240 */ "NK_LE",
  /*  241 */ "NK_GE",
  /*  242 */ "NK_NE",
  /*  243 */ "MATCH",
  /*  244 */ "NMATCH",
  /*  245 */ "CONTAINS",
  /*  246 */ "IN",
  /*  247 */ "JOIN",
  /*  248 */ "INNER",
  /*  249 */ "SELECT",
  /*  250 */ "DISTINCT",
  /*  251 */ "WHERE",
  /*  252 */ "PARTITION",
  /*  253 */ "BY",
  /*  254 */ "SESSION",
  /*  255 */ "STATE_WINDOW",
  /*  256 */ "EVENT_WINDOW",
  /*  257 */ "SLIDING",
  /*  258 */ "FILL",
  /*  259 */ "VALUE",
  /*  260 */ "VALUE_F",
  /*  261 */ "NONE",
  /*  262 */ "PREV",
  /*  263 */ "NULL_F",
  /*  264 */ "LINEAR",
  /*  265 */ "NEXT",
  /*  266 */ "HAVING",
  /*  267 */ "RANGE",
  /*  268 */ "EVERY",
  /*  269 */ "ORDER",
  /*  270 */ "SLIMIT",
  /*  271 */ "SOFFSET",
  /*  272 */ "LIMIT",
  /*  273 */ "OFFSET",
  /*  274 */ "ASC",
  /*  275 */ "NULLS",
  /*  276 */ "ABORT",
  /*  277 */ "AFTER",
  /*  278 */ "ATTACH",
  /*  279 */ "BEFORE",
  /*  280 */ "BEGIN",
  /*  281 */ "BITAND",
  /*  282 */ "BITNOT",
  /*  283 */ "BITOR",
  /*  284 */ "BLOCKS",
  /*  285 */ "CHANGE",
  /*  286 */ "COMMA",
  /*  287 */ "CONCAT",
  /*  288 */ "CONFLICT",
  /*  289 */ "COPY",
  /*  290 */ "DEFERRED",
  /*  291 */ "DELIMITERS",
  /*  292 */ "DETACH",
  /*  293 */ "DIVIDE",
  /*  294 */ "DOT",
  /*  295 */ "EACH",
  /*  296 */ "FAIL",
  /*  297 */ "FILE",
  /*  298 */ "FOR",
  /*  299 */ "GLOB",
  /*  300 */ "ID",
  /*  301 */ "IMMEDIATE",
  /*  302 */ "IMPORT",
  /*  303 */ "INITIALLY",
  /*  304 */ "INSTEAD",
  /*  305 */ "ISNULL",
  /*  306 */ "KEY",
  /*  307 */ "MODULES",
  /*  308 */ "NK_BITNOT",
  /*  309 */ "NK_SEMI",
  /*  310 */ "NOTNULL",
  /*  311 */ "OF",
  /*  312 */ "PLUS",
  /*  313 */ "PRIVILEGE",
  /*  314 */ "RAISE",
  /*  315 */ "REPLACE",
  /*  316 */ "RESTRICT",
  /*  317 */ "ROW",
  /*  318 */ "SEMI",
  /*  319 */ "STAR",
  /*  320 */ "STATEMENT",
  /*  321 */ "STRICT",
  /*  322 */ "STRING",
  /*  323 */ "TIMES",
  /*  324 */ "VALUES",
  /*  325 */ "VARIABLE",
  /*  326 */ "VIEW",
  /*  327 */ "WAL",
  /*  328 */ "cmd",
  /*  329 */ "account_options",
  /*  330 */ "alter_account_options",
  /*  331 */ "literal",
  /*  332 */ "alter_account_option",
  /*  333 */ "user_name",
  /*  334 */ "sysinfo_opt",
  /*  335 */ "privileges",
  /*  336 */ "priv_level",
  /*  337 */ "priv_type_list",
  /*  338 */ "priv_type",
  /*  339 */ "db_name",
  /*  340 */ "topic_name",
  /*  341 */ "dnode_endpoint",
  /*  342 */ "force_opt",
  /*  343 */ "not_exists_opt",
  /*  344 */ "db_options",
  /*  345 */ "exists_opt",
  /*  346 */ "alter_db_options",
  /*  347 */ "speed_opt",
  /*  348 */ "start_opt",
  /*  349 */ "end_opt",
  /*  350 */ "integer_list",
  /*  351 */ "variable_list",
  /*  352 */ "retention_list",
  /*  353 */ "alter_db_option",
  /*  354 */ "retention",
  /*  355 */ "full_table_name",
  /*  356 */ "column_def_list",
  /*  357 */ "tags_def_opt",
  /*  358 */ "table_options",
  /*  359 */ "multi_create_clause",
  /*  360 */ "tags_def",
  /*  361 */ "multi_drop_clause",
  /*  362 */ "alter_table_clause",
  /*  363 */ "alter_table_options",
  /*  364 */ "column_name",
  /*  365 */ "type_name",
  /*  366 */ "signed_literal",
  /*  367 */ "create_subtable_clause",
  /*  368 */ "specific_cols_opt",
  /*  369 */ "expression_list",
  /*  370 */ "drop_table_clause",
  /*  371 */ "col_name_list",
  /*  372 */ "table_name",
  /*  373 */ "column_def",
  /*  374 */ "duration_list",
  /*  375 */ "rollup_func_list",
  /*  376 */ "alter_table_option",
  /*  377 */ "duration_literal",
  /*  378 */ "rollup_func_name",
  /*  379 */ "function_name",
  /*  380 */ "col_name",
  /*  381 */ "db_name_cond_opt",
  /*  382 */ "like_pattern_opt",
  /*  383 */ "table_name_cond",
  /*  384 */ "from_db_opt",
  /*  385 */ "tag_list_opt",
  /*  386 */ "tag_item",
  /*  387 */ "column_alias",
  /*  388 */ "full_index_name",
  /*  389 */ "index_options",
  /*  390 */ "index_name",
  /*  391 */ "func_list",
  /*  392 */ "sliding_opt",
  /*  393 */ "sma_stream_opt",
  /*  394 */ "func",
  /*  395 */ "sma_func_name",
  /*  396 */ "query_or_subquery",
  /*  397 */ "cgroup_name",
  /*  398 */ "analyze_opt",
  /*  399 */ "explain_options",
  /*  400 */ "insert_query",
  /*  401 */ "agg_func_opt",
  /*  402 */ "bufsize_opt",
  /*  403 */ "stream_name",
  /*  404 */ "stream_options",
  /*  405 */ "col_list_opt",
  /*  406 */ "tag_def_or_ref_opt",
  /*  407 */ "subtable_opt",
  /*  408 */ "expression",
  /*  409 */ "dnode_list",
  /*  410 */ "where_clause_opt",
  /*  411 */ "signed",
  /*  412 */ "literal_func",
  /*  413 */ "literal_list",
  /*  414 */ "table_alias",
  /*  415 */ "expr_or_subquery",
  /*  416 */ "pseudo_column",
  /*  417 */ "column_reference",
  /*  418 */ "function_expression",
  /*  419 */ "case_when_expression",
  /*  420 */ "star_func",
  /*  421 */ "star_func_para_list",
  /*  422 */ "noarg_func",
  /*  423 */ "other_para_list",
  /*  424 */ "star_func_para",
  /*  425 */ "when_then_list",
  /*  426 */ "case_when_else_opt",
  /*  427 */ "common_expression",
  /*  428 */ "when_then_expr",
  /*  429 */ "predicate",
  /*  430 */ "compare_op",
  /*  431 */ "in_op",
  /*  432 */ "in_predicate_value",
  /*  433 */ "boolean_value_expression",
  /*  434 */ "boolean_primary",
  /*  435 */ "from_clause_opt",
  /*  436 */ "table_reference_list",
  /*  437 */ "table_reference",
  /*  438 */ "table_primary",
  /*  439 */ "joined_table",
  /*  440 */ "alias_opt",
  /*  441 */ "subquery",
  /*  442 */ "parenthesized_joined_table",
  /*  443 */ "join_type",
  /*  444 */ "search_condition",
  /*  445 */ "query_specification",
  /*  446 */ "set_quantifier_opt",
  /*  447 */ "select_list",
  /*  448 */ "partition_by_clause_opt",
  /*  449 */ "range_opt",
  /*  450 */ "every_opt",
  /*  451 */ "fill_opt",
  /*  452 */ "twindow_clause_opt",
  /*  453 */ "group_by_clause_opt",
  /*  454 */ "having_clause_opt",
  /*  455 */ "select_item",
  /*  456 */ "partition_list",
  /*  457 */ "partition_item",
  /*  458 */ "fill_mode",
  /*  459 */ "group_by_list",
  /*  460 */ "query_expression",
  /*  461 */ "query_simple",
  /*  462 */ "order_by_clause_opt",
  /*  463 */ "slimit_clause_opt",
  /*  464 */ "limit_clause_opt",
  /*  465 */ "union_query_expression",
  /*  466 */ "query_simple_or_subquery",
  /*  467 */ "sort_specification_list",
  /*  468 */ "sort_specification",
  /*  469 */ "ordering_specification_opt",
  /*  470 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 121 */ "integer_list ::= NK_INTEGER",
 /* 122 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 123 */ "variable_list ::= NK_VARIABLE",
 /* 124 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 125 */ "retention_list ::= retention",
 /* 126 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 127 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 128 */ "speed_opt ::=",
 /* 129 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 130 */ "start_opt ::=",
 /* 131 */ "start_opt ::= START WITH NK_INTEGER",
 /* 132 */ "start_opt ::= START WITH NK_STRING",
 /* 133 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 134 */ "end_opt ::=",
 /* 135 */ "end_opt ::= END WITH NK_INTEGER",
 /* 136 */ "end_opt ::= END WITH NK_STRING",
 /* 137 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 138 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 139 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 140 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 141 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 142 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 143 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 144 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 145 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 146 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 147 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 148 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 149 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 150 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 151 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 152 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 153 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 154 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 155 */ "multi_create_clause ::= create_subtable_clause",
 /* 156 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 157 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 158 */ "multi_drop_clause ::= drop_table_clause",
 /* 159 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 160 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 161 */ "specific_cols_opt ::=",
 /* 162 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 163 */ "full_table_name ::= table_name",
 /* 164 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 165 */ "column_def_list ::= column_def",
 /* 166 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 167 */ "column_def ::= column_name type_name",
 /* 168 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 169 */ "type_name ::= BOOL",
 /* 170 */ "type_name ::= TINYINT",
 /* 171 */ "type_name ::= SMALLINT",
 /* 172 */ "type_name ::= INT",
 /* 173 */ "type_name ::= INTEGER",
 /* 174 */ "type_name ::= BIGINT",
 /* 175 */ "type_name ::= FLOAT",
 /* 176 */ "type_name ::= DOUBLE",
 /* 177 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 178 */ "type_name ::= TIMESTAMP",
 /* 179 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= TINYINT UNSIGNED",
 /* 181 */ "type_name ::= SMALLINT UNSIGNED",
 /* 182 */ "type_name ::= INT UNSIGNED",
 /* 183 */ "type_name ::= BIGINT UNSIGNED",
 /* 184 */ "type_name ::= JSON",
 /* 185 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 186 */ "type_name ::= MEDIUMBLOB",
 /* 187 */ "type_name ::= BLOB",
 /* 188 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 189 */ "type_name ::= DECIMAL",
 /* 190 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 191 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 192 */ "tags_def_opt ::=",
 /* 193 */ "tags_def_opt ::= tags_def",
 /* 194 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 195 */ "table_options ::=",
 /* 196 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 197 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 198 */ "table_options ::= table_options WATERMARK duration_list",
 /* 199 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 200 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 201 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 202 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 203 */ "alter_table_options ::= alter_table_option",
 /* 204 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 205 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 206 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 207 */ "duration_list ::= duration_literal",
 /* 208 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 209 */ "rollup_func_list ::= rollup_func_name",
 /* 210 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 211 */ "rollup_func_name ::= function_name",
 /* 212 */ "rollup_func_name ::= FIRST",
 /* 213 */ "rollup_func_name ::= LAST",
 /* 214 */ "col_name_list ::= col_name",
 /* 215 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 216 */ "col_name ::= column_name",
 /* 217 */ "cmd ::= SHOW DNODES",
 /* 218 */ "cmd ::= SHOW USERS",
 /* 219 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 220 */ "cmd ::= SHOW DATABASES",
 /* 221 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 222 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 223 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 224 */ "cmd ::= SHOW MNODES",
 /* 225 */ "cmd ::= SHOW QNODES",
 /* 226 */ "cmd ::= SHOW FUNCTIONS",
 /* 227 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 228 */ "cmd ::= SHOW STREAMS",
 /* 229 */ "cmd ::= SHOW ACCOUNTS",
 /* 230 */ "cmd ::= SHOW APPS",
 /* 231 */ "cmd ::= SHOW CONNECTIONS",
 /* 232 */ "cmd ::= SHOW LICENCES",
 /* 233 */ "cmd ::= SHOW GRANTS",
 /* 234 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 235 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 236 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 237 */ "cmd ::= SHOW QUERIES",
 /* 238 */ "cmd ::= SHOW SCORES",
 /* 239 */ "cmd ::= SHOW TOPICS",
 /* 240 */ "cmd ::= SHOW VARIABLES",
 /* 241 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 242 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 243 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 244 */ "cmd ::= SHOW BNODES",
 /* 245 */ "cmd ::= SHOW SNODES",
 /* 246 */ "cmd ::= SHOW CLUSTER",
 /* 247 */ "cmd ::= SHOW TRANSACTIONS",
 /* 248 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 249 */ "cmd ::= SHOW CONSUMERS",
 /* 250 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 251 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 252 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 253 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 254 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 255 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 256 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 257 */ "db_name_cond_opt ::=",
 /* 258 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 259 */ "like_pattern_opt ::=",
 /* 260 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 261 */ "table_name_cond ::= table_name",
 /* 262 */ "from_db_opt ::=",
 /* 263 */ "from_db_opt ::= FROM db_name",
 /* 264 */ "tag_list_opt ::=",
 /* 265 */ "tag_list_opt ::= tag_item",
 /* 266 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 267 */ "tag_item ::= TBNAME",
 /* 268 */ "tag_item ::= QTAGS",
 /* 269 */ "tag_item ::= column_name",
 /* 270 */ "tag_item ::= column_name column_alias",
 /* 271 */ "tag_item ::= column_name AS column_alias",
 /* 272 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 273 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 274 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 275 */ "full_index_name ::= index_name",
 /* 276 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 277 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 278 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 279 */ "func_list ::= func",
 /* 280 */ "func_list ::= func_list NK_COMMA func",
 /* 281 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 282 */ "sma_func_name ::= function_name",
 /* 283 */ "sma_func_name ::= COUNT",
 /* 284 */ "sma_func_name ::= FIRST",
 /* 285 */ "sma_func_name ::= LAST",
 /* 286 */ "sma_func_name ::= LAST_ROW",
 /* 287 */ "sma_stream_opt ::=",
 /* 288 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 289 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 290 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 291 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 292 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 293 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 294 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 295 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 296 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 297 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 298 */ "cmd ::= DESC full_table_name",
 /* 299 */ "cmd ::= DESCRIBE full_table_name",
 /* 300 */ "cmd ::= RESET QUERY CACHE",
 /* 301 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 302 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 303 */ "analyze_opt ::=",
 /* 304 */ "analyze_opt ::= ANALYZE",
 /* 305 */ "explain_options ::=",
 /* 306 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 307 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 308 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 309 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 310 */ "agg_func_opt ::=",
 /* 311 */ "agg_func_opt ::= AGGREGATE",
 /* 312 */ "bufsize_opt ::=",
 /* 313 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 314 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 315 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 316 */ "col_list_opt ::=",
 /* 317 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 318 */ "tag_def_or_ref_opt ::=",
 /* 319 */ "tag_def_or_ref_opt ::= tags_def",
 /* 320 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 321 */ "stream_options ::=",
 /* 322 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 323 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 324 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 325 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 326 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 327 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 328 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 329 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 330 */ "subtable_opt ::=",
 /* 331 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 332 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 333 */ "cmd ::= KILL QUERY NK_STRING",
 /* 334 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 335 */ "cmd ::= BALANCE VGROUP",
 /* 336 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 337 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 338 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 339 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 340 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 341 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 342 */ "cmd ::= query_or_subquery",
 /* 343 */ "cmd ::= insert_query",
 /* 344 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 345 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 346 */ "literal ::= NK_INTEGER",
 /* 347 */ "literal ::= NK_FLOAT",
 /* 348 */ "literal ::= NK_STRING",
 /* 349 */ "literal ::= NK_BOOL",
 /* 350 */ "literal ::= TIMESTAMP NK_STRING",
 /* 351 */ "literal ::= duration_literal",
 /* 352 */ "literal ::= NULL",
 /* 353 */ "literal ::= NK_QUESTION",
 /* 354 */ "duration_literal ::= NK_VARIABLE",
 /* 355 */ "signed ::= NK_INTEGER",
 /* 356 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 357 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 358 */ "signed ::= NK_FLOAT",
 /* 359 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 360 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 361 */ "signed_literal ::= signed",
 /* 362 */ "signed_literal ::= NK_STRING",
 /* 363 */ "signed_literal ::= NK_BOOL",
 /* 364 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 365 */ "signed_literal ::= duration_literal",
 /* 366 */ "signed_literal ::= NULL",
 /* 367 */ "signed_literal ::= literal_func",
 /* 368 */ "signed_literal ::= NK_QUESTION",
 /* 369 */ "literal_list ::= signed_literal",
 /* 370 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 371 */ "db_name ::= NK_ID",
 /* 372 */ "table_name ::= NK_ID",
 /* 373 */ "column_name ::= NK_ID",
 /* 374 */ "function_name ::= NK_ID",
 /* 375 */ "table_alias ::= NK_ID",
 /* 376 */ "column_alias ::= NK_ID",
 /* 377 */ "user_name ::= NK_ID",
 /* 378 */ "topic_name ::= NK_ID",
 /* 379 */ "stream_name ::= NK_ID",
 /* 380 */ "cgroup_name ::= NK_ID",
 /* 381 */ "index_name ::= NK_ID",
 /* 382 */ "expr_or_subquery ::= expression",
 /* 383 */ "expression ::= literal",
 /* 384 */ "expression ::= pseudo_column",
 /* 385 */ "expression ::= column_reference",
 /* 386 */ "expression ::= function_expression",
 /* 387 */ "expression ::= case_when_expression",
 /* 388 */ "expression ::= NK_LP expression NK_RP",
 /* 389 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 390 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 391 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 392 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 393 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 394 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 395 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 396 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 397 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 398 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 399 */ "expression_list ::= expr_or_subquery",
 /* 400 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 401 */ "column_reference ::= column_name",
 /* 402 */ "column_reference ::= table_name NK_DOT column_name",
 /* 403 */ "pseudo_column ::= ROWTS",
 /* 404 */ "pseudo_column ::= TBNAME",
 /* 405 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 406 */ "pseudo_column ::= QSTART",
 /* 407 */ "pseudo_column ::= QEND",
 /* 408 */ "pseudo_column ::= QDURATION",
 /* 409 */ "pseudo_column ::= WSTART",
 /* 410 */ "pseudo_column ::= WEND",
 /* 411 */ "pseudo_column ::= WDURATION",
 /* 412 */ "pseudo_column ::= IROWTS",
 /* 413 */ "pseudo_column ::= ISFILLED",
 /* 414 */ "pseudo_column ::= QTAGS",
 /* 415 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 416 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 417 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 418 */ "function_expression ::= literal_func",
 /* 419 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 420 */ "literal_func ::= NOW",
 /* 421 */ "noarg_func ::= NOW",
 /* 422 */ "noarg_func ::= TODAY",
 /* 423 */ "noarg_func ::= TIMEZONE",
 /* 424 */ "noarg_func ::= DATABASE",
 /* 425 */ "noarg_func ::= CLIENT_VERSION",
 /* 426 */ "noarg_func ::= SERVER_VERSION",
 /* 427 */ "noarg_func ::= SERVER_STATUS",
 /* 428 */ "noarg_func ::= CURRENT_USER",
 /* 429 */ "noarg_func ::= USER",
 /* 430 */ "star_func ::= COUNT",
 /* 431 */ "star_func ::= FIRST",
 /* 432 */ "star_func ::= LAST",
 /* 433 */ "star_func ::= LAST_ROW",
 /* 434 */ "star_func_para_list ::= NK_STAR",
 /* 435 */ "star_func_para_list ::= other_para_list",
 /* 436 */ "other_para_list ::= star_func_para",
 /* 437 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 438 */ "star_func_para ::= expr_or_subquery",
 /* 439 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 440 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 441 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 442 */ "when_then_list ::= when_then_expr",
 /* 443 */ "when_then_list ::= when_then_list when_then_expr",
 /* 444 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 445 */ "case_when_else_opt ::=",
 /* 446 */ "case_when_else_opt ::= ELSE common_expression",
 /* 447 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 448 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 449 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 450 */ "predicate ::= expr_or_subquery IS NULL",
 /* 451 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 452 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 453 */ "compare_op ::= NK_LT",
 /* 454 */ "compare_op ::= NK_GT",
 /* 455 */ "compare_op ::= NK_LE",
 /* 456 */ "compare_op ::= NK_GE",
 /* 457 */ "compare_op ::= NK_NE",
 /* 458 */ "compare_op ::= NK_EQ",
 /* 459 */ "compare_op ::= LIKE",
 /* 460 */ "compare_op ::= NOT LIKE",
 /* 461 */ "compare_op ::= MATCH",
 /* 462 */ "compare_op ::= NMATCH",
 /* 463 */ "compare_op ::= CONTAINS",
 /* 464 */ "in_op ::= IN",
 /* 465 */ "in_op ::= NOT IN",
 /* 466 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 467 */ "boolean_value_expression ::= boolean_primary",
 /* 468 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 469 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 470 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 471 */ "boolean_primary ::= predicate",
 /* 472 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 473 */ "common_expression ::= expr_or_subquery",
 /* 474 */ "common_expression ::= boolean_value_expression",
 /* 475 */ "from_clause_opt ::=",
 /* 476 */ "from_clause_opt ::= FROM table_reference_list",
 /* 477 */ "table_reference_list ::= table_reference",
 /* 478 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 479 */ "table_reference ::= table_primary",
 /* 480 */ "table_reference ::= joined_table",
 /* 481 */ "table_primary ::= table_name alias_opt",
 /* 482 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 483 */ "table_primary ::= subquery alias_opt",
 /* 484 */ "table_primary ::= parenthesized_joined_table",
 /* 485 */ "alias_opt ::=",
 /* 486 */ "alias_opt ::= table_alias",
 /* 487 */ "alias_opt ::= AS table_alias",
 /* 488 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 489 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 490 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 491 */ "join_type ::=",
 /* 492 */ "join_type ::= INNER",
 /* 493 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 494 */ "set_quantifier_opt ::=",
 /* 495 */ "set_quantifier_opt ::= DISTINCT",
 /* 496 */ "set_quantifier_opt ::= ALL",
 /* 497 */ "select_list ::= select_item",
 /* 498 */ "select_list ::= select_list NK_COMMA select_item",
 /* 499 */ "select_item ::= NK_STAR",
 /* 500 */ "select_item ::= common_expression",
 /* 501 */ "select_item ::= common_expression column_alias",
 /* 502 */ "select_item ::= common_expression AS column_alias",
 /* 503 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 504 */ "where_clause_opt ::=",
 /* 505 */ "where_clause_opt ::= WHERE search_condition",
 /* 506 */ "partition_by_clause_opt ::=",
 /* 507 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 508 */ "partition_list ::= partition_item",
 /* 509 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 510 */ "partition_item ::= expr_or_subquery",
 /* 511 */ "partition_item ::= expr_or_subquery column_alias",
 /* 512 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 513 */ "twindow_clause_opt ::=",
 /* 514 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 515 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 516 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 517 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 518 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 519 */ "sliding_opt ::=",
 /* 520 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 521 */ "fill_opt ::=",
 /* 522 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 523 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 524 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 525 */ "fill_mode ::= NONE",
 /* 526 */ "fill_mode ::= PREV",
 /* 527 */ "fill_mode ::= NULL",
 /* 528 */ "fill_mode ::= NULL_F",
 /* 529 */ "fill_mode ::= LINEAR",
 /* 530 */ "fill_mode ::= NEXT",
 /* 531 */ "group_by_clause_opt ::=",
 /* 532 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 533 */ "group_by_list ::= expr_or_subquery",
 /* 534 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 535 */ "having_clause_opt ::=",
 /* 536 */ "having_clause_opt ::= HAVING search_condition",
 /* 537 */ "range_opt ::=",
 /* 538 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 539 */ "every_opt ::=",
 /* 540 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 541 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 542 */ "query_simple ::= query_specification",
 /* 543 */ "query_simple ::= union_query_expression",
 /* 544 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 545 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 546 */ "query_simple_or_subquery ::= query_simple",
 /* 547 */ "query_simple_or_subquery ::= subquery",
 /* 548 */ "query_or_subquery ::= query_expression",
 /* 549 */ "query_or_subquery ::= subquery",
 /* 550 */ "order_by_clause_opt ::=",
 /* 551 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 552 */ "slimit_clause_opt ::=",
 /* 553 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 554 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 555 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 556 */ "limit_clause_opt ::=",
 /* 557 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 558 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 559 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 560 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 561 */ "subquery ::= NK_LP subquery NK_RP",
 /* 562 */ "search_condition ::= common_expression",
 /* 563 */ "sort_specification_list ::= sort_specification",
 /* 564 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 565 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 566 */ "ordering_specification_opt ::=",
 /* 567 */ "ordering_specification_opt ::= ASC",
 /* 568 */ "ordering_specification_opt ::= DESC",
 /* 569 */ "null_ordering_opt ::=",
 /* 570 */ "null_ordering_opt ::= NULLS FIRST",
 /* 571 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 328: /* cmd */
    case 331: /* literal */
    case 344: /* db_options */
    case 346: /* alter_db_options */
    case 348: /* start_opt */
    case 349: /* end_opt */
    case 354: /* retention */
    case 355: /* full_table_name */
    case 358: /* table_options */
    case 362: /* alter_table_clause */
    case 363: /* alter_table_options */
    case 366: /* signed_literal */
    case 367: /* create_subtable_clause */
    case 370: /* drop_table_clause */
    case 373: /* column_def */
    case 377: /* duration_literal */
    case 378: /* rollup_func_name */
    case 380: /* col_name */
    case 381: /* db_name_cond_opt */
    case 382: /* like_pattern_opt */
    case 383: /* table_name_cond */
    case 384: /* from_db_opt */
    case 386: /* tag_item */
    case 388: /* full_index_name */
    case 389: /* index_options */
    case 392: /* sliding_opt */
    case 393: /* sma_stream_opt */
    case 394: /* func */
    case 396: /* query_or_subquery */
    case 399: /* explain_options */
    case 400: /* insert_query */
    case 404: /* stream_options */
    case 407: /* subtable_opt */
    case 408: /* expression */
    case 410: /* where_clause_opt */
    case 411: /* signed */
    case 412: /* literal_func */
    case 415: /* expr_or_subquery */
    case 416: /* pseudo_column */
    case 417: /* column_reference */
    case 418: /* function_expression */
    case 419: /* case_when_expression */
    case 424: /* star_func_para */
    case 426: /* case_when_else_opt */
    case 427: /* common_expression */
    case 428: /* when_then_expr */
    case 429: /* predicate */
    case 432: /* in_predicate_value */
    case 433: /* boolean_value_expression */
    case 434: /* boolean_primary */
    case 435: /* from_clause_opt */
    case 436: /* table_reference_list */
    case 437: /* table_reference */
    case 438: /* table_primary */
    case 439: /* joined_table */
    case 441: /* subquery */
    case 442: /* parenthesized_joined_table */
    case 444: /* search_condition */
    case 445: /* query_specification */
    case 449: /* range_opt */
    case 450: /* every_opt */
    case 451: /* fill_opt */
    case 452: /* twindow_clause_opt */
    case 454: /* having_clause_opt */
    case 455: /* select_item */
    case 457: /* partition_item */
    case 460: /* query_expression */
    case 461: /* query_simple */
    case 463: /* slimit_clause_opt */
    case 464: /* limit_clause_opt */
    case 465: /* union_query_expression */
    case 466: /* query_simple_or_subquery */
    case 468: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy140)); 
}
      break;
    case 329: /* account_options */
    case 330: /* alter_account_options */
    case 332: /* alter_account_option */
    case 347: /* speed_opt */
    case 402: /* bufsize_opt */
{
 
}
      break;
    case 333: /* user_name */
    case 336: /* priv_level */
    case 339: /* db_name */
    case 340: /* topic_name */
    case 341: /* dnode_endpoint */
    case 364: /* column_name */
    case 372: /* table_name */
    case 379: /* function_name */
    case 387: /* column_alias */
    case 390: /* index_name */
    case 395: /* sma_func_name */
    case 397: /* cgroup_name */
    case 403: /* stream_name */
    case 414: /* table_alias */
    case 420: /* star_func */
    case 422: /* noarg_func */
    case 440: /* alias_opt */
{
 
}
      break;
    case 334: /* sysinfo_opt */
{
 
}
      break;
    case 335: /* privileges */
    case 337: /* priv_type_list */
    case 338: /* priv_type */
{
 
}
      break;
    case 342: /* force_opt */
    case 343: /* not_exists_opt */
    case 345: /* exists_opt */
    case 398: /* analyze_opt */
    case 401: /* agg_func_opt */
    case 446: /* set_quantifier_opt */
{
 
}
      break;
    case 350: /* integer_list */
    case 351: /* variable_list */
    case 352: /* retention_list */
    case 356: /* column_def_list */
    case 357: /* tags_def_opt */
    case 359: /* multi_create_clause */
    case 360: /* tags_def */
    case 361: /* multi_drop_clause */
    case 368: /* specific_cols_opt */
    case 369: /* expression_list */
    case 371: /* col_name_list */
    case 374: /* duration_list */
    case 375: /* rollup_func_list */
    case 385: /* tag_list_opt */
    case 391: /* func_list */
    case 405: /* col_list_opt */
    case 406: /* tag_def_or_ref_opt */
    case 409: /* dnode_list */
    case 413: /* literal_list */
    case 421: /* star_func_para_list */
    case 423: /* other_para_list */
    case 425: /* when_then_list */
    case 447: /* select_list */
    case 448: /* partition_by_clause_opt */
    case 453: /* group_by_clause_opt */
    case 456: /* partition_list */
    case 459: /* group_by_list */
    case 462: /* order_by_clause_opt */
    case 467: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy220)); 
}
      break;
    case 353: /* alter_db_option */
    case 376: /* alter_table_option */
{
 
}
      break;
    case 365: /* type_name */
{
 
}
      break;
    case 430: /* compare_op */
    case 431: /* in_op */
{
 
}
      break;
    case 443: /* join_type */
{
 
}
      break;
    case 458: /* fill_mode */
{
 
}
      break;
    case 469: /* ordering_specification_opt */
{
 
}
      break;
    case 470: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  328,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  328,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  329,    0 }, /* (2) account_options ::= */
  {  329,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  329,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  329,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  329,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  329,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  329,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  329,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  329,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  329,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  330,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  330,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  332,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  332,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  332,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  332,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  332,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  332,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  332,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  332,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  332,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  332,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  328,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  328,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  328,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  328,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  328,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  334,    0 }, /* (29) sysinfo_opt ::= */
  {  334,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  328,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  328,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  335,   -1 }, /* (33) privileges ::= ALL */
  {  335,   -1 }, /* (34) privileges ::= priv_type_list */
  {  335,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  337,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  337,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  338,   -1 }, /* (38) priv_type ::= READ */
  {  338,   -1 }, /* (39) priv_type ::= WRITE */
  {  336,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  336,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  336,   -1 }, /* (42) priv_level ::= topic_name */
  {  328,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  328,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  328,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  328,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  328,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  328,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  328,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  328,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  341,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  341,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  341,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  342,    0 }, /* (54) force_opt ::= */
  {  342,   -1 }, /* (55) force_opt ::= FORCE */
  {  328,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  328,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  328,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  328,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  328,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  328,   -2 }, /* (68) cmd ::= USE db_name */
  {  328,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  328,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  328,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  328,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  343,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  343,    0 }, /* (74) not_exists_opt ::= */
  {  345,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  345,    0 }, /* (76) exists_opt ::= */
  {  344,    0 }, /* (77) db_options ::= */
  {  344,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  344,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  344,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  344,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  344,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  344,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  344,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  344,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  344,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  344,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  344,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  344,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  344,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  344,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  344,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  344,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  344,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  344,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  344,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  344,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  344,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  344,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  344,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  344,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  344,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  344,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  344,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  346,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  346,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  353,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  353,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  353,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  353,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  353,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  353,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  353,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  353,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  353,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  353,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  353,   -2 }, /* (120) alter_db_option ::= MINROWS NK_INTEGER */
  {  350,   -1 }, /* (121) integer_list ::= NK_INTEGER */
  {  350,   -3 }, /* (122) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  351,   -1 }, /* (123) variable_list ::= NK_VARIABLE */
  {  351,   -3 }, /* (124) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  352,   -1 }, /* (125) retention_list ::= retention */
  {  352,   -3 }, /* (126) retention_list ::= retention_list NK_COMMA retention */
  {  354,   -3 }, /* (127) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  347,    0 }, /* (128) speed_opt ::= */
  {  347,   -2 }, /* (129) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  348,    0 }, /* (130) start_opt ::= */
  {  348,   -3 }, /* (131) start_opt ::= START WITH NK_INTEGER */
  {  348,   -3 }, /* (132) start_opt ::= START WITH NK_STRING */
  {  348,   -4 }, /* (133) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  349,    0 }, /* (134) end_opt ::= */
  {  349,   -3 }, /* (135) end_opt ::= END WITH NK_INTEGER */
  {  349,   -3 }, /* (136) end_opt ::= END WITH NK_STRING */
  {  349,   -4 }, /* (137) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  328,   -9 }, /* (138) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  328,   -3 }, /* (139) cmd ::= CREATE TABLE multi_create_clause */
  {  328,   -9 }, /* (140) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  328,   -3 }, /* (141) cmd ::= DROP TABLE multi_drop_clause */
  {  328,   -4 }, /* (142) cmd ::= DROP STABLE exists_opt full_table_name */
  {  328,   -3 }, /* (143) cmd ::= ALTER TABLE alter_table_clause */
  {  328,   -3 }, /* (144) cmd ::= ALTER STABLE alter_table_clause */
  {  362,   -2 }, /* (145) alter_table_clause ::= full_table_name alter_table_options */
  {  362,   -5 }, /* (146) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  362,   -4 }, /* (147) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  362,   -5 }, /* (148) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  362,   -5 }, /* (149) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  362,   -5 }, /* (150) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  362,   -4 }, /* (151) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  362,   -5 }, /* (152) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  362,   -5 }, /* (153) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  362,   -6 }, /* (154) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  359,   -1 }, /* (155) multi_create_clause ::= create_subtable_clause */
  {  359,   -2 }, /* (156) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  367,  -10 }, /* (157) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  361,   -1 }, /* (158) multi_drop_clause ::= drop_table_clause */
  {  361,   -3 }, /* (159) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  370,   -2 }, /* (160) drop_table_clause ::= exists_opt full_table_name */
  {  368,    0 }, /* (161) specific_cols_opt ::= */
  {  368,   -3 }, /* (162) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  355,   -1 }, /* (163) full_table_name ::= table_name */
  {  355,   -3 }, /* (164) full_table_name ::= db_name NK_DOT table_name */
  {  356,   -1 }, /* (165) column_def_list ::= column_def */
  {  356,   -3 }, /* (166) column_def_list ::= column_def_list NK_COMMA column_def */
  {  373,   -2 }, /* (167) column_def ::= column_name type_name */
  {  373,   -4 }, /* (168) column_def ::= column_name type_name COMMENT NK_STRING */
  {  365,   -1 }, /* (169) type_name ::= BOOL */
  {  365,   -1 }, /* (170) type_name ::= TINYINT */
  {  365,   -1 }, /* (171) type_name ::= SMALLINT */
  {  365,   -1 }, /* (172) type_name ::= INT */
  {  365,   -1 }, /* (173) type_name ::= INTEGER */
  {  365,   -1 }, /* (174) type_name ::= BIGINT */
  {  365,   -1 }, /* (175) type_name ::= FLOAT */
  {  365,   -1 }, /* (176) type_name ::= DOUBLE */
  {  365,   -4 }, /* (177) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (178) type_name ::= TIMESTAMP */
  {  365,   -4 }, /* (179) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  365,   -2 }, /* (180) type_name ::= TINYINT UNSIGNED */
  {  365,   -2 }, /* (181) type_name ::= SMALLINT UNSIGNED */
  {  365,   -2 }, /* (182) type_name ::= INT UNSIGNED */
  {  365,   -2 }, /* (183) type_name ::= BIGINT UNSIGNED */
  {  365,   -1 }, /* (184) type_name ::= JSON */
  {  365,   -4 }, /* (185) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (186) type_name ::= MEDIUMBLOB */
  {  365,   -1 }, /* (187) type_name ::= BLOB */
  {  365,   -4 }, /* (188) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  365,   -1 }, /* (189) type_name ::= DECIMAL */
  {  365,   -4 }, /* (190) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  365,   -6 }, /* (191) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  357,    0 }, /* (192) tags_def_opt ::= */
  {  357,   -1 }, /* (193) tags_def_opt ::= tags_def */
  {  360,   -4 }, /* (194) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  358,    0 }, /* (195) table_options ::= */
  {  358,   -3 }, /* (196) table_options ::= table_options COMMENT NK_STRING */
  {  358,   -3 }, /* (197) table_options ::= table_options MAX_DELAY duration_list */
  {  358,   -3 }, /* (198) table_options ::= table_options WATERMARK duration_list */
  {  358,   -5 }, /* (199) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  358,   -3 }, /* (200) table_options ::= table_options TTL NK_INTEGER */
  {  358,   -5 }, /* (201) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  358,   -3 }, /* (202) table_options ::= table_options DELETE_MARK duration_list */
  {  363,   -1 }, /* (203) alter_table_options ::= alter_table_option */
  {  363,   -2 }, /* (204) alter_table_options ::= alter_table_options alter_table_option */
  {  376,   -2 }, /* (205) alter_table_option ::= COMMENT NK_STRING */
  {  376,   -2 }, /* (206) alter_table_option ::= TTL NK_INTEGER */
  {  374,   -1 }, /* (207) duration_list ::= duration_literal */
  {  374,   -3 }, /* (208) duration_list ::= duration_list NK_COMMA duration_literal */
  {  375,   -1 }, /* (209) rollup_func_list ::= rollup_func_name */
  {  375,   -3 }, /* (210) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  378,   -1 }, /* (211) rollup_func_name ::= function_name */
  {  378,   -1 }, /* (212) rollup_func_name ::= FIRST */
  {  378,   -1 }, /* (213) rollup_func_name ::= LAST */
  {  371,   -1 }, /* (214) col_name_list ::= col_name */
  {  371,   -3 }, /* (215) col_name_list ::= col_name_list NK_COMMA col_name */
  {  380,   -1 }, /* (216) col_name ::= column_name */
  {  328,   -2 }, /* (217) cmd ::= SHOW DNODES */
  {  328,   -2 }, /* (218) cmd ::= SHOW USERS */
  {  328,   -3 }, /* (219) cmd ::= SHOW USER PRIVILEGES */
  {  328,   -2 }, /* (220) cmd ::= SHOW DATABASES */
  {  328,   -4 }, /* (221) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  328,   -4 }, /* (222) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  328,   -3 }, /* (223) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  328,   -2 }, /* (224) cmd ::= SHOW MNODES */
  {  328,   -2 }, /* (225) cmd ::= SHOW QNODES */
  {  328,   -2 }, /* (226) cmd ::= SHOW FUNCTIONS */
  {  328,   -5 }, /* (227) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  328,   -2 }, /* (228) cmd ::= SHOW STREAMS */
  {  328,   -2 }, /* (229) cmd ::= SHOW ACCOUNTS */
  {  328,   -2 }, /* (230) cmd ::= SHOW APPS */
  {  328,   -2 }, /* (231) cmd ::= SHOW CONNECTIONS */
  {  328,   -2 }, /* (232) cmd ::= SHOW LICENCES */
  {  328,   -2 }, /* (233) cmd ::= SHOW GRANTS */
  {  328,   -4 }, /* (234) cmd ::= SHOW CREATE DATABASE db_name */
  {  328,   -4 }, /* (235) cmd ::= SHOW CREATE TABLE full_table_name */
  {  328,   -4 }, /* (236) cmd ::= SHOW CREATE STABLE full_table_name */
  {  328,   -2 }, /* (237) cmd ::= SHOW QUERIES */
  {  328,   -2 }, /* (238) cmd ::= SHOW SCORES */
  {  328,   -2 }, /* (239) cmd ::= SHOW TOPICS */
  {  328,   -2 }, /* (240) cmd ::= SHOW VARIABLES */
  {  328,   -3 }, /* (241) cmd ::= SHOW CLUSTER VARIABLES */
  {  328,   -3 }, /* (242) cmd ::= SHOW LOCAL VARIABLES */
  {  328,   -5 }, /* (243) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  328,   -2 }, /* (244) cmd ::= SHOW BNODES */
  {  328,   -2 }, /* (245) cmd ::= SHOW SNODES */
  {  328,   -2 }, /* (246) cmd ::= SHOW CLUSTER */
  {  328,   -2 }, /* (247) cmd ::= SHOW TRANSACTIONS */
  {  328,   -4 }, /* (248) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  328,   -2 }, /* (249) cmd ::= SHOW CONSUMERS */
  {  328,   -2 }, /* (250) cmd ::= SHOW SUBSCRIPTIONS */
  {  328,   -5 }, /* (251) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  328,   -7 }, /* (252) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  328,   -3 }, /* (253) cmd ::= SHOW VNODES NK_INTEGER */
  {  328,   -3 }, /* (254) cmd ::= SHOW VNODES NK_STRING */
  {  328,   -3 }, /* (255) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  328,   -3 }, /* (256) cmd ::= SHOW CLUSTER ALIVE */
  {  381,    0 }, /* (257) db_name_cond_opt ::= */
  {  381,   -2 }, /* (258) db_name_cond_opt ::= db_name NK_DOT */
  {  382,    0 }, /* (259) like_pattern_opt ::= */
  {  382,   -2 }, /* (260) like_pattern_opt ::= LIKE NK_STRING */
  {  383,   -1 }, /* (261) table_name_cond ::= table_name */
  {  384,    0 }, /* (262) from_db_opt ::= */
  {  384,   -2 }, /* (263) from_db_opt ::= FROM db_name */
  {  385,    0 }, /* (264) tag_list_opt ::= */
  {  385,   -1 }, /* (265) tag_list_opt ::= tag_item */
  {  385,   -3 }, /* (266) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  386,   -1 }, /* (267) tag_item ::= TBNAME */
  {  386,   -1 }, /* (268) tag_item ::= QTAGS */
  {  386,   -1 }, /* (269) tag_item ::= column_name */
  {  386,   -2 }, /* (270) tag_item ::= column_name column_alias */
  {  386,   -3 }, /* (271) tag_item ::= column_name AS column_alias */
  {  328,   -8 }, /* (272) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  328,   -9 }, /* (273) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  328,   -4 }, /* (274) cmd ::= DROP INDEX exists_opt full_index_name */
  {  388,   -1 }, /* (275) full_index_name ::= index_name */
  {  388,   -3 }, /* (276) full_index_name ::= db_name NK_DOT index_name */
  {  389,  -10 }, /* (277) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  389,  -12 }, /* (278) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  391,   -1 }, /* (279) func_list ::= func */
  {  391,   -3 }, /* (280) func_list ::= func_list NK_COMMA func */
  {  394,   -4 }, /* (281) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  395,   -1 }, /* (282) sma_func_name ::= function_name */
  {  395,   -1 }, /* (283) sma_func_name ::= COUNT */
  {  395,   -1 }, /* (284) sma_func_name ::= FIRST */
  {  395,   -1 }, /* (285) sma_func_name ::= LAST */
  {  395,   -1 }, /* (286) sma_func_name ::= LAST_ROW */
  {  393,    0 }, /* (287) sma_stream_opt ::= */
  {  393,   -3 }, /* (288) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  393,   -3 }, /* (289) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  393,   -3 }, /* (290) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  328,   -6 }, /* (291) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  328,   -7 }, /* (292) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  328,   -9 }, /* (293) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  328,   -7 }, /* (294) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  328,   -9 }, /* (295) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  328,   -4 }, /* (296) cmd ::= DROP TOPIC exists_opt topic_name */
  {  328,   -7 }, /* (297) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  328,   -2 }, /* (298) cmd ::= DESC full_table_name */
  {  328,   -2 }, /* (299) cmd ::= DESCRIBE full_table_name */
  {  328,   -3 }, /* (300) cmd ::= RESET QUERY CACHE */
  {  328,   -4 }, /* (301) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  328,   -4 }, /* (302) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  398,    0 }, /* (303) analyze_opt ::= */
  {  398,   -1 }, /* (304) analyze_opt ::= ANALYZE */
  {  399,    0 }, /* (305) explain_options ::= */
  {  399,   -3 }, /* (306) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  399,   -3 }, /* (307) explain_options ::= explain_options RATIO NK_FLOAT */
  {  328,  -10 }, /* (308) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  328,   -4 }, /* (309) cmd ::= DROP FUNCTION exists_opt function_name */
  {  401,    0 }, /* (310) agg_func_opt ::= */
  {  401,   -1 }, /* (311) agg_func_opt ::= AGGREGATE */
  {  402,    0 }, /* (312) bufsize_opt ::= */
  {  402,   -2 }, /* (313) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  328,  -12 }, /* (314) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  328,   -4 }, /* (315) cmd ::= DROP STREAM exists_opt stream_name */
  {  405,    0 }, /* (316) col_list_opt ::= */
  {  405,   -3 }, /* (317) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (318) tag_def_or_ref_opt ::= */
  {  406,   -1 }, /* (319) tag_def_or_ref_opt ::= tags_def */
  {  406,   -4 }, /* (320) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  404,    0 }, /* (321) stream_options ::= */
  {  404,   -3 }, /* (322) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  404,   -3 }, /* (323) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  404,   -4 }, /* (324) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  404,   -3 }, /* (325) stream_options ::= stream_options WATERMARK duration_literal */
  {  404,   -4 }, /* (326) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  404,   -3 }, /* (327) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  404,   -3 }, /* (328) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  404,   -4 }, /* (329) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  407,    0 }, /* (330) subtable_opt ::= */
  {  407,   -4 }, /* (331) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  328,   -3 }, /* (332) cmd ::= KILL CONNECTION NK_INTEGER */
  {  328,   -3 }, /* (333) cmd ::= KILL QUERY NK_STRING */
  {  328,   -3 }, /* (334) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  328,   -2 }, /* (335) cmd ::= BALANCE VGROUP */
  {  328,   -4 }, /* (336) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  328,   -4 }, /* (337) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  328,   -3 }, /* (338) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  409,   -2 }, /* (339) dnode_list ::= DNODE NK_INTEGER */
  {  409,   -3 }, /* (340) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  328,   -4 }, /* (341) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  328,   -1 }, /* (342) cmd ::= query_or_subquery */
  {  328,   -1 }, /* (343) cmd ::= insert_query */
  {  400,   -7 }, /* (344) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  400,   -4 }, /* (345) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  331,   -1 }, /* (346) literal ::= NK_INTEGER */
  {  331,   -1 }, /* (347) literal ::= NK_FLOAT */
  {  331,   -1 }, /* (348) literal ::= NK_STRING */
  {  331,   -1 }, /* (349) literal ::= NK_BOOL */
  {  331,   -2 }, /* (350) literal ::= TIMESTAMP NK_STRING */
  {  331,   -1 }, /* (351) literal ::= duration_literal */
  {  331,   -1 }, /* (352) literal ::= NULL */
  {  331,   -1 }, /* (353) literal ::= NK_QUESTION */
  {  377,   -1 }, /* (354) duration_literal ::= NK_VARIABLE */
  {  411,   -1 }, /* (355) signed ::= NK_INTEGER */
  {  411,   -2 }, /* (356) signed ::= NK_PLUS NK_INTEGER */
  {  411,   -2 }, /* (357) signed ::= NK_MINUS NK_INTEGER */
  {  411,   -1 }, /* (358) signed ::= NK_FLOAT */
  {  411,   -2 }, /* (359) signed ::= NK_PLUS NK_FLOAT */
  {  411,   -2 }, /* (360) signed ::= NK_MINUS NK_FLOAT */
  {  366,   -1 }, /* (361) signed_literal ::= signed */
  {  366,   -1 }, /* (362) signed_literal ::= NK_STRING */
  {  366,   -1 }, /* (363) signed_literal ::= NK_BOOL */
  {  366,   -2 }, /* (364) signed_literal ::= TIMESTAMP NK_STRING */
  {  366,   -1 }, /* (365) signed_literal ::= duration_literal */
  {  366,   -1 }, /* (366) signed_literal ::= NULL */
  {  366,   -1 }, /* (367) signed_literal ::= literal_func */
  {  366,   -1 }, /* (368) signed_literal ::= NK_QUESTION */
  {  413,   -1 }, /* (369) literal_list ::= signed_literal */
  {  413,   -3 }, /* (370) literal_list ::= literal_list NK_COMMA signed_literal */
  {  339,   -1 }, /* (371) db_name ::= NK_ID */
  {  372,   -1 }, /* (372) table_name ::= NK_ID */
  {  364,   -1 }, /* (373) column_name ::= NK_ID */
  {  379,   -1 }, /* (374) function_name ::= NK_ID */
  {  414,   -1 }, /* (375) table_alias ::= NK_ID */
  {  387,   -1 }, /* (376) column_alias ::= NK_ID */
  {  333,   -1 }, /* (377) user_name ::= NK_ID */
  {  340,   -1 }, /* (378) topic_name ::= NK_ID */
  {  403,   -1 }, /* (379) stream_name ::= NK_ID */
  {  397,   -1 }, /* (380) cgroup_name ::= NK_ID */
  {  390,   -1 }, /* (381) index_name ::= NK_ID */
  {  415,   -1 }, /* (382) expr_or_subquery ::= expression */
  {  408,   -1 }, /* (383) expression ::= literal */
  {  408,   -1 }, /* (384) expression ::= pseudo_column */
  {  408,   -1 }, /* (385) expression ::= column_reference */
  {  408,   -1 }, /* (386) expression ::= function_expression */
  {  408,   -1 }, /* (387) expression ::= case_when_expression */
  {  408,   -3 }, /* (388) expression ::= NK_LP expression NK_RP */
  {  408,   -2 }, /* (389) expression ::= NK_PLUS expr_or_subquery */
  {  408,   -2 }, /* (390) expression ::= NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (391) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  408,   -3 }, /* (392) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  408,   -3 }, /* (393) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  408,   -3 }, /* (394) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  408,   -3 }, /* (395) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  408,   -3 }, /* (396) expression ::= column_reference NK_ARROW NK_STRING */
  {  408,   -3 }, /* (397) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  408,   -3 }, /* (398) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  369,   -1 }, /* (399) expression_list ::= expr_or_subquery */
  {  369,   -3 }, /* (400) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  417,   -1 }, /* (401) column_reference ::= column_name */
  {  417,   -3 }, /* (402) column_reference ::= table_name NK_DOT column_name */
  {  416,   -1 }, /* (403) pseudo_column ::= ROWTS */
  {  416,   -1 }, /* (404) pseudo_column ::= TBNAME */
  {  416,   -3 }, /* (405) pseudo_column ::= table_name NK_DOT TBNAME */
  {  416,   -1 }, /* (406) pseudo_column ::= QSTART */
  {  416,   -1 }, /* (407) pseudo_column ::= QEND */
  {  416,   -1 }, /* (408) pseudo_column ::= QDURATION */
  {  416,   -1 }, /* (409) pseudo_column ::= WSTART */
  {  416,   -1 }, /* (410) pseudo_column ::= WEND */
  {  416,   -1 }, /* (411) pseudo_column ::= WDURATION */
  {  416,   -1 }, /* (412) pseudo_column ::= IROWTS */
  {  416,   -1 }, /* (413) pseudo_column ::= ISFILLED */
  {  416,   -1 }, /* (414) pseudo_column ::= QTAGS */
  {  418,   -4 }, /* (415) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  418,   -4 }, /* (416) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  418,   -6 }, /* (417) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  418,   -1 }, /* (418) function_expression ::= literal_func */
  {  412,   -3 }, /* (419) literal_func ::= noarg_func NK_LP NK_RP */
  {  412,   -1 }, /* (420) literal_func ::= NOW */
  {  422,   -1 }, /* (421) noarg_func ::= NOW */
  {  422,   -1 }, /* (422) noarg_func ::= TODAY */
  {  422,   -1 }, /* (423) noarg_func ::= TIMEZONE */
  {  422,   -1 }, /* (424) noarg_func ::= DATABASE */
  {  422,   -1 }, /* (425) noarg_func ::= CLIENT_VERSION */
  {  422,   -1 }, /* (426) noarg_func ::= SERVER_VERSION */
  {  422,   -1 }, /* (427) noarg_func ::= SERVER_STATUS */
  {  422,   -1 }, /* (428) noarg_func ::= CURRENT_USER */
  {  422,   -1 }, /* (429) noarg_func ::= USER */
  {  420,   -1 }, /* (430) star_func ::= COUNT */
  {  420,   -1 }, /* (431) star_func ::= FIRST */
  {  420,   -1 }, /* (432) star_func ::= LAST */
  {  420,   -1 }, /* (433) star_func ::= LAST_ROW */
  {  421,   -1 }, /* (434) star_func_para_list ::= NK_STAR */
  {  421,   -1 }, /* (435) star_func_para_list ::= other_para_list */
  {  423,   -1 }, /* (436) other_para_list ::= star_func_para */
  {  423,   -3 }, /* (437) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  424,   -1 }, /* (438) star_func_para ::= expr_or_subquery */
  {  424,   -3 }, /* (439) star_func_para ::= table_name NK_DOT NK_STAR */
  {  419,   -4 }, /* (440) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  419,   -5 }, /* (441) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  425,   -1 }, /* (442) when_then_list ::= when_then_expr */
  {  425,   -2 }, /* (443) when_then_list ::= when_then_list when_then_expr */
  {  428,   -4 }, /* (444) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  426,    0 }, /* (445) case_when_else_opt ::= */
  {  426,   -2 }, /* (446) case_when_else_opt ::= ELSE common_expression */
  {  429,   -3 }, /* (447) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  429,   -5 }, /* (448) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -6 }, /* (449) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  429,   -3 }, /* (450) predicate ::= expr_or_subquery IS NULL */
  {  429,   -4 }, /* (451) predicate ::= expr_or_subquery IS NOT NULL */
  {  429,   -3 }, /* (452) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  430,   -1 }, /* (453) compare_op ::= NK_LT */
  {  430,   -1 }, /* (454) compare_op ::= NK_GT */
  {  430,   -1 }, /* (455) compare_op ::= NK_LE */
  {  430,   -1 }, /* (456) compare_op ::= NK_GE */
  {  430,   -1 }, /* (457) compare_op ::= NK_NE */
  {  430,   -1 }, /* (458) compare_op ::= NK_EQ */
  {  430,   -1 }, /* (459) compare_op ::= LIKE */
  {  430,   -2 }, /* (460) compare_op ::= NOT LIKE */
  {  430,   -1 }, /* (461) compare_op ::= MATCH */
  {  430,   -1 }, /* (462) compare_op ::= NMATCH */
  {  430,   -1 }, /* (463) compare_op ::= CONTAINS */
  {  431,   -1 }, /* (464) in_op ::= IN */
  {  431,   -2 }, /* (465) in_op ::= NOT IN */
  {  432,   -3 }, /* (466) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  433,   -1 }, /* (467) boolean_value_expression ::= boolean_primary */
  {  433,   -2 }, /* (468) boolean_value_expression ::= NOT boolean_primary */
  {  433,   -3 }, /* (469) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  433,   -3 }, /* (470) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  434,   -1 }, /* (471) boolean_primary ::= predicate */
  {  434,   -3 }, /* (472) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  427,   -1 }, /* (473) common_expression ::= expr_or_subquery */
  {  427,   -1 }, /* (474) common_expression ::= boolean_value_expression */
  {  435,    0 }, /* (475) from_clause_opt ::= */
  {  435,   -2 }, /* (476) from_clause_opt ::= FROM table_reference_list */
  {  436,   -1 }, /* (477) table_reference_list ::= table_reference */
  {  436,   -3 }, /* (478) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  437,   -1 }, /* (479) table_reference ::= table_primary */
  {  437,   -1 }, /* (480) table_reference ::= joined_table */
  {  438,   -2 }, /* (481) table_primary ::= table_name alias_opt */
  {  438,   -4 }, /* (482) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  438,   -2 }, /* (483) table_primary ::= subquery alias_opt */
  {  438,   -1 }, /* (484) table_primary ::= parenthesized_joined_table */
  {  440,    0 }, /* (485) alias_opt ::= */
  {  440,   -1 }, /* (486) alias_opt ::= table_alias */
  {  440,   -2 }, /* (487) alias_opt ::= AS table_alias */
  {  442,   -3 }, /* (488) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  442,   -3 }, /* (489) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  439,   -6 }, /* (490) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  443,    0 }, /* (491) join_type ::= */
  {  443,   -1 }, /* (492) join_type ::= INNER */
  {  445,  -12 }, /* (493) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  446,    0 }, /* (494) set_quantifier_opt ::= */
  {  446,   -1 }, /* (495) set_quantifier_opt ::= DISTINCT */
  {  446,   -1 }, /* (496) set_quantifier_opt ::= ALL */
  {  447,   -1 }, /* (497) select_list ::= select_item */
  {  447,   -3 }, /* (498) select_list ::= select_list NK_COMMA select_item */
  {  455,   -1 }, /* (499) select_item ::= NK_STAR */
  {  455,   -1 }, /* (500) select_item ::= common_expression */
  {  455,   -2 }, /* (501) select_item ::= common_expression column_alias */
  {  455,   -3 }, /* (502) select_item ::= common_expression AS column_alias */
  {  455,   -3 }, /* (503) select_item ::= table_name NK_DOT NK_STAR */
  {  410,    0 }, /* (504) where_clause_opt ::= */
  {  410,   -2 }, /* (505) where_clause_opt ::= WHERE search_condition */
  {  448,    0 }, /* (506) partition_by_clause_opt ::= */
  {  448,   -3 }, /* (507) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  456,   -1 }, /* (508) partition_list ::= partition_item */
  {  456,   -3 }, /* (509) partition_list ::= partition_list NK_COMMA partition_item */
  {  457,   -1 }, /* (510) partition_item ::= expr_or_subquery */
  {  457,   -2 }, /* (511) partition_item ::= expr_or_subquery column_alias */
  {  457,   -3 }, /* (512) partition_item ::= expr_or_subquery AS column_alias */
  {  452,    0 }, /* (513) twindow_clause_opt ::= */
  {  452,   -6 }, /* (514) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  452,   -4 }, /* (515) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  452,   -6 }, /* (516) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -8 }, /* (517) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  452,   -7 }, /* (518) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  392,    0 }, /* (519) sliding_opt ::= */
  {  392,   -4 }, /* (520) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  451,    0 }, /* (521) fill_opt ::= */
  {  451,   -4 }, /* (522) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  451,   -6 }, /* (523) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  451,   -6 }, /* (524) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  458,   -1 }, /* (525) fill_mode ::= NONE */
  {  458,   -1 }, /* (526) fill_mode ::= PREV */
  {  458,   -1 }, /* (527) fill_mode ::= NULL */
  {  458,   -1 }, /* (528) fill_mode ::= NULL_F */
  {  458,   -1 }, /* (529) fill_mode ::= LINEAR */
  {  458,   -1 }, /* (530) fill_mode ::= NEXT */
  {  453,    0 }, /* (531) group_by_clause_opt ::= */
  {  453,   -3 }, /* (532) group_by_clause_opt ::= GROUP BY group_by_list */
  {  459,   -1 }, /* (533) group_by_list ::= expr_or_subquery */
  {  459,   -3 }, /* (534) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  454,    0 }, /* (535) having_clause_opt ::= */
  {  454,   -2 }, /* (536) having_clause_opt ::= HAVING search_condition */
  {  449,    0 }, /* (537) range_opt ::= */
  {  449,   -6 }, /* (538) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  450,    0 }, /* (539) every_opt ::= */
  {  450,   -4 }, /* (540) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  460,   -4 }, /* (541) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  461,   -1 }, /* (542) query_simple ::= query_specification */
  {  461,   -1 }, /* (543) query_simple ::= union_query_expression */
  {  465,   -4 }, /* (544) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  465,   -3 }, /* (545) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  466,   -1 }, /* (546) query_simple_or_subquery ::= query_simple */
  {  466,   -1 }, /* (547) query_simple_or_subquery ::= subquery */
  {  396,   -1 }, /* (548) query_or_subquery ::= query_expression */
  {  396,   -1 }, /* (549) query_or_subquery ::= subquery */
  {  462,    0 }, /* (550) order_by_clause_opt ::= */
  {  462,   -3 }, /* (551) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  463,    0 }, /* (552) slimit_clause_opt ::= */
  {  463,   -2 }, /* (553) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  463,   -4 }, /* (554) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  463,   -4 }, /* (555) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  464,    0 }, /* (556) limit_clause_opt ::= */
  {  464,   -2 }, /* (557) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  464,   -4 }, /* (558) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  464,   -4 }, /* (559) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  441,   -3 }, /* (560) subquery ::= NK_LP query_expression NK_RP */
  {  441,   -3 }, /* (561) subquery ::= NK_LP subquery NK_RP */
  {  444,   -1 }, /* (562) search_condition ::= common_expression */
  {  467,   -1 }, /* (563) sort_specification_list ::= sort_specification */
  {  467,   -3 }, /* (564) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  468,   -3 }, /* (565) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  469,    0 }, /* (566) ordering_specification_opt ::= */
  {  469,   -1 }, /* (567) ordering_specification_opt ::= ASC */
  {  469,   -1 }, /* (568) ordering_specification_opt ::= DESC */
  {  470,    0 }, /* (569) null_ordering_opt ::= */
  {  470,   -2 }, /* (570) null_ordering_opt ::= NULLS FIRST */
  {  470,   -2 }, /* (571) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,329,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy0, yymsp[0].minor.yy857); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy881, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy857 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy857 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy303, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy303 = yymsp[0].minor.yy303; }
  yymsp[0].minor.yy303 = yylhsminor.yy303;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy303 = yymsp[-2].minor.yy303 | yymsp[0].minor.yy303; }
  yymsp[-2].minor.yy303 = yylhsminor.yy303;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy303 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy881 = yymsp[-2].minor.yy881; }
  yymsp[-2].minor.yy881 = yylhsminor.yy881;
        break;
      case 42: /* priv_level ::= topic_name */
      case 282: /* sma_func_name ::= function_name */ yytestcase(yyruleno==282);
      case 486: /* alias_opt ::= table_alias */ yytestcase(yyruleno==486);
{ yylhsminor.yy881 = yymsp[0].minor.yy881; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy881, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy587); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy587); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 283: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==283);
      case 284: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==284);
      case 285: /* sma_func_name ::= LAST */ yytestcase(yyruleno==285);
      case 286: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==286);
      case 371: /* db_name ::= NK_ID */ yytestcase(yyruleno==371);
      case 372: /* table_name ::= NK_ID */ yytestcase(yyruleno==372);
      case 373: /* column_name ::= NK_ID */ yytestcase(yyruleno==373);
      case 374: /* function_name ::= NK_ID */ yytestcase(yyruleno==374);
      case 375: /* table_alias ::= NK_ID */ yytestcase(yyruleno==375);
      case 376: /* column_alias ::= NK_ID */ yytestcase(yyruleno==376);
      case 377: /* user_name ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* topic_name ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* stream_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* index_name ::= NK_ID */ yytestcase(yyruleno==381);
      case 421: /* noarg_func ::= NOW */ yytestcase(yyruleno==421);
      case 422: /* noarg_func ::= TODAY */ yytestcase(yyruleno==422);
      case 423: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==423);
      case 424: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==424);
      case 425: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==425);
      case 426: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==426);
      case 427: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==428);
      case 429: /* noarg_func ::= USER */ yytestcase(yyruleno==429);
      case 430: /* star_func ::= COUNT */ yytestcase(yyruleno==430);
      case 431: /* star_func ::= FIRST */ yytestcase(yyruleno==431);
      case 432: /* star_func ::= LAST */ yytestcase(yyruleno==432);
      case 433: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==433);
{ yylhsminor.yy881 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy881 = yylhsminor.yy881;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 303: /* analyze_opt ::= */ yytestcase(yyruleno==303);
      case 310: /* agg_func_opt ::= */ yytestcase(yyruleno==310);
      case 494: /* set_quantifier_opt ::= */ yytestcase(yyruleno==494);
{ yymsp[1].minor.yy587 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 304: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==304);
      case 311: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==311);
      case 495: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==495);
{ yymsp[0].minor.yy587 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy587, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy214); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy881, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy587 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy587 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy140 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_KEEP, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_RETENTIONS, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-3].minor.yy140, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy140 = setDatabaseOption(pCxt, yymsp[-2].minor.yy140, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy140 = createAlterDatabaseOptions(pCxt); yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yylhsminor.yy140, &yymsp[0].minor.yy809); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy140 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy140, &yymsp[0].minor.yy809); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy809.type = DB_OPTION_KEEP; yymsp[-1].minor.yy809.pList = yymsp[0].minor.yy220; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_PAGES; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_WAL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy809.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 122: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 340: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==340);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 123: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy220 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 124: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 125: /* retention_list ::= retention */
      case 155: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==155);
      case 158: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==158);
      case 165: /* column_def_list ::= column_def */ yytestcase(yyruleno==165);
      case 209: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==209);
      case 214: /* col_name_list ::= col_name */ yytestcase(yyruleno==214);
      case 265: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==265);
      case 279: /* func_list ::= func */ yytestcase(yyruleno==279);
      case 369: /* literal_list ::= signed_literal */ yytestcase(yyruleno==369);
      case 436: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==436);
      case 442: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==442);
      case 497: /* select_list ::= select_item */ yytestcase(yyruleno==497);
      case 508: /* partition_list ::= partition_item */ yytestcase(yyruleno==508);
      case 563: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==563);
{ yylhsminor.yy220 = createNodeList(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 126: /* retention_list ::= retention_list NK_COMMA retention */
      case 159: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==159);
      case 166: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==166);
      case 210: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==210);
      case 215: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==215);
      case 266: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==266);
      case 280: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==280);
      case 370: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==370);
      case 437: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==437);
      case 498: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==498);
      case 509: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==509);
      case 564: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==564);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 127: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy140 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 128: /* speed_opt ::= */
      case 312: /* bufsize_opt ::= */ yytestcase(yyruleno==312);
{ yymsp[1].minor.yy214 = 0; }
        break;
      case 129: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 313: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==313);
{ yymsp[-1].minor.yy214 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 130: /* start_opt ::= */
      case 134: /* end_opt ::= */ yytestcase(yyruleno==134);
      case 259: /* like_pattern_opt ::= */ yytestcase(yyruleno==259);
      case 330: /* subtable_opt ::= */ yytestcase(yyruleno==330);
      case 445: /* case_when_else_opt ::= */ yytestcase(yyruleno==445);
      case 475: /* from_clause_opt ::= */ yytestcase(yyruleno==475);
      case 504: /* where_clause_opt ::= */ yytestcase(yyruleno==504);
      case 513: /* twindow_clause_opt ::= */ yytestcase(yyruleno==513);
      case 519: /* sliding_opt ::= */ yytestcase(yyruleno==519);
      case 521: /* fill_opt ::= */ yytestcase(yyruleno==521);
      case 535: /* having_clause_opt ::= */ yytestcase(yyruleno==535);
      case 537: /* range_opt ::= */ yytestcase(yyruleno==537);
      case 539: /* every_opt ::= */ yytestcase(yyruleno==539);
      case 552: /* slimit_clause_opt ::= */ yytestcase(yyruleno==552);
      case 556: /* limit_clause_opt ::= */ yytestcase(yyruleno==556);
{ yymsp[1].minor.yy140 = NULL; }
        break;
      case 131: /* start_opt ::= START WITH NK_INTEGER */
      case 135: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==135);
{ yymsp[-2].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 132: /* start_opt ::= START WITH NK_STRING */
      case 136: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==136);
{ yymsp[-2].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 133: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 137: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==137);
{ yymsp[-3].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 138: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 140: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==140);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy220, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 139: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 141: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 142: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 143: /* cmd ::= ALTER TABLE alter_table_clause */
      case 342: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==342);
      case 343: /* cmd ::= insert_query */ yytestcase(yyruleno==343);
{ pCxt->pRootNode = yymsp[0].minor.yy140; }
        break;
      case 144: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy140); }
        break;
      case 145: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy140 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 146: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 147: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 148: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 149: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 150: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 151: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 152: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 153: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 154: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy140 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy140, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 156: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 443: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==443);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy220 = yylhsminor.yy220;
        break;
      case 157: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy140 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy587, yymsp[-8].minor.yy140, yymsp[-6].minor.yy140, yymsp[-5].minor.yy220, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-9].minor.yy140 = yylhsminor.yy140;
        break;
      case 160: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy140 = createDropTableClause(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 161: /* specific_cols_opt ::= */
      case 192: /* tags_def_opt ::= */ yytestcase(yyruleno==192);
      case 264: /* tag_list_opt ::= */ yytestcase(yyruleno==264);
      case 316: /* col_list_opt ::= */ yytestcase(yyruleno==316);
      case 318: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==318);
      case 506: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==506);
      case 531: /* group_by_clause_opt ::= */ yytestcase(yyruleno==531);
      case 550: /* order_by_clause_opt ::= */ yytestcase(yyruleno==550);
{ yymsp[1].minor.yy220 = NULL; }
        break;
      case 162: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 317: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==317);
{ yymsp[-2].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 163: /* full_table_name ::= table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 164: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 167: /* column_def ::= column_name type_name */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy881, yymsp[0].minor.yy682, NULL); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 168: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-2].minor.yy682, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 169: /* type_name ::= BOOL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 170: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 172: /* type_name ::= INT */
      case 173: /* type_name ::= INTEGER */ yytestcase(yyruleno==173);
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 174: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 175: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 176: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 177: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 178: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 179: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 181: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 182: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 183: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy682 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 184: /* type_name ::= JSON */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 185: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 186: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 187: /* type_name ::= BLOB */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 188: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 189: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 190: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 191: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy682 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 193: /* tags_def_opt ::= tags_def */
      case 319: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==319);
      case 435: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==435);
{ yylhsminor.yy220 = yymsp[0].minor.yy220; }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 194: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 320: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==320);
{ yymsp[-3].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 195: /* table_options ::= */
{ yymsp[1].minor.yy140 = createDefaultTableOptions(pCxt); }
        break;
      case 196: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 197: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 198: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 199: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 200: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 201: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-4].minor.yy140, TABLE_OPTION_SMA, yymsp[-1].minor.yy220); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 202: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-2].minor.yy140, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy220); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 203: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy140 = createAlterTableOptions(pCxt); yylhsminor.yy140 = setTableOption(pCxt, yylhsminor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 204: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy140 = setTableOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy809.type, &yymsp[0].minor.yy809.val); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 205: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 206: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy809.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy809.val = yymsp[0].minor.yy0; }
        break;
      case 207: /* duration_list ::= duration_literal */
      case 399: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==399);
{ yylhsminor.yy220 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 208: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 400: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==400);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 211: /* rollup_func_name ::= function_name */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy881, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 212: /* rollup_func_name ::= FIRST */
      case 213: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==213);
      case 268: /* tag_item ::= QTAGS */ yytestcase(yyruleno==268);
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 216: /* col_name ::= column_name */
      case 269: /* tag_item ::= column_name */ yytestcase(yyruleno==269);
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 217: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 218: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 219: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 220: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 221: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 222: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, OP_TYPE_LIKE); }
        break;
      case 223: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy140, NULL, OP_TYPE_LIKE); }
        break;
      case 224: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 226: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 227: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 228: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 229: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 230: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 231: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 232: /* cmd ::= SHOW LICENCES */
      case 233: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==233);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 234: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 235: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 236: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 237: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 238: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 239: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 240: /* cmd ::= SHOW VARIABLES */
      case 241: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==241);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 242: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 243: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy140); }
        break;
      case 244: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 245: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 247: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 248: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 249: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 250: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 251: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy140, yymsp[-1].minor.yy140, OP_TYPE_EQUAL); }
        break;
      case 252: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140, yymsp[-3].minor.yy220); }
        break;
      case 253: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 254: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 255: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy140,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 256: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 257: /* db_name_cond_opt ::= */
      case 262: /* from_db_opt ::= */ yytestcase(yyruleno==262);
{ yymsp[1].minor.yy140 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 258: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 260: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 261: /* table_name_cond ::= table_name */
{ yylhsminor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 263: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy140 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy881); }
        break;
      case 267: /* tag_item ::= TBNAME */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 270: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 271: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy881), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 272: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy587, yymsp[-3].minor.yy140, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 273: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy587, yymsp[-5].minor.yy140, yymsp[-3].minor.yy140, yymsp[-1].minor.yy220, NULL); }
        break;
      case 274: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy587, yymsp[0].minor.yy140); }
        break;
      case 275: /* full_index_name ::= index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy881); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 276: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy140 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 277: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy140 = createIndexOption(pCxt, yymsp[-7].minor.yy220, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 278: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy140 = createIndexOption(pCxt, yymsp[-9].minor.yy220, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 281: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 287: /* sma_stream_opt ::= */
      case 321: /* stream_options ::= */ yytestcase(yyruleno==321);
{ yymsp[1].minor.yy140 = createStreamOptions(pCxt); }
        break;
      case 288: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 289: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 290: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy140)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 291: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, yymsp[0].minor.yy140); }
        break;
      case 292: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy881, false); }
        break;
      case 293: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, &yymsp[0].minor.yy881, true); }
        break;
      case 294: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy587, &yymsp[-3].minor.yy881, yymsp[0].minor.yy140, false); }
        break;
      case 295: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy587, &yymsp[-5].minor.yy881, yymsp[0].minor.yy140, true); }
        break;
      case 296: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 297: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy587, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881); }
        break;
      case 298: /* cmd ::= DESC full_table_name */
      case 299: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==299);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 300: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 301: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 302: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==302);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy587, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 305: /* explain_options ::= */
{ yymsp[1].minor.yy140 = createDefaultExplainOptions(pCxt); }
        break;
      case 306: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy140 = setExplainVerbose(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 307: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy140 = setExplainRatio(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 308: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy587, yymsp[-8].minor.yy587, &yymsp[-5].minor.yy881, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy682, yymsp[0].minor.yy214); }
        break;
      case 309: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 314: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy587, &yymsp[-8].minor.yy881, yymsp[-5].minor.yy140, yymsp[-7].minor.yy140, yymsp[-3].minor.yy220, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, yymsp[-4].minor.yy220); }
        break;
      case 315: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy587, &yymsp[0].minor.yy881); }
        break;
      case 322: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 323: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==323);
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 324: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 325: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 326: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 327: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 328: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-2].minor.yy140, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 329: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy140 = setStreamOptions(pCxt, yymsp[-3].minor.yy140, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 331: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 520: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==520);
      case 540: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==540);
{ yymsp[-3].minor.yy140 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy140); }
        break;
      case 332: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 333: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 334: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 335: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 336: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 337: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy220); }
        break;
      case 338: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 339: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 341: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 344: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy140 = createInsertStmt(pCxt, yymsp[-4].minor.yy140, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 345: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy140 = createInsertStmt(pCxt, yymsp[-1].minor.yy140, NULL, yymsp[0].minor.yy140); }
        break;
      case 346: /* literal ::= NK_INTEGER */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 347: /* literal ::= NK_FLOAT */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 348: /* literal ::= NK_STRING */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 349: /* literal ::= NK_BOOL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 350: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 351: /* literal ::= duration_literal */
      case 361: /* signed_literal ::= signed */ yytestcase(yyruleno==361);
      case 382: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==382);
      case 383: /* expression ::= literal */ yytestcase(yyruleno==383);
      case 384: /* expression ::= pseudo_column */ yytestcase(yyruleno==384);
      case 385: /* expression ::= column_reference */ yytestcase(yyruleno==385);
      case 386: /* expression ::= function_expression */ yytestcase(yyruleno==386);
      case 387: /* expression ::= case_when_expression */ yytestcase(yyruleno==387);
      case 418: /* function_expression ::= literal_func */ yytestcase(yyruleno==418);
      case 467: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==467);
      case 471: /* boolean_primary ::= predicate */ yytestcase(yyruleno==471);
      case 473: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==473);
      case 474: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==474);
      case 477: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==477);
      case 479: /* table_reference ::= table_primary */ yytestcase(yyruleno==479);
      case 480: /* table_reference ::= joined_table */ yytestcase(yyruleno==480);
      case 484: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==484);
      case 542: /* query_simple ::= query_specification */ yytestcase(yyruleno==542);
      case 543: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==543);
      case 546: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==546);
      case 548: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==548);
{ yylhsminor.yy140 = yymsp[0].minor.yy140; }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 352: /* literal ::= NULL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 353: /* literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 354: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 355: /* signed ::= NK_INTEGER */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 356: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 357: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 358: /* signed ::= NK_FLOAT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 359: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 360: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 362: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 363: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 364: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 365: /* signed_literal ::= duration_literal */
      case 367: /* signed_literal ::= literal_func */ yytestcase(yyruleno==367);
      case 438: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==438);
      case 500: /* select_item ::= common_expression */ yytestcase(yyruleno==500);
      case 510: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==510);
      case 547: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==547);
      case 549: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==549);
      case 562: /* search_condition ::= common_expression */ yytestcase(yyruleno==562);
{ yylhsminor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 366: /* signed_literal ::= NULL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 368: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy140 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 388: /* expression ::= NK_LP expression NK_RP */
      case 472: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==472);
      case 561: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==561);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 389: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy140));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 390: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 391: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 392: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 393: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 394: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 395: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 396: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 397: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 398: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 401: /* column_reference ::= column_name */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy881, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy881)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 402: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881, createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy881)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 403: /* pseudo_column ::= ROWTS */
      case 404: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==404);
      case 406: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==406);
      case 407: /* pseudo_column ::= QEND */ yytestcase(yyruleno==407);
      case 408: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==408);
      case 409: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==409);
      case 410: /* pseudo_column ::= WEND */ yytestcase(yyruleno==410);
      case 411: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==411);
      case 412: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==413);
      case 414: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==414);
      case 420: /* literal_func ::= NOW */ yytestcase(yyruleno==420);
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 405: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy881)))); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 415: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 416: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==416);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy881, yymsp[-1].minor.yy220)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 417: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy682)); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 419: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy881, NULL)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 434: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy220 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 439: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 503: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==503);
{ yylhsminor.yy140 = createColumnNode(pCxt, &yymsp[-2].minor.yy881, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 440: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 441: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-2].minor.yy220, yymsp[-1].minor.yy140)); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 444: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy140 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
        break;
      case 446: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
        break;
      case 447: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 452: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==452);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy794, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 448: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 449: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 450: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 451: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL));
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 453: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_THAN; }
        break;
      case 454: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_THAN; }
        break;
      case 455: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy794 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 456: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy794 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 457: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy794 = OP_TYPE_NOT_EQUAL; }
        break;
      case 458: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy794 = OP_TYPE_EQUAL; }
        break;
      case 459: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy794 = OP_TYPE_LIKE; }
        break;
      case 460: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_LIKE; }
        break;
      case 461: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_MATCH; }
        break;
      case 462: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy794 = OP_TYPE_NMATCH; }
        break;
      case 463: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy794 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 464: /* in_op ::= IN */
{ yymsp[0].minor.yy794 = OP_TYPE_IN; }
        break;
      case 465: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy794 = OP_TYPE_NOT_IN; }
        break;
      case 466: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 468: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 469: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 470: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 476: /* from_clause_opt ::= FROM table_reference_list */
      case 505: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==505);
      case 536: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==536);
{ yymsp[-1].minor.yy140 = yymsp[0].minor.yy140; }
        break;
      case 478: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 481: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 482: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-3].minor.yy881, &yymsp[-1].minor.yy881, &yymsp[0].minor.yy881); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 483: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy140 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 485: /* alias_opt ::= */
{ yymsp[1].minor.yy881 = nil_token;  }
        break;
      case 487: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy881 = yymsp[0].minor.yy881; }
        break;
      case 488: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 489: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==489);
{ yymsp[-2].minor.yy140 = yymsp[-1].minor.yy140; }
        break;
      case 490: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, yymsp[-4].minor.yy852, yymsp[-5].minor.yy140, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 491: /* join_type ::= */
{ yymsp[1].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 492: /* join_type ::= INNER */
{ yymsp[0].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 493: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy140 = createSelectStmt(pCxt, yymsp[-10].minor.yy587, yymsp[-9].minor.yy220, yymsp[-8].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addWhereClause(pCxt, yymsp[-11].minor.yy140, yymsp[-7].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addPartitionByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-6].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy140, yymsp[-2].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addGroupByClause(pCxt, yymsp[-11].minor.yy140, yymsp[-1].minor.yy220);
                                                                                    yymsp[-11].minor.yy140 = addHavingClause(pCxt, yymsp[-11].minor.yy140, yymsp[0].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addRangeClause(pCxt, yymsp[-11].minor.yy140, yymsp[-5].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addEveryClause(pCxt, yymsp[-11].minor.yy140, yymsp[-4].minor.yy140);
                                                                                    yymsp[-11].minor.yy140 = addFillClause(pCxt, yymsp[-11].minor.yy140, yymsp[-3].minor.yy140);
                                                                                  }
        break;
      case 496: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy587 = false; }
        break;
      case 499: /* select_item ::= NK_STAR */
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 501: /* select_item ::= common_expression column_alias */
      case 511: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==511);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 502: /* select_item ::= common_expression AS column_alias */
      case 512: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==512);
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), &yymsp[0].minor.yy881); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 507: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 532: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==532);
      case 551: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==551);
{ yymsp[-2].minor.yy220 = yymsp[0].minor.yy220; }
        break;
      case 514: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy140 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 515: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy140 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 516: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 517: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 518: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy140 = createEventWindowNode(pCxt, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 522: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy140 = createFillNode(pCxt, yymsp[-1].minor.yy174, NULL); }
        break;
      case 523: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 524: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 525: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy174 = FILL_MODE_NONE; }
        break;
      case 526: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy174 = FILL_MODE_PREV; }
        break;
      case 527: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL; }
        break;
      case 528: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL_F; }
        break;
      case 529: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy174 = FILL_MODE_LINEAR; }
        break;
      case 530: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy174 = FILL_MODE_NEXT; }
        break;
      case 533: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy220 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 534: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 538: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy140 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 541: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy140 = addOrderByClause(pCxt, yymsp[-3].minor.yy140, yymsp[-2].minor.yy220);
                                                                                    yylhsminor.yy140 = addSlimitClause(pCxt, yylhsminor.yy140, yymsp[-1].minor.yy140);
                                                                                    yylhsminor.yy140 = addLimitClause(pCxt, yylhsminor.yy140, yymsp[0].minor.yy140);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 544: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 545: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 553: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 557: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==557);
{ yymsp[-1].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 554: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 558: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==558);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 555: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 559: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==559);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 560: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 565: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy140 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[-1].minor.yy866, yymsp[0].minor.yy697); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 566: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy866 = ORDER_ASC; }
        break;
      case 567: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy866 = ORDER_ASC; }
        break;
      case 568: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy866 = ORDER_DESC; }
        break;
      case 569: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy697 = NULL_ORDER_DEFAULT; }
        break;
      case 570: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_FIRST; }
        break;
      case 571: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
