/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 461
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy32;
  SToken yy77;
  int32_t yy248;
  int8_t yy287;
  ENullOrder yy385;
  EJoinType yy560;
  SNode* yy600;
  SNodeList* yy601;
  SAlterOption yy661;
  EOperatorType yy666;
  int64_t yy717;
  EFillMode yy798;
  bool yy841;
  SDataType yy888;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             722
#define YYNRULE              546
#define YYNTOKEN             325
#define YY_MAX_SHIFT         721
#define YY_MIN_SHIFTREDUCE   1069
#define YY_MAX_SHIFTREDUCE   1614
#define YY_ERROR_ACTION      1615
#define YY_ACCEPT_ACTION     1616
#define YY_NO_ACTION         1617
#define YY_MIN_REDUCE        1618
#define YY_MAX_REDUCE        2163
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3069)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    35,  280,  465, 1886,  466, 1654,  474,  372,  466, 1654,
 /*    10 */  1817, 1819,   45,   43, 1544, 1964, 1884,  598, 1760,  471,
 /*    20 */   367,  412, 1394,   38,   37,  467, 1960,   44,   42,   41,
 /*    30 */    40,   39,  172, 1474,  464, 1392,  232,  469, 1660, 1801,
 /*    40 */   576,  610,   38,   37, 2134,  547,   44,   42,   41,   40,
 /*    50 */    39,    8,  610,  338, 1871, 1956, 1962,  349, 1469,  575,
 /*    60 */   178,  324,  190,   18, 2135,  577,  621,   38,   37, 1977,
 /*    70 */  1400,   44,   42,   41,   40,   39,  473, 1420,  588,  469,
 /*    80 */  1660,   38,   37,   45,   43,   44,   42,   41,   40,   39,
 /*    90 */  2139,  367,  174, 1394, 1618,   14,  139,  331,   81, 2036,
 /*   100 */  1995,   80,   60,   27, 1474, 1811, 1392, 1421,  591,  137,
 /*   110 */   162, 1581, 1630, 1946,  611,  627,   48,  718,  128,  127,
 /*   120 */   126,  125,  124,  123,  122,  121,  120,   48,  129, 1469,
 /*   130 */   103,  163, 1476, 1477,   18,  504, 1725,  448, 1503, 1976,
 /*   140 */    64, 1400,  483, 2012,  138, 1771,  106, 1978,  631, 1980,
 /*   150 */  1981,  626, 1763,  621, 1419, 2139, 1824,  149,  175, 2134,
 /*   160 */  2065, 1449, 1459,  355,  361, 2061,   14, 1475, 1478,  260,
 /*   170 */  2073,  587, 1822,  130,  586, 2138,  610, 2134,  180, 2135,
 /*   180 */  2137, 2139, 1395, 1604, 1393, 2134, 2091,  533,  718, 1271,
 /*   190 */  1272,  263,  575,  178, 1504,  194,  193, 2135,  577,   49,
 /*   200 */   531, 2138,  529, 1476, 1477, 2135, 2136, 1398, 1399,   53,
 /*   210 */  1448, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458,  623,
 /*   220 */   619, 1467, 1468, 1470, 1471, 1472, 1473,    2,   60,   60,
 /*   230 */    89,   60, 1449, 1459, 2080, 1419,  159,  119, 1475, 1478,
 /*   240 */   118,  117,  116,  115,  114,  113,  112,  111,  110,  571,
 /*   250 */   262,  230,  181, 1395, 2080, 1393, 1537,   38,   37, 1641,
 /*   260 */  2077,   44,   42,   41,   40,   39,   34,  365, 1498, 1499,
 /*   270 */  1500, 1501, 1502, 1506, 1507, 1508, 1509,  181, 1398, 1399,
 /*   280 */  2076, 1448, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458,
 /*   290 */   623,  619, 1467, 1468, 1470, 1471, 1472, 1473,    2,  401,
 /*   300 */    11,   45,   43, 1946, 1964, 1394, 1548, 1640, 1995,  367,
 /*   310 */   413, 1394, 1419,   86,  326, 1960,  570,  537, 1392,  535,
 /*   320 */   403,  399, 1474,  414, 1392, 1228,  653,  652,  651, 1232,
 /*   330 */   650, 1234, 1235,  649, 1237,  646, 1687, 1243,  643, 1245,
 /*   340 */  1246,  640,  637,  216, 1956, 1962,  362, 1469,  160,  181,
 /*   350 */   406, 1946,   18, 1400, 1824,  621,  569, 1774,  167, 1400,
 /*   360 */  1121,  360, 1120,  665,  500,  496,  492,  488,  213, 1639,
 /*   370 */  1822, 1638,   45,   43, 1479,  215, 1324, 1325,  181,  181,
 /*   380 */   367,  181, 1394, 1824,   14,   44,   42,   41,   40,   39,
 /*   390 */   371, 1122,  552, 1474,  657, 1392, 2134, 1815, 1637, 1822,
 /*   400 */   718,  519,  518,  517,   85, 1102,  718,  211, 1619,  134,
 /*   410 */   513, 2140,  178, 1946,  512, 1946, 2135,  577, 1469,  511,
 /*   420 */   516, 1476, 1477, 1611, 1636,  510,  271,  272, 1400,  119,
 /*   430 */  1400,  270,  118,  117,  116,  115,  114,  113,  112,  111,
 /*   440 */   110,  588, 1946, 1420, 1104,  661, 1107, 1108, 1815, 1886,
 /*   450 */  1449, 1459,  611, 1450, 1824,   46, 1475, 1478, 1121,  358,
 /*   460 */  1120,  335, 1883,  598,  611, 1395,   54, 1393, 1946,  618,
 /*   470 */  1822, 1395,  137, 1393,  210,  204, 1635,  718,  183,  209,
 /*   480 */    38,   37,  479, 1771,   44,   42,   41,   40,   39, 1122,
 /*   490 */  1398, 1399, 1476, 1477,   84, 1771, 1398, 1399,  202, 1448,
 /*   500 */  1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458,  623,  619,
 /*   510 */  1467, 1468, 1470, 1471, 1472, 1473,    2, 1767, 1610, 1421,
 /*   520 */  1946, 1449, 1459,  588, 1188, 1634,  576, 1475, 1478,  611,
 /*   530 */  2134,  590,  176, 2073, 2074,  611,  135, 2078, 1419,  519,
 /*   540 */   518,  517, 1395,  410, 1393,  575,  178,  134,  513,  411,
 /*   550 */  2135,  577,  512, 1633,  137, 1339, 1340,  511,  516, 1190,
 /*   560 */  1771, 1977, 1632,  510, 1818, 1819, 1771, 1398, 1399, 1946,
 /*   570 */  1448, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458,  623,
 /*   580 */   619, 1467, 1468, 1470, 1471, 1472, 1473,    2,   45,   43,
 /*   590 */  1338, 1341, 1995, 1749,   84,  359,  367, 1946, 1394, 1418,
 /*   600 */   628, 1616,  613,  160, 2037, 1946, 1946,  627,  133, 1474,
 /*   610 */   231, 1392, 1773, 1495,  177, 2073, 2074, 1766,  135, 2078,
 /*   620 */    38,   37, 1977, 2080,   44,   42,   41,   40,   39,  524,
 /*   630 */   566, 1976, 1422,  611, 1469, 2012,  656, 1571,  106, 1978,
 /*   640 */   631, 1980, 1981,  626,  534,  621, 1400,  129,  140, 2075,
 /*   650 */   146, 2036, 2065, 1995,  509,  483,  361, 2061,  229,   45,
 /*   660 */    43,  628,  262,  611, 1771,  382, 1946,  367,  627, 1394,
 /*   670 */    11,   46,    9,  527, 1629, 1371, 1372,  420,  521, 1628,
 /*   680 */  1474, 1824, 1392,  228, 1762,   60,  563, 1569, 1570, 1572,
 /*   690 */  1573, 1933, 1976,  718, 1771, 1960, 2012, 1823,  611,  164,
 /*   700 */  1978,  631, 1980, 1981,  626, 1469,  621,  552, 1476, 1477,
 /*   710 */  1867, 2134,  281, 1627,  572,  567,  561, 1400, 1946,   67,
 /*   720 */  1748,  186,   66, 1946, 1956, 1962, 2140,  178, 1626, 1771,
 /*   730 */  1484, 2135,  577,   13,   12,  621, 1419, 1449, 1459,  389,
 /*   740 */   553, 2102,   14, 1475, 1478,  611,   38,   37, 1505, 1747,
 /*   750 */    44,   42,   41,   40,   39,   31,  172, 1946, 1395,  434,
 /*   760 */  1393,   38,   37, 1867,  718,   44,   42,   41,   40,   39,
 /*   770 */  1967,  405, 1946,  404,  188,  240, 1771, 1422, 1872, 1476,
 /*   780 */  1477, 1746, 1625, 1398, 1399, 1419, 1448, 1451, 1452, 1453,
 /*   790 */  1454, 1455, 1456, 1457, 1458,  623,  619, 1467, 1468, 1470,
 /*   800 */  1471, 1472, 1473,    2,   41,   40,   39,  611, 1449, 1459,
 /*   810 */   323,  665, 1417,   11, 1475, 1478,  370,   97, 1969,  442,
 /*   820 */    32,  435,  455,  580,  160,  454, 1946,  663, 1517, 1395,
 /*   830 */  1510, 1393, 1624, 1773, 1560,  181,  373, 1422, 1771, 1764,
 /*   840 */   426, 1965,  456, 1541,  160,  428,  151,  150,  660,  659,
 /*   850 */   658,  148, 1960, 1773, 1398, 1399,  677, 1448, 1451, 1452,
 /*   860 */  1453, 1454, 1455, 1456, 1457, 1458,  623,  619, 1467, 1468,
 /*   870 */  1470, 1471, 1472, 1473,    2, 1623, 1946, 1450,  515,  514,
 /*   880 */   161, 1956, 1962,   33,   52,  300,  339, 1684,  663,   38,
 /*   890 */    37,  551,  621,   44,   42,   41,   40,   39,  416,  298,
 /*   900 */    70, 2138,  615,   69, 2037,  689,  687,  151,  150,  660,
 /*   910 */   659,  658,  148, 1867,  662,  294, 1756, 1815, 1801, 1946,
 /*   920 */   187,  198,  461,  459,  192,  678, 1450, 1741,  452, 1107,
 /*   930 */  1108,  447,  446,  445,  444,  441,  440,  439,  438,  437,
 /*   940 */   433,  432,  431,  430,  340,  423,  422,  421,  594,  418,
 /*   950 */   417,  337,  695,  694,  693,  692,  377,   60,  691,  690,
 /*   960 */   141,  685,  684,  683,  682,  681,  680,  679,  153,  675,
 /*   970 */   674,  673,  376,  375,  670,  669,  668,  667,  666, 1622,
 /*   980 */   239,  611,  663, 1621, 1758,  611,  380, 1854,  379,  508,
 /*   990 */   552, 2085, 1537,  611, 2134,  481,  105, 1613, 1614,  482,
 /*  1000 */  1977,  151,  150,  660,  659,  658,  148, 1768, 1754, 2140,
 /*  1010 */   178,  507, 1771,   71, 2135,  577, 1771,   50,  143,    3,
 /*  1020 */   131,  583,  221, 1946, 1771,  219,  235, 1946,  552,  611,
 /*  1030 */   552, 1995, 2134, 1403, 2134, 1674,   78,   77,  409,  591,
 /*  1040 */   588,  185,  611,  145, 1946,  581,  627, 2140,  178, 2140,
 /*  1050 */   178, 1631, 2135,  577, 2135,  577,  548,  520,  540,  322,
 /*  1060 */  1771,  611,  397,   79,  395,  391,  387,  384,  381,  622,
 /*  1070 */  1976,  137, 1977, 1771, 2012,  592,   62,  106, 1978,  631,
 /*  1080 */  1980, 1981,  626,  611,  621, 1540, 1402,  223,  244,  175,
 /*  1090 */   222, 2065, 1771, 1667,  655,  361, 2061,  596,  611,  611,
 /*  1100 */   552, 1665,  225, 1995, 2134,  224,  227,  181,  611,  226,
 /*  1110 */   343,  628,  597,  275, 1771,  522, 1946, 2092,  627, 2140,
 /*  1120 */   178,  238,  606,  525, 2135,  577, 1977,  611, 1568, 1771,
 /*  1130 */  1771,  179, 2073, 2074,  149,  135, 2078, 1726,  429, 1771,
 /*  1140 */   246,  608, 1976,   13,   12,  102, 2012,   47, 2105,  106,
 /*  1150 */  1978,  631, 1980, 1981,  626,   99,  621, 1995, 1771,  268,
 /*  1160 */    87, 2154,  579, 2065,   68,  628,  257,  361, 2061,  214,
 /*  1170 */  1946,  344,  627,  342,  341,  147,  506,  564, 2099,  251,
 /*  1180 */   508,  611, 1406,  611,  149,   62,  595, 1977,   47,   47,
 /*  1190 */  1661,  635,  147, 1996,  149,  374, 1976,  609,  378, 1336,
 /*  1200 */  2012,  132,  507,  106, 1978,  631, 1980, 1981,  626, 1876,
 /*  1210 */   621,  273, 1771, 1655, 1771, 2154,  603, 2065, 1995, 1150,
 /*  1220 */   147,  361, 2061, 1812, 2095,  671,  628,  277,  364,  363,
 /*  1230 */   672, 1946, 2112,  627,  589, 1405, 1221, 1511, 1408,  713,
 /*  1240 */  1460,  293,    1, 1249, 1253,  584, 1260, 1169,  259, 1474,
 /*  1250 */  1977, 1401, 1167, 1258, 1151,  256,    4, 1976,  383,  388,
 /*  1260 */   336, 2012, 1358,  288,  106, 1978,  631, 1980, 1981,  626,
 /*  1270 */  1977,  621,  152,  191, 1469,  415, 2154, 1422, 2065, 1877,
 /*  1280 */   419, 1995,  361, 2061,  450,  424, 1400, 1417,  436,  628,
 /*  1290 */  1869,  443,  449,  559, 1946,  451,  627,  457,  195,  458,
 /*  1300 */   460, 1995,  462, 1423,  463, 1425,  475,  201,  472,  628,
 /*  1310 */  1420,  476,  203, 1424, 1946, 1426,  627,  477,  478,  480,
 /*  1320 */  1976,  206,  484,  208, 2012,   82,   83,  106, 1978,  631,
 /*  1330 */  1980, 1981,  626,  617,  621,  212, 1124,  541,  501, 2154,
 /*  1340 */  1976, 2065,  503,  502, 2012,  361, 2061,  106, 1978,  631,
 /*  1350 */  1980, 1981,  626,  505,  621, 1761, 2128,  109,  325, 2154,
 /*  1360 */   218, 2065, 1923, 1922, 1757,  361, 2061,  220,  539,  154,
 /*  1370 */   721,  233,  155, 1977, 1759, 1755, 2084,  156,  157,  542,
 /*  1380 */   289,  236,  549,  543,  287,  546, 2111,  565, 2096,  556,
 /*  1390 */   601, 2110,  562, 2087,  350,  568, 2106,  574, 1409,  171,
 /*  1400 */  1404,  250,  168,  252, 1995,  711,  707,  703,  699,  285,
 /*  1410 */   242,  245,  628,    7,  557,  555,  554, 1946, 1537,  627,
 /*  1420 */  2157,  585, 2133, 1412, 1414,  351,  582,  255,  136, 1421,
 /*  1430 */   593,  253, 1977,  254, 2081,  354,  619, 1467, 1468, 1470,
 /*  1440 */  1471, 1472, 1473, 1976,  290,  104,  264, 2012,  278,   92,
 /*  1450 */   106, 1978,  631, 1980, 1981,  626,  599,  621,  600, 1894,
 /*  1460 */  1893, 1892, 2040, 1995, 2065,  291,  604,  357,  361, 2061,
 /*  1470 */    94,  628,  292,   96,  605, 1772, 1946,  258,  627,   59,
 /*  1480 */  2046,  607,   98, 1816,  633,  295, 1977, 1742,  714,   51,
 /*  1490 */   715,  327,  717,  328, 1940,  319,  284,  299, 1939,  304,
 /*  1500 */    75,  297, 1976, 1938, 1937,   76, 2012, 1934,  385,  106,
 /*  1510 */  1978,  631, 1980, 1981,  626,  266,  621, 1995,  318,  308,
 /*  1520 */   265, 2038,  386, 2065, 1386,  628, 1387,  361, 2061,  390,
 /*  1530 */  1946,  184,  627, 1932,  392,  393,  394, 1365, 1931,  234,
 /*  1540 */   396, 1930, 1929,  398,  400, 1928,  402, 1977, 1361, 1360,
 /*  1550 */  1905, 1904,  407,  408, 1903, 1902, 1976, 1315, 1862, 1861,
 /*  1560 */  2012, 1859,  142,  106, 1978,  631, 1980, 1981,  626, 1858,
 /*  1570 */   621, 1857, 1860, 1856, 1855,  614, 1853, 2065, 1995, 1852,
 /*  1580 */  1851,  361, 2061,  189,  425, 1850,  628,  427, 1849, 1848,
 /*  1590 */  1847, 1946, 1846,  627,  144, 1834, 1833, 1832, 1831, 1830,
 /*  1600 */  1829, 1828, 1827, 1317,  453, 1977, 1845, 1844, 1843, 1842,
 /*  1610 */  1841, 1840, 1839, 1838, 1837, 1836, 1835, 1976, 1826, 1825,
 /*  1620 */  1689, 2012, 1196,  196,  107, 1978,  631, 1980, 1981,  626,
 /*  1630 */  1688,  621, 1686,  197, 1650,  199, 1995, 1110, 2065, 1109,
 /*  1640 */  1649, 1918, 2064, 2061,  628, 1912, 1901,  173,  207, 1946,
 /*  1650 */  1900,  627, 1966, 1880, 1750, 1143,   73, 1685, 1683, 1977,
 /*  1660 */  1681, 1679, 1677,  485,  200,   74,  205, 1664,  468,  470,
 /*  1670 */   487,  489,  493,  497,  491, 1976, 1663,  486,  495, 2012,
 /*  1680 */  1646,  490,  107, 1978,  631, 1980, 1981,  626, 1977,  621,
 /*  1690 */  1995,  494,  498, 1752,  499, 1264, 2065, 1751,  628, 1265,
 /*  1700 */   616, 2061, 1675, 1946, 1187,  627, 1186, 1185,   61, 1184,
 /*  1710 */   686, 1179,  688, 1181, 1180, 1668, 1178,  345,  346, 1995,
 /*  1720 */   523, 1666,  347,  526, 1645,  528, 1644,  625, 1643,  629,
 /*  1730 */   532,  108, 1946, 2012,  627, 1917,  107, 1978,  631, 1980,
 /*  1740 */  1981,  626,  530,  621,  217, 1376, 1977, 1375, 1378,   55,
 /*  1750 */  2065,  536, 1367, 1911,  330, 2061,  544, 1899, 1976, 1897,
 /*  1760 */    26, 2139, 2012,   19,   16,  316, 1978,  631, 1980, 1981,
 /*  1770 */   626,  624,  621,  612, 2030,  558,  560, 1995, 1583,   28,
 /*  1780 */   241,   58,  243, 1567,  248,  628,  166,  247,  249,   29,
 /*  1790 */  1946, 1967,  627,   30, 1559,   20,   63,   17,   88, 1598,
 /*  1800 */  1977, 1603, 1604, 1597,   21,  352, 1602,   56, 1601,  353,
 /*  1810 */  1534,  545, 1533,  261,  237, 1898, 1976, 1896, 1895,  348,
 /*  1820 */  2012,   57,  550,  165, 1978,  631, 1980, 1981,  626,    5,
 /*  1830 */   621, 1995,  158,    6,  169, 1879,   91,   90,   22,  628,
 /*  1840 */    93,  267, 1565,  269, 1946,  274,  627,   65, 1878,   95,
 /*  1850 */   279,   23,   99,   12, 1977, 1410, 2015,  170, 1464, 1462,
 /*  1860 */   620,  182,   36, 1441,   15,  602,  634,  369,  276,  638,
 /*  1870 */  1976, 1461, 1433,   24, 2012,  578, 2155,  107, 1978,  631,
 /*  1880 */  1980, 1981,  626,   25,  621, 1995,  632, 1250, 1247,  636,
 /*  1890 */   639, 2065, 1244,  628,  641,  642, 2062,  644, 1946,  645,
 /*  1900 */   627, 1238, 1236, 1486,  647, 1242, 1977,   10,  648, 1241,
 /*  1910 */  1227,  100,  282, 1259,  101,  654, 1496, 1240, 1239, 1255,
 /*  1920 */    72, 1141, 1977,  664, 1976, 1175, 1174,  630, 2012, 1173,
 /*  1930 */  1172,  164, 1978,  631, 1980, 1981,  626, 1995,  621, 1171,
 /*  1940 */  1170, 1485, 1168, 1166, 1165,  628, 1164, 1194,  676, 1162,
 /*  1950 */  1946, 1161,  627, 1995,  283, 1160, 1159, 1158, 1157, 1156,
 /*  1960 */  1189,  628, 1153, 1191, 1152, 1149, 1946, 1148,  627, 1147,
 /*  1970 */  1146, 1682,  696, 2103,  697,  698, 1976, 1680,  700,  701,
 /*  1980 */  2012,  702, 1678,  310, 1978,  631, 1980, 1981,  626,  704,
 /*  1990 */   621,  706, 1976,  705, 1676,  708, 2012,  709,  710,  165,
 /*  2000 */  1978,  631, 1980, 1981,  626, 1662,  621,  712, 1099, 1642,
 /*  2010 */   286, 1977,  716, 1617, 1396,  296,  719,  720, 1617, 1617,
 /*  2020 */  1617, 1617, 1617, 1617, 1617, 1617, 1617,  573, 1617, 1977,
 /*  2030 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2040 */  1617, 1617, 1995, 1617, 1617, 1617, 1617,  356, 1617, 1617,
 /*  2050 */   628, 1617, 2156, 1617, 1617, 1946, 1617,  627, 1617, 1617,
 /*  2060 */  1995, 1617, 1617, 1617, 1617, 1617, 1617, 1617,  625, 1617,
 /*  2070 */  1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617, 1617,
 /*  2080 */  1617, 1976, 1617, 1977, 1617, 2012, 1617, 1617,  317, 1978,
 /*  2090 */   631, 1980, 1981,  626, 1617,  621, 1617, 1617, 1617, 1976,
 /*  2100 */  1977, 1617, 1617, 2012, 1617, 1617,  316, 1978,  631, 1980,
 /*  2110 */  1981,  626, 1617,  621, 1995, 2031, 1617, 1617, 1617,  366,
 /*  2120 */  1617, 1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,  627,
 /*  2130 */  1617, 1995, 1617, 1617, 1617, 1617,  368, 1617, 1617,  628,
 /*  2140 */  1617, 1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617,
 /*  2150 */  1617, 1617, 1977, 1976, 1617, 1617, 1617, 2012, 1617, 1617,
 /*  2160 */   317, 1978,  631, 1980, 1981,  626, 1617,  621, 1977, 1617,
 /*  2170 */  1976, 1617, 1617, 1617, 2012, 1617, 1617,  317, 1978,  631,
 /*  2180 */  1980, 1981,  626, 1995,  621, 1617, 1617, 1617, 1617, 1617,
 /*  2190 */  1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,  627, 1995,
 /*  2200 */  1617, 1617, 1617, 1617, 1617, 1617, 1617,  628, 1617, 1617,
 /*  2210 */  1617, 1617, 1946, 1617,  627, 1617, 1617, 1617, 1617, 1617,
 /*  2220 */  1977, 1617,  538, 1617, 1617, 1617, 2012, 1617, 1617,  312,
 /*  2230 */  1978,  631, 1980, 1981,  626, 1617,  621, 1617, 1976, 1617,
 /*  2240 */  1617, 1617, 2012, 1617, 1617,  301, 1978,  631, 1980, 1981,
 /*  2250 */   626, 1995,  621, 1617, 1617, 1617, 1617, 1617, 1617,  628,
 /*  2260 */  1617, 1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617,
 /*  2270 */  1617, 1617, 1617, 1617, 1977, 1617, 1617, 1617, 1617, 1617,
 /*  2280 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2290 */  1976, 1617, 1617, 1617, 2012, 1977, 1617,  302, 1978,  631,
 /*  2300 */  1980, 1981,  626, 1617,  621, 1995, 1617, 1617, 1617, 1617,
 /*  2310 */  1617, 1617, 1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,
 /*  2320 */   627, 1617, 1617, 1617, 1617, 1617, 1995, 1617, 1617, 1617,
 /*  2330 */  1617, 1617, 1617, 1617,  628, 1617, 1617, 1617, 1617, 1946,
 /*  2340 */  1617,  627, 1617, 1617, 1976, 1617, 1617, 1617, 2012, 1617,
 /*  2350 */  1617,  303, 1978,  631, 1980, 1981,  626, 1617,  621, 1617,
 /*  2360 */  1617, 1617, 1617, 1617, 1617, 1976, 1617, 1617, 1617, 2012,
 /*  2370 */  1617, 1977,  309, 1978,  631, 1980, 1981,  626, 1617,  621,
 /*  2380 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1977,
 /*  2390 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2400 */  1617, 1617, 1995, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2410 */   628, 1617, 1617, 1617, 1617, 1946, 1617,  627, 1617, 1617,
 /*  2420 */  1995, 1617, 1617, 1617, 1617, 1617, 1617, 1617,  628, 1617,
 /*  2430 */  1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617, 1617,
 /*  2440 */  1617, 1976, 1617, 1977, 1617, 2012, 1617, 1617,  313, 1978,
 /*  2450 */   631, 1980, 1981,  626, 1617,  621, 1617, 1617, 1617, 1976,
 /*  2460 */  1977, 1617, 1617, 2012, 1617, 1617,  305, 1978,  631, 1980,
 /*  2470 */  1981,  626, 1617,  621, 1995, 1617, 1617, 1617, 1617, 1617,
 /*  2480 */  1617, 1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,  627,
 /*  2490 */  1617, 1995, 1617, 1617, 1617, 1617, 1617, 1617, 1617,  628,
 /*  2500 */  1617, 1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617,
 /*  2510 */  1617, 1617, 1977, 1976, 1617, 1617, 1617, 2012, 1617, 1617,
 /*  2520 */   314, 1978,  631, 1980, 1981,  626, 1617,  621, 1977, 1617,
 /*  2530 */  1976, 1617, 1617, 1617, 2012, 1617, 1617,  306, 1978,  631,
 /*  2540 */  1980, 1981,  626, 1995,  621, 1617, 1617, 1617, 1617, 1617,
 /*  2550 */  1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,  627, 1995,
 /*  2560 */  1617, 1617, 1617, 1617, 1617, 1617, 1617,  628, 1617, 1617,
 /*  2570 */  1617, 1617, 1946, 1617,  627, 1617, 1617, 1617, 1617, 1617,
 /*  2580 */  1977, 1617, 1976, 1617, 1617, 1617, 2012, 1617, 1617,  315,
 /*  2590 */  1978,  631, 1980, 1981,  626, 1617,  621, 1617, 1976, 1617,
 /*  2600 */  1617, 1617, 2012, 1977, 1617,  307, 1978,  631, 1980, 1981,
 /*  2610 */   626, 1995,  621, 1617, 1617, 1617, 1617, 1617, 1617,  628,
 /*  2620 */  1617, 1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617,
 /*  2630 */  1617, 1617, 1617, 1617, 1995, 1617, 1617, 1617, 1617, 1617,
 /*  2640 */  1617, 1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,  627,
 /*  2650 */  1976, 1617, 1617, 1617, 2012, 1977, 1617,  320, 1978,  631,
 /*  2660 */  1980, 1981,  626, 1617,  621, 1617, 1617, 1617, 1617, 1617,
 /*  2670 */  1617, 1617, 1617, 1976, 1617, 1617, 1617, 2012, 1617, 1617,
 /*  2680 */   321, 1978,  631, 1980, 1981,  626, 1995,  621, 1617, 1617,
 /*  2690 */  1617, 1617, 1617, 1617,  628, 1617, 1617, 1617, 1617, 1946,
 /*  2700 */  1617,  627, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2710 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1977, 1617,
 /*  2720 */  1617, 1617, 1617, 1617, 1617, 1976, 1617, 1617, 1617, 2012,
 /*  2730 */  1617, 1617, 1989, 1978,  631, 1980, 1981,  626, 1617,  621,
 /*  2740 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1995,
 /*  2750 */  1617, 1617, 1617, 1617, 1617, 1617, 1617,  628, 1617, 1617,
 /*  2760 */  1617, 1617, 1946, 1617,  627, 1617, 1617, 1617, 1617, 1617,
 /*  2770 */  1977, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2780 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1976, 1977,
 /*  2790 */  1617, 1617, 2012, 1617, 1617, 1988, 1978,  631, 1980, 1981,
 /*  2800 */   626, 1995,  621, 1617, 1617, 1617, 1617, 1617, 1617,  628,
 /*  2810 */  1617, 1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617,
 /*  2820 */  1995, 1617, 1617, 1617, 1617, 1617, 1617, 1617,  628, 1617,
 /*  2830 */  1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617, 1617,
 /*  2840 */  1976, 1977, 1617, 1617, 2012, 1617, 1617, 1987, 1978,  631,
 /*  2850 */  1980, 1981,  626, 1617,  621, 1617, 1617, 1977, 1617, 1976,
 /*  2860 */  1617, 1617, 1617, 2012, 1617, 1617,  332, 1978,  631, 1980,
 /*  2870 */  1981,  626, 1995,  621, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2880 */   628, 1617, 1617, 1617, 1617, 1946, 1617,  627, 1995, 1617,
 /*  2890 */  1617, 1617, 1617, 1617, 1617, 1617,  628, 1617, 1617, 1617,
 /*  2900 */  1617, 1946, 1617,  627, 1617, 1617, 1617, 1617, 1617, 1977,
 /*  2910 */  1617, 1976, 1617, 1617, 1617, 2012, 1617, 1617,  333, 1978,
 /*  2920 */   631, 1980, 1981,  626, 1617,  621, 1617, 1976, 1617, 1617,
 /*  2930 */  1617, 2012, 1977, 1617,  329, 1978,  631, 1980, 1981,  626,
 /*  2940 */  1995,  621, 1617, 1617, 1617, 1617, 1617, 1617,  628, 1617,
 /*  2950 */  1617, 1617, 1617, 1946, 1617,  627, 1617, 1617, 1617, 1617,
 /*  2960 */  1617, 1617, 1617, 1995, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  2970 */  1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,  627, 1976,
 /*  2980 */  1617, 1617, 1617, 2012, 1977, 1617,  334, 1978,  631, 1980,
 /*  2990 */  1981,  626, 1617,  621, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  3000 */  1617, 1617,  629, 1617, 1617, 1617, 2012, 1617, 1617,  312,
 /*  3010 */  1978,  631, 1980, 1981,  626, 1995,  621, 1617, 1617, 1617,
 /*  3020 */  1617, 1617, 1617,  628, 1617, 1617, 1617, 1617, 1946, 1617,
 /*  3030 */   627, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  3040 */  1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617, 1617,
 /*  3050 */  1617, 1617, 1617, 1617, 1976, 1617, 1617, 1617, 2012, 1617,
 /*  3060 */  1617,  311, 1978,  631, 1980, 1981,  626, 1617,  621,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   420,  421,  332,  374,  334,  335,  332,  370,  334,  335,
 /*    10 */   373,  374,   12,   13,   14,  361,  387,  388,  360,   14,
 /*    20 */    20,  336,   22,    8,    9,   20,  372,   12,   13,   14,
 /*    30 */    15,   16,  359,   33,  333,   35,  352,  336,  337,  355,
 /*    40 */   431,   20,    8,    9,  435,  393,   12,   13,   14,   15,
 /*    50 */    16,   39,   20,  380,  381,  401,  402,  403,   58,  450,
 /*    60 */   451,  376,   58,   63,  455,  456,  412,    8,    9,  328,
 /*    70 */    70,   12,   13,   14,   15,   16,  333,   20,  336,  336,
 /*    80 */   337,    8,    9,   12,   13,   12,   13,   14,   15,   16,
 /*    90 */     3,   20,  358,   22,    0,   95,  415,   63,   94,  418,
 /*   100 */   359,   97,   95,   44,   33,  371,   35,   20,  367,  367,
 /*   110 */   327,   96,  329,  372,  336,  374,   95,  117,   24,   25,
 /*   120 */    26,   27,   28,   29,   30,   31,   32,   95,  350,   58,
 /*   130 */   340,  343,  132,  133,   63,  357,  348,   79,  104,  398,
 /*   140 */     4,   70,   62,  402,  354,  367,  405,  406,  407,  408,
 /*   150 */   409,  410,  362,  412,   20,  431,  359,   44,  417,  435,
 /*   160 */   419,  161,  162,  366,  423,  424,   95,  167,  168,  427,
 /*   170 */   428,  429,  375,  431,  432,  451,   20,  435,  437,  455,
 /*   180 */   456,  431,  182,   96,  184,  435,  445,   21,  117,  132,
 /*   190 */   133,   58,  450,  451,  160,  137,  138,  455,  456,   95,
 /*   200 */    34,  451,   36,  132,  133,  455,  456,  207,  208,   96,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,   95,   95,
 /*   230 */    97,   95,  161,  162,  404,   20,  163,   21,  167,  168,
 /*   240 */    24,   25,   26,   27,   28,   29,   30,   31,   32,   20,
 /*   250 */   163,  127,  245,  182,  404,  184,  244,    8,    9,  328,
 /*   260 */   430,   12,   13,   14,   15,   16,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  245,  207,  208,
 /*   280 */   430,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  177,
 /*   300 */   229,   12,   13,  372,  361,   22,   14,  328,  359,   20,
 /*   310 */    22,   22,   20,  189,  190,  372,  367,  193,   35,  195,
 /*   320 */   198,  199,   33,   35,   35,  108,  109,  110,  111,  112,
 /*   330 */   113,  114,  115,  116,  117,  118,    0,  120,  121,  122,
 /*   340 */   123,  124,  125,   33,  401,  402,  403,   58,  359,  245,
 /*   350 */   389,  372,   63,   70,  359,  412,  407,  368,   48,   70,
 /*   360 */    20,  366,   22,   62,   54,   55,   56,   57,   58,  328,
 /*   370 */   375,  328,   12,   13,   14,   35,  161,  162,  245,  245,
 /*   380 */    20,  245,   22,  359,   95,   12,   13,   14,   15,   16,
 /*   390 */   366,   51,  431,   33,  369,   35,  435,  372,  328,  375,
 /*   400 */   117,   65,   66,   67,   94,    4,  117,   97,    0,   73,
 /*   410 */    74,  450,  451,  372,   78,  372,  455,  456,   58,   83,
 /*   420 */    84,  132,  133,  174,  328,   89,  126,  127,   70,   21,
 /*   430 */    70,  131,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   440 */    32,  336,  372,   20,   43,  369,   45,   46,  372,  374,
 /*   450 */   161,  162,  336,  161,  359,   95,  167,  168,   20,  384,
 /*   460 */    22,  366,  387,  388,  336,  182,  350,  184,  372,   63,
 /*   470 */   375,  182,  367,  184,  164,  165,  328,  117,  350,  169,
 /*   480 */     8,    9,  172,  367,   12,   13,   14,   15,   16,   51,
 /*   490 */   207,  208,  132,  133,  342,  367,  207,  208,  188,  210,
 /*   500 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   510 */   221,  222,  223,  224,  225,  226,  227,  365,  269,   20,
 /*   520 */   372,  161,  162,  336,   35,  328,  431,  167,  168,  336,
 /*   530 */   435,  426,  427,  428,  429,  336,  431,  432,   20,   65,
 /*   540 */    66,   67,  182,  350,  184,  450,  451,   73,   74,  350,
 /*   550 */   455,  456,   78,  328,  367,  132,  133,   83,   84,   70,
 /*   560 */   367,  328,  328,   89,  373,  374,  367,  207,  208,  372,
 /*   570 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   580 */   220,  221,  222,  223,  224,  225,  226,  227,   12,   13,
 /*   590 */   167,  168,  359,    0,  342,  351,   20,  372,   22,   20,
 /*   600 */   367,  325,  416,  359,  418,  372,  372,  374,  356,   33,
 /*   610 */   126,   35,  368,  207,  427,  428,  429,  365,  431,  432,
 /*   620 */     8,    9,  328,  404,   12,   13,   14,   15,   16,    4,
 /*   630 */   166,  398,   20,  336,   58,  402,  106,  207,  405,  406,
 /*   640 */   407,  408,  409,  410,   19,  412,   70,  350,  415,  430,
 /*   650 */   417,  418,  419,  359,  357,   62,  423,  424,   33,   12,
 /*   660 */    13,  367,  163,  336,  367,  389,  372,   20,  374,   22,
 /*   670 */   229,   95,  231,   48,  328,  191,  192,  350,   53,  328,
 /*   680 */    33,  359,   35,   58,  361,   95,  256,  257,  258,  259,
 /*   690 */   260,    0,  398,  117,  367,  372,  402,  375,  336,  405,
 /*   700 */   406,  407,  408,  409,  410,   58,  412,  431,  132,  133,
 /*   710 */   367,  435,  350,  328,  250,  251,  252,   70,  372,   94,
 /*   720 */     0,  378,   97,  372,  401,  402,  450,  451,  328,  367,
 /*   730 */    14,  455,  456,    1,    2,  412,   20,  161,  162,   48,
 /*   740 */   446,  447,   95,  167,  168,  336,    8,    9,  160,    0,
 /*   750 */    12,   13,   14,   15,   16,    2,  359,  372,  182,  350,
 /*   760 */   184,    8,    9,  367,  117,   12,   13,   14,   15,   16,
 /*   770 */    47,  181,  372,  183,  378,  163,  367,   20,  381,  132,
 /*   780 */   133,    0,  328,  207,  208,   20,  210,  211,  212,  213,
 /*   790 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   800 */   224,  225,  226,  227,   14,   15,   16,  336,  161,  162,
 /*   810 */    18,   62,   20,  229,  167,  168,  351,  340,   95,   27,
 /*   820 */   232,  350,   30,   44,  359,   33,  372,  107,   96,  182,
 /*   830 */   242,  184,  328,  368,   96,  245,  351,   20,  367,  362,
 /*   840 */    48,  361,   50,    4,  359,   53,  126,  127,  128,  129,
 /*   850 */   130,  131,  372,  368,  207,  208,   70,  210,  211,  212,
 /*   860 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   870 */   223,  224,  225,  226,  227,  328,  372,  161,  345,  346,
 /*   880 */    18,  401,  402,    2,  163,   23,   94,    0,  107,    8,
 /*   890 */     9,  170,  412,   12,   13,   14,   15,   16,  106,   37,
 /*   900 */    38,    3,  416,   41,  418,  345,  346,  126,  127,  128,
 /*   910 */   129,  130,  131,  367,  369,  352,  360,  372,  355,  372,
 /*   920 */   163,   59,   60,   61,  378,  347,  161,  349,  136,   45,
 /*   930 */    46,  139,  140,  141,  142,  143,  144,  145,  146,  147,
 /*   940 */   148,  149,  150,  151,  152,  153,  154,  155,  389,  157,
 /*   950 */   158,  159,   65,   66,   67,   68,   69,   95,   71,   72,
 /*   960 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   970 */    83,   84,   85,   86,   87,   88,   89,   90,   91,  328,
 /*   980 */   163,  336,  107,  328,  360,  336,  389,    0,  389,  107,
 /*   990 */   431,  243,  244,  336,  435,  350,  134,  132,  133,  350,
 /*  1000 */   328,  126,  127,  128,  129,  130,  131,  350,  360,  450,
 /*  1010 */   451,  129,  367,  106,  455,  456,  367,   42,   42,   44,
 /*  1020 */    44,   44,   99,  372,  367,  102,  360,  372,  431,  336,
 /*  1030 */   431,  359,  435,   35,  435,    0,  174,  175,  176,  367,
 /*  1040 */   336,  179,  336,  350,  372,  266,  374,  450,  451,  450,
 /*  1050 */   451,  329,  455,  456,  455,  456,  350,   22,  389,  197,
 /*  1060 */   367,  336,  200,  156,  202,  203,  204,  205,  206,  360,
 /*  1070 */   398,  367,  328,  367,  402,  350,   44,  405,  406,  407,
 /*  1080 */   408,  409,  410,  336,  412,  246,   35,   99,   44,  417,
 /*  1090 */   102,  419,  367,    0,  360,  423,  424,  350,  336,  336,
 /*  1100 */   431,    0,   99,  359,  435,  102,   99,  245,  336,  102,
 /*  1110 */    37,  367,  350,  350,  367,   22,  372,  445,  374,  450,
 /*  1120 */   451,   58,  350,   22,  455,  456,  328,  336,   96,  367,
 /*  1130 */   367,  427,  428,  429,   44,  431,  432,  348,  151,  367,
 /*  1140 */    96,  350,  398,    1,    2,   95,  402,   44,  382,  405,
 /*  1150 */   406,  407,  408,  409,  410,  105,  412,  359,  367,   44,
 /*  1160 */    97,  417,  264,  419,   44,  367,  459,  423,  424,  338,
 /*  1170 */   372,   98,  374,  100,  101,   44,  103,  448,  434,  442,
 /*  1180 */   107,  336,  184,  336,   44,   44,   96,  328,   44,   44,
 /*  1190 */     0,   44,   44,  359,   44,  350,  398,  350,  338,   96,
 /*  1200 */   402,   44,  129,  405,  406,  407,  408,  409,  410,  382,
 /*  1210 */   412,   96,  367,  335,  367,  417,   96,  419,  359,   35,
 /*  1220 */    44,  423,  424,  371,  382,   13,  367,   96,   12,   13,
 /*  1230 */    13,  372,  434,  374,  433,  184,   96,   96,   22,   49,
 /*  1240 */    96,   96,  436,   96,   96,  268,   96,   35,  452,   33,
 /*  1250 */   328,   35,   35,   96,   70,  425,  247,  398,  400,   48,
 /*  1260 */   399,  402,  180,  391,  405,  406,  407,  408,  409,  410,
 /*  1270 */   328,  412,   96,   42,   58,  379,  417,   20,  419,  382,
 /*  1280 */   379,  359,  423,  424,  160,  377,   70,   20,  336,  367,
 /*  1290 */   336,  379,  377,  434,  372,  377,  374,   93,  336,  344,
 /*  1300 */   336,  359,  336,   20,  330,   20,  395,  342,  330,  367,
 /*  1310 */    20,  374,  342,   20,  372,   20,  374,  337,  390,  337,
 /*  1320 */   398,  342,  336,  342,  402,  342,  342,  405,  406,  407,
 /*  1330 */   408,  409,  410,  117,  412,  342,   52,  397,  339,  417,
 /*  1340 */   398,  419,  330,  339,  402,  423,  424,  405,  406,  407,
 /*  1350 */   408,  409,  410,  359,  412,  359,  434,  336,  330,  417,
 /*  1360 */   359,  419,  372,  372,  359,  423,  424,  359,  196,  359,
 /*  1370 */    19,  340,  359,  328,  359,  359,  434,  359,  359,  187,
 /*  1380 */   395,  340,  336,  394,   33,  374,  441,  255,  382,  372,
 /*  1390 */   254,  441,  372,  444,  372,  372,  382,  173,  182,   48,
 /*  1400 */   184,  443,  441,  440,  359,   54,   55,   56,   57,   58,
 /*  1410 */   385,  385,  367,  261,  263,  262,  248,  372,  244,  374,
 /*  1420 */   460,  267,  454,  207,  208,  270,  265,  400,  367,   20,
 /*  1430 */   336,  439,  328,  438,  404,  337,  220,  221,  222,  223,
 /*  1440 */   224,  225,  226,  398,  385,   94,  340,  402,   97,  340,
 /*  1450 */   405,  406,  407,  408,  409,  410,  372,  412,  372,  372,
 /*  1460 */   372,  372,  417,  359,  419,  385,  165,  372,  423,  424,
 /*  1470 */   340,  367,  355,  340,  383,  367,  372,  453,  374,   95,
 /*  1480 */   422,  130,   95,  372,  363,  336,  328,  349,   36,  392,
 /*  1490 */   331,  386,  330,  386,    0,  396,  340,  326,    0,  353,
 /*  1500 */   189,  341,  398,    0,    0,   42,  402,    0,   35,  405,
 /*  1510 */   406,  407,  408,  409,  410,  164,  412,  359,  353,  353,
 /*  1520 */   169,  417,  201,  419,   35,  367,   35,  423,  424,  201,
 /*  1530 */   372,   35,  374,    0,   35,   35,  201,  186,    0,  188,
 /*  1540 */   201,    0,    0,   35,   22,    0,   35,  328,  184,  182,
 /*  1550 */     0,    0,  178,  177,    0,    0,  398,   47,    0,    0,
 /*  1560 */   402,    0,   42,  405,  406,  407,  408,  409,  410,    0,
 /*  1570 */   412,    0,    0,    0,    0,  417,    0,  419,  359,    0,
 /*  1580 */     0,  423,  424,  151,   35,    0,  367,  151,    0,    0,
 /*  1590 */     0,  372,    0,  374,   42,    0,    0,    0,    0,    0,
 /*  1600 */     0,    0,    0,   22,  135,  328,    0,    0,    0,    0,
 /*  1610 */     0,    0,    0,    0,    0,    0,    0,  398,    0,    0,
 /*  1620 */     0,  402,   35,   58,  405,  406,  407,  408,  409,  410,
 /*  1630 */     0,  412,    0,   58,    0,   42,  359,   14,  419,   14,
 /*  1640 */     0,    0,  423,  424,  367,    0,    0,   44,  173,  372,
 /*  1650 */     0,  374,   47,    0,    0,   64,   39,    0,    0,  328,
 /*  1660 */     0,    0,    0,   35,   40,   39,   39,    0,   47,   47,
 /*  1670 */    39,   35,   35,   35,   39,  398,    0,   48,   39,  402,
 /*  1680 */     0,   48,  405,  406,  407,  408,  409,  410,  328,  412,
 /*  1690 */   359,   48,   48,    0,   39,   22,  419,    0,  367,   35,
 /*  1700 */   423,  424,    0,  372,   35,  374,   35,   35,  104,   35,
 /*  1710 */    44,   22,   44,   35,   35,    0,   35,   22,   22,  359,
 /*  1720 */    50,    0,   22,   35,    0,   35,    0,  367,    0,  398,
 /*  1730 */    22,   20,  372,  402,  374,    0,  405,  406,  407,  408,
 /*  1740 */   409,  410,   35,  412,  102,   35,  328,   35,   96,  163,
 /*  1750 */   419,  194,   35,    0,  423,  424,   22,    0,  398,    0,
 /*  1760 */    95,    3,  402,   44,  249,  405,  406,  407,  408,  409,
 /*  1770 */   410,  411,  412,  413,  414,  228,  253,  359,   96,   95,
 /*  1780 */    95,   44,   96,   96,   44,  367,   95,   95,   47,   95,
 /*  1790 */   372,   47,  374,   44,   96,  249,    3,  249,   95,   35,
 /*  1800 */   328,   96,   96,   35,   44,   35,   35,  243,   35,   35,
 /*  1810 */    96,  163,   96,   47,  165,    0,  398,    0,    0,  163,
 /*  1820 */   402,   44,  171,  405,  406,  407,  408,  409,  410,  170,
 /*  1830 */   412,  359,  185,  170,   47,    0,   39,   95,   95,  367,
 /*  1840 */    39,   96,   96,   95,  372,   95,  374,   95,    0,   95,
 /*  1850 */    47,   44,  105,    2,  328,   22,   95,   47,   96,   96,
 /*  1860 */    95,   47,   95,   22,   95,  166,   35,   35,  164,   35,
 /*  1870 */   398,   96,   96,   95,  402,  457,  458,  405,  406,  407,
 /*  1880 */   408,  409,  410,   95,  412,  359,  106,   96,   96,   95,
 /*  1890 */    95,  419,   96,  367,   35,   95,  424,   35,  372,   95,
 /*  1900 */   374,   96,   96,  228,   35,  119,  328,  230,   95,  119,
 /*  1910 */    22,   95,   44,   35,   95,  107,  207,  119,  119,   22,
 /*  1920 */    95,   64,  328,   63,  398,   35,   35,  209,  402,   35,
 /*  1930 */    35,  405,  406,  407,  408,  409,  410,  359,  412,   35,
 /*  1940 */    35,  228,   35,   35,   35,  367,   35,   70,   92,   35,
 /*  1950 */   372,   35,  374,  359,   44,   35,   22,   35,   35,   35,
 /*  1960 */    35,  367,   35,   70,   35,   35,  372,   35,  374,   22,
 /*  1970 */    35,    0,   35,  447,   48,   39,  398,    0,   35,   48,
 /*  1980 */   402,   39,    0,  405,  406,  407,  408,  409,  410,   35,
 /*  1990 */   412,   39,  398,   48,    0,   35,  402,   48,   39,  405,
 /*  2000 */   406,  407,  408,  409,  410,    0,  412,   35,   35,    0,
 /*  2010 */    22,  328,   21,  461,   22,   22,   21,   20,  461,  461,
 /*  2020 */   461,  461,  461,  461,  461,  461,  461,  449,  461,  328,
 /*  2030 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2040 */   461,  461,  359,  461,  461,  461,  461,  364,  461,  461,
 /*  2050 */   367,  461,  458,  461,  461,  372,  461,  374,  461,  461,
 /*  2060 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2070 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2080 */   461,  398,  461,  328,  461,  402,  461,  461,  405,  406,
 /*  2090 */   407,  408,  409,  410,  461,  412,  461,  461,  461,  398,
 /*  2100 */   328,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2110 */   409,  410,  461,  412,  359,  414,  461,  461,  461,  364,
 /*  2120 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2130 */   461,  359,  461,  461,  461,  461,  364,  461,  461,  367,
 /*  2140 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2150 */   461,  461,  328,  398,  461,  461,  461,  402,  461,  461,
 /*  2160 */   405,  406,  407,  408,  409,  410,  461,  412,  328,  461,
 /*  2170 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2180 */   408,  409,  410,  359,  412,  461,  461,  461,  461,  461,
 /*  2190 */   461,  367,  461,  461,  461,  461,  372,  461,  374,  359,
 /*  2200 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2210 */   461,  461,  372,  461,  374,  461,  461,  461,  461,  461,
 /*  2220 */   328,  461,  398,  461,  461,  461,  402,  461,  461,  405,
 /*  2230 */   406,  407,  408,  409,  410,  461,  412,  461,  398,  461,
 /*  2240 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2250 */   410,  359,  412,  461,  461,  461,  461,  461,  461,  367,
 /*  2260 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2270 */   461,  461,  461,  461,  328,  461,  461,  461,  461,  461,
 /*  2280 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2290 */   398,  461,  461,  461,  402,  328,  461,  405,  406,  407,
 /*  2300 */   408,  409,  410,  461,  412,  359,  461,  461,  461,  461,
 /*  2310 */   461,  461,  461,  367,  461,  461,  461,  461,  372,  461,
 /*  2320 */   374,  461,  461,  461,  461,  461,  359,  461,  461,  461,
 /*  2330 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  2340 */   461,  374,  461,  461,  398,  461,  461,  461,  402,  461,
 /*  2350 */   461,  405,  406,  407,  408,  409,  410,  461,  412,  461,
 /*  2360 */   461,  461,  461,  461,  461,  398,  461,  461,  461,  402,
 /*  2370 */   461,  328,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2380 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  328,
 /*  2390 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2400 */   461,  461,  359,  461,  461,  461,  461,  461,  461,  461,
 /*  2410 */   367,  461,  461,  461,  461,  372,  461,  374,  461,  461,
 /*  2420 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2430 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2440 */   461,  398,  461,  328,  461,  402,  461,  461,  405,  406,
 /*  2450 */   407,  408,  409,  410,  461,  412,  461,  461,  461,  398,
 /*  2460 */   328,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2470 */   409,  410,  461,  412,  359,  461,  461,  461,  461,  461,
 /*  2480 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2490 */   461,  359,  461,  461,  461,  461,  461,  461,  461,  367,
 /*  2500 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2510 */   461,  461,  328,  398,  461,  461,  461,  402,  461,  461,
 /*  2520 */   405,  406,  407,  408,  409,  410,  461,  412,  328,  461,
 /*  2530 */   398,  461,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2540 */   408,  409,  410,  359,  412,  461,  461,  461,  461,  461,
 /*  2550 */   461,  367,  461,  461,  461,  461,  372,  461,  374,  359,
 /*  2560 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2570 */   461,  461,  372,  461,  374,  461,  461,  461,  461,  461,
 /*  2580 */   328,  461,  398,  461,  461,  461,  402,  461,  461,  405,
 /*  2590 */   406,  407,  408,  409,  410,  461,  412,  461,  398,  461,
 /*  2600 */   461,  461,  402,  328,  461,  405,  406,  407,  408,  409,
 /*  2610 */   410,  359,  412,  461,  461,  461,  461,  461,  461,  367,
 /*  2620 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2630 */   461,  461,  461,  461,  359,  461,  461,  461,  461,  461,
 /*  2640 */   461,  461,  367,  461,  461,  461,  461,  372,  461,  374,
 /*  2650 */   398,  461,  461,  461,  402,  328,  461,  405,  406,  407,
 /*  2660 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  461,
 /*  2670 */   461,  461,  461,  398,  461,  461,  461,  402,  461,  461,
 /*  2680 */   405,  406,  407,  408,  409,  410,  359,  412,  461,  461,
 /*  2690 */   461,  461,  461,  461,  367,  461,  461,  461,  461,  372,
 /*  2700 */   461,  374,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2710 */   461,  461,  461,  461,  461,  461,  461,  461,  328,  461,
 /*  2720 */   461,  461,  461,  461,  461,  398,  461,  461,  461,  402,
 /*  2730 */   461,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2740 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  359,
 /*  2750 */   461,  461,  461,  461,  461,  461,  461,  367,  461,  461,
 /*  2760 */   461,  461,  372,  461,  374,  461,  461,  461,  461,  461,
 /*  2770 */   328,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2780 */   461,  461,  461,  461,  461,  461,  461,  461,  398,  328,
 /*  2790 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2800 */   410,  359,  412,  461,  461,  461,  461,  461,  461,  367,
 /*  2810 */   461,  461,  461,  461,  372,  461,  374,  461,  461,  461,
 /*  2820 */   359,  461,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2830 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2840 */   398,  328,  461,  461,  402,  461,  461,  405,  406,  407,
 /*  2850 */   408,  409,  410,  461,  412,  461,  461,  328,  461,  398,
 /*  2860 */   461,  461,  461,  402,  461,  461,  405,  406,  407,  408,
 /*  2870 */   409,  410,  359,  412,  461,  461,  461,  461,  461,  461,
 /*  2880 */   367,  461,  461,  461,  461,  372,  461,  374,  359,  461,
 /*  2890 */   461,  461,  461,  461,  461,  461,  367,  461,  461,  461,
 /*  2900 */   461,  372,  461,  374,  461,  461,  461,  461,  461,  328,
 /*  2910 */   461,  398,  461,  461,  461,  402,  461,  461,  405,  406,
 /*  2920 */   407,  408,  409,  410,  461,  412,  461,  398,  461,  461,
 /*  2930 */   461,  402,  328,  461,  405,  406,  407,  408,  409,  410,
 /*  2940 */   359,  412,  461,  461,  461,  461,  461,  461,  367,  461,
 /*  2950 */   461,  461,  461,  372,  461,  374,  461,  461,  461,  461,
 /*  2960 */   461,  461,  461,  359,  461,  461,  461,  461,  461,  461,
 /*  2970 */   461,  367,  461,  461,  461,  461,  372,  461,  374,  398,
 /*  2980 */   461,  461,  461,  402,  328,  461,  405,  406,  407,  408,
 /*  2990 */   409,  410,  461,  412,  461,  461,  461,  461,  461,  461,
 /*  3000 */   461,  461,  398,  461,  461,  461,  402,  461,  461,  405,
 /*  3010 */   406,  407,  408,  409,  410,  359,  412,  461,  461,  461,
 /*  3020 */   461,  461,  461,  367,  461,  461,  461,  461,  372,  461,
 /*  3030 */   374,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  3040 */   461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  3050 */   461,  461,  461,  461,  398,  461,  461,  461,  402,  461,
 /*  3060 */   461,  405,  406,  407,  408,  409,  410,  461,  412,
};
#define YY_SHIFT_COUNT    (721)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2009)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   862,    0,   71,    0,  289,  289,  289,  289,  289,  289,
 /*    10 */   289,  289,  289,  289,  289,  360,  576,  576,  647,  576,
 /*    20 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    30 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    40 */   576,  576,  576,  576,  576,  576,  576,  576,   32,  134,
 /*    50 */    21,  590,  133,    7,  104,    7,   21,   21, 1216, 1216,
 /*    60 */     7, 1216, 1216,  136,    7,  423,  156,  156,  423,  401,
 /*    70 */   401,  215,   57,    5,    5,  156,  156,  156,  156,  156,
 /*    80 */   156,  156,  156,  156,  156,   80,  156,  156,  229,  156,
 /*    90 */   518,  156,  156,  156,  156,  518,  156,  156,  518,  156,
 /*   100 */   518,  518,  518,  156,  301,  792,   34,   34,  216,  474,
 /*   110 */   283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
 /*   120 */   283,  283,  283,  283,  283,  283,  283,  283,  283, 1073,
 /*   130 */    87,  215,   57,  593,  489,  499,  499,  499,  749,  441,
 /*   140 */   441,  489,  579,  579,  579,  530,  584,  518,  358,  518,
 /*   150 */   358,  358,  530,  786,  217,  217,  217,  217,  217,  217,
 /*   160 */   217, 1351,  408,  336,  612,  249,  430,  340,  464,  292,
 /*   170 */   716,  438,  757,  884,  882,  817,  748,   12,  898,  748,
 /*   180 */   975,  839,  765, 1009, 1211, 1082, 1231, 1257, 1231, 1124,
 /*   190 */  1267, 1267, 1231, 1124, 1124, 1204, 1267, 1267, 1267, 1283,
 /*   200 */  1283, 1285,   80, 1290,   80, 1293, 1295,   80, 1293,   80,
 /*   210 */    80,   80, 1267,   80, 1284, 1284, 1283,  518,  518,  518,
 /*   220 */   518,  518,  518,  518,  518,  518,  518,  518, 1267, 1283,
 /*   230 */   358,  358, 1172, 1285,  301, 1192, 1290,  301, 1267, 1257,
 /*   240 */  1257,  358, 1132, 1136,  358, 1132, 1136,  358,  358,  518,
 /*   250 */  1152, 1224, 1132, 1151, 1153, 1168, 1009, 1155, 1154, 1161,
 /*   260 */  1174,  579, 1409, 1267, 1293,  301,  301, 1136,  358,  358,
 /*   270 */   358,  358,  358, 1136,  358, 1301,  301,  530,  301,  579,
 /*   280 */  1384, 1387,  358,  786, 1267,  301, 1452, 1283, 3069, 3069,
 /*   290 */  3069, 3069, 3069, 3069, 3069, 3069, 3069,  887,  310,   94,
 /*   300 */   625,   15,   59,  738,  720,  753,  881,   73,  781,  472,
 /*   310 */   472,  472,  472,  472,  472,  472,  472,  472,  875,  124,
 /*   320 */   373,  373,  122,    4,   58,  166,  484,  300,  300,  790,
 /*   330 */   732,  588,  790,  790,  790,  113,  691,  288,  976,  907,
 /*   340 */   987,  923,  988, 1003, 1007, 1035, 1093, 1101, 1063, 1032,
 /*   350 */  1044,  865,  779,  977,  721, 1090, 1103, 1115, 1120, 1131,
 /*   360 */  1140, 1142, 1141,  998, 1051,  406, 1144,  723, 1145, 1147,
 /*   370 */  1148, 1150, 1157, 1176, 1050, 1212, 1217, 1184, 1190, 1494,
 /*   380 */  1498, 1311, 1503, 1504, 1463, 1507, 1473, 1321, 1489, 1491,
 /*   390 */  1496, 1328, 1533, 1499, 1500, 1335, 1538, 1339, 1541, 1508,
 /*   400 */  1542, 1522, 1545, 1511, 1364, 1367, 1550, 1551, 1374, 1376,
 /*   410 */  1554, 1555, 1510, 1558, 1559, 1561, 1520, 1569, 1571, 1572,
 /*   420 */  1573, 1574, 1576, 1579, 1580, 1432, 1549, 1585, 1436, 1588,
 /*   430 */  1589, 1590, 1592, 1606, 1607, 1608, 1609, 1610, 1611, 1612,
 /*   440 */  1613, 1614, 1615, 1616, 1552, 1595, 1596, 1597, 1598, 1599,
 /*   450 */  1581, 1600, 1601, 1602, 1469, 1618, 1619, 1587, 1620, 1565,
 /*   460 */  1630, 1575, 1632, 1634, 1593, 1617, 1603, 1605, 1623, 1621,
 /*   470 */  1625, 1622, 1640, 1624, 1626, 1641, 1645, 1646, 1627, 1475,
 /*   480 */  1650, 1653, 1654, 1591, 1657, 1658, 1628, 1629, 1631, 1660,
 /*   490 */  1636, 1633, 1635, 1661, 1637, 1643, 1639, 1662, 1638, 1644,
 /*   500 */  1655, 1667, 1676, 1680, 1693, 1604, 1642, 1664, 1673, 1697,
 /*   510 */  1669, 1671, 1672, 1674, 1666, 1668, 1678, 1679, 1689, 1681,
 /*   520 */  1702, 1695, 1715, 1696, 1670, 1721, 1700, 1688, 1724, 1690,
 /*   530 */  1726, 1707, 1728, 1708, 1711, 1710, 1712, 1557, 1652, 1665,
 /*   540 */  1735, 1586, 1717, 1753, 1647, 1734, 1648, 1649, 1757, 1759,
 /*   550 */  1656, 1651, 1758, 1719, 1515, 1684, 1682, 1685, 1659, 1547,
 /*   560 */  1663, 1523, 1686, 1737, 1687, 1691, 1692, 1694, 1698, 1740,
 /*   570 */  1741, 1744, 1703, 1749, 1546, 1705, 1706, 1793, 1760, 1548,
 /*   580 */  1764, 1768, 1770, 1771, 1773, 1774, 1714, 1716, 1766, 1564,
 /*   590 */  1777, 1787, 1815, 1817, 1818, 1835, 1742, 1797, 1743, 1745,
 /*   600 */  1746, 1748, 1750, 1699, 1752, 1848, 1801, 1704, 1754, 1747,
 /*   610 */  1605, 1803, 1807, 1675, 1677, 1713, 1851, 1833, 1709, 1761,
 /*   620 */  1762, 1765, 1763, 1767, 1775, 1810, 1769, 1778, 1814, 1776,
 /*   630 */  1841, 1718, 1788, 1780, 1791, 1831, 1832, 1794, 1792, 1834,
 /*   640 */  1795, 1796, 1859, 1800, 1805, 1862, 1804, 1806, 1869, 1813,
 /*   650 */  1786, 1790, 1798, 1799, 1888, 1808, 1816, 1868, 1819, 1878,
 /*   660 */  1825, 1868, 1868, 1897, 1857, 1860, 1890, 1891, 1894, 1895,
 /*   670 */  1904, 1905, 1907, 1908, 1909, 1911, 1877, 1856, 1910, 1914,
 /*   680 */  1916, 1920, 1934, 1922, 1923, 1924, 1893, 1666, 1925, 1668,
 /*   690 */  1927, 1929, 1930, 1932, 1947, 1935, 1971, 1937, 1926, 1936,
 /*   700 */  1977, 1943, 1931, 1942, 1982, 1954, 1945, 1952, 1994, 1960,
 /*   710 */  1949, 1959, 2005, 1972, 1973, 2009, 1988, 1991, 1992, 1993,
 /*   720 */  1995, 1997,
};
#define YY_REDUCE_COUNT (296)
#define YY_REDUCE_MIN   (-420)
#define YY_REDUCE_MAX   (2656)
static const short yy_reduce_ofst[] = {
 /*     0 */   276, -259,  233,  672,  744,  798,  859,  922,  942, 1045,
 /*    10 */  1104, 1158, 1219, 1277, 1331, 1360,  294, 1418, 1472, 1526,
 /*    20 */  1578, 1594, 1683, 1701, 1755, 1772, 1824, 1840, 1892, 1946,
 /*    30 */  1967, 2043, 2061, 2115, 2132, 2184, 2200, 2252, 2275, 2327,
 /*    40 */  2390, 2442, 2461, 2513, 2529, 2581, 2604, 2656, -258,   95,
 /*    50 */   105,  -39,  559,  597,  599,  669,  187,  704, -346,  -57,
 /*    60 */  -391,  323,  480, -276, -250,   75, -222,  297, -371, -330,
 /*    70 */  -326, -327, -363, -299, -257,  116,  128,  193,  199,  327,
 /*    80 */   409,  471,  645,  649,  657,  252,  693,  706,  -51,  725,
 /*    90 */  -203,  747,  762,  763,  772,  244,  791,  847,   -5,  362,
 /*   100 */   465,   24,  485,  845, -210, -315, -420, -420, -217, -212,
 /*   110 */   -69,  -21,   41,   43,   70,   96,  148,  197,  225,  234,
 /*   120 */   346,  351,  385,  400,  454,  504,  547,  651,  655, -266,
 /*   130 */  -170,  397,  191,  152,  533, -170, -150,  219,  477,  186,
 /*   140 */   486,  560,  343,  396,  546, -316, -319,  -11,   25,  322,
 /*   150 */    76,  545,  563,  578, -342,  556,  624,  648,  666,  709,
 /*   160 */   734, -348,  722,  789,  766,  707,  729,  831,  737,  834,
 /*   170 */   834,  860,  827,  878,  852,  842,  801,  801,  796,  801,
 /*   180 */   830,  806,  834,  858,  861,  872,  896,  897,  901,  908,
 /*   190 */   952,  954,  912,  915,  918,  955,  962,  964,  966,  974,
 /*   200 */   978,  911,  965,  937,  970,  980,  928,  979,  982,  981,
 /*   210 */   983,  984,  986,  993,  999, 1004, 1012,  994,  996, 1001,
 /*   220 */  1005, 1008, 1010, 1013, 1015, 1016, 1018, 1019, 1021, 1028,
 /*   230 */   990,  991,  940,  985, 1031,  989, 1011, 1041, 1046, 1006,
 /*   240 */  1014, 1017,  945, 1025, 1020,  950, 1026, 1022, 1023,  834,
 /*   250 */   949,  958,  961,  963,  992,  995, 1027,  960,  968, 1024,
 /*   260 */   801, 1061, 1030, 1094, 1098, 1106, 1109, 1059, 1084, 1086,
 /*   270 */  1087, 1088, 1089, 1080, 1095, 1091, 1130, 1117, 1133, 1108,
 /*   280 */  1058, 1121, 1111, 1138, 1149, 1156, 1159, 1162, 1097, 1099,
 /*   290 */  1105, 1107, 1146, 1165, 1166, 1160, 1171,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    10 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    20 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    30 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    40 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    50 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    60 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    70 */  1615, 1870, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*    80 */  1615, 1615, 1615, 1615, 1615, 1693, 1615, 1615, 1615, 1615,
 /*    90 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   100 */  1615, 1615, 1615, 1615, 1691, 1863, 2067, 1615, 1615, 1615,
 /*   110 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   120 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   130 */  2079, 1615, 1615, 1693, 1615, 2079, 2079, 2079, 1691, 2039,
 /*   140 */  2039, 1615, 1615, 1615, 1615, 1800, 1615, 1615, 1615, 1615,
 /*   150 */  1615, 1615, 1800, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   160 */  1615, 1913, 1615, 1615, 2104, 2158, 1615, 1615, 2107, 1615,
 /*   170 */  1615, 1615, 1875, 1615, 1753, 2094, 2071, 2085, 2142, 2072,
 /*   180 */  2069, 2088, 1615, 2098, 1615, 1906, 1868, 1615, 1868, 1865,
 /*   190 */  1615, 1615, 1868, 1865, 1865, 1744, 1615, 1615, 1615, 1615,
 /*   200 */  1615, 1615, 1693, 1615, 1693, 1615, 1615, 1693, 1615, 1693,
 /*   210 */  1693, 1693, 1615, 1693, 1672, 1672, 1615, 1615, 1615, 1615,
 /*   220 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   230 */  1615, 1615, 1926, 1615, 1691, 1915, 1615, 1691, 1615, 1615,
 /*   240 */  1615, 1615, 2115, 2113, 1615, 2115, 2113, 1615, 1615, 1615,
 /*   250 */  2127, 2123, 2115, 2131, 2129, 2100, 2098, 2161, 2148, 2144,
 /*   260 */  2085, 1615, 1615, 1615, 1615, 1691, 1691, 2113, 1615, 1615,
 /*   270 */  1615, 1615, 1615, 2113, 1615, 1615, 1691, 1615, 1691, 1615,
 /*   280 */  1615, 1769, 1615, 1615, 1615, 1691, 1647, 1615, 1908, 1919,
 /*   290 */  1891, 1891, 1803, 1803, 1803, 1694, 1620, 1615, 1615, 1615,
 /*   300 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 2126,
 /*   310 */  2125, 1994, 1615, 2043, 2042, 2041, 2032, 1993, 1765, 1615,
 /*   320 */  1992, 1991, 1615, 1615, 1615, 1615, 1615, 1882, 1881, 1985,
 /*   330 */  1615, 1615, 1986, 1984, 1983, 1615, 1615, 1615, 1615, 1615,
 /*   340 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   350 */  1615, 1615, 2145, 2149, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   360 */  1615, 2068, 1615, 1615, 1615, 1615, 1615, 1968, 1615, 1615,
 /*   370 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   380 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   390 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   400 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   410 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   420 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   430 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   440 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   450 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   460 */  1615, 1615, 1615, 1615, 1615, 1615, 1652, 1973, 1615, 1615,
 /*   470 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   480 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   490 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   500 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   510 */  1615, 1615, 1615, 1615, 1732, 1731, 1615, 1615, 1615, 1615,
 /*   520 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   530 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1976, 1615,
 /*   540 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   550 */  1615, 1615, 2141, 2101, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   560 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   570 */  1615, 1968, 1615, 2124, 1615, 1615, 2139, 1615, 2143, 1615,
 /*   580 */  1615, 1615, 1615, 1615, 1615, 1615, 2078, 2074, 1615, 1615,
 /*   590 */  2070, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   600 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   610 */  1967, 1615, 2029, 1615, 1615, 1615, 2063, 1615, 1615, 2014,
 /*   620 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1976,
 /*   630 */  1615, 1979, 1615, 1615, 1615, 1615, 1615, 1797, 1615, 1615,
 /*   640 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   650 */  1782, 1780, 1779, 1778, 1615, 1775, 1615, 1810, 1615, 1615,
 /*   660 */  1615, 1806, 1805, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   670 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1712, 1615,
 /*   680 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1704, 1615, 1703,
 /*   690 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   700 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   710 */  1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615, 1615,
 /*   720 */  1615, 1615,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  271,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  271,  /*      AFTER => ABORT */
  271,  /*     ATTACH => ABORT */
  271,  /*     BEFORE => ABORT */
  271,  /*      BEGIN => ABORT */
  271,  /*     BITAND => ABORT */
  271,  /*     BITNOT => ABORT */
  271,  /*      BITOR => ABORT */
  271,  /*     BLOCKS => ABORT */
  271,  /*     CHANGE => ABORT */
  271,  /*      COMMA => ABORT */
  271,  /*    COMPACT => ABORT */
  271,  /*     CONCAT => ABORT */
  271,  /*   CONFLICT => ABORT */
  271,  /*       COPY => ABORT */
  271,  /*   DEFERRED => ABORT */
  271,  /* DELIMITERS => ABORT */
  271,  /*     DETACH => ABORT */
  271,  /*     DIVIDE => ABORT */
  271,  /*        DOT => ABORT */
  271,  /*       EACH => ABORT */
  271,  /*       FAIL => ABORT */
  271,  /*       FILE => ABORT */
  271,  /*        FOR => ABORT */
  271,  /*       GLOB => ABORT */
  271,  /*         ID => ABORT */
  271,  /*  IMMEDIATE => ABORT */
  271,  /*     IMPORT => ABORT */
  271,  /*  INITIALLY => ABORT */
  271,  /*    INSTEAD => ABORT */
  271,  /*     ISNULL => ABORT */
  271,  /*        KEY => ABORT */
  271,  /*    MODULES => ABORT */
  271,  /*  NK_BITNOT => ABORT */
  271,  /*    NK_SEMI => ABORT */
  271,  /*    NOTNULL => ABORT */
  271,  /*         OF => ABORT */
  271,  /*       PLUS => ABORT */
  271,  /*  PRIVILEGE => ABORT */
  271,  /*      RAISE => ABORT */
  271,  /*    REPLACE => ABORT */
  271,  /*   RESTRICT => ABORT */
  271,  /*        ROW => ABORT */
  271,  /*       SEMI => ABORT */
  271,  /*       STAR => ABORT */
  271,  /*  STATEMENT => ABORT */
  271,  /*     STRICT => ABORT */
  271,  /*     STRING => ABORT */
  271,  /*      TIMES => ABORT */
  271,  /*     UPDATE => ABORT */
  271,  /*     VALUES => ABORT */
  271,  /*   VARIABLE => ABORT */
  271,  /*       VIEW => ABORT */
  271,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "COUNT",
  /*  168 */ "LAST_ROW",
  /*  169 */ "TOPIC",
  /*  170 */ "WITH",
  /*  171 */ "META",
  /*  172 */ "CONSUMER",
  /*  173 */ "GROUP",
  /*  174 */ "DESC",
  /*  175 */ "DESCRIBE",
  /*  176 */ "RESET",
  /*  177 */ "QUERY",
  /*  178 */ "CACHE",
  /*  179 */ "EXPLAIN",
  /*  180 */ "ANALYZE",
  /*  181 */ "VERBOSE",
  /*  182 */ "NK_BOOL",
  /*  183 */ "RATIO",
  /*  184 */ "NK_FLOAT",
  /*  185 */ "OUTPUTTYPE",
  /*  186 */ "AGGREGATE",
  /*  187 */ "BUFSIZE",
  /*  188 */ "STREAM",
  /*  189 */ "INTO",
  /*  190 */ "TRIGGER",
  /*  191 */ "AT_ONCE",
  /*  192 */ "WINDOW_CLOSE",
  /*  193 */ "IGNORE",
  /*  194 */ "EXPIRED",
  /*  195 */ "FILL_HISTORY",
  /*  196 */ "SUBTABLE",
  /*  197 */ "KILL",
  /*  198 */ "CONNECTION",
  /*  199 */ "TRANSACTION",
  /*  200 */ "BALANCE",
  /*  201 */ "VGROUP",
  /*  202 */ "MERGE",
  /*  203 */ "REDISTRIBUTE",
  /*  204 */ "SPLIT",
  /*  205 */ "DELETE",
  /*  206 */ "INSERT",
  /*  207 */ "NULL",
  /*  208 */ "NK_QUESTION",
  /*  209 */ "NK_ARROW",
  /*  210 */ "ROWTS",
  /*  211 */ "QSTART",
  /*  212 */ "QEND",
  /*  213 */ "QDURATION",
  /*  214 */ "WSTART",
  /*  215 */ "WEND",
  /*  216 */ "WDURATION",
  /*  217 */ "IROWTS",
  /*  218 */ "ISFILLED",
  /*  219 */ "CAST",
  /*  220 */ "NOW",
  /*  221 */ "TODAY",
  /*  222 */ "TIMEZONE",
  /*  223 */ "CLIENT_VERSION",
  /*  224 */ "SERVER_VERSION",
  /*  225 */ "SERVER_STATUS",
  /*  226 */ "CURRENT_USER",
  /*  227 */ "CASE",
  /*  228 */ "END",
  /*  229 */ "WHEN",
  /*  230 */ "THEN",
  /*  231 */ "ELSE",
  /*  232 */ "BETWEEN",
  /*  233 */ "IS",
  /*  234 */ "NK_LT",
  /*  235 */ "NK_GT",
  /*  236 */ "NK_LE",
  /*  237 */ "NK_GE",
  /*  238 */ "NK_NE",
  /*  239 */ "MATCH",
  /*  240 */ "NMATCH",
  /*  241 */ "CONTAINS",
  /*  242 */ "IN",
  /*  243 */ "JOIN",
  /*  244 */ "INNER",
  /*  245 */ "SELECT",
  /*  246 */ "DISTINCT",
  /*  247 */ "WHERE",
  /*  248 */ "PARTITION",
  /*  249 */ "BY",
  /*  250 */ "SESSION",
  /*  251 */ "STATE_WINDOW",
  /*  252 */ "EVENT_WINDOW",
  /*  253 */ "START",
  /*  254 */ "SLIDING",
  /*  255 */ "FILL",
  /*  256 */ "VALUE",
  /*  257 */ "NONE",
  /*  258 */ "PREV",
  /*  259 */ "LINEAR",
  /*  260 */ "NEXT",
  /*  261 */ "HAVING",
  /*  262 */ "RANGE",
  /*  263 */ "EVERY",
  /*  264 */ "ORDER",
  /*  265 */ "SLIMIT",
  /*  266 */ "SOFFSET",
  /*  267 */ "LIMIT",
  /*  268 */ "OFFSET",
  /*  269 */ "ASC",
  /*  270 */ "NULLS",
  /*  271 */ "ABORT",
  /*  272 */ "AFTER",
  /*  273 */ "ATTACH",
  /*  274 */ "BEFORE",
  /*  275 */ "BEGIN",
  /*  276 */ "BITAND",
  /*  277 */ "BITNOT",
  /*  278 */ "BITOR",
  /*  279 */ "BLOCKS",
  /*  280 */ "CHANGE",
  /*  281 */ "COMMA",
  /*  282 */ "COMPACT",
  /*  283 */ "CONCAT",
  /*  284 */ "CONFLICT",
  /*  285 */ "COPY",
  /*  286 */ "DEFERRED",
  /*  287 */ "DELIMITERS",
  /*  288 */ "DETACH",
  /*  289 */ "DIVIDE",
  /*  290 */ "DOT",
  /*  291 */ "EACH",
  /*  292 */ "FAIL",
  /*  293 */ "FILE",
  /*  294 */ "FOR",
  /*  295 */ "GLOB",
  /*  296 */ "ID",
  /*  297 */ "IMMEDIATE",
  /*  298 */ "IMPORT",
  /*  299 */ "INITIALLY",
  /*  300 */ "INSTEAD",
  /*  301 */ "ISNULL",
  /*  302 */ "KEY",
  /*  303 */ "MODULES",
  /*  304 */ "NK_BITNOT",
  /*  305 */ "NK_SEMI",
  /*  306 */ "NOTNULL",
  /*  307 */ "OF",
  /*  308 */ "PLUS",
  /*  309 */ "PRIVILEGE",
  /*  310 */ "RAISE",
  /*  311 */ "REPLACE",
  /*  312 */ "RESTRICT",
  /*  313 */ "ROW",
  /*  314 */ "SEMI",
  /*  315 */ "STAR",
  /*  316 */ "STATEMENT",
  /*  317 */ "STRICT",
  /*  318 */ "STRING",
  /*  319 */ "TIMES",
  /*  320 */ "UPDATE",
  /*  321 */ "VALUES",
  /*  322 */ "VARIABLE",
  /*  323 */ "VIEW",
  /*  324 */ "WAL",
  /*  325 */ "cmd",
  /*  326 */ "account_options",
  /*  327 */ "alter_account_options",
  /*  328 */ "literal",
  /*  329 */ "alter_account_option",
  /*  330 */ "user_name",
  /*  331 */ "sysinfo_opt",
  /*  332 */ "privileges",
  /*  333 */ "priv_level",
  /*  334 */ "priv_type_list",
  /*  335 */ "priv_type",
  /*  336 */ "db_name",
  /*  337 */ "topic_name",
  /*  338 */ "dnode_endpoint",
  /*  339 */ "force_opt",
  /*  340 */ "not_exists_opt",
  /*  341 */ "db_options",
  /*  342 */ "exists_opt",
  /*  343 */ "alter_db_options",
  /*  344 */ "speed_opt",
  /*  345 */ "integer_list",
  /*  346 */ "variable_list",
  /*  347 */ "retention_list",
  /*  348 */ "alter_db_option",
  /*  349 */ "retention",
  /*  350 */ "full_table_name",
  /*  351 */ "column_def_list",
  /*  352 */ "tags_def_opt",
  /*  353 */ "table_options",
  /*  354 */ "multi_create_clause",
  /*  355 */ "tags_def",
  /*  356 */ "multi_drop_clause",
  /*  357 */ "alter_table_clause",
  /*  358 */ "alter_table_options",
  /*  359 */ "column_name",
  /*  360 */ "type_name",
  /*  361 */ "signed_literal",
  /*  362 */ "create_subtable_clause",
  /*  363 */ "specific_cols_opt",
  /*  364 */ "expression_list",
  /*  365 */ "drop_table_clause",
  /*  366 */ "col_name_list",
  /*  367 */ "table_name",
  /*  368 */ "column_def",
  /*  369 */ "duration_list",
  /*  370 */ "rollup_func_list",
  /*  371 */ "alter_table_option",
  /*  372 */ "duration_literal",
  /*  373 */ "rollup_func_name",
  /*  374 */ "function_name",
  /*  375 */ "col_name",
  /*  376 */ "db_name_cond_opt",
  /*  377 */ "like_pattern_opt",
  /*  378 */ "table_name_cond",
  /*  379 */ "from_db_opt",
  /*  380 */ "tag_list_opt",
  /*  381 */ "tag_item",
  /*  382 */ "column_alias",
  /*  383 */ "index_options",
  /*  384 */ "func_list",
  /*  385 */ "sliding_opt",
  /*  386 */ "sma_stream_opt",
  /*  387 */ "func",
  /*  388 */ "sma_func_name",
  /*  389 */ "query_or_subquery",
  /*  390 */ "cgroup_name",
  /*  391 */ "analyze_opt",
  /*  392 */ "explain_options",
  /*  393 */ "agg_func_opt",
  /*  394 */ "bufsize_opt",
  /*  395 */ "stream_name",
  /*  396 */ "stream_options",
  /*  397 */ "subtable_opt",
  /*  398 */ "expression",
  /*  399 */ "dnode_list",
  /*  400 */ "where_clause_opt",
  /*  401 */ "signed",
  /*  402 */ "literal_func",
  /*  403 */ "literal_list",
  /*  404 */ "table_alias",
  /*  405 */ "expr_or_subquery",
  /*  406 */ "pseudo_column",
  /*  407 */ "column_reference",
  /*  408 */ "function_expression",
  /*  409 */ "case_when_expression",
  /*  410 */ "star_func",
  /*  411 */ "star_func_para_list",
  /*  412 */ "noarg_func",
  /*  413 */ "other_para_list",
  /*  414 */ "star_func_para",
  /*  415 */ "when_then_list",
  /*  416 */ "case_when_else_opt",
  /*  417 */ "common_expression",
  /*  418 */ "when_then_expr",
  /*  419 */ "predicate",
  /*  420 */ "compare_op",
  /*  421 */ "in_op",
  /*  422 */ "in_predicate_value",
  /*  423 */ "boolean_value_expression",
  /*  424 */ "boolean_primary",
  /*  425 */ "from_clause_opt",
  /*  426 */ "table_reference_list",
  /*  427 */ "table_reference",
  /*  428 */ "table_primary",
  /*  429 */ "joined_table",
  /*  430 */ "alias_opt",
  /*  431 */ "subquery",
  /*  432 */ "parenthesized_joined_table",
  /*  433 */ "join_type",
  /*  434 */ "search_condition",
  /*  435 */ "query_specification",
  /*  436 */ "set_quantifier_opt",
  /*  437 */ "select_list",
  /*  438 */ "partition_by_clause_opt",
  /*  439 */ "range_opt",
  /*  440 */ "every_opt",
  /*  441 */ "fill_opt",
  /*  442 */ "twindow_clause_opt",
  /*  443 */ "group_by_clause_opt",
  /*  444 */ "having_clause_opt",
  /*  445 */ "select_item",
  /*  446 */ "partition_list",
  /*  447 */ "partition_item",
  /*  448 */ "fill_mode",
  /*  449 */ "group_by_list",
  /*  450 */ "query_expression",
  /*  451 */ "query_simple",
  /*  452 */ "order_by_clause_opt",
  /*  453 */ "slimit_clause_opt",
  /*  454 */ "limit_clause_opt",
  /*  455 */ "union_query_expression",
  /*  456 */ "query_simple_or_subquery",
  /*  457 */ "sort_specification_list",
  /*  458 */ "sort_specification",
  /*  459 */ "ordering_specification_opt",
  /*  460 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 261 */ "cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 262 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "func_list ::= func",
 /* 266 */ "func_list ::= func_list NK_COMMA func",
 /* 267 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 268 */ "sma_func_name ::= function_name",
 /* 269 */ "sma_func_name ::= COUNT",
 /* 270 */ "sma_func_name ::= FIRST",
 /* 271 */ "sma_func_name ::= LAST",
 /* 272 */ "sma_func_name ::= LAST_ROW",
 /* 273 */ "sma_stream_opt ::=",
 /* 274 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 275 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 276 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 278 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 279 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 280 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 282 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 283 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 284 */ "cmd ::= DESC full_table_name",
 /* 285 */ "cmd ::= DESCRIBE full_table_name",
 /* 286 */ "cmd ::= RESET QUERY CACHE",
 /* 287 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 288 */ "analyze_opt ::=",
 /* 289 */ "analyze_opt ::= ANALYZE",
 /* 290 */ "explain_options ::=",
 /* 291 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 292 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 293 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 294 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 295 */ "agg_func_opt ::=",
 /* 296 */ "agg_func_opt ::= AGGREGATE",
 /* 297 */ "bufsize_opt ::=",
 /* 298 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 299 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 300 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 301 */ "stream_options ::=",
 /* 302 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 303 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 304 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 305 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 306 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 307 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 308 */ "subtable_opt ::=",
 /* 309 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 310 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 311 */ "cmd ::= KILL QUERY NK_STRING",
 /* 312 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 313 */ "cmd ::= BALANCE VGROUP",
 /* 314 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 315 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 316 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 317 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 318 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 319 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 320 */ "cmd ::= query_or_subquery",
 /* 321 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 322 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 323 */ "literal ::= NK_INTEGER",
 /* 324 */ "literal ::= NK_FLOAT",
 /* 325 */ "literal ::= NK_STRING",
 /* 326 */ "literal ::= NK_BOOL",
 /* 327 */ "literal ::= TIMESTAMP NK_STRING",
 /* 328 */ "literal ::= duration_literal",
 /* 329 */ "literal ::= NULL",
 /* 330 */ "literal ::= NK_QUESTION",
 /* 331 */ "duration_literal ::= NK_VARIABLE",
 /* 332 */ "signed ::= NK_INTEGER",
 /* 333 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 334 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 335 */ "signed ::= NK_FLOAT",
 /* 336 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 337 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 338 */ "signed_literal ::= signed",
 /* 339 */ "signed_literal ::= NK_STRING",
 /* 340 */ "signed_literal ::= NK_BOOL",
 /* 341 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 342 */ "signed_literal ::= duration_literal",
 /* 343 */ "signed_literal ::= NULL",
 /* 344 */ "signed_literal ::= literal_func",
 /* 345 */ "signed_literal ::= NK_QUESTION",
 /* 346 */ "literal_list ::= signed_literal",
 /* 347 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 348 */ "db_name ::= NK_ID",
 /* 349 */ "table_name ::= NK_ID",
 /* 350 */ "column_name ::= NK_ID",
 /* 351 */ "function_name ::= NK_ID",
 /* 352 */ "table_alias ::= NK_ID",
 /* 353 */ "column_alias ::= NK_ID",
 /* 354 */ "user_name ::= NK_ID",
 /* 355 */ "topic_name ::= NK_ID",
 /* 356 */ "stream_name ::= NK_ID",
 /* 357 */ "cgroup_name ::= NK_ID",
 /* 358 */ "expr_or_subquery ::= expression",
 /* 359 */ "expression ::= literal",
 /* 360 */ "expression ::= pseudo_column",
 /* 361 */ "expression ::= column_reference",
 /* 362 */ "expression ::= function_expression",
 /* 363 */ "expression ::= case_when_expression",
 /* 364 */ "expression ::= NK_LP expression NK_RP",
 /* 365 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 366 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 371 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 372 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 373 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 374 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 375 */ "expression_list ::= expr_or_subquery",
 /* 376 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 377 */ "column_reference ::= column_name",
 /* 378 */ "column_reference ::= table_name NK_DOT column_name",
 /* 379 */ "pseudo_column ::= ROWTS",
 /* 380 */ "pseudo_column ::= TBNAME",
 /* 381 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 382 */ "pseudo_column ::= QSTART",
 /* 383 */ "pseudo_column ::= QEND",
 /* 384 */ "pseudo_column ::= QDURATION",
 /* 385 */ "pseudo_column ::= WSTART",
 /* 386 */ "pseudo_column ::= WEND",
 /* 387 */ "pseudo_column ::= WDURATION",
 /* 388 */ "pseudo_column ::= IROWTS",
 /* 389 */ "pseudo_column ::= ISFILLED",
 /* 390 */ "pseudo_column ::= QTAGS",
 /* 391 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 392 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 393 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 394 */ "function_expression ::= literal_func",
 /* 395 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 396 */ "literal_func ::= NOW",
 /* 397 */ "noarg_func ::= NOW",
 /* 398 */ "noarg_func ::= TODAY",
 /* 399 */ "noarg_func ::= TIMEZONE",
 /* 400 */ "noarg_func ::= DATABASE",
 /* 401 */ "noarg_func ::= CLIENT_VERSION",
 /* 402 */ "noarg_func ::= SERVER_VERSION",
 /* 403 */ "noarg_func ::= SERVER_STATUS",
 /* 404 */ "noarg_func ::= CURRENT_USER",
 /* 405 */ "noarg_func ::= USER",
 /* 406 */ "star_func ::= COUNT",
 /* 407 */ "star_func ::= FIRST",
 /* 408 */ "star_func ::= LAST",
 /* 409 */ "star_func ::= LAST_ROW",
 /* 410 */ "star_func_para_list ::= NK_STAR",
 /* 411 */ "star_func_para_list ::= other_para_list",
 /* 412 */ "other_para_list ::= star_func_para",
 /* 413 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 414 */ "star_func_para ::= expr_or_subquery",
 /* 415 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 416 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 417 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 418 */ "when_then_list ::= when_then_expr",
 /* 419 */ "when_then_list ::= when_then_list when_then_expr",
 /* 420 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 421 */ "case_when_else_opt ::=",
 /* 422 */ "case_when_else_opt ::= ELSE common_expression",
 /* 423 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 424 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 425 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 426 */ "predicate ::= expr_or_subquery IS NULL",
 /* 427 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 428 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 429 */ "compare_op ::= NK_LT",
 /* 430 */ "compare_op ::= NK_GT",
 /* 431 */ "compare_op ::= NK_LE",
 /* 432 */ "compare_op ::= NK_GE",
 /* 433 */ "compare_op ::= NK_NE",
 /* 434 */ "compare_op ::= NK_EQ",
 /* 435 */ "compare_op ::= LIKE",
 /* 436 */ "compare_op ::= NOT LIKE",
 /* 437 */ "compare_op ::= MATCH",
 /* 438 */ "compare_op ::= NMATCH",
 /* 439 */ "compare_op ::= CONTAINS",
 /* 440 */ "in_op ::= IN",
 /* 441 */ "in_op ::= NOT IN",
 /* 442 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 443 */ "boolean_value_expression ::= boolean_primary",
 /* 444 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 445 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 446 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 447 */ "boolean_primary ::= predicate",
 /* 448 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 449 */ "common_expression ::= expr_or_subquery",
 /* 450 */ "common_expression ::= boolean_value_expression",
 /* 451 */ "from_clause_opt ::=",
 /* 452 */ "from_clause_opt ::= FROM table_reference_list",
 /* 453 */ "table_reference_list ::= table_reference",
 /* 454 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 455 */ "table_reference ::= table_primary",
 /* 456 */ "table_reference ::= joined_table",
 /* 457 */ "table_primary ::= table_name alias_opt",
 /* 458 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 459 */ "table_primary ::= subquery alias_opt",
 /* 460 */ "table_primary ::= parenthesized_joined_table",
 /* 461 */ "alias_opt ::=",
 /* 462 */ "alias_opt ::= table_alias",
 /* 463 */ "alias_opt ::= AS table_alias",
 /* 464 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 465 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 466 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 467 */ "join_type ::=",
 /* 468 */ "join_type ::= INNER",
 /* 469 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 470 */ "set_quantifier_opt ::=",
 /* 471 */ "set_quantifier_opt ::= DISTINCT",
 /* 472 */ "set_quantifier_opt ::= ALL",
 /* 473 */ "select_list ::= select_item",
 /* 474 */ "select_list ::= select_list NK_COMMA select_item",
 /* 475 */ "select_item ::= NK_STAR",
 /* 476 */ "select_item ::= common_expression",
 /* 477 */ "select_item ::= common_expression column_alias",
 /* 478 */ "select_item ::= common_expression AS column_alias",
 /* 479 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 480 */ "where_clause_opt ::=",
 /* 481 */ "where_clause_opt ::= WHERE search_condition",
 /* 482 */ "partition_by_clause_opt ::=",
 /* 483 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 484 */ "partition_list ::= partition_item",
 /* 485 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 486 */ "partition_item ::= expr_or_subquery",
 /* 487 */ "partition_item ::= expr_or_subquery column_alias",
 /* 488 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 489 */ "twindow_clause_opt ::=",
 /* 490 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 491 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 492 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 493 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 494 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 495 */ "sliding_opt ::=",
 /* 496 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 497 */ "fill_opt ::=",
 /* 498 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 499 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 500 */ "fill_mode ::= NONE",
 /* 501 */ "fill_mode ::= PREV",
 /* 502 */ "fill_mode ::= NULL",
 /* 503 */ "fill_mode ::= LINEAR",
 /* 504 */ "fill_mode ::= NEXT",
 /* 505 */ "group_by_clause_opt ::=",
 /* 506 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 507 */ "group_by_list ::= expr_or_subquery",
 /* 508 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 509 */ "having_clause_opt ::=",
 /* 510 */ "having_clause_opt ::= HAVING search_condition",
 /* 511 */ "range_opt ::=",
 /* 512 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 513 */ "every_opt ::=",
 /* 514 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 515 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 516 */ "query_simple ::= query_specification",
 /* 517 */ "query_simple ::= union_query_expression",
 /* 518 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 519 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 520 */ "query_simple_or_subquery ::= query_simple",
 /* 521 */ "query_simple_or_subquery ::= subquery",
 /* 522 */ "query_or_subquery ::= query_expression",
 /* 523 */ "query_or_subquery ::= subquery",
 /* 524 */ "order_by_clause_opt ::=",
 /* 525 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 526 */ "slimit_clause_opt ::=",
 /* 527 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 528 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 529 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 530 */ "limit_clause_opt ::=",
 /* 531 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 532 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 533 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 534 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 535 */ "subquery ::= NK_LP subquery NK_RP",
 /* 536 */ "search_condition ::= common_expression",
 /* 537 */ "sort_specification_list ::= sort_specification",
 /* 538 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 539 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 540 */ "ordering_specification_opt ::=",
 /* 541 */ "ordering_specification_opt ::= ASC",
 /* 542 */ "ordering_specification_opt ::= DESC",
 /* 543 */ "null_ordering_opt ::=",
 /* 544 */ "null_ordering_opt ::= NULLS FIRST",
 /* 545 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 325: /* cmd */
    case 328: /* literal */
    case 341: /* db_options */
    case 343: /* alter_db_options */
    case 349: /* retention */
    case 350: /* full_table_name */
    case 353: /* table_options */
    case 357: /* alter_table_clause */
    case 358: /* alter_table_options */
    case 361: /* signed_literal */
    case 362: /* create_subtable_clause */
    case 365: /* drop_table_clause */
    case 368: /* column_def */
    case 372: /* duration_literal */
    case 373: /* rollup_func_name */
    case 375: /* col_name */
    case 376: /* db_name_cond_opt */
    case 377: /* like_pattern_opt */
    case 378: /* table_name_cond */
    case 379: /* from_db_opt */
    case 381: /* tag_item */
    case 383: /* index_options */
    case 385: /* sliding_opt */
    case 386: /* sma_stream_opt */
    case 387: /* func */
    case 389: /* query_or_subquery */
    case 392: /* explain_options */
    case 396: /* stream_options */
    case 397: /* subtable_opt */
    case 398: /* expression */
    case 400: /* where_clause_opt */
    case 401: /* signed */
    case 402: /* literal_func */
    case 405: /* expr_or_subquery */
    case 406: /* pseudo_column */
    case 407: /* column_reference */
    case 408: /* function_expression */
    case 409: /* case_when_expression */
    case 414: /* star_func_para */
    case 416: /* case_when_else_opt */
    case 417: /* common_expression */
    case 418: /* when_then_expr */
    case 419: /* predicate */
    case 422: /* in_predicate_value */
    case 423: /* boolean_value_expression */
    case 424: /* boolean_primary */
    case 425: /* from_clause_opt */
    case 426: /* table_reference_list */
    case 427: /* table_reference */
    case 428: /* table_primary */
    case 429: /* joined_table */
    case 431: /* subquery */
    case 432: /* parenthesized_joined_table */
    case 434: /* search_condition */
    case 435: /* query_specification */
    case 439: /* range_opt */
    case 440: /* every_opt */
    case 441: /* fill_opt */
    case 442: /* twindow_clause_opt */
    case 444: /* having_clause_opt */
    case 445: /* select_item */
    case 447: /* partition_item */
    case 450: /* query_expression */
    case 451: /* query_simple */
    case 453: /* slimit_clause_opt */
    case 454: /* limit_clause_opt */
    case 455: /* union_query_expression */
    case 456: /* query_simple_or_subquery */
    case 458: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy600)); 
}
      break;
    case 326: /* account_options */
    case 327: /* alter_account_options */
    case 329: /* alter_account_option */
    case 344: /* speed_opt */
    case 394: /* bufsize_opt */
{
 
}
      break;
    case 330: /* user_name */
    case 333: /* priv_level */
    case 336: /* db_name */
    case 337: /* topic_name */
    case 338: /* dnode_endpoint */
    case 359: /* column_name */
    case 367: /* table_name */
    case 374: /* function_name */
    case 382: /* column_alias */
    case 388: /* sma_func_name */
    case 390: /* cgroup_name */
    case 395: /* stream_name */
    case 404: /* table_alias */
    case 410: /* star_func */
    case 412: /* noarg_func */
    case 430: /* alias_opt */
{
 
}
      break;
    case 331: /* sysinfo_opt */
{
 
}
      break;
    case 332: /* privileges */
    case 334: /* priv_type_list */
    case 335: /* priv_type */
{
 
}
      break;
    case 339: /* force_opt */
    case 340: /* not_exists_opt */
    case 342: /* exists_opt */
    case 391: /* analyze_opt */
    case 393: /* agg_func_opt */
    case 436: /* set_quantifier_opt */
{
 
}
      break;
    case 345: /* integer_list */
    case 346: /* variable_list */
    case 347: /* retention_list */
    case 351: /* column_def_list */
    case 352: /* tags_def_opt */
    case 354: /* multi_create_clause */
    case 355: /* tags_def */
    case 356: /* multi_drop_clause */
    case 363: /* specific_cols_opt */
    case 364: /* expression_list */
    case 366: /* col_name_list */
    case 369: /* duration_list */
    case 370: /* rollup_func_list */
    case 380: /* tag_list_opt */
    case 384: /* func_list */
    case 399: /* dnode_list */
    case 403: /* literal_list */
    case 411: /* star_func_para_list */
    case 413: /* other_para_list */
    case 415: /* when_then_list */
    case 437: /* select_list */
    case 438: /* partition_by_clause_opt */
    case 443: /* group_by_clause_opt */
    case 446: /* partition_list */
    case 449: /* group_by_list */
    case 452: /* order_by_clause_opt */
    case 457: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy601)); 
}
      break;
    case 348: /* alter_db_option */
    case 371: /* alter_table_option */
{
 
}
      break;
    case 360: /* type_name */
{
 
}
      break;
    case 420: /* compare_op */
    case 421: /* in_op */
{
 
}
      break;
    case 433: /* join_type */
{
 
}
      break;
    case 448: /* fill_mode */
{
 
}
      break;
    case 459: /* ordering_specification_opt */
{
 
}
      break;
    case 460: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  325,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  325,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  326,    0 }, /* (2) account_options ::= */
  {  326,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  326,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  326,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  326,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  326,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  326,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  326,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  326,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  326,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  327,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  327,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  329,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  329,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  329,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  329,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  329,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  329,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  329,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  329,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  329,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  329,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  325,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  325,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  325,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  325,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  325,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  331,    0 }, /* (29) sysinfo_opt ::= */
  {  331,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  325,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  325,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  332,   -1 }, /* (33) privileges ::= ALL */
  {  332,   -1 }, /* (34) privileges ::= priv_type_list */
  {  332,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  334,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  334,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  335,   -1 }, /* (38) priv_type ::= READ */
  {  335,   -1 }, /* (39) priv_type ::= WRITE */
  {  333,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  333,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  333,   -1 }, /* (42) priv_level ::= topic_name */
  {  325,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  325,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  325,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  325,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  325,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  325,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  325,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  325,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  338,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  338,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  338,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  339,    0 }, /* (54) force_opt ::= */
  {  339,   -1 }, /* (55) force_opt ::= FORCE */
  {  325,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  325,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  325,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  325,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  325,   -2 }, /* (68) cmd ::= USE db_name */
  {  325,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  325,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  325,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  340,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  340,    0 }, /* (73) not_exists_opt ::= */
  {  342,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  342,    0 }, /* (75) exists_opt ::= */
  {  341,    0 }, /* (76) db_options ::= */
  {  341,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  341,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  341,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  341,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  341,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  341,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  341,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  341,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  341,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  341,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  341,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  341,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  341,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  341,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  341,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  341,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  341,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  341,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  341,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  341,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  341,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  341,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  341,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  341,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  341,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  341,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  341,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  341,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  341,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  341,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  343,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  343,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  348,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  348,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  348,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  348,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  348,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  348,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  348,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  348,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  348,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  348,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  345,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  345,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  346,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  346,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  347,   -1 }, /* (123) retention_list ::= retention */
  {  347,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  349,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  344,    0 }, /* (126) speed_opt ::= */
  {  344,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  325,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  325,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  325,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  325,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  325,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  325,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  325,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  357,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  357,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  357,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  357,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  357,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  357,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  357,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  357,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  357,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  357,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  354,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  354,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  362,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  356,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  356,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  365,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  363,    0 }, /* (151) specific_cols_opt ::= */
  {  363,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  350,   -1 }, /* (153) full_table_name ::= table_name */
  {  350,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  351,   -1 }, /* (155) column_def_list ::= column_def */
  {  351,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  368,   -2 }, /* (157) column_def ::= column_name type_name */
  {  368,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  360,   -1 }, /* (159) type_name ::= BOOL */
  {  360,   -1 }, /* (160) type_name ::= TINYINT */
  {  360,   -1 }, /* (161) type_name ::= SMALLINT */
  {  360,   -1 }, /* (162) type_name ::= INT */
  {  360,   -1 }, /* (163) type_name ::= INTEGER */
  {  360,   -1 }, /* (164) type_name ::= BIGINT */
  {  360,   -1 }, /* (165) type_name ::= FLOAT */
  {  360,   -1 }, /* (166) type_name ::= DOUBLE */
  {  360,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  360,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  360,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  360,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  360,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  360,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  360,   -1 }, /* (174) type_name ::= JSON */
  {  360,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  360,   -1 }, /* (177) type_name ::= BLOB */
  {  360,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (179) type_name ::= DECIMAL */
  {  360,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  360,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  352,    0 }, /* (182) tags_def_opt ::= */
  {  352,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  355,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  353,    0 }, /* (185) table_options ::= */
  {  353,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  353,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  353,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  353,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  353,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  353,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  353,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  358,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  358,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  371,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  371,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  369,   -1 }, /* (197) duration_list ::= duration_literal */
  {  369,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  370,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  370,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  373,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  373,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  373,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  366,   -1 }, /* (204) col_name_list ::= col_name */
  {  366,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  375,   -1 }, /* (206) col_name ::= column_name */
  {  325,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  325,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  325,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  325,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  325,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  325,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  325,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  325,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  325,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  325,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  325,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  325,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  325,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  325,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  325,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  325,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  325,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  325,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  325,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  325,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  325,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  325,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  325,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  325,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  325,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  325,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  325,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  325,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  325,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  325,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  325,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  325,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  325,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  325,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  325,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  325,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  325,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  325,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  376,    0 }, /* (245) db_name_cond_opt ::= */
  {  376,   -2 }, /* (246) db_name_cond_opt ::= db_name NK_DOT */
  {  377,    0 }, /* (247) like_pattern_opt ::= */
  {  377,   -2 }, /* (248) like_pattern_opt ::= LIKE NK_STRING */
  {  378,   -1 }, /* (249) table_name_cond ::= table_name */
  {  379,    0 }, /* (250) from_db_opt ::= */
  {  379,   -2 }, /* (251) from_db_opt ::= FROM db_name */
  {  380,    0 }, /* (252) tag_list_opt ::= */
  {  380,   -1 }, /* (253) tag_list_opt ::= tag_item */
  {  380,   -3 }, /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  381,   -1 }, /* (255) tag_item ::= TBNAME */
  {  381,   -1 }, /* (256) tag_item ::= QTAGS */
  {  381,   -1 }, /* (257) tag_item ::= column_name */
  {  381,   -2 }, /* (258) tag_item ::= column_name column_alias */
  {  381,   -3 }, /* (259) tag_item ::= column_name AS column_alias */
  {  325,   -8 }, /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  325,   -9 }, /* (261) cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
  {  325,   -4 }, /* (262) cmd ::= DROP INDEX exists_opt full_table_name */
  {  383,  -10 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,  -12 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  384,   -1 }, /* (265) func_list ::= func */
  {  384,   -3 }, /* (266) func_list ::= func_list NK_COMMA func */
  {  387,   -4 }, /* (267) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  388,   -1 }, /* (268) sma_func_name ::= function_name */
  {  388,   -1 }, /* (269) sma_func_name ::= COUNT */
  {  388,   -1 }, /* (270) sma_func_name ::= FIRST */
  {  388,   -1 }, /* (271) sma_func_name ::= LAST */
  {  388,   -1 }, /* (272) sma_func_name ::= LAST_ROW */
  {  386,    0 }, /* (273) sma_stream_opt ::= */
  {  386,   -3 }, /* (274) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  386,   -3 }, /* (275) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  386,   -3 }, /* (276) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  325,   -6 }, /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  325,   -7 }, /* (278) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  325,   -9 }, /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  325,   -7 }, /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  325,   -9 }, /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  325,   -4 }, /* (282) cmd ::= DROP TOPIC exists_opt topic_name */
  {  325,   -7 }, /* (283) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  325,   -2 }, /* (284) cmd ::= DESC full_table_name */
  {  325,   -2 }, /* (285) cmd ::= DESCRIBE full_table_name */
  {  325,   -3 }, /* (286) cmd ::= RESET QUERY CACHE */
  {  325,   -4 }, /* (287) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  391,    0 }, /* (288) analyze_opt ::= */
  {  391,   -1 }, /* (289) analyze_opt ::= ANALYZE */
  {  392,    0 }, /* (290) explain_options ::= */
  {  392,   -3 }, /* (291) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  392,   -3 }, /* (292) explain_options ::= explain_options RATIO NK_FLOAT */
  {  325,  -10 }, /* (293) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  325,   -4 }, /* (294) cmd ::= DROP FUNCTION exists_opt function_name */
  {  393,    0 }, /* (295) agg_func_opt ::= */
  {  393,   -1 }, /* (296) agg_func_opt ::= AGGREGATE */
  {  394,    0 }, /* (297) bufsize_opt ::= */
  {  394,   -2 }, /* (298) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  325,  -11 }, /* (299) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  325,   -4 }, /* (300) cmd ::= DROP STREAM exists_opt stream_name */
  {  396,    0 }, /* (301) stream_options ::= */
  {  396,   -3 }, /* (302) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  396,   -3 }, /* (303) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  396,   -4 }, /* (304) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  396,   -3 }, /* (305) stream_options ::= stream_options WATERMARK duration_literal */
  {  396,   -4 }, /* (306) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  396,   -3 }, /* (307) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  397,    0 }, /* (308) subtable_opt ::= */
  {  397,   -4 }, /* (309) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  325,   -3 }, /* (310) cmd ::= KILL CONNECTION NK_INTEGER */
  {  325,   -3 }, /* (311) cmd ::= KILL QUERY NK_STRING */
  {  325,   -3 }, /* (312) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  325,   -2 }, /* (313) cmd ::= BALANCE VGROUP */
  {  325,   -4 }, /* (314) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  325,   -4 }, /* (315) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  325,   -3 }, /* (316) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  399,   -2 }, /* (317) dnode_list ::= DNODE NK_INTEGER */
  {  399,   -3 }, /* (318) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  325,   -4 }, /* (319) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  325,   -1 }, /* (320) cmd ::= query_or_subquery */
  {  325,   -7 }, /* (321) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  325,   -4 }, /* (322) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  328,   -1 }, /* (323) literal ::= NK_INTEGER */
  {  328,   -1 }, /* (324) literal ::= NK_FLOAT */
  {  328,   -1 }, /* (325) literal ::= NK_STRING */
  {  328,   -1 }, /* (326) literal ::= NK_BOOL */
  {  328,   -2 }, /* (327) literal ::= TIMESTAMP NK_STRING */
  {  328,   -1 }, /* (328) literal ::= duration_literal */
  {  328,   -1 }, /* (329) literal ::= NULL */
  {  328,   -1 }, /* (330) literal ::= NK_QUESTION */
  {  372,   -1 }, /* (331) duration_literal ::= NK_VARIABLE */
  {  401,   -1 }, /* (332) signed ::= NK_INTEGER */
  {  401,   -2 }, /* (333) signed ::= NK_PLUS NK_INTEGER */
  {  401,   -2 }, /* (334) signed ::= NK_MINUS NK_INTEGER */
  {  401,   -1 }, /* (335) signed ::= NK_FLOAT */
  {  401,   -2 }, /* (336) signed ::= NK_PLUS NK_FLOAT */
  {  401,   -2 }, /* (337) signed ::= NK_MINUS NK_FLOAT */
  {  361,   -1 }, /* (338) signed_literal ::= signed */
  {  361,   -1 }, /* (339) signed_literal ::= NK_STRING */
  {  361,   -1 }, /* (340) signed_literal ::= NK_BOOL */
  {  361,   -2 }, /* (341) signed_literal ::= TIMESTAMP NK_STRING */
  {  361,   -1 }, /* (342) signed_literal ::= duration_literal */
  {  361,   -1 }, /* (343) signed_literal ::= NULL */
  {  361,   -1 }, /* (344) signed_literal ::= literal_func */
  {  361,   -1 }, /* (345) signed_literal ::= NK_QUESTION */
  {  403,   -1 }, /* (346) literal_list ::= signed_literal */
  {  403,   -3 }, /* (347) literal_list ::= literal_list NK_COMMA signed_literal */
  {  336,   -1 }, /* (348) db_name ::= NK_ID */
  {  367,   -1 }, /* (349) table_name ::= NK_ID */
  {  359,   -1 }, /* (350) column_name ::= NK_ID */
  {  374,   -1 }, /* (351) function_name ::= NK_ID */
  {  404,   -1 }, /* (352) table_alias ::= NK_ID */
  {  382,   -1 }, /* (353) column_alias ::= NK_ID */
  {  330,   -1 }, /* (354) user_name ::= NK_ID */
  {  337,   -1 }, /* (355) topic_name ::= NK_ID */
  {  395,   -1 }, /* (356) stream_name ::= NK_ID */
  {  390,   -1 }, /* (357) cgroup_name ::= NK_ID */
  {  405,   -1 }, /* (358) expr_or_subquery ::= expression */
  {  398,   -1 }, /* (359) expression ::= literal */
  {  398,   -1 }, /* (360) expression ::= pseudo_column */
  {  398,   -1 }, /* (361) expression ::= column_reference */
  {  398,   -1 }, /* (362) expression ::= function_expression */
  {  398,   -1 }, /* (363) expression ::= case_when_expression */
  {  398,   -3 }, /* (364) expression ::= NK_LP expression NK_RP */
  {  398,   -2 }, /* (365) expression ::= NK_PLUS expr_or_subquery */
  {  398,   -2 }, /* (366) expression ::= NK_MINUS expr_or_subquery */
  {  398,   -3 }, /* (367) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  398,   -3 }, /* (368) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  398,   -3 }, /* (369) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  398,   -3 }, /* (370) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  398,   -3 }, /* (371) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  398,   -3 }, /* (372) expression ::= column_reference NK_ARROW NK_STRING */
  {  398,   -3 }, /* (373) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  398,   -3 }, /* (374) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  364,   -1 }, /* (375) expression_list ::= expr_or_subquery */
  {  364,   -3 }, /* (376) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  407,   -1 }, /* (377) column_reference ::= column_name */
  {  407,   -3 }, /* (378) column_reference ::= table_name NK_DOT column_name */
  {  406,   -1 }, /* (379) pseudo_column ::= ROWTS */
  {  406,   -1 }, /* (380) pseudo_column ::= TBNAME */
  {  406,   -3 }, /* (381) pseudo_column ::= table_name NK_DOT TBNAME */
  {  406,   -1 }, /* (382) pseudo_column ::= QSTART */
  {  406,   -1 }, /* (383) pseudo_column ::= QEND */
  {  406,   -1 }, /* (384) pseudo_column ::= QDURATION */
  {  406,   -1 }, /* (385) pseudo_column ::= WSTART */
  {  406,   -1 }, /* (386) pseudo_column ::= WEND */
  {  406,   -1 }, /* (387) pseudo_column ::= WDURATION */
  {  406,   -1 }, /* (388) pseudo_column ::= IROWTS */
  {  406,   -1 }, /* (389) pseudo_column ::= ISFILLED */
  {  406,   -1 }, /* (390) pseudo_column ::= QTAGS */
  {  408,   -4 }, /* (391) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  408,   -4 }, /* (392) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  408,   -6 }, /* (393) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  408,   -1 }, /* (394) function_expression ::= literal_func */
  {  402,   -3 }, /* (395) literal_func ::= noarg_func NK_LP NK_RP */
  {  402,   -1 }, /* (396) literal_func ::= NOW */
  {  412,   -1 }, /* (397) noarg_func ::= NOW */
  {  412,   -1 }, /* (398) noarg_func ::= TODAY */
  {  412,   -1 }, /* (399) noarg_func ::= TIMEZONE */
  {  412,   -1 }, /* (400) noarg_func ::= DATABASE */
  {  412,   -1 }, /* (401) noarg_func ::= CLIENT_VERSION */
  {  412,   -1 }, /* (402) noarg_func ::= SERVER_VERSION */
  {  412,   -1 }, /* (403) noarg_func ::= SERVER_STATUS */
  {  412,   -1 }, /* (404) noarg_func ::= CURRENT_USER */
  {  412,   -1 }, /* (405) noarg_func ::= USER */
  {  410,   -1 }, /* (406) star_func ::= COUNT */
  {  410,   -1 }, /* (407) star_func ::= FIRST */
  {  410,   -1 }, /* (408) star_func ::= LAST */
  {  410,   -1 }, /* (409) star_func ::= LAST_ROW */
  {  411,   -1 }, /* (410) star_func_para_list ::= NK_STAR */
  {  411,   -1 }, /* (411) star_func_para_list ::= other_para_list */
  {  413,   -1 }, /* (412) other_para_list ::= star_func_para */
  {  413,   -3 }, /* (413) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  414,   -1 }, /* (414) star_func_para ::= expr_or_subquery */
  {  414,   -3 }, /* (415) star_func_para ::= table_name NK_DOT NK_STAR */
  {  409,   -4 }, /* (416) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  409,   -5 }, /* (417) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  415,   -1 }, /* (418) when_then_list ::= when_then_expr */
  {  415,   -2 }, /* (419) when_then_list ::= when_then_list when_then_expr */
  {  418,   -4 }, /* (420) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  416,    0 }, /* (421) case_when_else_opt ::= */
  {  416,   -2 }, /* (422) case_when_else_opt ::= ELSE common_expression */
  {  419,   -3 }, /* (423) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  419,   -5 }, /* (424) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  419,   -6 }, /* (425) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  419,   -3 }, /* (426) predicate ::= expr_or_subquery IS NULL */
  {  419,   -4 }, /* (427) predicate ::= expr_or_subquery IS NOT NULL */
  {  419,   -3 }, /* (428) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  420,   -1 }, /* (429) compare_op ::= NK_LT */
  {  420,   -1 }, /* (430) compare_op ::= NK_GT */
  {  420,   -1 }, /* (431) compare_op ::= NK_LE */
  {  420,   -1 }, /* (432) compare_op ::= NK_GE */
  {  420,   -1 }, /* (433) compare_op ::= NK_NE */
  {  420,   -1 }, /* (434) compare_op ::= NK_EQ */
  {  420,   -1 }, /* (435) compare_op ::= LIKE */
  {  420,   -2 }, /* (436) compare_op ::= NOT LIKE */
  {  420,   -1 }, /* (437) compare_op ::= MATCH */
  {  420,   -1 }, /* (438) compare_op ::= NMATCH */
  {  420,   -1 }, /* (439) compare_op ::= CONTAINS */
  {  421,   -1 }, /* (440) in_op ::= IN */
  {  421,   -2 }, /* (441) in_op ::= NOT IN */
  {  422,   -3 }, /* (442) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  423,   -1 }, /* (443) boolean_value_expression ::= boolean_primary */
  {  423,   -2 }, /* (444) boolean_value_expression ::= NOT boolean_primary */
  {  423,   -3 }, /* (445) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  423,   -3 }, /* (446) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  424,   -1 }, /* (447) boolean_primary ::= predicate */
  {  424,   -3 }, /* (448) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  417,   -1 }, /* (449) common_expression ::= expr_or_subquery */
  {  417,   -1 }, /* (450) common_expression ::= boolean_value_expression */
  {  425,    0 }, /* (451) from_clause_opt ::= */
  {  425,   -2 }, /* (452) from_clause_opt ::= FROM table_reference_list */
  {  426,   -1 }, /* (453) table_reference_list ::= table_reference */
  {  426,   -3 }, /* (454) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  427,   -1 }, /* (455) table_reference ::= table_primary */
  {  427,   -1 }, /* (456) table_reference ::= joined_table */
  {  428,   -2 }, /* (457) table_primary ::= table_name alias_opt */
  {  428,   -4 }, /* (458) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  428,   -2 }, /* (459) table_primary ::= subquery alias_opt */
  {  428,   -1 }, /* (460) table_primary ::= parenthesized_joined_table */
  {  430,    0 }, /* (461) alias_opt ::= */
  {  430,   -1 }, /* (462) alias_opt ::= table_alias */
  {  430,   -2 }, /* (463) alias_opt ::= AS table_alias */
  {  432,   -3 }, /* (464) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  432,   -3 }, /* (465) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  429,   -6 }, /* (466) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  433,    0 }, /* (467) join_type ::= */
  {  433,   -1 }, /* (468) join_type ::= INNER */
  {  435,  -12 }, /* (469) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  436,    0 }, /* (470) set_quantifier_opt ::= */
  {  436,   -1 }, /* (471) set_quantifier_opt ::= DISTINCT */
  {  436,   -1 }, /* (472) set_quantifier_opt ::= ALL */
  {  437,   -1 }, /* (473) select_list ::= select_item */
  {  437,   -3 }, /* (474) select_list ::= select_list NK_COMMA select_item */
  {  445,   -1 }, /* (475) select_item ::= NK_STAR */
  {  445,   -1 }, /* (476) select_item ::= common_expression */
  {  445,   -2 }, /* (477) select_item ::= common_expression column_alias */
  {  445,   -3 }, /* (478) select_item ::= common_expression AS column_alias */
  {  445,   -3 }, /* (479) select_item ::= table_name NK_DOT NK_STAR */
  {  400,    0 }, /* (480) where_clause_opt ::= */
  {  400,   -2 }, /* (481) where_clause_opt ::= WHERE search_condition */
  {  438,    0 }, /* (482) partition_by_clause_opt ::= */
  {  438,   -3 }, /* (483) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  446,   -1 }, /* (484) partition_list ::= partition_item */
  {  446,   -3 }, /* (485) partition_list ::= partition_list NK_COMMA partition_item */
  {  447,   -1 }, /* (486) partition_item ::= expr_or_subquery */
  {  447,   -2 }, /* (487) partition_item ::= expr_or_subquery column_alias */
  {  447,   -3 }, /* (488) partition_item ::= expr_or_subquery AS column_alias */
  {  442,    0 }, /* (489) twindow_clause_opt ::= */
  {  442,   -6 }, /* (490) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  442,   -4 }, /* (491) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  442,   -6 }, /* (492) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  442,   -8 }, /* (493) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  442,   -7 }, /* (494) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  385,    0 }, /* (495) sliding_opt ::= */
  {  385,   -4 }, /* (496) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  441,    0 }, /* (497) fill_opt ::= */
  {  441,   -4 }, /* (498) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  441,   -6 }, /* (499) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  448,   -1 }, /* (500) fill_mode ::= NONE */
  {  448,   -1 }, /* (501) fill_mode ::= PREV */
  {  448,   -1 }, /* (502) fill_mode ::= NULL */
  {  448,   -1 }, /* (503) fill_mode ::= LINEAR */
  {  448,   -1 }, /* (504) fill_mode ::= NEXT */
  {  443,    0 }, /* (505) group_by_clause_opt ::= */
  {  443,   -3 }, /* (506) group_by_clause_opt ::= GROUP BY group_by_list */
  {  449,   -1 }, /* (507) group_by_list ::= expr_or_subquery */
  {  449,   -3 }, /* (508) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  444,    0 }, /* (509) having_clause_opt ::= */
  {  444,   -2 }, /* (510) having_clause_opt ::= HAVING search_condition */
  {  439,    0 }, /* (511) range_opt ::= */
  {  439,   -6 }, /* (512) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  440,    0 }, /* (513) every_opt ::= */
  {  440,   -4 }, /* (514) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  450,   -4 }, /* (515) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  451,   -1 }, /* (516) query_simple ::= query_specification */
  {  451,   -1 }, /* (517) query_simple ::= union_query_expression */
  {  455,   -4 }, /* (518) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  455,   -3 }, /* (519) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  456,   -1 }, /* (520) query_simple_or_subquery ::= query_simple */
  {  456,   -1 }, /* (521) query_simple_or_subquery ::= subquery */
  {  389,   -1 }, /* (522) query_or_subquery ::= query_expression */
  {  389,   -1 }, /* (523) query_or_subquery ::= subquery */
  {  452,    0 }, /* (524) order_by_clause_opt ::= */
  {  452,   -3 }, /* (525) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  453,    0 }, /* (526) slimit_clause_opt ::= */
  {  453,   -2 }, /* (527) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  453,   -4 }, /* (528) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  453,   -4 }, /* (529) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  454,    0 }, /* (530) limit_clause_opt ::= */
  {  454,   -2 }, /* (531) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  454,   -4 }, /* (532) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  454,   -4 }, /* (533) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  431,   -3 }, /* (534) subquery ::= NK_LP query_expression NK_RP */
  {  431,   -3 }, /* (535) subquery ::= NK_LP subquery NK_RP */
  {  434,   -1 }, /* (536) search_condition ::= common_expression */
  {  457,   -1 }, /* (537) sort_specification_list ::= sort_specification */
  {  457,   -3 }, /* (538) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  458,   -3 }, /* (539) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  459,    0 }, /* (540) ordering_specification_opt ::= */
  {  459,   -1 }, /* (541) ordering_specification_opt ::= ASC */
  {  459,   -1 }, /* (542) ordering_specification_opt ::= DESC */
  {  460,    0 }, /* (543) null_ordering_opt ::= */
  {  460,   -2 }, /* (544) null_ordering_opt ::= NULLS FIRST */
  {  460,   -2 }, /* (545) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,326,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,329,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,327,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy0, yymsp[0].minor.yy287); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy287 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy287 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy717 = yymsp[0].minor.yy717; }
  yymsp[0].minor.yy717 = yylhsminor.yy717;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy717 = yymsp[-2].minor.yy717 | yymsp[0].minor.yy717; }
  yymsp[-2].minor.yy717 = yylhsminor.yy717;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy77; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 42: /* priv_level ::= topic_name */
      case 268: /* sma_func_name ::= function_name */ yytestcase(yyruleno==268);
      case 462: /* alias_opt ::= table_alias */ yytestcase(yyruleno==462);
{ yylhsminor.yy77 = yymsp[0].minor.yy77; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy77, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy841); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy841); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 269: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==269);
      case 270: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==270);
      case 271: /* sma_func_name ::= LAST */ yytestcase(yyruleno==271);
      case 272: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==272);
      case 348: /* db_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* table_name ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* column_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* function_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* table_alias ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* column_alias ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* user_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* topic_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* stream_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 357: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==357);
      case 397: /* noarg_func ::= NOW */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= TODAY */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==403);
      case 404: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==404);
      case 405: /* noarg_func ::= USER */ yytestcase(yyruleno==405);
      case 406: /* star_func ::= COUNT */ yytestcase(yyruleno==406);
      case 407: /* star_func ::= FIRST */ yytestcase(yyruleno==407);
      case 408: /* star_func ::= LAST */ yytestcase(yyruleno==408);
      case 409: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==409);
{ yylhsminor.yy77 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 288: /* analyze_opt ::= */ yytestcase(yyruleno==288);
      case 295: /* agg_func_opt ::= */ yytestcase(yyruleno==295);
      case 470: /* set_quantifier_opt ::= */ yytestcase(yyruleno==470);
{ yymsp[1].minor.yy841 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 289: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==289);
      case 296: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==296);
      case 471: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==471);
{ yymsp[0].minor.yy841 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy841, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy248); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy841 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy841 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy600 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_KEEP, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_RETENTIONS, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy600 = createAlterDatabaseOptions(pCxt); yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yylhsminor.yy600, &yymsp[0].minor.yy661); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy600, &yymsp[0].minor.yy661); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy661.type = DB_OPTION_KEEP; yymsp[-1].minor.yy661.pList = yymsp[0].minor.yy601; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_PAGES; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_WAL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 318: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==318);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy601 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 265: /* func_list ::= func */ yytestcase(yyruleno==265);
      case 346: /* literal_list ::= signed_literal */ yytestcase(yyruleno==346);
      case 412: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==412);
      case 418: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==418);
      case 473: /* select_list ::= select_item */ yytestcase(yyruleno==473);
      case 484: /* partition_list ::= partition_item */ yytestcase(yyruleno==484);
      case 537: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==537);
{ yylhsminor.yy601 = createNodeList(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 266: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==266);
      case 347: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==347);
      case 413: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==413);
      case 474: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==474);
      case 485: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==485);
      case 538: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==538);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy600 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 126: /* speed_opt ::= */
      case 297: /* bufsize_opt ::= */ yytestcase(yyruleno==297);
{ yymsp[1].minor.yy248 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 298: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==298);
{ yymsp[-1].minor.yy248 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-5].minor.yy600, yymsp[-3].minor.yy601, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 320: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==320);
{ pCxt->pRootNode = yymsp[0].minor.yy600; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy600); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy600 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy600 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy600, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 419: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==419);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy601 = yylhsminor.yy601;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy600 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy841, yymsp[-8].minor.yy600, yymsp[-6].minor.yy600, yymsp[-5].minor.yy601, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-9].minor.yy600 = yylhsminor.yy600;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy600 = createDropTableClause(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 482: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==482);
      case 505: /* group_by_clause_opt ::= */ yytestcase(yyruleno==505);
      case 524: /* order_by_clause_opt ::= */ yytestcase(yyruleno==524);
{ yymsp[1].minor.yy601 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888, NULL); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-2].minor.yy888, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 411: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==411);
{ yylhsminor.yy601 = yymsp[0].minor.yy601; }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy600 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_SMA, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy600 = createAlterTableOptions(pCxt); yylhsminor.yy600 = setTableOption(pCxt, yylhsminor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 375: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==375);
{ yylhsminor.yy601 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 376: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==376);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy600, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy600); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600, yymsp[-3].minor.yy601); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy600 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 247: /* like_pattern_opt ::= */
      case 308: /* subtable_opt ::= */ yytestcase(yyruleno==308);
      case 421: /* case_when_else_opt ::= */ yytestcase(yyruleno==421);
      case 451: /* from_clause_opt ::= */ yytestcase(yyruleno==451);
      case 480: /* where_clause_opt ::= */ yytestcase(yyruleno==480);
      case 489: /* twindow_clause_opt ::= */ yytestcase(yyruleno==489);
      case 495: /* sliding_opt ::= */ yytestcase(yyruleno==495);
      case 497: /* fill_opt ::= */ yytestcase(yyruleno==497);
      case 509: /* having_clause_opt ::= */ yytestcase(yyruleno==509);
      case 511: /* range_opt ::= */ yytestcase(yyruleno==511);
      case 513: /* every_opt ::= */ yytestcase(yyruleno==513);
      case 526: /* slimit_clause_opt ::= */ yytestcase(yyruleno==526);
      case 530: /* limit_clause_opt ::= */ yytestcase(yyruleno==530);
{ yymsp[1].minor.yy600 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy841, yymsp[-3].minor.yy600, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 261: /* cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy841, yymsp[-5].minor.yy600, yymsp[-3].minor.yy600, yymsp[-1].minor.yy601, NULL); }
        break;
      case 262: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy600 = createIndexOption(pCxt, yymsp[-7].minor.yy601, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy600 = createIndexOption(pCxt, yymsp[-9].minor.yy601, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 267: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 273: /* sma_stream_opt ::= */
      case 301: /* stream_options ::= */ yytestcase(yyruleno==301);
{ yymsp[1].minor.yy600 = createStreamOptions(pCxt); }
        break;
      case 274: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 305: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==305);
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 275: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 276: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 278: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy77, false); }
        break;
      case 279: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[0].minor.yy77, true); }
        break;
      case 280: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, yymsp[0].minor.yy600, false); }
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, yymsp[0].minor.yy600, true); }
        break;
      case 282: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 283: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 284: /* cmd ::= DESC full_table_name */
      case 285: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==285);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 286: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 287: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy841, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 290: /* explain_options ::= */
{ yymsp[1].minor.yy600 = createDefaultExplainOptions(pCxt); }
        break;
      case 291: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy600 = setExplainVerbose(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 292: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy600 = setExplainRatio(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 293: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-8].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy888, yymsp[0].minor.yy248); }
        break;
      case 294: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 299: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy841, &yymsp[-7].minor.yy77, yymsp[-4].minor.yy600, yymsp[-6].minor.yy600, yymsp[-3].minor.yy601, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 300: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 302: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 303: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 304: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 306: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 307: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 309: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 496: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==496);
      case 514: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==514);
{ yymsp[-3].minor.yy600 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy600); }
        break;
      case 310: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 312: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 313: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 314: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 315: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy601); }
        break;
      case 316: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 317: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 319: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 321: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy600, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 322: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 323: /* literal ::= NK_INTEGER */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 324: /* literal ::= NK_FLOAT */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 325: /* literal ::= NK_STRING */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 326: /* literal ::= NK_BOOL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 327: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 328: /* literal ::= duration_literal */
      case 338: /* signed_literal ::= signed */ yytestcase(yyruleno==338);
      case 358: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==358);
      case 359: /* expression ::= literal */ yytestcase(yyruleno==359);
      case 360: /* expression ::= pseudo_column */ yytestcase(yyruleno==360);
      case 361: /* expression ::= column_reference */ yytestcase(yyruleno==361);
      case 362: /* expression ::= function_expression */ yytestcase(yyruleno==362);
      case 363: /* expression ::= case_when_expression */ yytestcase(yyruleno==363);
      case 394: /* function_expression ::= literal_func */ yytestcase(yyruleno==394);
      case 443: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==443);
      case 447: /* boolean_primary ::= predicate */ yytestcase(yyruleno==447);
      case 449: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==449);
      case 450: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==450);
      case 453: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==453);
      case 455: /* table_reference ::= table_primary */ yytestcase(yyruleno==455);
      case 456: /* table_reference ::= joined_table */ yytestcase(yyruleno==456);
      case 460: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==460);
      case 516: /* query_simple ::= query_specification */ yytestcase(yyruleno==516);
      case 517: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==517);
      case 520: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==520);
      case 522: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==522);
{ yylhsminor.yy600 = yymsp[0].minor.yy600; }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 329: /* literal ::= NULL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 330: /* literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 331: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 332: /* signed ::= NK_INTEGER */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 333: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 334: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 335: /* signed ::= NK_FLOAT */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 336: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 337: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 339: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 340: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 341: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 342: /* signed_literal ::= duration_literal */
      case 344: /* signed_literal ::= literal_func */ yytestcase(yyruleno==344);
      case 414: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==414);
      case 476: /* select_item ::= common_expression */ yytestcase(yyruleno==476);
      case 486: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==486);
      case 521: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==521);
      case 523: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==523);
      case 536: /* search_condition ::= common_expression */ yytestcase(yyruleno==536);
{ yylhsminor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 343: /* signed_literal ::= NULL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 345: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 364: /* expression ::= NK_LP expression NK_RP */
      case 448: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==448);
      case 535: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==535);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 365: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy600));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 366: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 367: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 368: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 369: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 370: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 371: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 372: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 373: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 374: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 377: /* column_reference ::= column_name */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy77, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 378: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 379: /* pseudo_column ::= ROWTS */
      case 380: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==380);
      case 382: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= QEND */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= WEND */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==388);
      case 389: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==389);
      case 390: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==390);
      case 396: /* literal_func ::= NOW */ yytestcase(yyruleno==396);
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 381: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy77)))); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 391: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 392: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==392);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 393: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy888)); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 395: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy77, NULL)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 410: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy601 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 415: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 479: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==479);
{ yylhsminor.yy600 = createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 416: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 417: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 420: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy600 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
        break;
      case 422: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
        break;
      case 423: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 428: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==428);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy666, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 424: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 425: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 426: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), NULL));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 427: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL));
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 429: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_THAN; }
        break;
      case 430: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_THAN; }
        break;
      case 431: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 432: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 433: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy666 = OP_TYPE_NOT_EQUAL; }
        break;
      case 434: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy666 = OP_TYPE_EQUAL; }
        break;
      case 435: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy666 = OP_TYPE_LIKE; }
        break;
      case 436: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_LIKE; }
        break;
      case 437: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_MATCH; }
        break;
      case 438: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_NMATCH; }
        break;
      case 439: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy666 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 440: /* in_op ::= IN */
{ yymsp[0].minor.yy666 = OP_TYPE_IN; }
        break;
      case 441: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_IN; }
        break;
      case 442: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 444: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 445: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 446: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 452: /* from_clause_opt ::= FROM table_reference_list */
      case 481: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==481);
      case 510: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==510);
{ yymsp[-1].minor.yy600 = yymsp[0].minor.yy600; }
        break;
      case 454: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 457: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 458: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 459: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy600 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 461: /* alias_opt ::= */
{ yymsp[1].minor.yy77 = nil_token;  }
        break;
      case 463: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy77 = yymsp[0].minor.yy77; }
        break;
      case 464: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 465: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==465);
{ yymsp[-2].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 466: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, yymsp[-4].minor.yy560, yymsp[-5].minor.yy600, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 467: /* join_type ::= */
{ yymsp[1].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 468: /* join_type ::= INNER */
{ yymsp[0].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 469: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy600 = createSelectStmt(pCxt, yymsp[-10].minor.yy841, yymsp[-9].minor.yy601, yymsp[-8].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addWhereClause(pCxt, yymsp[-11].minor.yy600, yymsp[-7].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addPartitionByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-6].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy600, yymsp[-2].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addGroupByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-1].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addHavingClause(pCxt, yymsp[-11].minor.yy600, yymsp[0].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addRangeClause(pCxt, yymsp[-11].minor.yy600, yymsp[-5].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addEveryClause(pCxt, yymsp[-11].minor.yy600, yymsp[-4].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addFillClause(pCxt, yymsp[-11].minor.yy600, yymsp[-3].minor.yy600);
                                                                                  }
        break;
      case 472: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy841 = false; }
        break;
      case 475: /* select_item ::= NK_STAR */
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 477: /* select_item ::= common_expression column_alias */
      case 487: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==487);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 478: /* select_item ::= common_expression AS column_alias */
      case 488: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==488);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 483: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 506: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==506);
      case 525: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==525);
{ yymsp[-2].minor.yy601 = yymsp[0].minor.yy601; }
        break;
      case 490: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy600 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 491: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy600 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 492: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 493: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 494: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy600 = createEventWindowNode(pCxt, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 498: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy600 = createFillNode(pCxt, yymsp[-1].minor.yy798, NULL); }
        break;
      case 499: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy600 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
        break;
      case 500: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy798 = FILL_MODE_NONE; }
        break;
      case 501: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy798 = FILL_MODE_PREV; }
        break;
      case 502: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy798 = FILL_MODE_NULL; }
        break;
      case 503: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy798 = FILL_MODE_LINEAR; }
        break;
      case 504: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy798 = FILL_MODE_NEXT; }
        break;
      case 507: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy601 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 508: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 512: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy600 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 515: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy600 = addOrderByClause(pCxt, yymsp[-3].minor.yy600, yymsp[-2].minor.yy601);
                                                                                    yylhsminor.yy600 = addSlimitClause(pCxt, yylhsminor.yy600, yymsp[-1].minor.yy600);
                                                                                    yylhsminor.yy600 = addLimitClause(pCxt, yylhsminor.yy600, yymsp[0].minor.yy600);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 518: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 519: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 527: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 531: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==531);
{ yymsp[-1].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 528: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 532: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==532);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 529: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 533: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==533);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 534: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 539: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy600 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), yymsp[-1].minor.yy32, yymsp[0].minor.yy385); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 540: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy32 = ORDER_ASC; }
        break;
      case 541: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy32 = ORDER_ASC; }
        break;
      case 542: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy32 = ORDER_DESC; }
        break;
      case 543: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy385 = NULL_ORDER_DEFAULT; }
        break;
      case 544: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_FIRST; }
        break;
      case 545: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
