import sys 
from util.log import *
from util.cases import *
from util.sql import *
from util.dnodes import tdDnodes
from math import inf

class TDTestCase:
    def caseDescription(self):
        '''
        case1<shenglian zhou>: nchar bugs on outer query, order by ts in outer query, and ucs4 mbs conversion 
        ''' 
        return
    
    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)
        self._conn = conn
        
    def restartTaosd(self, index=1, dbname="db"):
        tdDnodes.stop(index)
        tdDnodes.startWithoutSleep(index)
        tdSql.execute(f"use nchardb")

    def run(self):
        print("running {}".format(__file__))
        tdSql.execute("drop database if exists nchardb")
        tdSql.execute("create database if not exists nchardb")
        tdSql.execute('use nchardb')



        tdSql.execute('create stable stable_1 (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);')

        tdSql.execute('create stable stable_2 (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);')

        tdSql.execute('create stable stable_null_data (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);')

        tdSql.execute('create stable stable_null_childtable (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                 q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp)                 tags(loc nchar(100) , t_int int , t_bigint bigint , t_smallint smallint , t_tinyint tinyint, t_bool bool , t_binary binary(100) , t_nchar nchar(100) ,t_float float , t_double double , t_ts timestamp);')

        tdSql.execute("create table stable_1_1 using stable_1 tags('stable_1_1', '0' , '0' , '0' , '0' , 0 , 'binary1' , 'nchar1' , '0' , '0' ,'0') ;")

        tdSql.execute("create table stable_1_2 using stable_1 tags('stable_1_2', '2147483647' , '9223372036854775807' , '32767' , '127' , 1 , 'binary2' , 'nchar2' , '2' , '22' , '1999-09-09 09:09:09.090') ;")

        tdSql.execute("create table stable_1_3 using stable_1 tags('stable_1_3', '-2147483647' , '-9223372036854775807' , '-32767' , '-127' , false , 'binary3' , 'nchar3nchar3' , '-3.3' , '-33.33' , '2099-09-09 09:09:09.090') ;")

        tdSql.execute("create table stable_1_4 using stable_1 tags('stable_1_4', '0' , '0' , '0' , '0' , 0 , '0' , '0' , '0' , '0' ,'0') ;")

        tdSql.execute("create table stable_2_1 using stable_2 tags('stable_2_1' , '0' , '0' , '0' , '0' , 0 , 'binary21' , 'nchar21' , '0' , '0' ,'0') ;")

        tdSql.execute("create table stable_2_2 using stable_2 tags('stable_2_2' , '0' , '0' , '0' , '0' , 0 , '0' , '0' , '0' , '0' ,'0') ;")

        tdSql.execute("create table stable_null_data_1 using stable_null_data tags('stable_null_data_1', '0' , '0' , '0' , '0' , 0 , '0' , '0' , '0' , '0' ,'0') ;")

        tdSql.execute('create table regular_table_1                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                    q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                    q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;')

        tdSql.execute('create table regular_table_2                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                    q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                    q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;')

        tdSql.execute('create table regular_table_3                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                    q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                    q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;')

        tdSql.execute('create table regular_table_null                     (ts timestamp , q_int int , q_bigint bigint , q_smallint smallint , q_tinyint tinyint , q_float float , q_double double , q_bool bool , q_binary binary(100) , q_nchar nchar(100) , q_ts timestamp ,                     q_binary1 binary(100) , q_nchar1 nchar(100) ,q_binary2 binary(100) , q_nchar2 nchar(100) ,q_binary3 binary(100) , q_nchar3 nchar(100) ,q_binary4 binary(100) , q_nchar4 nchar(100) ,                    q_binary5 binary(100) , q_nchar5 nchar(100) ,q_binary6 binary(100) , q_nchar6 nchar(100) ,q_binary7 binary(100) , q_nchar7 nchar(100) ,q_binary8 binary(100) , q_nchar8 nchar(100) ,                    q_int_null int , q_bigint_null bigint , q_smallint_null smallint , q_tinyint_null tinyint, q_float_null float , q_double_null double , q_bool_null bool , q_binary_null binary(20) , q_nchar_null nchar(20) , q_ts_null timestamp) ;')

        tdSql.execute("insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000000, -439727522, 612301787638826993, 9533, -97, 3516.375596, -63.596320, 0, 'binary.PIhHdeegEoHadxQpLAQI', 'nchar.福建省辽阳县丰都熊街u座 233621', 1630000000000, 'binary1.JgnEFSLkRtzEQOZsUibN', 'nchar1.福建省宜都县海港王街M座 713195', 'binary2.tsCyNVyBJDCnIvUdjVev', 'nchar2.宁夏回族自治区兰州市淄川香港路Y座 213761', 'binary3.AlZhLGOLRoWDRvqbsWfC', 'nchar3.海南省静市江北海口路X座 702375', 'binary4.NdciuKObKZYwDVhtIOgB', 'nchar4.四川省桂荣市滨城林街m座 503259', 'binary5.BUEJHkTvXfstJGArxcBz', 'nchar5.贵州省大冶县滨城梧州街P座 554324', 'binary6.ArgeExOkcjzjHDtyQARL', 'nchar6.山东省建华市魏都南京街o座 326153', 'binary7.QvDuzpiSJhpNBmQKHeWb', 'nchar7.湖北省桂芳市高明邯郸路q座 413345', 'binary8.WglkhUkXHcTYoWgshnnp', 'nchar8.内蒙古自治区太原县萧山王路p座 322176') ;")

        tdSql.execute("insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000000, -1927728216, -6011044987062918899, 21730, 55, -379272379409.344971, 202621.613403, 0, 'binary.mgOAjgCfpIKVvJcFNMOc', 'nchar.上海市彬市丰都王路e座 634384', 1630000000000, 'binary1.cSVybMOLDLDvyNSJbRrc', 'nchar1.天津市潮州县金平胡街m座 378486', 'binary2.bdYIDYtteQeyjJkksUGK', 'nchar2.黑龙江省帅市崇文沈阳路Y座 103751', 'binary3.azSbzOjOyaUCFOTIsgHG', 'nchar3.河北省成都市东丽李街k座 303784', 'binary4.ohUNyPlQqkiMzpeTyOWS', 'nchar4.江苏省俊县西夏辛集街U座 593642', 'binary5.ENaKrNBgrArvKrFVzzlr', 'nchar5.北京市澳门县闵行杭州街L座 506999', 'binary6.VOHdDIsQoSrmQChGJvNB', 'nchar6.山西省敏县新城成都街b座 364960', 'binary7.SBvUJKRslUvmfsqGTtNO', 'nchar7.浙江省深圳市大东李路m座 882995', 'binary8.fcjjRXqwaSllnpvnvkYn', 'nchar8.云南省帅县城北香港街E座 477480') ;")

        tdSql.execute("insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000000, 896032926, 6023643830222415811, 21936, 49, -3817.697182, -641551013002.837036, 1, 'binary.qjCLjIApCPmxDrPLinCu', 'nchar.安徽省洁县翔安南宁路q座 420885', 1630000000000, 'binary1.cGMsWYzwmvbENGnODINP', 'nchar1.陕西省惠州县城东郑州街a座 702479', 'binary2.FeyVxiUQWvaCkYlzlfeG', 'nchar2.上海市宁德市淄川周路n座 803882', 'binary3.UkNjWBPyCBRgkpmvtpWw', 'nchar3.北京市峰市璧山刘路G座 746867', 'binary4.xqFUKKJYHIpPlfyNuhFF', 'nchar4.湖北省齐齐哈尔市静安蒋街w座 215779', 'binary5.CCRGhhIjzzUEyhmxALRL', 'nchar5.北京市桂香市城东淮安街K座 265859', 'binary6.gvlOwjDLsDuPaCcVqiIX', 'nchar6.四川省东县静安余路Y座 617110', 'binary7.UXOSeWwjOJAoMNtgvPQE', 'nchar7.江西省玉英市海港澳门路q座 945219', 'binary8.mDiEkZDpVpDrdKUbhvcT', 'nchar8.香港特别行政区太原市黄浦黄街P座 177199') ;")

        tdSql.execute("insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000000, 651177360, 1729081754117700025, 23056, 13, -6.636242, 82.921964, 1, 'binary.EoaIaneNQHMAUIbOidQe', 'nchar.广西壮族自治区天津县花溪魏街i座 376191', 1630000000000, 'binary1.HlIOKTKSbfaVAlClZuBh', 'nchar1.四川省柳县黄浦林路C座 108476', 'binary2.JLsEXPSzqGmcVHMLgAHh', 'nchar2.上海市济南市平山合山街Z座 778571', 'binary3.mxAFCDLuRGaHOqmLIJpE', 'nchar3.河南省沈阳市南溪潜江街A座 468196', 'binary4.oXDqUtayeNmHovscxiVq', 'nchar4.海南省亮市高港海门路K座 870267', 'binary5.BLksYIROpOJhmClgwqyK', 'nchar5.山东省宜都县滨城徐街N座 306711', 'binary6.CoRjxWPAzdBYFOgiZzeg', 'nchar6.广西壮族自治区霞市长寿沈阳路L座 914991', 'binary7.MLfTLPVrPGvrcJYFqfFC', 'nchar7.辽宁省合肥市高明李路l座 224862', 'binary8.IfxKkLWFTHNeNEflRfzY', 'nchar8.新疆维吾尔自治区沈阳县朝阳福州街q座 939080') ;")

        tdSql.execute("insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000001, -746014185, -6611210245469344058, -27252, -77, -243654741.301468, -8.444537, 1, 'binary.EVYMoxfQftKyeUxzjhIj', 'nchar.江苏省六安县上街祁街p座 147895', 1630000000001, 'binary1.EqegqpWNNQmNarUebJgx', 'nchar1.北京市石家庄县高明太原街V座 139496', 'binary2.CgjLFXASsqDMbqpClkyo', 'nchar2.江苏省合山县涪城重庆路Q座 428968', 'binary3.wxQqnqtofXGaaQDIcVCL', 'nchar3.河南省呼和浩特市锡山兴城街O座 840658', 'binary4.zyKhpKkjeZokFeegJQDi', 'nchar4.西藏自治区潜江县魏都钟街i座 919700', 'binary5.OrEfrEsydYTamaZkNkwk', 'nchar5.重庆市兰英县沙湾嘉禾街c座 775060', 'binary6.NIpeYChLyWNMVOoSuDQY', 'nchar6.天津市杨市萧山合肥街b座 371505', 'binary7.gYzZPgKZiebmbgARfhbW', 'nchar7.河北省西安市浔阳通辽街w座 546863', 'binary8.sGpPIgZTnhPvEqbASIzz', 'nchar8.宁夏回族自治区文市朝阳昆明街O座 933200') ;")

        tdSql.execute("insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000001, -1971853248, -1403199549636457306, -21922, -13, 77363611038104.703125, -458826.670338, 1, 'binary.dLopzuuaEkQyOKdwEkoF', 'nchar.浙江省深圳县涪城贵阳路L座 154418', 1630000000001, 'binary1.VsdtZMdFeVMRVgpklpmT', 'nchar1.澳门特别行政区佛山市闵行兴安盟路O座 197626', 'binary2.NDlRTlhCWMfVPcQUDEAU', 'nchar2.贵州省长沙县永川金街F座 263410', 'binary3.YySoOsWslJgqFFJLByXa', 'nchar3.辽宁省兴安盟市崇文崔街W座 740261', 'binary4.htDrNqFhPBUEgnwqUnJy', 'nchar4.上海市杨县西峰天津街A座 215633', 'binary5.PICqEmpTJMRRFMoLiAYL', 'nchar5.四川省拉萨县清浦戴路d座 807565', 'binary6.TcHUZlyIvOLzjzOLQVeY', 'nchar6.福建省玉市金平西宁路y座 216505', 'binary7.KVgSEZbApHVciiiHdmMv', 'nchar7.广东省香港市友好张路N座 530133', 'binary8.BbnDEmsmbuMsmARBrmaB', 'nchar8.陕西省淮安市西峰淮安路G座 471156') ;")

        tdSql.execute("insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000000, 1290384855, 6453496169647608559, 17237, 78, -4556903756831.950195, 8558137.310094, 0, 'binary.RicjHNdlJvZXcuIUCtwp', 'nchar.辽宁省小红县安次刘路I座 783067', 1630000000000, 'binary1.PZrbgCdVlhLuYWzJfpcQ', 'nchar1.澳门特别行政区武汉市璧山孔路Y座 467679', 'binary2.CCmnLmgCmPDGsacmypKr', 'nchar2.广东省哈尔滨市朝阳巢湖路P座 520015', 'binary3.xpmnymjjdbpefsJbXiaA', 'nchar3.宁夏回族自治区齐齐哈尔市长寿海门路s座 980357', 'binary4.MQQAGeTBCbbAFmyCdNdx', 'nchar4.天津市哈尔滨县新城杨路w座 877346', 'binary5.jcGNOXcvsteCwnVwZxkv', 'nchar5.青海省哈尔滨市蓟州雷路S座 774634', 'binary6.sFIopESAmZxNtpEAXvmh', 'nchar6.上海市琳市萧山朴路I座 857895', 'binary7.GJEBncpKznEVYlBjADXc', 'nchar7.内蒙古自治区永安县南湖王路m座 128263', 'binary8.bseliCaYePtOlhjBDKlA', 'nchar8.新疆维吾尔自治区畅市清浦惠州路Y座 221741') ;")

        tdSql.execute("insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000001, 1577644138, 5424290571527673071, 21765, 84, 592473004730.168945, 1461967845107.139893, 0, 'binary.REnSISlqmqqrnTVDsVuc', 'nchar.浙江省呼和浩特市丰都田街T座 149274', 1630000000000, 'binary1.QBTMVrRvMGcRSiUFpsnA', 'nchar1.甘肃省佛山县大兴石家庄街y座 699134', 'binary2.iaKGuopmHqqbANMmhQaB', 'nchar2.福建省杭州县闵行福州街e座 356019', 'binary3.pAdZtAJFuMQGiLYWCFzp', 'nchar3.天津市玲市梁平阜新路R座 699400', 'binary4.bJvTLLaAsMVnxxKragLA', 'nchar4.内蒙古自治区银川市萧山乌鲁木齐街p座 711931', 'binary5.ITFlhuZlVWIBJqLhkOey', 'nchar5.陕西省桂芳县南湖北镇路s座 173929', 'binary6.EZDRIMGNFYtddfbOlkvT', 'nchar6.四川省兴城市沙湾李街p座 370512', 'binary7.RunKOCOVDEkKXXLbQQwD', 'nchar7.河北省兴安盟市萧山张路n座 447381', 'binary8.YOTuRbbLIqBCEgLddPwI', 'nchar8.北京市文县浔阳澳门路h座 816162') ;")

        tdSql.execute("insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000000010, 2090912853, 6664951181911026762, 27365, 66, -584038.233035, -934072263.917529, 0, 'binary.aqhUfBvmuNqFySsMkMdt', 'nchar.湖南省瑞县沙市王街c座 200752', 1630000000000, 'binary1.MwStUNfrTBVbvhHjfNza', 'nchar1.河北省雪市魏都杜街i座 259384', 'binary2.DGmDtcyaEObwuQVxDpUP', 'nchar2.湖北省淑兰县普陀胡路n座 716038', 'binary3.IAounswvgoPxMXtsqnwU', 'nchar3.甘肃省永安县南湖银川街C座 330264', 'binary4.wPwqkMLYqzkhmRHRpKAy', 'nchar4.上海市通辽市浔阳北镇路H座 317911', 'binary5.iQoYVJdmAoSBlyGpJpXx', 'nchar5.浙江省建华市大兴永安街K座 644305', 'binary6.MmjmFrioKDTFoegthaRD', 'nchar6.澳门特别行政区楠市龙潭太原路f座 611785', 'binary7.aHloPsebqjkwcCRXAcGc', 'nchar7.北京市桂芝市高港许街N座 542112', 'binary8.xvNxozZWlsTvtweWXQrl', 'nchar8.山东省北镇市静安巢湖路N座 751441') ;")

        tdSql.execute("insert into stable_1_1  (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double , q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001000, 1154867532, -4617169670731049020, 21991, -24, 1168661238750.610107, -426107677972.705994, 0, 'binary.hRmglnSXuxUSvYIqDolS', 'nchar.天津市齐齐哈尔市兴山王路e座 440016', 1630000000001, 'binary1.rpZLfFIvigPxgWvEiTnf', 'nchar1.天津市欣县上街李街n座 110533', 'binary2.CWBcufneMDLIfNmMyDQD', 'nchar2.甘肃省利市房山姜路f座 539129', 'binary3.uhGROtaovBUWCsBUcRUS', 'nchar3.贵州省嘉禾县安次天津路a座 385203', 'binary4.iXwEQVdoHPejKHgtUcnp', 'nchar4.山西省乌鲁木齐县西峰王街z座 375814', 'binary5.YxaTiRVvJItsdEsMogEr', 'nchar5.陕西省金凤市静安邵街s座 349352', 'binary6.znhgdUaTGWcwjmZAsZtC', 'nchar6.澳门特别行政区宁德县朝阳苏路r座 964005', 'binary7.OaZVpQWKsvDQANUDbcVU', 'nchar7.云南省凯市淄川柳州路g座 551620', 'binary8.XKoaJcnvWGWgtmCHASlj', 'nchar8.山西省洋县吉区袁街k座 383085') ;")

        tdSql.execute("insert into  regular_table_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001000, -1295218132, -2795255426441574417, -25856, -79, 31169.428912, -33.958690, 0, 'binary.qhHqAnxdwJQzpAIOnKsM', 'nchar.黑龙江省海口县上街张街B座 580665', 1630000000001, 'binary1.dFkcGdPczduswPtesnoF', 'nchar1.台湾省杰县丰都汪路j座 804255', 'binary2.pYgofQUdjJTzXLHZcNSc', 'nchar2.黑龙江省南昌市朝阳纪路i座 993767', 'binary3.UXtZpmwhjyEPOHhZyUxJ', 'nchar3.内蒙古自治区红市和平潮州路m座 803939', 'binary4.PHswTmYqZhTldHjklJYF', 'nchar4.四川省淮安市怀柔荆门路B座 969808', 'binary5.dKzVSArjPVLJXGTDWuOn', 'nchar5.台湾省璐县吉区梧州路T座 112945', 'binary6.AQrpGtxOsELOgWzfUxBo', 'nchar6.宁夏回族自治区淑兰县江北包街K座 510189', 'binary7.nYDVRmWgROIOOrVqCOse', 'nchar7.湖北省玉兰县双滦王街V座 272885', 'binary8.VCfynbYrgaMmjRiXHdUK', 'nchar8.贵州省畅县孝南宁德路z座 172562') ;")

        tdSql.execute("insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001000, 1406358857, 3587109948379738474, 6769, 53, -6976945.888649, 7.677615, 1, 'binary.owVOUICouSTklPEhbivn', 'nchar.内蒙古自治区辽阳县普陀柳路a座 840131', 1630000000001, 'binary1.uJCOuTOBoHKrmxJuPjWe', 'nchar1.北京市帅市长寿王街h座 105426', 'binary2.XWXOVmhROrAgBbsXANmC', 'nchar2.澳门特别行政区金凤县海港荆门路x座 762691', 'binary3.gxCneIGHUGBNHhjKfxYi', 'nchar3.宁夏回族自治区惠州县长寿李路R座 863651', 'binary4.rRYTZlEWfyBoprvSjmrU', 'nchar4.宁夏回族自治区平县秀英马路e座 846867', 'binary5.dDdPBqkpKquoRoacZZda', 'nchar5.河南省凤兰市大兴兴城路n座 845990', 'binary6.iITctvWPvSZocnjfyaAT', 'nchar6.重庆市永安市崇文宁德路L座 343620', 'binary7.fcDNUjTjvwxhYLLCMLCL', 'nchar7.上海市淑华市安次杨街s座 495789', 'binary8.wVedqBcRAcpUPMTNhrHz', 'nchar8.陕西省军县丰都王街T座 625091') ;")

        tdSql.execute("insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001000, 529011547, 5833219696463195177, 1368, 65, 88870.197516, 99120299502.128296, 1, 'binary.UxevmcLToszoUNHugtyM', 'nchar.安徽省红县安次叶路T座 440225', 1630000000001, 'binary1.sjsxFPefdlFKrTRAVouS', 'nchar1.贵州省柳州县海陵关岭街j座 890479', 'binary2.VOmSguDBtwojjcfmekbK', 'nchar2.贵州省兰州市沈北新汕尾路C座 478355', 'binary3.lJyJEMVjrqMUsmoBpWRN', 'nchar3.浙江省银川市友好黄街n座 118384', 'binary4.dgfhUSYsixNpyrERBkHr', 'nchar4.四川省琴市华龙方街J座 391129', 'binary5.hOVSTUkubHIghBwgKwEG', 'nchar5.陕西省瑜市华龙六安路x座 164875', 'binary6.SjWSOGeaMjBWIpoZSAcU', 'nchar6.河北省大冶市双滦孙路p座 902942', 'binary7.yAJcsKTMIyIhZijNsPkS', 'nchar7.台湾省银川市上街天津街U座 414513', 'binary8.BDMFDVvENIJkyoakNOvS', 'nchar8.重庆市荆门县南长银川街K座 999033') ;")

        tdSql.execute("insert into stable_1_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001001, -1866552988, -758901224671643352, -255, -64, -0.884551, -26.457607, 1, 'binary.draSVywTJWrxguXBtWEq', 'nchar.山东省上海县沙市翟街f座 172428', 1630000000002, 'binary1.nOXUZkAqDrnKxtwOxqtf', 'nchar1.辽宁省飞县牧野张路C座 379691', 'binary2.NKVuIxfhKuRiIGxqAQEh', 'nchar2.湖南省玉华市双滦王路Y座 106635', 'binary3.IWFsIUfCFJpynVEWFykw', 'nchar3.甘肃省宇县东城宜都路q座 883419', 'binary4.oYHgrkuMqsznJYiuMOGG', 'nchar4.台湾省邯郸市白云吴路H座 185871', 'binary5.DHSVcnCnLheJAOYMLLBJ', 'nchar5.新疆维吾尔自治区秀芳市怀柔巢湖路h座 193210', 'binary6.manaViLNdwzCBTxsJkdC', 'nchar6.辽宁省海门县大东马鞍山街q座 452562', 'binary7.ulrIznjySbFuIFWWjgnE', 'nchar7.新疆维吾尔自治区文市海陵刘街U座 979746', 'binary8.dAekCjvegomJekAMZOYY', 'nchar8.广西壮族自治区辽阳市城北李街c座 242662') ;")

        tdSql.execute("insert into regular_table_2 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001001, -741599443, -2779047021078882907, -2391, -17, 4299185271508.240234, 604469850161.758057, 1, 'binary.fXHBNYpwPFvxpmfkIJKq', 'nchar.河南省郑州县金平张路s座 406855', 1630000000002, 'binary1.qMsKGcIfmJmzqrLkaMZW', 'nchar1.台湾省齐齐哈尔县淄川乌路r座 947114', 'binary2.gUenDGAMpsjwAoLzuAVX', 'nchar2.江西省张家港县清浦上海街i座 960744', 'binary3.bnaWRmgZlUyMPaePUnrA', 'nchar3.香港特别行政区柳市永川张街A座 685451', 'binary4.ItKAwCgHdhBbQKJPJuWl', 'nchar4.陕西省飞县房山台北街P座 773575', 'binary5.obrRlauJBKUQjZeeDKzk', 'nchar5.澳门特别行政区丹丹市清城巢湖路D座 164790', 'binary6.EHcbDRSkpFjfYgoAhipL', 'nchar6.辽宁省小红市沈河高路R座 491125', 'binary7.zBsdfSePYONCPTFpSxtd', 'nchar7.浙江省玉英县孝南潮州街Q座 240622', 'binary8.ktVwuMPStmephdhCyXpW', 'nchar8.广西壮族自治区晨市沙湾宋路n座 375716') ;")

        tdSql.execute("insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001000, 861043174, 5455100179131942803, 11627, 93, 4704891958.274140, -90663765201548.906250, 0, 'binary.mzefOJuVapGcOZRBPWSA', 'nchar.湖南省桂香市合川武汉路e座 190074', 1630000000001, 'binary1.OKSAdzYZtxmTYgUqDTUJ', 'nchar1.天津市西安市房山程路g座 201540', 'binary2.UVZXgaXnvsOFMyfQtxlk', 'nchar2.辽宁省武汉市清浦长春路C座 249816', 'binary3.cykuADWPZFQANvsqhRKX', 'nchar3.河北省刚市东城解路i座 865426', 'binary4.KJUftFRDQqQZOjPRbash', 'nchar4.辽宁省长沙县永川张路h座 794840', 'binary5.mzizxALkpwFvhsDKDZLX', 'nchar5.上海市哈尔滨市长寿阎街d座 505069', 'binary6.COpyPYrULAJYVDcSidce', 'nchar6.上海市桂英县沙湾魏街v座 727936', 'binary7.EraykZvYQkepZTyCLhrX', 'nchar7.新疆维吾尔自治区婷市兴山齐齐哈尔街T座 467826', 'binary8.qpqMrYpGgIWuzjCwqRtA', 'nchar8.辽宁省凤兰市魏都沈阳路D座 852593') ;")

        tdSql.execute("insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001001, 891559292, 8826812031501648951, 25495, 17, -2673857362.484810, -992615811880.187012, 0, 'binary.sUSMJvnrtyRGAdkofSRp', 'nchar.北京市乌鲁木齐县金平郑州街K座 565319', 1630000000001, 'binary1.bkypAUrybRZdjEAQpLaD', 'nchar1.香港特别行政区通辽市清城张家港街g座 456475', 'binary2.mTeRDPIPKIqXXaCKxZZg', 'nchar2.海南省潜江市六枝特张路D座 742115', 'binary3.pXNShlLsrfFhMkZVJmvJ', 'nchar3.内蒙古自治区成市海港重庆街z座 935702', 'binary4.ePZMxraOFLRUirwjYQgz', 'nchar4.甘肃省哈尔滨县南溪兴城路B座 464192', 'binary5.EnZjhIMsFGQHTNgGwlLY', 'nchar5.山东省天津市门头沟齐齐哈尔路H座 590367', 'binary6.OwvaiZKpWMEuXNefCdSd', 'nchar6.广西壮族自治区凯县高坪葛路i座 733075', 'binary7.eZvrAHwgOSpNfkWOheQK', 'nchar7.云南省佳县大兴刘街b座 134332', 'binary8.mmASwYqspmYxzgEQMScD', 'nchar8.福建省秀英市高明广州街S座 972859') ;")

        tdSql.execute("insert into stable_2_1 (ts , q_int , q_bigint , q_smallint , q_tinyint , q_float , q_double, q_bool , q_binary , q_nchar, q_ts,q_binary1 , q_nchar1 , q_binary2 , q_nchar2 , q_binary3 , q_nchar3 , q_binary4 , q_nchar4 , q_binary5 , q_nchar5 , q_binary6 , q_nchar6 , q_binary7 , q_nchar7, q_binary8 , q_nchar8) values(1630000001010, 1406420228, 3809984898292539483, 15475, 82, -96.706822, 944989.967705, 0, 'binary.ZeTYsWJUdikuGndNhdDg', 'nchar.四川省潜江县蓟州陈街G座 347914', 1630000000001, 'binary1.xWLSLgSXgNPMCtEqeIem', 'nchar1.山东省辽阳县锡山上海路R座 816023', 'binary2.vdRFTigUtJQpwmklHmqs', 'nchar2.浙江省彬县崇文尚街v座 145248', 'binary3.DuUfOKRvTmFXKPglEJLy', 'nchar3.山西省秀荣市崇文嘉禾路b座 658257', 'binary4.XdprBDmPQensCLNylpfX', 'nchar4.青海省柳州县沈北新张家港街A座 207436', 'binary5.trUYUEAEeXecKeYDqBGX', 'nchar5.台湾省东市新城张路Q座 187531', 'binary6.gQwmTXQOFCblFwaBGoFG', 'nchar6.澳门特别行政区秀珍市萧山长春路D座 398394', 'binary7.djQZYSGDCbforCnoDkRE', 'nchar7.安徽省兴安盟市和平丰街o座 702930', 'binary8.QIuisWlGYavgxfQjfnAd', 'nchar8.黑龙江省海燕县闵行沈阳街S座 986676') ;")

        tdSql.query('select CONCAT_WS(" , , abc, 123",q_nchar2, q_nchar1, q_nchar3, q_nchar6) from stable_1;')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'nchar2.宁夏回族自治区兰州市淄川香港路Y座 213761 , , abc, 123nchar1.福建省宜都县海港王街M座 713195 , , abc, 123nchar3.海南省静市江北海口路X座 702375 , , abc, 123nchar6.山东省建华市魏都南京街o座 326153')
        tdSql.checkData(1, 0, 'nchar2.甘肃省利市房山姜路f座 539129 , , abc, 123nchar1.天津市欣县上街李街n座 110533 , , abc, 123nchar3.贵州省嘉禾县安次天津路a座 385203 , , abc, 123nchar6.澳门特别行政区宁德县朝阳苏路r座 964005')
        tdSql.checkData(2, 0, 'nchar2.上海市宁德市淄川周路n座 803882 , , abc, 123nchar1.陕西省惠州县城东郑州街a座 702479 , , abc, 123nchar3.北京市峰市璧山刘路G座 746867 , , abc, 123nchar6.四川省东县静安余路Y座 617110')
        tdSql.checkData(3, 0, 'nchar2.江苏省合山县涪城重庆路Q座 428968 , , abc, 123nchar1.北京市石家庄县高明太原街V座 139496 , , abc, 123nchar3.河南省呼和浩特市锡山兴城街O座 840658 , , abc, 123nchar6.天津市杨市萧山合肥街b座 371505')
        tdSql.checkData(4, 0, 'nchar2.澳门特别行政区金凤县海港荆门路x座 762691 , , abc, 123nchar1.北京市帅市长寿王街h座 105426 , , abc, 123nchar3.宁夏回族自治区惠州县长寿李路R座 863651 , , abc, 123nchar6.重庆市永安市崇文宁德路L座 343620')
        tdSql.checkData(5, 0, 'nchar2.湖南省玉华市双滦王路Y座 106635 , , abc, 123nchar1.辽宁省飞县牧野张路C座 379691 , , abc, 123nchar3.甘肃省宇县东城宜都路q座 883419 , , abc, 123nchar6.辽宁省海门县大东马鞍山街q座 452562')

        tdSql.query('select concat_ws(" , , abc, 山东省", q_nchar2, q_nchar1, q_nchar4, q_nchar6) from stable_1;')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'nchar2.宁夏回族自治区兰州市淄川香港路Y座 213761 , , abc, 山东省nchar1.福建省宜都县海港王街M座 713195 , , abc, 山东省nchar4.四川省桂荣市滨城林街m座 503259 , , abc, 山东省nchar6.山东省建华市魏都南京街o座 326153')
        tdSql.checkData(1, 0, 'nchar2.甘肃省利市房山姜路f座 539129 , , abc, 山东省nchar1.天津市欣县上街李街n座 110533 , , abc, 山东省nchar4.山西省乌鲁木齐县西峰王街z座 375814 , , abc, 山东省nchar6.澳门特别行政区宁德县朝阳苏路r座 964005')
        tdSql.checkData(2, 0, 'nchar2.上海市宁德市淄川周路n座 803882 , , abc, 山东省nchar1.陕西省惠州县城东郑州街a座 702479 , , abc, 山东省nchar4.湖北省齐齐哈尔市静安蒋街w座 215779 , , abc, 山东省nchar6.四川省东县静安余路Y座 617110')
        tdSql.checkData(3, 0, 'nchar2.江苏省合山县涪城重庆路Q座 428968 , , abc, 山东省nchar1.北京市石家庄县高明太原街V座 139496 , , abc, 山东省nchar4.西藏自治区潜江县魏都钟街i座 919700 , , abc, 山东省nchar6.天津市杨市萧山合肥街b座 371505')
        tdSql.checkData(4, 0, 'nchar2.澳门特别行政区金凤县海港荆门路x座 762691 , , abc, 山东省nchar1.北京市帅市长寿王街h座 105426 , , abc, 山东省nchar4.宁夏回族自治区平县秀英马路e座 846867 , , abc, 山东省nchar6.重庆市永安市崇文宁德路L座 343620')
        tdSql.checkData(5, 0, 'nchar2.湖南省玉华市双滦王路Y座 106635 , , abc, 山东省nchar1.辽宁省飞县牧野张路C座 379691 , , abc, 山东省nchar4.台湾省邯郸市白云吴路H座 185871 , , abc, 山东省nchar6.辽宁省海门县大东马鞍山街q座 452562')

        tdSql.query('select concat_ws(" , , abc, 山东省", q_nchar2, q_nchar1, q_nchar4, q_nchar6) from (select * from stable_1);')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'nchar2.宁夏回族自治区兰州市淄川香港路Y座 213761 , , abc, 山东省nchar1.福建省宜都县海港王街M座 713195 , , abc, 山东省nchar4.四川省桂荣市滨城林街m座 503259 , , abc, 山东省nchar6.山东省建华市魏都南京街o座 326153')
        tdSql.checkData(1, 0, 'nchar2.甘肃省利市房山姜路f座 539129 , , abc, 山东省nchar1.天津市欣县上街李街n座 110533 , , abc, 山东省nchar4.山西省乌鲁木齐县西峰王街z座 375814 , , abc, 山东省nchar6.澳门特别行政区宁德县朝阳苏路r座 964005')
        tdSql.checkData(2, 0, 'nchar2.上海市宁德市淄川周路n座 803882 , , abc, 山东省nchar1.陕西省惠州县城东郑州街a座 702479 , , abc, 山东省nchar4.湖北省齐齐哈尔市静安蒋街w座 215779 , , abc, 山东省nchar6.四川省东县静安余路Y座 617110')
        tdSql.checkData(3, 0, 'nchar2.江苏省合山县涪城重庆路Q座 428968 , , abc, 山东省nchar1.北京市石家庄县高明太原街V座 139496 , , abc, 山东省nchar4.西藏自治区潜江县魏都钟街i座 919700 , , abc, 山东省nchar6.天津市杨市萧山合肥街b座 371505')
        tdSql.checkData(4, 0, 'nchar2.澳门特别行政区金凤县海港荆门路x座 762691 , , abc, 山东省nchar1.北京市帅市长寿王街h座 105426 , , abc, 山东省nchar4.宁夏回族自治区平县秀英马路e座 846867 , , abc, 山东省nchar6.重庆市永安市崇文宁德路L座 343620')
        tdSql.checkData(5, 0, 'nchar2.湖南省玉华市双滦王路Y座 106635 , , abc, 山东省nchar1.辽宁省飞县牧野张路C座 379691 , , abc, 山东省nchar4.台湾省邯郸市白云吴路H座 185871 , , abc, 山东省nchar6.辽宁省海门县大东马鞍山街q座 452562')

        tdSql.query('select upper(q_nchar1),upper(q_nchar2),length(q_nchar1),char_length(q_nchar1),lower(q_nchar1) from (select * from stable_1);')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR1.福建省宜都县海港王街M座 713195')
        tdSql.checkData(0, 1, 'NCHAR2.宁夏回族自治区兰州市淄川香港路Y座 213761')
        tdSql.checkData(0, 2, 104)
        tdSql.checkData(0, 3, 26)
        tdSql.checkData(0, 4, 'nchar1.福建省宜都县海港王街m座 713195')
        tdSql.checkData(1, 0, 'NCHAR1.天津市欣县上街李街N座 110533')
        tdSql.checkData(1, 1, 'NCHAR2.甘肃省利市房山姜路F座 539129')
        tdSql.checkData(1, 2, 100)
        tdSql.checkData(1, 3, 25)
        tdSql.checkData(1, 4, 'nchar1.天津市欣县上街李街n座 110533')
        tdSql.checkData(2, 0, 'NCHAR1.陕西省惠州县城东郑州街A座 702479')
        tdSql.checkData(2, 1, 'NCHAR2.上海市宁德市淄川周路N座 803882')
        tdSql.checkData(2, 2, 108)
        tdSql.checkData(2, 3, 27)
        tdSql.checkData(2, 4, 'nchar1.陕西省惠州县城东郑州街a座 702479')
        tdSql.checkData(3, 0, 'NCHAR1.北京市石家庄县高明太原街V座 139496')
        tdSql.checkData(3, 1, 'NCHAR2.江苏省合山县涪城重庆路Q座 428968')
        tdSql.checkData(3, 2, 112)
        tdSql.checkData(3, 3, 28)
        tdSql.checkData(3, 4, 'nchar1.北京市石家庄县高明太原街v座 139496')
        tdSql.checkData(4, 0, 'NCHAR1.北京市帅市长寿王街H座 105426')
        tdSql.checkData(4, 1, 'NCHAR2.澳门特别行政区金凤县海港荆门路X座 762691')
        tdSql.checkData(4, 2, 100)
        tdSql.checkData(4, 3, 25)
        tdSql.checkData(4, 4, 'nchar1.北京市帅市长寿王街h座 105426')
        tdSql.checkData(5, 0, 'NCHAR1.辽宁省飞县牧野张路C座 379691')
        tdSql.checkData(5, 1, 'NCHAR2.湖南省玉华市双滦王路Y座 106635')
        tdSql.checkData(5, 2, 100)
        tdSql.checkData(5, 3, 25)
        tdSql.checkData(5, 4, 'nchar1.辽宁省飞县牧野张路c座 379691')

        tdSql.query('select upper(q_nchar1),upper(q_nchar2),length(q_nchar1),char_length(q_nchar1),lower(q_nchar1) from (select * from stable_1) order by ts;')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR1.福建省宜都县海港王街M座 713195')
        tdSql.checkData(0, 1, 'NCHAR2.宁夏回族自治区兰州市淄川香港路Y座 213761')
        tdSql.checkData(0, 2, 104)
        tdSql.checkData(0, 3, 26)
        tdSql.checkData(0, 4, 'nchar1.福建省宜都县海港王街m座 713195')
        tdSql.checkData(1, 0, 'NCHAR1.陕西省惠州县城东郑州街A座 702479')
        tdSql.checkData(1, 1, 'NCHAR2.上海市宁德市淄川周路N座 803882')
        tdSql.checkData(1, 2, 108)
        tdSql.checkData(1, 3, 27)
        tdSql.checkData(1, 4, 'nchar1.陕西省惠州县城东郑州街a座 702479')
        tdSql.checkData(2, 0, 'NCHAR1.北京市石家庄县高明太原街V座 139496')
        tdSql.checkData(2, 1, 'NCHAR2.江苏省合山县涪城重庆路Q座 428968')
        tdSql.checkData(2, 2, 112)
        tdSql.checkData(2, 3, 28)
        tdSql.checkData(2, 4, 'nchar1.北京市石家庄县高明太原街v座 139496')
        tdSql.checkData(3, 0, 'NCHAR1.天津市欣县上街李街N座 110533')
        tdSql.checkData(3, 1, 'NCHAR2.甘肃省利市房山姜路F座 539129')
        tdSql.checkData(3, 2, 100)
        tdSql.checkData(3, 3, 25)
        tdSql.checkData(3, 4, 'nchar1.天津市欣县上街李街n座 110533')
        tdSql.checkData(4, 0, 'NCHAR1.北京市帅市长寿王街H座 105426')
        tdSql.checkData(4, 1, 'NCHAR2.澳门特别行政区金凤县海港荆门路X座 762691')
        tdSql.checkData(4, 2, 100)
        tdSql.checkData(4, 3, 25)
        tdSql.checkData(4, 4, 'nchar1.北京市帅市长寿王街h座 105426')
        tdSql.checkData(5, 0, 'NCHAR1.辽宁省飞县牧野张路C座 379691')
        tdSql.checkData(5, 1, 'NCHAR2.湖南省玉华市双滦王路Y座 106635')
        tdSql.checkData(5, 2, 100)
        tdSql.checkData(5, 3, 25)
        tdSql.checkData(5, 4, 'nchar1.辽宁省飞县牧野张路c座 379691')

        tdSql.query('select upper(q_nchar1),upper(q_nchar2),length(q_nchar1),char_length(q_nchar1),lower(q_nchar1) from (select * from stable_1);')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR1.福建省宜都县海港王街M座 713195')
        tdSql.checkData(0, 1, 'NCHAR2.宁夏回族自治区兰州市淄川香港路Y座 213761')
        tdSql.checkData(0, 2, 104)
        tdSql.checkData(0, 3, 26)
        tdSql.checkData(0, 4, 'nchar1.福建省宜都县海港王街m座 713195')
        tdSql.checkData(1, 0, 'NCHAR1.天津市欣县上街李街N座 110533')
        tdSql.checkData(1, 1, 'NCHAR2.甘肃省利市房山姜路F座 539129')
        tdSql.checkData(1, 2, 100)
        tdSql.checkData(1, 3, 25)
        tdSql.checkData(1, 4, 'nchar1.天津市欣县上街李街n座 110533')
        tdSql.checkData(2, 0, 'NCHAR1.陕西省惠州县城东郑州街A座 702479')
        tdSql.checkData(2, 1, 'NCHAR2.上海市宁德市淄川周路N座 803882')
        tdSql.checkData(2, 2, 108)
        tdSql.checkData(2, 3, 27)
        tdSql.checkData(2, 4, 'nchar1.陕西省惠州县城东郑州街a座 702479')
        tdSql.checkData(3, 0, 'NCHAR1.北京市石家庄县高明太原街V座 139496')
        tdSql.checkData(3, 1, 'NCHAR2.江苏省合山县涪城重庆路Q座 428968')
        tdSql.checkData(3, 2, 112)
        tdSql.checkData(3, 3, 28)
        tdSql.checkData(3, 4, 'nchar1.北京市石家庄县高明太原街v座 139496')
        tdSql.checkData(4, 0, 'NCHAR1.北京市帅市长寿王街H座 105426')
        tdSql.checkData(4, 1, 'NCHAR2.澳门特别行政区金凤县海港荆门路X座 762691')
        tdSql.checkData(4, 2, 100)
        tdSql.checkData(4, 3, 25)
        tdSql.checkData(4, 4, 'nchar1.北京市帅市长寿王街h座 105426')
        tdSql.checkData(5, 0, 'NCHAR1.辽宁省飞县牧野张路C座 379691')
        tdSql.checkData(5, 1, 'NCHAR2.湖南省玉华市双滦王路Y座 106635')
        tdSql.checkData(5, 2, 100)
        tdSql.checkData(5, 3, 25)
        tdSql.checkData(5, 4, 'nchar1.辽宁省飞县牧野张路c座 379691')

        tdSql.query('select CONCAT_WS("abc, taos, , <, %, $, @, |",q_binary3, q_binary7, q_binary4, q_binary8, q_binary5, q_binary6, q_binary2, q_binary1) from stable_2;')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'binary3.xpmnymjjdbpefsJbXiaAabc, taos, , <, %, $, @, |binary7.GJEBncpKznEVYlBjADXcabc, taos, , <, %, $, @, |binary4.MQQAGeTBCbbAFmyCdNdxabc, taos, , <, %, $, @, |binary8.bseliCaYePtOlhjBDKlAabc, taos, , <, %, $, @, |binary5.jcGNOXcvsteCwnVwZxkvabc, taos, , <, %, $, @, |binary6.sFIopESAmZxNtpEAXvmhabc, taos, , <, %, $, @, |binary2.CCmnLmgCmPDGsacmypKrabc, taos, , <, %, $, @, |binary1.PZrbgCdVlhLuYWzJfpcQ')
        tdSql.checkData(1, 0, 'binary3.pAdZtAJFuMQGiLYWCFzpabc, taos, , <, %, $, @, |binary7.RunKOCOVDEkKXXLbQQwDabc, taos, , <, %, $, @, |binary4.bJvTLLaAsMVnxxKragLAabc, taos, , <, %, $, @, |binary8.YOTuRbbLIqBCEgLddPwIabc, taos, , <, %, $, @, |binary5.ITFlhuZlVWIBJqLhkOeyabc, taos, , <, %, $, @, |binary6.EZDRIMGNFYtddfbOlkvTabc, taos, , <, %, $, @, |binary2.iaKGuopmHqqbANMmhQaBabc, taos, , <, %, $, @, |binary1.QBTMVrRvMGcRSiUFpsnA')
        tdSql.checkData(2, 0, 'binary3.IAounswvgoPxMXtsqnwUabc, taos, , <, %, $, @, |binary7.aHloPsebqjkwcCRXAcGcabc, taos, , <, %, $, @, |binary4.wPwqkMLYqzkhmRHRpKAyabc, taos, , <, %, $, @, |binary8.xvNxozZWlsTvtweWXQrlabc, taos, , <, %, $, @, |binary5.iQoYVJdmAoSBlyGpJpXxabc, taos, , <, %, $, @, |binary6.MmjmFrioKDTFoegthaRDabc, taos, , <, %, $, @, |binary2.DGmDtcyaEObwuQVxDpUPabc, taos, , <, %, $, @, |binary1.MwStUNfrTBVbvhHjfNza')
        tdSql.checkData(3, 0, 'binary3.cykuADWPZFQANvsqhRKXabc, taos, , <, %, $, @, |binary7.EraykZvYQkepZTyCLhrXabc, taos, , <, %, $, @, |binary4.KJUftFRDQqQZOjPRbashabc, taos, , <, %, $, @, |binary8.qpqMrYpGgIWuzjCwqRtAabc, taos, , <, %, $, @, |binary5.mzizxALkpwFvhsDKDZLXabc, taos, , <, %, $, @, |binary6.COpyPYrULAJYVDcSidceabc, taos, , <, %, $, @, |binary2.UVZXgaXnvsOFMyfQtxlkabc, taos, , <, %, $, @, |binary1.OKSAdzYZtxmTYgUqDTUJ')
        tdSql.checkData(4, 0, 'binary3.pXNShlLsrfFhMkZVJmvJabc, taos, , <, %, $, @, |binary7.eZvrAHwgOSpNfkWOheQKabc, taos, , <, %, $, @, |binary4.ePZMxraOFLRUirwjYQgzabc, taos, , <, %, $, @, |binary8.mmASwYqspmYxzgEQMScDabc, taos, , <, %, $, @, |binary5.EnZjhIMsFGQHTNgGwlLYabc, taos, , <, %, $, @, |binary6.OwvaiZKpWMEuXNefCdSdabc, taos, , <, %, $, @, |binary2.mTeRDPIPKIqXXaCKxZZgabc, taos, , <, %, $, @, |binary1.bkypAUrybRZdjEAQpLaD')
        tdSql.checkData(5, 0, 'binary3.DuUfOKRvTmFXKPglEJLyabc, taos, , <, %, $, @, |binary7.djQZYSGDCbforCnoDkREabc, taos, , <, %, $, @, |binary4.XdprBDmPQensCLNylpfXabc, taos, , <, %, $, @, |binary8.QIuisWlGYavgxfQjfnAdabc, taos, , <, %, $, @, |binary5.trUYUEAEeXecKeYDqBGXabc, taos, , <, %, $, @, |binary6.gQwmTXQOFCblFwaBGoFGabc, taos, , <, %, $, @, |binary2.vdRFTigUtJQpwmklHmqsabc, taos, , <, %, $, @, |binary1.xWLSLgSXgNPMCtEqeIem')

        tdSql.query('select * from (select CONCAT_WS("abc, taos, , <, %, $, @, |",q_binary3, q_binary7, q_binary4, q_binary8, q_binary5, q_binary6, q_binary2, q_binary1) from stable_2 where q_double <= 1.7E308 and  q_int <= 2147483647 and  t_tinyint != 128 and  t_nchar is not null and  q_nchar match \'nchar\' and  (q_bool = true or  q_bool = false));')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'binary3.xpmnymjjdbpefsJbXiaAabc, taos, , <, %, $, @, |binary7.GJEBncpKznEVYlBjADXcabc, taos, , <, %, $, @, |binary4.MQQAGeTBCbbAFmyCdNdxabc, taos, , <, %, $, @, |binary8.bseliCaYePtOlhjBDKlAabc, taos, , <, %, $, @, |binary5.jcGNOXcvsteCwnVwZxkvabc, taos, , <, %, $, @, |binary6.sFIopESAmZxNtpEAXvmhabc, taos, , <, %, $, @, |binary2.CCmnLmgCmPDGsacmypKrabc, taos, , <, %, $, @, |binary1.PZrbgCdVlhLuYWzJfpcQ')
        tdSql.checkData(1, 0, 'binary3.pAdZtAJFuMQGiLYWCFzpabc, taos, , <, %, $, @, |binary7.RunKOCOVDEkKXXLbQQwDabc, taos, , <, %, $, @, |binary4.bJvTLLaAsMVnxxKragLAabc, taos, , <, %, $, @, |binary8.YOTuRbbLIqBCEgLddPwIabc, taos, , <, %, $, @, |binary5.ITFlhuZlVWIBJqLhkOeyabc, taos, , <, %, $, @, |binary6.EZDRIMGNFYtddfbOlkvTabc, taos, , <, %, $, @, |binary2.iaKGuopmHqqbANMmhQaBabc, taos, , <, %, $, @, |binary1.QBTMVrRvMGcRSiUFpsnA')
        tdSql.checkData(2, 0, 'binary3.IAounswvgoPxMXtsqnwUabc, taos, , <, %, $, @, |binary7.aHloPsebqjkwcCRXAcGcabc, taos, , <, %, $, @, |binary4.wPwqkMLYqzkhmRHRpKAyabc, taos, , <, %, $, @, |binary8.xvNxozZWlsTvtweWXQrlabc, taos, , <, %, $, @, |binary5.iQoYVJdmAoSBlyGpJpXxabc, taos, , <, %, $, @, |binary6.MmjmFrioKDTFoegthaRDabc, taos, , <, %, $, @, |binary2.DGmDtcyaEObwuQVxDpUPabc, taos, , <, %, $, @, |binary1.MwStUNfrTBVbvhHjfNza')
        tdSql.checkData(3, 0, 'binary3.cykuADWPZFQANvsqhRKXabc, taos, , <, %, $, @, |binary7.EraykZvYQkepZTyCLhrXabc, taos, , <, %, $, @, |binary4.KJUftFRDQqQZOjPRbashabc, taos, , <, %, $, @, |binary8.qpqMrYpGgIWuzjCwqRtAabc, taos, , <, %, $, @, |binary5.mzizxALkpwFvhsDKDZLXabc, taos, , <, %, $, @, |binary6.COpyPYrULAJYVDcSidceabc, taos, , <, %, $, @, |binary2.UVZXgaXnvsOFMyfQtxlkabc, taos, , <, %, $, @, |binary1.OKSAdzYZtxmTYgUqDTUJ')
        tdSql.checkData(4, 0, 'binary3.pXNShlLsrfFhMkZVJmvJabc, taos, , <, %, $, @, |binary7.eZvrAHwgOSpNfkWOheQKabc, taos, , <, %, $, @, |binary4.ePZMxraOFLRUirwjYQgzabc, taos, , <, %, $, @, |binary8.mmASwYqspmYxzgEQMScDabc, taos, , <, %, $, @, |binary5.EnZjhIMsFGQHTNgGwlLYabc, taos, , <, %, $, @, |binary6.OwvaiZKpWMEuXNefCdSdabc, taos, , <, %, $, @, |binary2.mTeRDPIPKIqXXaCKxZZgabc, taos, , <, %, $, @, |binary1.bkypAUrybRZdjEAQpLaD')
        tdSql.checkData(5, 0, 'binary3.DuUfOKRvTmFXKPglEJLyabc, taos, , <, %, $, @, |binary7.djQZYSGDCbforCnoDkREabc, taos, , <, %, $, @, |binary4.XdprBDmPQensCLNylpfXabc, taos, , <, %, $, @, |binary8.QIuisWlGYavgxfQjfnAdabc, taos, , <, %, $, @, |binary5.trUYUEAEeXecKeYDqBGXabc, taos, , <, %, $, @, |binary6.gQwmTXQOFCblFwaBGoFGabc, taos, , <, %, $, @, |binary2.vdRFTigUtJQpwmklHmqsabc, taos, , <, %, $, @, |binary1.xWLSLgSXgNPMCtEqeIem')

        tdSql.query('select CONCAT_WS("), <, ., ^, >, , |, /",q_nchar1, q_nchar6, q_nchar7, q_nchar, q_nchar5, q_nchar8, q_nchar4, q_nchar3) from stable_2;')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'nchar1.澳门特别行政区武汉市璧山孔路Y座 467679), <, ., ^, >, , |, /nchar6.上海市琳市萧山朴路I座 857895), <, ., ^, >, , |, /nchar7.内蒙古自治区永安县南湖王路m座 128263), <, ., ^, >, , |, /nchar.辽宁省小红县安次刘路I座 783067), <, ., ^, >, , |, /nchar5.青海省哈尔滨市蓟州雷路S座 774634), <, ., ^, >, , |, /nchar8.新疆维吾尔自治区畅市清浦惠州路Y座 221741), <, ., ^, >, , |, /nchar4.天津市哈尔滨县新城杨路w座 877346), <, ., ^, >, , |, /nchar3.宁夏回族自治区齐齐哈尔市长寿海门路s座 980357')
        tdSql.checkData(1, 0, 'nchar1.甘肃省佛山县大兴石家庄街y座 699134), <, ., ^, >, , |, /nchar6.四川省兴城市沙湾李街p座 370512), <, ., ^, >, , |, /nchar7.河北省兴安盟市萧山张路n座 447381), <, ., ^, >, , |, /nchar.浙江省呼和浩特市丰都田街T座 149274), <, ., ^, >, , |, /nchar5.陕西省桂芳县南湖北镇路s座 173929), <, ., ^, >, , |, /nchar8.北京市文县浔阳澳门路h座 816162), <, ., ^, >, , |, /nchar4.内蒙古自治区银川市萧山乌鲁木齐街p座 711931), <, ., ^, >, , |, /nchar3.天津市玲市梁平阜新路R座 699400')
        tdSql.checkData(2, 0, 'nchar1.河北省雪市魏都杜街i座 259384), <, ., ^, >, , |, /nchar6.澳门特别行政区楠市龙潭太原路f座 611785), <, ., ^, >, , |, /nchar7.北京市桂芝市高港许街N座 542112), <, ., ^, >, , |, /nchar.湖南省瑞县沙市王街c座 200752), <, ., ^, >, , |, /nchar5.浙江省建华市大兴永安街K座 644305), <, ., ^, >, , |, /nchar8.山东省北镇市静安巢湖路N座 751441), <, ., ^, >, , |, /nchar4.上海市通辽市浔阳北镇路H座 317911), <, ., ^, >, , |, /nchar3.甘肃省永安县南湖银川街C座 330264')
        tdSql.checkData(3, 0, 'nchar1.天津市西安市房山程路g座 201540), <, ., ^, >, , |, /nchar6.上海市桂英县沙湾魏街v座 727936), <, ., ^, >, , |, /nchar7.新疆维吾尔自治区婷市兴山齐齐哈尔街T座 467826), <, ., ^, >, , |, /nchar.湖南省桂香市合川武汉路e座 190074), <, ., ^, >, , |, /nchar5.上海市哈尔滨市长寿阎街d座 505069), <, ., ^, >, , |, /nchar8.辽宁省凤兰市魏都沈阳路D座 852593), <, ., ^, >, , |, /nchar4.辽宁省长沙县永川张路h座 794840), <, ., ^, >, , |, /nchar3.河北省刚市东城解路i座 865426')
        tdSql.checkData(4, 0, 'nchar1.香港特别行政区通辽市清城张家港街g座 456475), <, ., ^, >, , |, /nchar6.广西壮族自治区凯县高坪葛路i座 733075), <, ., ^, >, , |, /nchar7.云南省佳县大兴刘街b座 134332), <, ., ^, >, , |, /nchar.北京市乌鲁木齐县金平郑州街K座 565319), <, ., ^, >, , |, /nchar5.山东省天津市门头沟齐齐哈尔路H座 590367), <, ., ^, >, , |, /nchar8.福建省秀英市高明广州街S座 972859), <, ., ^, >, , |, /nchar4.甘肃省哈尔滨县南溪兴城路B座 464192), <, ., ^, >, , |, /nchar3.内蒙古自治区成市海港重庆街z座 935702')
        tdSql.checkData(5, 0, 'nchar1.山东省辽阳县锡山上海路R座 816023), <, ., ^, >, , |, /nchar6.澳门特别行政区秀珍市萧山长春路D座 398394), <, ., ^, >, , |, /nchar7.安徽省兴安盟市和平丰街o座 702930), <, ., ^, >, , |, /nchar.四川省潜江县蓟州陈街G座 347914), <, ., ^, >, , |, /nchar5.台湾省东市新城张路Q座 187531), <, ., ^, >, , |, /nchar8.黑龙江省海燕县闵行沈阳街S座 986676), <, ., ^, >, , |, /nchar4.青海省柳州县沈北新张家港街A座 207436), <, ., ^, >, , |, /nchar3.山西省秀荣市崇文嘉禾路b座 658257')

        tdSql.query('select CONCAT_WS("), <, ., ^, >, , |, /",q_nchar1, q_nchar6, q_nchar7, q_nchar, q_nchar5, q_nchar8, q_nchar4, q_nchar3) from stable_2 where  q_bigint is not null and  t_ts is not null and q_binary nmatch \'binarynchar\';')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'nchar1.澳门特别行政区武汉市璧山孔路Y座 467679), <, ., ^, >, , |, /nchar6.上海市琳市萧山朴路I座 857895), <, ., ^, >, , |, /nchar7.内蒙古自治区永安县南湖王路m座 128263), <, ., ^, >, , |, /nchar.辽宁省小红县安次刘路I座 783067), <, ., ^, >, , |, /nchar5.青海省哈尔滨市蓟州雷路S座 774634), <, ., ^, >, , |, /nchar8.新疆维吾尔自治区畅市清浦惠州路Y座 221741), <, ., ^, >, , |, /nchar4.天津市哈尔滨县新城杨路w座 877346), <, ., ^, >, , |, /nchar3.宁夏回族自治区齐齐哈尔市长寿海门路s座 980357')
        tdSql.checkData(1, 0, 'nchar1.甘肃省佛山县大兴石家庄街y座 699134), <, ., ^, >, , |, /nchar6.四川省兴城市沙湾李街p座 370512), <, ., ^, >, , |, /nchar7.河北省兴安盟市萧山张路n座 447381), <, ., ^, >, , |, /nchar.浙江省呼和浩特市丰都田街T座 149274), <, ., ^, >, , |, /nchar5.陕西省桂芳县南湖北镇路s座 173929), <, ., ^, >, , |, /nchar8.北京市文县浔阳澳门路h座 816162), <, ., ^, >, , |, /nchar4.内蒙古自治区银川市萧山乌鲁木齐街p座 711931), <, ., ^, >, , |, /nchar3.天津市玲市梁平阜新路R座 699400')
        tdSql.checkData(2, 0, 'nchar1.河北省雪市魏都杜街i座 259384), <, ., ^, >, , |, /nchar6.澳门特别行政区楠市龙潭太原路f座 611785), <, ., ^, >, , |, /nchar7.北京市桂芝市高港许街N座 542112), <, ., ^, >, , |, /nchar.湖南省瑞县沙市王街c座 200752), <, ., ^, >, , |, /nchar5.浙江省建华市大兴永安街K座 644305), <, ., ^, >, , |, /nchar8.山东省北镇市静安巢湖路N座 751441), <, ., ^, >, , |, /nchar4.上海市通辽市浔阳北镇路H座 317911), <, ., ^, >, , |, /nchar3.甘肃省永安县南湖银川街C座 330264')
        tdSql.checkData(3, 0, 'nchar1.天津市西安市房山程路g座 201540), <, ., ^, >, , |, /nchar6.上海市桂英县沙湾魏街v座 727936), <, ., ^, >, , |, /nchar7.新疆维吾尔自治区婷市兴山齐齐哈尔街T座 467826), <, ., ^, >, , |, /nchar.湖南省桂香市合川武汉路e座 190074), <, ., ^, >, , |, /nchar5.上海市哈尔滨市长寿阎街d座 505069), <, ., ^, >, , |, /nchar8.辽宁省凤兰市魏都沈阳路D座 852593), <, ., ^, >, , |, /nchar4.辽宁省长沙县永川张路h座 794840), <, ., ^, >, , |, /nchar3.河北省刚市东城解路i座 865426')
        tdSql.checkData(4, 0, 'nchar1.香港特别行政区通辽市清城张家港街g座 456475), <, ., ^, >, , |, /nchar6.广西壮族自治区凯县高坪葛路i座 733075), <, ., ^, >, , |, /nchar7.云南省佳县大兴刘街b座 134332), <, ., ^, >, , |, /nchar.北京市乌鲁木齐县金平郑州街K座 565319), <, ., ^, >, , |, /nchar5.山东省天津市门头沟齐齐哈尔路H座 590367), <, ., ^, >, , |, /nchar8.福建省秀英市高明广州街S座 972859), <, ., ^, >, , |, /nchar4.甘肃省哈尔滨县南溪兴城路B座 464192), <, ., ^, >, , |, /nchar3.内蒙古自治区成市海港重庆街z座 935702')
        tdSql.checkData(5, 0, 'nchar1.山东省辽阳县锡山上海路R座 816023), <, ., ^, >, , |, /nchar6.澳门特别行政区秀珍市萧山长春路D座 398394), <, ., ^, >, , |, /nchar7.安徽省兴安盟市和平丰街o座 702930), <, ., ^, >, , |, /nchar.四川省潜江县蓟州陈街G座 347914), <, ., ^, >, , |, /nchar5.台湾省东市新城张路Q座 187531), <, ., ^, >, , |, /nchar8.黑龙江省海燕县闵行沈阳街S座 986676), <, ., ^, >, , |, /nchar4.青海省柳州县沈北新张家港街A座 207436), <, ., ^, >, , |, /nchar3.山西省秀荣市崇文嘉禾路b座 658257')

        tdSql.query('select CONCAT_WS("$, , ~",q_nchar7, q_nchar5, q_nchar8) from stable_1;')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'nchar7.湖北省桂芳市高明邯郸路q座 413345$, , ~nchar5.贵州省大冶县滨城梧州街P座 554324$, , ~nchar8.内蒙古自治区太原县萧山王路p座 322176')
        tdSql.checkData(1, 0, 'nchar7.云南省凯市淄川柳州路g座 551620$, , ~nchar5.陕西省金凤市静安邵街s座 349352$, , ~nchar8.山西省洋县吉区袁街k座 383085')
        tdSql.checkData(2, 0, 'nchar7.江西省玉英市海港澳门路q座 945219$, , ~nchar5.北京市桂香市城东淮安街K座 265859$, , ~nchar8.香港特别行政区太原市黄浦黄街P座 177199')
        tdSql.checkData(3, 0, 'nchar7.河北省西安市浔阳通辽街w座 546863$, , ~nchar5.重庆市兰英县沙湾嘉禾街c座 775060$, , ~nchar8.宁夏回族自治区文市朝阳昆明街O座 933200')
        tdSql.checkData(4, 0, 'nchar7.上海市淑华市安次杨街s座 495789$, , ~nchar5.河南省凤兰市大兴兴城路n座 845990$, , ~nchar8.陕西省军县丰都王街T座 625091')
        tdSql.checkData(5, 0, 'nchar7.新疆维吾尔自治区文市海陵刘街U座 979746$, , ~nchar5.新疆维吾尔自治区秀芳市怀柔巢湖路h座 193210$, , ~nchar8.广西壮族自治区辽阳市城北李街c座 242662')

        tdSql.query('select CONCAT_WS("taos, _, +",q_binary2, q_binary5, q_binary4) from (select * from stable_1) where q_nchar is not null;')
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'binary2.tsCyNVyBJDCnIvUdjVevtaos, _, +binary5.BUEJHkTvXfstJGArxcBztaos, _, +binary4.NdciuKObKZYwDVhtIOgB')
        tdSql.checkData(1, 0, 'binary2.CWBcufneMDLIfNmMyDQDtaos, _, +binary5.YxaTiRVvJItsdEsMogErtaos, _, +binary4.iXwEQVdoHPejKHgtUcnp')
        tdSql.checkData(2, 0, 'binary2.FeyVxiUQWvaCkYlzlfeGtaos, _, +binary5.CCRGhhIjzzUEyhmxALRLtaos, _, +binary4.xqFUKKJYHIpPlfyNuhFF')
        tdSql.checkData(3, 0, 'binary2.CgjLFXASsqDMbqpClkyotaos, _, +binary5.OrEfrEsydYTamaZkNkwktaos, _, +binary4.zyKhpKkjeZokFeegJQDi')
        tdSql.checkData(4, 0, 'binary2.XWXOVmhROrAgBbsXANmCtaos, _, +binary5.dDdPBqkpKquoRoacZZdataos, _, +binary4.rRYTZlEWfyBoprvSjmrU')
        tdSql.checkData(5, 0, 'binary2.NKVuIxfhKuRiIGxqAQEhtaos, _, +binary5.DHSVcnCnLheJAOYMLLBJtaos, _, +binary4.oYHgrkuMqsznJYiuMOGG')

        tdSql.query("select UPPER(q_nchar),UPPER(q_nchar),LOWER(q_nchar),length(q_nchar),char_length(q_nchar) from stable_2 where tbname in ('stable_2_1') and q_tinyint <= 127 and  t_smallint is not null and  (q_binary like 'binary%'  or q_nchar = '0'  or q_binary = 'binary_' ) and t_bool in (0 , 1) ;")
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(0, 1, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(0, 2, 'nchar.辽宁省小红县安次刘路i座 783067')
        tdSql.checkData(0, 3, 100)
        tdSql.checkData(0, 4, 25)
        tdSql.checkData(1, 0, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(1, 1, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(1, 2, 'nchar.浙江省呼和浩特市丰都田街t座 149274')
        tdSql.checkData(1, 3, 108)
        tdSql.checkData(1, 4, 27)
        tdSql.checkData(2, 0, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(2, 1, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(2, 2, 'nchar.湖南省瑞县沙市王街c座 200752')
        tdSql.checkData(2, 3, 96)
        tdSql.checkData(2, 4, 24)
        tdSql.checkData(3, 0, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(3, 1, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(3, 2, 'nchar.湖南省桂香市合川武汉路e座 190074')
        tdSql.checkData(3, 3, 104)
        tdSql.checkData(3, 4, 26)
        tdSql.checkData(4, 0, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(4, 1, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(4, 2, 'nchar.北京市乌鲁木齐县金平郑州街k座 565319')
        tdSql.checkData(4, 3, 112)
        tdSql.checkData(4, 4, 28)
        tdSql.checkData(5, 0, 'NCHAR.四川省潜江县蓟州陈街G座 347914')
        tdSql.checkData(5, 1, 'NCHAR.四川省潜江县蓟州陈街G座 347914')
        tdSql.checkData(5, 2, 'nchar.四川省潜江县蓟州陈街g座 347914')
        tdSql.checkData(5, 3, 100)
        tdSql.checkData(5, 4, 25)

        tdSql.query("select UPPER(q_nchar),UPPER(q_nchar),LOWER(q_nchar),length(q_nchar),char_length(q_nchar) from stable_2 where tbname in ('stable_2_1');")
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(0, 1, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(0, 2, 'nchar.辽宁省小红县安次刘路i座 783067')
        tdSql.checkData(0, 3, 100)
        tdSql.checkData(0, 4, 25)
        tdSql.checkData(1, 0, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(1, 1, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(1, 2, 'nchar.浙江省呼和浩特市丰都田街t座 149274')
        tdSql.checkData(1, 3, 108)
        tdSql.checkData(1, 4, 27)
        tdSql.checkData(2, 0, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(2, 1, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(2, 2, 'nchar.湖南省瑞县沙市王街c座 200752')
        tdSql.checkData(2, 3, 96)
        tdSql.checkData(2, 4, 24)
        tdSql.checkData(3, 0, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(3, 1, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(3, 2, 'nchar.湖南省桂香市合川武汉路e座 190074')
        tdSql.checkData(3, 3, 104)
        tdSql.checkData(3, 4, 26)
        tdSql.checkData(4, 0, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(4, 1, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(4, 2, 'nchar.北京市乌鲁木齐县金平郑州街k座 565319')
        tdSql.checkData(4, 3, 112)
        tdSql.checkData(4, 4, 28)
        tdSql.checkData(5, 0, 'NCHAR.四川省潜江县蓟州陈街G座 347914')
        tdSql.checkData(5, 1, 'NCHAR.四川省潜江县蓟州陈街G座 347914')
        tdSql.checkData(5, 2, 'nchar.四川省潜江县蓟州陈街g座 347914')
        tdSql.checkData(5, 3, 100)
        tdSql.checkData(5, 4, 25)

        tdSql.query("select * from (select UPPER(q_nchar),UPPER(q_nchar),LOWER(q_nchar),length(q_nchar),char_length(q_nchar) from stable_2 where tbname in ('stable_2_1') and q_tinyint <= 127 and  q_tinyint between -127 and 127  and  (q_binary like 'binary%'  or q_nchar = '0'  or q_binary = 'binary_' ) and t_bool in (0 , 1)  );")
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(0, 1, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(0, 2, 'nchar.辽宁省小红县安次刘路i座 783067')
        tdSql.checkData(0, 3, 100)
        tdSql.checkData(0, 4, 25)
        tdSql.checkData(1, 0, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(1, 1, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(1, 2, 'nchar.浙江省呼和浩特市丰都田街t座 149274')
        tdSql.checkData(1, 3, 108)
        tdSql.checkData(1, 4, 27)
        tdSql.checkData(2, 0, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(2, 1, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(2, 2, 'nchar.湖南省瑞县沙市王街c座 200752')
        tdSql.checkData(2, 3, 96)
        tdSql.checkData(2, 4, 24)
        tdSql.checkData(3, 0, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(3, 1, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(3, 2, 'nchar.湖南省桂香市合川武汉路e座 190074')
        tdSql.checkData(3, 3, 104)
        tdSql.checkData(3, 4, 26)
        tdSql.checkData(4, 0, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(4, 1, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(4, 2, 'nchar.北京市乌鲁木齐县金平郑州街k座 565319')
        tdSql.checkData(4, 3, 112)
        tdSql.checkData(4, 4, 28)
        tdSql.checkData(5, 0, 'NCHAR.四川省潜江县蓟州陈街G座 347914')
        tdSql.checkData(5, 1, 'NCHAR.四川省潜江县蓟州陈街G座 347914')
        tdSql.checkData(5, 2, 'nchar.四川省潜江县蓟州陈街g座 347914')
        tdSql.checkData(5, 3, 100)
        tdSql.checkData(5, 4, 25)

        tdSql.query("select UPPER(q_nchar),LOWER(q_nchar),length(q_nchar),char_length(q_nchar) from stable_2 where tbname in ('stable_2_1');")
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(0, 1, 'nchar.辽宁省小红县安次刘路i座 783067')
        tdSql.checkData(0, 2, 100)
        tdSql.checkData(0, 3, 25)
        tdSql.checkData(1, 0, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(1, 1, 'nchar.浙江省呼和浩特市丰都田街t座 149274')
        tdSql.checkData(1, 2, 108)
        tdSql.checkData(1, 3, 27)
        tdSql.checkData(2, 0, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(2, 1, 'nchar.湖南省瑞县沙市王街c座 200752')
        tdSql.checkData(2, 2, 96)
        tdSql.checkData(2, 3, 24)
        tdSql.checkData(3, 0, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(3, 1, 'nchar.湖南省桂香市合川武汉路e座 190074')
        tdSql.checkData(3, 2, 104)
        tdSql.checkData(3, 3, 26)
        tdSql.checkData(4, 0, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(4, 1, 'nchar.北京市乌鲁木齐县金平郑州街k座 565319')
        tdSql.checkData(4, 2, 112)
        tdSql.checkData(4, 3, 28)
        tdSql.checkData(5, 0, 'NCHAR.四川省潜江县蓟州陈街G座 347914')
        tdSql.checkData(5, 1, 'nchar.四川省潜江县蓟州陈街g座 347914')
        tdSql.checkData(5, 2, 100)
        tdSql.checkData(5, 3, 25)

        tdSql.query("select UPPER(q_nchar) from stable_2 where tbname in ('stable_2_1') and q_tinyint <= 127 and  q_tinyint between -127 and 127  and  (q_binary like 'binary%'  or q_nchar = '0'  or q_binary = 'binary_' ) and t_bool in (0 , 1) ;")
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'NCHAR.辽宁省小红县安次刘路I座 783067')
        tdSql.checkData(1, 0, 'NCHAR.浙江省呼和浩特市丰都田街T座 149274')
        tdSql.checkData(2, 0, 'NCHAR.湖南省瑞县沙市王街C座 200752')
        tdSql.checkData(3, 0, 'NCHAR.湖南省桂香市合川武汉路E座 190074')
        tdSql.checkData(4, 0, 'NCHAR.北京市乌鲁木齐县金平郑州街K座 565319')
        tdSql.checkData(5, 0, 'NCHAR.四川省潜江县蓟州陈街G座 347914')

        tdSql.query("select * from (select UPPER(q_binary),LOWER(q_binary),CONCAT(q_binary,q_binary) from stable_2 where tbname in ('stable_2_1') and  q_int is not null and  t_smallint >= -32767 and  q_binary nmatch 'binarynchar' and  (t_bool = true or  t_bool = false) order by ts desc);")
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, 'BINARY.ZETYSWJUDIKUGNDNHDDG')
        tdSql.checkData(0, 1, 'binary.zetyswjudikugndnhddg')
        tdSql.checkData(0, 2, 'binary.ZeTYsWJUdikuGndNhdDgbinary.ZeTYsWJUdikuGndNhdDg')
        tdSql.checkData(1, 0, 'BINARY.SUSMJVNRTYRGADKOFSRP')
        tdSql.checkData(1, 1, 'binary.susmjvnrtyrgadkofsrp')
        tdSql.checkData(1, 2, 'binary.sUSMJvnrtyRGAdkofSRpbinary.sUSMJvnrtyRGAdkofSRp')
        tdSql.checkData(2, 0, 'BINARY.MZEFOJUVAPGCOZRBPWSA')
        tdSql.checkData(2, 1, 'binary.mzefojuvapgcozrbpwsa')
        tdSql.checkData(2, 2, 'binary.mzefOJuVapGcOZRBPWSAbinary.mzefOJuVapGcOZRBPWSA')
        tdSql.checkData(3, 0, 'BINARY.AQHUFBVMUNQFYSSMKMDT')
        tdSql.checkData(3, 1, 'binary.aqhufbvmunqfyssmkmdt')
        tdSql.checkData(3, 2, 'binary.aqhUfBvmuNqFySsMkMdtbinary.aqhUfBvmuNqFySsMkMdt')
        tdSql.checkData(4, 0, 'BINARY.RENSISLQMQQRNTVDSVUC')
        tdSql.checkData(4, 1, 'binary.rensislqmqqrntvdsvuc')
        tdSql.checkData(4, 2, 'binary.REnSISlqmqqrnTVDsVucbinary.REnSISlqmqqrnTVDsVuc')
        tdSql.checkData(5, 0, 'BINARY.RICJHNDLJVZXCUIUCTWP')
        tdSql.checkData(5, 1, 'binary.ricjhndljvzxcuiuctwp')
        tdSql.checkData(5, 2, 'binary.RicjHNdlJvZXcuIUCtwpbinary.RicjHNdlJvZXcuIUCtwp')

        tdSql.query("select * from (select ts, UPPER(q_binary), LOWER(q_binary) from stable_2 where tbname in ('stable_2_1') and  q_int is not null and  t_smallint >= -32767 and  q_binary nmatch 'binarynchar' and  (t_bool = true or  t_bool = false)) order by ts desc;")
        tdSql.checkRows(6)
        tdSql.checkData(0, 0, datetime.datetime(2021, 8, 27, 1, 46, 41, 10000))
        tdSql.checkData(0, 1, 'BINARY.ZETYSWJUDIKUGNDNHDDG')
        tdSql.checkData(0, 2, 'binary.zetyswjudikugndnhddg')
        tdSql.checkData(1, 0, datetime.datetime(2021, 8, 27, 1, 46, 41, 1000))
        tdSql.checkData(1, 1, 'BINARY.SUSMJVNRTYRGADKOFSRP')
        tdSql.checkData(1, 2, 'binary.susmjvnrtyrgadkofsrp')
        tdSql.checkData(2, 0, datetime.datetime(2021, 8, 27, 1, 46, 41))
        tdSql.checkData(2, 1, 'BINARY.MZEFOJUVAPGCOZRBPWSA')
        tdSql.checkData(2, 2, 'binary.mzefojuvapgcozrbpwsa')
        tdSql.checkData(3, 0, datetime.datetime(2021, 8, 27, 1, 46, 40, 10000))
        tdSql.checkData(3, 1, 'BINARY.AQHUFBVMUNQFYSSMKMDT')
        tdSql.checkData(3, 2, 'binary.aqhufbvmunqfyssmkmdt')
        tdSql.checkData(4, 0, datetime.datetime(2021, 8, 27, 1, 46, 40, 1000))
        tdSql.checkData(4, 1, 'BINARY.RENSISLQMQQRNTVDSVUC')
        tdSql.checkData(4, 2, 'binary.rensislqmqqrntvdsvuc')
        tdSql.checkData(5, 0, datetime.datetime(2021, 8, 27, 1, 46, 40))
        tdSql.checkData(5, 1, 'BINARY.RICJHNDLJVZXCUIUCTWP')
        tdSql.checkData(5, 2, 'binary.ricjhndljvzxcuiuctwp')

        tdSql.execute('drop database nchardb')
    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)

tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
