/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "os.h"
#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 346
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy145;
  EOrder yy250;
  EOperatorType yy348;
  int32_t yy376;
  SDataType yy380;
  SNode* yy456;
  SToken yy517;
  EFillMode yy534;
  ENullOrder yy645;
  SNodeList* yy652;
  bool yy673;
  EJoinType yy684;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             574
#define YYNRULE              441
#define YYNTOKEN             231
#define YY_MAX_SHIFT         573
#define YY_MIN_SHIFTREDUCE   855
#define YY_MAX_SHIFTREDUCE   1295
#define YY_ERROR_ACTION      1296
#define YY_ACCEPT_ACTION     1297
#define YY_NO_ACTION         1298
#define YY_MIN_REDUCE        1299
#define YY_MAX_REDUCE        1739
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1906)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   487, 1718, 1590, 1502,  273,  474,  322,  290,  285,   78,
 /*    10 */   146, 1514,   33,   31, 1717, 1410,  386,  407, 1715,  487,
 /*    20 */   282, 1576, 1115, 1470, 1576, 1421, 1606,  125,   78,  272,
 /*    30 */   447, 1378,  415,  450, 1468,  393, 1572, 1578, 1113, 1572,
 /*    40 */  1578,   26,  205,  470, 1421, 1718,  174, 1562, 1576,  410,
 /*    50 */    12,   33,   31, 1237,  404,  105,  486, 1121,  137,  282,
 /*    60 */   173, 1115, 1715, 1572, 1579,   54,   74, 1591,  473, 1593,
 /*    70 */  1594,  469,  486,  464,   59,    1, 1656, 1113,  100,  487,
 /*    80 */   275, 1652,  132,   30,   29,   28, 1416,   45,  326,   12,
 /*    90 */    44,   54,  103,  486,  201,  293, 1121,  286,  570, 1348,
 /*   100 */   430, 1683, 1505, 1507, 1421,  122,  449,  133, 1663, 1664,
 /*   110 */  1114, 1668, 1417, 1423,    1, 1300,  983,  510,  509,  508,
 /*   120 */   987,  507,  989,  990,  506,  992,  503,   36,  998,  500,
 /*   130 */  1000, 1001,  497,  494,    9,    8,   89,  570, 1136,   88,
 /*   140 */    87,   86,   85,   84,   83,   82,   81,   80,   36, 1114,
 /*   150 */  1116,  546,  545,  544,  543,  297,  365,  542,  541,  540,
 /*   160 */   108,  535,  534,  533,  532,  531,  530,  529,  528,  115,
 /*   170 */   524, 1119, 1120,   63, 1164, 1165, 1166, 1167, 1168, 1169,
 /*   180 */  1170,  466, 1175, 1176, 1177, 1178, 1179, 1180, 1181, 1116,
 /*   190 */   891, 1606,  292,  402, 1414,  396,  416, 1297,  471,  401,
 /*   200 */   122,  138,  102, 1140,  397,  395,  384,  398, 1423, 1213,
 /*   210 */  1119, 1120,  394, 1164, 1165, 1166, 1167, 1168, 1169, 1170,
 /*   220 */   466, 1175, 1176, 1177, 1178, 1179, 1180, 1181,   33,   31,
 /*   230 */   101, 1590,  414,  440,  389, 1718,  282,  250, 1115, 1136,
 /*   240 */    34,   32,   30,   29,   28,  412,  344, 1718,  137,  356,
 /*   250 */  1670,  298, 1715,  138, 1113, 1606, 1299,  392,  357, 1470,
 /*   260 */  1716,  321,  471,  320, 1715,  287,   12,   33,   31,  487,
 /*   270 */  1468,  138,  470, 1121, 1667,  282, 1562, 1115,  327,  138,
 /*   280 */    98,   97,   96,   95,   94,   93,   92,   91,   90, 1412,
 /*   290 */  1718,    1, 1138, 1113, 1421,   74, 1591,  473, 1593, 1594,
 /*   300 */   469,  328,  464,  137, 1251, 1656,  128, 1715,   69,  275,
 /*   310 */  1652, 1730, 1121,  138,  570, 1261, 1470, 1462,   65,  138,
 /*   320 */  1690, 1077,  294,  200,   56,  270, 1114, 1468,  175, 1079,
 /*   330 */     7,  251,  355,  264, 1562,  350,  349,  348,  347,  346,
 /*   340 */     6,  343,  342,  341,  340,  339,  335,  334,  333,  332,
 /*   350 */   331,  330,  329,  570,  434, 1259, 1260, 1262, 1263,  101,
 /*   360 */   892,  441,  891,  389,   89, 1114, 1116,   88,   87,   86,
 /*   370 */    85,   84,   83,   82,   81,   80,  265, 1322,  263,  262,
 /*   380 */   893,  388,  437,  124,   48, 1311,  392, 1119, 1120, 1078,
 /*   390 */  1164, 1165, 1166, 1167, 1168, 1169, 1170,  466, 1175, 1176,
 /*   400 */  1177, 1178, 1179, 1180, 1181, 1116, 1398,   22,  295,   34,
 /*   410 */    32,   30,   29,   28, 1351,  523,  122,   34,   32,   30,
 /*   420 */    29,   28, 1562, 1141, 1423,  228, 1119, 1120, 1451, 1164,
 /*   430 */  1165, 1166, 1167, 1168, 1169, 1170,  466, 1175, 1176, 1177,
 /*   440 */  1178, 1179, 1180, 1181,   33,   31, 1182,  254,   24, 1201,
 /*   450 */   442,  438,  282,  424, 1115, 1590,  138,  945,   34,   32,
 /*   460 */    30,   29,   28,  566,  565,  487,  402,  107,  396, 1206,
 /*   470 */  1113,  518,  401, 1151,  336,  102,  947,  397,  395, 1606,
 /*   480 */   398, 1199,  313,   33,   31,  394,  471,  391,  390, 1121,
 /*   490 */  1421,  282, 1139, 1115,  521, 1321,  470, 1232,  425,  474,
 /*   500 */  1562,  315,  487, 1320,   23, 1515,  451,    7, 1590, 1113,
 /*   510 */  1137,  337, 1319,  517,  516,  515,  487,  514, 1318,   73,
 /*   520 */  1591,  473, 1593, 1594,  469,  364,  464, 1421, 1121, 1656,
 /*   530 */   570, 1200, 1606,  253, 1652,  487,  351, 1718,   70,  471,
 /*   540 */  1562, 1421, 1114,  186, 1418, 1718,    7,  122, 1562,  470,
 /*   550 */   137, 1205,  106, 1562, 1715, 1424,  431, 1562,  137, 1413,
 /*   560 */  1421,  513, 1715, 1562,   34,   32,   30,   29,   28,  570,
 /*   570 */   144,  487,  249, 1591,  473, 1593, 1594,  469, 1317,  464,
 /*   580 */  1543, 1114, 1116,  148,  147, 1316,   25,  280, 1194, 1195,
 /*   590 */  1196, 1197, 1198, 1202, 1203, 1204, 1421,   52,  453, 1315,
 /*   600 */    51,  400,  399, 1119, 1120,  526, 1164, 1165, 1166, 1167,
 /*   610 */  1168, 1169, 1170,  466, 1175, 1176, 1177, 1178, 1179, 1180,
 /*   620 */  1181, 1116, 1314, 1562, 1313,   34,   32,   30,   29,   28,
 /*   630 */  1562,  457, 1310,   34,   32,   30,   29,   28, 1399,  520,
 /*   640 */   519, 1236, 1119, 1120, 1562, 1164, 1165, 1166, 1167, 1168,
 /*   650 */  1169, 1170,  466, 1175, 1176, 1177, 1178, 1179, 1180, 1181,
 /*   660 */    33,   31, 1309,  254, 1670, 1590, 1670, 1562,  282, 1562,
 /*   670 */  1115,   34,   32,   30,   29,   28,  447, 1562,   34,   32,
 /*   680 */    30,   29,   28,  289,  288, 1406, 1113,  365, 1666, 1606,
 /*   690 */  1665, 1397, 1583, 1129,  487, 1292,  450, 1199,  527,  487,
 /*   700 */  1393,  105,  487,  484, 1581, 1121,  470, 1562,  485, 1122,
 /*   710 */  1562,  219,  539,  537, 1506, 1507,  487, 1408, 1590, 1421,
 /*   720 */  1308,  451, 1404,    1, 1421,  296, 1307, 1421, 1121,   74,
 /*   730 */  1591,  473, 1593, 1594,  469, 1151,  464,  178,  103, 1656,
 /*   740 */   523, 1421, 1606,  275, 1652,  132,  570, 1200, 1306,  471,
 /*   750 */  1305, 1101, 1102,  198, 1663,  446, 1304,  445, 1114,  470,
 /*   760 */  1718,  121,  538, 1562, 1684, 1562,  316, 1205, 1303,  488,
 /*   770 */  1302, 1562, 1244,  137, 1291, 1675, 1232, 1715, 1138, 1470,
 /*   780 */   458, 1125,   75, 1591,  473, 1593, 1594,  469, 1187,  464,
 /*   790 */  1469,  454, 1656, 1562, 1138, 1562, 1655, 1652, 1116,    9,
 /*   800 */     8, 1562,   25,  280, 1194, 1195, 1196, 1197, 1198, 1202,
 /*   810 */  1203, 1204,  465, 1562, 1551, 1562, 1590,   40,  252, 1119,
 /*   820 */  1120, 1130, 1164, 1165, 1166, 1167, 1168, 1169, 1170,  466,
 /*   830 */  1175, 1176, 1177, 1178, 1179, 1180, 1181, 1396,  123, 1235,
 /*   840 */  1606,  166, 1133,  234,  164, 1338,  168,  471, 1590,  167,
 /*   850 */   305,  170, 1333, 1115,  169,  232,  172,  470,  113,  171,
 /*   860 */    47, 1562,  426,  512, 1258, 1294, 1295,  403,  149, 1113,
 /*   870 */  1331,  189, 1606,   35,  405,  191,  461, 1207, 1312,  471,
 /*   880 */    74, 1591,  473, 1593, 1594,  469,  423,  464, 1121,  470,
 /*   890 */  1656, 1379,  408, 1562,  275, 1652, 1730,   35,  107,   35,
 /*   900 */   208, 1171,  518, 1072,  210, 1713,  110,  111,  202,  435,
 /*   910 */   479,  216,   74, 1591,  473, 1593, 1594,  469, 1463,  464,
 /*   920 */   113, 1124, 1656, 1123,  976,  521,  275, 1652, 1730,  570,
 /*   930 */   195,   47,   72,  417,  383,  971,  917, 1674,  455,  492,
 /*   940 */   448, 1114, 1686, 1004,  517,  516,  515,  111,  514,  112,
 /*   950 */   447, 1008,  113, 1015,  111,  918, 1014, 1607,  114,    2,
 /*   960 */   204, 1136,  300,   50,   49,  325,  304,  143, 1590,  259,
 /*   970 */   945,  261,  319,  224,  145,  105,  338, 1590, 1085, 1504,
 /*   980 */   345, 1116,  352,  353,  260,  354,  311,  358,  307,  303,
 /*   990 */   140, 1145, 1606, 1127,  359, 1126,  150, 1191,  360,  471,
 /*  1000 */  1144, 1606, 1119, 1120,  361,  153,  362, 1143,  471,  470,
 /*  1010 */   156,  363,  103, 1562, 1142,   53,  366,  159,  470,  451,
 /*  1020 */   385,  138, 1562,  387, 1411,   79,  269,  134, 1663, 1664,
 /*  1030 */  1121, 1668,  241, 1591,  473, 1593, 1594,  469, 1590,  464,
 /*  1040 */   163,   75, 1591,  473, 1593, 1594,  469, 1407,  464,  165,
 /*  1050 */   116, 1656,  117, 1409, 1405,  460, 1652, 1547, 1718,  573,
 /*  1060 */   118,  119, 1606,  428,  447,  418, 1141, 1687,  176,  468,
 /*  1070 */   225,  137,  419,  223,  427, 1715,   99,  179,  181,  470,
 /*  1080 */   422,  184,  562, 1562,  558,  554,  550,  222,  436,  105,
 /*  1090 */   226, 1697, 1590,  187,  477,  433,  444,  190, 1696,  194,
 /*  1100 */   274,  439,  248, 1591,  473, 1593, 1594,  469,  467,  464,
 /*  1110 */   462, 1628,    5,  432,   71,    4, 1606,  217, 1232,  104,
 /*  1120 */  1140,  130,   37,  471, 1590,  197,  103,  196, 1677, 1671,
 /*  1130 */   276,  459,  456,  470,   16, 1513,  475, 1562,  481,  476,
 /*  1140 */  1590,  135, 1663, 1664, 1512, 1668,  480,  483, 1606,  212,
 /*  1150 */   203, 1733, 1714,  284, 1637,  471,  126, 1591,  473, 1593,
 /*  1160 */  1594,  469,  214,  464, 1606,  470,   62,  482, 1422, 1562,
 /*  1170 */   227,  471,   64, 1394,  490,  229,  429,  221,  569,  182,
 /*  1180 */    43,  470,  233,  129,  271, 1562,  235,  231,  244, 1591,
 /*  1190 */   473, 1593, 1594,  469, 1556,  464, 1093,  236,  177, 1590,
 /*  1200 */   452, 1731, 1555,  299,   75, 1591,  473, 1593, 1594,  469,
 /*  1210 */   301,  464, 1590, 1552, 1656,  302, 1109, 1110,  141, 1653,
 /*  1220 */   306, 1550,  308, 1606,  309,  310,  443, 1549,  312, 1548,
 /*  1230 */   471,  314, 1533,  142,  317,  318, 1606, 1088, 1087, 1527,
 /*  1240 */   470, 1526,  323,  471, 1562,  324, 1525, 1524, 1055, 1497,
 /*  1250 */  1496, 1495, 1494,  470, 1493, 1492, 1491, 1562,  109, 1480,
 /*  1260 */   279, 1490, 1489,  126, 1591,  473, 1593, 1594,  469, 1590,
 /*  1270 */   464,  155, 1400,  910, 1349, 1057,  249, 1591,  473, 1593,
 /*  1280 */  1594,  469, 1488,  464, 1487, 1486, 1485, 1484, 1483, 1482,
 /*  1290 */  1481, 1479, 1478, 1606, 1477, 1476, 1475, 1474, 1473, 1472,
 /*  1300 */   468, 1471, 1350, 1541, 1535, 1519, 1510, 1347, 1732,  369,
 /*  1310 */   470,  367,  368, 1345, 1562,  371,  372, 1590,  373, 1343,
 /*  1320 */  1341,  375,  377, 1330,  381, 1329, 1326, 1402,   77,  376,
 /*  1330 */   162, 1401,  536,  248, 1591,  473, 1593, 1594,  469,  538,
 /*  1340 */   464, 1606, 1629, 1020,  380, 1339, 1590,  379,  471, 1023,
 /*  1350 */   944,  266,  943,  942,  941,  940,  937, 1334,  470,  267,
 /*  1360 */   936, 1332, 1562,  406,  268,  281,  409, 1325,  411, 1324,
 /*  1370 */  1606,  413,   76, 1540,   46, 1534, 1095,  471,  120,  180,
 /*  1380 */   420,  249, 1591,  473, 1593, 1594,  469,  470,  464, 1518,
 /*  1390 */  1517, 1562,  161,  183,  283,  131, 1590,  421, 1509,  185,
 /*  1400 */    13,  382,    3,  378,  374,  370,  160,   57,   35,  188,
 /*  1410 */   249, 1591,  473, 1593, 1594,  469,   41,  464,   38,   14,
 /*  1420 */  1606,   11, 1581, 1257, 1250, 1280,  127,  471,  192,   20,
 /*  1430 */    58,    8,  193,   55,   21, 1590,  158,  470,   39, 1229,
 /*  1440 */  1228, 1562, 1279,  199, 1590,  277, 1285, 1284,   15, 1283,
 /*  1450 */   278,   17,  136, 1174, 1173,  463,   27, 1159,  139, 1606,
 /*  1460 */   237, 1591,  473, 1593, 1594,  469,  471,  464, 1606, 1508,
 /*  1470 */  1172, 1192,   10,  206,   18,  471,  470,   19,  478,  207,
 /*  1480 */  1562, 1255,  213,  472, 1131,  470,   65, 1580,  209, 1562,
 /*  1490 */   211,   60, 1590,   61,  157,  218,  152,   42,  154,  243,
 /*  1500 */  1591,  473, 1593, 1594,  469, 1590,  464,  215,  245, 1591,
 /*  1510 */   473, 1593, 1594,  469,  489,  464, 1606,  151,  491, 1005,
 /*  1520 */   291,  493,  495,  471, 1002,  496,  498,  999,  499, 1606,
 /*  1530 */   993,  501,  502,  470,  991,  504,  471, 1562,  505,  982,
 /*  1540 */   997,  996,   66,  511,  995,  994,  470, 1017, 1016,   67,
 /*  1550 */  1562,   68, 1013, 1010,  908,  522,  238, 1591,  473, 1593,
 /*  1560 */  1594,  469,  933,  464,  951,  525,  220,  931, 1590,  246,
 /*  1570 */  1591,  473, 1593, 1594,  469,  930,  464, 1590,  929,  928,
 /*  1580 */   927,  926,  925,  924,  948,  946,  921,  920,  919, 1346,
 /*  1590 */   916,  915, 1606,  914,  913,  547,  548,  549, 1344,  471,
 /*  1600 */   551, 1606,  552, 1342,  556,  555,  553,  557,  471,  470,
 /*  1610 */  1340,  559,  560, 1562,  561, 1328, 1590,  563,  470,  564,
 /*  1620 */  1327, 1323, 1562,  567, 1117,  568,  571, 1590,  230,  572,
 /*  1630 */  1298, 1298,  239, 1591,  473, 1593, 1594,  469, 1298,  464,
 /*  1640 */  1606,  247, 1591,  473, 1593, 1594,  469,  471,  464, 1298,
 /*  1650 */  1298, 1606, 1298, 1298, 1298, 1298, 1298,  470,  471, 1298,
 /*  1660 */  1298, 1562, 1298, 1298, 1298, 1298, 1298, 1298,  470, 1298,
 /*  1670 */  1298, 1298, 1562, 1298, 1298, 1298, 1590, 1298, 1298, 1298,
 /*  1680 */   240, 1591,  473, 1593, 1594,  469, 1298,  464, 1298, 1298,
 /*  1690 */  1298, 1602, 1591,  473, 1593, 1594,  469, 1298,  464, 1298,
 /*  1700 */  1606, 1298, 1298, 1298, 1298, 1298, 1298,  471, 1298, 1298,
 /*  1710 */  1298, 1298, 1298, 1298, 1298, 1590, 1298,  470, 1298, 1298,
 /*  1720 */  1298, 1562, 1298, 1298, 1590, 1298, 1298, 1298, 1298, 1298,
 /*  1730 */  1298, 1298, 1298, 1590, 1298, 1298, 1298, 1298, 1298, 1606,
 /*  1740 */  1601, 1591,  473, 1593, 1594,  469,  471,  464, 1606, 1298,
 /*  1750 */  1298, 1298, 1298, 1298, 1298,  471,  470, 1606, 1298, 1298,
 /*  1760 */  1562, 1298, 1298, 1298,  471,  470, 1298, 1298, 1298, 1562,
 /*  1770 */  1298, 1298, 1590, 1298,  470, 1298, 1298, 1298, 1562, 1600,
 /*  1780 */  1591,  473, 1593, 1594,  469, 1590,  464, 1298,  257, 1591,
 /*  1790 */   473, 1593, 1594,  469, 1298,  464, 1606,  256, 1591,  473,
 /*  1800 */  1593, 1594,  469,  471,  464, 1298, 1298, 1298, 1298, 1606,
 /*  1810 */  1298, 1298, 1298,  470, 1298, 1298,  471, 1562, 1298, 1298,
 /*  1820 */  1298, 1298, 1298, 1298, 1298, 1298,  470, 1298, 1298, 1298,
 /*  1830 */  1562, 1298, 1298, 1298, 1590, 1298,  258, 1591,  473, 1593,
 /*  1840 */  1594,  469, 1298,  464, 1298, 1298, 1298, 1298, 1298,  255,
 /*  1850 */  1591,  473, 1593, 1594,  469, 1298,  464, 1298, 1606, 1298,
 /*  1860 */  1298, 1298, 1298, 1298, 1298,  471, 1298, 1298, 1298, 1298,
 /*  1870 */  1298, 1298, 1298, 1298, 1298,  470, 1298, 1298, 1298, 1562,
 /*  1880 */  1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298,
 /*  1890 */  1298, 1298, 1298, 1298, 1298, 1298, 1298, 1298,  242, 1591,
 /*  1900 */   473, 1593, 1594,  469, 1298,  464,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   240,  324,  234,  265,  262,  275,  285,  262,  278,  249,
 /*    10 */   272,  281,   12,   13,  337,  259,  256,    4,  341,  240,
 /*    20 */    20,  279,   22,  258,  279,  265,  258,  243,  249,  264,
 /*    30 */   240,  247,   19,  265,  269,  256,  294,  295,   38,  294,
 /*    40 */   295,  309,  310,  275,  265,  324,   33,  279,  279,   36,
 /*    50 */    50,   12,   13,   14,   41,  265,   20,   57,  337,   20,
 /*    60 */    47,   22,  341,  294,  295,  242,  298,  299,  300,  301,
 /*    70 */   302,  303,   20,  305,    4,   75,  308,   38,  255,  240,
 /*    80 */   312,  313,  314,   14,   15,   16,  263,   74,  249,   50,
 /*    90 */    77,  242,  302,   20,  326,  267,   57,  250,   98,    0,
 /*   100 */   332,  333,  274,  275,  265,  258,  316,  317,  318,  319,
 /*   110 */   110,  321,  263,  266,   75,    0,   89,   90,   91,   92,
 /*   120 */    93,   94,   95,   96,   97,   98,   99,   75,  101,  102,
 /*   130 */   103,  104,  105,  106,    1,    2,   21,   98,   20,   24,
 /*   140 */    25,   26,   27,   28,   29,   30,   31,   32,   75,  110,
 /*   150 */   150,   52,   53,   54,   55,   56,   49,   58,   59,   60,
 /*   160 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   170 */    71,  171,  172,  239,  174,  175,  176,  177,  178,  179,
 /*   180 */   180,  181,  182,  183,  184,  185,  186,  187,  188,  150,
 /*   190 */    22,  258,  250,   52,  260,   54,  285,  231,  265,   58,
 /*   200 */   258,  201,   61,   20,   63,   64,   38,   66,  266,   76,
 /*   210 */   171,  172,   71,  174,  175,  176,  177,  178,  179,  180,
 /*   220 */   181,  182,  183,  184,  185,  186,  187,  188,   12,   13,
 /*   230 */    61,  234,   21,  300,   65,  324,   20,   18,   22,   20,
 /*   240 */    12,   13,   14,   15,   16,   34,   27,  324,  337,   30,
 /*   250 */   296,  285,  341,  201,   38,  258,    0,   88,   39,  258,
 /*   260 */   337,  149,  265,  151,  341,  264,   50,   12,   13,  240,
 /*   270 */   269,  201,  275,   57,  320,   20,  279,   22,  249,  201,
 /*   280 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  234,
 /*   290 */   324,   75,   20,   38,  265,  298,  299,  300,  301,  302,
 /*   300 */   303,  240,  305,  337,   76,  308,  257,  341,   75,  312,
 /*   310 */   313,  314,   57,  201,   98,  171,  258,  268,   85,  201,
 /*   320 */   323,   74,  264,  140,  159,  160,  110,  269,  163,   82,
 /*   330 */    75,  270,  113,   35,  279,  116,  117,  118,  119,  120,
 /*   340 */    43,  122,  123,  124,  125,  126,  127,  128,  129,  130,
 /*   350 */   131,  132,  133,   98,  210,  211,  212,  213,  214,   61,
 /*   360 */    20,   20,   22,   65,   21,  110,  150,   24,   25,   26,
 /*   370 */    27,   28,   29,   30,   31,   32,   78,  234,   80,   81,
 /*   380 */    40,   83,  138,  233,    3,  235,   88,  171,  172,  142,
 /*   390 */   174,  175,  176,  177,  178,  179,  180,  181,  182,  183,
 /*   400 */   184,  185,  186,  187,  188,  150,    0,    2,  250,   12,
 /*   410 */    13,   14,   15,   16,    0,   49,  258,   12,   13,   14,
 /*   420 */    15,   16,  279,   20,  266,  251,  171,  172,  254,  174,
 /*   430 */   175,  176,  177,  178,  179,  180,  181,  182,  183,  184,
 /*   440 */   185,  186,  187,  188,   12,   13,   14,   50,    2,  134,
 /*   450 */   206,  207,   20,  240,   22,  234,  201,   38,   12,   13,
 /*   460 */    14,   15,   16,  237,  238,  240,   52,   61,   54,  154,
 /*   470 */    38,   65,   58,   76,  249,   61,   57,   63,   64,  258,
 /*   480 */    66,   84,  146,   12,   13,   71,  265,  244,  245,   57,
 /*   490 */   265,   20,   20,   22,   88,  234,  275,  200,  285,  275,
 /*   500 */   279,  165,  240,  234,  189,  281,  285,   75,  234,   38,
 /*   510 */    20,  249,  234,  107,  108,  109,  240,  111,  234,  298,
 /*   520 */   299,  300,  301,  302,  303,  249,  305,  265,   57,  308,
 /*   530 */    98,  134,  258,  312,  313,  240,   67,  324,  239,  265,
 /*   540 */   279,  265,  110,  140,  249,  324,   75,  258,  279,  275,
 /*   550 */   337,  154,  253,  279,  341,  266,  282,  279,  337,  260,
 /*   560 */   265,   86,  341,  279,   12,   13,   14,   15,   16,   98,
 /*   570 */    47,  240,  298,  299,  300,  301,  302,  303,  234,  305,
 /*   580 */   249,  110,  150,  114,  115,  234,  189,  190,  191,  192,
 /*   590 */   193,  194,  195,  196,  197,  198,  265,   74,  217,  234,
 /*   600 */    77,  244,  245,  171,  172,   57,  174,  175,  176,  177,
 /*   610 */   178,  179,  180,  181,  182,  183,  184,  185,  186,  187,
 /*   620 */   188,  150,  234,  279,  234,   12,   13,   14,   15,   16,
 /*   630 */   279,   72,  234,   12,   13,   14,   15,   16,    0,  244,
 /*   640 */   245,    4,  171,  172,  279,  174,  175,  176,  177,  178,
 /*   650 */   179,  180,  181,  182,  183,  184,  185,  186,  187,  188,
 /*   660 */    12,   13,  234,   50,  296,  234,  296,  279,   20,  279,
 /*   670 */    22,   12,   13,   14,   15,   16,  240,  279,   12,   13,
 /*   680 */    14,   15,   16,   12,   13,  259,   38,   49,  320,  258,
 /*   690 */   320,    0,   75,   22,  240,  143,  265,   84,  246,  240,
 /*   700 */   248,  265,  240,  249,   87,   57,  275,  279,  249,   38,
 /*   710 */   279,  249,  244,  245,  274,  275,  240,  259,  234,  265,
 /*   720 */   234,  285,  259,   75,  265,  249,  234,  265,   57,  298,
 /*   730 */   299,  300,  301,  302,  303,   76,  305,  259,  302,  308,
 /*   740 */    49,  265,  258,  312,  313,  314,   98,  134,  234,  265,
 /*   750 */   234,  161,  162,  317,  318,  319,  234,  321,  110,  275,
 /*   760 */   324,  140,   72,  279,  333,  279,   76,  154,  234,   98,
 /*   770 */   234,  279,   14,  337,  222,  199,  200,  341,   20,  258,
 /*   780 */   221,  110,  298,  299,  300,  301,  302,  303,   14,  305,
 /*   790 */   269,   72,  308,  279,   20,  279,  312,  313,  150,    1,
 /*   800 */     2,  279,  189,  190,  191,  192,  193,  194,  195,  196,
 /*   810 */   197,  198,  259,  279,    0,  279,  234,  140,  141,  171,
 /*   820 */   172,  150,  174,  175,  176,  177,  178,  179,  180,  181,
 /*   830 */   182,  183,  184,  185,  186,  187,  188,    0,   18,  202,
 /*   840 */   258,   79,  171,   23,   82,    0,   79,  265,  234,   82,
 /*   850 */    36,   79,    0,   22,   82,   35,   79,  275,   72,   82,
 /*   860 */    72,  279,   76,  259,   76,  186,  187,   22,   48,   38,
 /*   870 */     0,   72,  258,   72,   22,   76,   50,   76,  235,  265,
 /*   880 */   298,  299,  300,  301,  302,  303,  288,  305,   57,  275,
 /*   890 */   308,  247,   22,  279,  312,  313,  314,   72,   61,   72,
 /*   900 */    72,   76,   65,   76,   76,  323,   72,   72,  344,  335,
 /*   910 */    76,   76,  298,  299,  300,  301,  302,  303,  268,  305,
 /*   920 */    72,   38,  308,   38,   76,   88,  312,  313,  314,   98,
 /*   930 */   329,   72,  112,  292,  237,   76,   38,  323,  219,   72,
 /*   940 */   322,  110,  297,   76,  107,  108,  109,   72,  111,   72,
 /*   950 */   240,   76,   72,   76,   72,   57,   76,  258,   76,  325,
 /*   960 */   338,   20,  240,  143,  144,  145,   36,  147,  234,  293,
 /*   970 */    38,  244,  152,  286,  121,  265,  240,  234,  148,  240,
 /*   980 */   273,  150,  271,  134,  164,  271,  166,  240,  168,  169,
 /*   990 */   170,   20,  258,  110,  290,  110,  242,  171,  275,  265,
 /*  1000 */    20,  258,  171,  172,  283,  242,  265,   20,  265,  275,
 /*  1010 */   242,  276,  302,  279,   20,  242,  240,  242,  275,  285,
 /*  1020 */   236,  201,  279,  258,  258,  240,  236,  317,  318,  319,
 /*  1030 */    57,  321,  298,  299,  300,  301,  302,  303,  234,  305,
 /*  1040 */   258,  298,  299,  300,  301,  302,  303,  258,  305,  258,
 /*  1050 */   258,  308,  258,  258,  258,  312,  313,  279,  324,   19,
 /*  1060 */   258,  258,  258,  276,  240,  157,   20,  297,  239,  265,
 /*  1070 */   290,  337,  289,   33,  265,  341,   36,  239,  239,  275,
 /*  1080 */   275,  239,   42,  279,   44,   45,   46,   47,  209,  265,
 /*  1090 */   283,  334,  234,  280,  208,  279,  215,  280,  334,  330,
 /*  1100 */   279,  279,  298,  299,  300,  301,  302,  303,  304,  305,
 /*  1110 */   306,  307,  216,  204,   74,  203,  258,   77,  200,  265,
 /*  1120 */    20,  328,  121,  265,  234,  315,  302,  327,  331,  296,
 /*  1130 */   223,  220,  218,  275,   75,  280,  279,  279,  277,  279,
 /*  1140 */   234,  317,  318,  319,  280,  321,  137,  107,  258,  265,
 /*  1150 */   339,  345,  340,  279,  311,  265,  298,  299,  300,  301,
 /*  1160 */   302,  303,  239,  305,  258,  275,  239,  276,  265,  279,
 /*  1170 */   254,  265,   75,  248,  261,  240,  136,  239,  236,  139,
 /*  1180 */   287,  275,  232,  291,  284,  279,  252,  241,  298,  299,
 /*  1190 */   300,  301,  302,  303,    0,  305,  156,  252,  158,  234,
 /*  1200 */   342,  343,    0,   64,  298,  299,  300,  301,  302,  303,
 /*  1210 */    38,  305,  234,    0,  308,  167,   38,   38,   38,  313,
 /*  1220 */   167,    0,   38,  258,   38,  167,  336,    0,   38,    0,
 /*  1230 */   265,   38,    0,   75,  154,  153,  258,  110,  150,    0,
 /*  1240 */   275,    0,   53,  265,  279,  146,    0,    0,   87,    0,
 /*  1250 */     0,    0,    0,  275,    0,    0,    0,  279,  121,    0,
 /*  1260 */   282,    0,    0,  298,  299,  300,  301,  302,  303,  234,
 /*  1270 */   305,   43,    0,   51,    0,   22,  298,  299,  300,  301,
 /*  1280 */   302,  303,    0,  305,    0,    0,    0,    0,    0,    0,
 /*  1290 */     0,    0,    0,  258,    0,    0,    0,    0,    0,    0,
 /*  1300 */   265,    0,    0,    0,    0,    0,    0,    0,  343,   43,
 /*  1310 */   275,   38,   36,    0,  279,   38,   36,  234,   43,    0,
 /*  1320 */     0,   38,   43,    0,   43,    0,    0,    0,   84,   36,
 /*  1330 */    82,    0,   72,  298,  299,  300,  301,  302,  303,   72,
 /*  1340 */   305,  258,  307,   22,   36,    0,  234,   38,  265,   38,
 /*  1350 */    38,   22,   38,   38,   38,   38,   38,    0,  275,   22,
 /*  1360 */    38,    0,  279,   39,   22,  282,   38,    0,   22,    0,
 /*  1370 */   258,   22,   20,    0,  140,    0,   38,  265,  155,  137,
 /*  1380 */    22,  298,  299,  300,  301,  302,  303,  275,  305,    0,
 /*  1390 */     0,  279,   33,   43,  282,   36,  234,  140,    0,  135,
 /*  1400 */   205,   42,   72,   44,   45,   46,   47,   75,   72,   76,
 /*  1410 */   298,  299,  300,  301,  302,  303,   72,  305,  199,  205,
 /*  1420 */   258,  205,   87,   76,   76,   38,   75,  265,   75,   75,
 /*  1430 */    75,    2,   72,   74,   72,  234,   77,  275,   72,   76,
 /*  1440 */    76,  279,   38,   87,  234,   38,   76,   38,   72,   38,
 /*  1450 */    38,   72,   87,   76,   76,   75,   75,   22,   87,  258,
 /*  1460 */   298,  299,  300,  301,  302,  303,  265,  305,  258,    0,
 /*  1470 */    76,  171,   75,   87,   75,  265,  275,   75,  138,   76,
 /*  1480 */   279,   76,   43,  173,   22,  275,   85,   87,   75,  279,
 /*  1490 */    75,   75,  234,   75,  135,   87,  137,   75,  139,  298,
 /*  1500 */   299,  300,  301,  302,  303,  234,  305,  135,  298,  299,
 /*  1510 */   300,  301,  302,  303,   86,  305,  258,  158,   38,   76,
 /*  1520 */    38,   75,   38,  265,   76,   75,   38,   76,   75,  258,
 /*  1530 */    76,   38,   75,  275,   76,   38,  265,  279,   75,   22,
 /*  1540 */   100,  100,   75,   88,  100,  100,  275,   38,  110,   75,
 /*  1550 */   279,   75,   38,   22,   51,   50,  298,  299,  300,  301,
 /*  1560 */   302,  303,   38,  305,   57,   73,   72,   38,  234,  298,
 /*  1570 */   299,  300,  301,  302,  303,   38,  305,  234,   38,   38,
 /*  1580 */    38,   38,   38,   22,   57,   38,   38,   38,   38,    0,
 /*  1590 */    38,   38,  258,   38,   38,   38,   36,   43,    0,  265,
 /*  1600 */    38,  258,   36,    0,   36,   38,   43,   43,  265,  275,
 /*  1610 */     0,   38,   36,  279,   43,    0,  234,   38,  275,   37,
 /*  1620 */     0,    0,  279,   22,   22,   21,   21,  234,   22,   20,
 /*  1630 */   346,  346,  298,  299,  300,  301,  302,  303,  346,  305,
 /*  1640 */   258,  298,  299,  300,  301,  302,  303,  265,  305,  346,
 /*  1650 */   346,  258,  346,  346,  346,  346,  346,  275,  265,  346,
 /*  1660 */   346,  279,  346,  346,  346,  346,  346,  346,  275,  346,
 /*  1670 */   346,  346,  279,  346,  346,  346,  234,  346,  346,  346,
 /*  1680 */   298,  299,  300,  301,  302,  303,  346,  305,  346,  346,
 /*  1690 */   346,  298,  299,  300,  301,  302,  303,  346,  305,  346,
 /*  1700 */   258,  346,  346,  346,  346,  346,  346,  265,  346,  346,
 /*  1710 */   346,  346,  346,  346,  346,  234,  346,  275,  346,  346,
 /*  1720 */   346,  279,  346,  346,  234,  346,  346,  346,  346,  346,
 /*  1730 */   346,  346,  346,  234,  346,  346,  346,  346,  346,  258,
 /*  1740 */   298,  299,  300,  301,  302,  303,  265,  305,  258,  346,
 /*  1750 */   346,  346,  346,  346,  346,  265,  275,  258,  346,  346,
 /*  1760 */   279,  346,  346,  346,  265,  275,  346,  346,  346,  279,
 /*  1770 */   346,  346,  234,  346,  275,  346,  346,  346,  279,  298,
 /*  1780 */   299,  300,  301,  302,  303,  234,  305,  346,  298,  299,
 /*  1790 */   300,  301,  302,  303,  346,  305,  258,  298,  299,  300,
 /*  1800 */   301,  302,  303,  265,  305,  346,  346,  346,  346,  258,
 /*  1810 */   346,  346,  346,  275,  346,  346,  265,  279,  346,  346,
 /*  1820 */   346,  346,  346,  346,  346,  346,  275,  346,  346,  346,
 /*  1830 */   279,  346,  346,  346,  234,  346,  298,  299,  300,  301,
 /*  1840 */   302,  303,  346,  305,  346,  346,  346,  346,  346,  298,
 /*  1850 */   299,  300,  301,  302,  303,  346,  305,  346,  258,  346,
 /*  1860 */   346,  346,  346,  346,  346,  265,  346,  346,  346,  346,
 /*  1870 */   346,  346,  346,  346,  346,  275,  346,  346,  346,  279,
 /*  1880 */   346,  346,  346,  346,  346,  346,  346,  346,  346,  346,
 /*  1890 */   346,  346,  346,  346,  346,  346,  346,  346,  298,  299,
 /*  1900 */   300,  301,  302,  303,  346,  305,
};
#define YY_SHIFT_COUNT    (573)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1621)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   820,    0,   39,  216,  216,  216,  216,  255,  216,  216,
 /*    10 */   432,  471,  648,  471,  471,  471,  471,  471,  471,  471,
 /*    20 */   471,  471,  471,  471,  471,  471,  471,  471,  471,  471,
 /*    30 */   471,  471,  471,  471,  471,  471,   52,   73,   73,   73,
 /*    40 */   118,  671,  671,  112,   36,   36,   78,  671,   70,   36,
 /*    50 */    36,   36,   36,   36,   36,  107,   36,  272,  341,   78,
 /*    60 */   472,  272,   36,   36,  272,   36,  272,  472,  272,  272,
 /*    70 */    36,  366,  219,  397,  613,  613,  343,  831,  298,  141,
 /*    80 */   831,  831,  831,  831,  831,  831,  831,  831,  831,  831,
 /*    90 */   831,  831,  831,  831,  831,  831,  831,  831,  831,  340,
 /*   100 */   638,  419,  419,  183,  183,  183,  691,  419,  419,  490,
 /*   110 */   472,  272,  472,  272,  475,  548,   27,   27,   27,   27,
 /*   120 */    27,   27,   27, 1040,  115,  414,  552,  144,  169,  165,
 /*   130 */   244,  168,  403,  576,  297,  576,  758,  381,  637,  774,
 /*   140 */   941,  930,  932,  830,  941,  941,  853,  849,  849,  941,
 /*   150 */   971,  107,  472,  980,  107,  490,  987,  107,  107,  941,
 /*   160 */   107,  994,  272,  272,  272,  272,  272,  272,  272,  272,
 /*   170 */   272,  272,  272,  941,  994,  973,  971,  366,  908,  472,
 /*   180 */   366,  980,  366,  490,  987,  366, 1046,  879,  886,  973,
 /*   190 */   879,  886,  973,  973,  896,  881,  909,  912,  918,  490,
 /*   200 */  1100, 1001,  907,  911,  914, 1059,  272,  886,  973,  973,
 /*   210 */   886,  973, 1009,  490,  987,  366,  475,  366,  490, 1097,
 /*   220 */   548,  941,  366,  994, 1906, 1906, 1906, 1906, 1906, 1906,
 /*   230 */  1906,   99, 1359,  256,   13,  406,  837,  228,  405,  446,
 /*   240 */   621,  659,  666,  666,  666,  666,  666,  666,  666,  666,
 /*   250 */   523,  469,  247,  133,  315,   69,   69,   69,   69,  814,
 /*   260 */   336,  690,  762,  767,  772,  777,  845,  852,  870,  211,
 /*   270 */   590,  677,  786,  788,  799,  798,  679,  719,  559,  801,
 /*   280 */   826,  825,  617,  827,  828,  834,  835,  848,  883,  885,
 /*   290 */   859,  867,  875,  877,  880,  882,  233,  898, 1194, 1202,
 /*   300 */  1139, 1213, 1172, 1048, 1178, 1179, 1180, 1053, 1221, 1184,
 /*   310 */  1186, 1058, 1227, 1190, 1229, 1193, 1232, 1158, 1080, 1082,
 /*   320 */  1127, 1088, 1239, 1241, 1189, 1099, 1246, 1247, 1161, 1249,
 /*   330 */  1250, 1251, 1252, 1254, 1255, 1256, 1261, 1262, 1282, 1284,
 /*   340 */  1285, 1286, 1287, 1288, 1289, 1290, 1137, 1259, 1291, 1292,
 /*   350 */  1294, 1295, 1296, 1253, 1297, 1298, 1299, 1301, 1302, 1303,
 /*   360 */  1304, 1305, 1306, 1228, 1272, 1222, 1274, 1307, 1273, 1276,
 /*   370 */  1266, 1313, 1277, 1280, 1275, 1319, 1283, 1293, 1279, 1320,
 /*   380 */  1309, 1308, 1281, 1323, 1325, 1326, 1327, 1244, 1248, 1311,
 /*   390 */  1260, 1267, 1321, 1331, 1312, 1314, 1315, 1316, 1317, 1260,
 /*   400 */  1267, 1318, 1322, 1345, 1329, 1357, 1337, 1324, 1361, 1342,
 /*   410 */  1328, 1367, 1346, 1369, 1349, 1352, 1373, 1234, 1338, 1375,
 /*   420 */  1223, 1358, 1257, 1242, 1389, 1390, 1398, 1332, 1350, 1264,
 /*   430 */  1330, 1336, 1195, 1333, 1344, 1347, 1351, 1353, 1354, 1348,
 /*   440 */  1360, 1335, 1355, 1362, 1214, 1363, 1364, 1356, 1219, 1366,
 /*   450 */  1365, 1370, 1376, 1216, 1387, 1404, 1407, 1409, 1411, 1412,
 /*   460 */  1429, 1300, 1379, 1377, 1380, 1378, 1381, 1394, 1371, 1397,
 /*   470 */  1399, 1386, 1435, 1310, 1402, 1403, 1405, 1413, 1415, 1340,
 /*   480 */  1416, 1469, 1439, 1372, 1418, 1401, 1400, 1408, 1462, 1422,
 /*   490 */  1428, 1443, 1480, 1482, 1446, 1448, 1484, 1450, 1451, 1488,
 /*   500 */  1453, 1454, 1493, 1457, 1458, 1497, 1463, 1440, 1441, 1444,
 /*   510 */  1445, 1517, 1455, 1467, 1509, 1438, 1474, 1476, 1514, 1260,
 /*   520 */  1267, 1531, 1503, 1505, 1524, 1507, 1492, 1494, 1529, 1537,
 /*   530 */  1540, 1541, 1542, 1543, 1544, 1561, 1527, 1260, 1547, 1267,
 /*   540 */  1548, 1549, 1550, 1552, 1553, 1555, 1556, 1589, 1557, 1560,
 /*   550 */  1554, 1598, 1562, 1566, 1563, 1603, 1567, 1568, 1564, 1610,
 /*   560 */  1573, 1576, 1571, 1615, 1579, 1582, 1620, 1621, 1601, 1604,
 /*   570 */  1602, 1606, 1605, 1609,
};
#define YY_REDUCE_COUNT (230)
#define YY_REDUCE_MIN   (-323)
#define YY_REDUCE_MAX   (1600)
static const short yy_reduce_ofst[] = {
 /*     0 */   -34,  221, -232,  431,   -3,  582,  614,  734,  484,  743,
 /*    10 */   804,  858,  906,  274,  890,  965,  978, 1035, 1083, 1112,
 /*    20 */  1162, 1201, 1210, 1258, 1271, 1334, 1343, 1382, 1393, 1442,
 /*    30 */  1481, 1490, 1499, 1538, 1551, 1600,  436, -210,  710,  824,
 /*    40 */   213, -258, -255, -279, -240, -221,  -89, -231, -323, -161,
 /*    50 */    29,  225,  262,  276,  295, -177,  331, -235,  -67,  -77,
 /*    60 */  -270, -153,  454,  459,    1,  462,  -58, -172,   58,  158,
 /*    70 */   476,  299,   61, -268, -268, -268,  150,   55,   49, -216,
 /*    80 */   143,  261,  269,  278,  284,  344,  351,  365,  388,  390,
 /*    90 */   398,  428,  486,  492,  514,  516,  522,  534,  536,  226,
 /*   100 */  -151,  243,  357,  -46,  368,  370,  -66,  395,  468, -262,
 /*   110 */   224,  289,  440,  521,  174,  452, -244,  426,  458,  463,
 /*   120 */   478,  553,  604,  598,  643,  644,  564,  574,  650,  641,
 /*   130 */   601,  697,  645,  618,  618,  618,  699,  622,  634,  699,
 /*   140 */   722,  676,  727,  687,  736,  739,  707,  711,  714,  747,
 /*   150 */   704,  754,  723,  721,  763,  741,  735,  768,  773,  776,
 /*   160 */   775,  784,  765,  766,  782,  789,  791,  792,  794,  795,
 /*   170 */   796,  802,  803,  785,  790,  778,  780,  829,  783,  805,
 /*   180 */   838,  807,  839,  809,  787,  842,  770,  757,  813,  816,
 /*   190 */   764,  817,  821,  822,  797,  769,  793,  800,  618,  854,
 /*   200 */   833,  810,  806,  812,  811,  843,  699,  855,  857,  860,
 /*   210 */   864,  874,  861,  884,  891,  923,  916,  927,  903,  913,
 /*   220 */   925,  935,  938,  942,  893,  892,  900,  934,  945,  946,
 /*   230 */   950,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*    10 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*    20 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*    30 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*    40 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*    50 */  1296, 1296, 1296, 1296, 1296, 1355, 1296, 1296, 1296, 1296,
 /*    60 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*    70 */  1296, 1353, 1498, 1296, 1658, 1296, 1296, 1296, 1296, 1296,
 /*    80 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*    90 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   100 */  1355, 1296, 1296, 1669, 1669, 1669, 1353, 1296, 1296, 1296,
 /*   110 */  1296, 1296, 1296, 1296, 1450, 1296, 1296, 1296, 1296, 1296,
 /*   120 */  1296, 1296, 1296, 1536, 1296, 1296, 1734, 1296, 1403, 1542,
 /*   130 */  1693, 1296, 1685, 1661, 1675, 1662, 1296, 1719, 1678, 1296,
 /*   140 */  1296, 1296, 1296, 1528, 1296, 1296, 1503, 1500, 1500, 1296,
 /*   150 */  1296, 1355, 1296, 1296, 1355, 1296, 1296, 1355, 1355, 1296,
 /*   160 */  1355, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   170 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1353, 1538, 1296,
 /*   180 */  1353, 1296, 1353, 1296, 1296, 1353, 1296, 1700, 1698, 1296,
 /*   190 */  1700, 1698, 1296, 1296, 1712, 1708, 1691, 1689, 1675, 1296,
 /*   200 */  1296, 1296, 1737, 1725, 1721, 1296, 1296, 1698, 1296, 1296,
 /*   210 */  1698, 1296, 1511, 1296, 1296, 1353, 1296, 1353, 1296, 1419,
 /*   220 */  1296, 1296, 1353, 1296, 1530, 1544, 1520, 1453, 1453, 1356,
 /*   230 */  1301, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   240 */  1296, 1296, 1605, 1711, 1710, 1634, 1633, 1632, 1630, 1604,
 /*   250 */  1296, 1296, 1296, 1296, 1296, 1598, 1599, 1597, 1596, 1296,
 /*   260 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   270 */  1296, 1296, 1296, 1296, 1296, 1659, 1296, 1722, 1726, 1296,
 /*   280 */  1296, 1296, 1582, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   290 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   300 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   310 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   320 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   330 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   340 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   350 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   360 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   370 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   380 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   390 */  1466, 1465, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1383,
 /*   400 */  1382, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   410 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   420 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   430 */  1682, 1692, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   440 */  1296, 1582, 1296, 1709, 1296, 1668, 1664, 1296, 1296, 1660,
 /*   450 */  1296, 1296, 1720, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   460 */  1654, 1296, 1627, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   470 */  1296, 1296, 1296, 1592, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   480 */  1296, 1296, 1296, 1296, 1296, 1296, 1581, 1296, 1296, 1296,
 /*   490 */  1296, 1296, 1296, 1296, 1447, 1296, 1296, 1296, 1296, 1296,
 /*   500 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1432, 1430, 1429,
 /*   510 */  1428, 1296, 1425, 1296, 1296, 1296, 1296, 1296, 1296, 1456,
 /*   520 */  1455, 1296, 1296, 1296, 1296, 1296, 1296, 1376, 1296, 1296,
 /*   530 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1367, 1296, 1366,
 /*   540 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   550 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   560 */  1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296, 1296,
 /*   570 */  1296, 1296, 1296, 1296,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*         ON => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BLOCKS => nothing */
    0,  /*      CACHE => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*     QUORUM => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*        TTL => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* STREAM_MODE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /*     STRICT => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*        SMA => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*      DELAY => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*       FROM => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*     SCHEMA => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  224,  /*  NK_BITNOT => ID */
  224,  /*     INSERT => ID */
  224,  /*     VALUES => ID */
  224,  /*     IMPORT => ID */
  224,  /*    NK_SEMI => ID */
  224,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "STRICT",
  /*   72 */ "NK_COMMA",
  /*   73 */ "NK_COLON",
  /*   74 */ "TABLE",
  /*   75 */ "NK_LP",
  /*   76 */ "NK_RP",
  /*   77 */ "STABLE",
  /*   78 */ "ADD",
  /*   79 */ "COLUMN",
  /*   80 */ "MODIFY",
  /*   81 */ "RENAME",
  /*   82 */ "TAG",
  /*   83 */ "SET",
  /*   84 */ "NK_EQ",
  /*   85 */ "USING",
  /*   86 */ "TAGS",
  /*   87 */ "NK_DOT",
  /*   88 */ "COMMENT",
  /*   89 */ "BOOL",
  /*   90 */ "TINYINT",
  /*   91 */ "SMALLINT",
  /*   92 */ "INT",
  /*   93 */ "INTEGER",
  /*   94 */ "BIGINT",
  /*   95 */ "FLOAT",
  /*   96 */ "DOUBLE",
  /*   97 */ "BINARY",
  /*   98 */ "TIMESTAMP",
  /*   99 */ "NCHAR",
  /*  100 */ "UNSIGNED",
  /*  101 */ "JSON",
  /*  102 */ "VARCHAR",
  /*  103 */ "MEDIUMBLOB",
  /*  104 */ "BLOB",
  /*  105 */ "VARBINARY",
  /*  106 */ "DECIMAL",
  /*  107 */ "SMA",
  /*  108 */ "ROLLUP",
  /*  109 */ "FILE_FACTOR",
  /*  110 */ "NK_FLOAT",
  /*  111 */ "DELAY",
  /*  112 */ "SHOW",
  /*  113 */ "DATABASES",
  /*  114 */ "TABLES",
  /*  115 */ "STABLES",
  /*  116 */ "MNODES",
  /*  117 */ "MODULES",
  /*  118 */ "QNODES",
  /*  119 */ "FUNCTIONS",
  /*  120 */ "INDEXES",
  /*  121 */ "FROM",
  /*  122 */ "ACCOUNTS",
  /*  123 */ "APPS",
  /*  124 */ "CONNECTIONS",
  /*  125 */ "LICENCE",
  /*  126 */ "GRANTS",
  /*  127 */ "QUERIES",
  /*  128 */ "SCORES",
  /*  129 */ "TOPICS",
  /*  130 */ "VARIABLES",
  /*  131 */ "BNODES",
  /*  132 */ "SNODES",
  /*  133 */ "CLUSTER",
  /*  134 */ "LIKE",
  /*  135 */ "INDEX",
  /*  136 */ "FULLTEXT",
  /*  137 */ "FUNCTION",
  /*  138 */ "INTERVAL",
  /*  139 */ "TOPIC",
  /*  140 */ "AS",
  /*  141 */ "WITH",
  /*  142 */ "SCHEMA",
  /*  143 */ "DESC",
  /*  144 */ "DESCRIBE",
  /*  145 */ "RESET",
  /*  146 */ "QUERY",
  /*  147 */ "EXPLAIN",
  /*  148 */ "ANALYZE",
  /*  149 */ "VERBOSE",
  /*  150 */ "NK_BOOL",
  /*  151 */ "RATIO",
  /*  152 */ "COMPACT",
  /*  153 */ "VNODES",
  /*  154 */ "IN",
  /*  155 */ "OUTPUTTYPE",
  /*  156 */ "AGGREGATE",
  /*  157 */ "BUFSIZE",
  /*  158 */ "STREAM",
  /*  159 */ "INTO",
  /*  160 */ "TRIGGER",
  /*  161 */ "AT_ONCE",
  /*  162 */ "WINDOW_CLOSE",
  /*  163 */ "WATERMARK",
  /*  164 */ "KILL",
  /*  165 */ "CONNECTION",
  /*  166 */ "MERGE",
  /*  167 */ "VGROUP",
  /*  168 */ "REDISTRIBUTE",
  /*  169 */ "SPLIT",
  /*  170 */ "SYNCDB",
  /*  171 */ "NULL",
  /*  172 */ "NK_QUESTION",
  /*  173 */ "NK_ARROW",
  /*  174 */ "ROWTS",
  /*  175 */ "TBNAME",
  /*  176 */ "QSTARTTS",
  /*  177 */ "QENDTS",
  /*  178 */ "WSTARTTS",
  /*  179 */ "WENDTS",
  /*  180 */ "WDURATION",
  /*  181 */ "CAST",
  /*  182 */ "NOW",
  /*  183 */ "TODAY",
  /*  184 */ "TIMEZONE",
  /*  185 */ "COUNT",
  /*  186 */ "FIRST",
  /*  187 */ "LAST",
  /*  188 */ "LAST_ROW",
  /*  189 */ "BETWEEN",
  /*  190 */ "IS",
  /*  191 */ "NK_LT",
  /*  192 */ "NK_GT",
  /*  193 */ "NK_LE",
  /*  194 */ "NK_GE",
  /*  195 */ "NK_NE",
  /*  196 */ "MATCH",
  /*  197 */ "NMATCH",
  /*  198 */ "CONTAINS",
  /*  199 */ "JOIN",
  /*  200 */ "INNER",
  /*  201 */ "SELECT",
  /*  202 */ "DISTINCT",
  /*  203 */ "WHERE",
  /*  204 */ "PARTITION",
  /*  205 */ "BY",
  /*  206 */ "SESSION",
  /*  207 */ "STATE_WINDOW",
  /*  208 */ "SLIDING",
  /*  209 */ "FILL",
  /*  210 */ "VALUE",
  /*  211 */ "NONE",
  /*  212 */ "PREV",
  /*  213 */ "LINEAR",
  /*  214 */ "NEXT",
  /*  215 */ "GROUP",
  /*  216 */ "HAVING",
  /*  217 */ "ORDER",
  /*  218 */ "SLIMIT",
  /*  219 */ "SOFFSET",
  /*  220 */ "LIMIT",
  /*  221 */ "OFFSET",
  /*  222 */ "ASC",
  /*  223 */ "NULLS",
  /*  224 */ "ID",
  /*  225 */ "NK_BITNOT",
  /*  226 */ "INSERT",
  /*  227 */ "VALUES",
  /*  228 */ "IMPORT",
  /*  229 */ "NK_SEMI",
  /*  230 */ "FILE",
  /*  231 */ "cmd",
  /*  232 */ "account_options",
  /*  233 */ "alter_account_options",
  /*  234 */ "literal",
  /*  235 */ "alter_account_option",
  /*  236 */ "user_name",
  /*  237 */ "dnode_endpoint",
  /*  238 */ "dnode_host_name",
  /*  239 */ "not_exists_opt",
  /*  240 */ "db_name",
  /*  241 */ "db_options",
  /*  242 */ "exists_opt",
  /*  243 */ "alter_db_options",
  /*  244 */ "integer_list",
  /*  245 */ "variable_list",
  /*  246 */ "retention_list",
  /*  247 */ "alter_db_option",
  /*  248 */ "retention",
  /*  249 */ "full_table_name",
  /*  250 */ "column_def_list",
  /*  251 */ "tags_def_opt",
  /*  252 */ "table_options",
  /*  253 */ "multi_create_clause",
  /*  254 */ "tags_def",
  /*  255 */ "multi_drop_clause",
  /*  256 */ "alter_table_clause",
  /*  257 */ "alter_table_options",
  /*  258 */ "column_name",
  /*  259 */ "type_name",
  /*  260 */ "create_subtable_clause",
  /*  261 */ "specific_tags_opt",
  /*  262 */ "literal_list",
  /*  263 */ "drop_table_clause",
  /*  264 */ "col_name_list",
  /*  265 */ "table_name",
  /*  266 */ "column_def",
  /*  267 */ "func_name_list",
  /*  268 */ "alter_table_option",
  /*  269 */ "col_name",
  /*  270 */ "db_name_cond_opt",
  /*  271 */ "like_pattern_opt",
  /*  272 */ "table_name_cond",
  /*  273 */ "from_db_opt",
  /*  274 */ "func_name",
  /*  275 */ "function_name",
  /*  276 */ "index_name",
  /*  277 */ "index_options",
  /*  278 */ "func_list",
  /*  279 */ "duration_literal",
  /*  280 */ "sliding_opt",
  /*  281 */ "func",
  /*  282 */ "expression_list",
  /*  283 */ "topic_name",
  /*  284 */ "topic_options",
  /*  285 */ "query_expression",
  /*  286 */ "analyze_opt",
  /*  287 */ "explain_options",
  /*  288 */ "agg_func_opt",
  /*  289 */ "bufsize_opt",
  /*  290 */ "stream_name",
  /*  291 */ "stream_options",
  /*  292 */ "into_opt",
  /*  293 */ "dnode_list",
  /*  294 */ "signed",
  /*  295 */ "signed_literal",
  /*  296 */ "table_alias",
  /*  297 */ "column_alias",
  /*  298 */ "expression",
  /*  299 */ "pseudo_column",
  /*  300 */ "column_reference",
  /*  301 */ "function_expression",
  /*  302 */ "subquery",
  /*  303 */ "star_func",
  /*  304 */ "star_func_para_list",
  /*  305 */ "noarg_func",
  /*  306 */ "other_para_list",
  /*  307 */ "star_func_para",
  /*  308 */ "predicate",
  /*  309 */ "compare_op",
  /*  310 */ "in_op",
  /*  311 */ "in_predicate_value",
  /*  312 */ "boolean_value_expression",
  /*  313 */ "boolean_primary",
  /*  314 */ "common_expression",
  /*  315 */ "from_clause",
  /*  316 */ "table_reference_list",
  /*  317 */ "table_reference",
  /*  318 */ "table_primary",
  /*  319 */ "joined_table",
  /*  320 */ "alias_opt",
  /*  321 */ "parenthesized_joined_table",
  /*  322 */ "join_type",
  /*  323 */ "search_condition",
  /*  324 */ "query_specification",
  /*  325 */ "set_quantifier_opt",
  /*  326 */ "select_list",
  /*  327 */ "where_clause_opt",
  /*  328 */ "partition_by_clause_opt",
  /*  329 */ "twindow_clause_opt",
  /*  330 */ "group_by_clause_opt",
  /*  331 */ "having_clause_opt",
  /*  332 */ "select_sublist",
  /*  333 */ "select_item",
  /*  334 */ "fill_opt",
  /*  335 */ "fill_mode",
  /*  336 */ "group_by_list",
  /*  337 */ "query_expression_body",
  /*  338 */ "order_by_clause_opt",
  /*  339 */ "slimit_clause_opt",
  /*  340 */ "limit_clause_opt",
  /*  341 */ "query_primary",
  /*  342 */ "sort_specification_list",
  /*  343 */ "sort_specification",
  /*  344 */ "ordering_specification_opt",
  /*  345 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  79 */ "alter_db_options ::= alter_db_option",
 /*  80 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  81 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  82 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  83 */ "alter_db_option ::= KEEP integer_list",
 /*  84 */ "alter_db_option ::= KEEP variable_list",
 /*  85 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  86 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  87 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  88 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  89 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  90 */ "integer_list ::= NK_INTEGER",
 /*  91 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  92 */ "variable_list ::= NK_VARIABLE",
 /*  93 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  94 */ "retention_list ::= retention",
 /*  95 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  96 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  97 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  98 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  99 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 100 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 101 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 102 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 103 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 104 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 105 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 107 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 109 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 111 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 112 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 113 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 114 */ "multi_create_clause ::= create_subtable_clause",
 /* 115 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 116 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 117 */ "multi_drop_clause ::= drop_table_clause",
 /* 118 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 119 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 120 */ "specific_tags_opt ::=",
 /* 121 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 122 */ "full_table_name ::= table_name",
 /* 123 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 124 */ "column_def_list ::= column_def",
 /* 125 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 126 */ "column_def ::= column_name type_name",
 /* 127 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 128 */ "type_name ::= BOOL",
 /* 129 */ "type_name ::= TINYINT",
 /* 130 */ "type_name ::= SMALLINT",
 /* 131 */ "type_name ::= INT",
 /* 132 */ "type_name ::= INTEGER",
 /* 133 */ "type_name ::= BIGINT",
 /* 134 */ "type_name ::= FLOAT",
 /* 135 */ "type_name ::= DOUBLE",
 /* 136 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TIMESTAMP",
 /* 138 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 139 */ "type_name ::= TINYINT UNSIGNED",
 /* 140 */ "type_name ::= SMALLINT UNSIGNED",
 /* 141 */ "type_name ::= INT UNSIGNED",
 /* 142 */ "type_name ::= BIGINT UNSIGNED",
 /* 143 */ "type_name ::= JSON",
 /* 144 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 145 */ "type_name ::= MEDIUMBLOB",
 /* 146 */ "type_name ::= BLOB",
 /* 147 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL",
 /* 149 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 150 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 151 */ "tags_def_opt ::=",
 /* 152 */ "tags_def_opt ::= tags_def",
 /* 153 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 154 */ "table_options ::=",
 /* 155 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 156 */ "table_options ::= table_options KEEP integer_list",
 /* 157 */ "table_options ::= table_options KEEP variable_list",
 /* 158 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 159 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 160 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 161 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 162 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 163 */ "alter_table_options ::= alter_table_option",
 /* 164 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 165 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 166 */ "alter_table_option ::= KEEP integer_list",
 /* 167 */ "alter_table_option ::= KEEP variable_list",
 /* 168 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 169 */ "col_name_list ::= col_name",
 /* 170 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 171 */ "col_name ::= column_name",
 /* 172 */ "cmd ::= SHOW DNODES",
 /* 173 */ "cmd ::= SHOW USERS",
 /* 174 */ "cmd ::= SHOW DATABASES",
 /* 175 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 176 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 177 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 178 */ "cmd ::= SHOW MNODES",
 /* 179 */ "cmd ::= SHOW MODULES",
 /* 180 */ "cmd ::= SHOW QNODES",
 /* 181 */ "cmd ::= SHOW FUNCTIONS",
 /* 182 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 183 */ "cmd ::= SHOW STREAMS",
 /* 184 */ "cmd ::= SHOW ACCOUNTS",
 /* 185 */ "cmd ::= SHOW APPS",
 /* 186 */ "cmd ::= SHOW CONNECTIONS",
 /* 187 */ "cmd ::= SHOW LICENCE",
 /* 188 */ "cmd ::= SHOW GRANTS",
 /* 189 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 190 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 191 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 192 */ "cmd ::= SHOW QUERIES",
 /* 193 */ "cmd ::= SHOW SCORES",
 /* 194 */ "cmd ::= SHOW TOPICS",
 /* 195 */ "cmd ::= SHOW VARIABLES",
 /* 196 */ "cmd ::= SHOW BNODES",
 /* 197 */ "cmd ::= SHOW SNODES",
 /* 198 */ "cmd ::= SHOW CLUSTER",
 /* 199 */ "db_name_cond_opt ::=",
 /* 200 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 201 */ "like_pattern_opt ::=",
 /* 202 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 203 */ "table_name_cond ::= table_name",
 /* 204 */ "from_db_opt ::=",
 /* 205 */ "from_db_opt ::= FROM db_name",
 /* 206 */ "func_name_list ::= func_name",
 /* 207 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 208 */ "func_name ::= function_name",
 /* 209 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 210 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 211 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 212 */ "index_options ::=",
 /* 213 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 214 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 215 */ "func_list ::= func",
 /* 216 */ "func_list ::= func_list NK_COMMA func",
 /* 217 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 218 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression",
 /* 219 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name",
 /* 220 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 221 */ "topic_options ::=",
 /* 222 */ "topic_options ::= topic_options WITH TABLE",
 /* 223 */ "topic_options ::= topic_options WITH SCHEMA",
 /* 224 */ "topic_options ::= topic_options WITH TAG",
 /* 225 */ "cmd ::= DESC full_table_name",
 /* 226 */ "cmd ::= DESCRIBE full_table_name",
 /* 227 */ "cmd ::= RESET QUERY CACHE",
 /* 228 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 229 */ "analyze_opt ::=",
 /* 230 */ "analyze_opt ::= ANALYZE",
 /* 231 */ "explain_options ::=",
 /* 232 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 233 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 234 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 235 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 236 */ "cmd ::= DROP FUNCTION function_name",
 /* 237 */ "agg_func_opt ::=",
 /* 238 */ "agg_func_opt ::= AGGREGATE",
 /* 239 */ "bufsize_opt ::=",
 /* 240 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 241 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 242 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 243 */ "into_opt ::=",
 /* 244 */ "into_opt ::= INTO full_table_name",
 /* 245 */ "stream_options ::=",
 /* 246 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 247 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 248 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 249 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 250 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 251 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 252 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 253 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 254 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 255 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 256 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 257 */ "cmd ::= query_expression",
 /* 258 */ "literal ::= NK_INTEGER",
 /* 259 */ "literal ::= NK_FLOAT",
 /* 260 */ "literal ::= NK_STRING",
 /* 261 */ "literal ::= NK_BOOL",
 /* 262 */ "literal ::= TIMESTAMP NK_STRING",
 /* 263 */ "literal ::= duration_literal",
 /* 264 */ "literal ::= NULL",
 /* 265 */ "literal ::= NK_QUESTION",
 /* 266 */ "duration_literal ::= NK_VARIABLE",
 /* 267 */ "signed ::= NK_INTEGER",
 /* 268 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 269 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 270 */ "signed ::= NK_FLOAT",
 /* 271 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 272 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 273 */ "signed_literal ::= signed",
 /* 274 */ "signed_literal ::= NK_STRING",
 /* 275 */ "signed_literal ::= NK_BOOL",
 /* 276 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 277 */ "signed_literal ::= duration_literal",
 /* 278 */ "signed_literal ::= NULL",
 /* 279 */ "literal_list ::= signed_literal",
 /* 280 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 281 */ "db_name ::= NK_ID",
 /* 282 */ "table_name ::= NK_ID",
 /* 283 */ "column_name ::= NK_ID",
 /* 284 */ "function_name ::= NK_ID",
 /* 285 */ "table_alias ::= NK_ID",
 /* 286 */ "column_alias ::= NK_ID",
 /* 287 */ "user_name ::= NK_ID",
 /* 288 */ "index_name ::= NK_ID",
 /* 289 */ "topic_name ::= NK_ID",
 /* 290 */ "stream_name ::= NK_ID",
 /* 291 */ "expression ::= literal",
 /* 292 */ "expression ::= pseudo_column",
 /* 293 */ "expression ::= column_reference",
 /* 294 */ "expression ::= function_expression",
 /* 295 */ "expression ::= subquery",
 /* 296 */ "expression ::= NK_LP expression NK_RP",
 /* 297 */ "expression ::= NK_PLUS expression",
 /* 298 */ "expression ::= NK_MINUS expression",
 /* 299 */ "expression ::= expression NK_PLUS expression",
 /* 300 */ "expression ::= expression NK_MINUS expression",
 /* 301 */ "expression ::= expression NK_STAR expression",
 /* 302 */ "expression ::= expression NK_SLASH expression",
 /* 303 */ "expression ::= expression NK_REM expression",
 /* 304 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 305 */ "expression_list ::= expression",
 /* 306 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 307 */ "column_reference ::= column_name",
 /* 308 */ "column_reference ::= table_name NK_DOT column_name",
 /* 309 */ "pseudo_column ::= ROWTS",
 /* 310 */ "pseudo_column ::= TBNAME",
 /* 311 */ "pseudo_column ::= QSTARTTS",
 /* 312 */ "pseudo_column ::= QENDTS",
 /* 313 */ "pseudo_column ::= WSTARTTS",
 /* 314 */ "pseudo_column ::= WENDTS",
 /* 315 */ "pseudo_column ::= WDURATION",
 /* 316 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 317 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 318 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 319 */ "function_expression ::= noarg_func NK_LP NK_RP",
 /* 320 */ "noarg_func ::= NOW",
 /* 321 */ "noarg_func ::= TODAY",
 /* 322 */ "noarg_func ::= TIMEZONE",
 /* 323 */ "star_func ::= COUNT",
 /* 324 */ "star_func ::= FIRST",
 /* 325 */ "star_func ::= LAST",
 /* 326 */ "star_func ::= LAST_ROW",
 /* 327 */ "star_func_para_list ::= NK_STAR",
 /* 328 */ "star_func_para_list ::= other_para_list",
 /* 329 */ "other_para_list ::= star_func_para",
 /* 330 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 331 */ "star_func_para ::= expression",
 /* 332 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 333 */ "predicate ::= expression compare_op expression",
 /* 334 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 335 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 336 */ "predicate ::= expression IS NULL",
 /* 337 */ "predicate ::= expression IS NOT NULL",
 /* 338 */ "predicate ::= expression in_op in_predicate_value",
 /* 339 */ "compare_op ::= NK_LT",
 /* 340 */ "compare_op ::= NK_GT",
 /* 341 */ "compare_op ::= NK_LE",
 /* 342 */ "compare_op ::= NK_GE",
 /* 343 */ "compare_op ::= NK_NE",
 /* 344 */ "compare_op ::= NK_EQ",
 /* 345 */ "compare_op ::= LIKE",
 /* 346 */ "compare_op ::= NOT LIKE",
 /* 347 */ "compare_op ::= MATCH",
 /* 348 */ "compare_op ::= NMATCH",
 /* 349 */ "compare_op ::= CONTAINS",
 /* 350 */ "in_op ::= IN",
 /* 351 */ "in_op ::= NOT IN",
 /* 352 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 353 */ "boolean_value_expression ::= boolean_primary",
 /* 354 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 355 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 356 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 357 */ "boolean_primary ::= predicate",
 /* 358 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 359 */ "common_expression ::= expression",
 /* 360 */ "common_expression ::= boolean_value_expression",
 /* 361 */ "from_clause ::= FROM table_reference_list",
 /* 362 */ "table_reference_list ::= table_reference",
 /* 363 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 364 */ "table_reference ::= table_primary",
 /* 365 */ "table_reference ::= joined_table",
 /* 366 */ "table_primary ::= table_name alias_opt",
 /* 367 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 368 */ "table_primary ::= subquery alias_opt",
 /* 369 */ "table_primary ::= parenthesized_joined_table",
 /* 370 */ "alias_opt ::=",
 /* 371 */ "alias_opt ::= table_alias",
 /* 372 */ "alias_opt ::= AS table_alias",
 /* 373 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 374 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 375 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 376 */ "join_type ::=",
 /* 377 */ "join_type ::= INNER",
 /* 378 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 379 */ "set_quantifier_opt ::=",
 /* 380 */ "set_quantifier_opt ::= DISTINCT",
 /* 381 */ "set_quantifier_opt ::= ALL",
 /* 382 */ "select_list ::= NK_STAR",
 /* 383 */ "select_list ::= select_sublist",
 /* 384 */ "select_sublist ::= select_item",
 /* 385 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 386 */ "select_item ::= common_expression",
 /* 387 */ "select_item ::= common_expression column_alias",
 /* 388 */ "select_item ::= common_expression AS column_alias",
 /* 389 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 390 */ "where_clause_opt ::=",
 /* 391 */ "where_clause_opt ::= WHERE search_condition",
 /* 392 */ "partition_by_clause_opt ::=",
 /* 393 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 394 */ "twindow_clause_opt ::=",
 /* 395 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 396 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 397 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 398 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 399 */ "sliding_opt ::=",
 /* 400 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 401 */ "fill_opt ::=",
 /* 402 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 403 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 404 */ "fill_mode ::= NONE",
 /* 405 */ "fill_mode ::= PREV",
 /* 406 */ "fill_mode ::= NULL",
 /* 407 */ "fill_mode ::= LINEAR",
 /* 408 */ "fill_mode ::= NEXT",
 /* 409 */ "group_by_clause_opt ::=",
 /* 410 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 411 */ "group_by_list ::= expression",
 /* 412 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 413 */ "having_clause_opt ::=",
 /* 414 */ "having_clause_opt ::= HAVING search_condition",
 /* 415 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 416 */ "query_expression_body ::= query_primary",
 /* 417 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 418 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 419 */ "query_primary ::= query_specification",
 /* 420 */ "order_by_clause_opt ::=",
 /* 421 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 422 */ "slimit_clause_opt ::=",
 /* 423 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 424 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 425 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 426 */ "limit_clause_opt ::=",
 /* 427 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 428 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 429 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 430 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 431 */ "search_condition ::= common_expression",
 /* 432 */ "sort_specification_list ::= sort_specification",
 /* 433 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 434 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 435 */ "ordering_specification_opt ::=",
 /* 436 */ "ordering_specification_opt ::= ASC",
 /* 437 */ "ordering_specification_opt ::= DESC",
 /* 438 */ "null_ordering_opt ::=",
 /* 439 */ "null_ordering_opt ::= NULLS FIRST",
 /* 440 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 231: /* cmd */
    case 234: /* literal */
    case 241: /* db_options */
    case 243: /* alter_db_options */
    case 248: /* retention */
    case 249: /* full_table_name */
    case 252: /* table_options */
    case 256: /* alter_table_clause */
    case 257: /* alter_table_options */
    case 260: /* create_subtable_clause */
    case 263: /* drop_table_clause */
    case 266: /* column_def */
    case 269: /* col_name */
    case 270: /* db_name_cond_opt */
    case 271: /* like_pattern_opt */
    case 272: /* table_name_cond */
    case 273: /* from_db_opt */
    case 274: /* func_name */
    case 277: /* index_options */
    case 279: /* duration_literal */
    case 280: /* sliding_opt */
    case 281: /* func */
    case 284: /* topic_options */
    case 285: /* query_expression */
    case 287: /* explain_options */
    case 291: /* stream_options */
    case 292: /* into_opt */
    case 294: /* signed */
    case 295: /* signed_literal */
    case 298: /* expression */
    case 299: /* pseudo_column */
    case 300: /* column_reference */
    case 301: /* function_expression */
    case 302: /* subquery */
    case 307: /* star_func_para */
    case 308: /* predicate */
    case 311: /* in_predicate_value */
    case 312: /* boolean_value_expression */
    case 313: /* boolean_primary */
    case 314: /* common_expression */
    case 315: /* from_clause */
    case 316: /* table_reference_list */
    case 317: /* table_reference */
    case 318: /* table_primary */
    case 319: /* joined_table */
    case 321: /* parenthesized_joined_table */
    case 323: /* search_condition */
    case 324: /* query_specification */
    case 327: /* where_clause_opt */
    case 329: /* twindow_clause_opt */
    case 331: /* having_clause_opt */
    case 333: /* select_item */
    case 334: /* fill_opt */
    case 337: /* query_expression_body */
    case 339: /* slimit_clause_opt */
    case 340: /* limit_clause_opt */
    case 341: /* query_primary */
    case 343: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy456)); 
}
      break;
    case 232: /* account_options */
    case 233: /* alter_account_options */
    case 235: /* alter_account_option */
    case 289: /* bufsize_opt */
{
 
}
      break;
    case 236: /* user_name */
    case 237: /* dnode_endpoint */
    case 238: /* dnode_host_name */
    case 240: /* db_name */
    case 258: /* column_name */
    case 265: /* table_name */
    case 275: /* function_name */
    case 276: /* index_name */
    case 283: /* topic_name */
    case 290: /* stream_name */
    case 296: /* table_alias */
    case 297: /* column_alias */
    case 303: /* star_func */
    case 305: /* noarg_func */
    case 320: /* alias_opt */
{
 
}
      break;
    case 239: /* not_exists_opt */
    case 242: /* exists_opt */
    case 286: /* analyze_opt */
    case 288: /* agg_func_opt */
    case 325: /* set_quantifier_opt */
{
 
}
      break;
    case 244: /* integer_list */
    case 245: /* variable_list */
    case 246: /* retention_list */
    case 250: /* column_def_list */
    case 251: /* tags_def_opt */
    case 253: /* multi_create_clause */
    case 254: /* tags_def */
    case 255: /* multi_drop_clause */
    case 261: /* specific_tags_opt */
    case 262: /* literal_list */
    case 264: /* col_name_list */
    case 267: /* func_name_list */
    case 278: /* func_list */
    case 282: /* expression_list */
    case 293: /* dnode_list */
    case 304: /* star_func_para_list */
    case 306: /* other_para_list */
    case 326: /* select_list */
    case 328: /* partition_by_clause_opt */
    case 330: /* group_by_clause_opt */
    case 332: /* select_sublist */
    case 336: /* group_by_list */
    case 338: /* order_by_clause_opt */
    case 342: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy652)); 
}
      break;
    case 247: /* alter_db_option */
    case 268: /* alter_table_option */
{
 
}
      break;
    case 259: /* type_name */
{
 
}
      break;
    case 309: /* compare_op */
    case 310: /* in_op */
{
 
}
      break;
    case 322: /* join_type */
{
 
}
      break;
    case 335: /* fill_mode */
{
 
}
      break;
    case 344: /* ordering_specification_opt */
{
 
}
      break;
    case 345: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  231,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  231,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  232,    0 }, /* (2) account_options ::= */
  {  232,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  232,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  232,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  232,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  232,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  232,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  232,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  232,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  232,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  233,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  233,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  235,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  235,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  235,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  235,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  235,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  235,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  235,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  235,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  235,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  235,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  231,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  231,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  231,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  231,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  231,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  231,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  231,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  231,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  231,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  231,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  231,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  231,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  237,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  238,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  238,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  231,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  231,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  231,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  231,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  231,   -2 }, /* (51) cmd ::= USE db_name */
  {  231,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  239,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  239,    0 }, /* (54) not_exists_opt ::= */
  {  242,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  242,    0 }, /* (56) exists_opt ::= */
  {  241,    0 }, /* (57) db_options ::= */
  {  241,   -3 }, /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
  {  241,   -3 }, /* (59) db_options ::= db_options CACHE NK_INTEGER */
  {  241,   -3 }, /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
  {  241,   -3 }, /* (61) db_options ::= db_options COMP NK_INTEGER */
  {  241,   -3 }, /* (62) db_options ::= db_options DAYS NK_INTEGER */
  {  241,   -3 }, /* (63) db_options ::= db_options DAYS NK_VARIABLE */
  {  241,   -3 }, /* (64) db_options ::= db_options FSYNC NK_INTEGER */
  {  241,   -3 }, /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
  {  241,   -3 }, /* (66) db_options ::= db_options MINROWS NK_INTEGER */
  {  241,   -3 }, /* (67) db_options ::= db_options KEEP integer_list */
  {  241,   -3 }, /* (68) db_options ::= db_options KEEP variable_list */
  {  241,   -3 }, /* (69) db_options ::= db_options PRECISION NK_STRING */
  {  241,   -3 }, /* (70) db_options ::= db_options QUORUM NK_INTEGER */
  {  241,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  241,   -3 }, /* (72) db_options ::= db_options TTL NK_INTEGER */
  {  241,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  241,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  241,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  241,   -3 }, /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  241,   -3 }, /* (77) db_options ::= db_options RETENTIONS retention_list */
  {  241,   -3 }, /* (78) db_options ::= db_options STRICT NK_INTEGER */
  {  243,   -1 }, /* (79) alter_db_options ::= alter_db_option */
  {  243,   -2 }, /* (80) alter_db_options ::= alter_db_options alter_db_option */
  {  247,   -2 }, /* (81) alter_db_option ::= BLOCKS NK_INTEGER */
  {  247,   -2 }, /* (82) alter_db_option ::= FSYNC NK_INTEGER */
  {  247,   -2 }, /* (83) alter_db_option ::= KEEP integer_list */
  {  247,   -2 }, /* (84) alter_db_option ::= KEEP variable_list */
  {  247,   -2 }, /* (85) alter_db_option ::= WAL NK_INTEGER */
  {  247,   -2 }, /* (86) alter_db_option ::= QUORUM NK_INTEGER */
  {  247,   -2 }, /* (87) alter_db_option ::= CACHELAST NK_INTEGER */
  {  247,   -2 }, /* (88) alter_db_option ::= REPLICA NK_INTEGER */
  {  247,   -2 }, /* (89) alter_db_option ::= STRICT NK_INTEGER */
  {  244,   -1 }, /* (90) integer_list ::= NK_INTEGER */
  {  244,   -3 }, /* (91) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  245,   -1 }, /* (92) variable_list ::= NK_VARIABLE */
  {  245,   -3 }, /* (93) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  246,   -1 }, /* (94) retention_list ::= retention */
  {  246,   -3 }, /* (95) retention_list ::= retention_list NK_COMMA retention */
  {  248,   -3 }, /* (96) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  231,   -9 }, /* (97) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  231,   -3 }, /* (98) cmd ::= CREATE TABLE multi_create_clause */
  {  231,   -9 }, /* (99) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  231,   -3 }, /* (100) cmd ::= DROP TABLE multi_drop_clause */
  {  231,   -4 }, /* (101) cmd ::= DROP STABLE exists_opt full_table_name */
  {  231,   -3 }, /* (102) cmd ::= ALTER TABLE alter_table_clause */
  {  231,   -3 }, /* (103) cmd ::= ALTER STABLE alter_table_clause */
  {  256,   -2 }, /* (104) alter_table_clause ::= full_table_name alter_table_options */
  {  256,   -5 }, /* (105) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  256,   -4 }, /* (106) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  256,   -5 }, /* (107) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  256,   -5 }, /* (108) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  256,   -5 }, /* (109) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  256,   -4 }, /* (110) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  256,   -5 }, /* (111) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  256,   -5 }, /* (112) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  256,   -6 }, /* (113) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  253,   -1 }, /* (114) multi_create_clause ::= create_subtable_clause */
  {  253,   -2 }, /* (115) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  260,   -9 }, /* (116) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  255,   -1 }, /* (117) multi_drop_clause ::= drop_table_clause */
  {  255,   -2 }, /* (118) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  263,   -2 }, /* (119) drop_table_clause ::= exists_opt full_table_name */
  {  261,    0 }, /* (120) specific_tags_opt ::= */
  {  261,   -3 }, /* (121) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  249,   -1 }, /* (122) full_table_name ::= table_name */
  {  249,   -3 }, /* (123) full_table_name ::= db_name NK_DOT table_name */
  {  250,   -1 }, /* (124) column_def_list ::= column_def */
  {  250,   -3 }, /* (125) column_def_list ::= column_def_list NK_COMMA column_def */
  {  266,   -2 }, /* (126) column_def ::= column_name type_name */
  {  266,   -4 }, /* (127) column_def ::= column_name type_name COMMENT NK_STRING */
  {  259,   -1 }, /* (128) type_name ::= BOOL */
  {  259,   -1 }, /* (129) type_name ::= TINYINT */
  {  259,   -1 }, /* (130) type_name ::= SMALLINT */
  {  259,   -1 }, /* (131) type_name ::= INT */
  {  259,   -1 }, /* (132) type_name ::= INTEGER */
  {  259,   -1 }, /* (133) type_name ::= BIGINT */
  {  259,   -1 }, /* (134) type_name ::= FLOAT */
  {  259,   -1 }, /* (135) type_name ::= DOUBLE */
  {  259,   -4 }, /* (136) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (137) type_name ::= TIMESTAMP */
  {  259,   -4 }, /* (138) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  259,   -2 }, /* (139) type_name ::= TINYINT UNSIGNED */
  {  259,   -2 }, /* (140) type_name ::= SMALLINT UNSIGNED */
  {  259,   -2 }, /* (141) type_name ::= INT UNSIGNED */
  {  259,   -2 }, /* (142) type_name ::= BIGINT UNSIGNED */
  {  259,   -1 }, /* (143) type_name ::= JSON */
  {  259,   -4 }, /* (144) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (145) type_name ::= MEDIUMBLOB */
  {  259,   -1 }, /* (146) type_name ::= BLOB */
  {  259,   -4 }, /* (147) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (148) type_name ::= DECIMAL */
  {  259,   -4 }, /* (149) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  259,   -6 }, /* (150) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  251,    0 }, /* (151) tags_def_opt ::= */
  {  251,   -1 }, /* (152) tags_def_opt ::= tags_def */
  {  254,   -4 }, /* (153) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  252,    0 }, /* (154) table_options ::= */
  {  252,   -3 }, /* (155) table_options ::= table_options COMMENT NK_STRING */
  {  252,   -3 }, /* (156) table_options ::= table_options KEEP integer_list */
  {  252,   -3 }, /* (157) table_options ::= table_options KEEP variable_list */
  {  252,   -3 }, /* (158) table_options ::= table_options TTL NK_INTEGER */
  {  252,   -5 }, /* (159) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  252,   -5 }, /* (160) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  252,   -3 }, /* (161) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  252,   -3 }, /* (162) table_options ::= table_options DELAY NK_INTEGER */
  {  257,   -1 }, /* (163) alter_table_options ::= alter_table_option */
  {  257,   -2 }, /* (164) alter_table_options ::= alter_table_options alter_table_option */
  {  268,   -2 }, /* (165) alter_table_option ::= COMMENT NK_STRING */
  {  268,   -2 }, /* (166) alter_table_option ::= KEEP integer_list */
  {  268,   -2 }, /* (167) alter_table_option ::= KEEP variable_list */
  {  268,   -2 }, /* (168) alter_table_option ::= TTL NK_INTEGER */
  {  264,   -1 }, /* (169) col_name_list ::= col_name */
  {  264,   -3 }, /* (170) col_name_list ::= col_name_list NK_COMMA col_name */
  {  269,   -1 }, /* (171) col_name ::= column_name */
  {  231,   -2 }, /* (172) cmd ::= SHOW DNODES */
  {  231,   -2 }, /* (173) cmd ::= SHOW USERS */
  {  231,   -2 }, /* (174) cmd ::= SHOW DATABASES */
  {  231,   -4 }, /* (175) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  231,   -4 }, /* (176) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  231,   -3 }, /* (177) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  231,   -2 }, /* (178) cmd ::= SHOW MNODES */
  {  231,   -2 }, /* (179) cmd ::= SHOW MODULES */
  {  231,   -2 }, /* (180) cmd ::= SHOW QNODES */
  {  231,   -2 }, /* (181) cmd ::= SHOW FUNCTIONS */
  {  231,   -5 }, /* (182) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  231,   -2 }, /* (183) cmd ::= SHOW STREAMS */
  {  231,   -2 }, /* (184) cmd ::= SHOW ACCOUNTS */
  {  231,   -2 }, /* (185) cmd ::= SHOW APPS */
  {  231,   -2 }, /* (186) cmd ::= SHOW CONNECTIONS */
  {  231,   -2 }, /* (187) cmd ::= SHOW LICENCE */
  {  231,   -2 }, /* (188) cmd ::= SHOW GRANTS */
  {  231,   -4 }, /* (189) cmd ::= SHOW CREATE DATABASE db_name */
  {  231,   -4 }, /* (190) cmd ::= SHOW CREATE TABLE full_table_name */
  {  231,   -4 }, /* (191) cmd ::= SHOW CREATE STABLE full_table_name */
  {  231,   -2 }, /* (192) cmd ::= SHOW QUERIES */
  {  231,   -2 }, /* (193) cmd ::= SHOW SCORES */
  {  231,   -2 }, /* (194) cmd ::= SHOW TOPICS */
  {  231,   -2 }, /* (195) cmd ::= SHOW VARIABLES */
  {  231,   -2 }, /* (196) cmd ::= SHOW BNODES */
  {  231,   -2 }, /* (197) cmd ::= SHOW SNODES */
  {  231,   -2 }, /* (198) cmd ::= SHOW CLUSTER */
  {  270,    0 }, /* (199) db_name_cond_opt ::= */
  {  270,   -2 }, /* (200) db_name_cond_opt ::= db_name NK_DOT */
  {  271,    0 }, /* (201) like_pattern_opt ::= */
  {  271,   -2 }, /* (202) like_pattern_opt ::= LIKE NK_STRING */
  {  272,   -1 }, /* (203) table_name_cond ::= table_name */
  {  273,    0 }, /* (204) from_db_opt ::= */
  {  273,   -2 }, /* (205) from_db_opt ::= FROM db_name */
  {  267,   -1 }, /* (206) func_name_list ::= func_name */
  {  267,   -3 }, /* (207) func_name_list ::= func_name_list NK_COMMA func_name */
  {  274,   -1 }, /* (208) func_name ::= function_name */
  {  231,   -8 }, /* (209) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  231,  -10 }, /* (210) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  231,   -6 }, /* (211) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  277,    0 }, /* (212) index_options ::= */
  {  277,   -9 }, /* (213) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  277,  -11 }, /* (214) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  278,   -1 }, /* (215) func_list ::= func */
  {  278,   -3 }, /* (216) func_list ::= func_list NK_COMMA func */
  {  281,   -4 }, /* (217) func ::= function_name NK_LP expression_list NK_RP */
  {  231,   -7 }, /* (218) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
  {  231,   -7 }, /* (219) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
  {  231,   -4 }, /* (220) cmd ::= DROP TOPIC exists_opt topic_name */
  {  284,    0 }, /* (221) topic_options ::= */
  {  284,   -3 }, /* (222) topic_options ::= topic_options WITH TABLE */
  {  284,   -3 }, /* (223) topic_options ::= topic_options WITH SCHEMA */
  {  284,   -3 }, /* (224) topic_options ::= topic_options WITH TAG */
  {  231,   -2 }, /* (225) cmd ::= DESC full_table_name */
  {  231,   -2 }, /* (226) cmd ::= DESCRIBE full_table_name */
  {  231,   -3 }, /* (227) cmd ::= RESET QUERY CACHE */
  {  231,   -4 }, /* (228) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  286,    0 }, /* (229) analyze_opt ::= */
  {  286,   -1 }, /* (230) analyze_opt ::= ANALYZE */
  {  287,    0 }, /* (231) explain_options ::= */
  {  287,   -3 }, /* (232) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  287,   -3 }, /* (233) explain_options ::= explain_options RATIO NK_FLOAT */
  {  231,   -6 }, /* (234) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  231,  -10 }, /* (235) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  231,   -3 }, /* (236) cmd ::= DROP FUNCTION function_name */
  {  288,    0 }, /* (237) agg_func_opt ::= */
  {  288,   -1 }, /* (238) agg_func_opt ::= AGGREGATE */
  {  289,    0 }, /* (239) bufsize_opt ::= */
  {  289,   -2 }, /* (240) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  231,   -8 }, /* (241) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  231,   -4 }, /* (242) cmd ::= DROP STREAM exists_opt stream_name */
  {  292,    0 }, /* (243) into_opt ::= */
  {  292,   -2 }, /* (244) into_opt ::= INTO full_table_name */
  {  291,    0 }, /* (245) stream_options ::= */
  {  291,   -3 }, /* (246) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  291,   -3 }, /* (247) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  291,   -3 }, /* (248) stream_options ::= stream_options WATERMARK duration_literal */
  {  231,   -3 }, /* (249) cmd ::= KILL CONNECTION NK_INTEGER */
  {  231,   -3 }, /* (250) cmd ::= KILL QUERY NK_INTEGER */
  {  231,   -4 }, /* (251) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  231,   -4 }, /* (252) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  231,   -3 }, /* (253) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  293,   -2 }, /* (254) dnode_list ::= DNODE NK_INTEGER */
  {  293,   -3 }, /* (255) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  231,   -3 }, /* (256) cmd ::= SYNCDB db_name REPLICA */
  {  231,   -1 }, /* (257) cmd ::= query_expression */
  {  234,   -1 }, /* (258) literal ::= NK_INTEGER */
  {  234,   -1 }, /* (259) literal ::= NK_FLOAT */
  {  234,   -1 }, /* (260) literal ::= NK_STRING */
  {  234,   -1 }, /* (261) literal ::= NK_BOOL */
  {  234,   -2 }, /* (262) literal ::= TIMESTAMP NK_STRING */
  {  234,   -1 }, /* (263) literal ::= duration_literal */
  {  234,   -1 }, /* (264) literal ::= NULL */
  {  234,   -1 }, /* (265) literal ::= NK_QUESTION */
  {  279,   -1 }, /* (266) duration_literal ::= NK_VARIABLE */
  {  294,   -1 }, /* (267) signed ::= NK_INTEGER */
  {  294,   -2 }, /* (268) signed ::= NK_PLUS NK_INTEGER */
  {  294,   -2 }, /* (269) signed ::= NK_MINUS NK_INTEGER */
  {  294,   -1 }, /* (270) signed ::= NK_FLOAT */
  {  294,   -2 }, /* (271) signed ::= NK_PLUS NK_FLOAT */
  {  294,   -2 }, /* (272) signed ::= NK_MINUS NK_FLOAT */
  {  295,   -1 }, /* (273) signed_literal ::= signed */
  {  295,   -1 }, /* (274) signed_literal ::= NK_STRING */
  {  295,   -1 }, /* (275) signed_literal ::= NK_BOOL */
  {  295,   -2 }, /* (276) signed_literal ::= TIMESTAMP NK_STRING */
  {  295,   -1 }, /* (277) signed_literal ::= duration_literal */
  {  295,   -1 }, /* (278) signed_literal ::= NULL */
  {  262,   -1 }, /* (279) literal_list ::= signed_literal */
  {  262,   -3 }, /* (280) literal_list ::= literal_list NK_COMMA signed_literal */
  {  240,   -1 }, /* (281) db_name ::= NK_ID */
  {  265,   -1 }, /* (282) table_name ::= NK_ID */
  {  258,   -1 }, /* (283) column_name ::= NK_ID */
  {  275,   -1 }, /* (284) function_name ::= NK_ID */
  {  296,   -1 }, /* (285) table_alias ::= NK_ID */
  {  297,   -1 }, /* (286) column_alias ::= NK_ID */
  {  236,   -1 }, /* (287) user_name ::= NK_ID */
  {  276,   -1 }, /* (288) index_name ::= NK_ID */
  {  283,   -1 }, /* (289) topic_name ::= NK_ID */
  {  290,   -1 }, /* (290) stream_name ::= NK_ID */
  {  298,   -1 }, /* (291) expression ::= literal */
  {  298,   -1 }, /* (292) expression ::= pseudo_column */
  {  298,   -1 }, /* (293) expression ::= column_reference */
  {  298,   -1 }, /* (294) expression ::= function_expression */
  {  298,   -1 }, /* (295) expression ::= subquery */
  {  298,   -3 }, /* (296) expression ::= NK_LP expression NK_RP */
  {  298,   -2 }, /* (297) expression ::= NK_PLUS expression */
  {  298,   -2 }, /* (298) expression ::= NK_MINUS expression */
  {  298,   -3 }, /* (299) expression ::= expression NK_PLUS expression */
  {  298,   -3 }, /* (300) expression ::= expression NK_MINUS expression */
  {  298,   -3 }, /* (301) expression ::= expression NK_STAR expression */
  {  298,   -3 }, /* (302) expression ::= expression NK_SLASH expression */
  {  298,   -3 }, /* (303) expression ::= expression NK_REM expression */
  {  298,   -3 }, /* (304) expression ::= column_reference NK_ARROW NK_STRING */
  {  282,   -1 }, /* (305) expression_list ::= expression */
  {  282,   -3 }, /* (306) expression_list ::= expression_list NK_COMMA expression */
  {  300,   -1 }, /* (307) column_reference ::= column_name */
  {  300,   -3 }, /* (308) column_reference ::= table_name NK_DOT column_name */
  {  299,   -1 }, /* (309) pseudo_column ::= ROWTS */
  {  299,   -1 }, /* (310) pseudo_column ::= TBNAME */
  {  299,   -1 }, /* (311) pseudo_column ::= QSTARTTS */
  {  299,   -1 }, /* (312) pseudo_column ::= QENDTS */
  {  299,   -1 }, /* (313) pseudo_column ::= WSTARTTS */
  {  299,   -1 }, /* (314) pseudo_column ::= WENDTS */
  {  299,   -1 }, /* (315) pseudo_column ::= WDURATION */
  {  301,   -4 }, /* (316) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  301,   -4 }, /* (317) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  301,   -6 }, /* (318) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  301,   -3 }, /* (319) function_expression ::= noarg_func NK_LP NK_RP */
  {  305,   -1 }, /* (320) noarg_func ::= NOW */
  {  305,   -1 }, /* (321) noarg_func ::= TODAY */
  {  305,   -1 }, /* (322) noarg_func ::= TIMEZONE */
  {  303,   -1 }, /* (323) star_func ::= COUNT */
  {  303,   -1 }, /* (324) star_func ::= FIRST */
  {  303,   -1 }, /* (325) star_func ::= LAST */
  {  303,   -1 }, /* (326) star_func ::= LAST_ROW */
  {  304,   -1 }, /* (327) star_func_para_list ::= NK_STAR */
  {  304,   -1 }, /* (328) star_func_para_list ::= other_para_list */
  {  306,   -1 }, /* (329) other_para_list ::= star_func_para */
  {  306,   -3 }, /* (330) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  307,   -1 }, /* (331) star_func_para ::= expression */
  {  307,   -3 }, /* (332) star_func_para ::= table_name NK_DOT NK_STAR */
  {  308,   -3 }, /* (333) predicate ::= expression compare_op expression */
  {  308,   -5 }, /* (334) predicate ::= expression BETWEEN expression AND expression */
  {  308,   -6 }, /* (335) predicate ::= expression NOT BETWEEN expression AND expression */
  {  308,   -3 }, /* (336) predicate ::= expression IS NULL */
  {  308,   -4 }, /* (337) predicate ::= expression IS NOT NULL */
  {  308,   -3 }, /* (338) predicate ::= expression in_op in_predicate_value */
  {  309,   -1 }, /* (339) compare_op ::= NK_LT */
  {  309,   -1 }, /* (340) compare_op ::= NK_GT */
  {  309,   -1 }, /* (341) compare_op ::= NK_LE */
  {  309,   -1 }, /* (342) compare_op ::= NK_GE */
  {  309,   -1 }, /* (343) compare_op ::= NK_NE */
  {  309,   -1 }, /* (344) compare_op ::= NK_EQ */
  {  309,   -1 }, /* (345) compare_op ::= LIKE */
  {  309,   -2 }, /* (346) compare_op ::= NOT LIKE */
  {  309,   -1 }, /* (347) compare_op ::= MATCH */
  {  309,   -1 }, /* (348) compare_op ::= NMATCH */
  {  309,   -1 }, /* (349) compare_op ::= CONTAINS */
  {  310,   -1 }, /* (350) in_op ::= IN */
  {  310,   -2 }, /* (351) in_op ::= NOT IN */
  {  311,   -3 }, /* (352) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  312,   -1 }, /* (353) boolean_value_expression ::= boolean_primary */
  {  312,   -2 }, /* (354) boolean_value_expression ::= NOT boolean_primary */
  {  312,   -3 }, /* (355) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  312,   -3 }, /* (356) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  313,   -1 }, /* (357) boolean_primary ::= predicate */
  {  313,   -3 }, /* (358) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  314,   -1 }, /* (359) common_expression ::= expression */
  {  314,   -1 }, /* (360) common_expression ::= boolean_value_expression */
  {  315,   -2 }, /* (361) from_clause ::= FROM table_reference_list */
  {  316,   -1 }, /* (362) table_reference_list ::= table_reference */
  {  316,   -3 }, /* (363) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  317,   -1 }, /* (364) table_reference ::= table_primary */
  {  317,   -1 }, /* (365) table_reference ::= joined_table */
  {  318,   -2 }, /* (366) table_primary ::= table_name alias_opt */
  {  318,   -4 }, /* (367) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  318,   -2 }, /* (368) table_primary ::= subquery alias_opt */
  {  318,   -1 }, /* (369) table_primary ::= parenthesized_joined_table */
  {  320,    0 }, /* (370) alias_opt ::= */
  {  320,   -1 }, /* (371) alias_opt ::= table_alias */
  {  320,   -2 }, /* (372) alias_opt ::= AS table_alias */
  {  321,   -3 }, /* (373) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  321,   -3 }, /* (374) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  319,   -6 }, /* (375) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  322,    0 }, /* (376) join_type ::= */
  {  322,   -1 }, /* (377) join_type ::= INNER */
  {  324,   -9 }, /* (378) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  325,    0 }, /* (379) set_quantifier_opt ::= */
  {  325,   -1 }, /* (380) set_quantifier_opt ::= DISTINCT */
  {  325,   -1 }, /* (381) set_quantifier_opt ::= ALL */
  {  326,   -1 }, /* (382) select_list ::= NK_STAR */
  {  326,   -1 }, /* (383) select_list ::= select_sublist */
  {  332,   -1 }, /* (384) select_sublist ::= select_item */
  {  332,   -3 }, /* (385) select_sublist ::= select_sublist NK_COMMA select_item */
  {  333,   -1 }, /* (386) select_item ::= common_expression */
  {  333,   -2 }, /* (387) select_item ::= common_expression column_alias */
  {  333,   -3 }, /* (388) select_item ::= common_expression AS column_alias */
  {  333,   -3 }, /* (389) select_item ::= table_name NK_DOT NK_STAR */
  {  327,    0 }, /* (390) where_clause_opt ::= */
  {  327,   -2 }, /* (391) where_clause_opt ::= WHERE search_condition */
  {  328,    0 }, /* (392) partition_by_clause_opt ::= */
  {  328,   -3 }, /* (393) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  329,    0 }, /* (394) twindow_clause_opt ::= */
  {  329,   -6 }, /* (395) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  329,   -4 }, /* (396) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  329,   -6 }, /* (397) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  329,   -8 }, /* (398) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  280,    0 }, /* (399) sliding_opt ::= */
  {  280,   -4 }, /* (400) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  334,    0 }, /* (401) fill_opt ::= */
  {  334,   -4 }, /* (402) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  334,   -6 }, /* (403) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  335,   -1 }, /* (404) fill_mode ::= NONE */
  {  335,   -1 }, /* (405) fill_mode ::= PREV */
  {  335,   -1 }, /* (406) fill_mode ::= NULL */
  {  335,   -1 }, /* (407) fill_mode ::= LINEAR */
  {  335,   -1 }, /* (408) fill_mode ::= NEXT */
  {  330,    0 }, /* (409) group_by_clause_opt ::= */
  {  330,   -3 }, /* (410) group_by_clause_opt ::= GROUP BY group_by_list */
  {  336,   -1 }, /* (411) group_by_list ::= expression */
  {  336,   -3 }, /* (412) group_by_list ::= group_by_list NK_COMMA expression */
  {  331,    0 }, /* (413) having_clause_opt ::= */
  {  331,   -2 }, /* (414) having_clause_opt ::= HAVING search_condition */
  {  285,   -4 }, /* (415) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  337,   -1 }, /* (416) query_expression_body ::= query_primary */
  {  337,   -4 }, /* (417) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  337,   -3 }, /* (418) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  341,   -1 }, /* (419) query_primary ::= query_specification */
  {  338,    0 }, /* (420) order_by_clause_opt ::= */
  {  338,   -3 }, /* (421) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  339,    0 }, /* (422) slimit_clause_opt ::= */
  {  339,   -2 }, /* (423) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  339,   -4 }, /* (424) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  339,   -4 }, /* (425) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  340,    0 }, /* (426) limit_clause_opt ::= */
  {  340,   -2 }, /* (427) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  340,   -4 }, /* (428) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  340,   -4 }, /* (429) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  302,   -3 }, /* (430) subquery ::= NK_LP query_expression NK_RP */
  {  323,   -1 }, /* (431) search_condition ::= common_expression */
  {  342,   -1 }, /* (432) sort_specification_list ::= sort_specification */
  {  342,   -3 }, /* (433) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  343,   -3 }, /* (434) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  344,    0 }, /* (435) ordering_specification_opt ::= */
  {  344,   -1 }, /* (436) ordering_specification_opt ::= ASC */
  {  344,   -1 }, /* (437) ordering_specification_opt ::= DESC */
  {  345,    0 }, /* (438) null_ordering_opt ::= */
  {  345,   -2 }, /* (439) null_ordering_opt ::= NULLS FIRST */
  {  345,   -2 }, /* (440) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,232,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,233,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,232,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,234,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,235,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,233,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,235,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,234,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy517, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy517, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy517); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy517, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy517); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 281: /* db_name ::= NK_ID */ yytestcase(yyruleno==281);
      case 282: /* table_name ::= NK_ID */ yytestcase(yyruleno==282);
      case 283: /* column_name ::= NK_ID */ yytestcase(yyruleno==283);
      case 284: /* function_name ::= NK_ID */ yytestcase(yyruleno==284);
      case 285: /* table_alias ::= NK_ID */ yytestcase(yyruleno==285);
      case 286: /* column_alias ::= NK_ID */ yytestcase(yyruleno==286);
      case 287: /* user_name ::= NK_ID */ yytestcase(yyruleno==287);
      case 288: /* index_name ::= NK_ID */ yytestcase(yyruleno==288);
      case 289: /* topic_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* stream_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 320: /* noarg_func ::= NOW */ yytestcase(yyruleno==320);
      case 321: /* noarg_func ::= TODAY */ yytestcase(yyruleno==321);
      case 322: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==322);
      case 323: /* star_func ::= COUNT */ yytestcase(yyruleno==323);
      case 324: /* star_func ::= FIRST */ yytestcase(yyruleno==324);
      case 325: /* star_func ::= LAST */ yytestcase(yyruleno==325);
      case 326: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==326);
{ yylhsminor.yy517 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy517 = yylhsminor.yy517;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy673, &yymsp[-1].minor.yy517, yymsp[0].minor.yy456); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy673, &yymsp[0].minor.yy517); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy517); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy517, yymsp[0].minor.yy456); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy673 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 229: /* analyze_opt ::= */ yytestcase(yyruleno==229);
      case 237: /* agg_func_opt ::= */ yytestcase(yyruleno==237);
      case 379: /* set_quantifier_opt ::= */ yytestcase(yyruleno==379);
{ yymsp[1].minor.yy673 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy673 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy456 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pKeep = yymsp[0].minor.yy652; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pRetentions = yymsp[0].minor.yy652; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 78: /* db_options ::= db_options STRICT NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy456)->pStrict = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 79: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy456 = createDatabaseOptions(pCxt); yylhsminor.yy456 = setDatabaseAlterOption(pCxt, yylhsminor.yy456, &yymsp[0].minor.yy145); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 80: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy456 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy456, &yymsp[0].minor.yy145); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 81: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 83: /* alter_db_option ::= KEEP integer_list */
      case 84: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==84);
{ yymsp[-1].minor.yy145.type = DB_OPTION_KEEP; yymsp[-1].minor.yy145.pList = yymsp[0].minor.yy652; }
        break;
      case 85: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_WAL; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 89: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_STRICT; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 90: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy652 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 91: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 255: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==255);
{ yylhsminor.yy652 = addNodeToList(pCxt, yymsp[-2].minor.yy652, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 92: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy652 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 93: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy652 = addNodeToList(pCxt, yymsp[-2].minor.yy652, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 94: /* retention_list ::= retention */
      case 114: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==114);
      case 117: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==117);
      case 124: /* column_def_list ::= column_def */ yytestcase(yyruleno==124);
      case 169: /* col_name_list ::= col_name */ yytestcase(yyruleno==169);
      case 206: /* func_name_list ::= func_name */ yytestcase(yyruleno==206);
      case 215: /* func_list ::= func */ yytestcase(yyruleno==215);
      case 279: /* literal_list ::= signed_literal */ yytestcase(yyruleno==279);
      case 329: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==329);
      case 384: /* select_sublist ::= select_item */ yytestcase(yyruleno==384);
      case 432: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==432);
{ yylhsminor.yy652 = createNodeList(pCxt, yymsp[0].minor.yy456); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 95: /* retention_list ::= retention_list NK_COMMA retention */
      case 125: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==125);
      case 170: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==170);
      case 207: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==207);
      case 216: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==216);
      case 280: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==280);
      case 330: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==330);
      case 385: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==385);
      case 433: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==433);
{ yylhsminor.yy652 = addNodeToList(pCxt, yymsp[-2].minor.yy652, yymsp[0].minor.yy456); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 96: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy456 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 97: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 99: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==99);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy673, yymsp[-5].minor.yy456, yymsp[-3].minor.yy652, yymsp[-1].minor.yy652, yymsp[0].minor.yy456); }
        break;
      case 98: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy652); }
        break;
      case 100: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy652); }
        break;
      case 101: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy673, yymsp[0].minor.yy456); }
        break;
      case 102: /* cmd ::= ALTER TABLE alter_table_clause */
      case 103: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==103);
      case 257: /* cmd ::= query_expression */ yytestcase(yyruleno==257);
{ pCxt->pRootNode = yymsp[0].minor.yy456; }
        break;
      case 104: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy456 = createAlterTableOption(pCxt, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 105: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy517, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 106: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy456 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy456, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy517); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 107: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy517, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 108: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy456 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy517, &yymsp[0].minor.yy517); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 109: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy517, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 110: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy456 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy456, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy517); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 111: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy456 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy517, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 112: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy456 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy456, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy517, &yymsp[0].minor.yy517); }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 113: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy456 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy456, &yymsp[-2].minor.yy517, yymsp[0].minor.yy456); }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 115: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 118: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==118);
{ yylhsminor.yy652 = addNodeToList(pCxt, yymsp[-1].minor.yy652, yymsp[0].minor.yy456); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 116: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy456 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy673, yymsp[-7].minor.yy456, yymsp[-5].minor.yy456, yymsp[-4].minor.yy652, yymsp[-1].minor.yy652); }
  yymsp[-8].minor.yy456 = yylhsminor.yy456;
        break;
      case 119: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy456 = createDropTableClause(pCxt, yymsp[-1].minor.yy673, yymsp[0].minor.yy456); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 120: /* specific_tags_opt ::= */
      case 151: /* tags_def_opt ::= */ yytestcase(yyruleno==151);
      case 392: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==392);
      case 409: /* group_by_clause_opt ::= */ yytestcase(yyruleno==409);
      case 420: /* order_by_clause_opt ::= */ yytestcase(yyruleno==420);
{ yymsp[1].minor.yy652 = NULL; }
        break;
      case 121: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy652 = yymsp[-1].minor.yy652; }
        break;
      case 122: /* full_table_name ::= table_name */
{ yylhsminor.yy456 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy517, NULL); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 123: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy456 = createRealTableNode(pCxt, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy517, NULL); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 126: /* column_def ::= column_name type_name */
{ yylhsminor.yy456 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy517, yymsp[0].minor.yy380, NULL); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 127: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy456 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy517, yymsp[-2].minor.yy380, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 128: /* type_name ::= BOOL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 129: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 130: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 131: /* type_name ::= INT */
      case 132: /* type_name ::= INTEGER */ yytestcase(yyruleno==132);
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 133: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 134: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 135: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 136: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 138: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 139: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 140: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 141: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 142: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 143: /* type_name ::= JSON */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 144: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 145: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 146: /* type_name ::= BLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 147: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 149: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 152: /* tags_def_opt ::= tags_def */
      case 328: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==328);
      case 383: /* select_list ::= select_sublist */ yytestcase(yyruleno==383);
{ yylhsminor.yy652 = yymsp[0].minor.yy652; }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 153: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy652 = yymsp[-1].minor.yy652; }
        break;
      case 154: /* table_options ::= */
{ yymsp[1].minor.yy456 = createTableOptions(pCxt); }
        break;
      case 155: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 156: /* table_options ::= table_options KEEP integer_list */
      case 157: /* table_options ::= table_options KEEP variable_list */ yytestcase(yyruleno==157);
{ ((STableOptions*)yymsp[-2].minor.yy456)->pKeep = yymsp[0].minor.yy652; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 158: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 159: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy456)->pSma = yymsp[-1].minor.yy652; yylhsminor.yy456 = yymsp[-4].minor.yy456; }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 160: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy456)->pFuncs = yymsp[-1].minor.yy652; yylhsminor.yy456 = yymsp[-4].minor.yy456; }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 161: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 162: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy456)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 163: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy456 = createTableOptions(pCxt); yylhsminor.yy456 = setTableAlterOption(pCxt, yylhsminor.yy456, &yymsp[0].minor.yy145); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 164: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy456 = setTableAlterOption(pCxt, yymsp[-1].minor.yy456, &yymsp[0].minor.yy145); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 165: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy145.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 166: /* alter_table_option ::= KEEP integer_list */
      case 167: /* alter_table_option ::= KEEP variable_list */ yytestcase(yyruleno==167);
{ yymsp[-1].minor.yy145.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy145.pList = yymsp[0].minor.yy652; }
        break;
      case 168: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy145.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy145.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 171: /* col_name ::= column_name */
{ yylhsminor.yy456 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy517); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 172: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 173: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 176: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 177: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy456, NULL); }
        break;
      case 178: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 181: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 183: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 185: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW LICENCE */
      case 188: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==188);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy517); }
        break;
      case 190: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy456); }
        break;
      case 191: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy456); }
        break;
      case 192: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 195: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 196: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 199: /* db_name_cond_opt ::= */
      case 204: /* from_db_opt ::= */ yytestcase(yyruleno==204);
{ yymsp[1].minor.yy456 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 200: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy517); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 201: /* like_pattern_opt ::= */
      case 212: /* index_options ::= */ yytestcase(yyruleno==212);
      case 243: /* into_opt ::= */ yytestcase(yyruleno==243);
      case 390: /* where_clause_opt ::= */ yytestcase(yyruleno==390);
      case 394: /* twindow_clause_opt ::= */ yytestcase(yyruleno==394);
      case 399: /* sliding_opt ::= */ yytestcase(yyruleno==399);
      case 401: /* fill_opt ::= */ yytestcase(yyruleno==401);
      case 413: /* having_clause_opt ::= */ yytestcase(yyruleno==413);
      case 422: /* slimit_clause_opt ::= */ yytestcase(yyruleno==422);
      case 426: /* limit_clause_opt ::= */ yytestcase(yyruleno==426);
{ yymsp[1].minor.yy456 = NULL; }
        break;
      case 202: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 203: /* table_name_cond ::= table_name */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy517); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 205: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy517); }
        break;
      case 208: /* func_name ::= function_name */
{ yylhsminor.yy456 = createFunctionNode(pCxt, &yymsp[0].minor.yy517, NULL); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 209: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy673, &yymsp[-3].minor.yy517, &yymsp[-1].minor.yy517, NULL, yymsp[0].minor.yy456); }
        break;
      case 210: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy673, &yymsp[-5].minor.yy517, &yymsp[-3].minor.yy517, yymsp[-1].minor.yy652, NULL); }
        break;
      case 211: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy673, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy517); }
        break;
      case 213: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy456 = createIndexOption(pCxt, yymsp[-6].minor.yy652, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), NULL, yymsp[0].minor.yy456); }
        break;
      case 214: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy456 = createIndexOption(pCxt, yymsp[-8].minor.yy652, releaseRawExprNode(pCxt, yymsp[-4].minor.yy456), releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), yymsp[0].minor.yy456); }
        break;
      case 217: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy456 = createFunctionNode(pCxt, &yymsp[-3].minor.yy517, yymsp[-1].minor.yy652); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 218: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy673, &yymsp[-3].minor.yy517, yymsp[0].minor.yy456, NULL, yymsp[-2].minor.yy456); }
        break;
      case 219: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy673, &yymsp[-3].minor.yy517, NULL, &yymsp[0].minor.yy517, yymsp[-2].minor.yy456); }
        break;
      case 220: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy673, &yymsp[0].minor.yy517); }
        break;
      case 221: /* topic_options ::= */
{ yymsp[1].minor.yy456 = createTopicOptions(pCxt); }
        break;
      case 222: /* topic_options ::= topic_options WITH TABLE */
{ ((STopicOptions*)yymsp[-2].minor.yy456)->withTable = true; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 223: /* topic_options ::= topic_options WITH SCHEMA */
{ ((STopicOptions*)yymsp[-2].minor.yy456)->withSchema = true; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 224: /* topic_options ::= topic_options WITH TAG */
{ ((STopicOptions*)yymsp[-2].minor.yy456)->withTag = true; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 225: /* cmd ::= DESC full_table_name */
      case 226: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==226);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy456); }
        break;
      case 227: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 228: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy673, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 230: /* analyze_opt ::= ANALYZE */
      case 238: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==238);
      case 380: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==380);
{ yymsp[0].minor.yy673 = true; }
        break;
      case 231: /* explain_options ::= */
{ yymsp[1].minor.yy456 = createDefaultExplainOptions(pCxt); }
        break;
      case 232: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy456 = setExplainVerbose(pCxt, yymsp[-2].minor.yy456, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 233: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy456 = setExplainRatio(pCxt, yymsp[-2].minor.yy456, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 234: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy652); }
        break;
      case 235: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy673, yymsp[-8].minor.yy673, &yymsp[-5].minor.yy517, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy380, yymsp[0].minor.yy376); }
        break;
      case 236: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy517); }
        break;
      case 239: /* bufsize_opt ::= */
{ yymsp[1].minor.yy376 = 0; }
        break;
      case 240: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy376 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 241: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy673, &yymsp[-4].minor.yy517, yymsp[-2].minor.yy456, yymsp[-3].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 242: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy673, &yymsp[0].minor.yy517); }
        break;
      case 244: /* into_opt ::= INTO full_table_name */
      case 361: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==361);
      case 391: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==391);
      case 414: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==414);
{ yymsp[-1].minor.yy456 = yymsp[0].minor.yy456; }
        break;
      case 245: /* stream_options ::= */
{ yymsp[1].minor.yy456 = createStreamOptions(pCxt); }
        break;
      case 246: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy456)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 247: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy456)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 248: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy456)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy456); yylhsminor.yy456 = yymsp[-2].minor.yy456; }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 249: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 250: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 251: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 252: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy652); }
        break;
      case 253: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 254: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy652 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 256: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy517); }
        break;
      case 258: /* literal ::= NK_INTEGER */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 259: /* literal ::= NK_FLOAT */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 260: /* literal ::= NK_STRING */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 261: /* literal ::= NK_BOOL */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 262: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 263: /* literal ::= duration_literal */
      case 273: /* signed_literal ::= signed */ yytestcase(yyruleno==273);
      case 291: /* expression ::= literal */ yytestcase(yyruleno==291);
      case 292: /* expression ::= pseudo_column */ yytestcase(yyruleno==292);
      case 293: /* expression ::= column_reference */ yytestcase(yyruleno==293);
      case 294: /* expression ::= function_expression */ yytestcase(yyruleno==294);
      case 295: /* expression ::= subquery */ yytestcase(yyruleno==295);
      case 353: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==353);
      case 357: /* boolean_primary ::= predicate */ yytestcase(yyruleno==357);
      case 359: /* common_expression ::= expression */ yytestcase(yyruleno==359);
      case 360: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==360);
      case 362: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==362);
      case 364: /* table_reference ::= table_primary */ yytestcase(yyruleno==364);
      case 365: /* table_reference ::= joined_table */ yytestcase(yyruleno==365);
      case 369: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==369);
      case 416: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==416);
      case 419: /* query_primary ::= query_specification */ yytestcase(yyruleno==419);
{ yylhsminor.yy456 = yymsp[0].minor.yy456; }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 264: /* literal ::= NULL */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 265: /* literal ::= NK_QUESTION */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 266: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 267: /* signed ::= NK_INTEGER */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 268: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 269: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 270: /* signed ::= NK_FLOAT */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 271: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 272: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 274: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 275: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 276: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 277: /* signed_literal ::= duration_literal */
      case 331: /* star_func_para ::= expression */ yytestcase(yyruleno==331);
      case 386: /* select_item ::= common_expression */ yytestcase(yyruleno==386);
      case 431: /* search_condition ::= common_expression */ yytestcase(yyruleno==431);
{ yylhsminor.yy456 = releaseRawExprNode(pCxt, yymsp[0].minor.yy456); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 278: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy456 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 296: /* expression ::= NK_LP expression NK_RP */
      case 358: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==358);
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 297: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy456));
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 298: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy456), NULL));
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 299: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 300: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 301: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 302: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 303: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 304: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 305: /* expression_list ::= expression */
{ yylhsminor.yy652 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy456)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 306: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy652 = addNodeToList(pCxt, yymsp[-2].minor.yy652, releaseRawExprNode(pCxt, yymsp[0].minor.yy456)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 307: /* column_reference ::= column_name */
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy517, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy517)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 308: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy517, createColumnNode(pCxt, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy517)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 309: /* pseudo_column ::= ROWTS */
      case 310: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==310);
      case 311: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==311);
      case 312: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==312);
      case 313: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==313);
      case 314: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==314);
      case 315: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==315);
{ yylhsminor.yy456 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy456 = yylhsminor.yy456;
        break;
      case 316: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 317: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==317);
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy517, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy517, yymsp[-1].minor.yy652)); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 318: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), yymsp[-1].minor.yy380)); }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 319: /* function_expression ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy0, createFunctionNodeNoArg(pCxt, &yymsp[-2].minor.yy517)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 327: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy652 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 332: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 389: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==389);
{ yylhsminor.yy456 = createColumnNode(pCxt, &yymsp[-2].minor.yy517, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 333: /* predicate ::= expression compare_op expression */
      case 338: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==338);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy348, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 334: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy456), releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-4].minor.yy456 = yylhsminor.yy456;
        break;
      case 335: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy456), releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 336: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), NULL));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 337: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), NULL));
                                                                                  }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 339: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy348 = OP_TYPE_LOWER_THAN; }
        break;
      case 340: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy348 = OP_TYPE_GREATER_THAN; }
        break;
      case 341: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy348 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 342: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy348 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 343: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy348 = OP_TYPE_NOT_EQUAL; }
        break;
      case 344: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy348 = OP_TYPE_EQUAL; }
        break;
      case 345: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy348 = OP_TYPE_LIKE; }
        break;
      case 346: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy348 = OP_TYPE_NOT_LIKE; }
        break;
      case 347: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy348 = OP_TYPE_MATCH; }
        break;
      case 348: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy348 = OP_TYPE_NMATCH; }
        break;
      case 349: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy348 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 350: /* in_op ::= IN */
{ yymsp[0].minor.yy348 = OP_TYPE_IN; }
        break;
      case 351: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy348 = OP_TYPE_NOT_IN; }
        break;
      case 352: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy652)); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 354: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy456), NULL));
                                                                                  }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 355: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 356: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy456);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy456);
                                                                                    yylhsminor.yy456 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), releaseRawExprNode(pCxt, yymsp[0].minor.yy456)));
                                                                                  }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 363: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy456 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy456, yymsp[0].minor.yy456, NULL); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 366: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy456 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy517, &yymsp[0].minor.yy517); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 367: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy456 = createRealTableNode(pCxt, &yymsp[-3].minor.yy517, &yymsp[-1].minor.yy517, &yymsp[0].minor.yy517); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 368: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy456 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456), &yymsp[0].minor.yy517); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 370: /* alias_opt ::= */
{ yymsp[1].minor.yy517 = nil_token;  }
        break;
      case 371: /* alias_opt ::= table_alias */
{ yylhsminor.yy517 = yymsp[0].minor.yy517; }
  yymsp[0].minor.yy517 = yylhsminor.yy517;
        break;
      case 372: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy517 = yymsp[0].minor.yy517; }
        break;
      case 373: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 374: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==374);
{ yymsp[-2].minor.yy456 = yymsp[-1].minor.yy456; }
        break;
      case 375: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy456 = createJoinTableNode(pCxt, yymsp[-4].minor.yy684, yymsp[-5].minor.yy456, yymsp[-2].minor.yy456, yymsp[0].minor.yy456); }
  yymsp[-5].minor.yy456 = yylhsminor.yy456;
        break;
      case 376: /* join_type ::= */
{ yymsp[1].minor.yy684 = JOIN_TYPE_INNER; }
        break;
      case 377: /* join_type ::= INNER */
{ yymsp[0].minor.yy684 = JOIN_TYPE_INNER; }
        break;
      case 378: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy456 = createSelectStmt(pCxt, yymsp[-7].minor.yy673, yymsp[-6].minor.yy652, yymsp[-5].minor.yy456);
                                                                                    yymsp[-8].minor.yy456 = addWhereClause(pCxt, yymsp[-8].minor.yy456, yymsp[-4].minor.yy456);
                                                                                    yymsp[-8].minor.yy456 = addPartitionByClause(pCxt, yymsp[-8].minor.yy456, yymsp[-3].minor.yy652);
                                                                                    yymsp[-8].minor.yy456 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy456, yymsp[-2].minor.yy456);
                                                                                    yymsp[-8].minor.yy456 = addGroupByClause(pCxt, yymsp[-8].minor.yy456, yymsp[-1].minor.yy652);
                                                                                    yymsp[-8].minor.yy456 = addHavingClause(pCxt, yymsp[-8].minor.yy456, yymsp[0].minor.yy456);
                                                                                  }
        break;
      case 381: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy673 = false; }
        break;
      case 382: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy652 = NULL; }
        break;
      case 387: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy456 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456), &yymsp[0].minor.yy517); }
  yymsp[-1].minor.yy456 = yylhsminor.yy456;
        break;
      case 388: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy456 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), &yymsp[0].minor.yy517); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 393: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 410: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==410);
      case 421: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==421);
{ yymsp[-2].minor.yy652 = yymsp[0].minor.yy652; }
        break;
      case 395: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy456 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), releaseRawExprNode(pCxt, yymsp[-1].minor.yy456)); }
        break;
      case 396: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy456 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy456)); }
        break;
      case 397: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy456 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), NULL, yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 398: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy456 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy456), releaseRawExprNode(pCxt, yymsp[-3].minor.yy456), yymsp[-1].minor.yy456, yymsp[0].minor.yy456); }
        break;
      case 400: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy456 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy456); }
        break;
      case 402: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy456 = createFillNode(pCxt, yymsp[-1].minor.yy534, NULL); }
        break;
      case 403: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy456 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy652)); }
        break;
      case 404: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy534 = FILL_MODE_NONE; }
        break;
      case 405: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy534 = FILL_MODE_PREV; }
        break;
      case 406: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy534 = FILL_MODE_NULL; }
        break;
      case 407: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy534 = FILL_MODE_LINEAR; }
        break;
      case 408: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy534 = FILL_MODE_NEXT; }
        break;
      case 411: /* group_by_list ::= expression */
{ yylhsminor.yy652 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 412: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy652 = addNodeToList(pCxt, yymsp[-2].minor.yy652, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy456))); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 415: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy456 = addOrderByClause(pCxt, yymsp[-3].minor.yy456, yymsp[-2].minor.yy652);
                                                                                    yylhsminor.yy456 = addSlimitClause(pCxt, yylhsminor.yy456, yymsp[-1].minor.yy456);
                                                                                    yylhsminor.yy456 = addLimitClause(pCxt, yylhsminor.yy456, yymsp[0].minor.yy456);
                                                                                  }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 417: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy456 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy456, yymsp[0].minor.yy456); }
  yymsp[-3].minor.yy456 = yylhsminor.yy456;
        break;
      case 418: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy456 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy456, yymsp[0].minor.yy456); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 423: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 427: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==427);
{ yymsp[-1].minor.yy456 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 424: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 428: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==428);
{ yymsp[-3].minor.yy456 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 425: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 429: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==429);
{ yymsp[-3].minor.yy456 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 430: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy456 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy456); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 434: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy456 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy456), yymsp[-1].minor.yy250, yymsp[0].minor.yy645); }
  yymsp[-2].minor.yy456 = yylhsminor.yy456;
        break;
      case 435: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy250 = ORDER_ASC; }
        break;
      case 436: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy250 = ORDER_ASC; }
        break;
      case 437: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy250 = ORDER_DESC; }
        break;
      case 438: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy645 = NULL_ORDER_DEFAULT; }
        break;
      case 439: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy645 = NULL_ORDER_FIRST; }
        break;
      case 440: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy645 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
