/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 359
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy28;
  int32_t yy42;
  ENullOrder yy107;
  EFillMode yy320;
  SToken yy421;
  SNodeList* yy530;
  SAlterOption yy557;
  EOrder yy610;
  bool yy621;
  EJoinType yy636;
  int64_t yy669;
  SNode* yy674;
  SDataType yy690;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             622
#define YYNRULE              459
#define YYNTOKEN             239
#define YY_MAX_SHIFT         621
#define YY_MIN_SHIFTREDUCE   912
#define YY_MAX_SHIFTREDUCE   1370
#define YY_ERROR_ACTION      1371
#define YY_ACCEPT_ACTION     1372
#define YY_NO_ACTION         1373
#define YY_MIN_REDUCE        1374
#define YY_MAX_REDUCE        1832
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2098)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1557,  321, 1679, 1666, 1550, 1552,  300,  396, 1666,  397,
 /*    10 */  1406,  317,   35,   33, 1663,  404, 1556,  397, 1406, 1663,
 /*    20 */   309, 1483, 1184, 1557,   36,   34,   32,   31,   30, 1695,
 /*    30 */   299,  536,   36,   34,   32,   31,   30,  521, 1810, 1555,
 /*    40 */  1659, 1665, 1649, 1810,  520, 1659, 1665, 1182,   28,  233,
 /*    50 */  1809,  540,  362, 1372, 1807,  150,  540,  501,   14, 1807,
 /*    60 */    35,   33, 1311,  395, 1190, 1679,  399,  536,  309, 1708,
 /*    70 */  1184,  159,   82, 1680,  523, 1682, 1683,  519,  414,  540,
 /*    80 */    57,    1, 1748,  536,  401, 1810,  283, 1744,  497,  281,
 /*    90 */  1206,  537, 1695,  537, 1325, 1182,   62, 1808, 1810,   61,
 /*   100 */   521, 1807,  106,  618,  154, 1649,   14,  520,  942,  435,
 /*   110 */   151,  326, 1190,   24, 1807,  414,  114, 1253, 1254, 1505,
 /*   120 */   501, 1505,  356,   36,   34,   32,   31,   30,   39,    2,
 /*   130 */   134,  497, 1708, 1695, 1462,   82, 1680,  523, 1682, 1683,
 /*   140 */   519,  490,  540,  524,   38, 1748,  946,  947, 1318,  283,
 /*   150 */  1744,  618, 1810, 1600, 1208,  112,  196,   56, 1185,  114,
 /*   160 */  1183, 1810, 1208, 1810,  149, 1253, 1254,  130, 1807,  499,
 /*   170 */   146, 1755, 1756,  149, 1760,  149,  574, 1807,  489, 1807,
 /*   180 */   508,  486, 1188, 1189,  347, 1235, 1236, 1238, 1239, 1240,
 /*   190 */  1241, 1242,  516,  538, 1250, 1251, 1252, 1255,  112,   36,
 /*   200 */    34,   32,   31,   30,  349,  345, 1185,  133, 1183, 1386,
 /*   210 */   152,   66,  282,  147, 1755, 1756, 1209, 1760,  524,   35,
 /*   220 */    33,   36,   34,   32,   31,   30,  312,  309, 1599, 1184,
 /*   230 */  1188, 1189, 1375, 1235, 1236, 1238, 1239, 1240, 1241, 1242,
 /*   240 */   516,  538, 1250, 1251, 1252, 1255,   36,   34,   32,   31,
 /*   250 */    30,  492,  487,   96, 1182,   73,   95,   94,   93,   92,
 /*   260 */    91,   90,   89,   88,   87,   14,  491,   35,   33, 1222,
 /*   270 */    26, 1190, 1433,  152, 1496,  309, 1498, 1184, 1193,   56,
 /*   280 */    36,   34,   32,   31,   30, 1663,  152,  403,    2, 1335,
 /*   290 */   399, 1049,  563,  562,  561, 1053,  560, 1055, 1056,  559,
 /*   300 */  1058,  556, 1182, 1064,  553, 1066, 1067,  550,  547, 1261,
 /*   310 */   618, 1659, 1665, 1091, 1092, 1208,   32,   31,   30, 1190,
 /*   320 */  1237,  589,  540, 1397, 1253, 1254,  483, 1333, 1334, 1336,
 /*   330 */  1337, 1209,  596,  595,  594,  324,    8,  593,  592,  591,
 /*   340 */   116,  586,  585,  584,  583,  582,  581,  580,  579,  124,
 /*   350 */   575, 1436,  578,  313, 1477,  355,   56,  354,  618, 1367,
 /*   360 */  1207,  131,  350, 1649,  572, 1185, 1396, 1183,  509, 1395,
 /*   370 */  1507,   96, 1253, 1254,   95,   94,   93,   92,   91,   90,
 /*   380 */    89,   88,   87,  122,  121,  569,  568,  567,   64, 1188,
 /*   390 */  1189, 1196, 1235, 1236, 1238, 1239, 1240, 1241, 1242,  516,
 /*   400 */   538, 1250, 1251, 1252, 1255,  497, 1649,  537,  152, 1649,
 /*   410 */  1501,  449,  448, 1185, 1557, 1183,  447, 1394,  360,  111,
 /*   420 */   444,  314, 1393,  443,  442,  441,   35,   33, 1256,  570,
 /*   430 */  1555, 1679, 1548,  114,  309, 1505, 1184, 1188, 1189, 1366,
 /*   440 */  1235, 1236, 1238, 1239, 1240, 1241, 1242,  516,  538, 1250,
 /*   450 */  1251, 1252, 1255, 1392, 1184,  449,  448, 1649, 1695, 1391,
 /*   460 */   447, 1182, 1649,  111,  444,  152,  521,  443,  442,  441,
 /*   470 */   197, 1649,  112,  520,   35,   33, 1551, 1552, 1190, 1182,
 /*   480 */  1190, 1237,  309, 1679, 1184,  152,  537,  148, 1755, 1756,
 /*   490 */   293, 1760,  959, 1649,  958,    9, 1190,  361, 1708, 1649,
 /*   500 */    64,   84, 1680,  523, 1682, 1683,  519, 1390,  540, 1182,
 /*   510 */  1695, 1748,  203,  110, 1505, 1747, 1744,  618,  500,  433,
 /*   520 */   473,  960, 1500, 1649,  571,  520, 1190, 1548, 1166, 1167,
 /*   530 */   187, 1253, 1254,  185,  537,  618,  316,  315,   56,  294,
 /*   540 */    67,  292,  291,    9,  437,  106, 1198, 1649,  439, 1482,
 /*   550 */  1708, 1310,  440,   83, 1680,  523, 1682, 1683,  519, 1011,
 /*   560 */   540, 1810, 1505, 1748,  959,  618,  958,  302, 1744,  145,
 /*   570 */   438, 1191, 1185,  149, 1183,  463, 1013, 1807, 1557, 1253,
 /*   580 */  1254,  225,  446,  445,  537,  320,  479, 1775, 1190,  386,
 /*   590 */  1185,    7, 1183,  960, 1555,  371, 1188, 1189, 1208, 1235,
 /*   600 */  1236, 1238, 1239, 1240, 1241, 1242,  516,  538, 1250, 1251,
 /*   610 */  1252, 1255, 1505,  319, 1188, 1189, 1810, 1275,  946,  947,
 /*   620 */  1185,  131, 1183,  322,  144,   79, 1389,  541,  149, 1388,
 /*   630 */  1507,  131, 1807,   35,   33,  163,  162, 1544,  115, 1280,
 /*   640 */  1507,  309,  572, 1184, 1188, 1189, 1497, 1235, 1236, 1238,
 /*   650 */  1239, 1240, 1241, 1242,  516,  538, 1250, 1251, 1252, 1255,
 /*   660 */  1385,  122,  121,  569,  568,  567, 1649,  152, 1182, 1649,
 /*   670 */   537, 1384,   11,   10,   25, 1667, 1383,  537,  280,   54,
 /*   680 */  1206,  372, 1199, 1762, 1194, 1190, 1663,  379,  413, 1382,
 /*   690 */   391,   36,   34,   32,   31,   30,  590,  588, 1505,  537,
 /*   700 */  1649, 1679,    2, 1210,  132, 1505, 1202, 1759,  392,  262,
 /*   710 */  1502, 1649, 1659, 1665, 1192, 1381, 1649,  538, 1250, 1251,
 /*   720 */  1374,  260,   53,  540,  618,   52, 1380, 1505, 1695, 1649,
 /*   730 */  1379,  256, 1762, 1762, 1535,  505,  521,  284, 1253, 1254,
 /*   740 */  1480, 1649,  164,  520,  105,  104,  103,  102,  101,  100,
 /*   750 */    99,   98,   97, 1287,  480, 1649, 1758, 1757, 1309, 1767,
 /*   760 */  1306, 1222, 1378, 1306, 1237,  566, 1649,   56, 1708, 1273,
 /*   770 */  1649,  278, 1680,  523, 1682, 1683,  519,  577,  540, 1185,
 /*   780 */   390, 1183, 1481,  385,  384,  383,  382,  381,  378,  377,
 /*   790 */   376,  375,  374,  370,  369,  368,  367,  366,  365,  364,
 /*   800 */   363, 1211, 1649, 1188, 1189,   81, 1235, 1236, 1238, 1239,
 /*   810 */  1240, 1241, 1242,  516,  538, 1250, 1251, 1252, 1255,  131,
 /*   820 */  1274,  537,   36,   34,   32,   31,   30, 1195, 1508,  537,
 /*   830 */   224, 1637, 1626,  572,  537, 1377,   60,   59,  359,  574,
 /*   840 */   471,  158, 1279,  189,  513,  534,  188,  353,  191, 1505,
 /*   850 */   439,  190,  122,  121,  569,  568,  567, 1505,  279,  537,
 /*   860 */   537,  343, 1505,  341,  337,  333,  155,  328,  284, 1494,
 /*   870 */   535,  246,  438, 1423, 1490, 1649,  335,   27,  307, 1268,
 /*   880 */  1269, 1270, 1271, 1272, 1276, 1277, 1278, 1505, 1505, 1418,
 /*   890 */  1679, 1590,  537, 1416,  193,  450,  152,  192, 1669,  461,
 /*   900 */  1273,  503,  161,  323,  120,  621,   46,  983,  212, 1369,
 /*   910 */  1370,  452,  459,   11,   10,  455,   78, 1695,   37,  251,
 /*   920 */  1505,  506, 1492, 1488,  984,  500,   75,  200,  209,  515,
 /*   930 */  1649,  142,  520,  565,  182, 1671,   37,  612,  608,  604,
 /*   940 */   600,  250,  470, 1387,   37,  475,  137, 1332,  235,  214,
 /*   950 */   118, 1274,  431,  427,  423,  419,  181, 1708,  228, 1281,
 /*   960 */    83, 1680,  523, 1682, 1683,  519,   80,  540, 1265,  244,
 /*   970 */  1748,  484, 1463, 1279,  302, 1744,  145, 1243,  119,  120,
 /*   980 */    46,   65,  545,  119,  179, 1139,  120,  107, 1412,  237,
 /*   990 */   464,  529,  119,  432, 1776, 1696,  219,  325, 1407, 1545,
 /*  1000 */  1778,  498,  533,    3, 1679,    5,  227,  230,   27,  307,
 /*  1010 */  1268, 1269, 1270, 1271, 1272, 1276, 1277, 1278,  327,  243,
 /*  1020 */  1042,  255, 1206, 1070, 1074,  232,  330, 1081, 1079,  478,
 /*  1030 */  1679, 1695,  205,  123,  614,  334,  289, 1150, 1011,  521,
 /*  1040 */   290,  252,  380,  178, 1649,  170,  520,  175,  373,  409,
 /*  1050 */  1592, 1158,  160,  199,  388,  387, 1679, 1695,  389, 1212,
 /*  1060 */   393,  394,  402, 1215,  405,  521,  167,  406,  168,  169,
 /*  1070 */  1649, 1708,  520, 1214,   83, 1680,  523, 1682, 1683,  519,
 /*  1080 */   407,  540, 1216, 1695, 1748,  408,  172,  410,  302, 1744,
 /*  1090 */  1823,  521,  174, 1213,  412,  177, 1649, 1708,  520, 1782,
 /*  1100 */    83, 1680,  523, 1682, 1683,  519,  411,  540, 1679,   63,
 /*  1110 */  1748,  415,  180,  434,  302, 1744, 1823,  436, 1495,  184,
 /*  1120 */  1491,  186, 1679, 1708,  125, 1805,   83, 1680,  523, 1682,
 /*  1130 */  1683,  519,  298,  540,   86, 1695, 1748,  126,  198, 1493,
 /*  1140 */   302, 1744, 1823,  521, 1489,  127, 1631,  253, 1649, 1695,
 /*  1150 */   520, 1766,  128, 1630,  472,  465,  469,  521, 1211,  466,
 /*  1160 */   527,  201, 1649,  501,  520,  204,  207,  476,  485,  477,
 /*  1170 */   474, 1789, 1779, 1679,  482, 1708,  301,  501,  269, 1680,
 /*  1180 */   523, 1682, 1683,  519,  210,  540,  488, 1788,    6, 1708,
 /*  1190 */   454,  213,  269, 1680,  523, 1682, 1683,  519,  494,  540,
 /*  1200 */  1695, 1306, 1769,  220, 1810,  462,  481,  113,  521, 1210,
 /*  1210 */  1763,   40,  510, 1649,  303,  520,  151,   18, 1810,  195,
 /*  1220 */  1807, 1598,  507,  530,  531,  218,  525, 1597,  221,  526,
 /*  1230 */   149,  457,  239,  241, 1807,  311,  451, 1679,  139,  532,
 /*  1240 */  1708,  194, 1826,   84, 1680,  523, 1682, 1683,  519, 1729,
 /*  1250 */   540, 1679,  254, 1748,   72, 1806, 1506,  512, 1744,  504,
 /*  1260 */  1679,  511,   74,  226, 1695, 1478,   51,  543,  229,   50,
 /*  1270 */   231,  257,  518,  617,  249,   47,  138, 1649, 1695,  520,
 /*  1280 */  1549,  261,  263,  270,  264,  259,  521, 1695, 1643, 1642,
 /*  1290 */    58, 1649, 1641,  520,  329,  521, 1638,  332,  331, 1177,
 /*  1300 */  1649, 1178,  520,  156, 1708,  336, 1636,  277, 1680,  523,
 /*  1310 */  1682, 1683,  519,  517,  540,  514, 1720, 1679, 1708,  338,
 /*  1320 */   339,  135, 1680,  523, 1682, 1683,  519, 1708,  540,  340,
 /*  1330 */    84, 1680,  523, 1682, 1683,  519, 1635,  540,  342, 1679,
 /*  1340 */  1748, 1634,  344, 1633, 1695, 1745,  346, 1632,  348, 1616,
 /*  1350 */   157,  351,  521,  352, 1153, 1152, 1610, 1649, 1609,  520,
 /*  1360 */   357,  358, 1608, 1607,  502, 1824, 1695, 1125, 1585, 1584,
 /*  1370 */  1583, 1582, 1581, 1580,  521, 1579, 1578, 1577, 1576, 1649,
 /*  1380 */  1575,  520, 1574, 1573, 1708, 1572, 1571,  273, 1680,  523,
 /*  1390 */  1682, 1683,  519, 1679,  540, 1570, 1569, 1568, 1567,  117,
 /*  1400 */  1566, 1565, 1564, 1563, 1562, 1679, 1708, 1561, 1560,  135,
 /*  1410 */  1680,  523, 1682, 1683,  519, 1127,  540, 1559, 1558, 1435,
 /*  1420 */  1695, 1403,  143,  949,  493,  108,  948,  165,  521, 1402,
 /*  1430 */  1624, 1618, 1695, 1649,  398,  520,  400,  166, 1606,  173,
 /*  1440 */   518, 1605,  109, 1595, 1484, 1649,  306,  520,  171, 1434,
 /*  1450 */   176, 1432,  418, 1825, 1430, 1428, 1679,  422, 1426,  426,
 /*  1460 */  1708,  416,  430,  278, 1680,  523, 1682, 1683,  519,  977,
 /*  1470 */   540,  417, 1708,  421,  420,  277, 1680,  523, 1682, 1683,
 /*  1480 */   519,  424,  540, 1695, 1721,  425,  428,  429, 1415, 1414,
 /*  1490 */  1401,  521, 1486, 1085, 1084, 1485, 1649, 1010,  520, 1009,
 /*  1500 */  1008,  587,  589, 1007, 1004, 1424,   45, 1679,  295,  308,
 /*  1510 */  1003,  183, 1002, 1419,  453,  296, 1417,  456,  297, 1400,
 /*  1520 */   458, 1679, 1399, 1708,  460, 1623,  278, 1680,  523, 1682,
 /*  1530 */  1683,  519,   85,  540, 1695, 1617,   49,  467, 1160, 1604,
 /*  1540 */  1603, 1602,  521,  129, 1594,   68,  206, 1649, 1695,  520,
 /*  1550 */   211,    4,   37,   15,  136,   43,  521, 1331,  215,   22,
 /*  1560 */   310, 1649, 1324,  520,  216,  217,   69,   23, 1669,   16,
 /*  1570 */  1679,  468,  223,   41, 1708,  208,  202,  278, 1680,  523,
 /*  1580 */  1682, 1683,  519,   48,  540, 1303, 1302, 1679, 1708,   42,
 /*  1590 */   140,  265, 1680,  523, 1682, 1683,  519, 1695,  540, 1360,
 /*  1600 */    17, 1355, 1349, 1354,   10,  521,   19,  304, 1359, 1358,
 /*  1610 */  1649,  305,  520, 1245, 1695,   29,  141,  153, 1244, 1266,
 /*  1620 */   234, 1230,  521,   12,   20, 1593,   21, 1649,  236,  520,
 /*  1630 */   240, 1329,  522,  238,   70, 1668, 1679, 1708,  245,  528,
 /*  1640 */   272, 1680,  523, 1682, 1683,  519,   75,  540, 1679,   13,
 /*  1650 */    71, 1711, 1200, 1247, 1708,  539,   44,  274, 1680,  523,
 /*  1660 */  1682, 1683,  519, 1695,  540, 1071,  544,  318,  542,  242,
 /*  1670 */   546,  521, 1068,  548, 1065, 1695, 1649,  549,  520,  551,
 /*  1680 */   554,  552,  555,  521,  557, 1059, 1057,  558, 1649, 1679,
 /*  1690 */   520, 1063, 1062, 1048,   76,   77, 1080,   55,  564,  247,
 /*  1700 */  1061, 1076, 1060, 1708,  975,  573,  266, 1680,  523, 1682,
 /*  1710 */  1683,  519,  999,  540, 1017, 1708, 1695,  576,  275, 1680,
 /*  1720 */   523, 1682, 1683,  519,  521,  540,  248,  997,  996, 1649,
 /*  1730 */   995,  520,  992,  994,  993,  991,  990, 1014, 1012,  987,
 /*  1740 */   986, 1679,  985,  982,  981,  980, 1431,  597,  598,  599,
 /*  1750 */  1679, 1429,  601,  602, 1427,  603, 1708, 1425,  605,  267,
 /*  1760 */  1680,  523, 1682, 1683,  519,  606,  540,  607, 1695,  609,
 /*  1770 */   610,  611, 1413,  613, 1398,  615,  521, 1695, 1186,  616,
 /*  1780 */   619, 1649,  258,  520,  620,  521, 1373, 1373, 1373, 1373,
 /*  1790 */  1649, 1373,  520, 1373, 1373, 1373, 1373, 1373, 1373, 1679,
 /*  1800 */  1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1708, 1373,
 /*  1810 */  1373,  276, 1680,  523, 1682, 1683,  519, 1708,  540, 1373,
 /*  1820 */   268, 1680,  523, 1682, 1683,  519, 1695,  540, 1373, 1373,
 /*  1830 */  1373, 1373, 1373, 1373,  521, 1373, 1373,  497, 1373, 1649,
 /*  1840 */  1679,  520, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
 /*  1850 */  1373, 1373, 1373, 1373, 1373, 1373, 1373, 1679, 1373, 1373,
 /*  1860 */  1373, 1373, 1373, 1373, 1373,  114, 1708, 1695, 1373, 1691,
 /*  1870 */  1680,  523, 1682, 1683,  519,  521,  540, 1373, 1373, 1373,
 /*  1880 */  1649, 1373,  520, 1373, 1695,  501, 1373, 1373, 1373, 1373,
 /*  1890 */  1373, 1373,  521, 1373, 1373, 1373, 1373, 1649, 1373,  520,
 /*  1900 */  1373, 1373, 1373, 1373,  112, 1373, 1679, 1708, 1373, 1373,
 /*  1910 */  1690, 1680,  523, 1682, 1683,  519, 1373,  540, 1679,  222,
 /*  1920 */  1755,  496, 1373,  495, 1708, 1373, 1810, 1689, 1680,  523,
 /*  1930 */  1682, 1683,  519, 1695,  540, 1373, 1373, 1373,  151,  497,
 /*  1940 */  1373,  521, 1807, 1373, 1373, 1695, 1649, 1373,  520, 1373,
 /*  1950 */  1373, 1373, 1373,  521, 1373, 1373, 1373, 1373, 1649, 1679,
 /*  1960 */   520, 1373, 1373, 1373, 1373, 1373, 1373,  114, 1373, 1373,
 /*  1970 */  1373, 1373, 1373, 1708, 1373, 1373,  287, 1680,  523, 1682,
 /*  1980 */  1683,  519, 1373,  540, 1373, 1708, 1695,  501,  286, 1680,
 /*  1990 */   523, 1682, 1683,  519,  521,  540, 1373, 1373, 1373, 1649,
 /*  2000 */  1373,  520, 1373, 1373, 1373, 1373,  112, 1373, 1373, 1373,
 /*  2010 */  1373, 1679, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
 /*  2020 */  1679,  222, 1755,  496, 1373,  495, 1708, 1373, 1810,  288,
 /*  2030 */  1680,  523, 1682, 1683,  519, 1373,  540, 1373, 1695, 1373,
 /*  2040 */   149, 1373, 1373, 1373, 1807, 1373,  521, 1695, 1373, 1373,
 /*  2050 */  1373, 1649, 1373,  520, 1373,  521, 1373, 1373, 1373, 1373,
 /*  2060 */  1649, 1373,  520, 1373, 1373, 1373, 1373, 1373, 1373, 1373,
 /*  2070 */  1373, 1373, 1373, 1373, 1373, 1373, 1373, 1373, 1708, 1373,
 /*  2080 */  1373,  285, 1680,  523, 1682, 1683,  519, 1708,  540, 1373,
 /*  2090 */   271, 1680,  523, 1682, 1683,  519, 1373,  540,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   269,  280,  242,  271,  283,  284,  274,  245,  271,  247,
 /*    10 */   248,  274,   12,   13,  282,  245,  285,  247,  248,  282,
 /*    20 */    20,    0,   22,  269,   12,   13,   14,   15,   16,  269,
 /*    30 */   276,   20,   12,   13,   14,   15,   16,  277,  338,  285,
 /*    40 */   308,  309,  282,  338,  284,  308,  309,   47,  323,  324,
 /*    50 */   350,  319,  249,  239,  354,  350,  319,  297,   58,  354,
 /*    60 */    12,   13,   14,  246,   64,  242,  249,   20,   20,  309,
 /*    70 */    22,   55,  312,  313,  314,  315,  316,  317,   57,  319,
 /*    80 */     4,   81,  322,   20,   14,  338,  326,  327,  249,  286,
 /*    90 */    20,  249,  269,  249,   82,   47,   80,  350,  338,   83,
 /*   100 */   277,  354,  260,  103,  260,  282,   58,  284,    4,  267,
 /*   110 */   350,  297,   64,    2,  354,   57,  277,  117,  118,  277,
 /*   120 */   297,  277,  297,   12,   13,   14,   15,   16,   81,   81,
 /*   130 */   254,  249,  309,  269,  258,  312,  313,  314,  315,  316,
 /*   140 */   317,  277,  319,  284,   81,  322,   42,   43,   14,  326,
 /*   150 */   327,  103,  338,  294,   20,  316,  113,   81,  158,  277,
 /*   160 */   160,  338,   20,  338,  350,  117,  118,  147,  354,  330,
 /*   170 */   331,  332,  333,  350,  335,  350,   57,  354,  314,  354,
 /*   180 */    41,  145,  182,  183,  153,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  316,   12,
 /*   200 */    13,   14,   15,   16,  173,  174,  158,  241,  160,  243,
 /*   210 */   210,  168,  169,  331,  332,  333,   20,  335,  284,   12,
 /*   220 */    13,   12,   13,   14,   15,   16,  292,   20,  294,   22,
 /*   230 */   182,  183,    0,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,   12,   13,   14,   15,
 /*   250 */    16,  215,  216,   21,   47,  251,   24,   25,   26,   27,
 /*   260 */    28,   29,   30,   31,   32,   58,   20,   12,   13,   82,
 /*   270 */     2,   64,    0,  210,  271,   20,  272,   22,   47,   81,
 /*   280 */    12,   13,   14,   15,   16,  282,  210,  246,   81,  182,
 /*   290 */   249,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   300 */   103,  104,   47,  106,  107,  108,  109,  110,  111,   14,
 /*   310 */   103,  308,  309,  117,  118,   20,   14,   15,   16,   64,
 /*   320 */   186,   41,  319,  242,  117,  118,  219,  220,  221,  222,
 /*   330 */   223,   20,   60,   61,   62,   63,   81,   65,   66,   67,
 /*   340 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   350 */    78,    0,  257,  261,  259,  157,   81,  159,  103,  150,
 /*   360 */    20,  269,   82,  282,   93,  158,  242,  160,  229,  242,
 /*   370 */   278,   21,  117,  118,   24,   25,   26,   27,   28,   29,
 /*   380 */    30,   31,   32,  112,  113,  114,  115,  116,  253,  182,
 /*   390 */   183,  160,  185,  186,  187,  188,  189,  190,  191,  192,
 /*   400 */   193,  194,  195,  196,  197,  249,  282,  249,  210,  282,
 /*   410 */   275,   60,   61,  158,  269,  160,   65,  242,  260,   68,
 /*   420 */    69,  276,  242,   72,   73,   74,   12,   13,   14,  279,
 /*   430 */   285,  242,  282,  277,   20,  277,   22,  182,  183,  230,
 /*   440 */   185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
 /*   450 */   195,  196,  197,  242,   22,   60,   61,  282,  269,  242,
 /*   460 */    65,   47,  282,   68,   69,  210,  277,   72,   73,   74,
 /*   470 */   112,  282,  316,  284,   12,   13,  283,  284,   64,   47,
 /*   480 */    64,  186,   20,  242,   22,  210,  249,  331,  332,  333,
 /*   490 */    35,  335,   20,  282,   22,   81,   64,  260,  309,  282,
 /*   500 */   253,  312,  313,  314,  315,  316,  317,  242,  319,   47,
 /*   510 */   269,  322,   55,  266,  277,  326,  327,  103,  277,   47,
 /*   520 */   297,   49,  275,  282,  279,  284,   64,  282,  170,  171,
 /*   530 */    85,  117,  118,   88,  249,  103,   12,   13,   81,   84,
 /*   540 */    83,   86,   87,   81,   89,  260,   22,  282,   93,    0,
 /*   550 */   309,    4,  267,  312,  313,  314,  315,  316,  317,   47,
 /*   560 */   319,  338,  277,  322,   20,  103,   22,  326,  327,  328,
 /*   570 */   115,   47,  158,  350,  160,  297,   64,  354,  269,  117,
 /*   580 */   118,  340,  255,  256,  249,  276,  345,  346,   64,   75,
 /*   590 */   158,   37,  160,   49,  285,  260,  182,  183,   20,  185,
 /*   600 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   610 */   196,  197,  277,  261,  182,  183,  338,  141,   42,   43,
 /*   620 */   158,  269,  160,  261,  268,  251,  242,  103,  350,  242,
 /*   630 */   278,  269,  354,   12,   13,  121,  122,  281,  264,  163,
 /*   640 */   278,   20,   93,   22,  182,  183,  272,  185,  186,  187,
 /*   650 */   188,  189,  190,  191,  192,  193,  194,  195,  196,  197,
 /*   660 */   242,  112,  113,  114,  115,  116,  282,  210,   47,  282,
 /*   670 */   249,  242,    1,    2,  198,  271,  242,  249,   18,    3,
 /*   680 */    20,  260,  158,  310,  160,   64,  282,   27,  260,  242,
 /*   690 */    30,   12,   13,   14,   15,   16,  255,  256,  277,  249,
 /*   700 */   282,  242,   81,   20,   18,  277,  182,  334,   48,   23,
 /*   710 */   260,  282,  308,  309,   47,  242,  282,  193,  194,  195,
 /*   720 */     0,   35,   36,  319,  103,   39,  242,  277,  269,  282,
 /*   730 */   242,  262,  310,  310,  265,   41,  277,   58,  117,  118,
 /*   740 */     0,  282,   56,  284,   24,   25,   26,   27,   28,   29,
 /*   750 */    30,   31,   32,   82,  295,  282,  334,  334,  211,  208,
 /*   760 */   209,   82,  242,  209,  186,   92,  282,   81,  309,   90,
 /*   770 */   282,  312,  313,  314,  315,  316,  317,   64,  319,  158,
 /*   780 */   120,  160,    0,  123,  124,  125,  126,  127,  128,  129,
 /*   790 */   130,  131,  132,  133,  134,  135,  136,  137,  138,  139,
 /*   800 */   140,   20,  282,  182,  183,  119,  185,  186,  187,  188,
 /*   810 */   189,  190,  191,  192,  193,  194,  195,  196,  197,  269,
 /*   820 */   141,  249,   12,   13,   14,   15,   16,  160,  278,  249,
 /*   830 */   147,    0,  260,   93,  249,  242,  150,  151,  152,   57,
 /*   840 */   260,  155,  163,   85,   58,  260,   88,  161,   85,  277,
 /*   850 */    93,   88,  112,  113,  114,  115,  116,  277,  172,  249,
 /*   860 */   249,  175,  277,  177,  178,  179,  180,  181,   58,  270,
 /*   870 */   260,  260,  115,    0,  270,  282,   45,  198,  199,  200,
 /*   880 */   201,  202,  203,  204,  205,  206,  207,  277,  277,    0,
 /*   890 */   242,  277,  249,    0,   85,   22,  210,   88,   44,   21,
 /*   900 */    90,  225,  288,  260,   41,   19,   41,   47,   41,  117,
 /*   910 */   118,   22,   34,    1,    2,   22,   81,  269,   41,   33,
 /*   920 */   277,  227,  270,  270,   64,  277,   91,  270,  147,  270,
 /*   930 */   282,   45,  284,  270,   33,   81,   41,   51,   52,   53,
 /*   940 */    54,   55,  301,  243,   41,   82,   45,   82,   41,   82,
 /*   950 */    41,  141,   51,   52,   53,   54,   55,  309,  357,   82,
 /*   960 */   312,  313,  314,  315,  316,  317,   80,  319,  182,   83,
 /*   970 */   322,  348,  258,  163,  326,  327,  328,   82,   41,   41,
 /*   980 */    41,   80,   41,   41,   83,   82,   41,   41,    0,   82,
 /*   990 */   305,   82,   41,  250,  346,  269,  342,  250,  248,  281,
 /*  1000 */   311,  336,  116,  339,  242,  212,  351,  351,  198,  199,
 /*  1010 */   200,  201,  202,  203,  204,  205,  206,  207,  307,   82,
 /*  1020 */    82,   82,   20,   82,   82,  351,  249,   82,   82,  143,
 /*  1030 */   242,  269,  146,   82,   46,   45,  306,  156,   47,  277,
 /*  1040 */   255,  299,  289,  142,  282,  144,  284,  146,  249,  148,
 /*  1050 */   249,  165,   40,  167,  141,  287,  242,  269,  287,   20,
 /*  1060 */   249,  244,  244,   20,  303,  277,  253,  284,  167,  253,
 /*  1070 */   282,  309,  284,   20,  312,  313,  314,  315,  316,  317,
 /*  1080 */   296,  319,   20,  269,  322,  298,  253,  296,  326,  327,
 /*  1090 */   328,  277,  253,   20,  290,  253,  282,  309,  284,  337,
 /*  1100 */   312,  313,  314,  315,  316,  317,  277,  319,  242,  253,
 /*  1110 */   322,  249,  253,  244,  326,  327,  328,  269,  269,  269,
 /*  1120 */   269,  269,  242,  309,  269,  337,  312,  313,  314,  315,
 /*  1130 */   316,  317,  244,  319,  249,  269,  322,  269,  251,  269,
 /*  1140 */   326,  327,  328,  277,  269,  269,  282,  303,  282,  269,
 /*  1150 */   284,  337,  269,  282,  249,  166,  284,  277,   20,  302,
 /*  1160 */   217,  251,  282,  297,  284,  251,  251,  277,  218,  290,
 /*  1170 */   296,  347,  311,  242,  282,  309,  282,  297,  312,  313,
 /*  1180 */   314,  315,  316,  317,  293,  319,  282,  347,  224,  309,
 /*  1190 */     4,  293,  312,  313,  314,  315,  316,  317,  149,  319,
 /*  1200 */   269,  209,  344,  307,  338,   19,  213,  277,  277,   20,
 /*  1210 */   310,   40,  228,  282,  231,  284,  350,   81,  338,   33,
 /*  1220 */   354,  293,  226,  144,  291,  343,  282,  293,  329,  282,
 /*  1230 */   350,   45,  277,  251,  354,  282,   50,  242,  341,  290,
 /*  1240 */   309,   55,  358,  312,  313,  314,  315,  316,  317,  325,
 /*  1250 */   319,  242,  265,  322,  251,  353,  277,  326,  327,  353,
 /*  1260 */   242,  353,   81,  352,  269,  259,   80,  273,  352,   83,
 /*  1270 */   352,  249,  277,  244,  251,  300,  304,  282,  269,  284,
 /*  1280 */   282,  240,  263,  263,  263,  252,  277,  269,    0,    0,
 /*  1290 */    40,  282,    0,  284,   72,  277,    0,  176,   47,   47,
 /*  1300 */   282,   47,  284,   47,  309,  176,    0,  312,  313,  314,
 /*  1310 */   315,  316,  317,  318,  319,  320,  321,  242,  309,   47,
 /*  1320 */    47,  312,  313,  314,  315,  316,  317,  309,  319,  176,
 /*  1330 */   312,  313,  314,  315,  316,  317,    0,  319,  176,  242,
 /*  1340 */   322,    0,   47,    0,  269,  327,   22,    0,   47,    0,
 /*  1350 */    81,  163,  277,  162,  160,  158,    0,  282,    0,  284,
 /*  1360 */   154,  153,    0,    0,  355,  356,  269,   44,    0,    0,
 /*  1370 */     0,    0,    0,    0,  277,    0,    0,    0,    0,  282,
 /*  1380 */     0,  284,    0,    0,  309,    0,    0,  312,  313,  314,
 /*  1390 */   315,  316,  317,  242,  319,    0,    0,    0,    0,   40,
 /*  1400 */     0,    0,    0,    0,    0,  242,  309,    0,    0,  312,
 /*  1410 */   313,  314,  315,  316,  317,   22,  319,    0,    0,    0,
 /*  1420 */   269,    0,   41,   14,  349,   37,   14,   40,  277,    0,
 /*  1430 */     0,    0,  269,  282,   44,  284,   44,   38,    0,  149,
 /*  1440 */   277,    0,   37,    0,    0,  282,  295,  284,   37,    0,
 /*  1450 */    37,    0,   37,  356,    0,    0,  242,   37,    0,   37,
 /*  1460 */   309,   47,   37,  312,  313,  314,  315,  316,  317,   59,
 /*  1470 */   319,   45,  309,   45,   47,  312,  313,  314,  315,  316,
 /*  1480 */   317,   47,  319,  269,  321,   45,   47,   45,    0,    0,
 /*  1490 */     0,  277,    0,   47,   22,    0,  282,   47,  284,   47,
 /*  1500 */    47,   41,   41,   47,   47,    0,   90,  242,   22,  295,
 /*  1510 */    47,   88,   47,    0,   48,   22,    0,   47,   22,    0,
 /*  1520 */    22,  242,    0,  309,   22,    0,  312,  313,  314,  315,
 /*  1530 */   316,  317,   20,  319,  269,    0,  147,   22,   47,    0,
 /*  1540 */     0,    0,  277,  164,    0,   81,   37,  282,  269,  284,
 /*  1550 */    82,   41,   41,  214,   81,   41,  277,   82,   81,   81,
 /*  1560 */   295,  282,   82,  284,   41,   44,   81,   41,   44,  214,
 /*  1570 */   242,  147,   44,  208,  309,  142,  144,  312,  313,  314,
 /*  1580 */   315,  316,  317,  147,  319,   82,   82,  242,  309,   41,
 /*  1590 */    44,  312,  313,  314,  315,  316,  317,  269,  319,   82,
 /*  1600 */    41,   47,   82,   47,    2,  277,   41,   47,   47,   47,
 /*  1610 */   282,   47,  284,   82,  269,   81,   44,   44,   82,  182,
 /*  1620 */    82,   22,  277,   81,   81,    0,   81,  282,   81,  284,
 /*  1630 */    37,   82,  184,   81,   81,   44,  242,  309,   44,  145,
 /*  1640 */   312,  313,  314,  315,  316,  317,   91,  319,  242,  214,
 /*  1650 */    81,   81,   22,   82,  309,   81,   81,  312,  313,  314,
 /*  1660 */   315,  316,  317,  269,  319,   82,   47,   47,   92,  142,
 /*  1670 */    81,  277,   82,   47,   82,  269,  282,   81,  284,   47,
 /*  1680 */    47,   81,   81,  277,   47,   82,   82,   81,  282,  242,
 /*  1690 */   284,  105,  105,   22,   81,   81,   47,   81,   93,   41,
 /*  1700 */   105,   22,  105,  309,   59,   58,  312,  313,  314,  315,
 /*  1710 */   316,  317,   47,  319,   64,  309,  269,   79,  312,  313,
 /*  1720 */   314,  315,  316,  317,  277,  319,   41,   47,   47,  282,
 /*  1730 */    47,  284,   22,   47,   47,   47,   47,   64,   47,   47,
 /*  1740 */    47,  242,   47,   47,   47,   47,    0,   47,   45,   37,
 /*  1750 */   242,    0,   47,   45,    0,   37,  309,    0,   47,  312,
 /*  1760 */   313,  314,  315,  316,  317,   45,  319,   37,  269,   47,
 /*  1770 */    45,   37,    0,   47,    0,   22,  277,  269,   22,   21,
 /*  1780 */    21,  282,   22,  284,   20,  277,  359,  359,  359,  359,
 /*  1790 */   282,  359,  284,  359,  359,  359,  359,  359,  359,  242,
 /*  1800 */   359,  359,  359,  359,  359,  359,  359,  359,  309,  359,
 /*  1810 */   359,  312,  313,  314,  315,  316,  317,  309,  319,  359,
 /*  1820 */   312,  313,  314,  315,  316,  317,  269,  319,  359,  359,
 /*  1830 */   359,  359,  359,  359,  277,  359,  359,  249,  359,  282,
 /*  1840 */   242,  284,  359,  359,  359,  359,  359,  359,  359,  359,
 /*  1850 */   359,  359,  359,  359,  359,  359,  359,  242,  359,  359,
 /*  1860 */   359,  359,  359,  359,  359,  277,  309,  269,  359,  312,
 /*  1870 */   313,  314,  315,  316,  317,  277,  319,  359,  359,  359,
 /*  1880 */   282,  359,  284,  359,  269,  297,  359,  359,  359,  359,
 /*  1890 */   359,  359,  277,  359,  359,  359,  359,  282,  359,  284,
 /*  1900 */   359,  359,  359,  359,  316,  359,  242,  309,  359,  359,
 /*  1910 */   312,  313,  314,  315,  316,  317,  359,  319,  242,  331,
 /*  1920 */   332,  333,  359,  335,  309,  359,  338,  312,  313,  314,
 /*  1930 */   315,  316,  317,  269,  319,  359,  359,  359,  350,  249,
 /*  1940 */   359,  277,  354,  359,  359,  269,  282,  359,  284,  359,
 /*  1950 */   359,  359,  359,  277,  359,  359,  359,  359,  282,  242,
 /*  1960 */   284,  359,  359,  359,  359,  359,  359,  277,  359,  359,
 /*  1970 */   359,  359,  359,  309,  359,  359,  312,  313,  314,  315,
 /*  1980 */   316,  317,  359,  319,  359,  309,  269,  297,  312,  313,
 /*  1990 */   314,  315,  316,  317,  277,  319,  359,  359,  359,  282,
 /*  2000 */   359,  284,  359,  359,  359,  359,  316,  359,  359,  359,
 /*  2010 */   359,  242,  359,  359,  359,  359,  359,  359,  359,  359,
 /*  2020 */   242,  331,  332,  333,  359,  335,  309,  359,  338,  312,
 /*  2030 */   313,  314,  315,  316,  317,  359,  319,  359,  269,  359,
 /*  2040 */   350,  359,  359,  359,  354,  359,  277,  269,  359,  359,
 /*  2050 */   359,  282,  359,  284,  359,  277,  359,  359,  359,  359,
 /*  2060 */   282,  359,  284,  359,  359,  359,  359,  359,  359,  359,
 /*  2070 */   359,  359,  359,  359,  359,  359,  359,  359,  309,  359,
 /*  2080 */   359,  312,  313,  314,  315,  316,  317,  309,  319,  359,
 /*  2090 */   312,  313,  314,  315,  316,  317,  359,  319,
};
#define YY_SHIFT_COUNT    (621)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1774)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   686,    0,    0,   48,  207,  207,  207,  207,  255,  255,
 /*    10 */   207,  207,  414,  462,  621,  462,  462,  462,  462,  462,
 /*    20 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*    30 */   462,  462,  462,  462,  462,  462,  462,  462,   63,   63,
 /*    40 */    47,   47,   47,  524,  524,  524,  524,  198,  457,  275,
 /*    50 */    11,   11,  104,  104,   76,  196,  275,  275,   11,   11,
 /*    60 */    11,   11,   11,   11,   11,   58,   11,   11,  142,  246,
 /*    70 */   311,  142,   11,   11,  142,   11,  142,  142,  142,   11,
 /*    80 */   119,  660,  679,  810,  810,  350,  395,  432,  432,  432,
 /*    90 */   432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
 /*   100 */   432,  432,  432,  432,  432,  432,  455,  196,   70,   70,
 /*   110 */    21,  512,  683,  683,  683,  782,  512,  340,  311,  142,
 /*   120 */   142,  416,  416,  673,  713,  197,  197,  197,  197,  197,
 /*   130 */   197,  197,  886,  232,  351,  209,  107,  472,   43,   36,
 /*   140 */   134,  295,  544,  576,  757,  781,  551,  554,  551,  676,
 /*   150 */   676,  676,  547,  578,  793, 1002,  990,  991,  881, 1002,
 /*   160 */  1002, 1012,  913,  913, 1002, 1039, 1039, 1043,   58,  311,
 /*   170 */    58, 1053, 1062,   58, 1053,   58,  340, 1073,   58,   58,
 /*   180 */  1002,   58, 1039,  142,  142,  142,  142,  142,  142,  142,
 /*   190 */   142,  142,  142,  142, 1002, 1039,  416,  416, 1043,  119,
 /*   200 */   989,  311,  119, 1002, 1053,  119,  340, 1073,  119, 1138,
 /*   210 */   950,  943,  416,  950,  943,  416,  416,  142,  964, 1049,
 /*   220 */   993,  793,  992,  340, 1189, 1171,  984,  996,  983,  984,
 /*   230 */   996,  984,  996, 1136,  943,  416,  416,  943,  416, 1079,
 /*   240 */   340, 1073,  119,  673,  119,  340, 1181,  416,  713, 1002,
 /*   250 */   119, 1039, 2098, 2098, 2098, 2098, 2098, 2098, 2098,  272,
 /*   260 */   901,  720, 1186,  549,  740,   12,  111,  268,   20,  187,
 /*   270 */   271,  234,  234,  234,  234,  234,  234,  234,  234,   31,
 /*   280 */    16,  514,  358,  671,  476,  302,  302,  302,  302,  831,
 /*   290 */   280,  445,  758,  763,  809,  873,  889,  893,  878,  863,
 /*   300 */   865,  867,  912,  792,  694,  139,  877,  786,  895,  854,
 /*   310 */   903,  907,  909,  937,  938,  231,  667,  939,  941,  942,
 /*   320 */   945,  946,  951,  835,  860,  988, 1288, 1289, 1250, 1292,
 /*   330 */  1222, 1296, 1251, 1121, 1252, 1254, 1256, 1129, 1306, 1272,
 /*   340 */  1273, 1153, 1336, 1162, 1341, 1295, 1343, 1324, 1347, 1301,
 /*   350 */  1349, 1269, 1188, 1191, 1194, 1197, 1356, 1358, 1206, 1208,
 /*   360 */  1362, 1363, 1323, 1368, 1369, 1370, 1371, 1372, 1373, 1375,
 /*   370 */  1376, 1377, 1378, 1380, 1382, 1383, 1385, 1386, 1395, 1396,
 /*   380 */  1397, 1359, 1398, 1400, 1401, 1402, 1403, 1404, 1393, 1407,
 /*   390 */  1408, 1417, 1418, 1419, 1421, 1387, 1388, 1381, 1409, 1390,
 /*   400 */  1412, 1392, 1429, 1399, 1405, 1430, 1431, 1438, 1411, 1290,
 /*   410 */  1441, 1443, 1413, 1444, 1410, 1449, 1451, 1414, 1426, 1415,
 /*   420 */  1454, 1427, 1428, 1420, 1455, 1434, 1440, 1422, 1458, 1439,
 /*   430 */  1442, 1425, 1488, 1489, 1490, 1492, 1416, 1423, 1446, 1472,
 /*   440 */  1495, 1450, 1452, 1453, 1456, 1460, 1461, 1457, 1463, 1465,
 /*   450 */  1505, 1486, 1513, 1493, 1466, 1516, 1496, 1470, 1519, 1498,
 /*   460 */  1522, 1502, 1512, 1525, 1389, 1491, 1535, 1379, 1515, 1424,
 /*   470 */  1432, 1539, 1540, 1541, 1436, 1544, 1464, 1509, 1433, 1510,
 /*   480 */  1511, 1339, 1468, 1514, 1475, 1473, 1477, 1478, 1480, 1523,
 /*   490 */  1521, 1524, 1485, 1526, 1355, 1503, 1504, 1528, 1365, 1548,
 /*   500 */  1546, 1517, 1559, 1435, 1520, 1554, 1556, 1560, 1561, 1562,
 /*   510 */  1564, 1520, 1602, 1437, 1565, 1531, 1534, 1536, 1572, 1542,
 /*   520 */  1543, 1573, 1599, 1448, 1545, 1538, 1549, 1547, 1552, 1494,
 /*   530 */  1553, 1625, 1593, 1527, 1569, 1555, 1591, 1594, 1570, 1571,
 /*   540 */  1574, 1630, 1575, 1576, 1583, 1619, 1620, 1589, 1590, 1626,
 /*   550 */  1596, 1592, 1632, 1600, 1603, 1633, 1601, 1604, 1637, 1606,
 /*   560 */  1586, 1587, 1595, 1597, 1671, 1605, 1613, 1614, 1649, 1616,
 /*   570 */  1658, 1658, 1679, 1645, 1647, 1665, 1650, 1638, 1685, 1680,
 /*   580 */  1681, 1683, 1686, 1687, 1710, 1688, 1689, 1673, 1460, 1691,
 /*   590 */  1461, 1692, 1693, 1695, 1696, 1697, 1698, 1746, 1700, 1703,
 /*   600 */  1712, 1751, 1705, 1708, 1718, 1754, 1711, 1720, 1730, 1757,
 /*   610 */  1722, 1725, 1734, 1772, 1726, 1774, 1753, 1758, 1756, 1760,
 /*   620 */  1759, 1764,
};
#define YY_REDUCE_COUNT (258)
#define YY_REDUCE_MIN   (-300)
#define YY_REDUCE_MAX   (1778)
static const short yy_reduce_ofst[] = {
 /*     0 */  -186, -240, -177,  241,  648,  762,  788,  814,  866,  880,
 /*    10 */   189,  931,  995, 1009, 1018,  459, 1075, 1097, 1151, 1163,
 /*    20 */  1214, 1265, 1279, 1328, 1345, 1394, 1406, 1447, 1499, 1508,
 /*    30 */  1557, 1598, 1615, 1664, 1676, 1717, 1769, 1778, 1588, 1690,
 /*    40 */  -161, -118,  156, -268, -263,    3,  404, -175,  223,  278,
 /*    50 */  -158,  285, -238, -230, -300, -279, -295, -253, -156,  158,
 /*    60 */   237,  335,  421,  428,  450,  247,  572,  580, -246, -136,
 /*    70 */   -66,   92,  585,  610,  145,  611,  352,  309,  362,  643,
 /*    80 */   374, -197, -275, -275, -275,  -34, -124,   81,  124,  127,
 /*    90 */   175,  180,  211,  217,  265,  384,  387,  418,  429,  434,
 /*   100 */   447,  473,  484,  488,  520,  593,  356,  193, -183,   41,
 /*   110 */   135,  327,  373,  422,  423,    4,  441,  614, -141,  550,
 /*   120 */  -269,  150,  245,  469,   95,  599,  604,  652,  653,  657,
 /*   130 */   659,  663,  641,  700,  714,  601,  623,  743,  685,  654,
 /*   140 */   726,  726,  747,  750,  718,  689,  665,  665,  665,  655,
 /*   150 */   656,  674,  664,  726,  711,  777,  730,  785,  742,  799,
 /*   160 */   801,  753,  768,  771,  811,  817,  818,  761,  813,  783,
 /*   170 */   816,  784,  787,  833,  791,  839,  829,  804,  842,  856,
 /*   180 */   862,  859,  869,  848,  849,  850,  851,  852,  855,  868,
 /*   190 */   870,  875,  876,  883,  885,  888,  864,  871,  844,  887,
 /*   200 */   857,  872,  910,  905,  874,  914,  890,  879,  915,  861,
 /*   210 */   824,  891,  892,  840,  898,  894,  904,  726,  858,  882,
 /*   220 */   897,  896,  665,  930,  900,  899,  902,  911,  884,  906,
 /*   230 */   916,  908,  918,  924,  928,  944,  947,  934,  953,  933,
 /*   240 */   955,  949,  982,  987, 1003,  979,  994,  998, 1006, 1022,
 /*   250 */  1023, 1029,  975,  972, 1019, 1020, 1021, 1033, 1041,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    10 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    20 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    30 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    40 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    50 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    60 */  1371, 1371, 1371, 1371, 1371, 1440, 1371, 1371, 1371, 1371,
 /*    70 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    80 */  1438, 1586, 1371, 1750, 1371, 1371, 1371, 1371, 1371, 1371,
 /*    90 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   100 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   110 */  1440, 1371, 1761, 1761, 1761, 1438, 1371, 1371, 1371, 1371,
 /*   120 */  1371, 1371, 1371, 1534, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   130 */  1371, 1371, 1619, 1371, 1371, 1827, 1371, 1371, 1625, 1785,
 /*   140 */  1371, 1371, 1371, 1371, 1487, 1777, 1753, 1767, 1754, 1812,
 /*   150 */  1812, 1812, 1770, 1371, 1781, 1371, 1371, 1371, 1611, 1371,
 /*   160 */  1371, 1591, 1588, 1588, 1371, 1371, 1371, 1371, 1440, 1371,
 /*   170 */  1440, 1371, 1371, 1440, 1371, 1440, 1371, 1371, 1440, 1440,
 /*   180 */  1371, 1440, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   190 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1438,
 /*   200 */  1621, 1371, 1438, 1371, 1371, 1438, 1371, 1371, 1438, 1371,
 /*   210 */  1792, 1790, 1371, 1792, 1790, 1371, 1371, 1371, 1804, 1800,
 /*   220 */  1783, 1781, 1767, 1371, 1371, 1371, 1818, 1814, 1830, 1818,
 /*   230 */  1814, 1818, 1814, 1371, 1790, 1371, 1371, 1790, 1371, 1596,
 /*   240 */  1371, 1371, 1438, 1371, 1438, 1371, 1503, 1371, 1371, 1371,
 /*   250 */  1438, 1371, 1613, 1627, 1537, 1537, 1537, 1441, 1376, 1371,
 /*   260 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   270 */  1499, 1694, 1803, 1802, 1726, 1725, 1724, 1722, 1693, 1371,
 /*   280 */  1371, 1371, 1371, 1371, 1371, 1687, 1688, 1686, 1685, 1371,
 /*   290 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   300 */  1371, 1371, 1751, 1371, 1815, 1819, 1371, 1371, 1371, 1670,
 /*   310 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   320 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   330 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   340 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   350 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   360 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   370 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   380 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   390 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1405, 1371, 1371,
 /*   400 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   410 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   420 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   430 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   440 */  1371, 1371, 1371, 1371, 1371, 1468, 1467, 1371, 1371, 1371,
 /*   450 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   460 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   470 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1774,
 /*   480 */  1784, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   490 */  1371, 1670, 1371, 1801, 1371, 1760, 1756, 1371, 1371, 1752,
 /*   500 */  1371, 1371, 1813, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   510 */  1371, 1371, 1746, 1371, 1719, 1371, 1371, 1371, 1371, 1371,
 /*   520 */  1371, 1371, 1371, 1681, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   530 */  1371, 1371, 1371, 1371, 1371, 1371, 1669, 1371, 1710, 1371,
 /*   540 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1531, 1371, 1371,
 /*   550 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   560 */  1516, 1514, 1513, 1512, 1371, 1509, 1371, 1371, 1371, 1371,
 /*   570 */  1540, 1539, 1371, 1371, 1371, 1371, 1371, 1371, 1460, 1371,
 /*   580 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1451, 1371,
 /*   590 */  1450, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   600 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   610 */  1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371, 1371,
 /*   620 */  1371, 1371,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  232,  /*  NK_BITNOT => ID */
  232,  /*     INSERT => ID */
  232,  /*     VALUES => ID */
  232,  /*     IMPORT => ID */
  232,  /*    NK_SEMI => ID */
  232,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DURATION",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "MAX_DELAY",
  /*  113 */ "WATERMARK",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "FIRST",
  /*  118 */ "LAST",
  /*  119 */ "SHOW",
  /*  120 */ "DATABASES",
  /*  121 */ "TABLES",
  /*  122 */ "STABLES",
  /*  123 */ "MNODES",
  /*  124 */ "MODULES",
  /*  125 */ "QNODES",
  /*  126 */ "FUNCTIONS",
  /*  127 */ "INDEXES",
  /*  128 */ "ACCOUNTS",
  /*  129 */ "APPS",
  /*  130 */ "CONNECTIONS",
  /*  131 */ "LICENCE",
  /*  132 */ "GRANTS",
  /*  133 */ "QUERIES",
  /*  134 */ "SCORES",
  /*  135 */ "TOPICS",
  /*  136 */ "VARIABLES",
  /*  137 */ "BNODES",
  /*  138 */ "SNODES",
  /*  139 */ "CLUSTER",
  /*  140 */ "TRANSACTIONS",
  /*  141 */ "LIKE",
  /*  142 */ "INDEX",
  /*  143 */ "FULLTEXT",
  /*  144 */ "FUNCTION",
  /*  145 */ "INTERVAL",
  /*  146 */ "TOPIC",
  /*  147 */ "AS",
  /*  148 */ "CONSUMER",
  /*  149 */ "GROUP",
  /*  150 */ "DESC",
  /*  151 */ "DESCRIBE",
  /*  152 */ "RESET",
  /*  153 */ "QUERY",
  /*  154 */ "CACHE",
  /*  155 */ "EXPLAIN",
  /*  156 */ "ANALYZE",
  /*  157 */ "VERBOSE",
  /*  158 */ "NK_BOOL",
  /*  159 */ "RATIO",
  /*  160 */ "NK_FLOAT",
  /*  161 */ "COMPACT",
  /*  162 */ "VNODES",
  /*  163 */ "IN",
  /*  164 */ "OUTPUTTYPE",
  /*  165 */ "AGGREGATE",
  /*  166 */ "BUFSIZE",
  /*  167 */ "STREAM",
  /*  168 */ "INTO",
  /*  169 */ "TRIGGER",
  /*  170 */ "AT_ONCE",
  /*  171 */ "WINDOW_CLOSE",
  /*  172 */ "KILL",
  /*  173 */ "CONNECTION",
  /*  174 */ "TRANSACTION",
  /*  175 */ "BALANCE",
  /*  176 */ "VGROUP",
  /*  177 */ "MERGE",
  /*  178 */ "REDISTRIBUTE",
  /*  179 */ "SPLIT",
  /*  180 */ "SYNCDB",
  /*  181 */ "DELETE",
  /*  182 */ "NULL",
  /*  183 */ "NK_QUESTION",
  /*  184 */ "NK_ARROW",
  /*  185 */ "ROWTS",
  /*  186 */ "TBNAME",
  /*  187 */ "QSTARTTS",
  /*  188 */ "QENDTS",
  /*  189 */ "WSTARTTS",
  /*  190 */ "WENDTS",
  /*  191 */ "WDURATION",
  /*  192 */ "CAST",
  /*  193 */ "NOW",
  /*  194 */ "TODAY",
  /*  195 */ "TIMEZONE",
  /*  196 */ "COUNT",
  /*  197 */ "LAST_ROW",
  /*  198 */ "BETWEEN",
  /*  199 */ "IS",
  /*  200 */ "NK_LT",
  /*  201 */ "NK_GT",
  /*  202 */ "NK_LE",
  /*  203 */ "NK_GE",
  /*  204 */ "NK_NE",
  /*  205 */ "MATCH",
  /*  206 */ "NMATCH",
  /*  207 */ "CONTAINS",
  /*  208 */ "JOIN",
  /*  209 */ "INNER",
  /*  210 */ "SELECT",
  /*  211 */ "DISTINCT",
  /*  212 */ "WHERE",
  /*  213 */ "PARTITION",
  /*  214 */ "BY",
  /*  215 */ "SESSION",
  /*  216 */ "STATE_WINDOW",
  /*  217 */ "SLIDING",
  /*  218 */ "FILL",
  /*  219 */ "VALUE",
  /*  220 */ "NONE",
  /*  221 */ "PREV",
  /*  222 */ "LINEAR",
  /*  223 */ "NEXT",
  /*  224 */ "HAVING",
  /*  225 */ "ORDER",
  /*  226 */ "SLIMIT",
  /*  227 */ "SOFFSET",
  /*  228 */ "LIMIT",
  /*  229 */ "OFFSET",
  /*  230 */ "ASC",
  /*  231 */ "NULLS",
  /*  232 */ "ID",
  /*  233 */ "NK_BITNOT",
  /*  234 */ "INSERT",
  /*  235 */ "VALUES",
  /*  236 */ "IMPORT",
  /*  237 */ "NK_SEMI",
  /*  238 */ "FILE",
  /*  239 */ "cmd",
  /*  240 */ "account_options",
  /*  241 */ "alter_account_options",
  /*  242 */ "literal",
  /*  243 */ "alter_account_option",
  /*  244 */ "user_name",
  /*  245 */ "privileges",
  /*  246 */ "priv_level",
  /*  247 */ "priv_type_list",
  /*  248 */ "priv_type",
  /*  249 */ "db_name",
  /*  250 */ "dnode_endpoint",
  /*  251 */ "not_exists_opt",
  /*  252 */ "db_options",
  /*  253 */ "exists_opt",
  /*  254 */ "alter_db_options",
  /*  255 */ "integer_list",
  /*  256 */ "variable_list",
  /*  257 */ "retention_list",
  /*  258 */ "alter_db_option",
  /*  259 */ "retention",
  /*  260 */ "full_table_name",
  /*  261 */ "column_def_list",
  /*  262 */ "tags_def_opt",
  /*  263 */ "table_options",
  /*  264 */ "multi_create_clause",
  /*  265 */ "tags_def",
  /*  266 */ "multi_drop_clause",
  /*  267 */ "alter_table_clause",
  /*  268 */ "alter_table_options",
  /*  269 */ "column_name",
  /*  270 */ "type_name",
  /*  271 */ "signed_literal",
  /*  272 */ "create_subtable_clause",
  /*  273 */ "specific_tags_opt",
  /*  274 */ "literal_list",
  /*  275 */ "drop_table_clause",
  /*  276 */ "col_name_list",
  /*  277 */ "table_name",
  /*  278 */ "column_def",
  /*  279 */ "duration_list",
  /*  280 */ "rollup_func_list",
  /*  281 */ "alter_table_option",
  /*  282 */ "duration_literal",
  /*  283 */ "rollup_func_name",
  /*  284 */ "function_name",
  /*  285 */ "col_name",
  /*  286 */ "db_name_cond_opt",
  /*  287 */ "like_pattern_opt",
  /*  288 */ "table_name_cond",
  /*  289 */ "from_db_opt",
  /*  290 */ "index_name",
  /*  291 */ "index_options",
  /*  292 */ "func_list",
  /*  293 */ "sliding_opt",
  /*  294 */ "func",
  /*  295 */ "expression_list",
  /*  296 */ "topic_name",
  /*  297 */ "query_expression",
  /*  298 */ "cgroup_name",
  /*  299 */ "analyze_opt",
  /*  300 */ "explain_options",
  /*  301 */ "agg_func_opt",
  /*  302 */ "bufsize_opt",
  /*  303 */ "stream_name",
  /*  304 */ "stream_options",
  /*  305 */ "into_opt",
  /*  306 */ "dnode_list",
  /*  307 */ "where_clause_opt",
  /*  308 */ "signed",
  /*  309 */ "literal_func",
  /*  310 */ "table_alias",
  /*  311 */ "column_alias",
  /*  312 */ "expression",
  /*  313 */ "pseudo_column",
  /*  314 */ "column_reference",
  /*  315 */ "function_expression",
  /*  316 */ "subquery",
  /*  317 */ "star_func",
  /*  318 */ "star_func_para_list",
  /*  319 */ "noarg_func",
  /*  320 */ "other_para_list",
  /*  321 */ "star_func_para",
  /*  322 */ "predicate",
  /*  323 */ "compare_op",
  /*  324 */ "in_op",
  /*  325 */ "in_predicate_value",
  /*  326 */ "boolean_value_expression",
  /*  327 */ "boolean_primary",
  /*  328 */ "common_expression",
  /*  329 */ "from_clause",
  /*  330 */ "table_reference_list",
  /*  331 */ "table_reference",
  /*  332 */ "table_primary",
  /*  333 */ "joined_table",
  /*  334 */ "alias_opt",
  /*  335 */ "parenthesized_joined_table",
  /*  336 */ "join_type",
  /*  337 */ "search_condition",
  /*  338 */ "query_specification",
  /*  339 */ "set_quantifier_opt",
  /*  340 */ "select_list",
  /*  341 */ "partition_by_clause_opt",
  /*  342 */ "twindow_clause_opt",
  /*  343 */ "group_by_clause_opt",
  /*  344 */ "having_clause_opt",
  /*  345 */ "select_sublist",
  /*  346 */ "select_item",
  /*  347 */ "fill_opt",
  /*  348 */ "fill_mode",
  /*  349 */ "group_by_list",
  /*  350 */ "query_expression_body",
  /*  351 */ "order_by_clause_opt",
  /*  352 */ "slimit_clause_opt",
  /*  353 */ "limit_clause_opt",
  /*  354 */ "query_primary",
  /*  355 */ "sort_specification_list",
  /*  356 */ "sort_specification",
  /*  357 */ "ordering_specification_opt",
  /*  358 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_endpoint ::= NK_ID",
 /*  48 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  72 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 166 */ "table_options ::= table_options WATERMARK duration_list",
 /* 167 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 168 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 169 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 170 */ "alter_table_options ::= alter_table_option",
 /* 171 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 172 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 173 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 174 */ "duration_list ::= duration_literal",
 /* 175 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 176 */ "rollup_func_list ::= rollup_func_name",
 /* 177 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 178 */ "rollup_func_name ::= function_name",
 /* 179 */ "rollup_func_name ::= FIRST",
 /* 180 */ "rollup_func_name ::= LAST",
 /* 181 */ "col_name_list ::= col_name",
 /* 182 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 183 */ "col_name ::= column_name",
 /* 184 */ "cmd ::= SHOW DNODES",
 /* 185 */ "cmd ::= SHOW USERS",
 /* 186 */ "cmd ::= SHOW DATABASES",
 /* 187 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 188 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 189 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 190 */ "cmd ::= SHOW MNODES",
 /* 191 */ "cmd ::= SHOW MODULES",
 /* 192 */ "cmd ::= SHOW QNODES",
 /* 193 */ "cmd ::= SHOW FUNCTIONS",
 /* 194 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 195 */ "cmd ::= SHOW STREAMS",
 /* 196 */ "cmd ::= SHOW ACCOUNTS",
 /* 197 */ "cmd ::= SHOW APPS",
 /* 198 */ "cmd ::= SHOW CONNECTIONS",
 /* 199 */ "cmd ::= SHOW LICENCE",
 /* 200 */ "cmd ::= SHOW GRANTS",
 /* 201 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 202 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 203 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 204 */ "cmd ::= SHOW QUERIES",
 /* 205 */ "cmd ::= SHOW SCORES",
 /* 206 */ "cmd ::= SHOW TOPICS",
 /* 207 */ "cmd ::= SHOW VARIABLES",
 /* 208 */ "cmd ::= SHOW BNODES",
 /* 209 */ "cmd ::= SHOW SNODES",
 /* 210 */ "cmd ::= SHOW CLUSTER",
 /* 211 */ "cmd ::= SHOW TRANSACTIONS",
 /* 212 */ "db_name_cond_opt ::=",
 /* 213 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 214 */ "like_pattern_opt ::=",
 /* 215 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 216 */ "table_name_cond ::= table_name",
 /* 217 */ "from_db_opt ::=",
 /* 218 */ "from_db_opt ::= FROM db_name",
 /* 219 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 220 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 221 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 222 */ "index_options ::=",
 /* 223 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 224 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 225 */ "func_list ::= func",
 /* 226 */ "func_list ::= func_list NK_COMMA func",
 /* 227 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 228 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 229 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 230 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 231 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 232 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 233 */ "cmd ::= DESC full_table_name",
 /* 234 */ "cmd ::= DESCRIBE full_table_name",
 /* 235 */ "cmd ::= RESET QUERY CACHE",
 /* 236 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 237 */ "analyze_opt ::=",
 /* 238 */ "analyze_opt ::= ANALYZE",
 /* 239 */ "explain_options ::=",
 /* 240 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 241 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 242 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 243 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 244 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 245 */ "agg_func_opt ::=",
 /* 246 */ "agg_func_opt ::= AGGREGATE",
 /* 247 */ "bufsize_opt ::=",
 /* 248 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 249 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 250 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 251 */ "into_opt ::=",
 /* 252 */ "into_opt ::= INTO full_table_name",
 /* 253 */ "stream_options ::=",
 /* 254 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 255 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 256 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 257 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 258 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 259 */ "cmd ::= KILL QUERY NK_STRING",
 /* 260 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 261 */ "cmd ::= BALANCE VGROUP",
 /* 262 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 263 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 264 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 265 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 266 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 267 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 268 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 269 */ "cmd ::= query_expression",
 /* 270 */ "literal ::= NK_INTEGER",
 /* 271 */ "literal ::= NK_FLOAT",
 /* 272 */ "literal ::= NK_STRING",
 /* 273 */ "literal ::= NK_BOOL",
 /* 274 */ "literal ::= TIMESTAMP NK_STRING",
 /* 275 */ "literal ::= duration_literal",
 /* 276 */ "literal ::= NULL",
 /* 277 */ "literal ::= NK_QUESTION",
 /* 278 */ "duration_literal ::= NK_VARIABLE",
 /* 279 */ "signed ::= NK_INTEGER",
 /* 280 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 281 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 282 */ "signed ::= NK_FLOAT",
 /* 283 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 284 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 285 */ "signed_literal ::= signed",
 /* 286 */ "signed_literal ::= NK_STRING",
 /* 287 */ "signed_literal ::= NK_BOOL",
 /* 288 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 289 */ "signed_literal ::= duration_literal",
 /* 290 */ "signed_literal ::= NULL",
 /* 291 */ "signed_literal ::= literal_func",
 /* 292 */ "literal_list ::= signed_literal",
 /* 293 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 294 */ "db_name ::= NK_ID",
 /* 295 */ "table_name ::= NK_ID",
 /* 296 */ "column_name ::= NK_ID",
 /* 297 */ "function_name ::= NK_ID",
 /* 298 */ "table_alias ::= NK_ID",
 /* 299 */ "column_alias ::= NK_ID",
 /* 300 */ "user_name ::= NK_ID",
 /* 301 */ "index_name ::= NK_ID",
 /* 302 */ "topic_name ::= NK_ID",
 /* 303 */ "stream_name ::= NK_ID",
 /* 304 */ "cgroup_name ::= NK_ID",
 /* 305 */ "expression ::= literal",
 /* 306 */ "expression ::= pseudo_column",
 /* 307 */ "expression ::= column_reference",
 /* 308 */ "expression ::= function_expression",
 /* 309 */ "expression ::= subquery",
 /* 310 */ "expression ::= NK_LP expression NK_RP",
 /* 311 */ "expression ::= NK_PLUS expression",
 /* 312 */ "expression ::= NK_MINUS expression",
 /* 313 */ "expression ::= expression NK_PLUS expression",
 /* 314 */ "expression ::= expression NK_MINUS expression",
 /* 315 */ "expression ::= expression NK_STAR expression",
 /* 316 */ "expression ::= expression NK_SLASH expression",
 /* 317 */ "expression ::= expression NK_REM expression",
 /* 318 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 319 */ "expression_list ::= expression",
 /* 320 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 321 */ "column_reference ::= column_name",
 /* 322 */ "column_reference ::= table_name NK_DOT column_name",
 /* 323 */ "pseudo_column ::= ROWTS",
 /* 324 */ "pseudo_column ::= TBNAME",
 /* 325 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 326 */ "pseudo_column ::= QSTARTTS",
 /* 327 */ "pseudo_column ::= QENDTS",
 /* 328 */ "pseudo_column ::= WSTARTTS",
 /* 329 */ "pseudo_column ::= WENDTS",
 /* 330 */ "pseudo_column ::= WDURATION",
 /* 331 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 332 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 333 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 334 */ "function_expression ::= literal_func",
 /* 335 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 336 */ "literal_func ::= NOW",
 /* 337 */ "noarg_func ::= NOW",
 /* 338 */ "noarg_func ::= TODAY",
 /* 339 */ "noarg_func ::= TIMEZONE",
 /* 340 */ "star_func ::= COUNT",
 /* 341 */ "star_func ::= FIRST",
 /* 342 */ "star_func ::= LAST",
 /* 343 */ "star_func ::= LAST_ROW",
 /* 344 */ "star_func_para_list ::= NK_STAR",
 /* 345 */ "star_func_para_list ::= other_para_list",
 /* 346 */ "other_para_list ::= star_func_para",
 /* 347 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 348 */ "star_func_para ::= expression",
 /* 349 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 350 */ "predicate ::= expression compare_op expression",
 /* 351 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 352 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 353 */ "predicate ::= expression IS NULL",
 /* 354 */ "predicate ::= expression IS NOT NULL",
 /* 355 */ "predicate ::= expression in_op in_predicate_value",
 /* 356 */ "compare_op ::= NK_LT",
 /* 357 */ "compare_op ::= NK_GT",
 /* 358 */ "compare_op ::= NK_LE",
 /* 359 */ "compare_op ::= NK_GE",
 /* 360 */ "compare_op ::= NK_NE",
 /* 361 */ "compare_op ::= NK_EQ",
 /* 362 */ "compare_op ::= LIKE",
 /* 363 */ "compare_op ::= NOT LIKE",
 /* 364 */ "compare_op ::= MATCH",
 /* 365 */ "compare_op ::= NMATCH",
 /* 366 */ "compare_op ::= CONTAINS",
 /* 367 */ "in_op ::= IN",
 /* 368 */ "in_op ::= NOT IN",
 /* 369 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 370 */ "boolean_value_expression ::= boolean_primary",
 /* 371 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 372 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 373 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 374 */ "boolean_primary ::= predicate",
 /* 375 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 376 */ "common_expression ::= expression",
 /* 377 */ "common_expression ::= boolean_value_expression",
 /* 378 */ "from_clause ::= FROM table_reference_list",
 /* 379 */ "table_reference_list ::= table_reference",
 /* 380 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 381 */ "table_reference ::= table_primary",
 /* 382 */ "table_reference ::= joined_table",
 /* 383 */ "table_primary ::= table_name alias_opt",
 /* 384 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 385 */ "table_primary ::= subquery alias_opt",
 /* 386 */ "table_primary ::= parenthesized_joined_table",
 /* 387 */ "alias_opt ::=",
 /* 388 */ "alias_opt ::= table_alias",
 /* 389 */ "alias_opt ::= AS table_alias",
 /* 390 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 391 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 392 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 393 */ "join_type ::=",
 /* 394 */ "join_type ::= INNER",
 /* 395 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 396 */ "set_quantifier_opt ::=",
 /* 397 */ "set_quantifier_opt ::= DISTINCT",
 /* 398 */ "set_quantifier_opt ::= ALL",
 /* 399 */ "select_list ::= NK_STAR",
 /* 400 */ "select_list ::= select_sublist",
 /* 401 */ "select_sublist ::= select_item",
 /* 402 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 403 */ "select_item ::= common_expression",
 /* 404 */ "select_item ::= common_expression column_alias",
 /* 405 */ "select_item ::= common_expression AS column_alias",
 /* 406 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 407 */ "where_clause_opt ::=",
 /* 408 */ "where_clause_opt ::= WHERE search_condition",
 /* 409 */ "partition_by_clause_opt ::=",
 /* 410 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 411 */ "twindow_clause_opt ::=",
 /* 412 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 413 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 414 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 415 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 416 */ "sliding_opt ::=",
 /* 417 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 418 */ "fill_opt ::=",
 /* 419 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 420 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 421 */ "fill_mode ::= NONE",
 /* 422 */ "fill_mode ::= PREV",
 /* 423 */ "fill_mode ::= NULL",
 /* 424 */ "fill_mode ::= LINEAR",
 /* 425 */ "fill_mode ::= NEXT",
 /* 426 */ "group_by_clause_opt ::=",
 /* 427 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 428 */ "group_by_list ::= expression",
 /* 429 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 430 */ "having_clause_opt ::=",
 /* 431 */ "having_clause_opt ::= HAVING search_condition",
 /* 432 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 433 */ "query_expression_body ::= query_primary",
 /* 434 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 435 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 436 */ "query_primary ::= query_specification",
 /* 437 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 438 */ "order_by_clause_opt ::=",
 /* 439 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 440 */ "slimit_clause_opt ::=",
 /* 441 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 442 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 443 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 444 */ "limit_clause_opt ::=",
 /* 445 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 446 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 447 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 448 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 449 */ "search_condition ::= common_expression",
 /* 450 */ "sort_specification_list ::= sort_specification",
 /* 451 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 452 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 453 */ "ordering_specification_opt ::=",
 /* 454 */ "ordering_specification_opt ::= ASC",
 /* 455 */ "ordering_specification_opt ::= DESC",
 /* 456 */ "null_ordering_opt ::=",
 /* 457 */ "null_ordering_opt ::= NULLS FIRST",
 /* 458 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 239: /* cmd */
    case 242: /* literal */
    case 252: /* db_options */
    case 254: /* alter_db_options */
    case 259: /* retention */
    case 260: /* full_table_name */
    case 263: /* table_options */
    case 267: /* alter_table_clause */
    case 268: /* alter_table_options */
    case 271: /* signed_literal */
    case 272: /* create_subtable_clause */
    case 275: /* drop_table_clause */
    case 278: /* column_def */
    case 282: /* duration_literal */
    case 283: /* rollup_func_name */
    case 285: /* col_name */
    case 286: /* db_name_cond_opt */
    case 287: /* like_pattern_opt */
    case 288: /* table_name_cond */
    case 289: /* from_db_opt */
    case 291: /* index_options */
    case 293: /* sliding_opt */
    case 294: /* func */
    case 297: /* query_expression */
    case 300: /* explain_options */
    case 304: /* stream_options */
    case 305: /* into_opt */
    case 307: /* where_clause_opt */
    case 308: /* signed */
    case 309: /* literal_func */
    case 312: /* expression */
    case 313: /* pseudo_column */
    case 314: /* column_reference */
    case 315: /* function_expression */
    case 316: /* subquery */
    case 321: /* star_func_para */
    case 322: /* predicate */
    case 325: /* in_predicate_value */
    case 326: /* boolean_value_expression */
    case 327: /* boolean_primary */
    case 328: /* common_expression */
    case 329: /* from_clause */
    case 330: /* table_reference_list */
    case 331: /* table_reference */
    case 332: /* table_primary */
    case 333: /* joined_table */
    case 335: /* parenthesized_joined_table */
    case 337: /* search_condition */
    case 338: /* query_specification */
    case 342: /* twindow_clause_opt */
    case 344: /* having_clause_opt */
    case 346: /* select_item */
    case 347: /* fill_opt */
    case 350: /* query_expression_body */
    case 352: /* slimit_clause_opt */
    case 353: /* limit_clause_opt */
    case 354: /* query_primary */
    case 356: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy674)); 
}
      break;
    case 240: /* account_options */
    case 241: /* alter_account_options */
    case 243: /* alter_account_option */
    case 302: /* bufsize_opt */
{
 
}
      break;
    case 244: /* user_name */
    case 246: /* priv_level */
    case 249: /* db_name */
    case 250: /* dnode_endpoint */
    case 269: /* column_name */
    case 277: /* table_name */
    case 284: /* function_name */
    case 290: /* index_name */
    case 296: /* topic_name */
    case 298: /* cgroup_name */
    case 303: /* stream_name */
    case 310: /* table_alias */
    case 311: /* column_alias */
    case 317: /* star_func */
    case 319: /* noarg_func */
    case 334: /* alias_opt */
{
 
}
      break;
    case 245: /* privileges */
    case 247: /* priv_type_list */
    case 248: /* priv_type */
{
 
}
      break;
    case 251: /* not_exists_opt */
    case 253: /* exists_opt */
    case 299: /* analyze_opt */
    case 301: /* agg_func_opt */
    case 339: /* set_quantifier_opt */
{
 
}
      break;
    case 255: /* integer_list */
    case 256: /* variable_list */
    case 257: /* retention_list */
    case 261: /* column_def_list */
    case 262: /* tags_def_opt */
    case 264: /* multi_create_clause */
    case 265: /* tags_def */
    case 266: /* multi_drop_clause */
    case 273: /* specific_tags_opt */
    case 274: /* literal_list */
    case 276: /* col_name_list */
    case 279: /* duration_list */
    case 280: /* rollup_func_list */
    case 292: /* func_list */
    case 295: /* expression_list */
    case 306: /* dnode_list */
    case 318: /* star_func_para_list */
    case 320: /* other_para_list */
    case 340: /* select_list */
    case 341: /* partition_by_clause_opt */
    case 343: /* group_by_clause_opt */
    case 345: /* select_sublist */
    case 349: /* group_by_list */
    case 351: /* order_by_clause_opt */
    case 355: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy530)); 
}
      break;
    case 258: /* alter_db_option */
    case 281: /* alter_table_option */
{
 
}
      break;
    case 270: /* type_name */
{
 
}
      break;
    case 323: /* compare_op */
    case 324: /* in_op */
{
 
}
      break;
    case 336: /* join_type */
{
 
}
      break;
    case 348: /* fill_mode */
{
 
}
      break;
    case 357: /* ordering_specification_opt */
{
 
}
      break;
    case 358: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  239,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  239,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  240,    0 }, /* (2) account_options ::= */
  {  240,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  240,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  240,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  240,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  240,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  240,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  240,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  240,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  240,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  241,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  241,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  243,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  243,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  243,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  243,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  243,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  243,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  243,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  243,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  243,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  243,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  239,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  239,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  239,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  239,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  245,   -1 }, /* (30) privileges ::= ALL */
  {  245,   -1 }, /* (31) privileges ::= priv_type_list */
  {  247,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  247,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  248,   -1 }, /* (34) priv_type ::= READ */
  {  248,   -1 }, /* (35) priv_type ::= WRITE */
  {  246,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  246,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  239,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  239,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  239,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  239,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  239,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  239,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  239,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  239,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  250,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  250,   -1 }, /* (47) dnode_endpoint ::= NK_ID */
  {  250,   -1 }, /* (48) dnode_endpoint ::= NK_IPTOKEN */
  {  239,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  239,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  239,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  239,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  239,   -2 }, /* (61) cmd ::= USE db_name */
  {  239,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  251,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  251,    0 }, /* (64) not_exists_opt ::= */
  {  253,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  253,    0 }, /* (66) exists_opt ::= */
  {  252,    0 }, /* (67) db_options ::= */
  {  252,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  252,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  252,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  252,   -3 }, /* (71) db_options ::= db_options DURATION NK_INTEGER */
  {  252,   -3 }, /* (72) db_options ::= db_options DURATION NK_VARIABLE */
  {  252,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  252,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  252,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  252,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  252,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  252,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  252,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  252,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  252,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  252,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  252,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  252,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  252,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  252,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  252,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  254,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  254,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  258,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  258,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  258,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  258,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  258,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  258,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  258,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  258,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  258,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  255,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  255,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  256,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  256,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  257,   -1 }, /* (103) retention_list ::= retention */
  {  257,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  259,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  239,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  239,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  239,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  239,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  239,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  239,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  239,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  267,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  267,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  267,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  267,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  267,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  267,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  267,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  267,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  267,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  267,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  264,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  264,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  272,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  266,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  266,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  275,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  273,    0 }, /* (129) specific_tags_opt ::= */
  {  273,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  260,   -1 }, /* (131) full_table_name ::= table_name */
  {  260,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  261,   -1 }, /* (133) column_def_list ::= column_def */
  {  261,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  278,   -2 }, /* (135) column_def ::= column_name type_name */
  {  278,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  270,   -1 }, /* (137) type_name ::= BOOL */
  {  270,   -1 }, /* (138) type_name ::= TINYINT */
  {  270,   -1 }, /* (139) type_name ::= SMALLINT */
  {  270,   -1 }, /* (140) type_name ::= INT */
  {  270,   -1 }, /* (141) type_name ::= INTEGER */
  {  270,   -1 }, /* (142) type_name ::= BIGINT */
  {  270,   -1 }, /* (143) type_name ::= FLOAT */
  {  270,   -1 }, /* (144) type_name ::= DOUBLE */
  {  270,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  270,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  270,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  270,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  270,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  270,   -1 }, /* (152) type_name ::= JSON */
  {  270,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  270,   -1 }, /* (155) type_name ::= BLOB */
  {  270,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (157) type_name ::= DECIMAL */
  {  270,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  270,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  262,    0 }, /* (160) tags_def_opt ::= */
  {  262,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  265,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  263,    0 }, /* (163) table_options ::= */
  {  263,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  263,   -3 }, /* (165) table_options ::= table_options MAX_DELAY duration_list */
  {  263,   -3 }, /* (166) table_options ::= table_options WATERMARK duration_list */
  {  263,   -5 }, /* (167) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  263,   -3 }, /* (168) table_options ::= table_options TTL NK_INTEGER */
  {  263,   -5 }, /* (169) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  268,   -1 }, /* (170) alter_table_options ::= alter_table_option */
  {  268,   -2 }, /* (171) alter_table_options ::= alter_table_options alter_table_option */
  {  281,   -2 }, /* (172) alter_table_option ::= COMMENT NK_STRING */
  {  281,   -2 }, /* (173) alter_table_option ::= TTL NK_INTEGER */
  {  279,   -1 }, /* (174) duration_list ::= duration_literal */
  {  279,   -3 }, /* (175) duration_list ::= duration_list NK_COMMA duration_literal */
  {  280,   -1 }, /* (176) rollup_func_list ::= rollup_func_name */
  {  280,   -3 }, /* (177) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  283,   -1 }, /* (178) rollup_func_name ::= function_name */
  {  283,   -1 }, /* (179) rollup_func_name ::= FIRST */
  {  283,   -1 }, /* (180) rollup_func_name ::= LAST */
  {  276,   -1 }, /* (181) col_name_list ::= col_name */
  {  276,   -3 }, /* (182) col_name_list ::= col_name_list NK_COMMA col_name */
  {  285,   -1 }, /* (183) col_name ::= column_name */
  {  239,   -2 }, /* (184) cmd ::= SHOW DNODES */
  {  239,   -2 }, /* (185) cmd ::= SHOW USERS */
  {  239,   -2 }, /* (186) cmd ::= SHOW DATABASES */
  {  239,   -4 }, /* (187) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  239,   -4 }, /* (188) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  239,   -3 }, /* (189) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  239,   -2 }, /* (190) cmd ::= SHOW MNODES */
  {  239,   -2 }, /* (191) cmd ::= SHOW MODULES */
  {  239,   -2 }, /* (192) cmd ::= SHOW QNODES */
  {  239,   -2 }, /* (193) cmd ::= SHOW FUNCTIONS */
  {  239,   -5 }, /* (194) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  239,   -2 }, /* (195) cmd ::= SHOW STREAMS */
  {  239,   -2 }, /* (196) cmd ::= SHOW ACCOUNTS */
  {  239,   -2 }, /* (197) cmd ::= SHOW APPS */
  {  239,   -2 }, /* (198) cmd ::= SHOW CONNECTIONS */
  {  239,   -2 }, /* (199) cmd ::= SHOW LICENCE */
  {  239,   -2 }, /* (200) cmd ::= SHOW GRANTS */
  {  239,   -4 }, /* (201) cmd ::= SHOW CREATE DATABASE db_name */
  {  239,   -4 }, /* (202) cmd ::= SHOW CREATE TABLE full_table_name */
  {  239,   -4 }, /* (203) cmd ::= SHOW CREATE STABLE full_table_name */
  {  239,   -2 }, /* (204) cmd ::= SHOW QUERIES */
  {  239,   -2 }, /* (205) cmd ::= SHOW SCORES */
  {  239,   -2 }, /* (206) cmd ::= SHOW TOPICS */
  {  239,   -2 }, /* (207) cmd ::= SHOW VARIABLES */
  {  239,   -2 }, /* (208) cmd ::= SHOW BNODES */
  {  239,   -2 }, /* (209) cmd ::= SHOW SNODES */
  {  239,   -2 }, /* (210) cmd ::= SHOW CLUSTER */
  {  239,   -2 }, /* (211) cmd ::= SHOW TRANSACTIONS */
  {  286,    0 }, /* (212) db_name_cond_opt ::= */
  {  286,   -2 }, /* (213) db_name_cond_opt ::= db_name NK_DOT */
  {  287,    0 }, /* (214) like_pattern_opt ::= */
  {  287,   -2 }, /* (215) like_pattern_opt ::= LIKE NK_STRING */
  {  288,   -1 }, /* (216) table_name_cond ::= table_name */
  {  289,    0 }, /* (217) from_db_opt ::= */
  {  289,   -2 }, /* (218) from_db_opt ::= FROM db_name */
  {  239,   -8 }, /* (219) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  239,  -10 }, /* (220) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  239,   -6 }, /* (221) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  291,    0 }, /* (222) index_options ::= */
  {  291,   -9 }, /* (223) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  291,  -11 }, /* (224) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  292,   -1 }, /* (225) func_list ::= func */
  {  292,   -3 }, /* (226) func_list ::= func_list NK_COMMA func */
  {  294,   -4 }, /* (227) func ::= function_name NK_LP expression_list NK_RP */
  {  239,   -6 }, /* (228) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  239,   -7 }, /* (229) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  239,   -7 }, /* (230) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  239,   -4 }, /* (231) cmd ::= DROP TOPIC exists_opt topic_name */
  {  239,   -7 }, /* (232) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  239,   -2 }, /* (233) cmd ::= DESC full_table_name */
  {  239,   -2 }, /* (234) cmd ::= DESCRIBE full_table_name */
  {  239,   -3 }, /* (235) cmd ::= RESET QUERY CACHE */
  {  239,   -4 }, /* (236) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  299,    0 }, /* (237) analyze_opt ::= */
  {  299,   -1 }, /* (238) analyze_opt ::= ANALYZE */
  {  300,    0 }, /* (239) explain_options ::= */
  {  300,   -3 }, /* (240) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  300,   -3 }, /* (241) explain_options ::= explain_options RATIO NK_FLOAT */
  {  239,   -6 }, /* (242) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  239,  -10 }, /* (243) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  239,   -4 }, /* (244) cmd ::= DROP FUNCTION exists_opt function_name */
  {  301,    0 }, /* (245) agg_func_opt ::= */
  {  301,   -1 }, /* (246) agg_func_opt ::= AGGREGATE */
  {  302,    0 }, /* (247) bufsize_opt ::= */
  {  302,   -2 }, /* (248) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  239,   -8 }, /* (249) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  239,   -4 }, /* (250) cmd ::= DROP STREAM exists_opt stream_name */
  {  305,    0 }, /* (251) into_opt ::= */
  {  305,   -2 }, /* (252) into_opt ::= INTO full_table_name */
  {  304,    0 }, /* (253) stream_options ::= */
  {  304,   -3 }, /* (254) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  304,   -3 }, /* (255) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  304,   -4 }, /* (256) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  304,   -3 }, /* (257) stream_options ::= stream_options WATERMARK duration_literal */
  {  239,   -3 }, /* (258) cmd ::= KILL CONNECTION NK_INTEGER */
  {  239,   -3 }, /* (259) cmd ::= KILL QUERY NK_STRING */
  {  239,   -3 }, /* (260) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  239,   -2 }, /* (261) cmd ::= BALANCE VGROUP */
  {  239,   -4 }, /* (262) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  239,   -4 }, /* (263) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  239,   -3 }, /* (264) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  306,   -2 }, /* (265) dnode_list ::= DNODE NK_INTEGER */
  {  306,   -3 }, /* (266) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  239,   -3 }, /* (267) cmd ::= SYNCDB db_name REPLICA */
  {  239,   -4 }, /* (268) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  239,   -1 }, /* (269) cmd ::= query_expression */
  {  242,   -1 }, /* (270) literal ::= NK_INTEGER */
  {  242,   -1 }, /* (271) literal ::= NK_FLOAT */
  {  242,   -1 }, /* (272) literal ::= NK_STRING */
  {  242,   -1 }, /* (273) literal ::= NK_BOOL */
  {  242,   -2 }, /* (274) literal ::= TIMESTAMP NK_STRING */
  {  242,   -1 }, /* (275) literal ::= duration_literal */
  {  242,   -1 }, /* (276) literal ::= NULL */
  {  242,   -1 }, /* (277) literal ::= NK_QUESTION */
  {  282,   -1 }, /* (278) duration_literal ::= NK_VARIABLE */
  {  308,   -1 }, /* (279) signed ::= NK_INTEGER */
  {  308,   -2 }, /* (280) signed ::= NK_PLUS NK_INTEGER */
  {  308,   -2 }, /* (281) signed ::= NK_MINUS NK_INTEGER */
  {  308,   -1 }, /* (282) signed ::= NK_FLOAT */
  {  308,   -2 }, /* (283) signed ::= NK_PLUS NK_FLOAT */
  {  308,   -2 }, /* (284) signed ::= NK_MINUS NK_FLOAT */
  {  271,   -1 }, /* (285) signed_literal ::= signed */
  {  271,   -1 }, /* (286) signed_literal ::= NK_STRING */
  {  271,   -1 }, /* (287) signed_literal ::= NK_BOOL */
  {  271,   -2 }, /* (288) signed_literal ::= TIMESTAMP NK_STRING */
  {  271,   -1 }, /* (289) signed_literal ::= duration_literal */
  {  271,   -1 }, /* (290) signed_literal ::= NULL */
  {  271,   -1 }, /* (291) signed_literal ::= literal_func */
  {  274,   -1 }, /* (292) literal_list ::= signed_literal */
  {  274,   -3 }, /* (293) literal_list ::= literal_list NK_COMMA signed_literal */
  {  249,   -1 }, /* (294) db_name ::= NK_ID */
  {  277,   -1 }, /* (295) table_name ::= NK_ID */
  {  269,   -1 }, /* (296) column_name ::= NK_ID */
  {  284,   -1 }, /* (297) function_name ::= NK_ID */
  {  310,   -1 }, /* (298) table_alias ::= NK_ID */
  {  311,   -1 }, /* (299) column_alias ::= NK_ID */
  {  244,   -1 }, /* (300) user_name ::= NK_ID */
  {  290,   -1 }, /* (301) index_name ::= NK_ID */
  {  296,   -1 }, /* (302) topic_name ::= NK_ID */
  {  303,   -1 }, /* (303) stream_name ::= NK_ID */
  {  298,   -1 }, /* (304) cgroup_name ::= NK_ID */
  {  312,   -1 }, /* (305) expression ::= literal */
  {  312,   -1 }, /* (306) expression ::= pseudo_column */
  {  312,   -1 }, /* (307) expression ::= column_reference */
  {  312,   -1 }, /* (308) expression ::= function_expression */
  {  312,   -1 }, /* (309) expression ::= subquery */
  {  312,   -3 }, /* (310) expression ::= NK_LP expression NK_RP */
  {  312,   -2 }, /* (311) expression ::= NK_PLUS expression */
  {  312,   -2 }, /* (312) expression ::= NK_MINUS expression */
  {  312,   -3 }, /* (313) expression ::= expression NK_PLUS expression */
  {  312,   -3 }, /* (314) expression ::= expression NK_MINUS expression */
  {  312,   -3 }, /* (315) expression ::= expression NK_STAR expression */
  {  312,   -3 }, /* (316) expression ::= expression NK_SLASH expression */
  {  312,   -3 }, /* (317) expression ::= expression NK_REM expression */
  {  312,   -3 }, /* (318) expression ::= column_reference NK_ARROW NK_STRING */
  {  295,   -1 }, /* (319) expression_list ::= expression */
  {  295,   -3 }, /* (320) expression_list ::= expression_list NK_COMMA expression */
  {  314,   -1 }, /* (321) column_reference ::= column_name */
  {  314,   -3 }, /* (322) column_reference ::= table_name NK_DOT column_name */
  {  313,   -1 }, /* (323) pseudo_column ::= ROWTS */
  {  313,   -1 }, /* (324) pseudo_column ::= TBNAME */
  {  313,   -3 }, /* (325) pseudo_column ::= table_name NK_DOT TBNAME */
  {  313,   -1 }, /* (326) pseudo_column ::= QSTARTTS */
  {  313,   -1 }, /* (327) pseudo_column ::= QENDTS */
  {  313,   -1 }, /* (328) pseudo_column ::= WSTARTTS */
  {  313,   -1 }, /* (329) pseudo_column ::= WENDTS */
  {  313,   -1 }, /* (330) pseudo_column ::= WDURATION */
  {  315,   -4 }, /* (331) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  315,   -4 }, /* (332) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  315,   -6 }, /* (333) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  315,   -1 }, /* (334) function_expression ::= literal_func */
  {  309,   -3 }, /* (335) literal_func ::= noarg_func NK_LP NK_RP */
  {  309,   -1 }, /* (336) literal_func ::= NOW */
  {  319,   -1 }, /* (337) noarg_func ::= NOW */
  {  319,   -1 }, /* (338) noarg_func ::= TODAY */
  {  319,   -1 }, /* (339) noarg_func ::= TIMEZONE */
  {  317,   -1 }, /* (340) star_func ::= COUNT */
  {  317,   -1 }, /* (341) star_func ::= FIRST */
  {  317,   -1 }, /* (342) star_func ::= LAST */
  {  317,   -1 }, /* (343) star_func ::= LAST_ROW */
  {  318,   -1 }, /* (344) star_func_para_list ::= NK_STAR */
  {  318,   -1 }, /* (345) star_func_para_list ::= other_para_list */
  {  320,   -1 }, /* (346) other_para_list ::= star_func_para */
  {  320,   -3 }, /* (347) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  321,   -1 }, /* (348) star_func_para ::= expression */
  {  321,   -3 }, /* (349) star_func_para ::= table_name NK_DOT NK_STAR */
  {  322,   -3 }, /* (350) predicate ::= expression compare_op expression */
  {  322,   -5 }, /* (351) predicate ::= expression BETWEEN expression AND expression */
  {  322,   -6 }, /* (352) predicate ::= expression NOT BETWEEN expression AND expression */
  {  322,   -3 }, /* (353) predicate ::= expression IS NULL */
  {  322,   -4 }, /* (354) predicate ::= expression IS NOT NULL */
  {  322,   -3 }, /* (355) predicate ::= expression in_op in_predicate_value */
  {  323,   -1 }, /* (356) compare_op ::= NK_LT */
  {  323,   -1 }, /* (357) compare_op ::= NK_GT */
  {  323,   -1 }, /* (358) compare_op ::= NK_LE */
  {  323,   -1 }, /* (359) compare_op ::= NK_GE */
  {  323,   -1 }, /* (360) compare_op ::= NK_NE */
  {  323,   -1 }, /* (361) compare_op ::= NK_EQ */
  {  323,   -1 }, /* (362) compare_op ::= LIKE */
  {  323,   -2 }, /* (363) compare_op ::= NOT LIKE */
  {  323,   -1 }, /* (364) compare_op ::= MATCH */
  {  323,   -1 }, /* (365) compare_op ::= NMATCH */
  {  323,   -1 }, /* (366) compare_op ::= CONTAINS */
  {  324,   -1 }, /* (367) in_op ::= IN */
  {  324,   -2 }, /* (368) in_op ::= NOT IN */
  {  325,   -3 }, /* (369) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  326,   -1 }, /* (370) boolean_value_expression ::= boolean_primary */
  {  326,   -2 }, /* (371) boolean_value_expression ::= NOT boolean_primary */
  {  326,   -3 }, /* (372) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  326,   -3 }, /* (373) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  327,   -1 }, /* (374) boolean_primary ::= predicate */
  {  327,   -3 }, /* (375) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  328,   -1 }, /* (376) common_expression ::= expression */
  {  328,   -1 }, /* (377) common_expression ::= boolean_value_expression */
  {  329,   -2 }, /* (378) from_clause ::= FROM table_reference_list */
  {  330,   -1 }, /* (379) table_reference_list ::= table_reference */
  {  330,   -3 }, /* (380) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  331,   -1 }, /* (381) table_reference ::= table_primary */
  {  331,   -1 }, /* (382) table_reference ::= joined_table */
  {  332,   -2 }, /* (383) table_primary ::= table_name alias_opt */
  {  332,   -4 }, /* (384) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  332,   -2 }, /* (385) table_primary ::= subquery alias_opt */
  {  332,   -1 }, /* (386) table_primary ::= parenthesized_joined_table */
  {  334,    0 }, /* (387) alias_opt ::= */
  {  334,   -1 }, /* (388) alias_opt ::= table_alias */
  {  334,   -2 }, /* (389) alias_opt ::= AS table_alias */
  {  335,   -3 }, /* (390) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  335,   -3 }, /* (391) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  333,   -6 }, /* (392) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  336,    0 }, /* (393) join_type ::= */
  {  336,   -1 }, /* (394) join_type ::= INNER */
  {  338,   -9 }, /* (395) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  339,    0 }, /* (396) set_quantifier_opt ::= */
  {  339,   -1 }, /* (397) set_quantifier_opt ::= DISTINCT */
  {  339,   -1 }, /* (398) set_quantifier_opt ::= ALL */
  {  340,   -1 }, /* (399) select_list ::= NK_STAR */
  {  340,   -1 }, /* (400) select_list ::= select_sublist */
  {  345,   -1 }, /* (401) select_sublist ::= select_item */
  {  345,   -3 }, /* (402) select_sublist ::= select_sublist NK_COMMA select_item */
  {  346,   -1 }, /* (403) select_item ::= common_expression */
  {  346,   -2 }, /* (404) select_item ::= common_expression column_alias */
  {  346,   -3 }, /* (405) select_item ::= common_expression AS column_alias */
  {  346,   -3 }, /* (406) select_item ::= table_name NK_DOT NK_STAR */
  {  307,    0 }, /* (407) where_clause_opt ::= */
  {  307,   -2 }, /* (408) where_clause_opt ::= WHERE search_condition */
  {  341,    0 }, /* (409) partition_by_clause_opt ::= */
  {  341,   -3 }, /* (410) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  342,    0 }, /* (411) twindow_clause_opt ::= */
  {  342,   -6 }, /* (412) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  342,   -4 }, /* (413) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  342,   -6 }, /* (414) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  342,   -8 }, /* (415) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  293,    0 }, /* (416) sliding_opt ::= */
  {  293,   -4 }, /* (417) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  347,    0 }, /* (418) fill_opt ::= */
  {  347,   -4 }, /* (419) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  347,   -6 }, /* (420) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  348,   -1 }, /* (421) fill_mode ::= NONE */
  {  348,   -1 }, /* (422) fill_mode ::= PREV */
  {  348,   -1 }, /* (423) fill_mode ::= NULL */
  {  348,   -1 }, /* (424) fill_mode ::= LINEAR */
  {  348,   -1 }, /* (425) fill_mode ::= NEXT */
  {  343,    0 }, /* (426) group_by_clause_opt ::= */
  {  343,   -3 }, /* (427) group_by_clause_opt ::= GROUP BY group_by_list */
  {  349,   -1 }, /* (428) group_by_list ::= expression */
  {  349,   -3 }, /* (429) group_by_list ::= group_by_list NK_COMMA expression */
  {  344,    0 }, /* (430) having_clause_opt ::= */
  {  344,   -2 }, /* (431) having_clause_opt ::= HAVING search_condition */
  {  297,   -4 }, /* (432) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  350,   -1 }, /* (433) query_expression_body ::= query_primary */
  {  350,   -4 }, /* (434) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  350,   -3 }, /* (435) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  354,   -1 }, /* (436) query_primary ::= query_specification */
  {  354,   -6 }, /* (437) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  351,    0 }, /* (438) order_by_clause_opt ::= */
  {  351,   -3 }, /* (439) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  352,    0 }, /* (440) slimit_clause_opt ::= */
  {  352,   -2 }, /* (441) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  352,   -4 }, /* (442) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  352,   -4 }, /* (443) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  353,    0 }, /* (444) limit_clause_opt ::= */
  {  353,   -2 }, /* (445) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  353,   -4 }, /* (446) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  353,   -4 }, /* (447) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  316,   -3 }, /* (448) subquery ::= NK_LP query_expression NK_RP */
  {  337,   -1 }, /* (449) search_condition ::= common_expression */
  {  355,   -1 }, /* (450) sort_specification_list ::= sort_specification */
  {  355,   -3 }, /* (451) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  356,   -3 }, /* (452) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  357,    0 }, /* (453) ordering_specification_opt ::= */
  {  357,   -1 }, /* (454) ordering_specification_opt ::= ASC */
  {  357,   -1 }, /* (455) ordering_specification_opt ::= DESC */
  {  358,    0 }, /* (456) null_ordering_opt ::= */
  {  358,   -2 }, /* (457) null_ordering_opt ::= NULLS FIRST */
  {  358,   -2 }, /* (458) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,240,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,243,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,241,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy421, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy421, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy669, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy669, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy669 = yymsp[0].minor.yy669; }
  yymsp[0].minor.yy669 = yylhsminor.yy669;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy669 = yymsp[-2].minor.yy669 | yymsp[0].minor.yy669; }
  yymsp[-2].minor.yy669 = yylhsminor.yy669;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy421 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy421 = yylhsminor.yy421;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy421 = yymsp[-2].minor.yy421; }
  yymsp[-2].minor.yy421 = yylhsminor.yy421;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy421, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 294: /* db_name ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* table_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* column_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* function_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* table_alias ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* column_alias ::= NK_ID */ yytestcase(yyruleno==299);
      case 300: /* user_name ::= NK_ID */ yytestcase(yyruleno==300);
      case 301: /* index_name ::= NK_ID */ yytestcase(yyruleno==301);
      case 302: /* topic_name ::= NK_ID */ yytestcase(yyruleno==302);
      case 303: /* stream_name ::= NK_ID */ yytestcase(yyruleno==303);
      case 304: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==304);
      case 337: /* noarg_func ::= NOW */ yytestcase(yyruleno==337);
      case 338: /* noarg_func ::= TODAY */ yytestcase(yyruleno==338);
      case 339: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==339);
      case 340: /* star_func ::= COUNT */ yytestcase(yyruleno==340);
      case 341: /* star_func ::= FIRST */ yytestcase(yyruleno==341);
      case 342: /* star_func ::= LAST */ yytestcase(yyruleno==342);
      case 343: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==343);
{ yylhsminor.yy421 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy421 = yylhsminor.yy421;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy621, &yymsp[-1].minor.yy421, yymsp[0].minor.yy674); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy421, yymsp[0].minor.yy674); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy621 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 237: /* analyze_opt ::= */ yytestcase(yyruleno==237);
      case 245: /* agg_func_opt ::= */ yytestcase(yyruleno==245);
      case 396: /* set_quantifier_opt ::= */ yytestcase(yyruleno==396);
{ yymsp[1].minor.yy621 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy621 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy674 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 71: /* db_options ::= db_options DURATION NK_INTEGER */
      case 72: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_KEEP, yymsp[0].minor.yy530); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_RETENTIONS, yymsp[0].minor.yy530); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy674 = createAlterDatabaseOptions(pCxt); yylhsminor.yy674 = setAlterDatabaseOption(pCxt, yylhsminor.yy674, &yymsp[0].minor.yy557); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy674 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy674, &yymsp[0].minor.yy557); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy557.type = DB_OPTION_KEEP; yymsp[-1].minor.yy557.pList = yymsp[0].minor.yy530; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_PAGES; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_STRICT; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_WAL; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy530 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 266: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==266);
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy530 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 176: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==176);
      case 181: /* col_name_list ::= col_name */ yytestcase(yyruleno==181);
      case 225: /* func_list ::= func */ yytestcase(yyruleno==225);
      case 292: /* literal_list ::= signed_literal */ yytestcase(yyruleno==292);
      case 346: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==346);
      case 401: /* select_sublist ::= select_item */ yytestcase(yyruleno==401);
      case 450: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==450);
{ yylhsminor.yy530 = createNodeList(pCxt, yymsp[0].minor.yy674); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 177: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==177);
      case 182: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==182);
      case 226: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==226);
      case 293: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==293);
      case 347: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==347);
      case 402: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==402);
      case 451: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==451);
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, yymsp[0].minor.yy674); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy674 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy621, yymsp[-5].minor.yy674, yymsp[-3].minor.yy530, yymsp[-1].minor.yy530, yymsp[0].minor.yy674); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy530); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy530); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy621, yymsp[0].minor.yy674); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 269: /* cmd ::= query_expression */ yytestcase(yyruleno==269);
{ pCxt->pRootNode = yymsp[0].minor.yy674; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy674 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy674 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy674, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy421); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy674 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy674 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy674, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy421); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy674 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy674 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy674, &yymsp[-2].minor.yy421, yymsp[0].minor.yy674); }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-1].minor.yy530, yymsp[0].minor.yy674); }
  yymsp[-1].minor.yy530 = yylhsminor.yy530;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy674 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy621, yymsp[-8].minor.yy674, yymsp[-6].minor.yy674, yymsp[-5].minor.yy530, yymsp[-2].minor.yy530, yymsp[0].minor.yy674); }
  yymsp[-9].minor.yy674 = yylhsminor.yy674;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy674 = createDropTableClause(pCxt, yymsp[-1].minor.yy621, yymsp[0].minor.yy674); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 409: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==409);
      case 426: /* group_by_clause_opt ::= */ yytestcase(yyruleno==426);
      case 438: /* order_by_clause_opt ::= */ yytestcase(yyruleno==438);
{ yymsp[1].minor.yy530 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy530 = yymsp[-1].minor.yy530; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy674 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy421, NULL); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy674 = createRealTableNode(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421, NULL); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy674 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690, NULL); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy674 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy421, yymsp[-2].minor.yy690, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy690 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 345: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==345);
      case 400: /* select_list ::= select_sublist */ yytestcase(yyruleno==400);
{ yylhsminor.yy530 = yymsp[0].minor.yy530; }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy530 = yymsp[-1].minor.yy530; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy674 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-2].minor.yy674, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 165: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-2].minor.yy674, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy530); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 166: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-2].minor.yy674, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy530); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 167: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-4].minor.yy674, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy530); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 168: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-2].minor.yy674, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 169: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-4].minor.yy674, TABLE_OPTION_SMA, yymsp[-1].minor.yy530); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 170: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy674 = createAlterTableOptions(pCxt); yylhsminor.yy674 = setTableOption(pCxt, yylhsminor.yy674, yymsp[0].minor.yy557.type, &yymsp[0].minor.yy557.val); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 171: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-1].minor.yy674, yymsp[0].minor.yy557.type, &yymsp[0].minor.yy557.val); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 172: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy557.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 173: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy557.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 174: /* duration_list ::= duration_literal */
      case 319: /* expression_list ::= expression */ yytestcase(yyruleno==319);
{ yylhsminor.yy530 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy674)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 175: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 320: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==320);
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, releaseRawExprNode(pCxt, yymsp[0].minor.yy674)); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 178: /* rollup_func_name ::= function_name */
{ yylhsminor.yy674 = createFunctionNode(pCxt, &yymsp[0].minor.yy421, NULL); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 179: /* rollup_func_name ::= FIRST */
      case 180: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==180);
{ yylhsminor.yy674 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 183: /* col_name ::= column_name */
{ yylhsminor.yy674 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy421); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 184: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 188: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 189: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy674, NULL); }
        break;
      case 190: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 195: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 196: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 197: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW LICENCE */
      case 200: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==200);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 202: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy674); }
        break;
      case 203: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy674); }
        break;
      case 204: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 205: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 206: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 207: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 208: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 209: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 210: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 211: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 212: /* db_name_cond_opt ::= */
      case 217: /* from_db_opt ::= */ yytestcase(yyruleno==217);
{ yymsp[1].minor.yy674 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 213: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 214: /* like_pattern_opt ::= */
      case 222: /* index_options ::= */ yytestcase(yyruleno==222);
      case 251: /* into_opt ::= */ yytestcase(yyruleno==251);
      case 407: /* where_clause_opt ::= */ yytestcase(yyruleno==407);
      case 411: /* twindow_clause_opt ::= */ yytestcase(yyruleno==411);
      case 416: /* sliding_opt ::= */ yytestcase(yyruleno==416);
      case 418: /* fill_opt ::= */ yytestcase(yyruleno==418);
      case 430: /* having_clause_opt ::= */ yytestcase(yyruleno==430);
      case 440: /* slimit_clause_opt ::= */ yytestcase(yyruleno==440);
      case 444: /* limit_clause_opt ::= */ yytestcase(yyruleno==444);
{ yymsp[1].minor.yy674 = NULL; }
        break;
      case 215: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 216: /* table_name_cond ::= table_name */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy421); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 218: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy421); }
        break;
      case 219: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy621, &yymsp[-3].minor.yy421, &yymsp[-1].minor.yy421, NULL, yymsp[0].minor.yy674); }
        break;
      case 220: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy621, &yymsp[-5].minor.yy421, &yymsp[-3].minor.yy421, yymsp[-1].minor.yy530, NULL); }
        break;
      case 221: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy621, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 223: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy674 = createIndexOption(pCxt, yymsp[-6].minor.yy530, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), NULL, yymsp[0].minor.yy674); }
        break;
      case 224: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy674 = createIndexOption(pCxt, yymsp[-8].minor.yy530, releaseRawExprNode(pCxt, yymsp[-4].minor.yy674), releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), yymsp[0].minor.yy674); }
        break;
      case 227: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy674 = createFunctionNode(pCxt, &yymsp[-3].minor.yy421, yymsp[-1].minor.yy530); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 228: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy621, &yymsp[-2].minor.yy421, yymsp[0].minor.yy674, NULL, NULL); }
        break;
      case 229: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy621, &yymsp[-3].minor.yy421, NULL, &yymsp[0].minor.yy421, NULL); }
        break;
      case 230: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy621, &yymsp[-3].minor.yy421, NULL, NULL, yymsp[0].minor.yy674); }
        break;
      case 231: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 232: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy621, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 233: /* cmd ::= DESC full_table_name */
      case 234: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==234);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy674); }
        break;
      case 235: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 236: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy621, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 238: /* analyze_opt ::= ANALYZE */
      case 246: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==246);
      case 397: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==397);
{ yymsp[0].minor.yy621 = true; }
        break;
      case 239: /* explain_options ::= */
{ yymsp[1].minor.yy674 = createDefaultExplainOptions(pCxt); }
        break;
      case 240: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy674 = setExplainVerbose(pCxt, yymsp[-2].minor.yy674, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 241: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy674 = setExplainRatio(pCxt, yymsp[-2].minor.yy674, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 242: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy530); }
        break;
      case 243: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy621, yymsp[-8].minor.yy621, &yymsp[-5].minor.yy421, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy690, yymsp[0].minor.yy42); }
        break;
      case 244: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 247: /* bufsize_opt ::= */
{ yymsp[1].minor.yy42 = 0; }
        break;
      case 248: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy42 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 249: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy621, &yymsp[-4].minor.yy421, yymsp[-2].minor.yy674, yymsp[-3].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 250: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 252: /* into_opt ::= INTO full_table_name */
      case 378: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==378);
      case 408: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==408);
      case 431: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==431);
{ yymsp[-1].minor.yy674 = yymsp[0].minor.yy674; }
        break;
      case 253: /* stream_options ::= */
{ yymsp[1].minor.yy674 = createStreamOptions(pCxt); }
        break;
      case 254: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy674)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy674 = yymsp[-2].minor.yy674; }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 255: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy674)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy674 = yymsp[-2].minor.yy674; }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 256: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy674)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy674)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy674); yylhsminor.yy674 = yymsp[-3].minor.yy674; }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 257: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy674)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy674); yylhsminor.yy674 = yymsp[-2].minor.yy674; }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 258: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 259: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 260: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 261: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 262: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 263: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy530); }
        break;
      case 264: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 265: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy530 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 267: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy421); }
        break;
      case 268: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 270: /* literal ::= NK_INTEGER */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 271: /* literal ::= NK_FLOAT */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 272: /* literal ::= NK_STRING */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 273: /* literal ::= NK_BOOL */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 274: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 275: /* literal ::= duration_literal */
      case 285: /* signed_literal ::= signed */ yytestcase(yyruleno==285);
      case 305: /* expression ::= literal */ yytestcase(yyruleno==305);
      case 306: /* expression ::= pseudo_column */ yytestcase(yyruleno==306);
      case 307: /* expression ::= column_reference */ yytestcase(yyruleno==307);
      case 308: /* expression ::= function_expression */ yytestcase(yyruleno==308);
      case 309: /* expression ::= subquery */ yytestcase(yyruleno==309);
      case 334: /* function_expression ::= literal_func */ yytestcase(yyruleno==334);
      case 370: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==370);
      case 374: /* boolean_primary ::= predicate */ yytestcase(yyruleno==374);
      case 376: /* common_expression ::= expression */ yytestcase(yyruleno==376);
      case 377: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==377);
      case 379: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==379);
      case 381: /* table_reference ::= table_primary */ yytestcase(yyruleno==381);
      case 382: /* table_reference ::= joined_table */ yytestcase(yyruleno==382);
      case 386: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==386);
      case 433: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==433);
      case 436: /* query_primary ::= query_specification */ yytestcase(yyruleno==436);
{ yylhsminor.yy674 = yymsp[0].minor.yy674; }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 276: /* literal ::= NULL */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 277: /* literal ::= NK_QUESTION */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 278: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 279: /* signed ::= NK_INTEGER */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 280: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 281: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 282: /* signed ::= NK_FLOAT */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 283: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 284: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 286: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 287: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 288: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 289: /* signed_literal ::= duration_literal */
      case 291: /* signed_literal ::= literal_func */ yytestcase(yyruleno==291);
      case 348: /* star_func_para ::= expression */ yytestcase(yyruleno==348);
      case 403: /* select_item ::= common_expression */ yytestcase(yyruleno==403);
      case 449: /* search_condition ::= common_expression */ yytestcase(yyruleno==449);
{ yylhsminor.yy674 = releaseRawExprNode(pCxt, yymsp[0].minor.yy674); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 290: /* signed_literal ::= NULL */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 310: /* expression ::= NK_LP expression NK_RP */
      case 375: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==375);
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 311: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy674));
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 312: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy674), NULL));
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 313: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 314: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 315: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 316: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 317: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 318: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 321: /* column_reference ::= column_name */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy421, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy421)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 322: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421, createColumnNode(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 323: /* pseudo_column ::= ROWTS */
      case 324: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==324);
      case 326: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==326);
      case 327: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==327);
      case 328: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==328);
      case 329: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==329);
      case 330: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==330);
      case 336: /* literal_func ::= NOW */ yytestcase(yyruleno==336);
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 325: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy421)))); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 331: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 332: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==332);
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy421, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy421, yymsp[-1].minor.yy530)); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 333: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), yymsp[-1].minor.yy690)); }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 335: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy421, NULL)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 344: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy530 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 349: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 406: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==406);
{ yylhsminor.yy674 = createColumnNode(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 350: /* predicate ::= expression compare_op expression */
      case 355: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==355);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy28, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 351: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy674), releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 352: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy674), releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 353: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), NULL));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 354: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), NULL));
                                                                                  }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 356: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy28 = OP_TYPE_LOWER_THAN; }
        break;
      case 357: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy28 = OP_TYPE_GREATER_THAN; }
        break;
      case 358: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy28 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 359: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy28 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 360: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy28 = OP_TYPE_NOT_EQUAL; }
        break;
      case 361: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy28 = OP_TYPE_EQUAL; }
        break;
      case 362: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy28 = OP_TYPE_LIKE; }
        break;
      case 363: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy28 = OP_TYPE_NOT_LIKE; }
        break;
      case 364: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy28 = OP_TYPE_MATCH; }
        break;
      case 365: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy28 = OP_TYPE_NMATCH; }
        break;
      case 366: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy28 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 367: /* in_op ::= IN */
{ yymsp[0].minor.yy28 = OP_TYPE_IN; }
        break;
      case 368: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy28 = OP_TYPE_NOT_IN; }
        break;
      case 369: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy530)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 371: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy674), NULL));
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 372: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 373: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 380: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy674 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy674, yymsp[0].minor.yy674, NULL); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 383: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy674 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 384: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy674 = createRealTableNode(pCxt, &yymsp[-3].minor.yy421, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 385: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy674 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674), &yymsp[0].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 387: /* alias_opt ::= */
{ yymsp[1].minor.yy421 = nil_token;  }
        break;
      case 388: /* alias_opt ::= table_alias */
{ yylhsminor.yy421 = yymsp[0].minor.yy421; }
  yymsp[0].minor.yy421 = yylhsminor.yy421;
        break;
      case 389: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy421 = yymsp[0].minor.yy421; }
        break;
      case 390: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 391: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==391);
{ yymsp[-2].minor.yy674 = yymsp[-1].minor.yy674; }
        break;
      case 392: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy674 = createJoinTableNode(pCxt, yymsp[-4].minor.yy636, yymsp[-5].minor.yy674, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 393: /* join_type ::= */
{ yymsp[1].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 394: /* join_type ::= INNER */
{ yymsp[0].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 395: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy674 = createSelectStmt(pCxt, yymsp[-7].minor.yy621, yymsp[-6].minor.yy530, yymsp[-5].minor.yy674);
                                                                                    yymsp[-8].minor.yy674 = addWhereClause(pCxt, yymsp[-8].minor.yy674, yymsp[-4].minor.yy674);
                                                                                    yymsp[-8].minor.yy674 = addPartitionByClause(pCxt, yymsp[-8].minor.yy674, yymsp[-3].minor.yy530);
                                                                                    yymsp[-8].minor.yy674 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy674, yymsp[-2].minor.yy674);
                                                                                    yymsp[-8].minor.yy674 = addGroupByClause(pCxt, yymsp[-8].minor.yy674, yymsp[-1].minor.yy530);
                                                                                    yymsp[-8].minor.yy674 = addHavingClause(pCxt, yymsp[-8].minor.yy674, yymsp[0].minor.yy674);
                                                                                  }
        break;
      case 398: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy621 = false; }
        break;
      case 399: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy530 = NULL; }
        break;
      case 404: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy674 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674), &yymsp[0].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 405: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy674 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), &yymsp[0].minor.yy421); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 410: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 427: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==427);
      case 439: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==439);
{ yymsp[-2].minor.yy530 = yymsp[0].minor.yy530; }
        break;
      case 412: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy674 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), releaseRawExprNode(pCxt, yymsp[-1].minor.yy674)); }
        break;
      case 413: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy674 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674)); }
        break;
      case 414: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy674 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), NULL, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 415: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy674 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy674), releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 417: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy674 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy674); }
        break;
      case 419: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy674 = createFillNode(pCxt, yymsp[-1].minor.yy320, NULL); }
        break;
      case 420: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy674 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy530)); }
        break;
      case 421: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy320 = FILL_MODE_NONE; }
        break;
      case 422: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy320 = FILL_MODE_PREV; }
        break;
      case 423: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy320 = FILL_MODE_NULL; }
        break;
      case 424: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy320 = FILL_MODE_LINEAR; }
        break;
      case 425: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy320 = FILL_MODE_NEXT; }
        break;
      case 428: /* group_by_list ::= expression */
{ yylhsminor.yy530 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 429: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 432: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy674 = addOrderByClause(pCxt, yymsp[-3].minor.yy674, yymsp[-2].minor.yy530);
                                                                                    yylhsminor.yy674 = addSlimitClause(pCxt, yylhsminor.yy674, yymsp[-1].minor.yy674);
                                                                                    yylhsminor.yy674 = addLimitClause(pCxt, yylhsminor.yy674, yymsp[0].minor.yy674);
                                                                                  }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 434: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy674 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 435: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy674 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 437: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy674 = yymsp[-4].minor.yy674; }
  yy_destructor(yypParser,351,&yymsp[-3].minor);
  yy_destructor(yypParser,352,&yymsp[-2].minor);
  yy_destructor(yypParser,353,&yymsp[-1].minor);
        break;
      case 441: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 445: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==445);
{ yymsp[-1].minor.yy674 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 442: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 446: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==446);
{ yymsp[-3].minor.yy674 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 443: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 447: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==447);
{ yymsp[-3].minor.yy674 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 448: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy674); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 452: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy674 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), yymsp[-1].minor.yy610, yymsp[0].minor.yy107); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 453: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy610 = ORDER_ASC; }
        break;
      case 454: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy610 = ORDER_ASC; }
        break;
      case 455: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy610 = ORDER_DESC; }
        break;
      case 456: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy107 = NULL_ORDER_DEFAULT; }
        break;
      case 457: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy107 = NULL_ORDER_FIRST; }
        break;
      case 458: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy107 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
