###################################################################
#           Copyright (c) 2021 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
from util.log import *
from util.cases import *
from util.sql import *


class TDTestCase:
    def caseDescription(self):
        '''
        case1<Ganlin Zhao>: [TD-11216]<feature>: Time window related keywords
        '''
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def getBuildPath(self):
        selfPath = os.path.dirname(os.path.realpath(__file__))

        if ("community" in selfPath):
            projPath = selfPath[:selfPath.find("community")]
        else:
            projPath = selfPath[:selfPath.find("tests")]

        for root, dirs, files in os.walk(projPath):
            if ("taosd" in files):
                rootRealPath = os.path.dirname(os.path.realpath(root))
                if ("packaging" not in rootRealPath):
                    buildPath = root[:len(root) - len("/build/bin")]
                    break
        return buildPath

    def checkTimestampEqual(self, elm, expect_elm):
        caller = inspect.getframeinfo(inspect.stack()[1][0])
        if len(elm) == len(expect_elm):
            delta = abs(int(elm[-1]) - int(expect_elm[-1]))
            if delta == 1: #ignore 1 second diff
                new_elm = expect_elm[0:-1] + elm[-1]
            else:
                new_elm = expect_elm;
            if elm == new_elm:
                tdLog.info("sql:%s, elm:%s == expect_elm:%s" % (tdSql.sql, elm, new_elm))
            else:
                args = (caller.filename, caller.lineno, tdSql.sql, elm, new_elm)
                tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)
        else:
            args = (caller.filename, caller.lineno, tdSql.sql, elm, expect_elm)
            tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)


    def run(self):
        print("running {}".format(__file__))

        #Prepare data
        #db precision "ms"
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, c0 int) tags (t0 int);")
        tdSql.execute("create table ctb1 using stb tags (1);")
        tdSql.execute("create table ctb2 using stb tags (2);")
        tdSql.execute("create table tb (ts timestamp, c0 int);")

        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:05', 5)")

        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:00', 0)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:01', 1)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:02', 2)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:03', 3)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:04', 4)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:05', 5)")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', 5)")

        #db precision "us"
        tdSql.execute("drop database if exists db_u")
        tdSql.execute("create database if not exists db_u precision 'us'")
        tdSql.execute('use db_u')

        tdSql.execute("create stable stb (ts timestamp, c0 int) tags (t0 int);")
        tdSql.execute("create table ctb1 using stb tags (1);")
        tdSql.execute("create table ctb2 using stb tags (2);")
        tdSql.execute("create table tb (ts timestamp, c0 int);")

        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:05', 5)")

        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:00', 0)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:01', 1)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:02', 2)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:03', 3)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:04', 4)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:05', 5)")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', 5)")

        #db precision "ns"
        tdSql.execute("drop database if exists db_n")
        tdSql.execute("create database if not exists db_n precision 'ns'")
        tdSql.execute('use db_n')

        tdSql.execute("create stable stb (ts timestamp, c0 int) tags (t0 int);")
        tdSql.execute("create table ctb1 using stb tags (1);")
        tdSql.execute("create table ctb2 using stb tags (2);")
        tdSql.execute("create table tb (ts timestamp, c0 int);")

        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into ctb1 values ('2022-02-02 02:00:05', 5)")

        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:00', 0)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:01', 1)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:02', 2)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:03', 3)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:04', 4)")
        tdSql.execute("insert into ctb2 values ('2022-02-02 03:00:05', 5)")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', 0)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', 1)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', 2)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:03', 3)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:04', 4)")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:05', 5)")


        #execute query
        print("============== STEP 1: select _qsatrt,_qstop,_qduration in projection query  ================== ")

        # db precision "ms"
        tdSql.execute('use db_m')

        ## _qstart
        tdSql.query("select _qstart from tb;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstart from ctb1;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstart from stb;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        #res = tdSql.getData(6, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(7, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(8, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(9, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(10, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(11, 0)

        tdSql.query("select _qstart from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        #res = tdSql.getData(6, 0)
        #tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        #res = tdSql.getData(7, 0)
        #tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        #res = tdSql.getData(8, 0)
        #tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstart from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstart from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)

        tdSql.query("select _qstart,ts from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,ts from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,ts from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(9)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(6, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(7, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(8, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,_c0 from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,_c0 from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,_c0 from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(9)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(6, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(7, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(8, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,tbname from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,tbname from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,tbname from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(9)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(6, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(7, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(8, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        ##_qstop
        tdSql.query("select _qstop from tb;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstop from ctb1;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstop from stb;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        #res = tdSql.getData(6, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(7, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(8, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(9, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(10, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(11, 0)

        tdSql.query("select _qstop from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)

        tdSql.query("select _qstop from tb where ts >= '2022-02-02 02:00:02' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstop from ctb1 where ts >= '2022-02-02 02:00:02' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstop from stb where ts >= '2022-02-02 02:00:02' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)

        tdSql.query("select _qstop,ts from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,ts from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,ts from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,_c0 from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,_c0 from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,_c0 from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,tbname from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,tbname from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,tbname from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        ##_qduration
        tdSql.query("select _qduration from tb;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration from ctb1;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration from stb;")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(res, None)
        #res = tdSql.getData(6, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(7, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(8, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(9, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(10, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(11, 0)

        tdSql.query("select _qduration from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(5, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(6, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(7, 0)
        #tdSql.checkEqual(res, None)
        #res = tdSql.getData(8, 0)
        #tdSql.checkEqual(res, None)

        tdSql.query("select _qduration from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(res, None)
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(res, None)


        tdSql.query("select _qduration from tb where ts >= '2022-02-02 02:00:02' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qduration from ctb1 where ts >= '2022-02-02 02:00:02' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qduration from stb where ts >= '2022-02-02 02:00:02' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)

        tdSql.query("select _qduration from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)

        tdSql.query("select _qduration,ts from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration,ts from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration,ts from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)

        tdSql.query("select _qduration,_c0 from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration,_c0 from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration,_c0 from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)

        tdSql.query("select _qduration,tbname from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration,tbname from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)
        tdSql.query("select _qduration,tbname from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 4000)
        tdSql.checkData(1, 0, 4000)
        tdSql.checkData(2, 0, 4000)

        #_qstart,_qstop,_qduration together
        tdSql.query("select _qstart,_qstop,_qduration,c0 from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        tdSql.checkData(0, 2, 4000)
        tdSql.checkData(1, 2, 4000)
        tdSql.checkData(2, 2, 4000)
        tdSql.query("select _qstart,_qstop,_qduration,c0 from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        tdSql.checkData(0, 2, 4000)
        tdSql.checkData(1, 2, 4000)
        tdSql.checkData(2, 2, 4000)
        tdSql.query("select _qstart,_qstop,_qduration,c0 from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:07';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(0, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(1, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        res = tdSql.getData(2, 1)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:07")
        tdSql.checkData(0, 2, 4000)
        tdSql.checkData(1, 2, 4000)
        tdSql.checkData(2, 2, 4000)

        # db precision "us"
        tdSql.execute('use db_u')

        ##_qstart
        tdSql.query("select _qstart from tb where ts >= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        tdSql.query("select _qstart from ctb1 where ts >= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(2)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        tdSql.query("select _qstart from stb where ts >= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(6)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        #res = tdSql.getData(6, 0)
        #tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        #res = tdSql.getData(7, 0)
        #tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")

        ##_qstop
        tdSql.query("select _qstop from tb where ts <= '2022-02-02 02:00:02.123456';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        tdSql.query("select _qstop from ctb1 where ts <= '2022-02-02 02:00:02.123456';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        tdSql.query("select _qstop from stb where ts <= '2022-02-02 02:00:02.123456';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")

        ##_qduration
        tdSql.query("select _qduration from tb where ts >= '2022-02-02 02:00:00.123455' and ts <= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000001)
        tdSql.checkData(1, 0, 3000001)
        tdSql.checkData(2, 0, 3000001)
        tdSql.query("select _qduration from ctb1 where ts >= '2022-02-02 02:00:00.123455' and ts <= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000001)
        tdSql.checkData(1, 0, 3000001)
        tdSql.checkData(2, 0, 3000001)
        tdSql.query("select _qduration from stb where ts >= '2022-02-02 02:00:00.123455' and ts <= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000001)
        tdSql.checkData(1, 0, 3000001)
        tdSql.checkData(2, 0, 3000001)


        print("============== STEP 2: select _qstart,_qstop,_qduration in aggregate/selective/scalar query  ================== ")
        # db precision "ms"
        tdSql.execute('use db_m')

        ## _qstart
        tdSql.query("select _qstart,avg(c0) from tb;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstart,avg(c0) from ctb1;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstart,avg(c0) from stb;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)

        tdSql.query("select _qstart,avg(c0) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,avg(c0) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,avg(c0) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,avg(c0) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstart,avg(c0) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstart,avg(c0) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)

        tdSql.query("select _qstart,sum(c0) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,sum(c0) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,sum(c0) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,count(*) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,count(*) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,count(*) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,min(c0) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,min(c0) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,min(c0) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,first(c0) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,first(c0) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,first(c0) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,ceil(c0) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,ceil(c0) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,ceil(c0) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(9)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(6, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(7, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(8, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,round(1.5) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,round(1.5) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,round(1.5) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(9)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(6, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(7, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(8, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstart,abs(1.5) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,abs(1.5) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstart,abs(1.5) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(9)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(6, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(7, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(8, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        ##_qstop
        tdSql.query("select _qstop,avg(c0) from tb;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstop,avg(c0) from ctb1;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qstop,avg(c0) from stb;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)

        tdSql.query("select _qstop,avg(c0) from tb where ts <= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstop,avg(c0) from ctb1 where ts <= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query("select _qstop,avg(c0) from stb where ts <= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query("select _qstop,avg(c0) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstop,avg(c0) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qstop,avg(c0) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)

        tdSql.query("select _qstop,sum(c0) from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,sum(c0) from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,sum(c0) from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,count(*) from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,count(*) from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,count(*) from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,min(c0) from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,min(c0) from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,min(c0) from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,first(c0) from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,first(c0) from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,first(c0) from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,ceil(c0) from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,ceil(c0) from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,ceil(c0) from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,round(1.5) from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,round(1.5) from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,round(1.5) from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query("select _qstop,abs(1.5) from tb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,abs(1.5) from ctb1 where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query("select _qstop,abs(1.5) from stb where ts <= '2022-02-02 02:00:02';")
        tdSql.checkRows(3)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        ##_qduration
        tdSql.query("select _qduration,avg(c0) from tb;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration,avg(c0) from ctb1;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration,avg(c0) from stb;")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)

        tdSql.query("select _qduration,avg(c0) from tb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration,avg(c0) from ctb1 where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration,avg(c0) from stb where ts >= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)

        tdSql.query("select _qduration,avg(c0) from tb where ts <= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration,avg(c0) from ctb1 where ts <= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)
        tdSql.query("select _qduration,avg(c0) from stb where ts <= '2022-02-02 02:00:03';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(res, None)

        tdSql.query("select _qduration,avg(c0) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qduration,avg(c0) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)
        tdSql.query("select _qduration,avg(c0) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:00';")
        tdSql.checkRows(0)

        tdSql.query("select _qduration,sum(c0) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,sum(c0) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,sum(c0) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)

        tdSql.query("select _qduration,count(*) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,count(*) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,count(*) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)

        tdSql.query("select _qduration,min(c0) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,min(c0) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,min(c0) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)

        tdSql.query("select _qduration,first(c0) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,first(c0) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query("select _qduration,first(c0) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000)

        tdSql.query("select _qduration,ceil(c0) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query("select _qduration,ceil(c0) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query("select _qduration,ceil(c0) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)

        tdSql.query("select _qduration,round(1.5) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query("select _qduration,round(1.5) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query("select _qduration,round(1.5) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)

        tdSql.query("select _qduration,abs(1.5) from tb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query("select _qduration,abs(1.5) from ctb1 where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query("select _qduration,abs(1.5) from stb where ts >= '2022-02-02 02:00:03' and ts <= '2022-02-02 02:00:06';")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)

        # db precision "us"
        tdSql.execute('use db_u')

        ##_qstart
        tdSql.query("select _qstart,avg(c0) from tb where ts >= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        tdSql.query("select _qstart,avg(c0) from ctb1 where ts >= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")
        tdSql.query("select _qstart,avg(c0) from stb where ts >= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03.123456")

        ##_qstop
        tdSql.query("select _qstop,avg(c0) from tb where ts <= '2022-02-02 02:00:02.123456';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        tdSql.query("select _qstop,avg(c0) from ctb1 where ts <= '2022-02-02 02:00:02.123456';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")
        tdSql.query("select _qstop,avg(c0) from stb where ts <= '2022-02-02 02:00:02.123456';")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02.123456")

        ##_qduration
        tdSql.query("select _qduration,avg(c0) from tb where ts >= '2022-02-02 02:00:00.123455' and ts <= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000001)
        tdSql.query("select _qduration,avg(c0) from ctb1 where ts >= '2022-02-02 02:00:00.123455' and ts <= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000001)
        tdSql.query("select _qduration,avg(c0) from stb where ts >= '2022-02-02 02:00:00.123455' and ts <= '2022-02-02 02:00:03.123456';")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3000001)

        print("============== STEP 3: select _qsatrt,_qstop,_qduration in nested outer query  ================== ")
        tdSql.execute('use db_m')
        ##_wstart
        tdSql.query('select _qstart from (select _qstart,c0 from tb where ts >= "2022-02-02 02:00:03")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query('select _qstart from (select _qstart,c0 from ctb1 where ts >= "2022-02-02 02:00:03")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query('select _qstart from (select _qstart,c0 from stb where ts >= "2022-02-02 02:00:03")')
        tdSql.checkRows(9)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(3, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(4, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(5, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(6, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(7, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        res = tdSql.getData(8, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        tdSql.query('select _qstart from (select _qstart,sum(c0) from tb where ts >= "2022-02-02 02:00:03")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query('select _qstart from (select _qstart,sum(c0) from ctb1 where ts >= "2022-02-02 02:00:03")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")
        tdSql.query('select _qstart from (select _qstart,sum(c0) from stb where ts >= "2022-02-02 02:00:03")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:03")

        ##_wstop
        tdSql.query('select _qstop from (select _qstop,c0 from tb where ts <= "2022-02-02 02:00:02")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query('select _qstop from (select _qstop,c0 from ctb1 where ts <= "2022-02-02 02:00:02")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query('select _qstop from (select _qstop,c0 from stb where ts <= "2022-02-02 02:00:02")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(1, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        res = tdSql.getData(2, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        tdSql.query('select _qstop from (select _qstop,sum(c0) from tb where ts <= "2022-02-02 02:00:02")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query('select _qstop from (select _qstop,sum(c0) from ctb1 where ts <= "2022-02-02 02:00:02")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")
        tdSql.query('select _qstop from (select _qstop,sum(c0) from stb where ts <= "2022-02-02 02:00:02")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        res = tdSql.getData(0, 0)
        tdSql.checkEqual(str(res), "2022-02-02 02:00:02")

        ##_wduration
        tdSql.query('select _qduration from (select _qduration,c0 from tb where ts >= "2022-02-02 02:00:03" and ts <= "2022-02-02 02:00:06")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query('select _qduration from (select _qduration,c0 from ctb1 where ts >= "2022-02-02 02:00:03" and ts <= "2022-02-02 02:00:06")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)
        tdSql.query('select _qduration from (select _qduration,c0 from stb where ts >= "2022-02-02 02:00:03" and ts <= "2022-02-02 02:00:06")')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.checkData(1, 0, 3000)
        tdSql.checkData(2, 0, 3000)

        tdSql.query('select _qduration from (select _qduration,sum(c0) from tb where ts >= "2022-02-02 02:00:03" and ts <= "2022-02-02 02:00:06")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query('select _qduration from (select _qduration,sum(c0) from ctb1 where ts >= "2022-02-02 02:00:03" and ts <= "2022-02-02 02:00:06")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 3000)
        tdSql.query('select _qduration from (select _qduration,sum(c0) from stb where ts >= "2022-02-02 02:00:03" and ts <= "2022-02-02 02:00:06")')
        tdSql.checkRows(1)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 3000)
        print("============== STEP 5: select _qstart/_qstop/_qduration other cases  ================== ")

        #distinct
        tdSql.query("select distinct _qstart from tb")
        tdSql.query("select distinct _qstart from ctb1")
        tdSql.query("select distinct _qstart from stb")

        tdSql.query("select distinct _qstop from tb")
        tdSql.query("select distinct _qstop from ctb1")
        tdSql.query("select distinct _qstop from stb")

        tdSql.query("select distinct _qduration from tb")
        tdSql.query("select distinct _qduration from ctb1")
        tdSql.query("select distinct _qduration from stb")

        #_qs,col
        tdSql.query("select _qstart,ts from tb")
        tdSql.query("select _qstart,ts from ctb1")
        tdSql.query("select _qstart,ts from stb")
        tdSql.query("select _qstart,c0 from tb")
        tdSql.query("select _qstart,c0 from ctb1")
        tdSql.query("select _qstart,c0 from stb")
        tdSql.query("select _qstart,_qstart from tb")
        tdSql.query("select _qstart,_qstart from ctb1")
        tdSql.query("select _qstart,_qstart from stb")
        tdSql.query("select _qstart,t0 from ctb1")
        tdSql.query("select _qstart,t0 from stb")

        tdSql.query("select _qstop,ts from tb")
        tdSql.query("select _qstop,ts from ctb1")
        tdSql.query("select _qstop,ts from stb")
        tdSql.query("select _qstop,c0 from tb")
        tdSql.query("select _qstop,c0 from ctb1")
        tdSql.query("select _qstop,c0 from stb")
        tdSql.query("select _qstop,_qstop from tb")
        tdSql.query("select _qstop,_qstop from ctb1")
        tdSql.query("select _qstop,_qstop from stb")
        tdSql.query("select _qstop,t0 from ctb1")
        tdSql.query("select _qstop,t0 from stb")

        tdSql.query("select _qduration,ts from tb")
        tdSql.query("select _qduration,ts from ctb1")
        tdSql.query("select _qduration,ts from stb")
        tdSql.query("select _qduration,c0 from tb")
        tdSql.query("select _qduration,c0 from ctb1")
        tdSql.query("select _qduration,c0 from stb")
        tdSql.query("select _qduration,_qduration from tb")
        tdSql.query("select _qduration,_qduration from ctb1")
        tdSql.query("select _qduration,_qduration from stb")
        tdSql.query("select _qduration,t0 from ctb1")
        tdSql.query("select _qduration,t0 from stb")

        #_qs,constant
        tdSql.query("select _qstart,1 from tb")
        tdSql.query("select _qstart,1 from ctb1")
        tdSql.query("select _qstart,1 from stb")
        tdSql.query("select _qstart,true from tb")
        tdSql.query("select _qstart,true from ctb1")
        tdSql.query("select _qstart,true from stb")
        tdSql.query("select _qstart,'abc' from tb")
        tdSql.query("select _qstart,'abc' from ctb1")
        tdSql.query("select _qstart,'abc' from stb")

        tdSql.query("select _qstop,1 from tb")
        tdSql.query("select _qstop,1 from ctb1")
        tdSql.query("select _qstop,1 from stb")
        tdSql.query("select _qstop,true from tb")
        tdSql.query("select _qstop,true from ctb1")
        tdSql.query("select _qstop,true from stb")
        tdSql.query("select _qstop,'abc' from tb")
        tdSql.query("select _qstop,'abc' from ctb1")
        tdSql.query("select _qstop,'abc' from stb")

        tdSql.query("select _qduration,1 from tb")
        tdSql.query("select _qduration,1 from ctb1")
        tdSql.query("select _qduration,1 from stb")
        tdSql.query("select _qduration,true from tb")
        tdSql.query("select _qduration,true from ctb1")
        tdSql.query("select _qduration,true from stb")
        tdSql.query("select _qduration,'abc' from tb")
        tdSql.query("select _qduration,'abc' from ctb1")
        tdSql.query("select _qduration,'abc' from stb")

        #interval/sliding
        tdSql.query("select _qstart from tb interval (1s)")
        tdSql.query("select _qstart from ctb1 interval (1s)")
        tdSql.query("select _qstart from stb interval (1s)")

        tdSql.query("select _qstop from tb interval (1s)")
        tdSql.query("select _qstop from ctb1 interval (1s)")
        tdSql.query("select _qstop from stb interval (1s)")

        tdSql.query("select _qduration from tb interval (1s)")
        tdSql.query("select _qduration from ctb1 interval (1s)")
        tdSql.query("select _qduration from stb interval (1s)")

        tdSql.query("select _qstart from tb interval (1s) sliding (1s)")
        tdSql.query("select _qstart from ctb1 interval (1s) sliding (1s)")
        tdSql.query("select _qstart from stb interval (1s) sliding (1s)")

        tdSql.query("select _qstop from tb interval (1s) sliding (1s)")
        tdSql.query("select _qstop from ctb1 interval (1s) sliding (1s)")
        tdSql.query("select _qstop from stb interval (1s) sliding (1s)")

        tdSql.query("select _qduration from tb interval (1s) sliding (1s)")
        tdSql.query("select _qduration from ctb1 interval (1s) sliding (1s)")
        tdSql.query("select _qduration from stb interval (1s) sliding (1s)")


        #session_window
        tdSql.query("select _qstart,avg(c0) from tb session(ts, 1s)")
        tdSql.query("select _qstart,avg(c0) from ctb1 session(ts, 1s)")

        tdSql.query("select _qstop,avg(c0) from tb session(ts, 1s)")
        tdSql.query("select _qstop,avg(c0) from ctb1 session(ts, 1s)")

        tdSql.query("select _qduration,avg(c0) from tb session(ts, 1s)")
        tdSql.query("select _qduration,avg(c0) from ctb1 session(ts, 1s)")


        #order by
        tdSql.query("select _qstart from tb order by ts")
        tdSql.query("select _qstart from ctb1 order by ts")
        tdSql.query("select _qstart from stb order by ts")
        #tdSql.query("select _qstart from tb order by ts desc")
        #tdSql.query("select _qstart from ctb1 order by ts desc")
        #tdSql.query("select _qstart from stb order by ts desc")

        tdSql.query("select _qstop from tb order by ts")
        tdSql.query("select _qstop from ctb1 order by ts")
        tdSql.query("select _qstop from stb order by ts")
        #tdSql.query("select _qstop from tb order by ts desc")
        #tdSql.query("select _qstop from ctb1 order by ts desc")
        #tdSql.query("select _qstop from stb order by ts desc")


        tdSql.query("select _qduration from tb order by ts")
        tdSql.query("select _qduration from ctb1 order by ts")
        tdSql.query("select _qduration from stb order by ts")
        #tdSql.query("select _qduration from tb order by ts desc")
        #tdSql.query("select _qduration from ctb1 order by ts desc")
        #tdSql.query("select _qduration from stb order by ts desc")

        #limit
        tdSql.query("select _qstart from tb limit 3")
        tdSql.query("select _qstart from ctb1 limit 3")
        tdSql.query("select _qstart from stb limit 3")

        tdSql.query("select _qstop from tb limit 3")
        tdSql.query("select _qstop from ctb1 limit 3")
        tdSql.query("select _qstop from stb limit 3")


        tdSql.query("select _qduration from tb limit 3")
        tdSql.query("select _qduration from ctb1 limit 3")
        tdSql.query("select _qduration from stb limit 3")

        ############# not supported ###############
        tdSql.error("select _qstart + 1 from tb interval (1s)")
        tdSql.error("select _qstart + 1 from ctb1 interval (1s)")
        tdSql.error("select _qstart + 1 from stb interval (1s)")
        tdSql.error("select _qstart + 1.0 from tb interval (1s)")
        tdSql.error("select _qstart + 1.0 from ctb1 interval (1s)")
        tdSql.error("select _qstart + 1.0 from stb interval (1s)")
        tdSql.error("select _qstart + true from tb interval (1s)")
        tdSql.error("select _qstart + true from ctb1 interval (1s)")
        tdSql.error("select _qstart + true from stb interval (1s)")
        tdSql.error("select _qstart + 'abc' from tb interval (1s)")
        tdSql.error("select _qstart + 'abc' from ctb1 interval (1s)")
        tdSql.error("select _qstart + 'abc' from stb interval (1s)")
        tdSql.error("select _qstart + 1s from tb interval (1s)")
        tdSql.error("select _qstart + 1s from ctb1 interval (1s)")
        tdSql.error("select _qstart + 1s from stb interval (1s)")
        tdSql.error("select _qstart + ts from tb interval (1s)")
        tdSql.error("select _qstart + ts from ctb1 interval (1s)")
        tdSql.error("select _qstart + ts from stb interval (1s)")
        tdSql.error("select _qstart + c0 from tb interval (1s)")
        tdSql.error("select _qstart + c0 from ctb1 interval (1s)")
        tdSql.error("select _qstart + c0 from stb interval (1s)")
        tdSql.error("select _qstart + _qstop from tb interval (1s)")
        tdSql.error("select _qstart + _qstop from ctb1 interval (1s)")
        tdSql.error("select _qstart + _qstop from stb interval (1s)")
        tdSql.error("select _qstart + _qduration from tb interval (1s)")
        tdSql.error("select _qstart + _qduration from ctb1 interval (1s)")
        tdSql.error("select _qstart + _qduration from stb interval (1s)")

        tdSql.error("select _qstop + 1 from tb interval (1s)")
        tdSql.error("select _qstop + 1 from ctb1 interval (1s)")
        tdSql.error("select _qstop + 1 from stb interval (1s)")
        tdSql.error("select _qstop + 1.0 from tb interval (1s)")
        tdSql.error("select _qstop + 1.0 from ctb1 interval (1s)")
        tdSql.error("select _qstop + 1.0 from stb interval (1s)")
        tdSql.error("select _qstop + true from tb interval (1s)")
        tdSql.error("select _qstop + true from ctb1 interval (1s)")
        tdSql.error("select _qstop + true from stb interval (1s)")
        tdSql.error("select _qstop + 'abc' from tb interval (1s)")
        tdSql.error("select _qstop + 'abc' from ctb1 interval (1s)")
        tdSql.error("select _qstop + 'abc' from stb interval (1s)")
        tdSql.error("select _qstop + 1s from tb interval (1s)")
        tdSql.error("select _qstop + 1s from ctb1 interval (1s)")
        tdSql.error("select _qstop + 1s from stb interval (1s)")
        tdSql.error("select _qstop + ts from tb interval (1s)")
        tdSql.error("select _qstop + ts from ctb1 interval (1s)")
        tdSql.error("select _qstop + ts from stb interval (1s)")
        tdSql.error("select _qstop + c0 from tb interval (1s)")
        tdSql.error("select _qstop + c0 from ctb1 interval (1s)")
        tdSql.error("select _qstop + c0 from stb interval (1s)")
        tdSql.error("select _qstop + _qstart from tb interval (1s)")
        tdSql.error("select _qstop + _qstart from ctb1 interval (1s)")
        tdSql.error("select _qstop + _qstart from stb interval (1s)")
        tdSql.error("select _qstop + _qduration from tb interval (1s)")
        tdSql.error("select _qstop + _qduration from ctb1 interval (1s)")
        tdSql.error("select _qstop + _qduration from stb interval (1s)")

        tdSql.error("select _qduration + 1 from tb interval (1s)")
        tdSql.error("select _qduration + 1 from ctb1 interval (1s)")
        tdSql.error("select _qduration + 1 from stb interval (1s)")
        tdSql.error("select _qduration + 1.0 from tb interval (1s)")
        tdSql.error("select _qduration + 1.0 from ctb1 interval (1s)")
        tdSql.error("select _qduration + 1.0 from stb interval (1s)")
        tdSql.error("select _qduration + true from tb interval (1s)")
        tdSql.error("select _qduration + true from ctb1 interval (1s)")
        tdSql.error("select _qduration + true from stb interval (1s)")
        tdSql.error("select _qduration + 'abc' from tb interval (1s)")
        tdSql.error("select _qduration + 'abc' from ctb1 interval (1s)")
        tdSql.error("select _qduration + 'abc' from stb interval (1s)")
        tdSql.error("select _qduration + 1s from tb interval (1s)")
        tdSql.error("select _qduration + 1s from ctb1 interval (1s)")
        tdSql.error("select _qduration + 1s from stb interval (1s)")
        tdSql.error("select _qduration + ts from tb interval (1s)")
        tdSql.error("select _qduration + ts from ctb1 interval (1s)")
        tdSql.error("select _qduration + ts from stb interval (1s)")
        tdSql.error("select _qduration + c0 from tb interval (1s)")
        tdSql.error("select _qduration + c0 from ctb1 interval (1s)")
        tdSql.error("select _qduration + c0 from stb interval (1s)")
        tdSql.error("select _qduration + _qstart from tb interval (1s)")
        tdSql.error("select _qduration + _qstart from ctb1 interval (1s)")
        tdSql.error("select _qduration + _qstart from stb interval (1s)")
        tdSql.error("select _qduration + _qduration from tb interval (1s)")
        tdSql.error("select _qduration + _qduration from ctb1 interval (1s)")
        tdSql.error("select _qduration + _qduration from stb interval (1s)")

        #state_window
        tdSql.error("select _qstart,avg(c0) from tb state_window(c0)")
        tdSql.error("select _qstart,avg(c0) from ctb1 state_window(c0)")

        tdSql.error("select _qstop,avg(c0) from tb state_window(c0)")
        tdSql.error("select _qstop,avg(c0) from ctb1 state_window(c0)")

        tdSql.error("select _qduration,avg(c0) from tb state_window(c0)")
        tdSql.error("select _qduration,avg(c0) from ctb1 state_window(c0)")

        #group by
        tdSql.error("select _qstart from stb group by tbname")
        tdSql.error("select _qstop from stb group by tbname")
        tdSql.error("select _qduration from stb group by tbname")

        return
        tdSql.execute('drop database db_m')
        tdSql.execute('drop database db_u')
        tdSql.execute('drop database db_n')

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
