/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 359
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy28;
  int32_t yy42;
  ENullOrder yy107;
  EFillMode yy320;
  SToken yy421;
  SNodeList* yy530;
  SAlterOption yy557;
  EOrder yy610;
  bool yy621;
  EJoinType yy636;
  int64_t yy669;
  SNode* yy674;
  SDataType yy690;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             618
#define YYNRULE              453
#define YYNTOKEN             239
#define YY_MAX_SHIFT         617
#define YY_MIN_SHIFTREDUCE   904
#define YY_MAX_SHIFTREDUCE   1356
#define YY_ERROR_ACTION      1357
#define YY_ACCEPT_ACTION     1358
#define YY_NO_ACTION         1359
#define YY_MIN_REDUCE        1360
#define YY_MAX_REDUCE        1812
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2144)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    28,  230, 1659, 1646,  610,  609,  296, 1646,  357, 1482,
 /*    10 */   313, 1480,   35,   33,  351,   36,   34,   32,   31,   30,
 /*    20 */   305,   24, 1170, 1643,  532,  441,  440, 1643,   79, 1643,
 /*    30 */  1675,   36,   34,   32,   31,   30,  152,  492,  516, 1639,
 /*    40 */  1645,  115,  277, 1639, 1645, 1639, 1645, 1168,  515, 1483,
 /*    50 */   535,  532, 1629, 1491,  535, 1790,  535,  496,   14, 1742,
 /*    60 */    35,   33, 1297,  355, 1176, 1659,  114,  147,  305, 1688,
 /*    70 */  1170, 1787,   82, 1660,  518, 1662, 1663,  514,  500,  535,
 /*    80 */  1491,    1, 1728, 1739, 1790, 1311,  278, 1724,   36,   34,
 /*    90 */    32,   31,   30, 1675,  531, 1168, 1789, 1647, 1790,  519,
 /*   100 */  1787,  516,  308,  614,  112, 1580,   14,  409,   35,   33,
 /*   110 */   149,  515, 1176, 1169, 1787, 1629,  305, 1643, 1170,  145,
 /*   120 */  1735, 1736, 1194, 1740,   36,   34,   32,   31,   30,    2,
 /*   130 */   381,   63, 1688, 1639, 1645,   84, 1660,  518, 1662, 1663,
 /*   140 */   514, 1361,  535, 1168,  535, 1728,  531, 1790,   56, 1727,
 /*   150 */  1724,  614,  142, 1487,   14,  391, 1171,  392, 1392,  148,
 /*   160 */  1176, 1169,   96, 1787, 1529,   95,   94,   93,   92,   91,
 /*   170 */    90,   89,   88,   87,  161,  160,  132,    2, 1372,  566,
 /*   180 */  1174, 1175,  934, 1221, 1222, 1224, 1225, 1226, 1227, 1228,
 /*   190 */   511,  533, 1236, 1237, 1238, 1239, 1240, 1241,  565,  614,
 /*   200 */   564,  563,  562,  399, 1171,  392, 1392,   38,   96, 1169,
 /*   210 */   150,   95,   94,   93,   92,   91,   90,   89,   88,   87,
 /*   220 */   938,  939,   65,  294, 1353,   55,  194, 1617, 1174, 1175,
 /*   230 */  1360, 1221, 1222, 1224, 1225, 1226, 1227, 1228,  511,  533,
 /*   240 */  1236, 1237, 1238, 1239, 1240, 1241,   36,   34,   32,   31,
 /*   250 */    30,  531, 1171, 1358,  105,  104,  103,  102,  101,  100,
 /*   260 */    99,   98,   97, 1469,  501,   35,   33,   36,   34,   32,
 /*   270 */    31,   30,  330,  305,   55, 1170, 1174, 1175,  342, 1221,
 /*   280 */  1222, 1224, 1225, 1226, 1227, 1228,  511,  533, 1236, 1237,
 /*   290 */  1238, 1239, 1240, 1241,  468,  532,  444,  443,  344,  340,
 /*   300 */  1168,  442,  486, 1659,  111,  439, 1352,  356,  438,  437,
 /*   310 */   436,  321,   39,   35,   33, 1242,   26, 1176,  133,   63,
 /*   320 */   409,  305, 1448, 1170, 1491,   72,   36,   34,   32,   31,
 /*   330 */    30, 1675,  110,  508,    8, 1790,  150, 1208, 1535,  516,
 /*   340 */   288, 1486,   55,  492,  458,  295, 1484,  147, 1168,  515,
 /*   350 */  1533, 1787, 1790, 1629,  150,  951,  614,  950,  496,  481,
 /*   360 */  1261,   35,   33, 1468,  147, 1176, 1169,  200, 1787,  305,
 /*   370 */  1688, 1170,  114,   82, 1660,  518, 1662, 1663,  514,  129,
 /*   380 */   535, 1266,    9, 1728,  952, 1790,  568,  278, 1724,  289,
 /*   390 */  1196,  287,  286,   55,  432,   66, 1168,  147,  434, 1790,
 /*   400 */  1422, 1787,   78,  150,  614, 1790,   32,   31,   30, 1171,
 /*   410 */   112,  147,   74, 1176, 1169, 1787,  350, 1788,  349,   25,
 /*   420 */   433, 1787,  396, 1467,  494,  144, 1735, 1736, 1192, 1740,
 /*   430 */     9,  487,  482, 1174, 1175,  583, 1221, 1222, 1224, 1225,
 /*   440 */  1226, 1227, 1228,  511,  533, 1236, 1237, 1238, 1239, 1240,
 /*   450 */  1241,  317,  614, 1003,  532, 1251,  566, 1171, 1571, 1573,
 /*   460 */   444,  443, 1169,  150, 1466,  442,  366, 1321,  111,  439,
 /*   470 */  1005,  150,  438,  437,  436,  565,  345,  564,  563,  562,
 /*   480 */   568, 1174, 1175, 1491, 1221, 1222, 1224, 1225, 1226, 1227,
 /*   490 */  1228,  511,  533, 1236, 1237, 1238, 1239, 1240, 1241,  157,
 /*   500 */    11,   10, 1195, 1675,  309, 1171,  478, 1319, 1320, 1322,
 /*   510 */  1323,  485,  130, 1535, 1383,  221,  584,  582,   35,   33,
 /*   520 */   310, 1493,  150, 1382,   61, 1533,  305,   60, 1170, 1174,
 /*   530 */  1175, 1193, 1221, 1222, 1224, 1225, 1226, 1227, 1228,  511,
 /*   540 */   533, 1236, 1237, 1238, 1239, 1240, 1241,  484,  390, 1572,
 /*   550 */  1573,  394, 1304, 1168, 1535,  532,  532,  566, 1194,  532,
 /*   560 */   276,  316, 1192, 1419, 1629,  975, 1533,  106,  106,  374,
 /*   570 */  1176,  367,  386, 1629,  430,  435,  565,  519,  564,  563,
 /*   580 */   562, 1273,  976, 1581, 1491, 1491,  532,    2, 1491,  131,
 /*   590 */   387,  532,  532,  532,  258, 1247, 1381, 1380,  408, 1379,
 /*   600 */   315, 1194, 1535, 1607, 1488,  466,  256,   53,  130,  614,
 /*   610 */    52, 1378,  561,  398, 1534, 1491,  394, 1493,  950, 1169,
 /*   620 */  1491, 1491, 1491,  590,  589,  588,  320,  162,  587,  586,
 /*   630 */   585,  116,  580,  579,  578,  577,  576,  575,  574,  573,
 /*   640 */   123,  569,  318,  428, 1568,  130, 1629, 1629, 1197, 1629,
 /*   650 */   130,  159,   55,  252, 1494,  572, 1521, 1463,    7, 1493,
 /*   660 */   385, 1629, 1171,  380,  379,  378,  377,  376,  373,  372,
 /*   670 */   371,  370,  369,  365,  364,  363,  362,  361,  360,  359,
 /*   680 */   358, 1377, 1376,   54,  492,  503, 1174, 1175,   81, 1221,
 /*   690 */  1222, 1224, 1225, 1226, 1227, 1228,  511,  533, 1236, 1237,
 /*   700 */  1238, 1239, 1240, 1241,  532, 1375,   36,   34,   32,   31,
 /*   710 */    30,  532, 1374,  114,  532, 1194,  529,  938,  939,   59,
 /*   720 */    58,  354, 1223,  530,  156, 1659,  243,  532, 1371,  348,
 /*   730 */  1296, 1629, 1629, 1491,   36,   34,   32,   31,   30,  319,
 /*   740 */  1491,  275,  185, 1491,  338,  183,  336,  332,  328,  153,
 /*   750 */   323,  112,  279, 1675, 1370, 1629, 1491, 1369, 1476, 1742,
 /*   760 */   571,  495, 1629, 1742, 1368, 1223,  146, 1735, 1736, 1367,
 /*   770 */  1740,  515, 1366,  206, 1478, 1629, 1208, 1365, 1629, 1409,
 /*   780 */   279,  150, 1364, 1738, 1259, 1659, 1363, 1737, 1747, 1292,
 /*   790 */  1474,  187, 1688,  434,  186,   83, 1660,  518, 1662, 1663,
 /*   800 */   514,  445,  535,  189, 1629, 1728,  188, 1629,  197,  298,
 /*   810 */  1724,  143, 1259, 1675, 1629,  433, 1404,  191, 1402, 1629,
 /*   820 */   190,  495, 1629,  222,  456, 1153, 1154, 1629,  474, 1755,
 /*   830 */  1292,  515, 1629, 1260,  449, 1629, 1629,  454,  447, 1649,
 /*   840 */   450,  510,  120,   46,  560,  209,   37,   11,   10,  457,
 /*   850 */  1355, 1356, 1688,  465, 1265,   83, 1660,  518, 1662, 1663,
 /*   860 */   514, 1260,  535,  193, 1179, 1728,   37,   37,  232,  298,
 /*   870 */  1724,  143, 1373,  504,  118,  452, 1651, 1170, 1178, 1223,
 /*   880 */   446, 1449, 1265,  470, 1318,  192,  211, 1267,  225, 1756,
 /*   890 */   459,  119,   27,  303, 1254, 1255, 1256, 1257, 1258, 1262,
 /*   900 */  1263, 1264, 1168, 1659,  120,  498,   46, 1229, 1126,  234,
 /*   910 */    51,  540,  479,   50,  216,  524,  119, 1676,  120, 1176,
 /*   920 */    27,  303, 1254, 1255, 1256, 1257, 1258, 1262, 1263, 1264,
 /*   930 */  1182, 1675,  240, 1393,  427, 1659, 1758, 1295,  121,  516,
 /*   940 */  1530,  119,  493,  224, 1181, 1034,  227,  251,  229,  515,
 /*   950 */     3,    5, 1062, 1629, 1192,  322,  325, 1066,  614, 1072,
 /*   960 */   329, 1003,  284, 1675,  285, 1137,  248, 1659, 1169,  368,
 /*   970 */  1688,  516, 1570,   83, 1660,  518, 1662, 1663,  514, 1070,
 /*   980 */   535,  515,  122, 1728,  158, 1629,  383,  298, 1724, 1803,
 /*   990 */   375,  388, 1198,  382,  384, 1675,  389,  397, 1762, 1201,
 /*  1000 */   400,  165, 1688,  516,  401,   83, 1660,  518, 1662, 1663,
 /*  1010 */   514, 1171,  535,  515,  167, 1728, 1200, 1629, 1659,  298,
 /*  1020 */  1724, 1803, 1202,  402,  170,  405,  403,  172,  406, 1199,
 /*  1030 */  1785,  175,  407,  410, 1688, 1174, 1175,   83, 1660,  518,
 /*  1040 */  1662, 1663,  514,   62,  535,  178, 1675, 1728, 1659, 1176,
 /*  1050 */   431,  298, 1724, 1803,  516, 1481,  429,  182, 1477,   86,
 /*  1060 */   184, 1611, 1746,  124,  515,  293,  125, 1479, 1629, 1475,
 /*  1070 */   126,  249,  195,  496,  460,  198, 1675,  127,  467,  469,
 /*  1080 */   461,  472,  464, 1197,  516, 1688,  201,  471,  263, 1660,
 /*  1090 */   518, 1662, 1663,  514,  515,  535,  204, 1759, 1629,  480,
 /*  1100 */   522, 1769, 1768,  496,    6, 1749,  207,  477,  489,  215,
 /*  1110 */  1292,  476,  210,  137, 1790, 1688,  297,  113,  263, 1660,
 /*  1120 */   518, 1662, 1663,  514,  483,  535,  149, 1196,   40,  217,
 /*  1130 */  1787,  505,  502, 1041,  558,  557,  556, 1045,  555, 1047,
 /*  1140 */  1048,  554, 1050,  551, 1790, 1056,  548, 1058, 1059,  545,
 /*  1150 */   542, 1743,   18,  299, 1579, 1578,  147,  180,  520,  521,
 /*  1160 */  1787, 1786, 1709, 1659,  218,  307,  223,  525,  526,  141,
 /*  1170 */   236,  527,  238,  250, 1492,  426,  422,  418,  414,  179,
 /*  1180 */    71,   73, 1659,  538, 1464,  253, 1806,  245,   47,  499,
 /*  1190 */   226, 1675,  613,  506,  228,  136,  264,  274,  255,  516,
 /*  1200 */   257,  265, 1623, 1622,   64,   57, 1621,  177,  324,  515,
 /*  1210 */  1675, 1618,  327, 1629,  326, 1163, 1164,  154,  513,  331,
 /*  1220 */  1616,  333,  334,  335, 1615,  337, 1614,  339,  515, 1613,
 /*  1230 */  1688,  341, 1629,   84, 1660,  518, 1662, 1663,  514, 1612,
 /*  1240 */   535, 1659,  343, 1728, 1597,  155,  346,  507, 1724, 1688,
 /*  1250 */  1659,  347,  272, 1660,  518, 1662, 1663,  514,  512,  535,
 /*  1260 */   509, 1700, 1140, 1591,  176, 1139,  168, 1590,  173, 1675,
 /*  1270 */   404,  352,  353, 1589, 1588, 1109, 1563,  516, 1675, 1562,
 /*  1280 */  1561, 1560, 1559, 1558, 1557, 1556,  516,  515,  166, 1555,
 /*  1290 */  1554, 1629, 1553, 1552, 1551, 1550,  515, 1549, 1548, 1547,
 /*  1300 */  1629, 1546,  117, 1545, 1544, 1543, 1542, 1541, 1688, 1540,
 /*  1310 */  1111,  134, 1660,  518, 1662, 1663,  514, 1688,  535, 1539,
 /*  1320 */    84, 1660,  518, 1662, 1663,  514, 1538,  535, 1537, 1536,
 /*  1330 */  1728,  617, 1659, 1421, 1389, 1725,  163,  108,  941,  940,
 /*  1340 */  1388, 1659, 1605,  140, 1599,  247, 1587,  171,  164, 1586,
 /*  1350 */   109, 1576,  393,  169,  497, 1804, 1470,  107,  395,  174,
 /*  1360 */  1675, 1420, 1418,  606,  602,  598,  594,  246,  516, 1675,
 /*  1370 */   969, 1416,  413,  417,  411,  412,  416,  516,  515,  415,
 /*  1380 */  1414, 1412, 1629,  420,  419,  475,  423,  515,  424,  421,
 /*  1390 */   425, 1629,   80, 1659, 1401,  241, 1400, 1387, 1472, 1688,
 /*  1400 */  1075, 1076,  273, 1660,  518, 1662, 1663,  514, 1688,  535,
 /*  1410 */    45,  268, 1660,  518, 1662, 1663,  514, 1471,  535, 1002,
 /*  1420 */  1001, 1675, 1000,  999,  581,  583,  996, 1410,  528,  516,
 /*  1430 */   290, 1405,  995,  181,  994,  291,  448, 1403,  451,  515,
 /*  1440 */   292, 1386,  453, 1629, 1385,  455,   85, 1604,  488, 1147,
 /*  1450 */  1598,  462, 1659,  473, 1585, 1584,  202,  199, 1583, 1575,
 /*  1460 */  1688,  312,  311,  134, 1660,  518, 1662, 1663,  514,  203,
 /*  1470 */   535, 1184,  208,   67, 1145,    4,  196,   37,  128,   15,
 /*  1480 */  1675,   43, 1317, 1310, 1659,  135,   49,  212,  516,  213,
 /*  1490 */   205,   22,  463,   48, 1289,  214, 1177, 1649,  515,   41,
 /*  1500 */  1659,   23, 1629, 1288,   42,  302,   68, 1805,  220,  138,
 /*  1510 */  1346,   17, 1675, 1176, 1341, 1335, 1340,   10,  300, 1688,
 /*  1520 */   513, 1345,  273, 1660,  518, 1662, 1663,  514, 1675,  535,
 /*  1530 */   515, 1344,  301,   19, 1629,   16,  516,   13, 1231, 1252,
 /*  1540 */   139,  151,   29, 1216, 1230,  517,  515,   12,  523,   20,
 /*  1550 */  1629, 1688,  536,  304,  272, 1660,  518, 1662, 1663,  514,
 /*  1560 */  1659,  535, 1180, 1701,   21, 1574,  237, 1688,  231, 1315,
 /*  1570 */   273, 1660,  518, 1662, 1663,  514,  233,  535,  239,  235,
 /*  1580 */    69,   70,   74, 1648,  242, 1691, 1186, 1233, 1675, 1063,
 /*  1590 */   534,   44,  539,  537,  314,  541,  516,  543, 1060,  544,
 /*  1600 */  1659, 1057,  546,  547,  549, 1185,  515, 1051,  550,  552,
 /*  1610 */  1629, 1659, 1049,  306,  553, 1040, 1055, 1054, 1053,  559,
 /*  1620 */  1071, 1068, 1052,   75,   76,   77,  967, 1688, 1675, 1188,
 /*  1630 */   273, 1660,  518, 1662, 1663,  514,  516,  535,  567, 1675,
 /*  1640 */   533, 1236, 1237,  991, 1069, 1009,  515,  516,  570,  244,
 /*  1650 */  1629, 1659,  989,  988,  987,  984,  986,  515, 1006,  985,
 /*  1660 */   983, 1629,  982, 1004, 1659,  492,  979, 1688,  978,  977,
 /*  1670 */   259, 1660,  518, 1662, 1663,  514,  974,  535, 1688, 1675,
 /*  1680 */  1417,  267, 1660,  518, 1662, 1663,  514,  516,  535,  973,
 /*  1690 */   972,  591, 1675,  592,  114,  593, 1415,  515,  596,  595,
 /*  1700 */   516, 1629,  597, 1413,  599,  600,  601, 1411,  603,  604,
 /*  1710 */   515,  605, 1399,  496, 1629,  607,  608, 1659, 1688, 1398,
 /*  1720 */  1384,  269, 1660,  518, 1662, 1663,  514,  611,  535,  612,
 /*  1730 */   615, 1688,  112, 1172,  260, 1660,  518, 1662, 1663,  514,
 /*  1740 */   254,  535,  616, 1359, 1359, 1675, 1359,  219, 1735,  491,
 /*  1750 */  1659,  490, 1359,  516, 1790, 1359, 1359, 1359, 1359, 1359,
 /*  1760 */  1359, 1359, 1359,  515, 1359, 1659,  149, 1629, 1359, 1359,
 /*  1770 */  1787, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1675, 1359,
 /*  1780 */  1359, 1359, 1359, 1359, 1688, 1359,  516,  270, 1660,  518,
 /*  1790 */  1662, 1663,  514, 1675,  535, 1359,  515, 1359, 1659, 1359,
 /*  1800 */  1629,  516, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359,
 /*  1810 */  1359,  515, 1359, 1659, 1359, 1629, 1359, 1688, 1359, 1359,
 /*  1820 */   261, 1660,  518, 1662, 1663,  514, 1675,  535, 1359, 1359,
 /*  1830 */  1359, 1359, 1688, 1359,  516,  271, 1660,  518, 1662, 1663,
 /*  1840 */   514, 1675,  535, 1359,  515, 1359, 1359, 1359, 1629,  516,
 /*  1850 */  1359, 1359, 1359, 1659, 1359, 1359, 1359, 1359, 1359,  515,
 /*  1860 */  1359, 1359, 1359, 1629, 1359, 1688, 1359, 1359,  262, 1660,
 /*  1870 */   518, 1662, 1663,  514, 1359,  535, 1359, 1359, 1359, 1359,
 /*  1880 */  1688, 1675, 1359, 1671, 1660,  518, 1662, 1663,  514,  516,
 /*  1890 */   535, 1359, 1359, 1659, 1359, 1359, 1359, 1359, 1359,  515,
 /*  1900 */  1359, 1359, 1359, 1629, 1659, 1359, 1359, 1359, 1359, 1359,
 /*  1910 */  1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359,
 /*  1920 */  1688, 1675, 1359, 1670, 1660,  518, 1662, 1663,  514,  516,
 /*  1930 */   535, 1359, 1675, 1359, 1359, 1359, 1359, 1359, 1359,  515,
 /*  1940 */   516, 1359, 1359, 1629, 1659, 1359, 1359, 1359, 1359, 1359,
 /*  1950 */   515, 1359, 1359, 1359, 1629, 1359, 1359, 1659, 1359, 1359,
 /*  1960 */  1688, 1359, 1359, 1669, 1660,  518, 1662, 1663,  514, 1359,
 /*  1970 */   535, 1688, 1675, 1359,  282, 1660,  518, 1662, 1663,  514,
 /*  1980 */   516,  535, 1359, 1359, 1359, 1675, 1359, 1359, 1359, 1359,
 /*  1990 */   515, 1359, 1359,  516, 1629, 1359, 1359, 1359, 1359, 1359,
 /*  2000 */  1359, 1359, 1359,  515, 1359, 1359, 1359, 1629, 1659, 1359,
 /*  2010 */  1359, 1688, 1359, 1359,  281, 1660,  518, 1662, 1663,  514,
 /*  2020 */  1359,  535, 1359, 1359, 1688, 1359, 1359,  283, 1660,  518,
 /*  2030 */  1662, 1663,  514, 1359,  535, 1359, 1675, 1359,  492, 1359,
 /*  2040 */  1359, 1659, 1359, 1359,  516, 1359, 1359, 1359, 1359, 1359,
 /*  2050 */  1359, 1359, 1359, 1359,  515, 1359, 1359, 1359, 1629, 1359,
 /*  2060 */  1359, 1359, 1359, 1359, 1359, 1359, 1359,  114, 1359, 1675,
 /*  2070 */  1359, 1359, 1359, 1359, 1359, 1688, 1359,  516,  280, 1660,
 /*  2080 */   518, 1662, 1663,  514, 1359,  535,  496,  515, 1359, 1359,
 /*  2090 */  1359, 1629, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359,
 /*  2100 */  1359, 1359, 1359, 1359, 1359,  112, 1359, 1359, 1688, 1359,
 /*  2110 */  1359,  266, 1660,  518, 1662, 1663,  514, 1359,  535, 1359,
 /*  2120 */   219, 1735,  491, 1359,  490, 1359, 1359, 1790, 1359, 1359,
 /*  2130 */  1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359, 1359,  147,
 /*  2140 */  1359, 1359, 1359, 1787,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   323,  324,  242,  272,  250,  251,  275,  272,  249,  272,
 /*    10 */   275,  271,   12,   13,  297,   12,   13,   14,   15,   16,
 /*    20 */    20,    2,   22,  292,  249,  256,  257,  292,  252,  292,
 /*    30 */   270,   12,   13,   14,   15,   16,  261,  249,  278,  308,
 /*    40 */   309,  265,  283,  308,  309,  308,  309,   47,  288,  273,
 /*    50 */   319,  249,  292,  278,  319,  338,  319,  297,   58,  310,
 /*    60 */    12,   13,   14,  261,   64,  242,  278,  350,   20,  309,
 /*    70 */    22,  354,  312,  313,  314,  315,  316,  317,   41,  319,
 /*    80 */   278,   81,  322,  334,  338,   82,  326,  327,   12,   13,
 /*    90 */    14,   15,   16,  270,   20,   47,  350,  272,  338,  288,
 /*   100 */   354,  278,  291,  103,  316,  294,   58,   57,   12,   13,
 /*   110 */   350,  288,   64,  113,  354,  292,   20,  292,   22,  331,
 /*   120 */   332,  333,   20,  335,   12,   13,   14,   15,   16,   81,
 /*   130 */    75,  254,  309,  308,  309,  312,  313,  314,  315,  316,
 /*   140 */   317,    0,  319,   47,  319,  322,   20,  338,    4,  326,
 /*   150 */   327,  103,  269,  276,   58,  245,  156,  247,  248,  350,
 /*   160 */    64,  113,   21,  354,  281,   24,   25,   26,   27,   28,
 /*   170 */    29,   30,   31,   32,  119,  120,  241,   81,  243,   93,
 /*   180 */   180,  181,    4,  183,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  112,  103,
 /*   200 */   114,  115,  116,  245,  156,  247,  248,   81,   21,  113,
 /*   210 */   210,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   220 */    42,   43,  165,  166,  148,   81,  169,    0,  180,  181,
 /*   230 */     0,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,   12,   13,   14,   15,
 /*   250 */    16,   20,  156,  239,   24,   25,   26,   27,   28,   29,
 /*   260 */    30,   31,   32,    0,  227,   12,   13,   12,   13,   14,
 /*   270 */    15,   16,   45,   20,   81,   22,  180,  181,  151,  183,
 /*   280 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   290 */   194,  195,  196,  197,  297,  249,   60,   61,  171,  172,
 /*   300 */    47,   65,   20,  242,   68,   69,  230,  261,   72,   73,
 /*   310 */    74,  297,   81,   12,   13,   14,    2,   64,  255,  254,
 /*   320 */    57,   20,  259,   22,  278,  252,   12,   13,   14,   15,
 /*   330 */    16,  270,  267,   58,   81,  338,  210,   82,  270,  278,
 /*   340 */    35,  276,   81,  249,  297,  277,  273,  350,   47,  288,
 /*   350 */   282,  354,  338,  292,  210,   20,  103,   22,  297,  143,
 /*   360 */   139,   12,   13,    0,  350,   64,  113,   55,  354,   20,
 /*   370 */   309,   22,  278,  312,  313,  314,  315,  316,  317,  145,
 /*   380 */   319,  160,   81,  322,   49,  338,   57,  326,  327,   84,
 /*   390 */    20,   86,   87,   81,   89,   83,   47,  350,   93,  338,
 /*   400 */     0,  354,   81,  210,  103,  338,   14,   15,   16,  156,
 /*   410 */   316,  350,   91,   64,  113,  354,  155,  350,  157,  198,
 /*   420 */   115,  354,   14,    0,  330,  331,  332,  333,   20,  335,
 /*   430 */    81,  215,  216,  180,  181,   41,  183,  184,  185,  186,
 /*   440 */   187,  188,  189,  190,  191,  192,  193,  194,  195,  196,
 /*   450 */   197,  280,  103,   47,  249,  180,   93,  156,  287,  288,
 /*   460 */    60,   61,  113,  210,    0,   65,  261,  180,   68,   69,
 /*   470 */    64,  210,   72,   73,   74,  112,   82,  114,  115,  116,
 /*   480 */    57,  180,  181,  278,  183,  184,  185,  186,  187,  188,
 /*   490 */   189,  190,  191,  192,  193,  194,  195,  196,  197,   55,
 /*   500 */     1,    2,   20,  270,  262,  156,  219,  220,  221,  222,
 /*   510 */   223,  278,  270,  270,  242,  145,  256,  257,   12,   13,
 /*   520 */   277,  279,  210,  242,   80,  282,   20,   83,   22,  180,
 /*   530 */   181,   20,  183,  184,  185,  186,  187,  188,  189,  190,
 /*   540 */   191,  192,  193,  194,  195,  196,  197,  314,  246,  287,
 /*   550 */   288,  249,   14,   47,  270,  249,  249,   93,   20,  249,
 /*   560 */    18,  277,   20,    0,  292,   47,  282,  261,  261,   27,
 /*   570 */    64,  261,   30,  292,  268,  268,  112,  288,  114,  115,
 /*   580 */   116,   82,   64,  294,  278,  278,  249,   81,  278,   18,
 /*   590 */    48,  249,  249,  249,   23,   14,  242,  242,  261,  242,
 /*   600 */   262,   20,  270,  261,  261,  261,   35,   36,  270,  103,
 /*   610 */    39,  242,   92,  246,  282,  278,  249,  279,   22,  113,
 /*   620 */   278,  278,  278,   60,   61,   62,   63,   56,   65,   66,
 /*   630 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   640 */    77,   78,  262,   47,  278,  270,  292,  292,   20,  292,
 /*   650 */   270,  285,   81,  263,  279,  258,  266,  260,   37,  279,
 /*   660 */   118,  292,  156,  121,  122,  123,  124,  125,  126,  127,
 /*   670 */   128,  129,  130,  131,  132,  133,  134,  135,  136,  137,
 /*   680 */   138,  242,  242,    3,  249,   41,  180,  181,  117,  183,
 /*   690 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   700 */   194,  195,  196,  197,  249,  242,   12,   13,   14,   15,
 /*   710 */    16,  249,  242,  278,  249,   20,  261,   42,   43,  148,
 /*   720 */   149,  150,  184,  261,  153,  242,  261,  249,  242,  158,
 /*   730 */     4,  292,  292,  278,   12,   13,   14,   15,   16,  261,
 /*   740 */   278,  170,   85,  278,  173,   88,  175,  176,  177,  178,
 /*   750 */   179,  316,   58,  270,  242,  292,  278,  242,  271,  310,
 /*   760 */    64,  278,  292,  310,  242,  184,  331,  332,  333,  242,
 /*   770 */   335,  288,  242,  145,  271,  292,   82,  242,  292,    0,
 /*   780 */    58,  210,  242,  334,   90,  242,  242,  334,  208,  209,
 /*   790 */   271,   85,  309,   93,   88,  312,  313,  314,  315,  316,
 /*   800 */   317,   22,  319,   85,  292,  322,   88,  292,  271,  326,
 /*   810 */   327,  328,   90,  270,  292,  115,    0,   85,    0,  292,
 /*   820 */    88,  278,  292,  340,   21,  167,  168,  292,  345,  346,
 /*   830 */   209,  288,  292,  139,    4,  292,  292,   34,   22,   44,
 /*   840 */    22,  271,   41,   41,  271,   41,   41,    1,    2,   19,
 /*   850 */   195,  196,  309,  301,  160,  312,  313,  314,  315,  316,
 /*   860 */   317,  139,  319,   33,   47,  322,   41,   41,   41,  326,
 /*   870 */   327,  328,  243,  229,   41,   45,   81,   22,   47,  184,
 /*   880 */    50,  259,  160,   82,   82,   55,   82,   82,  357,  346,
 /*   890 */   305,   41,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   900 */   206,  207,   47,  242,   41,  225,   41,   82,   82,   82,
 /*   910 */    80,   41,  348,   83,  342,   82,   41,  270,   41,   64,
 /*   920 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   930 */   113,  270,   82,  248,  250,  242,  311,  211,   41,  278,
 /*   940 */   281,   41,  336,  351,  113,   82,  351,   82,  351,  288,
 /*   950 */   339,  212,   82,  292,   20,  307,  249,   82,  103,   82,
 /*   960 */    45,   47,  306,  270,  256,  154,  299,  242,  113,  249,
 /*   970 */   309,  278,  249,  312,  313,  314,  315,  316,  317,   82,
 /*   980 */   319,  288,   82,  322,   40,  292,  139,  326,  327,  328,
 /*   990 */   286,  249,   20,  284,  284,  270,  244,  244,  337,   20,
 /*  1000 */   303,  254,  309,  278,  288,  312,  313,  314,  315,  316,
 /*  1010 */   317,  156,  319,  288,  254,  322,   20,  292,  242,  326,
 /*  1020 */   327,  328,   20,  296,  254,  296,  298,  254,  278,   20,
 /*  1030 */   337,  254,  289,  249,  309,  180,  181,  312,  313,  314,
 /*  1040 */   315,  316,  317,  254,  319,  254,  270,  322,  242,   64,
 /*  1050 */   270,  326,  327,  328,  278,  270,  244,  270,  270,  249,
 /*  1060 */   270,  292,  337,  270,  288,  244,  270,  270,  292,  270,
 /*  1070 */   270,  303,  252,  297,  163,  252,  270,  270,  249,  296,
 /*  1080 */   302,  289,  288,   20,  278,  309,  252,  278,  312,  313,
 /*  1090 */   314,  315,  316,  317,  288,  319,  252,  311,  292,  218,
 /*  1100 */   217,  347,  347,  297,  224,  344,  293,  292,  147,  343,
 /*  1110 */   209,  213,  293,  341,  338,  309,  292,  278,  312,  313,
 /*  1120 */   314,  315,  316,  317,  292,  319,  350,   20,   40,  307,
 /*  1130 */   354,  228,  226,   94,   95,   96,   97,   98,   99,  100,
 /*  1140 */   101,  102,  103,  104,  338,  106,  107,  108,  109,  110,
 /*  1150 */   111,  310,   81,  231,  293,  293,  350,   33,  292,  292,
 /*  1160 */   354,  353,  325,  242,  329,  292,  352,  142,  290,   45,
 /*  1170 */   278,  289,  252,  266,  278,   51,   52,   53,   54,   55,
 /*  1180 */   252,   81,  242,  274,  260,  249,  358,  252,  300,  353,
 /*  1190 */   352,  270,  244,  353,  352,  304,  264,  264,  253,  278,
 /*  1200 */   240,  264,    0,    0,   80,   40,    0,   83,   72,  288,
 /*  1210 */   270,    0,  174,  292,   47,   47,   47,   47,  278,  174,
 /*  1220 */     0,   47,   47,  174,    0,  174,    0,   47,  288,    0,
 /*  1230 */   309,   47,  292,  312,  313,  314,  315,  316,  317,    0,
 /*  1240 */   319,  242,   47,  322,    0,   81,  160,  326,  327,  309,
 /*  1250 */   242,  159,  312,  313,  314,  315,  316,  317,  318,  319,
 /*  1260 */   320,  321,  113,    0,  140,  156,  142,    0,  144,  270,
 /*  1270 */   146,  152,  151,    0,    0,   44,    0,  278,  270,    0,
 /*  1280 */     0,    0,    0,    0,    0,    0,  278,  288,  164,    0,
 /*  1290 */     0,  292,    0,    0,    0,    0,  288,    0,    0,    0,
 /*  1300 */   292,    0,   40,    0,    0,    0,    0,    0,  309,    0,
 /*  1310 */    22,  312,  313,  314,  315,  316,  317,  309,  319,    0,
 /*  1320 */   312,  313,  314,  315,  316,  317,    0,  319,    0,    0,
 /*  1330 */   322,   19,  242,    0,    0,  327,   40,   37,   14,   14,
 /*  1340 */     0,  242,    0,   41,    0,   33,    0,  147,   38,    0,
 /*  1350 */    37,    0,   44,   37,  355,  356,    0,   45,   44,   37,
 /*  1360 */   270,    0,    0,   51,   52,   53,   54,   55,  278,  270,
 /*  1370 */    59,    0,   37,   37,   47,   45,   45,  278,  288,   47,
 /*  1380 */     0,    0,  292,   45,   47,  295,   47,  288,   45,   37,
 /*  1390 */    37,  292,   80,  242,    0,   83,    0,    0,    0,  309,
 /*  1400 */    22,   47,  312,  313,  314,  315,  316,  317,  309,  319,
 /*  1410 */    90,  312,  313,  314,  315,  316,  317,    0,  319,   47,
 /*  1420 */    47,  270,   47,   47,   41,   41,   47,    0,  116,  278,
 /*  1430 */    22,    0,   47,   88,   47,   22,   48,    0,   47,  288,
 /*  1440 */    22,    0,   22,  292,    0,   22,   20,    0,  349,   47,
 /*  1450 */     0,   22,  242,  141,    0,    0,  144,  142,    0,    0,
 /*  1460 */   309,   12,   13,  312,  313,  314,  315,  316,  317,   37,
 /*  1470 */   319,   22,   82,   81,  162,   41,  164,   41,  161,  214,
 /*  1480 */   270,   41,   82,   82,  242,   81,  145,   81,  278,   41,
 /*  1490 */   140,   81,  145,  145,   82,   44,   47,   44,  288,  208,
 /*  1500 */   242,   41,  292,   82,   41,  295,   81,  356,   44,   44,
 /*  1510 */    82,   41,  270,   64,   47,   82,   47,    2,   47,  309,
 /*  1520 */   278,   47,  312,  313,  314,  315,  316,  317,  270,  319,
 /*  1530 */   288,   47,   47,   41,  292,  214,  278,  214,   82,  180,
 /*  1540 */    44,   44,   81,   22,   82,  182,  288,   81,  143,   81,
 /*  1550 */   292,  309,  103,  295,  312,  313,  314,  315,  316,  317,
 /*  1560 */   242,  319,  113,  321,   81,    0,   37,  309,   82,   82,
 /*  1570 */   312,  313,  314,  315,  316,  317,   81,  319,  140,   81,
 /*  1580 */    81,   81,   91,   44,   44,   81,   22,   82,  270,   82,
 /*  1590 */    81,   81,   47,   92,   47,   81,  278,   47,   82,   81,
 /*  1600 */   242,   82,   47,   81,   47,  156,  288,   82,   81,   47,
 /*  1610 */   292,  242,   82,  295,   81,   22,  105,  105,  105,   93,
 /*  1620 */    47,   22,  105,   81,   81,   81,   59,  309,  270,  180,
 /*  1630 */   312,  313,  314,  315,  316,  317,  278,  319,   58,  270,
 /*  1640 */   191,  192,  193,   47,  113,   64,  288,  278,   79,   41,
 /*  1650 */   292,  242,   47,   47,   47,   22,   47,  288,   64,   47,
 /*  1660 */    47,  292,   47,   47,  242,  249,   47,  309,   47,   47,
 /*  1670 */   312,  313,  314,  315,  316,  317,   47,  319,  309,  270,
 /*  1680 */     0,  312,  313,  314,  315,  316,  317,  278,  319,   47,
 /*  1690 */    47,   47,  270,   45,  278,   37,    0,  288,   45,   47,
 /*  1700 */   278,  292,   37,    0,   47,   45,   37,    0,   47,   45,
 /*  1710 */   288,   37,    0,  297,  292,   47,   46,  242,  309,    0,
 /*  1720 */     0,  312,  313,  314,  315,  316,  317,   22,  319,   21,
 /*  1730 */    21,  309,  316,   22,  312,  313,  314,  315,  316,  317,
 /*  1740 */    22,  319,   20,  359,  359,  270,  359,  331,  332,  333,
 /*  1750 */   242,  335,  359,  278,  338,  359,  359,  359,  359,  359,
 /*  1760 */   359,  359,  359,  288,  359,  242,  350,  292,  359,  359,
 /*  1770 */   354,  359,  359,  359,  359,  359,  359,  359,  270,  359,
 /*  1780 */   359,  359,  359,  359,  309,  359,  278,  312,  313,  314,
 /*  1790 */   315,  316,  317,  270,  319,  359,  288,  359,  242,  359,
 /*  1800 */   292,  278,  359,  359,  359,  359,  359,  359,  359,  359,
 /*  1810 */   359,  288,  359,  242,  359,  292,  359,  309,  359,  359,
 /*  1820 */   312,  313,  314,  315,  316,  317,  270,  319,  359,  359,
 /*  1830 */   359,  359,  309,  359,  278,  312,  313,  314,  315,  316,
 /*  1840 */   317,  270,  319,  359,  288,  359,  359,  359,  292,  278,
 /*  1850 */   359,  359,  359,  242,  359,  359,  359,  359,  359,  288,
 /*  1860 */   359,  359,  359,  292,  359,  309,  359,  359,  312,  313,
 /*  1870 */   314,  315,  316,  317,  359,  319,  359,  359,  359,  359,
 /*  1880 */   309,  270,  359,  312,  313,  314,  315,  316,  317,  278,
 /*  1890 */   319,  359,  359,  242,  359,  359,  359,  359,  359,  288,
 /*  1900 */   359,  359,  359,  292,  242,  359,  359,  359,  359,  359,
 /*  1910 */   359,  359,  359,  359,  359,  359,  359,  359,  359,  359,
 /*  1920 */   309,  270,  359,  312,  313,  314,  315,  316,  317,  278,
 /*  1930 */   319,  359,  270,  359,  359,  359,  359,  359,  359,  288,
 /*  1940 */   278,  359,  359,  292,  242,  359,  359,  359,  359,  359,
 /*  1950 */   288,  359,  359,  359,  292,  359,  359,  242,  359,  359,
 /*  1960 */   309,  359,  359,  312,  313,  314,  315,  316,  317,  359,
 /*  1970 */   319,  309,  270,  359,  312,  313,  314,  315,  316,  317,
 /*  1980 */   278,  319,  359,  359,  359,  270,  359,  359,  359,  359,
 /*  1990 */   288,  359,  359,  278,  292,  359,  359,  359,  359,  359,
 /*  2000 */   359,  359,  359,  288,  359,  359,  359,  292,  242,  359,
 /*  2010 */   359,  309,  359,  359,  312,  313,  314,  315,  316,  317,
 /*  2020 */   359,  319,  359,  359,  309,  359,  359,  312,  313,  314,
 /*  2030 */   315,  316,  317,  359,  319,  359,  270,  359,  249,  359,
 /*  2040 */   359,  242,  359,  359,  278,  359,  359,  359,  359,  359,
 /*  2050 */   359,  359,  359,  359,  288,  359,  359,  359,  292,  359,
 /*  2060 */   359,  359,  359,  359,  359,  359,  359,  278,  359,  270,
 /*  2070 */   359,  359,  359,  359,  359,  309,  359,  278,  312,  313,
 /*  2080 */   314,  315,  316,  317,  359,  319,  297,  288,  359,  359,
 /*  2090 */   359,  292,  359,  359,  359,  359,  359,  359,  359,  359,
 /*  2100 */   359,  359,  359,  359,  359,  316,  359,  359,  309,  359,
 /*  2110 */   359,  312,  313,  314,  315,  316,  317,  359,  319,  359,
 /*  2120 */   331,  332,  333,  359,  335,  359,  359,  338,  359,  359,
 /*  2130 */   359,  359,  359,  359,  359,  359,  359,  359,  359,  350,
 /*  2140 */   359,  359,  359,  354,
};
#define YY_SHIFT_COUNT    (617)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1722)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   571,    0,    0,   48,   96,   96,   96,   96,  253,  253,
 /*    10 */    96,   96,  301,  349,  506,  349,  349,  349,  349,  349,
 /*    20 */   349,  349,  349,  349,  349,  349,  349,  349,  349,  349,
 /*    30 */   349,  349,  349,  349,  349,  349,  349,  349,  126,  126,
 /*    40 */   231,  231,  231, 1449, 1449, 1449, 1449,  261,  312,  193,
 /*    50 */    74,   74,  178,  178,  144,  193,  193,   74,   74,   74,
 /*    60 */    74,   74,   74,   74,   50,   74,   74,  102,  282,  482,
 /*    70 */   102,   74,   74,  102,   74,  102,  102,  482,  102,   74,
 /*    80 */   329,  542,  694,  722,  722,  187,  236,  855,  855,  855,
 /*    90 */   855,  855,  855,  855,  855,  855,  855,  855,  855,  855,
 /*   100 */   855,  855,  855,  855,  855,  855,  305,  335,  408,  408,
 /*   110 */   263,  406,  370,  370,  370,  423,  406,  511,  482,  102,
 /*   120 */   102,  482,  520,  696, 1039, 1039, 1039, 1039, 1039, 1039,
 /*   130 */  1039, 1312,  141,  400,   76,  287,   57,  216,  538,  581,
 /*   140 */   675,  596,  700,  628,  580,  621,  580,  680,  680,  680,
 /*   150 */   726,  695,  739,  934,  915,  914,  811,  934,  934,  944,
 /*   160 */   847,  847,  934,  972,  972,  979,   50,  482,   50,  996,
 /*   170 */  1002,   50,  996,   50,  511, 1009,   50,   50,  934,   50,
 /*   180 */   972,  102,  102,  102,  102,  102,  102,  102,  102,  102,
 /*   190 */   102,  102,  934,  972,  985,  979,  329,  911,  482,  329,
 /*   200 */   934,  996,  329,  511, 1009,  329, 1063,  881,  883,  985,
 /*   210 */   881,  883,  985,  985,  102,  880,  961,  898,  739,  901,
 /*   220 */   511, 1107, 1088,  903,  906,  922,  903,  906,  903,  906,
 /*   230 */  1071,  883,  985,  985,  883,  985, 1025,  511, 1009,  329,
 /*   240 */   520,  329,  511, 1100,  696,  934,  329,  972, 2144, 2144,
 /*   250 */  2144, 2144, 2144, 2144, 2144,  563, 1124,  230,  830,    3,
 /*   260 */    19,  314,  234,  255,  363,  464,  112,  112,  112,  112,
 /*   270 */   112,  112,  112,  112,   86,  127,  444,   55,  499,  221,
 /*   280 */   392,  392,  392,  392,  227,  394,  657,  706,  718,  732,
 /*   290 */   779,  816,  818,  803,  658,  801,  802,  804,  846,  655,
 /*   300 */    37,  644,  805,  275,  825,  795,  826,  827,  833,  850,
 /*   310 */   863,  817,  831,  865,  870,  875,  877,  897,  900,  321,
 /*   320 */   518, 1202, 1203, 1165, 1206, 1136, 1211, 1167, 1038, 1168,
 /*   330 */  1169, 1170, 1045, 1220, 1174, 1175, 1049, 1224, 1051, 1226,
 /*   340 */  1180, 1229, 1184, 1239, 1195, 1244, 1164, 1086, 1092, 1149,
 /*   350 */  1109, 1263, 1267, 1119, 1121, 1273, 1274, 1231, 1276, 1279,
 /*   360 */  1280, 1281, 1282, 1283, 1284, 1285, 1289, 1290, 1292, 1293,
 /*   370 */  1294, 1295, 1297, 1298, 1299, 1301, 1262, 1303, 1304, 1305,
 /*   380 */  1306, 1307, 1309, 1288, 1319, 1326, 1328, 1329, 1333, 1334,
 /*   390 */  1296, 1300, 1302, 1324, 1308, 1325, 1314, 1340, 1310, 1313,
 /*   400 */  1342, 1344, 1346, 1316, 1200, 1349, 1351, 1322, 1356, 1311,
 /*   410 */  1361, 1362, 1327, 1330, 1335, 1371, 1332, 1331, 1336, 1380,
 /*   420 */  1337, 1338, 1352, 1381, 1339, 1343, 1353, 1394, 1396, 1397,
 /*   430 */  1398, 1320, 1345, 1354, 1378, 1417, 1372, 1373, 1375, 1376,
 /*   440 */  1383, 1384, 1379, 1385, 1387, 1427, 1408, 1431, 1413, 1388,
 /*   450 */  1437, 1418, 1391, 1441, 1420, 1444, 1423, 1426, 1447, 1341,
 /*   460 */  1402, 1450, 1317, 1429, 1347, 1315, 1454, 1455, 1458, 1348,
 /*   470 */  1459, 1392, 1432, 1350, 1434, 1436, 1265, 1390, 1440, 1400,
 /*   480 */  1404, 1406, 1410, 1401, 1448, 1451, 1453, 1425, 1460, 1321,
 /*   490 */  1412, 1421, 1464, 1291, 1463, 1465, 1428, 1470, 1323, 1433,
 /*   500 */  1467, 1469, 1471, 1474, 1484, 1485, 1433, 1515, 1359, 1492,
 /*   510 */  1456, 1461, 1462, 1496, 1466, 1468, 1497, 1521, 1363, 1483,
 /*   520 */  1486, 1487, 1495, 1498, 1405, 1499, 1565, 1529, 1438, 1500,
 /*   530 */  1491, 1539, 1540, 1504, 1505, 1509, 1564, 1510, 1501, 1507,
 /*   540 */  1545, 1547, 1514, 1516, 1550, 1518, 1519, 1555, 1522, 1525,
 /*   550 */  1557, 1527, 1530, 1562, 1533, 1511, 1512, 1513, 1517, 1593,
 /*   560 */  1526, 1542, 1543, 1573, 1544, 1531, 1599, 1567, 1580, 1596,
 /*   570 */  1581, 1569, 1608, 1605, 1606, 1607, 1609, 1612, 1633, 1613,
 /*   580 */  1615, 1594, 1383, 1616, 1384, 1619, 1621, 1622, 1629, 1642,
 /*   590 */  1643, 1680, 1644, 1648, 1658, 1696, 1652, 1653, 1665, 1703,
 /*   600 */  1657, 1660, 1669, 1707, 1661, 1664, 1674, 1712, 1668, 1670,
 /*   610 */  1719, 1720, 1705, 1708, 1711, 1718, 1709, 1722,
};
#define YY_REDUCE_COUNT (254)
#define YY_REDUCE_MIN   (-323)
#define YY_REDUCE_MAX   (1799)
static const short yy_reduce_ofst[] = {
 /*     0 */    14, -240,   61,  483,  543,  661,  693,  725,  776,  806,
 /*    10 */  -177,  921,  940,  999, 1008, 1090, 1099, 1151, 1210, 1242,
 /*    20 */  1258, 1318, 1358, 1369, 1409, 1422, 1475, 1508, 1523, 1556,
 /*    30 */  1571, 1611, 1651, 1662, 1702, 1715, 1766, 1799, 1416, 1789,
 /*    40 */    94, -212,  435, -269, -265, -263, -175, -283,   -3,   47,
 /*    50 */   306,  307,  -90,  -42, -254, -191,   67, -225, -198,   46,
 /*    60 */   205,  310,  337,  343,   65,  342,  344,   68,  233, -189,
 /*    70 */   242,  455,  462,  243,  465,  338,  284,  171,  380,  478,
 /*    80 */  -224, -241, -323, -323, -323,  -65,   63,  272,  281,  354,
 /*    90 */   355,  357,  369,  439,  440,  463,  470,  486,  512,  515,
 /*   100 */   522,  527,  530,  535,  540,  544, -117, -246,  302,  367,
 /*   110 */  -123, -231, -251,  449,  453,   73,  260,  366,  289,  375,
 /*   120 */   332,  262,  390,  397, -260,  487,  503,  519,  537,  570,
 /*   130 */   573,  552,  629,  622,  531,  564,  585,  572,  647,  647,
 /*   140 */   685,  684,  659,  625,  606,  606,  606,  592,  595,  597,
 /*   150 */   611,  647,  648,  707,  656,  708,  667,  720,  723,  704,
 /*   160 */   709,  710,  742,  752,  753,  697,  747,  716,  760,  727,
 /*   170 */   728,  770,  729,  773,  750,  743,  777,  789,  784,  791,
 /*   180 */   812,  780,  785,  787,  788,  790,  793,  796,  797,  799,
 /*   190 */   800,  807,  810,  821,  769,  768,  820,  778,  794,  823,
 /*   200 */   829,  783,  834,  809,  792,  844,  786,  754,  813,  815,
 /*   210 */   755,  819,  824,  832,  647,  761,  766,  772,  822,  606,
 /*   220 */   839,  841,  835,  808,  814,  828,  836,  838,  840,  842,
 /*   230 */   837,  861,  866,  867,  862,  873,  878,  892,  882,  920,
 /*   240 */   907,  928,  896,  909,  924,  936,  935,  948,  888,  891,
 /*   250 */   932,  933,  937,  945,  960,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    10 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    20 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    30 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    40 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    50 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    60 */  1357, 1357, 1357, 1357, 1426, 1357, 1357, 1357, 1357, 1357,
 /*    70 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    80 */  1424, 1564, 1357, 1730, 1357, 1357, 1357, 1357, 1357, 1357,
 /*    90 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   100 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   110 */  1426, 1357, 1741, 1741, 1741, 1424, 1357, 1357, 1357, 1357,
 /*   120 */  1357, 1357, 1520, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   130 */  1357, 1600, 1357, 1357, 1807, 1357, 1606, 1765, 1357, 1357,
 /*   140 */  1357, 1357, 1473, 1757, 1733, 1747, 1734, 1792, 1792, 1792,
 /*   150 */  1750, 1357, 1761, 1357, 1357, 1357, 1592, 1357, 1357, 1569,
 /*   160 */  1566, 1566, 1357, 1357, 1357, 1357, 1426, 1357, 1426, 1357,
 /*   170 */  1357, 1426, 1357, 1426, 1357, 1357, 1426, 1426, 1357, 1426,
 /*   180 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   190 */  1357, 1357, 1357, 1357, 1357, 1357, 1424, 1602, 1357, 1424,
 /*   200 */  1357, 1357, 1424, 1357, 1357, 1424, 1357, 1772, 1770, 1357,
 /*   210 */  1772, 1770, 1357, 1357, 1357, 1784, 1780, 1763, 1761, 1747,
 /*   220 */  1357, 1357, 1357, 1798, 1794, 1810, 1798, 1794, 1798, 1794,
 /*   230 */  1357, 1770, 1357, 1357, 1770, 1357, 1577, 1357, 1357, 1424,
 /*   240 */  1357, 1424, 1357, 1489, 1357, 1357, 1424, 1357, 1594, 1608,
 /*   250 */  1523, 1523, 1523, 1427, 1362, 1357, 1357, 1357, 1357, 1357,
 /*   260 */  1357, 1357, 1357, 1357, 1357, 1357, 1674, 1783, 1782, 1706,
 /*   270 */  1705, 1704, 1702, 1673, 1485, 1357, 1357, 1357, 1357, 1357,
 /*   280 */  1667, 1668, 1666, 1665, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   290 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1731, 1357,
 /*   300 */  1795, 1799, 1357, 1357, 1357, 1650, 1357, 1357, 1357, 1357,
 /*   310 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   320 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   330 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   340 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   350 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   360 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   370 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   380 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   390 */  1357, 1357, 1391, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   400 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   410 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   420 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   430 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   440 */  1454, 1453, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   450 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   460 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   470 */  1357, 1357, 1357, 1357, 1754, 1764, 1357, 1357, 1357, 1357,
 /*   480 */  1357, 1357, 1357, 1357, 1357, 1357, 1650, 1357, 1781, 1357,
 /*   490 */  1740, 1736, 1357, 1357, 1732, 1357, 1357, 1793, 1357, 1357,
 /*   500 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1726, 1357, 1699,
 /*   510 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1661, 1357,
 /*   520 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   530 */  1357, 1649, 1357, 1690, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   540 */  1357, 1357, 1517, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   550 */  1357, 1357, 1357, 1357, 1357, 1502, 1500, 1499, 1498, 1357,
 /*   560 */  1495, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   570 */  1357, 1357, 1446, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   580 */  1357, 1357, 1437, 1357, 1436, 1357, 1357, 1357, 1357, 1357,
 /*   590 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   600 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
 /*   610 */  1357, 1357, 1357, 1357, 1357, 1357, 1357, 1357,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  232,  /*  NK_BITNOT => ID */
  232,  /*     INSERT => ID */
  232,  /*     VALUES => ID */
  232,  /*     IMPORT => ID */
  232,  /*    NK_SEMI => ID */
  232,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "FILE_FACTOR",
  /*  113 */ "NK_FLOAT",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "SHOW",
  /*  118 */ "DATABASES",
  /*  119 */ "TABLES",
  /*  120 */ "STABLES",
  /*  121 */ "MNODES",
  /*  122 */ "MODULES",
  /*  123 */ "QNODES",
  /*  124 */ "FUNCTIONS",
  /*  125 */ "INDEXES",
  /*  126 */ "ACCOUNTS",
  /*  127 */ "APPS",
  /*  128 */ "CONNECTIONS",
  /*  129 */ "LICENCE",
  /*  130 */ "GRANTS",
  /*  131 */ "QUERIES",
  /*  132 */ "SCORES",
  /*  133 */ "TOPICS",
  /*  134 */ "VARIABLES",
  /*  135 */ "BNODES",
  /*  136 */ "SNODES",
  /*  137 */ "CLUSTER",
  /*  138 */ "TRANSACTIONS",
  /*  139 */ "LIKE",
  /*  140 */ "INDEX",
  /*  141 */ "FULLTEXT",
  /*  142 */ "FUNCTION",
  /*  143 */ "INTERVAL",
  /*  144 */ "TOPIC",
  /*  145 */ "AS",
  /*  146 */ "CONSUMER",
  /*  147 */ "GROUP",
  /*  148 */ "DESC",
  /*  149 */ "DESCRIBE",
  /*  150 */ "RESET",
  /*  151 */ "QUERY",
  /*  152 */ "CACHE",
  /*  153 */ "EXPLAIN",
  /*  154 */ "ANALYZE",
  /*  155 */ "VERBOSE",
  /*  156 */ "NK_BOOL",
  /*  157 */ "RATIO",
  /*  158 */ "COMPACT",
  /*  159 */ "VNODES",
  /*  160 */ "IN",
  /*  161 */ "OUTPUTTYPE",
  /*  162 */ "AGGREGATE",
  /*  163 */ "BUFSIZE",
  /*  164 */ "STREAM",
  /*  165 */ "INTO",
  /*  166 */ "TRIGGER",
  /*  167 */ "AT_ONCE",
  /*  168 */ "WINDOW_CLOSE",
  /*  169 */ "WATERMARK",
  /*  170 */ "KILL",
  /*  171 */ "CONNECTION",
  /*  172 */ "TRANSACTION",
  /*  173 */ "BALANCE",
  /*  174 */ "VGROUP",
  /*  175 */ "MERGE",
  /*  176 */ "REDISTRIBUTE",
  /*  177 */ "SPLIT",
  /*  178 */ "SYNCDB",
  /*  179 */ "DELETE",
  /*  180 */ "NULL",
  /*  181 */ "NK_QUESTION",
  /*  182 */ "NK_ARROW",
  /*  183 */ "ROWTS",
  /*  184 */ "TBNAME",
  /*  185 */ "QSTARTTS",
  /*  186 */ "QENDTS",
  /*  187 */ "WSTARTTS",
  /*  188 */ "WENDTS",
  /*  189 */ "WDURATION",
  /*  190 */ "CAST",
  /*  191 */ "NOW",
  /*  192 */ "TODAY",
  /*  193 */ "TIMEZONE",
  /*  194 */ "COUNT",
  /*  195 */ "FIRST",
  /*  196 */ "LAST",
  /*  197 */ "LAST_ROW",
  /*  198 */ "BETWEEN",
  /*  199 */ "IS",
  /*  200 */ "NK_LT",
  /*  201 */ "NK_GT",
  /*  202 */ "NK_LE",
  /*  203 */ "NK_GE",
  /*  204 */ "NK_NE",
  /*  205 */ "MATCH",
  /*  206 */ "NMATCH",
  /*  207 */ "CONTAINS",
  /*  208 */ "JOIN",
  /*  209 */ "INNER",
  /*  210 */ "SELECT",
  /*  211 */ "DISTINCT",
  /*  212 */ "WHERE",
  /*  213 */ "PARTITION",
  /*  214 */ "BY",
  /*  215 */ "SESSION",
  /*  216 */ "STATE_WINDOW",
  /*  217 */ "SLIDING",
  /*  218 */ "FILL",
  /*  219 */ "VALUE",
  /*  220 */ "NONE",
  /*  221 */ "PREV",
  /*  222 */ "LINEAR",
  /*  223 */ "NEXT",
  /*  224 */ "HAVING",
  /*  225 */ "ORDER",
  /*  226 */ "SLIMIT",
  /*  227 */ "SOFFSET",
  /*  228 */ "LIMIT",
  /*  229 */ "OFFSET",
  /*  230 */ "ASC",
  /*  231 */ "NULLS",
  /*  232 */ "ID",
  /*  233 */ "NK_BITNOT",
  /*  234 */ "INSERT",
  /*  235 */ "VALUES",
  /*  236 */ "IMPORT",
  /*  237 */ "NK_SEMI",
  /*  238 */ "FILE",
  /*  239 */ "cmd",
  /*  240 */ "account_options",
  /*  241 */ "alter_account_options",
  /*  242 */ "literal",
  /*  243 */ "alter_account_option",
  /*  244 */ "user_name",
  /*  245 */ "privileges",
  /*  246 */ "priv_level",
  /*  247 */ "priv_type_list",
  /*  248 */ "priv_type",
  /*  249 */ "db_name",
  /*  250 */ "dnode_endpoint",
  /*  251 */ "dnode_host_name",
  /*  252 */ "not_exists_opt",
  /*  253 */ "db_options",
  /*  254 */ "exists_opt",
  /*  255 */ "alter_db_options",
  /*  256 */ "integer_list",
  /*  257 */ "variable_list",
  /*  258 */ "retention_list",
  /*  259 */ "alter_db_option",
  /*  260 */ "retention",
  /*  261 */ "full_table_name",
  /*  262 */ "column_def_list",
  /*  263 */ "tags_def_opt",
  /*  264 */ "table_options",
  /*  265 */ "multi_create_clause",
  /*  266 */ "tags_def",
  /*  267 */ "multi_drop_clause",
  /*  268 */ "alter_table_clause",
  /*  269 */ "alter_table_options",
  /*  270 */ "column_name",
  /*  271 */ "type_name",
  /*  272 */ "signed_literal",
  /*  273 */ "create_subtable_clause",
  /*  274 */ "specific_tags_opt",
  /*  275 */ "literal_list",
  /*  276 */ "drop_table_clause",
  /*  277 */ "col_name_list",
  /*  278 */ "table_name",
  /*  279 */ "column_def",
  /*  280 */ "func_name_list",
  /*  281 */ "alter_table_option",
  /*  282 */ "col_name",
  /*  283 */ "db_name_cond_opt",
  /*  284 */ "like_pattern_opt",
  /*  285 */ "table_name_cond",
  /*  286 */ "from_db_opt",
  /*  287 */ "func_name",
  /*  288 */ "function_name",
  /*  289 */ "index_name",
  /*  290 */ "index_options",
  /*  291 */ "func_list",
  /*  292 */ "duration_literal",
  /*  293 */ "sliding_opt",
  /*  294 */ "func",
  /*  295 */ "expression_list",
  /*  296 */ "topic_name",
  /*  297 */ "query_expression",
  /*  298 */ "cgroup_name",
  /*  299 */ "analyze_opt",
  /*  300 */ "explain_options",
  /*  301 */ "agg_func_opt",
  /*  302 */ "bufsize_opt",
  /*  303 */ "stream_name",
  /*  304 */ "stream_options",
  /*  305 */ "into_opt",
  /*  306 */ "dnode_list",
  /*  307 */ "where_clause_opt",
  /*  308 */ "signed",
  /*  309 */ "literal_func",
  /*  310 */ "table_alias",
  /*  311 */ "column_alias",
  /*  312 */ "expression",
  /*  313 */ "pseudo_column",
  /*  314 */ "column_reference",
  /*  315 */ "function_expression",
  /*  316 */ "subquery",
  /*  317 */ "star_func",
  /*  318 */ "star_func_para_list",
  /*  319 */ "noarg_func",
  /*  320 */ "other_para_list",
  /*  321 */ "star_func_para",
  /*  322 */ "predicate",
  /*  323 */ "compare_op",
  /*  324 */ "in_op",
  /*  325 */ "in_predicate_value",
  /*  326 */ "boolean_value_expression",
  /*  327 */ "boolean_primary",
  /*  328 */ "common_expression",
  /*  329 */ "from_clause",
  /*  330 */ "table_reference_list",
  /*  331 */ "table_reference",
  /*  332 */ "table_primary",
  /*  333 */ "joined_table",
  /*  334 */ "alias_opt",
  /*  335 */ "parenthesized_joined_table",
  /*  336 */ "join_type",
  /*  337 */ "search_condition",
  /*  338 */ "query_specification",
  /*  339 */ "set_quantifier_opt",
  /*  340 */ "select_list",
  /*  341 */ "partition_by_clause_opt",
  /*  342 */ "twindow_clause_opt",
  /*  343 */ "group_by_clause_opt",
  /*  344 */ "having_clause_opt",
  /*  345 */ "select_sublist",
  /*  346 */ "select_item",
  /*  347 */ "fill_opt",
  /*  348 */ "fill_mode",
  /*  349 */ "group_by_list",
  /*  350 */ "query_expression_body",
  /*  351 */ "order_by_clause_opt",
  /*  352 */ "slimit_clause_opt",
  /*  353 */ "limit_clause_opt",
  /*  354 */ "query_primary",
  /*  355 */ "sort_specification_list",
  /*  356 */ "sort_specification",
  /*  357 */ "ordering_specification_opt",
  /*  358 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 166 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 167 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 168 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 169 */ "alter_table_options ::= alter_table_option",
 /* 170 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 171 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 172 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 173 */ "col_name_list ::= col_name",
 /* 174 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 175 */ "col_name ::= column_name",
 /* 176 */ "cmd ::= SHOW DNODES",
 /* 177 */ "cmd ::= SHOW USERS",
 /* 178 */ "cmd ::= SHOW DATABASES",
 /* 179 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 182 */ "cmd ::= SHOW MNODES",
 /* 183 */ "cmd ::= SHOW MODULES",
 /* 184 */ "cmd ::= SHOW QNODES",
 /* 185 */ "cmd ::= SHOW FUNCTIONS",
 /* 186 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 187 */ "cmd ::= SHOW STREAMS",
 /* 188 */ "cmd ::= SHOW ACCOUNTS",
 /* 189 */ "cmd ::= SHOW APPS",
 /* 190 */ "cmd ::= SHOW CONNECTIONS",
 /* 191 */ "cmd ::= SHOW LICENCE",
 /* 192 */ "cmd ::= SHOW GRANTS",
 /* 193 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 194 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 195 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 196 */ "cmd ::= SHOW QUERIES",
 /* 197 */ "cmd ::= SHOW SCORES",
 /* 198 */ "cmd ::= SHOW TOPICS",
 /* 199 */ "cmd ::= SHOW VARIABLES",
 /* 200 */ "cmd ::= SHOW BNODES",
 /* 201 */ "cmd ::= SHOW SNODES",
 /* 202 */ "cmd ::= SHOW CLUSTER",
 /* 203 */ "cmd ::= SHOW TRANSACTIONS",
 /* 204 */ "db_name_cond_opt ::=",
 /* 205 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 206 */ "like_pattern_opt ::=",
 /* 207 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 208 */ "table_name_cond ::= table_name",
 /* 209 */ "from_db_opt ::=",
 /* 210 */ "from_db_opt ::= FROM db_name",
 /* 211 */ "func_name_list ::= func_name",
 /* 212 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 213 */ "func_name ::= function_name",
 /* 214 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 215 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 216 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 217 */ "index_options ::=",
 /* 218 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 220 */ "func_list ::= func",
 /* 221 */ "func_list ::= func_list NK_COMMA func",
 /* 222 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 223 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 225 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 226 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 227 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 228 */ "cmd ::= DESC full_table_name",
 /* 229 */ "cmd ::= DESCRIBE full_table_name",
 /* 230 */ "cmd ::= RESET QUERY CACHE",
 /* 231 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 232 */ "analyze_opt ::=",
 /* 233 */ "analyze_opt ::= ANALYZE",
 /* 234 */ "explain_options ::=",
 /* 235 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 236 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 237 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 238 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 239 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 240 */ "agg_func_opt ::=",
 /* 241 */ "agg_func_opt ::= AGGREGATE",
 /* 242 */ "bufsize_opt ::=",
 /* 243 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 244 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 245 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 246 */ "into_opt ::=",
 /* 247 */ "into_opt ::= INTO full_table_name",
 /* 248 */ "stream_options ::=",
 /* 249 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 250 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 251 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 252 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 253 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 254 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 255 */ "cmd ::= BALANCE VGROUP",
 /* 256 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 257 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 258 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 259 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 260 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 261 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 262 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 263 */ "cmd ::= query_expression",
 /* 264 */ "literal ::= NK_INTEGER",
 /* 265 */ "literal ::= NK_FLOAT",
 /* 266 */ "literal ::= NK_STRING",
 /* 267 */ "literal ::= NK_BOOL",
 /* 268 */ "literal ::= TIMESTAMP NK_STRING",
 /* 269 */ "literal ::= duration_literal",
 /* 270 */ "literal ::= NULL",
 /* 271 */ "literal ::= NK_QUESTION",
 /* 272 */ "duration_literal ::= NK_VARIABLE",
 /* 273 */ "signed ::= NK_INTEGER",
 /* 274 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 275 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 276 */ "signed ::= NK_FLOAT",
 /* 277 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 278 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 279 */ "signed_literal ::= signed",
 /* 280 */ "signed_literal ::= NK_STRING",
 /* 281 */ "signed_literal ::= NK_BOOL",
 /* 282 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 283 */ "signed_literal ::= duration_literal",
 /* 284 */ "signed_literal ::= NULL",
 /* 285 */ "signed_literal ::= literal_func",
 /* 286 */ "literal_list ::= signed_literal",
 /* 287 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 288 */ "db_name ::= NK_ID",
 /* 289 */ "table_name ::= NK_ID",
 /* 290 */ "column_name ::= NK_ID",
 /* 291 */ "function_name ::= NK_ID",
 /* 292 */ "table_alias ::= NK_ID",
 /* 293 */ "column_alias ::= NK_ID",
 /* 294 */ "user_name ::= NK_ID",
 /* 295 */ "index_name ::= NK_ID",
 /* 296 */ "topic_name ::= NK_ID",
 /* 297 */ "stream_name ::= NK_ID",
 /* 298 */ "cgroup_name ::= NK_ID",
 /* 299 */ "expression ::= literal",
 /* 300 */ "expression ::= pseudo_column",
 /* 301 */ "expression ::= column_reference",
 /* 302 */ "expression ::= function_expression",
 /* 303 */ "expression ::= subquery",
 /* 304 */ "expression ::= NK_LP expression NK_RP",
 /* 305 */ "expression ::= NK_PLUS expression",
 /* 306 */ "expression ::= NK_MINUS expression",
 /* 307 */ "expression ::= expression NK_PLUS expression",
 /* 308 */ "expression ::= expression NK_MINUS expression",
 /* 309 */ "expression ::= expression NK_STAR expression",
 /* 310 */ "expression ::= expression NK_SLASH expression",
 /* 311 */ "expression ::= expression NK_REM expression",
 /* 312 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 313 */ "expression_list ::= expression",
 /* 314 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 315 */ "column_reference ::= column_name",
 /* 316 */ "column_reference ::= table_name NK_DOT column_name",
 /* 317 */ "pseudo_column ::= ROWTS",
 /* 318 */ "pseudo_column ::= TBNAME",
 /* 319 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 320 */ "pseudo_column ::= QSTARTTS",
 /* 321 */ "pseudo_column ::= QENDTS",
 /* 322 */ "pseudo_column ::= WSTARTTS",
 /* 323 */ "pseudo_column ::= WENDTS",
 /* 324 */ "pseudo_column ::= WDURATION",
 /* 325 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 326 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 327 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 328 */ "function_expression ::= literal_func",
 /* 329 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 330 */ "literal_func ::= NOW",
 /* 331 */ "noarg_func ::= NOW",
 /* 332 */ "noarg_func ::= TODAY",
 /* 333 */ "noarg_func ::= TIMEZONE",
 /* 334 */ "star_func ::= COUNT",
 /* 335 */ "star_func ::= FIRST",
 /* 336 */ "star_func ::= LAST",
 /* 337 */ "star_func ::= LAST_ROW",
 /* 338 */ "star_func_para_list ::= NK_STAR",
 /* 339 */ "star_func_para_list ::= other_para_list",
 /* 340 */ "other_para_list ::= star_func_para",
 /* 341 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 342 */ "star_func_para ::= expression",
 /* 343 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 344 */ "predicate ::= expression compare_op expression",
 /* 345 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 346 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 347 */ "predicate ::= expression IS NULL",
 /* 348 */ "predicate ::= expression IS NOT NULL",
 /* 349 */ "predicate ::= expression in_op in_predicate_value",
 /* 350 */ "compare_op ::= NK_LT",
 /* 351 */ "compare_op ::= NK_GT",
 /* 352 */ "compare_op ::= NK_LE",
 /* 353 */ "compare_op ::= NK_GE",
 /* 354 */ "compare_op ::= NK_NE",
 /* 355 */ "compare_op ::= NK_EQ",
 /* 356 */ "compare_op ::= LIKE",
 /* 357 */ "compare_op ::= NOT LIKE",
 /* 358 */ "compare_op ::= MATCH",
 /* 359 */ "compare_op ::= NMATCH",
 /* 360 */ "compare_op ::= CONTAINS",
 /* 361 */ "in_op ::= IN",
 /* 362 */ "in_op ::= NOT IN",
 /* 363 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 364 */ "boolean_value_expression ::= boolean_primary",
 /* 365 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 366 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 367 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 368 */ "boolean_primary ::= predicate",
 /* 369 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 370 */ "common_expression ::= expression",
 /* 371 */ "common_expression ::= boolean_value_expression",
 /* 372 */ "from_clause ::= FROM table_reference_list",
 /* 373 */ "table_reference_list ::= table_reference",
 /* 374 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 375 */ "table_reference ::= table_primary",
 /* 376 */ "table_reference ::= joined_table",
 /* 377 */ "table_primary ::= table_name alias_opt",
 /* 378 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 379 */ "table_primary ::= subquery alias_opt",
 /* 380 */ "table_primary ::= parenthesized_joined_table",
 /* 381 */ "alias_opt ::=",
 /* 382 */ "alias_opt ::= table_alias",
 /* 383 */ "alias_opt ::= AS table_alias",
 /* 384 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 385 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 386 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 387 */ "join_type ::=",
 /* 388 */ "join_type ::= INNER",
 /* 389 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 390 */ "set_quantifier_opt ::=",
 /* 391 */ "set_quantifier_opt ::= DISTINCT",
 /* 392 */ "set_quantifier_opt ::= ALL",
 /* 393 */ "select_list ::= NK_STAR",
 /* 394 */ "select_list ::= select_sublist",
 /* 395 */ "select_sublist ::= select_item",
 /* 396 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 397 */ "select_item ::= common_expression",
 /* 398 */ "select_item ::= common_expression column_alias",
 /* 399 */ "select_item ::= common_expression AS column_alias",
 /* 400 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 401 */ "where_clause_opt ::=",
 /* 402 */ "where_clause_opt ::= WHERE search_condition",
 /* 403 */ "partition_by_clause_opt ::=",
 /* 404 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 405 */ "twindow_clause_opt ::=",
 /* 406 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 407 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 408 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 409 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 410 */ "sliding_opt ::=",
 /* 411 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 412 */ "fill_opt ::=",
 /* 413 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 414 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 415 */ "fill_mode ::= NONE",
 /* 416 */ "fill_mode ::= PREV",
 /* 417 */ "fill_mode ::= NULL",
 /* 418 */ "fill_mode ::= LINEAR",
 /* 419 */ "fill_mode ::= NEXT",
 /* 420 */ "group_by_clause_opt ::=",
 /* 421 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 422 */ "group_by_list ::= expression",
 /* 423 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 424 */ "having_clause_opt ::=",
 /* 425 */ "having_clause_opt ::= HAVING search_condition",
 /* 426 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 427 */ "query_expression_body ::= query_primary",
 /* 428 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 429 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 430 */ "query_primary ::= query_specification",
 /* 431 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 432 */ "order_by_clause_opt ::=",
 /* 433 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 434 */ "slimit_clause_opt ::=",
 /* 435 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 436 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 437 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 438 */ "limit_clause_opt ::=",
 /* 439 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 440 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 441 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 442 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 443 */ "search_condition ::= common_expression",
 /* 444 */ "sort_specification_list ::= sort_specification",
 /* 445 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 446 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 447 */ "ordering_specification_opt ::=",
 /* 448 */ "ordering_specification_opt ::= ASC",
 /* 449 */ "ordering_specification_opt ::= DESC",
 /* 450 */ "null_ordering_opt ::=",
 /* 451 */ "null_ordering_opt ::= NULLS FIRST",
 /* 452 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 239: /* cmd */
    case 242: /* literal */
    case 253: /* db_options */
    case 255: /* alter_db_options */
    case 260: /* retention */
    case 261: /* full_table_name */
    case 264: /* table_options */
    case 268: /* alter_table_clause */
    case 269: /* alter_table_options */
    case 272: /* signed_literal */
    case 273: /* create_subtable_clause */
    case 276: /* drop_table_clause */
    case 279: /* column_def */
    case 282: /* col_name */
    case 283: /* db_name_cond_opt */
    case 284: /* like_pattern_opt */
    case 285: /* table_name_cond */
    case 286: /* from_db_opt */
    case 287: /* func_name */
    case 290: /* index_options */
    case 292: /* duration_literal */
    case 293: /* sliding_opt */
    case 294: /* func */
    case 297: /* query_expression */
    case 300: /* explain_options */
    case 304: /* stream_options */
    case 305: /* into_opt */
    case 307: /* where_clause_opt */
    case 308: /* signed */
    case 309: /* literal_func */
    case 312: /* expression */
    case 313: /* pseudo_column */
    case 314: /* column_reference */
    case 315: /* function_expression */
    case 316: /* subquery */
    case 321: /* star_func_para */
    case 322: /* predicate */
    case 325: /* in_predicate_value */
    case 326: /* boolean_value_expression */
    case 327: /* boolean_primary */
    case 328: /* common_expression */
    case 329: /* from_clause */
    case 330: /* table_reference_list */
    case 331: /* table_reference */
    case 332: /* table_primary */
    case 333: /* joined_table */
    case 335: /* parenthesized_joined_table */
    case 337: /* search_condition */
    case 338: /* query_specification */
    case 342: /* twindow_clause_opt */
    case 344: /* having_clause_opt */
    case 346: /* select_item */
    case 347: /* fill_opt */
    case 350: /* query_expression_body */
    case 352: /* slimit_clause_opt */
    case 353: /* limit_clause_opt */
    case 354: /* query_primary */
    case 356: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy674)); 
}
      break;
    case 240: /* account_options */
    case 241: /* alter_account_options */
    case 243: /* alter_account_option */
    case 302: /* bufsize_opt */
{
 
}
      break;
    case 244: /* user_name */
    case 246: /* priv_level */
    case 249: /* db_name */
    case 250: /* dnode_endpoint */
    case 251: /* dnode_host_name */
    case 270: /* column_name */
    case 278: /* table_name */
    case 288: /* function_name */
    case 289: /* index_name */
    case 296: /* topic_name */
    case 298: /* cgroup_name */
    case 303: /* stream_name */
    case 310: /* table_alias */
    case 311: /* column_alias */
    case 317: /* star_func */
    case 319: /* noarg_func */
    case 334: /* alias_opt */
{
 
}
      break;
    case 245: /* privileges */
    case 247: /* priv_type_list */
    case 248: /* priv_type */
{
 
}
      break;
    case 252: /* not_exists_opt */
    case 254: /* exists_opt */
    case 299: /* analyze_opt */
    case 301: /* agg_func_opt */
    case 339: /* set_quantifier_opt */
{
 
}
      break;
    case 256: /* integer_list */
    case 257: /* variable_list */
    case 258: /* retention_list */
    case 262: /* column_def_list */
    case 263: /* tags_def_opt */
    case 265: /* multi_create_clause */
    case 266: /* tags_def */
    case 267: /* multi_drop_clause */
    case 274: /* specific_tags_opt */
    case 275: /* literal_list */
    case 277: /* col_name_list */
    case 280: /* func_name_list */
    case 291: /* func_list */
    case 295: /* expression_list */
    case 306: /* dnode_list */
    case 318: /* star_func_para_list */
    case 320: /* other_para_list */
    case 340: /* select_list */
    case 341: /* partition_by_clause_opt */
    case 343: /* group_by_clause_opt */
    case 345: /* select_sublist */
    case 349: /* group_by_list */
    case 351: /* order_by_clause_opt */
    case 355: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy530)); 
}
      break;
    case 259: /* alter_db_option */
    case 281: /* alter_table_option */
{
 
}
      break;
    case 271: /* type_name */
{
 
}
      break;
    case 323: /* compare_op */
    case 324: /* in_op */
{
 
}
      break;
    case 336: /* join_type */
{
 
}
      break;
    case 348: /* fill_mode */
{
 
}
      break;
    case 357: /* ordering_specification_opt */
{
 
}
      break;
    case 358: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  239,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  239,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  240,    0 }, /* (2) account_options ::= */
  {  240,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  240,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  240,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  240,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  240,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  240,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  240,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  240,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  240,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  241,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  241,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  243,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  243,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  243,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  243,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  243,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  243,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  243,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  243,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  243,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  243,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  239,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  239,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  239,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  239,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  245,   -1 }, /* (30) privileges ::= ALL */
  {  245,   -1 }, /* (31) privileges ::= priv_type_list */
  {  247,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  247,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  248,   -1 }, /* (34) priv_type ::= READ */
  {  248,   -1 }, /* (35) priv_type ::= WRITE */
  {  246,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  246,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  239,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  239,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  239,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  239,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  239,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  239,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  239,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  239,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  250,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  251,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  251,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  239,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  239,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  239,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  239,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  239,   -2 }, /* (61) cmd ::= USE db_name */
  {  239,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  252,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  252,    0 }, /* (64) not_exists_opt ::= */
  {  254,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  254,    0 }, /* (66) exists_opt ::= */
  {  253,    0 }, /* (67) db_options ::= */
  {  253,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  253,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  253,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  253,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  253,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  253,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  253,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  253,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  253,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  253,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  253,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  253,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  253,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  253,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  253,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  253,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  253,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  253,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  253,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  253,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  255,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  255,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  259,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  259,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  259,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  259,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  259,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  259,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  259,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  259,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  259,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  256,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  256,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  257,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  257,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  258,   -1 }, /* (103) retention_list ::= retention */
  {  258,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  260,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  239,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  239,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  239,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  239,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  239,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  239,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  239,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  268,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  268,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  268,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  268,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  268,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  268,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  268,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  268,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  268,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  268,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  265,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  265,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  273,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  267,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  267,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  276,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  274,    0 }, /* (129) specific_tags_opt ::= */
  {  274,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  261,   -1 }, /* (131) full_table_name ::= table_name */
  {  261,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  262,   -1 }, /* (133) column_def_list ::= column_def */
  {  262,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  279,   -2 }, /* (135) column_def ::= column_name type_name */
  {  279,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  271,   -1 }, /* (137) type_name ::= BOOL */
  {  271,   -1 }, /* (138) type_name ::= TINYINT */
  {  271,   -1 }, /* (139) type_name ::= SMALLINT */
  {  271,   -1 }, /* (140) type_name ::= INT */
  {  271,   -1 }, /* (141) type_name ::= INTEGER */
  {  271,   -1 }, /* (142) type_name ::= BIGINT */
  {  271,   -1 }, /* (143) type_name ::= FLOAT */
  {  271,   -1 }, /* (144) type_name ::= DOUBLE */
  {  271,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  271,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  271,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  271,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  271,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  271,   -1 }, /* (152) type_name ::= JSON */
  {  271,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  271,   -1 }, /* (155) type_name ::= BLOB */
  {  271,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (157) type_name ::= DECIMAL */
  {  271,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  271,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  263,    0 }, /* (160) tags_def_opt ::= */
  {  263,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  266,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  264,    0 }, /* (163) table_options ::= */
  {  264,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  264,   -3 }, /* (165) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  264,   -5 }, /* (166) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  264,   -3 }, /* (167) table_options ::= table_options TTL NK_INTEGER */
  {  264,   -5 }, /* (168) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  269,   -1 }, /* (169) alter_table_options ::= alter_table_option */
  {  269,   -2 }, /* (170) alter_table_options ::= alter_table_options alter_table_option */
  {  281,   -2 }, /* (171) alter_table_option ::= COMMENT NK_STRING */
  {  281,   -2 }, /* (172) alter_table_option ::= TTL NK_INTEGER */
  {  277,   -1 }, /* (173) col_name_list ::= col_name */
  {  277,   -3 }, /* (174) col_name_list ::= col_name_list NK_COMMA col_name */
  {  282,   -1 }, /* (175) col_name ::= column_name */
  {  239,   -2 }, /* (176) cmd ::= SHOW DNODES */
  {  239,   -2 }, /* (177) cmd ::= SHOW USERS */
  {  239,   -2 }, /* (178) cmd ::= SHOW DATABASES */
  {  239,   -4 }, /* (179) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  239,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  239,   -3 }, /* (181) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  239,   -2 }, /* (182) cmd ::= SHOW MNODES */
  {  239,   -2 }, /* (183) cmd ::= SHOW MODULES */
  {  239,   -2 }, /* (184) cmd ::= SHOW QNODES */
  {  239,   -2 }, /* (185) cmd ::= SHOW FUNCTIONS */
  {  239,   -5 }, /* (186) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  239,   -2 }, /* (187) cmd ::= SHOW STREAMS */
  {  239,   -2 }, /* (188) cmd ::= SHOW ACCOUNTS */
  {  239,   -2 }, /* (189) cmd ::= SHOW APPS */
  {  239,   -2 }, /* (190) cmd ::= SHOW CONNECTIONS */
  {  239,   -2 }, /* (191) cmd ::= SHOW LICENCE */
  {  239,   -2 }, /* (192) cmd ::= SHOW GRANTS */
  {  239,   -4 }, /* (193) cmd ::= SHOW CREATE DATABASE db_name */
  {  239,   -4 }, /* (194) cmd ::= SHOW CREATE TABLE full_table_name */
  {  239,   -4 }, /* (195) cmd ::= SHOW CREATE STABLE full_table_name */
  {  239,   -2 }, /* (196) cmd ::= SHOW QUERIES */
  {  239,   -2 }, /* (197) cmd ::= SHOW SCORES */
  {  239,   -2 }, /* (198) cmd ::= SHOW TOPICS */
  {  239,   -2 }, /* (199) cmd ::= SHOW VARIABLES */
  {  239,   -2 }, /* (200) cmd ::= SHOW BNODES */
  {  239,   -2 }, /* (201) cmd ::= SHOW SNODES */
  {  239,   -2 }, /* (202) cmd ::= SHOW CLUSTER */
  {  239,   -2 }, /* (203) cmd ::= SHOW TRANSACTIONS */
  {  283,    0 }, /* (204) db_name_cond_opt ::= */
  {  283,   -2 }, /* (205) db_name_cond_opt ::= db_name NK_DOT */
  {  284,    0 }, /* (206) like_pattern_opt ::= */
  {  284,   -2 }, /* (207) like_pattern_opt ::= LIKE NK_STRING */
  {  285,   -1 }, /* (208) table_name_cond ::= table_name */
  {  286,    0 }, /* (209) from_db_opt ::= */
  {  286,   -2 }, /* (210) from_db_opt ::= FROM db_name */
  {  280,   -1 }, /* (211) func_name_list ::= func_name */
  {  280,   -3 }, /* (212) func_name_list ::= func_name_list NK_COMMA func_name */
  {  287,   -1 }, /* (213) func_name ::= function_name */
  {  239,   -8 }, /* (214) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  239,  -10 }, /* (215) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  239,   -6 }, /* (216) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  290,    0 }, /* (217) index_options ::= */
  {  290,   -9 }, /* (218) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  290,  -11 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  291,   -1 }, /* (220) func_list ::= func */
  {  291,   -3 }, /* (221) func_list ::= func_list NK_COMMA func */
  {  294,   -4 }, /* (222) func ::= function_name NK_LP expression_list NK_RP */
  {  239,   -6 }, /* (223) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  239,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  239,   -7 }, /* (225) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  239,   -4 }, /* (226) cmd ::= DROP TOPIC exists_opt topic_name */
  {  239,   -7 }, /* (227) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  239,   -2 }, /* (228) cmd ::= DESC full_table_name */
  {  239,   -2 }, /* (229) cmd ::= DESCRIBE full_table_name */
  {  239,   -3 }, /* (230) cmd ::= RESET QUERY CACHE */
  {  239,   -4 }, /* (231) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  299,    0 }, /* (232) analyze_opt ::= */
  {  299,   -1 }, /* (233) analyze_opt ::= ANALYZE */
  {  300,    0 }, /* (234) explain_options ::= */
  {  300,   -3 }, /* (235) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  300,   -3 }, /* (236) explain_options ::= explain_options RATIO NK_FLOAT */
  {  239,   -6 }, /* (237) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  239,  -10 }, /* (238) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  239,   -4 }, /* (239) cmd ::= DROP FUNCTION exists_opt function_name */
  {  301,    0 }, /* (240) agg_func_opt ::= */
  {  301,   -1 }, /* (241) agg_func_opt ::= AGGREGATE */
  {  302,    0 }, /* (242) bufsize_opt ::= */
  {  302,   -2 }, /* (243) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  239,   -8 }, /* (244) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  239,   -4 }, /* (245) cmd ::= DROP STREAM exists_opt stream_name */
  {  305,    0 }, /* (246) into_opt ::= */
  {  305,   -2 }, /* (247) into_opt ::= INTO full_table_name */
  {  304,    0 }, /* (248) stream_options ::= */
  {  304,   -3 }, /* (249) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  304,   -3 }, /* (250) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  304,   -3 }, /* (251) stream_options ::= stream_options WATERMARK duration_literal */
  {  239,   -3 }, /* (252) cmd ::= KILL CONNECTION NK_INTEGER */
  {  239,   -3 }, /* (253) cmd ::= KILL QUERY NK_INTEGER */
  {  239,   -3 }, /* (254) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  239,   -2 }, /* (255) cmd ::= BALANCE VGROUP */
  {  239,   -4 }, /* (256) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  239,   -4 }, /* (257) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  239,   -3 }, /* (258) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  306,   -2 }, /* (259) dnode_list ::= DNODE NK_INTEGER */
  {  306,   -3 }, /* (260) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  239,   -3 }, /* (261) cmd ::= SYNCDB db_name REPLICA */
  {  239,   -4 }, /* (262) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  239,   -1 }, /* (263) cmd ::= query_expression */
  {  242,   -1 }, /* (264) literal ::= NK_INTEGER */
  {  242,   -1 }, /* (265) literal ::= NK_FLOAT */
  {  242,   -1 }, /* (266) literal ::= NK_STRING */
  {  242,   -1 }, /* (267) literal ::= NK_BOOL */
  {  242,   -2 }, /* (268) literal ::= TIMESTAMP NK_STRING */
  {  242,   -1 }, /* (269) literal ::= duration_literal */
  {  242,   -1 }, /* (270) literal ::= NULL */
  {  242,   -1 }, /* (271) literal ::= NK_QUESTION */
  {  292,   -1 }, /* (272) duration_literal ::= NK_VARIABLE */
  {  308,   -1 }, /* (273) signed ::= NK_INTEGER */
  {  308,   -2 }, /* (274) signed ::= NK_PLUS NK_INTEGER */
  {  308,   -2 }, /* (275) signed ::= NK_MINUS NK_INTEGER */
  {  308,   -1 }, /* (276) signed ::= NK_FLOAT */
  {  308,   -2 }, /* (277) signed ::= NK_PLUS NK_FLOAT */
  {  308,   -2 }, /* (278) signed ::= NK_MINUS NK_FLOAT */
  {  272,   -1 }, /* (279) signed_literal ::= signed */
  {  272,   -1 }, /* (280) signed_literal ::= NK_STRING */
  {  272,   -1 }, /* (281) signed_literal ::= NK_BOOL */
  {  272,   -2 }, /* (282) signed_literal ::= TIMESTAMP NK_STRING */
  {  272,   -1 }, /* (283) signed_literal ::= duration_literal */
  {  272,   -1 }, /* (284) signed_literal ::= NULL */
  {  272,   -1 }, /* (285) signed_literal ::= literal_func */
  {  275,   -1 }, /* (286) literal_list ::= signed_literal */
  {  275,   -3 }, /* (287) literal_list ::= literal_list NK_COMMA signed_literal */
  {  249,   -1 }, /* (288) db_name ::= NK_ID */
  {  278,   -1 }, /* (289) table_name ::= NK_ID */
  {  270,   -1 }, /* (290) column_name ::= NK_ID */
  {  288,   -1 }, /* (291) function_name ::= NK_ID */
  {  310,   -1 }, /* (292) table_alias ::= NK_ID */
  {  311,   -1 }, /* (293) column_alias ::= NK_ID */
  {  244,   -1 }, /* (294) user_name ::= NK_ID */
  {  289,   -1 }, /* (295) index_name ::= NK_ID */
  {  296,   -1 }, /* (296) topic_name ::= NK_ID */
  {  303,   -1 }, /* (297) stream_name ::= NK_ID */
  {  298,   -1 }, /* (298) cgroup_name ::= NK_ID */
  {  312,   -1 }, /* (299) expression ::= literal */
  {  312,   -1 }, /* (300) expression ::= pseudo_column */
  {  312,   -1 }, /* (301) expression ::= column_reference */
  {  312,   -1 }, /* (302) expression ::= function_expression */
  {  312,   -1 }, /* (303) expression ::= subquery */
  {  312,   -3 }, /* (304) expression ::= NK_LP expression NK_RP */
  {  312,   -2 }, /* (305) expression ::= NK_PLUS expression */
  {  312,   -2 }, /* (306) expression ::= NK_MINUS expression */
  {  312,   -3 }, /* (307) expression ::= expression NK_PLUS expression */
  {  312,   -3 }, /* (308) expression ::= expression NK_MINUS expression */
  {  312,   -3 }, /* (309) expression ::= expression NK_STAR expression */
  {  312,   -3 }, /* (310) expression ::= expression NK_SLASH expression */
  {  312,   -3 }, /* (311) expression ::= expression NK_REM expression */
  {  312,   -3 }, /* (312) expression ::= column_reference NK_ARROW NK_STRING */
  {  295,   -1 }, /* (313) expression_list ::= expression */
  {  295,   -3 }, /* (314) expression_list ::= expression_list NK_COMMA expression */
  {  314,   -1 }, /* (315) column_reference ::= column_name */
  {  314,   -3 }, /* (316) column_reference ::= table_name NK_DOT column_name */
  {  313,   -1 }, /* (317) pseudo_column ::= ROWTS */
  {  313,   -1 }, /* (318) pseudo_column ::= TBNAME */
  {  313,   -3 }, /* (319) pseudo_column ::= table_name NK_DOT TBNAME */
  {  313,   -1 }, /* (320) pseudo_column ::= QSTARTTS */
  {  313,   -1 }, /* (321) pseudo_column ::= QENDTS */
  {  313,   -1 }, /* (322) pseudo_column ::= WSTARTTS */
  {  313,   -1 }, /* (323) pseudo_column ::= WENDTS */
  {  313,   -1 }, /* (324) pseudo_column ::= WDURATION */
  {  315,   -4 }, /* (325) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  315,   -4 }, /* (326) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  315,   -6 }, /* (327) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  315,   -1 }, /* (328) function_expression ::= literal_func */
  {  309,   -3 }, /* (329) literal_func ::= noarg_func NK_LP NK_RP */
  {  309,   -1 }, /* (330) literal_func ::= NOW */
  {  319,   -1 }, /* (331) noarg_func ::= NOW */
  {  319,   -1 }, /* (332) noarg_func ::= TODAY */
  {  319,   -1 }, /* (333) noarg_func ::= TIMEZONE */
  {  317,   -1 }, /* (334) star_func ::= COUNT */
  {  317,   -1 }, /* (335) star_func ::= FIRST */
  {  317,   -1 }, /* (336) star_func ::= LAST */
  {  317,   -1 }, /* (337) star_func ::= LAST_ROW */
  {  318,   -1 }, /* (338) star_func_para_list ::= NK_STAR */
  {  318,   -1 }, /* (339) star_func_para_list ::= other_para_list */
  {  320,   -1 }, /* (340) other_para_list ::= star_func_para */
  {  320,   -3 }, /* (341) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  321,   -1 }, /* (342) star_func_para ::= expression */
  {  321,   -3 }, /* (343) star_func_para ::= table_name NK_DOT NK_STAR */
  {  322,   -3 }, /* (344) predicate ::= expression compare_op expression */
  {  322,   -5 }, /* (345) predicate ::= expression BETWEEN expression AND expression */
  {  322,   -6 }, /* (346) predicate ::= expression NOT BETWEEN expression AND expression */
  {  322,   -3 }, /* (347) predicate ::= expression IS NULL */
  {  322,   -4 }, /* (348) predicate ::= expression IS NOT NULL */
  {  322,   -3 }, /* (349) predicate ::= expression in_op in_predicate_value */
  {  323,   -1 }, /* (350) compare_op ::= NK_LT */
  {  323,   -1 }, /* (351) compare_op ::= NK_GT */
  {  323,   -1 }, /* (352) compare_op ::= NK_LE */
  {  323,   -1 }, /* (353) compare_op ::= NK_GE */
  {  323,   -1 }, /* (354) compare_op ::= NK_NE */
  {  323,   -1 }, /* (355) compare_op ::= NK_EQ */
  {  323,   -1 }, /* (356) compare_op ::= LIKE */
  {  323,   -2 }, /* (357) compare_op ::= NOT LIKE */
  {  323,   -1 }, /* (358) compare_op ::= MATCH */
  {  323,   -1 }, /* (359) compare_op ::= NMATCH */
  {  323,   -1 }, /* (360) compare_op ::= CONTAINS */
  {  324,   -1 }, /* (361) in_op ::= IN */
  {  324,   -2 }, /* (362) in_op ::= NOT IN */
  {  325,   -3 }, /* (363) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  326,   -1 }, /* (364) boolean_value_expression ::= boolean_primary */
  {  326,   -2 }, /* (365) boolean_value_expression ::= NOT boolean_primary */
  {  326,   -3 }, /* (366) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  326,   -3 }, /* (367) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  327,   -1 }, /* (368) boolean_primary ::= predicate */
  {  327,   -3 }, /* (369) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  328,   -1 }, /* (370) common_expression ::= expression */
  {  328,   -1 }, /* (371) common_expression ::= boolean_value_expression */
  {  329,   -2 }, /* (372) from_clause ::= FROM table_reference_list */
  {  330,   -1 }, /* (373) table_reference_list ::= table_reference */
  {  330,   -3 }, /* (374) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  331,   -1 }, /* (375) table_reference ::= table_primary */
  {  331,   -1 }, /* (376) table_reference ::= joined_table */
  {  332,   -2 }, /* (377) table_primary ::= table_name alias_opt */
  {  332,   -4 }, /* (378) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  332,   -2 }, /* (379) table_primary ::= subquery alias_opt */
  {  332,   -1 }, /* (380) table_primary ::= parenthesized_joined_table */
  {  334,    0 }, /* (381) alias_opt ::= */
  {  334,   -1 }, /* (382) alias_opt ::= table_alias */
  {  334,   -2 }, /* (383) alias_opt ::= AS table_alias */
  {  335,   -3 }, /* (384) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  335,   -3 }, /* (385) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  333,   -6 }, /* (386) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  336,    0 }, /* (387) join_type ::= */
  {  336,   -1 }, /* (388) join_type ::= INNER */
  {  338,   -9 }, /* (389) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  339,    0 }, /* (390) set_quantifier_opt ::= */
  {  339,   -1 }, /* (391) set_quantifier_opt ::= DISTINCT */
  {  339,   -1 }, /* (392) set_quantifier_opt ::= ALL */
  {  340,   -1 }, /* (393) select_list ::= NK_STAR */
  {  340,   -1 }, /* (394) select_list ::= select_sublist */
  {  345,   -1 }, /* (395) select_sublist ::= select_item */
  {  345,   -3 }, /* (396) select_sublist ::= select_sublist NK_COMMA select_item */
  {  346,   -1 }, /* (397) select_item ::= common_expression */
  {  346,   -2 }, /* (398) select_item ::= common_expression column_alias */
  {  346,   -3 }, /* (399) select_item ::= common_expression AS column_alias */
  {  346,   -3 }, /* (400) select_item ::= table_name NK_DOT NK_STAR */
  {  307,    0 }, /* (401) where_clause_opt ::= */
  {  307,   -2 }, /* (402) where_clause_opt ::= WHERE search_condition */
  {  341,    0 }, /* (403) partition_by_clause_opt ::= */
  {  341,   -3 }, /* (404) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  342,    0 }, /* (405) twindow_clause_opt ::= */
  {  342,   -6 }, /* (406) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  342,   -4 }, /* (407) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  342,   -6 }, /* (408) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  342,   -8 }, /* (409) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  293,    0 }, /* (410) sliding_opt ::= */
  {  293,   -4 }, /* (411) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  347,    0 }, /* (412) fill_opt ::= */
  {  347,   -4 }, /* (413) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  347,   -6 }, /* (414) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  348,   -1 }, /* (415) fill_mode ::= NONE */
  {  348,   -1 }, /* (416) fill_mode ::= PREV */
  {  348,   -1 }, /* (417) fill_mode ::= NULL */
  {  348,   -1 }, /* (418) fill_mode ::= LINEAR */
  {  348,   -1 }, /* (419) fill_mode ::= NEXT */
  {  343,    0 }, /* (420) group_by_clause_opt ::= */
  {  343,   -3 }, /* (421) group_by_clause_opt ::= GROUP BY group_by_list */
  {  349,   -1 }, /* (422) group_by_list ::= expression */
  {  349,   -3 }, /* (423) group_by_list ::= group_by_list NK_COMMA expression */
  {  344,    0 }, /* (424) having_clause_opt ::= */
  {  344,   -2 }, /* (425) having_clause_opt ::= HAVING search_condition */
  {  297,   -4 }, /* (426) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  350,   -1 }, /* (427) query_expression_body ::= query_primary */
  {  350,   -4 }, /* (428) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  350,   -3 }, /* (429) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  354,   -1 }, /* (430) query_primary ::= query_specification */
  {  354,   -6 }, /* (431) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  351,    0 }, /* (432) order_by_clause_opt ::= */
  {  351,   -3 }, /* (433) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  352,    0 }, /* (434) slimit_clause_opt ::= */
  {  352,   -2 }, /* (435) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  352,   -4 }, /* (436) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  352,   -4 }, /* (437) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  353,    0 }, /* (438) limit_clause_opt ::= */
  {  353,   -2 }, /* (439) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  353,   -4 }, /* (440) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  353,   -4 }, /* (441) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  316,   -3 }, /* (442) subquery ::= NK_LP query_expression NK_RP */
  {  337,   -1 }, /* (443) search_condition ::= common_expression */
  {  355,   -1 }, /* (444) sort_specification_list ::= sort_specification */
  {  355,   -3 }, /* (445) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  356,   -3 }, /* (446) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  357,    0 }, /* (447) ordering_specification_opt ::= */
  {  357,   -1 }, /* (448) ordering_specification_opt ::= ASC */
  {  357,   -1 }, /* (449) ordering_specification_opt ::= DESC */
  {  358,    0 }, /* (450) null_ordering_opt ::= */
  {  358,   -2 }, /* (451) null_ordering_opt ::= NULLS FIRST */
  {  358,   -2 }, /* (452) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,240,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,243,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,241,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy421, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy421, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy669, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy669, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy669 = yymsp[0].minor.yy669; }
  yymsp[0].minor.yy669 = yylhsminor.yy669;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy669 = yymsp[-2].minor.yy669 | yymsp[0].minor.yy669; }
  yymsp[-2].minor.yy669 = yylhsminor.yy669;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy421 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy421 = yylhsminor.yy421;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy421 = yymsp[-2].minor.yy421; }
  yymsp[-2].minor.yy421 = yylhsminor.yy421;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy421, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 288: /* db_name ::= NK_ID */ yytestcase(yyruleno==288);
      case 289: /* table_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* column_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* function_name ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* table_alias ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* column_alias ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* user_name ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* index_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* topic_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* stream_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==298);
      case 331: /* noarg_func ::= NOW */ yytestcase(yyruleno==331);
      case 332: /* noarg_func ::= TODAY */ yytestcase(yyruleno==332);
      case 333: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==333);
      case 334: /* star_func ::= COUNT */ yytestcase(yyruleno==334);
      case 335: /* star_func ::= FIRST */ yytestcase(yyruleno==335);
      case 336: /* star_func ::= LAST */ yytestcase(yyruleno==336);
      case 337: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==337);
{ yylhsminor.yy421 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy421 = yylhsminor.yy421;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy621, &yymsp[-1].minor.yy421, yymsp[0].minor.yy674); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy421, yymsp[0].minor.yy674); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy621 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 232: /* analyze_opt ::= */ yytestcase(yyruleno==232);
      case 240: /* agg_func_opt ::= */ yytestcase(yyruleno==240);
      case 390: /* set_quantifier_opt ::= */ yytestcase(yyruleno==390);
{ yymsp[1].minor.yy621 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy621 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy674 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_KEEP, yymsp[0].minor.yy530); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_RETENTIONS, yymsp[0].minor.yy530); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy674 = setDatabaseOption(pCxt, yymsp[-2].minor.yy674, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy674 = createAlterDatabaseOptions(pCxt); yylhsminor.yy674 = setAlterDatabaseOption(pCxt, yylhsminor.yy674, &yymsp[0].minor.yy557); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy674 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy674, &yymsp[0].minor.yy557); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy557.type = DB_OPTION_KEEP; yymsp[-1].minor.yy557.pList = yymsp[0].minor.yy530; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_PAGES; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_STRICT; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy557.type = DB_OPTION_WAL; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy530 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 260: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==260);
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy530 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 173: /* col_name_list ::= col_name */ yytestcase(yyruleno==173);
      case 211: /* func_name_list ::= func_name */ yytestcase(yyruleno==211);
      case 220: /* func_list ::= func */ yytestcase(yyruleno==220);
      case 286: /* literal_list ::= signed_literal */ yytestcase(yyruleno==286);
      case 340: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==340);
      case 395: /* select_sublist ::= select_item */ yytestcase(yyruleno==395);
      case 444: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==444);
{ yylhsminor.yy530 = createNodeList(pCxt, yymsp[0].minor.yy674); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 174: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==221);
      case 287: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==287);
      case 341: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==341);
      case 396: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==396);
      case 445: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==445);
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, yymsp[0].minor.yy674); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy674 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy621, yymsp[-5].minor.yy674, yymsp[-3].minor.yy530, yymsp[-1].minor.yy530, yymsp[0].minor.yy674); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy530); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy530); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy621, yymsp[0].minor.yy674); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 263: /* cmd ::= query_expression */ yytestcase(yyruleno==263);
{ pCxt->pRootNode = yymsp[0].minor.yy674; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy674 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy674 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy674, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy421); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy674 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy674 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy674, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy421); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy674 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy674 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy674, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy674 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy674, &yymsp[-2].minor.yy421, yymsp[0].minor.yy674); }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-1].minor.yy530, yymsp[0].minor.yy674); }
  yymsp[-1].minor.yy530 = yylhsminor.yy530;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy674 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy621, yymsp[-8].minor.yy674, yymsp[-6].minor.yy674, yymsp[-5].minor.yy530, yymsp[-2].minor.yy530, yymsp[0].minor.yy674); }
  yymsp[-9].minor.yy674 = yylhsminor.yy674;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy674 = createDropTableClause(pCxt, yymsp[-1].minor.yy621, yymsp[0].minor.yy674); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 403: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==403);
      case 420: /* group_by_clause_opt ::= */ yytestcase(yyruleno==420);
      case 432: /* order_by_clause_opt ::= */ yytestcase(yyruleno==432);
{ yymsp[1].minor.yy530 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy530 = yymsp[-1].minor.yy530; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy674 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy421, NULL); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy674 = createRealTableNode(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421, NULL); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy674 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy421, yymsp[0].minor.yy690, NULL); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy674 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy421, yymsp[-2].minor.yy690, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy690 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy690 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy690 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy690 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 339: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==339);
      case 394: /* select_list ::= select_sublist */ yytestcase(yyruleno==394);
{ yylhsminor.yy530 = yymsp[0].minor.yy530; }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy530 = yymsp[-1].minor.yy530; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy674 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-2].minor.yy674, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 165: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-2].minor.yy674, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 166: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-4].minor.yy674, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy530); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 167: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-2].minor.yy674, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 168: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-4].minor.yy674, TABLE_OPTION_SMA, yymsp[-1].minor.yy530); }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 169: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy674 = createAlterTableOptions(pCxt); yylhsminor.yy674 = setTableOption(pCxt, yylhsminor.yy674, yymsp[0].minor.yy557.type, &yymsp[0].minor.yy557.val); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 170: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy674 = setTableOption(pCxt, yymsp[-1].minor.yy674, yymsp[0].minor.yy557.type, &yymsp[0].minor.yy557.val); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 171: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy557.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 172: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy557.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy557.val = yymsp[0].minor.yy0; }
        break;
      case 175: /* col_name ::= column_name */
{ yylhsminor.yy674 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy421); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 176: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy674, NULL); }
        break;
      case 182: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 187: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 189: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW LICENCE */
      case 192: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==192);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy421); }
        break;
      case 194: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy674); }
        break;
      case 195: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy674); }
        break;
      case 196: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 204: /* db_name_cond_opt ::= */
      case 209: /* from_db_opt ::= */ yytestcase(yyruleno==209);
{ yymsp[1].minor.yy674 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 205: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 206: /* like_pattern_opt ::= */
      case 217: /* index_options ::= */ yytestcase(yyruleno==217);
      case 246: /* into_opt ::= */ yytestcase(yyruleno==246);
      case 401: /* where_clause_opt ::= */ yytestcase(yyruleno==401);
      case 405: /* twindow_clause_opt ::= */ yytestcase(yyruleno==405);
      case 410: /* sliding_opt ::= */ yytestcase(yyruleno==410);
      case 412: /* fill_opt ::= */ yytestcase(yyruleno==412);
      case 424: /* having_clause_opt ::= */ yytestcase(yyruleno==424);
      case 434: /* slimit_clause_opt ::= */ yytestcase(yyruleno==434);
      case 438: /* limit_clause_opt ::= */ yytestcase(yyruleno==438);
{ yymsp[1].minor.yy674 = NULL; }
        break;
      case 207: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 208: /* table_name_cond ::= table_name */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy421); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 210: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy421); }
        break;
      case 213: /* func_name ::= function_name */
{ yylhsminor.yy674 = createFunctionNode(pCxt, &yymsp[0].minor.yy421, NULL); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 214: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy621, &yymsp[-3].minor.yy421, &yymsp[-1].minor.yy421, NULL, yymsp[0].minor.yy674); }
        break;
      case 215: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy621, &yymsp[-5].minor.yy421, &yymsp[-3].minor.yy421, yymsp[-1].minor.yy530, NULL); }
        break;
      case 216: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy621, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 218: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy674 = createIndexOption(pCxt, yymsp[-6].minor.yy530, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), NULL, yymsp[0].minor.yy674); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy674 = createIndexOption(pCxt, yymsp[-8].minor.yy530, releaseRawExprNode(pCxt, yymsp[-4].minor.yy674), releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), yymsp[0].minor.yy674); }
        break;
      case 222: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy674 = createFunctionNode(pCxt, &yymsp[-3].minor.yy421, yymsp[-1].minor.yy530); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 223: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy621, &yymsp[-2].minor.yy421, yymsp[0].minor.yy674, NULL, NULL); }
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy621, &yymsp[-3].minor.yy421, NULL, &yymsp[0].minor.yy421, NULL); }
        break;
      case 225: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy621, &yymsp[-3].minor.yy421, NULL, NULL, yymsp[0].minor.yy674); }
        break;
      case 226: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 227: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy621, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421); }
        break;
      case 228: /* cmd ::= DESC full_table_name */
      case 229: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy674); }
        break;
      case 230: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 231: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy621, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 233: /* analyze_opt ::= ANALYZE */
      case 241: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==241);
      case 391: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==391);
{ yymsp[0].minor.yy621 = true; }
        break;
      case 234: /* explain_options ::= */
{ yymsp[1].minor.yy674 = createDefaultExplainOptions(pCxt); }
        break;
      case 235: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy674 = setExplainVerbose(pCxt, yymsp[-2].minor.yy674, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 236: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy674 = setExplainRatio(pCxt, yymsp[-2].minor.yy674, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 237: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy530); }
        break;
      case 238: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy621, yymsp[-8].minor.yy621, &yymsp[-5].minor.yy421, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy690, yymsp[0].minor.yy42); }
        break;
      case 239: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 242: /* bufsize_opt ::= */
{ yymsp[1].minor.yy42 = 0; }
        break;
      case 243: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy42 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 244: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy621, &yymsp[-4].minor.yy421, yymsp[-2].minor.yy674, yymsp[-3].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 245: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy621, &yymsp[0].minor.yy421); }
        break;
      case 247: /* into_opt ::= INTO full_table_name */
      case 372: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==372);
      case 402: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==402);
      case 425: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==425);
{ yymsp[-1].minor.yy674 = yymsp[0].minor.yy674; }
        break;
      case 248: /* stream_options ::= */
{ yymsp[1].minor.yy674 = createStreamOptions(pCxt); }
        break;
      case 249: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy674)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy674 = yymsp[-2].minor.yy674; }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 250: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy674)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy674 = yymsp[-2].minor.yy674; }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 251: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy674)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy674); yylhsminor.yy674 = yymsp[-2].minor.yy674; }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 252: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 253: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 254: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 255: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 256: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 257: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy530); }
        break;
      case 258: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 259: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy530 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 261: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy421); }
        break;
      case 262: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 264: /* literal ::= NK_INTEGER */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 265: /* literal ::= NK_FLOAT */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 266: /* literal ::= NK_STRING */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 267: /* literal ::= NK_BOOL */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 268: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 269: /* literal ::= duration_literal */
      case 279: /* signed_literal ::= signed */ yytestcase(yyruleno==279);
      case 299: /* expression ::= literal */ yytestcase(yyruleno==299);
      case 300: /* expression ::= pseudo_column */ yytestcase(yyruleno==300);
      case 301: /* expression ::= column_reference */ yytestcase(yyruleno==301);
      case 302: /* expression ::= function_expression */ yytestcase(yyruleno==302);
      case 303: /* expression ::= subquery */ yytestcase(yyruleno==303);
      case 328: /* function_expression ::= literal_func */ yytestcase(yyruleno==328);
      case 364: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==364);
      case 368: /* boolean_primary ::= predicate */ yytestcase(yyruleno==368);
      case 370: /* common_expression ::= expression */ yytestcase(yyruleno==370);
      case 371: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==371);
      case 373: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==373);
      case 375: /* table_reference ::= table_primary */ yytestcase(yyruleno==375);
      case 376: /* table_reference ::= joined_table */ yytestcase(yyruleno==376);
      case 380: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==380);
      case 427: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==427);
      case 430: /* query_primary ::= query_specification */ yytestcase(yyruleno==430);
{ yylhsminor.yy674 = yymsp[0].minor.yy674; }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 270: /* literal ::= NULL */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 271: /* literal ::= NK_QUESTION */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 272: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 273: /* signed ::= NK_INTEGER */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 274: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 275: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 276: /* signed ::= NK_FLOAT */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 277: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 278: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 280: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 281: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 282: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 283: /* signed_literal ::= duration_literal */
      case 285: /* signed_literal ::= literal_func */ yytestcase(yyruleno==285);
      case 342: /* star_func_para ::= expression */ yytestcase(yyruleno==342);
      case 397: /* select_item ::= common_expression */ yytestcase(yyruleno==397);
      case 443: /* search_condition ::= common_expression */ yytestcase(yyruleno==443);
{ yylhsminor.yy674 = releaseRawExprNode(pCxt, yymsp[0].minor.yy674); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 284: /* signed_literal ::= NULL */
{ yylhsminor.yy674 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 304: /* expression ::= NK_LP expression NK_RP */
      case 369: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==369);
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 305: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy674));
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 306: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy674), NULL));
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 307: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 308: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 309: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 310: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 311: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 312: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 313: /* expression_list ::= expression */
{ yylhsminor.yy530 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy674)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 314: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, releaseRawExprNode(pCxt, yymsp[0].minor.yy674)); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 315: /* column_reference ::= column_name */
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy421, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy421)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 316: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421, createColumnNode(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy421)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 317: /* pseudo_column ::= ROWTS */
      case 318: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==318);
      case 320: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==320);
      case 321: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==321);
      case 322: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==322);
      case 323: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==323);
      case 324: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==324);
      case 330: /* literal_func ::= NOW */ yytestcase(yyruleno==330);
{ yylhsminor.yy674 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy674 = yylhsminor.yy674;
        break;
      case 319: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy421)))); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 325: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 326: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==326);
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy421, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy421, yymsp[-1].minor.yy530)); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 327: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), yymsp[-1].minor.yy690)); }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 329: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy421, NULL)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 338: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy530 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 343: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 400: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==400);
{ yylhsminor.yy674 = createColumnNode(pCxt, &yymsp[-2].minor.yy421, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 344: /* predicate ::= expression compare_op expression */
      case 349: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==349);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy28, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 345: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy674), releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-4].minor.yy674 = yylhsminor.yy674;
        break;
      case 346: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy674), releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 347: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), NULL));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 348: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), NULL));
                                                                                  }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 350: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy28 = OP_TYPE_LOWER_THAN; }
        break;
      case 351: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy28 = OP_TYPE_GREATER_THAN; }
        break;
      case 352: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy28 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 353: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy28 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 354: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy28 = OP_TYPE_NOT_EQUAL; }
        break;
      case 355: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy28 = OP_TYPE_EQUAL; }
        break;
      case 356: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy28 = OP_TYPE_LIKE; }
        break;
      case 357: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy28 = OP_TYPE_NOT_LIKE; }
        break;
      case 358: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy28 = OP_TYPE_MATCH; }
        break;
      case 359: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy28 = OP_TYPE_NMATCH; }
        break;
      case 360: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy28 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 361: /* in_op ::= IN */
{ yymsp[0].minor.yy28 = OP_TYPE_IN; }
        break;
      case 362: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy28 = OP_TYPE_NOT_IN; }
        break;
      case 363: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy530)); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 365: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy674), NULL));
                                                                                  }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 366: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 367: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy674);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy674);
                                                                                    yylhsminor.yy674 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), releaseRawExprNode(pCxt, yymsp[0].minor.yy674)));
                                                                                  }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 374: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy674 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy674, yymsp[0].minor.yy674, NULL); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 377: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy674 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 378: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy674 = createRealTableNode(pCxt, &yymsp[-3].minor.yy421, &yymsp[-1].minor.yy421, &yymsp[0].minor.yy421); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 379: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy674 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674), &yymsp[0].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 381: /* alias_opt ::= */
{ yymsp[1].minor.yy421 = nil_token;  }
        break;
      case 382: /* alias_opt ::= table_alias */
{ yylhsminor.yy421 = yymsp[0].minor.yy421; }
  yymsp[0].minor.yy421 = yylhsminor.yy421;
        break;
      case 383: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy421 = yymsp[0].minor.yy421; }
        break;
      case 384: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 385: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==385);
{ yymsp[-2].minor.yy674 = yymsp[-1].minor.yy674; }
        break;
      case 386: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy674 = createJoinTableNode(pCxt, yymsp[-4].minor.yy636, yymsp[-5].minor.yy674, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-5].minor.yy674 = yylhsminor.yy674;
        break;
      case 387: /* join_type ::= */
{ yymsp[1].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 388: /* join_type ::= INNER */
{ yymsp[0].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 389: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy674 = createSelectStmt(pCxt, yymsp[-7].minor.yy621, yymsp[-6].minor.yy530, yymsp[-5].minor.yy674);
                                                                                    yymsp[-8].minor.yy674 = addWhereClause(pCxt, yymsp[-8].minor.yy674, yymsp[-4].minor.yy674);
                                                                                    yymsp[-8].minor.yy674 = addPartitionByClause(pCxt, yymsp[-8].minor.yy674, yymsp[-3].minor.yy530);
                                                                                    yymsp[-8].minor.yy674 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy674, yymsp[-2].minor.yy674);
                                                                                    yymsp[-8].minor.yy674 = addGroupByClause(pCxt, yymsp[-8].minor.yy674, yymsp[-1].minor.yy530);
                                                                                    yymsp[-8].minor.yy674 = addHavingClause(pCxt, yymsp[-8].minor.yy674, yymsp[0].minor.yy674);
                                                                                  }
        break;
      case 392: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy621 = false; }
        break;
      case 393: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy530 = NULL; }
        break;
      case 398: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy674 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674), &yymsp[0].minor.yy421); }
  yymsp[-1].minor.yy674 = yylhsminor.yy674;
        break;
      case 399: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy674 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), &yymsp[0].minor.yy421); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 404: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 421: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==421);
      case 433: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==433);
{ yymsp[-2].minor.yy530 = yymsp[0].minor.yy530; }
        break;
      case 406: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy674 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), releaseRawExprNode(pCxt, yymsp[-1].minor.yy674)); }
        break;
      case 407: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy674 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy674)); }
        break;
      case 408: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy674 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), NULL, yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 409: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy674 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy674), releaseRawExprNode(pCxt, yymsp[-3].minor.yy674), yymsp[-1].minor.yy674, yymsp[0].minor.yy674); }
        break;
      case 411: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy674 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy674); }
        break;
      case 413: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy674 = createFillNode(pCxt, yymsp[-1].minor.yy320, NULL); }
        break;
      case 414: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy674 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy530)); }
        break;
      case 415: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy320 = FILL_MODE_NONE; }
        break;
      case 416: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy320 = FILL_MODE_PREV; }
        break;
      case 417: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy320 = FILL_MODE_NULL; }
        break;
      case 418: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy320 = FILL_MODE_LINEAR; }
        break;
      case 419: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy320 = FILL_MODE_NEXT; }
        break;
      case 422: /* group_by_list ::= expression */
{ yylhsminor.yy530 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); }
  yymsp[0].minor.yy530 = yylhsminor.yy530;
        break;
      case 423: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy530 = addNodeToList(pCxt, yymsp[-2].minor.yy530, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy674))); }
  yymsp[-2].minor.yy530 = yylhsminor.yy530;
        break;
      case 426: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy674 = addOrderByClause(pCxt, yymsp[-3].minor.yy674, yymsp[-2].minor.yy530);
                                                                                    yylhsminor.yy674 = addSlimitClause(pCxt, yylhsminor.yy674, yymsp[-1].minor.yy674);
                                                                                    yylhsminor.yy674 = addLimitClause(pCxt, yylhsminor.yy674, yymsp[0].minor.yy674);
                                                                                  }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 428: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy674 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-3].minor.yy674 = yylhsminor.yy674;
        break;
      case 429: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy674 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy674, yymsp[0].minor.yy674); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 431: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy674 = yymsp[-4].minor.yy674; }
  yy_destructor(yypParser,351,&yymsp[-3].minor);
  yy_destructor(yypParser,352,&yymsp[-2].minor);
  yy_destructor(yypParser,353,&yymsp[-1].minor);
        break;
      case 435: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 439: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==439);
{ yymsp[-1].minor.yy674 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 436: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 440: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==440);
{ yymsp[-3].minor.yy674 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 437: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 441: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==441);
{ yymsp[-3].minor.yy674 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 442: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy674 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy674); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 446: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy674 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy674), yymsp[-1].minor.yy610, yymsp[0].minor.yy107); }
  yymsp[-2].minor.yy674 = yylhsminor.yy674;
        break;
      case 447: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy610 = ORDER_ASC; }
        break;
      case 448: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy610 = ORDER_ASC; }
        break;
      case 449: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy610 = ORDER_DESC; }
        break;
      case 450: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy107 = NULL_ORDER_DEFAULT; }
        break;
      case 451: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy107 = NULL_ORDER_FIRST; }
        break;
      case 452: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy107 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
