/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 452
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy4;
  int64_t yy37;
  SAlterOption yy101;
  SNode* yy232;
  SDataType yy264;
  SNodeList* yy288;
  SToken yy481;
  int8_t yy607;
  EFillMode yy614;
  int32_t yy692;
  EJoinType yy700;
  bool yy777;
  ENullOrder yy833;
  EOrder yy866;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             701
#define YYNRULE              528
#define YYNTOKEN             319
#define YY_MAX_SHIFT         700
#define YY_MIN_SHIFTREDUCE   1036
#define YY_MAX_SHIFTREDUCE   1563
#define YY_ERROR_ACTION      1564
#define YY_ACCEPT_ACTION     1565
#define YY_NO_ACTION         1566
#define YY_MIN_REDUCE        1567
#define YY_MAX_REDUCE        2094
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3333)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   450,  167,  451, 1602,   77,  458, 1711,  451, 1602,  538,
 /*    10 */  1824,  552,   44,   42, 1759,  339,  338, 1892, 1069, 1821,
 /*    20 */   353, 1568, 1344,  154,  120,  552, 1896, 1716,  593, 1897,
 /*    30 */  1910,  488, 1722, 1424,  156, 1342,  593, 1892,   52, 1673,
 /*    40 */  1892, 1720,  110, 1888, 1894,  109,  108,  107,  106,  105,
 /*    50 */   104,  103,  102,  101,  590, 1720,  600, 1419, 1073, 1074,
 /*    60 */  1928, 1370,   17, 1888, 1894,  341, 1888, 1894,  607, 1350,
 /*    70 */    44,   42, 1494, 1878,  449,  606,  600,  453,  353,  600,
 /*    80 */  1344,  467,   37,   36,  132, 1772,   43,   41,   40,   39,
 /*    90 */    38, 1424, 1910, 1342, 1372,    1,  608,  157,  552, 1579,
 /*   100 */  1944, 1771, 1896,   46,   98,  352, 1911,  610, 1913, 1914,
 /*   110 */   605,  176,  600, 1892,   58, 1419,  552,  697, 1910, 1997,
 /*   120 */    17,  130, 1928,  317, 1993,  398, 1698, 1350, 1720,  120,
 /*   130 */   607, 1426, 1427,  635, 2065, 1878,  493,  606,   47, 1888,
 /*   140 */  1894,  347,  592,  169, 2005, 2006, 1720, 2010, 1928,  577,
 /*   150 */   171,  455,  600,    1, 2066,  579,  607, 1367, 1908,   77,
 /*   160 */  1590, 1878, 1944,  606,  313,  329,   97, 1909, 1911,  610,
 /*   170 */  1913, 1914,  605,  125,  600,  697, 1345,  129, 1343,  141,
 /*   180 */  1968, 1997, 1715, 1928, 1908,  346, 1993,  467, 1944, 1426,
 /*   190 */  1427,  572,  159, 1909, 1911,  610, 1913, 1914,  605,  435,
 /*   200 */   600, 1348, 1349, 1878, 1399, 1400, 1402, 1403, 1404, 1405,
 /*   210 */  1406, 1407, 1408, 1409,  602,  598, 1417, 1418, 1420, 1421,
 /*   220 */  1422, 1423, 1425, 1428,    3, 1565,  330, 1369,  328,  327,
 /*   230 */   571,  490,  222,  573, 1345,  492, 1343,  246,  457,  236,
 /*   240 */   237,  453,  174,  110,  580, 2086,  109,  108,  107,  106,
 /*   250 */   105,  104,  103,  102,  101,  186,  185,  491,  182, 1348,
 /*   260 */  1349,  174, 1399, 1400, 1402, 1403, 1404, 1405, 1406, 1407,
 /*   270 */  1408, 1409,  602,  598, 1417, 1418, 1420, 1421, 1422, 1423,
 /*   280 */  1425, 1428,    3,   44,   42,  174,  368, 1371,   79,  315,
 /*   290 */   643,  353,  542, 1344,  540,   74, 1696,  315,   73,  593,
 /*   300 */   542, 1910,  540,  534, 1424, 2070, 1342, 1195,  632,  631,
 /*   310 */   630, 1199,  629, 1201, 1202,  628, 1204,  625,  230, 1210,
 /*   320 */   622, 1212, 1213,  619,  616,   11,  358,    9, 1419, 1765,
 /*   330 */  1767, 1928, 2065,   17, 2065, 2012,   62, 1498,   87,  607,
 /*   340 */  1350,   44,   42, 1369, 1878, 1865,  606, 2071,  171,  353,
 /*   350 */  2069, 1344, 2066,  579, 2066, 2068,   58,  643,   81,  700,
 /*   360 */  1713,   58, 1424, 2009, 1342, 1520,    1,  608,  387,    7,
 /*   370 */  1086, 1944, 1085,  277,   46,  297,  352, 1911,  610, 1913,
 /*   380 */  1914,  605, 1567,  600, 1368,  207, 1419,  165,  697,  389,
 /*   390 */   385,   17,  375,  690,  686,  682,  678,  275, 1350, 1491,
 /*   400 */  1087, 1155, 1426, 1427,   11, 2065,  119,  118,  117,  116,
 /*   410 */   115,  114,  113,  112,  111,  565, 1518, 1519, 1521, 1522,
 /*   420 */   577,  171, 1772, 1350,    1, 2066,  579,   58, 1589,  322,
 /*   430 */   269,  504,  503,  502,   95, 1157, 1434,  243, 1770,  126,
 /*   440 */   498,  391, 1369,  390,  497,  496,  697, 1345,  655, 1343,
 /*   450 */   495,  501,  392, 1697, 1369, 1370,  494, 1814,   37,   36,
 /*   460 */  1426, 1427,   43,   41,   40,   39,   38,  578,  179,  534,
 /*   470 */   549, 1878, 1348, 1349, 1709, 1399, 1400, 1402, 1403, 1404,
 /*   480 */  1405, 1406, 1407, 1408, 1409,  602,  598, 1417, 1418, 1420,
 /*   490 */  1421, 1422, 1423, 1425, 1428,    3, 2065,   11, 2065, 1772,
 /*   500 */    34,  270,  232,  174, 1705, 1345,  340, 1343,  174, 1707,
 /*   510 */    94,  577,  171, 2071,  171, 1770, 2066,  579, 2066,  579,
 /*   520 */  1315,  174,  225,  229,  127, 1766, 1767, 1910, 1401,   58,
 /*   530 */  1348, 1349, 1712, 1399, 1400, 1402, 1403, 1404, 1405, 1406,
 /*   540 */  1407, 1408, 1409,  602,  598, 1417, 1418, 1420, 1421, 1422,
 /*   550 */  1423, 1425, 1428,    3,   44,   42, 2070, 1928,  500,  499,
 /*   560 */   641,  356,  353,   80, 1344,  607, 1237, 1238,  568,  154,
 /*   570 */  1878, 1487,  606, 1371,  174, 1424, 1814, 1342, 1722,  145,
 /*   580 */   144,  638,  637,  636,   37,   36, 1910,  180,   43,   41,
 /*   590 */    40,   39,   38, 1908,  554,  552, 1969, 1944, 1086, 1419,
 /*   600 */  1085,  158, 1909, 1911,  610, 1913, 1914,  605,  396,  600,
 /*   610 */  1772, 1350,   44,   42, 1429, 1455, 1928,  357, 1560,  518,
 /*   620 */   353,  336, 1344,  552,  607, 1720, 1770, 1401, 1087, 1878,
 /*   630 */  1703,  606,  516, 1424,  514, 1342,  397,    8, 1490,  235,
 /*   640 */    37,   36,  557, 2034,   43,   41,   40,   39,   38, 1553,
 /*   650 */   359,  226, 1908, 1720,  574,  569, 1944, 1419,  154,  697,
 /*   660 */   304, 1909, 1911,  610, 1913, 1914,  605, 1722,  600, 1350,
 /*   670 */   349,  348, 1530, 1426, 1427, 1344,  174,   37,   36,  552,
 /*   680 */  1358,   43,   41,   40,   39,   38,   31,  223, 1342,  552,
 /*   690 */  1750, 1424,  407, 1351,   30,    8, 1460, 2012, 1321, 1322,
 /*   700 */    37,   36,  421,  538,   43,   41,   40,   39,   38, 1720,
 /*   710 */  2012,  552,   26, 1822, 1559, 1419,  269,  697, 1345, 1720,
 /*   720 */  1343, 2069, 1350,   32,  422, 2008,  399, 1350, 1510,   37,
 /*   730 */    36, 1426, 1427,   43,   41,   40,   39,   38, 2007,  400,
 /*   740 */  2070, 1720,  128, 1348, 1349, 1968, 1399, 1400, 1402, 1403,
 /*   750 */  1404, 1405, 1406, 1407, 1408, 1409,  602,  598, 1417, 1418,
 /*   760 */  1420, 1421, 1422, 1423, 1425, 1428,    3,   13,   12, 2065,
 /*   770 */   697,   40,   39,   38,  601,  596, 1345,  641, 1343,   43,
 /*   780 */    41,   40,   39,   38,  174, 2069,  634,   37,   36, 2066,
 /*   790 */  2067,   43,   41,   40,   39,   38,  145,  144,  638,  637,
 /*   800 */   636, 1348, 1349,  143, 1399, 1400, 1402, 1403, 1404, 1405,
 /*   810 */  1406, 1407, 1408, 1409,  602,  598, 1417, 1418, 1420, 1421,
 /*   820 */  1422, 1423, 1425, 1428,    3,   44,   42,  492,  552, 1345,
 /*   830 */  1820, 1343,  308,  353, 1359, 1344, 1354,  585,  556,  552,
 /*   840 */  1969,  465,  668,  666,  529, 1588, 1424, 1587, 1342,  491,
 /*   850 */   552,  537,  466, 1814, 1348, 1349,   51, 1910, 1720, 1362,
 /*   860 */  1364, 1369, 1467, 1717,  184, 1073, 1074, 1586,  534, 1720,
 /*   870 */  1419, 1585, 1674,  598, 1417, 1418, 1420, 1421, 1422, 1423,
 /*   880 */  1720,  552, 1350,   44,   42,  552,  552, 1928, 1878, 1580,
 /*   890 */  1878,  353,  366, 1344,  137,  607, 1634, 2065,  530,  535,
 /*   900 */  1878,  656,  606, 1690, 1424, 1584, 1342,  406,    8,  534,
 /*   910 */  1878, 1720, 2071,  171, 1878, 1720, 1720, 2066,  579, 1621,
 /*   920 */  1819, 1583,  308, 1908, 1582, 2017, 1487, 1944, 1419, 1581,
 /*   930 */   697,   98, 1909, 1911,  610, 1913, 1914,  605, 2065,  600,
 /*   940 */  1350,  505,  153, 1578, 1426, 1427, 1997, 1577, 1878, 1614,
 /*   950 */  1996, 1993,  552, 2071,  171,   72, 1576,  552, 2066,  579,
 /*   960 */   504,  503,  502,   45, 1878,  240,    1, 1878,  126,  498,
 /*   970 */   360,  507, 1878,  497,  496,  639, 2037,  581, 1763,  495,
 /*   980 */   501,  206, 1720, 1372,  208,  494, 1878, 1720,  697, 1345,
 /*   990 */  1878, 1343,  365, 1695,  522,  582, 1575,  264,  161, 1878,
 /*  1000 */  1574, 1573, 1426, 1427,  484,  480,  476,  472,  205,  534,
 /*  1010 */   640,  534,  234, 1763, 1348, 1349, 1292, 1399, 1400, 1402,
 /*  1020 */  1403, 1404, 1405, 1406, 1407, 1408, 1409,  602,  598, 1417,
 /*  1030 */  1418, 1420, 1421, 1422, 1423, 1425, 1428,    3, 2065, 1878,
 /*  1040 */  2065,  154,  566, 1878, 1878,   78, 1401, 1345,  203, 1343,
 /*  1050 */  1723,   48,    4, 2071,  171, 2071,  171,  586, 2066,  579,
 /*  1060 */  2066,  579,   37,   36, 1572,  238,   43,   41,   40,   39,
 /*  1070 */    38, 1571, 1348, 1349, 1631, 1399, 1400, 1402, 1403, 1404,
 /*  1080 */  1405, 1406, 1407, 1408, 1409,  602,  598, 1417, 1418, 1420,
 /*  1090 */  1421, 1422, 1423, 1425, 1428,    3,  312, 1801, 1367,  282,
 /*  1100 */   641,  590, 1750,   50,  533,  429,  590, 1878,  440,  213,
 /*  1110 */   202,  196,  211,  201, 1878,  215,  138,  463,  214,  145,
 /*  1120 */   144,  638,  637,  636, 1570,  413,  245,  441,  142,  217,
 /*  1130 */   415,  132,  216,  194,  219,  143,  132,  218,  674,  673,
 /*  1140 */   672,  671,  363,  258,  670,  669,  133,  664,  663,  662,
 /*  1150 */   661,  660,  659,  658,  657,  147,  653,  652,  651,  362,
 /*  1160 */   361,  648,  647,  646,  645,  644,  155, 1878,  130,  545,
 /*  1170 */   552,  288,  325,  130,  597, 1562, 1563,   13,   12,   60,
 /*  1180 */  1353,  242, 2070,  548,  402,  286,   66, 1612, 1188,   65,
 /*  1190 */   170, 2005, 2006, 1608, 2010,  172, 2005, 2006,  250, 2010,
 /*  1200 */  1720,   60, 1929,   45,  364,   45,  190,  446,  444,  510,
 /*  1210 */   614,  142,  439,  583, 1910,  434,  433,  432,  431,  428,
 /*  1220 */   427,  426,  425,  424,  420,  419,  418,  417,  326,  410,
 /*  1230 */   409,  408, 1517,  404,  403,  324, 1352, 1603, 1899, 1760,
 /*  1240 */   552,  692,  552,   58, 1928,  143,  416,  552, 2027,  122,
 /*  1250 */   591,  253,  594,  550, 1461,  551, 1410, 1878,  281,  606,
 /*  1260 */   271,   37,   36, 1216, 1220,   43,   41,   40,   39,   38,
 /*  1270 */  1720,  509, 1720,   93,  266, 1553,  590, 1720,  263,    2,
 /*  1280 */  1908,   96,  578,   90, 1944,    5,  519, 1901,   97, 1909,
 /*  1290 */  1911,  610, 1913, 1914,  605, 1115,  600,  142, 1227,  369,
 /*  1300 */   221,  168, 1225, 1997,  374,  323,  132,  346, 1993, 1308,
 /*  1310 */   278, 2065,  649, 1445,  512,  318,   71,   70,  395,  506,
 /*  1320 */   173,  178,  183, 1356,  220, 1910,  577,  171, 2023, 1116,
 /*  1330 */   650, 2066,  579,  401, 1135,  437,  405,  411, 1367,  311,
 /*  1340 */   430,  423,  383,  121,  381,  377,  373,  370,  367, 1816,
 /*  1350 */   146, 1910, 1133,  436,  438, 1928,  442, 1453,  443, 1373,
 /*  1360 */   448,   64,  187,  594,   63,  267, 2005,  589, 1878,  588,
 /*  1370 */   606,  456, 2065,  445, 1375,  447,  459,  193, 1374, 1355,
 /*  1380 */   460, 1928, 1376,  195,  461,  462,  198,  577,  171,  607,
 /*  1390 */   174, 1908, 2066,  579, 1878, 1944,  606,  464,  200,   97,
 /*  1400 */  1909, 1911,  610, 1913, 1914,  605,   75,  600, 1089,  468,
 /*  1410 */    76, 1454,  168,  485, 1997,  204,  486, 1908,  346, 1993,
 /*  1420 */   487, 1944,  489,   99, 1710,   97, 1909, 1911,  610, 1913,
 /*  1430 */  1914,  605,  314,  600,  210, 1706,  521,  523, 2085, 2024,
 /*  1440 */  1997,  212,  148,  149,  346, 1993, 1708, 1704,  279,  224,
 /*  1450 */   150,  151, 1855,  524, 2031,  528,  227,  531,  536,  231,
 /*  1460 */   564,  525,  546, 1910,   84,  335,  539, 1854, 1826,  543,
 /*  1470 */   280,  337,   86, 1721, 1372,  139,  560,  567, 2043,  562,
 /*  1480 */   140, 2042,   33,  350, 1448, 1449, 1450, 1451, 1452, 1456,
 /*  1490 */  1457, 1458, 1459, 1928,  547,  248,    6,  563,  342,  252,
 /*  1500 */  2019,  607, 2028,  570, 2038,  576, 1878,  561,  606,  559,
 /*  1510 */   558,  257,  343,  587, 2064, 2088,  584, 1487, 1371,  262,
 /*  1520 */    57,  131,   88, 1691, 2013,  612,  283,  274, 1764, 1908,
 /*  1530 */  1910,  693,  694, 1944,  696,   49,  295,   97, 1909, 1911,
 /*  1540 */   610, 1913, 1914,  605,  307,  600,  306,  162,  259,  260,
 /*  1550 */  2085, 1978, 1997,  285,  261,  305,  346, 1993,  287, 1872,
 /*  1560 */  1928, 1871,  265,   68, 1870, 1869, 2059,   69,  607,  371,
 /*  1570 */   372, 1336, 1337, 1878, 1866,  606,  177,  376, 1864,  378,
 /*  1580 */   379,  380, 1863,  382, 1910, 1862,  384, 1861,  386, 1860,
 /*  1590 */   388, 1311, 1310, 1837, 1836,  393, 1908,  394, 1835, 1834,
 /*  1600 */  1944, 1809, 1280, 1808,   97, 1909, 1911,  610, 1913, 1914,
 /*  1610 */   605, 1806,  600,  134, 1928, 1805, 1804, 2085, 1807, 1997,
 /*  1620 */   181,  135,  607,  346, 1993, 1803, 1802, 1878, 1800,  606,
 /*  1630 */  1799, 1798,  412, 2016, 1797,  414, 1796, 1795, 1910, 1794,
 /*  1640 */  1793, 1792, 1791, 1790, 1789, 1788, 1787, 1786, 1785, 1784,
 /*  1650 */  1908, 1783, 1782, 1781, 1944,  136, 1780, 1779,   97, 1909,
 /*  1660 */  1911,  610, 1913, 1914,  605, 1778,  600, 1777, 1928, 1776,
 /*  1670 */  1775, 1972, 1282, 1997,  188, 1635,  607,  346, 1993, 1774,
 /*  1680 */  1773, 1878, 1636,  606,  189, 1633, 1599, 1076, 1598, 1163,
 /*  1690 */  1075, 1910, 1108,  199, 1832, 1818, 1699,  191,  123, 1850,
 /*  1700 */  1844,  166,  192,  124, 1908, 1833,  452,  454, 1944, 1632,
 /*  1710 */   197, 1630,   97, 1909, 1911,  610, 1913, 1914,  605,  469,
 /*  1720 */   600, 1928,  471, 1628,  470, 1970,  473, 1997,  474,  607,
 /*  1730 */  1626,  346, 1993, 1624, 1878, 1611,  606,  475,  477,  481,
 /*  1740 */   478,  479, 1610, 1595, 1910,  483, 1701, 1231,  482, 1230,
 /*  1750 */  1700, 1154, 1153, 1152, 1151, 1150,  665, 1908,  667, 1147,
 /*  1760 */  1146, 1944, 1145, 1144, 1622,   97, 1909, 1911,  610, 1913,
 /*  1770 */  1914,  605,   59,  600, 1928,  331, 1615,  332,  555, 1613,
 /*  1780 */  1997,  508,  607,  333,  346, 1993,  511, 1878, 1594,  606,
 /*  1790 */  1593,  209,  513,  515, 1592,  517, 1849,  100,   53, 1843,
 /*  1800 */  1317,  152,  526, 1328, 1831, 1910, 1829, 1830, 2070,   25,
 /*  1810 */  1908, 1828, 1827,   18, 1944, 1825, 1326,  233,   98, 1909,
 /*  1820 */  1911,  610, 1913, 1914,  605, 1817,  600, 1325,  532, 1910,
 /*  1830 */    83,  239,  228, 1997,   82, 1928,   85,  595, 1993,   90,
 /*  1840 */    19,  527,   15,  604,  244,   20,  241,   27, 1878, 1436,
 /*  1850 */   606,   56, 1532,  334,  541,  247,  255, 1435,  544, 1928,
 /*  1860 */    10,   29,  249, 1514,  251,  256, 1516,  607, 1509,  160,
 /*  1870 */  1899, 1908, 1878,  254,  606, 1944,   61,   28,   89,  303,
 /*  1880 */  1909, 1911,  610, 1913, 1914,  605,  603,  600,  553, 1962,
 /*  1890 */    22, 1910, 1547, 1546,  344, 1908, 1552, 1553, 1551, 1944,
 /*  1900 */  1550,  345,  268,   98, 1909, 1911,  610, 1913, 1914,  605,
 /*  1910 */  1484,  600, 1483,   55, 1898,  163,   12, 1360, 1997, 1414,
 /*  1920 */   164, 1928, 1947, 1994,  599,  175,   35, 1446, 1412,  604,
 /*  1930 */  1411,   14,   23, 1392, 1878, 1384,  606,   24,  613,  611,
 /*  1940 */   609, 1217, 1910,  355,  615,  617, 1214,  618,  620, 1211,
 /*  1950 */   621,  623,  626, 1194,   21,  624,   16, 1908, 1205, 1209,
 /*  1960 */  1203, 1944,   54, 1208, 1226,  303, 1909, 1911,  610, 1913,
 /*  1970 */  1914,  605, 1928,  600, 1222, 1963,  272,  627,   91,  633,
 /*  1980 */   607,   92,   67, 1106,  642, 1878, 1207,  606, 1141, 1140,
 /*  1990 */  1206, 1139, 1138, 1137, 1136, 1134, 1910, 1132, 1131, 1130,
 /*  2000 */  1128, 1161, 1127, 1126,  654, 1125, 1124, 1123, 1908,  273,
 /*  2010 */  1122, 1121, 1944, 1158, 1910, 1156,  158, 1909, 1911,  610,
 /*  2020 */  1913, 1914,  605, 1118,  600, 1117, 1928, 1114, 1113, 1112,
 /*  2030 */  1111, 1629,  675,  677,  607, 1627,  676,  679,  680, 1878,
 /*  2040 */   681,  606, 1625,  683, 1928,  684, 1623,  687,  685,  689,
 /*  2050 */   688, 1609,  607,  691, 1066, 1591,  276, 1878, 2035,  606,
 /*  2060 */   695, 1566, 1908, 1346,  699,  284, 1944, 1566,  698, 1566,
 /*  2070 */   299, 1909, 1911,  610, 1913, 1914,  605, 1566,  600, 1566,
 /*  2080 */  1908, 1566, 1566, 1566, 1944, 1566, 1566, 1566,  159, 1909,
 /*  2090 */  1911,  610, 1913, 1914,  605, 1566,  600, 1910, 1566, 1566,
 /*  2100 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2110 */  1566, 1566, 1566, 1566,  575, 1566, 1566, 1566, 1566, 1566,
 /*  2120 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1928, 1566, 1566,
 /*  2130 */  1566, 1566,  351, 1566, 1566,  607, 1566, 1566, 1566, 1566,
 /*  2140 */  1878, 2087,  606, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2150 */  1566, 1566, 1910, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2160 */  1566, 1566, 1566, 1908, 1566, 1566, 1566, 1944, 1566, 1566,
 /*  2170 */  1566,  304, 1909, 1911,  610, 1913, 1914,  605, 1566,  600,
 /*  2180 */  1566, 1566, 1928, 1566, 1566, 1566, 1566,  354, 1566, 1566,
 /*  2190 */   607, 1566, 1566, 1566, 1566, 1878, 1566,  606, 1566, 1566,
 /*  2200 */  1566, 1566, 1566, 1910, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2210 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1908, 1566,
 /*  2220 */  1566, 1566, 1944, 1566, 1566, 1566,  304, 1909, 1911,  610,
 /*  2230 */  1913, 1914,  605, 1928,  600, 1566, 1566, 1566, 1566, 1566,
 /*  2240 */  1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,  606, 1566,
 /*  2250 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1910, 1566, 1566,
 /*  2260 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,  520,
 /*  2270 */  1566, 1566, 1566, 1944, 1566, 1566, 1566,  297, 1909, 1911,
 /*  2280 */   610, 1913, 1914,  605, 1566,  600, 1566, 1928, 1566, 1566,
 /*  2290 */  1566, 1566, 1566, 1566, 1566,  607, 1566, 1566, 1566, 1566,
 /*  2300 */  1878, 1566,  606, 1566, 1566, 1566, 1566, 1566, 1910, 1566,
 /*  2310 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2320 */  1566, 1566, 1566, 1908, 1566, 1566, 1566, 1944, 1566, 1566,
 /*  2330 */  1566,  289, 1909, 1911,  610, 1913, 1914,  605, 1928,  600,
 /*  2340 */  1566, 1566, 1566, 1566, 1566, 1566,  607, 1566, 1566, 1566,
 /*  2350 */  1566, 1878, 1566,  606, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2360 */  1566, 1566, 1910, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2370 */  1566, 1566, 1566, 1566, 1908, 1566, 1566, 1566, 1944, 1566,
 /*  2380 */  1910, 1566,  290, 1909, 1911,  610, 1913, 1914,  605, 1566,
 /*  2390 */   600, 1566, 1928, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2400 */   607, 1566, 1566, 1566, 1566, 1878, 1566,  606, 1566, 1566,
 /*  2410 */  1928, 1566, 1566, 1566, 1566, 1566, 1566, 1566,  607, 1566,
 /*  2420 */  1566, 1566, 1566, 1878, 1566,  606, 1566, 1566, 1908, 1566,
 /*  2430 */  1566, 1566, 1944, 1566, 1566, 1566,  291, 1909, 1911,  610,
 /*  2440 */  1913, 1914,  605, 1566,  600, 1566, 1908, 1566, 1566, 1566,
 /*  2450 */  1944, 1566, 1566, 1566,  298, 1909, 1911,  610, 1913, 1914,
 /*  2460 */   605, 1566,  600, 1910, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2470 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2480 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2490 */  1566, 1566, 1566, 1928, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2500 */  1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,  606, 1566,
 /*  2510 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1910, 1566,
 /*  2520 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1908,
 /*  2530 */  1566, 1566, 1566, 1944, 1566, 1566, 1566,  300, 1909, 1911,
 /*  2540 */   610, 1913, 1914,  605, 1566,  600, 1566, 1566, 1928, 1566,
 /*  2550 */  1566, 1566, 1566, 1566, 1566, 1566,  607, 1566, 1566, 1566,
 /*  2560 */  1566, 1878, 1566,  606, 1566, 1566, 1566, 1566, 1566, 1910,
 /*  2570 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2580 */  1566, 1566, 1566, 1566, 1908, 1566, 1566, 1566, 1944, 1566,
 /*  2590 */  1566, 1566,  292, 1909, 1911,  610, 1913, 1914,  605, 1928,
 /*  2600 */   600, 1566, 1566, 1566, 1566, 1566, 1566,  607, 1566, 1566,
 /*  2610 */  1566, 1566, 1878, 1566,  606, 1566, 1566, 1566, 1566, 1566,
 /*  2620 */  1566, 1566, 1566, 1910, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2630 */  1566, 1566, 1566, 1566, 1566, 1908, 1566, 1566, 1566, 1944,
 /*  2640 */  1566, 1566, 1566,  301, 1909, 1911,  610, 1913, 1914,  605,
 /*  2650 */  1566,  600, 1566, 1928, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2660 */  1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,  606, 1566,
 /*  2670 */  1566, 1566, 1566, 1566, 1910, 1566, 1566, 1566, 1566, 1566,
 /*  2680 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1908,
 /*  2690 */  1566, 1566, 1566, 1944, 1566, 1566, 1566,  293, 1909, 1911,
 /*  2700 */   610, 1913, 1914,  605, 1928,  600, 1566, 1566, 1566, 1566,
 /*  2710 */  1566, 1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,  606,
 /*  2720 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1910, 1566,
 /*  2730 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2740 */  1908, 1566, 1566, 1566, 1944, 1566, 1910, 1566,  302, 1909,
 /*  2750 */  1911,  610, 1913, 1914,  605, 1566,  600, 1566, 1928, 1566,
 /*  2760 */  1566, 1566, 1566, 1566, 1566, 1566,  607, 1566, 1566, 1566,
 /*  2770 */  1566, 1878, 1566,  606, 1566, 1566, 1928, 1566, 1566, 1566,
 /*  2780 */  1566, 1566, 1566, 1566,  607, 1566, 1566, 1566, 1566, 1878,
 /*  2790 */  1566,  606, 1566, 1566, 1908, 1566, 1566, 1566, 1944, 1566,
 /*  2800 */  1566, 1566,  294, 1909, 1911,  610, 1913, 1914,  605, 1566,
 /*  2810 */   600, 1566, 1908, 1566, 1566, 1566, 1944, 1566, 1566, 1566,
 /*  2820 */   309, 1909, 1911,  610, 1913, 1914,  605, 1566,  600, 1910,
 /*  2830 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2840 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2850 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1928,
 /*  2860 */  1566, 1566, 1566, 1566, 1566, 1566, 1566,  607, 1566, 1566,
 /*  2870 */  1566, 1566, 1878, 1566,  606, 1566, 1566, 1566, 1566, 1566,
 /*  2880 */  1566, 1566, 1566, 1566, 1910, 1566, 1566, 1566, 1566, 1566,
 /*  2890 */  1566, 1566, 1566, 1566, 1566, 1908, 1566, 1566, 1566, 1944,
 /*  2900 */  1566, 1566, 1566,  310, 1909, 1911,  610, 1913, 1914,  605,
 /*  2910 */  1566,  600, 1566, 1566, 1928, 1566, 1566, 1566, 1566, 1566,
 /*  2920 */  1566, 1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,  606,
 /*  2930 */  1566, 1566, 1566, 1566, 1566, 1910, 1566, 1566, 1566, 1566,
 /*  2940 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  2950 */  1908, 1566, 1566, 1566, 1944, 1566, 1566, 1566, 1922, 1909,
 /*  2960 */  1911,  610, 1913, 1914,  605, 1928,  600, 1566, 1566, 1566,
 /*  2970 */  1566, 1566, 1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,
 /*  2980 */   606, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1910,
 /*  2990 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3000 */  1566, 1908, 1566, 1566, 1566, 1944, 1566, 1566, 1566, 1921,
 /*  3010 */  1909, 1911,  610, 1913, 1914,  605, 1566,  600, 1566, 1928,
 /*  3020 */  1566, 1566, 1566, 1566, 1566, 1566, 1566,  607, 1566, 1566,
 /*  3030 */  1566, 1566, 1878, 1566,  606, 1566, 1566, 1566, 1566, 1566,
 /*  3040 */  1910, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3050 */  1566, 1566, 1566, 1566, 1566, 1908, 1566, 1566, 1566, 1944,
 /*  3060 */  1566, 1566, 1566, 1920, 1909, 1911,  610, 1913, 1914,  605,
 /*  3070 */  1928,  600, 1566, 1566, 1566, 1566, 1566, 1566,  607, 1566,
 /*  3080 */  1566, 1566, 1566, 1878, 1566,  606, 1566, 1566, 1566, 1566,
 /*  3090 */  1566, 1566, 1566, 1566, 1910, 1566, 1566, 1566, 1566, 1566,
 /*  3100 */  1566, 1566, 1566, 1566, 1566, 1566, 1908, 1566, 1566, 1566,
 /*  3110 */  1944, 1566, 1910, 1566,  319, 1909, 1911,  610, 1913, 1914,
 /*  3120 */   605, 1566,  600, 1566, 1928, 1566, 1566, 1566, 1566, 1566,
 /*  3130 */  1566, 1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,  606,
 /*  3140 */  1566, 1566, 1928, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3150 */   607, 1566, 1566, 1566, 1566, 1878, 1566,  606, 1566, 1566,
 /*  3160 */  1908, 1566, 1566, 1566, 1944, 1566, 1566, 1566,  320, 1909,
 /*  3170 */  1911,  610, 1913, 1914,  605, 1566,  600, 1566, 1908, 1566,
 /*  3180 */  1566, 1566, 1944, 1566, 1566, 1566,  316, 1909, 1911,  610,
 /*  3190 */  1913, 1914,  605, 1566,  600, 1910, 1566, 1566, 1566, 1566,
 /*  3200 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3210 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3220 */  1566, 1566, 1566, 1566, 1566, 1928, 1566, 1566, 1566, 1566,
 /*  3230 */  1566, 1566, 1566,  607, 1566, 1566, 1566, 1566, 1878, 1566,
 /*  3240 */   606, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3250 */  1910, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3260 */  1566, 1908, 1566, 1566, 1566, 1944, 1566, 1566, 1566,  321,
 /*  3270 */  1909, 1911,  610, 1913, 1914,  605, 1566,  600, 1566, 1566,
 /*  3280 */  1928, 1566, 1566, 1566, 1566, 1566, 1566, 1566,  607, 1566,
 /*  3290 */  1566, 1566, 1566, 1878, 1566,  606, 1566, 1566, 1566, 1566,
 /*  3300 */  1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566, 1566,
 /*  3310 */  1566, 1566, 1566, 1566, 1566, 1566, 1908, 1566, 1566, 1566,
 /*  3320 */  1944, 1566, 1566, 1566,  296, 1909, 1911,  610, 1913, 1914,
 /*  3330 */   605, 1566,  600,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   326,  351,  328,  329,  335,  326,  354,  328,  329,  367,
 /*    10 */     0,  330,   12,   13,  364,  344,  374,  365,    4,  377,
 /*    20 */    20,    0,   22,  352,  343,  330,  354,  358,   20,  354,
 /*    30 */   322,  350,  361,   33,  336,   35,   20,  365,  343,  341,
 /*    40 */   365,  360,   21,  391,  392,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  330,  360,  404,   57,   44,   45,
 /*    60 */   352,   20,   62,  391,  392,  393,  391,  392,  360,   69,
 /*    70 */    12,   13,   14,  365,  327,  367,  404,  330,   20,  404,
 /*    80 */    22,   61,    8,    9,  360,  352,   12,   13,   14,   15,
 /*    90 */    16,   33,  322,   35,   20,   95,  388,  321,  330,  323,
 /*   100 */   392,  368,  354,   95,  396,  397,  398,  399,  400,  401,
 /*   110 */   402,  343,  404,  365,   95,   57,  330,  117,  322,  411,
 /*   120 */    62,  397,  352,  415,  416,  330,    0,   69,  360,  343,
 /*   130 */   360,  131,  132,  106,  426,  365,  350,  367,   95,  391,
 /*   140 */   392,  393,  418,  419,  420,  421,  360,  423,  352,  441,
 /*   150 */   442,   14,  404,   95,  446,  447,  360,   20,  388,  335,
 /*   160 */   322,  365,  392,  367,  369,   37,  396,  397,  398,  399,
 /*   170 */   400,  401,  402,  349,  404,  117,  176,  407,  178,  409,
 /*   180 */   410,  411,  358,  352,  388,  415,  416,   61,  392,  131,
 /*   190 */   132,  360,  396,  397,  398,  399,  400,  401,  402,   79,
 /*   200 */   404,  201,  202,  365,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  319,   98,   20,  100,  101,
 /*   230 */   399,  103,  127,   20,  176,  107,  178,  163,  327,  126,
 /*   240 */   127,  330,  242,   21,  448,  449,   24,   25,   26,   27,
 /*   250 */    28,   29,   30,   31,   32,  135,  136,  129,   57,  201,
 /*   260 */   202,  242,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   270 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   280 */   222,  223,  224,   12,   13,  242,  380,   20,  183,  184,
 /*   290 */    61,   20,  187,   22,  189,   94,    0,  184,   97,   20,
 /*   300 */   187,  322,  189,  397,   33,  397,   35,  108,  109,  110,
 /*   310 */   111,  112,  113,  114,  115,  116,  117,  118,   57,  120,
 /*   320 */   121,  122,  123,  124,  125,  226,  363,  228,   57,  366,
 /*   330 */   367,  352,  426,   62,  426,  394,    4,   14,  333,  360,
 /*   340 */    69,   12,   13,   20,  365,    0,  367,  441,  442,   20,
 /*   350 */   442,   22,  446,  447,  446,  447,   95,   61,   97,   19,
 /*   360 */   355,   95,   33,  422,   35,  201,   95,  388,  171,   39,
 /*   370 */    20,  392,   22,   33,   95,  396,  397,  398,  399,  400,
 /*   380 */   401,  402,    0,  404,   20,   35,   57,   47,  117,  192,
 /*   390 */   193,   62,   47,   53,   54,   55,   56,   57,   69,    4,
 /*   400 */    50,   35,  131,  132,  226,  426,   24,   25,   26,   27,
 /*   410 */    28,   29,   30,   31,   32,  251,  252,  253,  254,  255,
 /*   420 */   441,  442,  352,   69,   95,  446,  447,   95,  322,  359,
 /*   430 */   163,   64,   65,   66,   94,   69,   14,   97,  368,   72,
 /*   440 */    73,  175,   20,  177,   77,   78,  117,  176,   69,  178,
 /*   450 */    83,   84,  380,    0,   20,   20,   89,  360,    8,    9,
 /*   460 */   131,  132,   12,   13,   14,   15,   16,  397,  371,  397,
 /*   470 */   130,  365,  201,  202,  353,  204,  205,  206,  207,  208,
 /*   480 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   490 */   219,  220,  221,  222,  223,  224,  426,  226,  426,  352,
 /*   500 */   412,  413,  162,  242,  353,  176,  359,  178,  242,  353,
 /*   510 */   333,  441,  442,  441,  442,  368,  446,  447,  446,  447,
 /*   520 */   180,  242,  182,   57,  347,  366,  367,  322,  205,   95,
 /*   530 */   201,  202,  355,  204,  205,  206,  207,  208,  209,  210,
 /*   540 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   550 */   221,  222,  223,  224,   12,   13,    3,  352,  338,  339,
 /*   560 */   107,  344,   20,   97,   22,  360,  131,  132,  161,  352,
 /*   570 */   365,  241,  367,   20,  242,   33,  360,   35,  361,  126,
 /*   580 */   127,  128,  129,  130,    8,    9,  322,  371,   12,   13,
 /*   590 */    14,   15,   16,  388,  408,  330,  410,  392,   20,   57,
 /*   600 */    22,  396,  397,  398,  399,  400,  401,  402,  343,  404,
 /*   610 */   352,   69,   12,   13,   14,  158,  352,  359,  168,   21,
 /*   620 */    20,  357,   22,  330,  360,  360,  368,  205,   50,  365,
 /*   630 */   353,  367,   34,   33,   36,   35,  343,   95,  243,  126,
 /*   640 */     8,    9,  437,  438,   12,   13,   14,   15,   16,   96,
 /*   650 */   344,  353,  388,  360,  247,  248,  392,   57,  352,  117,
 /*   660 */   396,  397,  398,  399,  400,  401,  402,  361,  404,   69,
 /*   670 */    12,   13,   96,  131,  132,   22,  242,    8,    9,  330,
 /*   680 */    22,   12,   13,   14,   15,   16,  229,  345,   35,  330,
 /*   690 */   348,   33,  343,   35,    2,   95,  239,  394,  185,  186,
 /*   700 */     8,    9,  343,  367,   12,   13,   14,   15,   16,  360,
 /*   710 */   394,  330,   43,  377,  264,   57,  163,  117,  176,  360,
 /*   720 */   178,    3,   69,    2,  343,  422,   22,   69,   96,    8,
 /*   730 */     9,  131,  132,   12,   13,   14,   15,   16,  422,   35,
 /*   740 */   397,  360,  407,  201,  202,  410,  204,  205,  206,  207,
 /*   750 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   760 */   218,  219,  220,  221,  222,  223,  224,    1,    2,  426,
 /*   770 */   117,   14,   15,   16,  353,  117,  176,  107,  178,   12,
 /*   780 */    13,   14,   15,   16,  242,  442,  353,    8,    9,  446,
 /*   790 */   447,   12,   13,   14,   15,   16,  126,  127,  128,  129,
 /*   800 */   130,  201,  202,   43,  204,  205,  206,  207,  208,  209,
 /*   810 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   820 */   220,  221,  222,  223,  224,   12,   13,  107,  330,  176,
 /*   830 */   376,  178,  378,   20,  176,   22,  178,   43,  408,  330,
 /*   840 */   410,  343,  338,  339,  384,  322,   33,  322,   35,  129,
 /*   850 */   330,  380,  343,  360,  201,  202,   96,  322,  360,  201,
 /*   860 */   202,   20,   96,  343,  371,   44,   45,  322,  397,  360,
 /*   870 */    57,  322,  341,  215,  216,  217,  218,  219,  220,  221,
 /*   880 */   360,  330,   69,   12,   13,  330,  330,  352,  365,  323,
 /*   890 */   365,   20,  380,   22,  343,  360,    0,  426,  343,  343,
 /*   900 */   365,  340,  367,  342,   33,  322,   35,  106,   95,  397,
 /*   910 */   365,  360,  441,  442,  365,  360,  360,  446,  447,    0,
 /*   920 */   376,  322,  378,  388,  322,  240,  241,  392,   57,  322,
 /*   930 */   117,  396,  397,  398,  399,  400,  401,  402,  426,  404,
 /*   940 */    69,   22,  163,  322,  131,  132,  411,  322,  365,    0,
 /*   950 */   415,  416,  330,  441,  442,  154,  322,  330,  446,  447,
 /*   960 */    64,   65,   66,   43,  365,  343,   95,  365,   72,   73,
 /*   970 */   343,   22,  365,   77,   78,  362,  395,  259,  365,   83,
 /*   980 */    84,  331,  360,   20,   33,   89,  365,  360,  117,  176,
 /*   990 */   365,  178,  380,    0,  380,   43,  322,  450,   47,  365,
 /*  1000 */   322,  322,  131,  132,   53,   54,   55,   56,   57,  397,
 /*  1010 */   362,  397,   43,  365,  201,  202,   96,  204,  205,  206,
 /*  1020 */   207,  208,  209,  210,  211,  212,  213,  214,  215,  216,
 /*  1030 */   217,  218,  219,  220,  221,  222,  223,  224,  426,  365,
 /*  1040 */   426,  352,  439,  365,  365,   94,  205,  176,   97,  178,
 /*  1050 */   361,   42,   43,  441,  442,  441,  442,  263,  446,  447,
 /*  1060 */   446,  447,    8,    9,  322,   96,   12,   13,   14,   15,
 /*  1070 */    16,  322,  201,  202,    0,  204,  205,  206,  207,  208,
 /*  1080 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*  1090 */   219,  220,  221,  222,  223,  224,   18,    0,   20,  345,
 /*  1100 */   107,  330,  348,  163,  164,   27,  330,  365,   30,   99,
 /*  1110 */   159,  160,  102,  162,  365,   99,   43,  166,  102,  126,
 /*  1120 */   127,  128,  129,  130,  322,   47,  163,   49,   43,   99,
 /*  1130 */    52,  360,  102,  182,   99,   43,  360,  102,   64,   65,
 /*  1140 */    66,   67,   68,  433,   70,   71,   72,   73,   74,   75,
 /*  1150 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*  1160 */    86,   87,   88,   89,   90,   91,   18,  365,  397,   96,
 /*  1170 */   330,   23,   94,  397,   62,  131,  132,    1,    2,   43,
 /*  1180 */    35,   96,    3,  343,  106,   37,   38,    0,   96,   41,
 /*  1190 */   419,  420,  421,    0,  423,  419,  420,  421,   43,  423,
 /*  1200 */   360,   43,  352,   43,  331,   43,   58,   59,   60,   22,
 /*  1210 */    43,   43,  134,  261,  322,  137,  138,  139,  140,  141,
 /*  1220 */   142,  143,  144,  145,  146,  147,  148,  149,  150,  151,
 /*  1230 */   152,  153,   96,  155,  156,  157,   35,  329,   46,  364,
 /*  1240 */   330,   48,  330,   95,  352,   43,  149,  330,  395,   43,
 /*  1250 */   424,   96,  360,  343,   96,  343,   96,  365,   96,  367,
 /*  1260 */   343,    8,    9,   96,   96,   12,   13,   14,   15,   16,
 /*  1270 */   360,    4,  360,   95,  443,   96,  330,  360,  417,  427,
 /*  1280 */   388,  133,  397,  105,  392,  244,   19,   95,  396,  397,
 /*  1290 */   398,  399,  400,  401,  402,   35,  404,   43,   96,  390,
 /*  1300 */    33,  409,   96,  411,   47,  389,  360,  415,  416,  174,
 /*  1310 */   382,  426,   13,  201,   47,   62,  168,  169,  170,   52,
 /*  1320 */   428,  173,   42,  178,   57,  322,  441,  442,  436,   69,
 /*  1330 */    13,  446,  447,  372,   35,  158,  372,  370,   20,  191,
 /*  1340 */   372,  330,  194,  397,  196,  197,  198,  199,  200,  330,
 /*  1350 */    96,  322,   35,  370,  370,  352,   93,  104,  337,   20,
 /*  1360 */   324,   94,  330,  360,   97,  419,  420,  421,  365,  423,
 /*  1370 */   367,  324,  426,  330,   20,  330,  386,  335,   20,  178,
 /*  1380 */   367,  352,   20,  335,  379,  381,  335,  441,  442,  360,
 /*  1390 */   242,  388,  446,  447,  365,  392,  367,  379,  335,  396,
 /*  1400 */   397,  398,  399,  400,  401,  402,  335,  404,   51,  330,
 /*  1410 */   335,  158,  409,  332,  411,  335,  332,  388,  415,  416,
 /*  1420 */   324,  392,  352,  330,  352,  396,  397,  398,  399,  400,
 /*  1430 */   401,  402,  324,  404,  352,  352,  190,  387,  409,  436,
 /*  1440 */   411,  352,  352,  352,  415,  416,  352,  352,  386,  333,
 /*  1450 */   352,  352,  365,  181,  425,  367,  333,  330,  330,  333,
 /*  1460 */   249,  385,  160,  322,  333,  379,  365,  365,  365,  365,
 /*  1470 */   348,  365,  333,  360,   20,  375,  365,  250,  432,  365,
 /*  1480 */   375,  432,  229,  230,  231,  232,  233,  234,  235,  236,
 /*  1490 */   237,  238,  239,  352,  373,  375,  256,  365,  365,  375,
 /*  1500 */   435,  360,  395,  365,  395,  167,  365,  258,  367,  257,
 /*  1510 */   245,  434,  265,  262,  445,  451,  260,  241,   20,  390,
 /*  1520 */    95,  360,   95,  342,  394,  356,  330,  333,  365,  388,
 /*  1530 */   322,   36,  325,  392,  324,  383,  346,  396,  397,  398,
 /*  1540 */   399,  400,  401,  402,  378,  404,  346,  432,  431,  430,
 /*  1550 */   409,  414,  411,  334,  429,  346,  415,  416,  320,    0,
 /*  1560 */   352,    0,  444,  183,    0,    0,  425,   42,  360,   35,
 /*  1570 */   195,   35,   35,  365,    0,  367,   35,  195,    0,   35,
 /*  1580 */    35,  195,    0,  195,  322,    0,   35,    0,   22,    0,
 /*  1590 */    35,  178,  176,    0,    0,  172,  388,  171,    0,    0,
 /*  1600 */   392,    0,   46,    0,  396,  397,  398,  399,  400,  401,
 /*  1610 */   402,    0,  404,   42,  352,    0,    0,  409,    0,  411,
 /*  1620 */   149,   42,  360,  415,  416,    0,    0,  365,    0,  367,
 /*  1630 */     0,    0,   35,  425,    0,  149,    0,    0,  322,    0,
 /*  1640 */     0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1650 */   388,    0,    0,    0,  392,   42,    0,    0,  396,  397,
 /*  1660 */   398,  399,  400,  401,  402,    0,  404,    0,  352,    0,
 /*  1670 */     0,  409,   22,  411,   57,    0,  360,  415,  416,    0,
 /*  1680 */     0,  365,    0,  367,   57,    0,    0,   14,    0,   35,
 /*  1690 */    14,  322,   63,  167,    0,    0,    0,   42,   39,    0,
 /*  1700 */     0,   43,   40,   39,  388,    0,   46,   46,  392,    0,
 /*  1710 */    39,    0,  396,  397,  398,  399,  400,  401,  402,   35,
 /*  1720 */   404,  352,   39,    0,   47,  409,   35,  411,   47,  360,
 /*  1730 */     0,  415,  416,    0,  365,    0,  367,   39,   35,   35,
 /*  1740 */    47,   39,    0,    0,  322,   39,    0,   35,   47,   22,
 /*  1750 */     0,   35,   35,   22,   35,   35,   43,  388,   43,   35,
 /*  1760 */    35,  392,   22,   35,    0,  396,  397,  398,  399,  400,
 /*  1770 */   401,  402,  104,  404,  352,   22,    0,   22,  409,    0,
 /*  1780 */   411,   49,  360,   22,  415,  416,   35,  365,    0,  367,
 /*  1790 */     0,  102,   35,   35,    0,   22,    0,   20,  163,    0,
 /*  1800 */    35,  179,   22,   96,    0,  322,    0,    0,    3,   95,
 /*  1810 */   388,    0,    0,   95,  392,    0,   35,   96,  396,  397,
 /*  1820 */   398,  399,  400,  401,  402,    0,  404,   35,  165,  322,
 /*  1830 */    39,   95,  160,  411,   95,  352,   95,  415,  416,  105,
 /*  1840 */    43,  163,  246,  360,   46,   43,  159,   95,  365,  225,
 /*  1850 */   367,   43,   96,  163,  188,   95,   43,  225,  161,  352,
 /*  1860 */   227,   43,   96,   96,   95,   46,   96,  360,   96,   95,
 /*  1870 */    46,  388,  365,   95,  367,  392,    3,   95,   95,  396,
 /*  1880 */   397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
 /*  1890 */    43,  322,   35,   35,   35,  388,   96,   96,   35,  392,
 /*  1900 */    35,   35,   46,  396,  397,  398,  399,  400,  401,  402,
 /*  1910 */    96,  404,   96,   43,   46,   46,    2,   22,  411,   96,
 /*  1920 */    46,  352,   95,  416,   95,   46,   95,  201,   96,  360,
 /*  1930 */    96,   95,   95,   22,  365,   96,  367,   95,   35,  106,
 /*  1940 */   203,   96,  322,   35,   95,   35,   96,   95,   35,   96,
 /*  1950 */    95,   35,   35,   22,  246,   95,  246,  388,   96,  119,
 /*  1960 */    96,  392,  240,  119,   35,  396,  397,  398,  399,  400,
 /*  1970 */   401,  402,  352,  404,   22,  406,   43,   95,   95,  107,
 /*  1980 */   360,   95,   95,   63,   62,  365,  119,  367,   35,   35,
 /*  1990 */   119,   35,   35,   35,   35,   35,  322,   35,   35,   35,
 /*  2000 */    35,   69,   35,   22,   92,   35,   22,   35,  388,   43,
 /*  2010 */    35,   35,  392,   69,  322,   35,  396,  397,  398,  399,
 /*  2020 */   400,  401,  402,   35,  404,   35,  352,   35,   35,   22,
 /*  2030 */    35,    0,   35,   39,  360,    0,   47,   35,   47,  365,
 /*  2040 */    39,  367,    0,   35,  352,   47,    0,   35,   39,   39,
 /*  2050 */    47,    0,  360,   35,   35,    0,   22,  365,  438,  367,
 /*  2060 */    21,  452,  388,   22,   20,   22,  392,  452,   21,  452,
 /*  2070 */   396,  397,  398,  399,  400,  401,  402,  452,  404,  452,
 /*  2080 */   388,  452,  452,  452,  392,  452,  452,  452,  396,  397,
 /*  2090 */   398,  399,  400,  401,  402,  452,  404,  322,  452,  452,
 /*  2100 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2110 */   452,  452,  452,  452,  440,  452,  452,  452,  452,  452,
 /*  2120 */   452,  452,  452,  452,  452,  452,  452,  352,  452,  452,
 /*  2130 */   452,  452,  357,  452,  452,  360,  452,  452,  452,  452,
 /*  2140 */   365,  449,  367,  452,  452,  452,  452,  452,  452,  452,
 /*  2150 */   452,  452,  322,  452,  452,  452,  452,  452,  452,  452,
 /*  2160 */   452,  452,  452,  388,  452,  452,  452,  392,  452,  452,
 /*  2170 */   452,  396,  397,  398,  399,  400,  401,  402,  452,  404,
 /*  2180 */   452,  452,  352,  452,  452,  452,  452,  357,  452,  452,
 /*  2190 */   360,  452,  452,  452,  452,  365,  452,  367,  452,  452,
 /*  2200 */   452,  452,  452,  322,  452,  452,  452,  452,  452,  452,
 /*  2210 */   452,  452,  452,  452,  452,  452,  452,  452,  388,  452,
 /*  2220 */   452,  452,  392,  452,  452,  452,  396,  397,  398,  399,
 /*  2230 */   400,  401,  402,  352,  404,  452,  452,  452,  452,  452,
 /*  2240 */   452,  360,  452,  452,  452,  452,  365,  452,  367,  452,
 /*  2250 */   452,  452,  452,  452,  452,  452,  452,  322,  452,  452,
 /*  2260 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  388,
 /*  2270 */   452,  452,  452,  392,  452,  452,  452,  396,  397,  398,
 /*  2280 */   399,  400,  401,  402,  452,  404,  452,  352,  452,  452,
 /*  2290 */   452,  452,  452,  452,  452,  360,  452,  452,  452,  452,
 /*  2300 */   365,  452,  367,  452,  452,  452,  452,  452,  322,  452,
 /*  2310 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2320 */   452,  452,  452,  388,  452,  452,  452,  392,  452,  452,
 /*  2330 */   452,  396,  397,  398,  399,  400,  401,  402,  352,  404,
 /*  2340 */   452,  452,  452,  452,  452,  452,  360,  452,  452,  452,
 /*  2350 */   452,  365,  452,  367,  452,  452,  452,  452,  452,  452,
 /*  2360 */   452,  452,  322,  452,  452,  452,  452,  452,  452,  452,
 /*  2370 */   452,  452,  452,  452,  388,  452,  452,  452,  392,  452,
 /*  2380 */   322,  452,  396,  397,  398,  399,  400,  401,  402,  452,
 /*  2390 */   404,  452,  352,  452,  452,  452,  452,  452,  452,  452,
 /*  2400 */   360,  452,  452,  452,  452,  365,  452,  367,  452,  452,
 /*  2410 */   352,  452,  452,  452,  452,  452,  452,  452,  360,  452,
 /*  2420 */   452,  452,  452,  365,  452,  367,  452,  452,  388,  452,
 /*  2430 */   452,  452,  392,  452,  452,  452,  396,  397,  398,  399,
 /*  2440 */   400,  401,  402,  452,  404,  452,  388,  452,  452,  452,
 /*  2450 */   392,  452,  452,  452,  396,  397,  398,  399,  400,  401,
 /*  2460 */   402,  452,  404,  322,  452,  452,  452,  452,  452,  452,
 /*  2470 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2480 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2490 */   452,  452,  452,  352,  452,  452,  452,  452,  452,  452,
 /*  2500 */   452,  360,  452,  452,  452,  452,  365,  452,  367,  452,
 /*  2510 */   452,  452,  452,  452,  452,  452,  452,  452,  322,  452,
 /*  2520 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  388,
 /*  2530 */   452,  452,  452,  392,  452,  452,  452,  396,  397,  398,
 /*  2540 */   399,  400,  401,  402,  452,  404,  452,  452,  352,  452,
 /*  2550 */   452,  452,  452,  452,  452,  452,  360,  452,  452,  452,
 /*  2560 */   452,  365,  452,  367,  452,  452,  452,  452,  452,  322,
 /*  2570 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2580 */   452,  452,  452,  452,  388,  452,  452,  452,  392,  452,
 /*  2590 */   452,  452,  396,  397,  398,  399,  400,  401,  402,  352,
 /*  2600 */   404,  452,  452,  452,  452,  452,  452,  360,  452,  452,
 /*  2610 */   452,  452,  365,  452,  367,  452,  452,  452,  452,  452,
 /*  2620 */   452,  452,  452,  322,  452,  452,  452,  452,  452,  452,
 /*  2630 */   452,  452,  452,  452,  452,  388,  452,  452,  452,  392,
 /*  2640 */   452,  452,  452,  396,  397,  398,  399,  400,  401,  402,
 /*  2650 */   452,  404,  452,  352,  452,  452,  452,  452,  452,  452,
 /*  2660 */   452,  360,  452,  452,  452,  452,  365,  452,  367,  452,
 /*  2670 */   452,  452,  452,  452,  322,  452,  452,  452,  452,  452,
 /*  2680 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  388,
 /*  2690 */   452,  452,  452,  392,  452,  452,  452,  396,  397,  398,
 /*  2700 */   399,  400,  401,  402,  352,  404,  452,  452,  452,  452,
 /*  2710 */   452,  452,  360,  452,  452,  452,  452,  365,  452,  367,
 /*  2720 */   452,  452,  452,  452,  452,  452,  452,  452,  322,  452,
 /*  2730 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2740 */   388,  452,  452,  452,  392,  452,  322,  452,  396,  397,
 /*  2750 */   398,  399,  400,  401,  402,  452,  404,  452,  352,  452,
 /*  2760 */   452,  452,  452,  452,  452,  452,  360,  452,  452,  452,
 /*  2770 */   452,  365,  452,  367,  452,  452,  352,  452,  452,  452,
 /*  2780 */   452,  452,  452,  452,  360,  452,  452,  452,  452,  365,
 /*  2790 */   452,  367,  452,  452,  388,  452,  452,  452,  392,  452,
 /*  2800 */   452,  452,  396,  397,  398,  399,  400,  401,  402,  452,
 /*  2810 */   404,  452,  388,  452,  452,  452,  392,  452,  452,  452,
 /*  2820 */   396,  397,  398,  399,  400,  401,  402,  452,  404,  322,
 /*  2830 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2840 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2850 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  352,
 /*  2860 */   452,  452,  452,  452,  452,  452,  452,  360,  452,  452,
 /*  2870 */   452,  452,  365,  452,  367,  452,  452,  452,  452,  452,
 /*  2880 */   452,  452,  452,  452,  322,  452,  452,  452,  452,  452,
 /*  2890 */   452,  452,  452,  452,  452,  388,  452,  452,  452,  392,
 /*  2900 */   452,  452,  452,  396,  397,  398,  399,  400,  401,  402,
 /*  2910 */   452,  404,  452,  452,  352,  452,  452,  452,  452,  452,
 /*  2920 */   452,  452,  360,  452,  452,  452,  452,  365,  452,  367,
 /*  2930 */   452,  452,  452,  452,  452,  322,  452,  452,  452,  452,
 /*  2940 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  2950 */   388,  452,  452,  452,  392,  452,  452,  452,  396,  397,
 /*  2960 */   398,  399,  400,  401,  402,  352,  404,  452,  452,  452,
 /*  2970 */   452,  452,  452,  360,  452,  452,  452,  452,  365,  452,
 /*  2980 */   367,  452,  452,  452,  452,  452,  452,  452,  452,  322,
 /*  2990 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  3000 */   452,  388,  452,  452,  452,  392,  452,  452,  452,  396,
 /*  3010 */   397,  398,  399,  400,  401,  402,  452,  404,  452,  352,
 /*  3020 */   452,  452,  452,  452,  452,  452,  452,  360,  452,  452,
 /*  3030 */   452,  452,  365,  452,  367,  452,  452,  452,  452,  452,
 /*  3040 */   322,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  3050 */   452,  452,  452,  452,  452,  388,  452,  452,  452,  392,
 /*  3060 */   452,  452,  452,  396,  397,  398,  399,  400,  401,  402,
 /*  3070 */   352,  404,  452,  452,  452,  452,  452,  452,  360,  452,
 /*  3080 */   452,  452,  452,  365,  452,  367,  452,  452,  452,  452,
 /*  3090 */   452,  452,  452,  452,  322,  452,  452,  452,  452,  452,
 /*  3100 */   452,  452,  452,  452,  452,  452,  388,  452,  452,  452,
 /*  3110 */   392,  452,  322,  452,  396,  397,  398,  399,  400,  401,
 /*  3120 */   402,  452,  404,  452,  352,  452,  452,  452,  452,  452,
 /*  3130 */   452,  452,  360,  452,  452,  452,  452,  365,  452,  367,
 /*  3140 */   452,  452,  352,  452,  452,  452,  452,  452,  452,  452,
 /*  3150 */   360,  452,  452,  452,  452,  365,  452,  367,  452,  452,
 /*  3160 */   388,  452,  452,  452,  392,  452,  452,  452,  396,  397,
 /*  3170 */   398,  399,  400,  401,  402,  452,  404,  452,  388,  452,
 /*  3180 */   452,  452,  392,  452,  452,  452,  396,  397,  398,  399,
 /*  3190 */   400,  401,  402,  452,  404,  322,  452,  452,  452,  452,
 /*  3200 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  3210 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  3220 */   452,  452,  452,  452,  452,  352,  452,  452,  452,  452,
 /*  3230 */   452,  452,  452,  360,  452,  452,  452,  452,  365,  452,
 /*  3240 */   367,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  3250 */   322,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  3260 */   452,  388,  452,  452,  452,  392,  452,  452,  452,  396,
 /*  3270 */   397,  398,  399,  400,  401,  402,  452,  404,  452,  452,
 /*  3280 */   352,  452,  452,  452,  452,  452,  452,  452,  360,  452,
 /*  3290 */   452,  452,  452,  365,  452,  367,  452,  452,  452,  452,
 /*  3300 */   452,  452,  452,  452,  452,  452,  452,  452,  452,  452,
 /*  3310 */   452,  452,  452,  452,  452,  452,  388,  452,  452,  452,
 /*  3320 */   392,  452,  452,  452,  396,  397,  398,  399,  400,  401,
 /*  3330 */   402,  452,  404,
};
#define YY_SHIFT_COUNT    (700)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2055)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1148,    0,   58,  271,   58,  329,  329,  329,  542,  329,
 /*    10 */   329,  329,  329,  329,  600,  813,  813,  871,  813,  813,
 /*    20 */   813,  813,  813,  813,  813,  813,  813,  813,  813,  813,
 /*    30 */   813,  813,  813,  813,  813,  813,  813,  813,  813,  813,
 /*    40 */   813,  813,  813,  813,  813,  813,  279,  434,    8,  266,
 /*    50 */   261,   19,   43,   19,    8,    8,  658,  658,   19,  658,
 /*    60 */   658,  332,   19,   16,   16,   14,   14,  435,   16,   16,
 /*    70 */    16,   16,   16,   16,   16,   16,   16,   16,   20,   16,
 /*    80 */    16,   16,   41,   16,   16,  207,   16,   16,  207,  213,
 /*    90 */    16,  207,  207,  207,   16,  229, 1078, 1253, 1253,  367,
 /*   100 */   222,  653,  653,  653,  653,  653,  653,  653,  653,  653,
 /*   110 */   653,  653,  653,  653,  653,  653,  653,  653,  653,  653,
 /*   120 */   128,  553,  435,  137,  137,  126,  366,  296,   99,   99,
 /*   130 */   267,  267,  267,  366,  364,  364,  364,   27,   41,   10,
 /*   140 */    10,  178,  207,  207,  354,  354,   27,  379,  199,  199,
 /*   150 */   199,  199,  199,  199,  199,  340,  896,   21,   74,  450,
 /*   160 */   164,  350,  407,  323,  422,  578,  821,  720,  963,  685,
 /*   170 */   330,  718,  685, 1009,  395,  841, 1041, 1257, 1135, 1280,
 /*   180 */  1280, 1177, 1318, 1318, 1280, 1177, 1177, 1263, 1318, 1318,
 /*   190 */  1318, 1339, 1339, 1354,   20,   41,   20, 1358, 1362,   20,
 /*   200 */  1358,   20,   20,   20, 1318,   20, 1357, 1357, 1339,  207,
 /*   210 */   207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
 /*   220 */  1318, 1339,  354, 1246, 1354,  229, 1272,   41,  229, 1318,
 /*   230 */  1318, 1358,  229, 1211,  354,  354,  354,  354, 1211,  354,
 /*   240 */  1302,  229,   27,  229,  364, 1454, 1454,  354, 1227, 1211,
 /*   250 */   354,  354, 1227, 1211,  354,  354,  207, 1240, 1338, 1227,
 /*   260 */  1249, 1252, 1265, 1041, 1247, 1251, 1256, 1276,  364, 1498,
 /*   270 */  1425, 1427,  354,  379, 1318,  229, 1495, 1339, 3333, 3333,
 /*   280 */  3333, 3333, 3333, 3333, 3333, 1074,  951,  382, 1267,  576,
 /*   290 */   669,  632,  692,  721,  779,  453, 1054, 1054, 1054, 1054,
 /*   300 */  1054, 1054, 1054, 1054, 1054,  993,  670,  105,  113,  767,
 /*   310 */   767,  197,  201,  120,  598,  513,  757,  766,  457,  757,
 /*   320 */   757,  757,  760,  345,  704,  801, 1097, 1010, 1016, 1030,
 /*   330 */  1035,  919,  949, 1187,  466,  940,  920,  969, 1073, 1085,
 /*   340 */  1092, 1136, 1155, 1044,  952,  794, 1176, 1158, 1145, 1201,
 /*   350 */  1112, 1160, 1179, 1192, 1162, 1167, 1168, 1202, 1206, 1254,
 /*   360 */  1178, 1299, 1317, 1260, 1193, 1559, 1561, 1380, 1564, 1565,
 /*   370 */  1525, 1574, 1534, 1375, 1536, 1537, 1541, 1382, 1578, 1544,
 /*   380 */  1545, 1386, 1582, 1388, 1585, 1551, 1587, 1566, 1589, 1555,
 /*   390 */  1413, 1416, 1593, 1594, 1423, 1426, 1598, 1599, 1556, 1601,
 /*   400 */  1603, 1611, 1571, 1615, 1616, 1618, 1579, 1625, 1626, 1628,
 /*   410 */  1630, 1631, 1471, 1597, 1634, 1486, 1636, 1637, 1639, 1640,
 /*   420 */  1641, 1642, 1643, 1644, 1645, 1646, 1647, 1648, 1649, 1651,
 /*   430 */  1652, 1613, 1653, 1656, 1657, 1665, 1667, 1650, 1669, 1670,
 /*   440 */  1679, 1680, 1654, 1682, 1617, 1675, 1627, 1685, 1686, 1655,
 /*   450 */  1659, 1658, 1673, 1660, 1676, 1661, 1688, 1662, 1664, 1699,
 /*   460 */  1700, 1705, 1671, 1526, 1694, 1695, 1696, 1629, 1709, 1711,
 /*   470 */  1684, 1677, 1683, 1723, 1691, 1681, 1698, 1730, 1703, 1693,
 /*   480 */  1702, 1733, 1704, 1701, 1706, 1735, 1742, 1743, 1746, 1668,
 /*   490 */  1689, 1712, 1727, 1750, 1716, 1717, 1731, 1719, 1720, 1713,
 /*   500 */  1715, 1724, 1725, 1740, 1728, 1764, 1753, 1776, 1755, 1732,
 /*   510 */  1779, 1761, 1751, 1788, 1757, 1790, 1758, 1794, 1773, 1777,
 /*   520 */  1707, 1714, 1796, 1635, 1765, 1799, 1622, 1780, 1678, 1672,
 /*   530 */  1804, 1806, 1690, 1663, 1805, 1807, 1811, 1812, 1718, 1721,
 /*   540 */  1781, 1792, 1666, 1815, 1736, 1697, 1739, 1825, 1791, 1687,
 /*   550 */  1741, 1734, 1798, 1797, 1624, 1633, 1632, 1802, 1596, 1752,
 /*   560 */  1756, 1760, 1766, 1767, 1769, 1808, 1770, 1774, 1778, 1782,
 /*   570 */  1772, 1813, 1819, 1824, 1783, 1818, 1708, 1800, 1801, 1873,
 /*   580 */  1847, 1710, 1857, 1858, 1859, 1863, 1865, 1866, 1814, 1816,
 /*   590 */  1856, 1722, 1870, 1868, 1869, 1914, 1895, 1726, 1827, 1823,
 /*   600 */  1829, 1832, 1831, 1834, 1874, 1836, 1837, 1879, 1839, 1911,
 /*   610 */  1737, 1842, 1833, 1845, 1903, 1908, 1849, 1850, 1910, 1852,
 /*   620 */  1853, 1913, 1855, 1862, 1916, 1860, 1864, 1917, 1882, 1840,
 /*   630 */  1844, 1867, 1871, 1931, 1872, 1883, 1886, 1929, 1887, 1933,
 /*   640 */  1933, 1952, 1920, 1922, 1953, 1954, 1956, 1957, 1958, 1959,
 /*   650 */  1960, 1962, 1963, 1964, 1932, 1912, 1966, 1965, 1967, 1981,
 /*   660 */  1970, 1984, 1972, 1975, 1976, 1944, 1713, 1980, 1715, 1988,
 /*   670 */  1990, 1992, 1993, 2007, 1995, 2031, 1997, 1989, 1994, 2035,
 /*   680 */  2002, 1991, 2001, 2042, 2008, 1998, 2009, 2046, 2012, 2003,
 /*   690 */  2010, 2051, 2018, 2019, 2055, 2034, 2039, 2041, 2043, 2047,
 /*   700 */  2044,
};
#define YY_REDUCE_COUNT (284)
#define YY_REDUCE_MIN   (-358)
#define YY_REDUCE_MAX   (2928)
static const short yy_reduce_ofst[] = {
 /*     0 */   -94, -292,  892, -230, 1003, 1029, 1141, 1208,  -21, 1262,
 /*    10 */  1316, 1369,  535, 1422, 1483,  205, -204, 1507,  264, 1569,
 /*    20 */  1620, 1674, 1692, 1775, 1830, 1881, 1935, 1986, 2040, 2058,
 /*    30 */  2141, 2196, 2247, 2301, 2352, 2406, 2424, 2507, 2562, 2613,
 /*    40 */  2667, 2718, 2772, 2790, 2873, 2928,  946,   70, -276,   72,
 /*    50 */   471,  512,  612,  614,  771,  776, -328, -252,  885, -348,
 /*    60 */  -325,  -92,  343, -319, -214, -326, -321,  -37, -305, -232,
 /*    70 */   265,  293,  349,  359,  381,  498,  509,  520, -176,  551,
 /*    80 */   555,  556, -358,  622,  840, -329,  910,  912,  147, -169,
 /*    90 */   917,  217,  258,  306,  627,  177, -205,   88,   88, -302,
 /*   100 */  -224, -162,  106,  523,  525,  545,  549,  583,  599,  602,
 /*   110 */   607,  621,  625,  634,  674,  678,  679,  742,  749,  802,
 /*   120 */  -350,  -59,  159, -253,  -89, -331,  220,    5,  186,  430,
 /*   130 */   -59,  303,  316,  504,   97,  216,  493,  342,  336,  454,
 /*   140 */   544,  335,  689, -267,  613,  648,  754,  561,  121,  151,
 /*   150 */   156,  277,  298,  421,  433,  460,  531,  566,  581,  547,
 /*   160 */   603,  650,  710,  850,  850,  873,  908,  875,  853,  826,
 /*   170 */   826,  831,  826,  861,  852,  850,  909,  916,  928,  961,
 /*   180 */   964,  967, 1011, 1019,  968,  983,  984, 1021, 1032, 1043,
 /*   190 */  1045, 1036, 1047,  990, 1042, 1013, 1048, 1005, 1004, 1051,
 /*   200 */  1018, 1063, 1071, 1075, 1079, 1080, 1081, 1084, 1096, 1070,
 /*   210 */  1072, 1082, 1083, 1089, 1090, 1091, 1094, 1095, 1098, 1099,
 /*   220 */  1093, 1108, 1087, 1050, 1062, 1116, 1076, 1088, 1123, 1127,
 /*   230 */  1128, 1086, 1126, 1100, 1101, 1102, 1103, 1104, 1105, 1106,
 /*   240 */  1121, 1131, 1122, 1139, 1113, 1107, 1109, 1111, 1046, 1120,
 /*   250 */  1114, 1132, 1049, 1124, 1133, 1138,  850, 1065, 1077, 1115,
 /*   260 */  1117, 1119, 1125, 1129, 1064, 1069, 1118,  826, 1161, 1130,
 /*   270 */  1137, 1169, 1163, 1181, 1196, 1194, 1207, 1210, 1152, 1166,
 /*   280 */  1190, 1200, 1209, 1219, 1238,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    10 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    20 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    30 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    40 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    50 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    60 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    70 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1640, 1564,
 /*    80 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*    90 */  1564, 1564, 1564, 1564, 1564, 1638, 1810, 1999, 1564, 1564,
 /*   100 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   110 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   120 */  1564, 2011, 1564, 1564, 1564, 1640, 1564, 1638, 1971, 1971,
 /*   130 */  2011, 2011, 2011, 1564, 1564, 1564, 1564, 1749, 1564, 1851,
 /*   140 */  1851, 1564, 1564, 1564, 1564, 1564, 1749, 1564, 1564, 1564,
 /*   150 */  1564, 1564, 1564, 1564, 1564, 1845, 1564, 1564, 2036, 2089,
 /*   160 */  1564, 1564, 2039, 1564, 1564, 1564, 1564, 1702, 2026, 2003,
 /*   170 */  2017, 2073, 2004, 2001, 2020, 1564, 2030, 1564, 1838, 1815,
 /*   180 */  1815, 1812, 1564, 1564, 1815, 1812, 1812, 1693, 1564, 1564,
 /*   190 */  1564, 1564, 1564, 1564, 1640, 1564, 1640, 1564, 1564, 1640,
 /*   200 */  1564, 1640, 1640, 1640, 1564, 1640, 1619, 1619, 1564, 1564,
 /*   210 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   220 */  1564, 1564, 1564, 1858, 1564, 1638, 1847, 1564, 1638, 1564,
 /*   230 */  1564, 1564, 1638, 2044, 1564, 1564, 1564, 1564, 2044, 1564,
 /*   240 */  1564, 1638, 1564, 1638, 1564, 1564, 1564, 1564, 2046, 2044,
 /*   250 */  1564, 1564, 2046, 2044, 1564, 1564, 1564, 2058, 2054, 2046,
 /*   260 */  2062, 2060, 2032, 2030, 2092, 2079, 2075, 2017, 1564, 1564,
 /*   270 */  1564, 1718, 1564, 1564, 1564, 1638, 1596, 1564, 1840, 1851,
 /*   280 */  1752, 1752, 1752, 1641, 1569, 1564, 1564, 1564, 1564, 1564,
 /*   290 */  1564, 1564, 1564, 1564, 1564, 1564, 1927, 1564, 2057, 2056,
 /*   300 */  1975, 1974, 1973, 1964, 1926, 1564, 1714, 1564, 1564, 1925,
 /*   310 */  1924, 1564, 1564, 1564, 1564, 1564, 1918, 1564, 1564, 1919,
 /*   320 */  1917, 1916, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   330 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   340 */  1564, 1564, 1564, 1564, 2076, 2080, 2000, 1564, 1564, 1564,
 /*   350 */  1564, 1564, 1909, 1900, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   360 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   370 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   380 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   390 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   400 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   410 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   420 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   430 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   440 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   450 */  1564, 1601, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   460 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   470 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   480 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   490 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1680,
 /*   500 */  1679, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   510 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   520 */  1908, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   530 */  1564, 1564, 1564, 1564, 2072, 1564, 1564, 1564, 1564, 1564,
 /*   540 */  1564, 1564, 1564, 1855, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   550 */  1564, 1564, 1564, 1961, 1564, 1564, 1564, 2033, 1564, 1564,
 /*   560 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   570 */  1564, 1564, 1564, 1900, 1564, 2055, 1564, 1564, 2070, 1564,
 /*   580 */  2074, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 2010, 2006,
 /*   590 */  1564, 1564, 2002, 1899, 1564, 1995, 1564, 1564, 1946, 1564,
 /*   600 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1908, 1564,
 /*   610 */  1912, 1564, 1564, 1564, 1564, 1564, 1746, 1564, 1564, 1564,
 /*   620 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1731,
 /*   630 */  1729, 1728, 1727, 1564, 1724, 1564, 1564, 1564, 1564, 1755,
 /*   640 */  1754, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   650 */  1564, 1564, 1564, 1564, 1564, 1564, 1660, 1564, 1564, 1564,
 /*   660 */  1564, 1564, 1564, 1564, 1564, 1564, 1651, 1564, 1650, 1564,
 /*   670 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   680 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   690 */  1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564, 1564,
 /*   700 */  1564,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  266,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  266,  /*      AFTER => ABORT */
  266,  /*     ATTACH => ABORT */
  266,  /*     BEFORE => ABORT */
  266,  /*      BEGIN => ABORT */
  266,  /*     BITAND => ABORT */
  266,  /*     BITNOT => ABORT */
  266,  /*      BITOR => ABORT */
  266,  /*     BLOCKS => ABORT */
  266,  /*     CHANGE => ABORT */
  266,  /*      COMMA => ABORT */
  266,  /*    COMPACT => ABORT */
  266,  /*     CONCAT => ABORT */
  266,  /*   CONFLICT => ABORT */
  266,  /*       COPY => ABORT */
  266,  /*   DEFERRED => ABORT */
  266,  /* DELIMITERS => ABORT */
  266,  /*     DETACH => ABORT */
  266,  /*     DIVIDE => ABORT */
  266,  /*        DOT => ABORT */
  266,  /*       EACH => ABORT */
  266,  /*       FAIL => ABORT */
  266,  /*       FILE => ABORT */
  266,  /*        FOR => ABORT */
  266,  /*       GLOB => ABORT */
  266,  /*         ID => ABORT */
  266,  /*  IMMEDIATE => ABORT */
  266,  /*     IMPORT => ABORT */
  266,  /*  INITIALLY => ABORT */
  266,  /*    INSTEAD => ABORT */
  266,  /*     ISNULL => ABORT */
  266,  /*        KEY => ABORT */
  266,  /*    MODULES => ABORT */
  266,  /*  NK_BITNOT => ABORT */
  266,  /*    NK_SEMI => ABORT */
  266,  /*    NOTNULL => ABORT */
  266,  /*         OF => ABORT */
  266,  /*       PLUS => ABORT */
  266,  /*  PRIVILEGE => ABORT */
  266,  /*      RAISE => ABORT */
  266,  /*    REPLACE => ABORT */
  266,  /*   RESTRICT => ABORT */
  266,  /*        ROW => ABORT */
  266,  /*       SEMI => ABORT */
  266,  /*       STAR => ABORT */
  266,  /*  STATEMENT => ABORT */
  266,  /*     STRING => ABORT */
  266,  /*      TIMES => ABORT */
  266,  /*     UPDATE => ABORT */
  266,  /*     VALUES => ABORT */
  266,  /*   VARIABLE => ABORT */
  266,  /*       VIEW => ABORT */
  266,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "FORCE",
  /*   52 */ "LOCAL",
  /*   53 */ "QNODE",
  /*   54 */ "BNODE",
  /*   55 */ "SNODE",
  /*   56 */ "MNODE",
  /*   57 */ "DATABASE",
  /*   58 */ "USE",
  /*   59 */ "FLUSH",
  /*   60 */ "TRIM",
  /*   61 */ "IF",
  /*   62 */ "NOT",
  /*   63 */ "EXISTS",
  /*   64 */ "BUFFER",
  /*   65 */ "CACHEMODEL",
  /*   66 */ "CACHESIZE",
  /*   67 */ "COMP",
  /*   68 */ "DURATION",
  /*   69 */ "NK_VARIABLE",
  /*   70 */ "MAXROWS",
  /*   71 */ "MINROWS",
  /*   72 */ "KEEP",
  /*   73 */ "PAGES",
  /*   74 */ "PAGESIZE",
  /*   75 */ "TSDB_PAGESIZE",
  /*   76 */ "PRECISION",
  /*   77 */ "REPLICA",
  /*   78 */ "STRICT",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "FIRST",
  /*  132 */ "LAST",
  /*  133 */ "SHOW",
  /*  134 */ "DATABASES",
  /*  135 */ "TABLES",
  /*  136 */ "STABLES",
  /*  137 */ "MNODES",
  /*  138 */ "QNODES",
  /*  139 */ "FUNCTIONS",
  /*  140 */ "INDEXES",
  /*  141 */ "ACCOUNTS",
  /*  142 */ "APPS",
  /*  143 */ "CONNECTIONS",
  /*  144 */ "LICENCES",
  /*  145 */ "GRANTS",
  /*  146 */ "QUERIES",
  /*  147 */ "SCORES",
  /*  148 */ "TOPICS",
  /*  149 */ "VARIABLES",
  /*  150 */ "CLUSTER",
  /*  151 */ "BNODES",
  /*  152 */ "SNODES",
  /*  153 */ "TRANSACTIONS",
  /*  154 */ "DISTRIBUTED",
  /*  155 */ "CONSUMERS",
  /*  156 */ "SUBSCRIPTIONS",
  /*  157 */ "VNODES",
  /*  158 */ "LIKE",
  /*  159 */ "INDEX",
  /*  160 */ "FUNCTION",
  /*  161 */ "INTERVAL",
  /*  162 */ "TOPIC",
  /*  163 */ "AS",
  /*  164 */ "WITH",
  /*  165 */ "META",
  /*  166 */ "CONSUMER",
  /*  167 */ "GROUP",
  /*  168 */ "DESC",
  /*  169 */ "DESCRIBE",
  /*  170 */ "RESET",
  /*  171 */ "QUERY",
  /*  172 */ "CACHE",
  /*  173 */ "EXPLAIN",
  /*  174 */ "ANALYZE",
  /*  175 */ "VERBOSE",
  /*  176 */ "NK_BOOL",
  /*  177 */ "RATIO",
  /*  178 */ "NK_FLOAT",
  /*  179 */ "OUTPUTTYPE",
  /*  180 */ "AGGREGATE",
  /*  181 */ "BUFSIZE",
  /*  182 */ "STREAM",
  /*  183 */ "INTO",
  /*  184 */ "TRIGGER",
  /*  185 */ "AT_ONCE",
  /*  186 */ "WINDOW_CLOSE",
  /*  187 */ "IGNORE",
  /*  188 */ "EXPIRED",
  /*  189 */ "FILL_HISTORY",
  /*  190 */ "SUBTABLE",
  /*  191 */ "KILL",
  /*  192 */ "CONNECTION",
  /*  193 */ "TRANSACTION",
  /*  194 */ "BALANCE",
  /*  195 */ "VGROUP",
  /*  196 */ "MERGE",
  /*  197 */ "REDISTRIBUTE",
  /*  198 */ "SPLIT",
  /*  199 */ "DELETE",
  /*  200 */ "INSERT",
  /*  201 */ "NULL",
  /*  202 */ "NK_QUESTION",
  /*  203 */ "NK_ARROW",
  /*  204 */ "ROWTS",
  /*  205 */ "TBNAME",
  /*  206 */ "QSTART",
  /*  207 */ "QEND",
  /*  208 */ "QDURATION",
  /*  209 */ "WSTART",
  /*  210 */ "WEND",
  /*  211 */ "WDURATION",
  /*  212 */ "IROWTS",
  /*  213 */ "QTAGS",
  /*  214 */ "CAST",
  /*  215 */ "NOW",
  /*  216 */ "TODAY",
  /*  217 */ "TIMEZONE",
  /*  218 */ "CLIENT_VERSION",
  /*  219 */ "SERVER_VERSION",
  /*  220 */ "SERVER_STATUS",
  /*  221 */ "CURRENT_USER",
  /*  222 */ "COUNT",
  /*  223 */ "LAST_ROW",
  /*  224 */ "CASE",
  /*  225 */ "END",
  /*  226 */ "WHEN",
  /*  227 */ "THEN",
  /*  228 */ "ELSE",
  /*  229 */ "BETWEEN",
  /*  230 */ "IS",
  /*  231 */ "NK_LT",
  /*  232 */ "NK_GT",
  /*  233 */ "NK_LE",
  /*  234 */ "NK_GE",
  /*  235 */ "NK_NE",
  /*  236 */ "MATCH",
  /*  237 */ "NMATCH",
  /*  238 */ "CONTAINS",
  /*  239 */ "IN",
  /*  240 */ "JOIN",
  /*  241 */ "INNER",
  /*  242 */ "SELECT",
  /*  243 */ "DISTINCT",
  /*  244 */ "WHERE",
  /*  245 */ "PARTITION",
  /*  246 */ "BY",
  /*  247 */ "SESSION",
  /*  248 */ "STATE_WINDOW",
  /*  249 */ "SLIDING",
  /*  250 */ "FILL",
  /*  251 */ "VALUE",
  /*  252 */ "NONE",
  /*  253 */ "PREV",
  /*  254 */ "LINEAR",
  /*  255 */ "NEXT",
  /*  256 */ "HAVING",
  /*  257 */ "RANGE",
  /*  258 */ "EVERY",
  /*  259 */ "ORDER",
  /*  260 */ "SLIMIT",
  /*  261 */ "SOFFSET",
  /*  262 */ "LIMIT",
  /*  263 */ "OFFSET",
  /*  264 */ "ASC",
  /*  265 */ "NULLS",
  /*  266 */ "ABORT",
  /*  267 */ "AFTER",
  /*  268 */ "ATTACH",
  /*  269 */ "BEFORE",
  /*  270 */ "BEGIN",
  /*  271 */ "BITAND",
  /*  272 */ "BITNOT",
  /*  273 */ "BITOR",
  /*  274 */ "BLOCKS",
  /*  275 */ "CHANGE",
  /*  276 */ "COMMA",
  /*  277 */ "COMPACT",
  /*  278 */ "CONCAT",
  /*  279 */ "CONFLICT",
  /*  280 */ "COPY",
  /*  281 */ "DEFERRED",
  /*  282 */ "DELIMITERS",
  /*  283 */ "DETACH",
  /*  284 */ "DIVIDE",
  /*  285 */ "DOT",
  /*  286 */ "EACH",
  /*  287 */ "FAIL",
  /*  288 */ "FILE",
  /*  289 */ "FOR",
  /*  290 */ "GLOB",
  /*  291 */ "ID",
  /*  292 */ "IMMEDIATE",
  /*  293 */ "IMPORT",
  /*  294 */ "INITIALLY",
  /*  295 */ "INSTEAD",
  /*  296 */ "ISNULL",
  /*  297 */ "KEY",
  /*  298 */ "MODULES",
  /*  299 */ "NK_BITNOT",
  /*  300 */ "NK_SEMI",
  /*  301 */ "NOTNULL",
  /*  302 */ "OF",
  /*  303 */ "PLUS",
  /*  304 */ "PRIVILEGE",
  /*  305 */ "RAISE",
  /*  306 */ "REPLACE",
  /*  307 */ "RESTRICT",
  /*  308 */ "ROW",
  /*  309 */ "SEMI",
  /*  310 */ "STAR",
  /*  311 */ "STATEMENT",
  /*  312 */ "STRING",
  /*  313 */ "TIMES",
  /*  314 */ "UPDATE",
  /*  315 */ "VALUES",
  /*  316 */ "VARIABLE",
  /*  317 */ "VIEW",
  /*  318 */ "WAL",
  /*  319 */ "cmd",
  /*  320 */ "account_options",
  /*  321 */ "alter_account_options",
  /*  322 */ "literal",
  /*  323 */ "alter_account_option",
  /*  324 */ "user_name",
  /*  325 */ "sysinfo_opt",
  /*  326 */ "privileges",
  /*  327 */ "priv_level",
  /*  328 */ "priv_type_list",
  /*  329 */ "priv_type",
  /*  330 */ "db_name",
  /*  331 */ "dnode_endpoint",
  /*  332 */ "force_opt",
  /*  333 */ "not_exists_opt",
  /*  334 */ "db_options",
  /*  335 */ "exists_opt",
  /*  336 */ "alter_db_options",
  /*  337 */ "speed_opt",
  /*  338 */ "integer_list",
  /*  339 */ "variable_list",
  /*  340 */ "retention_list",
  /*  341 */ "alter_db_option",
  /*  342 */ "retention",
  /*  343 */ "full_table_name",
  /*  344 */ "column_def_list",
  /*  345 */ "tags_def_opt",
  /*  346 */ "table_options",
  /*  347 */ "multi_create_clause",
  /*  348 */ "tags_def",
  /*  349 */ "multi_drop_clause",
  /*  350 */ "alter_table_clause",
  /*  351 */ "alter_table_options",
  /*  352 */ "column_name",
  /*  353 */ "type_name",
  /*  354 */ "signed_literal",
  /*  355 */ "create_subtable_clause",
  /*  356 */ "specific_cols_opt",
  /*  357 */ "expression_list",
  /*  358 */ "drop_table_clause",
  /*  359 */ "col_name_list",
  /*  360 */ "table_name",
  /*  361 */ "column_def",
  /*  362 */ "duration_list",
  /*  363 */ "rollup_func_list",
  /*  364 */ "alter_table_option",
  /*  365 */ "duration_literal",
  /*  366 */ "rollup_func_name",
  /*  367 */ "function_name",
  /*  368 */ "col_name",
  /*  369 */ "db_name_cond_opt",
  /*  370 */ "like_pattern_opt",
  /*  371 */ "table_name_cond",
  /*  372 */ "from_db_opt",
  /*  373 */ "index_options",
  /*  374 */ "func_list",
  /*  375 */ "sliding_opt",
  /*  376 */ "sma_stream_opt",
  /*  377 */ "func",
  /*  378 */ "stream_options",
  /*  379 */ "topic_name",
  /*  380 */ "query_or_subquery",
  /*  381 */ "cgroup_name",
  /*  382 */ "analyze_opt",
  /*  383 */ "explain_options",
  /*  384 */ "agg_func_opt",
  /*  385 */ "bufsize_opt",
  /*  386 */ "stream_name",
  /*  387 */ "subtable_opt",
  /*  388 */ "expression",
  /*  389 */ "dnode_list",
  /*  390 */ "where_clause_opt",
  /*  391 */ "signed",
  /*  392 */ "literal_func",
  /*  393 */ "literal_list",
  /*  394 */ "table_alias",
  /*  395 */ "column_alias",
  /*  396 */ "expr_or_subquery",
  /*  397 */ "subquery",
  /*  398 */ "pseudo_column",
  /*  399 */ "column_reference",
  /*  400 */ "function_expression",
  /*  401 */ "case_when_expression",
  /*  402 */ "star_func",
  /*  403 */ "star_func_para_list",
  /*  404 */ "noarg_func",
  /*  405 */ "other_para_list",
  /*  406 */ "star_func_para",
  /*  407 */ "when_then_list",
  /*  408 */ "case_when_else_opt",
  /*  409 */ "common_expression",
  /*  410 */ "when_then_expr",
  /*  411 */ "predicate",
  /*  412 */ "compare_op",
  /*  413 */ "in_op",
  /*  414 */ "in_predicate_value",
  /*  415 */ "boolean_value_expression",
  /*  416 */ "boolean_primary",
  /*  417 */ "from_clause_opt",
  /*  418 */ "table_reference_list",
  /*  419 */ "table_reference",
  /*  420 */ "table_primary",
  /*  421 */ "joined_table",
  /*  422 */ "alias_opt",
  /*  423 */ "parenthesized_joined_table",
  /*  424 */ "join_type",
  /*  425 */ "search_condition",
  /*  426 */ "query_specification",
  /*  427 */ "set_quantifier_opt",
  /*  428 */ "select_list",
  /*  429 */ "partition_by_clause_opt",
  /*  430 */ "range_opt",
  /*  431 */ "every_opt",
  /*  432 */ "fill_opt",
  /*  433 */ "twindow_clause_opt",
  /*  434 */ "group_by_clause_opt",
  /*  435 */ "having_clause_opt",
  /*  436 */ "select_item",
  /*  437 */ "partition_list",
  /*  438 */ "partition_item",
  /*  439 */ "fill_mode",
  /*  440 */ "group_by_list",
  /*  441 */ "query_expression",
  /*  442 */ "query_simple",
  /*  443 */ "order_by_clause_opt",
  /*  444 */ "slimit_clause_opt",
  /*  445 */ "limit_clause_opt",
  /*  446 */ "union_query_expression",
  /*  447 */ "query_simple_or_subquery",
  /*  448 */ "sort_specification_list",
  /*  449 */ "sort_specification",
  /*  450 */ "ordering_specification_opt",
  /*  451 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "force_opt ::=",
 /*  53 */ "force_opt ::= FORCE",
 /*  54 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  55 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  56 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  65 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  66 */ "cmd ::= USE db_name",
 /*  67 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  68 */ "cmd ::= FLUSH DATABASE db_name",
 /*  69 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  70 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  71 */ "not_exists_opt ::=",
 /*  72 */ "exists_opt ::= IF EXISTS",
 /*  73 */ "exists_opt ::=",
 /*  74 */ "db_options ::=",
 /*  75 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  76 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  77 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  78 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  79 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  80 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  81 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  82 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  83 */ "db_options ::= db_options KEEP integer_list",
 /*  84 */ "db_options ::= db_options KEEP variable_list",
 /*  85 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  86 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  87 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  88 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  89 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  90 */ "db_options ::= db_options STRICT NK_STRING",
 /*  91 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  92 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  93 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  94 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 103 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 104 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 106 */ "alter_db_options ::= alter_db_option",
 /* 107 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 108 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 109 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 110 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 111 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 112 */ "alter_db_option ::= KEEP integer_list",
 /* 113 */ "alter_db_option ::= KEEP variable_list",
 /* 114 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 115 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 116 */ "alter_db_option ::= STRICT NK_STRING",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "alter_table_options ::= alter_table_option",
 /* 193 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 194 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 195 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 196 */ "duration_list ::= duration_literal",
 /* 197 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 198 */ "rollup_func_list ::= rollup_func_name",
 /* 199 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 200 */ "rollup_func_name ::= function_name",
 /* 201 */ "rollup_func_name ::= FIRST",
 /* 202 */ "rollup_func_name ::= LAST",
 /* 203 */ "col_name_list ::= col_name",
 /* 204 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 205 */ "col_name ::= column_name",
 /* 206 */ "cmd ::= SHOW DNODES",
 /* 207 */ "cmd ::= SHOW USERS",
 /* 208 */ "cmd ::= SHOW DATABASES",
 /* 209 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 210 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 212 */ "cmd ::= SHOW MNODES",
 /* 213 */ "cmd ::= SHOW QNODES",
 /* 214 */ "cmd ::= SHOW FUNCTIONS",
 /* 215 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 216 */ "cmd ::= SHOW STREAMS",
 /* 217 */ "cmd ::= SHOW ACCOUNTS",
 /* 218 */ "cmd ::= SHOW APPS",
 /* 219 */ "cmd ::= SHOW CONNECTIONS",
 /* 220 */ "cmd ::= SHOW LICENCES",
 /* 221 */ "cmd ::= SHOW GRANTS",
 /* 222 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 223 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 224 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 225 */ "cmd ::= SHOW QUERIES",
 /* 226 */ "cmd ::= SHOW SCORES",
 /* 227 */ "cmd ::= SHOW TOPICS",
 /* 228 */ "cmd ::= SHOW VARIABLES",
 /* 229 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 230 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 231 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 232 */ "cmd ::= SHOW BNODES",
 /* 233 */ "cmd ::= SHOW SNODES",
 /* 234 */ "cmd ::= SHOW CLUSTER",
 /* 235 */ "cmd ::= SHOW TRANSACTIONS",
 /* 236 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 237 */ "cmd ::= SHOW CONSUMERS",
 /* 238 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 239 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 240 */ "cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt",
 /* 241 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 242 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 243 */ "db_name_cond_opt ::=",
 /* 244 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 245 */ "like_pattern_opt ::=",
 /* 246 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 247 */ "table_name_cond ::= table_name",
 /* 248 */ "from_db_opt ::=",
 /* 249 */ "from_db_opt ::= FROM db_name",
 /* 250 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 251 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 252 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 253 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 254 */ "func_list ::= func",
 /* 255 */ "func_list ::= func_list NK_COMMA func",
 /* 256 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 257 */ "sma_stream_opt ::=",
 /* 258 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 259 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 260 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 261 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 262 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 263 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 264 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 265 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 266 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 267 */ "cmd ::= DESC full_table_name",
 /* 268 */ "cmd ::= DESCRIBE full_table_name",
 /* 269 */ "cmd ::= RESET QUERY CACHE",
 /* 270 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 271 */ "analyze_opt ::=",
 /* 272 */ "analyze_opt ::= ANALYZE",
 /* 273 */ "explain_options ::=",
 /* 274 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 275 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 276 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 277 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 278 */ "agg_func_opt ::=",
 /* 279 */ "agg_func_opt ::= AGGREGATE",
 /* 280 */ "bufsize_opt ::=",
 /* 281 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 282 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 283 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 284 */ "stream_options ::=",
 /* 285 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 286 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 287 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 288 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 289 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 290 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 291 */ "subtable_opt ::=",
 /* 292 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 293 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 294 */ "cmd ::= KILL QUERY NK_STRING",
 /* 295 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 296 */ "cmd ::= BALANCE VGROUP",
 /* 297 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 298 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 299 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 300 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 301 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 302 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 303 */ "cmd ::= query_or_subquery",
 /* 304 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 305 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 306 */ "literal ::= NK_INTEGER",
 /* 307 */ "literal ::= NK_FLOAT",
 /* 308 */ "literal ::= NK_STRING",
 /* 309 */ "literal ::= NK_BOOL",
 /* 310 */ "literal ::= TIMESTAMP NK_STRING",
 /* 311 */ "literal ::= duration_literal",
 /* 312 */ "literal ::= NULL",
 /* 313 */ "literal ::= NK_QUESTION",
 /* 314 */ "duration_literal ::= NK_VARIABLE",
 /* 315 */ "signed ::= NK_INTEGER",
 /* 316 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 317 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 318 */ "signed ::= NK_FLOAT",
 /* 319 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 320 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 321 */ "signed_literal ::= signed",
 /* 322 */ "signed_literal ::= NK_STRING",
 /* 323 */ "signed_literal ::= NK_BOOL",
 /* 324 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 325 */ "signed_literal ::= duration_literal",
 /* 326 */ "signed_literal ::= NULL",
 /* 327 */ "signed_literal ::= literal_func",
 /* 328 */ "signed_literal ::= NK_QUESTION",
 /* 329 */ "literal_list ::= signed_literal",
 /* 330 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 331 */ "db_name ::= NK_ID",
 /* 332 */ "table_name ::= NK_ID",
 /* 333 */ "column_name ::= NK_ID",
 /* 334 */ "function_name ::= NK_ID",
 /* 335 */ "table_alias ::= NK_ID",
 /* 336 */ "column_alias ::= NK_ID",
 /* 337 */ "user_name ::= NK_ID",
 /* 338 */ "topic_name ::= NK_ID",
 /* 339 */ "stream_name ::= NK_ID",
 /* 340 */ "cgroup_name ::= NK_ID",
 /* 341 */ "expr_or_subquery ::= expression",
 /* 342 */ "expr_or_subquery ::= subquery",
 /* 343 */ "expression ::= literal",
 /* 344 */ "expression ::= pseudo_column",
 /* 345 */ "expression ::= column_reference",
 /* 346 */ "expression ::= function_expression",
 /* 347 */ "expression ::= case_when_expression",
 /* 348 */ "expression ::= NK_LP expression NK_RP",
 /* 349 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 350 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 351 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 352 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 353 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 354 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 355 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 356 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 357 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 358 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 359 */ "expression_list ::= expr_or_subquery",
 /* 360 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 361 */ "column_reference ::= column_name",
 /* 362 */ "column_reference ::= table_name NK_DOT column_name",
 /* 363 */ "pseudo_column ::= ROWTS",
 /* 364 */ "pseudo_column ::= TBNAME",
 /* 365 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 366 */ "pseudo_column ::= QSTART",
 /* 367 */ "pseudo_column ::= QEND",
 /* 368 */ "pseudo_column ::= QDURATION",
 /* 369 */ "pseudo_column ::= WSTART",
 /* 370 */ "pseudo_column ::= WEND",
 /* 371 */ "pseudo_column ::= WDURATION",
 /* 372 */ "pseudo_column ::= IROWTS",
 /* 373 */ "pseudo_column ::= QTAGS",
 /* 374 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 375 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 376 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 377 */ "function_expression ::= literal_func",
 /* 378 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 379 */ "literal_func ::= NOW",
 /* 380 */ "noarg_func ::= NOW",
 /* 381 */ "noarg_func ::= TODAY",
 /* 382 */ "noarg_func ::= TIMEZONE",
 /* 383 */ "noarg_func ::= DATABASE",
 /* 384 */ "noarg_func ::= CLIENT_VERSION",
 /* 385 */ "noarg_func ::= SERVER_VERSION",
 /* 386 */ "noarg_func ::= SERVER_STATUS",
 /* 387 */ "noarg_func ::= CURRENT_USER",
 /* 388 */ "noarg_func ::= USER",
 /* 389 */ "star_func ::= COUNT",
 /* 390 */ "star_func ::= FIRST",
 /* 391 */ "star_func ::= LAST",
 /* 392 */ "star_func ::= LAST_ROW",
 /* 393 */ "star_func_para_list ::= NK_STAR",
 /* 394 */ "star_func_para_list ::= other_para_list",
 /* 395 */ "other_para_list ::= star_func_para",
 /* 396 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 397 */ "star_func_para ::= expr_or_subquery",
 /* 398 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 399 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 400 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 401 */ "when_then_list ::= when_then_expr",
 /* 402 */ "when_then_list ::= when_then_list when_then_expr",
 /* 403 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 404 */ "case_when_else_opt ::=",
 /* 405 */ "case_when_else_opt ::= ELSE common_expression",
 /* 406 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 407 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 408 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 409 */ "predicate ::= expr_or_subquery IS NULL",
 /* 410 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 411 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 412 */ "compare_op ::= NK_LT",
 /* 413 */ "compare_op ::= NK_GT",
 /* 414 */ "compare_op ::= NK_LE",
 /* 415 */ "compare_op ::= NK_GE",
 /* 416 */ "compare_op ::= NK_NE",
 /* 417 */ "compare_op ::= NK_EQ",
 /* 418 */ "compare_op ::= LIKE",
 /* 419 */ "compare_op ::= NOT LIKE",
 /* 420 */ "compare_op ::= MATCH",
 /* 421 */ "compare_op ::= NMATCH",
 /* 422 */ "compare_op ::= CONTAINS",
 /* 423 */ "in_op ::= IN",
 /* 424 */ "in_op ::= NOT IN",
 /* 425 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 426 */ "boolean_value_expression ::= boolean_primary",
 /* 427 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 428 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 429 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 430 */ "boolean_primary ::= predicate",
 /* 431 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 432 */ "common_expression ::= expr_or_subquery",
 /* 433 */ "common_expression ::= boolean_value_expression",
 /* 434 */ "from_clause_opt ::=",
 /* 435 */ "from_clause_opt ::= FROM table_reference_list",
 /* 436 */ "table_reference_list ::= table_reference",
 /* 437 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 438 */ "table_reference ::= table_primary",
 /* 439 */ "table_reference ::= joined_table",
 /* 440 */ "table_primary ::= table_name alias_opt",
 /* 441 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 442 */ "table_primary ::= subquery alias_opt",
 /* 443 */ "table_primary ::= parenthesized_joined_table",
 /* 444 */ "alias_opt ::=",
 /* 445 */ "alias_opt ::= table_alias",
 /* 446 */ "alias_opt ::= AS table_alias",
 /* 447 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 448 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 449 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 450 */ "join_type ::=",
 /* 451 */ "join_type ::= INNER",
 /* 452 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 453 */ "set_quantifier_opt ::=",
 /* 454 */ "set_quantifier_opt ::= DISTINCT",
 /* 455 */ "set_quantifier_opt ::= ALL",
 /* 456 */ "select_list ::= select_item",
 /* 457 */ "select_list ::= select_list NK_COMMA select_item",
 /* 458 */ "select_item ::= NK_STAR",
 /* 459 */ "select_item ::= common_expression",
 /* 460 */ "select_item ::= common_expression column_alias",
 /* 461 */ "select_item ::= common_expression AS column_alias",
 /* 462 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 463 */ "where_clause_opt ::=",
 /* 464 */ "where_clause_opt ::= WHERE search_condition",
 /* 465 */ "partition_by_clause_opt ::=",
 /* 466 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 467 */ "partition_list ::= partition_item",
 /* 468 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 469 */ "partition_item ::= expr_or_subquery",
 /* 470 */ "partition_item ::= expr_or_subquery column_alias",
 /* 471 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 472 */ "twindow_clause_opt ::=",
 /* 473 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 474 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 475 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 476 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 477 */ "sliding_opt ::=",
 /* 478 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 479 */ "fill_opt ::=",
 /* 480 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 481 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 482 */ "fill_mode ::= NONE",
 /* 483 */ "fill_mode ::= PREV",
 /* 484 */ "fill_mode ::= NULL",
 /* 485 */ "fill_mode ::= LINEAR",
 /* 486 */ "fill_mode ::= NEXT",
 /* 487 */ "group_by_clause_opt ::=",
 /* 488 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 489 */ "group_by_list ::= expr_or_subquery",
 /* 490 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 491 */ "having_clause_opt ::=",
 /* 492 */ "having_clause_opt ::= HAVING search_condition",
 /* 493 */ "range_opt ::=",
 /* 494 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 495 */ "every_opt ::=",
 /* 496 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 497 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 498 */ "query_simple ::= query_specification",
 /* 499 */ "query_simple ::= union_query_expression",
 /* 500 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 501 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 502 */ "query_simple_or_subquery ::= query_simple",
 /* 503 */ "query_simple_or_subquery ::= subquery",
 /* 504 */ "query_or_subquery ::= query_expression",
 /* 505 */ "query_or_subquery ::= subquery",
 /* 506 */ "order_by_clause_opt ::=",
 /* 507 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 508 */ "slimit_clause_opt ::=",
 /* 509 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 510 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 511 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 512 */ "limit_clause_opt ::=",
 /* 513 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 514 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 515 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 516 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 517 */ "subquery ::= NK_LP subquery NK_RP",
 /* 518 */ "search_condition ::= common_expression",
 /* 519 */ "sort_specification_list ::= sort_specification",
 /* 520 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 521 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 522 */ "ordering_specification_opt ::=",
 /* 523 */ "ordering_specification_opt ::= ASC",
 /* 524 */ "ordering_specification_opt ::= DESC",
 /* 525 */ "null_ordering_opt ::=",
 /* 526 */ "null_ordering_opt ::= NULLS FIRST",
 /* 527 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 319: /* cmd */
    case 322: /* literal */
    case 334: /* db_options */
    case 336: /* alter_db_options */
    case 342: /* retention */
    case 343: /* full_table_name */
    case 346: /* table_options */
    case 350: /* alter_table_clause */
    case 351: /* alter_table_options */
    case 354: /* signed_literal */
    case 355: /* create_subtable_clause */
    case 358: /* drop_table_clause */
    case 361: /* column_def */
    case 365: /* duration_literal */
    case 366: /* rollup_func_name */
    case 368: /* col_name */
    case 369: /* db_name_cond_opt */
    case 370: /* like_pattern_opt */
    case 371: /* table_name_cond */
    case 372: /* from_db_opt */
    case 373: /* index_options */
    case 375: /* sliding_opt */
    case 376: /* sma_stream_opt */
    case 377: /* func */
    case 378: /* stream_options */
    case 380: /* query_or_subquery */
    case 383: /* explain_options */
    case 387: /* subtable_opt */
    case 388: /* expression */
    case 390: /* where_clause_opt */
    case 391: /* signed */
    case 392: /* literal_func */
    case 396: /* expr_or_subquery */
    case 397: /* subquery */
    case 398: /* pseudo_column */
    case 399: /* column_reference */
    case 400: /* function_expression */
    case 401: /* case_when_expression */
    case 406: /* star_func_para */
    case 408: /* case_when_else_opt */
    case 409: /* common_expression */
    case 410: /* when_then_expr */
    case 411: /* predicate */
    case 414: /* in_predicate_value */
    case 415: /* boolean_value_expression */
    case 416: /* boolean_primary */
    case 417: /* from_clause_opt */
    case 418: /* table_reference_list */
    case 419: /* table_reference */
    case 420: /* table_primary */
    case 421: /* joined_table */
    case 423: /* parenthesized_joined_table */
    case 425: /* search_condition */
    case 426: /* query_specification */
    case 430: /* range_opt */
    case 431: /* every_opt */
    case 432: /* fill_opt */
    case 433: /* twindow_clause_opt */
    case 435: /* having_clause_opt */
    case 436: /* select_item */
    case 438: /* partition_item */
    case 441: /* query_expression */
    case 442: /* query_simple */
    case 444: /* slimit_clause_opt */
    case 445: /* limit_clause_opt */
    case 446: /* union_query_expression */
    case 447: /* query_simple_or_subquery */
    case 449: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy232)); 
}
      break;
    case 320: /* account_options */
    case 321: /* alter_account_options */
    case 323: /* alter_account_option */
    case 337: /* speed_opt */
    case 385: /* bufsize_opt */
{
 
}
      break;
    case 324: /* user_name */
    case 327: /* priv_level */
    case 330: /* db_name */
    case 331: /* dnode_endpoint */
    case 352: /* column_name */
    case 360: /* table_name */
    case 367: /* function_name */
    case 379: /* topic_name */
    case 381: /* cgroup_name */
    case 386: /* stream_name */
    case 394: /* table_alias */
    case 395: /* column_alias */
    case 402: /* star_func */
    case 404: /* noarg_func */
    case 422: /* alias_opt */
{
 
}
      break;
    case 325: /* sysinfo_opt */
{
 
}
      break;
    case 326: /* privileges */
    case 328: /* priv_type_list */
    case 329: /* priv_type */
{
 
}
      break;
    case 332: /* force_opt */
    case 333: /* not_exists_opt */
    case 335: /* exists_opt */
    case 382: /* analyze_opt */
    case 384: /* agg_func_opt */
    case 427: /* set_quantifier_opt */
{
 
}
      break;
    case 338: /* integer_list */
    case 339: /* variable_list */
    case 340: /* retention_list */
    case 344: /* column_def_list */
    case 345: /* tags_def_opt */
    case 347: /* multi_create_clause */
    case 348: /* tags_def */
    case 349: /* multi_drop_clause */
    case 356: /* specific_cols_opt */
    case 357: /* expression_list */
    case 359: /* col_name_list */
    case 362: /* duration_list */
    case 363: /* rollup_func_list */
    case 374: /* func_list */
    case 389: /* dnode_list */
    case 393: /* literal_list */
    case 403: /* star_func_para_list */
    case 405: /* other_para_list */
    case 407: /* when_then_list */
    case 428: /* select_list */
    case 429: /* partition_by_clause_opt */
    case 434: /* group_by_clause_opt */
    case 437: /* partition_list */
    case 440: /* group_by_list */
    case 443: /* order_by_clause_opt */
    case 448: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy288)); 
}
      break;
    case 341: /* alter_db_option */
    case 364: /* alter_table_option */
{
 
}
      break;
    case 353: /* type_name */
{
 
}
      break;
    case 412: /* compare_op */
    case 413: /* in_op */
{
 
}
      break;
    case 424: /* join_type */
{
 
}
      break;
    case 439: /* fill_mode */
{
 
}
      break;
    case 450: /* ordering_specification_opt */
{
 
}
      break;
    case 451: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  319,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  319,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  320,    0 }, /* (2) account_options ::= */
  {  320,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  320,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  320,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  320,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  320,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  320,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  320,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  320,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  320,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  321,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  321,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  323,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  323,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  323,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  323,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  323,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  323,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  323,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  323,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  323,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  323,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  319,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  319,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  319,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  319,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  319,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  325,    0 }, /* (29) sysinfo_opt ::= */
  {  325,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  319,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  319,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  326,   -1 }, /* (33) privileges ::= ALL */
  {  326,   -1 }, /* (34) privileges ::= priv_type_list */
  {  328,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  328,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  329,   -1 }, /* (37) priv_type ::= READ */
  {  329,   -1 }, /* (38) priv_type ::= WRITE */
  {  327,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  327,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  319,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  319,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  319,   -4 }, /* (43) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  319,   -4 }, /* (44) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  319,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  319,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  319,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  319,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  331,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  331,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  331,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  332,    0 }, /* (52) force_opt ::= */
  {  332,   -1 }, /* (53) force_opt ::= FORCE */
  {  319,   -3 }, /* (54) cmd ::= ALTER LOCAL NK_STRING */
  {  319,   -4 }, /* (55) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  319,   -5 }, /* (56) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (57) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (58) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (59) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (60) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (61) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (62) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (63) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (64) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  319,   -4 }, /* (65) cmd ::= DROP DATABASE exists_opt db_name */
  {  319,   -2 }, /* (66) cmd ::= USE db_name */
  {  319,   -4 }, /* (67) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  319,   -3 }, /* (68) cmd ::= FLUSH DATABASE db_name */
  {  319,   -4 }, /* (69) cmd ::= TRIM DATABASE db_name speed_opt */
  {  333,   -3 }, /* (70) not_exists_opt ::= IF NOT EXISTS */
  {  333,    0 }, /* (71) not_exists_opt ::= */
  {  335,   -2 }, /* (72) exists_opt ::= IF EXISTS */
  {  335,    0 }, /* (73) exists_opt ::= */
  {  334,    0 }, /* (74) db_options ::= */
  {  334,   -3 }, /* (75) db_options ::= db_options BUFFER NK_INTEGER */
  {  334,   -3 }, /* (76) db_options ::= db_options CACHEMODEL NK_STRING */
  {  334,   -3 }, /* (77) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  334,   -3 }, /* (78) db_options ::= db_options COMP NK_INTEGER */
  {  334,   -3 }, /* (79) db_options ::= db_options DURATION NK_INTEGER */
  {  334,   -3 }, /* (80) db_options ::= db_options DURATION NK_VARIABLE */
  {  334,   -3 }, /* (81) db_options ::= db_options MAXROWS NK_INTEGER */
  {  334,   -3 }, /* (82) db_options ::= db_options MINROWS NK_INTEGER */
  {  334,   -3 }, /* (83) db_options ::= db_options KEEP integer_list */
  {  334,   -3 }, /* (84) db_options ::= db_options KEEP variable_list */
  {  334,   -3 }, /* (85) db_options ::= db_options PAGES NK_INTEGER */
  {  334,   -3 }, /* (86) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  334,   -3 }, /* (87) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  334,   -3 }, /* (88) db_options ::= db_options PRECISION NK_STRING */
  {  334,   -3 }, /* (89) db_options ::= db_options REPLICA NK_INTEGER */
  {  334,   -3 }, /* (90) db_options ::= db_options STRICT NK_STRING */
  {  334,   -3 }, /* (91) db_options ::= db_options VGROUPS NK_INTEGER */
  {  334,   -3 }, /* (92) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  334,   -3 }, /* (93) db_options ::= db_options RETENTIONS retention_list */
  {  334,   -3 }, /* (94) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  334,   -3 }, /* (95) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  334,   -3 }, /* (96) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  334,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  334,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  334,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  334,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  334,   -3 }, /* (101) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  334,   -3 }, /* (102) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  334,   -3 }, /* (103) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  334,   -3 }, /* (104) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  334,   -3 }, /* (105) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  336,   -1 }, /* (106) alter_db_options ::= alter_db_option */
  {  336,   -2 }, /* (107) alter_db_options ::= alter_db_options alter_db_option */
  {  341,   -2 }, /* (108) alter_db_option ::= BUFFER NK_INTEGER */
  {  341,   -2 }, /* (109) alter_db_option ::= CACHEMODEL NK_STRING */
  {  341,   -2 }, /* (110) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  341,   -2 }, /* (111) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  341,   -2 }, /* (112) alter_db_option ::= KEEP integer_list */
  {  341,   -2 }, /* (113) alter_db_option ::= KEEP variable_list */
  {  341,   -2 }, /* (114) alter_db_option ::= PAGES NK_INTEGER */
  {  341,   -2 }, /* (115) alter_db_option ::= REPLICA NK_INTEGER */
  {  341,   -2 }, /* (116) alter_db_option ::= STRICT NK_STRING */
  {  341,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  341,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  338,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  338,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  339,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  339,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  340,   -1 }, /* (123) retention_list ::= retention */
  {  340,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  342,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  337,    0 }, /* (126) speed_opt ::= */
  {  337,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  319,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  319,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  319,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  319,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  319,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  319,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  319,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  350,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  350,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  350,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  350,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  350,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  350,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  350,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  350,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  350,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  350,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  347,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  347,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  355,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  349,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  349,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  358,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  356,    0 }, /* (151) specific_cols_opt ::= */
  {  356,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  343,   -1 }, /* (153) full_table_name ::= table_name */
  {  343,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  344,   -1 }, /* (155) column_def_list ::= column_def */
  {  344,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  361,   -2 }, /* (157) column_def ::= column_name type_name */
  {  361,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  353,   -1 }, /* (159) type_name ::= BOOL */
  {  353,   -1 }, /* (160) type_name ::= TINYINT */
  {  353,   -1 }, /* (161) type_name ::= SMALLINT */
  {  353,   -1 }, /* (162) type_name ::= INT */
  {  353,   -1 }, /* (163) type_name ::= INTEGER */
  {  353,   -1 }, /* (164) type_name ::= BIGINT */
  {  353,   -1 }, /* (165) type_name ::= FLOAT */
  {  353,   -1 }, /* (166) type_name ::= DOUBLE */
  {  353,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  353,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  353,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  353,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  353,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  353,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  353,   -1 }, /* (174) type_name ::= JSON */
  {  353,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  353,   -1 }, /* (177) type_name ::= BLOB */
  {  353,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (179) type_name ::= DECIMAL */
  {  353,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  353,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  345,    0 }, /* (182) tags_def_opt ::= */
  {  345,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  348,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  346,    0 }, /* (185) table_options ::= */
  {  346,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  346,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  346,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  346,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  346,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  346,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (192) alter_table_options ::= alter_table_option */
  {  351,   -2 }, /* (193) alter_table_options ::= alter_table_options alter_table_option */
  {  364,   -2 }, /* (194) alter_table_option ::= COMMENT NK_STRING */
  {  364,   -2 }, /* (195) alter_table_option ::= TTL NK_INTEGER */
  {  362,   -1 }, /* (196) duration_list ::= duration_literal */
  {  362,   -3 }, /* (197) duration_list ::= duration_list NK_COMMA duration_literal */
  {  363,   -1 }, /* (198) rollup_func_list ::= rollup_func_name */
  {  363,   -3 }, /* (199) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  366,   -1 }, /* (200) rollup_func_name ::= function_name */
  {  366,   -1 }, /* (201) rollup_func_name ::= FIRST */
  {  366,   -1 }, /* (202) rollup_func_name ::= LAST */
  {  359,   -1 }, /* (203) col_name_list ::= col_name */
  {  359,   -3 }, /* (204) col_name_list ::= col_name_list NK_COMMA col_name */
  {  368,   -1 }, /* (205) col_name ::= column_name */
  {  319,   -2 }, /* (206) cmd ::= SHOW DNODES */
  {  319,   -2 }, /* (207) cmd ::= SHOW USERS */
  {  319,   -2 }, /* (208) cmd ::= SHOW DATABASES */
  {  319,   -4 }, /* (209) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  319,   -4 }, /* (210) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  319,   -3 }, /* (211) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  319,   -2 }, /* (212) cmd ::= SHOW MNODES */
  {  319,   -2 }, /* (213) cmd ::= SHOW QNODES */
  {  319,   -2 }, /* (214) cmd ::= SHOW FUNCTIONS */
  {  319,   -5 }, /* (215) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  319,   -2 }, /* (216) cmd ::= SHOW STREAMS */
  {  319,   -2 }, /* (217) cmd ::= SHOW ACCOUNTS */
  {  319,   -2 }, /* (218) cmd ::= SHOW APPS */
  {  319,   -2 }, /* (219) cmd ::= SHOW CONNECTIONS */
  {  319,   -2 }, /* (220) cmd ::= SHOW LICENCES */
  {  319,   -2 }, /* (221) cmd ::= SHOW GRANTS */
  {  319,   -4 }, /* (222) cmd ::= SHOW CREATE DATABASE db_name */
  {  319,   -4 }, /* (223) cmd ::= SHOW CREATE TABLE full_table_name */
  {  319,   -4 }, /* (224) cmd ::= SHOW CREATE STABLE full_table_name */
  {  319,   -2 }, /* (225) cmd ::= SHOW QUERIES */
  {  319,   -2 }, /* (226) cmd ::= SHOW SCORES */
  {  319,   -2 }, /* (227) cmd ::= SHOW TOPICS */
  {  319,   -2 }, /* (228) cmd ::= SHOW VARIABLES */
  {  319,   -3 }, /* (229) cmd ::= SHOW CLUSTER VARIABLES */
  {  319,   -3 }, /* (230) cmd ::= SHOW LOCAL VARIABLES */
  {  319,   -5 }, /* (231) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  319,   -2 }, /* (232) cmd ::= SHOW BNODES */
  {  319,   -2 }, /* (233) cmd ::= SHOW SNODES */
  {  319,   -2 }, /* (234) cmd ::= SHOW CLUSTER */
  {  319,   -2 }, /* (235) cmd ::= SHOW TRANSACTIONS */
  {  319,   -4 }, /* (236) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  319,   -2 }, /* (237) cmd ::= SHOW CONSUMERS */
  {  319,   -2 }, /* (238) cmd ::= SHOW SUBSCRIPTIONS */
  {  319,   -5 }, /* (239) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  319,   -6 }, /* (240) cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
  {  319,   -3 }, /* (241) cmd ::= SHOW VNODES NK_INTEGER */
  {  319,   -3 }, /* (242) cmd ::= SHOW VNODES NK_STRING */
  {  369,    0 }, /* (243) db_name_cond_opt ::= */
  {  369,   -2 }, /* (244) db_name_cond_opt ::= db_name NK_DOT */
  {  370,    0 }, /* (245) like_pattern_opt ::= */
  {  370,   -2 }, /* (246) like_pattern_opt ::= LIKE NK_STRING */
  {  371,   -1 }, /* (247) table_name_cond ::= table_name */
  {  372,    0 }, /* (248) from_db_opt ::= */
  {  372,   -2 }, /* (249) from_db_opt ::= FROM db_name */
  {  319,   -8 }, /* (250) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  319,   -4 }, /* (251) cmd ::= DROP INDEX exists_opt full_table_name */
  {  373,  -10 }, /* (252) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  373,  -12 }, /* (253) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  374,   -1 }, /* (254) func_list ::= func */
  {  374,   -3 }, /* (255) func_list ::= func_list NK_COMMA func */
  {  377,   -4 }, /* (256) func ::= function_name NK_LP expression_list NK_RP */
  {  376,    0 }, /* (257) sma_stream_opt ::= */
  {  376,   -3 }, /* (258) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  376,   -3 }, /* (259) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  319,   -6 }, /* (260) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  319,   -7 }, /* (261) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  319,   -9 }, /* (262) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  319,   -7 }, /* (263) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  319,   -9 }, /* (264) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  319,   -4 }, /* (265) cmd ::= DROP TOPIC exists_opt topic_name */
  {  319,   -7 }, /* (266) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  319,   -2 }, /* (267) cmd ::= DESC full_table_name */
  {  319,   -2 }, /* (268) cmd ::= DESCRIBE full_table_name */
  {  319,   -3 }, /* (269) cmd ::= RESET QUERY CACHE */
  {  319,   -4 }, /* (270) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  382,    0 }, /* (271) analyze_opt ::= */
  {  382,   -1 }, /* (272) analyze_opt ::= ANALYZE */
  {  383,    0 }, /* (273) explain_options ::= */
  {  383,   -3 }, /* (274) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  383,   -3 }, /* (275) explain_options ::= explain_options RATIO NK_FLOAT */
  {  319,  -10 }, /* (276) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  319,   -4 }, /* (277) cmd ::= DROP FUNCTION exists_opt function_name */
  {  384,    0 }, /* (278) agg_func_opt ::= */
  {  384,   -1 }, /* (279) agg_func_opt ::= AGGREGATE */
  {  385,    0 }, /* (280) bufsize_opt ::= */
  {  385,   -2 }, /* (281) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  319,  -11 }, /* (282) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  319,   -4 }, /* (283) cmd ::= DROP STREAM exists_opt stream_name */
  {  378,    0 }, /* (284) stream_options ::= */
  {  378,   -3 }, /* (285) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  378,   -3 }, /* (286) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  378,   -4 }, /* (287) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  378,   -3 }, /* (288) stream_options ::= stream_options WATERMARK duration_literal */
  {  378,   -4 }, /* (289) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  378,   -3 }, /* (290) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  387,    0 }, /* (291) subtable_opt ::= */
  {  387,   -4 }, /* (292) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  319,   -3 }, /* (293) cmd ::= KILL CONNECTION NK_INTEGER */
  {  319,   -3 }, /* (294) cmd ::= KILL QUERY NK_STRING */
  {  319,   -3 }, /* (295) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  319,   -2 }, /* (296) cmd ::= BALANCE VGROUP */
  {  319,   -4 }, /* (297) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  319,   -4 }, /* (298) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  319,   -3 }, /* (299) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  389,   -2 }, /* (300) dnode_list ::= DNODE NK_INTEGER */
  {  389,   -3 }, /* (301) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  319,   -4 }, /* (302) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  319,   -1 }, /* (303) cmd ::= query_or_subquery */
  {  319,   -7 }, /* (304) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  319,   -4 }, /* (305) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  322,   -1 }, /* (306) literal ::= NK_INTEGER */
  {  322,   -1 }, /* (307) literal ::= NK_FLOAT */
  {  322,   -1 }, /* (308) literal ::= NK_STRING */
  {  322,   -1 }, /* (309) literal ::= NK_BOOL */
  {  322,   -2 }, /* (310) literal ::= TIMESTAMP NK_STRING */
  {  322,   -1 }, /* (311) literal ::= duration_literal */
  {  322,   -1 }, /* (312) literal ::= NULL */
  {  322,   -1 }, /* (313) literal ::= NK_QUESTION */
  {  365,   -1 }, /* (314) duration_literal ::= NK_VARIABLE */
  {  391,   -1 }, /* (315) signed ::= NK_INTEGER */
  {  391,   -2 }, /* (316) signed ::= NK_PLUS NK_INTEGER */
  {  391,   -2 }, /* (317) signed ::= NK_MINUS NK_INTEGER */
  {  391,   -1 }, /* (318) signed ::= NK_FLOAT */
  {  391,   -2 }, /* (319) signed ::= NK_PLUS NK_FLOAT */
  {  391,   -2 }, /* (320) signed ::= NK_MINUS NK_FLOAT */
  {  354,   -1 }, /* (321) signed_literal ::= signed */
  {  354,   -1 }, /* (322) signed_literal ::= NK_STRING */
  {  354,   -1 }, /* (323) signed_literal ::= NK_BOOL */
  {  354,   -2 }, /* (324) signed_literal ::= TIMESTAMP NK_STRING */
  {  354,   -1 }, /* (325) signed_literal ::= duration_literal */
  {  354,   -1 }, /* (326) signed_literal ::= NULL */
  {  354,   -1 }, /* (327) signed_literal ::= literal_func */
  {  354,   -1 }, /* (328) signed_literal ::= NK_QUESTION */
  {  393,   -1 }, /* (329) literal_list ::= signed_literal */
  {  393,   -3 }, /* (330) literal_list ::= literal_list NK_COMMA signed_literal */
  {  330,   -1 }, /* (331) db_name ::= NK_ID */
  {  360,   -1 }, /* (332) table_name ::= NK_ID */
  {  352,   -1 }, /* (333) column_name ::= NK_ID */
  {  367,   -1 }, /* (334) function_name ::= NK_ID */
  {  394,   -1 }, /* (335) table_alias ::= NK_ID */
  {  395,   -1 }, /* (336) column_alias ::= NK_ID */
  {  324,   -1 }, /* (337) user_name ::= NK_ID */
  {  379,   -1 }, /* (338) topic_name ::= NK_ID */
  {  386,   -1 }, /* (339) stream_name ::= NK_ID */
  {  381,   -1 }, /* (340) cgroup_name ::= NK_ID */
  {  396,   -1 }, /* (341) expr_or_subquery ::= expression */
  {  396,   -1 }, /* (342) expr_or_subquery ::= subquery */
  {  388,   -1 }, /* (343) expression ::= literal */
  {  388,   -1 }, /* (344) expression ::= pseudo_column */
  {  388,   -1 }, /* (345) expression ::= column_reference */
  {  388,   -1 }, /* (346) expression ::= function_expression */
  {  388,   -1 }, /* (347) expression ::= case_when_expression */
  {  388,   -3 }, /* (348) expression ::= NK_LP expression NK_RP */
  {  388,   -2 }, /* (349) expression ::= NK_PLUS expr_or_subquery */
  {  388,   -2 }, /* (350) expression ::= NK_MINUS expr_or_subquery */
  {  388,   -3 }, /* (351) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  388,   -3 }, /* (352) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  388,   -3 }, /* (353) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  388,   -3 }, /* (354) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  388,   -3 }, /* (355) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  388,   -3 }, /* (356) expression ::= column_reference NK_ARROW NK_STRING */
  {  388,   -3 }, /* (357) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  388,   -3 }, /* (358) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  357,   -1 }, /* (359) expression_list ::= expr_or_subquery */
  {  357,   -3 }, /* (360) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  399,   -1 }, /* (361) column_reference ::= column_name */
  {  399,   -3 }, /* (362) column_reference ::= table_name NK_DOT column_name */
  {  398,   -1 }, /* (363) pseudo_column ::= ROWTS */
  {  398,   -1 }, /* (364) pseudo_column ::= TBNAME */
  {  398,   -3 }, /* (365) pseudo_column ::= table_name NK_DOT TBNAME */
  {  398,   -1 }, /* (366) pseudo_column ::= QSTART */
  {  398,   -1 }, /* (367) pseudo_column ::= QEND */
  {  398,   -1 }, /* (368) pseudo_column ::= QDURATION */
  {  398,   -1 }, /* (369) pseudo_column ::= WSTART */
  {  398,   -1 }, /* (370) pseudo_column ::= WEND */
  {  398,   -1 }, /* (371) pseudo_column ::= WDURATION */
  {  398,   -1 }, /* (372) pseudo_column ::= IROWTS */
  {  398,   -1 }, /* (373) pseudo_column ::= QTAGS */
  {  400,   -4 }, /* (374) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  400,   -4 }, /* (375) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  400,   -6 }, /* (376) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  400,   -1 }, /* (377) function_expression ::= literal_func */
  {  392,   -3 }, /* (378) literal_func ::= noarg_func NK_LP NK_RP */
  {  392,   -1 }, /* (379) literal_func ::= NOW */
  {  404,   -1 }, /* (380) noarg_func ::= NOW */
  {  404,   -1 }, /* (381) noarg_func ::= TODAY */
  {  404,   -1 }, /* (382) noarg_func ::= TIMEZONE */
  {  404,   -1 }, /* (383) noarg_func ::= DATABASE */
  {  404,   -1 }, /* (384) noarg_func ::= CLIENT_VERSION */
  {  404,   -1 }, /* (385) noarg_func ::= SERVER_VERSION */
  {  404,   -1 }, /* (386) noarg_func ::= SERVER_STATUS */
  {  404,   -1 }, /* (387) noarg_func ::= CURRENT_USER */
  {  404,   -1 }, /* (388) noarg_func ::= USER */
  {  402,   -1 }, /* (389) star_func ::= COUNT */
  {  402,   -1 }, /* (390) star_func ::= FIRST */
  {  402,   -1 }, /* (391) star_func ::= LAST */
  {  402,   -1 }, /* (392) star_func ::= LAST_ROW */
  {  403,   -1 }, /* (393) star_func_para_list ::= NK_STAR */
  {  403,   -1 }, /* (394) star_func_para_list ::= other_para_list */
  {  405,   -1 }, /* (395) other_para_list ::= star_func_para */
  {  405,   -3 }, /* (396) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  406,   -1 }, /* (397) star_func_para ::= expr_or_subquery */
  {  406,   -3 }, /* (398) star_func_para ::= table_name NK_DOT NK_STAR */
  {  401,   -4 }, /* (399) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  401,   -5 }, /* (400) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  407,   -1 }, /* (401) when_then_list ::= when_then_expr */
  {  407,   -2 }, /* (402) when_then_list ::= when_then_list when_then_expr */
  {  410,   -4 }, /* (403) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  408,    0 }, /* (404) case_when_else_opt ::= */
  {  408,   -2 }, /* (405) case_when_else_opt ::= ELSE common_expression */
  {  411,   -3 }, /* (406) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  411,   -5 }, /* (407) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  411,   -6 }, /* (408) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  411,   -3 }, /* (409) predicate ::= expr_or_subquery IS NULL */
  {  411,   -4 }, /* (410) predicate ::= expr_or_subquery IS NOT NULL */
  {  411,   -3 }, /* (411) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  412,   -1 }, /* (412) compare_op ::= NK_LT */
  {  412,   -1 }, /* (413) compare_op ::= NK_GT */
  {  412,   -1 }, /* (414) compare_op ::= NK_LE */
  {  412,   -1 }, /* (415) compare_op ::= NK_GE */
  {  412,   -1 }, /* (416) compare_op ::= NK_NE */
  {  412,   -1 }, /* (417) compare_op ::= NK_EQ */
  {  412,   -1 }, /* (418) compare_op ::= LIKE */
  {  412,   -2 }, /* (419) compare_op ::= NOT LIKE */
  {  412,   -1 }, /* (420) compare_op ::= MATCH */
  {  412,   -1 }, /* (421) compare_op ::= NMATCH */
  {  412,   -1 }, /* (422) compare_op ::= CONTAINS */
  {  413,   -1 }, /* (423) in_op ::= IN */
  {  413,   -2 }, /* (424) in_op ::= NOT IN */
  {  414,   -3 }, /* (425) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  415,   -1 }, /* (426) boolean_value_expression ::= boolean_primary */
  {  415,   -2 }, /* (427) boolean_value_expression ::= NOT boolean_primary */
  {  415,   -3 }, /* (428) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  415,   -3 }, /* (429) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  416,   -1 }, /* (430) boolean_primary ::= predicate */
  {  416,   -3 }, /* (431) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  409,   -1 }, /* (432) common_expression ::= expr_or_subquery */
  {  409,   -1 }, /* (433) common_expression ::= boolean_value_expression */
  {  417,    0 }, /* (434) from_clause_opt ::= */
  {  417,   -2 }, /* (435) from_clause_opt ::= FROM table_reference_list */
  {  418,   -1 }, /* (436) table_reference_list ::= table_reference */
  {  418,   -3 }, /* (437) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  419,   -1 }, /* (438) table_reference ::= table_primary */
  {  419,   -1 }, /* (439) table_reference ::= joined_table */
  {  420,   -2 }, /* (440) table_primary ::= table_name alias_opt */
  {  420,   -4 }, /* (441) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  420,   -2 }, /* (442) table_primary ::= subquery alias_opt */
  {  420,   -1 }, /* (443) table_primary ::= parenthesized_joined_table */
  {  422,    0 }, /* (444) alias_opt ::= */
  {  422,   -1 }, /* (445) alias_opt ::= table_alias */
  {  422,   -2 }, /* (446) alias_opt ::= AS table_alias */
  {  423,   -3 }, /* (447) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  423,   -3 }, /* (448) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  421,   -6 }, /* (449) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  424,    0 }, /* (450) join_type ::= */
  {  424,   -1 }, /* (451) join_type ::= INNER */
  {  426,  -12 }, /* (452) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  427,    0 }, /* (453) set_quantifier_opt ::= */
  {  427,   -1 }, /* (454) set_quantifier_opt ::= DISTINCT */
  {  427,   -1 }, /* (455) set_quantifier_opt ::= ALL */
  {  428,   -1 }, /* (456) select_list ::= select_item */
  {  428,   -3 }, /* (457) select_list ::= select_list NK_COMMA select_item */
  {  436,   -1 }, /* (458) select_item ::= NK_STAR */
  {  436,   -1 }, /* (459) select_item ::= common_expression */
  {  436,   -2 }, /* (460) select_item ::= common_expression column_alias */
  {  436,   -3 }, /* (461) select_item ::= common_expression AS column_alias */
  {  436,   -3 }, /* (462) select_item ::= table_name NK_DOT NK_STAR */
  {  390,    0 }, /* (463) where_clause_opt ::= */
  {  390,   -2 }, /* (464) where_clause_opt ::= WHERE search_condition */
  {  429,    0 }, /* (465) partition_by_clause_opt ::= */
  {  429,   -3 }, /* (466) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  437,   -1 }, /* (467) partition_list ::= partition_item */
  {  437,   -3 }, /* (468) partition_list ::= partition_list NK_COMMA partition_item */
  {  438,   -1 }, /* (469) partition_item ::= expr_or_subquery */
  {  438,   -2 }, /* (470) partition_item ::= expr_or_subquery column_alias */
  {  438,   -3 }, /* (471) partition_item ::= expr_or_subquery AS column_alias */
  {  433,    0 }, /* (472) twindow_clause_opt ::= */
  {  433,   -6 }, /* (473) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  433,   -4 }, /* (474) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  433,   -6 }, /* (475) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  433,   -8 }, /* (476) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  375,    0 }, /* (477) sliding_opt ::= */
  {  375,   -4 }, /* (478) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  432,    0 }, /* (479) fill_opt ::= */
  {  432,   -4 }, /* (480) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  432,   -6 }, /* (481) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  439,   -1 }, /* (482) fill_mode ::= NONE */
  {  439,   -1 }, /* (483) fill_mode ::= PREV */
  {  439,   -1 }, /* (484) fill_mode ::= NULL */
  {  439,   -1 }, /* (485) fill_mode ::= LINEAR */
  {  439,   -1 }, /* (486) fill_mode ::= NEXT */
  {  434,    0 }, /* (487) group_by_clause_opt ::= */
  {  434,   -3 }, /* (488) group_by_clause_opt ::= GROUP BY group_by_list */
  {  440,   -1 }, /* (489) group_by_list ::= expr_or_subquery */
  {  440,   -3 }, /* (490) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  435,    0 }, /* (491) having_clause_opt ::= */
  {  435,   -2 }, /* (492) having_clause_opt ::= HAVING search_condition */
  {  430,    0 }, /* (493) range_opt ::= */
  {  430,   -6 }, /* (494) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  431,    0 }, /* (495) every_opt ::= */
  {  431,   -4 }, /* (496) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  441,   -4 }, /* (497) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  442,   -1 }, /* (498) query_simple ::= query_specification */
  {  442,   -1 }, /* (499) query_simple ::= union_query_expression */
  {  446,   -4 }, /* (500) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  446,   -3 }, /* (501) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  447,   -1 }, /* (502) query_simple_or_subquery ::= query_simple */
  {  447,   -1 }, /* (503) query_simple_or_subquery ::= subquery */
  {  380,   -1 }, /* (504) query_or_subquery ::= query_expression */
  {  380,   -1 }, /* (505) query_or_subquery ::= subquery */
  {  443,    0 }, /* (506) order_by_clause_opt ::= */
  {  443,   -3 }, /* (507) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  444,    0 }, /* (508) slimit_clause_opt ::= */
  {  444,   -2 }, /* (509) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  444,   -4 }, /* (510) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  444,   -4 }, /* (511) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  445,    0 }, /* (512) limit_clause_opt ::= */
  {  445,   -2 }, /* (513) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  445,   -4 }, /* (514) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  445,   -4 }, /* (515) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  397,   -3 }, /* (516) subquery ::= NK_LP query_expression NK_RP */
  {  397,   -3 }, /* (517) subquery ::= NK_LP subquery NK_RP */
  {  425,   -1 }, /* (518) search_condition ::= common_expression */
  {  448,   -1 }, /* (519) sort_specification_list ::= sort_specification */
  {  448,   -3 }, /* (520) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  449,   -3 }, /* (521) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  450,    0 }, /* (522) ordering_specification_opt ::= */
  {  450,   -1 }, /* (523) ordering_specification_opt ::= ASC */
  {  450,   -1 }, /* (524) ordering_specification_opt ::= DESC */
  {  451,    0 }, /* (525) null_ordering_opt ::= */
  {  451,   -2 }, /* (526) null_ordering_opt ::= NULLS FIRST */
  {  451,   -2 }, /* (527) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,321,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,320,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,322,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,323,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,323,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,322,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy481, &yymsp[-1].minor.yy0, yymsp[0].minor.yy607); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy481, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy481, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy481, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy481); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy607 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy607 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy37, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy481); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy37, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy481); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy37 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy37 = yymsp[0].minor.yy37; }
  yymsp[0].minor.yy37 = yylhsminor.yy37;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy37 = yymsp[-2].minor.yy37 | yymsp[0].minor.yy37; }
  yymsp[-2].minor.yy37 = yylhsminor.yy37;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy37 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy37 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy481 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy481 = yylhsminor.yy481;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy481 = yymsp[-2].minor.yy481; }
  yymsp[-2].minor.yy481 = yylhsminor.yy481;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy481, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy777); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy481, yymsp[0].minor.yy777); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 331: /* db_name ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* table_name ::= NK_ID */ yytestcase(yyruleno==332);
      case 333: /* column_name ::= NK_ID */ yytestcase(yyruleno==333);
      case 334: /* function_name ::= NK_ID */ yytestcase(yyruleno==334);
      case 335: /* table_alias ::= NK_ID */ yytestcase(yyruleno==335);
      case 336: /* column_alias ::= NK_ID */ yytestcase(yyruleno==336);
      case 337: /* user_name ::= NK_ID */ yytestcase(yyruleno==337);
      case 338: /* topic_name ::= NK_ID */ yytestcase(yyruleno==338);
      case 339: /* stream_name ::= NK_ID */ yytestcase(yyruleno==339);
      case 340: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==340);
      case 380: /* noarg_func ::= NOW */ yytestcase(yyruleno==380);
      case 381: /* noarg_func ::= TODAY */ yytestcase(yyruleno==381);
      case 382: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==382);
      case 383: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==383);
      case 384: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==384);
      case 385: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==385);
      case 386: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==386);
      case 387: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==387);
      case 388: /* noarg_func ::= USER */ yytestcase(yyruleno==388);
      case 389: /* star_func ::= COUNT */ yytestcase(yyruleno==389);
      case 390: /* star_func ::= FIRST */ yytestcase(yyruleno==390);
      case 391: /* star_func ::= LAST */ yytestcase(yyruleno==391);
      case 392: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==392);
{ yylhsminor.yy481 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy481 = yylhsminor.yy481;
        break;
      case 52: /* force_opt ::= */
      case 71: /* not_exists_opt ::= */ yytestcase(yyruleno==71);
      case 73: /* exists_opt ::= */ yytestcase(yyruleno==73);
      case 271: /* analyze_opt ::= */ yytestcase(yyruleno==271);
      case 278: /* agg_func_opt ::= */ yytestcase(yyruleno==278);
      case 453: /* set_quantifier_opt ::= */ yytestcase(yyruleno==453);
{ yymsp[1].minor.yy777 = false; }
        break;
      case 53: /* force_opt ::= FORCE */
      case 272: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==272);
      case 279: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==279);
      case 454: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==454);
{ yymsp[0].minor.yy777 = true; }
        break;
      case 54: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy777, &yymsp[-1].minor.yy481, yymsp[0].minor.yy232); }
        break;
      case 65: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy481); }
        break;
      case 66: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy481); }
        break;
      case 67: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy481, yymsp[0].minor.yy232); }
        break;
      case 68: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy481); }
        break;
      case 69: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy481, yymsp[0].minor.yy692); }
        break;
      case 70: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy777 = true; }
        break;
      case 72: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy777 = true; }
        break;
      case 74: /* db_options ::= */
{ yymsp[1].minor.yy232 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 75: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 76: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 77: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 78: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 79: /* db_options ::= db_options DURATION NK_INTEGER */
      case 80: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==80);
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 81: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 82: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 83: /* db_options ::= db_options KEEP integer_list */
      case 84: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==84);
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_KEEP, yymsp[0].minor.yy288); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 85: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 86: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 87: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 88: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 89: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 90: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 91: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 92: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 93: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_RETENTIONS, yymsp[0].minor.yy288); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 94: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 95: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 96: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-3].minor.yy232, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-3].minor.yy232, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 101: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 102: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 103: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 104: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 105: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy232 = setDatabaseOption(pCxt, yymsp[-2].minor.yy232, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 106: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy232 = createAlterDatabaseOptions(pCxt); yylhsminor.yy232 = setAlterDatabaseOption(pCxt, yylhsminor.yy232, &yymsp[0].minor.yy101); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 107: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy232 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy232, &yymsp[0].minor.yy101); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 108: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy101.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy101.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy101.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy101.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= KEEP integer_list */
      case 113: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==113);
{ yymsp[-1].minor.yy101.type = DB_OPTION_KEEP; yymsp[-1].minor.yy101.pList = yymsp[0].minor.yy288; }
        break;
      case 114: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy101.type = DB_OPTION_PAGES; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy101.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy101.type = DB_OPTION_STRICT; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy101.type = DB_OPTION_WAL; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy101.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy288 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy288 = yylhsminor.yy288;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 301: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==301);
{ yylhsminor.yy288 = addNodeToList(pCxt, yymsp[-2].minor.yy288, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy288 = yylhsminor.yy288;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy288 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy288 = yylhsminor.yy288;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy288 = addNodeToList(pCxt, yymsp[-2].minor.yy288, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy288 = yylhsminor.yy288;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 198: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==198);
      case 203: /* col_name_list ::= col_name */ yytestcase(yyruleno==203);
      case 254: /* func_list ::= func */ yytestcase(yyruleno==254);
      case 329: /* literal_list ::= signed_literal */ yytestcase(yyruleno==329);
      case 395: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==395);
      case 401: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==401);
      case 456: /* select_list ::= select_item */ yytestcase(yyruleno==456);
      case 467: /* partition_list ::= partition_item */ yytestcase(yyruleno==467);
      case 519: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==519);
{ yylhsminor.yy288 = createNodeList(pCxt, yymsp[0].minor.yy232); }
  yymsp[0].minor.yy288 = yylhsminor.yy288;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 199: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==204);
      case 255: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==255);
      case 330: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==330);
      case 396: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==396);
      case 457: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==457);
      case 468: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==468);
      case 520: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==520);
{ yylhsminor.yy288 = addNodeToList(pCxt, yymsp[-2].minor.yy288, yymsp[0].minor.yy232); }
  yymsp[-2].minor.yy288 = yylhsminor.yy288;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy232 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 126: /* speed_opt ::= */
      case 280: /* bufsize_opt ::= */ yytestcase(yyruleno==280);
{ yymsp[1].minor.yy692 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 281: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==281);
{ yymsp[-1].minor.yy692 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy777, yymsp[-5].minor.yy232, yymsp[-3].minor.yy288, yymsp[-1].minor.yy288, yymsp[0].minor.yy232); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy288); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy288); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy232); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 303: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==303);
{ pCxt->pRootNode = yymsp[0].minor.yy232; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy232); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy232 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy232, yymsp[0].minor.yy232); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy232 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy232, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy481, yymsp[0].minor.yy264); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy232 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy232, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy481); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy232 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy232, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy481, yymsp[0].minor.yy264); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy232 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy232, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy481, &yymsp[0].minor.yy481); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy232 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy232, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy481, yymsp[0].minor.yy264); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy232 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy232, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy481); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy232 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy232, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy481, yymsp[0].minor.yy264); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy232 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy232, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy481, &yymsp[0].minor.yy481); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy232 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy232, &yymsp[-2].minor.yy481, yymsp[0].minor.yy232); }
  yymsp[-5].minor.yy232 = yylhsminor.yy232;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 402: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==402);
{ yylhsminor.yy288 = addNodeToList(pCxt, yymsp[-1].minor.yy288, yymsp[0].minor.yy232); }
  yymsp[-1].minor.yy288 = yylhsminor.yy288;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy232 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy777, yymsp[-8].minor.yy232, yymsp[-6].minor.yy232, yymsp[-5].minor.yy288, yymsp[-2].minor.yy288, yymsp[0].minor.yy232); }
  yymsp[-9].minor.yy232 = yylhsminor.yy232;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy232 = createDropTableClause(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy232); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 465: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==465);
      case 487: /* group_by_clause_opt ::= */ yytestcase(yyruleno==487);
      case 506: /* order_by_clause_opt ::= */ yytestcase(yyruleno==506);
{ yymsp[1].minor.yy288 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy288 = yymsp[-1].minor.yy288; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy232 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy481, NULL); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy232 = createRealTableNode(pCxt, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy481, NULL); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy232 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy481, yymsp[0].minor.yy264, NULL); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy232 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy481, yymsp[-2].minor.yy264, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy264 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy264 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy264 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy264 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy264 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy264 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy264 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy264 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy264 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy264 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy264 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 394: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==394);
{ yylhsminor.yy288 = yymsp[0].minor.yy288; }
  yymsp[0].minor.yy288 = yylhsminor.yy288;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy288 = yymsp[-1].minor.yy288; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy232 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy232 = setTableOption(pCxt, yymsp[-2].minor.yy232, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy232 = setTableOption(pCxt, yymsp[-2].minor.yy232, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy288); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy232 = setTableOption(pCxt, yymsp[-2].minor.yy232, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy288); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy232 = setTableOption(pCxt, yymsp[-4].minor.yy232, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy288); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy232 = setTableOption(pCxt, yymsp[-2].minor.yy232, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy232 = setTableOption(pCxt, yymsp[-4].minor.yy232, TABLE_OPTION_SMA, yymsp[-1].minor.yy288); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 192: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy232 = createAlterTableOptions(pCxt); yylhsminor.yy232 = setTableOption(pCxt, yylhsminor.yy232, yymsp[0].minor.yy101.type, &yymsp[0].minor.yy101.val); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 193: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy232 = setTableOption(pCxt, yymsp[-1].minor.yy232, yymsp[0].minor.yy101.type, &yymsp[0].minor.yy101.val); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 194: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy101.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 195: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy101.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy101.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* duration_list ::= duration_literal */
      case 359: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==359);
{ yylhsminor.yy288 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy232)); }
  yymsp[0].minor.yy288 = yylhsminor.yy288;
        break;
      case 197: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 360: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==360);
{ yylhsminor.yy288 = addNodeToList(pCxt, yymsp[-2].minor.yy288, releaseRawExprNode(pCxt, yymsp[0].minor.yy232)); }
  yymsp[-2].minor.yy288 = yylhsminor.yy288;
        break;
      case 200: /* rollup_func_name ::= function_name */
{ yylhsminor.yy232 = createFunctionNode(pCxt, &yymsp[0].minor.yy481, NULL); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 201: /* rollup_func_name ::= FIRST */
      case 202: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==202);
{ yylhsminor.yy232 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 205: /* col_name ::= column_name */
{ yylhsminor.yy232 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy481); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 206: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 208: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 209: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy232, yymsp[0].minor.yy232, OP_TYPE_LIKE); }
        break;
      case 210: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy232, yymsp[0].minor.yy232, OP_TYPE_LIKE); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy232, NULL, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 213: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 215: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy232, yymsp[-1].minor.yy232, OP_TYPE_EQUAL); }
        break;
      case 216: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 217: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 218: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 219: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 220: /* cmd ::= SHOW LICENCES */
      case 221: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==221);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 222: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy481); }
        break;
      case 223: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy232); }
        break;
      case 224: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy232); }
        break;
      case 225: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 226: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 227: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 228: /* cmd ::= SHOW VARIABLES */
      case 229: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 230: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 231: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy232); }
        break;
      case 232: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 233: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 234: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 235: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 236: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy232); }
        break;
      case 237: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 238: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy232, yymsp[-1].minor.yy232, OP_TYPE_EQUAL); }
        break;
      case 240: /* cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLE_TAGS_STMT, yymsp[0].minor.yy232, yymsp[-1].minor.yy232, OP_TYPE_EQUAL); }
        break;
      case 241: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 242: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 243: /* db_name_cond_opt ::= */
      case 248: /* from_db_opt ::= */ yytestcase(yyruleno==248);
{ yymsp[1].minor.yy232 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 244: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy232 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy481); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 245: /* like_pattern_opt ::= */
      case 291: /* subtable_opt ::= */ yytestcase(yyruleno==291);
      case 404: /* case_when_else_opt ::= */ yytestcase(yyruleno==404);
      case 434: /* from_clause_opt ::= */ yytestcase(yyruleno==434);
      case 463: /* where_clause_opt ::= */ yytestcase(yyruleno==463);
      case 472: /* twindow_clause_opt ::= */ yytestcase(yyruleno==472);
      case 477: /* sliding_opt ::= */ yytestcase(yyruleno==477);
      case 479: /* fill_opt ::= */ yytestcase(yyruleno==479);
      case 491: /* having_clause_opt ::= */ yytestcase(yyruleno==491);
      case 493: /* range_opt ::= */ yytestcase(yyruleno==493);
      case 495: /* every_opt ::= */ yytestcase(yyruleno==495);
      case 508: /* slimit_clause_opt ::= */ yytestcase(yyruleno==508);
      case 512: /* limit_clause_opt ::= */ yytestcase(yyruleno==512);
{ yymsp[1].minor.yy232 = NULL; }
        break;
      case 246: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 247: /* table_name_cond ::= table_name */
{ yylhsminor.yy232 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy481); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 249: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy232 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy481); }
        break;
      case 250: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy777, yymsp[-3].minor.yy232, yymsp[-1].minor.yy232, NULL, yymsp[0].minor.yy232); }
        break;
      case 251: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy777, yymsp[0].minor.yy232); }
        break;
      case 252: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy232 = createIndexOption(pCxt, yymsp[-7].minor.yy288, releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), NULL, yymsp[-1].minor.yy232, yymsp[0].minor.yy232); }
        break;
      case 253: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy232 = createIndexOption(pCxt, yymsp[-9].minor.yy288, releaseRawExprNode(pCxt, yymsp[-5].minor.yy232), releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), yymsp[-1].minor.yy232, yymsp[0].minor.yy232); }
        break;
      case 256: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy232 = createFunctionNode(pCxt, &yymsp[-3].minor.yy481, yymsp[-1].minor.yy288); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 257: /* sma_stream_opt ::= */
      case 284: /* stream_options ::= */ yytestcase(yyruleno==284);
{ yymsp[1].minor.yy232 = createStreamOptions(pCxt); }
        break;
      case 258: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 288: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==288);
{ ((SStreamOptions*)yymsp[-2].minor.yy232)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy232); yylhsminor.yy232 = yymsp[-2].minor.yy232; }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 259: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy232)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy232); yylhsminor.yy232 = yymsp[-2].minor.yy232; }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 260: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy777, &yymsp[-2].minor.yy481, yymsp[0].minor.yy232); }
        break;
      case 261: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy777, &yymsp[-3].minor.yy481, &yymsp[0].minor.yy481, false); }
        break;
      case 262: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy777, &yymsp[-5].minor.yy481, &yymsp[0].minor.yy481, true); }
        break;
      case 263: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy777, &yymsp[-3].minor.yy481, yymsp[0].minor.yy232, false); }
        break;
      case 264: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy777, &yymsp[-5].minor.yy481, yymsp[0].minor.yy232, true); }
        break;
      case 265: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy481); }
        break;
      case 266: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy777, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy481); }
        break;
      case 267: /* cmd ::= DESC full_table_name */
      case 268: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==268);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy232); }
        break;
      case 269: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 270: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy777, yymsp[-1].minor.yy232, yymsp[0].minor.yy232); }
        break;
      case 273: /* explain_options ::= */
{ yymsp[1].minor.yy232 = createDefaultExplainOptions(pCxt); }
        break;
      case 274: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy232 = setExplainVerbose(pCxt, yymsp[-2].minor.yy232, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 275: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy232 = setExplainRatio(pCxt, yymsp[-2].minor.yy232, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 276: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy777, yymsp[-8].minor.yy777, &yymsp[-5].minor.yy481, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy264, yymsp[0].minor.yy692); }
        break;
      case 277: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy481); }
        break;
      case 282: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy777, &yymsp[-7].minor.yy481, yymsp[-4].minor.yy232, yymsp[-6].minor.yy232, yymsp[-3].minor.yy288, yymsp[-2].minor.yy232, yymsp[0].minor.yy232); }
        break;
      case 283: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy777, &yymsp[0].minor.yy481); }
        break;
      case 285: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy232)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy232 = yymsp[-2].minor.yy232; }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 286: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy232)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy232 = yymsp[-2].minor.yy232; }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 287: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy232)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy232)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy232); yylhsminor.yy232 = yymsp[-3].minor.yy232; }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 289: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy232)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy232 = yymsp[-3].minor.yy232; }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 290: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy232)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy232 = yymsp[-2].minor.yy232; }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 292: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 478: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==478);
      case 496: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==496);
{ yymsp[-3].minor.yy232 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy232); }
        break;
      case 293: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 294: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 295: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 296: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 297: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 298: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy288); }
        break;
      case 299: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 300: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy288 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 302: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy232, yymsp[0].minor.yy232); }
        break;
      case 304: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy232, yymsp[-2].minor.yy288, yymsp[0].minor.yy232); }
        break;
      case 305: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy232, NULL, yymsp[0].minor.yy232); }
        break;
      case 306: /* literal ::= NK_INTEGER */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 307: /* literal ::= NK_FLOAT */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 308: /* literal ::= NK_STRING */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 309: /* literal ::= NK_BOOL */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 310: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 311: /* literal ::= duration_literal */
      case 321: /* signed_literal ::= signed */ yytestcase(yyruleno==321);
      case 341: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==341);
      case 342: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==342);
      case 343: /* expression ::= literal */ yytestcase(yyruleno==343);
      case 344: /* expression ::= pseudo_column */ yytestcase(yyruleno==344);
      case 345: /* expression ::= column_reference */ yytestcase(yyruleno==345);
      case 346: /* expression ::= function_expression */ yytestcase(yyruleno==346);
      case 347: /* expression ::= case_when_expression */ yytestcase(yyruleno==347);
      case 377: /* function_expression ::= literal_func */ yytestcase(yyruleno==377);
      case 426: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==426);
      case 430: /* boolean_primary ::= predicate */ yytestcase(yyruleno==430);
      case 432: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==432);
      case 433: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==433);
      case 436: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==436);
      case 438: /* table_reference ::= table_primary */ yytestcase(yyruleno==438);
      case 439: /* table_reference ::= joined_table */ yytestcase(yyruleno==439);
      case 443: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==443);
      case 498: /* query_simple ::= query_specification */ yytestcase(yyruleno==498);
      case 499: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==499);
      case 502: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==502);
      case 504: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==504);
{ yylhsminor.yy232 = yymsp[0].minor.yy232; }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 312: /* literal ::= NULL */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 313: /* literal ::= NK_QUESTION */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 314: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 315: /* signed ::= NK_INTEGER */
{ yylhsminor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 316: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 317: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 318: /* signed ::= NK_FLOAT */
{ yylhsminor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 319: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 320: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 322: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 323: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 324: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 325: /* signed_literal ::= duration_literal */
      case 327: /* signed_literal ::= literal_func */ yytestcase(yyruleno==327);
      case 397: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==397);
      case 459: /* select_item ::= common_expression */ yytestcase(yyruleno==459);
      case 469: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==469);
      case 503: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==503);
      case 505: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==505);
      case 518: /* search_condition ::= common_expression */ yytestcase(yyruleno==518);
{ yylhsminor.yy232 = releaseRawExprNode(pCxt, yymsp[0].minor.yy232); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 326: /* signed_literal ::= NULL */
{ yylhsminor.yy232 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 328: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy232 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 348: /* expression ::= NK_LP expression NK_RP */
      case 431: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==431);
      case 517: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==517);
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy232)); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 349: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy232));
                                                                                  }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 350: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy232), NULL));
                                                                                  }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 351: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232))); 
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 352: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232))); 
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 353: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232))); 
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 354: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232))); 
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 355: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 356: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 357: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 358: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 361: /* column_reference ::= column_name */
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy481, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy481)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 362: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy481, createColumnNode(pCxt, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy481)); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 363: /* pseudo_column ::= ROWTS */
      case 364: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==364);
      case 366: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==366);
      case 367: /* pseudo_column ::= QEND */ yytestcase(yyruleno==367);
      case 368: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==368);
      case 369: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==369);
      case 370: /* pseudo_column ::= WEND */ yytestcase(yyruleno==370);
      case 371: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==371);
      case 372: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==372);
      case 373: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==373);
      case 379: /* literal_func ::= NOW */ yytestcase(yyruleno==379);
{ yylhsminor.yy232 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 365: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy481)))); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 374: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 375: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==375);
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy481, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy481, yymsp[-1].minor.yy288)); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 376: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), yymsp[-1].minor.yy264)); }
  yymsp[-5].minor.yy232 = yylhsminor.yy232;
        break;
      case 378: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy481, NULL)); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 393: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy288 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy288 = yylhsminor.yy288;
        break;
      case 398: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 462: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==462);
{ yylhsminor.yy232 = createColumnNode(pCxt, &yymsp[-2].minor.yy481, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 399: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy288, yymsp[-1].minor.yy232)); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 400: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), yymsp[-2].minor.yy288, yymsp[-1].minor.yy232)); }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 403: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy232 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)); }
        break;
      case 405: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy232 = releaseRawExprNode(pCxt, yymsp[0].minor.yy232); }
        break;
      case 406: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 411: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==411);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy4, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 407: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy232), releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-4].minor.yy232 = yylhsminor.yy232;
        break;
      case 408: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy232), releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-5].minor.yy232 = yylhsminor.yy232;
        break;
      case 409: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), NULL));
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 410: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), NULL));
                                                                                  }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 412: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy4 = OP_TYPE_LOWER_THAN; }
        break;
      case 413: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy4 = OP_TYPE_GREATER_THAN; }
        break;
      case 414: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy4 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 415: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy4 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 416: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy4 = OP_TYPE_NOT_EQUAL; }
        break;
      case 417: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy4 = OP_TYPE_EQUAL; }
        break;
      case 418: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy4 = OP_TYPE_LIKE; }
        break;
      case 419: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy4 = OP_TYPE_NOT_LIKE; }
        break;
      case 420: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy4 = OP_TYPE_MATCH; }
        break;
      case 421: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy4 = OP_TYPE_NMATCH; }
        break;
      case 422: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy4 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 423: /* in_op ::= IN */
{ yymsp[0].minor.yy4 = OP_TYPE_IN; }
        break;
      case 424: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy4 = OP_TYPE_NOT_IN; }
        break;
      case 425: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy288)); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 427: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy232), NULL));
                                                                                  }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 428: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 429: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy232);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy232);
                                                                                    yylhsminor.yy232 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), releaseRawExprNode(pCxt, yymsp[0].minor.yy232)));
                                                                                  }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 435: /* from_clause_opt ::= FROM table_reference_list */
      case 464: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==464);
      case 492: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==492);
{ yymsp[-1].minor.yy232 = yymsp[0].minor.yy232; }
        break;
      case 437: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy232 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy232, yymsp[0].minor.yy232, NULL); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 440: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy232 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy481, &yymsp[0].minor.yy481); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 441: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy232 = createRealTableNode(pCxt, &yymsp[-3].minor.yy481, &yymsp[-1].minor.yy481, &yymsp[0].minor.yy481); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 442: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy232 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy232), &yymsp[0].minor.yy481); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 444: /* alias_opt ::= */
{ yymsp[1].minor.yy481 = nil_token;  }
        break;
      case 445: /* alias_opt ::= table_alias */
{ yylhsminor.yy481 = yymsp[0].minor.yy481; }
  yymsp[0].minor.yy481 = yylhsminor.yy481;
        break;
      case 446: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy481 = yymsp[0].minor.yy481; }
        break;
      case 447: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 448: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==448);
{ yymsp[-2].minor.yy232 = yymsp[-1].minor.yy232; }
        break;
      case 449: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy232 = createJoinTableNode(pCxt, yymsp[-4].minor.yy700, yymsp[-5].minor.yy232, yymsp[-2].minor.yy232, yymsp[0].minor.yy232); }
  yymsp[-5].minor.yy232 = yylhsminor.yy232;
        break;
      case 450: /* join_type ::= */
{ yymsp[1].minor.yy700 = JOIN_TYPE_INNER; }
        break;
      case 451: /* join_type ::= INNER */
{ yymsp[0].minor.yy700 = JOIN_TYPE_INNER; }
        break;
      case 452: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy232 = createSelectStmt(pCxt, yymsp[-10].minor.yy777, yymsp[-9].minor.yy288, yymsp[-8].minor.yy232);
                                                                                    yymsp[-11].minor.yy232 = addWhereClause(pCxt, yymsp[-11].minor.yy232, yymsp[-7].minor.yy232);
                                                                                    yymsp[-11].minor.yy232 = addPartitionByClause(pCxt, yymsp[-11].minor.yy232, yymsp[-6].minor.yy288);
                                                                                    yymsp[-11].minor.yy232 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy232, yymsp[-2].minor.yy232);
                                                                                    yymsp[-11].minor.yy232 = addGroupByClause(pCxt, yymsp[-11].minor.yy232, yymsp[-1].minor.yy288);
                                                                                    yymsp[-11].minor.yy232 = addHavingClause(pCxt, yymsp[-11].minor.yy232, yymsp[0].minor.yy232);
                                                                                    yymsp[-11].minor.yy232 = addRangeClause(pCxt, yymsp[-11].minor.yy232, yymsp[-5].minor.yy232);
                                                                                    yymsp[-11].minor.yy232 = addEveryClause(pCxt, yymsp[-11].minor.yy232, yymsp[-4].minor.yy232);
                                                                                    yymsp[-11].minor.yy232 = addFillClause(pCxt, yymsp[-11].minor.yy232, yymsp[-3].minor.yy232);
                                                                                  }
        break;
      case 455: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy777 = false; }
        break;
      case 458: /* select_item ::= NK_STAR */
{ yylhsminor.yy232 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy232 = yylhsminor.yy232;
        break;
      case 460: /* select_item ::= common_expression column_alias */
      case 470: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==470);
{ yylhsminor.yy232 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy232), &yymsp[0].minor.yy481); }
  yymsp[-1].minor.yy232 = yylhsminor.yy232;
        break;
      case 461: /* select_item ::= common_expression AS column_alias */
      case 471: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==471);
{ yylhsminor.yy232 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), &yymsp[0].minor.yy481); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 466: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 488: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==488);
      case 507: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==507);
{ yymsp[-2].minor.yy288 = yymsp[0].minor.yy288; }
        break;
      case 473: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy232 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), releaseRawExprNode(pCxt, yymsp[-1].minor.yy232)); }
        break;
      case 474: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy232 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy232)); }
        break;
      case 475: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy232 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), NULL, yymsp[-1].minor.yy232, yymsp[0].minor.yy232); }
        break;
      case 476: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy232 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy232), releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), yymsp[-1].minor.yy232, yymsp[0].minor.yy232); }
        break;
      case 480: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy232 = createFillNode(pCxt, yymsp[-1].minor.yy614, NULL); }
        break;
      case 481: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy232 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy288)); }
        break;
      case 482: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy614 = FILL_MODE_NONE; }
        break;
      case 483: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy614 = FILL_MODE_PREV; }
        break;
      case 484: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy614 = FILL_MODE_NULL; }
        break;
      case 485: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy614 = FILL_MODE_LINEAR; }
        break;
      case 486: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy614 = FILL_MODE_NEXT; }
        break;
      case 489: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy288 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy232))); }
  yymsp[0].minor.yy288 = yylhsminor.yy288;
        break;
      case 490: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy288 = addNodeToList(pCxt, yymsp[-2].minor.yy288, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy232))); }
  yymsp[-2].minor.yy288 = yylhsminor.yy288;
        break;
      case 494: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy232 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy232), releaseRawExprNode(pCxt, yymsp[-1].minor.yy232)); }
        break;
      case 497: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy232 = addOrderByClause(pCxt, yymsp[-3].minor.yy232, yymsp[-2].minor.yy288);
                                                                                    yylhsminor.yy232 = addSlimitClause(pCxt, yylhsminor.yy232, yymsp[-1].minor.yy232);
                                                                                    yylhsminor.yy232 = addLimitClause(pCxt, yylhsminor.yy232, yymsp[0].minor.yy232);
                                                                                  }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 500: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy232 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy232, yymsp[0].minor.yy232); }
  yymsp[-3].minor.yy232 = yylhsminor.yy232;
        break;
      case 501: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy232 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy232, yymsp[0].minor.yy232); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 509: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 513: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==513);
{ yymsp[-1].minor.yy232 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 510: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 514: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==514);
{ yymsp[-3].minor.yy232 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 511: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 515: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==515);
{ yymsp[-3].minor.yy232 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 516: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy232 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy232); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 521: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy232 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy232), yymsp[-1].minor.yy866, yymsp[0].minor.yy833); }
  yymsp[-2].minor.yy232 = yylhsminor.yy232;
        break;
      case 522: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy866 = ORDER_ASC; }
        break;
      case 523: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy866 = ORDER_ASC; }
        break;
      case 524: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy866 = ORDER_DESC; }
        break;
      case 525: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy833 = NULL_ORDER_DEFAULT; }
        break;
      case 526: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy833 = NULL_ORDER_FIRST; }
        break;
      case 527: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy833 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
