###################################################################
#           Copyright (c) 2016 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, db_test.stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
import taos
from util.log import tdLog
from util.cases import tdCases
from util.sql import tdSql
import time
import random

class TDTestCase:

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def run(self):
        tdSql.prepare()

        print("==============step1 tag format =======")
        tdLog.info("create database   ")
        tdSql.execute("create database db_json")
        tdSql.execute("use db_json")    
        # test  tag format 
        tdSql.execute("create table if not exists  jsons1(ts timestamp, dataInt int, dataStr nchar(50)) tags(jtag json(128))")
        tdSql.error("create table if not exists  jsons1(ts timestamp, dataInt int, dataStr nchar(50)) tags(jtag json(64),jtag1 json(100))")
        tdSql.error("create table if not exists  jsons1(ts timestamp, dataInt int, dataStr nchar(50)) tags(jtag json(64),dataBool bool)")
        
        tdSql.execute("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags('{\"loc\":\"fff\",\"id\":5}')")

        # two stables: jsons1 jsons2 ,test  tag's value  and  key  
        tdSql.execute("insert into  jsons1_1(ts,dataInt)  using  jsons1 tags('{\"loc+\":\"fff\",\"id\":5}') values (now,12)")

        tdSql.error("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags('{oc:\"fff\",\"id\":5}')")
        tdSql.error("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags('{\"loc\":fff,\"id\":5}')")
        tdSql.error("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags('3333')")
        tdSql.error("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags('{\"loc\":}')")
        tdSql.error("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags('{\"loc\":bool)")
        tdSql.error("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags(true)")
        tdSql.error("CREATE TABLE if not exists  jsons1_1 using  jsons1 tags('[{\"num\":5}]')")

        # test object and key max length. max key length is 256, max object length is 4096 include abcd.
        tdSql.execute("create table if not exists  jsons4(ts timestamp, dataInt int, dataStr nchar(50)) tags(jtag json(128))")

        char1= ''.join(['abcd']*64)
        char2=''.join(char1)
        char3= ''.join(['abcd']*1022)
        print(len(char3))   # 4088
        tdSql.execute("CREATE TABLE if not exists  jsons4_1 using  jsons4 tags('{\"%s\":5}')" % char1)  # len(key)=256
        tdSql.error("CREATE TABLE if not exists  jsons4_1 using  jsons4 tags('{\"%s1\":5}')" % char2)   # len(key)=257
        tdSql.execute("CREATE TABLE if not exists  jsons4_2 using  jsons4 tags('{\"T\":\"%s\"}')" % char3)  # len(object)=4096
        tdSql.error("CREATE TABLE if not exists  jsons4_2 using  jsons4 tags('{\"TS\":\"%s\"}')" % char3)   # len(object)=4097

        tdSql.execute("insert into  jsons1_1 values(now, 1, 'json1')")
        tdSql.execute("insert into  jsons1_1 values(now+1s, 1, 'json1')")
        tdSql.execute("insert into  jsons1_2 using  jsons1 tags('{\"num\":5,\"location\":\"beijing\"}') values (now, 1, 'json2')")
        tdSql.execute("insert into  jsons1_3 using  jsons1 tags('{\"num\":34,\"location\":\"beijing\",\"level\":\"l1\"}') values (now, 1, 'json3')")
        tdSql.execute("insert into  jsons1_4 using  jsons1 tags('{\"class\":55,\"location\":\"beijing\",\"name\":\"name4\"}') values (now, 1, 'json4')")

        # test : json'vaule is null and 
        tdSql.execute("create table if not exists  jsons2(ts timestamp, dataInt2 int, dataStr2 nchar(50)) tags(jtag2 json(300))")
        tdSql.execute("CREATE TABLE if not exists  jsons2_1 using  jsons2 tags('{}')")
        tdSql.query("select jtag2 from  jsons2_1")
        tdSql.checkData(0, 0, None)
        tdSql.execute("CREATE TABLE if not exists  jsons2_2 using  jsons2 tags('')")
        tdSql.query("select jtag2 from  jsons2_2")
        tdSql.checkData(0, 0, None)
        tdSql.execute("CREATE TABLE if not exists  jsons2_3 using  jsons2 tags('null')")
        tdSql.query("select jtag2 from  jsons2_3")
        tdSql.checkData(0, 0, None) 
        tdSql.execute("CREATE TABLE if not exists  jsons2_4 using  jsons2 tags('\t')")
        tdSql.query("select jtag2 from  jsons2_4")
        tdSql.checkData(0, 0, None)
        tdSql.execute("CREATE TABLE if not exists  jsons2_5 using  jsons2 tags(' ')")
        tdSql.query("select jtag2 from  jsons2_5")
        tdSql.checkData(0, 0, None)
        tdSql.execute("CREATE TABLE if not exists  jsons2_6 using  jsons2 tags('{\"nv\":null,\"tea\":true,\"\":false,\"\":123,\"tea\":false}')")
        tdSql.query("select jtag2 from  jsons2_6")
        tdSql.checkData(0, 0, "{\"nv\":null,\"tea\":true}")
        tdSql.error("CREATE TABLE if not exists  jsons2_7 using  jsons2 tags('{\"nv\":null,\"tea\":123,\"\":false,\"\":123,\"tea\":false}')")
        tdSql.execute("CREATE TABLE if not exists  jsons2_7 using  jsons2 tags('{\"test7\":\"\"}')")
        tdSql.query("select jtag2 from  jsons2_7")
        tdSql.checkData(0, 0, "{\"test7\":\"\"}")

        print("==============step2 alter json table==")
        tdLog.info("alter stable add tag")
        tdSql.error("ALTER STABLE  jsons2 add tag jtag3 nchar(20)")
        tdSql.error("ALTER STABLE  jsons2 drop tag jtag2")
        tdSql.execute("ALTER STABLE jsons2 change tag jtag2 jtag3")
        tdSql.query("select jtag3->'tea' from  jsons2_6")
        tdSql.checkData(0, 0, "true")       
        tdSql.error("ALTER TABLE  jsons2_6 SET TAG jtag3='{\"tea-=[].;!@#$%^&*()/\":}'")
        tdSql.execute("ALTER TABLE  jsons2_6 SET TAG jtag3='{\"tea-=[].;!@#$%^&*()/\":false}'")
        tdSql.query("select jtag3 from  jsons2_6")
        tdSql.checkData(0, 0, "{\"tea-=[].;!@#$%^&*()/\":false}")
        tdSql.execute("ALTER TABLE  jsons1_1 SET TAG jtag='{\"sex\":\"femail\",\"age\":35}'")
        tdSql.query("select jtag from  jsons1_1")
        tdSql.checkData(0, 0, "{\"sex\":\"femail\",\"age\":35}")
       


        print("==============step3")
        tdLog.info("select table")

        tdSql.query("select jtag from  jsons1_1")
        tdSql.checkData(0, 0, "{\"sex\":\"femail\",\"age\":35}")

        tdSql.query("select jtag from  jsons1 where  jtag->'name'='name4'")
        tdSql.checkData(0, 0, "{\"class\":55,\"location\":\"beijing\",\"name\":\"name4\"}")


        tdSql.query("select * from  jsons1")
        tdSql.checkRows(6)

        tdSql.query("select * from  jsons1_1")
        tdSql.checkRows(3)

        tdSql.query("select * from  jsons1 where jtag->'location'='beijing'")
        tdSql.checkRows(3)

        tdSql.query("select jtag->'location' from  jsons1_2")
        tdSql.checkData(0, 0, "beijing")


        tdSql.query("select jtag->'num' from  jsons1 where jtag->'level'='l1'")
        tdSql.checkData(0, 0, 34)

        tdSql.query("select jtag->'location' from  jsons1")
        tdSql.checkRows(4)

        tdSql.query("select jtag from  jsons1_1")
        tdSql.checkRows(1)

        tdSql.query("select * from  jsons1 where jtag?'sex' or jtag?'num'")
        tdSql.checkRows(5)

        tdSql.query("select * from  jsons1 where jtag?'sex' and jtag?'num'")
        tdSql.checkRows(0)

        tdSql.query("select jtag->'sex' from  jsons1 where jtag?'sex' or jtag?'num'")
        tdSql.checkData(0, 0, "femail")
        tdSql.checkRows(3)

        tdSql.query("select *,tbname from  jsons1 where jtag->'location'='beijing'")
        tdSql.checkRows(3)

        tdSql.query("select *,tbname from  jsons1 where jtag->'num'=5 or jtag?'sex'")
        tdSql.checkRows(4)

        # test with tbname
        tdSql.query("select * from  jsons1 where tbname = 'jsons1_1'")
        tdSql.checkRows(3)

        tdSql.query("select * from  jsons1 where tbname = 'jsons1_1' or jtag?'num'")
        tdSql.checkRows(5)

        tdSql.query("select * from  jsons1 where tbname = 'jsons1_1' and jtag?'num'")
        tdSql.checkRows(0)

        tdSql.query("select * from  jsons1 where tbname = 'jsons1_1' or jtag->'num'=5")
        tdSql.checkRows(4)

        # test where condition like
        tdSql.query("select *,tbname from  jsons1 where jtag->'location' like 'bei%'")
        tdSql.checkRows(3)

        tdSql.query("select *,tbname from  jsons1 where jtag->'location' like 'bei%' and jtag->'location'='beijin'")
        tdSql.checkRows(0)

        tdSql.query("select *,tbname from  jsons1 where jtag->'location' like 'bei%' or jtag->'location'='beijin'")
        tdSql.checkRows(3)

        tdSql.query("select *,tbname from  jsons1 where jtag->'location' like 'bei%' and jtag->'num'=34")
        tdSql.checkRows(1)

        tdSql.query("select *,tbname from  jsons1 where (jtag->'location' like 'shanghai%' or jtag->'num'=34) and jtag->'class'=55")
        tdSql.checkRows(0)

        tdSql.error("select * from  jsons1 where jtag->'num' like '5%'")

        # test where condition in
        tdSql.query("select * from  jsons1 where jtag->'location' in ('beijing')")
        tdSql.checkRows(3)

        tdSql.query("select * from  jsons1 where jtag->'num' in (5,34)")
        tdSql.checkRows(2)

        tdSql.error("select * from  jsons1 where jtag->'num' in ('5',34)")

        tdSql.query("select * from  jsons1 where jtag->'location' in ('beijing') and jtag->'class'=55")
        tdSql.checkRows(1)

        # test where condition match
        tdSql.query("select * from  jsons1 where jtag->'location' match 'jin$'")
        tdSql.checkRows(0)

        tdSql.query("select * from  jsons1 where jtag->'location' match 'jin'")
        tdSql.checkRows(3)

        tdSql.query("select * from  jsons1 where datastr match 'json' and jtag->'location' match 'jin'")
        tdSql.checkRows(3)

        tdSql.error("select * from  jsons1 where jtag->'num' match '5'")

        # test json string parse
        tdSql.error("CREATE TABLE if not exists  jsons1_5 using  jsons1 tags('efwewf')")
        tdSql.execute("CREATE TABLE if not exists  jsons1_5 using  jsons1 tags('\t')")
        tdSql.execute("CREATE TABLE if not exists  jsons1_6 using  jsons1 tags('')")

        tdSql.query("select jtag from  jsons1_6")
        tdSql.checkData(0, 0, None)

        tdSql.execute("CREATE TABLE if not exists  jsons1_7 using  jsons1 tags('{}')")
        tdSql.query("select jtag from  jsons1_7")
        tdSql.checkData(0, 0, None)

        tdSql.execute("CREATE TABLE if not exists  jsons1_8 using  jsons1 tags('null')")
        tdSql.query("select jtag from  jsons1_8")
        tdSql.checkData(0, 0, None)

        tdSql.execute("CREATE TABLE if not exists  jsons1_9 using  jsons1 tags('{\"\":4, \"time\":null}')")
        tdSql.query("select jtag from  jsons1_9")
        tdSql.checkData(0, 0, "{\"time\":null}")

        tdSql.execute("CREATE TABLE if not exists  jsons1_10 using  jsons1 tags('{\"k1\":\"\",\"k1\":\"v1\",\"k2\":true,\"k3\":false,\"k4\":55}')")
        tdSql.query("select jtag from  jsons1_10")
        tdSql.checkData(0, 0, "{\"k1\":\"\",\"k2\":true,\"k3\":false,\"k4\":55}")

        tdSql.query("select jtag->'k2' from  jsons1_10")
        tdSql.checkData(0, 0, "true")

        tdSql.query("select jtag from  jsons1 where jtag->'k1'=''")
        tdSql.checkRows(1)

        tdSql.query("select jtag from  jsons1 where jtag->'k2'=true")
        tdSql.checkRows(1)

        tdSql.query("select jtag from  jsons1 where jtag is null")
        tdSql.checkRows(4)

        tdSql.query("select jtag from  jsons1 where jtag is not null")
        tdSql.checkRows(6)

        tdSql.query("select * from  jsons1 where jtag->'location' is not null")
        tdSql.checkRows(3)

        tdSql.query("select tbname,jtag from  jsons1 where jtag->'location' is null")
        tdSql.checkRows(7)

        tdSql.query("select * from  jsons1 where jtag->'num' is not null")
        tdSql.checkRows(2)

        tdSql.query("select * from  jsons1 where jtag->'location'='null'")
        tdSql.checkRows(0)

        tdSql.error("select * from  jsons1 where jtag->'num'='null'")

        # test distinct
        tdSql.query("select distinct jtag from  jsons1")
        tdSql.checkRows(7)

        tdSql.query("select distinct jtag->'location' from  jsons1")
        tdSql.checkRows(2)

        # test chinese
        tdSql.execute("CREATE TABLE if not exists  jsons1_11 using  jsons1 tags('{\"k1\":\"中国\",\"k5\":\"是是是\"}')")

        tdSql.query("select tbname,jtag from  jsons1 where jtag->'k1' match '中'")
        tdSql.checkRows(1)

        tdSql.query("select tbname,jtag from  jsons1 where jtag->'k1'='中国'")
        tdSql.checkRows(1)

        #test dumplicate key with normal colomn
        tdSql.execute("INSERT INTO  jsons1_12 using  jsons1 tags('{\"tbname\":\"tt\",\"databool\":true,\"dataStr\":\"是是是\"}') values(now, 4, \"你就会\")")

        tdSql.query("select *,tbname,jtag from  jsons1 where jtag->'dataStr' match '是'")
        tdSql.checkRows(1)

        tdSql.query("select tbname,jtag->'tbname' from  jsons1 where jtag->'tbname'='tt'")
        tdSql.checkRows(1)

        # test  filter : and /or / in/ like
        tdSql.query("select * from jsons1 where jtag->'num' is not null or jtag?'class' and jtag?'databool'")
        tdSql.checkRows(2)

        tdSql.query("select * from jsons1 where jtag->'num' is not null and jtag?'class' or jtag?'databool'")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 4)

        tdSql.query("select * from jsons1 where jtag->'num' is not null or jtag?'class' and jtag?'databool' and jtag->'k1' match '中' or  jtag->'location' in ('beijing')  and  jtag->'location' like 'bei%'")
        tdSql.checkRows(3)

        tdSql.query("select * from jsons1 where datastr like '你就会' and ( jtag->'num' is not null or jtag?'tbname' and jtag?'databool' )")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 4)

        tdSql.error("select * from jsons1 where datastr like '你就会' and jtag->'num' is not null or jtag?'class' and jtag?'databool'")


        tdSql.error("select * from jsons1 where datastr like '你就会' or jtag->'num' is not null or jtag?'class' and jtag?'databool' and jtag->'k1' match '中' or  jtag->'location' in ('beijing')  and  jtag->'location' like 'bei%' ")

        tdSql.query("select * from jsons1 where datastr like '你就会' and (jtag->'num' is not null or jtag?'class' and jtag?'databool' and jtag->'k1' match '中' or  jtag->'location' in ('beijing')  and  jtag->'location' like 'bei%' )")
        tdSql.checkRows(0)
      
        tdSql.error("select *,tbname,jtag from  jsons1 where dataBool=true")

        # test error
        tdSql.error("CREATE TABLE if not exists  jsons1_13 using  jsons1 tags(3333)")
        tdSql.execute("CREATE TABLE if not exists  jsons1_13 using  jsons1 tags('{\"1loc\":\"fff\",\";id\":5}')")
        tdSql.error("CREATE TABLE if not exists  jsons1_13 using  jsons1 tags('{\"。loc\":\"fff\",\"fsd\":5}')")
        tdSql.error("CREATE TABLE if not exists  jsons1_13 using  jsons1 tags('{\"试试\":\"fff\",\";id\":5}')")
        tdSql.error("insert into  jsons1_13 using  jsons1 tags(3)")

        # test  query  normal column,tag and tbname 
        tdSql.execute("create stable if not exists  jsons3(ts timestamp, dataInt3 int(100), dataBool3  bool, dataStr3 nchar(50)) tags(jtag3 json)")
        tdSql.execute("create table jsons3_2 using  jsons3 tags('{\"t\":true,\"t123\":123,\"\":\"true\"}')")
        
        tdSql.execute("create table jsons3_3 using  jsons3 tags('{\"t\":true,\"t123\":456,\"k1\":true,\"str1\":\"111\"}')")
        tdSql.execute("insert into jsons3_3 values(now, 4, true, 'test')")

        tdSql.execute("insert into jsons3_4 using  jsons3 tags('{\"t\":true,\"t123\":789,\"k1\":false,\"s\":null,\"str1\":\"112\"}')  values(now, 5, true, 'test')")
        tdSql.query("select * from  jsons3 where jtag3->'k1'=true")
        tdSql.checkRows(1)
        tdSql.error("select  jtag3->k1 from  jsons3 ")
        tdSql.error("select  jtag3 from  jsons3 where jtag3->'k1'")
        tdSql.error("select  jtag3 from  jsons3 where jtag3?'k1'=true")
        tdSql.error("select  jtag3?'k1' from  jsons3;")
        tdSql.error("select  jtag3?'k1'=true from  jsons3;")
        tdSql.error("select  jtag3->'k1'=true from  jsons3;")
        tdSql.error("insert into jsons3_5 using  jsons3 tags('{\"t\":true,\"t123\":789,\"k1\":1,\"s\":null}')  values(now, 5, true, 'test')")
        tdSql.execute("insert into jsons3_5 using  jsons3 tags('{\"t\":true,\"t123\":012,\"k2\":null,\"s\":null}')  values(now, 5, true, 'test')")
        tdSql.execute("insert into jsons3_6 using  jsons3 tags('{\"t\":true,\"t123\":789,\"k1\":false,\"s\":null}')  values(now, 5, true, 'test')")
        tdSql.query("select jtag3 from jsons3 where jtag3->'t123'=12 or jtag3?'k1'")
        tdSql.checkRows(4)
        tdSql.query("select distinct jtag3 from jsons3 where jtag3->'t123'=12 or jtag3?'k1'")
        tdSql.checkRows(4)


        tdSql.execute("INSERT INTO  jsons1_14 using  jsons1 tags('{\"tbname\":\"tt\",\"location\":\"tianjing\",\"dataStr\":\"是是是\"}') values(now,5, \"你就会\")")

        tdSql.query("select ts,jtag->'tbname',tbname from  jsons1 where dataint>=1 and jtag->'location' in ('tianjing','123') and jtag?'tbname'")
        tdSql.checkRows(1)
        tdSql.checkData(0, 1, 'tt')

        tdSql.query("select ts,jtag->'tbname',tbname from  jsons1 where dataint between 1 and 5 and jtag->'location' in ('tianjing','123')")
        tdSql.checkRows(1)
        tdSql.checkData(0, 2, 'jsons1_14')

        tdSql.query("select ts,jtag3->'tbname', jtag3->'str1',tbname from  jsons3 where jtag3->'t123'  between 456 and 789 and jtag3->'str1' like '11%' ")
        tdSql.checkRows(2)
        for i in range(1):
            if tdSql.queryResult[i][1] == 'jsons3_3':
                tdSql.checkData(i, 2, 111) 

        tdSql.query("select  jtag3->'',dataint3 from  jsons3")
        tdSql.checkRows(4)
        for i in range(4):
            if tdSql.queryResult[i][1] == 4:
                tdSql.checkData(i, 0, None) 
        tdSql.query("select tbname,dataint3,jtag3->'k1' from jsons3;")
        tdSql.checkRows(4)
        for i in range(3):
            if tdSql.queryResult[i][1] == 4:
                tdSql.checkData(i, 2, 'true') 

        # Select_exprs is SQL function -Aggregation function  , tests includes group by and order by 
 
        tdSql.query("select  avg(dataInt),count(dataint),sum(dataint) from jsons1 group by jtag->'location' order by jtag->'location';")
        tdSql.checkData(2, 3, 'tianjing')        
        tdSql.checkRows(3)
        for i in range(2):
            if tdSql.queryResult[i][3] == 'beijing':
                tdSql.checkData(i, 0, 1) 
                tdSql.checkData(i, 1, 3) 
        # tdSql.query("select  avg(dataInt) as 123 ,count(dataint),sum(dataint)  from jsons1 group by jtag->'location' order by 123")
        # tdSql.query("select  avg(dataInt) as avgdata ,count(dataint),sum(dataint)  from jsons1 group by jtag->'location' order by  avgdata ;")
        tdSql.query("select  avg(dataInt),count(dataint),sum(dataint)   from jsons1 group by jtag->'location' order by ts;")
        tdSql.checkRows(3)
        tdSql.query("select  avg(dataInt),count(dataint),sum(dataint)   from jsons1 group by jtag->'age' order by tbname;")
        tdSql.checkRows(2)
        tdSql.error("select  avg(dataInt)   from jsons1 group by jtag->'location' order by dataInt;")
        tdSql.error("select  avg(dataInt),tbname   from jsons1 group by jtag->'location' order by tbname;")
        tdSql.execute("CREATE TABLE if not exists  jsons1_15 using  jsons1 tags('{\"tbname\":\"tt\",\"location\":\"beijing\"}')")
        tdSql.execute("insert into  jsons1_15 values(now+1s, 2, 'json1')")
        tdSql.error("select twa(dataint) from jsons1 group by jtag->'location' order by jtag->'location';")
        tdSql.error("select  irate(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        # tdSql.query(" select stddev(dataint) from jsons1 group by jtag->'location';")
        # tdSql.checkRows(2)
        tdSql.query(" select stddev(dataint) from jsons1  where  jtag->'location'='beijing';")
        tdSql.checkRows(1)
        tdSql.error(" select LEASTSQUARES(dataint,1,2) from jsons1_1 where  jtag->'location' ='beijing' ;")

        # Select_exprs is SQL function -Selection function

        tdSql.query(" select  min(dataint),jtag from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)
        tdSql.query(" select  max(dataint),jtag from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 12)
        tdSql.query(" select  first(*) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)
        tdSql.query(" select  last(*) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)
        tdSql.error(" select  last(*),jtag from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.query(" select  last_row(*) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)
        tdSql.query(" select  apercentile(dataint,0) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)
        tdSql.query(" select  apercentile(dataint,50) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)     
        tdSql.query(" select  apercentile(dataint,90) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)    
        tdSql.query(" select  apercentile(dataint,100) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)   
        tdSql.query(" select  apercentile(dataint,0,'t-digest') from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)
        tdSql.query(" select  apercentile(dataint,50,'t-digest') from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1) 
        tdSql.query(" select  apercentile(dataint,100,'t-digest') from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkRows(1)   
        tdSql.query(" select  interp(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing')  and ts >= '2021-11-10 20:58:25.007' and ts<= '2021-11-12 20:58:32.000'  every(2a) ;")
        # tdSql.checkData(0,0,1)  
        # tdSql.checkRows(1)   
        # tdSql.query("select  top(dataint,1)  from jsons1 group by jtag->'location';")
        # tdSql.query("select  top(dataint,100)  from jsons1 group by jtag->'location';")
        # tdSql.query("select  bottom(dataint,1)  from jsons1 group by jtag->'location';")
        # tdSql.query("select  bottom(dataint,100)  from jsons1 group by jtag->'location';")

        #  Select_exprs is SQL function -Calculation  function

        tdSql.error(" select  diff(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.error(" select  Derivative(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.query(" select  SPREAD(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.checkData(0, 0, 11) 
        tdSql.query(" select  ceil(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.query(" select  floor(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        tdSql.query(" select  round(dataint) from jsons1 where jtag->'location' in ('beijing','tianjing') or jtag?'num' or jtag->'age'=35 ;")
        #need insert new data --data type is double or float and tests ceil floor round .
        tdSql.execute("create table if not exists jsons7(ts timestamp, dataInt int, dataBool bool, datafloat float, datadouble double,dataStr nchar(50)) tags(jtag json)")
        tdSql.execute("insert into jsons7_1 using jsons7 tags('{\"nv\":null,\"tea\":true,\"\":false,\" \":123,\"tea\":false}') values (now,2,'true',0.9,0.1,'123')")
        tdSql.query("select * from jsons7 where jtag->'tea'=0 ;")
        tdSql.checkRows(0)
        tdSql.query("select * from jsons7 where jtag->'tea'=3;")
        # tdSql.checkRows(0)
        tdSql.execute("insert into jsons7_1 values (now,3,'true',-4.8,-5.5,'123') ")
        tdSql.execute("insert into jsons7_1 values (now,4,'true',1.9998,2.00001,'123') ")
        tdSql.execute("insert into jsons7_2 using jsons7 tags('{\"nv\":null,\"tea\":true,\"\":false,\"tag\":123,\"tea\":false}') values (now,5,'true',4.01,2.2,'123') ")
        tdSql.execute("insert into jsons7_2 (ts,datadouble) values (now,-0.9) ")
        tdSql.execute("insert into jsons7_2 (ts,datadouble) values (now,-2.9) ")
        tdSql.execute("insert into jsons7_2 (ts,datafloat) values (now,-0.9) ")
        tdSql.execute("insert into jsons7_2 (ts,datafloat) values (now,-1.9) ")
        # tdSql.execute("CREATE TABLE if not exists jsons7_3 using jsons7 tags('{\"nv\":null,\"tea\":true,\"\":false,\"tag\":4569\"tea\":false}') ")
        tdSql.query("select ts,ceil(dataint),ceil(datafloat),ceil(datadouble) from jsons7 where jtag?'tea';")
        tdSql.query("select ceil(dataint),ceil(datafloat),ceil(datadouble) from jsons7 where jtag?'tea';")
        tdSql.query("select ts,floor(dataint),floor(datafloat),floor(datadouble) from jsons7 where jtag?'tea';")
        tdSql.query("select floor(dataint),floor(datafloat),floor(datadouble) from jsons7 where jtag?'tea';")
        tdSql.query("select ts,round(dataint),round(datafloat),round(datadouble) from jsons7 where jtag?'tea';")
        tdSql.query("select round(dataint),round(datafloat),round(datadouble) from jsons7 where jtag?'tea';")

        
        # test join
        tdSql.execute("create table if not exists jsons6(ts timestamp, dataInt int, dataBool bool, dataStr nchar(50)) tags(jtag json)")
        tdSql.execute("create table if not exists jsons5(ts timestamp, dataInt int, dataBool bool, dataStr nchar(50)) tags(jtag json)")
        tdSql.execute("CREATE TABLE if not exists jsons6_1 using jsons6 tags('{\"loc\":\"fff\",\"id\":6}')")
        tdSql.execute("CREATE TABLE if not exists jsons6_2 using jsons6 tags('{\"loc\":\"ffc\",\"id\":5}')")
        tdSql.execute("insert into jsons6_1 values ('2020-04-18 15:00:00.000', 1, false, 'json1')")
        tdSql.execute("insert into jsons6_2 values ('2020-04-18 15:00:01.000', 2, false, 'json1')")
        tdSql.execute("insert into jsons5_1 using jsons5 tags('{\"loc\":\"fff\",\"num\":5,\"location\":\"beijing\"}') values ('2020-04-18 15:00:00.000', 2, true, 'json2')")
        tdSql.execute("insert into jsons5_2 using jsons5 tags('{\"loc\":\"fff\",\"id\":5,\"location\":\"beijing\"}') values ('2020-04-18 15:00:01.000', 2, true, 'json2')")

        tdSql.error("select 'sss',33,a.jtag->'loc' from jsons6 a,jsons5 b where a.ts=b.ts and a.jtag->'loc'=b.jtag->'loc'")
        # tdSql.query("select 'sss',33,a.jtag->'loc' from jsons6 a,jsons5 b where a.ts=b.ts and a.jtag->'id'=b.jtag->'id'")
        # tdSql.checkData(0, 0, "sss")
        # tdSql.checkData(0, 2, "ffc")


        # query  child table 
        # tdSql.error("select * from  jsons3_2 where jtag3->'k1'=true;")
        # tdSql.checkData(0, 0, None)
        # tdSql.checkRows(3)



        # # test drop tables and databases
        # tdSql.execute("drop table jsons1_1")
        # tdSql.execute("drop stable jsons1")
        # tdSql.execute("drop stable jsons3")
        # tdSql.execute("drop stable jsons2")
        # tdSql.execute("drop database db_json_tag_test")



    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
