/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 374
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNodeList* yy24;
  SDataType yy48;
  bool yy97;
  SAlterOption yy189;
  int32_t yy244;
  EFillMode yy250;
  EJoinType yy596;
  EOrder yy598;
  int8_t yy619;
  SNode* yy652;
  ENullOrder yy653;
  SToken yy657;
  EOperatorType yy700;
  int64_t yy701;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             653
#define YYNRULE              483
#define YYNTOKEN             250
#define YY_MAX_SHIFT         652
#define YY_MIN_SHIFTREDUCE   953
#define YY_MAX_SHIFTREDUCE   1435
#define YY_ERROR_ACTION      1436
#define YY_ACCEPT_ACTION     1437
#define YY_NO_ACTION         1438
#define YY_MIN_REDUCE        1439
#define YY_MAX_REDUCE        1921
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2489)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   567,  422, 1437,  423, 1474, 1742, 1673,  430,  317,  423,
 /*    10 */  1474,  111,   39,   37, 1504,  140, 1739, 1451,  460,   69,
 /*    20 */   326, 1440, 1236, 1742,  488,  151,  334,  526, 1573, 1564,
 /*    30 */  1261,  566,  115, 1311, 1739, 1234, 1847,  486, 1612,  484,
 /*    40 */  1739, 1568,  101, 1735, 1741,  100,   99,   98,   97,   96,
 /*    50 */    95,   94,   93,   92,  570,  119, 1306, 1625, 1755,   14,
 /*    60 */  1844, 1735, 1741,  343,  331, 1242,  373, 1735, 1741,   39,
 /*    70 */    37, 1372,  570, 1623,  566,  474,  473,  326,  570, 1236,
 /*    80 */   472, 1847,    1,  116,  469,  553, 1773,  468,  467,  466,
 /*    90 */  1311, 1625, 1234,  329,  529,  117, 1670,  567,  337, 1725,
 /*   100 */  1462,  549,  504, 1899,  649, 1843, 1899, 1623,  111,  528,
 /*   110 */   153, 1840, 1841, 1306, 1845,  465,   14,  156, 1313, 1314,
 /*   120 */   156, 1896, 1242, 1439, 1896, 1573, 1480, 1786, 1135, 1136,
 /*   130 */    88, 1756,  552, 1758, 1759,  548,   42,  570,   78,    2,
 /*   140 */  1832, 1725, 1899,  209,  319, 1828,  152,  110,  109,  108,
 /*   150 */   107,  106,  105,  104,  103,  102,  156,  439,  232, 1566,
 /*   160 */  1896,  649, 1501, 1237,  141, 1235,  505, 1860, 1530,   60,
 /*   170 */   520,   73,  474,  473,  644, 1313, 1314,  472, 1743,  338,
 /*   180 */   116,  469, 1618, 1620,  468,  467,  466, 1240, 1241, 1739,
 /*   190 */  1289, 1290, 1292, 1293, 1294, 1295, 1296,  545,  568, 1304,
 /*   200 */  1305, 1307, 1308, 1309, 1310, 1312, 1315,   33,   32,  245,
 /*   210 */   246,   40,   38,   36,   35,   34, 1735, 1741,  421,  159,
 /*   220 */  1237,  425, 1235,  626,  625,  624,  341,  570,  623,  622,
 /*   230 */   621,  121,  616,  615,  614,  613,  612,  611,  610,  609,
 /*   240 */   131,  605, 1262,  986, 1240, 1241,   61, 1289, 1290, 1292,
 /*   250 */  1293, 1294, 1295, 1296,  545,  568, 1304, 1305, 1307, 1308,
 /*   260 */  1309, 1310, 1312, 1315,   39,   37,  566, 1236,   60,  490,
 /*   270 */   304, 1396,  326,  159, 1236,   40,   38,   36,   35,   34,
 /*   280 */  1234, 1261, 1406,  990,  991, 1311,   84, 1234, 1093,  593,
 /*   290 */   592,  591, 1097,  590, 1099, 1100,  589, 1102,  586,  120,
 /*   300 */  1108,  583, 1110, 1111,  580,  577,  159, 1565, 1306, 1899,
 /*   310 */  1242,   14,  512, 1394, 1395, 1397, 1398, 1242,  602, 1551,
 /*   320 */   379,   39,   37,  156,   60, 1755,  604, 1896,   43,  326,
 /*   330 */  1003, 1236, 1002, 1260,    2,  330,   60,  129,  128,  599,
 /*   340 */   598,  597, 1311,  138, 1234,  458,  336, 1259,  372,  649,
 /*   350 */   371,  526, 1575, 1773,  138, 1899,  649,  296, 1549,  339,
 /*   360 */  1004,  550,  244, 1575, 1899, 1306, 1725,  138,  549, 1898,
 /*   370 */  1313, 1314,  231, 1896, 1242, 1899, 1575,  439,  157,  119,
 /*   380 */    33,   32, 1896,  530,   40,   38,   36,   35,   34, 1897,
 /*   390 */  1379,    8,  567, 1896, 1786, 1663, 1260,   87, 1756,  552,
 /*   400 */  1758, 1759,  548,  161,  570,  159,  168, 1832, 1237,  364,
 /*   410 */  1235,  298, 1828,  649, 1773, 1237,  604, 1235,  515,  117,
 /*   420 */  1573,   83,  519, 1899, 1218, 1219, 1242, 1313, 1314,  366,
 /*   430 */   362,   80, 1240, 1241,  154, 1840, 1841,  158, 1845, 1240,
 /*   440 */  1241, 1896, 1289, 1290, 1292, 1293, 1294, 1295, 1296,  545,
 /*   450 */   568, 1304, 1305, 1307, 1308, 1309, 1310, 1312, 1315,  101,
 /*   460 */   518,  159,  100,   99,   98,   97,   96,   95,   94,   93,
 /*   470 */    92,  427, 1237,  159, 1235,   33,   32, 1258,   26,   40,
 /*   480 */    38,   36,   35,   34,   33,   32,  412, 1321,   40,   38,
 /*   490 */    36,   35,   34, 1260,  521,  516, 1240, 1241,  596, 1289,
 /*   500 */  1290, 1292, 1293, 1294, 1295, 1296,  545,  568, 1304, 1305,
 /*   510 */  1307, 1308, 1309, 1310, 1312, 1315,   39,   37, 1316,  567,
 /*   520 */   202,   30,  240,  567,  326,  607, 1236, 1432,  159, 1461,
 /*   530 */   377, 1460,  170,  169,  378, 1745, 1003, 1311, 1002, 1234,
 /*   540 */   497, 1459,   28,   36,   35,   34,    7, 1573,   33,   32,
 /*   550 */  1386, 1573,   40,   38,   36,   35,   34,   33,   32, 1755,
 /*   560 */  1306,   40,   38,   36,   35,   34, 1004, 1291, 1458, 1242,
 /*   570 */  1725, 1747, 1725,   39,   37, 1755, 1619, 1620,  479,   71,
 /*   580 */   304,  326, 1725, 1236,   33,   32,    9, 1773,   40,   38,
 /*   590 */    36,   35,   34,  489, 1311,  550, 1234,  138,   69,  567,
 /*   600 */  1725,  567,  549, 1773,   11,   10, 1576,  201,  649, 1725,
 /*   610 */   382,  529,  397, 1431,  166, 1457, 1725, 1306,  549,   22,
 /*   620 */  1569,  482, 1313, 1314, 1550,  476, 1242, 1573, 1786, 1573,
 /*   630 */   200,   89, 1756,  552, 1758, 1759,  548,  429,  570,   67,
 /*   640 */   425, 1832,   66,    9, 1786, 1831, 1828,   88, 1756,  552,
 /*   650 */  1758, 1759,  548, 1055,  570,   55, 1725, 1832,   54,  526,
 /*   660 */  1562,  319, 1828,  152, 1291,  649, 1335, 1237, 1558, 1235,
 /*   670 */    33,   32, 1456, 1455,   40,   38,   36,   35,   34, 1313,
 /*   680 */  1314, 1548,  600, 1057, 1861, 1616, 1347,  119, 1454, 1340,
 /*   690 */  1453, 1240, 1241, 1450, 1289, 1290, 1292, 1293, 1294, 1295,
 /*   700 */  1296,  545,  568, 1304, 1305, 1307, 1308, 1309, 1310, 1312,
 /*   710 */  1315,  471,  470, 1725, 1725,   33,   32, 1371,  602,   40,
 /*   720 */    38,   36,   35,   34, 1237, 1367, 1235,  117,   27, 1725,
 /*   730 */  1449, 1725, 1448, 1447, 1725,  310, 1446,  129,  128,  599,
 /*   740 */   598,  597,  155, 1840, 1841, 1274, 1845, 1669, 1240, 1241,
 /*   750 */   305, 1289, 1290, 1292, 1293, 1294, 1295, 1296,  545,  568,
 /*   760 */  1304, 1305, 1307, 1308, 1309, 1310, 1312, 1315,   39,   37,
 /*   770 */   295, 1725, 1258, 1725, 1725,  602,  326, 1725, 1236,  405,
 /*   780 */   464, 1847,  417,  311, 1445,  309,  308, 1668,  462, 1311,
 /*   790 */   305, 1234,  464, 1263,  129,  128,  599,  598,  597,  390,
 /*   800 */    58,  418,  463,  392,  567, 1842,  620,  618,  553,  567,
 /*   810 */  1260,  567, 1306,  567,  463,  398,  567, 1444,  567, 1671,
 /*   820 */   438, 1242, 1570, 1713, 1702, 1725, 1443,  498, 1755,  502,
 /*   830 */   534,  567, 1573,  383, 1625,  990,  991, 1573,    2, 1573,
 /*   840 */   267, 1573,  564, 1603, 1573,  537, 1573,   33,   32, 1560,
 /*   850 */  1624,   40,   38,   36,   35,   34, 1773,  137, 1725, 1573,
 /*   860 */   649,  608,  601, 1545,  550, 1616, 1556, 1725, 1442, 1725,
 /*   870 */   352,  549, 1491,  416, 1313, 1314,  411,  410,  409,  408,
 /*   880 */   407,  404,  403,  402,  401,  400,  396,  395,  394,  393,
 /*   890 */   387,  386,  385,  384,  475,  381,  380, 1786,  299, 1245,
 /*   900 */    88, 1756,  552, 1758, 1759,  548,  567,  570,  208, 1725,
 /*   910 */  1832, 1852, 1367, 1486,  319, 1828, 1912,  565,  188, 1237,
 /*   920 */   205, 1235, 1274,  212,  544, 1867,  193,  619,  195,  191,
 /*   930 */  1333,  194,  144, 1370, 1573,  477,   72,  456,  452,  448,
 /*   940 */   444,  187,  197, 1240, 1241,  196, 1289, 1290, 1292, 1293,
 /*   950 */  1294, 1295, 1296,  545,  568, 1304, 1305, 1307, 1308, 1309,
 /*   960 */  1310, 1312, 1315,  139,  567,  567,   70,  367,  273,  185,
 /*   970 */    52,  501,  595,   50,  199,  256,  340,  198, 1484,  542,
 /*   980 */   216, 1291,  271,   57, 1334, 1452,   56, 1531,   11,   10,
 /*   990 */   513,  235, 1573, 1573, 1434, 1435,   41,   41,  457,   41,
 /*  1000 */   480,  242,  171,  123,  126,  127,  491, 1339,  223, 1244,
 /*  1010 */  1027,   33,   32, 1393, 1774,   40,   38,   36,   35,   34,
 /*  1020 */   218,  342, 1475,   50,  575,  535,  126,   60,  127, 1248,
 /*  1030 */   526,  184,  177,  532,  182, 1613, 1341, 1297,  435, 1186,
 /*  1040 */  1028,  247,  538,  559,  253, 1086,   29,  324, 1328, 1329,
 /*  1050 */  1330, 1331, 1332, 1336, 1337, 1338,  112,  175,  119,  126,
 /*  1060 */   527, 1863,  299,  266, 1114,   86, 1118,  234, 1125,    5,
 /*  1070 */     3,  237,  239,  344, 1258,  347,  351,  306, 1055,  307,
 /*  1080 */   530,  263, 1202,  399,  167, 1665,  406,  414,  413,  419,
 /*  1090 */  1264,  415,  420,  428, 1333, 1267, 1123,  431,  117,  130,
 /*  1100 */    64,   63,  376,  432, 1266,  165,  174, 1325, 1755,  176,
 /*  1110 */   433,  370, 1268,  229, 1840,  525,  434,  524,  179,  436,
 /*  1120 */  1899, 1265,  294,  181,  183,  360,   68,  358,  354,  350,
 /*  1130 */   162,  345,  437,  186,  158,  440, 1773,  459, 1896, 1247,
 /*  1140 */  1707,  461,   91, 1563,  550,  297,  190, 1559, 1334, 1725,
 /*  1150 */   192,  549,  132,  264,  133,  203, 1561,  492, 1557,  134,
 /*  1160 */   135, 1755,  206,  493,  159,  499,  530,  503,  210, 1263,
 /*  1170 */   514, 1339, 1874,  316, 1864,  556,  496, 1786, 1873,    6,
 /*  1180 */    87, 1756,  552, 1758, 1759,  548, 1854,  570,  509, 1773,
 /*  1190 */  1832,  214,  511,  523,  298, 1828,  217,  550,  510,  508,
 /*  1200 */   146,  318, 1725, 1755,  549,  517, 1899,  224,  222,  225,
 /*  1210 */    29,  324, 1328, 1329, 1330, 1331, 1332, 1336, 1337, 1338,
 /*  1220 */   156,  507,  227, 1367, 1896,  118, 1262,   44,  539,  536,
 /*  1230 */  1786, 1773, 1848,   88, 1756,  552, 1758, 1759,  548,  550,
 /*  1240 */   570,  226,  228, 1832, 1725,   18,  549,  319, 1828, 1912,
 /*  1250 */   333,  332,  320, 1813,  560,  561, 1915, 1895, 1890,  249,
 /*  1260 */  1250,  533,  233,  236,  124,  540,  554,  555,  238,  125,
 /*  1270 */  1706, 1311, 1786, 1243,  251,   88, 1756,  552, 1758, 1759,
 /*  1280 */   548, 1755,  570,  265, 1675, 1832,  562,  557,  328,  319,
 /*  1290 */  1828, 1912,   79,   77, 1306, 1617, 1574,  573, 1546,  268,
 /*  1300 */  1851,  645,  646, 1242,  259,  648,  145,  289, 1755, 1773,
 /*  1310 */    51,  291,  290,  270,  272, 1719, 1718,  550,   62, 1717,
 /*  1320 */  1714,  346, 1725,  348,  549,  349, 1229, 1230,  163,  353,
 /*  1330 */  1712,  355,  356,  357, 1711,  359, 1773, 1710,  361,  530,
 /*  1340 */  1709, 1708,  571,  363,  550,  365, 1692,  368,  164, 1725,
 /*  1350 */  1786,  549, 1205,  280, 1756,  552, 1758, 1759,  548,  369,
 /*  1360 */   570, 1204, 1686, 1685,  374,  375,  530, 1684, 1683, 1174,
 /*  1370 */  1658, 1657, 1656,   65, 1655, 1654, 1755, 1786, 1653, 1899,
 /*  1380 */   280, 1756,  552, 1758, 1759,  548, 1652,  570, 1651,  388,
 /*  1390 */   389, 1650,  391,  158, 1649, 1648, 1647, 1896, 1646, 1645,
 /*  1400 */  1644, 1251, 1643, 1246, 1773, 1176, 1899, 1642, 1641, 1640,
 /*  1410 */  1639, 1638,  550, 1637, 1636,  122, 1635, 1725, 1755,  549,
 /*  1420 */   156, 1634, 1633, 1632, 1896, 1254, 1631, 1630, 1629, 1628,
 /*  1430 */  1627, 1626, 1503, 1471,  172,  424,  568, 1304, 1305, 1307,
 /*  1440 */  1308, 1309, 1310, 1755,  150, 1786, 1773, 1021,   89, 1756,
 /*  1450 */   552, 1758, 1759,  548,  547,  570,  113,  993, 1832, 1725,
 /*  1460 */   992,  549,  541, 1828,  426, 1470, 1700, 1694, 1682, 1681,
 /*  1470 */  1667, 1773,  180, 1552,  173,  114,  178, 1502, 1500,  550,
 /*  1480 */   526,  443,  442,  441, 1725, 1498,  549, 1786,  445,  447,
 /*  1490 */   287, 1756,  552, 1758, 1759,  548,  546,  570,  543, 1804,
 /*  1500 */  1755,  446, 1496,  450, 1494,  454,  449, 1483,  119,  453,
 /*  1510 */  1482,  451, 1786,  189,  455,  142, 1756,  552, 1758, 1759,
 /*  1520 */   548, 1467,  570, 1554, 1129, 1128, 1553, 1054, 1773,   49,
 /*  1530 */   530, 1053, 1052, 1051,  617, 1048,  550,  619, 1492,  312,
 /*  1540 */  1047, 1725, 1487,  549, 1046, 1485,  313,  314,  117,  481,
 /*  1550 */   478, 1466, 1465,  483,  485, 1464,  487, 1755, 1699,   90,
 /*  1560 */   531, 1913,   53,  229, 1840,  525, 1212,  524, 1693, 1786,
 /*  1570 */  1899,  494,   89, 1756,  552, 1758, 1759,  548, 1755,  570,
 /*  1580 */  1680, 1678, 1832, 1679,  156, 1773,  207, 1829, 1896,  136,
 /*  1590 */   495,  315, 1677,  550, 1676, 1408,  500,    4, 1725,   41,
 /*  1600 */   549,   45,   15,  215,   23,   47, 1773,  220,   25,  213,
 /*  1610 */    46, 1392,  506, 1385,  550,  143,   16,  219,   24, 1725,
 /*  1620 */   221,  549, 1745,   74,  230,  147, 1786, 1364,   17,  288,
 /*  1630 */  1756,  552, 1758, 1759,  548, 1755,  570, 1420,   13, 1419,
 /*  1640 */  1363,  321, 1425, 1414, 1424, 1423,  322, 1786,   10, 1326,
 /*  1650 */   283, 1756,  552, 1758, 1759,  548,   19,  570, 1755, 1282,
 /*  1660 */  1299,  148,  160, 1773,   31,  551, 1674, 1298,   12,   20,
 /*  1670 */    21,  550,  241, 1390, 1666,  243, 1725,  248,  549,   75,
 /*  1680 */   558,  250,   76,  252, 1744,  255, 1773, 1789,   80,  522,
 /*  1690 */  1301, 1252,  572,  574,  550, 1115,  569,  335,  578, 1725,
 /*  1700 */  1755,  549,   48,  576, 1786, 1112,  579,  142, 1756,  552,
 /*  1710 */  1758, 1759,  548,  323,  570, 1109, 1755,  581,  582,  584,
 /*  1720 */   587, 1092,  594, 1103, 1101,  585,  588, 1786, 1773, 1107,
 /*  1730 */   288, 1756,  552, 1758, 1759,  548,  547,  570,   81, 1106,
 /*  1740 */  1105, 1725,   82,  549, 1773, 1124,   59,  257, 1120, 1019,
 /*  1750 */   603, 1104,  550, 1914, 1043,  606,  258, 1725, 1061,  549,
 /*  1760 */  1041, 1036, 1040, 1039, 1038, 1037, 1755, 1035, 1034, 1786,
 /*  1770 */  1058,  325,  287, 1756,  552, 1758, 1759,  548, 1056,  570,
 /*  1780 */  1031, 1805, 1030, 1029, 1026, 1786, 1025, 1024,  288, 1756,
 /*  1790 */   552, 1758, 1759,  548, 1773,  570,  652, 1499,  627,  629,
 /*  1800 */   628, 1497,  550,  631,  632,  633, 1495, 1725,  635,  549,
 /*  1810 */   262,  636, 1493,  637,  639,  641,  640, 1481,  643,  983,
 /*  1820 */  1463,  327,  261, 1755,  149,  647, 1438, 1238,  650,  642,
 /*  1830 */   638,  634,  630,  260, 1438, 1786,  269, 1438,  288, 1756,
 /*  1840 */   552, 1758, 1759,  548,  651,  570, 1438, 1438, 1438, 1438,
 /*  1850 */  1438, 1773, 1438, 1438, 1438, 1438, 1438, 1438,   85,  550,
 /*  1860 */  1438,  254, 1438, 1438, 1725, 1438,  549, 1438, 1438, 1438,
 /*  1870 */  1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438,
 /*  1880 */  1438, 1438, 1438, 1438, 1755, 1438, 1438, 1438, 1438, 1438,
 /*  1890 */  1438, 1438, 1786, 1438,  563,  274, 1756,  552, 1758, 1759,
 /*  1900 */   548, 1755,  570, 1438, 1438, 1438, 1438, 1438, 1438, 1438,
 /*  1910 */  1438, 1438, 1773, 1438, 1438, 1438, 1438, 1438, 1438, 1438,
 /*  1920 */   550, 1438, 1438, 1438, 1438, 1725,  211,  549, 1438, 1773,
 /*  1930 */  1438, 1438, 1438, 1438, 1438, 1438, 1438,  550, 1438, 1438,
 /*  1940 */  1438, 1438, 1725, 1755,  549, 1438, 1438, 1210, 1438,  204,
 /*  1950 */  1438, 1438, 1438, 1786, 1755, 1438,  275, 1756,  552, 1758,
 /*  1960 */  1759,  548, 1438,  570, 1438, 1755, 1438, 1438, 1438, 1438,
 /*  1970 */  1786, 1773, 1438,  276, 1756,  552, 1758, 1759,  548,  550,
 /*  1980 */   570, 1438, 1773, 1438, 1725, 1438,  549, 1438, 1438, 1438,
 /*  1990 */   550, 1438, 1438, 1773, 1438, 1725, 1438,  549, 1438, 1438,
 /*  2000 */  1438,  550, 1438, 1438, 1438, 1438, 1725, 1755,  549, 1438,
 /*  2010 */  1438, 1438, 1786, 1438, 1438,  282, 1756,  552, 1758, 1759,
 /*  2020 */   548, 1438,  570, 1786, 1438, 1755,  284, 1756,  552, 1758,
 /*  2030 */  1759,  548, 1438,  570, 1786, 1773, 1438,  277, 1756,  552,
 /*  2040 */  1758, 1759,  548,  550,  570, 1438, 1438, 1438, 1725, 1755,
 /*  2050 */   549, 1438, 1438, 1773, 1438, 1438, 1438, 1438, 1438, 1438,
 /*  2060 */  1438,  550, 1438, 1438, 1438, 1438, 1725, 1438,  549, 1438,
 /*  2070 */  1438, 1438, 1438, 1438, 1438, 1438, 1786, 1773, 1438,  285,
 /*  2080 */  1756,  552, 1758, 1759,  548,  550,  570, 1438, 1438, 1438,
 /*  2090 */  1725, 1438,  549, 1438, 1786, 1438, 1438,  278, 1756,  552,
 /*  2100 */  1758, 1759,  548, 1438,  570, 1755, 1438, 1438, 1438, 1438,
 /*  2110 */  1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1786, 1438,
 /*  2120 */  1438,  286, 1756,  552, 1758, 1759,  548, 1438,  570, 1438,
 /*  2130 */  1438, 1438, 1438, 1773, 1438, 1438, 1438, 1438, 1438, 1438,
 /*  2140 */  1438,  550, 1438, 1438, 1438, 1438, 1725, 1438,  549, 1438,
 /*  2150 */  1438, 1438, 1438, 1438, 1438, 1755, 1438, 1438, 1438, 1438,
 /*  2160 */  1438, 1438, 1438, 1438, 1438, 1438, 1755, 1438, 1438, 1438,
 /*  2170 */  1438, 1438, 1438, 1438, 1786, 1438, 1438,  279, 1756,  552,
 /*  2180 */  1758, 1759,  548, 1773,  570, 1438, 1438, 1438, 1438, 1438,
 /*  2190 */  1438,  550, 1438, 1438, 1773, 1438, 1725, 1438,  549, 1438,
 /*  2200 */  1438, 1438,  550, 1438, 1438, 1438, 1438, 1725, 1755,  549,
 /*  2210 */  1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1755,
 /*  2220 */  1438, 1438, 1438, 1438, 1786, 1438, 1438,  292, 1756,  552,
 /*  2230 */  1758, 1759,  548, 1755,  570, 1786, 1773, 1438,  293, 1756,
 /*  2240 */   552, 1758, 1759,  548,  550,  570, 1438, 1773, 1438, 1725,
 /*  2250 */  1438,  549, 1438, 1438, 1438,  550, 1438, 1438, 1438, 1438,
 /*  2260 */  1725, 1773,  549, 1438, 1438, 1438, 1438, 1438, 1438,  550,
 /*  2270 */  1438, 1438, 1438, 1438, 1725, 1438,  549, 1786, 1438, 1438,
 /*  2280 */  1767, 1756,  552, 1758, 1759,  548, 1438,  570, 1786, 1755,
 /*  2290 */  1438, 1766, 1756,  552, 1758, 1759,  548, 1438,  570, 1438,
 /*  2300 */  1438, 1438, 1786, 1755, 1438, 1765, 1756,  552, 1758, 1759,
 /*  2310 */   548, 1438,  570, 1438, 1438, 1438, 1438, 1773, 1438, 1438,
 /*  2320 */  1438, 1438, 1438, 1438, 1438,  550, 1438, 1438, 1438, 1438,
 /*  2330 */  1725, 1773,  549, 1438, 1438, 1438, 1438, 1438, 1438,  550,
 /*  2340 */  1438, 1438, 1438, 1438, 1725, 1438,  549, 1438, 1438, 1438,
 /*  2350 */  1438, 1438, 1438, 1755, 1438, 1438, 1438, 1438, 1786, 1438,
 /*  2360 */  1438,  302, 1756,  552, 1758, 1759,  548, 1438,  570, 1438,
 /*  2370 */  1438, 1438, 1786, 1438, 1438,  301, 1756,  552, 1758, 1759,
 /*  2380 */   548, 1773,  570, 1438, 1438, 1438, 1438, 1438, 1438,  550,
 /*  2390 */  1438, 1438, 1438, 1438, 1725, 1755,  549, 1438, 1438, 1438,
 /*  2400 */  1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1755,
 /*  2410 */  1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438, 1438,
 /*  2420 */  1438, 1438, 1786, 1773, 1438,  303, 1756,  552, 1758, 1759,
 /*  2430 */   548,  550,  570, 1438, 1438, 1438, 1725, 1773,  549, 1438,
 /*  2440 */  1438, 1438, 1438, 1438, 1438,  550, 1438, 1438, 1438, 1438,
 /*  2450 */  1725, 1438,  549, 1438, 1438, 1438, 1438, 1438, 1438, 1438,
 /*  2460 */  1438, 1438, 1438, 1438, 1786, 1438, 1438,  300, 1756,  552,
 /*  2470 */  1758, 1759,  548, 1438,  570, 1438, 1438, 1438, 1786, 1438,
 /*  2480 */  1438,  281, 1756,  552, 1758, 1759,  548, 1438,  570,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   261,  257,  250,  259,  260,  283,    0,  257,  286,  259,
 /*    10 */   260,  272,   12,   13,    0,  252,  294,  254,  279,  265,
 /*    20 */    20,    0,   22,  283,   21,  280,  286,  261,  289,  283,
 /*    30 */    20,   20,  278,   33,  294,   35,  323,   34,  293,   36,
 /*    40 */   294,  287,   21,  321,  322,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  332,  289,   56,  281,  253,   59,
 /*    60 */   347,  321,  322,  311,  288,   65,  311,  321,  322,   12,
 /*    70 */    13,   14,  332,  297,   20,   61,   62,   20,  332,   22,
 /*    80 */    66,  323,   82,   69,   70,  296,  281,   73,   74,   75,
 /*    90 */    33,  281,   35,  304,  289,  329,  307,  261,  288,  294,
 /*   100 */   253,  296,  311,  351,  104,  347,  351,  297,  272,  343,
 /*   110 */   344,  345,  346,   56,  348,  279,   59,  365,  118,  119,
 /*   120 */   365,  369,   65,    0,  369,  289,    0,  322,  118,  119,
 /*   130 */   325,  326,  327,  328,  329,  330,   82,  332,  263,   82,
 /*   140 */   335,  294,  351,   56,  339,  340,  341,   24,   25,   26,
 /*   150 */    27,   28,   29,   30,   31,   32,  365,   58,  353,  284,
 /*   160 */   369,  104,    0,  163,  266,  165,  361,  362,  270,   82,
 /*   170 */    20,   84,   61,   62,   48,  118,  119,   66,  283,  292,
 /*   180 */    69,   70,  295,  296,   73,   74,   75,  187,  188,  294,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,    8,    9,  113,
 /*   210 */   114,   12,   13,   14,   15,   16,  321,  322,  258,  219,
 /*   220 */   163,  261,  165,   61,   62,   63,   64,  332,   66,   67,
 /*   230 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   240 */    78,   79,   20,    4,  187,  188,    4,  190,  191,  192,
 /*   250 */   193,  194,  195,  196,  197,  198,  199,  200,  201,  202,
 /*   260 */   203,  204,  205,  206,   12,   13,   20,   22,   82,  311,
 /*   270 */   174,  187,   20,  219,   22,   12,   13,   14,   15,   16,
 /*   280 */    35,   20,   83,   44,   45,   33,  263,   35,   95,   96,
 /*   290 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  276,
 /*   300 */   107,  108,  109,  110,  111,  112,  219,  284,   56,  351,
 /*   310 */    65,   59,  228,  229,  230,  231,  232,   65,   94,    0,
 /*   320 */   261,   12,   13,  365,   82,  253,   58,  369,   82,   20,
 /*   330 */    20,   22,   22,   20,   82,  273,   82,  113,  114,  115,
 /*   340 */   116,  117,   33,  281,   35,   35,  273,   20,  162,  104,
 /*   350 */   164,  261,  290,  281,  281,  351,  104,  298,    0,  273,
 /*   360 */    50,  289,  113,  290,  351,   56,  294,  281,  296,  365,
 /*   370 */   118,  119,  150,  369,   65,  351,  290,   58,  365,  289,
 /*   380 */     8,    9,  369,  311,   12,   13,   14,   15,   16,  365,
 /*   390 */    14,   82,  261,  369,  322,  289,   20,  325,  326,  327,
 /*   400 */   328,  329,  330,  272,  332,  219,  300,  335,  163,  158,
 /*   410 */   165,  339,  340,  104,  281,  163,   58,  165,  148,  329,
 /*   420 */   289,   82,  289,  351,  175,  176,   65,  118,  119,  178,
 /*   430 */   179,   92,  187,  188,  344,  345,  346,  365,  348,  187,
 /*   440 */   188,  369,  190,  191,  192,  193,  194,  195,  196,  197,
 /*   450 */   198,  199,  200,  201,  202,  203,  204,  205,  206,   21,
 /*   460 */   327,  219,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   470 */    32,   14,  163,  219,  165,    8,    9,   20,    2,   12,
 /*   480 */    13,   14,   15,   16,    8,    9,   76,   14,   12,   13,
 /*   490 */    14,   15,   16,   20,  224,  225,  187,  188,   93,  190,
 /*   500 */   191,  192,  193,  194,  195,  196,  197,  198,  199,  200,
 /*   510 */   201,  202,  203,  204,  205,  206,   12,   13,   14,  261,
 /*   520 */   114,  336,  337,  261,   20,   65,   22,  155,  219,  253,
 /*   530 */   272,  253,  122,  123,  272,   46,   20,   33,   22,   35,
 /*   540 */   315,  253,    2,   14,   15,   16,   39,  289,    8,    9,
 /*   550 */    83,  289,   12,   13,   14,   15,   16,    8,    9,  253,
 /*   560 */    56,   12,   13,   14,   15,   16,   50,  191,  253,   65,
 /*   570 */   294,   82,  294,   12,   13,  253,  295,  296,    4,  173,
 /*   580 */   174,   20,  294,   22,    8,    9,   82,  281,   12,   13,
 /*   590 */    14,   15,   16,   19,   33,  289,   35,  281,  265,  261,
 /*   600 */   294,  261,  296,  281,    1,    2,  290,   33,  104,  294,
 /*   610 */   272,  289,  272,  241,   56,  253,  294,   56,  296,   43,
 /*   620 */   287,   47,  118,  119,    0,   51,   65,  289,  322,  289,
 /*   630 */    56,  325,  326,  327,  328,  329,  330,  258,  332,   81,
 /*   640 */   261,  335,   84,   82,  322,  339,  340,  325,  326,  327,
 /*   650 */   328,  329,  330,   35,  332,   81,  294,  335,   84,  261,
 /*   660 */   282,  339,  340,  341,  191,  104,  145,  163,  282,  165,
 /*   670 */     8,    9,  253,  253,   12,   13,   14,   15,   16,  118,
 /*   680 */   119,    0,  291,   65,  362,  294,   83,  289,  253,  168,
 /*   690 */   253,  187,  188,  253,  190,  191,  192,  193,  194,  195,
 /*   700 */   196,  197,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   710 */   206,  267,  268,  294,  294,    8,    9,    4,   94,   12,
 /*   720 */    13,   14,   15,   16,  163,  218,  165,  329,  207,  294,
 /*   730 */   253,  294,  253,  253,  294,   37,  253,  113,  114,  115,
 /*   740 */   116,  117,  344,  345,  346,   83,  348,  306,  187,  188,
 /*   750 */   309,  190,  191,  192,  193,  194,  195,  196,  197,  198,
 /*   760 */   199,  200,  201,  202,  203,  204,  205,  206,   12,   13,
 /*   770 */    18,  294,   20,  294,  294,   94,   20,  294,   22,   27,
 /*   780 */    94,  323,   30,   85,  253,   87,   88,  306,   90,   33,
 /*   790 */   309,   35,   94,   20,  113,  114,  115,  116,  117,   47,
 /*   800 */     3,   49,  116,   51,  261,  347,  267,  268,  296,  261,
 /*   810 */    20,  261,   56,  261,  116,  272,  261,  253,  261,  307,
 /*   820 */   272,   65,  272,    0,  272,  294,  253,  272,  253,  272,
 /*   830 */    43,  261,  289,   81,  281,   44,   45,  289,   82,  289,
 /*   840 */   274,  289,  272,  277,  289,   43,  289,    8,    9,  282,
 /*   850 */   297,   12,   13,   14,   15,   16,  281,  150,  294,  289,
 /*   860 */   104,  269,  291,  271,  289,  294,  282,  294,  253,  294,
 /*   870 */    47,  296,    0,  121,  118,  119,  124,  125,  126,  127,
 /*   880 */   128,  129,  130,  131,  132,  133,  134,  135,  136,  137,
 /*   890 */   138,  139,  140,  141,   22,  143,  144,  322,   59,   35,
 /*   900 */   325,  326,  327,  328,  329,  330,  261,  332,   56,  294,
 /*   910 */   335,  217,  218,    0,  339,  340,  341,  272,   33,  163,
 /*   920 */   282,  165,   83,  150,  282,  350,   86,   43,   86,   89,
 /*   930 */    91,   89,   47,  220,  289,   22,   84,   52,   53,   54,
 /*   940 */    55,   56,   86,  187,  188,   89,  190,  191,  192,  193,
 /*   950 */   194,  195,  196,  197,  198,  199,  200,  201,  202,  203,
 /*   960 */   204,  205,  206,   18,  261,  261,   81,   83,   23,   84,
 /*   970 */   150,  151,  282,   43,   86,  272,  272,   89,    0,   59,
 /*   980 */    43,  191,   37,   38,  145,  254,   41,  270,    1,    2,
 /*   990 */   363,  372,  289,  289,  118,  119,   43,   43,  262,   43,
 /*  1000 */    22,   43,   57,   43,   43,   43,  318,  168,  358,   35,
 /*  1010 */    35,    8,    9,   83,  281,   12,   13,   14,   15,   16,
 /*  1020 */    83,  262,  260,   43,   43,  238,   43,   82,   43,  165,
 /*  1030 */   261,  146,  147,  236,  149,  293,   83,   83,  153,   83,
 /*  1040 */    65,   83,  240,   83,   83,   83,  207,  208,  209,  210,
 /*  1050 */   211,  212,  213,  214,  215,  216,   43,  172,  289,   43,
 /*  1060 */   349,  324,   59,   83,   83,  120,   83,  366,   83,  221,
 /*  1070 */   352,  366,  366,  320,   20,  261,   47,  319,   35,  267,
 /*  1080 */   311,  313,  161,  261,   42,  261,  301,  145,  299,  261,
 /*  1090 */    20,  299,  255,  255,   91,   20,   83,  317,  329,   83,
 /*  1100 */   155,  156,  157,  296,   20,  160,  265,  187,  253,  265,
 /*  1110 */   310,  166,   20,  344,  345,  346,  312,  348,  265,  310,
 /*  1120 */   351,   20,  177,  265,  265,  180,  265,  182,  183,  184,
 /*  1130 */   185,  186,  302,  265,  365,  261,  281,  255,  369,  165,
 /*  1140 */   294,  281,  261,  281,  289,  255,  281,  281,  145,  294,
 /*  1150 */   281,  296,  281,  317,  281,  263,  281,  171,  281,  281,
 /*  1160 */   281,  253,  263,  316,  219,  261,  311,  261,  263,   20,
 /*  1170 */   227,  168,  357,  310,  324,  226,  296,  322,  357,  233,
 /*  1180 */   325,  326,  327,  328,  329,  330,  360,  332,  294,  281,
 /*  1190 */   335,  305,  294,  154,  339,  340,  305,  289,  235,  234,
 /*  1200 */   357,  294,  294,  253,  296,  294,  351,  356,  359,  355,
 /*  1210 */   207,  208,  209,  210,  211,  212,  213,  214,  215,  216,
 /*  1220 */   365,  222,  320,  218,  369,  289,   20,   42,  239,  237,
 /*  1230 */   322,  281,  323,  325,  326,  327,  328,  329,  330,  289,
 /*  1240 */   332,  354,  342,  335,  294,   82,  296,  339,  340,  341,
 /*  1250 */    12,   13,  242,  338,  147,  303,  373,  368,  350,  289,
 /*  1260 */    22,  368,  367,  367,  305,  368,  294,  294,  367,  305,
 /*  1270 */   294,   33,  322,   35,  263,  325,  326,  327,  328,  329,
 /*  1280 */   330,  253,  332,  277,  294,  335,  302,  294,  294,  339,
 /*  1290 */   340,  341,   82,  263,   56,  294,  289,  285,  271,  261,
 /*  1300 */   350,   36,  256,   65,  263,  255,  309,  275,  253,  281,
 /*  1310 */   314,  275,  275,  264,  251,    0,    0,  289,   42,    0,
 /*  1320 */     0,   73,  294,   35,  296,  181,   35,   35,   35,  181,
 /*  1330 */     0,   35,   35,  181,    0,  181,  281,    0,   35,  311,
 /*  1340 */     0,    0,  104,   22,  289,   35,    0,  168,   82,  294,
 /*  1350 */   322,  296,  165,  325,  326,  327,  328,  329,  330,  167,
 /*  1360 */   332,  163,    0,    0,  159,  158,  311,    0,    0,   46,
 /*  1370 */     0,    0,    0,  142,    0,    0,  253,  322,    0,  351,
 /*  1380 */   325,  326,  327,  328,  329,  330,    0,  332,    0,  137,
 /*  1390 */    35,    0,  137,  365,    0,    0,    0,  369,    0,    0,
 /*  1400 */     0,  163,    0,  165,  281,   22,  351,    0,    0,    0,
 /*  1410 */     0,    0,  289,    0,    0,   42,    0,  294,  253,  296,
 /*  1420 */   365,    0,    0,    0,  369,  187,    0,    0,    0,    0,
 /*  1430 */     0,    0,    0,    0,   42,   46,  198,  199,  200,  201,
 /*  1440 */   202,  203,  204,  253,   43,  322,  281,   60,  325,  326,
 /*  1450 */   327,  328,  329,  330,  289,  332,   39,   14,  335,  294,
 /*  1460 */    14,  296,  339,  340,   46,    0,    0,    0,    0,    0,
 /*  1470 */     0,  281,  154,    0,   40,   39,   39,    0,    0,  289,
 /*  1480 */   261,   39,   47,   35,  294,    0,  296,  322,   35,   39,
 /*  1490 */   325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
 /*  1500 */   253,   47,    0,   47,    0,   47,   35,    0,  289,   35,
 /*  1510 */     0,   39,  322,   89,   39,  325,  326,  327,  328,  329,
 /*  1520 */   330,    0,  332,    0,   35,   22,    0,   35,  281,   91,
 /*  1530 */   311,   35,   35,   35,   43,   35,  289,   43,    0,   22,
 /*  1540 */    35,  294,    0,  296,   35,    0,   22,   22,  329,   35,
 /*  1550 */    49,    0,    0,   35,   35,    0,   22,  253,    0,   20,
 /*  1560 */   370,  371,  150,  344,  345,  346,   35,  348,    0,  322,
 /*  1570 */   351,   22,  325,  326,  327,  328,  329,  330,  253,  332,
 /*  1580 */     0,    0,  335,    0,  365,  281,  147,  340,  369,  169,
 /*  1590 */   150,  150,    0,  289,    0,   83,  152,   43,  294,   43,
 /*  1600 */   296,  217,  223,   83,   82,   43,  281,   43,   43,   82,
 /*  1610 */    43,   83,  308,   83,  289,   82,  223,   82,   82,  294,
 /*  1620 */    46,  296,   46,   82,   46,   46,  322,   83,   43,  325,
 /*  1630 */   326,  327,  328,  329,  330,  253,  332,   35,  223,   35,
 /*  1640 */    83,   35,   83,   83,   35,   35,   35,  322,    2,  187,
 /*  1650 */   325,  326,  327,  328,  329,  330,   43,  332,  253,   22,
 /*  1660 */    83,   46,   46,  281,   82,  189,    0,   83,   82,   82,
 /*  1670 */    82,  289,   83,   83,    0,   82,  294,   82,  296,   82,
 /*  1680 */   148,   39,   82,  146,   46,   46,  281,   82,   92,  364,
 /*  1690 */    83,   22,   93,   35,  289,   83,   82,   35,   35,  294,
 /*  1700 */   253,  296,   82,   82,  322,   83,   82,  325,  326,  327,
 /*  1710 */   328,  329,  330,  308,  332,   83,  253,   35,   82,   35,
 /*  1720 */    35,   22,   94,   83,   83,   82,   82,  322,  281,  106,
 /*  1730 */   325,  326,  327,  328,  329,  330,  289,  332,   82,  106,
 /*  1740 */   106,  294,   82,  296,  281,   35,   82,   43,   22,   60,
 /*  1750 */    59,  106,  289,  371,   35,   80,   43,  294,   65,  296,
 /*  1760 */    35,   22,   35,   35,   35,   35,  253,   35,   35,  322,
 /*  1770 */    65,  308,  325,  326,  327,  328,  329,  330,   35,  332,
 /*  1780 */    35,  334,   35,   35,   35,  322,   35,   35,  325,  326,
 /*  1790 */   327,  328,  329,  330,  281,  332,   19,    0,   35,   39,
 /*  1800 */    47,    0,  289,   35,   47,   39,    0,  294,   35,  296,
 /*  1810 */    33,   47,    0,   39,   35,   39,   47,    0,   35,   35,
 /*  1820 */     0,  308,   22,  253,   47,   21,  374,   22,   21,   52,
 /*  1830 */    53,   54,   55,   56,  374,  322,   22,  374,  325,  326,
 /*  1840 */   327,  328,  329,  330,   20,  332,  374,  374,  374,  374,
 /*  1850 */   374,  281,  374,  374,  374,  374,  374,  374,   81,  289,
 /*  1860 */   374,   84,  374,  374,  294,  374,  296,  374,  374,  374,
 /*  1870 */   374,  374,  374,  374,  374,  374,  374,  374,  374,  374,
 /*  1880 */   374,  374,  374,  374,  253,  374,  374,  374,  374,  374,
 /*  1890 */   374,  374,  322,  374,  117,  325,  326,  327,  328,  329,
 /*  1900 */   330,  253,  332,  374,  374,  374,  374,  374,  374,  374,
 /*  1910 */   374,  374,  281,  374,  374,  374,  374,  374,  374,  374,
 /*  1920 */   289,  374,  374,  374,  374,  294,  149,  296,  374,  281,
 /*  1930 */   374,  374,  374,  374,  374,  374,  374,  289,  374,  374,
 /*  1940 */   374,  374,  294,  253,  296,  374,  374,  170,  374,  172,
 /*  1950 */   374,  374,  374,  322,  253,  374,  325,  326,  327,  328,
 /*  1960 */   329,  330,  374,  332,  374,  253,  374,  374,  374,  374,
 /*  1970 */   322,  281,  374,  325,  326,  327,  328,  329,  330,  289,
 /*  1980 */   332,  374,  281,  374,  294,  374,  296,  374,  374,  374,
 /*  1990 */   289,  374,  374,  281,  374,  294,  374,  296,  374,  374,
 /*  2000 */   374,  289,  374,  374,  374,  374,  294,  253,  296,  374,
 /*  2010 */   374,  374,  322,  374,  374,  325,  326,  327,  328,  329,
 /*  2020 */   330,  374,  332,  322,  374,  253,  325,  326,  327,  328,
 /*  2030 */   329,  330,  374,  332,  322,  281,  374,  325,  326,  327,
 /*  2040 */   328,  329,  330,  289,  332,  374,  374,  374,  294,  253,
 /*  2050 */   296,  374,  374,  281,  374,  374,  374,  374,  374,  374,
 /*  2060 */   374,  289,  374,  374,  374,  374,  294,  374,  296,  374,
 /*  2070 */   374,  374,  374,  374,  374,  374,  322,  281,  374,  325,
 /*  2080 */   326,  327,  328,  329,  330,  289,  332,  374,  374,  374,
 /*  2090 */   294,  374,  296,  374,  322,  374,  374,  325,  326,  327,
 /*  2100 */   328,  329,  330,  374,  332,  253,  374,  374,  374,  374,
 /*  2110 */   374,  374,  374,  374,  374,  374,  374,  374,  322,  374,
 /*  2120 */   374,  325,  326,  327,  328,  329,  330,  374,  332,  374,
 /*  2130 */   374,  374,  374,  281,  374,  374,  374,  374,  374,  374,
 /*  2140 */   374,  289,  374,  374,  374,  374,  294,  374,  296,  374,
 /*  2150 */   374,  374,  374,  374,  374,  253,  374,  374,  374,  374,
 /*  2160 */   374,  374,  374,  374,  374,  374,  253,  374,  374,  374,
 /*  2170 */   374,  374,  374,  374,  322,  374,  374,  325,  326,  327,
 /*  2180 */   328,  329,  330,  281,  332,  374,  374,  374,  374,  374,
 /*  2190 */   374,  289,  374,  374,  281,  374,  294,  374,  296,  374,
 /*  2200 */   374,  374,  289,  374,  374,  374,  374,  294,  253,  296,
 /*  2210 */   374,  374,  374,  374,  374,  374,  374,  374,  374,  253,
 /*  2220 */   374,  374,  374,  374,  322,  374,  374,  325,  326,  327,
 /*  2230 */   328,  329,  330,  253,  332,  322,  281,  374,  325,  326,
 /*  2240 */   327,  328,  329,  330,  289,  332,  374,  281,  374,  294,
 /*  2250 */   374,  296,  374,  374,  374,  289,  374,  374,  374,  374,
 /*  2260 */   294,  281,  296,  374,  374,  374,  374,  374,  374,  289,
 /*  2270 */   374,  374,  374,  374,  294,  374,  296,  322,  374,  374,
 /*  2280 */   325,  326,  327,  328,  329,  330,  374,  332,  322,  253,
 /*  2290 */   374,  325,  326,  327,  328,  329,  330,  374,  332,  374,
 /*  2300 */   374,  374,  322,  253,  374,  325,  326,  327,  328,  329,
 /*  2310 */   330,  374,  332,  374,  374,  374,  374,  281,  374,  374,
 /*  2320 */   374,  374,  374,  374,  374,  289,  374,  374,  374,  374,
 /*  2330 */   294,  281,  296,  374,  374,  374,  374,  374,  374,  289,
 /*  2340 */   374,  374,  374,  374,  294,  374,  296,  374,  374,  374,
 /*  2350 */   374,  374,  374,  253,  374,  374,  374,  374,  322,  374,
 /*  2360 */   374,  325,  326,  327,  328,  329,  330,  374,  332,  374,
 /*  2370 */   374,  374,  322,  374,  374,  325,  326,  327,  328,  329,
 /*  2380 */   330,  281,  332,  374,  374,  374,  374,  374,  374,  289,
 /*  2390 */   374,  374,  374,  374,  294,  253,  296,  374,  374,  374,
 /*  2400 */   374,  374,  374,  374,  374,  374,  374,  374,  374,  253,
 /*  2410 */   374,  374,  374,  374,  374,  374,  374,  374,  374,  374,
 /*  2420 */   374,  374,  322,  281,  374,  325,  326,  327,  328,  329,
 /*  2430 */   330,  289,  332,  374,  374,  374,  294,  281,  296,  374,
 /*  2440 */   374,  374,  374,  374,  374,  289,  374,  374,  374,  374,
 /*  2450 */   294,  374,  296,  374,  374,  374,  374,  374,  374,  374,
 /*  2460 */   374,  374,  374,  374,  322,  374,  374,  325,  326,  327,
 /*  2470 */   328,  329,  330,  374,  332,  374,  374,  374,  322,  374,
 /*  2480 */   374,  325,  326,  327,  328,  329,  330,  374,  332,
};
#define YY_SHIFT_COUNT    (652)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1824)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   945,    0,    0,   57,  252,  252,  252,  252,  309,  309,
 /*    10 */   252,  252,  504,  561,  756,  561,  561,  561,  561,  561,
 /*    20 */   561,  561,  561,  561,  561,  561,  561,  561,  561,  561,
 /*    30 */   561,  561,  561,  561,  561,  561,  561,  561,  561,  561,
 /*    40 */   561,  561,   54,   54,  246,  246,  246, 1238, 1238, 1238,
 /*    50 */  1238,  186,   87,  254,   11,   11,  239,  239,  242,   10,
 /*    60 */   254,  254,   11,   11,   11,   11,   11,   11,   11,   11,
 /*    70 */    99,   11,   11,   11,  150,  261,  313,   11,   11,  313,
 /*    80 */    11,  313,  313,  313,   11,  268,  752,  839, 1003, 1003,
 /*    90 */   438,  111,  245,  245,  245,  245,  245,  245,  245,  245,
 /*   100 */   245,  245,  245,  245,  245,  245,  245,  245,  245,  245,
 /*   110 */   245,  698,   10,  457,  457,  319,  618,  222,  222,  222,
 /*   120 */   358,  618,  327,  261,    6,    6,  313,  313,  361,  361,
 /*   130 */   405,  460,  193,  193,  193,  193,  193,  193,  193, 1777,
 /*   140 */    21,   14,  372,   84,  310,  406,  270,  376,  473,  516,
 /*   150 */   791,  686,  773,  694,  507,  694,  797,  797,  797,  713,
 /*   160 */   790,  848, 1054, 1029, 1043,  921, 1054, 1054, 1042,  942,
 /*   170 */   942, 1054, 1070, 1070, 1075,   99,  261,   99, 1084, 1092,
 /*   180 */    99, 1084,   99, 1101,   99,   99, 1054,   99, 1070,  313,
 /*   190 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*   200 */  1054, 1070,  361, 1075,  268,  986,  261,  268, 1054, 1054,
 /*   210 */  1084,  268, 1149,  361,  943,  949,  361,  943,  949,  361,
 /*   220 */   361,  313,  946, 1039,  943,  963,  965,  999,  848, 1005,
 /*   230 */   327, 1206, 1185,  989,  992, 1010,  989,  992,  989,  992,
 /*   240 */  1163,  949,  361,  361,  361,  361,  361,  949,  361, 1107,
 /*   250 */   327, 1101,  268,  405,  268,  327, 1210,  361,  460, 1054,
 /*   260 */   268, 1265, 1070, 2489, 2489, 2489, 2489, 2489, 2489, 2489,
 /*   270 */   162,  885,  123,  574,  199,  576,  467,  476,  540,  707,
 /*   280 */   662,  549,  549,  549,  549,  549,  549,  549,  549,  624,
 /*   290 */   681,  224,  263,  263,  251,  558,  410,    3,  603,  521,
 /*   300 */   529,  529,  529,  529,  249,   96,  823,  884,  840,  842,
 /*   310 */   856,  888,  872,  913,  978,  852,  820,  930,  937,  987,
 /*   320 */   876,  787,  802,  953,  920,  954,  489,  956,  958,  960,
 /*   330 */   961,  962,  864,  974,  980,  981,  983,  985, 1013, 1016,
 /*   340 */   339,  975,  126, 1315, 1316, 1276, 1319, 1248, 1320, 1288,
 /*   350 */  1144, 1291, 1292, 1293, 1148, 1330, 1296, 1297, 1152, 1334,
 /*   360 */  1154, 1337, 1303, 1340, 1321, 1341, 1310, 1346, 1266, 1179,
 /*   370 */  1192, 1187, 1198, 1362, 1363, 1205, 1207, 1367, 1368, 1323,
 /*   380 */  1370, 1371, 1372, 1231, 1374, 1375, 1378, 1386, 1388, 1252,
 /*   390 */  1355, 1391, 1255, 1394, 1395, 1396, 1398, 1399, 1400, 1402,
 /*   400 */  1407, 1408, 1409, 1410, 1411, 1413, 1414, 1373, 1416, 1421,
 /*   410 */  1422, 1423, 1426, 1427, 1383, 1428, 1429, 1430, 1431, 1432,
 /*   420 */  1433, 1392, 1417, 1401, 1443, 1389, 1446, 1418, 1465, 1434,
 /*   430 */  1436, 1466, 1467, 1468, 1437, 1318, 1469, 1470, 1473, 1387,
 /*   440 */  1477, 1478, 1448, 1435, 1442, 1485, 1453, 1454, 1450, 1502,
 /*   450 */  1471, 1456, 1472, 1504, 1474, 1458, 1475, 1507, 1510, 1521,
 /*   460 */  1523, 1438, 1424, 1489, 1503, 1526, 1492, 1496, 1497, 1498,
 /*   470 */  1491, 1494, 1500, 1505, 1509, 1538, 1517, 1542, 1524, 1501,
 /*   480 */  1545, 1525, 1514, 1551, 1518, 1552, 1519, 1555, 1534, 1539,
 /*   490 */  1558, 1412, 1531, 1568, 1420, 1549, 1440, 1439, 1580, 1581,
 /*   500 */  1441, 1444, 1583, 1592, 1594, 1554, 1556, 1379, 1522, 1512,
 /*   510 */  1527, 1520, 1562, 1528, 1533, 1535, 1536, 1530, 1564, 1574,
 /*   520 */  1576, 1541, 1565, 1393, 1544, 1557, 1578, 1384, 1567, 1579,
 /*   530 */  1559, 1585, 1415, 1560, 1602, 1604, 1606, 1609, 1610, 1611,
 /*   540 */  1560, 1646, 1462, 1613, 1577, 1582, 1584, 1615, 1586, 1587,
 /*   550 */  1616, 1637, 1476, 1588, 1589, 1590, 1593, 1666, 1595, 1532,
 /*   560 */  1597, 1674, 1642, 1537, 1600, 1596, 1638, 1639, 1605, 1607,
 /*   570 */  1614, 1669, 1620, 1599, 1612, 1658, 1662, 1621, 1622, 1663,
 /*   580 */  1624, 1632, 1682, 1636, 1640, 1684, 1643, 1641, 1685, 1644,
 /*   590 */  1623, 1633, 1634, 1645, 1699, 1628, 1656, 1660, 1710, 1664,
 /*   600 */  1704, 1704, 1726, 1689, 1691, 1719, 1693, 1675, 1713, 1725,
 /*   610 */  1727, 1728, 1729, 1730, 1739, 1732, 1733, 1705, 1491, 1743,
 /*   620 */  1494, 1745, 1747, 1748, 1749, 1751, 1752, 1797, 1763, 1753,
 /*   630 */  1760, 1801, 1768, 1757, 1766, 1806, 1773, 1764, 1774, 1812,
 /*   640 */  1779, 1769, 1776, 1817, 1783, 1784, 1820, 1800, 1804, 1805,
 /*   650 */  1814, 1807, 1824,
};
#define YY_REDUCE_COUNT (269)
#define YY_REDUCE_MIN   (-287)
#define YY_REDUCE_MAX   (2156)
static const short yy_reduce_ofst[] = {
 /*     0 */  -248,   72,  855, -195,  322,  575,  908,  950, 1028, 1055,
 /*    10 */   306, 1123, 1165, 1190, 1247, 1304, 1325, 1382, 1405, 1447,
 /*    20 */  1463, 1513, 1570, 1631, 1648, 1690, 1701, 1712, 1754, 1772,
 /*    30 */  1796, 1852, 1902, 1913, 1955, 1966, 1980, 2036, 2050, 2100,
 /*    40 */  2142, 2156,  769, 1219, -234,   90,  398, -278, -260, -254,
 /*    50 */  -105, -245, -209,  -42, -261, -164, -256, -250,    4, -113,
 /*    60 */    13,   24,  131,  258,  262,  338,  340,  543,  548,  550,
 /*    70 */  -246,  552,  555,  557,  133, -211,   62,  570,  645, -224,
 /*    80 */   703,   73, -190,   86,  704,   23,   59,  185,  185,  185,
 /*    90 */  -237, -102, -153,  276,  278,  288,  315,  362,  419,  420,
 /*   100 */   435,  437,  440,  477,  479,  480,  483,  531,  564,  573,
 /*   110 */   615, -255,  281,  -40,  379,  333,  444, -287, -242,  458,
 /*   120 */  -125,  539,  106,  512,  441,  481,  316,  553,  391,  571,
 /*   130 */   566,  592,  378,  386,  567,  584,  638,  642,  690,  225,
 /*   140 */   731,  717,  619,  627,  736,  688,  650,  733,  733,  759,
 /*   150 */   762,  742,  737,  711,  711,  711,  701,  705,  706,  718,
 /*   160 */   733,  753,  814,  758,  812,  768,  822,  824,  785,  789,
 /*   170 */   792,  828,  837,  838,  780,  841,  807,  844,  800,  804,
 /*   180 */   853,  809,  858,  830,  859,  861,  874,  868,  882,  860,
 /*   190 */   862,  865,  866,  869,  871,  873,  875,  877,  878,  879,
 /*   200 */   881,  890,  846,  836,  892,  847,  880,  899,  904,  906,
 /*   210 */   863,  905,  850,  894,  815,  886,  898,  821,  891,  907,
 /*   220 */   911,  733,  826,  849,  843,  851,  854,  887,  902,  711,
 /*   230 */   936,  909,  900,  889,  895,  883,  893,  896,  897,  901,
 /*   240 */   915,  959,  972,  973,  976,  990,  993,  964,  994,  952,
 /*   250 */   970,  984, 1011, 1006, 1030, 1007, 1012, 1001, 1027, 1038,
 /*   260 */  1041, 1046, 1050,  996,  997, 1032, 1036, 1037, 1049, 1063,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    10 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    20 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    30 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    40 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    50 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    60 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    70 */  1508, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*    80 */  1436, 1436, 1436, 1436, 1436, 1506, 1659, 1436, 1834, 1436,
 /*    90 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   100 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   110 */  1436, 1436, 1436, 1436, 1436, 1508, 1436, 1846, 1846, 1846,
 /*   120 */  1506, 1436, 1436, 1436, 1703, 1703, 1436, 1436, 1436, 1436,
 /*   130 */  1602, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1695,
 /*   140 */  1436, 1436, 1916, 1436, 1436, 1701, 1870, 1436, 1436, 1436,
 /*   150 */  1436, 1555, 1862, 1838, 1852, 1839, 1901, 1901, 1901, 1855,
 /*   160 */  1436, 1866, 1436, 1436, 1436, 1687, 1436, 1436, 1664, 1661,
 /*   170 */  1661, 1436, 1436, 1436, 1436, 1508, 1436, 1508, 1436, 1436,
 /*   180 */  1508, 1436, 1508, 1436, 1508, 1508, 1436, 1508, 1436, 1436,
 /*   190 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   200 */  1436, 1436, 1436, 1436, 1506, 1697, 1436, 1506, 1436, 1436,
 /*   210 */  1436, 1506, 1436, 1436, 1877, 1875, 1436, 1877, 1875, 1436,
 /*   220 */  1436, 1436, 1889, 1885, 1877, 1893, 1891, 1868, 1866, 1852,
 /*   230 */  1436, 1436, 1836, 1907, 1903, 1919, 1907, 1903, 1907, 1903,
 /*   240 */  1436, 1875, 1436, 1436, 1436, 1436, 1436, 1875, 1436, 1436,
 /*   250 */  1436, 1436, 1506, 1436, 1506, 1436, 1571, 1436, 1436, 1436,
 /*   260 */  1506, 1468, 1436, 1689, 1703, 1605, 1605, 1605, 1509, 1441,
 /*   270 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   280 */  1436, 1772, 1888, 1887, 1810, 1809, 1808, 1806, 1771, 1436,
 /*   290 */  1436, 1567, 1770, 1769, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   300 */  1763, 1764, 1762, 1761, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   310 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1835,
 /*   320 */  1436, 1904, 1908, 1436, 1436, 1436, 1746, 1436, 1436, 1436,
 /*   330 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   340 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   350 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   360 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   370 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   380 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   390 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   400 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   410 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   420 */  1436, 1436, 1436, 1473, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   430 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   440 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   450 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   460 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   470 */  1536, 1535, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   480 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   490 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   500 */  1436, 1436, 1436, 1436, 1436, 1859, 1869, 1436, 1436, 1436,
 /*   510 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   520 */  1746, 1436, 1886, 1436, 1845, 1841, 1436, 1436, 1837, 1436,
 /*   530 */  1436, 1902, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   540 */  1436, 1830, 1436, 1803, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   550 */  1436, 1436, 1757, 1436, 1436, 1436, 1436, 1707, 1436, 1436,
 /*   560 */  1436, 1436, 1436, 1436, 1436, 1436, 1745, 1436, 1788, 1436,
 /*   570 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1599, 1436, 1436,
 /*   580 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   590 */  1584, 1582, 1581, 1580, 1436, 1577, 1436, 1436, 1436, 1436,
 /*   600 */  1608, 1607, 1436, 1436, 1436, 1436, 1436, 1436, 1528, 1436,
 /*   610 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1519, 1436,
 /*   620 */  1518, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   630 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   640 */  1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436, 1436,
 /*   650 */  1436, 1436, 1436,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  243,  /*  NK_BITNOT => ID */
  243,  /*     INSERT => ID */
  243,  /*     VALUES => ID */
  243,  /*     IMPORT => ID */
  243,  /*    NK_SEMI => ID */
  243,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "IF",
  /*   59 */ "NOT",
  /*   60 */ "EXISTS",
  /*   61 */ "BUFFER",
  /*   62 */ "CACHELAST",
  /*   63 */ "COMP",
  /*   64 */ "DURATION",
  /*   65 */ "NK_VARIABLE",
  /*   66 */ "FSYNC",
  /*   67 */ "MAXROWS",
  /*   68 */ "MINROWS",
  /*   69 */ "KEEP",
  /*   70 */ "PAGES",
  /*   71 */ "PAGESIZE",
  /*   72 */ "PRECISION",
  /*   73 */ "REPLICA",
  /*   74 */ "STRICT",
  /*   75 */ "WAL",
  /*   76 */ "VGROUPS",
  /*   77 */ "SINGLE_STABLE",
  /*   78 */ "RETENTIONS",
  /*   79 */ "SCHEMALESS",
  /*   80 */ "NK_COLON",
  /*   81 */ "TABLE",
  /*   82 */ "NK_LP",
  /*   83 */ "NK_RP",
  /*   84 */ "STABLE",
  /*   85 */ "ADD",
  /*   86 */ "COLUMN",
  /*   87 */ "MODIFY",
  /*   88 */ "RENAME",
  /*   89 */ "TAG",
  /*   90 */ "SET",
  /*   91 */ "NK_EQ",
  /*   92 */ "USING",
  /*   93 */ "TAGS",
  /*   94 */ "COMMENT",
  /*   95 */ "BOOL",
  /*   96 */ "TINYINT",
  /*   97 */ "SMALLINT",
  /*   98 */ "INT",
  /*   99 */ "INTEGER",
  /*  100 */ "BIGINT",
  /*  101 */ "FLOAT",
  /*  102 */ "DOUBLE",
  /*  103 */ "BINARY",
  /*  104 */ "TIMESTAMP",
  /*  105 */ "NCHAR",
  /*  106 */ "UNSIGNED",
  /*  107 */ "JSON",
  /*  108 */ "VARCHAR",
  /*  109 */ "MEDIUMBLOB",
  /*  110 */ "BLOB",
  /*  111 */ "VARBINARY",
  /*  112 */ "DECIMAL",
  /*  113 */ "MAX_DELAY",
  /*  114 */ "WATERMARK",
  /*  115 */ "ROLLUP",
  /*  116 */ "TTL",
  /*  117 */ "SMA",
  /*  118 */ "FIRST",
  /*  119 */ "LAST",
  /*  120 */ "SHOW",
  /*  121 */ "DATABASES",
  /*  122 */ "TABLES",
  /*  123 */ "STABLES",
  /*  124 */ "MNODES",
  /*  125 */ "MODULES",
  /*  126 */ "QNODES",
  /*  127 */ "FUNCTIONS",
  /*  128 */ "INDEXES",
  /*  129 */ "ACCOUNTS",
  /*  130 */ "APPS",
  /*  131 */ "CONNECTIONS",
  /*  132 */ "LICENCE",
  /*  133 */ "GRANTS",
  /*  134 */ "QUERIES",
  /*  135 */ "SCORES",
  /*  136 */ "TOPICS",
  /*  137 */ "VARIABLES",
  /*  138 */ "BNODES",
  /*  139 */ "SNODES",
  /*  140 */ "CLUSTER",
  /*  141 */ "TRANSACTIONS",
  /*  142 */ "DISTRIBUTED",
  /*  143 */ "CONSUMERS",
  /*  144 */ "SUBSCRIPTIONS",
  /*  145 */ "LIKE",
  /*  146 */ "INDEX",
  /*  147 */ "FUNCTION",
  /*  148 */ "INTERVAL",
  /*  149 */ "TOPIC",
  /*  150 */ "AS",
  /*  151 */ "WITH",
  /*  152 */ "META",
  /*  153 */ "CONSUMER",
  /*  154 */ "GROUP",
  /*  155 */ "DESC",
  /*  156 */ "DESCRIBE",
  /*  157 */ "RESET",
  /*  158 */ "QUERY",
  /*  159 */ "CACHE",
  /*  160 */ "EXPLAIN",
  /*  161 */ "ANALYZE",
  /*  162 */ "VERBOSE",
  /*  163 */ "NK_BOOL",
  /*  164 */ "RATIO",
  /*  165 */ "NK_FLOAT",
  /*  166 */ "COMPACT",
  /*  167 */ "VNODES",
  /*  168 */ "IN",
  /*  169 */ "OUTPUTTYPE",
  /*  170 */ "AGGREGATE",
  /*  171 */ "BUFSIZE",
  /*  172 */ "STREAM",
  /*  173 */ "INTO",
  /*  174 */ "TRIGGER",
  /*  175 */ "AT_ONCE",
  /*  176 */ "WINDOW_CLOSE",
  /*  177 */ "KILL",
  /*  178 */ "CONNECTION",
  /*  179 */ "TRANSACTION",
  /*  180 */ "BALANCE",
  /*  181 */ "VGROUP",
  /*  182 */ "MERGE",
  /*  183 */ "REDISTRIBUTE",
  /*  184 */ "SPLIT",
  /*  185 */ "SYNCDB",
  /*  186 */ "DELETE",
  /*  187 */ "NULL",
  /*  188 */ "NK_QUESTION",
  /*  189 */ "NK_ARROW",
  /*  190 */ "ROWTS",
  /*  191 */ "TBNAME",
  /*  192 */ "QSTARTTS",
  /*  193 */ "QENDTS",
  /*  194 */ "WSTARTTS",
  /*  195 */ "WENDTS",
  /*  196 */ "WDURATION",
  /*  197 */ "CAST",
  /*  198 */ "NOW",
  /*  199 */ "TODAY",
  /*  200 */ "TIMEZONE",
  /*  201 */ "CLIENT_VERSION",
  /*  202 */ "SERVER_VERSION",
  /*  203 */ "SERVER_STATUS",
  /*  204 */ "CURRENT_USER",
  /*  205 */ "COUNT",
  /*  206 */ "LAST_ROW",
  /*  207 */ "BETWEEN",
  /*  208 */ "IS",
  /*  209 */ "NK_LT",
  /*  210 */ "NK_GT",
  /*  211 */ "NK_LE",
  /*  212 */ "NK_GE",
  /*  213 */ "NK_NE",
  /*  214 */ "MATCH",
  /*  215 */ "NMATCH",
  /*  216 */ "CONTAINS",
  /*  217 */ "JOIN",
  /*  218 */ "INNER",
  /*  219 */ "SELECT",
  /*  220 */ "DISTINCT",
  /*  221 */ "WHERE",
  /*  222 */ "PARTITION",
  /*  223 */ "BY",
  /*  224 */ "SESSION",
  /*  225 */ "STATE_WINDOW",
  /*  226 */ "SLIDING",
  /*  227 */ "FILL",
  /*  228 */ "VALUE",
  /*  229 */ "NONE",
  /*  230 */ "PREV",
  /*  231 */ "LINEAR",
  /*  232 */ "NEXT",
  /*  233 */ "HAVING",
  /*  234 */ "RANGE",
  /*  235 */ "EVERY",
  /*  236 */ "ORDER",
  /*  237 */ "SLIMIT",
  /*  238 */ "SOFFSET",
  /*  239 */ "LIMIT",
  /*  240 */ "OFFSET",
  /*  241 */ "ASC",
  /*  242 */ "NULLS",
  /*  243 */ "ID",
  /*  244 */ "NK_BITNOT",
  /*  245 */ "INSERT",
  /*  246 */ "VALUES",
  /*  247 */ "IMPORT",
  /*  248 */ "NK_SEMI",
  /*  249 */ "FILE",
  /*  250 */ "cmd",
  /*  251 */ "account_options",
  /*  252 */ "alter_account_options",
  /*  253 */ "literal",
  /*  254 */ "alter_account_option",
  /*  255 */ "user_name",
  /*  256 */ "sysinfo_opt",
  /*  257 */ "privileges",
  /*  258 */ "priv_level",
  /*  259 */ "priv_type_list",
  /*  260 */ "priv_type",
  /*  261 */ "db_name",
  /*  262 */ "dnode_endpoint",
  /*  263 */ "not_exists_opt",
  /*  264 */ "db_options",
  /*  265 */ "exists_opt",
  /*  266 */ "alter_db_options",
  /*  267 */ "integer_list",
  /*  268 */ "variable_list",
  /*  269 */ "retention_list",
  /*  270 */ "alter_db_option",
  /*  271 */ "retention",
  /*  272 */ "full_table_name",
  /*  273 */ "column_def_list",
  /*  274 */ "tags_def_opt",
  /*  275 */ "table_options",
  /*  276 */ "multi_create_clause",
  /*  277 */ "tags_def",
  /*  278 */ "multi_drop_clause",
  /*  279 */ "alter_table_clause",
  /*  280 */ "alter_table_options",
  /*  281 */ "column_name",
  /*  282 */ "type_name",
  /*  283 */ "signed_literal",
  /*  284 */ "create_subtable_clause",
  /*  285 */ "specific_tags_opt",
  /*  286 */ "literal_list",
  /*  287 */ "drop_table_clause",
  /*  288 */ "col_name_list",
  /*  289 */ "table_name",
  /*  290 */ "column_def",
  /*  291 */ "duration_list",
  /*  292 */ "rollup_func_list",
  /*  293 */ "alter_table_option",
  /*  294 */ "duration_literal",
  /*  295 */ "rollup_func_name",
  /*  296 */ "function_name",
  /*  297 */ "col_name",
  /*  298 */ "db_name_cond_opt",
  /*  299 */ "like_pattern_opt",
  /*  300 */ "table_name_cond",
  /*  301 */ "from_db_opt",
  /*  302 */ "index_name",
  /*  303 */ "index_options",
  /*  304 */ "func_list",
  /*  305 */ "sliding_opt",
  /*  306 */ "sma_stream_opt",
  /*  307 */ "func",
  /*  308 */ "expression_list",
  /*  309 */ "stream_options",
  /*  310 */ "topic_name",
  /*  311 */ "query_expression",
  /*  312 */ "cgroup_name",
  /*  313 */ "analyze_opt",
  /*  314 */ "explain_options",
  /*  315 */ "agg_func_opt",
  /*  316 */ "bufsize_opt",
  /*  317 */ "stream_name",
  /*  318 */ "into_opt",
  /*  319 */ "dnode_list",
  /*  320 */ "where_clause_opt",
  /*  321 */ "signed",
  /*  322 */ "literal_func",
  /*  323 */ "table_alias",
  /*  324 */ "column_alias",
  /*  325 */ "expression",
  /*  326 */ "pseudo_column",
  /*  327 */ "column_reference",
  /*  328 */ "function_expression",
  /*  329 */ "subquery",
  /*  330 */ "star_func",
  /*  331 */ "star_func_para_list",
  /*  332 */ "noarg_func",
  /*  333 */ "other_para_list",
  /*  334 */ "star_func_para",
  /*  335 */ "predicate",
  /*  336 */ "compare_op",
  /*  337 */ "in_op",
  /*  338 */ "in_predicate_value",
  /*  339 */ "boolean_value_expression",
  /*  340 */ "boolean_primary",
  /*  341 */ "common_expression",
  /*  342 */ "from_clause_opt",
  /*  343 */ "table_reference_list",
  /*  344 */ "table_reference",
  /*  345 */ "table_primary",
  /*  346 */ "joined_table",
  /*  347 */ "alias_opt",
  /*  348 */ "parenthesized_joined_table",
  /*  349 */ "join_type",
  /*  350 */ "search_condition",
  /*  351 */ "query_specification",
  /*  352 */ "set_quantifier_opt",
  /*  353 */ "select_list",
  /*  354 */ "partition_by_clause_opt",
  /*  355 */ "range_opt",
  /*  356 */ "every_opt",
  /*  357 */ "fill_opt",
  /*  358 */ "twindow_clause_opt",
  /*  359 */ "group_by_clause_opt",
  /*  360 */ "having_clause_opt",
  /*  361 */ "select_sublist",
  /*  362 */ "select_item",
  /*  363 */ "fill_mode",
  /*  364 */ "group_by_list",
  /*  365 */ "query_expression_body",
  /*  366 */ "order_by_clause_opt",
  /*  367 */ "slimit_clause_opt",
  /*  368 */ "limit_clause_opt",
  /*  369 */ "query_primary",
  /*  370 */ "sort_specification_list",
  /*  371 */ "sort_specification",
  /*  372 */ "ordering_specification_opt",
  /*  373 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  67 */ "not_exists_opt ::=",
 /*  68 */ "exists_opt ::= IF EXISTS",
 /*  69 */ "exists_opt ::=",
 /*  70 */ "db_options ::=",
 /*  71 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  72 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  73 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  74 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  75 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  76 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  77 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  78 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  79 */ "db_options ::= db_options KEEP integer_list",
 /*  80 */ "db_options ::= db_options KEEP variable_list",
 /*  81 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  82 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  83 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  84 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  85 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  86 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  87 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  88 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  89 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  90 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  91 */ "alter_db_options ::= alter_db_option",
 /*  92 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  93 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  94 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  95 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  96 */ "alter_db_option ::= KEEP integer_list",
 /*  97 */ "alter_db_option ::= KEEP variable_list",
 /*  98 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  99 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 100 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 101 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 102 */ "integer_list ::= NK_INTEGER",
 /* 103 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 104 */ "variable_list ::= NK_VARIABLE",
 /* 105 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 106 */ "retention_list ::= retention",
 /* 107 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 108 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 109 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 110 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 111 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 112 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 113 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 114 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 115 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 116 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 117 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 118 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 119 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 120 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 121 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 122 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 123 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 125 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 126 */ "multi_create_clause ::= create_subtable_clause",
 /* 127 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 128 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 129 */ "multi_drop_clause ::= drop_table_clause",
 /* 130 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 131 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 132 */ "specific_tags_opt ::=",
 /* 133 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 134 */ "full_table_name ::= table_name",
 /* 135 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 136 */ "column_def_list ::= column_def",
 /* 137 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 138 */ "column_def ::= column_name type_name",
 /* 139 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 140 */ "type_name ::= BOOL",
 /* 141 */ "type_name ::= TINYINT",
 /* 142 */ "type_name ::= SMALLINT",
 /* 143 */ "type_name ::= INT",
 /* 144 */ "type_name ::= INTEGER",
 /* 145 */ "type_name ::= BIGINT",
 /* 146 */ "type_name ::= FLOAT",
 /* 147 */ "type_name ::= DOUBLE",
 /* 148 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 149 */ "type_name ::= TIMESTAMP",
 /* 150 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 151 */ "type_name ::= TINYINT UNSIGNED",
 /* 152 */ "type_name ::= SMALLINT UNSIGNED",
 /* 153 */ "type_name ::= INT UNSIGNED",
 /* 154 */ "type_name ::= BIGINT UNSIGNED",
 /* 155 */ "type_name ::= JSON",
 /* 156 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= MEDIUMBLOB",
 /* 158 */ "type_name ::= BLOB",
 /* 159 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= DECIMAL",
 /* 161 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 163 */ "tags_def_opt ::=",
 /* 164 */ "tags_def_opt ::= tags_def",
 /* 165 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 166 */ "table_options ::=",
 /* 167 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 168 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 169 */ "table_options ::= table_options WATERMARK duration_list",
 /* 170 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 171 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 172 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 173 */ "alter_table_options ::= alter_table_option",
 /* 174 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 175 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 176 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 177 */ "duration_list ::= duration_literal",
 /* 178 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 179 */ "rollup_func_list ::= rollup_func_name",
 /* 180 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 181 */ "rollup_func_name ::= function_name",
 /* 182 */ "rollup_func_name ::= FIRST",
 /* 183 */ "rollup_func_name ::= LAST",
 /* 184 */ "col_name_list ::= col_name",
 /* 185 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 186 */ "col_name ::= column_name",
 /* 187 */ "cmd ::= SHOW DNODES",
 /* 188 */ "cmd ::= SHOW USERS",
 /* 189 */ "cmd ::= SHOW DATABASES",
 /* 190 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 193 */ "cmd ::= SHOW MNODES",
 /* 194 */ "cmd ::= SHOW MODULES",
 /* 195 */ "cmd ::= SHOW QNODES",
 /* 196 */ "cmd ::= SHOW FUNCTIONS",
 /* 197 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 198 */ "cmd ::= SHOW STREAMS",
 /* 199 */ "cmd ::= SHOW ACCOUNTS",
 /* 200 */ "cmd ::= SHOW APPS",
 /* 201 */ "cmd ::= SHOW CONNECTIONS",
 /* 202 */ "cmd ::= SHOW LICENCE",
 /* 203 */ "cmd ::= SHOW GRANTS",
 /* 204 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 205 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 206 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 207 */ "cmd ::= SHOW QUERIES",
 /* 208 */ "cmd ::= SHOW SCORES",
 /* 209 */ "cmd ::= SHOW TOPICS",
 /* 210 */ "cmd ::= SHOW VARIABLES",
 /* 211 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 212 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 213 */ "cmd ::= SHOW BNODES",
 /* 214 */ "cmd ::= SHOW SNODES",
 /* 215 */ "cmd ::= SHOW CLUSTER",
 /* 216 */ "cmd ::= SHOW TRANSACTIONS",
 /* 217 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 218 */ "cmd ::= SHOW CONSUMERS",
 /* 219 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 220 */ "db_name_cond_opt ::=",
 /* 221 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 222 */ "like_pattern_opt ::=",
 /* 223 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 224 */ "table_name_cond ::= table_name",
 /* 225 */ "from_db_opt ::=",
 /* 226 */ "from_db_opt ::= FROM db_name",
 /* 227 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 228 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 229 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 230 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 231 */ "func_list ::= func",
 /* 232 */ "func_list ::= func_list NK_COMMA func",
 /* 233 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 234 */ "sma_stream_opt ::=",
 /* 235 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 236 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 237 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 238 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 239 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 242 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 243 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 244 */ "cmd ::= DESC full_table_name",
 /* 245 */ "cmd ::= DESCRIBE full_table_name",
 /* 246 */ "cmd ::= RESET QUERY CACHE",
 /* 247 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 248 */ "analyze_opt ::=",
 /* 249 */ "analyze_opt ::= ANALYZE",
 /* 250 */ "explain_options ::=",
 /* 251 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 252 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 253 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 254 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 255 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 256 */ "agg_func_opt ::=",
 /* 257 */ "agg_func_opt ::= AGGREGATE",
 /* 258 */ "bufsize_opt ::=",
 /* 259 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 260 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 261 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 262 */ "into_opt ::=",
 /* 263 */ "into_opt ::= INTO full_table_name",
 /* 264 */ "stream_options ::=",
 /* 265 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 266 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 267 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 268 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 269 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 270 */ "cmd ::= KILL QUERY NK_STRING",
 /* 271 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 272 */ "cmd ::= BALANCE VGROUP",
 /* 273 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 274 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 275 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 276 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 277 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 278 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 279 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 280 */ "cmd ::= query_expression",
 /* 281 */ "literal ::= NK_INTEGER",
 /* 282 */ "literal ::= NK_FLOAT",
 /* 283 */ "literal ::= NK_STRING",
 /* 284 */ "literal ::= NK_BOOL",
 /* 285 */ "literal ::= TIMESTAMP NK_STRING",
 /* 286 */ "literal ::= duration_literal",
 /* 287 */ "literal ::= NULL",
 /* 288 */ "literal ::= NK_QUESTION",
 /* 289 */ "duration_literal ::= NK_VARIABLE",
 /* 290 */ "signed ::= NK_INTEGER",
 /* 291 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 292 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 293 */ "signed ::= NK_FLOAT",
 /* 294 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 295 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 296 */ "signed_literal ::= signed",
 /* 297 */ "signed_literal ::= NK_STRING",
 /* 298 */ "signed_literal ::= NK_BOOL",
 /* 299 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 300 */ "signed_literal ::= duration_literal",
 /* 301 */ "signed_literal ::= NULL",
 /* 302 */ "signed_literal ::= literal_func",
 /* 303 */ "literal_list ::= signed_literal",
 /* 304 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 305 */ "db_name ::= NK_ID",
 /* 306 */ "table_name ::= NK_ID",
 /* 307 */ "column_name ::= NK_ID",
 /* 308 */ "function_name ::= NK_ID",
 /* 309 */ "table_alias ::= NK_ID",
 /* 310 */ "column_alias ::= NK_ID",
 /* 311 */ "user_name ::= NK_ID",
 /* 312 */ "index_name ::= NK_ID",
 /* 313 */ "topic_name ::= NK_ID",
 /* 314 */ "stream_name ::= NK_ID",
 /* 315 */ "cgroup_name ::= NK_ID",
 /* 316 */ "expression ::= literal",
 /* 317 */ "expression ::= pseudo_column",
 /* 318 */ "expression ::= column_reference",
 /* 319 */ "expression ::= function_expression",
 /* 320 */ "expression ::= subquery",
 /* 321 */ "expression ::= NK_LP expression NK_RP",
 /* 322 */ "expression ::= NK_PLUS expression",
 /* 323 */ "expression ::= NK_MINUS expression",
 /* 324 */ "expression ::= expression NK_PLUS expression",
 /* 325 */ "expression ::= expression NK_MINUS expression",
 /* 326 */ "expression ::= expression NK_STAR expression",
 /* 327 */ "expression ::= expression NK_SLASH expression",
 /* 328 */ "expression ::= expression NK_REM expression",
 /* 329 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 330 */ "expression ::= expression NK_BITAND expression",
 /* 331 */ "expression ::= expression NK_BITOR expression",
 /* 332 */ "expression_list ::= expression",
 /* 333 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 334 */ "column_reference ::= column_name",
 /* 335 */ "column_reference ::= table_name NK_DOT column_name",
 /* 336 */ "pseudo_column ::= ROWTS",
 /* 337 */ "pseudo_column ::= TBNAME",
 /* 338 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 339 */ "pseudo_column ::= QSTARTTS",
 /* 340 */ "pseudo_column ::= QENDTS",
 /* 341 */ "pseudo_column ::= WSTARTTS",
 /* 342 */ "pseudo_column ::= WENDTS",
 /* 343 */ "pseudo_column ::= WDURATION",
 /* 344 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 345 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 346 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 347 */ "function_expression ::= literal_func",
 /* 348 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 349 */ "literal_func ::= NOW",
 /* 350 */ "noarg_func ::= NOW",
 /* 351 */ "noarg_func ::= TODAY",
 /* 352 */ "noarg_func ::= TIMEZONE",
 /* 353 */ "noarg_func ::= DATABASE",
 /* 354 */ "noarg_func ::= CLIENT_VERSION",
 /* 355 */ "noarg_func ::= SERVER_VERSION",
 /* 356 */ "noarg_func ::= SERVER_STATUS",
 /* 357 */ "noarg_func ::= CURRENT_USER",
 /* 358 */ "noarg_func ::= USER",
 /* 359 */ "star_func ::= COUNT",
 /* 360 */ "star_func ::= FIRST",
 /* 361 */ "star_func ::= LAST",
 /* 362 */ "star_func ::= LAST_ROW",
 /* 363 */ "star_func_para_list ::= NK_STAR",
 /* 364 */ "star_func_para_list ::= other_para_list",
 /* 365 */ "other_para_list ::= star_func_para",
 /* 366 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 367 */ "star_func_para ::= expression",
 /* 368 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 369 */ "predicate ::= expression compare_op expression",
 /* 370 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 371 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 372 */ "predicate ::= expression IS NULL",
 /* 373 */ "predicate ::= expression IS NOT NULL",
 /* 374 */ "predicate ::= expression in_op in_predicate_value",
 /* 375 */ "compare_op ::= NK_LT",
 /* 376 */ "compare_op ::= NK_GT",
 /* 377 */ "compare_op ::= NK_LE",
 /* 378 */ "compare_op ::= NK_GE",
 /* 379 */ "compare_op ::= NK_NE",
 /* 380 */ "compare_op ::= NK_EQ",
 /* 381 */ "compare_op ::= LIKE",
 /* 382 */ "compare_op ::= NOT LIKE",
 /* 383 */ "compare_op ::= MATCH",
 /* 384 */ "compare_op ::= NMATCH",
 /* 385 */ "compare_op ::= CONTAINS",
 /* 386 */ "in_op ::= IN",
 /* 387 */ "in_op ::= NOT IN",
 /* 388 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 389 */ "boolean_value_expression ::= boolean_primary",
 /* 390 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 391 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 392 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 393 */ "boolean_primary ::= predicate",
 /* 394 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 395 */ "common_expression ::= expression",
 /* 396 */ "common_expression ::= boolean_value_expression",
 /* 397 */ "from_clause_opt ::=",
 /* 398 */ "from_clause_opt ::= FROM table_reference_list",
 /* 399 */ "table_reference_list ::= table_reference",
 /* 400 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 401 */ "table_reference ::= table_primary",
 /* 402 */ "table_reference ::= joined_table",
 /* 403 */ "table_primary ::= table_name alias_opt",
 /* 404 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 405 */ "table_primary ::= subquery alias_opt",
 /* 406 */ "table_primary ::= parenthesized_joined_table",
 /* 407 */ "alias_opt ::=",
 /* 408 */ "alias_opt ::= table_alias",
 /* 409 */ "alias_opt ::= AS table_alias",
 /* 410 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 411 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 412 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 413 */ "join_type ::=",
 /* 414 */ "join_type ::= INNER",
 /* 415 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 416 */ "set_quantifier_opt ::=",
 /* 417 */ "set_quantifier_opt ::= DISTINCT",
 /* 418 */ "set_quantifier_opt ::= ALL",
 /* 419 */ "select_list ::= NK_STAR",
 /* 420 */ "select_list ::= select_sublist",
 /* 421 */ "select_sublist ::= select_item",
 /* 422 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 423 */ "select_item ::= common_expression",
 /* 424 */ "select_item ::= common_expression column_alias",
 /* 425 */ "select_item ::= common_expression AS column_alias",
 /* 426 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 427 */ "where_clause_opt ::=",
 /* 428 */ "where_clause_opt ::= WHERE search_condition",
 /* 429 */ "partition_by_clause_opt ::=",
 /* 430 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 431 */ "twindow_clause_opt ::=",
 /* 432 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 433 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 434 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 435 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 436 */ "sliding_opt ::=",
 /* 437 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 438 */ "fill_opt ::=",
 /* 439 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 440 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 441 */ "fill_mode ::= NONE",
 /* 442 */ "fill_mode ::= PREV",
 /* 443 */ "fill_mode ::= NULL",
 /* 444 */ "fill_mode ::= LINEAR",
 /* 445 */ "fill_mode ::= NEXT",
 /* 446 */ "group_by_clause_opt ::=",
 /* 447 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 448 */ "group_by_list ::= expression",
 /* 449 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 450 */ "having_clause_opt ::=",
 /* 451 */ "having_clause_opt ::= HAVING search_condition",
 /* 452 */ "range_opt ::=",
 /* 453 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 454 */ "every_opt ::=",
 /* 455 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 456 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 457 */ "query_expression_body ::= query_primary",
 /* 458 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 459 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 460 */ "query_primary ::= query_specification",
 /* 461 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 462 */ "order_by_clause_opt ::=",
 /* 463 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 464 */ "slimit_clause_opt ::=",
 /* 465 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 466 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 467 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 468 */ "limit_clause_opt ::=",
 /* 469 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 470 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 471 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 472 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 473 */ "search_condition ::= common_expression",
 /* 474 */ "sort_specification_list ::= sort_specification",
 /* 475 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 476 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 477 */ "ordering_specification_opt ::=",
 /* 478 */ "ordering_specification_opt ::= ASC",
 /* 479 */ "ordering_specification_opt ::= DESC",
 /* 480 */ "null_ordering_opt ::=",
 /* 481 */ "null_ordering_opt ::= NULLS FIRST",
 /* 482 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 250: /* cmd */
    case 253: /* literal */
    case 264: /* db_options */
    case 266: /* alter_db_options */
    case 271: /* retention */
    case 272: /* full_table_name */
    case 275: /* table_options */
    case 279: /* alter_table_clause */
    case 280: /* alter_table_options */
    case 283: /* signed_literal */
    case 284: /* create_subtable_clause */
    case 287: /* drop_table_clause */
    case 290: /* column_def */
    case 294: /* duration_literal */
    case 295: /* rollup_func_name */
    case 297: /* col_name */
    case 298: /* db_name_cond_opt */
    case 299: /* like_pattern_opt */
    case 300: /* table_name_cond */
    case 301: /* from_db_opt */
    case 303: /* index_options */
    case 305: /* sliding_opt */
    case 306: /* sma_stream_opt */
    case 307: /* func */
    case 309: /* stream_options */
    case 311: /* query_expression */
    case 314: /* explain_options */
    case 318: /* into_opt */
    case 320: /* where_clause_opt */
    case 321: /* signed */
    case 322: /* literal_func */
    case 325: /* expression */
    case 326: /* pseudo_column */
    case 327: /* column_reference */
    case 328: /* function_expression */
    case 329: /* subquery */
    case 334: /* star_func_para */
    case 335: /* predicate */
    case 338: /* in_predicate_value */
    case 339: /* boolean_value_expression */
    case 340: /* boolean_primary */
    case 341: /* common_expression */
    case 342: /* from_clause_opt */
    case 343: /* table_reference_list */
    case 344: /* table_reference */
    case 345: /* table_primary */
    case 346: /* joined_table */
    case 348: /* parenthesized_joined_table */
    case 350: /* search_condition */
    case 351: /* query_specification */
    case 355: /* range_opt */
    case 356: /* every_opt */
    case 357: /* fill_opt */
    case 358: /* twindow_clause_opt */
    case 360: /* having_clause_opt */
    case 362: /* select_item */
    case 365: /* query_expression_body */
    case 367: /* slimit_clause_opt */
    case 368: /* limit_clause_opt */
    case 369: /* query_primary */
    case 371: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy652)); 
}
      break;
    case 251: /* account_options */
    case 252: /* alter_account_options */
    case 254: /* alter_account_option */
    case 316: /* bufsize_opt */
{
 
}
      break;
    case 255: /* user_name */
    case 258: /* priv_level */
    case 261: /* db_name */
    case 262: /* dnode_endpoint */
    case 281: /* column_name */
    case 289: /* table_name */
    case 296: /* function_name */
    case 302: /* index_name */
    case 310: /* topic_name */
    case 312: /* cgroup_name */
    case 317: /* stream_name */
    case 323: /* table_alias */
    case 324: /* column_alias */
    case 330: /* star_func */
    case 332: /* noarg_func */
    case 347: /* alias_opt */
{
 
}
      break;
    case 256: /* sysinfo_opt */
{
 
}
      break;
    case 257: /* privileges */
    case 259: /* priv_type_list */
    case 260: /* priv_type */
{
 
}
      break;
    case 263: /* not_exists_opt */
    case 265: /* exists_opt */
    case 313: /* analyze_opt */
    case 315: /* agg_func_opt */
    case 352: /* set_quantifier_opt */
{
 
}
      break;
    case 267: /* integer_list */
    case 268: /* variable_list */
    case 269: /* retention_list */
    case 273: /* column_def_list */
    case 274: /* tags_def_opt */
    case 276: /* multi_create_clause */
    case 277: /* tags_def */
    case 278: /* multi_drop_clause */
    case 285: /* specific_tags_opt */
    case 286: /* literal_list */
    case 288: /* col_name_list */
    case 291: /* duration_list */
    case 292: /* rollup_func_list */
    case 304: /* func_list */
    case 308: /* expression_list */
    case 319: /* dnode_list */
    case 331: /* star_func_para_list */
    case 333: /* other_para_list */
    case 353: /* select_list */
    case 354: /* partition_by_clause_opt */
    case 359: /* group_by_clause_opt */
    case 361: /* select_sublist */
    case 364: /* group_by_list */
    case 366: /* order_by_clause_opt */
    case 370: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy24)); 
}
      break;
    case 270: /* alter_db_option */
    case 293: /* alter_table_option */
{
 
}
      break;
    case 282: /* type_name */
{
 
}
      break;
    case 336: /* compare_op */
    case 337: /* in_op */
{
 
}
      break;
    case 349: /* join_type */
{
 
}
      break;
    case 363: /* fill_mode */
{
 
}
      break;
    case 372: /* ordering_specification_opt */
{
 
}
      break;
    case 373: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  250,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  250,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  251,    0 }, /* (2) account_options ::= */
  {  251,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  251,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  251,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  251,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  251,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  251,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  251,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  251,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  251,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  252,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  252,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  254,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  254,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  254,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  254,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  254,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  254,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  254,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  254,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  254,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  254,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  250,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  250,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  250,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  250,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  250,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  256,    0 }, /* (29) sysinfo_opt ::= */
  {  256,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  250,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  250,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  257,   -1 }, /* (33) privileges ::= ALL */
  {  257,   -1 }, /* (34) privileges ::= priv_type_list */
  {  259,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  259,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  260,   -1 }, /* (37) priv_type ::= READ */
  {  260,   -1 }, /* (38) priv_type ::= WRITE */
  {  258,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  258,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  250,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  250,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  250,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  250,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  250,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  250,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  250,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  250,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  262,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  262,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  262,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  250,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  250,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  250,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  250,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  250,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  250,   -2 }, /* (64) cmd ::= USE db_name */
  {  250,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  263,   -3 }, /* (66) not_exists_opt ::= IF NOT EXISTS */
  {  263,    0 }, /* (67) not_exists_opt ::= */
  {  265,   -2 }, /* (68) exists_opt ::= IF EXISTS */
  {  265,    0 }, /* (69) exists_opt ::= */
  {  264,    0 }, /* (70) db_options ::= */
  {  264,   -3 }, /* (71) db_options ::= db_options BUFFER NK_INTEGER */
  {  264,   -3 }, /* (72) db_options ::= db_options CACHELAST NK_INTEGER */
  {  264,   -3 }, /* (73) db_options ::= db_options COMP NK_INTEGER */
  {  264,   -3 }, /* (74) db_options ::= db_options DURATION NK_INTEGER */
  {  264,   -3 }, /* (75) db_options ::= db_options DURATION NK_VARIABLE */
  {  264,   -3 }, /* (76) db_options ::= db_options FSYNC NK_INTEGER */
  {  264,   -3 }, /* (77) db_options ::= db_options MAXROWS NK_INTEGER */
  {  264,   -3 }, /* (78) db_options ::= db_options MINROWS NK_INTEGER */
  {  264,   -3 }, /* (79) db_options ::= db_options KEEP integer_list */
  {  264,   -3 }, /* (80) db_options ::= db_options KEEP variable_list */
  {  264,   -3 }, /* (81) db_options ::= db_options PAGES NK_INTEGER */
  {  264,   -3 }, /* (82) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  264,   -3 }, /* (83) db_options ::= db_options PRECISION NK_STRING */
  {  264,   -3 }, /* (84) db_options ::= db_options REPLICA NK_INTEGER */
  {  264,   -3 }, /* (85) db_options ::= db_options STRICT NK_INTEGER */
  {  264,   -3 }, /* (86) db_options ::= db_options WAL NK_INTEGER */
  {  264,   -3 }, /* (87) db_options ::= db_options VGROUPS NK_INTEGER */
  {  264,   -3 }, /* (88) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  264,   -3 }, /* (89) db_options ::= db_options RETENTIONS retention_list */
  {  264,   -3 }, /* (90) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  266,   -1 }, /* (91) alter_db_options ::= alter_db_option */
  {  266,   -2 }, /* (92) alter_db_options ::= alter_db_options alter_db_option */
  {  270,   -2 }, /* (93) alter_db_option ::= BUFFER NK_INTEGER */
  {  270,   -2 }, /* (94) alter_db_option ::= CACHELAST NK_INTEGER */
  {  270,   -2 }, /* (95) alter_db_option ::= FSYNC NK_INTEGER */
  {  270,   -2 }, /* (96) alter_db_option ::= KEEP integer_list */
  {  270,   -2 }, /* (97) alter_db_option ::= KEEP variable_list */
  {  270,   -2 }, /* (98) alter_db_option ::= PAGES NK_INTEGER */
  {  270,   -2 }, /* (99) alter_db_option ::= REPLICA NK_INTEGER */
  {  270,   -2 }, /* (100) alter_db_option ::= STRICT NK_INTEGER */
  {  270,   -2 }, /* (101) alter_db_option ::= WAL NK_INTEGER */
  {  267,   -1 }, /* (102) integer_list ::= NK_INTEGER */
  {  267,   -3 }, /* (103) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  268,   -1 }, /* (104) variable_list ::= NK_VARIABLE */
  {  268,   -3 }, /* (105) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  269,   -1 }, /* (106) retention_list ::= retention */
  {  269,   -3 }, /* (107) retention_list ::= retention_list NK_COMMA retention */
  {  271,   -3 }, /* (108) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  250,   -9 }, /* (109) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  250,   -3 }, /* (110) cmd ::= CREATE TABLE multi_create_clause */
  {  250,   -9 }, /* (111) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  250,   -3 }, /* (112) cmd ::= DROP TABLE multi_drop_clause */
  {  250,   -4 }, /* (113) cmd ::= DROP STABLE exists_opt full_table_name */
  {  250,   -3 }, /* (114) cmd ::= ALTER TABLE alter_table_clause */
  {  250,   -3 }, /* (115) cmd ::= ALTER STABLE alter_table_clause */
  {  279,   -2 }, /* (116) alter_table_clause ::= full_table_name alter_table_options */
  {  279,   -5 }, /* (117) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  279,   -4 }, /* (118) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  279,   -5 }, /* (119) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  279,   -5 }, /* (120) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  279,   -5 }, /* (121) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  279,   -4 }, /* (122) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  279,   -5 }, /* (123) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  279,   -5 }, /* (124) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  279,   -6 }, /* (125) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  276,   -1 }, /* (126) multi_create_clause ::= create_subtable_clause */
  {  276,   -2 }, /* (127) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  284,  -10 }, /* (128) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  278,   -1 }, /* (129) multi_drop_clause ::= drop_table_clause */
  {  278,   -2 }, /* (130) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  287,   -2 }, /* (131) drop_table_clause ::= exists_opt full_table_name */
  {  285,    0 }, /* (132) specific_tags_opt ::= */
  {  285,   -3 }, /* (133) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  272,   -1 }, /* (134) full_table_name ::= table_name */
  {  272,   -3 }, /* (135) full_table_name ::= db_name NK_DOT table_name */
  {  273,   -1 }, /* (136) column_def_list ::= column_def */
  {  273,   -3 }, /* (137) column_def_list ::= column_def_list NK_COMMA column_def */
  {  290,   -2 }, /* (138) column_def ::= column_name type_name */
  {  290,   -4 }, /* (139) column_def ::= column_name type_name COMMENT NK_STRING */
  {  282,   -1 }, /* (140) type_name ::= BOOL */
  {  282,   -1 }, /* (141) type_name ::= TINYINT */
  {  282,   -1 }, /* (142) type_name ::= SMALLINT */
  {  282,   -1 }, /* (143) type_name ::= INT */
  {  282,   -1 }, /* (144) type_name ::= INTEGER */
  {  282,   -1 }, /* (145) type_name ::= BIGINT */
  {  282,   -1 }, /* (146) type_name ::= FLOAT */
  {  282,   -1 }, /* (147) type_name ::= DOUBLE */
  {  282,   -4 }, /* (148) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  282,   -1 }, /* (149) type_name ::= TIMESTAMP */
  {  282,   -4 }, /* (150) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  282,   -2 }, /* (151) type_name ::= TINYINT UNSIGNED */
  {  282,   -2 }, /* (152) type_name ::= SMALLINT UNSIGNED */
  {  282,   -2 }, /* (153) type_name ::= INT UNSIGNED */
  {  282,   -2 }, /* (154) type_name ::= BIGINT UNSIGNED */
  {  282,   -1 }, /* (155) type_name ::= JSON */
  {  282,   -4 }, /* (156) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  282,   -1 }, /* (157) type_name ::= MEDIUMBLOB */
  {  282,   -1 }, /* (158) type_name ::= BLOB */
  {  282,   -4 }, /* (159) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  282,   -1 }, /* (160) type_name ::= DECIMAL */
  {  282,   -4 }, /* (161) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  282,   -6 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  274,    0 }, /* (163) tags_def_opt ::= */
  {  274,   -1 }, /* (164) tags_def_opt ::= tags_def */
  {  277,   -4 }, /* (165) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  275,    0 }, /* (166) table_options ::= */
  {  275,   -3 }, /* (167) table_options ::= table_options COMMENT NK_STRING */
  {  275,   -3 }, /* (168) table_options ::= table_options MAX_DELAY duration_list */
  {  275,   -3 }, /* (169) table_options ::= table_options WATERMARK duration_list */
  {  275,   -5 }, /* (170) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  275,   -3 }, /* (171) table_options ::= table_options TTL NK_INTEGER */
  {  275,   -5 }, /* (172) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  280,   -1 }, /* (173) alter_table_options ::= alter_table_option */
  {  280,   -2 }, /* (174) alter_table_options ::= alter_table_options alter_table_option */
  {  293,   -2 }, /* (175) alter_table_option ::= COMMENT NK_STRING */
  {  293,   -2 }, /* (176) alter_table_option ::= TTL NK_INTEGER */
  {  291,   -1 }, /* (177) duration_list ::= duration_literal */
  {  291,   -3 }, /* (178) duration_list ::= duration_list NK_COMMA duration_literal */
  {  292,   -1 }, /* (179) rollup_func_list ::= rollup_func_name */
  {  292,   -3 }, /* (180) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  295,   -1 }, /* (181) rollup_func_name ::= function_name */
  {  295,   -1 }, /* (182) rollup_func_name ::= FIRST */
  {  295,   -1 }, /* (183) rollup_func_name ::= LAST */
  {  288,   -1 }, /* (184) col_name_list ::= col_name */
  {  288,   -3 }, /* (185) col_name_list ::= col_name_list NK_COMMA col_name */
  {  297,   -1 }, /* (186) col_name ::= column_name */
  {  250,   -2 }, /* (187) cmd ::= SHOW DNODES */
  {  250,   -2 }, /* (188) cmd ::= SHOW USERS */
  {  250,   -2 }, /* (189) cmd ::= SHOW DATABASES */
  {  250,   -4 }, /* (190) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  250,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  250,   -3 }, /* (192) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  250,   -2 }, /* (193) cmd ::= SHOW MNODES */
  {  250,   -2 }, /* (194) cmd ::= SHOW MODULES */
  {  250,   -2 }, /* (195) cmd ::= SHOW QNODES */
  {  250,   -2 }, /* (196) cmd ::= SHOW FUNCTIONS */
  {  250,   -5 }, /* (197) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  250,   -2 }, /* (198) cmd ::= SHOW STREAMS */
  {  250,   -2 }, /* (199) cmd ::= SHOW ACCOUNTS */
  {  250,   -2 }, /* (200) cmd ::= SHOW APPS */
  {  250,   -2 }, /* (201) cmd ::= SHOW CONNECTIONS */
  {  250,   -2 }, /* (202) cmd ::= SHOW LICENCE */
  {  250,   -2 }, /* (203) cmd ::= SHOW GRANTS */
  {  250,   -4 }, /* (204) cmd ::= SHOW CREATE DATABASE db_name */
  {  250,   -4 }, /* (205) cmd ::= SHOW CREATE TABLE full_table_name */
  {  250,   -4 }, /* (206) cmd ::= SHOW CREATE STABLE full_table_name */
  {  250,   -2 }, /* (207) cmd ::= SHOW QUERIES */
  {  250,   -2 }, /* (208) cmd ::= SHOW SCORES */
  {  250,   -2 }, /* (209) cmd ::= SHOW TOPICS */
  {  250,   -2 }, /* (210) cmd ::= SHOW VARIABLES */
  {  250,   -3 }, /* (211) cmd ::= SHOW LOCAL VARIABLES */
  {  250,   -4 }, /* (212) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  250,   -2 }, /* (213) cmd ::= SHOW BNODES */
  {  250,   -2 }, /* (214) cmd ::= SHOW SNODES */
  {  250,   -2 }, /* (215) cmd ::= SHOW CLUSTER */
  {  250,   -2 }, /* (216) cmd ::= SHOW TRANSACTIONS */
  {  250,   -4 }, /* (217) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  250,   -2 }, /* (218) cmd ::= SHOW CONSUMERS */
  {  250,   -2 }, /* (219) cmd ::= SHOW SUBSCRIPTIONS */
  {  298,    0 }, /* (220) db_name_cond_opt ::= */
  {  298,   -2 }, /* (221) db_name_cond_opt ::= db_name NK_DOT */
  {  299,    0 }, /* (222) like_pattern_opt ::= */
  {  299,   -2 }, /* (223) like_pattern_opt ::= LIKE NK_STRING */
  {  300,   -1 }, /* (224) table_name_cond ::= table_name */
  {  301,    0 }, /* (225) from_db_opt ::= */
  {  301,   -2 }, /* (226) from_db_opt ::= FROM db_name */
  {  250,   -8 }, /* (227) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  250,   -4 }, /* (228) cmd ::= DROP INDEX exists_opt index_name */
  {  303,  -10 }, /* (229) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  303,  -12 }, /* (230) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  304,   -1 }, /* (231) func_list ::= func */
  {  304,   -3 }, /* (232) func_list ::= func_list NK_COMMA func */
  {  307,   -4 }, /* (233) func ::= function_name NK_LP expression_list NK_RP */
  {  306,    0 }, /* (234) sma_stream_opt ::= */
  {  306,   -3 }, /* (235) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  306,   -3 }, /* (236) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  250,   -6 }, /* (237) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  250,   -7 }, /* (238) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  250,   -9 }, /* (239) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  250,   -7 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  250,   -9 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  250,   -4 }, /* (242) cmd ::= DROP TOPIC exists_opt topic_name */
  {  250,   -7 }, /* (243) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  250,   -2 }, /* (244) cmd ::= DESC full_table_name */
  {  250,   -2 }, /* (245) cmd ::= DESCRIBE full_table_name */
  {  250,   -3 }, /* (246) cmd ::= RESET QUERY CACHE */
  {  250,   -4 }, /* (247) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  313,    0 }, /* (248) analyze_opt ::= */
  {  313,   -1 }, /* (249) analyze_opt ::= ANALYZE */
  {  314,    0 }, /* (250) explain_options ::= */
  {  314,   -3 }, /* (251) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  314,   -3 }, /* (252) explain_options ::= explain_options RATIO NK_FLOAT */
  {  250,   -6 }, /* (253) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  250,  -10 }, /* (254) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  250,   -4 }, /* (255) cmd ::= DROP FUNCTION exists_opt function_name */
  {  315,    0 }, /* (256) agg_func_opt ::= */
  {  315,   -1 }, /* (257) agg_func_opt ::= AGGREGATE */
  {  316,    0 }, /* (258) bufsize_opt ::= */
  {  316,   -2 }, /* (259) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  250,   -8 }, /* (260) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  250,   -4 }, /* (261) cmd ::= DROP STREAM exists_opt stream_name */
  {  318,    0 }, /* (262) into_opt ::= */
  {  318,   -2 }, /* (263) into_opt ::= INTO full_table_name */
  {  309,    0 }, /* (264) stream_options ::= */
  {  309,   -3 }, /* (265) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  309,   -3 }, /* (266) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  309,   -4 }, /* (267) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  309,   -3 }, /* (268) stream_options ::= stream_options WATERMARK duration_literal */
  {  250,   -3 }, /* (269) cmd ::= KILL CONNECTION NK_INTEGER */
  {  250,   -3 }, /* (270) cmd ::= KILL QUERY NK_STRING */
  {  250,   -3 }, /* (271) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  250,   -2 }, /* (272) cmd ::= BALANCE VGROUP */
  {  250,   -4 }, /* (273) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  250,   -4 }, /* (274) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  250,   -3 }, /* (275) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  319,   -2 }, /* (276) dnode_list ::= DNODE NK_INTEGER */
  {  319,   -3 }, /* (277) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  250,   -3 }, /* (278) cmd ::= SYNCDB db_name REPLICA */
  {  250,   -4 }, /* (279) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  250,   -1 }, /* (280) cmd ::= query_expression */
  {  253,   -1 }, /* (281) literal ::= NK_INTEGER */
  {  253,   -1 }, /* (282) literal ::= NK_FLOAT */
  {  253,   -1 }, /* (283) literal ::= NK_STRING */
  {  253,   -1 }, /* (284) literal ::= NK_BOOL */
  {  253,   -2 }, /* (285) literal ::= TIMESTAMP NK_STRING */
  {  253,   -1 }, /* (286) literal ::= duration_literal */
  {  253,   -1 }, /* (287) literal ::= NULL */
  {  253,   -1 }, /* (288) literal ::= NK_QUESTION */
  {  294,   -1 }, /* (289) duration_literal ::= NK_VARIABLE */
  {  321,   -1 }, /* (290) signed ::= NK_INTEGER */
  {  321,   -2 }, /* (291) signed ::= NK_PLUS NK_INTEGER */
  {  321,   -2 }, /* (292) signed ::= NK_MINUS NK_INTEGER */
  {  321,   -1 }, /* (293) signed ::= NK_FLOAT */
  {  321,   -2 }, /* (294) signed ::= NK_PLUS NK_FLOAT */
  {  321,   -2 }, /* (295) signed ::= NK_MINUS NK_FLOAT */
  {  283,   -1 }, /* (296) signed_literal ::= signed */
  {  283,   -1 }, /* (297) signed_literal ::= NK_STRING */
  {  283,   -1 }, /* (298) signed_literal ::= NK_BOOL */
  {  283,   -2 }, /* (299) signed_literal ::= TIMESTAMP NK_STRING */
  {  283,   -1 }, /* (300) signed_literal ::= duration_literal */
  {  283,   -1 }, /* (301) signed_literal ::= NULL */
  {  283,   -1 }, /* (302) signed_literal ::= literal_func */
  {  286,   -1 }, /* (303) literal_list ::= signed_literal */
  {  286,   -3 }, /* (304) literal_list ::= literal_list NK_COMMA signed_literal */
  {  261,   -1 }, /* (305) db_name ::= NK_ID */
  {  289,   -1 }, /* (306) table_name ::= NK_ID */
  {  281,   -1 }, /* (307) column_name ::= NK_ID */
  {  296,   -1 }, /* (308) function_name ::= NK_ID */
  {  323,   -1 }, /* (309) table_alias ::= NK_ID */
  {  324,   -1 }, /* (310) column_alias ::= NK_ID */
  {  255,   -1 }, /* (311) user_name ::= NK_ID */
  {  302,   -1 }, /* (312) index_name ::= NK_ID */
  {  310,   -1 }, /* (313) topic_name ::= NK_ID */
  {  317,   -1 }, /* (314) stream_name ::= NK_ID */
  {  312,   -1 }, /* (315) cgroup_name ::= NK_ID */
  {  325,   -1 }, /* (316) expression ::= literal */
  {  325,   -1 }, /* (317) expression ::= pseudo_column */
  {  325,   -1 }, /* (318) expression ::= column_reference */
  {  325,   -1 }, /* (319) expression ::= function_expression */
  {  325,   -1 }, /* (320) expression ::= subquery */
  {  325,   -3 }, /* (321) expression ::= NK_LP expression NK_RP */
  {  325,   -2 }, /* (322) expression ::= NK_PLUS expression */
  {  325,   -2 }, /* (323) expression ::= NK_MINUS expression */
  {  325,   -3 }, /* (324) expression ::= expression NK_PLUS expression */
  {  325,   -3 }, /* (325) expression ::= expression NK_MINUS expression */
  {  325,   -3 }, /* (326) expression ::= expression NK_STAR expression */
  {  325,   -3 }, /* (327) expression ::= expression NK_SLASH expression */
  {  325,   -3 }, /* (328) expression ::= expression NK_REM expression */
  {  325,   -3 }, /* (329) expression ::= column_reference NK_ARROW NK_STRING */
  {  325,   -3 }, /* (330) expression ::= expression NK_BITAND expression */
  {  325,   -3 }, /* (331) expression ::= expression NK_BITOR expression */
  {  308,   -1 }, /* (332) expression_list ::= expression */
  {  308,   -3 }, /* (333) expression_list ::= expression_list NK_COMMA expression */
  {  327,   -1 }, /* (334) column_reference ::= column_name */
  {  327,   -3 }, /* (335) column_reference ::= table_name NK_DOT column_name */
  {  326,   -1 }, /* (336) pseudo_column ::= ROWTS */
  {  326,   -1 }, /* (337) pseudo_column ::= TBNAME */
  {  326,   -3 }, /* (338) pseudo_column ::= table_name NK_DOT TBNAME */
  {  326,   -1 }, /* (339) pseudo_column ::= QSTARTTS */
  {  326,   -1 }, /* (340) pseudo_column ::= QENDTS */
  {  326,   -1 }, /* (341) pseudo_column ::= WSTARTTS */
  {  326,   -1 }, /* (342) pseudo_column ::= WENDTS */
  {  326,   -1 }, /* (343) pseudo_column ::= WDURATION */
  {  328,   -4 }, /* (344) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  328,   -4 }, /* (345) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  328,   -6 }, /* (346) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  328,   -1 }, /* (347) function_expression ::= literal_func */
  {  322,   -3 }, /* (348) literal_func ::= noarg_func NK_LP NK_RP */
  {  322,   -1 }, /* (349) literal_func ::= NOW */
  {  332,   -1 }, /* (350) noarg_func ::= NOW */
  {  332,   -1 }, /* (351) noarg_func ::= TODAY */
  {  332,   -1 }, /* (352) noarg_func ::= TIMEZONE */
  {  332,   -1 }, /* (353) noarg_func ::= DATABASE */
  {  332,   -1 }, /* (354) noarg_func ::= CLIENT_VERSION */
  {  332,   -1 }, /* (355) noarg_func ::= SERVER_VERSION */
  {  332,   -1 }, /* (356) noarg_func ::= SERVER_STATUS */
  {  332,   -1 }, /* (357) noarg_func ::= CURRENT_USER */
  {  332,   -1 }, /* (358) noarg_func ::= USER */
  {  330,   -1 }, /* (359) star_func ::= COUNT */
  {  330,   -1 }, /* (360) star_func ::= FIRST */
  {  330,   -1 }, /* (361) star_func ::= LAST */
  {  330,   -1 }, /* (362) star_func ::= LAST_ROW */
  {  331,   -1 }, /* (363) star_func_para_list ::= NK_STAR */
  {  331,   -1 }, /* (364) star_func_para_list ::= other_para_list */
  {  333,   -1 }, /* (365) other_para_list ::= star_func_para */
  {  333,   -3 }, /* (366) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  334,   -1 }, /* (367) star_func_para ::= expression */
  {  334,   -3 }, /* (368) star_func_para ::= table_name NK_DOT NK_STAR */
  {  335,   -3 }, /* (369) predicate ::= expression compare_op expression */
  {  335,   -5 }, /* (370) predicate ::= expression BETWEEN expression AND expression */
  {  335,   -6 }, /* (371) predicate ::= expression NOT BETWEEN expression AND expression */
  {  335,   -3 }, /* (372) predicate ::= expression IS NULL */
  {  335,   -4 }, /* (373) predicate ::= expression IS NOT NULL */
  {  335,   -3 }, /* (374) predicate ::= expression in_op in_predicate_value */
  {  336,   -1 }, /* (375) compare_op ::= NK_LT */
  {  336,   -1 }, /* (376) compare_op ::= NK_GT */
  {  336,   -1 }, /* (377) compare_op ::= NK_LE */
  {  336,   -1 }, /* (378) compare_op ::= NK_GE */
  {  336,   -1 }, /* (379) compare_op ::= NK_NE */
  {  336,   -1 }, /* (380) compare_op ::= NK_EQ */
  {  336,   -1 }, /* (381) compare_op ::= LIKE */
  {  336,   -2 }, /* (382) compare_op ::= NOT LIKE */
  {  336,   -1 }, /* (383) compare_op ::= MATCH */
  {  336,   -1 }, /* (384) compare_op ::= NMATCH */
  {  336,   -1 }, /* (385) compare_op ::= CONTAINS */
  {  337,   -1 }, /* (386) in_op ::= IN */
  {  337,   -2 }, /* (387) in_op ::= NOT IN */
  {  338,   -3 }, /* (388) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  339,   -1 }, /* (389) boolean_value_expression ::= boolean_primary */
  {  339,   -2 }, /* (390) boolean_value_expression ::= NOT boolean_primary */
  {  339,   -3 }, /* (391) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  339,   -3 }, /* (392) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  340,   -1 }, /* (393) boolean_primary ::= predicate */
  {  340,   -3 }, /* (394) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  341,   -1 }, /* (395) common_expression ::= expression */
  {  341,   -1 }, /* (396) common_expression ::= boolean_value_expression */
  {  342,    0 }, /* (397) from_clause_opt ::= */
  {  342,   -2 }, /* (398) from_clause_opt ::= FROM table_reference_list */
  {  343,   -1 }, /* (399) table_reference_list ::= table_reference */
  {  343,   -3 }, /* (400) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  344,   -1 }, /* (401) table_reference ::= table_primary */
  {  344,   -1 }, /* (402) table_reference ::= joined_table */
  {  345,   -2 }, /* (403) table_primary ::= table_name alias_opt */
  {  345,   -4 }, /* (404) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  345,   -2 }, /* (405) table_primary ::= subquery alias_opt */
  {  345,   -1 }, /* (406) table_primary ::= parenthesized_joined_table */
  {  347,    0 }, /* (407) alias_opt ::= */
  {  347,   -1 }, /* (408) alias_opt ::= table_alias */
  {  347,   -2 }, /* (409) alias_opt ::= AS table_alias */
  {  348,   -3 }, /* (410) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  348,   -3 }, /* (411) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  346,   -6 }, /* (412) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  349,    0 }, /* (413) join_type ::= */
  {  349,   -1 }, /* (414) join_type ::= INNER */
  {  351,  -12 }, /* (415) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  352,    0 }, /* (416) set_quantifier_opt ::= */
  {  352,   -1 }, /* (417) set_quantifier_opt ::= DISTINCT */
  {  352,   -1 }, /* (418) set_quantifier_opt ::= ALL */
  {  353,   -1 }, /* (419) select_list ::= NK_STAR */
  {  353,   -1 }, /* (420) select_list ::= select_sublist */
  {  361,   -1 }, /* (421) select_sublist ::= select_item */
  {  361,   -3 }, /* (422) select_sublist ::= select_sublist NK_COMMA select_item */
  {  362,   -1 }, /* (423) select_item ::= common_expression */
  {  362,   -2 }, /* (424) select_item ::= common_expression column_alias */
  {  362,   -3 }, /* (425) select_item ::= common_expression AS column_alias */
  {  362,   -3 }, /* (426) select_item ::= table_name NK_DOT NK_STAR */
  {  320,    0 }, /* (427) where_clause_opt ::= */
  {  320,   -2 }, /* (428) where_clause_opt ::= WHERE search_condition */
  {  354,    0 }, /* (429) partition_by_clause_opt ::= */
  {  354,   -3 }, /* (430) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  358,    0 }, /* (431) twindow_clause_opt ::= */
  {  358,   -6 }, /* (432) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  358,   -4 }, /* (433) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  358,   -6 }, /* (434) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  358,   -8 }, /* (435) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  305,    0 }, /* (436) sliding_opt ::= */
  {  305,   -4 }, /* (437) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  357,    0 }, /* (438) fill_opt ::= */
  {  357,   -4 }, /* (439) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  357,   -6 }, /* (440) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  363,   -1 }, /* (441) fill_mode ::= NONE */
  {  363,   -1 }, /* (442) fill_mode ::= PREV */
  {  363,   -1 }, /* (443) fill_mode ::= NULL */
  {  363,   -1 }, /* (444) fill_mode ::= LINEAR */
  {  363,   -1 }, /* (445) fill_mode ::= NEXT */
  {  359,    0 }, /* (446) group_by_clause_opt ::= */
  {  359,   -3 }, /* (447) group_by_clause_opt ::= GROUP BY group_by_list */
  {  364,   -1 }, /* (448) group_by_list ::= expression */
  {  364,   -3 }, /* (449) group_by_list ::= group_by_list NK_COMMA expression */
  {  360,    0 }, /* (450) having_clause_opt ::= */
  {  360,   -2 }, /* (451) having_clause_opt ::= HAVING search_condition */
  {  355,    0 }, /* (452) range_opt ::= */
  {  355,   -6 }, /* (453) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  356,    0 }, /* (454) every_opt ::= */
  {  356,   -4 }, /* (455) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  311,   -4 }, /* (456) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  365,   -1 }, /* (457) query_expression_body ::= query_primary */
  {  365,   -4 }, /* (458) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  365,   -3 }, /* (459) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  369,   -1 }, /* (460) query_primary ::= query_specification */
  {  369,   -6 }, /* (461) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  366,    0 }, /* (462) order_by_clause_opt ::= */
  {  366,   -3 }, /* (463) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  367,    0 }, /* (464) slimit_clause_opt ::= */
  {  367,   -2 }, /* (465) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  367,   -4 }, /* (466) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  367,   -4 }, /* (467) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  368,    0 }, /* (468) limit_clause_opt ::= */
  {  368,   -2 }, /* (469) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  368,   -4 }, /* (470) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  368,   -4 }, /* (471) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  329,   -3 }, /* (472) subquery ::= NK_LP query_expression NK_RP */
  {  350,   -1 }, /* (473) search_condition ::= common_expression */
  {  370,   -1 }, /* (474) sort_specification_list ::= sort_specification */
  {  370,   -3 }, /* (475) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  371,   -3 }, /* (476) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  372,    0 }, /* (477) ordering_specification_opt ::= */
  {  372,   -1 }, /* (478) ordering_specification_opt ::= ASC */
  {  372,   -1 }, /* (479) ordering_specification_opt ::= DESC */
  {  373,    0 }, /* (480) null_ordering_opt ::= */
  {  373,   -2 }, /* (481) null_ordering_opt ::= NULLS FIRST */
  {  373,   -2 }, /* (482) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,251,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,252,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,251,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,253,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,254,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,252,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,254,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,253,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy657, &yymsp[-1].minor.yy0, yymsp[0].minor.yy619); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy657, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy657, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy657, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy657); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy619 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy619 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy701, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy657); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy701, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy657); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy701 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy701 = yymsp[0].minor.yy701; }
  yymsp[0].minor.yy701 = yylhsminor.yy701;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy701 = yymsp[-2].minor.yy701 | yymsp[0].minor.yy701; }
  yymsp[-2].minor.yy701 = yylhsminor.yy701;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy701 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy701 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy657 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy657 = yylhsminor.yy657;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy657 = yymsp[-2].minor.yy657; }
  yymsp[-2].minor.yy657 = yylhsminor.yy657;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy657, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy657); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 305: /* db_name ::= NK_ID */ yytestcase(yyruleno==305);
      case 306: /* table_name ::= NK_ID */ yytestcase(yyruleno==306);
      case 307: /* column_name ::= NK_ID */ yytestcase(yyruleno==307);
      case 308: /* function_name ::= NK_ID */ yytestcase(yyruleno==308);
      case 309: /* table_alias ::= NK_ID */ yytestcase(yyruleno==309);
      case 310: /* column_alias ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* user_name ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* index_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* topic_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* stream_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 350: /* noarg_func ::= NOW */ yytestcase(yyruleno==350);
      case 351: /* noarg_func ::= TODAY */ yytestcase(yyruleno==351);
      case 352: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==352);
      case 353: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==353);
      case 354: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==354);
      case 355: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==355);
      case 356: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==356);
      case 357: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= USER */ yytestcase(yyruleno==358);
      case 359: /* star_func ::= COUNT */ yytestcase(yyruleno==359);
      case 360: /* star_func ::= FIRST */ yytestcase(yyruleno==360);
      case 361: /* star_func ::= LAST */ yytestcase(yyruleno==361);
      case 362: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==362);
{ yylhsminor.yy657 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy657 = yylhsminor.yy657;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy97, &yymsp[-1].minor.yy657, yymsp[0].minor.yy652); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy97, &yymsp[0].minor.yy657); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy657); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy657, yymsp[0].minor.yy652); }
        break;
      case 66: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy97 = true; }
        break;
      case 67: /* not_exists_opt ::= */
      case 69: /* exists_opt ::= */ yytestcase(yyruleno==69);
      case 248: /* analyze_opt ::= */ yytestcase(yyruleno==248);
      case 256: /* agg_func_opt ::= */ yytestcase(yyruleno==256);
      case 416: /* set_quantifier_opt ::= */ yytestcase(yyruleno==416);
{ yymsp[1].minor.yy97 = false; }
        break;
      case 68: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy97 = true; }
        break;
      case 70: /* db_options ::= */
{ yymsp[1].minor.yy652 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 71: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 72: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 73: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 74: /* db_options ::= db_options DURATION NK_INTEGER */
      case 75: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==75);
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 76: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 77: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 78: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 79: /* db_options ::= db_options KEEP integer_list */
      case 80: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==80);
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_KEEP, yymsp[0].minor.yy24); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 81: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 82: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 83: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 84: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 85: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 86: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 87: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 88: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 89: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_RETENTIONS, yymsp[0].minor.yy24); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 90: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 91: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy652 = createAlterDatabaseOptions(pCxt); yylhsminor.yy652 = setAlterDatabaseOption(pCxt, yylhsminor.yy652, &yymsp[0].minor.yy189); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 92: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy652 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy652, &yymsp[0].minor.yy189); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 93: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 94: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= KEEP integer_list */
      case 97: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==97);
{ yymsp[-1].minor.yy189.type = DB_OPTION_KEEP; yymsp[-1].minor.yy189.pList = yymsp[0].minor.yy24; }
        break;
      case 98: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_PAGES; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_STRICT; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 101: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy189.type = DB_OPTION_WAL; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy24 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy24 = yylhsminor.yy24;
        break;
      case 103: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 277: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==277);
{ yylhsminor.yy24 = addNodeToList(pCxt, yymsp[-2].minor.yy24, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy24 = yylhsminor.yy24;
        break;
      case 104: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy24 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy24 = yylhsminor.yy24;
        break;
      case 105: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy24 = addNodeToList(pCxt, yymsp[-2].minor.yy24, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy24 = yylhsminor.yy24;
        break;
      case 106: /* retention_list ::= retention */
      case 126: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==126);
      case 129: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==129);
      case 136: /* column_def_list ::= column_def */ yytestcase(yyruleno==136);
      case 179: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==179);
      case 184: /* col_name_list ::= col_name */ yytestcase(yyruleno==184);
      case 231: /* func_list ::= func */ yytestcase(yyruleno==231);
      case 303: /* literal_list ::= signed_literal */ yytestcase(yyruleno==303);
      case 365: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==365);
      case 421: /* select_sublist ::= select_item */ yytestcase(yyruleno==421);
      case 474: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==474);
{ yylhsminor.yy24 = createNodeList(pCxt, yymsp[0].minor.yy652); }
  yymsp[0].minor.yy24 = yylhsminor.yy24;
        break;
      case 107: /* retention_list ::= retention_list NK_COMMA retention */
      case 137: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==185);
      case 232: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==232);
      case 304: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==304);
      case 366: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==366);
      case 422: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==422);
      case 475: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==475);
{ yylhsminor.yy24 = addNodeToList(pCxt, yymsp[-2].minor.yy24, yymsp[0].minor.yy652); }
  yymsp[-2].minor.yy24 = yylhsminor.yy24;
        break;
      case 108: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy652 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 109: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 111: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==111);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy97, yymsp[-5].minor.yy652, yymsp[-3].minor.yy24, yymsp[-1].minor.yy24, yymsp[0].minor.yy652); }
        break;
      case 110: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy24); }
        break;
      case 112: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy24); }
        break;
      case 113: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy97, yymsp[0].minor.yy652); }
        break;
      case 114: /* cmd ::= ALTER TABLE alter_table_clause */
      case 115: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==115);
      case 280: /* cmd ::= query_expression */ yytestcase(yyruleno==280);
{ pCxt->pRootNode = yymsp[0].minor.yy652; }
        break;
      case 116: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy652 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 117: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy657, yymsp[0].minor.yy48); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 118: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy652 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy652, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy657); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 119: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy657, yymsp[0].minor.yy48); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 120: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy652 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy657, &yymsp[0].minor.yy657); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 121: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy657, yymsp[0].minor.yy48); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 122: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy652 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy652, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy657); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 123: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy657, yymsp[0].minor.yy48); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 124: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy652 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy657, &yymsp[0].minor.yy657); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 125: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy652 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy652, &yymsp[-2].minor.yy657, yymsp[0].minor.yy652); }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 127: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 130: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==130);
{ yylhsminor.yy24 = addNodeToList(pCxt, yymsp[-1].minor.yy24, yymsp[0].minor.yy652); }
  yymsp[-1].minor.yy24 = yylhsminor.yy24;
        break;
      case 128: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy652 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy97, yymsp[-8].minor.yy652, yymsp[-6].minor.yy652, yymsp[-5].minor.yy24, yymsp[-2].minor.yy24, yymsp[0].minor.yy652); }
  yymsp[-9].minor.yy652 = yylhsminor.yy652;
        break;
      case 131: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy652 = createDropTableClause(pCxt, yymsp[-1].minor.yy97, yymsp[0].minor.yy652); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 132: /* specific_tags_opt ::= */
      case 163: /* tags_def_opt ::= */ yytestcase(yyruleno==163);
      case 429: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==429);
      case 446: /* group_by_clause_opt ::= */ yytestcase(yyruleno==446);
      case 462: /* order_by_clause_opt ::= */ yytestcase(yyruleno==462);
{ yymsp[1].minor.yy24 = NULL; }
        break;
      case 133: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy24 = yymsp[-1].minor.yy24; }
        break;
      case 134: /* full_table_name ::= table_name */
{ yylhsminor.yy652 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy657, NULL); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 135: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy652 = createRealTableNode(pCxt, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy657, NULL); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 138: /* column_def ::= column_name type_name */
{ yylhsminor.yy652 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy657, yymsp[0].minor.yy48, NULL); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 139: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy652 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy657, yymsp[-2].minor.yy48, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 140: /* type_name ::= BOOL */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 141: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 142: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 143: /* type_name ::= INT */
      case 144: /* type_name ::= INTEGER */ yytestcase(yyruleno==144);
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 145: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 146: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 147: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 148: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy48 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 149: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 150: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy48 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 151: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy48 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 152: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy48 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 153: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy48 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 154: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy48 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 155: /* type_name ::= JSON */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 156: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy48 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 158: /* type_name ::= BLOB */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 159: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy48 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy48 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy48 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy48 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 164: /* tags_def_opt ::= tags_def */
      case 364: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==364);
      case 420: /* select_list ::= select_sublist */ yytestcase(yyruleno==420);
{ yylhsminor.yy24 = yymsp[0].minor.yy24; }
  yymsp[0].minor.yy24 = yylhsminor.yy24;
        break;
      case 165: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy24 = yymsp[-1].minor.yy24; }
        break;
      case 166: /* table_options ::= */
{ yymsp[1].minor.yy652 = createDefaultTableOptions(pCxt); }
        break;
      case 167: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 168: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy24); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 169: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy24); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 170: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-4].minor.yy652, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy24); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 171: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 172: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-4].minor.yy652, TABLE_OPTION_SMA, yymsp[-1].minor.yy24); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 173: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy652 = createAlterTableOptions(pCxt); yylhsminor.yy652 = setTableOption(pCxt, yylhsminor.yy652, yymsp[0].minor.yy189.type, &yymsp[0].minor.yy189.val); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 174: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-1].minor.yy652, yymsp[0].minor.yy189.type, &yymsp[0].minor.yy189.val); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 175: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy189.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 176: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy189.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy189.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* duration_list ::= duration_literal */
      case 332: /* expression_list ::= expression */ yytestcase(yyruleno==332);
{ yylhsminor.yy24 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy652)); }
  yymsp[0].minor.yy24 = yylhsminor.yy24;
        break;
      case 178: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 333: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==333);
{ yylhsminor.yy24 = addNodeToList(pCxt, yymsp[-2].minor.yy24, releaseRawExprNode(pCxt, yymsp[0].minor.yy652)); }
  yymsp[-2].minor.yy24 = yylhsminor.yy24;
        break;
      case 181: /* rollup_func_name ::= function_name */
{ yylhsminor.yy652 = createFunctionNode(pCxt, &yymsp[0].minor.yy657, NULL); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 182: /* rollup_func_name ::= FIRST */
      case 183: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==183);
{ yylhsminor.yy652 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 186: /* col_name ::= column_name */
{ yylhsminor.yy652 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy657); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 187: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 188: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 189: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 190: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy652, yymsp[0].minor.yy652, OP_TYPE_LIKE); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy652, yymsp[0].minor.yy652, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy652, NULL, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 195: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 196: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 197: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy652, yymsp[-1].minor.yy652, OP_TYPE_EQUAL); }
        break;
      case 198: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 199: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 200: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 201: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 202: /* cmd ::= SHOW LICENCE */
      case 203: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==203);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 204: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy657); }
        break;
      case 205: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy652); }
        break;
      case 206: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy652); }
        break;
      case 207: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 208: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 209: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 210: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 211: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 213: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 216: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy652); }
        break;
      case 218: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 219: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 220: /* db_name_cond_opt ::= */
      case 225: /* from_db_opt ::= */ yytestcase(yyruleno==225);
{ yymsp[1].minor.yy652 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 221: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy657); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 222: /* like_pattern_opt ::= */
      case 262: /* into_opt ::= */ yytestcase(yyruleno==262);
      case 397: /* from_clause_opt ::= */ yytestcase(yyruleno==397);
      case 427: /* where_clause_opt ::= */ yytestcase(yyruleno==427);
      case 431: /* twindow_clause_opt ::= */ yytestcase(yyruleno==431);
      case 436: /* sliding_opt ::= */ yytestcase(yyruleno==436);
      case 438: /* fill_opt ::= */ yytestcase(yyruleno==438);
      case 450: /* having_clause_opt ::= */ yytestcase(yyruleno==450);
      case 452: /* range_opt ::= */ yytestcase(yyruleno==452);
      case 454: /* every_opt ::= */ yytestcase(yyruleno==454);
      case 464: /* slimit_clause_opt ::= */ yytestcase(yyruleno==464);
      case 468: /* limit_clause_opt ::= */ yytestcase(yyruleno==468);
{ yymsp[1].minor.yy652 = NULL; }
        break;
      case 223: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 224: /* table_name_cond ::= table_name */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy657); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 226: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy657); }
        break;
      case 227: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy97, &yymsp[-3].minor.yy657, &yymsp[-1].minor.yy657, NULL, yymsp[0].minor.yy652); }
        break;
      case 228: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy97, &yymsp[0].minor.yy657); }
        break;
      case 229: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy652 = createIndexOption(pCxt, yymsp[-7].minor.yy24, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), NULL, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 230: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy652 = createIndexOption(pCxt, yymsp[-9].minor.yy24, releaseRawExprNode(pCxt, yymsp[-5].minor.yy652), releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 233: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy652 = createFunctionNode(pCxt, &yymsp[-3].minor.yy657, yymsp[-1].minor.yy24); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 234: /* sma_stream_opt ::= */
      case 264: /* stream_options ::= */ yytestcase(yyruleno==264);
{ yymsp[1].minor.yy652 = createStreamOptions(pCxt); }
        break;
      case 235: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 268: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==268);
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 236: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 237: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy97, &yymsp[-2].minor.yy657, yymsp[0].minor.yy652); }
        break;
      case 238: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy97, &yymsp[-3].minor.yy657, &yymsp[0].minor.yy657, false); }
        break;
      case 239: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy97, &yymsp[-5].minor.yy657, &yymsp[0].minor.yy657, true); }
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy97, &yymsp[-3].minor.yy657, yymsp[0].minor.yy652, false); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy97, &yymsp[-5].minor.yy657, yymsp[0].minor.yy652, true); }
        break;
      case 242: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy97, &yymsp[0].minor.yy657); }
        break;
      case 243: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy97, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy657); }
        break;
      case 244: /* cmd ::= DESC full_table_name */
      case 245: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==245);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy652); }
        break;
      case 246: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 247: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy97, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 249: /* analyze_opt ::= ANALYZE */
      case 257: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==257);
      case 417: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==417);
{ yymsp[0].minor.yy97 = true; }
        break;
      case 250: /* explain_options ::= */
{ yymsp[1].minor.yy652 = createDefaultExplainOptions(pCxt); }
        break;
      case 251: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy652 = setExplainVerbose(pCxt, yymsp[-2].minor.yy652, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 252: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy652 = setExplainRatio(pCxt, yymsp[-2].minor.yy652, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 253: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy24); }
        break;
      case 254: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy97, yymsp[-8].minor.yy97, &yymsp[-5].minor.yy657, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy48, yymsp[0].minor.yy244); }
        break;
      case 255: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy97, &yymsp[0].minor.yy657); }
        break;
      case 258: /* bufsize_opt ::= */
{ yymsp[1].minor.yy244 = 0; }
        break;
      case 259: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy244 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 260: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy97, &yymsp[-4].minor.yy657, yymsp[-2].minor.yy652, yymsp[-3].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 261: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy97, &yymsp[0].minor.yy657); }
        break;
      case 263: /* into_opt ::= INTO full_table_name */
      case 398: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==398);
      case 428: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==428);
      case 451: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==451);
{ yymsp[-1].minor.yy652 = yymsp[0].minor.yy652; }
        break;
      case 265: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 266: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 267: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy652)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy652)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); yylhsminor.yy652 = yymsp[-3].minor.yy652; }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 269: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 270: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 271: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 272: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 273: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 274: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy24); }
        break;
      case 275: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 276: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy24 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 278: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy657); }
        break;
      case 279: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 281: /* literal ::= NK_INTEGER */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 282: /* literal ::= NK_FLOAT */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 283: /* literal ::= NK_STRING */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 284: /* literal ::= NK_BOOL */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 285: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 286: /* literal ::= duration_literal */
      case 296: /* signed_literal ::= signed */ yytestcase(yyruleno==296);
      case 316: /* expression ::= literal */ yytestcase(yyruleno==316);
      case 317: /* expression ::= pseudo_column */ yytestcase(yyruleno==317);
      case 318: /* expression ::= column_reference */ yytestcase(yyruleno==318);
      case 319: /* expression ::= function_expression */ yytestcase(yyruleno==319);
      case 320: /* expression ::= subquery */ yytestcase(yyruleno==320);
      case 347: /* function_expression ::= literal_func */ yytestcase(yyruleno==347);
      case 389: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==389);
      case 393: /* boolean_primary ::= predicate */ yytestcase(yyruleno==393);
      case 395: /* common_expression ::= expression */ yytestcase(yyruleno==395);
      case 396: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==396);
      case 399: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==399);
      case 401: /* table_reference ::= table_primary */ yytestcase(yyruleno==401);
      case 402: /* table_reference ::= joined_table */ yytestcase(yyruleno==402);
      case 406: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==406);
      case 457: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==457);
      case 460: /* query_primary ::= query_specification */ yytestcase(yyruleno==460);
{ yylhsminor.yy652 = yymsp[0].minor.yy652; }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 287: /* literal ::= NULL */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 288: /* literal ::= NK_QUESTION */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 289: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 290: /* signed ::= NK_INTEGER */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 291: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 292: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 293: /* signed ::= NK_FLOAT */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 294: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 295: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 297: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 298: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 299: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 300: /* signed_literal ::= duration_literal */
      case 302: /* signed_literal ::= literal_func */ yytestcase(yyruleno==302);
      case 367: /* star_func_para ::= expression */ yytestcase(yyruleno==367);
      case 423: /* select_item ::= common_expression */ yytestcase(yyruleno==423);
      case 473: /* search_condition ::= common_expression */ yytestcase(yyruleno==473);
{ yylhsminor.yy652 = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 301: /* signed_literal ::= NULL */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 321: /* expression ::= NK_LP expression NK_RP */
      case 394: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==394);
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 322: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy652));
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 323: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy652), NULL));
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 324: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 325: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 326: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 327: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 328: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 329: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 330: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 331: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 334: /* column_reference ::= column_name */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy657, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy657)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 335: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy657, createColumnNode(pCxt, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy657)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 336: /* pseudo_column ::= ROWTS */
      case 337: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==337);
      case 339: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==339);
      case 340: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==340);
      case 341: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==341);
      case 342: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==342);
      case 343: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==343);
      case 349: /* literal_func ::= NOW */ yytestcase(yyruleno==349);
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 338: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy657)))); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 344: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 345: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==345);
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy657, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy657, yymsp[-1].minor.yy24)); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 346: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), yymsp[-1].minor.yy48)); }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 348: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy657, NULL)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 363: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy24 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy24 = yylhsminor.yy24;
        break;
      case 368: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 426: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==426);
{ yylhsminor.yy652 = createColumnNode(pCxt, &yymsp[-2].minor.yy657, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 369: /* predicate ::= expression compare_op expression */
      case 374: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==374);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy700, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 370: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy652), releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 371: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy652), releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 372: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), NULL));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 373: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), NULL));
                                                                                  }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 375: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy700 = OP_TYPE_LOWER_THAN; }
        break;
      case 376: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy700 = OP_TYPE_GREATER_THAN; }
        break;
      case 377: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy700 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 378: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy700 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 379: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy700 = OP_TYPE_NOT_EQUAL; }
        break;
      case 380: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy700 = OP_TYPE_EQUAL; }
        break;
      case 381: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy700 = OP_TYPE_LIKE; }
        break;
      case 382: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy700 = OP_TYPE_NOT_LIKE; }
        break;
      case 383: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy700 = OP_TYPE_MATCH; }
        break;
      case 384: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy700 = OP_TYPE_NMATCH; }
        break;
      case 385: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy700 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 386: /* in_op ::= IN */
{ yymsp[0].minor.yy700 = OP_TYPE_IN; }
        break;
      case 387: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy700 = OP_TYPE_NOT_IN; }
        break;
      case 388: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy24)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 390: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy652), NULL));
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 391: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 392: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 400: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy652 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy652, yymsp[0].minor.yy652, NULL); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 403: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy652 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy657, &yymsp[0].minor.yy657); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 404: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy652 = createRealTableNode(pCxt, &yymsp[-3].minor.yy657, &yymsp[-1].minor.yy657, &yymsp[0].minor.yy657); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 405: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy652 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652), &yymsp[0].minor.yy657); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 407: /* alias_opt ::= */
{ yymsp[1].minor.yy657 = nil_token;  }
        break;
      case 408: /* alias_opt ::= table_alias */
{ yylhsminor.yy657 = yymsp[0].minor.yy657; }
  yymsp[0].minor.yy657 = yylhsminor.yy657;
        break;
      case 409: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy657 = yymsp[0].minor.yy657; }
        break;
      case 410: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 411: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==411);
{ yymsp[-2].minor.yy652 = yymsp[-1].minor.yy652; }
        break;
      case 412: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy652 = createJoinTableNode(pCxt, yymsp[-4].minor.yy596, yymsp[-5].minor.yy652, yymsp[-2].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 413: /* join_type ::= */
{ yymsp[1].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 414: /* join_type ::= INNER */
{ yymsp[0].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 415: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy652 = createSelectStmt(pCxt, yymsp[-10].minor.yy97, yymsp[-9].minor.yy24, yymsp[-8].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addWhereClause(pCxt, yymsp[-11].minor.yy652, yymsp[-7].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addPartitionByClause(pCxt, yymsp[-11].minor.yy652, yymsp[-6].minor.yy24);
                                                                                    yymsp[-11].minor.yy652 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy652, yymsp[-2].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addGroupByClause(pCxt, yymsp[-11].minor.yy652, yymsp[-1].minor.yy24);
                                                                                    yymsp[-11].minor.yy652 = addHavingClause(pCxt, yymsp[-11].minor.yy652, yymsp[0].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addRangeClause(pCxt, yymsp[-11].minor.yy652, yymsp[-5].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addEveryClause(pCxt, yymsp[-11].minor.yy652, yymsp[-4].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addFillClause(pCxt, yymsp[-11].minor.yy652, yymsp[-3].minor.yy652);
                                                                                  }
        break;
      case 418: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy97 = false; }
        break;
      case 419: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy24 = NULL; }
        break;
      case 424: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy652 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652), &yymsp[0].minor.yy657); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 425: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy652 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), &yymsp[0].minor.yy657); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 430: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 447: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==447);
      case 463: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==463);
{ yymsp[-2].minor.yy24 = yymsp[0].minor.yy24; }
        break;
      case 432: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy652 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
        break;
      case 433: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy652 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
        break;
      case 434: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy652 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), NULL, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 435: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy652 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy652), releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 437: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 455: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==455);
{ yymsp[-3].minor.yy652 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy652); }
        break;
      case 439: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy652 = createFillNode(pCxt, yymsp[-1].minor.yy250, NULL); }
        break;
      case 440: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy652 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy24)); }
        break;
      case 441: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy250 = FILL_MODE_NONE; }
        break;
      case 442: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy250 = FILL_MODE_PREV; }
        break;
      case 443: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy250 = FILL_MODE_NULL; }
        break;
      case 444: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy250 = FILL_MODE_LINEAR; }
        break;
      case 445: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy250 = FILL_MODE_NEXT; }
        break;
      case 448: /* group_by_list ::= expression */
{ yylhsminor.yy24 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); }
  yymsp[0].minor.yy24 = yylhsminor.yy24;
        break;
      case 449: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy24 = addNodeToList(pCxt, yymsp[-2].minor.yy24, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); }
  yymsp[-2].minor.yy24 = yylhsminor.yy24;
        break;
      case 453: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy652 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
        break;
      case 456: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy652 = addOrderByClause(pCxt, yymsp[-3].minor.yy652, yymsp[-2].minor.yy24);
                                                                                    yylhsminor.yy652 = addSlimitClause(pCxt, yylhsminor.yy652, yymsp[-1].minor.yy652);
                                                                                    yylhsminor.yy652 = addLimitClause(pCxt, yylhsminor.yy652, yymsp[0].minor.yy652);
                                                                                  }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 458: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy652 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 459: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy652 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 461: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy652 = yymsp[-4].minor.yy652; }
  yy_destructor(yypParser,366,&yymsp[-3].minor);
  yy_destructor(yypParser,367,&yymsp[-2].minor);
  yy_destructor(yypParser,368,&yymsp[-1].minor);
        break;
      case 465: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 469: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==469);
{ yymsp[-1].minor.yy652 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 466: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 470: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==470);
{ yymsp[-3].minor.yy652 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 467: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 471: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==471);
{ yymsp[-3].minor.yy652 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 472: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy652); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 476: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy652 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), yymsp[-1].minor.yy598, yymsp[0].minor.yy653); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 477: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy598 = ORDER_ASC; }
        break;
      case 478: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy598 = ORDER_ASC; }
        break;
      case 479: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy598 = ORDER_DESC; }
        break;
      case 480: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy653 = NULL_ORDER_DEFAULT; }
        break;
      case 481: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy653 = NULL_ORDER_FIRST; }
        break;
      case 482: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy653 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
