/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 484
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int64_t yy85;
  ENullOrder yy257;
  EFillMode yy470;
  STokenPair yy489;
  SNode* yy520;
  EOperatorType yy524;
  bool yy537;
  int8_t yy575;
  EJoinType yy596;
  SAlterOption yy805;
  SToken yy833;
  SDataType yy840;
  int32_t yy860;
  SNodeList* yy904;
  EOrder yy906;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             789
#define YYNRULE              594
#define YYNRULE_WITH_ACTION  594
#define YYNTOKEN             336
#define YY_MAX_SHIFT         788
#define YY_MIN_SHIFTREDUCE   1165
#define YY_MAX_SHIFTREDUCE   1758
#define YY_ERROR_ACTION      1759
#define YY_ACCEPT_ACTION     1760
#define YY_NO_ACTION         1761
#define YY_MIN_REDUCE        1762
#define YY_MAX_REDUCE        2355
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2969)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2167,  445, 2145, 2057,  404,  444,  144, 1984, 1986, 2226,
 /*    10 */   696,  451,   48,   46, 1686, 1763, 2153,  218, 2055,  669,
 /*    20 */   399,  529, 1535, 1805,   41,   40, 2149,  639,   47,   45,
 /*    30 */    44,   43,   42, 1616, 1838, 1533,  123, 1560, 2185,  122,
 /*    40 */   121,  120,  119,  118,  117,  116,  115,  114,  620,  681,
 /*    50 */  2135, 2326,  698,   41,   40, 2185,  345,   47,   45,   44,
 /*    60 */    43,   42, 1611, 2151,  396,  649, 2332,  188,   19, 1560,
 /*    70 */  2057, 2327,  646,  692,  681, 1541,   47,   45,   44,   43,
 /*    80 */    42,  170,  392, 1774, 2166, 2054,  669, 2202, 1561,   30,
 /*    90 */   339, 2168,  702, 2170, 2171,  697,  695,  692,  683, 2220,
 /*   100 */   785,   66, 2118,   15,  762,  761,  760,  759,  411,  638,
 /*   110 */   758,  757,  146,  752,  751,  750,  749,  748,  747,  746,
 /*   120 */   159,  742,  741,  740,  410,  409,  737,  736,  735,  177,
 /*   130 */   176, 2100,   51,  526, 2270, 1356,  527, 1798,  123, 1618,
 /*   140 */  1619,  122,  121,  120,  119,  118,  117,  116,  115,  114,
 /*   150 */  1347,  724,  723,  722, 1351,  721, 1353, 1354,  720,  717,
 /*   160 */  2267, 1362,  714, 1364, 1365,  711,  708,   38,  303, 1591,
 /*   170 */  1601, 2331,  181, 1991, 2326, 1617, 1620,  285,  251,   62,
 /*   180 */   364, 1760,  667,  657,  142, 1762, 1445, 1446, 1989, 1536,
 /*   190 */  2330, 1534,  366, 2040, 2327, 2329,  543, 1755,   41,   40,
 /*   200 */    62, 1562,   47,   45,   44,   43,   42, 1390, 1391,  132,
 /*   210 */   131,  130,  129,  128,  127,  126,  125,  124,   62,  640,
 /*   220 */    93, 1539, 1540,  181, 1590, 1593, 1594, 1595, 1596, 1597,
 /*   230 */  1598, 1599, 1600,  694,  690, 1609, 1610, 1612, 1613, 1614,
 /*   240 */  1615,    2,   48,   46, 2041, 2167, 1223,  349, 1222, 1558,
 /*   250 */   399,  645, 1535,  414, 2326,  660,  482,  413,  358,  496,
 /*   260 */   393,  138,  495, 1616,  443, 1533,  442,   62,  167,  644,
 /*   270 */   188,  408,  407,  402, 2327,  646, 1941, 1561,  465, 1224,
 /*   280 */   497,  167,  681, 2185, 1560,  467,  282, 2263,  656, 1941,
 /*   290 */   134,  655, 1611, 2326, 1542, 2135,  441,  698,   19, 1754,
 /*   300 */   620,  650, 1645, 2326,  523, 1541,    9,  534,  644,  188,
 /*   310 */   527, 1798,  521, 2327,  646,  517,  513,  428, 2332,  188,
 /*   320 */  1985, 1986, 2331, 2327,  646, 2326,   44,   43,   42, 2166,
 /*   330 */   785,  367, 2202,   15,  191,  110, 2168,  702, 2170, 2171,
 /*   340 */   697, 2330,  692,  455, 1991, 2327, 2328,  185,   12, 2255,
 /*   350 */    10,  379,  284,  395, 2251,  191,   41,   40, 1646, 1989,
 /*   360 */    47,   45,   44,   43,   42,   51,  190,   62, 1563, 1618,
 /*   370 */  1619, 1198,  493,  191, 2281,  487,  486,  485,  484,  481,
 /*   380 */   480,  479,  478,  477,  473,  472,  471,  470,  348,  462,
 /*   390 */   461,  460,  531,  457,  456,  365, 1462, 1463,  528, 1591,
 /*   400 */  1601,  657,  142,  682, 1939, 1617, 1620,  584,  583,  582,
 /*   410 */  1200,  452, 1203, 1204,  574,  139,  578,  371,  489, 1536,
 /*   420 */   577, 1534,  191,  133,  453,  576,  581,  374,  373,  734,
 /*   430 */   566,  575, 1461, 1464,  598,   37,  397, 1640, 1641, 1642,
 /*   440 */  1643, 1644, 1648, 1649, 1650, 1651, 2021,  596,   52,  594,
 /*   450 */  1545, 1539, 1540, 1559, 1590, 1593, 1594, 1595, 1596, 1597,
 /*   460 */  1598, 1599, 1600,  694,  690, 1609, 1610, 1612, 1613, 1614,
 /*   470 */  1615,    2,   12,   48,   46,  682, 1939, 1991,  209,  208,
 /*   480 */   635,  399,  726, 1535,  389, 1982,  372,  668,  370,  369,
 /*   490 */  2167,  568, 1989, 1785, 1616,  133, 1533, 1714,  682, 1939,
 /*   500 */   699,  488,  571,  659,  186, 2263, 2264,  220,  140, 2268,
 /*   510 */  2331,  529,  570, 1805,  645, 2167,  569, 2326,  193,  262,
 /*   520 */   191, 1915,  191, 1611, 1679,  699,  663, 1562, 2185,   19,
 /*   530 */  1226, 1227,  644,  188,  682, 1939, 1541, 2327,  646,  541,
 /*   540 */  2135, 2050,  698, 2135,  632,  631, 1712, 1713, 1715, 1716,
 /*   550 */  1717,   41,   40, 2185,   57,   47,   45,   44,   43,   42,
 /*   560 */    87,  785,  249,  184,   15, 2135,  248,  698, 1841,  641,
 /*   570 */   636,  629,   87,  620, 2166, 1978, 2326, 2202, 1784,  607,
 /*   580 */   171, 2168,  702, 2170, 2171,  697, 1935,  692,  734,  368,
 /*   590 */   668, 2332,  188,   12,  682, 1939, 2327,  646, 1934, 2166,
 /*   600 */  1618, 1619, 2202,  191,  469,  110, 2168,  702, 2170, 2171,
 /*   610 */   697, 1748,  692,  468,  449,  145,  107,  152, 2226, 2255,
 /*   620 */   621, 2292, 1783,  395, 2251, 2167,   90,  668, 2135,  353,
 /*   630 */  1591, 1601,  378,  143,  600,  660, 1617, 1620,  584,  583,
 /*   640 */   582, 1931,  666,  433, 2050,  574,  139,  578,  562,  561,
 /*   650 */  1536,  577, 1534,  682, 1939, 1541,  576,  581,  374,  373,
 /*   660 */    41,   40,  575, 2185,   47,   45,   44,   43,   42, 1991,
 /*   670 */   435,  431, 2135,  450, 2156, 2135,  394,  698,  284,  677,
 /*   680 */  1647, 2050, 1539, 1540, 1989, 1590, 1593, 1594, 1595, 1596,
 /*   690 */  1597, 1598, 1599, 1600,  694,  690, 1609, 1610, 1612, 1613,
 /*   700 */  1614, 1615,    2,   48,   46, 1621,  684,  744, 2227, 2166,
 /*   710 */   250,  399, 2202, 1535,  166,  110, 2168,  702, 2170, 2171,
 /*   720 */   697, 1991,  692,  402, 1616, 2167, 1533,  185,  403, 2255,
 /*   730 */  2158,  164, 1311,  395, 2251,  699, 1989, 1807,  380, 1941,
 /*   740 */   589, 1916, 1563,   41,   40, 1310, 1989,   47,   45,   44,
 /*   750 */    43,   42,  405, 1611, 2282,  599, 1725,   35,  682, 1939,
 /*   760 */   167, 2167,  169, 2185,  682, 1939, 1541, 1652, 1941,  247,
 /*   770 */  1880,  699,  725, 2289, 1300, 2135,   34,  698,  459, 1506,
 /*   780 */  1507, 1928,   41,   40,  474,  592,   47,   45,   44,   43,
 /*   790 */    42,  785,  586,  686,   49, 2227, 1782, 2167,  246, 2185,
 /*   800 */   732,  157,  156,  729,  728,  727,  154,  699, 1315, 2166,
 /*   810 */   498, 2135, 2202,  698, 1302,  110, 2168,  702, 2170, 2171,
 /*   820 */   697, 1314,  692,  682, 1939,  564,  563, 2346, 1914, 2255,
 /*   830 */  1618, 1619,  167,  395, 2251, 2185,  580,  579,   70, 1702,
 /*   840 */  1942,   69,  572,  475, 1991, 2166, 2135, 2135, 2202,  698,
 /*   850 */  1781,  110, 2168,  702, 2170, 2171,  697, 2270,  692, 1990,
 /*   860 */  1591, 1601, 1690, 2346, 1298, 2255, 1617, 1620, 1560,  395,
 /*   870 */  2251,   14,   13,  732,  157,  156,  729,  728,  727,  154,
 /*   880 */  1536, 2166, 1534, 2266, 2202, 1780,  500,  110, 2168,  702,
 /*   890 */  2170, 2171,  697,  202,  692,  657,  142,   36, 1779, 2230,
 /*   900 */  2135, 2255, 1778,   41,   40,  395, 2251,   47,   45,   44,
 /*   910 */    43,   42, 1539, 1540, 1924, 1590, 1593, 1594, 1595, 1596,
 /*   920 */  1597, 1598, 1599, 1600,  694,  690, 1609, 1610, 1612, 1613,
 /*   930 */  1614, 1615,    2,   48,   46, 2135, 1223,  155, 1222, 2167,
 /*   940 */  1535,  399, 2036, 1535, 1777, 2128,  657,  142, 2135,  699,
 /*   950 */  2330, 2302, 2135, 1533, 1616, 1776, 1533, 1773,  682, 1939,
 /*   960 */   732,  157,  156,  729,  728,  727,  154,  294,  295, 1224,
 /*   970 */   682, 1939,  293,  730, 1659, 2167, 1982, 2185,  542,  205,
 /*   980 */  1683,  682, 1939, 1611,  101,  699, 2270,  627,  201, 2135,
 /*   990 */  1936,  698,  620, 1541, 2135, 2326, 1541,   56,  187, 2263,
 /*  1000 */  2264,  252,  140, 2268, 1926, 2135, 1772, 2135, 1771, 1932,
 /*  1010 */  2332,  188, 2265, 2185, 1206, 2327,  646, 1592,  785,   84,
 /*  1020 */  1559,  785,   83, 2166,   49, 2135, 2202,  698, 2129,  110,
 /*  1030 */  2168,  702, 2170, 2171,  697, 2167,  692,  682, 1939,  756,
 /*  1040 */   754, 2346, 1770, 2255,   54,  699,    3,  395, 2251,  189,
 /*  1050 */  2263, 2264, 1563,  140, 2268, 1769, 2135,  616, 2135, 2166,
 /*  1060 */  1618, 1619, 2202, 1203, 1204,  110, 2168,  702, 2170, 2171,
 /*  1070 */   697,  731,  692, 2185, 1982,  620, 1626, 2346, 2326, 2255,
 /*  1080 */   682, 1939, 1560,  395, 2251, 2135, 1768,  698,  682, 1939,
 /*  1090 */  1591, 1601, 2135, 2332,  188, 2121, 1617, 1620, 2327,  646,
 /*  1100 */   661,  682, 1939,  682, 1939, 2135, 1560, 1536,  665, 1534,
 /*  1110 */  1536,  652, 1534,  682, 1939, 1767, 1766, 2145,  259, 2166,
 /*  1120 */  1765,  406, 2202,  298, 1922,  172, 2168,  702, 2170, 2171,
 /*  1130 */   697, 1930,  692,  679, 2036,  605, 2135, 2036, 1943, 1539,
 /*  1140 */  1540, 2149, 1539, 1540,  421, 1590, 1593, 1594, 1595, 1596,
 /*  1150 */  1597, 1598, 1599, 1600,  694,  690, 1609, 1610, 1612, 1613,
 /*  1160 */  1614, 1615,    2,   48,   46, 2135, 2135,  682, 1939, 2167,
 /*  1170 */  2135,  399,  148, 1535,  135, 2145,  647, 2347, 2151,  699,
 /*  1180 */   203, 2320,  620,  207, 1616, 2326, 1533,  680,  692, 2154,
 /*  1190 */    41,   40, 2167, 1917,   47,   45,   44,   43,   42, 2149,
 /*  1200 */  2332,  188,  699,  261, 2274, 2327,  646, 2185,  317,  682,
 /*  1210 */  1939, 1968,  570, 1611,  745,  155,  569, 1901,   74, 2135,
 /*  1220 */   155,  698, 2275, 1679,  239,  648, 1541,  237,  573,  304,
 /*  1230 */  2185, 1592,  602,   50,  601, 1682, 2151,  150,  241,   50,
 /*  1240 */   243,  240, 2135,  242,  698,  245,  692, 1825,  244,  689,
 /*  1250 */  1296,  785, 1816, 2166,   15, 1592, 2202,  266,  155,  110,
 /*  1260 */  2168,  702, 2170, 2171,  697,  260,  692,   82,  256,  585,
 /*  1270 */  1814, 2346, 1544, 2255,  587, 1501, 2166,  395, 2251, 2202,
 /*  1280 */  1504,  619,  110, 2168,  702, 2170, 2171,  697,   50,  692,
 /*  1290 */  1618, 1619,  590, 1711, 2346, 1881, 2255, 1757, 1758, 1710,
 /*  1300 */   395, 2251,  291,   71,  153,  155,   14,   13,   91,  168,
 /*  1310 */    64,   50,  106, 1543,  323,  693,  633,  268,  664, 1257,
 /*  1320 */  1591, 1601,  103,  738, 1808,  739, 1617, 1620,  321,   73,
 /*  1330 */  1775, 2295,   72,   50,  279,  137,  273,  706,  153,  155,
 /*  1340 */  1536,  136, 1534,  346, 1879, 1276,  153, 1274, 1459,  653,
 /*  1350 */  1878, 2186, 2045,  412,  216,  508,  506,  503, 1799, 1258,
 /*  1360 */  1979, 1804,  296,  674,  300, 1341, 2285,  658,  278,  281,
 /*  1370 */  1653, 1602, 1539, 1540,  780, 1590, 1593, 1594, 1595, 1596,
 /*  1380 */  1597, 1598, 1599, 1600,  694,  690, 1609, 1610, 1612, 1613,
 /*  1390 */  1614, 1615,    2,  316,   62,  408,  407, 1368, 1372, 1379,
 /*  1400 */     1, 1377, 1637,    5,   55, 1549,  158,  415,  420, 1566,
 /*  1410 */   362,  437,  436,  195,  196,  439, 1616,  234, 1542, 1482,
 /*  1420 */   198,  206,  454,  311, 1563,  458, 1558, 2046, 1547,  463,
 /*  1430 */  2167,  491,  109,  174,  483,  476, 2038,  490,  492,  501,
 /*  1440 */   699,  560,  556,  552,  548, 1611,  233,  499,  211,  504,
 /*  1450 */   502,  213,  210,  505,  507,  509, 1564,  524, 1541,    4,
 /*  1460 */   525,  532,  535,  533, 1561,  221,  536,  223, 2185, 1546,
 /*  1470 */  1565,  537,   81,   80,  448, 1567,  226,  200,  538,  540,
 /*  1480 */  2135,  228,  698,  688,   85,   86,   88,  544,  565,  231,
 /*  1490 */   440,  438, 2167,  232,  112,  604,  352,  606, 2109,  567,
 /*  1500 */  1929,  347,  699,  236,  429,   89,  610,  427,  423,  419,
 /*  1510 */   416,  441, 1925,  611, 2166,  151,  312, 2202,  238,  160,
 /*  1520 */   110, 2168,  702, 2170, 2171,  697,  161,  692,  253, 1927,
 /*  1530 */  2185, 1923, 2228,  162, 2255,  609,  163, 2106,  395, 2251,
 /*  1540 */   255,  614, 2135,  257,  698, 1489, 2105,  617,  615,  191,
 /*  1550 */   634,  624,  672,  630, 2301,    8,  230,  224,  384, 2167,
 /*  1560 */  2286,  229, 2296,  539,  264, 2300,  637,  643,  272,  699,
 /*  1570 */   267,  654, 1550,  625, 1545,  274, 2166,  175, 2277, 2202,
 /*  1580 */   623,  222,  110, 2168,  702, 2170, 2171,  697,  622,  692,
 /*  1590 */   277,  385,  651,  276,  685,  141, 2255, 2185, 1562,  275,
 /*  1600 */   395, 2251, 1679, 2271, 1553, 1555,  388, 1568,  286, 2135,
 /*  1610 */   662,  698,   96, 2051,  313,  670,  280,  690, 1609, 1610,
 /*  1620 */  1612, 1613, 1614, 1615, 2167,  671,  314, 2349, 2065, 2064,
 /*  1630 */  2063,  391,  675,   61,  699,  676,   98,  315, 2236,  102,
 /*  1640 */  1983,  781, 1902, 2166, 2325,  342, 2202,  100, 1940,  111,
 /*  1650 */  2168,  702, 2170, 2171,  697,  704,  692,  318,  307,  782,
 /*  1660 */  2167,  784, 2185, 2255,  320,   53,  322, 2254, 2251,  327,
 /*  1670 */   699,  341,  331,  354, 2135, 2127,  698,  355, 2126, 2125,
 /*  1680 */    78, 2122,  417,  418, 1526, 1527,  194,  422, 2120,  424,
 /*  1690 */   425,  426, 2119,  363, 2117,  430, 2167,  434, 2185, 2116,
 /*  1700 */  2115, 1517,  432, 2096,  197, 2095,  699,  199, 2166,   79,
 /*  1710 */  2135, 2202,  698, 1485,  111, 2168,  702, 2170, 2171,  697,
 /*  1720 */  2167,  692, 1484, 2077, 2076, 2075,  446,  447, 2255, 2074,
 /*  1730 */   699, 2073,  687, 2251, 2185, 2029, 1436, 2028, 2026, 2025,
 /*  1740 */   147, 2024, 2027, 2023,  700, 2022, 2135, 2202,  698, 2020,
 /*  1750 */   111, 2168,  702, 2170, 2171,  697, 2019,  692, 2185, 2018,
 /*  1760 */   204,  464, 2017, 2031, 2255,  466, 2016, 2015,  357, 2251,
 /*  1770 */  2135, 2014,  698, 2013, 2012, 2011, 2010, 2009, 2008, 2007,
 /*  1780 */  2166, 2006, 2005, 2202, 2004, 2167,  111, 2168,  702, 2170,
 /*  1790 */  2171,  697, 2003,  692, 2002,  699,  149, 2001, 2000, 1999,
 /*  1800 */  2255, 2030, 1998, 1997, 2166, 2252, 1996, 2202, 1995, 1438,
 /*  1810 */   171, 2168,  702, 2170, 2171,  697, 1994,  692,  494, 1993,
 /*  1820 */  1992, 1844, 1312, 2185, 1308, 1843, 1316,  212,  382, 1842,
 /*  1830 */   214,  350,  215,  351, 1840, 2135, 1837,  698, 1836,  511,
 /*  1840 */   515, 1829,  510, 1818,  519,  514, 1794, 2167,  512,  518,
 /*  1850 */   516, 2293,  520,  522,  217, 1793,   76,  699, 1205,  182,
 /*  1860 */  2094, 2084,  219, 2167, 2072,   77,  227,  225, 2071, 2166,
 /*  1870 */  2155,  183, 2202,  699,  530,  340, 2168,  702, 2170, 2171,
 /*  1880 */   697, 2049,  692, 1918, 1839, 2185, 1835,  545,  546,  547,
 /*  1890 */   383,  549,  551, 1831,  550, 1828,  554, 2135, 1833,  698,
 /*  1900 */  1250, 2185,  553,  558,  555,  557, 1813, 1811,  559, 1812,
 /*  1910 */  1810, 1790, 1920, 2135, 2167,  698, 1383, 1384, 1919,  753,
 /*  1920 */  1299,  755, 1297, 1295,  699, 1294, 1286, 1293, 1826,  588,
 /*  1930 */  1815, 2166, 1292, 1817, 2202, 1291, 2167,  340, 2168,  702,
 /*  1940 */  2170, 2171,  697, 1288,  692,   63,  699, 2166, 1287, 1285,
 /*  1950 */  2202,  375, 2185,  333, 2168,  702, 2170, 2171,  697,  235,
 /*  1960 */   692,  591,  376,  377, 2135, 1789,  698,  593, 1788,  595,
 /*  1970 */  1787,  597,  113, 1511, 2185, 1515,   29, 1513, 1510,  390,
 /*  1980 */  2093, 1491,   67, 1493, 1495, 2083, 2135, 2331,  698,  612,
 /*  1990 */  2070, 2068,   20, 1727,   17,    6,  642,   21, 2166,   31,
 /*  2000 */  2167, 2202,  263,  608,  172, 2168,  702, 2170, 2171,  697,
 /*  2010 */   696,  692,    7,   58,   23,  618,  626,   22,  628,  613,
 /*  2020 */  2166,  788,  165, 2202,  258,  265,  340, 2168,  702, 2170,
 /*  2030 */  2171,  697,  270,  692,  381,  310, 2167,   33, 2185, 1709,
 /*  2040 */   173,  271, 2156,   65,   24, 1742,  699,  269,   32, 1741,
 /*  2050 */  2135,  180,  698,  386, 1701, 1747, 2348,   92, 2167,  778,
 /*  2060 */   774,  770,  766, 1748,  308, 1746, 1745,  387,  699,  283,
 /*  2070 */  1676,   60,  178, 1675, 2185,   94,   95,   25,  292,  398,
 /*  2080 */  2069, 2067, 2066, 2048, 2166,  289, 2135, 2202,  698,  297,
 /*  2090 */   339, 2168,  702, 2170, 2171,  697, 2185,  692,  673, 2221,
 /*  2100 */   290,  400,   18, 1707,  108, 2047,   68,  301, 2135,   97,
 /*  2110 */   698,   99,  302,   59,  103,   26, 1628, 1627,   13,   11,
 /*  2120 */  2166, 1551, 1638, 2202, 2205, 2167,  340, 2168,  702, 2170,
 /*  2130 */  2171,  697,  299,  692,  179,  699,  192, 1606,  691,  678,
 /*  2140 */  1604, 1583, 2166, 1603, 2167, 2202,   39,   16,  340, 2168,
 /*  2150 */   702, 2170, 2171,  697,  699,  692,   27,  705, 1575,  701,
 /*  2160 */    28,  703, 1369, 2185,  401,  707,  709, 1366, 1363,  710,
 /*  2170 */   712,  713,  715, 1357,  288, 2135,  716,  698, 1355,  287,
 /*  2180 */   718,  719, 2185,  305, 1361, 1360, 1359,  104,  105, 1378,
 /*  2190 */  1374,   75, 1358, 1248, 2135,  733,  698, 1280, 1279,  254,
 /*  2200 */  1278, 1277, 1275, 1306, 1273, 1272, 1271,  743,  306,  603,
 /*  2210 */  1266, 1269, 2202, 2167, 1268,  335, 2168,  702, 2170, 2171,
 /*  2220 */   697, 1267,  692,  699, 1265, 1264, 1263, 1303, 2166, 1301,
 /*  2230 */  2167, 2202, 1260, 1259,  324, 2168,  702, 2170, 2171,  697,
 /*  2240 */   699,  692, 1256, 1255, 1254, 1253, 1834,  763,  764, 1832,
 /*  2250 */   765, 2185,  767,  768,  769, 1830,  771,  773,  772, 1827,
 /*  2260 */   775, 1809,  776, 2135,  779,  698,  777, 1195, 2185, 1786,
 /*  2270 */   309,  783, 1761, 1537,  319,  786,  787, 1761, 2167, 1761,
 /*  2280 */  2135, 1761,  698, 1761, 1761, 1761, 1761, 1761,  699, 1761,
 /*  2290 */  1761, 1761, 1761, 1761, 1761, 1761, 1761, 2166, 1761, 1761,
 /*  2300 */  2202, 1761, 1761,  325, 2168,  702, 2170, 2171,  697, 1761,
 /*  2310 */   692, 1761, 1761, 1761, 2166, 1761, 2185, 2202, 1761, 1761,
 /*  2320 */   326, 2168,  702, 2170, 2171,  697, 2167,  692, 2135, 1761,
 /*  2330 */   698, 1761, 1761, 1761, 1761, 1761,  699, 1761, 1761, 1761,
 /*  2340 */  1761, 1761, 1761, 2167, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2350 */  1761, 1761, 1761,  699, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2360 */  1761, 1761, 2166, 1761, 2185, 2202, 1761, 1761,  332, 2168,
 /*  2370 */   702, 2170, 2171,  697, 1761,  692, 2135, 1761,  698, 1761,
 /*  2380 */  1761, 2185, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2390 */  1761, 2167, 1761, 2135, 1761,  698, 1761, 1761, 1761, 1761,
 /*  2400 */  1761,  699, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2410 */  2166, 1761, 1761, 2202, 2167, 1761,  336, 2168,  702, 2170,
 /*  2420 */  2171,  697, 1761,  692,  699, 1761, 1761, 2166, 1761, 2185,
 /*  2430 */  2202, 1761, 1761,  328, 2168,  702, 2170, 2171,  697, 2167,
 /*  2440 */   692, 2135, 1761,  698, 1761, 1761, 1761, 1761, 1761,  699,
 /*  2450 */  1761, 1761, 2185, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2460 */  1761, 1761, 1761, 1761, 2135, 1761,  698, 1761, 1761, 1761,
 /*  2470 */  1761, 1761, 1761, 1761, 1761, 2166, 1761, 2185, 2202, 1761,
 /*  2480 */  1761,  337, 2168,  702, 2170, 2171,  697, 1761,  692, 2135,
 /*  2490 */  2167,  698, 1761, 1761, 1761, 1761, 1761, 1761, 2166, 1761,
 /*  2500 */   699, 2202, 1761, 1761,  329, 2168,  702, 2170, 2171,  697,
 /*  2510 */  1761,  692, 1761, 1761, 2167, 1761, 1761, 1761, 1761, 1761,
 /*  2520 */  1761, 1761, 1761, 2166,  699, 1761, 2202, 1761, 2185,  338,
 /*  2530 */  2168,  702, 2170, 2171,  697, 1761,  692, 1761, 1761, 1761,
 /*  2540 */  2135, 1761,  698, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2550 */  1761, 1761, 2185, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2560 */  1761, 1761, 2167, 1761, 2135, 1761,  698, 1761, 1761, 1761,
 /*  2570 */  1761, 1761,  699, 1761, 2166, 1761, 1761, 2202, 2167, 1761,
 /*  2580 */   330, 2168,  702, 2170, 2171,  697, 1761,  692,  699, 1761,
 /*  2590 */  1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 2166, 1761,
 /*  2600 */  2185, 2202, 1761, 1761,  343, 2168,  702, 2170, 2171,  697,
 /*  2610 */  1761,  692, 2135, 1761,  698, 1761, 2185, 1761, 1761, 1761,
 /*  2620 */  1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 2135, 1761,
 /*  2630 */   698, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2640 */  2167, 1761, 1761, 1761, 1761, 1761, 2166, 1761, 1761, 2202,
 /*  2650 */   699, 1761,  344, 2168,  702, 2170, 2171,  697, 1761,  692,
 /*  2660 */  1761, 1761, 2166, 1761, 2167, 2202, 1761, 1761, 2179, 2168,
 /*  2670 */   702, 2170, 2171,  697,  699,  692, 1761, 1761, 2185, 1761,
 /*  2680 */  1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2690 */  2135, 1761,  698, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2700 */  1761, 1761, 2185, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2710 */  1761, 1761, 2167, 1761, 2135, 1761,  698, 1761, 1761, 1761,
 /*  2720 */  1761, 1761,  699, 1761, 2166, 1761, 1761, 2202, 1761, 1761,
 /*  2730 */  2178, 2168,  702, 2170, 2171,  697, 1761,  692, 1761, 1761,
 /*  2740 */  1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 2166, 1761,
 /*  2750 */  2185, 2202, 1761, 1761, 2177, 2168,  702, 2170, 2171,  697,
 /*  2760 */  2167,  692, 2135, 1761,  698, 1761, 1761, 1761, 1761, 1761,
 /*  2770 */   699, 1761, 1761, 1761, 1761, 2167, 1761, 1761, 1761, 1761,
 /*  2780 */  1761, 1761, 1761, 1761, 1761,  699, 1761, 1761, 1761, 1761,
 /*  2790 */  1761, 1761, 1761, 1761, 1761, 1761, 2166, 1761, 2185, 2202,
 /*  2800 */  1761, 1761,  359, 2168,  702, 2170, 2171,  697, 1761,  692,
 /*  2810 */  2135, 1761,  698, 2185, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2820 */  1761, 1761, 1761, 2167, 1761, 2135, 1761,  698, 1761, 1761,
 /*  2830 */  1761, 1761, 1761,  699, 1761, 1761, 1761, 1761, 2167, 1761,
 /*  2840 */  1761, 1761, 1761, 1761, 2166, 1761, 1761, 2202,  699, 1761,
 /*  2850 */   360, 2168,  702, 2170, 2171,  697, 1761,  692, 1761, 2166,
 /*  2860 */  1761, 2185, 2202, 1761, 1761,  356, 2168,  702, 2170, 2171,
 /*  2870 */   697, 2167,  692, 2135, 1761,  698, 2185, 1761, 1761, 1761,
 /*  2880 */  1761,  699, 1761, 1761, 1761, 1761, 1761, 1761, 2135, 1761,
 /*  2890 */   698, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2900 */  1761, 1761, 1761, 1761, 1761, 1761, 1761, 2166, 1761, 2185,
 /*  2910 */  2202, 1761, 1761,  361, 2168,  702, 2170, 2171,  697, 1761,
 /*  2920 */   692, 2135,  700,  698, 1761, 2202, 1761, 1761,  335, 2168,
 /*  2930 */   702, 2170, 2171,  697, 1761,  692, 1761, 1761, 1761, 1761,
 /*  2940 */  1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761, 1761,
 /*  2950 */  1761, 1761, 1761, 1761, 1761, 2166, 1761, 1761, 2202, 1761,
 /*  2960 */  1761,  334, 2168,  702, 2170, 2171,  697, 1761,  692,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   339,  408,  365,  391,  387,  412,  439,  390,  391,  442,
 /*    10 */   349,  348,   12,   13,   14,    0,  379,  344,  406,  407,
 /*    20 */    20,  348,   22,  350,    8,    9,  389,  349,   12,   13,
 /*    30 */    14,   15,   16,   33,    0,   35,   21,   20,  377,   24,
 /*    40 */    25,   26,   27,   28,   29,   30,   31,   32,  455,   20,
 /*    50 */   389,  458,  391,    8,    9,  377,  393,   12,   13,   14,
 /*    60 */    15,   16,   62,  426,  427,   44,  473,  474,   68,   20,
 /*    70 */   391,  478,  479,  436,   20,   75,   12,   13,   14,   15,
 /*    80 */    16,  338,  403,  340,  423,  406,  407,  426,   20,   44,
 /*    90 */   429,  430,  431,  432,  433,  434,  435,  436,  437,  438,
 /*   100 */   100,    4,    0,  103,   70,   71,   72,   73,   74,  431,
 /*   110 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   130 */    96,  373,  103,  343,  428,  100,  346,  347,   21,  139,
 /*   140 */   140,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   150 */   115,  116,  117,  118,  119,  120,  121,  122,  123,  124,
 /*   160 */   454,  126,  127,  128,  129,  130,  131,  444,  445,  169,
 /*   170 */   170,  455,  377,  377,  458,  175,  176,   62,  420,  103,
 /*   180 */   384,  336,   20,  348,  349,    0,  169,  170,  392,  189,
 /*   190 */   474,  191,  397,  398,  478,  479,   67,  181,    8,    9,
 /*   200 */   103,   20,   12,   13,   14,   15,   16,  139,  140,   24,
 /*   210 */    25,   26,   27,   28,   29,   30,   31,   32,  103,   20,
 /*   220 */   105,  221,  222,  377,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   240 */   240,  241,   12,   13,  398,  339,   20,   18,   22,   20,
 /*   250 */    20,  455,   22,  408,  458,  349,   27,  412,   68,   30,
 /*   260 */   369,   35,   33,   33,  188,   35,  190,  103,  377,  473,
 /*   270 */   474,   12,   13,  369,  478,  479,  385,   20,   49,   53,
 /*   280 */    51,  377,   20,  377,   20,   56,  451,  452,  453,  385,
 /*   290 */   455,  456,   62,  458,   35,  389,  220,  391,   68,  283,
 /*   300 */   455,  280,  112,  458,   49,   75,   39,  343,  473,  474,
 /*   310 */   346,  347,   57,  478,  479,   60,   61,  215,  473,  474,
 /*   320 */   390,  391,  455,  478,  479,  458,   14,   15,   16,  423,
 /*   330 */   100,  102,  426,  103,  258,  429,  430,  431,  432,  433,
 /*   340 */   434,  474,  436,  114,  377,  478,  479,  441,  242,  443,
 /*   350 */   244,  384,  171,  447,  448,  258,    8,    9,  168,  392,
 /*   360 */    12,   13,   14,   15,   16,  103,  460,  103,   20,  139,
 /*   370 */   140,    4,  143,  258,  468,  146,  147,  148,  149,  150,
 /*   380 */   151,  152,  153,  154,  155,  156,  157,  158,  159,  160,
 /*   390 */   161,  162,   14,  164,  165,  166,  139,  140,   20,  169,
 /*   400 */   170,  348,  349,  348,  349,  175,  176,   70,   71,   72,
 /*   410 */    43,   22,   45,   46,   77,   78,   79,   37,   84,  189,
 /*   420 */    83,  191,  258,  368,   35,   88,   89,   90,   91,   67,
 /*   430 */   375,   94,  175,  176,   21,  245,  246,  247,  248,  249,
 /*   440 */   250,  251,  252,  253,  254,  255,    0,   34,  103,   36,
 /*   450 */   191,  221,  222,   20,  224,  225,  226,  227,  228,  229,
 /*   460 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   470 */   240,  241,  242,   12,   13,  348,  349,  377,  144,  145,
 /*   480 */   174,   20,  386,   22,  384,  389,  106,  348,  108,  109,
 /*   490 */   339,  111,  392,  339,   33,  368,   35,  221,  348,  349,
 /*   500 */   349,  167,  375,  450,  451,  452,  453,  344,  455,  456,
 /*   510 */     3,  348,  132,  350,  455,  339,  136,  458,  368,  171,
 /*   520 */   258,    0,  258,   62,  257,  349,  408,   20,  377,   68,
 /*   530 */    54,   55,  473,  474,  348,  349,   75,  478,  479,  400,
 /*   540 */   389,  402,  391,  389,  268,  269,  270,  271,  272,  273,
 /*   550 */   274,    8,    9,  377,  368,   12,   13,   14,   15,   16,
 /*   560 */   357,  100,  134,  376,  103,  389,  138,  391,    0,  263,
 /*   570 */   264,  265,  357,  455,  423,  388,  458,  426,  339,  114,
 /*   580 */   429,  430,  431,  432,  433,  434,  383,  436,   67,  374,
 /*   590 */   348,  473,  474,  242,  348,  349,  478,  479,  383,  423,
 /*   600 */   139,  140,  426,  258,  158,  429,  430,  431,  432,  433,
 /*   610 */   434,  104,  436,  167,  368,  439,  355,  441,  442,  443,
 /*   620 */   469,  470,  339,  447,  448,  339,  198,  348,  389,  201,
 /*   630 */   169,  170,  204,  372,  206,  349,  175,  176,   70,   71,
 /*   640 */    72,  380,  400,  184,  402,   77,   78,   79,  353,  354,
 /*   650 */   189,   83,  191,  348,  349,   75,   88,   89,   90,   91,
 /*   660 */     8,    9,   94,  377,   12,   13,   14,   15,   16,  377,
 /*   670 */   211,  212,  389,  368,   47,  389,  384,  391,  171,  400,
 /*   680 */   168,  402,  221,  222,  392,  224,  225,  226,  227,  228,
 /*   690 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*   700 */   239,  240,  241,   12,   13,   14,  440,   75,  442,  423,
 /*   710 */   133,   20,  426,   22,  171,  429,  430,  431,  432,  433,
 /*   720 */   434,  377,  436,  369,   33,  339,   35,  441,  384,  443,
 /*   730 */   103,  377,   22,  447,  448,  349,  392,  351,  384,  385,
 /*   740 */     4,    0,   20,    8,    9,   35,  392,   12,   13,   14,
 /*   750 */    15,   16,  369,   62,  468,   19,  104,  245,  348,  349,
 /*   760 */   377,  339,  358,  377,  348,  349,   75,  255,  385,   33,
 /*   770 */   366,  349,  114,  351,   35,  389,    2,  391,  368,  202,
 /*   780 */   203,  378,    8,    9,  368,   49,   12,   13,   14,   15,
 /*   790 */    16,  100,   56,  440,  103,  442,  339,  339,   62,  377,
 /*   800 */   132,  133,  134,  135,  136,  137,  138,  349,   22,  423,
 /*   810 */   100,  389,  426,  391,   75,  429,  430,  431,  432,  433,
 /*   820 */   434,   35,  436,  348,  349,  353,  354,  441,    0,  443,
 /*   830 */   139,  140,  377,  447,  448,  377,  362,  363,  102,  104,
 /*   840 */   385,  105,   13,  368,  377,  423,  389,  389,  426,  391,
 /*   850 */   339,  429,  430,  431,  432,  433,  434,  428,  436,  392,
 /*   860 */   169,  170,   14,  441,   35,  443,  175,  176,   20,  447,
 /*   870 */   448,    1,    2,  132,  133,  134,  135,  136,  137,  138,
 /*   880 */   189,  423,  191,  454,  426,  339,  100,  429,  430,  431,
 /*   890 */   432,  433,  434,  171,  436,  348,  349,    2,  339,  441,
 /*   900 */   389,  443,  339,    8,    9,  447,  448,   12,   13,   14,
 /*   910 */    15,   16,  221,  222,  378,  224,  225,  226,  227,  228,
 /*   920 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*   930 */   239,  240,  241,   12,   13,  389,   20,   44,   22,  339,
 /*   940 */    22,   20,  349,   22,  339,  408,  348,  349,  389,  349,
 /*   950 */     3,  351,  389,   35,   33,  339,   35,  339,  348,  349,
 /*   960 */   132,  133,  134,  135,  136,  137,  138,  133,  134,   53,
 /*   970 */   348,  349,  138,  386,  104,  339,  389,  377,  368,   62,
 /*   980 */     4,  348,  349,   62,  355,  349,  428,  351,  395,  389,
 /*   990 */   368,  391,  455,   75,  389,  458,   75,  104,  451,  452,
 /*  1000 */   453,  368,  455,  456,  378,  389,  339,  389,  339,  380,
 /*  1010 */   473,  474,  454,  377,   14,  478,  479,  169,  100,  102,
 /*  1020 */    20,  100,  105,  423,  103,  389,  426,  391,  408,  429,
 /*  1030 */   430,  431,  432,  433,  434,  339,  436,  348,  349,  362,
 /*  1040 */   363,  441,  339,  443,   42,  349,   44,  447,  448,  451,
 /*  1050 */   452,  453,   20,  455,  456,  339,  389,  368,  389,  423,
 /*  1060 */   139,  140,  426,   45,   46,  429,  430,  431,  432,  433,
 /*  1070 */   434,  386,  436,  377,  389,  455,   14,  441,  458,  443,
 /*  1080 */   348,  349,   20,  447,  448,  389,  339,  391,  348,  349,
 /*  1090 */   169,  170,  389,  473,  474,    0,  175,  176,  478,  479,
 /*  1100 */   368,  348,  349,  348,  349,  389,   20,  189,  368,  191,
 /*  1110 */   189,   44,  191,  348,  349,  339,  339,  365,  413,  423,
 /*  1120 */   339,  368,  426,  368,  378,  429,  430,  431,  432,  433,
 /*  1130 */   434,  379,  436,  368,  349,  408,  389,  349,  378,  221,
 /*  1140 */   222,  389,  221,  222,   49,  224,  225,  226,  227,  228,
 /*  1150 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*  1160 */   239,  240,  241,   12,   13,  389,  389,  348,  349,  339,
 /*  1170 */   389,   20,   42,   22,   44,  365,  480,  481,  426,  349,
 /*  1180 */   395,  351,  455,  395,   33,  458,   35,  368,  436,  379,
 /*  1190 */     8,    9,  339,    0,   12,   13,   14,   15,   16,  389,
 /*  1200 */   473,  474,  349,  171,  351,  478,  479,  377,  370,  348,
 /*  1210 */   349,  373,  132,   62,  364,   44,  136,  367,  114,  389,
 /*  1220 */    44,  391,  256,  257,  107,  278,   75,  110,   13,  368,
 /*  1230 */   377,  169,  205,   44,  207,  259,  426,   44,  107,   44,
 /*  1240 */   107,  110,  389,  110,  391,  107,  436,    0,  110,   68,
 /*  1250 */    35,  100,    0,  423,  103,  169,  426,   44,   44,  429,
 /*  1260 */   430,  431,  432,  433,  434,   62,  436,  163,  378,   22,
 /*  1270 */     0,  441,   35,  443,   22,  104,  423,  447,  448,  426,
 /*  1280 */   104,   48,  429,  430,  431,  432,  433,  434,   44,  436,
 /*  1290 */   139,  140,   22,  104,  441,  366,  443,  139,  140,  104,
 /*  1300 */   447,  448,   44,   44,   44,   44,    1,    2,  105,   18,
 /*  1310 */    44,   44,  103,   35,   23,  378,  471,  104,  104,   35,
 /*  1320 */   169,  170,  113,   13,    0,   13,  175,  176,   37,   38,
 /*  1330 */   340,  399,   41,   44,  482,  352,  465,   44,   44,   44,
 /*  1340 */   189,   44,  191,   52,  365,   35,   44,   35,  104,  282,
 /*  1350 */   365,  377,  399,  352,   63,   64,   65,   66,  347,   75,
 /*  1360 */   388,  349,  104,  104,  104,  104,  399,  457,  449,  475,
 /*  1370 */   104,  104,  221,  222,   50,  224,  225,  226,  227,  228,
 /*  1380 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*  1390 */   239,  240,  241,  104,  103,   12,   13,  104,  104,  104,
 /*  1400 */   459,  104,  221,  260,  171,   22,  104,  425,   49,   20,
 /*  1410 */   424,  417,  204,  422,  357,  417,   33,   33,   35,  187,
 /*  1420 */   357,   42,  396,  410,   20,  396,   20,  399,  191,  394,
 /*  1430 */   339,  168,  141,   49,  396,  348,  348,  394,  394,  101,
 /*  1440 */   349,   57,   58,   59,   60,   62,   62,   99,  348,   98,
 /*  1450 */   361,  348,  360,  359,  348,  348,   20,  341,   75,   48,
 /*  1460 */   345,  341,  417,  345,   20,  357,  391,  357,  377,  191,
 /*  1470 */    20,  350,  181,  182,  183,   20,  357,  186,  409,  350,
 /*  1480 */   389,  357,  391,  100,  357,  357,  102,  348,  341,  105,
 /*  1490 */   199,  200,  339,  357,  348,  208,  341,  421,  389,  377,
 /*  1500 */   377,  210,  349,  377,  213,  103,  195,  216,  217,  218,
 /*  1510 */   219,  220,  377,  416,  423,  419,  417,  426,  377,  377,
 /*  1520 */   429,  430,  431,  432,  433,  434,  377,  436,  355,  377,
 /*  1530 */   377,  377,  441,  377,  443,  194,  377,  389,  447,  448,
 /*  1540 */   415,  391,  389,  355,  391,  193,  389,  348,  414,  258,
 /*  1550 */   267,  389,  266,  389,  464,  275,  172,  173,  389,  339,
 /*  1560 */   399,  177,  399,  179,  404,  464,  389,  180,  466,  349,
 /*  1570 */   404,  281,  189,  277,  191,  463,  423,  464,  467,  426,
 /*  1580 */   276,  197,  429,  430,  431,  432,  433,  434,  261,  436,
 /*  1590 */   425,  284,  279,  461,  441,  349,  443,  377,   20,  462,
 /*  1600 */   447,  448,  257,  428,  221,  222,  350,   20,  355,  389,
 /*  1610 */   348,  391,  355,  402,  404,  389,  476,  234,  235,  236,
 /*  1620 */   237,  238,  239,  240,  339,  389,  404,  483,  389,  389,
 /*  1630 */   389,  389,  173,  103,  349,  401,  355,  373,  446,  103,
 /*  1640 */   389,   36,  367,  423,  477,  418,  426,  355,  349,  429,
 /*  1650 */   430,  431,  432,  433,  434,  381,  436,  348,  355,  342,
 /*  1660 */   339,  341,  377,  443,  356,  411,  337,  447,  448,  371,
 /*  1670 */   349,  371,  371,  405,  389,    0,  391,  405,    0,    0,
 /*  1680 */    42,    0,   35,  214,   35,   35,   35,  214,    0,   35,
 /*  1690 */    35,  214,    0,  214,    0,   35,  339,   35,  377,    0,
 /*  1700 */     0,  209,   22,    0,  197,    0,  349,  197,  423,  198,
 /*  1710 */   389,  426,  391,  191,  429,  430,  431,  432,  433,  434,
 /*  1720 */   339,  436,  189,    0,    0,    0,  185,  184,  443,    0,
 /*  1730 */   349,    0,  447,  448,  377,    0,   47,    0,    0,    0,
 /*  1740 */    42,    0,    0,    0,  423,    0,  389,  426,  391,    0,
 /*  1750 */   429,  430,  431,  432,  433,  434,    0,  436,  377,    0,
 /*  1760 */   158,   35,    0,    0,  443,  158,    0,    0,  447,  448,
 /*  1770 */   389,    0,  391,    0,    0,    0,    0,    0,    0,    0,
 /*  1780 */   423,    0,    0,  426,    0,  339,  429,  430,  431,  432,
 /*  1790 */   433,  434,    0,  436,    0,  349,   42,    0,    0,    0,
 /*  1800 */   443,    0,    0,    0,  423,  448,    0,  426,    0,   22,
 /*  1810 */   429,  430,  431,  432,  433,  434,    0,  436,  142,    0,
 /*  1820 */     0,    0,   22,  377,   35,    0,   22,   62,  382,    0,
 /*  1830 */    62,   48,   62,   48,    0,  389,    0,  391,    0,   49,
 /*  1840 */    49,    0,   35,    0,   49,   35,    0,  339,   39,   35,
 /*  1850 */    39,  470,   39,   35,   42,    0,   39,  349,   14,   44,
 /*  1860 */     0,    0,   40,  339,    0,   39,  180,   39,    0,  423,
 /*  1870 */    47,   47,  426,  349,   47,  429,  430,  431,  432,  433,
 /*  1880 */   434,    0,  436,    0,    0,  377,    0,   35,   49,   39,
 /*  1890 */   382,   35,   39,    0,   49,    0,   49,  389,    0,  391,
 /*  1900 */    69,  377,   35,   49,   39,   35,    0,    0,   39,    0,
 /*  1910 */     0,    0,    0,  389,  339,  391,   22,   35,    0,   44,
 /*  1920 */    35,   44,   35,   35,  349,   35,   22,   35,    0,   51,
 /*  1930 */     0,  423,   35,    0,  426,   35,  339,  429,  430,  431,
 /*  1940 */   432,  433,  434,   35,  436,  112,  349,  423,   35,   35,
 /*  1950 */   426,   22,  377,  429,  430,  431,  432,  433,  434,  110,
 /*  1960 */   436,   35,   22,   22,  389,    0,  391,   35,    0,   35,
 /*  1970 */     0,   22,   20,   35,  377,  104,  103,   35,   35,  382,
 /*  1980 */     0,   35,  103,   22,  196,    0,  389,    3,  391,   22,
 /*  1990 */     0,    0,   44,  104,  262,   48,  472,   44,  423,  103,
 /*  2000 */   339,  426,  103,    1,  429,  430,  431,  432,  433,  434,
 /*  2010 */   349,  436,   48,  171,  262,  178,  101,   44,   99,  171,
 /*  2020 */   423,   19,  192,  426,  173,  104,  429,  430,  431,  432,
 /*  2030 */   433,  434,   44,  436,  171,   33,  339,   44,  377,  104,
 /*  2040 */   103,   47,   47,    3,   44,   35,  349,  103,  103,   35,
 /*  2050 */   389,   49,  391,   35,  104,  104,  481,  103,  339,   57,
 /*  2060 */    58,   59,   60,  104,   62,   35,   35,   35,  349,   47,
 /*  2070 */   104,   44,   47,  104,  377,  103,   39,  103,  103,  382,
 /*  2080 */     0,    0,    0,    0,  423,   47,  389,  426,  391,  103,
 /*  2090 */   429,  430,  431,  432,  433,  434,  377,  436,  174,  438,
 /*  2100 */   104,  382,  262,  104,  102,    0,  103,  105,  389,   39,
 /*  2110 */   391,  103,   47,  256,  113,   44,  101,  101,    2,  243,
 /*  2120 */   423,   22,  221,  426,  103,  339,  429,  430,  431,  432,
 /*  2130 */   433,  434,  172,  436,   47,  349,   47,  104,  103,  137,
 /*  2140 */   104,   22,  423,  104,  339,  426,  103,  103,  429,  430,
 /*  2150 */   431,  432,  433,  434,  349,  436,  103,   35,  104,  223,
 /*  2160 */   103,  114,  104,  377,   35,  103,   35,  104,  104,  103,
 /*  2170 */    35,  103,   35,  104,  172,  389,  103,  391,  104,  177,
 /*  2180 */    35,  103,  377,   44,  125,  125,  125,  103,  103,   35,
 /*  2190 */    22,  103,  125,   69,  389,   68,  391,   35,   35,  197,
 /*  2200 */    35,   35,   35,   75,   35,   35,   35,   97,   44,  423,
 /*  2210 */    22,   35,  426,  339,   35,  429,  430,  431,  432,  433,
 /*  2220 */   434,   35,  436,  349,   35,   35,   35,   75,  423,   35,
 /*  2230 */   339,  426,   35,   35,  429,  430,  431,  432,  433,  434,
 /*  2240 */   349,  436,   35,   35,   22,   35,    0,   35,   49,    0,
 /*  2250 */    39,  377,   35,   49,   39,    0,   35,   39,   49,    0,
 /*  2260 */    35,    0,   49,  389,   35,  391,   39,   35,  377,    0,
 /*  2270 */    22,   21,  484,   22,   22,   21,   20,  484,  339,  484,
 /*  2280 */   389,  484,  391,  484,  484,  484,  484,  484,  349,  484,
 /*  2290 */   484,  484,  484,  484,  484,  484,  484,  423,  484,  484,
 /*  2300 */   426,  484,  484,  429,  430,  431,  432,  433,  434,  484,
 /*  2310 */   436,  484,  484,  484,  423,  484,  377,  426,  484,  484,
 /*  2320 */   429,  430,  431,  432,  433,  434,  339,  436,  389,  484,
 /*  2330 */   391,  484,  484,  484,  484,  484,  349,  484,  484,  484,
 /*  2340 */   484,  484,  484,  339,  484,  484,  484,  484,  484,  484,
 /*  2350 */   484,  484,  484,  349,  484,  484,  484,  484,  484,  484,
 /*  2360 */   484,  484,  423,  484,  377,  426,  484,  484,  429,  430,
 /*  2370 */   431,  432,  433,  434,  484,  436,  389,  484,  391,  484,
 /*  2380 */   484,  377,  484,  484,  484,  484,  484,  484,  484,  484,
 /*  2390 */   484,  339,  484,  389,  484,  391,  484,  484,  484,  484,
 /*  2400 */   484,  349,  484,  484,  484,  484,  484,  484,  484,  484,
 /*  2410 */   423,  484,  484,  426,  339,  484,  429,  430,  431,  432,
 /*  2420 */   433,  434,  484,  436,  349,  484,  484,  423,  484,  377,
 /*  2430 */   426,  484,  484,  429,  430,  431,  432,  433,  434,  339,
 /*  2440 */   436,  389,  484,  391,  484,  484,  484,  484,  484,  349,
 /*  2450 */   484,  484,  377,  484,  484,  484,  484,  484,  484,  484,
 /*  2460 */   484,  484,  484,  484,  389,  484,  391,  484,  484,  484,
 /*  2470 */   484,  484,  484,  484,  484,  423,  484,  377,  426,  484,
 /*  2480 */   484,  429,  430,  431,  432,  433,  434,  484,  436,  389,
 /*  2490 */   339,  391,  484,  484,  484,  484,  484,  484,  423,  484,
 /*  2500 */   349,  426,  484,  484,  429,  430,  431,  432,  433,  434,
 /*  2510 */   484,  436,  484,  484,  339,  484,  484,  484,  484,  484,
 /*  2520 */   484,  484,  484,  423,  349,  484,  426,  484,  377,  429,
 /*  2530 */   430,  431,  432,  433,  434,  484,  436,  484,  484,  484,
 /*  2540 */   389,  484,  391,  484,  484,  484,  484,  484,  484,  484,
 /*  2550 */   484,  484,  377,  484,  484,  484,  484,  484,  484,  484,
 /*  2560 */   484,  484,  339,  484,  389,  484,  391,  484,  484,  484,
 /*  2570 */   484,  484,  349,  484,  423,  484,  484,  426,  339,  484,
 /*  2580 */   429,  430,  431,  432,  433,  434,  484,  436,  349,  484,
 /*  2590 */   484,  484,  484,  484,  484,  484,  484,  484,  423,  484,
 /*  2600 */   377,  426,  484,  484,  429,  430,  431,  432,  433,  434,
 /*  2610 */   484,  436,  389,  484,  391,  484,  377,  484,  484,  484,
 /*  2620 */   484,  484,  484,  484,  484,  484,  484,  484,  389,  484,
 /*  2630 */   391,  484,  484,  484,  484,  484,  484,  484,  484,  484,
 /*  2640 */   339,  484,  484,  484,  484,  484,  423,  484,  484,  426,
 /*  2650 */   349,  484,  429,  430,  431,  432,  433,  434,  484,  436,
 /*  2660 */   484,  484,  423,  484,  339,  426,  484,  484,  429,  430,
 /*  2670 */   431,  432,  433,  434,  349,  436,  484,  484,  377,  484,
 /*  2680 */   484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
 /*  2690 */   389,  484,  391,  484,  484,  484,  484,  484,  484,  484,
 /*  2700 */   484,  484,  377,  484,  484,  484,  484,  484,  484,  484,
 /*  2710 */   484,  484,  339,  484,  389,  484,  391,  484,  484,  484,
 /*  2720 */   484,  484,  349,  484,  423,  484,  484,  426,  484,  484,
 /*  2730 */   429,  430,  431,  432,  433,  434,  484,  436,  484,  484,
 /*  2740 */   484,  484,  484,  484,  484,  484,  484,  484,  423,  484,
 /*  2750 */   377,  426,  484,  484,  429,  430,  431,  432,  433,  434,
 /*  2760 */   339,  436,  389,  484,  391,  484,  484,  484,  484,  484,
 /*  2770 */   349,  484,  484,  484,  484,  339,  484,  484,  484,  484,
 /*  2780 */   484,  484,  484,  484,  484,  349,  484,  484,  484,  484,
 /*  2790 */   484,  484,  484,  484,  484,  484,  423,  484,  377,  426,
 /*  2800 */   484,  484,  429,  430,  431,  432,  433,  434,  484,  436,
 /*  2810 */   389,  484,  391,  377,  484,  484,  484,  484,  484,  484,
 /*  2820 */   484,  484,  484,  339,  484,  389,  484,  391,  484,  484,
 /*  2830 */   484,  484,  484,  349,  484,  484,  484,  484,  339,  484,
 /*  2840 */   484,  484,  484,  484,  423,  484,  484,  426,  349,  484,
 /*  2850 */   429,  430,  431,  432,  433,  434,  484,  436,  484,  423,
 /*  2860 */   484,  377,  426,  484,  484,  429,  430,  431,  432,  433,
 /*  2870 */   434,  339,  436,  389,  484,  391,  377,  484,  484,  484,
 /*  2880 */   484,  349,  484,  484,  484,  484,  484,  484,  389,  484,
 /*  2890 */   391,  484,  484,  484,  484,  484,  484,  484,  484,  484,
 /*  2900 */   484,  484,  484,  484,  484,  484,  484,  423,  484,  377,
 /*  2910 */   426,  484,  484,  429,  430,  431,  432,  433,  434,  484,
 /*  2920 */   436,  389,  423,  391,  484,  426,  484,  484,  429,  430,
 /*  2930 */   431,  432,  433,  434,  484,  436,  484,  484,  484,  484,
 /*  2940 */   484,  484,  484,  484,  484,  484,  484,  484,  484,  484,
 /*  2950 */   484,  484,  484,  484,  484,  423,  484,  484,  426,  484,
 /*  2960 */   484,  429,  430,  431,  432,  433,  434,  484,  436,  336,
 /*  2970 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  2980 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  2990 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3000 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3010 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3020 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3030 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3040 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3050 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3060 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3070 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3080 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3090 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3100 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3110 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3120 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3130 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3140 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3150 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3160 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3170 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3180 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3190 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3200 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3210 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3220 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3230 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3240 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3250 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3260 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3270 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3280 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3290 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*  3300 */   336,  336,  336,  336,  336,
};
#define YY_SHIFT_COUNT    (788)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2269)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1291,    0,  230,    0,  461,  461,  461,  461,  461,  461,
 /*    10 */   461,  461,  461,  461,  461,  461,  691,  921,  921, 1151,
 /*    20 */   921,  921,  921,  921,  921,  921,  921,  921,  921,  921,
 /*    30 */   921,  921,  921,  921,  921,  921,  921,  921,  921,  921,
 /*    40 */   921,  921,  921,  921,  921,  921,  921,  921,  921,  921,
 /*    50 */   921,  262,  264,   76,   29,  115,  164,  345,  164,   29,
 /*    60 */    29, 1383,  164, 1383, 1383,   97,  164,   49,  257,   54,
 /*    70 */    54,  257,  367,  367,   17,   68,  378,  378,   54,   54,
 /*    80 */    54,   54,   54,   54,   54,  162,   54,   54,  129,   49,
 /*    90 */    54,   54,  199,   54,   49,   54,  162,   54,  162,   49,
 /*   100 */    54,   54,   49,   54,   49,   49,   49,   54,  362,  229,
 /*   110 */   190,  190,  337,  117,  918,  918,  918,  918,  918,  918,
 /*   120 */   918,  918,  918,  918,  918,  918,  918,  918,  918,  918,
 /*   130 */   918,  918,  918,  380,  507,   17,   68,  476,  476,  739,
 /*   140 */   181,  181,  181,  521,  106,  106,  739,  433,  433,  433,
 /*   150 */   129,  465,  351,   49,  580,   49,  580,  580,  658,  632,
 /*   160 */    35,   35,   35,   35,   35,   35,   35,   35, 2002,  568,
 /*   170 */    15,  348,   16,  276,  226,  306,  259,  259,  848, 1062,
 /*   180 */   916,  722, 1018, 1000, 1080, 1032,  966,  267,  947,  966,
 /*   190 */  1002,  976, 1086, 1143, 1359, 1389, 1208,  129, 1389,  129,
 /*   200 */  1232, 1379, 1404, 1379, 1263, 1406, 1406, 1379, 1263, 1263,
 /*   210 */  1338, 1348, 1406, 1351, 1406, 1406, 1406, 1436, 1411, 1436,
 /*   220 */  1411, 1389,  129, 1444,  129, 1450, 1455,  129, 1450,  129,
 /*   230 */   129,  129, 1406,  129, 1436,   49,   49,   49,   49,   49,
 /*   240 */    49,   49,   49,   49,   49,   49, 1406, 1436,  580,  580,
 /*   250 */   580, 1287, 1402, 1389,  362, 1311, 1341, 1444,  362, 1352,
 /*   260 */  1406, 1404, 1404,  580, 1283, 1286,  580, 1283, 1286,  580,
 /*   270 */   580,   49, 1280, 1387, 1283, 1296, 1304, 1327, 1143, 1307,
 /*   280 */  1290, 1313, 1345,  433, 1578, 1406, 1450,  362,  362, 1587,
 /*   290 */  1286,  580,  580,  580,  580,  580, 1286,  580, 1459,  362,
 /*   300 */   658,  362,  433, 1530, 1536,  580,  632, 1406,  362, 1605,
 /*   310 */  1436, 2969, 2969, 2969, 2969, 2969, 2969, 2969, 2969, 2969,
 /*   320 */    34, 1384,  185,  736,  652,   45,  735,  741,  774,  895,
 /*   330 */   543,  828, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182,
 /*   340 */  1182,  668,  428,   64,   64,  334,  255,  459,  446,  917,
 /*   350 */   710,  786,  413,  577,  834,  834,  312,  870,  512,  312,
 /*   360 */   312,  312, 1095,  102,  893,  389, 1130, 1104, 1193, 1117,
 /*   370 */  1131, 1133, 1138,  829, 1215, 1247, 1252, 1270, 1027, 1171,
 /*   380 */  1176, 1203, 1189, 1195, 1213, 1158,   21, 1067, 1233, 1214,
 /*   390 */  1244, 1258, 1259, 1260, 1261, 1305, 1266, 1181, 1267,  627,
 /*   400 */  1289, 1293, 1294, 1295, 1297, 1302, 1209, 1237, 1278, 1310,
 /*   410 */  1312, 1284, 1324, 1675, 1678, 1679, 1638, 1681, 1647, 1469,
 /*   420 */  1649, 1650, 1651, 1473, 1688, 1654, 1655, 1477, 1692, 1479,
 /*   430 */  1694, 1660, 1699, 1680, 1700, 1662, 1492, 1703, 1507, 1705,
 /*   440 */  1510, 1511, 1522, 1533, 1723, 1724, 1725, 1541, 1543, 1729,
 /*   450 */  1731, 1689, 1735, 1737, 1738, 1698, 1739, 1741, 1742, 1743,
 /*   460 */  1745, 1749, 1756, 1759, 1602, 1726, 1762, 1607, 1763, 1766,
 /*   470 */  1767, 1771, 1773, 1774, 1775, 1776, 1777, 1778, 1779, 1781,
 /*   480 */  1782, 1784, 1792, 1794, 1754, 1797, 1798, 1799, 1801, 1802,
 /*   490 */  1803, 1787, 1806, 1808, 1816, 1676, 1819, 1820, 1800, 1783,
 /*   500 */  1804, 1785, 1821, 1765, 1789, 1825, 1768, 1829, 1770, 1834,
 /*   510 */  1836, 1807, 1790, 1809, 1838, 1810, 1791, 1811, 1841, 1814,
 /*   520 */  1795, 1813, 1843, 1818, 1846, 1812, 1817, 1815, 1823, 1824,
 /*   530 */  1844, 1827, 1855, 1822, 1826, 1860, 1861, 1864, 1828, 1686,
 /*   540 */  1868, 1881, 1883, 1831, 1884, 1886, 1852, 1839, 1850, 1898,
 /*   550 */  1856, 1845, 1853, 1893, 1867, 1847, 1865, 1895, 1870, 1854,
 /*   560 */  1869, 1906, 1907, 1909, 1910, 1911, 1912, 1833, 1849, 1882,
 /*   570 */  1894, 1918, 1885, 1887, 1888, 1890, 1892, 1897, 1900, 1875,
 /*   580 */  1877, 1908, 1913, 1904, 1914, 1928, 1929, 1933, 1940, 1878,
 /*   590 */  1930, 1941, 1926, 1965, 1932, 1968, 1934, 1970, 1949, 1952,
 /*   600 */  1938, 1942, 1943, 1871, 1873, 1980, 1842, 1879, 1788, 1946,
 /*   610 */  1961, 1985, 1830, 1967, 1848, 1851, 1990, 1991, 1863, 1837,
 /*   620 */  1984, 1948, 1732, 1896, 1889, 1899, 1947, 1915, 1964, 1919,
 /*   630 */  1921, 1953, 1973, 1935, 1937, 1944, 1945, 1950, 1988, 1994,
 /*   640 */  1995, 1954, 1993, 1752, 1951, 1959, 2040, 2000, 1840, 2010,
 /*   650 */  2014, 2018, 2030, 2031, 2032, 1966, 1969, 2022, 1857, 2027,
 /*   660 */  2025, 2080, 2081, 2082, 2083, 1972, 2037, 1823, 2038, 1974,
 /*   670 */  1996, 1999, 1975, 1986, 1924, 2003, 2105, 2070, 1960, 2008,
 /*   680 */  2001, 1823, 2065, 2071, 2015, 1876, 2016, 2116, 2099, 1901,
 /*   690 */  2021, 2033, 2035, 2036, 2043, 2039, 2087, 2044, 2053, 2089,
 /*   700 */  2054, 2119, 1936, 2057, 2047, 2058, 2122, 2129, 2062, 2063,
 /*   710 */  2131, 2066, 2064, 2135, 2068, 2069, 2137, 2073, 2074, 2145,
 /*   720 */  2078, 2059, 2060, 2061, 2067, 2084, 2139, 2085, 2154, 2088,
 /*   730 */  2139, 2139, 2168, 2124, 2127, 2162, 2163, 2165, 2166, 2167,
 /*   740 */  2169, 2170, 2171, 2128, 2110, 2164, 2176, 2179, 2186, 2188,
 /*   750 */  2189, 2190, 2191, 2152, 1875, 2194, 1877, 2197, 2198, 2207,
 /*   760 */  2208, 2222, 2210, 2246, 2212, 2199, 2211, 2249, 2217, 2204,
 /*   770 */  2215, 2255, 2221, 2209, 2218, 2259, 2225, 2213, 2227, 2261,
 /*   780 */  2229, 2232, 2269, 2248, 2250, 2251, 2252, 2254, 2256,
};
#define YY_REDUCE_COUNT (319)
#define YY_REDUCE_MIN   (-433)
#define YY_REDUCE_MAX   (2532)
static const short yy_reduce_ofst[] = {
 /*     0 */  -155,  -94,  176,  286,  386,  422,  600,  636,  830,  853,
 /*    10 */   458, 1091, 1153, 1220, 1285, 1321, -339,  151,  696, 1357,
 /*    20 */  1381, 1446, 1508, 1524, 1575, 1597, 1661, 1697, 1719, 1786,
 /*    30 */  1805, 1874, 1891, 1939, 1987, 2004, 2052, 2075, 2100, 2151,
 /*    40 */  2175, 2223, 2239, 2301, 2325, 2373, 2421, 2436, 2484, 2499,
 /*    50 */  2532, -165, -204, -407,   53,  118,  537,  620,  727,  547,
 /*    60 */   598, -363,   59,  752,  810, -284, -133,  354, -321,   55,
 /*    70 */   127, -388, -210,  -36, -205, -383, -327,  163,  150,  186,
 /*    80 */   246,  305,  410,  416,  475,  139,  610,  622,  215,  -33,
 /*    90 */   633,  689, -322,  732,  100,  740,  242,  755,  279, -109,
 /*   100 */   765,  819,  292,  861,  -96,  344,  383,  753,  261, -337,
 /*   110 */  -277, -277,  404, -257,  154,  239,  283,  457,  511,  546,
 /*   120 */   559,  563,  605,  616,  618,  667,  669,  703,  716,  747,
 /*   130 */   776,  777,  781,  187, -294, -154,  -70,  295,  472,  474,
 /*   140 */  -294,  429,  558,  629,  266,  353,  677,  593,  785,  788,
 /*   150 */   203, -242, -433,  455,   96,  467,  587,  685,  838,  850,
 /*   160 */   403,  536,  626,  746,  760,  890,  937,  760,  705,  929,
 /*   170 */   990,  932,  852,  845,  983,  871,  979,  985,  974,  974,
 /*   180 */  1001,  953, 1011, 1012,  972,  967,  910,  910,  894,  910,
 /*   190 */   919,  941,  974,  982,  986,  994,  991, 1057,  998, 1063,
 /*   200 */  1013, 1026, 1028, 1029, 1035, 1087, 1088, 1038, 1043, 1044,
 /*   210 */  1089, 1092, 1100, 1094, 1103, 1106, 1107, 1116, 1115, 1120,
 /*   220 */  1118, 1045, 1108, 1075, 1110, 1121, 1069, 1119, 1129, 1124,
 /*   230 */  1127, 1128, 1139, 1136, 1147, 1122, 1123, 1126, 1135, 1141,
 /*   240 */  1142, 1149, 1152, 1154, 1156, 1159, 1146, 1155, 1109, 1148,
 /*   250 */  1157, 1076, 1096, 1099, 1173, 1097, 1125, 1150, 1188, 1134,
 /*   260 */  1199, 1161, 1163, 1162, 1090, 1160, 1164, 1101, 1166, 1169,
 /*   270 */  1177,  974, 1111, 1102, 1113, 1112, 1137, 1132, 1165, 1144,
 /*   280 */  1167, 1140,  910, 1246, 1175, 1262, 1256, 1253, 1257, 1211,
 /*   290 */  1210, 1226, 1236, 1239, 1240, 1241, 1222, 1242, 1234, 1281,
 /*   300 */  1264, 1292, 1299, 1192, 1274, 1251, 1275, 1309, 1303, 1317,
 /*   310 */  1320, 1254, 1227, 1268, 1272, 1298, 1300, 1301, 1308, 1329,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*    10 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*    20 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*    30 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*    40 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*    50 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*    60 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*    70 */  1759, 1759, 1759, 1759, 2039, 1759, 1759, 1759, 1759, 1759,
 /*    80 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1848, 1759,
 /*    90 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   100 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1846, 2032,
 /*   110 */  2257, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   120 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   130 */  1759, 1759, 1759, 1759, 2269, 1759, 1759, 1822, 1822, 1759,
 /*   140 */  2269, 2269, 2269, 1846, 2229, 2229, 1759, 1759, 1759, 1759,
 /*   150 */  1848, 2099, 1759, 1759, 1759, 1759, 1759, 1759, 1967, 1759,
 /*   160 */  1759, 1759, 1759, 1759, 1991, 1759, 1759, 1759, 2091, 1759,
 /*   170 */  1759, 2294, 2350, 1759, 1759, 2297, 1759, 1759, 1759, 1759,
 /*   180 */  1759, 2044, 1759, 1759, 1921, 2284, 2261, 2275, 2334, 2262,
 /*   190 */  2259, 2278, 1759, 2288, 1759, 1759, 2113, 1848, 1759, 1848,
 /*   200 */  2078, 2037, 1759, 2037, 2034, 1759, 1759, 2037, 2034, 2034,
 /*   210 */  1910, 1906, 1759, 1904, 1759, 1759, 1759, 1759, 1806, 1759,
 /*   220 */  1806, 1759, 1848, 1759, 1848, 1759, 1759, 1848, 1759, 1848,
 /*   230 */  1848, 1848, 1759, 1848, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   240 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   250 */  1759, 2111, 2097, 1759, 1846, 2089, 2087, 1759, 1846, 2085,
 /*   260 */  1759, 1759, 1759, 1759, 2305, 2303, 1759, 2305, 2303, 1759,
 /*   270 */  1759, 1759, 2319, 2315, 2305, 2323, 2321, 2290, 2288, 2353,
 /*   280 */  2340, 2336, 2275, 1759, 1759, 1759, 1759, 1846, 1846, 1759,
 /*   290 */  2303, 1759, 1759, 1759, 1759, 1759, 2303, 1759, 1759, 1846,
 /*   300 */  1759, 1846, 1759, 1759, 1937, 1759, 1759, 1759, 1846, 1791,
 /*   310 */  1759, 2080, 2102, 2062, 2062, 1970, 1970, 1970, 1849, 1764,
 /*   320 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   330 */  1759, 1759, 2318, 2317, 2184, 1759, 2233, 2232, 2231, 2222,
 /*   340 */  2183, 1933, 1759, 2182, 2181, 1759, 1759, 1759, 1759, 1759,
 /*   350 */  1759, 1759, 1759, 1759, 2053, 2052, 2175, 1759, 1759, 2176,
 /*   360 */  2174, 2173, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   370 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   380 */  1759, 1759, 1759, 1759, 1759, 1759, 2337, 2341, 1759, 1759,
 /*   390 */  1759, 1759, 1759, 1759, 1759, 2258, 1759, 1759, 1759, 2157,
 /*   400 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   410 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   420 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   430 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   440 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   450 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   460 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   470 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   480 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   490 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   500 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   510 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   520 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1796, 2162, 1759,
 /*   530 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   540 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   550 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   560 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   570 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1887,
 /*   580 */  1886, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   590 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   600 */  1759, 1759, 1759, 2166, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   610 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   620 */  2333, 2291, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   630 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   640 */  2157, 1759, 2316, 1759, 1759, 2331, 1759, 2335, 1759, 1759,
 /*   650 */  1759, 1759, 1759, 1759, 1759, 2268, 2264, 1759, 1759, 2260,
 /*   660 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 2165, 1759, 1759,
 /*   670 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   680 */  1759, 2156, 1759, 2219, 1759, 1759, 1759, 2253, 1759, 1759,
 /*   690 */  2204, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   700 */  2166, 1759, 2169, 1759, 1759, 1759, 1759, 1759, 1964, 1759,
 /*   710 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   720 */  1759, 1949, 1947, 1946, 1945, 1759, 1977, 1759, 1759, 1759,
 /*   730 */  1973, 1972, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   740 */  1759, 1759, 1759, 1759, 1759, 1867, 1759, 1759, 1759, 1759,
 /*   750 */  1759, 1759, 1759, 1759, 1859, 1759, 1858, 1759, 1759, 1759,
 /*   760 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   770 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
 /*   780 */  1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759, 1759,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*     UNSAFE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  285,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*      PAUSE => nothing */
    0,  /*     RESUME => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*  UNTREATED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  285,  /*      AFTER => ABORT */
  285,  /*     ATTACH => ABORT */
  285,  /*     BEFORE => ABORT */
  285,  /*      BEGIN => ABORT */
  285,  /*     BITAND => ABORT */
  285,  /*     BITNOT => ABORT */
  285,  /*      BITOR => ABORT */
  285,  /*     BLOCKS => ABORT */
  285,  /*     CHANGE => ABORT */
  285,  /*      COMMA => ABORT */
  285,  /*     CONCAT => ABORT */
  285,  /*   CONFLICT => ABORT */
  285,  /*       COPY => ABORT */
  285,  /*   DEFERRED => ABORT */
  285,  /* DELIMITERS => ABORT */
  285,  /*     DETACH => ABORT */
  285,  /*     DIVIDE => ABORT */
  285,  /*        DOT => ABORT */
  285,  /*       EACH => ABORT */
  285,  /*       FAIL => ABORT */
  285,  /*       FILE => ABORT */
  285,  /*        FOR => ABORT */
  285,  /*       GLOB => ABORT */
  285,  /*         ID => ABORT */
  285,  /*  IMMEDIATE => ABORT */
  285,  /*     IMPORT => ABORT */
  285,  /*  INITIALLY => ABORT */
  285,  /*    INSTEAD => ABORT */
  285,  /*     ISNULL => ABORT */
  285,  /*        KEY => ABORT */
  285,  /*    MODULES => ABORT */
  285,  /*  NK_BITNOT => ABORT */
  285,  /*    NK_SEMI => ABORT */
  285,  /*    NOTNULL => ABORT */
  285,  /*         OF => ABORT */
  285,  /*       PLUS => ABORT */
  285,  /*  PRIVILEGE => ABORT */
  285,  /*      RAISE => ABORT */
  285,  /*   RESTRICT => ABORT */
  285,  /*        ROW => ABORT */
  285,  /*       SEMI => ABORT */
  285,  /*       STAR => ABORT */
  285,  /*  STATEMENT => ABORT */
  285,  /*     STRICT => ABORT */
  285,  /*     STRING => ABORT */
  285,  /*      TIMES => ABORT */
  285,  /*     VALUES => ABORT */
  285,  /*   VARIABLE => ABORT */
  285,  /*       VIEW => ABORT */
  285,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "UNSAFE",
  /*   56 */ "LOCAL",
  /*   57 */ "QNODE",
  /*   58 */ "BNODE",
  /*   59 */ "SNODE",
  /*   60 */ "MNODE",
  /*   61 */ "VNODE",
  /*   62 */ "DATABASE",
  /*   63 */ "USE",
  /*   64 */ "FLUSH",
  /*   65 */ "TRIM",
  /*   66 */ "COMPACT",
  /*   67 */ "IF",
  /*   68 */ "NOT",
  /*   69 */ "EXISTS",
  /*   70 */ "BUFFER",
  /*   71 */ "CACHEMODEL",
  /*   72 */ "CACHESIZE",
  /*   73 */ "COMP",
  /*   74 */ "DURATION",
  /*   75 */ "NK_VARIABLE",
  /*   76 */ "MAXROWS",
  /*   77 */ "MINROWS",
  /*   78 */ "KEEP",
  /*   79 */ "PAGES",
  /*   80 */ "PAGESIZE",
  /*   81 */ "TSDB_PAGESIZE",
  /*   82 */ "PRECISION",
  /*   83 */ "REPLICA",
  /*   84 */ "VGROUPS",
  /*   85 */ "SINGLE_STABLE",
  /*   86 */ "RETENTIONS",
  /*   87 */ "SCHEMALESS",
  /*   88 */ "WAL_LEVEL",
  /*   89 */ "WAL_FSYNC_PERIOD",
  /*   90 */ "WAL_RETENTION_PERIOD",
  /*   91 */ "WAL_RETENTION_SIZE",
  /*   92 */ "WAL_ROLL_PERIOD",
  /*   93 */ "WAL_SEGMENT_SIZE",
  /*   94 */ "STT_TRIGGER",
  /*   95 */ "TABLE_PREFIX",
  /*   96 */ "TABLE_SUFFIX",
  /*   97 */ "NK_COLON",
  /*   98 */ "MAX_SPEED",
  /*   99 */ "START",
  /*  100 */ "TIMESTAMP",
  /*  101 */ "END",
  /*  102 */ "TABLE",
  /*  103 */ "NK_LP",
  /*  104 */ "NK_RP",
  /*  105 */ "STABLE",
  /*  106 */ "ADD",
  /*  107 */ "COLUMN",
  /*  108 */ "MODIFY",
  /*  109 */ "RENAME",
  /*  110 */ "TAG",
  /*  111 */ "SET",
  /*  112 */ "NK_EQ",
  /*  113 */ "USING",
  /*  114 */ "TAGS",
  /*  115 */ "BOOL",
  /*  116 */ "TINYINT",
  /*  117 */ "SMALLINT",
  /*  118 */ "INT",
  /*  119 */ "INTEGER",
  /*  120 */ "BIGINT",
  /*  121 */ "FLOAT",
  /*  122 */ "DOUBLE",
  /*  123 */ "BINARY",
  /*  124 */ "NCHAR",
  /*  125 */ "UNSIGNED",
  /*  126 */ "JSON",
  /*  127 */ "VARCHAR",
  /*  128 */ "MEDIUMBLOB",
  /*  129 */ "BLOB",
  /*  130 */ "VARBINARY",
  /*  131 */ "DECIMAL",
  /*  132 */ "COMMENT",
  /*  133 */ "MAX_DELAY",
  /*  134 */ "WATERMARK",
  /*  135 */ "ROLLUP",
  /*  136 */ "TTL",
  /*  137 */ "SMA",
  /*  138 */ "DELETE_MARK",
  /*  139 */ "FIRST",
  /*  140 */ "LAST",
  /*  141 */ "SHOW",
  /*  142 */ "PRIVILEGES",
  /*  143 */ "DATABASES",
  /*  144 */ "TABLES",
  /*  145 */ "STABLES",
  /*  146 */ "MNODES",
  /*  147 */ "QNODES",
  /*  148 */ "FUNCTIONS",
  /*  149 */ "INDEXES",
  /*  150 */ "ACCOUNTS",
  /*  151 */ "APPS",
  /*  152 */ "CONNECTIONS",
  /*  153 */ "LICENCES",
  /*  154 */ "GRANTS",
  /*  155 */ "QUERIES",
  /*  156 */ "SCORES",
  /*  157 */ "TOPICS",
  /*  158 */ "VARIABLES",
  /*  159 */ "CLUSTER",
  /*  160 */ "BNODES",
  /*  161 */ "SNODES",
  /*  162 */ "TRANSACTIONS",
  /*  163 */ "DISTRIBUTED",
  /*  164 */ "CONSUMERS",
  /*  165 */ "SUBSCRIPTIONS",
  /*  166 */ "VNODES",
  /*  167 */ "ALIVE",
  /*  168 */ "LIKE",
  /*  169 */ "TBNAME",
  /*  170 */ "QTAGS",
  /*  171 */ "AS",
  /*  172 */ "INDEX",
  /*  173 */ "FUNCTION",
  /*  174 */ "INTERVAL",
  /*  175 */ "COUNT",
  /*  176 */ "LAST_ROW",
  /*  177 */ "TOPIC",
  /*  178 */ "META",
  /*  179 */ "CONSUMER",
  /*  180 */ "GROUP",
  /*  181 */ "DESC",
  /*  182 */ "DESCRIBE",
  /*  183 */ "RESET",
  /*  184 */ "QUERY",
  /*  185 */ "CACHE",
  /*  186 */ "EXPLAIN",
  /*  187 */ "ANALYZE",
  /*  188 */ "VERBOSE",
  /*  189 */ "NK_BOOL",
  /*  190 */ "RATIO",
  /*  191 */ "NK_FLOAT",
  /*  192 */ "OUTPUTTYPE",
  /*  193 */ "AGGREGATE",
  /*  194 */ "BUFSIZE",
  /*  195 */ "LANGUAGE",
  /*  196 */ "REPLACE",
  /*  197 */ "STREAM",
  /*  198 */ "INTO",
  /*  199 */ "PAUSE",
  /*  200 */ "RESUME",
  /*  201 */ "TRIGGER",
  /*  202 */ "AT_ONCE",
  /*  203 */ "WINDOW_CLOSE",
  /*  204 */ "IGNORE",
  /*  205 */ "EXPIRED",
  /*  206 */ "FILL_HISTORY",
  /*  207 */ "UPDATE",
  /*  208 */ "SUBTABLE",
  /*  209 */ "UNTREATED",
  /*  210 */ "KILL",
  /*  211 */ "CONNECTION",
  /*  212 */ "TRANSACTION",
  /*  213 */ "BALANCE",
  /*  214 */ "VGROUP",
  /*  215 */ "LEADER",
  /*  216 */ "MERGE",
  /*  217 */ "REDISTRIBUTE",
  /*  218 */ "SPLIT",
  /*  219 */ "DELETE",
  /*  220 */ "INSERT",
  /*  221 */ "NULL",
  /*  222 */ "NK_QUESTION",
  /*  223 */ "NK_ARROW",
  /*  224 */ "ROWTS",
  /*  225 */ "QSTART",
  /*  226 */ "QEND",
  /*  227 */ "QDURATION",
  /*  228 */ "WSTART",
  /*  229 */ "WEND",
  /*  230 */ "WDURATION",
  /*  231 */ "IROWTS",
  /*  232 */ "ISFILLED",
  /*  233 */ "CAST",
  /*  234 */ "NOW",
  /*  235 */ "TODAY",
  /*  236 */ "TIMEZONE",
  /*  237 */ "CLIENT_VERSION",
  /*  238 */ "SERVER_VERSION",
  /*  239 */ "SERVER_STATUS",
  /*  240 */ "CURRENT_USER",
  /*  241 */ "CASE",
  /*  242 */ "WHEN",
  /*  243 */ "THEN",
  /*  244 */ "ELSE",
  /*  245 */ "BETWEEN",
  /*  246 */ "IS",
  /*  247 */ "NK_LT",
  /*  248 */ "NK_GT",
  /*  249 */ "NK_LE",
  /*  250 */ "NK_GE",
  /*  251 */ "NK_NE",
  /*  252 */ "MATCH",
  /*  253 */ "NMATCH",
  /*  254 */ "CONTAINS",
  /*  255 */ "IN",
  /*  256 */ "JOIN",
  /*  257 */ "INNER",
  /*  258 */ "SELECT",
  /*  259 */ "DISTINCT",
  /*  260 */ "WHERE",
  /*  261 */ "PARTITION",
  /*  262 */ "BY",
  /*  263 */ "SESSION",
  /*  264 */ "STATE_WINDOW",
  /*  265 */ "EVENT_WINDOW",
  /*  266 */ "SLIDING",
  /*  267 */ "FILL",
  /*  268 */ "VALUE",
  /*  269 */ "VALUE_F",
  /*  270 */ "NONE",
  /*  271 */ "PREV",
  /*  272 */ "NULL_F",
  /*  273 */ "LINEAR",
  /*  274 */ "NEXT",
  /*  275 */ "HAVING",
  /*  276 */ "RANGE",
  /*  277 */ "EVERY",
  /*  278 */ "ORDER",
  /*  279 */ "SLIMIT",
  /*  280 */ "SOFFSET",
  /*  281 */ "LIMIT",
  /*  282 */ "OFFSET",
  /*  283 */ "ASC",
  /*  284 */ "NULLS",
  /*  285 */ "ABORT",
  /*  286 */ "AFTER",
  /*  287 */ "ATTACH",
  /*  288 */ "BEFORE",
  /*  289 */ "BEGIN",
  /*  290 */ "BITAND",
  /*  291 */ "BITNOT",
  /*  292 */ "BITOR",
  /*  293 */ "BLOCKS",
  /*  294 */ "CHANGE",
  /*  295 */ "COMMA",
  /*  296 */ "CONCAT",
  /*  297 */ "CONFLICT",
  /*  298 */ "COPY",
  /*  299 */ "DEFERRED",
  /*  300 */ "DELIMITERS",
  /*  301 */ "DETACH",
  /*  302 */ "DIVIDE",
  /*  303 */ "DOT",
  /*  304 */ "EACH",
  /*  305 */ "FAIL",
  /*  306 */ "FILE",
  /*  307 */ "FOR",
  /*  308 */ "GLOB",
  /*  309 */ "ID",
  /*  310 */ "IMMEDIATE",
  /*  311 */ "IMPORT",
  /*  312 */ "INITIALLY",
  /*  313 */ "INSTEAD",
  /*  314 */ "ISNULL",
  /*  315 */ "KEY",
  /*  316 */ "MODULES",
  /*  317 */ "NK_BITNOT",
  /*  318 */ "NK_SEMI",
  /*  319 */ "NOTNULL",
  /*  320 */ "OF",
  /*  321 */ "PLUS",
  /*  322 */ "PRIVILEGE",
  /*  323 */ "RAISE",
  /*  324 */ "RESTRICT",
  /*  325 */ "ROW",
  /*  326 */ "SEMI",
  /*  327 */ "STAR",
  /*  328 */ "STATEMENT",
  /*  329 */ "STRICT",
  /*  330 */ "STRING",
  /*  331 */ "TIMES",
  /*  332 */ "VALUES",
  /*  333 */ "VARIABLE",
  /*  334 */ "VIEW",
  /*  335 */ "WAL",
  /*  336 */ "cmd",
  /*  337 */ "account_options",
  /*  338 */ "alter_account_options",
  /*  339 */ "literal",
  /*  340 */ "alter_account_option",
  /*  341 */ "user_name",
  /*  342 */ "sysinfo_opt",
  /*  343 */ "privileges",
  /*  344 */ "priv_level",
  /*  345 */ "with_opt",
  /*  346 */ "priv_type_list",
  /*  347 */ "priv_type",
  /*  348 */ "db_name",
  /*  349 */ "table_name",
  /*  350 */ "topic_name",
  /*  351 */ "search_condition",
  /*  352 */ "dnode_endpoint",
  /*  353 */ "force_opt",
  /*  354 */ "unsafe_opt",
  /*  355 */ "not_exists_opt",
  /*  356 */ "db_options",
  /*  357 */ "exists_opt",
  /*  358 */ "alter_db_options",
  /*  359 */ "speed_opt",
  /*  360 */ "start_opt",
  /*  361 */ "end_opt",
  /*  362 */ "integer_list",
  /*  363 */ "variable_list",
  /*  364 */ "retention_list",
  /*  365 */ "signed",
  /*  366 */ "alter_db_option",
  /*  367 */ "retention",
  /*  368 */ "full_table_name",
  /*  369 */ "column_def_list",
  /*  370 */ "tags_def_opt",
  /*  371 */ "table_options",
  /*  372 */ "multi_create_clause",
  /*  373 */ "tags_def",
  /*  374 */ "multi_drop_clause",
  /*  375 */ "alter_table_clause",
  /*  376 */ "alter_table_options",
  /*  377 */ "column_name",
  /*  378 */ "type_name",
  /*  379 */ "signed_literal",
  /*  380 */ "create_subtable_clause",
  /*  381 */ "specific_cols_opt",
  /*  382 */ "expression_list",
  /*  383 */ "drop_table_clause",
  /*  384 */ "col_name_list",
  /*  385 */ "column_def",
  /*  386 */ "duration_list",
  /*  387 */ "rollup_func_list",
  /*  388 */ "alter_table_option",
  /*  389 */ "duration_literal",
  /*  390 */ "rollup_func_name",
  /*  391 */ "function_name",
  /*  392 */ "col_name",
  /*  393 */ "db_name_cond_opt",
  /*  394 */ "like_pattern_opt",
  /*  395 */ "table_name_cond",
  /*  396 */ "from_db_opt",
  /*  397 */ "tag_list_opt",
  /*  398 */ "tag_item",
  /*  399 */ "column_alias",
  /*  400 */ "full_index_name",
  /*  401 */ "index_options",
  /*  402 */ "index_name",
  /*  403 */ "func_list",
  /*  404 */ "sliding_opt",
  /*  405 */ "sma_stream_opt",
  /*  406 */ "func",
  /*  407 */ "sma_func_name",
  /*  408 */ "query_or_subquery",
  /*  409 */ "cgroup_name",
  /*  410 */ "analyze_opt",
  /*  411 */ "explain_options",
  /*  412 */ "insert_query",
  /*  413 */ "or_replace_opt",
  /*  414 */ "agg_func_opt",
  /*  415 */ "bufsize_opt",
  /*  416 */ "language_opt",
  /*  417 */ "stream_name",
  /*  418 */ "stream_options",
  /*  419 */ "col_list_opt",
  /*  420 */ "tag_def_or_ref_opt",
  /*  421 */ "subtable_opt",
  /*  422 */ "ignore_opt",
  /*  423 */ "expression",
  /*  424 */ "dnode_list",
  /*  425 */ "where_clause_opt",
  /*  426 */ "literal_func",
  /*  427 */ "literal_list",
  /*  428 */ "table_alias",
  /*  429 */ "expr_or_subquery",
  /*  430 */ "pseudo_column",
  /*  431 */ "column_reference",
  /*  432 */ "function_expression",
  /*  433 */ "case_when_expression",
  /*  434 */ "star_func",
  /*  435 */ "star_func_para_list",
  /*  436 */ "noarg_func",
  /*  437 */ "other_para_list",
  /*  438 */ "star_func_para",
  /*  439 */ "when_then_list",
  /*  440 */ "case_when_else_opt",
  /*  441 */ "common_expression",
  /*  442 */ "when_then_expr",
  /*  443 */ "predicate",
  /*  444 */ "compare_op",
  /*  445 */ "in_op",
  /*  446 */ "in_predicate_value",
  /*  447 */ "boolean_value_expression",
  /*  448 */ "boolean_primary",
  /*  449 */ "from_clause_opt",
  /*  450 */ "table_reference_list",
  /*  451 */ "table_reference",
  /*  452 */ "table_primary",
  /*  453 */ "joined_table",
  /*  454 */ "alias_opt",
  /*  455 */ "subquery",
  /*  456 */ "parenthesized_joined_table",
  /*  457 */ "join_type",
  /*  458 */ "query_specification",
  /*  459 */ "set_quantifier_opt",
  /*  460 */ "select_list",
  /*  461 */ "partition_by_clause_opt",
  /*  462 */ "range_opt",
  /*  463 */ "every_opt",
  /*  464 */ "fill_opt",
  /*  465 */ "twindow_clause_opt",
  /*  466 */ "group_by_clause_opt",
  /*  467 */ "having_clause_opt",
  /*  468 */ "select_item",
  /*  469 */ "partition_list",
  /*  470 */ "partition_item",
  /*  471 */ "fill_mode",
  /*  472 */ "group_by_list",
  /*  473 */ "query_expression",
  /*  474 */ "query_simple",
  /*  475 */ "order_by_clause_opt",
  /*  476 */ "slimit_clause_opt",
  /*  477 */ "limit_clause_opt",
  /*  478 */ "union_query_expression",
  /*  479 */ "query_simple_or_subquery",
  /*  480 */ "sort_specification_list",
  /*  481 */ "sort_specification",
  /*  482 */ "ordering_specification_opt",
  /*  483 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= DROP DNODE NK_INTEGER unsafe_opt",
 /*  51 */ "cmd ::= DROP DNODE dnode_endpoint unsafe_opt",
 /*  52 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  53 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  54 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  55 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  56 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  57 */ "dnode_endpoint ::= NK_STRING",
 /*  58 */ "dnode_endpoint ::= NK_ID",
 /*  59 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  60 */ "force_opt ::=",
 /*  61 */ "force_opt ::= FORCE",
 /*  62 */ "unsafe_opt ::= UNSAFE",
 /*  63 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  64 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  65 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  74 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  75 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  76 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  77 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  78 */ "cmd ::= USE db_name",
 /*  79 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  80 */ "cmd ::= FLUSH DATABASE db_name",
 /*  81 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  82 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  83 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  84 */ "not_exists_opt ::=",
 /*  85 */ "exists_opt ::= IF EXISTS",
 /*  86 */ "exists_opt ::=",
 /*  87 */ "db_options ::=",
 /*  88 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  89 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  90 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  92 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  93 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  94 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  95 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  96 */ "db_options ::= db_options KEEP integer_list",
 /*  97 */ "db_options ::= db_options KEEP variable_list",
 /*  98 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  99 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options PRECISION NK_STRING",
 /* 102 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 103 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 104 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 105 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 106 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 113 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 114 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 115 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 116 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 117 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 118 */ "alter_db_options ::= alter_db_option",
 /* 119 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 120 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 121 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 122 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 124 */ "alter_db_option ::= KEEP integer_list",
 /* 125 */ "alter_db_option ::= KEEP variable_list",
 /* 126 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 127 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 129 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 130 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 132 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 133 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 134 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 135 */ "integer_list ::= NK_INTEGER",
 /* 136 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 137 */ "variable_list ::= NK_VARIABLE",
 /* 138 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 139 */ "retention_list ::= retention",
 /* 140 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 141 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 142 */ "speed_opt ::=",
 /* 143 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 144 */ "start_opt ::=",
 /* 145 */ "start_opt ::= START WITH NK_INTEGER",
 /* 146 */ "start_opt ::= START WITH NK_STRING",
 /* 147 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 148 */ "end_opt ::=",
 /* 149 */ "end_opt ::= END WITH NK_INTEGER",
 /* 150 */ "end_opt ::= END WITH NK_STRING",
 /* 151 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 152 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 153 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 154 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 155 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 156 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 157 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 158 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 159 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 160 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 161 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 162 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 163 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 164 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 165 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 166 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 167 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 168 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 169 */ "multi_create_clause ::= create_subtable_clause",
 /* 170 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 171 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 172 */ "multi_drop_clause ::= drop_table_clause",
 /* 173 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 174 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 175 */ "specific_cols_opt ::=",
 /* 176 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 177 */ "full_table_name ::= table_name",
 /* 178 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 179 */ "column_def_list ::= column_def",
 /* 180 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 181 */ "column_def ::= column_name type_name",
 /* 182 */ "type_name ::= BOOL",
 /* 183 */ "type_name ::= TINYINT",
 /* 184 */ "type_name ::= SMALLINT",
 /* 185 */ "type_name ::= INT",
 /* 186 */ "type_name ::= INTEGER",
 /* 187 */ "type_name ::= BIGINT",
 /* 188 */ "type_name ::= FLOAT",
 /* 189 */ "type_name ::= DOUBLE",
 /* 190 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 191 */ "type_name ::= TIMESTAMP",
 /* 192 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= TINYINT UNSIGNED",
 /* 194 */ "type_name ::= SMALLINT UNSIGNED",
 /* 195 */ "type_name ::= INT UNSIGNED",
 /* 196 */ "type_name ::= BIGINT UNSIGNED",
 /* 197 */ "type_name ::= JSON",
 /* 198 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 199 */ "type_name ::= MEDIUMBLOB",
 /* 200 */ "type_name ::= BLOB",
 /* 201 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 202 */ "type_name ::= DECIMAL",
 /* 203 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 204 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 205 */ "tags_def_opt ::=",
 /* 206 */ "tags_def_opt ::= tags_def",
 /* 207 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 208 */ "table_options ::=",
 /* 209 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 210 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 211 */ "table_options ::= table_options WATERMARK duration_list",
 /* 212 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 213 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 214 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 215 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 216 */ "alter_table_options ::= alter_table_option",
 /* 217 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 218 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 219 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 220 */ "duration_list ::= duration_literal",
 /* 221 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 222 */ "rollup_func_list ::= rollup_func_name",
 /* 223 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 224 */ "rollup_func_name ::= function_name",
 /* 225 */ "rollup_func_name ::= FIRST",
 /* 226 */ "rollup_func_name ::= LAST",
 /* 227 */ "col_name_list ::= col_name",
 /* 228 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 229 */ "col_name ::= column_name",
 /* 230 */ "cmd ::= SHOW DNODES",
 /* 231 */ "cmd ::= SHOW USERS",
 /* 232 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 233 */ "cmd ::= SHOW DATABASES",
 /* 234 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 236 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 237 */ "cmd ::= SHOW MNODES",
 /* 238 */ "cmd ::= SHOW QNODES",
 /* 239 */ "cmd ::= SHOW FUNCTIONS",
 /* 240 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 241 */ "cmd ::= SHOW STREAMS",
 /* 242 */ "cmd ::= SHOW ACCOUNTS",
 /* 243 */ "cmd ::= SHOW APPS",
 /* 244 */ "cmd ::= SHOW CONNECTIONS",
 /* 245 */ "cmd ::= SHOW LICENCES",
 /* 246 */ "cmd ::= SHOW GRANTS",
 /* 247 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 248 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 249 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 250 */ "cmd ::= SHOW QUERIES",
 /* 251 */ "cmd ::= SHOW SCORES",
 /* 252 */ "cmd ::= SHOW TOPICS",
 /* 253 */ "cmd ::= SHOW VARIABLES",
 /* 254 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 255 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 256 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 257 */ "cmd ::= SHOW BNODES",
 /* 258 */ "cmd ::= SHOW SNODES",
 /* 259 */ "cmd ::= SHOW CLUSTER",
 /* 260 */ "cmd ::= SHOW TRANSACTIONS",
 /* 261 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 262 */ "cmd ::= SHOW CONSUMERS",
 /* 263 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 264 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 265 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 266 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 267 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 268 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 269 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 270 */ "db_name_cond_opt ::=",
 /* 271 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 272 */ "like_pattern_opt ::=",
 /* 273 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 274 */ "table_name_cond ::= table_name",
 /* 275 */ "from_db_opt ::=",
 /* 276 */ "from_db_opt ::= FROM db_name",
 /* 277 */ "tag_list_opt ::=",
 /* 278 */ "tag_list_opt ::= tag_item",
 /* 279 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 280 */ "tag_item ::= TBNAME",
 /* 281 */ "tag_item ::= QTAGS",
 /* 282 */ "tag_item ::= column_name",
 /* 283 */ "tag_item ::= column_name column_alias",
 /* 284 */ "tag_item ::= column_name AS column_alias",
 /* 285 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 286 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 287 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 288 */ "full_index_name ::= index_name",
 /* 289 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 290 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 291 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 292 */ "func_list ::= func",
 /* 293 */ "func_list ::= func_list NK_COMMA func",
 /* 294 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 295 */ "sma_func_name ::= function_name",
 /* 296 */ "sma_func_name ::= COUNT",
 /* 297 */ "sma_func_name ::= FIRST",
 /* 298 */ "sma_func_name ::= LAST",
 /* 299 */ "sma_func_name ::= LAST_ROW",
 /* 300 */ "sma_stream_opt ::=",
 /* 301 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 302 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 303 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 304 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 305 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 306 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 307 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 308 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 309 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 310 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 311 */ "cmd ::= DESC full_table_name",
 /* 312 */ "cmd ::= DESCRIBE full_table_name",
 /* 313 */ "cmd ::= RESET QUERY CACHE",
 /* 314 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 315 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 316 */ "analyze_opt ::=",
 /* 317 */ "analyze_opt ::= ANALYZE",
 /* 318 */ "explain_options ::=",
 /* 319 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 320 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 321 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 322 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 323 */ "agg_func_opt ::=",
 /* 324 */ "agg_func_opt ::= AGGREGATE",
 /* 325 */ "bufsize_opt ::=",
 /* 326 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 327 */ "language_opt ::=",
 /* 328 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 329 */ "or_replace_opt ::=",
 /* 330 */ "or_replace_opt ::= OR REPLACE",
 /* 331 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 332 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 333 */ "cmd ::= PAUSE STREAM exists_opt stream_name",
 /* 334 */ "cmd ::= RESUME STREAM exists_opt ignore_opt stream_name",
 /* 335 */ "col_list_opt ::=",
 /* 336 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 337 */ "tag_def_or_ref_opt ::=",
 /* 338 */ "tag_def_or_ref_opt ::= tags_def",
 /* 339 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 340 */ "stream_options ::=",
 /* 341 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 342 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 343 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 344 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 345 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 346 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 347 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 348 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 349 */ "subtable_opt ::=",
 /* 350 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 351 */ "ignore_opt ::=",
 /* 352 */ "ignore_opt ::= IGNORE UNTREATED",
 /* 353 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 354 */ "cmd ::= KILL QUERY NK_STRING",
 /* 355 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 356 */ "cmd ::= BALANCE VGROUP",
 /* 357 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 358 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 359 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 360 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 361 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 362 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 363 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 364 */ "cmd ::= query_or_subquery",
 /* 365 */ "cmd ::= insert_query",
 /* 366 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 367 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 368 */ "literal ::= NK_INTEGER",
 /* 369 */ "literal ::= NK_FLOAT",
 /* 370 */ "literal ::= NK_STRING",
 /* 371 */ "literal ::= NK_BOOL",
 /* 372 */ "literal ::= TIMESTAMP NK_STRING",
 /* 373 */ "literal ::= duration_literal",
 /* 374 */ "literal ::= NULL",
 /* 375 */ "literal ::= NK_QUESTION",
 /* 376 */ "duration_literal ::= NK_VARIABLE",
 /* 377 */ "signed ::= NK_INTEGER",
 /* 378 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 379 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 380 */ "signed ::= NK_FLOAT",
 /* 381 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 382 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 383 */ "signed_literal ::= signed",
 /* 384 */ "signed_literal ::= NK_STRING",
 /* 385 */ "signed_literal ::= NK_BOOL",
 /* 386 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 387 */ "signed_literal ::= duration_literal",
 /* 388 */ "signed_literal ::= NULL",
 /* 389 */ "signed_literal ::= literal_func",
 /* 390 */ "signed_literal ::= NK_QUESTION",
 /* 391 */ "literal_list ::= signed_literal",
 /* 392 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 393 */ "db_name ::= NK_ID",
 /* 394 */ "table_name ::= NK_ID",
 /* 395 */ "column_name ::= NK_ID",
 /* 396 */ "function_name ::= NK_ID",
 /* 397 */ "table_alias ::= NK_ID",
 /* 398 */ "column_alias ::= NK_ID",
 /* 399 */ "user_name ::= NK_ID",
 /* 400 */ "topic_name ::= NK_ID",
 /* 401 */ "stream_name ::= NK_ID",
 /* 402 */ "cgroup_name ::= NK_ID",
 /* 403 */ "index_name ::= NK_ID",
 /* 404 */ "expr_or_subquery ::= expression",
 /* 405 */ "expression ::= literal",
 /* 406 */ "expression ::= pseudo_column",
 /* 407 */ "expression ::= column_reference",
 /* 408 */ "expression ::= function_expression",
 /* 409 */ "expression ::= case_when_expression",
 /* 410 */ "expression ::= NK_LP expression NK_RP",
 /* 411 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 412 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 413 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 414 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 415 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 416 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 417 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 418 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 419 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 420 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 421 */ "expression_list ::= expr_or_subquery",
 /* 422 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 423 */ "column_reference ::= column_name",
 /* 424 */ "column_reference ::= table_name NK_DOT column_name",
 /* 425 */ "pseudo_column ::= ROWTS",
 /* 426 */ "pseudo_column ::= TBNAME",
 /* 427 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 428 */ "pseudo_column ::= QSTART",
 /* 429 */ "pseudo_column ::= QEND",
 /* 430 */ "pseudo_column ::= QDURATION",
 /* 431 */ "pseudo_column ::= WSTART",
 /* 432 */ "pseudo_column ::= WEND",
 /* 433 */ "pseudo_column ::= WDURATION",
 /* 434 */ "pseudo_column ::= IROWTS",
 /* 435 */ "pseudo_column ::= ISFILLED",
 /* 436 */ "pseudo_column ::= QTAGS",
 /* 437 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 438 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 439 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 440 */ "function_expression ::= literal_func",
 /* 441 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 442 */ "literal_func ::= NOW",
 /* 443 */ "noarg_func ::= NOW",
 /* 444 */ "noarg_func ::= TODAY",
 /* 445 */ "noarg_func ::= TIMEZONE",
 /* 446 */ "noarg_func ::= DATABASE",
 /* 447 */ "noarg_func ::= CLIENT_VERSION",
 /* 448 */ "noarg_func ::= SERVER_VERSION",
 /* 449 */ "noarg_func ::= SERVER_STATUS",
 /* 450 */ "noarg_func ::= CURRENT_USER",
 /* 451 */ "noarg_func ::= USER",
 /* 452 */ "star_func ::= COUNT",
 /* 453 */ "star_func ::= FIRST",
 /* 454 */ "star_func ::= LAST",
 /* 455 */ "star_func ::= LAST_ROW",
 /* 456 */ "star_func_para_list ::= NK_STAR",
 /* 457 */ "star_func_para_list ::= other_para_list",
 /* 458 */ "other_para_list ::= star_func_para",
 /* 459 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 460 */ "star_func_para ::= expr_or_subquery",
 /* 461 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 462 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 463 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 464 */ "when_then_list ::= when_then_expr",
 /* 465 */ "when_then_list ::= when_then_list when_then_expr",
 /* 466 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 467 */ "case_when_else_opt ::=",
 /* 468 */ "case_when_else_opt ::= ELSE common_expression",
 /* 469 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 470 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 471 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 472 */ "predicate ::= expr_or_subquery IS NULL",
 /* 473 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 474 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 475 */ "compare_op ::= NK_LT",
 /* 476 */ "compare_op ::= NK_GT",
 /* 477 */ "compare_op ::= NK_LE",
 /* 478 */ "compare_op ::= NK_GE",
 /* 479 */ "compare_op ::= NK_NE",
 /* 480 */ "compare_op ::= NK_EQ",
 /* 481 */ "compare_op ::= LIKE",
 /* 482 */ "compare_op ::= NOT LIKE",
 /* 483 */ "compare_op ::= MATCH",
 /* 484 */ "compare_op ::= NMATCH",
 /* 485 */ "compare_op ::= CONTAINS",
 /* 486 */ "in_op ::= IN",
 /* 487 */ "in_op ::= NOT IN",
 /* 488 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 489 */ "boolean_value_expression ::= boolean_primary",
 /* 490 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 491 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 492 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 493 */ "boolean_primary ::= predicate",
 /* 494 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 495 */ "common_expression ::= expr_or_subquery",
 /* 496 */ "common_expression ::= boolean_value_expression",
 /* 497 */ "from_clause_opt ::=",
 /* 498 */ "from_clause_opt ::= FROM table_reference_list",
 /* 499 */ "table_reference_list ::= table_reference",
 /* 500 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 501 */ "table_reference ::= table_primary",
 /* 502 */ "table_reference ::= joined_table",
 /* 503 */ "table_primary ::= table_name alias_opt",
 /* 504 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 505 */ "table_primary ::= subquery alias_opt",
 /* 506 */ "table_primary ::= parenthesized_joined_table",
 /* 507 */ "alias_opt ::=",
 /* 508 */ "alias_opt ::= table_alias",
 /* 509 */ "alias_opt ::= AS table_alias",
 /* 510 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 511 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 512 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 513 */ "join_type ::=",
 /* 514 */ "join_type ::= INNER",
 /* 515 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 516 */ "set_quantifier_opt ::=",
 /* 517 */ "set_quantifier_opt ::= DISTINCT",
 /* 518 */ "set_quantifier_opt ::= ALL",
 /* 519 */ "select_list ::= select_item",
 /* 520 */ "select_list ::= select_list NK_COMMA select_item",
 /* 521 */ "select_item ::= NK_STAR",
 /* 522 */ "select_item ::= common_expression",
 /* 523 */ "select_item ::= common_expression column_alias",
 /* 524 */ "select_item ::= common_expression AS column_alias",
 /* 525 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 526 */ "where_clause_opt ::=",
 /* 527 */ "where_clause_opt ::= WHERE search_condition",
 /* 528 */ "partition_by_clause_opt ::=",
 /* 529 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 530 */ "partition_list ::= partition_item",
 /* 531 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 532 */ "partition_item ::= expr_or_subquery",
 /* 533 */ "partition_item ::= expr_or_subquery column_alias",
 /* 534 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 535 */ "twindow_clause_opt ::=",
 /* 536 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 537 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 538 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 539 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 540 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 541 */ "sliding_opt ::=",
 /* 542 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 543 */ "fill_opt ::=",
 /* 544 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 545 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 546 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 547 */ "fill_mode ::= NONE",
 /* 548 */ "fill_mode ::= PREV",
 /* 549 */ "fill_mode ::= NULL",
 /* 550 */ "fill_mode ::= NULL_F",
 /* 551 */ "fill_mode ::= LINEAR",
 /* 552 */ "fill_mode ::= NEXT",
 /* 553 */ "group_by_clause_opt ::=",
 /* 554 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 555 */ "group_by_list ::= expr_or_subquery",
 /* 556 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 557 */ "having_clause_opt ::=",
 /* 558 */ "having_clause_opt ::= HAVING search_condition",
 /* 559 */ "range_opt ::=",
 /* 560 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 561 */ "every_opt ::=",
 /* 562 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 563 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 564 */ "query_simple ::= query_specification",
 /* 565 */ "query_simple ::= union_query_expression",
 /* 566 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 567 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 568 */ "query_simple_or_subquery ::= query_simple",
 /* 569 */ "query_simple_or_subquery ::= subquery",
 /* 570 */ "query_or_subquery ::= query_expression",
 /* 571 */ "query_or_subquery ::= subquery",
 /* 572 */ "order_by_clause_opt ::=",
 /* 573 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 574 */ "slimit_clause_opt ::=",
 /* 575 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 576 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 577 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 578 */ "limit_clause_opt ::=",
 /* 579 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 580 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 581 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 582 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 583 */ "subquery ::= NK_LP subquery NK_RP",
 /* 584 */ "search_condition ::= common_expression",
 /* 585 */ "sort_specification_list ::= sort_specification",
 /* 586 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 587 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 588 */ "ordering_specification_opt ::=",
 /* 589 */ "ordering_specification_opt ::= ASC",
 /* 590 */ "ordering_specification_opt ::= DESC",
 /* 591 */ "null_ordering_opt ::=",
 /* 592 */ "null_ordering_opt ::= NULLS FIRST",
 /* 593 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 336: /* cmd */
    case 339: /* literal */
    case 345: /* with_opt */
    case 351: /* search_condition */
    case 356: /* db_options */
    case 358: /* alter_db_options */
    case 360: /* start_opt */
    case 361: /* end_opt */
    case 365: /* signed */
    case 367: /* retention */
    case 368: /* full_table_name */
    case 371: /* table_options */
    case 375: /* alter_table_clause */
    case 376: /* alter_table_options */
    case 379: /* signed_literal */
    case 380: /* create_subtable_clause */
    case 383: /* drop_table_clause */
    case 385: /* column_def */
    case 389: /* duration_literal */
    case 390: /* rollup_func_name */
    case 392: /* col_name */
    case 393: /* db_name_cond_opt */
    case 394: /* like_pattern_opt */
    case 395: /* table_name_cond */
    case 396: /* from_db_opt */
    case 398: /* tag_item */
    case 400: /* full_index_name */
    case 401: /* index_options */
    case 404: /* sliding_opt */
    case 405: /* sma_stream_opt */
    case 406: /* func */
    case 408: /* query_or_subquery */
    case 411: /* explain_options */
    case 412: /* insert_query */
    case 418: /* stream_options */
    case 421: /* subtable_opt */
    case 423: /* expression */
    case 425: /* where_clause_opt */
    case 426: /* literal_func */
    case 429: /* expr_or_subquery */
    case 430: /* pseudo_column */
    case 431: /* column_reference */
    case 432: /* function_expression */
    case 433: /* case_when_expression */
    case 438: /* star_func_para */
    case 440: /* case_when_else_opt */
    case 441: /* common_expression */
    case 442: /* when_then_expr */
    case 443: /* predicate */
    case 446: /* in_predicate_value */
    case 447: /* boolean_value_expression */
    case 448: /* boolean_primary */
    case 449: /* from_clause_opt */
    case 450: /* table_reference_list */
    case 451: /* table_reference */
    case 452: /* table_primary */
    case 453: /* joined_table */
    case 455: /* subquery */
    case 456: /* parenthesized_joined_table */
    case 458: /* query_specification */
    case 462: /* range_opt */
    case 463: /* every_opt */
    case 464: /* fill_opt */
    case 465: /* twindow_clause_opt */
    case 467: /* having_clause_opt */
    case 468: /* select_item */
    case 470: /* partition_item */
    case 473: /* query_expression */
    case 474: /* query_simple */
    case 476: /* slimit_clause_opt */
    case 477: /* limit_clause_opt */
    case 478: /* union_query_expression */
    case 479: /* query_simple_or_subquery */
    case 481: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy520)); 
}
      break;
    case 337: /* account_options */
    case 338: /* alter_account_options */
    case 340: /* alter_account_option */
    case 359: /* speed_opt */
    case 415: /* bufsize_opt */
{
 
}
      break;
    case 341: /* user_name */
    case 348: /* db_name */
    case 349: /* table_name */
    case 350: /* topic_name */
    case 352: /* dnode_endpoint */
    case 377: /* column_name */
    case 391: /* function_name */
    case 399: /* column_alias */
    case 402: /* index_name */
    case 407: /* sma_func_name */
    case 409: /* cgroup_name */
    case 416: /* language_opt */
    case 417: /* stream_name */
    case 428: /* table_alias */
    case 434: /* star_func */
    case 436: /* noarg_func */
    case 454: /* alias_opt */
{
 
}
      break;
    case 342: /* sysinfo_opt */
{
 
}
      break;
    case 343: /* privileges */
    case 346: /* priv_type_list */
    case 347: /* priv_type */
{
 
}
      break;
    case 344: /* priv_level */
{
 
}
      break;
    case 353: /* force_opt */
    case 354: /* unsafe_opt */
    case 355: /* not_exists_opt */
    case 357: /* exists_opt */
    case 410: /* analyze_opt */
    case 413: /* or_replace_opt */
    case 414: /* agg_func_opt */
    case 422: /* ignore_opt */
    case 459: /* set_quantifier_opt */
{
 
}
      break;
    case 362: /* integer_list */
    case 363: /* variable_list */
    case 364: /* retention_list */
    case 369: /* column_def_list */
    case 370: /* tags_def_opt */
    case 372: /* multi_create_clause */
    case 373: /* tags_def */
    case 374: /* multi_drop_clause */
    case 381: /* specific_cols_opt */
    case 382: /* expression_list */
    case 384: /* col_name_list */
    case 386: /* duration_list */
    case 387: /* rollup_func_list */
    case 397: /* tag_list_opt */
    case 403: /* func_list */
    case 419: /* col_list_opt */
    case 420: /* tag_def_or_ref_opt */
    case 424: /* dnode_list */
    case 427: /* literal_list */
    case 435: /* star_func_para_list */
    case 437: /* other_para_list */
    case 439: /* when_then_list */
    case 460: /* select_list */
    case 461: /* partition_by_clause_opt */
    case 466: /* group_by_clause_opt */
    case 469: /* partition_list */
    case 472: /* group_by_list */
    case 475: /* order_by_clause_opt */
    case 480: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy904)); 
}
      break;
    case 366: /* alter_db_option */
    case 388: /* alter_table_option */
{
 
}
      break;
    case 378: /* type_name */
{
 
}
      break;
    case 444: /* compare_op */
    case 445: /* in_op */
{
 
}
      break;
    case 457: /* join_type */
{
 
}
      break;
    case 471: /* fill_mode */
{
 
}
      break;
    case 482: /* ordering_specification_opt */
{
 
}
      break;
    case 483: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   336,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   336,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   337,  /* (2) account_options ::= */
   337,  /* (3) account_options ::= account_options PPS literal */
   337,  /* (4) account_options ::= account_options TSERIES literal */
   337,  /* (5) account_options ::= account_options STORAGE literal */
   337,  /* (6) account_options ::= account_options STREAMS literal */
   337,  /* (7) account_options ::= account_options QTIME literal */
   337,  /* (8) account_options ::= account_options DBS literal */
   337,  /* (9) account_options ::= account_options USERS literal */
   337,  /* (10) account_options ::= account_options CONNS literal */
   337,  /* (11) account_options ::= account_options STATE literal */
   338,  /* (12) alter_account_options ::= alter_account_option */
   338,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   340,  /* (14) alter_account_option ::= PASS literal */
   340,  /* (15) alter_account_option ::= PPS literal */
   340,  /* (16) alter_account_option ::= TSERIES literal */
   340,  /* (17) alter_account_option ::= STORAGE literal */
   340,  /* (18) alter_account_option ::= STREAMS literal */
   340,  /* (19) alter_account_option ::= QTIME literal */
   340,  /* (20) alter_account_option ::= DBS literal */
   340,  /* (21) alter_account_option ::= USERS literal */
   340,  /* (22) alter_account_option ::= CONNS literal */
   340,  /* (23) alter_account_option ::= STATE literal */
   336,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   336,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   336,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   336,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   336,  /* (28) cmd ::= DROP USER user_name */
   342,  /* (29) sysinfo_opt ::= */
   342,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   336,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   336,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   343,  /* (33) privileges ::= ALL */
   343,  /* (34) privileges ::= priv_type_list */
   343,  /* (35) privileges ::= SUBSCRIBE */
   346,  /* (36) priv_type_list ::= priv_type */
   346,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   347,  /* (38) priv_type ::= READ */
   347,  /* (39) priv_type ::= WRITE */
   344,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   344,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   344,  /* (42) priv_level ::= db_name NK_DOT table_name */
   344,  /* (43) priv_level ::= topic_name */
   345,  /* (44) with_opt ::= */
   345,  /* (45) with_opt ::= WITH search_condition */
   336,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   336,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   336,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   336,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   336,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   336,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   336,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   336,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   336,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   336,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   336,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   352,  /* (57) dnode_endpoint ::= NK_STRING */
   352,  /* (58) dnode_endpoint ::= NK_ID */
   352,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
   353,  /* (60) force_opt ::= */
   353,  /* (61) force_opt ::= FORCE */
   354,  /* (62) unsafe_opt ::= UNSAFE */
   336,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   336,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   336,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   336,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   336,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   336,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   336,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   336,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   336,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   336,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   336,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   336,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   336,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   336,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   336,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   336,  /* (78) cmd ::= USE db_name */
   336,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   336,  /* (80) cmd ::= FLUSH DATABASE db_name */
   336,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   336,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   355,  /* (83) not_exists_opt ::= IF NOT EXISTS */
   355,  /* (84) not_exists_opt ::= */
   357,  /* (85) exists_opt ::= IF EXISTS */
   357,  /* (86) exists_opt ::= */
   356,  /* (87) db_options ::= */
   356,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   356,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   356,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   356,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   356,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   356,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   356,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   356,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   356,  /* (96) db_options ::= db_options KEEP integer_list */
   356,  /* (97) db_options ::= db_options KEEP variable_list */
   356,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   356,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   356,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   356,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   356,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   356,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   356,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   356,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   356,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   356,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   356,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   356,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   356,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   356,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   356,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   356,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   356,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   356,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   356,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   356,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   358,  /* (118) alter_db_options ::= alter_db_option */
   358,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   366,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   366,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   366,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   366,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   366,  /* (124) alter_db_option ::= KEEP integer_list */
   366,  /* (125) alter_db_option ::= KEEP variable_list */
   366,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   366,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   366,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   366,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   366,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   366,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   366,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   366,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   366,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   362,  /* (135) integer_list ::= NK_INTEGER */
   362,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   363,  /* (137) variable_list ::= NK_VARIABLE */
   363,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   364,  /* (139) retention_list ::= retention */
   364,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   367,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   359,  /* (142) speed_opt ::= */
   359,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
   360,  /* (144) start_opt ::= */
   360,  /* (145) start_opt ::= START WITH NK_INTEGER */
   360,  /* (146) start_opt ::= START WITH NK_STRING */
   360,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
   361,  /* (148) end_opt ::= */
   361,  /* (149) end_opt ::= END WITH NK_INTEGER */
   361,  /* (150) end_opt ::= END WITH NK_STRING */
   361,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   336,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   336,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   336,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   336,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   336,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   336,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   336,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   375,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   375,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   375,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   375,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   375,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   375,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   375,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   375,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   375,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   375,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   372,  /* (169) multi_create_clause ::= create_subtable_clause */
   372,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
   380,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   374,  /* (172) multi_drop_clause ::= drop_table_clause */
   374,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   383,  /* (174) drop_table_clause ::= exists_opt full_table_name */
   381,  /* (175) specific_cols_opt ::= */
   381,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   368,  /* (177) full_table_name ::= table_name */
   368,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   369,  /* (179) column_def_list ::= column_def */
   369,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   385,  /* (181) column_def ::= column_name type_name */
   378,  /* (182) type_name ::= BOOL */
   378,  /* (183) type_name ::= TINYINT */
   378,  /* (184) type_name ::= SMALLINT */
   378,  /* (185) type_name ::= INT */
   378,  /* (186) type_name ::= INTEGER */
   378,  /* (187) type_name ::= BIGINT */
   378,  /* (188) type_name ::= FLOAT */
   378,  /* (189) type_name ::= DOUBLE */
   378,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   378,  /* (191) type_name ::= TIMESTAMP */
   378,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   378,  /* (193) type_name ::= TINYINT UNSIGNED */
   378,  /* (194) type_name ::= SMALLINT UNSIGNED */
   378,  /* (195) type_name ::= INT UNSIGNED */
   378,  /* (196) type_name ::= BIGINT UNSIGNED */
   378,  /* (197) type_name ::= JSON */
   378,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   378,  /* (199) type_name ::= MEDIUMBLOB */
   378,  /* (200) type_name ::= BLOB */
   378,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   378,  /* (202) type_name ::= DECIMAL */
   378,  /* (203) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   378,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   370,  /* (205) tags_def_opt ::= */
   370,  /* (206) tags_def_opt ::= tags_def */
   373,  /* (207) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   371,  /* (208) table_options ::= */
   371,  /* (209) table_options ::= table_options COMMENT NK_STRING */
   371,  /* (210) table_options ::= table_options MAX_DELAY duration_list */
   371,  /* (211) table_options ::= table_options WATERMARK duration_list */
   371,  /* (212) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   371,  /* (213) table_options ::= table_options TTL NK_INTEGER */
   371,  /* (214) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   371,  /* (215) table_options ::= table_options DELETE_MARK duration_list */
   376,  /* (216) alter_table_options ::= alter_table_option */
   376,  /* (217) alter_table_options ::= alter_table_options alter_table_option */
   388,  /* (218) alter_table_option ::= COMMENT NK_STRING */
   388,  /* (219) alter_table_option ::= TTL NK_INTEGER */
   386,  /* (220) duration_list ::= duration_literal */
   386,  /* (221) duration_list ::= duration_list NK_COMMA duration_literal */
   387,  /* (222) rollup_func_list ::= rollup_func_name */
   387,  /* (223) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   390,  /* (224) rollup_func_name ::= function_name */
   390,  /* (225) rollup_func_name ::= FIRST */
   390,  /* (226) rollup_func_name ::= LAST */
   384,  /* (227) col_name_list ::= col_name */
   384,  /* (228) col_name_list ::= col_name_list NK_COMMA col_name */
   392,  /* (229) col_name ::= column_name */
   336,  /* (230) cmd ::= SHOW DNODES */
   336,  /* (231) cmd ::= SHOW USERS */
   336,  /* (232) cmd ::= SHOW USER PRIVILEGES */
   336,  /* (233) cmd ::= SHOW DATABASES */
   336,  /* (234) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   336,  /* (235) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   336,  /* (236) cmd ::= SHOW db_name_cond_opt VGROUPS */
   336,  /* (237) cmd ::= SHOW MNODES */
   336,  /* (238) cmd ::= SHOW QNODES */
   336,  /* (239) cmd ::= SHOW FUNCTIONS */
   336,  /* (240) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   336,  /* (241) cmd ::= SHOW STREAMS */
   336,  /* (242) cmd ::= SHOW ACCOUNTS */
   336,  /* (243) cmd ::= SHOW APPS */
   336,  /* (244) cmd ::= SHOW CONNECTIONS */
   336,  /* (245) cmd ::= SHOW LICENCES */
   336,  /* (246) cmd ::= SHOW GRANTS */
   336,  /* (247) cmd ::= SHOW CREATE DATABASE db_name */
   336,  /* (248) cmd ::= SHOW CREATE TABLE full_table_name */
   336,  /* (249) cmd ::= SHOW CREATE STABLE full_table_name */
   336,  /* (250) cmd ::= SHOW QUERIES */
   336,  /* (251) cmd ::= SHOW SCORES */
   336,  /* (252) cmd ::= SHOW TOPICS */
   336,  /* (253) cmd ::= SHOW VARIABLES */
   336,  /* (254) cmd ::= SHOW CLUSTER VARIABLES */
   336,  /* (255) cmd ::= SHOW LOCAL VARIABLES */
   336,  /* (256) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   336,  /* (257) cmd ::= SHOW BNODES */
   336,  /* (258) cmd ::= SHOW SNODES */
   336,  /* (259) cmd ::= SHOW CLUSTER */
   336,  /* (260) cmd ::= SHOW TRANSACTIONS */
   336,  /* (261) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   336,  /* (262) cmd ::= SHOW CONSUMERS */
   336,  /* (263) cmd ::= SHOW SUBSCRIPTIONS */
   336,  /* (264) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   336,  /* (265) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   336,  /* (266) cmd ::= SHOW VNODES NK_INTEGER */
   336,  /* (267) cmd ::= SHOW VNODES NK_STRING */
   336,  /* (268) cmd ::= SHOW db_name_cond_opt ALIVE */
   336,  /* (269) cmd ::= SHOW CLUSTER ALIVE */
   393,  /* (270) db_name_cond_opt ::= */
   393,  /* (271) db_name_cond_opt ::= db_name NK_DOT */
   394,  /* (272) like_pattern_opt ::= */
   394,  /* (273) like_pattern_opt ::= LIKE NK_STRING */
   395,  /* (274) table_name_cond ::= table_name */
   396,  /* (275) from_db_opt ::= */
   396,  /* (276) from_db_opt ::= FROM db_name */
   397,  /* (277) tag_list_opt ::= */
   397,  /* (278) tag_list_opt ::= tag_item */
   397,  /* (279) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   398,  /* (280) tag_item ::= TBNAME */
   398,  /* (281) tag_item ::= QTAGS */
   398,  /* (282) tag_item ::= column_name */
   398,  /* (283) tag_item ::= column_name column_alias */
   398,  /* (284) tag_item ::= column_name AS column_alias */
   336,  /* (285) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   336,  /* (286) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   336,  /* (287) cmd ::= DROP INDEX exists_opt full_index_name */
   400,  /* (288) full_index_name ::= index_name */
   400,  /* (289) full_index_name ::= db_name NK_DOT index_name */
   401,  /* (290) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   401,  /* (291) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   403,  /* (292) func_list ::= func */
   403,  /* (293) func_list ::= func_list NK_COMMA func */
   406,  /* (294) func ::= sma_func_name NK_LP expression_list NK_RP */
   407,  /* (295) sma_func_name ::= function_name */
   407,  /* (296) sma_func_name ::= COUNT */
   407,  /* (297) sma_func_name ::= FIRST */
   407,  /* (298) sma_func_name ::= LAST */
   407,  /* (299) sma_func_name ::= LAST_ROW */
   405,  /* (300) sma_stream_opt ::= */
   405,  /* (301) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   405,  /* (302) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   405,  /* (303) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   336,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   336,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   336,  /* (306) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   336,  /* (307) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   336,  /* (308) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   336,  /* (309) cmd ::= DROP TOPIC exists_opt topic_name */
   336,  /* (310) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   336,  /* (311) cmd ::= DESC full_table_name */
   336,  /* (312) cmd ::= DESCRIBE full_table_name */
   336,  /* (313) cmd ::= RESET QUERY CACHE */
   336,  /* (314) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   336,  /* (315) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   410,  /* (316) analyze_opt ::= */
   410,  /* (317) analyze_opt ::= ANALYZE */
   411,  /* (318) explain_options ::= */
   411,  /* (319) explain_options ::= explain_options VERBOSE NK_BOOL */
   411,  /* (320) explain_options ::= explain_options RATIO NK_FLOAT */
   336,  /* (321) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   336,  /* (322) cmd ::= DROP FUNCTION exists_opt function_name */
   414,  /* (323) agg_func_opt ::= */
   414,  /* (324) agg_func_opt ::= AGGREGATE */
   415,  /* (325) bufsize_opt ::= */
   415,  /* (326) bufsize_opt ::= BUFSIZE NK_INTEGER */
   416,  /* (327) language_opt ::= */
   416,  /* (328) language_opt ::= LANGUAGE NK_STRING */
   413,  /* (329) or_replace_opt ::= */
   413,  /* (330) or_replace_opt ::= OR REPLACE */
   336,  /* (331) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   336,  /* (332) cmd ::= DROP STREAM exists_opt stream_name */
   336,  /* (333) cmd ::= PAUSE STREAM exists_opt stream_name */
   336,  /* (334) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
   419,  /* (335) col_list_opt ::= */
   419,  /* (336) col_list_opt ::= NK_LP col_name_list NK_RP */
   420,  /* (337) tag_def_or_ref_opt ::= */
   420,  /* (338) tag_def_or_ref_opt ::= tags_def */
   420,  /* (339) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   418,  /* (340) stream_options ::= */
   418,  /* (341) stream_options ::= stream_options TRIGGER AT_ONCE */
   418,  /* (342) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   418,  /* (343) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   418,  /* (344) stream_options ::= stream_options WATERMARK duration_literal */
   418,  /* (345) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   418,  /* (346) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   418,  /* (347) stream_options ::= stream_options DELETE_MARK duration_literal */
   418,  /* (348) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   421,  /* (349) subtable_opt ::= */
   421,  /* (350) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   422,  /* (351) ignore_opt ::= */
   422,  /* (352) ignore_opt ::= IGNORE UNTREATED */
   336,  /* (353) cmd ::= KILL CONNECTION NK_INTEGER */
   336,  /* (354) cmd ::= KILL QUERY NK_STRING */
   336,  /* (355) cmd ::= KILL TRANSACTION NK_INTEGER */
   336,  /* (356) cmd ::= BALANCE VGROUP */
   336,  /* (357) cmd ::= BALANCE VGROUP LEADER */
   336,  /* (358) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   336,  /* (359) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   336,  /* (360) cmd ::= SPLIT VGROUP NK_INTEGER */
   424,  /* (361) dnode_list ::= DNODE NK_INTEGER */
   424,  /* (362) dnode_list ::= dnode_list DNODE NK_INTEGER */
   336,  /* (363) cmd ::= DELETE FROM full_table_name where_clause_opt */
   336,  /* (364) cmd ::= query_or_subquery */
   336,  /* (365) cmd ::= insert_query */
   412,  /* (366) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   412,  /* (367) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   339,  /* (368) literal ::= NK_INTEGER */
   339,  /* (369) literal ::= NK_FLOAT */
   339,  /* (370) literal ::= NK_STRING */
   339,  /* (371) literal ::= NK_BOOL */
   339,  /* (372) literal ::= TIMESTAMP NK_STRING */
   339,  /* (373) literal ::= duration_literal */
   339,  /* (374) literal ::= NULL */
   339,  /* (375) literal ::= NK_QUESTION */
   389,  /* (376) duration_literal ::= NK_VARIABLE */
   365,  /* (377) signed ::= NK_INTEGER */
   365,  /* (378) signed ::= NK_PLUS NK_INTEGER */
   365,  /* (379) signed ::= NK_MINUS NK_INTEGER */
   365,  /* (380) signed ::= NK_FLOAT */
   365,  /* (381) signed ::= NK_PLUS NK_FLOAT */
   365,  /* (382) signed ::= NK_MINUS NK_FLOAT */
   379,  /* (383) signed_literal ::= signed */
   379,  /* (384) signed_literal ::= NK_STRING */
   379,  /* (385) signed_literal ::= NK_BOOL */
   379,  /* (386) signed_literal ::= TIMESTAMP NK_STRING */
   379,  /* (387) signed_literal ::= duration_literal */
   379,  /* (388) signed_literal ::= NULL */
   379,  /* (389) signed_literal ::= literal_func */
   379,  /* (390) signed_literal ::= NK_QUESTION */
   427,  /* (391) literal_list ::= signed_literal */
   427,  /* (392) literal_list ::= literal_list NK_COMMA signed_literal */
   348,  /* (393) db_name ::= NK_ID */
   349,  /* (394) table_name ::= NK_ID */
   377,  /* (395) column_name ::= NK_ID */
   391,  /* (396) function_name ::= NK_ID */
   428,  /* (397) table_alias ::= NK_ID */
   399,  /* (398) column_alias ::= NK_ID */
   341,  /* (399) user_name ::= NK_ID */
   350,  /* (400) topic_name ::= NK_ID */
   417,  /* (401) stream_name ::= NK_ID */
   409,  /* (402) cgroup_name ::= NK_ID */
   402,  /* (403) index_name ::= NK_ID */
   429,  /* (404) expr_or_subquery ::= expression */
   423,  /* (405) expression ::= literal */
   423,  /* (406) expression ::= pseudo_column */
   423,  /* (407) expression ::= column_reference */
   423,  /* (408) expression ::= function_expression */
   423,  /* (409) expression ::= case_when_expression */
   423,  /* (410) expression ::= NK_LP expression NK_RP */
   423,  /* (411) expression ::= NK_PLUS expr_or_subquery */
   423,  /* (412) expression ::= NK_MINUS expr_or_subquery */
   423,  /* (413) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   423,  /* (414) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   423,  /* (415) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   423,  /* (416) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   423,  /* (417) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   423,  /* (418) expression ::= column_reference NK_ARROW NK_STRING */
   423,  /* (419) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   423,  /* (420) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   382,  /* (421) expression_list ::= expr_or_subquery */
   382,  /* (422) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   431,  /* (423) column_reference ::= column_name */
   431,  /* (424) column_reference ::= table_name NK_DOT column_name */
   430,  /* (425) pseudo_column ::= ROWTS */
   430,  /* (426) pseudo_column ::= TBNAME */
   430,  /* (427) pseudo_column ::= table_name NK_DOT TBNAME */
   430,  /* (428) pseudo_column ::= QSTART */
   430,  /* (429) pseudo_column ::= QEND */
   430,  /* (430) pseudo_column ::= QDURATION */
   430,  /* (431) pseudo_column ::= WSTART */
   430,  /* (432) pseudo_column ::= WEND */
   430,  /* (433) pseudo_column ::= WDURATION */
   430,  /* (434) pseudo_column ::= IROWTS */
   430,  /* (435) pseudo_column ::= ISFILLED */
   430,  /* (436) pseudo_column ::= QTAGS */
   432,  /* (437) function_expression ::= function_name NK_LP expression_list NK_RP */
   432,  /* (438) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   432,  /* (439) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   432,  /* (440) function_expression ::= literal_func */
   426,  /* (441) literal_func ::= noarg_func NK_LP NK_RP */
   426,  /* (442) literal_func ::= NOW */
   436,  /* (443) noarg_func ::= NOW */
   436,  /* (444) noarg_func ::= TODAY */
   436,  /* (445) noarg_func ::= TIMEZONE */
   436,  /* (446) noarg_func ::= DATABASE */
   436,  /* (447) noarg_func ::= CLIENT_VERSION */
   436,  /* (448) noarg_func ::= SERVER_VERSION */
   436,  /* (449) noarg_func ::= SERVER_STATUS */
   436,  /* (450) noarg_func ::= CURRENT_USER */
   436,  /* (451) noarg_func ::= USER */
   434,  /* (452) star_func ::= COUNT */
   434,  /* (453) star_func ::= FIRST */
   434,  /* (454) star_func ::= LAST */
   434,  /* (455) star_func ::= LAST_ROW */
   435,  /* (456) star_func_para_list ::= NK_STAR */
   435,  /* (457) star_func_para_list ::= other_para_list */
   437,  /* (458) other_para_list ::= star_func_para */
   437,  /* (459) other_para_list ::= other_para_list NK_COMMA star_func_para */
   438,  /* (460) star_func_para ::= expr_or_subquery */
   438,  /* (461) star_func_para ::= table_name NK_DOT NK_STAR */
   433,  /* (462) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   433,  /* (463) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   439,  /* (464) when_then_list ::= when_then_expr */
   439,  /* (465) when_then_list ::= when_then_list when_then_expr */
   442,  /* (466) when_then_expr ::= WHEN common_expression THEN common_expression */
   440,  /* (467) case_when_else_opt ::= */
   440,  /* (468) case_when_else_opt ::= ELSE common_expression */
   443,  /* (469) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   443,  /* (470) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   443,  /* (471) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   443,  /* (472) predicate ::= expr_or_subquery IS NULL */
   443,  /* (473) predicate ::= expr_or_subquery IS NOT NULL */
   443,  /* (474) predicate ::= expr_or_subquery in_op in_predicate_value */
   444,  /* (475) compare_op ::= NK_LT */
   444,  /* (476) compare_op ::= NK_GT */
   444,  /* (477) compare_op ::= NK_LE */
   444,  /* (478) compare_op ::= NK_GE */
   444,  /* (479) compare_op ::= NK_NE */
   444,  /* (480) compare_op ::= NK_EQ */
   444,  /* (481) compare_op ::= LIKE */
   444,  /* (482) compare_op ::= NOT LIKE */
   444,  /* (483) compare_op ::= MATCH */
   444,  /* (484) compare_op ::= NMATCH */
   444,  /* (485) compare_op ::= CONTAINS */
   445,  /* (486) in_op ::= IN */
   445,  /* (487) in_op ::= NOT IN */
   446,  /* (488) in_predicate_value ::= NK_LP literal_list NK_RP */
   447,  /* (489) boolean_value_expression ::= boolean_primary */
   447,  /* (490) boolean_value_expression ::= NOT boolean_primary */
   447,  /* (491) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   447,  /* (492) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   448,  /* (493) boolean_primary ::= predicate */
   448,  /* (494) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   441,  /* (495) common_expression ::= expr_or_subquery */
   441,  /* (496) common_expression ::= boolean_value_expression */
   449,  /* (497) from_clause_opt ::= */
   449,  /* (498) from_clause_opt ::= FROM table_reference_list */
   450,  /* (499) table_reference_list ::= table_reference */
   450,  /* (500) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   451,  /* (501) table_reference ::= table_primary */
   451,  /* (502) table_reference ::= joined_table */
   452,  /* (503) table_primary ::= table_name alias_opt */
   452,  /* (504) table_primary ::= db_name NK_DOT table_name alias_opt */
   452,  /* (505) table_primary ::= subquery alias_opt */
   452,  /* (506) table_primary ::= parenthesized_joined_table */
   454,  /* (507) alias_opt ::= */
   454,  /* (508) alias_opt ::= table_alias */
   454,  /* (509) alias_opt ::= AS table_alias */
   456,  /* (510) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   456,  /* (511) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   453,  /* (512) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   457,  /* (513) join_type ::= */
   457,  /* (514) join_type ::= INNER */
   458,  /* (515) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   459,  /* (516) set_quantifier_opt ::= */
   459,  /* (517) set_quantifier_opt ::= DISTINCT */
   459,  /* (518) set_quantifier_opt ::= ALL */
   460,  /* (519) select_list ::= select_item */
   460,  /* (520) select_list ::= select_list NK_COMMA select_item */
   468,  /* (521) select_item ::= NK_STAR */
   468,  /* (522) select_item ::= common_expression */
   468,  /* (523) select_item ::= common_expression column_alias */
   468,  /* (524) select_item ::= common_expression AS column_alias */
   468,  /* (525) select_item ::= table_name NK_DOT NK_STAR */
   425,  /* (526) where_clause_opt ::= */
   425,  /* (527) where_clause_opt ::= WHERE search_condition */
   461,  /* (528) partition_by_clause_opt ::= */
   461,  /* (529) partition_by_clause_opt ::= PARTITION BY partition_list */
   469,  /* (530) partition_list ::= partition_item */
   469,  /* (531) partition_list ::= partition_list NK_COMMA partition_item */
   470,  /* (532) partition_item ::= expr_or_subquery */
   470,  /* (533) partition_item ::= expr_or_subquery column_alias */
   470,  /* (534) partition_item ::= expr_or_subquery AS column_alias */
   465,  /* (535) twindow_clause_opt ::= */
   465,  /* (536) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   465,  /* (537) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   465,  /* (538) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   465,  /* (539) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   465,  /* (540) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   404,  /* (541) sliding_opt ::= */
   404,  /* (542) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   464,  /* (543) fill_opt ::= */
   464,  /* (544) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   464,  /* (545) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   464,  /* (546) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   471,  /* (547) fill_mode ::= NONE */
   471,  /* (548) fill_mode ::= PREV */
   471,  /* (549) fill_mode ::= NULL */
   471,  /* (550) fill_mode ::= NULL_F */
   471,  /* (551) fill_mode ::= LINEAR */
   471,  /* (552) fill_mode ::= NEXT */
   466,  /* (553) group_by_clause_opt ::= */
   466,  /* (554) group_by_clause_opt ::= GROUP BY group_by_list */
   472,  /* (555) group_by_list ::= expr_or_subquery */
   472,  /* (556) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   467,  /* (557) having_clause_opt ::= */
   467,  /* (558) having_clause_opt ::= HAVING search_condition */
   462,  /* (559) range_opt ::= */
   462,  /* (560) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   463,  /* (561) every_opt ::= */
   463,  /* (562) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   473,  /* (563) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   474,  /* (564) query_simple ::= query_specification */
   474,  /* (565) query_simple ::= union_query_expression */
   478,  /* (566) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   478,  /* (567) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   479,  /* (568) query_simple_or_subquery ::= query_simple */
   479,  /* (569) query_simple_or_subquery ::= subquery */
   408,  /* (570) query_or_subquery ::= query_expression */
   408,  /* (571) query_or_subquery ::= subquery */
   475,  /* (572) order_by_clause_opt ::= */
   475,  /* (573) order_by_clause_opt ::= ORDER BY sort_specification_list */
   476,  /* (574) slimit_clause_opt ::= */
   476,  /* (575) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   476,  /* (576) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   476,  /* (577) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   477,  /* (578) limit_clause_opt ::= */
   477,  /* (579) limit_clause_opt ::= LIMIT NK_INTEGER */
   477,  /* (580) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   477,  /* (581) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   455,  /* (582) subquery ::= NK_LP query_expression NK_RP */
   455,  /* (583) subquery ::= NK_LP subquery NK_RP */
   351,  /* (584) search_condition ::= common_expression */
   480,  /* (585) sort_specification_list ::= sort_specification */
   480,  /* (586) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   481,  /* (587) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   482,  /* (588) ordering_specification_opt ::= */
   482,  /* (589) ordering_specification_opt ::= ASC */
   482,  /* (590) ordering_specification_opt ::= DESC */
   483,  /* (591) null_ordering_opt ::= */
   483,  /* (592) null_ordering_opt ::= NULLS FIRST */
   483,  /* (593) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   -4,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   -4,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (57) dnode_endpoint ::= NK_STRING */
   -1,  /* (58) dnode_endpoint ::= NK_ID */
   -1,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (60) force_opt ::= */
   -1,  /* (61) force_opt ::= FORCE */
   -1,  /* (62) unsafe_opt ::= UNSAFE */
   -3,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (78) cmd ::= USE db_name */
   -4,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (80) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (83) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (84) not_exists_opt ::= */
   -2,  /* (85) exists_opt ::= IF EXISTS */
    0,  /* (86) exists_opt ::= */
    0,  /* (87) db_options ::= */
   -3,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options KEEP integer_list */
   -3,  /* (97) db_options ::= db_options KEEP variable_list */
   -3,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (118) alter_db_options ::= alter_db_option */
   -2,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (124) alter_db_option ::= KEEP integer_list */
   -2,  /* (125) alter_db_option ::= KEEP variable_list */
   -2,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (135) integer_list ::= NK_INTEGER */
   -3,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (137) variable_list ::= NK_VARIABLE */
   -3,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (139) retention_list ::= retention */
   -3,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (142) speed_opt ::= */
   -2,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (144) start_opt ::= */
   -3,  /* (145) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (146) start_opt ::= START WITH NK_STRING */
   -4,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (148) end_opt ::= */
   -3,  /* (149) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (150) end_opt ::= END WITH NK_STRING */
   -4,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (169) multi_create_clause ::= create_subtable_clause */
   -2,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (172) multi_drop_clause ::= drop_table_clause */
   -3,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (174) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (175) specific_cols_opt ::= */
   -3,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (177) full_table_name ::= table_name */
   -3,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (179) column_def_list ::= column_def */
   -3,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (181) column_def ::= column_name type_name */
   -1,  /* (182) type_name ::= BOOL */
   -1,  /* (183) type_name ::= TINYINT */
   -1,  /* (184) type_name ::= SMALLINT */
   -1,  /* (185) type_name ::= INT */
   -1,  /* (186) type_name ::= INTEGER */
   -1,  /* (187) type_name ::= BIGINT */
   -1,  /* (188) type_name ::= FLOAT */
   -1,  /* (189) type_name ::= DOUBLE */
   -4,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (191) type_name ::= TIMESTAMP */
   -4,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (193) type_name ::= TINYINT UNSIGNED */
   -2,  /* (194) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (195) type_name ::= INT UNSIGNED */
   -2,  /* (196) type_name ::= BIGINT UNSIGNED */
   -1,  /* (197) type_name ::= JSON */
   -4,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (199) type_name ::= MEDIUMBLOB */
   -1,  /* (200) type_name ::= BLOB */
   -4,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (202) type_name ::= DECIMAL */
   -4,  /* (203) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (205) tags_def_opt ::= */
   -1,  /* (206) tags_def_opt ::= tags_def */
   -4,  /* (207) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (208) table_options ::= */
   -3,  /* (209) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (210) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (211) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (212) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (213) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (214) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (215) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (216) alter_table_options ::= alter_table_option */
   -2,  /* (217) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (218) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (219) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (220) duration_list ::= duration_literal */
   -3,  /* (221) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (222) rollup_func_list ::= rollup_func_name */
   -3,  /* (223) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (224) rollup_func_name ::= function_name */
   -1,  /* (225) rollup_func_name ::= FIRST */
   -1,  /* (226) rollup_func_name ::= LAST */
   -1,  /* (227) col_name_list ::= col_name */
   -3,  /* (228) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (229) col_name ::= column_name */
   -2,  /* (230) cmd ::= SHOW DNODES */
   -2,  /* (231) cmd ::= SHOW USERS */
   -3,  /* (232) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (233) cmd ::= SHOW DATABASES */
   -4,  /* (234) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (235) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (236) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (237) cmd ::= SHOW MNODES */
   -2,  /* (238) cmd ::= SHOW QNODES */
   -2,  /* (239) cmd ::= SHOW FUNCTIONS */
   -5,  /* (240) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (241) cmd ::= SHOW STREAMS */
   -2,  /* (242) cmd ::= SHOW ACCOUNTS */
   -2,  /* (243) cmd ::= SHOW APPS */
   -2,  /* (244) cmd ::= SHOW CONNECTIONS */
   -2,  /* (245) cmd ::= SHOW LICENCES */
   -2,  /* (246) cmd ::= SHOW GRANTS */
   -4,  /* (247) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (248) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (249) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (250) cmd ::= SHOW QUERIES */
   -2,  /* (251) cmd ::= SHOW SCORES */
   -2,  /* (252) cmd ::= SHOW TOPICS */
   -2,  /* (253) cmd ::= SHOW VARIABLES */
   -3,  /* (254) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (255) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (256) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (257) cmd ::= SHOW BNODES */
   -2,  /* (258) cmd ::= SHOW SNODES */
   -2,  /* (259) cmd ::= SHOW CLUSTER */
   -2,  /* (260) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (261) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (262) cmd ::= SHOW CONSUMERS */
   -2,  /* (263) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (264) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (265) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (266) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (267) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (268) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (269) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (270) db_name_cond_opt ::= */
   -2,  /* (271) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (272) like_pattern_opt ::= */
   -2,  /* (273) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (274) table_name_cond ::= table_name */
    0,  /* (275) from_db_opt ::= */
   -2,  /* (276) from_db_opt ::= FROM db_name */
    0,  /* (277) tag_list_opt ::= */
   -1,  /* (278) tag_list_opt ::= tag_item */
   -3,  /* (279) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (280) tag_item ::= TBNAME */
   -1,  /* (281) tag_item ::= QTAGS */
   -1,  /* (282) tag_item ::= column_name */
   -2,  /* (283) tag_item ::= column_name column_alias */
   -3,  /* (284) tag_item ::= column_name AS column_alias */
   -8,  /* (285) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (286) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (287) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (288) full_index_name ::= index_name */
   -3,  /* (289) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (290) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (291) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (292) func_list ::= func */
   -3,  /* (293) func_list ::= func_list NK_COMMA func */
   -4,  /* (294) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (295) sma_func_name ::= function_name */
   -1,  /* (296) sma_func_name ::= COUNT */
   -1,  /* (297) sma_func_name ::= FIRST */
   -1,  /* (298) sma_func_name ::= LAST */
   -1,  /* (299) sma_func_name ::= LAST_ROW */
    0,  /* (300) sma_stream_opt ::= */
   -3,  /* (301) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (302) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (303) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (306) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (307) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (308) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (309) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (310) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (311) cmd ::= DESC full_table_name */
   -2,  /* (312) cmd ::= DESCRIBE full_table_name */
   -3,  /* (313) cmd ::= RESET QUERY CACHE */
   -4,  /* (314) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (315) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (316) analyze_opt ::= */
   -1,  /* (317) analyze_opt ::= ANALYZE */
    0,  /* (318) explain_options ::= */
   -3,  /* (319) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (320) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (321) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (322) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (323) agg_func_opt ::= */
   -1,  /* (324) agg_func_opt ::= AGGREGATE */
    0,  /* (325) bufsize_opt ::= */
   -2,  /* (326) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (327) language_opt ::= */
   -2,  /* (328) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (329) or_replace_opt ::= */
   -2,  /* (330) or_replace_opt ::= OR REPLACE */
  -12,  /* (331) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (332) cmd ::= DROP STREAM exists_opt stream_name */
   -4,  /* (333) cmd ::= PAUSE STREAM exists_opt stream_name */
   -5,  /* (334) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
    0,  /* (335) col_list_opt ::= */
   -3,  /* (336) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (337) tag_def_or_ref_opt ::= */
   -1,  /* (338) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (339) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (340) stream_options ::= */
   -3,  /* (341) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (342) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (343) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (344) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (345) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (346) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (347) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (348) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (349) subtable_opt ::= */
   -4,  /* (350) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
    0,  /* (351) ignore_opt ::= */
   -2,  /* (352) ignore_opt ::= IGNORE UNTREATED */
   -3,  /* (353) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (354) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (355) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (356) cmd ::= BALANCE VGROUP */
   -3,  /* (357) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (358) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (359) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (360) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (361) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (362) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (363) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (364) cmd ::= query_or_subquery */
   -1,  /* (365) cmd ::= insert_query */
   -7,  /* (366) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (367) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (368) literal ::= NK_INTEGER */
   -1,  /* (369) literal ::= NK_FLOAT */
   -1,  /* (370) literal ::= NK_STRING */
   -1,  /* (371) literal ::= NK_BOOL */
   -2,  /* (372) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (373) literal ::= duration_literal */
   -1,  /* (374) literal ::= NULL */
   -1,  /* (375) literal ::= NK_QUESTION */
   -1,  /* (376) duration_literal ::= NK_VARIABLE */
   -1,  /* (377) signed ::= NK_INTEGER */
   -2,  /* (378) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (379) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (380) signed ::= NK_FLOAT */
   -2,  /* (381) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (382) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (383) signed_literal ::= signed */
   -1,  /* (384) signed_literal ::= NK_STRING */
   -1,  /* (385) signed_literal ::= NK_BOOL */
   -2,  /* (386) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (387) signed_literal ::= duration_literal */
   -1,  /* (388) signed_literal ::= NULL */
   -1,  /* (389) signed_literal ::= literal_func */
   -1,  /* (390) signed_literal ::= NK_QUESTION */
   -1,  /* (391) literal_list ::= signed_literal */
   -3,  /* (392) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (393) db_name ::= NK_ID */
   -1,  /* (394) table_name ::= NK_ID */
   -1,  /* (395) column_name ::= NK_ID */
   -1,  /* (396) function_name ::= NK_ID */
   -1,  /* (397) table_alias ::= NK_ID */
   -1,  /* (398) column_alias ::= NK_ID */
   -1,  /* (399) user_name ::= NK_ID */
   -1,  /* (400) topic_name ::= NK_ID */
   -1,  /* (401) stream_name ::= NK_ID */
   -1,  /* (402) cgroup_name ::= NK_ID */
   -1,  /* (403) index_name ::= NK_ID */
   -1,  /* (404) expr_or_subquery ::= expression */
   -1,  /* (405) expression ::= literal */
   -1,  /* (406) expression ::= pseudo_column */
   -1,  /* (407) expression ::= column_reference */
   -1,  /* (408) expression ::= function_expression */
   -1,  /* (409) expression ::= case_when_expression */
   -3,  /* (410) expression ::= NK_LP expression NK_RP */
   -2,  /* (411) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (412) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (413) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (414) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (415) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (416) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (417) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (418) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (419) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (420) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (421) expression_list ::= expr_or_subquery */
   -3,  /* (422) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (423) column_reference ::= column_name */
   -3,  /* (424) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (425) pseudo_column ::= ROWTS */
   -1,  /* (426) pseudo_column ::= TBNAME */
   -3,  /* (427) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (428) pseudo_column ::= QSTART */
   -1,  /* (429) pseudo_column ::= QEND */
   -1,  /* (430) pseudo_column ::= QDURATION */
   -1,  /* (431) pseudo_column ::= WSTART */
   -1,  /* (432) pseudo_column ::= WEND */
   -1,  /* (433) pseudo_column ::= WDURATION */
   -1,  /* (434) pseudo_column ::= IROWTS */
   -1,  /* (435) pseudo_column ::= ISFILLED */
   -1,  /* (436) pseudo_column ::= QTAGS */
   -4,  /* (437) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (438) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (439) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (440) function_expression ::= literal_func */
   -3,  /* (441) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (442) literal_func ::= NOW */
   -1,  /* (443) noarg_func ::= NOW */
   -1,  /* (444) noarg_func ::= TODAY */
   -1,  /* (445) noarg_func ::= TIMEZONE */
   -1,  /* (446) noarg_func ::= DATABASE */
   -1,  /* (447) noarg_func ::= CLIENT_VERSION */
   -1,  /* (448) noarg_func ::= SERVER_VERSION */
   -1,  /* (449) noarg_func ::= SERVER_STATUS */
   -1,  /* (450) noarg_func ::= CURRENT_USER */
   -1,  /* (451) noarg_func ::= USER */
   -1,  /* (452) star_func ::= COUNT */
   -1,  /* (453) star_func ::= FIRST */
   -1,  /* (454) star_func ::= LAST */
   -1,  /* (455) star_func ::= LAST_ROW */
   -1,  /* (456) star_func_para_list ::= NK_STAR */
   -1,  /* (457) star_func_para_list ::= other_para_list */
   -1,  /* (458) other_para_list ::= star_func_para */
   -3,  /* (459) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (460) star_func_para ::= expr_or_subquery */
   -3,  /* (461) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (462) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (463) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (464) when_then_list ::= when_then_expr */
   -2,  /* (465) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (466) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (467) case_when_else_opt ::= */
   -2,  /* (468) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (469) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (470) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (471) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (472) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (473) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (474) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (475) compare_op ::= NK_LT */
   -1,  /* (476) compare_op ::= NK_GT */
   -1,  /* (477) compare_op ::= NK_LE */
   -1,  /* (478) compare_op ::= NK_GE */
   -1,  /* (479) compare_op ::= NK_NE */
   -1,  /* (480) compare_op ::= NK_EQ */
   -1,  /* (481) compare_op ::= LIKE */
   -2,  /* (482) compare_op ::= NOT LIKE */
   -1,  /* (483) compare_op ::= MATCH */
   -1,  /* (484) compare_op ::= NMATCH */
   -1,  /* (485) compare_op ::= CONTAINS */
   -1,  /* (486) in_op ::= IN */
   -2,  /* (487) in_op ::= NOT IN */
   -3,  /* (488) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (489) boolean_value_expression ::= boolean_primary */
   -2,  /* (490) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (491) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (492) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (493) boolean_primary ::= predicate */
   -3,  /* (494) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (495) common_expression ::= expr_or_subquery */
   -1,  /* (496) common_expression ::= boolean_value_expression */
    0,  /* (497) from_clause_opt ::= */
   -2,  /* (498) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (499) table_reference_list ::= table_reference */
   -3,  /* (500) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (501) table_reference ::= table_primary */
   -1,  /* (502) table_reference ::= joined_table */
   -2,  /* (503) table_primary ::= table_name alias_opt */
   -4,  /* (504) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (505) table_primary ::= subquery alias_opt */
   -1,  /* (506) table_primary ::= parenthesized_joined_table */
    0,  /* (507) alias_opt ::= */
   -1,  /* (508) alias_opt ::= table_alias */
   -2,  /* (509) alias_opt ::= AS table_alias */
   -3,  /* (510) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (511) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (512) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (513) join_type ::= */
   -1,  /* (514) join_type ::= INNER */
  -12,  /* (515) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (516) set_quantifier_opt ::= */
   -1,  /* (517) set_quantifier_opt ::= DISTINCT */
   -1,  /* (518) set_quantifier_opt ::= ALL */
   -1,  /* (519) select_list ::= select_item */
   -3,  /* (520) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (521) select_item ::= NK_STAR */
   -1,  /* (522) select_item ::= common_expression */
   -2,  /* (523) select_item ::= common_expression column_alias */
   -3,  /* (524) select_item ::= common_expression AS column_alias */
   -3,  /* (525) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (526) where_clause_opt ::= */
   -2,  /* (527) where_clause_opt ::= WHERE search_condition */
    0,  /* (528) partition_by_clause_opt ::= */
   -3,  /* (529) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (530) partition_list ::= partition_item */
   -3,  /* (531) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (532) partition_item ::= expr_or_subquery */
   -2,  /* (533) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (534) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (535) twindow_clause_opt ::= */
   -6,  /* (536) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (537) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (538) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (539) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (540) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (541) sliding_opt ::= */
   -4,  /* (542) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (543) fill_opt ::= */
   -4,  /* (544) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (545) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (546) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (547) fill_mode ::= NONE */
   -1,  /* (548) fill_mode ::= PREV */
   -1,  /* (549) fill_mode ::= NULL */
   -1,  /* (550) fill_mode ::= NULL_F */
   -1,  /* (551) fill_mode ::= LINEAR */
   -1,  /* (552) fill_mode ::= NEXT */
    0,  /* (553) group_by_clause_opt ::= */
   -3,  /* (554) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (555) group_by_list ::= expr_or_subquery */
   -3,  /* (556) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (557) having_clause_opt ::= */
   -2,  /* (558) having_clause_opt ::= HAVING search_condition */
    0,  /* (559) range_opt ::= */
   -6,  /* (560) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (561) every_opt ::= */
   -4,  /* (562) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (563) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (564) query_simple ::= query_specification */
   -1,  /* (565) query_simple ::= union_query_expression */
   -4,  /* (566) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (567) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (568) query_simple_or_subquery ::= query_simple */
   -1,  /* (569) query_simple_or_subquery ::= subquery */
   -1,  /* (570) query_or_subquery ::= query_expression */
   -1,  /* (571) query_or_subquery ::= subquery */
    0,  /* (572) order_by_clause_opt ::= */
   -3,  /* (573) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (574) slimit_clause_opt ::= */
   -2,  /* (575) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (576) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (577) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (578) limit_clause_opt ::= */
   -2,  /* (579) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (580) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (581) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (582) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (583) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (584) search_condition ::= common_expression */
   -1,  /* (585) sort_specification_list ::= sort_specification */
   -3,  /* (586) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (587) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (588) ordering_specification_opt ::= */
   -1,  /* (589) ordering_specification_opt ::= ASC */
   -1,  /* (590) ordering_specification_opt ::= DESC */
    0,  /* (591) null_ordering_opt ::= */
   -2,  /* (592) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (593) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,337,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,338,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,337,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,339,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,340,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,338,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,340,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,339,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy833, &yymsp[-1].minor.yy0, yymsp[0].minor.yy575); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy833, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy833, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy833, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy833); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy575 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy575 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy85, &yymsp[-3].minor.yy489, &yymsp[0].minor.yy833, yymsp[-2].minor.yy520); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy85, &yymsp[-3].minor.yy489, &yymsp[0].minor.yy833, yymsp[-2].minor.yy520); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy85 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy85 = yymsp[0].minor.yy85; }
  yymsp[0].minor.yy85 = yylhsminor.yy85;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy85 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy85 = yymsp[-2].minor.yy85 | yymsp[0].minor.yy85; }
  yymsp[-2].minor.yy85 = yylhsminor.yy85;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy85 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy85 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy489.first = yymsp[-2].minor.yy0; yylhsminor.yy489.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy489 = yylhsminor.yy489;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy489.first = yymsp[-2].minor.yy833; yylhsminor.yy489.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy489 = yylhsminor.yy489;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy489.first = yymsp[-2].minor.yy833; yylhsminor.yy489.second = yymsp[0].minor.yy833; }
  yymsp[-2].minor.yy489 = yylhsminor.yy489;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy489.first = yymsp[0].minor.yy833; yylhsminor.yy489.second = nil_token; }
  yymsp[0].minor.yy489 = yylhsminor.yy489;
        break;
      case 44: /* with_opt ::= */
      case 144: /* start_opt ::= */ yytestcase(yyruleno==144);
      case 148: /* end_opt ::= */ yytestcase(yyruleno==148);
      case 272: /* like_pattern_opt ::= */ yytestcase(yyruleno==272);
      case 349: /* subtable_opt ::= */ yytestcase(yyruleno==349);
      case 467: /* case_when_else_opt ::= */ yytestcase(yyruleno==467);
      case 497: /* from_clause_opt ::= */ yytestcase(yyruleno==497);
      case 526: /* where_clause_opt ::= */ yytestcase(yyruleno==526);
      case 535: /* twindow_clause_opt ::= */ yytestcase(yyruleno==535);
      case 541: /* sliding_opt ::= */ yytestcase(yyruleno==541);
      case 543: /* fill_opt ::= */ yytestcase(yyruleno==543);
      case 557: /* having_clause_opt ::= */ yytestcase(yyruleno==557);
      case 559: /* range_opt ::= */ yytestcase(yyruleno==559);
      case 561: /* every_opt ::= */ yytestcase(yyruleno==561);
      case 574: /* slimit_clause_opt ::= */ yytestcase(yyruleno==574);
      case 578: /* limit_clause_opt ::= */ yytestcase(yyruleno==578);
{ yymsp[1].minor.yy520 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 498: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==498);
      case 527: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==527);
      case 558: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==558);
{ yymsp[-1].minor.yy520 = yymsp[0].minor.yy520; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy833, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy537, false); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy833, yymsp[0].minor.yy537, false); }
        break;
      case 50: /* cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, false, yymsp[0].minor.yy537); }
        break;
      case 51: /* cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy833, false, yymsp[0].minor.yy537); }
        break;
      case 52: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= RESTORE DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* dnode_endpoint ::= NK_STRING */
      case 58: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==58);
      case 59: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==59);
      case 296: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==296);
      case 297: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==297);
      case 298: /* sma_func_name ::= LAST */ yytestcase(yyruleno==298);
      case 299: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==299);
      case 393: /* db_name ::= NK_ID */ yytestcase(yyruleno==393);
      case 394: /* table_name ::= NK_ID */ yytestcase(yyruleno==394);
      case 395: /* column_name ::= NK_ID */ yytestcase(yyruleno==395);
      case 396: /* function_name ::= NK_ID */ yytestcase(yyruleno==396);
      case 397: /* table_alias ::= NK_ID */ yytestcase(yyruleno==397);
      case 398: /* column_alias ::= NK_ID */ yytestcase(yyruleno==398);
      case 399: /* user_name ::= NK_ID */ yytestcase(yyruleno==399);
      case 400: /* topic_name ::= NK_ID */ yytestcase(yyruleno==400);
      case 401: /* stream_name ::= NK_ID */ yytestcase(yyruleno==401);
      case 402: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==402);
      case 403: /* index_name ::= NK_ID */ yytestcase(yyruleno==403);
      case 443: /* noarg_func ::= NOW */ yytestcase(yyruleno==443);
      case 444: /* noarg_func ::= TODAY */ yytestcase(yyruleno==444);
      case 445: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==445);
      case 446: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==446);
      case 447: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==447);
      case 448: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==448);
      case 449: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==449);
      case 450: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==450);
      case 451: /* noarg_func ::= USER */ yytestcase(yyruleno==451);
      case 452: /* star_func ::= COUNT */ yytestcase(yyruleno==452);
      case 453: /* star_func ::= FIRST */ yytestcase(yyruleno==453);
      case 454: /* star_func ::= LAST */ yytestcase(yyruleno==454);
      case 455: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==455);
{ yylhsminor.yy833 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy833 = yylhsminor.yy833;
        break;
      case 60: /* force_opt ::= */
      case 84: /* not_exists_opt ::= */ yytestcase(yyruleno==84);
      case 86: /* exists_opt ::= */ yytestcase(yyruleno==86);
      case 316: /* analyze_opt ::= */ yytestcase(yyruleno==316);
      case 323: /* agg_func_opt ::= */ yytestcase(yyruleno==323);
      case 329: /* or_replace_opt ::= */ yytestcase(yyruleno==329);
      case 351: /* ignore_opt ::= */ yytestcase(yyruleno==351);
      case 516: /* set_quantifier_opt ::= */ yytestcase(yyruleno==516);
{ yymsp[1].minor.yy537 = false; }
        break;
      case 61: /* force_opt ::= FORCE */
      case 62: /* unsafe_opt ::= UNSAFE */ yytestcase(yyruleno==62);
      case 317: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==317);
      case 324: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==324);
      case 517: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==517);
{ yymsp[0].minor.yy537 = true; }
        break;
      case 63: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 64: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 70: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 71: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 72: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 73: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 74: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 75: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 76: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy537, &yymsp[-1].minor.yy833, yymsp[0].minor.yy520); }
        break;
      case 77: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy537, &yymsp[0].minor.yy833); }
        break;
      case 78: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy833); }
        break;
      case 79: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy833, yymsp[0].minor.yy520); }
        break;
      case 80: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy833); }
        break;
      case 81: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy833, yymsp[0].minor.yy860); }
        break;
      case 82: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy833, yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 83: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy537 = true; }
        break;
      case 85: /* exists_opt ::= IF EXISTS */
      case 330: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==330);
      case 352: /* ignore_opt ::= IGNORE UNTREATED */ yytestcase(yyruleno==352);
{ yymsp[-1].minor.yy537 = true; }
        break;
      case 87: /* db_options ::= */
{ yymsp[1].minor.yy520 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 88: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 89: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 90: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 91: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 92: /* db_options ::= db_options DURATION NK_INTEGER */
      case 93: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==93);
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 94: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 95: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 96: /* db_options ::= db_options KEEP integer_list */
      case 97: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==97);
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_KEEP, yymsp[0].minor.yy904); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 98: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 99: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 100: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 101: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 102: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 103: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 104: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 105: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_RETENTIONS, yymsp[0].minor.yy904); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 106: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 107: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 108: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 110: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-3].minor.yy520, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 111: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 112: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-3].minor.yy520, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 113: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 114: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 115: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 116: /* db_options ::= db_options TABLE_PREFIX signed */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 117: /* db_options ::= db_options TABLE_SUFFIX signed */
{ yylhsminor.yy520 = setDatabaseOption(pCxt, yymsp[-2].minor.yy520, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 118: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy520 = createAlterDatabaseOptions(pCxt); yylhsminor.yy520 = setAlterDatabaseOption(pCxt, yylhsminor.yy520, &yymsp[0].minor.yy805); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 119: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy520 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy520, &yymsp[0].minor.yy805); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 120: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy805.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= KEEP integer_list */
      case 125: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==125);
{ yymsp[-1].minor.yy805.type = DB_OPTION_KEEP; yymsp[-1].minor.yy805.pList = yymsp[0].minor.yy904; }
        break;
      case 126: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_PAGES; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 128: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_WAL; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 129: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 130: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 132: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy805.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy805.val = t;
                                                                                  }
        break;
      case 133: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy805.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 134: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy805.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy805.val = t;
                                                                                  }
        break;
      case 135: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy904 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy904 = yylhsminor.yy904;
        break;
      case 136: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 362: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==362);
{ yylhsminor.yy904 = addNodeToList(pCxt, yymsp[-2].minor.yy904, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy904 = yylhsminor.yy904;
        break;
      case 137: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy904 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy904 = yylhsminor.yy904;
        break;
      case 138: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy904 = addNodeToList(pCxt, yymsp[-2].minor.yy904, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy904 = yylhsminor.yy904;
        break;
      case 139: /* retention_list ::= retention */
      case 169: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==169);
      case 172: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==172);
      case 179: /* column_def_list ::= column_def */ yytestcase(yyruleno==179);
      case 222: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==222);
      case 227: /* col_name_list ::= col_name */ yytestcase(yyruleno==227);
      case 278: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==278);
      case 292: /* func_list ::= func */ yytestcase(yyruleno==292);
      case 391: /* literal_list ::= signed_literal */ yytestcase(yyruleno==391);
      case 458: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==458);
      case 464: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==464);
      case 519: /* select_list ::= select_item */ yytestcase(yyruleno==519);
      case 530: /* partition_list ::= partition_item */ yytestcase(yyruleno==530);
      case 585: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==585);
{ yylhsminor.yy904 = createNodeList(pCxt, yymsp[0].minor.yy520); }
  yymsp[0].minor.yy904 = yylhsminor.yy904;
        break;
      case 140: /* retention_list ::= retention_list NK_COMMA retention */
      case 173: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==173);
      case 180: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==180);
      case 223: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==223);
      case 228: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==228);
      case 279: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==279);
      case 293: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==293);
      case 392: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==392);
      case 459: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==459);
      case 520: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==520);
      case 531: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==531);
      case 586: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==586);
{ yylhsminor.yy904 = addNodeToList(pCxt, yymsp[-2].minor.yy904, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy904 = yylhsminor.yy904;
        break;
      case 141: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy520 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 142: /* speed_opt ::= */
      case 325: /* bufsize_opt ::= */ yytestcase(yyruleno==325);
{ yymsp[1].minor.yy860 = 0; }
        break;
      case 143: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 326: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==326);
{ yymsp[-1].minor.yy860 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 145: /* start_opt ::= START WITH NK_INTEGER */
      case 149: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==149);
{ yymsp[-2].minor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 146: /* start_opt ::= START WITH NK_STRING */
      case 150: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==150);
{ yymsp[-2].minor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 147: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 151: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==151);
{ yymsp[-3].minor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 152: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 154: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==154);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy537, yymsp[-5].minor.yy520, yymsp[-3].minor.yy904, yymsp[-1].minor.yy904, yymsp[0].minor.yy520); }
        break;
      case 153: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy904); }
        break;
      case 155: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy904); }
        break;
      case 156: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy537, yymsp[0].minor.yy520); }
        break;
      case 157: /* cmd ::= ALTER TABLE alter_table_clause */
      case 364: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==364);
      case 365: /* cmd ::= insert_query */ yytestcase(yyruleno==365);
{ pCxt->pRootNode = yymsp[0].minor.yy520; }
        break;
      case 158: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy520); }
        break;
      case 159: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy520 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 160: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy520 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy520, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy833, yymsp[0].minor.yy840); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 161: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy520 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy520, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy833); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 162: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy520 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy520, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy833, yymsp[0].minor.yy840); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 163: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy520 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy520, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy833, &yymsp[0].minor.yy833); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 164: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy520 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy520, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy833, yymsp[0].minor.yy840); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 165: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy520 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy520, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy833); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 166: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy520 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy520, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy833, yymsp[0].minor.yy840); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 167: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy520 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy520, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy833, &yymsp[0].minor.yy833); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 168: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy520 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy520, &yymsp[-2].minor.yy833, yymsp[0].minor.yy520); }
  yymsp[-5].minor.yy520 = yylhsminor.yy520;
        break;
      case 170: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 465: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==465);
{ yylhsminor.yy904 = addNodeToList(pCxt, yymsp[-1].minor.yy904, yymsp[0].minor.yy520); }
  yymsp[-1].minor.yy904 = yylhsminor.yy904;
        break;
      case 171: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy520 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy537, yymsp[-8].minor.yy520, yymsp[-6].minor.yy520, yymsp[-5].minor.yy904, yymsp[-2].minor.yy904, yymsp[0].minor.yy520); }
  yymsp[-9].minor.yy520 = yylhsminor.yy520;
        break;
      case 174: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy520 = createDropTableClause(pCxt, yymsp[-1].minor.yy537, yymsp[0].minor.yy520); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 175: /* specific_cols_opt ::= */
      case 205: /* tags_def_opt ::= */ yytestcase(yyruleno==205);
      case 277: /* tag_list_opt ::= */ yytestcase(yyruleno==277);
      case 335: /* col_list_opt ::= */ yytestcase(yyruleno==335);
      case 337: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==337);
      case 528: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==528);
      case 553: /* group_by_clause_opt ::= */ yytestcase(yyruleno==553);
      case 572: /* order_by_clause_opt ::= */ yytestcase(yyruleno==572);
{ yymsp[1].minor.yy904 = NULL; }
        break;
      case 176: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 336: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==336);
{ yymsp[-2].minor.yy904 = yymsp[-1].minor.yy904; }
        break;
      case 177: /* full_table_name ::= table_name */
{ yylhsminor.yy520 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy833, NULL); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 178: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy520 = createRealTableNode(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy833, NULL); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 181: /* column_def ::= column_name type_name */
{ yylhsminor.yy520 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy833, yymsp[0].minor.yy840, NULL); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 182: /* type_name ::= BOOL */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 183: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 184: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 185: /* type_name ::= INT */
      case 186: /* type_name ::= INTEGER */ yytestcase(yyruleno==186);
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 187: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 188: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 189: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 190: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy840 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 191: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 192: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy840 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 193: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy840 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 194: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy840 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 195: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy840 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 196: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy840 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 197: /* type_name ::= JSON */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 198: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy840 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 199: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 200: /* type_name ::= BLOB */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 201: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy840 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 202: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy840 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 203: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy840 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 204: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy840 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 206: /* tags_def_opt ::= tags_def */
      case 338: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==338);
      case 457: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==457);
{ yylhsminor.yy904 = yymsp[0].minor.yy904; }
  yymsp[0].minor.yy904 = yylhsminor.yy904;
        break;
      case 207: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 339: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==339);
{ yymsp[-3].minor.yy904 = yymsp[-1].minor.yy904; }
        break;
      case 208: /* table_options ::= */
{ yymsp[1].minor.yy520 = createDefaultTableOptions(pCxt); }
        break;
      case 209: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-2].minor.yy520, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 210: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-2].minor.yy520, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy904); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 211: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-2].minor.yy520, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy904); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 212: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-4].minor.yy520, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy904); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 213: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-2].minor.yy520, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 214: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-4].minor.yy520, TABLE_OPTION_SMA, yymsp[-1].minor.yy904); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 215: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-2].minor.yy520, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy904); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 216: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy520 = createAlterTableOptions(pCxt); yylhsminor.yy520 = setTableOption(pCxt, yylhsminor.yy520, yymsp[0].minor.yy805.type, &yymsp[0].minor.yy805.val); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 217: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy520 = setTableOption(pCxt, yymsp[-1].minor.yy520, yymsp[0].minor.yy805.type, &yymsp[0].minor.yy805.val); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 218: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy805.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 219: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy805.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy805.val = yymsp[0].minor.yy0; }
        break;
      case 220: /* duration_list ::= duration_literal */
      case 421: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==421);
{ yylhsminor.yy904 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy520)); }
  yymsp[0].minor.yy904 = yylhsminor.yy904;
        break;
      case 221: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 422: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==422);
{ yylhsminor.yy904 = addNodeToList(pCxt, yymsp[-2].minor.yy904, releaseRawExprNode(pCxt, yymsp[0].minor.yy520)); }
  yymsp[-2].minor.yy904 = yylhsminor.yy904;
        break;
      case 224: /* rollup_func_name ::= function_name */
{ yylhsminor.yy520 = createFunctionNode(pCxt, &yymsp[0].minor.yy833, NULL); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 225: /* rollup_func_name ::= FIRST */
      case 226: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==226);
      case 281: /* tag_item ::= QTAGS */ yytestcase(yyruleno==281);
{ yylhsminor.yy520 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 229: /* col_name ::= column_name */
      case 282: /* tag_item ::= column_name */ yytestcase(yyruleno==282);
{ yylhsminor.yy520 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy833); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 230: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 231: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 232: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 234: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy520, yymsp[0].minor.yy520, OP_TYPE_LIKE); }
        break;
      case 235: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy520, yymsp[0].minor.yy520, OP_TYPE_LIKE); }
        break;
      case 236: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy520, NULL, OP_TYPE_LIKE); }
        break;
      case 237: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 238: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 239: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 240: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy520, yymsp[-1].minor.yy520, OP_TYPE_EQUAL); }
        break;
      case 241: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 242: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 243: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 244: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 245: /* cmd ::= SHOW LICENCES */
      case 246: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==246);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 247: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy833); }
        break;
      case 248: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy520); }
        break;
      case 249: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy520); }
        break;
      case 250: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 251: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 252: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 253: /* cmd ::= SHOW VARIABLES */
      case 254: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==254);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 255: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 256: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy520); }
        break;
      case 257: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 258: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 259: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 260: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 261: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy520); }
        break;
      case 262: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 263: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 264: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy520, yymsp[-1].minor.yy520, OP_TYPE_EQUAL); }
        break;
      case 265: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy520, yymsp[0].minor.yy520, yymsp[-3].minor.yy904); }
        break;
      case 266: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 267: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 268: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy520,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 269: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 270: /* db_name_cond_opt ::= */
      case 275: /* from_db_opt ::= */ yytestcase(yyruleno==275);
{ yymsp[1].minor.yy520 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 271: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy520 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy833); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 273: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 274: /* table_name_cond ::= table_name */
{ yylhsminor.yy520 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy833); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 276: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy520 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy833); }
        break;
      case 280: /* tag_item ::= TBNAME */
{ yylhsminor.yy520 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 283: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy520 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy833), &yymsp[0].minor.yy833); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 284: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy520 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy833), &yymsp[0].minor.yy833); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 285: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy537, yymsp[-3].minor.yy520, yymsp[-1].minor.yy520, NULL, yymsp[0].minor.yy520); }
        break;
      case 286: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy537, yymsp[-5].minor.yy520, yymsp[-3].minor.yy520, yymsp[-1].minor.yy904, NULL); }
        break;
      case 287: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy537, yymsp[0].minor.yy520); }
        break;
      case 288: /* full_index_name ::= index_name */
{ yylhsminor.yy520 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy833); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 289: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy520 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy833); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 290: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy520 = createIndexOption(pCxt, yymsp[-7].minor.yy904, releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), NULL, yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 291: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy520 = createIndexOption(pCxt, yymsp[-9].minor.yy904, releaseRawExprNode(pCxt, yymsp[-5].minor.yy520), releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 294: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy520 = createFunctionNode(pCxt, &yymsp[-3].minor.yy833, yymsp[-1].minor.yy904); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 295: /* sma_func_name ::= function_name */
      case 508: /* alias_opt ::= table_alias */ yytestcase(yyruleno==508);
{ yylhsminor.yy833 = yymsp[0].minor.yy833; }
  yymsp[0].minor.yy833 = yylhsminor.yy833;
        break;
      case 300: /* sma_stream_opt ::= */
      case 340: /* stream_options ::= */ yytestcase(yyruleno==340);
{ yymsp[1].minor.yy520 = createStreamOptions(pCxt); }
        break;
      case 301: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy520)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy520); yylhsminor.yy520 = yymsp[-2].minor.yy520; }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 302: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy520)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy520); yylhsminor.yy520 = yymsp[-2].minor.yy520; }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 303: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy520)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy520); yylhsminor.yy520 = yymsp[-2].minor.yy520; }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 304: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy537, &yymsp[-2].minor.yy833, yymsp[0].minor.yy520); }
        break;
      case 305: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy537, &yymsp[-3].minor.yy833, &yymsp[0].minor.yy833, false); }
        break;
      case 306: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy537, &yymsp[-5].minor.yy833, &yymsp[0].minor.yy833, true); }
        break;
      case 307: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy537, &yymsp[-3].minor.yy833, yymsp[0].minor.yy520, false); }
        break;
      case 308: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy537, &yymsp[-5].minor.yy833, yymsp[0].minor.yy520, true); }
        break;
      case 309: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy537, &yymsp[0].minor.yy833); }
        break;
      case 310: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy537, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy833); }
        break;
      case 311: /* cmd ::= DESC full_table_name */
      case 312: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==312);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy520); }
        break;
      case 313: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 314: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 315: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==315);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy537, yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 318: /* explain_options ::= */
{ yymsp[1].minor.yy520 = createDefaultExplainOptions(pCxt); }
        break;
      case 319: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy520 = setExplainVerbose(pCxt, yymsp[-2].minor.yy520, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 320: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy520 = setExplainRatio(pCxt, yymsp[-2].minor.yy520, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 321: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy537, yymsp[-9].minor.yy537, &yymsp[-6].minor.yy833, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy840, yymsp[-1].minor.yy860, &yymsp[0].minor.yy833, yymsp[-10].minor.yy537); }
        break;
      case 322: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy537, &yymsp[0].minor.yy833); }
        break;
      case 327: /* language_opt ::= */
{ yymsp[1].minor.yy833 = nil_token; }
        break;
      case 328: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy833 = yymsp[0].minor.yy0; }
        break;
      case 331: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy537, &yymsp[-8].minor.yy833, yymsp[-5].minor.yy520, yymsp[-7].minor.yy520, yymsp[-3].minor.yy904, yymsp[-2].minor.yy520, yymsp[0].minor.yy520, yymsp[-4].minor.yy904); }
        break;
      case 332: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy537, &yymsp[0].minor.yy833); }
        break;
      case 333: /* cmd ::= PAUSE STREAM exists_opt stream_name */
{ pCxt->pRootNode = createPauseStreamStmt(pCxt, yymsp[-1].minor.yy537, &yymsp[0].minor.yy833); }
        break;
      case 334: /* cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
{ pCxt->pRootNode = createResumeStreamStmt(pCxt, yymsp[-2].minor.yy537, yymsp[-1].minor.yy537, &yymsp[0].minor.yy833); }
        break;
      case 341: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 342: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==342);
{ yylhsminor.yy520 = setStreamOptions(pCxt, yymsp[-2].minor.yy520, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 343: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy520 = setStreamOptions(pCxt, yymsp[-3].minor.yy520, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy520)); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 344: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy520 = setStreamOptions(pCxt, yymsp[-2].minor.yy520, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy520)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 345: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy520 = setStreamOptions(pCxt, yymsp[-3].minor.yy520, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 346: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy520 = setStreamOptions(pCxt, yymsp[-2].minor.yy520, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 347: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy520 = setStreamOptions(pCxt, yymsp[-2].minor.yy520, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy520)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 348: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy520 = setStreamOptions(pCxt, yymsp[-3].minor.yy520, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 350: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 542: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==542);
      case 562: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==562);
{ yymsp[-3].minor.yy520 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy520); }
        break;
      case 353: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 354: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 355: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 356: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 357: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 358: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 359: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy904); }
        break;
      case 360: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 361: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy904 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 363: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 366: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy520 = createInsertStmt(pCxt, yymsp[-4].minor.yy520, yymsp[-2].minor.yy904, yymsp[0].minor.yy520); }
        break;
      case 367: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy520 = createInsertStmt(pCxt, yymsp[-1].minor.yy520, NULL, yymsp[0].minor.yy520); }
        break;
      case 368: /* literal ::= NK_INTEGER */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 369: /* literal ::= NK_FLOAT */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 370: /* literal ::= NK_STRING */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 371: /* literal ::= NK_BOOL */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 372: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 373: /* literal ::= duration_literal */
      case 383: /* signed_literal ::= signed */ yytestcase(yyruleno==383);
      case 404: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==404);
      case 405: /* expression ::= literal */ yytestcase(yyruleno==405);
      case 406: /* expression ::= pseudo_column */ yytestcase(yyruleno==406);
      case 407: /* expression ::= column_reference */ yytestcase(yyruleno==407);
      case 408: /* expression ::= function_expression */ yytestcase(yyruleno==408);
      case 409: /* expression ::= case_when_expression */ yytestcase(yyruleno==409);
      case 440: /* function_expression ::= literal_func */ yytestcase(yyruleno==440);
      case 489: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==489);
      case 493: /* boolean_primary ::= predicate */ yytestcase(yyruleno==493);
      case 495: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==495);
      case 496: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==496);
      case 499: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==499);
      case 501: /* table_reference ::= table_primary */ yytestcase(yyruleno==501);
      case 502: /* table_reference ::= joined_table */ yytestcase(yyruleno==502);
      case 506: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==506);
      case 564: /* query_simple ::= query_specification */ yytestcase(yyruleno==564);
      case 565: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==565);
      case 568: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==568);
      case 570: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==570);
{ yylhsminor.yy520 = yymsp[0].minor.yy520; }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 374: /* literal ::= NULL */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 375: /* literal ::= NK_QUESTION */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 376: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 377: /* signed ::= NK_INTEGER */
{ yylhsminor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 378: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 379: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 380: /* signed ::= NK_FLOAT */
{ yylhsminor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 381: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 382: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 384: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 385: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 386: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 387: /* signed_literal ::= duration_literal */
      case 389: /* signed_literal ::= literal_func */ yytestcase(yyruleno==389);
      case 460: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==460);
      case 522: /* select_item ::= common_expression */ yytestcase(yyruleno==522);
      case 532: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==532);
      case 569: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==569);
      case 571: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==571);
      case 584: /* search_condition ::= common_expression */ yytestcase(yyruleno==584);
{ yylhsminor.yy520 = releaseRawExprNode(pCxt, yymsp[0].minor.yy520); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 388: /* signed_literal ::= NULL */
{ yylhsminor.yy520 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 390: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy520 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 410: /* expression ::= NK_LP expression NK_RP */
      case 494: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==494);
      case 583: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==583);
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy520)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 411: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy520));
                                                                                  }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 412: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy520), NULL));
                                                                                  }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 413: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520))); 
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 414: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520))); 
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 415: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520))); 
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 416: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520))); 
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 417: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 418: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 419: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 420: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 423: /* column_reference ::= column_name */
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy833, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy833)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 424: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy833, createColumnNode(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy833)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 425: /* pseudo_column ::= ROWTS */
      case 426: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==426);
      case 428: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==428);
      case 429: /* pseudo_column ::= QEND */ yytestcase(yyruleno==429);
      case 430: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==430);
      case 431: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==431);
      case 432: /* pseudo_column ::= WEND */ yytestcase(yyruleno==432);
      case 433: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==433);
      case 434: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==434);
      case 435: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==435);
      case 436: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==436);
      case 442: /* literal_func ::= NOW */ yytestcase(yyruleno==442);
{ yylhsminor.yy520 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 427: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy833)))); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 437: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 438: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==438);
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy833, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy833, yymsp[-1].minor.yy904)); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 439: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), yymsp[-1].minor.yy840)); }
  yymsp[-5].minor.yy520 = yylhsminor.yy520;
        break;
      case 441: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy833, NULL)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 456: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy904 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy904 = yylhsminor.yy904;
        break;
      case 461: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 525: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==525);
{ yylhsminor.yy520 = createColumnNode(pCxt, &yymsp[-2].minor.yy833, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 462: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy904, yymsp[-1].minor.yy520)); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 463: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), yymsp[-2].minor.yy904, yymsp[-1].minor.yy520)); }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 466: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy520 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)); }
        break;
      case 468: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy520 = releaseRawExprNode(pCxt, yymsp[0].minor.yy520); }
        break;
      case 469: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 474: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==474);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy524, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 470: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy520), releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-4].minor.yy520 = yylhsminor.yy520;
        break;
      case 471: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy520), releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-5].minor.yy520 = yylhsminor.yy520;
        break;
      case 472: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), NULL));
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 473: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), NULL));
                                                                                  }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 475: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy524 = OP_TYPE_LOWER_THAN; }
        break;
      case 476: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy524 = OP_TYPE_GREATER_THAN; }
        break;
      case 477: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy524 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 478: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy524 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 479: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy524 = OP_TYPE_NOT_EQUAL; }
        break;
      case 480: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy524 = OP_TYPE_EQUAL; }
        break;
      case 481: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy524 = OP_TYPE_LIKE; }
        break;
      case 482: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy524 = OP_TYPE_NOT_LIKE; }
        break;
      case 483: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy524 = OP_TYPE_MATCH; }
        break;
      case 484: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy524 = OP_TYPE_NMATCH; }
        break;
      case 485: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy524 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 486: /* in_op ::= IN */
{ yymsp[0].minor.yy524 = OP_TYPE_IN; }
        break;
      case 487: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy524 = OP_TYPE_NOT_IN; }
        break;
      case 488: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy904)); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 490: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy520), NULL));
                                                                                  }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 491: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 492: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy520);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy520);
                                                                                    yylhsminor.yy520 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), releaseRawExprNode(pCxt, yymsp[0].minor.yy520)));
                                                                                  }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 500: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy520 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy520, yymsp[0].minor.yy520, NULL); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 503: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy520 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy833, &yymsp[0].minor.yy833); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 504: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy520 = createRealTableNode(pCxt, &yymsp[-3].minor.yy833, &yymsp[-1].minor.yy833, &yymsp[0].minor.yy833); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 505: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy520 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy520), &yymsp[0].minor.yy833); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 507: /* alias_opt ::= */
{ yymsp[1].minor.yy833 = nil_token;  }
        break;
      case 509: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy833 = yymsp[0].minor.yy833; }
        break;
      case 510: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 511: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==511);
{ yymsp[-2].minor.yy520 = yymsp[-1].minor.yy520; }
        break;
      case 512: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy520 = createJoinTableNode(pCxt, yymsp[-4].minor.yy596, yymsp[-5].minor.yy520, yymsp[-2].minor.yy520, yymsp[0].minor.yy520); }
  yymsp[-5].minor.yy520 = yylhsminor.yy520;
        break;
      case 513: /* join_type ::= */
{ yymsp[1].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 514: /* join_type ::= INNER */
{ yymsp[0].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 515: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy520 = createSelectStmt(pCxt, yymsp[-10].minor.yy537, yymsp[-9].minor.yy904, yymsp[-8].minor.yy520);
                                                                                    yymsp[-11].minor.yy520 = addWhereClause(pCxt, yymsp[-11].minor.yy520, yymsp[-7].minor.yy520);
                                                                                    yymsp[-11].minor.yy520 = addPartitionByClause(pCxt, yymsp[-11].minor.yy520, yymsp[-6].minor.yy904);
                                                                                    yymsp[-11].minor.yy520 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy520, yymsp[-2].minor.yy520);
                                                                                    yymsp[-11].minor.yy520 = addGroupByClause(pCxt, yymsp[-11].minor.yy520, yymsp[-1].minor.yy904);
                                                                                    yymsp[-11].minor.yy520 = addHavingClause(pCxt, yymsp[-11].minor.yy520, yymsp[0].minor.yy520);
                                                                                    yymsp[-11].minor.yy520 = addRangeClause(pCxt, yymsp[-11].minor.yy520, yymsp[-5].minor.yy520);
                                                                                    yymsp[-11].minor.yy520 = addEveryClause(pCxt, yymsp[-11].minor.yy520, yymsp[-4].minor.yy520);
                                                                                    yymsp[-11].minor.yy520 = addFillClause(pCxt, yymsp[-11].minor.yy520, yymsp[-3].minor.yy520);
                                                                                  }
        break;
      case 518: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy537 = false; }
        break;
      case 521: /* select_item ::= NK_STAR */
{ yylhsminor.yy520 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy520 = yylhsminor.yy520;
        break;
      case 523: /* select_item ::= common_expression column_alias */
      case 533: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==533);
{ yylhsminor.yy520 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy520), &yymsp[0].minor.yy833); }
  yymsp[-1].minor.yy520 = yylhsminor.yy520;
        break;
      case 524: /* select_item ::= common_expression AS column_alias */
      case 534: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==534);
{ yylhsminor.yy520 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), &yymsp[0].minor.yy833); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 529: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 554: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==554);
      case 573: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==573);
{ yymsp[-2].minor.yy904 = yymsp[0].minor.yy904; }
        break;
      case 536: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy520 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), releaseRawExprNode(pCxt, yymsp[-1].minor.yy520)); }
        break;
      case 537: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy520 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy520)); }
        break;
      case 538: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy520 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), NULL, yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 539: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy520 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy520), releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), yymsp[-1].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 540: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy520 = createEventWindowNode(pCxt, yymsp[-3].minor.yy520, yymsp[0].minor.yy520); }
        break;
      case 544: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy520 = createFillNode(pCxt, yymsp[-1].minor.yy470, NULL); }
        break;
      case 545: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy520 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy904)); }
        break;
      case 546: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy520 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy904)); }
        break;
      case 547: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy470 = FILL_MODE_NONE; }
        break;
      case 548: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy470 = FILL_MODE_PREV; }
        break;
      case 549: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy470 = FILL_MODE_NULL; }
        break;
      case 550: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy470 = FILL_MODE_NULL_F; }
        break;
      case 551: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy470 = FILL_MODE_LINEAR; }
        break;
      case 552: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy470 = FILL_MODE_NEXT; }
        break;
      case 555: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy904 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy520))); }
  yymsp[0].minor.yy904 = yylhsminor.yy904;
        break;
      case 556: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy904 = addNodeToList(pCxt, yymsp[-2].minor.yy904, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy520))); }
  yymsp[-2].minor.yy904 = yylhsminor.yy904;
        break;
      case 560: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy520 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy520), releaseRawExprNode(pCxt, yymsp[-1].minor.yy520)); }
        break;
      case 563: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy520 = addOrderByClause(pCxt, yymsp[-3].minor.yy520, yymsp[-2].minor.yy904);
                                                                                    yylhsminor.yy520 = addSlimitClause(pCxt, yylhsminor.yy520, yymsp[-1].minor.yy520);
                                                                                    yylhsminor.yy520 = addLimitClause(pCxt, yylhsminor.yy520, yymsp[0].minor.yy520);
                                                                                  }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 566: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy520 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy520, yymsp[0].minor.yy520); }
  yymsp[-3].minor.yy520 = yylhsminor.yy520;
        break;
      case 567: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy520 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy520, yymsp[0].minor.yy520); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 575: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 579: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==579);
{ yymsp[-1].minor.yy520 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 576: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 580: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==580);
{ yymsp[-3].minor.yy520 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 577: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 581: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==581);
{ yymsp[-3].minor.yy520 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 582: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy520 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy520); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 587: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy520 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy520), yymsp[-1].minor.yy906, yymsp[0].minor.yy257); }
  yymsp[-2].minor.yy520 = yylhsminor.yy520;
        break;
      case 588: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy906 = ORDER_ASC; }
        break;
      case 589: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy906 = ORDER_ASC; }
        break;
      case 590: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy906 = ORDER_DESC; }
        break;
      case 591: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy257 = NULL_ORDER_DEFAULT; }
        break;
      case 592: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy257 = NULL_ORDER_FIRST; }
        break;
      case 593: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy257 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
